/*
 * Copyright (c) 2015-2017, Renesas Electronics Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef LIFEC_REGISTERS_H
#define LIFEC_REGISTERS_H

#define	LIFEC_SEC_BASE	(0xE6110000U)

#define	SEC_SRC		(LIFEC_SEC_BASE + 0x0008U)
#define	SEC_SEL0	(LIFEC_SEC_BASE + 0x0030U)
#define	SEC_SEL1	(LIFEC_SEC_BASE + 0x0034U)
#define	SEC_SEL2	(LIFEC_SEC_BASE + 0x0038U)
#define	SEC_SEL3	(LIFEC_SEC_BASE + 0x003CU)
#define	SEC_SEL4	(LIFEC_SEC_BASE + 0x0058U)
#define	SEC_SEL5	(LIFEC_SEC_BASE + 0x005CU)
#define SEC_SEL6	(LIFEC_SEC_BASE + 0x0060U)
#define	SEC_SEL7	(LIFEC_SEC_BASE + 0x0064U)
#define	SEC_SEL8	(LIFEC_SEC_BASE + 0x0068U)
#define	SEC_SEL9	(LIFEC_SEC_BASE + 0x006CU)
#define	SEC_SEL10	(LIFEC_SEC_BASE + 0x0070U)
#define	SEC_SEL11	(LIFEC_SEC_BASE + 0x0074U)
#define	SEC_SEL12	(LIFEC_SEC_BASE + 0x0078U)
#define	SEC_SEL13	(LIFEC_SEC_BASE + 0x007CU)
#define	SEC_SEL14	(LIFEC_SEC_BASE + 0x0080U)
#define	SEC_SEL15	(LIFEC_SEC_BASE + 0x0084U)
#define	SEC_GRP0CR0	(LIFEC_SEC_BASE + 0x0138U)
#define	SEC_GRP1CR0	(LIFEC_SEC_BASE + 0x013CU)
#define	SEC_GRP0CR1	(LIFEC_SEC_BASE + 0x0140U)
#define	SEC_GRP1CR1	(LIFEC_SEC_BASE + 0x0144U)
#define	SEC_GRP0CR2	(LIFEC_SEC_BASE + 0x0148U)
#define	SEC_GRP1CR2	(LIFEC_SEC_BASE + 0x014CU)
#define	SEC_GRP0CR3	(LIFEC_SEC_BASE + 0x0150U)
#define	SEC_GRP1CR3	(LIFEC_SEC_BASE + 0x0154U)
#define	SEC_GRP0COND0	(LIFEC_SEC_BASE + 0x0158U)
#define	SEC_GRP1COND0	(LIFEC_SEC_BASE + 0x015CU)
#define	SEC_GRP0COND1	(LIFEC_SEC_BASE + 0x0160U)
#define	SEC_GRP1COND1	(LIFEC_SEC_BASE + 0x0164U)
#define	SEC_GRP0COND2	(LIFEC_SEC_BASE + 0x0168U)
#define	SEC_GRP1COND2	(LIFEC_SEC_BASE + 0x016CU)
#define	SEC_GRP0COND3	(LIFEC_SEC_BASE + 0x0170U)
#define	SEC_GRP1COND3	(LIFEC_SEC_BASE + 0x0174U)
#define	SEC_GRP0COND4	(LIFEC_SEC_BASE + 0x0178U)
#define	SEC_GRP1COND4	(LIFEC_SEC_BASE + 0x017CU)
#define	SEC_GRP0COND5	(LIFEC_SEC_BASE + 0x0180U)
#define	SEC_GRP1COND5	(LIFEC_SEC_BASE + 0x0184U)
#define	SEC_GRP0COND6	(LIFEC_SEC_BASE + 0x0188U)
#define	SEC_GRP1COND6	(LIFEC_SEC_BASE + 0x018CU)
#define	SEC_GRP0COND7	(LIFEC_SEC_BASE + 0x0190U)
#define	SEC_GRP1COND7	(LIFEC_SEC_BASE + 0x0194U)
#define	SEC_GRP0COND8	(LIFEC_SEC_BASE + 0x0198U)
#define	SEC_GRP1COND8	(LIFEC_SEC_BASE + 0x019CU)
#define	SEC_GRP0COND9	(LIFEC_SEC_BASE + 0x01A0U)
#define	SEC_GRP1COND9	(LIFEC_SEC_BASE + 0x01A4U)
#define	SEC_GRP0COND10	(LIFEC_SEC_BASE + 0x01A8U)
#define	SEC_GRP1COND10	(LIFEC_SEC_BASE + 0x01ACU)
#define	SEC_GRP0COND11	(LIFEC_SEC_BASE + 0x01B0U)
#define	SEC_GRP1COND11	(LIFEC_SEC_BASE + 0x01B4U)
#define	SEC_GRP0COND12	(LIFEC_SEC_BASE + 0x01B8U)
#define	SEC_GRP1COND12	(LIFEC_SEC_BASE + 0x01BCU)
#define	SEC_GRP0COND13	(LIFEC_SEC_BASE + 0x01C0U)
#define	SEC_GRP1COND13	(LIFEC_SEC_BASE + 0x01C4U)
#define	SEC_GRP0COND14	(LIFEC_SEC_BASE + 0x01C8U)
#define	SEC_GRP1COND14	(LIFEC_SEC_BASE + 0x01CCU)
#define	SEC_GRP0COND15	(LIFEC_SEC_BASE + 0x01D0U)
#define	SEC_GRP1COND15	(LIFEC_SEC_BASE + 0x01D4U)
#define	SEC_READONLY0	(LIFEC_SEC_BASE + 0x01D8U)
#define	SEC_READONLY1	(LIFEC_SEC_BASE + 0x01DCU)
#define	SEC_READONLY2	(LIFEC_SEC_BASE + 0x01E0U)
#define	SEC_READONLY3	(LIFEC_SEC_BASE + 0x01E4U)
#define	SEC_READONLY4	(LIFEC_SEC_BASE + 0x01E8U)
#define	SEC_READONLY5	(LIFEC_SEC_BASE + 0x01ECU)
#define	SEC_READONLY6	(LIFEC_SEC_BASE + 0x01F0U)
#define	SEC_READONLY7	(LIFEC_SEC_BASE + 0x01F4U)
#define	SEC_READONLY8	(LIFEC_SEC_BASE + 0x01F8U)
#define	SEC_READONLY9	(LIFEC_SEC_BASE + 0x01FCU)
#define	SEC_READONLY10	(LIFEC_SEC_BASE + 0x0200U)
#define	SEC_READONLY11	(LIFEC_SEC_BASE + 0x0204U)
#define	SEC_READONLY12	(LIFEC_SEC_BASE + 0x0208U)
#define	SEC_READONLY13	(LIFEC_SEC_BASE + 0x020CU)
#define	SEC_READONLY14	(LIFEC_SEC_BASE + 0x0210U)
#define	SEC_READONLY15	(LIFEC_SEC_BASE + 0x0214U)

#define	LIFEC_SAFE_BASE	(0xE6120000U)
#define	SAFE_GRP0CR0	(LIFEC_SAFE_BASE + 0x0138U)
#define	SAFE_GRP1CR0	(LIFEC_SAFE_BASE + 0x013CU)
#define	SAFE_GRP0CR1	(LIFEC_SAFE_BASE + 0x0140U)
#define	SAFE_GRP1CR1	(LIFEC_SAFE_BASE + 0x0144U)
#define	SAFE_GRP0CR2	(LIFEC_SAFE_BASE + 0x0148U)
#define	SAFE_GRP1CR2	(LIFEC_SAFE_BASE + 0x014CU)
#define	SAFE_GRP0CR3	(LIFEC_SAFE_BASE + 0x0150U)
#define	SAFE_GRP1CR3	(LIFEC_SAFE_BASE + 0x0154U)
#define	SAFE_GRP0COND0	(LIFEC_SAFE_BASE + 0x0158U)
#define	SAFE_GRP1COND0	(LIFEC_SAFE_BASE + 0x015CU)
#define	SAFE_GRP0COND1	(LIFEC_SAFE_BASE + 0x0160U)
#define	SAFE_GRP1COND1	(LIFEC_SAFE_BASE + 0x0164U)
#define	SAFE_GRP0COND2	(LIFEC_SAFE_BASE + 0x0168U)
#define	SAFE_GRP1COND2	(LIFEC_SAFE_BASE + 0x016CU)
#define	SAFE_GRP0COND3	(LIFEC_SAFE_BASE + 0x0170U)
#define	SAFE_GRP1COND3	(LIFEC_SAFE_BASE + 0x0174U)
#define	SAFE_GRP0COND4	(LIFEC_SAFE_BASE + 0x0178U)
#define	SAFE_GRP1COND4	(LIFEC_SAFE_BASE + 0x017CU)
#define	SAFE_GRP0COND5	(LIFEC_SAFE_BASE + 0x0180U)
#define	SAFE_GRP1COND5	(LIFEC_SAFE_BASE + 0x0184U)
#define	SAFE_GRP0COND6	(LIFEC_SAFE_BASE + 0x0188U)
#define	SAFE_GRP1COND6	(LIFEC_SAFE_BASE + 0x018CU)
#define	SAFE_GRP0COND7	(LIFEC_SAFE_BASE + 0x0190U)
#define	SAFE_GRP1COND7	(LIFEC_SAFE_BASE + 0x0194U)
#define	SAFE_GRP0COND8	(LIFEC_SAFE_BASE + 0x0198U)
#define	SAFE_GRP1COND8	(LIFEC_SAFE_BASE + 0x019CU)
#define	SAFE_GRP0COND9	(LIFEC_SAFE_BASE + 0x01A0U)
#define	SAFE_GRP1COND9	(LIFEC_SAFE_BASE + 0x01A4U)
#define	SAFE_GRP0COND10	(LIFEC_SAFE_BASE + 0x01A8U)
#define	SAFE_GRP1COND10	(LIFEC_SAFE_BASE + 0x01ACU)
#define	SAFE_GRP0COND11	(LIFEC_SAFE_BASE + 0x01B0U)
#define	SAFE_GRP1COND11	(LIFEC_SAFE_BASE + 0x01B4U)
#define	SAFE_GRP0COND12	(LIFEC_SAFE_BASE + 0x01B8U)
#define	SAFE_GRP1COND12	(LIFEC_SAFE_BASE + 0x01BCU)
#define	SAFE_GRP0COND13	(LIFEC_SAFE_BASE + 0x01C0U)
#define	SAFE_GRP1COND13	(LIFEC_SAFE_BASE + 0x01C4U)
#define	SAFE_GRP0COND14	(LIFEC_SAFE_BASE + 0x01C8U)
#define	SAFE_GRP1COND14	(LIFEC_SAFE_BASE + 0x01CCU)
#define	SAFE_GRP0COND15	(LIFEC_SAFE_BASE + 0x01D0U)
#define	SAFE_GRP1COND15	(LIFEC_SAFE_BASE + 0x01D4U)
#define	SAFE_READONLY0	(LIFEC_SAFE_BASE + 0x01D8U)
#define	SAFE_READONLY1	(LIFEC_SAFE_BASE + 0x01DCU)
#define	SAFE_READONLY2	(LIFEC_SAFE_BASE + 0x01E0U)
#define	SAFE_READONLY3	(LIFEC_SAFE_BASE + 0x01E4U)
#define	SAFE_READONLY4	(LIFEC_SAFE_BASE + 0x01E8U)
#define	SAFE_READONLY5	(LIFEC_SAFE_BASE + 0x01ECU)
#define	SAFE_READONLY6	(LIFEC_SAFE_BASE + 0x01F0U)
#define	SAFE_READONLY7	(LIFEC_SAFE_BASE + 0x01F4U)
#define	SAFE_READONLY8	(LIFEC_SAFE_BASE + 0x01F8U)
#define	SAFE_READONLY9	(LIFEC_SAFE_BASE + 0x01FCU)
#define	SAFE_READONLY10	(LIFEC_SAFE_BASE + 0x0200U)
#define	SAFE_READONLY11	(LIFEC_SAFE_BASE + 0x0204U)
#define	SAFE_READONLY12	(LIFEC_SAFE_BASE + 0x0208U)
#define	SAFE_READONLY13	(LIFEC_SAFE_BASE + 0x020CU)
#define	SAFE_READONLY14	(LIFEC_SAFE_BASE + 0x0210U)
#define	SAFE_READONLY15	(LIFEC_SAFE_BASE + 0x0214U)

#endif /* LIFEC_REGISTERS_H */
