#ifndef AVIFILE_FFAUDIODECODER_H
#define AVIFILE_FFAUDIODECODER_H

#include "audiodecoder.h"
#include "avm_avcodec.h"

AVM_BEGIN_NAMESPACE;

class FFAudioDecoder: public IAudioDecoder
{
    static const uint_t MIN_AC3_CHUNK_SIZE = 16384;
    AVCodec *m_pAvCodec;
    AVCodecContext* m_pAvContext;
public:
    FFAudioDecoder(AVCodec*, const CodecInfo&, const WAVEFORMATEX*);
    ~FFAudioDecoder();
    virtual int Convert(const void*, size_t, void*, size_t, size_t*, size_t*);
    virtual size_t GetMinSize() const;
    virtual size_t GetSrcSize(size_t dest_size) const;
};

AVM_END_NAMESPACE;

#endif //AVIFILE_FFAUDIODECODER_H
