/* SPDX-License-Identifier: BSD-3-Clause */

//-----------------------------------------------------------------------------
// Include files
//-----------------------------------------------------------------------------
#include "dramc_common.h"
#include "dramc_int_global.h"
#include "x_hal_io.h"
//-----------------------------------------------------------------------------
// Global variables
//-----------------------------------------------------------------------------
U8 gDRSEnableSelfWakeup = 0;

//----------------------------------------
// Auto Gen Code -- START
//----------------------------------------
#if (CHECK_GOLDEN_SETTING == TRUE)
typedef struct _GOLDEN_FIELD_T
{
	char fieldName[64]; //field name
	U32 group;
	U32 field;
	U32 u4ChaValue;
} GOLDEN_FIELD_T;
GOLDEN_FIELD_T *golden_setting_anwer;

#if APPLY_LOWPOWER_GOLDEN_SETTINGS
// DCM On
GOLDEN_FIELD_T shuf_golden_setting_anwer[] =
{
	{"SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1, 0x0},
	{"MISC_SHU_RX_CG_CTRL_RX_PRECAL_CG_EN", DDRPHY_REG_MISC_SHU_RX_CG_CTRL, MISC_SHU_RX_CG_CTRL_RX_PRECAL_CG_EN, 0x0},
	{"SHU_CA_CMD8_R_DMDQSIEN_FLAG_SYNC_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMDQSIEN_FLAG_SYNC_CG_IG_CA, 0x0},
	{"MISC_SHU_CG_CTRL0_R_PHY_MCK_CG_CTRL", DDRPHY_REG_MISC_SHU_CG_CTRL0, MISC_SHU_CG_CTRL0_R_PHY_MCK_CG_CTRL, 0x33403000},
	{"SHU_B1_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B1", DDRPHY_REG_SHU_B1_DQ7, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B1, 0x0},
	{"SHU_B0_DQ8_R_RMRX_TOPHY_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_RMRX_TOPHY_CG_IG_B0, 0x1},
	{"SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1, 0x0},
	{"SHU_CA_CMD8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_CA, 0x0},
	{"SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0, 0x0},
	{"SHU_CA_CMD8_R_RMRX_TOPHY_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_RMRX_TOPHY_CG_IG_CA, 0x0},
	{"SHU_CA_CMD7_R_DMTX_ARPI_CG_CS_NEW", DDRPHY_REG_SHU_CA_CMD7, SHU_CA_CMD7_R_DMTX_ARPI_CG_CS_NEW, 0x0},
	{"SHU_B1_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B1", DDRPHY_REG_SHU_B1_DQ7, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B1, 0x0},
	{"SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1, 0x0},
	{"SHU_CA_CMD8_R_RMRODTEN_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_RMRODTEN_CG_IG_CA, 0x0},
	{"SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0, 0x0},
	{"SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1, 0x0},
	{"SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0, 0x0},
	{"SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1, 0x0},
	{"SHU_CA_CMD8_R_DMRANK_PIPE_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMRANK_PIPE_CG_IG_CA, 0x0},
	{"SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0, 0x0},
	{"MISC_SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG", DDRPHY_REG_MISC_SHU_ODTCTRL, MISC_SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG, 0x0},
	{"SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1, 0x0},
	{"SHU_CA_CMD8_R_DMDQSIEN_FLAG_PIPE_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMDQSIEN_FLAG_PIPE_CG_IG_CA, 0x0},
	{"SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1, 0x0},
	{"SHU_B1_DQ8_R_RMRX_TOPHY_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_RMRX_TOPHY_CG_IG_B1, 0x1},
	{"SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1, 0x0},
	{"SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0, 0x0},
	{"SHU_CA_CMD8_R_DMRANK_CHG_PIPE_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMRANK_CHG_PIPE_CG_IG_CA, 0x0},
	{"SHU_CA_CMD8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_CA, 0x0},
	{"SHU_B0_DQ8_R_DMRXDLY_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRXDLY_CG_IG_B0, 0x1},
	{"SHU_CA_CMD7_R_DMTX_ARPI_CG_CMD_NEW", DDRPHY_REG_SHU_CA_CMD7, SHU_CA_CMD7_R_DMTX_ARPI_CG_CMD_NEW, 0x0},
	{"SHU_B0_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B0", DDRPHY_REG_SHU_B0_DQ7, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B0, 0x0},
	{"SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1, 0x0},
	{"SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0, 0x0},
	{"SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0, 0x0},
	{"SHU_CA_CMD13_RG_TX_ARCLKB_READ_BASE_DATA_TIE_EN_CA", DDRPHY_REG_SHU_CA_CMD13, SHU_CA_CMD13_RG_TX_ARCLKB_READ_BASE_DATA_TIE_EN_CA, 0x0},
	{"SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1, 0x0},
	{"SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0, 0x0},
	{"SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0, 0x0},
	{"SHU_B0_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B0", DDRPHY_REG_SHU_B0_DQ7, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B0, 0x0},
	{"SHU_B1_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B1", DDRPHY_REG_SHU_B1_DQ7, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B1, 0x0},
	{"SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT", DRAMC_REG_SHU_APHY_TX_PICG_CTRL, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT, 0x1},
	{"MISC_SHU_RX_CG_CTRL_RX_DQSIEN_RETRY_CG_EN", DDRPHY_REG_MISC_SHU_RX_CG_CTRL, MISC_SHU_RX_CG_CTRL_RX_DQSIEN_RETRY_CG_EN, 0x1},
	{"SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0, 0x0},
	{"SHU_B0_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B0", DDRPHY_REG_SHU_B0_DQ7, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B0, 0x0},
	{"SHU_B1_DQ8_R_DMRXDLY_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRXDLY_CG_IG_B1, 0x1},
	{"MISC_SHU_RX_CG_CTRL_RX_RDSEL_TRACKING_CG_EN", DDRPHY_REG_MISC_SHU_RX_CG_CTRL, MISC_SHU_RX_CG_CTRL_RX_RDSEL_TRACKING_CG_EN, 0x1},
};

GOLDEN_FIELD_T nonshuf_golden_setting_anwer[] =
{
	{"SCSMCTRL_CG_SCARB_SM_CGAR", DRAMC_REG_SCSMCTRL_CG, SCSMCTRL_CG_SCARB_SM_CGAR, 0x0},
	{"MISC_CG_CTRL5_R_DQ0_DLY_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_DQ0_DLY_DCM_EN, 0x1},
	{"MISC_CG_CTRL0_RG_CG_PHY_OFF_DIABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_PHY_OFF_DIABLE, 0x0},
	{"MISC_CTRL3_ARPI_MPDIV_CG_CA_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_MPDIV_CG_CA_OPT, 0x0},
	{"DUMMY_RD_DUMMY_RD_PA_OPT", DRAMC_REG_DUMMY_RD, DUMMY_RD_DUMMY_RD_PA_OPT, 0x1},
	{"DVFS_CTRL0_DVFS_CG_OPT", DRAMC_REG_DVFS_CTRL0, DVFS_CTRL0_DVFS_CG_OPT, 0x0},
	{"MISC_CTRL3_ARPI_MPDIV_CG_DQ_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_MPDIV_CG_DQ_OPT, 0x0},
	{"MISC_CTRL3_ARPI_CG_MCTL_CA_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_MCTL_CA_OPT, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_DQSIEN", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_DQSIEN, 0x1},
	{"MISC_CG_CTRL2_RG_MEM_DCM_FSEL", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_FSEL, 0x0},
	{"MISC_CG_CTRL0_RG_CG_COMB0_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_COMB0_OFF_DISABLE, 0x0},
	{"RX_CG_SET0_RDATCKAR", DRAMC_REG_RX_CG_SET0, RX_CG_SET0_RDATCKAR, 0x0},
	{"MISC_CTRL3_ARPI_CG_MCTL_DQ_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_MCTL_DQ_OPT, 0x0},
	{"MISC_CG_CTRL0_RG_CG_RX_COMB1_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_RX_COMB1_OFF_DISABLE, 0x0},
	{"MISC_CG_CTRL0_RG_CG_DRAMC_CK_OFF", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_DRAMC_CK_OFF, 0x0},
	{"MISC_CG_CTRL0_RG_CG_CMD_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_CMD_OFF_DISABLE, 0x0},
	{"MISC_CTRL3_R_DDRPHY_RX_PIPE_CG_IG", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_R_DDRPHY_RX_PIPE_CG_IG, 0x0},
	{"RX_CG_SET0_RDYCKAR", DRAMC_REG_RX_CG_SET0, RX_CG_SET0_RDYCKAR, 0x0},
	{"DDRCOMMON0_DISSTOP26M", DRAMC_REG_DDRCOMMON0, DDRCOMMON0_DISSTOP26M, 0x0},
	{"MISCTL0_REFP_ARBMASK_PBR2PBR_PA_DIS", DRAMC_REG_MISCTL0, MISCTL0_REFP_ARBMASK_PBR2PBR_PA_DIS, 0x0},
	{"DCM_CTRL0_BCLKAR", DRAMC_REG_DCM_CTRL0, DCM_CTRL0_BCLKAR, 0x0},
	{"DRAMC_PD_CTRL_DCMEN", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_DCMEN, 0x1},
	{"MISC_CG_CTRL5_R_CA_DLY_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_CA_DLY_DCM_EN, 0x1},
	{"CLKAR_REQQUECLKRUN", DRAMC_REG_CLKAR, CLKAR_REQQUECLKRUN, 0x0},
	{"CA_DLL_ARPI1_RG_ARPISM_MCK_SEL_CA_REG_OPT", DDRPHY_REG_CA_DLL_ARPI1, CA_DLL_ARPI1_RG_ARPISM_MCK_SEL_CA_REG_OPT, 0x0},
	{"DRAMC_PD_CTRL_DCMENNOTRFC", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_DCMENNOTRFC, 0x1},
	{"MISC_DUTYSCAN1_RX_EYE_SCAN_CG_EN", DDRPHY_REG_MISC_DUTYSCAN1, MISC_DUTYSCAN1_RX_EYE_SCAN_CG_EN, 0x0},
	{"TX_TRACKING_SET0_HMRRSEL_CGAR", DRAMC_REG_TX_TRACKING_SET0, TX_TRACKING_SET0_HMRRSEL_CGAR, 0x0},
	{"ACTIMING_CTRL_SEQCLKRUN", DRAMC_REG_ACTIMING_CTRL, ACTIMING_CTRL_SEQCLKRUN, 0x0},
	{"MISC_CTRL3_ARPI_CG_CLK_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_CLK_OPT, 0x0},
	{"CMD_DEC_CTRL0_SELPH_CMD_CG_DIS", DRAMC_REG_CMD_DEC_CTRL0, CMD_DEC_CTRL0_SELPH_CMD_CG_DIS, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_DQS", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_DQS, 0x1},
	{"TX_TRACKING_SET0_RDDQSOSC_CGAR", DRAMC_REG_TX_TRACKING_SET0, TX_TRACKING_SET0_RDDQSOSC_CGAR, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_CMD", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_CMD, 0x1},
	{"DRAMC_PD_CTRL_PHYCLKDYNGEN", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_PHYCLKDYNGEN, 0x1},
	{"MISC_CG_CTRL2_RG_MEM_DCM_DCM_EN", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_DCM_EN, 0x1},
	{"MISC_CTRL3_ARPI_CG_MCK_CA_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_MCK_CA_OPT, 0x0},
	{"MISC_CG_CTRL2_RG_MEM_DCM_CG_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_CG_OFF_DISABLE, 0x1},
	{"MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG, 0x0},
	{"MISC_CG_CTRL2_RG_MEM_DCM_FORCE_OFF", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_FORCE_OFF, 0x0},
	{"DRAMC_PD_CTRL_COMBPHY_CLKENSAME", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_COMBPHY_CLKENSAME, 0x0},
	{"MISC_CG_CTRL2_RG_PIPE0_CG_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_PIPE0_CG_OFF_DISABLE, 0x0},
	{"MISC_CTRL3_ARPI_CG_CMD_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_CMD_OPT, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_DQ", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_DQ, 0x1},
	{"MISC_CTRL3_ARPI_CG_DQ_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_DQ_OPT, 0x0},
	{"MISC_CG_CTRL0_RG_CG_RX_COMB0_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_RX_COMB0_OFF_DISABLE, 0x0},
	{"DRAMC_PD_CTRL_COMBCLKCTRL", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_COMBCLKCTRL, 0x1},
	{"MISC_CG_CTRL5_R_DQ1_DLY_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_DQ1_DLY_DCM_EN, 0x1},
	{"MISC_CG_CTRL5_R_CA_PI_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_CA_PI_DCM_EN, 0x1},
	{"MISC_CG_CTRL0_RG_CG_COMB_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_COMB_OFF_DISABLE, 0x0},
	{"MISC_CTRL3_ARPI_CG_DQS_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_DQS_OPT, 0x0},
	{"TX_CG_SET0_TX_ATK_CLKRUN", DRAMC_REG_TX_CG_SET0, TX_CG_SET0_TX_ATK_CLKRUN, 0x0},
	{"ZQ_SET0_ZQCS_MASK_SEL_CGAR", DRAMC_REG_ZQ_SET0, ZQ_SET0_ZQCS_MASK_SEL_CGAR, 0x0},
	{"DRAMC_PD_CTRL_APHYCKCG_FIXOFF", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_APHYCKCG_FIXOFF, 0x0},
	{"MISC_CG_CTRL2_RESERVED_MISC_CG_CTRL2_BIT30", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RESERVED_MISC_CG_CTRL2_BIT30, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_CS", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_CS, 0x1},
	{"MISC_CG_CTRL0_RG_CG_IDLE_SYNC_EN", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_IDLE_SYNC_EN, 0x0},
	{"MISC_CTRL3_R_DDRPHY_COMB_CG_IG", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_R_DDRPHY_COMB_CG_IG, 0x0},
	{"MISC_CG_CTRL0_RG_CG_NAO_FORCE_OFF", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_NAO_FORCE_OFF, 0x0},
	{"DRAMC_PD_CTRL_DCMEN2", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_DCMEN2, 0x1},
	{"MISC_CG_CTRL2_RG_MEM_DCM_DBC_EN", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_DBC_EN, 0x1},
	{"MISC_CG_CTRL2_RESERVED_MISC_CG_CTRL2_BIT27", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RESERVED_MISC_CG_CTRL2_BIT27, 0x0},
	{"MISC_CG_CTRL0_RG_CG_DRAMC_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_DRAMC_OFF_DISABLE, 0x0},
	{"MISC_CG_CTRL2_RG_MEM_DCM_DBC_CNT", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_DBC_CNT, 0x5},
	{"SCSMCTRL_CG_SCSM_CGAR", DRAMC_REG_SCSMCTRL_CG, SCSMCTRL_CG_SCSM_CGAR, 0x0},
	{"DRAMC_PD_CTRL_MIOCKCTRLOFF", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_MIOCKCTRLOFF, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_CLK", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_CLK, 0x1},
	{"MISC_CG_CTRL0_RG_CG_RX_CMD_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_RX_CMD_OFF_DISABLE, 0x0},
	{"MISC_CG_CTRL2_RG_MEM_DCM_FORCE_ON", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_FORCE_ON, 0x0},
	{"TX_CG_SET0_SELPH_4LCG_DIS", DRAMC_REG_TX_CG_SET0, TX_CG_SET0_SELPH_4LCG_DIS, 0x0},
	{"ACTIMING_CTRL_SEQCLKRUN3", DRAMC_REG_ACTIMING_CTRL, ACTIMING_CTRL_SEQCLKRUN3, 0x1},
	{"ACTIMING_CTRL_SEQCLKRUN2", DRAMC_REG_ACTIMING_CTRL, ACTIMING_CTRL_SEQCLKRUN2, 0x0},
	{"MISC_CG_CTRL5_R_DQ0_PI_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_DQ0_PI_DCM_EN, 0x1},
	{"MISC_RX_AUTOK_CFG0_RX_CAL_CG_EN", DDRPHY_REG_MISC_RX_AUTOK_CFG0, MISC_RX_AUTOK_CFG0_RX_CAL_CG_EN, 0x0},
	{"MISC_CTRL3_ARPI_CG_MCK_DQ_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_MCK_DQ_OPT, 0x0},
	{"MISC_CG_CTRL2_RG_PHY_CG_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_PHY_CG_OFF_DISABLE, 0x0},
	{"MISC_CG_CTRL0_RG_CG_COMB1_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_COMB1_OFF_DISABLE, 0x0},
	{"TX_CG_SET0_DWCLKRUN", DRAMC_REG_TX_CG_SET0, TX_CG_SET0_DWCLKRUN, 0x0},
	{"MISC_CG_CTRL0_RG_CG_EMI_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_EMI_OFF_DISABLE, 0x1},
	{"SREF_DPD_CTRL_SREF_CG_OPT", DRAMC_REG_SREF_DPD_CTRL, SREF_DPD_CTRL_SREF_CG_OPT, 0x0},
	{"TX_TRACKING_SET0_TXUIPI_CAL_CGAR", DRAMC_REG_TX_TRACKING_SET0, TX_TRACKING_SET0_TXUIPI_CAL_CGAR, 0x0},
	{"MISC_CTRL4_R_OPT2_MPDIV_CG", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_MPDIV_CG, 0x1},
	{"TX_CG_SET0_WDATA_CG_DIS", DRAMC_REG_TX_CG_SET0, TX_CG_SET0_WDATA_CG_DIS, 0x0},
	{"MISC_CG_CTRL0_RG_CG_INFRA_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_INFRA_OFF_DISABLE, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_MCK", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_MCK, 0x1},
	{"MISC_CG_CTRL2_RG_MEM_DCM_IDLE_FSEL", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_IDLE_FSEL, 0x3},
	{"MISC_CG_CTRL2_RG_MEM_DCM_APB_SEL", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_APB_SEL, 0x17},
	{"TX_CG_SET0_SELPH_CG_DIS", DRAMC_REG_TX_CG_SET0, TX_CG_SET0_SELPH_CG_DIS, 0x0},
	{"DRAMC_PD_CTRL_PHYGLUECLKRUN", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_PHYGLUECLKRUN, 0x0},
	{"MISC_CG_CTRL5_R_DQ1_PI_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_DQ1_PI_DCM_EN, 0x1},
	{"CLKAR_REQQUE_PACG_DIS", DRAMC_REG_CLKAR, CLKAR_REQQUE_PACG_DIS, 0x0},
	{"ZQ_SET0_ZQMASK_CGAR", DRAMC_REG_ZQ_SET0, ZQ_SET0_ZQMASK_CGAR, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_DQM", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_DQM, 0x1},
};

#else
// DCM Off
GOLDEN_FIELD_T shuf_golden_setting_anwer[] =
{
	{"SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1, 0x1},
	{"MISC_SHU_RX_CG_CTRL_RX_PRECAL_CG_EN", DDRPHY_REG_MISC_SHU_RX_CG_CTRL, MISC_SHU_RX_CG_CTRL_RX_PRECAL_CG_EN, 0x0},
	{"SHU_CA_CMD8_R_DMDQSIEN_FLAG_SYNC_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMDQSIEN_FLAG_SYNC_CG_IG_CA, 0x1},
	{"MISC_SHU_CG_CTRL0_R_PHY_MCK_CG_CTRL", DDRPHY_REG_MISC_SHU_CG_CTRL0, MISC_SHU_CG_CTRL0_R_PHY_MCK_CG_CTRL, 0x33403000},
	{"SHU_B1_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B1", DDRPHY_REG_SHU_B1_DQ7, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B1, 0x0},
	{"SHU_B0_DQ8_R_RMRX_TOPHY_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_RMRX_TOPHY_CG_IG_B0, 0x1},
	{"SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1, 0x1},
	{"SHU_CA_CMD8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_CA, 0x1},
	{"SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0, 0x1},
	{"SHU_CA_CMD8_R_RMRX_TOPHY_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_RMRX_TOPHY_CG_IG_CA, 0x1},
	{"SHU_CA_CMD7_R_DMTX_ARPI_CG_CS_NEW", DDRPHY_REG_SHU_CA_CMD7, SHU_CA_CMD7_R_DMTX_ARPI_CG_CS_NEW, 0x0},
	{"SHU_B1_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B1", DDRPHY_REG_SHU_B1_DQ7, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B1, 0x0},
	{"SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1, 0x1},
	{"SHU_CA_CMD8_R_RMRODTEN_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_RMRODTEN_CG_IG_CA, 0x1},
	{"SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0, 0x1},
	{"SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1, 0x1},
	{"SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0, 0x1},
	{"SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1, 0x1},
	{"SHU_CA_CMD8_R_DMRANK_PIPE_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMRANK_PIPE_CG_IG_CA, 0x1},
	{"SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0, 0x1},
	{"MISC_SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG", DDRPHY_REG_MISC_SHU_ODTCTRL, MISC_SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG, 0x1},
	{"SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1, 0x1},
	{"SHU_CA_CMD8_R_DMDQSIEN_FLAG_PIPE_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMDQSIEN_FLAG_PIPE_CG_IG_CA, 0x1},
	{"SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1, 0x1},
	{"SHU_B1_DQ8_R_RMRX_TOPHY_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_RMRX_TOPHY_CG_IG_B1, 0x1},
	{"SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1, 0x1},
	{"SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0, 0x1},
	{"SHU_CA_CMD8_R_DMRANK_CHG_PIPE_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMRANK_CHG_PIPE_CG_IG_CA, 0x1},
	{"SHU_CA_CMD8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_CA", DDRPHY_REG_SHU_CA_CMD8, SHU_CA_CMD8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_CA, 0x1},
	{"SHU_B0_DQ8_R_DMRXDLY_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRXDLY_CG_IG_B0, 0x1},
	{"SHU_CA_CMD7_R_DMTX_ARPI_CG_CMD_NEW", DDRPHY_REG_SHU_CA_CMD7, SHU_CA_CMD7_R_DMTX_ARPI_CG_CMD_NEW, 0x0},
	{"SHU_B0_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B0", DDRPHY_REG_SHU_B0_DQ7, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B0, 0x0},
	{"SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1, 0x1},
	{"SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0, 0x1},
	{"SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0, 0x1},
	{"SHU_CA_CMD13_RG_TX_ARCLKB_READ_BASE_DATA_TIE_EN_CA", DDRPHY_REG_SHU_CA_CMD13, SHU_CA_CMD13_RG_TX_ARCLKB_READ_BASE_DATA_TIE_EN_CA, 0x0},
	{"SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1, 0x1},
	{"SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0, 0x1},
	{"SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0, 0x1},
	{"SHU_B0_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B0", DDRPHY_REG_SHU_B0_DQ7, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B0, 0x0},
	{"SHU_B1_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B1", DDRPHY_REG_SHU_B1_DQ7, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B1, 0x0},
	{"SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT", DRAMC_REG_SHU_APHY_TX_PICG_CTRL, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT, 0x0},
	{"MISC_SHU_RX_CG_CTRL_RX_DQSIEN_RETRY_CG_EN", DDRPHY_REG_MISC_SHU_RX_CG_CTRL, MISC_SHU_RX_CG_CTRL_RX_DQSIEN_RETRY_CG_EN, 0x1},
	{"SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0", DDRPHY_REG_SHU_B0_DQ8, SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0, 0x1},
	{"SHU_B0_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B0", DDRPHY_REG_SHU_B0_DQ7, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B0, 0x0},
	{"SHU_B1_DQ8_R_DMRXDLY_CG_IG_B1", DDRPHY_REG_SHU_B1_DQ8, SHU_B1_DQ8_R_DMRXDLY_CG_IG_B1, 0x1},
	{"MISC_SHU_RX_CG_CTRL_RX_RDSEL_TRACKING_CG_EN", DDRPHY_REG_MISC_SHU_RX_CG_CTRL, MISC_SHU_RX_CG_CTRL_RX_RDSEL_TRACKING_CG_EN, 0x1},
};

GOLDEN_FIELD_T nonshuf_golden_setting_anwer[] =
{
	{"SCSMCTRL_CG_SCARB_SM_CGAR", DRAMC_REG_SCSMCTRL_CG, SCSMCTRL_CG_SCARB_SM_CGAR, 0x1},
	{"MISC_CG_CTRL5_R_DQ0_DLY_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_DQ0_DLY_DCM_EN, 0x0},
	{"MISC_CG_CTRL0_RG_CG_PHY_OFF_DIABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_PHY_OFF_DIABLE, 0x1},
	{"MISC_CTRL3_ARPI_MPDIV_CG_CA_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_MPDIV_CG_CA_OPT, 0x0},
	{"DUMMY_RD_DUMMY_RD_PA_OPT", DRAMC_REG_DUMMY_RD, DUMMY_RD_DUMMY_RD_PA_OPT, 0x1},
	{"DVFS_CTRL0_DVFS_CG_OPT", DRAMC_REG_DVFS_CTRL0, DVFS_CTRL0_DVFS_CG_OPT, 0x1},
	{"MISC_CTRL3_ARPI_MPDIV_CG_DQ_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_MPDIV_CG_DQ_OPT, 0x0},
	{"MISC_CTRL3_ARPI_CG_MCTL_CA_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_MCTL_CA_OPT, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_DQSIEN", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_DQSIEN, 0x0},
	{"MISC_CG_CTRL2_RG_MEM_DCM_FSEL", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_FSEL, 0x0},
	{"MISC_CG_CTRL0_RG_CG_COMB0_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_COMB0_OFF_DISABLE, 0x1},
	{"RX_CG_SET0_RDATCKAR", DRAMC_REG_RX_CG_SET0, RX_CG_SET0_RDATCKAR, 0x1},
	{"MISC_CTRL3_ARPI_CG_MCTL_DQ_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_MCTL_DQ_OPT, 0x0},
	{"MISC_CG_CTRL0_RG_CG_RX_COMB1_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_RX_COMB1_OFF_DISABLE, 0x1},
	{"MISC_CG_CTRL0_RG_CG_DRAMC_CK_OFF", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_DRAMC_CK_OFF, 0x0},
	{"MISC_CG_CTRL0_RG_CG_CMD_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_CMD_OFF_DISABLE, 0x1},
	{"MISC_CTRL3_R_DDRPHY_RX_PIPE_CG_IG", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_R_DDRPHY_RX_PIPE_CG_IG, 0x1},
	{"RX_CG_SET0_RDYCKAR", DRAMC_REG_RX_CG_SET0, RX_CG_SET0_RDYCKAR, 0x1},
	{"DDRCOMMON0_DISSTOP26M", DRAMC_REG_DDRCOMMON0, DDRCOMMON0_DISSTOP26M, 0x1},
	{"MISCTL0_REFP_ARBMASK_PBR2PBR_PA_DIS", DRAMC_REG_MISCTL0, MISCTL0_REFP_ARBMASK_PBR2PBR_PA_DIS, 0x1},
	{"DCM_CTRL0_BCLKAR", DRAMC_REG_DCM_CTRL0, DCM_CTRL0_BCLKAR, 0x1},
	{"DRAMC_PD_CTRL_DCMEN", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_DCMEN, 0x0},
	{"MISC_CG_CTRL5_R_CA_DLY_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_CA_DLY_DCM_EN, 0x0},
	{"CLKAR_REQQUECLKRUN", DRAMC_REG_CLKAR, CLKAR_REQQUECLKRUN, 0x1},
	{"CA_DLL_ARPI1_RG_ARPISM_MCK_SEL_CA_REG_OPT", DDRPHY_REG_CA_DLL_ARPI1, CA_DLL_ARPI1_RG_ARPISM_MCK_SEL_CA_REG_OPT, 0x0},
	{"DRAMC_PD_CTRL_DCMENNOTRFC", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_DCMENNOTRFC, 0x0},
	{"MISC_DUTYSCAN1_RX_EYE_SCAN_CG_EN", DDRPHY_REG_MISC_DUTYSCAN1, MISC_DUTYSCAN1_RX_EYE_SCAN_CG_EN, 0x1},
	{"TX_TRACKING_SET0_HMRRSEL_CGAR", DRAMC_REG_TX_TRACKING_SET0, TX_TRACKING_SET0_HMRRSEL_CGAR, 0x1},
	{"ACTIMING_CTRL_SEQCLKRUN", DRAMC_REG_ACTIMING_CTRL, ACTIMING_CTRL_SEQCLKRUN, 0x1},
	{"MISC_CTRL3_ARPI_CG_CLK_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_CLK_OPT, 0x0},
	{"CMD_DEC_CTRL0_SELPH_CMD_CG_DIS", DRAMC_REG_CMD_DEC_CTRL0, CMD_DEC_CTRL0_SELPH_CMD_CG_DIS, 0x1},
	{"MISC_CTRL4_R_OPT2_CG_DQS", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_DQS, 0x0},
	{"TX_TRACKING_SET0_RDDQSOSC_CGAR", DRAMC_REG_TX_TRACKING_SET0, TX_TRACKING_SET0_RDDQSOSC_CGAR, 0x1},
	{"MISC_CTRL4_R_OPT2_CG_CMD", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_CMD, 0x0},
	{"DRAMC_PD_CTRL_PHYCLKDYNGEN", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_PHYCLKDYNGEN, 0x0},
	{"MISC_CG_CTRL2_RG_MEM_DCM_DCM_EN", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_DCM_EN, 0x0},
	{"MISC_CTRL3_ARPI_CG_MCK_CA_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_MCK_CA_OPT, 0x0},
	{"MISC_CG_CTRL2_RG_MEM_DCM_CG_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_CG_OFF_DISABLE, 0x1},
	{"MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG, 0x0},
	{"MISC_CG_CTRL2_RG_MEM_DCM_FORCE_OFF", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_FORCE_OFF, 0x0},
	{"DRAMC_PD_CTRL_COMBPHY_CLKENSAME", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_COMBPHY_CLKENSAME, 0x1},
	{"MISC_CG_CTRL2_RG_PIPE0_CG_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_PIPE0_CG_OFF_DISABLE, 0x0},
	{"MISC_CTRL3_ARPI_CG_CMD_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_CMD_OPT, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_DQ", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_DQ, 0x0},
	{"MISC_CTRL3_ARPI_CG_DQ_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_DQ_OPT, 0x0},
	{"MISC_CG_CTRL0_RG_CG_RX_COMB0_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_RX_COMB0_OFF_DISABLE, 0x1},
	{"DRAMC_PD_CTRL_COMBCLKCTRL", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_COMBCLKCTRL, 0x0},
	{"MISC_CG_CTRL5_R_DQ1_DLY_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_DQ1_DLY_DCM_EN, 0x0},
	{"MISC_CG_CTRL5_R_CA_PI_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_CA_PI_DCM_EN, 0x0},
	{"MISC_CG_CTRL0_RG_CG_COMB_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_COMB_OFF_DISABLE, 0x1},
	{"MISC_CTRL3_ARPI_CG_DQS_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_DQS_OPT, 0x0},
	{"TX_CG_SET0_TX_ATK_CLKRUN", DRAMC_REG_TX_CG_SET0, TX_CG_SET0_TX_ATK_CLKRUN, 0x1},
	{"ZQ_SET0_ZQCS_MASK_SEL_CGAR", DRAMC_REG_ZQ_SET0, ZQ_SET0_ZQCS_MASK_SEL_CGAR, 0x1},
	{"DRAMC_PD_CTRL_APHYCKCG_FIXOFF", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_APHYCKCG_FIXOFF, 0x1},
	{"MISC_CG_CTRL2_RESERVED_MISC_CG_CTRL2_BIT30", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RESERVED_MISC_CG_CTRL2_BIT30, 0x0},
	{"MISC_CTRL4_R_OPT2_CG_CS", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_CS, 0x0},
	{"MISC_CG_CTRL0_RG_CG_IDLE_SYNC_EN", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_IDLE_SYNC_EN, 0x0},
	{"MISC_CTRL3_R_DDRPHY_COMB_CG_IG", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_R_DDRPHY_COMB_CG_IG, 0x1},
	{"MISC_CG_CTRL0_RG_CG_NAO_FORCE_OFF", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_NAO_FORCE_OFF, 0x0},
	{"DRAMC_PD_CTRL_DCMEN2", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_DCMEN2, 0x0},
	{"MISC_CG_CTRL2_RG_MEM_DCM_DBC_EN", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_DBC_EN, 0x1},
	{"MISC_CG_CTRL2_RESERVED_MISC_CG_CTRL2_BIT27", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RESERVED_MISC_CG_CTRL2_BIT27, 0x0},
	{"MISC_CG_CTRL0_RG_CG_DRAMC_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_DRAMC_OFF_DISABLE, 0x1},
	{"MISC_CG_CTRL2_RG_MEM_DCM_DBC_CNT", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_DBC_CNT, 0x5},
	{"SCSMCTRL_CG_SCSM_CGAR", DRAMC_REG_SCSMCTRL_CG, SCSMCTRL_CG_SCSM_CGAR, 0x1},
	{"DRAMC_PD_CTRL_MIOCKCTRLOFF", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_MIOCKCTRLOFF, 0x1},
	{"MISC_CTRL4_R_OPT2_CG_CLK", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_CLK, 0x0},
	{"MISC_CG_CTRL0_RG_CG_RX_CMD_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_RX_CMD_OFF_DISABLE, 0x1},
	{"MISC_CG_CTRL2_RG_MEM_DCM_FORCE_ON", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_FORCE_ON, 0x1},
	{"TX_CG_SET0_SELPH_4LCG_DIS", DRAMC_REG_TX_CG_SET0, TX_CG_SET0_SELPH_4LCG_DIS, 0x1},
	{"ACTIMING_CTRL_SEQCLKRUN3", DRAMC_REG_ACTIMING_CTRL, ACTIMING_CTRL_SEQCLKRUN3, 0x1},
	{"ACTIMING_CTRL_SEQCLKRUN2", DRAMC_REG_ACTIMING_CTRL, ACTIMING_CTRL_SEQCLKRUN2, 0x1},
	{"MISC_CG_CTRL5_R_DQ0_PI_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_DQ0_PI_DCM_EN, 0x0},
	{"MISC_RX_AUTOK_CFG0_RX_CAL_CG_EN", DDRPHY_REG_MISC_RX_AUTOK_CFG0, MISC_RX_AUTOK_CFG0_RX_CAL_CG_EN, 0x1},
	{"MISC_CTRL3_ARPI_CG_MCK_DQ_OPT", DDRPHY_REG_MISC_CTRL3, MISC_CTRL3_ARPI_CG_MCK_DQ_OPT, 0x0},
	{"MISC_CG_CTRL2_RG_PHY_CG_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_PHY_CG_OFF_DISABLE, 0x0},
	{"MISC_CG_CTRL0_RG_CG_COMB1_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_COMB1_OFF_DISABLE, 0x1},
	{"TX_CG_SET0_DWCLKRUN", DRAMC_REG_TX_CG_SET0, TX_CG_SET0_DWCLKRUN, 0x1},
	{"MISC_CG_CTRL0_RG_CG_EMI_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_EMI_OFF_DISABLE, 0x1},
	{"SREF_DPD_CTRL_SREF_CG_OPT", DRAMC_REG_SREF_DPD_CTRL, SREF_DPD_CTRL_SREF_CG_OPT, 0x1},
	{"TX_TRACKING_SET0_TXUIPI_CAL_CGAR", DRAMC_REG_TX_TRACKING_SET0, TX_TRACKING_SET0_TXUIPI_CAL_CGAR, 0x1},
	{"MISC_CTRL4_R_OPT2_MPDIV_CG", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_MPDIV_CG, 0x0},
	{"TX_CG_SET0_WDATA_CG_DIS", DRAMC_REG_TX_CG_SET0, TX_CG_SET0_WDATA_CG_DIS, 0x1},
	{"MISC_CG_CTRL0_RG_CG_INFRA_OFF_DISABLE", DDRPHY_REG_MISC_CG_CTRL0, MISC_CG_CTRL0_RG_CG_INFRA_OFF_DISABLE, 0x1},
	{"MISC_CTRL4_R_OPT2_CG_MCK", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_MCK, 0x0},
	{"MISC_CG_CTRL2_RG_MEM_DCM_IDLE_FSEL", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_IDLE_FSEL, 0x3},
	{"MISC_CG_CTRL2_RG_MEM_DCM_APB_SEL", DDRPHY_REG_MISC_CG_CTRL2, MISC_CG_CTRL2_RG_MEM_DCM_APB_SEL, 0x17},
	{"TX_CG_SET0_SELPH_CG_DIS", DRAMC_REG_TX_CG_SET0, TX_CG_SET0_SELPH_CG_DIS, 0x1},
	{"DRAMC_PD_CTRL_PHYGLUECLKRUN", DRAMC_REG_DRAMC_PD_CTRL, DRAMC_PD_CTRL_PHYGLUECLKRUN, 0x1},
	{"MISC_CG_CTRL5_R_DQ1_PI_DCM_EN", DDRPHY_REG_MISC_CG_CTRL5, MISC_CG_CTRL5_R_DQ1_PI_DCM_EN, 0x0},
	{"CLKAR_REQQUE_PACG_DIS", DRAMC_REG_CLKAR, CLKAR_REQQUE_PACG_DIS, 0x7fff},
	{"ZQ_SET0_ZQMASK_CGAR", DRAMC_REG_ZQ_SET0, ZQ_SET0_ZQMASK_CGAR, 0x1},
	{"MISC_CTRL4_R_OPT2_CG_DQM", DDRPHY_REG_MISC_CTRL4, MISC_CTRL4_R_OPT2_CG_DQM, 0x0},
};

#endif
#endif

static void EnableCommonDCMNonShuffle(DRAMC_CTX_T *p)
{
	vIO32WriteFldAlign_All(DRAMC_REG_ACTIMING_CTRL, 0x1, ACTIMING_CTRL_SEQCLKRUN3);
	vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL0,
			P_Fld(0x1, MISC_CG_CTRL0_RG_CG_EMI_OFF_DISABLE) |
			P_Fld(0x0, MISC_CG_CTRL0_RG_CG_IDLE_SYNC_EN) |
			P_Fld(0x0, MISC_CG_CTRL0_RG_CG_NAO_FORCE_OFF) |
			P_Fld(0x0, MISC_CG_CTRL0_RG_CG_DRAMC_CK_OFF));
	vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL2,
			P_Fld(0x1, MISC_CG_CTRL2_RG_MEM_DCM_CG_OFF_DISABLE) |
			P_Fld(0x17, MISC_CG_CTRL2_RG_MEM_DCM_APB_SEL) |
			P_Fld(0x0, MISC_CG_CTRL2_RG_MEM_DCM_FSEL) |
			P_Fld(0x0, MISC_CG_CTRL2_RESERVED_MISC_CG_CTRL2_BIT27) |
			P_Fld(0x3, MISC_CG_CTRL2_RG_MEM_DCM_IDLE_FSEL) |
			P_Fld(0x0, MISC_CG_CTRL2_RESERVED_MISC_CG_CTRL2_BIT30) |
			P_Fld(0x0, MISC_CG_CTRL2_RG_MEM_DCM_FORCE_OFF) |
			P_Fld(0x1, MISC_CG_CTRL2_RG_MEM_DCM_DBC_EN) |
			P_Fld(0x0, MISC_CG_CTRL2_RG_PHY_CG_OFF_DISABLE) |
			P_Fld(0x0, MISC_CG_CTRL2_RG_PIPE0_CG_OFF_DISABLE) |
			P_Fld(0x0, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG) |
			P_Fld(0x5, MISC_CG_CTRL2_RG_MEM_DCM_DBC_CNT));
	// RG group needs to be toggled!!
	vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL2, 1, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG);
	vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL2, 0, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG);
	vIO32WriteFldAlign_All(DDRPHY_REG_CA_DLL_ARPI1, 0x0, CA_DLL_ARPI1_RG_ARPISM_MCK_SEL_CA_REG_OPT);
	vIO32WriteFldAlign_All(DRAMC_REG_DUMMY_RD, 0x1, DUMMY_RD_DUMMY_RD_PA_OPT);
	vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL3,
			P_Fld(0x0, MISC_CTRL3_ARPI_CG_DQS_OPT) |
			P_Fld(0x0, MISC_CTRL3_ARPI_MPDIV_CG_CA_OPT) |
			P_Fld(0x0, MISC_CTRL3_ARPI_CG_DQ_OPT) |
			P_Fld(0x0, MISC_CTRL3_ARPI_CG_MCK_DQ_OPT) |
			P_Fld(0x0, MISC_CTRL3_ARPI_CG_CMD_OPT) |
			P_Fld(0x0, MISC_CTRL3_ARPI_CG_MCTL_DQ_OPT) |
			P_Fld(0x0, MISC_CTRL3_ARPI_CG_MCTL_CA_OPT) |
			P_Fld(0x0, MISC_CTRL3_ARPI_CG_CLK_OPT) |
			P_Fld(0x0, MISC_CTRL3_ARPI_MPDIV_CG_DQ_OPT) |
			P_Fld(0x0, MISC_CTRL3_ARPI_CG_MCK_CA_OPT));
return;
}

static void EnableCommonDCMShuffle(DRAMC_CTX_T *p, U32 u4DramcShuOffset, U32 u4DDRPhyShuOffset)
{
	vIO32WriteFldAlign_All(DDRPHY_REG_SHU_CA_CMD13 + u4DDRPhyShuOffset, 0x0, SHU_CA_CMD13_RG_TX_ARCLKB_READ_BASE_DATA_TIE_EN_CA);
	vIO32WriteFldMulti_All(DDRPHY_REG_MISC_SHU_RX_CG_CTRL + u4DDRPhyShuOffset,
			P_Fld(0x1, MISC_SHU_RX_CG_CTRL_RX_DQSIEN_RETRY_CG_EN) |
			P_Fld(0x1, MISC_SHU_RX_CG_CTRL_RX_RDSEL_TRACKING_CG_EN));
	vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B0_DQ8 + u4DDRPhyShuOffset,
			P_Fld(0x1, SHU_B0_DQ8_R_DMRXDLY_CG_IG_B0) |
			P_Fld(0x1, SHU_B0_DQ8_R_RMRX_TOPHY_CG_IG_B0));
	vIO32WriteFldAlign_All(DDRPHY_REG_MISC_SHU_CG_CTRL0 + u4DDRPhyShuOffset, 0x33403000, MISC_SHU_CG_CTRL0_R_PHY_MCK_CG_CTRL);
	vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B1_DQ8 + u4DDRPhyShuOffset,
			P_Fld(0x1, SHU_B1_DQ8_R_RMRX_TOPHY_CG_IG_B1) |
			P_Fld(0x1, SHU_B1_DQ8_R_DMRXDLY_CG_IG_B1));
	vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B1_DQ7 + u4DDRPhyShuOffset,
			P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B1) |
			P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B1) |
			P_Fld(0x0, SHU_B1_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B1));
	vIO32WriteFldMulti_All(DDRPHY_REG_SHU_CA_CMD7 + u4DDRPhyShuOffset,
			P_Fld(0x0, SHU_CA_CMD7_R_DMTX_ARPI_CG_CS_NEW) |
			P_Fld(0x0, SHU_CA_CMD7_R_DMTX_ARPI_CG_CMD_NEW));
#if TX_PICG_NEW_MODE
	vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B0_DQ7 + u4DDRPhyShuOffset,
			P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQ_NEW_B0) |
			P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQM_NEW_B0) |
			P_Fld(0x0, SHU_B0_DQ7_R_DMTX_ARPI_CG_DQS_NEW_B0));
#endif
return;
}

void EnableDramcPhyDCMNonShuffle(DRAMC_CTX_T *p, bool bEn)
{
	// Special case
	EnableCommonDCMNonShuffle(p);

	if(bEn)
	{
		vIO32WriteFldMulti_All(DRAMC_REG_TX_CG_SET0,
				P_Fld(0x0, TX_CG_SET0_DWCLKRUN) |
				P_Fld(0x0, TX_CG_SET0_SELPH_CG_DIS) |
				P_Fld(0x0, TX_CG_SET0_SELPH_4LCG_DIS) |
				P_Fld(0x0, TX_CG_SET0_TX_ATK_CLKRUN) |
				P_Fld(0x0, TX_CG_SET0_WDATA_CG_DIS));
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL5,
				P_Fld(0x1, MISC_CG_CTRL5_R_DQ1_DLY_DCM_EN) |
				P_Fld(0x1, MISC_CG_CTRL5_R_DQ1_PI_DCM_EN) |
				P_Fld(0x1, MISC_CG_CTRL5_R_DQ0_PI_DCM_EN) |
				P_Fld(0x1, MISC_CG_CTRL5_R_CA_PI_DCM_EN) |
				P_Fld(0x1, MISC_CG_CTRL5_R_DQ0_DLY_DCM_EN) |
				P_Fld(0x1, MISC_CG_CTRL5_R_CA_DLY_DCM_EN));
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL0,
				P_Fld(0x0, MISC_CG_CTRL0_RG_CG_DRAMC_OFF_DISABLE) |
				P_Fld(0x0, MISC_CG_CTRL0_RG_CG_COMB_OFF_DISABLE) |
				P_Fld(0x0, MISC_CG_CTRL0_RG_CG_CMD_OFF_DISABLE) |
				P_Fld(0x0, MISC_CG_CTRL0_RG_CG_COMB0_OFF_DISABLE) |
				P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_COMB1_OFF_DISABLE) |
				P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_COMB0_OFF_DISABLE) |
				P_Fld(0x0, MISC_CG_CTRL0_RG_CG_INFRA_OFF_DISABLE) |
				P_Fld(0x0, MISC_CG_CTRL0_RG_CG_PHY_OFF_DIABLE) |
				P_Fld(0x0, MISC_CG_CTRL0_RG_CG_COMB1_OFF_DISABLE) |
				P_Fld(0x0, MISC_CG_CTRL0_RG_CG_RX_CMD_OFF_DISABLE));
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL2,
				P_Fld(0x0, MISC_CG_CTRL2_RG_MEM_DCM_FORCE_ON) |
				P_Fld(0x1, MISC_CG_CTRL2_RG_MEM_DCM_DCM_EN));
		// RG group needs to be toggled!!
		vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL2, 1, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG);
		vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL2, 0, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG);
		vIO32WriteFldAlign_All(DRAMC_REG_MISCTL0, 0x0, MISCTL0_REFP_ARBMASK_PBR2PBR_PA_DIS);
		vIO32WriteFldAlign_All(DRAMC_REG_SREF_DPD_CTRL, 0x0, SREF_DPD_CTRL_SREF_CG_OPT);
		vIO32WriteFldMulti_All(DRAMC_REG_RX_CG_SET0,
				P_Fld(0x0, RX_CG_SET0_RDYCKAR) |
				P_Fld(0x0, RX_CG_SET0_RDATCKAR));
		vIO32WriteFldMulti_All(DRAMC_REG_ACTIMING_CTRL,
				P_Fld(0x0, ACTIMING_CTRL_SEQCLKRUN2) |
				P_Fld(0x0, ACTIMING_CTRL_SEQCLKRUN));
		vIO32WriteFldMulti_All(DRAMC_REG_SCSMCTRL_CG,
				P_Fld(0x0, SCSMCTRL_CG_SCARB_SM_CGAR) |
				P_Fld(0x0, SCSMCTRL_CG_SCSM_CGAR));
		vIO32WriteFldAlign_All(DRAMC_REG_CMD_DEC_CTRL0, 0x0, CMD_DEC_CTRL0_SELPH_CMD_CG_DIS);
		vIO32WriteFldMulti_All(DRAMC_REG_CLKAR,
				P_Fld(0x0, CLKAR_REQQUE_PACG_DIS) |
				P_Fld(0x0, CLKAR_REQQUECLKRUN));
		vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DUTYSCAN1, 0x0, MISC_DUTYSCAN1_RX_EYE_SCAN_CG_EN);
		vIO32WriteFldAlign_All(DRAMC_REG_DDRCOMMON0, 0x0, DDRCOMMON0_DISSTOP26M);
		vIO32WriteFldAlign_All(DRAMC_REG_DVFS_CTRL0, 0x0, DVFS_CTRL0_DVFS_CG_OPT);
		vIO32WriteFldAlign_All(DRAMC_REG_DCM_CTRL0, 0x0, DCM_CTRL0_BCLKAR);
		vIO32WriteFldMulti_All(DRAMC_REG_DRAMC_PD_CTRL,
				P_Fld(0x1, DRAMC_PD_CTRL_PHYCLKDYNGEN) |
				P_Fld(0x1, DRAMC_PD_CTRL_DCMEN2) |
				P_Fld(0x1, DRAMC_PD_CTRL_DCMEN) |
				P_Fld(0x0, DRAMC_PD_CTRL_PHYGLUECLKRUN) |
				P_Fld(0x0, DRAMC_PD_CTRL_COMBPHY_CLKENSAME) |
				P_Fld(0x0, DRAMC_PD_CTRL_APHYCKCG_FIXOFF) |
				P_Fld(0x0, DRAMC_PD_CTRL_MIOCKCTRLOFF) |
				P_Fld(0x1, DRAMC_PD_CTRL_DCMENNOTRFC) |
				P_Fld(0x1, DRAMC_PD_CTRL_COMBCLKCTRL));
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL3,
				P_Fld(0x0, MISC_CTRL3_R_DDRPHY_RX_PIPE_CG_IG) |
				P_Fld(0x0, MISC_CTRL3_R_DDRPHY_COMB_CG_IG));
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL4,
#if (RX_PICG_NEW_MODE || TX_PICG_NEW_MODE)
				P_Fld(0x1, MISC_CTRL4_R_OPT2_CG_MCK) |
				P_Fld(0x1, MISC_CTRL4_R_OPT2_MPDIV_CG) |
#endif
#if RX_PICG_NEW_MODE
				P_Fld(0x1, MISC_CTRL4_R_OPT2_CG_DQSIEN) |
#endif
#if TX_PICG_NEW_MODE
				P_Fld(0x1, MISC_CTRL4_R_OPT2_CG_DQ)  |
				P_Fld(0x1, MISC_CTRL4_R_OPT2_CG_DQS) |
				P_Fld(0x1, MISC_CTRL4_R_OPT2_CG_DQM) |
#endif
				P_Fld(0x1, MISC_CTRL4_R_OPT2_CG_CMD) |
				P_Fld(0x1, MISC_CTRL4_R_OPT2_CG_CLK) |
				P_Fld(0x1, MISC_CTRL4_R_OPT2_CG_CS));
		vIO32WriteFldMulti_All(DRAMC_REG_TX_TRACKING_SET0,
				P_Fld(0x0, TX_TRACKING_SET0_TXUIPI_CAL_CGAR) |
				P_Fld(0x0, TX_TRACKING_SET0_RDDQSOSC_CGAR) |
				P_Fld(0x0, TX_TRACKING_SET0_HMRRSEL_CGAR));
		vIO32WriteFldMulti_All(DRAMC_REG_ZQ_SET0,
				P_Fld(0x0, ZQ_SET0_ZQCS_MASK_SEL_CGAR) |
				P_Fld(0x0, ZQ_SET0_ZQMASK_CGAR));
		vIO32WriteFldAlign_All(DDRPHY_REG_MISC_RX_AUTOK_CFG0, 0x0, MISC_RX_AUTOK_CFG0_RX_CAL_CG_EN);
	}
	else
	{
		vIO32WriteFldMulti_All(DRAMC_REG_TX_CG_SET0,
				P_Fld(0x1, TX_CG_SET0_DWCLKRUN) |
				P_Fld(0x1, TX_CG_SET0_SELPH_CG_DIS) |
				P_Fld(0x1, TX_CG_SET0_SELPH_4LCG_DIS) |
				P_Fld(0x1, TX_CG_SET0_TX_ATK_CLKRUN) |
				P_Fld(0x1, TX_CG_SET0_WDATA_CG_DIS));
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL5,
				P_Fld(0x0, MISC_CG_CTRL5_R_DQ1_DLY_DCM_EN) |
				P_Fld(0x0, MISC_CG_CTRL5_R_DQ1_PI_DCM_EN) |
				P_Fld(0x0, MISC_CG_CTRL5_R_DQ0_PI_DCM_EN) |
				P_Fld(0x0, MISC_CG_CTRL5_R_CA_PI_DCM_EN) |
				P_Fld(0x0, MISC_CG_CTRL5_R_DQ0_DLY_DCM_EN) |
				P_Fld(0x0, MISC_CG_CTRL5_R_CA_DLY_DCM_EN));
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL0,
				P_Fld(0x1, MISC_CG_CTRL0_RG_CG_DRAMC_OFF_DISABLE) |
				P_Fld(0x1, MISC_CG_CTRL0_RG_CG_COMB_OFF_DISABLE) |
				P_Fld(0x1, MISC_CG_CTRL0_RG_CG_CMD_OFF_DISABLE) |
				P_Fld(0x1, MISC_CG_CTRL0_RG_CG_COMB0_OFF_DISABLE) |
				P_Fld(0x1, MISC_CG_CTRL0_RG_CG_RX_COMB1_OFF_DISABLE) |
				P_Fld(0x1, MISC_CG_CTRL0_RG_CG_RX_COMB0_OFF_DISABLE) |
				P_Fld(0x1, MISC_CG_CTRL0_RG_CG_INFRA_OFF_DISABLE) |
				P_Fld(0x1, MISC_CG_CTRL0_RG_CG_PHY_OFF_DIABLE) |
				P_Fld(0x1, MISC_CG_CTRL0_RG_CG_COMB1_OFF_DISABLE) |
				P_Fld(0x1, MISC_CG_CTRL0_RG_CG_RX_CMD_OFF_DISABLE));
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CG_CTRL2,
				P_Fld(0x1, MISC_CG_CTRL2_RG_MEM_DCM_FORCE_ON) |
				P_Fld(0x0, MISC_CG_CTRL2_RG_MEM_DCM_DCM_EN));
		// RG group needs to be toggled!!
		vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL2, 1, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG);
		vIO32WriteFldAlign_All(DDRPHY_REG_MISC_CG_CTRL2, 0, MISC_CG_CTRL2_RG_MEM_DCM_APB_TOG);
		vIO32WriteFldAlign_All(DRAMC_REG_MISCTL0, 0x1, MISCTL0_REFP_ARBMASK_PBR2PBR_PA_DIS);
		vIO32WriteFldAlign_All(DRAMC_REG_SREF_DPD_CTRL, 0x1, SREF_DPD_CTRL_SREF_CG_OPT);
		vIO32WriteFldMulti_All(DRAMC_REG_RX_CG_SET0,
				P_Fld(0x1, RX_CG_SET0_RDYCKAR) |
				P_Fld(0x1, RX_CG_SET0_RDATCKAR));
		vIO32WriteFldMulti_All(DRAMC_REG_ACTIMING_CTRL,
				P_Fld(0x1, ACTIMING_CTRL_SEQCLKRUN2) |
				P_Fld(0x1, ACTIMING_CTRL_SEQCLKRUN));
		vIO32WriteFldMulti_All(DRAMC_REG_SCSMCTRL_CG,
				P_Fld(0x1, SCSMCTRL_CG_SCARB_SM_CGAR) |
				P_Fld(0x1, SCSMCTRL_CG_SCSM_CGAR));
		vIO32WriteFldAlign_All(DRAMC_REG_CMD_DEC_CTRL0, 0x1, CMD_DEC_CTRL0_SELPH_CMD_CG_DIS);
		vIO32WriteFldMulti_All(DRAMC_REG_CLKAR,
				P_Fld(0x7fff, CLKAR_REQQUE_PACG_DIS) |
				P_Fld(0x1, CLKAR_REQQUECLKRUN));
		vIO32WriteFldAlign_All(DDRPHY_REG_MISC_DUTYSCAN1, 0x1, MISC_DUTYSCAN1_RX_EYE_SCAN_CG_EN);
		vIO32WriteFldAlign_All(DRAMC_REG_DDRCOMMON0, 0x1, DDRCOMMON0_DISSTOP26M);
		vIO32WriteFldAlign_All(DRAMC_REG_DVFS_CTRL0, 0x1, DVFS_CTRL0_DVFS_CG_OPT);
		vIO32WriteFldAlign_All(DRAMC_REG_DCM_CTRL0, 0x1, DCM_CTRL0_BCLKAR);
		vIO32WriteFldMulti_All(DRAMC_REG_DRAMC_PD_CTRL,
				P_Fld(0x0, DRAMC_PD_CTRL_PHYCLKDYNGEN) |
				P_Fld(0x0, DRAMC_PD_CTRL_DCMEN2) |
				P_Fld(0x0, DRAMC_PD_CTRL_DCMEN) |
				P_Fld(0x1, DRAMC_PD_CTRL_PHYGLUECLKRUN) |
				P_Fld(0x1, DRAMC_PD_CTRL_COMBPHY_CLKENSAME) |
				P_Fld(0x1, DRAMC_PD_CTRL_APHYCKCG_FIXOFF) |
				P_Fld(0x1, DRAMC_PD_CTRL_MIOCKCTRLOFF) |
				P_Fld(0x0, DRAMC_PD_CTRL_DCMENNOTRFC) |
				P_Fld(0x0, DRAMC_PD_CTRL_COMBCLKCTRL));
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL3,
				P_Fld(0x1, MISC_CTRL3_R_DDRPHY_RX_PIPE_CG_IG) |
				P_Fld(0x1, MISC_CTRL3_R_DDRPHY_COMB_CG_IG));
		vIO32WriteFldMulti_All(DDRPHY_REG_MISC_CTRL4,
				P_Fld(0x0, MISC_CTRL4_R_OPT2_CG_DQSIEN) |
				P_Fld(0x0, MISC_CTRL4_R_OPT2_CG_CLK) |
				P_Fld(0x0, MISC_CTRL4_R_OPT2_MPDIV_CG) |
				P_Fld(0x0, MISC_CTRL4_R_OPT2_CG_DQM) |
				P_Fld(0x0, MISC_CTRL4_R_OPT2_CG_CMD) |
				P_Fld(0x0, MISC_CTRL4_R_OPT2_CG_DQS) |
				P_Fld(0x0, MISC_CTRL4_R_OPT2_CG_MCK) |
				P_Fld(0x0, MISC_CTRL4_R_OPT2_CG_CS) |
				P_Fld(0x0, MISC_CTRL4_R_OPT2_CG_DQ));
		vIO32WriteFldMulti_All(DRAMC_REG_TX_TRACKING_SET0,
				P_Fld(0x1, TX_TRACKING_SET0_TXUIPI_CAL_CGAR) |
				P_Fld(0x1, TX_TRACKING_SET0_RDDQSOSC_CGAR) |
				P_Fld(0x1, TX_TRACKING_SET0_HMRRSEL_CGAR));
		vIO32WriteFldMulti_All(DRAMC_REG_ZQ_SET0,
				P_Fld(0x1, ZQ_SET0_ZQCS_MASK_SEL_CGAR) |
				P_Fld(0x1, ZQ_SET0_ZQMASK_CGAR));
		vIO32WriteFldAlign_All(DDRPHY_REG_MISC_RX_AUTOK_CFG0, 0x1, MISC_RX_AUTOK_CFG0_RX_CAL_CG_EN);
	}
	return;
}

void EnableDramcPhyDCMShuffle(DRAMC_CTX_T *p, bool bEn, U32 u4DramcShuOffset, U32 u4DDRPhyShuOffset)
{
	// Special case
	// DRAMC_REG_SHU_RX_CG_SET0 + u4DramcShuOffset - SHU_RX_CG_SET0_READ_START_EXTEND3: Special case
	// DRAMC_REG_SHU_RX_CG_SET0 + u4DramcShuOffset - SHU_RX_CG_SET0_READ_START_EXTEND2: Special case
	// DRAMC_REG_SHU_RX_CG_SET0 + u4DramcShuOffset - SHU_RX_CG_SET0_READ_START_EXTEND1: Special case
	// DRAMC_REG_SHU_RX_CG_SET0 + u4DramcShuOffset - SHU_RX_CG_SET0_DLE_LAST_EXTEND1: Special case
	// DRAMC_REG_SHU_RX_CG_SET0 + u4DramcShuOffset - SHU_RX_CG_SET0_DLE_LAST_EXTEND2: Special case
	// DRAMC_REG_SHU_RX_CG_SET0 + u4DramcShuOffset - SHU_RX_CG_SET0_DLE_LAST_EXTEND3: Special case
	EnableCommonDCMShuffle(p, u4DramcShuOffset, u4DDRPhyShuOffset);

	if(bEn)
	{
		vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B0_DQ8 + u4DDRPhyShuOffset,
				P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0) |
				P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0) |
				P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0) |
				P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0) |
				P_Fld(0x0, SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0) |
				P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0) |
				P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0) |
				P_Fld(0x0, SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0) |
				P_Fld(0x0, SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0) |
				P_Fld(0x0, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0));
		vIO32WriteFldMulti_All(DDRPHY_REG_SHU_CA_CMD8 + u4DDRPhyShuOffset,
				P_Fld(0x0, SHU_CA_CMD8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_CA) |
				P_Fld(0x0, SHU_CA_CMD8_R_DMRANK_PIPE_CG_IG_CA) |
				P_Fld(0x0, SHU_CA_CMD8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_CA) |
				P_Fld(0x0, SHU_CA_CMD8_R_DMDQSIEN_FLAG_PIPE_CG_IG_CA) |
				P_Fld(0x0, SHU_CA_CMD8_R_DMDQSIEN_FLAG_SYNC_CG_IG_CA) |
				P_Fld(0x0, SHU_CA_CMD8_R_DMRANK_CHG_PIPE_CG_IG_CA) |
				P_Fld(0x0, SHU_CA_CMD8_R_RMRX_TOPHY_CG_IG_CA) |
				P_Fld(0x0, SHU_CA_CMD8_R_RMRODTEN_CG_IG_CA));
#if TX_PICG_NEW_MODE
		vIO32WriteFldAlign_All(DRAMC_REG_SHU_APHY_TX_PICG_CTRL + u4DramcShuOffset, 0x1, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT);
#endif
		vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B1_DQ8 + u4DDRPhyShuOffset,
				P_Fld(0x0, SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1) |
				P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1) |
				P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1) |
				P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1) |
				P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1) |
				P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1) |
				P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1) |
				P_Fld(0x0, SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1) |
				P_Fld(0x0, SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1) |
				P_Fld(0x0, SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1));
		vIO32WriteFldAlign_All(DDRPHY_REG_MISC_SHU_ODTCTRL + u4DDRPhyShuOffset, 0x0, MISC_SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG);
	}
	else
	{
		vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B0_DQ8 + u4DDRPhyShuOffset,
				P_Fld(0x1, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B0) |
				P_Fld(0x1, SHU_B0_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B0) |
				P_Fld(0x1, SHU_B0_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B0) |
				P_Fld(0x1, SHU_B0_DQ8_R_DMRANK_PIPE_CG_IG_B0) |
				P_Fld(0x1, SHU_B0_DQ8_R_RMRODTEN_CG_IG_B0) |
				P_Fld(0x1, SHU_B0_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B0) |
				P_Fld(0x1, SHU_B0_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B0) |
				P_Fld(0x1, SHU_B0_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B0) |
				P_Fld(0x1, SHU_B0_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B0) |
				P_Fld(0x1, SHU_B0_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B0));
		vIO32WriteFldMulti_All(DDRPHY_REG_SHU_CA_CMD8 + u4DDRPhyShuOffset,
				P_Fld(0x1, SHU_CA_CMD8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_CA) |
				P_Fld(0x1, SHU_CA_CMD8_R_DMRANK_PIPE_CG_IG_CA) |
				P_Fld(0x1, SHU_CA_CMD8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_CA) |
				P_Fld(0x1, SHU_CA_CMD8_R_DMDQSIEN_FLAG_PIPE_CG_IG_CA) |
				P_Fld(0x1, SHU_CA_CMD8_R_DMDQSIEN_FLAG_SYNC_CG_IG_CA) |
				P_Fld(0x1, SHU_CA_CMD8_R_DMRANK_CHG_PIPE_CG_IG_CA) |
				P_Fld(0x1, SHU_CA_CMD8_R_RMRX_TOPHY_CG_IG_CA) |
				P_Fld(0x1, SHU_CA_CMD8_R_RMRODTEN_CG_IG_CA));
		vIO32WriteFldAlign_All(DRAMC_REG_SHU_APHY_TX_PICG_CTRL + u4DramcShuOffset, 0x0, SHU_APHY_TX_PICG_CTRL_DDRPHY_CLK_EN_COMB_TX_OPT);
		vIO32WriteFldMulti_All(DDRPHY_REG_SHU_B1_DQ8 + u4DDRPhyShuOffset,
				P_Fld(0x1, SHU_B1_DQ8_R_RMRODTEN_CG_IG_B1) |
				P_Fld(0x1, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_PIPE_CG_IG_B1) |
				P_Fld(0x1, SHU_B1_DQ8_R_DMDQSIEN_RDSEL_TOG_PIPE_CG_IG_B1) |
				P_Fld(0x1, SHU_B1_DQ8_R_DMRANK_PIPE_CG_IG_B1) |
				P_Fld(0x1, SHU_B1_DQ8_R_DMDQSIEN_FLAG_PIPE_CG_IG_B1) |
				P_Fld(0x1, SHU_B1_DQ8_R_DMRXDVS_RDSEL_PIPE_CG_IG_B1) |
				P_Fld(0x1, SHU_B1_DQ8_R_DMRANK_RXDLY_PIPE_CG_IG_B1) |
				P_Fld(0x1, SHU_B1_DQ8_R_DMDQSIEN_FLAG_SYNC_CG_IG_B1) |
				P_Fld(0x1, SHU_B1_DQ8_R_DMRANK_CHG_PIPE_CG_IG_B1) |
				P_Fld(0x1, SHU_B1_DQ8_R_DMRXDVS_RDSEL_TOG_PIPE_CG_IG_B1));
		vIO32WriteFldAlign_All(DDRPHY_REG_MISC_SHU_ODTCTRL + u4DDRPhyShuOffset, 0x1, MISC_SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG);
	}
	return;
}

//----------------------------------------
// Auto Gen Code -- END
//----------------------------------------

void EnableDramcPhyDCM(DRAMC_CTX_T *p, bool bEn)
{
	U32 u4WbrBackup = GetDramcBroadcast();
	DramcBroadcastOnOff(DRAMC_BROADCAST_OFF);

	EnableDramcPhyDCMNonShuffle(p, bEn);
	EnableDramcPhyDCMShuffle(p, bEn, 0, 0);//only need to set SHU0 RG while init, SHU0 will copy to others

#if ((CHECK_GOLDEN_SETTING == TRUE) && (APPLY_LOWPOWER_GOLDEN_SETTINGS == 0))
	DRAM_STATUS_T stResult = CheckGoldenSetting(p);
	msg("Golden setting check: %s\n", (stResult == DRAM_OK)? ("OK") : ("NG"));
#endif

	DramcBroadcastOnOff(u4WbrBackup);
	return;
}


#if RX_PICG_NEW_MODE
#if 0
DRAM_STATUS_T CheckRxPICGNewModeSetting(DRAMC_CTX_T *p)
{
	U8 channel_idx;
	U8 u1RankIdx;
	U32 u4Value;


	for(channel_idx = CHANNEL_A; channel_idx < p->support_channel_num; channel_idx++)
	{
		p->channel = channel_idx;
		msg("CH[%d] \n", channel_idx);
		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CTRL4), MISC_CTRL4_R_OPT2_CG_MCK);
		msg("MISC_CTRL4_R_OPT2_CG_MCK:0x%x \n", u4Value);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CTRL4), MISC_CTRL4_R_OPT2_MPDIV_CG);
		msg("MISC_CTRL4_R_OPT2_MPDIV_CG:0x%x \n", u4Value);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_CTRL4), MISC_CTRL4_R_OPT2_CG_DQSIEN);
		msg("MISC_CTRL4_R_OPT2_CG_DQSIEN:0x%x \n", u4Value);


		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_STBCAL1), MISC_STBCAL1_STBCNT_SHU_RST_EN);
		msg("MISC_STBCAL1_STBCNT_SHU_RST_EN:0x%x \n", u4Value);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_STBCAL2), MISC_STBCAL2_DQSIEN_SELPH_BY_RANK_EN);
		msg("MISC_STBCAL2_DQSIEN_SELPH_BY_RANK_EN:0x%x \n", u4Value);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_SHU_STBCAL), MISC_SHU_STBCAL_DQSIEN_PICG_MODE);
		msg("MISC_SHU_STBCAL_DQSIEN_PICG_MODE:0x%x \n", u4Value);


		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_RX_IN_GATE_EN_CTRL), MISC_RX_IN_GATE_EN_CTRL_RX_IN_GATE_EN_OPT);
		msg("MISC_RX_IN_GATE_EN_CTRL_RX_IN_GATE_EN_OPT:0x%x \n", u4Value);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_RX_IN_BUFF_EN_CTRL), MISC_RX_IN_BUFF_EN_CTRL_RX_IN_BUFF_EN_OPT);
		msg("MISC_RX_IN_BUFF_EN_CTRL_RX_IN_BUFF_EN_OPT:0x%x \n", u4Value);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_STBCAL2), MISC_STBCAL2_STB_STBENRST_EARLY_1T_EN);
		msg("MISC_STBCAL2_STB_STBENRST_EARLY_1T_EN:0x%x \n", u4Value);

		for (u1RankIdx = 0; u1RankIdx < p->support_rank_num; u1RankIdx++)//Should set 2 rank
		{

			vSetRank(p, u1RankIdx);
			u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_SHU_RK_DQSIEN_PICG_CTRL), MISC_SHU_RK_DQSIEN_PICG_CTRL_DQSIEN_PICG_TAIL_EXT_LAT);
			msg("Rank[%d] MISC_SHU_RK_DQSIEN_PICG_CTRL_DQSIEN_PICG_TAIL_EXT_LAT:0x%x \n", u1RankIdx, u4Value);
			u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_SHU_RK_DQSIEN_PICG_CTRL), MISC_SHU_RK_DQSIEN_PICG_CTRL_DQSIEN_PICG_HEAD_EXT_LAT);
			msg("Rank[%d] MISC_SHU_RK_DQSIEN_PICG_CTRL_DQSIEN_PICG_HEAD_EXT_LAT:0x%x \n", u1RankIdx, u4Value);
		}
		vSetRank(p, RANK_0);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_RX_IN_BUFF_EN_CTRL), MISC_RX_IN_BUFF_EN_CTRL_DIS_IN_BUFF_EN);
		msg("MISC_RX_IN_BUFF_EN_CTRL_DIS_IN_BUFF_EN:0x%x \n", u4Value);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_RX_IN_BUFF_EN_CTRL), MISC_RX_IN_BUFF_EN_CTRL_FIX_IN_BUFF_EN);
		msg("MISC_RX_IN_BUFF_EN_CTRL_FIX_IN_BUFF_EN:0x%x \n", u4Value);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_RX_IN_BUFF_EN_CTRL), MISC_RX_IN_BUFF_EN_CTRL_RX_IN_BUFF_EN_4BYTE_EN);
		msg("MISC_RX_IN_BUFF_EN_CTRL_RX_IN_BUFF_EN_4BYTE_EN:0x%x \n", u4Value);


		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_RX_IN_GATE_EN_CTRL), MISC_RX_IN_GATE_EN_CTRL_DIS_IN_GATE_EN);
		msg("MISC_RX_IN_GATE_EN_CTRL_DIS_IN_GATE_EN:0x%x \n", u4Value);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_RX_IN_GATE_EN_CTRL), MISC_RX_IN_GATE_EN_CTRL_FIX_IN_GATE_EN);
		msg("MISC_RX_IN_GATE_EN_CTRL_FIX_IN_GATE_EN:0x%x \n", u4Value);

		u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DDRPHY_REG_MISC_RX_IN_GATE_EN_CTRL), MISC_RX_IN_GATE_EN_CTRL_RX_IN_GATE_EN_4BYTE_EN);
		msg("MISC_RX_IN_GATE_EN_CTRL_RX_IN_GATE_EN_4BYTE_EN:0x%x \n", u4Value);

	}
	p->channel = CHANNEL_A;
}
#endif
#endif

#if (CHECK_GOLDEN_SETTING == TRUE)
DRAM_STATUS_T CheckGoldenField(DRAMC_CTX_T *p, GOLDEN_FIELD_T *golden_setting_anwer, U16 array_size)
{
	DRAM_STATUS_T eStatus = DRAM_OK;
	U8 channel_idx;
	U32 u4Value = 0;
	U32 u4Answer = 0;
	U16 array_cnt = array_size / sizeof(golden_setting_anwer[0]);

	U16 u2Idx = 0;
	for(u2Idx = 0; u2Idx < array_cnt; u2Idx++)
	{
		for(channel_idx = CHANNEL_A; channel_idx < p->support_channel_num; channel_idx++)//comapre CHA && CHB
		{
			vSetPHY2ChannelMapping(p, channel_idx);
			u4Value = u4IO32ReadFldAlign(DRAMC_REG_ADDR(golden_setting_anwer[u2Idx].group), golden_setting_anwer[u2Idx].field);
			//msg("%s: 0x%x\n", golden_setting_anwer[u2Idx].fieldName, u4Value);

			u4Answer = *(&golden_setting_anwer[u2Idx].u4ChaValue);//golden_setting_anwer only has CHA value

			if(u4Answer != 0xffffffff)//0xffffffff: no need to compare
			{
				if(u4Answer == u4Value)
				{
					//msg("OK [%s] 0x%x\n", golden_setting_anwer[u2Idx].fieldName, u4Answer);
				}
				else
				{
					msg("*** fail ***[%s]CH[%d][0x%x][ANS:0x%x]****** fail\n", golden_setting_anwer[u2Idx].fieldName, channel_idx, u4Value, u4Answer);
					eStatus |= DRAM_FAIL;
				}
			}
		}
	}
	return eStatus;
}

DRAM_STATUS_T CheckGoldenSetting(DRAMC_CTX_T *p)
{
	U8 u1BkShuffleIdx = p->pDFSTable->shuffleIdx;
	U8 u1SramShuffleIdx = 0;
	U8 u1ShuffleIdx = 0;
	U8 backup_channel = vGetPHY2ChannelMapping(p);
	DRAM_STATUS_T eStatus = DRAM_OK;

	msg("Golden setting check[Begin]\n");
	eStatus |= CheckGoldenField(p, nonshuf_golden_setting_anwer, sizeof(nonshuf_golden_setting_anwer));


	if(gAndroid_DVFS_en)
	{
		for (u1ShuffleIdx = 0; u1ShuffleIdx <= DRAM_DFS_SRAM_MAX; u1ShuffleIdx++)
		{
			if (u1ShuffleIdx < DRAM_DFS_SRAM_MAX)
			{
				msg("SRAM SHU%d\n", u1ShuffleIdx);
				u1SramShuffleIdx = u1ShuffleIdx;
			}
			else
			{
				msg("CONF SHU0, DDR[%d]\n", p->frequency * 2);
				u1SramShuffleIdx = u1BkShuffleIdx; //Restore to original freq && check conf SHU0
			}

			//msg("shuf_golden_setting_anwer:%d %d\n",	sizeof(shuf_golden_setting_anwer), sizeof(shuf_golden_setting_anwer[0]));
			DramcDFSDirectJump(p, u1SramShuffleIdx); //fill conf SHU0 && SHU1 from SRAM SHU(0~9) while DVFS twice
			DramcDFSDirectJump(p, u1SramShuffleIdx);

			eStatus |= CheckGoldenField(p, shuf_golden_setting_anwer, sizeof(shuf_golden_setting_anwer));
		}
	}
	else
	{
		msg("CONF SHU0, DDR[%d]\n", p->frequency * 2);
		eStatus |= CheckGoldenField(p, shuf_golden_setting_anwer, sizeof(shuf_golden_setting_anwer));
	}

	msg("Golden setting check[End]\n");

	vSetPHY2ChannelMapping(p, backup_channel);
	return eStatus;
}
#endif

#ifdef CLK_FREE_FUN_FOR_DRAMC_PSEL
//If dramc enter SREF and power down, all configure need to sync 2T again after exit SREF.
//If Psel is 1, clock will be free run at the periof of 2T to let conf be applied.
//If Psel is 0, Clock will be gated
void ClkFreeRunForDramcPsel(DRAMC_CTX_T *p)
{
	vIO32WriteFldMulti_All(DRAMC_REG_TX_CG_SET0, P_Fld(0, TX_CG_SET0_PSEL_OPT1)
			| P_Fld(0, TX_CG_SET0_PSEL_OPT2)
			| P_Fld(0, TX_CG_SET0_PSEL_OPT3)
			| P_Fld(0, TX_CG_SET0_PSELAR));
}
#endif

#if PA_IMPROVEMENT_FOR_DRAMC_ACTIVE_POWER
void DramcPAImprove(DRAMC_CTX_T *p)
{
	//U8 u1ShuIdx = 0, u1ShuCnt = 3; //TODO: change u1ShuCnt to actual shuffle num define
	//U32 u4targetAddr = 0; //For SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG, SHU_ODTCTRL_RODTEN_SELPH_CG_IG shuffle regs
	vIO32WriteFldAlign_All(DRAMC_REG_CLKAR, 0x0, CLKAR_REQQUE_PACG_DIS);
	vIO32WriteFldAlign_All(DRAMC_REG_CMD_DEC_CTRL0, 0x0, CMD_DEC_CTRL0_SELPH_CMD_CG_DIS);

	/* Dummy_RD_PA_OPT should be set to 1, or else some functions would fail (YH Tsai)
	 * Already set to 1 in in UpdateInitialSettings(), so comment out set to 0 here
	 */
	//vIO32WriteFldAlign_All(DRAMC_REG_ADDR(DRAMC_REG_DUMMY_RD), 0, DUMMY_RD_DUMMY_RD_PA_OPT);
	vIO32WriteFldMulti_All(DRAMC_REG_SCSMCTRL_CG, P_Fld(0, SCSMCTRL_CG_SCSM_CGAR)
			| P_Fld(0, SCSMCTRL_CG_SCARB_SM_CGAR));
	vIO32WriteFldMulti_All(DRAMC_REG_TX_TRACKING_SET0, P_Fld(0, TX_TRACKING_SET0_RDDQSOSC_CGAR)
			| P_Fld(0, TX_TRACKING_SET0_HMRRSEL_CGAR)
			| P_Fld(0, TX_TRACKING_SET0_TXUIPI_CAL_CGAR));

	//Below loop sets SHU*_ODTCTRL_RODTENSTB_SELPH_CG_IG, SHU*_ODTCTRL_RODTEN_SELPH_CG_IG (wei-jen)
	//for (u1ShuIdx = DRAM_DFS_SHUFFLE_1; u1ShuIdx < u1ShuCnt; u1ShuIdx++)
	//{
	//	  u4targetAddr = DRAMC_REG_SHU_ODTCTRL + SHU_GRP_DRAMC_OFFSET * u1ShuIdx;
	//	  vIO32WriteFldMulti_All(u4targetAddr, P_Fld(0x0, SHU_ODTCTRL_RODTENSTB_SELPH_CG_IG)
	//										  | P_Fld(0x0, SHU_ODTCTRL_RODTEN_SELPH_CG_IG));
	//}
}
#endif

#if ENABLE_DDR800_OPEN_LOOP_MODE_OPTION

void DDR800semiPowerSavingOn(DRAMC_CTX_T *p, U8 next_shu_level, U8 u1OnOff)
{

}
#endif
#if 0 //Comment out unused code
void DramcDRS(DRAMC_CTX_T *p, U8 bEnable)
{
	//R_DMDRS_CNTX[6:0](DVT set 0, HQA set 4 or 5)
	vIO32WriteFldMulti_All(DRAMC_REG_ADDR(DRAMC_REG_DRSCTRL), P_Fld(0, DRSCTRL_DRSPB2AB_OPT)
															| P_Fld(0, DRSCTRL_DRSMON_CLR)
															| P_Fld(8, DRSCTRL_DRSDLY)
															| P_Fld(0, DRSCTRL_DRSACKWAITREF)
															| P_Fld(!bEnable, DRSCTRL_DRSDIS)
															| P_Fld(1, DRSCTRL_DRSCLR_EN)
															| P_Fld(3, DRSCTRL_DRS_CNTX)
															| P_Fld(!gDRSEnableSelfWakeup, DRSCTRL_DRS_SELFWAKE_DMYRD_DIS)
															| P_Fld(0, DRSCTRL_DRSOPT2));
}
#endif

#if 0 //Comment out unused code
#if (FOR_DV_SIMULATION_USED == 0 && SW_CHANGE_FOR_SIMULATION == 0)
void DramcEnterSelfRefresh(DRAMC_CTX_T *p, U8 op)
{
	U8 ucstatus = 0;
	U32 uiTemp;
	U32 u4TimeCnt;

	u4TimeCnt = TIME_OUT_CNT;

	msg("[EnterSelfRefresh] %s\n", (op == 1) ? "enter" : "exit");

	if (op == 1) // enter self refresh
	{
		// ONLY work for LP4, not LP3
		// MISCA_SRFPD_DIS =1, self-refresh
		// MISCA_SRFPD_DIS =0, self-refresh power down
		vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SREFCTRL), 1, SREFCTRL_SRFPD_DIS);

		vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SREFCTRL), 1, SREFCTRL_SELFREF);
		mcDELAY_US(2);
		uiTemp = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_MISC_STATUSA), MISC_STATUSA_SREF_STATE);
		while ((uiTemp == 0) && (u4TimeCnt > 0))
		{
			msg2("Still not enter self refresh(%d)\n", u4TimeCnt);
			mcDELAY_US(1);
			uiTemp = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_MISC_STATUSA), MISC_STATUSA_SREF_STATE);
			u4TimeCnt --;
		}
	}
	else // exit self refresh
	{
		vIO32WriteFldAlign(DRAMC_REG_ADDR(DRAMC_REG_SREFCTRL), 0, SREFCTRL_SELFREF);

		mcDELAY_US(2);
		uiTemp = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_MISC_STATUSA), MISC_STATUSA_SREF_STATE);
		while ((uiTemp != 0) && (u4TimeCnt > 0))
		{
			msg2("Still not exit self refresh(%d)\n", u4TimeCnt);
			mcDELAY_US(1);
			uiTemp = u4IO32ReadFldAlign(DRAMC_REG_ADDR(DRAMC_REG_MISC_STATUSA), MISC_STATUSA_SREF_STATE);
			u4TimeCnt--;
		}
	}

   if (u4TimeCnt == 0)
   {
		msg("Self refresh fail\n");
   }
   else
   {
		msg("Self refresh done\n");
   }
}
#endif
#endif //Comment out unused code

#if ENABLE_RX_DCM_DPHY
void EnableRxDcmDPhy(DRAMC_CTX_T *p, U32 u4DDRPhyShuOffset, U16 u2Freq)
{
	U8 u1PRECAL_CG_EN = 0;

	if (u2Freq <= 400)
		u1PRECAL_CG_EN = 1;
	else
		u1PRECAL_CG_EN = 0;

	//power gain
	vIO32WriteFldMulti_All(DDRPHY_REG_MISC_SHU_RX_CG_CTRL + u4DDRPhyShuOffset,
			P_Fld(0x1, MISC_SHU_RX_CG_CTRL_RX_DCM_OPT) |
			P_Fld(0x1, MISC_SHU_RX_CG_CTRL_RX_APHY_CTRL_DCM_OPT) |
			P_Fld(0x1, MISC_SHU_RX_CG_CTRL_RX_RODT_DCM_OPT) |
			P_Fld(0x0, MISC_SHU_RX_CG_CTRL_RX_DQSIEN_STBCAL_CG_EN) |
			P_Fld(0x1, MISC_SHU_RX_CG_CTRL_RX_DQSIEN_AUTOK_CG_EN) | 	// if Rx gating Auto K, set 0, Runtime set 1
#if RDSEL_TRACKING_EN
			P_Fld(0x0, MISC_SHU_RX_CG_CTRL_RX_RDSEL_TRACKING_CG_EN) |	// if K, set 1, at runtime if enable, set 0, else 1
#else
			P_Fld(0x1, MISC_SHU_RX_CG_CTRL_RX_RDSEL_TRACKING_CG_EN) |
#endif
			P_Fld(0x1, MISC_SHU_RX_CG_CTRL_RX_DQSIEN_RETRY_CG_EN) |
			P_Fld(u1PRECAL_CG_EN, MISC_SHU_RX_CG_CTRL_RX_PRECAL_CG_EN) |
			P_Fld(0x2, MISC_SHU_RX_CG_CTRL_RX_DCM_EXT_DLY) |
			P_Fld(0x0, MISC_SHU_RX_CG_CTRL_RX_DCM_WAIT_DLE_EXT_DLY));

}
#endif

