% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnector.R
\name{dbGetConnectArgs}
\alias{dbGetConnectArgs}
\title{Get connection arguments}
\usage{
dbGetConnectArgs(drv, eval = TRUE, ...)
}
\arguments{
\item{drv}{A object inheriting from \linkS4class{DBIConnector}.}

\item{eval}{Set to \code{FALSE} to return the functions that generate the argument
instead of evaluating them.}

\item{...}{Other arguments passed on to methods. Not otherwise used.}
}
\description{
Returns the arguments stored in a \linkS4class{DBIConnector} object for inspection,
optionally evaluating them.
This function is called by \code{\link[=dbConnect]{dbConnect()}}
and usually does not need to be called directly.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbGetConnectArgs")}
}
\examples{
cnr <- new("DBIConnector",
  .drv = RSQLite::SQLite(),
  .conn_args = list(dbname = ":memory:", password = function() "supersecret")
)
dbGetConnectArgs(cnr)
dbGetConnectArgs(cnr, eval = FALSE)
}
\seealso{
Other DBIConnector generics: 
\code{\link{DBIConnector-class}},
\code{\link{dbConnect}()},
\code{\link{dbDataType}()},
\code{\link{dbIsReadOnly}()}
}
\concept{DBIConnector generics}
