/*
 * Copyright (C) 2015~2015 by CSSlayer
 * wengxt@gmail.com
 * Copyright (C) 2017 Modified by xzhao
 * i@xuzhao.net
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; see the file COPYING. If not,
 * see <http://www.gnu.org/licenses/>.
 */
#ifndef _FCITX_UTILS_KEYNAMETABLE_H_
#define _FCITX_UTILS_KEYNAMETABLE_H_

#include <stdint.h>

#ifdef __GNUC__
#define _FCITX_UNUSED_ __attribute__((__unused__))
#else
#define _FCITX_UNUSED_
#endif

#ifdef __cplusplus
extern "C" {
#endif

static const char *keyNameList[] _FCITX_UNUSED_ =
{
"0",
"1",
"2",
"3",
"3270_AltCursor",
"3270_Attn",
"3270_BackTab",
"3270_ChangeScreen",
"3270_Copy",
"3270_CursorBlink",
"3270_CursorSelect",
"3270_DeleteWord",
"3270_Duplicate",
"3270_Enter",
"3270_EraseEOF",
"3270_EraseInput",
"3270_ExSelect",
"3270_FieldMark",
"3270_Ident",
"3270_Jump",
"3270_KeyClick",
"3270_Left2",
"3270_PA1",
"3270_PA2",
"3270_PA3",
"3270_Play",
"3270_PrintScreen",
"3270_Quit",
"3270_Record",
"3270_Reset",
"3270_Right2",
"3270_Rule",
"3270_Setup",
"3270_Test",
"4",
"5",
"6",
"7",
"8",
"9",
"A",
"AE",
"Aacute",
"Abelowdot",
"Abreve",
"Abreveacute",
"Abrevebelowdot",
"Abrevegrave",
"Abrevehook",
"Abrevetilde",
"AccessX_Enable",
"AccessX_Feedback_Enable",
"Acircumflex",
"Acircumflexacute",
"Acircumflexbelowdot",
"Acircumflexgrave",
"Acircumflexhook",
"Acircumflextilde",
"AddFavorite",
"Adiaeresis",
"Agrave",
"Ahook",
"Alt_L",
"Alt_R",
"Amacron",
"Aogonek",
"ApplicationLeft",
"ApplicationRight",
"Arabic_0",
"Arabic_1",
"Arabic_2",
"Arabic_3",
"Arabic_4",
"Arabic_5",
"Arabic_6",
"Arabic_7",
"Arabic_8",
"Arabic_9",
"Arabic_ain",
"Arabic_alef",
"Arabic_alefmaksura",
"Arabic_beh",
"Arabic_comma",
"Arabic_dad",
"Arabic_dal",
"Arabic_damma",
"Arabic_dammatan",
"Arabic_ddal",
"Arabic_farsi_yeh",
"Arabic_fatha",
"Arabic_fathatan",
"Arabic_feh",
"Arabic_fullstop",
"Arabic_gaf",
"Arabic_ghain",
"Arabic_ha",
"Arabic_hah",
"Arabic_hamza",
"Arabic_hamza_above",
"Arabic_hamza_below",
"Arabic_hamzaonalef",
"Arabic_hamzaonwaw",
"Arabic_hamzaonyeh",
"Arabic_hamzaunderalef",
"Arabic_heh",
"Arabic_heh_doachashmee",
"Arabic_heh_goal",
"Arabic_jeem",
"Arabic_jeh",
"Arabic_kaf",
"Arabic_kasra",
"Arabic_kasratan",
"Arabic_keheh",
"Arabic_khah",
"Arabic_lam",
"Arabic_madda_above",
"Arabic_maddaonalef",
"Arabic_meem",
"Arabic_noon",
"Arabic_noon_ghunna",
"Arabic_peh",
"Arabic_percent",
"Arabic_qaf",
"Arabic_question_mark",
"Arabic_ra",
"Arabic_rreh",
"Arabic_sad",
"Arabic_seen",
"Arabic_semicolon",
"Arabic_shadda",
"Arabic_sheen",
"Arabic_sukun",
"Arabic_superscript_alef",
"Arabic_switch",
"Arabic_tah",
"Arabic_tatweel",
"Arabic_tcheh",
"Arabic_teh",
"Arabic_tehmarbuta",
"Arabic_thal",
"Arabic_theh",
"Arabic_tteh",
"Arabic_veh",
"Arabic_waw",
"Arabic_yeh",
"Arabic_yeh_baree",
"Arabic_zah",
"Arabic_zain",
"Aring",
"Armenian_AT",
"Armenian_AYB",
"Armenian_BEN",
"Armenian_CHA",
"Armenian_DA",
"Armenian_DZA",
"Armenian_E",
"Armenian_FE",
"Armenian_GHAT",
"Armenian_GIM",
"Armenian_HI",
"Armenian_HO",
"Armenian_INI",
"Armenian_JE",
"Armenian_KE",
"Armenian_KEN",
"Armenian_KHE",
"Armenian_LYUN",
"Armenian_MEN",
"Armenian_NU",
"Armenian_O",
"Armenian_PE",
"Armenian_PYUR",
"Armenian_RA",
"Armenian_RE",
"Armenian_SE",
"Armenian_SHA",
"Armenian_TCHE",
"Armenian_TO",
"Armenian_TSA",
"Armenian_TSO",
"Armenian_TYUN",
"Armenian_VEV",
"Armenian_VO",
"Armenian_VYUN",
"Armenian_YECH",
"Armenian_ZA",
"Armenian_ZHE",
"Armenian_accent",
"Armenian_amanak",
"Armenian_apostrophe",
"Armenian_at",
"Armenian_ayb",
"Armenian_ben",
"Armenian_but",
"Armenian_cha",
"Armenian_da",
"Armenian_dza",
"Armenian_e",
"Armenian_exclam",
"Armenian_fe",
"Armenian_full_stop",
"Armenian_ghat",
"Armenian_gim",
"Armenian_hi",
"Armenian_ho",
"Armenian_hyphen",
"Armenian_ini",
"Armenian_je",
"Armenian_ke",
"Armenian_ken",
"Armenian_khe",
"Armenian_ligature_ew",
"Armenian_lyun",
"Armenian_men",
"Armenian_nu",
"Armenian_o",
"Armenian_paruyk",
"Armenian_pe",
"Armenian_pyur",
"Armenian_question",
"Armenian_ra",
"Armenian_re",
"Armenian_se",
"Armenian_separation_mark",
"Armenian_sha",
"Armenian_shesht",
"Armenian_tche",
"Armenian_to",
"Armenian_tsa",
"Armenian_tso",
"Armenian_tyun",
"Armenian_verjaket",
"Armenian_vev",
"Armenian_vo",
"Armenian_vyun",
"Armenian_yech",
"Armenian_yentamna",
"Armenian_za",
"Armenian_zhe",
"Atilde",
"AudibleBell_Enable",
"AudioCycleTrack",
"AudioForward",
"AudioLowerVolume",
"AudioMedia",
"AudioMicMute",
"AudioMute",
"AudioNext",
"AudioPause",
"AudioPlay",
"AudioPrev",
"AudioRaiseVolume",
"AudioRandomPlay",
"AudioRecord",
"AudioRepeat",
"AudioRewind",
"AudioStop",
"Away",
"B",
"Babovedot",
"Back",
"BackForward",
"BackSpace",
"Battery",
"Begin",
"Blue",
"Bluetooth",
"Book",
"BounceKeys_Enable",
"Break",
"BrightnessAdjust",
"Byelorussian_SHORTU",
"Byelorussian_shortu",
"C",
"CD",
"CH",
"C_H",
"C_h",
"Cabovedot",
"Cacute",
"Calculator",
"Calendar",
"Cancel",
"Caps_Lock",
"Ccaron",
"Ccedilla",
"Ccircumflex",
"Ch",
"Clear",
"Close",
"Codeinput",
"ColonSign",
"Community",
"ContrastAdjust",
"Control_L",
"Control_R",
"Copy",
"CruzeiroSign",
"Cut",
"CycleAngle",
"Cyrillic_A",
"Cyrillic_BE",
"Cyrillic_CHE",
"Cyrillic_CHE_descender",
"Cyrillic_CHE_vertstroke",
"Cyrillic_DE",
"Cyrillic_DZHE",
"Cyrillic_E",
"Cyrillic_EF",
"Cyrillic_EL",
"Cyrillic_EM",
"Cyrillic_EN",
"Cyrillic_EN_descender",
"Cyrillic_ER",
"Cyrillic_ES",
"Cyrillic_GHE",
"Cyrillic_GHE_bar",
"Cyrillic_HA",
"Cyrillic_HARDSIGN",
"Cyrillic_HA_descender",
"Cyrillic_I",
"Cyrillic_IE",
"Cyrillic_IO",
"Cyrillic_I_macron",
"Cyrillic_JE",
"Cyrillic_KA",
"Cyrillic_KA_descender",
"Cyrillic_KA_vertstroke",
"Cyrillic_LJE",
"Cyrillic_NJE",
"Cyrillic_O",
"Cyrillic_O_bar",
"Cyrillic_PE",
"Cyrillic_SCHWA",
"Cyrillic_SHA",
"Cyrillic_SHCHA",
"Cyrillic_SHHA",
"Cyrillic_SHORTI",
"Cyrillic_SOFTSIGN",
"Cyrillic_TE",
"Cyrillic_TSE",
"Cyrillic_U",
"Cyrillic_U_macron",
"Cyrillic_U_straight",
"Cyrillic_U_straight_bar",
"Cyrillic_VE",
"Cyrillic_YA",
"Cyrillic_YERU",
"Cyrillic_YU",
"Cyrillic_ZE",
"Cyrillic_ZHE",
"Cyrillic_ZHE_descender",
"Cyrillic_a",
"Cyrillic_be",
"Cyrillic_che",
"Cyrillic_che_descender",
"Cyrillic_che_vertstroke",
"Cyrillic_de",
"Cyrillic_dzhe",
"Cyrillic_e",
"Cyrillic_ef",
"Cyrillic_el",
"Cyrillic_em",
"Cyrillic_en",
"Cyrillic_en_descender",
"Cyrillic_er",
"Cyrillic_es",
"Cyrillic_ghe",
"Cyrillic_ghe_bar",
"Cyrillic_ha",
"Cyrillic_ha_descender",
"Cyrillic_hardsign",
"Cyrillic_i",
"Cyrillic_i_macron",
"Cyrillic_ie",
"Cyrillic_io",
"Cyrillic_je",
"Cyrillic_ka",
"Cyrillic_ka_descender",
"Cyrillic_ka_vertstroke",
"Cyrillic_lje",
"Cyrillic_nje",
"Cyrillic_o",
"Cyrillic_o_bar",
"Cyrillic_pe",
"Cyrillic_schwa",
"Cyrillic_sha",
"Cyrillic_shcha",
"Cyrillic_shha",
"Cyrillic_shorti",
"Cyrillic_softsign",
"Cyrillic_te",
"Cyrillic_tse",
"Cyrillic_u",
"Cyrillic_u_macron",
"Cyrillic_u_straight",
"Cyrillic_u_straight_bar",
"Cyrillic_ve",
"Cyrillic_ya",
"Cyrillic_yeru",
"Cyrillic_yu",
"Cyrillic_ze",
"Cyrillic_zhe",
"Cyrillic_zhe_descender",
"D",
"DOS",
"Dabovedot",
"Dcaron",
"Delete",
"Display",
"Documents",
"DongSign",
"Down",
"Dstroke",
"E",
"ENG",
"ETH",
"EZH",
"Eabovedot",
"Eacute",
"Ebelowdot",
"Ecaron",
"Ecircumflex",
"Ecircumflexacute",
"Ecircumflexbelowdot",
"Ecircumflexgrave",
"Ecircumflexhook",
"Ecircumflextilde",
"EcuSign",
"Ediaeresis",
"Egrave",
"Ehook",
"Eisu_Shift",
"Eisu_toggle",
"Eject",
"Emacron",
"End",
"Eogonek",
"Escape",
"Eth",
"Etilde",
"EuroSign",
"Excel",
"Execute",
"Explorer",
"F",
"F1",
"F10",
"F11",
"F12",
"F13",
"F14",
"F15",
"F16",
"F17",
"F18",
"F19",
"F2",
"F20",
"F21",
"F22",
"F23",
"F24",
"F25",
"F26",
"F27",
"F28",
"F29",
"F3",
"F30",
"F31",
"F32",
"F33",
"F34",
"F35",
"F4",
"F5",
"F6",
"F7",
"F8",
"F9",
"FFrancSign",
"Fabovedot",
"Farsi_0",
"Farsi_1",
"Farsi_2",
"Farsi_3",
"Farsi_4",
"Farsi_5",
"Farsi_6",
"Farsi_7",
"Farsi_8",
"Farsi_9",
"Farsi_yeh",
"Favorites",
"Finance",
"Find",
"First_Virtual_Screen",
"Forward",
"FrameBack",
"FrameForward",
"G",
"Gabovedot",
"Game",
"Gbreve",
"Gcaron",
"Gcedilla",
"Gcircumflex",
"Georgian_an",
"Georgian_ban",
"Georgian_can",
"Georgian_char",
"Georgian_chin",
"Georgian_cil",
"Georgian_don",
"Georgian_en",
"Georgian_fi",
"Georgian_gan",
"Georgian_ghan",
"Georgian_hae",
"Georgian_har",
"Georgian_he",
"Georgian_hie",
"Georgian_hoe",
"Georgian_in",
"Georgian_jhan",
"Georgian_jil",
"Georgian_kan",
"Georgian_khar",
"Georgian_las",
"Georgian_man",
"Georgian_nar",
"Georgian_on",
"Georgian_par",
"Georgian_phar",
"Georgian_qar",
"Georgian_rae",
"Georgian_san",
"Georgian_shin",
"Georgian_tan",
"Georgian_tar",
"Georgian_un",
"Georgian_vin",
"Georgian_we",
"Georgian_xan",
"Georgian_zen",
"Georgian_zhar",
"Go",
"Greek_ALPHA",
"Greek_ALPHAaccent",
"Greek_BETA",
"Greek_CHI",
"Greek_DELTA",
"Greek_EPSILON",
"Greek_EPSILONaccent",
"Greek_ETA",
"Greek_ETAaccent",
"Greek_GAMMA",
"Greek_IOTA",
"Greek_IOTAaccent",
"Greek_IOTAdiaeresis",
"Greek_IOTAdieresis",
"Greek_KAPPA",
"Greek_LAMBDA",
"Greek_LAMDA",
"Greek_MU",
"Greek_NU",
"Greek_OMEGA",
"Greek_OMEGAaccent",
"Greek_OMICRON",
"Greek_OMICRONaccent",
"Greek_PHI",
"Greek_PI",
"Greek_PSI",
"Greek_RHO",
"Greek_SIGMA",
"Greek_TAU",
"Greek_THETA",
"Greek_UPSILON",
"Greek_UPSILONaccent",
"Greek_UPSILONdieresis",
"Greek_XI",
"Greek_ZETA",
"Greek_accentdieresis",
"Greek_alpha",
"Greek_alphaaccent",
"Greek_beta",
"Greek_chi",
"Greek_delta",
"Greek_epsilon",
"Greek_epsilonaccent",
"Greek_eta",
"Greek_etaaccent",
"Greek_finalsmallsigma",
"Greek_gamma",
"Greek_horizbar",
"Greek_iota",
"Greek_iotaaccent",
"Greek_iotaaccentdieresis",
"Greek_iotadieresis",
"Greek_kappa",
"Greek_lambda",
"Greek_lamda",
"Greek_mu",
"Greek_nu",
"Greek_omega",
"Greek_omegaaccent",
"Greek_omicron",
"Greek_omicronaccent",
"Greek_phi",
"Greek_pi",
"Greek_psi",
"Greek_rho",
"Greek_sigma",
"Greek_switch",
"Greek_tau",
"Greek_theta",
"Greek_upsilon",
"Greek_upsilonaccent",
"Greek_upsilonaccentdieresis",
"Greek_upsilondieresis",
"Greek_xi",
"Greek_zeta",
"Green",
"H",
"Hangul",
"Hangul_A",
"Hangul_AE",
"Hangul_AraeA",
"Hangul_AraeAE",
"Hangul_Banja",
"Hangul_Cieuc",
"Hangul_Codeinput",
"Hangul_Dikeud",
"Hangul_E",
"Hangul_EO",
"Hangul_EU",
"Hangul_End",
"Hangul_Hanja",
"Hangul_Hieuh",
"Hangul_I",
"Hangul_Ieung",
"Hangul_J_Cieuc",
"Hangul_J_Dikeud",
"Hangul_J_Hieuh",
"Hangul_J_Ieung",
"Hangul_J_Jieuj",
"Hangul_J_Khieuq",
"Hangul_J_Kiyeog",
"Hangul_J_KiyeogSios",
"Hangul_J_KkogjiDalrinIeung",
"Hangul_J_Mieum",
"Hangul_J_Nieun",
"Hangul_J_NieunHieuh",
"Hangul_J_NieunJieuj",
"Hangul_J_PanSios",
"Hangul_J_Phieuf",
"Hangul_J_Pieub",
"Hangul_J_PieubSios",
"Hangul_J_Rieul",
"Hangul_J_RieulHieuh",
"Hangul_J_RieulKiyeog",
"Hangul_J_RieulMieum",
"Hangul_J_RieulPhieuf",
"Hangul_J_RieulPieub",
"Hangul_J_RieulSios",
"Hangul_J_RieulTieut",
"Hangul_J_Sios",
"Hangul_J_SsangKiyeog",
"Hangul_J_SsangSios",
"Hangul_J_Tieut",
"Hangul_J_YeorinHieuh",
"Hangul_Jamo",
"Hangul_Jeonja",
"Hangul_Jieuj",
"Hangul_Khieuq",
"Hangul_Kiyeog",
"Hangul_KiyeogSios",
"Hangul_KkogjiDalrinIeung",
"Hangul_Mieum",
"Hangul_MultipleCandidate",
"Hangul_Nieun",
"Hangul_NieunHieuh",
"Hangul_NieunJieuj",
"Hangul_O",
"Hangul_OE",
"Hangul_PanSios",
"Hangul_Phieuf",
"Hangul_Pieub",
"Hangul_PieubSios",
"Hangul_PostHanja",
"Hangul_PreHanja",
"Hangul_PreviousCandidate",
"Hangul_Rieul",
"Hangul_RieulHieuh",
"Hangul_RieulKiyeog",
"Hangul_RieulMieum",
"Hangul_RieulPhieuf",
"Hangul_RieulPieub",
"Hangul_RieulSios",
"Hangul_RieulTieut",
"Hangul_RieulYeorinHieuh",
"Hangul_Romaja",
"Hangul_SingleCandidate",
"Hangul_Sios",
"Hangul_Special",
"Hangul_SsangDikeud",
"Hangul_SsangJieuj",
"Hangul_SsangKiyeog",
"Hangul_SsangPieub",
"Hangul_SsangSios",
"Hangul_Start",
"Hangul_SunkyeongeumMieum",
"Hangul_SunkyeongeumPhieuf",
"Hangul_SunkyeongeumPieub",
"Hangul_Tieut",
"Hangul_U",
"Hangul_WA",
"Hangul_WAE",
"Hangul_WE",
"Hangul_WEO",
"Hangul_WI",
"Hangul_YA",
"Hangul_YAE",
"Hangul_YE",
"Hangul_YEO",
"Hangul_YI",
"Hangul_YO",
"Hangul_YU",
"Hangul_YeorinHieuh",
"Hangul_switch",
"Hankaku",
"Hcircumflex",
"Hebrew_switch",
"Help",
"Henkan",
"Henkan_Mode",
"Hibernate",
"Hiragana",
"Hiragana_Katakana",
"History",
"Home",
"HomePage",
"HotLinks",
"Hstroke",
"Hyper_L",
"Hyper_R",
"I",
"ISO_Center_Object",
"ISO_Continuous_Underline",
"ISO_Discontinuous_Underline",
"ISO_Emphasize",
"ISO_Enter",
"ISO_Fast_Cursor_Down",
"ISO_Fast_Cursor_Left",
"ISO_Fast_Cursor_Right",
"ISO_Fast_Cursor_Up",
"ISO_First_Group",
"ISO_First_Group_Lock",
"ISO_Group_Latch",
"ISO_Group_Lock",
"ISO_Group_Shift",
"ISO_Last_Group",
"ISO_Last_Group_Lock",
"ISO_Left_Tab",
"ISO_Level2_Latch",
"ISO_Level3_Latch",
"ISO_Level3_Lock",
"ISO_Level3_Shift",
"ISO_Level5_Latch",
"ISO_Level5_Lock",
"ISO_Level5_Shift",
"ISO_Lock",
"ISO_Move_Line_Down",
"ISO_Move_Line_Up",
"ISO_Next_Group",
"ISO_Next_Group_Lock",
"ISO_Partial_Line_Down",
"ISO_Partial_Line_Up",
"ISO_Partial_Space_Left",
"ISO_Partial_Space_Right",
"ISO_Prev_Group",
"ISO_Prev_Group_Lock",
"ISO_Release_Both_Margins",
"ISO_Release_Margin_Left",
"ISO_Release_Margin_Right",
"ISO_Set_Margin_Left",
"ISO_Set_Margin_Right",
"Iabovedot",
"Iacute",
"Ibelowdot",
"Ibreve",
"Icircumflex",
"Idiaeresis",
"Igrave",
"Ihook",
"Imacron",
"Insert",
"Iogonek",
"Itilde",
"J",
"Jcircumflex",
"K",
"KP_0",
"KP_1",
"KP_2",
"KP_3",
"KP_4",
"KP_5",
"KP_6",
"KP_7",
"KP_8",
"KP_9",
"KP_Add",
"KP_Begin",
"KP_Decimal",
"KP_Delete",
"KP_Divide",
"KP_Down",
"KP_End",
"KP_Enter",
"KP_Equal",
"KP_F1",
"KP_F2",
"KP_F3",
"KP_F4",
"KP_Home",
"KP_Insert",
"KP_Left",
"KP_Multiply",
"KP_Next",
"KP_Page_Down",
"KP_Page_Up",
"KP_Prior",
"KP_Right",
"KP_Separator",
"KP_Space",
"KP_Subtract",
"KP_Tab",
"KP_Up",
"Kana_Lock",
"Kana_Shift",
"Kanji",
"Kanji_Bangou",
"Katakana",
"KbdBrightnessDown",
"KbdBrightnessUp",
"KbdLightOnOff",
"Kcedilla",
"Korean_Won",
"L",
"L1",
"L10",
"L2",
"L3",
"L4",
"L5",
"L6",
"L7",
"L8",
"L9",
"Lacute",
"Last_Virtual_Screen",
"Launch0",
"Launch1",
"Launch2",
"Launch3",
"Launch4",
"Launch5",
"Launch6",
"Launch7",
"Launch8",
"Launch9",
"LaunchA",
"LaunchB",
"LaunchC",
"LaunchD",
"LaunchE",
"LaunchF",
"Lbelowdot",
"Lcaron",
"Lcedilla",
"Left",
"LightBulb",
"Linefeed",
"LiraSign",
"LogGrabInfo",
"LogOff",
"LogWindowTree",
"Lstroke",
"M",
"Mabovedot",
"Macedonia_DSE",
"Macedonia_GJE",
"Macedonia_KJE",
"Macedonia_dse",
"Macedonia_gje",
"Macedonia_kje",
"Mae_Koho",
"Mail",
"MailForward",
"Market",
"Massyo",
"Meeting",
"Memo",
"Menu",
"MenuKB",
"MenuPB",
"Messenger",
"Meta_L",
"Meta_R",
"MillSign",
"Mode_switch",
"MonBrightnessDown",
"MonBrightnessUp",
"MouseKeys_Accel_Enable",
"MouseKeys_Enable",
"Muhenkan",
"Multi_key",
"MultipleCandidate",
"Music",
"MyComputer",
"MySites",
"N",
"Nacute",
"NairaSign",
"Ncaron",
"Ncedilla",
"New",
"NewSheqelSign",
"News",
"Next",
"Next_VMode",
"Next_Virtual_Screen",
"None",
"Ntilde",
"Num_Lock",
"O",
"OE",
"Oacute",
"Obarred",
"Obelowdot",
"Ocaron",
"Ocircumflex",
"Ocircumflexacute",
"Ocircumflexbelowdot",
"Ocircumflexgrave",
"Ocircumflexhook",
"Ocircumflextilde",
"Odiaeresis",
"Odoubleacute",
"OfficeHome",
"Ograve",
"Ohook",
"Ohorn",
"Ohornacute",
"Ohornbelowdot",
"Ohorngrave",
"Ohornhook",
"Ohorntilde",
"Omacron",
"Ooblique",
"Open",
"OpenURL",
"Option",
"Oslash",
"Otilde",
"Overlay1_Enable",
"Overlay2_Enable",
"P",
"Pabovedot",
"Page_Down",
"Page_Up",
"Paste",
"Pause",
"PesetaSign",
"Phone",
"Pictures",
"Pointer_Accelerate",
"Pointer_Button1",
"Pointer_Button2",
"Pointer_Button3",
"Pointer_Button4",
"Pointer_Button5",
"Pointer_Button_Dflt",
"Pointer_DblClick1",
"Pointer_DblClick2",
"Pointer_DblClick3",
"Pointer_DblClick4",
"Pointer_DblClick5",
"Pointer_DblClick_Dflt",
"Pointer_DfltBtnNext",
"Pointer_DfltBtnPrev",
"Pointer_Down",
"Pointer_DownLeft",
"Pointer_DownRight",
"Pointer_Drag1",
"Pointer_Drag2",
"Pointer_Drag3",
"Pointer_Drag4",
"Pointer_Drag5",
"Pointer_Drag_Dflt",
"Pointer_EnableKeys",
"Pointer_Left",
"Pointer_Right",
"Pointer_Up",
"Pointer_UpLeft",
"Pointer_UpRight",
"PowerDown",
"PowerOff",
"Prev_VMode",
"Prev_Virtual_Screen",
"PreviousCandidate",
"Print",
"Prior",
"Q",
"R",
"R1",
"R10",
"R11",
"R12",
"R13",
"R14",
"R15",
"R2",
"R3",
"R4",
"R5",
"R6",
"R7",
"R8",
"R9",
"Racute",
"Rcaron",
"Rcedilla",
"Red",
"Redo",
"Refresh",
"Reload",
"RepeatKeys_Enable",
"Reply",
"Return",
"Right",
"RockerDown",
"RockerEnter",
"RockerUp",
"Romaji",
"RotateWindows",
"RotationKB",
"RotationPB",
"RupeeSign",
"S",
"SCHWA",
"Sabovedot",
"Sacute",
"Save",
"Scaron",
"Scedilla",
"Scircumflex",
"ScreenSaver",
"ScrollClick",
"ScrollDown",
"ScrollUp",
"Scroll_Lock",
"Search",
"Select",
"SelectButton",
"Send",
"Serbian_DJE",
"Serbian_DZE",
"Serbian_JE",
"Serbian_LJE",
"Serbian_NJE",
"Serbian_TSHE",
"Serbian_dje",
"Serbian_dze",
"Serbian_je",
"Serbian_lje",
"Serbian_nje",
"Serbian_tshe",
"Shift_L",
"Shift_Lock",
"Shift_R",
"Shop",
"SingleCandidate",
"Sinh_a",
"Sinh_aa",
"Sinh_aa2",
"Sinh_ae",
"Sinh_ae2",
"Sinh_aee",
"Sinh_aee2",
"Sinh_ai",
"Sinh_ai2",
"Sinh_al",
"Sinh_au",
"Sinh_au2",
"Sinh_ba",
"Sinh_bha",
"Sinh_ca",
"Sinh_cha",
"Sinh_dda",
"Sinh_ddha",
"Sinh_dha",
"Sinh_dhha",
"Sinh_e",
"Sinh_e2",
"Sinh_ee",
"Sinh_ee2",
"Sinh_fa",
"Sinh_ga",
"Sinh_gha",
"Sinh_h2",
"Sinh_ha",
"Sinh_i",
"Sinh_i2",
"Sinh_ii",
"Sinh_ii2",
"Sinh_ja",
"Sinh_jha",
"Sinh_jnya",
"Sinh_ka",
"Sinh_kha",
"Sinh_kunddaliya",
"Sinh_la",
"Sinh_lla",
"Sinh_lu",
"Sinh_lu2",
"Sinh_luu",
"Sinh_luu2",
"Sinh_ma",
"Sinh_mba",
"Sinh_na",
"Sinh_ndda",
"Sinh_ndha",
"Sinh_ng",
"Sinh_ng2",
"Sinh_nga",
"Sinh_nja",
"Sinh_nna",
"Sinh_nya",
"Sinh_o",
"Sinh_o2",
"Sinh_oo",
"Sinh_oo2",
"Sinh_pa",
"Sinh_pha",
"Sinh_ra",
"Sinh_ri",
"Sinh_rii",
"Sinh_ru2",
"Sinh_ruu2",
"Sinh_sa",
"Sinh_sha",
"Sinh_ssha",
"Sinh_tha",
"Sinh_thha",
"Sinh_tta",
"Sinh_ttha",
"Sinh_u",
"Sinh_u2",
"Sinh_uu",
"Sinh_uu2",
"Sinh_va",
"Sinh_ya",
"Sleep",
"SlowKeys_Enable",
"Spell",
"SplitScreen",
"Standby",
"Start",
"StickyKeys_Enable",
"Stop",
"Subtitle",
"Super_L",
"Super_R",
"Support",
"Suspend",
"Switch_VT_1",
"Switch_VT_10",
"Switch_VT_11",
"Switch_VT_12",
"Switch_VT_2",
"Switch_VT_3",
"Switch_VT_4",
"Switch_VT_5",
"Switch_VT_6",
"Switch_VT_7",
"Switch_VT_8",
"Switch_VT_9",
"Sys_Req",
"T",
"THORN",
"Tab",
"Tabovedot",
"TaskPane",
"Tcaron",
"Tcedilla",
"Terminal",
"Terminate_Server",
"Thai_baht",
"Thai_bobaimai",
"Thai_chochan",
"Thai_chochang",
"Thai_choching",
"Thai_chochoe",
"Thai_dochada",
"Thai_dodek",
"Thai_fofa",
"Thai_fofan",
"Thai_hohip",
"Thai_honokhuk",
"Thai_khokhai",
"Thai_khokhon",
"Thai_khokhuat",
"Thai_khokhwai",
"Thai_khorakhang",
"Thai_kokai",
"Thai_lakkhangyao",
"Thai_lekchet",
"Thai_lekha",
"Thai_lekhok",
"Thai_lekkao",
"Thai_leknung",
"Thai_lekpaet",
"Thai_leksam",
"Thai_leksi",
"Thai_leksong",
"Thai_leksun",
"Thai_lochula",
"Thai_loling",
"Thai_lu",
"Thai_maichattawa",
"Thai_maiek",
"Thai_maihanakat",
"Thai_maihanakat_maitho",
"Thai_maitaikhu",
"Thai_maitho",
"Thai_maitri",
"Thai_maiyamok",
"Thai_moma",
"Thai_ngongu",
"Thai_nikhahit",
"Thai_nonen",
"Thai_nonu",
"Thai_oang",
"Thai_paiyannoi",
"Thai_phinthu",
"Thai_phophan",
"Thai_phophung",
"Thai_phosamphao",
"Thai_popla",
"Thai_rorua",
"Thai_ru",
"Thai_saraa",
"Thai_saraaa",
"Thai_saraae",
"Thai_saraaimaimalai",
"Thai_saraaimaimuan",
"Thai_saraam",
"Thai_sarae",
"Thai_sarai",
"Thai_saraii",
"Thai_sarao",
"Thai_sarau",
"Thai_saraue",
"Thai_sarauee",
"Thai_sarauu",
"Thai_sorusi",
"Thai_sosala",
"Thai_soso",
"Thai_sosua",
"Thai_thanthakhat",
"Thai_thonangmontho",
"Thai_thophuthao",
"Thai_thothahan",
"Thai_thothan",
"Thai_thothong",
"Thai_thothung",
"Thai_topatak",
"Thai_totao",
"Thai_wowaen",
"Thai_yoyak",
"Thai_yoying",
"Thorn",
"Time",
"ToDoList",
"Tools",
"TopMenu",
"TouchpadOff",
"TouchpadOn",
"TouchpadToggle",
"Touroku",
"Travel",
"Tslash",
"U",
"Uacute",
"Ubelowdot",
"Ubreve",
"Ucircumflex",
"Udiaeresis",
"Udoubleacute",
"Ugrave",
"Uhook",
"Uhorn",
"Uhornacute",
"Uhornbelowdot",
"Uhorngrave",
"Uhornhook",
"Uhorntilde",
"Ukrainian_GHE_WITH_UPTURN",
"Ukrainian_I",
"Ukrainian_IE",
"Ukrainian_YI",
"Ukrainian_ghe_with_upturn",
"Ukrainian_i",
"Ukrainian_ie",
"Ukrainian_yi",
"Ukranian_I",
"Ukranian_JE",
"Ukranian_YI",
"Ukranian_i",
"Ukranian_je",
"Ukranian_yi",
"Umacron",
"Undo",
"Ungrab",
"Uogonek",
"Up",
"Uring",
"User1KB",
"User2KB",
"UserPB",
"Utilde",
"V",
"VendorHome",
"Video",
"View",
"VoidSymbol",
"W",
"WLAN",
"WWW",
"Wacute",
"WakeUp",
"Wcircumflex",
"Wdiaeresis",
"WebCam",
"Wgrave",
"WheelButton",
"WindowClear",
"WindowClearGrab",
"WonSign",
"Word",
"X",
"Xabovedot",
"Xfer",
"Y",
"Yacute",
"Ybelowdot",
"Ycircumflex",
"Ydiaeresis",
"Yellow",
"Ygrave",
"Yhook",
"Ytilde",
"Z",
"Zabovedot",
"Zacute",
"Zcaron",
"Zen_Koho",
"Zenkaku",
"Zenkaku_Hankaku",
"ZoomIn",
"ZoomOut",
"Zstroke",
"a",
"aacute",
"abelowdot",
"abovedot",
"abreve",
"abreveacute",
"abrevebelowdot",
"abrevegrave",
"abrevehook",
"abrevetilde",
"acircumflex",
"acircumflexacute",
"acircumflexbelowdot",
"acircumflexgrave",
"acircumflexhook",
"acircumflextilde",
"acute",
"adiaeresis",
"ae",
"agrave",
"ahook",
"amacron",
"ampersand",
"aogonek",
"apostrophe",
"approxeq",
"approximate",
"aring",
"asciicircum",
"asciitilde",
"asterisk",
"at",
"atilde",
"b",
"babovedot",
"backslash",
"ballotcross",
"bar",
"because",
"blank",
"botintegral",
"botleftparens",
"botleftsqbracket",
"botleftsummation",
"botrightparens",
"botrightsqbracket",
"botrightsummation",
"bott",
"botvertsummationconnector",
"braceleft",
"braceright",
"bracketleft",
"bracketright",
"braille_blank",
"braille_dot_1",
"braille_dot_10",
"braille_dot_2",
"braille_dot_3",
"braille_dot_4",
"braille_dot_5",
"braille_dot_6",
"braille_dot_7",
"braille_dot_8",
"braille_dot_9",
"braille_dots_1",
"braille_dots_12",
"braille_dots_123",
"braille_dots_1234",
"braille_dots_12345",
"braille_dots_123456",
"braille_dots_1234567",
"braille_dots_12345678",
"braille_dots_1234568",
"braille_dots_123457",
"braille_dots_1234578",
"braille_dots_123458",
"braille_dots_12346",
"braille_dots_123467",
"braille_dots_1234678",
"braille_dots_123468",
"braille_dots_12347",
"braille_dots_123478",
"braille_dots_12348",
"braille_dots_1235",
"braille_dots_12356",
"braille_dots_123567",
"braille_dots_1235678",
"braille_dots_123568",
"braille_dots_12357",
"braille_dots_123578",
"braille_dots_12358",
"braille_dots_1236",
"braille_dots_12367",
"braille_dots_123678",
"braille_dots_12368",
"braille_dots_1237",
"braille_dots_12378",
"braille_dots_1238",
"braille_dots_124",
"braille_dots_1245",
"braille_dots_12456",
"braille_dots_124567",
"braille_dots_1245678",
"braille_dots_124568",
"braille_dots_12457",
"braille_dots_124578",
"braille_dots_12458",
"braille_dots_1246",
"braille_dots_12467",
"braille_dots_124678",
"braille_dots_12468",
"braille_dots_1247",
"braille_dots_12478",
"braille_dots_1248",
"braille_dots_125",
"braille_dots_1256",
"braille_dots_12567",
"braille_dots_125678",
"braille_dots_12568",
"braille_dots_1257",
"braille_dots_12578",
"braille_dots_1258",
"braille_dots_126",
"braille_dots_1267",
"braille_dots_12678",
"braille_dots_1268",
"braille_dots_127",
"braille_dots_1278",
"braille_dots_128",
"braille_dots_13",
"braille_dots_134",
"braille_dots_1345",
"braille_dots_13456",
"braille_dots_134567",
"braille_dots_1345678",
"braille_dots_134568",
"braille_dots_13457",
"braille_dots_134578",
"braille_dots_13458",
"braille_dots_1346",
"braille_dots_13467",
"braille_dots_134678",
"braille_dots_13468",
"braille_dots_1347",
"braille_dots_13478",
"braille_dots_1348",
"braille_dots_135",
"braille_dots_1356",
"braille_dots_13567",
"braille_dots_135678",
"braille_dots_13568",
"braille_dots_1357",
"braille_dots_13578",
"braille_dots_1358",
"braille_dots_136",
"braille_dots_1367",
"braille_dots_13678",
"braille_dots_1368",
"braille_dots_137",
"braille_dots_1378",
"braille_dots_138",
"braille_dots_14",
"braille_dots_145",
"braille_dots_1456",
"braille_dots_14567",
"braille_dots_145678",
"braille_dots_14568",
"braille_dots_1457",
"braille_dots_14578",
"braille_dots_1458",
"braille_dots_146",
"braille_dots_1467",
"braille_dots_14678",
"braille_dots_1468",
"braille_dots_147",
"braille_dots_1478",
"braille_dots_148",
"braille_dots_15",
"braille_dots_156",
"braille_dots_1567",
"braille_dots_15678",
"braille_dots_1568",
"braille_dots_157",
"braille_dots_1578",
"braille_dots_158",
"braille_dots_16",
"braille_dots_167",
"braille_dots_1678",
"braille_dots_168",
"braille_dots_17",
"braille_dots_178",
"braille_dots_18",
"braille_dots_2",
"braille_dots_23",
"braille_dots_234",
"braille_dots_2345",
"braille_dots_23456",
"braille_dots_234567",
"braille_dots_2345678",
"braille_dots_234568",
"braille_dots_23457",
"braille_dots_234578",
"braille_dots_23458",
"braille_dots_2346",
"braille_dots_23467",
"braille_dots_234678",
"braille_dots_23468",
"braille_dots_2347",
"braille_dots_23478",
"braille_dots_2348",
"braille_dots_235",
"braille_dots_2356",
"braille_dots_23567",
"braille_dots_235678",
"braille_dots_23568",
"braille_dots_2357",
"braille_dots_23578",
"braille_dots_2358",
"braille_dots_236",
"braille_dots_2367",
"braille_dots_23678",
"braille_dots_2368",
"braille_dots_237",
"braille_dots_2378",
"braille_dots_238",
"braille_dots_24",
"braille_dots_245",
"braille_dots_2456",
"braille_dots_24567",
"braille_dots_245678",
"braille_dots_24568",
"braille_dots_2457",
"braille_dots_24578",
"braille_dots_2458",
"braille_dots_246",
"braille_dots_2467",
"braille_dots_24678",
"braille_dots_2468",
"braille_dots_247",
"braille_dots_2478",
"braille_dots_248",
"braille_dots_25",
"braille_dots_256",
"braille_dots_2567",
"braille_dots_25678",
"braille_dots_2568",
"braille_dots_257",
"braille_dots_2578",
"braille_dots_258",
"braille_dots_26",
"braille_dots_267",
"braille_dots_2678",
"braille_dots_268",
"braille_dots_27",
"braille_dots_278",
"braille_dots_28",
"braille_dots_3",
"braille_dots_34",
"braille_dots_345",
"braille_dots_3456",
"braille_dots_34567",
"braille_dots_345678",
"braille_dots_34568",
"braille_dots_3457",
"braille_dots_34578",
"braille_dots_3458",
"braille_dots_346",
"braille_dots_3467",
"braille_dots_34678",
"braille_dots_3468",
"braille_dots_347",
"braille_dots_3478",
"braille_dots_348",
"braille_dots_35",
"braille_dots_356",
"braille_dots_3567",
"braille_dots_35678",
"braille_dots_3568",
"braille_dots_357",
"braille_dots_3578",
"braille_dots_358",
"braille_dots_36",
"braille_dots_367",
"braille_dots_3678",
"braille_dots_368",
"braille_dots_37",
"braille_dots_378",
"braille_dots_38",
"braille_dots_4",
"braille_dots_45",
"braille_dots_456",
"braille_dots_4567",
"braille_dots_45678",
"braille_dots_4568",
"braille_dots_457",
"braille_dots_4578",
"braille_dots_458",
"braille_dots_46",
"braille_dots_467",
"braille_dots_4678",
"braille_dots_468",
"braille_dots_47",
"braille_dots_478",
"braille_dots_48",
"braille_dots_5",
"braille_dots_56",
"braille_dots_567",
"braille_dots_5678",
"braille_dots_568",
"braille_dots_57",
"braille_dots_578",
"braille_dots_58",
"braille_dots_6",
"braille_dots_67",
"braille_dots_678",
"braille_dots_68",
"braille_dots_7",
"braille_dots_78",
"braille_dots_8",
"breve",
"brokenbar",
"c",
"c_h",
"cabovedot",
"cacute",
"careof",
"caret",
"caron",
"ccaron",
"ccedilla",
"ccircumflex",
"cedilla",
"cent",
"ch",
"checkerboard",
"checkmark",
"circle",
"club",
"colon",
"comma",
"containsas",
"copyright",
"cr",
"crossinglines",
"cuberoot",
"currency",
"cursor",
"d",
"dabovedot",
"dagger",
"dcaron",
"dead_A",
"dead_E",
"dead_I",
"dead_O",
"dead_U",
"dead_a",
"dead_abovecomma",
"dead_abovedot",
"dead_abovereversedcomma",
"dead_abovering",
"dead_aboveverticalline",
"dead_acute",
"dead_belowbreve",
"dead_belowcircumflex",
"dead_belowcomma",
"dead_belowdiaeresis",
"dead_belowdot",
"dead_belowmacron",
"dead_belowring",
"dead_belowtilde",
"dead_belowverticalline",
"dead_breve",
"dead_capital_schwa",
"dead_caron",
"dead_cedilla",
"dead_circumflex",
"dead_currency",
"dead_dasia",
"dead_diaeresis",
"dead_doubleacute",
"dead_doublegrave",
"dead_e",
"dead_grave",
"dead_greek",
"dead_hook",
"dead_horn",
"dead_i",
"dead_invertedbreve",
"dead_iota",
"dead_longsolidusoverlay",
"dead_lowline",
"dead_macron",
"dead_o",
"dead_ogonek",
"dead_perispomeni",
"dead_psili",
"dead_semivoiced_sound",
"dead_small_schwa",
"dead_stroke",
"dead_tilde",
"dead_u",
"dead_voiced_sound",
"decimalpoint",
"degree",
"diaeresis",
"diamond",
"digitspace",
"dintegral",
"division",
"dollar",
"doubbaselinedot",
"doubleacute",
"doubledagger",
"doublelowquotemark",
"downarrow",
"downcaret",
"downshoe",
"downstile",
"downtack",
"dstroke",
"e",
"eabovedot",
"eacute",
"ebelowdot",
"ecaron",
"ecircumflex",
"ecircumflexacute",
"ecircumflexbelowdot",
"ecircumflexgrave",
"ecircumflexhook",
"ecircumflextilde",
"ediaeresis",
"egrave",
"ehook",
"eightsubscript",
"eightsuperior",
"elementof",
"ellipsis",
"em3space",
"em4space",
"emacron",
"emdash",
"emfilledcircle",
"emfilledrect",
"emopencircle",
"emopenrectangle",
"emptyset",
"emspace",
"endash",
"enfilledcircbullet",
"enfilledsqbullet",
"eng",
"enopencircbullet",
"enopensquarebullet",
"enspace",
"eogonek",
"equal",
"eth",
"etilde",
"exclam",
"exclamdown",
"ezh",
"f",
"fabovedot",
"femalesymbol",
"ff",
"figdash",
"filledlefttribullet",
"filledrectbullet",
"filledrighttribullet",
"filledtribulletdown",
"filledtribulletup",
"fiveeighths",
"fivesixths",
"fivesubscript",
"fivesuperior",
"fourfifths",
"foursubscript",
"foursuperior",
"fourthroot",
"function",
"g",
"gabovedot",
"gbreve",
"gcaron",
"gcedilla",
"gcircumflex",
"grave",
"greater",
"greaterthanequal",
"guillemotleft",
"guillemotright",
"h",
"hairspace",
"hcircumflex",
"heart",
"hebrew_aleph",
"hebrew_ayin",
"hebrew_bet",
"hebrew_beth",
"hebrew_chet",
"hebrew_dalet",
"hebrew_daleth",
"hebrew_doublelowline",
"hebrew_finalkaph",
"hebrew_finalmem",
"hebrew_finalnun",
"hebrew_finalpe",
"hebrew_finalzade",
"hebrew_finalzadi",
"hebrew_gimel",
"hebrew_gimmel",
"hebrew_he",
"hebrew_het",
"hebrew_kaph",
"hebrew_kuf",
"hebrew_lamed",
"hebrew_mem",
"hebrew_nun",
"hebrew_pe",
"hebrew_qoph",
"hebrew_resh",
"hebrew_samech",
"hebrew_samekh",
"hebrew_shin",
"hebrew_taf",
"hebrew_taw",
"hebrew_tet",
"hebrew_teth",
"hebrew_waw",
"hebrew_yod",
"hebrew_zade",
"hebrew_zadi",
"hebrew_zain",
"hebrew_zayin",
"hexagram",
"horizconnector",
"horizlinescan1",
"horizlinescan3",
"horizlinescan5",
"horizlinescan7",
"horizlinescan9",
"hstroke",
"ht",
"hyphen",
"i",
"iTouch",
"iacute",
"ibelowdot",
"ibreve",
"icircumflex",
"identical",
"idiaeresis",
"idotless",
"ifonlyif",
"igrave",
"ihook",
"imacron",
"implies",
"includedin",
"includes",
"infinity",
"integral",
"intersection",
"iogonek",
"itilde",
"j",
"jcircumflex",
"jot",
"k",
"kana_A",
"kana_CHI",
"kana_E",
"kana_FU",
"kana_HA",
"kana_HE",
"kana_HI",
"kana_HO",
"kana_HU",
"kana_I",
"kana_KA",
"kana_KE",
"kana_KI",
"kana_KO",
"kana_KU",
"kana_MA",
"kana_ME",
"kana_MI",
"kana_MO",
"kana_MU",
"kana_N",
"kana_NA",
"kana_NE",
"kana_NI",
"kana_NO",
"kana_NU",
"kana_O",
"kana_RA",
"kana_RE",
"kana_RI",
"kana_RO",
"kana_RU",
"kana_SA",
"kana_SE",
"kana_SHI",
"kana_SO",
"kana_SU",
"kana_TA",
"kana_TE",
"kana_TI",
"kana_TO",
"kana_TSU",
"kana_TU",
"kana_U",
"kana_WA",
"kana_WO",
"kana_YA",
"kana_YO",
"kana_YU",
"kana_a",
"kana_closingbracket",
"kana_comma",
"kana_conjunctive",
"kana_e",
"kana_fullstop",
"kana_i",
"kana_middledot",
"kana_o",
"kana_openingbracket",
"kana_switch",
"kana_tsu",
"kana_tu",
"kana_u",
"kana_ya",
"kana_yo",
"kana_yu",
"kappa",
"kcedilla",
"kra",
"l",
"lacute",
"latincross",
"lbelowdot",
"lcaron",
"lcedilla",
"leftanglebracket",
"leftarrow",
"leftcaret",
"leftdoublequotemark",
"leftmiddlecurlybrace",
"leftopentriangle",
"leftpointer",
"leftradical",
"leftshoe",
"leftsinglequotemark",
"leftt",
"lefttack",
"less",
"lessthanequal",
"lf",
"logicaland",
"logicalor",
"lowleftcorner",
"lowrightcorner",
"lstroke",
"m",
"mabovedot",
"macron",
"malesymbol",
"maltesecross",
"marker",
"masculine",
"minus",
"minutes",
"mu",
"multiply",
"musicalflat",
"musicalsharp",
"n",
"nabla",
"nacute",
"ncaron",
"ncedilla",
"ninesubscript",
"ninesuperior",
"nl",
"nobreakspace",
"notapproxeq",
"notelementof",
"notequal",
"notidentical",
"notsign",
"ntilde",
"numbersign",
"numerosign",
"o",
"oacute",
"obarred",
"obelowdot",
"ocaron",
"ocircumflex",
"ocircumflexacute",
"ocircumflexbelowdot",
"ocircumflexgrave",
"ocircumflexhook",
"ocircumflextilde",
"odiaeresis",
"odoubleacute",
"oe",
"ogonek",
"ograve",
"ohook",
"ohorn",
"ohornacute",
"ohornbelowdot",
"ohorngrave",
"ohornhook",
"ohorntilde",
"omacron",
"oneeighth",
"onefifth",
"onehalf",
"onequarter",
"onesixth",
"onesubscript",
"onesuperior",
"onethird",
"ooblique",
"openrectbullet",
"openstar",
"opentribulletdown",
"opentribulletup",
"ordfeminine",
"oslash",
"otilde",
"overbar",
"overline",
"p",
"pabovedot",
"paragraph",
"parenleft",
"parenright",
"partdifferential",
"partialderivative",
"percent",
"period",
"periodcentered",
"permille",
"phonographcopyright",
"plus",
"plusminus",
"prescription",
"prolongedsound",
"punctspace",
"q",
"quad",
"question",
"questiondown",
"quotedbl",
"quoteleft",
"quoteright",
"r",
"racute",
"radical",
"rcaron",
"rcedilla",
"registered",
"rightanglebracket",
"rightarrow",
"rightcaret",
"rightdoublequotemark",
"rightmiddlecurlybrace",
"rightmiddlesummation",
"rightopentriangle",
"rightpointer",
"rightshoe",
"rightsinglequotemark",
"rightt",
"righttack",
"s",
"sabovedot",
"sacute",
"scaron",
"scedilla",
"schwa",
"scircumflex",
"script_switch",
"seconds",
"section",
"semicolon",
"semivoicedsound",
"seveneighths",
"sevensubscript",
"sevensuperior",
"signaturemark",
"signifblank",
"similarequal",
"singlelowquotemark",
"sixsubscript",
"sixsuperior",
"slash",
"soliddiamond",
"space",
"squareroot",
"ssharp",
"sterling",
"stricteq",
"t",
"tabovedot",
"tcaron",
"tcedilla",
"telephone",
"telephonerecorder",
"therefore",
"thinspace",
"thorn",
"threeeighths",
"threefifths",
"threequarters",
"threesubscript",
"threesuperior",
"tintegral",
"topintegral",
"topleftparens",
"topleftradical",
"topleftsqbracket",
"topleftsummation",
"toprightparens",
"toprightsqbracket",
"toprightsummation",
"topt",
"topvertsummationconnector",
"trademark",
"trademarkincircle",
"tslash",
"twofifths",
"twosubscript",
"twosuperior",
"twothirds",
"u",
"uacute",
"ubelowdot",
"ubreve",
"ucircumflex",
"udiaeresis",
"udoubleacute",
"ugrave",
"uhook",
"uhorn",
"uhornacute",
"uhornbelowdot",
"uhorngrave",
"uhornhook",
"uhorntilde",
"umacron",
"underbar",
"underscore",
"union",
"uogonek",
"uparrow",
"upcaret",
"upleftcorner",
"uprightcorner",
"upshoe",
"upstile",
"uptack",
"uring",
"utilde",
"v",
"variation",
"vertbar",
"vertconnector",
"voicedsound",
"vt",
"w",
"wacute",
"wcircumflex",
"wdiaeresis",
"wgrave",
"x",
"xabovedot",
"y",
"yacute",
"ybelowdot",
"ycircumflex",
"ydiaeresis",
"yen",
"ygrave",
"yhook",
"ytilde",
"z",
"zabovedot",
"zacute",
"zcaron",
"zerosubscript",
"zerosuperior",
"zstroke",
};

static const uint32_t keyValueByNameOffset[] _FCITX_UNUSED_ =
{
0x0030,
0x0031,
0x0032,
0x0033,
0xfd10,
0xfd0e,
0xfd05,
0xfd19,
0xfd15,
0xfd0f,
0xfd1c,
0xfd1a,
0xfd01,
0xfd1e,
0xfd06,
0xfd07,
0xfd1b,
0xfd02,
0xfd13,
0xfd12,
0xfd11,
0xfd04,
0xfd0a,
0xfd0b,
0xfd0c,
0xfd16,
0xfd1d,
0xfd09,
0xfd18,
0xfd08,
0xfd03,
0xfd14,
0xfd17,
0xfd0d,
0x0034,
0x0035,
0x0036,
0x0037,
0x0038,
0x0039,
0x0041,
0x00c6,
0x00c1,
0x1001ea0,
0x01c3,
0x1001eae,
0x1001eb6,
0x1001eb0,
0x1001eb2,
0x1001eb4,
0xfe70,
0xfe71,
0x00c2,
0x1001ea4,
0x1001eac,
0x1001ea6,
0x1001ea8,
0x1001eaa,
0x1008ff39,
0x00c4,
0x00c0,
0x1001ea2,
0xffe9,
0xffea,
0x03c0,
0x01a1,
0x1008ff50,
0x1008ff51,
0x1000660,
0x1000661,
0x1000662,
0x1000663,
0x1000664,
0x1000665,
0x1000666,
0x1000667,
0x1000668,
0x1000669,
0x05d9,
0x05c7,
0x05e9,
0x05c8,
0x05ac,
0x05d6,
0x05cf,
0x05ef,
0x05ec,
0x1000688,
0x10006cc,
0x05ee,
0x05eb,
0x05e1,
0x10006d4,
0x10006af,
0x05da,
0x05e7,
0x05cd,
0x05c1,
0x1000654,
0x1000655,
0x05c3,
0x05c4,
0x05c6,
0x05c5,
0x05e7,
0x10006be,
0x10006c1,
0x05cc,
0x1000698,
0x05e3,
0x05f0,
0x05ed,
0x10006a9,
0x05ce,
0x05e4,
0x1000653,
0x05c2,
0x05e5,
0x05e6,
0x10006ba,
0x100067e,
0x100066a,
0x05e2,
0x05bf,
0x05d1,
0x1000691,
0x05d5,
0x05d3,
0x05bb,
0x05f1,
0x05d4,
0x05f2,
0x1000670,
0xff7e,
0x05d7,
0x05e0,
0x1000686,
0x05ca,
0x05c9,
0x05d0,
0x05cb,
0x1000679,
0x10006a4,
0x05e8,
0x05ea,
0x10006d2,
0x05d8,
0x05d2,
0x00c5,
0x1000538,
0x1000531,
0x1000532,
0x1000549,
0x1000534,
0x1000541,
0x1000537,
0x1000556,
0x1000542,
0x1000533,
0x1000545,
0x1000540,
0x100053b,
0x100054b,
0x1000554,
0x100053f,
0x100053d,
0x100053c,
0x1000544,
0x1000546,
0x1000555,
0x100054a,
0x1000553,
0x100054c,
0x1000550,
0x100054d,
0x1000547,
0x1000543,
0x1000539,
0x100053e,
0x1000551,
0x100054f,
0x100054e,
0x1000548,
0x1000552,
0x1000535,
0x1000536,
0x100053a,
0x100055b,
0x100055c,
0x100055a,
0x1000568,
0x1000561,
0x1000562,
0x100055d,
0x1000579,
0x1000564,
0x1000571,
0x1000567,
0x100055c,
0x1000586,
0x1000589,
0x1000572,
0x1000563,
0x1000575,
0x1000570,
0x100058a,
0x100056b,
0x100057b,
0x1000584,
0x100056f,
0x100056d,
0x1000587,
0x100056c,
0x1000574,
0x1000576,
0x1000585,
0x100055e,
0x100057a,
0x1000583,
0x100055e,
0x100057c,
0x1000580,
0x100057d,
0x100055d,
0x1000577,
0x100055b,
0x1000573,
0x1000569,
0x100056e,
0x1000581,
0x100057f,
0x1000589,
0x100057e,
0x1000578,
0x1000582,
0x1000565,
0x100058a,
0x1000566,
0x100056a,
0x00c3,
0xfe7a,
0x1008ff9b,
0x1008ff97,
0x1008ff11,
0x1008ff32,
0x1008ffb2,
0x1008ff12,
0x1008ff17,
0x1008ff31,
0x1008ff14,
0x1008ff16,
0x1008ff13,
0x1008ff99,
0x1008ff1c,
0x1008ff98,
0x1008ff3e,
0x1008ff15,
0x1008ff8d,
0x0042,
0x1001e02,
0x1008ff26,
0x1008ff3f,
0xff08,
0x1008ff93,
0xff58,
0x1008ffa6,
0x1008ff94,
0x1008ff52,
0xfe74,
0xff6b,
0x1008ff3b,
0x06be,
0x06ae,
0x0043,
0x1008ff53,
0xfea2,
0xfea5,
0xfea4,
0x02c5,
0x01c6,
0x1008ff1d,
0x1008ff20,
0xff69,
0xffe5,
0x01c8,
0x00c7,
0x02c6,
0xfea1,
0xff0b,
0x1008ff56,
0xff37,
0x10020a1,
0x1008ff3d,
0x1008ff22,
0xffe3,
0xffe4,
0x1008ff57,
0x10020a2,
0x1008ff58,
0x1008ff9c,
0x06e1,
0x06e2,
0x06fe,
0x10004b6,
0x10004b8,
0x06e4,
0x06bf,
0x06fc,
0x06e6,
0x06ec,
0x06ed,
0x06ee,
0x10004a2,
0x06f2,
0x06f3,
0x06e7,
0x1000492,
0x06e8,
0x06ff,
0x10004b2,
0x06e9,
0x06e5,
0x06b3,
0x10004e2,
0x06b8,
0x06eb,
0x100049a,
0x100049c,
0x06b9,
0x06ba,
0x06ef,
0x10004e8,
0x06f0,
0x10004d8,
0x06fb,
0x06fd,
0x10004ba,
0x06ea,
0x06f8,
0x06f4,
0x06e3,
0x06f5,
0x10004ee,
0x10004ae,
0x10004b0,
0x06f7,
0x06f1,
0x06f9,
0x06e0,
0x06fa,
0x06f6,
0x1000496,
0x06c1,
0x06c2,
0x06de,
0x10004b7,
0x10004b9,
0x06c4,
0x06af,
0x06dc,
0x06c6,
0x06cc,
0x06cd,
0x06ce,
0x10004a3,
0x06d2,
0x06d3,
0x06c7,
0x1000493,
0x06c8,
0x10004b3,
0x06df,
0x06c9,
0x10004e3,
0x06c5,
0x06a3,
0x06a8,
0x06cb,
0x100049b,
0x100049d,
0x06a9,
0x06aa,
0x06cf,
0x10004e9,
0x06d0,
0x10004d9,
0x06db,
0x06dd,
0x10004bb,
0x06ca,
0x06d8,
0x06d4,
0x06c3,
0x06d5,
0x10004ef,
0x10004af,
0x10004b1,
0x06d7,
0x06d1,
0x06d9,
0x06c0,
0x06da,
0x06d6,
0x1000497,
0x0044,
0x1008ff5a,
0x1001e0a,
0x01cf,
0xffff,
0x1008ff59,
0x1008ff5b,
0x10020ab,
0xff54,
0x01d0,
0x0045,
0x03bd,
0x00d0,
0x10001b7,
0x03cc,
0x00c9,
0x1001eb8,
0x01cc,
0x00ca,
0x1001ebe,
0x1001ec6,
0x1001ec0,
0x1001ec2,
0x1001ec4,
0x10020a0,
0x00cb,
0x00c8,
0x1001eba,
0xff2f,
0xff30,
0x1008ff2c,
0x03aa,
0xff57,
0x01ca,
0xff1b,
0x00d0,
0x1001ebc,
0x20ac,
0x1008ff5c,
0xff62,
0x1008ff5d,
0x0046,
0xffbe,
0xffc7,
0xffc8,
0xffc9,
0xffca,
0xffcb,
0xffcc,
0xffcd,
0xffce,
0xffcf,
0xffd0,
0xffbf,
0xffd1,
0xffd2,
0xffd3,
0xffd4,
0xffd5,
0xffd6,
0xffd7,
0xffd8,
0xffd9,
0xffda,
0xffc0,
0xffdb,
0xffdc,
0xffdd,
0xffde,
0xffdf,
0xffe0,
0xffc1,
0xffc2,
0xffc3,
0xffc4,
0xffc5,
0xffc6,
0x10020a3,
0x1001e1e,
0x10006f0,
0x10006f1,
0x10006f2,
0x10006f3,
0x10006f4,
0x10006f5,
0x10006f6,
0x10006f7,
0x10006f8,
0x10006f9,
0x10006cc,
0x1008ff30,
0x1008ff3c,
0xff68,
0xfed0,
0x1008ff27,
0x1008ff9d,
0x1008ff9e,
0x0047,
0x02d5,
0x1008ff5e,
0x02ab,
0x10001e6,
0x03ab,
0x02d8,
0x10010d0,
0x10010d1,
0x10010ea,
0x10010ed,
0x10010e9,
0x10010ec,
0x10010d3,
0x10010d4,
0x10010f6,
0x10010d2,
0x10010e6,
0x10010f0,
0x10010f4,
0x10010f1,
0x10010f2,
0x10010f5,
0x10010d8,
0x10010ef,
0x10010eb,
0x10010d9,
0x10010e5,
0x10010da,
0x10010db,
0x10010dc,
0x10010dd,
0x10010de,
0x10010e4,
0x10010e7,
0x10010e0,
0x10010e1,
0x10010e8,
0x10010d7,
0x10010e2,
0x10010e3,
0x10010d5,
0x10010f3,
0x10010ee,
0x10010d6,
0x10010df,
0x1008ff5f,
0x07c1,
0x07a1,
0x07c2,
0x07d7,
0x07c4,
0x07c5,
0x07a2,
0x07c7,
0x07a3,
0x07c3,
0x07c9,
0x07a4,
0x07a5,
0x07a5,
0x07ca,
0x07cb,
0x07cb,
0x07cc,
0x07cd,
0x07d9,
0x07ab,
0x07cf,
0x07a7,
0x07d6,
0x07d0,
0x07d8,
0x07d1,
0x07d2,
0x07d4,
0x07c8,
0x07d5,
0x07a8,
0x07a9,
0x07ce,
0x07c6,
0x07ae,
0x07e1,
0x07b1,
0x07e2,
0x07f7,
0x07e4,
0x07e5,
0x07b2,
0x07e7,
0x07b3,
0x07f3,
0x07e3,
0x07af,
0x07e9,
0x07b4,
0x07b6,
0x07b5,
0x07ea,
0x07eb,
0x07eb,
0x07ec,
0x07ed,
0x07f9,
0x07bb,
0x07ef,
0x07b7,
0x07f6,
0x07f0,
0x07f8,
0x07f1,
0x07f2,
0xff7e,
0x07f4,
0x07e8,
0x07f5,
0x07b8,
0x07ba,
0x07b9,
0x07ee,
0x07e6,
0x1008ffa4,
0x0048,
0xff31,
0x0ebf,
0x0ec0,
0x0ef6,
0x0ef7,
0xff39,
0x0eba,
0xff37,
0x0ea7,
0x0ec4,
0x0ec3,
0x0ed1,
0xff33,
0xff34,
0x0ebe,
0x0ed3,
0x0eb7,
0x0eea,
0x0eda,
0x0eee,
0x0ee8,
0x0ee9,
0x0eeb,
0x0ed4,
0x0ed6,
0x0ef9,
0x0ee3,
0x0ed7,
0x0ed9,
0x0ed8,
0x0ef8,
0x0eed,
0x0ee4,
0x0ee5,
0x0edb,
0x0ee2,
0x0edc,
0x0edd,
0x0ee1,
0x0ede,
0x0edf,
0x0ee0,
0x0ee6,
0x0ed5,
0x0ee7,
0x0eec,
0x0efa,
0xff35,
0xff38,
0x0eb8,
0x0ebb,
0x0ea1,
0x0ea3,
0x0ef3,
0x0eb1,
0xff3d,
0x0ea4,
0x0ea6,
0x0ea5,
0x0ec7,
0x0eca,
0x0ef2,
0x0ebd,
0x0eb2,
0x0eb4,
0xff3b,
0xff3a,
0xff3e,
0x0ea9,
0x0eb0,
0x0eaa,
0x0eab,
0x0eaf,
0x0eac,
0x0ead,
0x0eae,
0x0eef,
0xff36,
0xff3c,
0x0eb5,
0xff3f,
0x0ea8,
0x0eb9,
0x0ea2,
0x0eb3,
0x0eb6,
0xff32,
0x0ef0,
0x0ef4,
0x0ef1,
0x0ebc,
0x0ecc,
0x0ec8,
0x0ec9,
0x0ece,
0x0ecd,
0x0ecf,
0x0ec1,
0x0ec2,
0x0ec6,
0x0ec5,
0x0ed2,
0x0ecb,
0x0ed0,
0x0ef5,
0xff7e,
0xff29,
0x02a6,
0xff7e,
0xff6a,
0xff23,
0xff23,
0x1008ffa8,
0xff25,
0xff27,
0x1008ff37,
0xff50,
0x1008ff18,
0x1008ff3a,
0x02a1,
0xffed,
0xffee,
0x0049,
0xfe33,
0xfe30,
0xfe31,
0xfe32,
0xfe34,
0xfe2f,
0xfe2c,
0xfe2d,
0xfe2e,
0xfe0c,
0xfe0d,
0xfe06,
0xfe07,
0xff7e,
0xfe0e,
0xfe0f,
0xfe20,
0xfe02,
0xfe04,
0xfe05,
0xfe03,
0xfe12,
0xfe13,
0xfe11,
0xfe01,
0xfe22,
0xfe21,
0xfe08,
0xfe09,
0xfe24,
0xfe23,
0xfe25,
0xfe26,
0xfe0a,
0xfe0b,
0xfe2b,
0xfe29,
0xfe2a,
0xfe27,
0xfe28,
0x02a9,
0x00cd,
0x1001eca,
0x100012c,
0x00ce,
0x00cf,
0x00cc,
0x1001ec8,
0x03cf,
0xff63,
0x03c7,
0x03a5,
0x004a,
0x02ac,
0x004b,
0xffb0,
0xffb1,
0xffb2,
0xffb3,
0xffb4,
0xffb5,
0xffb6,
0xffb7,
0xffb8,
0xffb9,
0xffab,
0xff9d,
0xffae,
0xff9f,
0xffaf,
0xff99,
0xff9c,
0xff8d,
0xffbd,
0xff91,
0xff92,
0xff93,
0xff94,
0xff95,
0xff9e,
0xff96,
0xffaa,
0xff9b,
0xff9b,
0xff9a,
0xff9a,
0xff98,
0xffac,
0xff80,
0xffad,
0xff89,
0xff97,
0xff2d,
0xff2e,
0xff21,
0xff37,
0xff26,
0x1008ff06,
0x1008ff05,
0x1008ff04,
0x03d3,
0x0eff,
0x004c,
0xffc8,
0xffd1,
0xffc9,
0xffca,
0xffcb,
0xffcc,
0xffcd,
0xffce,
0xffcf,
0xffd0,
0x01c5,
0xfed4,
0x1008ff40,
0x1008ff41,
0x1008ff42,
0x1008ff43,
0x1008ff44,
0x1008ff45,
0x1008ff46,
0x1008ff47,
0x1008ff48,
0x1008ff49,
0x1008ff4a,
0x1008ff4b,
0x1008ff4c,
0x1008ff4d,
0x1008ff4e,
0x1008ff4f,
0x1001e36,
0x01a5,
0x03a6,
0xff51,
0x1008ff35,
0xff0a,
0x10020a4,
0x1008fe25,
0x1008ff61,
0x1008fe24,
0x01a3,
0x004d,
0x1001e40,
0x06b5,
0x06b2,
0x06bc,
0x06a5,
0x06a2,
0x06ac,
0xff3e,
0x1008ff19,
0x1008ff90,
0x1008ff62,
0xff2c,
0x1008ff63,
0x1008ff1e,
0xff67,
0x1008ff65,
0x1008ff66,
0x1008ff8e,
0xffe7,
0xffe8,
0x10020a5,
0xff7e,
0x1008ff03,
0x1008ff02,
0xfe77,
0xfe76,
0xff22,
0xff20,
0xff3d,
0x1008ff92,
0x1008ff33,
0x1008ff67,
0x004e,
0x01d1,
0x10020a6,
0x01d2,
0x03d1,
0x1008ff68,
0x10020aa,
0x1008ff69,
0xff56,
0x1008fe22,
0xfed2,
0x0,
0x00d1,
0xff7f,
0x004f,
0x13bc,
0x00d3,
0x100019f,
0x1001ecc,
0x10001d1,
0x00d4,
0x1001ed0,
0x1001ed8,
0x1001ed2,
0x1001ed4,
0x1001ed6,
0x00d6,
0x01d5,
0x1008ff6a,
0x00d2,
0x1001ece,
0x10001a0,
0x1001eda,
0x1001ee2,
0x1001edc,
0x1001ede,
0x1001ee0,
0x03d2,
0x00d8,
0x1008ff6b,
0x1008ff38,
0x1008ff6c,
0x00d8,
0x00d5,
0xfe78,
0xfe79,
0x0050,
0x1001e56,
0xff56,
0xff55,
0x1008ff6d,
0xff13,
0x10020a7,
0x1008ff6e,
0x1008ff91,
0xfefa,
0xfee9,
0xfeea,
0xfeeb,
0xfeec,
0xfeed,
0xfee8,
0xfeef,
0xfef0,
0xfef1,
0xfef2,
0xfef3,
0xfeee,
0xfefb,
0xfefc,
0xfee3,
0xfee6,
0xfee7,
0xfef5,
0xfef6,
0xfef7,
0xfef8,
0xfefd,
0xfef4,
0xfef9,
0xfee0,
0xfee1,
0xfee2,
0xfee4,
0xfee5,
0x1008ff21,
0x1008ff2a,
0x1008fe23,
0xfed1,
0xff3e,
0xff61,
0xff55,
0x0051,
0x0052,
0xffd2,
0xffdb,
0xffdc,
0xffdd,
0xffde,
0xffdf,
0xffe0,
0xffd3,
0xffd4,
0xffd5,
0xffd6,
0xffd7,
0xffd8,
0xffd9,
0xffda,
0x01c0,
0x01d8,
0x03a3,
0x1008ffa3,
0xff66,
0x1008ff29,
0x1008ff73,
0xfe72,
0x1008ff72,
0xff0d,
0xff53,
0x1008ff24,
0x1008ff25,
0x1008ff23,
0xff24,
0x1008ff74,
0x1008ff76,
0x1008ff75,
0x10020a8,
0x0053,
0x100018f,
0x1001e60,
0x01a6,
0x1008ff77,
0x01a9,
0x01aa,
0x02de,
0x1008ff2d,
0x1008ff7a,
0x1008ff79,
0x1008ff78,
0xff14,
0x1008ff1b,
0xff60,
0x1008ffa0,
0x1008ff7b,
0x06b1,
0x06bf,
0x06b8,
0x06b9,
0x06ba,
0x06bb,
0x06a1,
0x06af,
0x06a8,
0x06a9,
0x06aa,
0x06ab,
0xffe1,
0xffe6,
0xffe2,
0x1008ff36,
0xff3c,
0x1000d85,
0x1000d86,
0x1000dcf,
0x1000d87,
0x1000dd0,
0x1000d88,
0x1000dd1,
0x1000d93,
0x1000ddb,
0x1000dca,
0x1000d96,
0x1000dde,
0x1000db6,
0x1000db7,
0x1000da0,
0x1000da1,
0x1000da9,
0x1000daa,
0x1000daf,
0x1000db0,
0x1000d91,
0x1000dd9,
0x1000d92,
0x1000dda,
0x1000dc6,
0x1000d9c,
0x1000d9d,
0x1000d83,
0x1000dc4,
0x1000d89,
0x1000dd2,
0x1000d8a,
0x1000dd3,
0x1000da2,
0x1000da3,
0x1000da5,
0x1000d9a,
0x1000d9b,
0x1000df4,
0x1000dbd,
0x1000dc5,
0x1000d8f,
0x1000ddf,
0x1000d90,
0x1000df3,
0x1000db8,
0x1000db9,
0x1000db1,
0x1000dac,
0x1000db3,
0x1000d82,
0x1000d9e,
0x1000d9f,
0x1000da6,
0x1000dab,
0x1000da4,
0x1000d94,
0x1000ddc,
0x1000d95,
0x1000ddd,
0x1000db4,
0x1000db5,
0x1000dbb,
0x1000d8d,
0x1000d8e,
0x1000dd8,
0x1000df2,
0x1000dc3,
0x1000dc1,
0x1000dc2,
0x1000dad,
0x1000dae,
0x1000da7,
0x1000da8,
0x1000d8b,
0x1000dd4,
0x1000d8c,
0x1000dd6,
0x1000dc0,
0x1000dba,
0x1008ff2f,
0xfe73,
0x1008ff7c,
0x1008ff7d,
0x1008ff10,
0x1008ff1a,
0xfe75,
0x1008ff28,
0x1008ff9a,
0xffeb,
0xffec,
0x1008ff7e,
0x1008ffa7,
0x1008fe01,
0x1008fe0a,
0x1008fe0b,
0x1008fe0c,
0x1008fe02,
0x1008fe03,
0x1008fe04,
0x1008fe05,
0x1008fe06,
0x1008fe07,
0x1008fe08,
0x1008fe09,
0xff15,
0x0054,
0x00de,
0xff09,
0x1001e6a,
0x1008ff7f,
0x01ab,
0x01de,
0x1008ff80,
0xfed5,
0x0ddf,
0x0dba,
0x0da8,
0x0daa,
0x0da9,
0x0dac,
0x0dae,
0x0db4,
0x0dbd,
0x0dbf,
0x0dcb,
0x0dce,
0x0da2,
0x0da5,
0x0da3,
0x0da4,
0x0da6,
0x0da1,
0x0de5,
0x0df7,
0x0df5,
0x0df6,
0x0df9,
0x0df1,
0x0df8,
0x0df3,
0x0df4,
0x0df2,
0x0df0,
0x0dcc,
0x0dc5,
0x0dc6,
0x0deb,
0x0de8,
0x0dd1,
0x0dde,
0x0de7,
0x0de9,
0x0dea,
0x0de6,
0x0dc1,
0x0da7,
0x0ded,
0x0db3,
0x0db9,
0x0dcd,
0x0dcf,
0x0dda,
0x0dbe,
0x0dbc,
0x0dc0,
0x0dbb,
0x0dc3,
0x0dc4,
0x0dd0,
0x0dd2,
0x0de1,
0x0de4,
0x0de3,
0x0dd3,
0x0de0,
0x0dd4,
0x0dd5,
0x0de2,
0x0dd8,
0x0dd6,
0x0dd7,
0x0dd9,
0x0dc9,
0x0dc8,
0x0dab,
0x0dca,
0x0dec,
0x0db1,
0x0db2,
0x0db7,
0x0db0,
0x0db8,
0x0db6,
0x0daf,
0x0db5,
0x0dc7,
0x0dc2,
0x0dad,
0x00de,
0x1008ff9f,
0x1008ff1f,
0x1008ff81,
0x1008ffa2,
0x1008ffb1,
0x1008ffb0,
0x1008ffa9,
0xff2b,
0x1008ff82,
0x03ac,
0x0055,
0x00da,
0x1001ee4,
0x02dd,
0x00db,
0x00dc,
0x01db,
0x00d9,
0x1001ee6,
0x10001af,
0x1001ee8,
0x1001ef0,
0x1001eea,
0x1001eec,
0x1001eee,
0x06bd,
0x06b6,
0x06b4,
0x06b7,
0x06ad,
0x06a6,
0x06a4,
0x06a7,
0x06b6,
0x06b4,
0x06b7,
0x06a6,
0x06a4,
0x06a7,
0x03de,
0xff65,
0x1008fe20,
0x03d9,
0xff52,
0x01d9,
0x1008ff85,
0x1008ff86,
0x1008ff84,
0x03dd,
0x0056,
0x1008ff34,
0x1008ff87,
0x1008ffa1,
0xffffff,
0x0057,
0x1008ff95,
0x1008ff2e,
0x1001e82,
0x1008ff2b,
0x1000174,
0x1001e84,
0x1008ff8f,
0x1001e80,
0x1008ff88,
0x1008ff55,
0x1008fe21,
0x10020a9,
0x1008ff89,
0x0058,
0x1001e8a,
0x1008ff8a,
0x0059,
0x00dd,
0x1001ef4,
0x1000176,
0x13be,
0x1008ffa5,
0x1001ef2,
0x1001ef6,
0x1001ef8,
0x005a,
0x01af,
0x01ac,
0x01ae,
0xff3d,
0xff28,
0xff2a,
0x1008ff8b,
0x1008ff8c,
0x10001b5,
0x0061,
0x00e1,
0x1001ea1,
0x01ff,
0x01e3,
0x1001eaf,
0x1001eb7,
0x1001eb1,
0x1001eb3,
0x1001eb5,
0x00e2,
0x1001ea5,
0x1001ead,
0x1001ea7,
0x1001ea9,
0x1001eab,
0x00b4,
0x00e4,
0x00e6,
0x00e0,
0x1001ea3,
0x03e0,
0x0026,
0x01b1,
0x0027,
0x1002248,
0x08c8,
0x00e5,
0x005e,
0x007e,
0x002a,
0x0040,
0x00e3,
0x0062,
0x1001e03,
0x005c,
0x0af4,
0x007c,
0x1002235,
0x09df,
0x08a5,
0x08ac,
0x08a8,
0x08b2,
0x08ae,
0x08aa,
0x08b6,
0x09f6,
0x08b4,
0x007b,
0x007d,
0x005b,
0x005d,
0x1002800,
0xfff1,
0xfffa,
0xfff2,
0xfff3,
0xfff4,
0xfff5,
0xfff6,
0xfff7,
0xfff8,
0xfff9,
0x1002801,
0x1002803,
0x1002807,
0x100280f,
0x100281f,
0x100283f,
0x100287f,
0x10028ff,
0x10028bf,
0x100285f,
0x10028df,
0x100289f,
0x100282f,
0x100286f,
0x10028ef,
0x10028af,
0x100284f,
0x10028cf,
0x100288f,
0x1002817,
0x1002837,
0x1002877,
0x10028f7,
0x10028b7,
0x1002857,
0x10028d7,
0x1002897,
0x1002827,
0x1002867,
0x10028e7,
0x10028a7,
0x1002847,
0x10028c7,
0x1002887,
0x100280b,
0x100281b,
0x100283b,
0x100287b,
0x10028fb,
0x10028bb,
0x100285b,
0x10028db,
0x100289b,
0x100282b,
0x100286b,
0x10028eb,
0x10028ab,
0x100284b,
0x10028cb,
0x100288b,
0x1002813,
0x1002833,
0x1002873,
0x10028f3,
0x10028b3,
0x1002853,
0x10028d3,
0x1002893,
0x1002823,
0x1002863,
0x10028e3,
0x10028a3,
0x1002843,
0x10028c3,
0x1002883,
0x1002805,
0x100280d,
0x100281d,
0x100283d,
0x100287d,
0x10028fd,
0x10028bd,
0x100285d,
0x10028dd,
0x100289d,
0x100282d,
0x100286d,
0x10028ed,
0x10028ad,
0x100284d,
0x10028cd,
0x100288d,
0x1002815,
0x1002835,
0x1002875,
0x10028f5,
0x10028b5,
0x1002855,
0x10028d5,
0x1002895,
0x1002825,
0x1002865,
0x10028e5,
0x10028a5,
0x1002845,
0x10028c5,
0x1002885,
0x1002809,
0x1002819,
0x1002839,
0x1002879,
0x10028f9,
0x10028b9,
0x1002859,
0x10028d9,
0x1002899,
0x1002829,
0x1002869,
0x10028e9,
0x10028a9,
0x1002849,
0x10028c9,
0x1002889,
0x1002811,
0x1002831,
0x1002871,
0x10028f1,
0x10028b1,
0x1002851,
0x10028d1,
0x1002891,
0x1002821,
0x1002861,
0x10028e1,
0x10028a1,
0x1002841,
0x10028c1,
0x1002881,
0x1002802,
0x1002806,
0x100280e,
0x100281e,
0x100283e,
0x100287e,
0x10028fe,
0x10028be,
0x100285e,
0x10028de,
0x100289e,
0x100282e,
0x100286e,
0x10028ee,
0x10028ae,
0x100284e,
0x10028ce,
0x100288e,
0x1002816,
0x1002836,
0x1002876,
0x10028f6,
0x10028b6,
0x1002856,
0x10028d6,
0x1002896,
0x1002826,
0x1002866,
0x10028e6,
0x10028a6,
0x1002846,
0x10028c6,
0x1002886,
0x100280a,
0x100281a,
0x100283a,
0x100287a,
0x10028fa,
0x10028ba,
0x100285a,
0x10028da,
0x100289a,
0x100282a,
0x100286a,
0x10028ea,
0x10028aa,
0x100284a,
0x10028ca,
0x100288a,
0x1002812,
0x1002832,
0x1002872,
0x10028f2,
0x10028b2,
0x1002852,
0x10028d2,
0x1002892,
0x1002822,
0x1002862,
0x10028e2,
0x10028a2,
0x1002842,
0x10028c2,
0x1002882,
0x1002804,
0x100280c,
0x100281c,
0x100283c,
0x100287c,
0x10028fc,
0x10028bc,
0x100285c,
0x10028dc,
0x100289c,
0x100282c,
0x100286c,
0x10028ec,
0x10028ac,
0x100284c,
0x10028cc,
0x100288c,
0x1002814,
0x1002834,
0x1002874,
0x10028f4,
0x10028b4,
0x1002854,
0x10028d4,
0x1002894,
0x1002824,
0x1002864,
0x10028e4,
0x10028a4,
0x1002844,
0x10028c4,
0x1002884,
0x1002808,
0x1002818,
0x1002838,
0x1002878,
0x10028f8,
0x10028b8,
0x1002858,
0x10028d8,
0x1002898,
0x1002828,
0x1002868,
0x10028e8,
0x10028a8,
0x1002848,
0x10028c8,
0x1002888,
0x1002810,
0x1002830,
0x1002870,
0x10028f0,
0x10028b0,
0x1002850,
0x10028d0,
0x1002890,
0x1002820,
0x1002860,
0x10028e0,
0x10028a0,
0x1002840,
0x10028c0,
0x1002880,
0x01a2,
0x00a6,
0x0063,
0xfea3,
0x02e5,
0x01e6,
0x0ab8,
0x0afc,
0x01b7,
0x01e8,
0x00e7,
0x02e6,
0x00b8,
0x00a2,
0xfea0,
0x09e1,
0x0af3,
0x0bcf,
0x0aec,
0x003a,
0x002c,
0x100220b,
0x00a9,
0x09e4,
0x09ee,
0x100221b,
0x00a4,
0x0aff,
0x0064,
0x1001e0b,
0x0af1,
0x01ef,
0xfe81,
0xfe83,
0xfe85,
0xfe87,
0xfe89,
0xfe80,
0xfe64,
0xfe56,
0xfe65,
0xfe58,
0xfe91,
0xfe51,
0xfe6b,
0xfe69,
0xfe6e,
0xfe6c,
0xfe60,
0xfe68,
0xfe67,
0xfe6a,
0xfe92,
0xfe55,
0xfe8b,
0xfe5a,
0xfe5b,
0xfe52,
0xfe6f,
0xfe65,
0xfe57,
0xfe59,
0xfe66,
0xfe82,
0xfe50,
0xfe8c,
0xfe61,
0xfe62,
0xfe84,
0xfe6d,
0xfe5d,
0xfe93,
0xfe90,
0xfe54,
0xfe86,
0xfe5c,
0xfe53,
0xfe64,
0xfe5f,
0xfe8a,
0xfe63,
0xfe53,
0xfe88,
0xfe5e,
0x0abd,
0x00b0,
0x00a8,
0x0aed,
0x0aa5,
0x100222c,
0x00f7,
0x0024,
0x0aaf,
0x01bd,
0x0af2,
0x0afe,
0x08fe,
0x0ba8,
0x0bd6,
0x0bc4,
0x0bc2,
0x01f0,
0x0065,
0x03ec,
0x00e9,
0x1001eb9,
0x01ec,
0x00ea,
0x1001ebf,
0x1001ec7,
0x1001ec1,
0x1001ec3,
0x1001ec5,
0x00eb,
0x00e8,
0x1001ebb,
0x1002088,
0x1002078,
0x1002208,
0x0aae,
0x0aa3,
0x0aa4,
0x03ba,
0x0aa9,
0x0ade,
0x0adf,
0x0ace,
0x0acf,
0x1002205,
0x0aa1,
0x0aaa,
0x0ae6,
0x0ae7,
0x03bf,
0x0ae0,
0x0ae1,
0x0aa2,
0x01ea,
0x003d,
0x00f0,
0x1001ebd,
0x0021,
0x00a1,
0x1000292,
0x0066,
0x1001e1f,
0x0af8,
0x09e3,
0x0abb,
0x0adc,
0x0adb,
0x0add,
0x0ae9,
0x0ae8,
0x0ac5,
0x0ab7,
0x1002085,
0x1002075,
0x0ab5,
0x1002084,
0x1002074,
0x100221c,
0x08f6,
0x0067,
0x02f5,
0x02bb,
0x10001e7,
0x03bb,
0x02f8,
0x0060,
0x003e,
0x08be,
0x00ab,
0x00bb,
0x0068,
0x0aa8,
0x02b6,
0x0aee,
0x0ce0,
0x0cf2,
0x0ce1,
0x0ce1,
0x0ce7,
0x0ce3,
0x0ce3,
0x0cdf,
0x0cea,
0x0ced,
0x0cef,
0x0cf3,
0x0cf5,
0x0cf5,
0x0ce2,
0x0ce2,
0x0ce4,
0x0ce7,
0x0ceb,
0x0cf7,
0x0cec,
0x0cee,
0x0cf0,
0x0cf4,
0x0cf7,
0x0cf8,
0x0cf1,
0x0cf1,
0x0cf9,
0x0cfa,
0x0cfa,
0x0ce8,
0x0ce8,
0x0ce5,
0x0ce9,
0x0cf6,
0x0cf6,
0x0ce6,
0x0ce6,
0x0ada,
0x08a3,
0x09ef,
0x09f0,
0x09f1,
0x09f2,
0x09f3,
0x02b1,
0x09e2,
0x00ad,
0x0069,
0x1008ff60,
0x00ed,
0x1001ecb,
0x100012d,
0x00ee,
0x08cf,
0x00ef,
0x02b9,
0x08cd,
0x00ec,
0x1001ec9,
0x03ef,
0x08ce,
0x08da,
0x08db,
0x08c2,
0x08bf,
0x08dc,
0x03e7,
0x03b5,
0x006a,
0x02bc,
0x0bca,
0x006b,
0x04b1,
0x04c1,
0x04b4,
0x04cc,
0x04ca,
0x04cd,
0x04cb,
0x04ce,
0x04cc,
0x04b2,
0x04b6,
0x04b9,
0x04b7,
0x04ba,
0x04b8,
0x04cf,
0x04d2,
0x04d0,
0x04d3,
0x04d1,
0x04dd,
0x04c5,
0x04c8,
0x04c6,
0x04c9,
0x04c7,
0x04b5,
0x04d7,
0x04da,
0x04d8,
0x04db,
0x04d9,
0x04bb,
0x04be,
0x04bc,
0x04bf,
0x04bd,
0x04c0,
0x04c3,
0x04c1,
0x04c4,
0x04c2,
0x04c2,
0x04b3,
0x04dc,
0x04a6,
0x04d4,
0x04d6,
0x04d5,
0x04a7,
0x04a3,
0x04a4,
0x04a5,
0x04aa,
0x04a1,
0x04a8,
0x04a5,
0x04ab,
0x04a2,
0xff7e,
0x04af,
0x04af,
0x04a9,
0x04ac,
0x04ae,
0x04ad,
0x03a2,
0x03f3,
0x03a2,
0x006c,
0x01e5,
0x0ad9,
0x1001e37,
0x01b5,
0x03b6,
0x0abc,
0x08fb,
0x0ba3,
0x0ad2,
0x08af,
0x0acc,
0x0aea,
0x08a1,
0x0bda,
0x0ad0,
0x09f4,
0x0bdc,
0x003c,
0x08bc,
0x09e5,
0x08de,
0x08df,
0x09ed,
0x09ea,
0x01b3,
0x006d,
0x1001e41,
0x00af,
0x0af7,
0x0af0,
0x0abf,
0x00ba,
0x002d,
0x0ad6,
0x00b5,
0x00d7,
0x0af6,
0x0af5,
0x006e,
0x08c5,
0x01f1,
0x01f2,
0x03f1,
0x1002089,
0x1002079,
0x09e8,
0x00a0,
0x1002247,
0x1002209,
0x08bd,
0x1002262,
0x00ac,
0x00f1,
0x0023,
0x06b0,
0x006f,
0x00f3,
0x1000275,
0x1001ecd,
0x10001d2,
0x00f4,
0x1001ed1,
0x1001ed9,
0x1001ed3,
0x1001ed5,
0x1001ed7,
0x00f6,
0x01f5,
0x13bd,
0x01b2,
0x00f2,
0x1001ecf,
0x10001a1,
0x1001edb,
0x1001ee3,
0x1001edd,
0x1001edf,
0x1001ee1,
0x03f2,
0x0ac3,
0x0ab2,
0x00bd,
0x00bc,
0x0ab6,
0x1002081,
0x00b9,
0x0ab0,
0x00f8,
0x0ae2,
0x0ae5,
0x0ae4,
0x0ae3,
0x00aa,
0x00f8,
0x00f5,
0x0bc0,
0x047e,
0x0070,
0x1001e57,
0x00b6,
0x0028,
0x0029,
0x1002202,
0x08ef,
0x0025,
0x002e,
0x00b7,
0x0ad5,
0x0afb,
0x002b,
0x00b1,
0x0ad4,
0x04b0,
0x0aa6,
0x0071,
0x0bcc,
0x003f,
0x00bf,
0x0022,
0x0060,
0x0027,
0x0072,
0x01e0,
0x08d6,
0x01f8,
0x03b3,
0x00ae,
0x0abe,
0x08fd,
0x0ba6,
0x0ad3,
0x08b0,
0x08b7,
0x0acd,
0x0aeb,
0x0bd8,
0x0ad1,
0x09f5,
0x0bfc,
0x0073,
0x1001e61,
0x01b6,
0x01b9,
0x01ba,
0x1000259,
0x02fe,
0xff7e,
0x0ad7,
0x00a7,
0x003b,
0x04df,
0x0ac6,
0x1002087,
0x1002077,
0x0aca,
0x0aac,
0x08c9,
0x0afd,
0x1002086,
0x1002076,
0x002f,
0x09e0,
0x0020,
0x100221a,
0x00df,
0x00a3,
0x1002263,
0x0074,
0x1001e6b,
0x01bb,
0x01fe,
0x0af9,
0x0afa,
0x08c0,
0x0aa7,
0x00fe,
0x0ac4,
0x0ab4,
0x00be,
0x1002083,
0x00b3,
0x100222d,
0x08a4,
0x08ab,
0x08a2,
0x08a7,
0x08b1,
0x08ad,
0x08a9,
0x08b5,
0x09f7,
0x08b3,
0x0ac9,
0x0acb,
0x03bc,
0x0ab3,
0x1002082,
0x00b2,
0x0ab1,
0x0075,
0x00fa,
0x1001ee5,
0x02fd,
0x00fb,
0x00fc,
0x01fb,
0x00f9,
0x1001ee7,
0x10001b0,
0x1001ee9,
0x1001ef1,
0x1001eeb,
0x1001eed,
0x1001eef,
0x03fe,
0x0bc6,
0x005f,
0x08dd,
0x03f9,
0x08fc,
0x0ba9,
0x09ec,
0x09eb,
0x0bc3,
0x0bd3,
0x0bce,
0x01f9,
0x03fd,
0x0076,
0x08c1,
0x09f8,
0x08a6,
0x04de,
0x09e9,
0x0077,
0x1001e83,
0x1000175,
0x1001e85,
0x1001e81,
0x0078,
0x1001e8b,
0x0079,
0x00fd,
0x1001ef5,
0x1000177,
0x00ff,
0x00a5,
0x1001ef3,
0x1001ef7,
0x1001ef9,
0x007a,
0x01bf,
0x01bc,
0x01be,
0x1002080,
0x1002070,
0x10001b6
};

const static struct KeyNameOffsetByValue {
    uint32_t sym;
    uint16_t offset;
} keyNameOffsetByValue[] _FCITX_UNUSED_ = {
{0x0, 934},
{0x0020, 2178},
{0x0021, 1835},
{0x0022, 2134},
{0x0023, 2069},
{0x0024, 1785},
{0x0025, 2120},
{0x0026, 1397},
{0x0027, 1399},
{0x0028, 2116},
{0x0029, 2117},
{0x002a, 1405},
{0x002b, 2125},
{0x002c, 1714},
{0x002d, 2048},
{0x002e, 2121},
{0x002f, 2176},
{0x0030, 0},
{0x0031, 1},
{0x0032, 2},
{0x0033, 3},
{0x0034, 34},
{0x0035, 35},
{0x0036, 36},
{0x0037, 37},
{0x0038, 38},
{0x0039, 39},
{0x003a, 1713},
{0x003b, 2165},
{0x003c, 2033},
{0x003d, 1832},
{0x003e, 1864},
{0x003f, 2132},
{0x0040, 1406},
{0x0041, 40},
{0x0042, 258},
{0x0043, 273},
{0x0044, 404},
{0x0045, 414},
{0x0046, 445},
{0x0047, 501},
{0x0048, 624},
{0x0049, 747},
{0x004a, 800},
{0x004b, 802},
{0x004c, 850},
{0x004d, 890},
{0x004e, 923},
{0x004f, 937},
{0x0050, 969},
{0x0051, 1015},
{0x0052, 1016},
{0x0053, 1051},
{0x0054, 1191},
{0x0055, 1295},
{0x0056, 1334},
{0x0057, 1339},
{0x0058, 1353},
{0x0059, 1356},
{0x005a, 1365},
{0x005b, 1426},
{0x005c, 1410},
{0x005d, 1427},
{0x005e, 1403},
{0x005f, 2232},
{0x0060, 1863},
{0x0061, 1375},
{0x0062, 1408},
{0x0063, 1696},
{0x0064, 1722},
{0x0065, 1796},
{0x0066, 1838},
{0x0067, 1857},
{0x0068, 1868},
{0x0069, 1921},
{0x006a, 1942},
{0x006b, 1945},
{0x006c, 2015},
{0x006d, 2041},
{0x006e, 2054},
{0x006f, 2071},
{0x0070, 2113},
{0x0071, 2130},
{0x0072, 2137},
{0x0073, 2155},
{0x0074, 2183},
{0x0075, 2215},
{0x0076, 2244},
{0x0077, 2250},
{0x0078, 2255},
{0x0079, 2257},
{0x007a, 2266},
{0x007b, 1424},
{0x007c, 1412},
{0x007d, 1425},
{0x007e, 1404},
{0x00a0, 2062},
{0x00a1, 1836},
{0x00a2, 1707},
{0x00a3, 2181},
{0x00a4, 1720},
{0x00a5, 2262},
{0x00a6, 1695},
{0x00a7, 2164},
{0x00a8, 1780},
{0x00a9, 1716},
{0x00aa, 2108},
{0x00ab, 1866},
{0x00ac, 2067},
{0x00ad, 1920},
{0x00ae, 2142},
{0x00af, 2043},
{0x00b0, 1779},
{0x00b1, 2126},
{0x00b2, 2213},
{0x00b3, 2196},
{0x00b4, 1391},
{0x00b5, 2050},
{0x00b6, 2115},
{0x00b7, 2122},
{0x00b8, 1706},
{0x00b9, 2101},
{0x00ba, 2047},
{0x00bb, 1867},
{0x00bc, 2098},
{0x00bd, 2097},
{0x00be, 2194},
{0x00bf, 2133},
{0x00c0, 60},
{0x00c1, 42},
{0x00c2, 52},
{0x00c3, 239},
{0x00c4, 59},
{0x00c5, 148},
{0x00c6, 41},
{0x00c7, 285},
{0x00c8, 430},
{0x00c9, 419},
{0x00ca, 422},
{0x00cb, 429},
{0x00cc, 794},
{0x00cd, 789},
{0x00ce, 792},
{0x00cf, 793},
{0x00d0, 416},
{0x00d1, 935},
{0x00d2, 952},
{0x00d3, 939},
{0x00d4, 943},
{0x00d5, 966},
{0x00d6, 949},
{0x00d7, 2051},
{0x00d8, 961},
{0x00d9, 1302},
{0x00da, 1296},
{0x00db, 1299},
{0x00dc, 1300},
{0x00dd, 1357},
{0x00de, 1192},
{0x00df, 2180},
{0x00e0, 1394},
{0x00e1, 1376},
{0x00e2, 1385},
{0x00e3, 1407},
{0x00e4, 1392},
{0x00e5, 1402},
{0x00e6, 1393},
{0x00e7, 1704},
{0x00e8, 1808},
{0x00e9, 1798},
{0x00ea, 1801},
{0x00eb, 1807},
{0x00ec, 1931},
{0x00ed, 1923},
{0x00ee, 1926},
{0x00ef, 1928},
{0x00f0, 1833},
{0x00f1, 2068},
{0x00f2, 2086},
{0x00f3, 2072},
{0x00f4, 2076},
{0x00f5, 2110},
{0x00f6, 2082},
{0x00f7, 1784},
{0x00f8, 2103},
{0x00f9, 2222},
{0x00fa, 2216},
{0x00fb, 2219},
{0x00fc, 2220},
{0x00fd, 2258},
{0x00fe, 2191},
{0x00ff, 2261},
{0x01a1, 65},
{0x01a2, 1694},
{0x01a3, 889},
{0x01a5, 880},
{0x01a6, 1054},
{0x01a9, 1056},
{0x01aa, 1057},
{0x01ab, 1196},
{0x01ac, 1367},
{0x01ae, 1368},
{0x01af, 1366},
{0x01b1, 1398},
{0x01b2, 2085},
{0x01b3, 2040},
{0x01b5, 2019},
{0x01b6, 2157},
{0x01b7, 1702},
{0x01b9, 2158},
{0x01ba, 2159},
{0x01bb, 2185},
{0x01bc, 2268},
{0x01bd, 1787},
{0x01be, 2269},
{0x01bf, 2267},
{0x01c0, 1032},
{0x01c3, 44},
{0x01c5, 861},
{0x01c6, 279},
{0x01c8, 284},
{0x01ca, 437},
{0x01cc, 421},
{0x01cf, 407},
{0x01d0, 413},
{0x01d1, 924},
{0x01d2, 926},
{0x01d5, 950},
{0x01d8, 1033},
{0x01d9, 1329},
{0x01db, 1301},
{0x01de, 1197},
{0x01e0, 2138},
{0x01e3, 1379},
{0x01e5, 2016},
{0x01e6, 1699},
{0x01e8, 1703},
{0x01ea, 1831},
{0x01ec, 1800},
{0x01ef, 1725},
{0x01f0, 1795},
{0x01f1, 2056},
{0x01f2, 2057},
{0x01f5, 2083},
{0x01f8, 2140},
{0x01f9, 2242},
{0x01fb, 2221},
{0x01fe, 2186},
{0x01ff, 1378},
{0x02a1, 744},
{0x02a6, 732},
{0x02a9, 788},
{0x02ab, 504},
{0x02ac, 801},
{0x02b1, 1918},
{0x02b6, 1870},
{0x02b9, 1929},
{0x02bb, 1859},
{0x02bc, 1943},
{0x02c5, 278},
{0x02c6, 286},
{0x02d5, 502},
{0x02d8, 507},
{0x02dd, 1298},
{0x02de, 1058},
{0x02e5, 1698},
{0x02e6, 1705},
{0x02f5, 1858},
{0x02f8, 1862},
{0x02fd, 2218},
{0x02fe, 2161},
{0x03a2, 2012},
{0x03a3, 1034},
{0x03a5, 799},
{0x03a6, 881},
{0x03aa, 435},
{0x03ab, 506},
{0x03ac, 1294},
{0x03b3, 2141},
{0x03b5, 1941},
{0x03b6, 2020},
{0x03ba, 1816},
{0x03bb, 1861},
{0x03bc, 2210},
{0x03bd, 415},
{0x03bf, 1827},
{0x03c0, 64},
{0x03c7, 798},
{0x03cc, 418},
{0x03cf, 796},
{0x03d1, 927},
{0x03d2, 960},
{0x03d3, 848},
{0x03d9, 1327},
{0x03dd, 1333},
{0x03de, 1324},
{0x03e0, 1396},
{0x03e7, 1940},
{0x03ec, 1797},
{0x03ef, 1933},
{0x03f1, 2058},
{0x03f2, 2094},
{0x03f3, 2013},
{0x03f9, 2234},
{0x03fd, 2243},
{0x03fe, 2230},
{0x047e, 2112},
{0x04a1, 2000},
{0x04a2, 2004},
{0x04a3, 1996},
{0x04a4, 1997},
{0x04a5, 1998},
{0x04a6, 1991},
{0x04a7, 1995},
{0x04a8, 2001},
{0x04a9, 2008},
{0x04aa, 1999},
{0x04ab, 2003},
{0x04ac, 2009},
{0x04ad, 2011},
{0x04ae, 2010},
{0x04af, 2006},
{0x04b0, 2128},
{0x04b1, 1946},
{0x04b2, 1955},
{0x04b3, 1989},
{0x04b4, 1948},
{0x04b5, 1972},
{0x04b6, 1956},
{0x04b7, 1958},
{0x04b8, 1960},
{0x04b9, 1957},
{0x04ba, 1959},
{0x04bb, 1978},
{0x04bc, 1980},
{0x04bd, 1982},
{0x04be, 1979},
{0x04bf, 1981},
{0x04c0, 1983},
{0x04c1, 1947},
{0x04c2, 1987},
{0x04c3, 1984},
{0x04c4, 1986},
{0x04c5, 1967},
{0x04c6, 1969},
{0x04c7, 1971},
{0x04c8, 1968},
{0x04c9, 1970},
{0x04ca, 1950},
{0x04cb, 1952},
{0x04cc, 1949},
{0x04cd, 1951},
{0x04ce, 1953},
{0x04cf, 1961},
{0x04d0, 1963},
{0x04d1, 1965},
{0x04d2, 1962},
{0x04d3, 1964},
{0x04d4, 1992},
{0x04d5, 1994},
{0x04d6, 1993},
{0x04d7, 1973},
{0x04d8, 1975},
{0x04d9, 1977},
{0x04da, 1974},
{0x04db, 1976},
{0x04dc, 1990},
{0x04dd, 1966},
{0x04de, 2248},
{0x04df, 2166},
{0x05ac, 82},
{0x05bb, 128},
{0x05bf, 123},
{0x05c1, 97},
{0x05c2, 116},
{0x05c3, 100},
{0x05c4, 101},
{0x05c5, 103},
{0x05c6, 102},
{0x05c7, 79},
{0x05c8, 81},
{0x05c9, 138},
{0x05ca, 137},
{0x05cb, 140},
{0x05cc, 107},
{0x05cd, 96},
{0x05ce, 113},
{0x05cf, 84},
{0x05d0, 139},
{0x05d1, 124},
{0x05d2, 147},
{0x05d3, 127},
{0x05d4, 130},
{0x05d5, 126},
{0x05d6, 83},
{0x05d7, 134},
{0x05d8, 146},
{0x05d9, 78},
{0x05da, 94},
{0x05e0, 135},
{0x05e1, 91},
{0x05e2, 122},
{0x05e3, 109},
{0x05e4, 114},
{0x05e5, 117},
{0x05e6, 118},
{0x05e7, 95},
{0x05e8, 143},
{0x05e9, 80},
{0x05ea, 144},
{0x05eb, 90},
{0x05ec, 86},
{0x05ed, 111},
{0x05ee, 89},
{0x05ef, 85},
{0x05f0, 110},
{0x05f1, 129},
{0x05f2, 131},
{0x06a1, 1074},
{0x06a2, 896},
{0x06a3, 375},
{0x06a4, 1316},
{0x06a5, 895},
{0x06a6, 1315},
{0x06a7, 1317},
{0x06a8, 376},
{0x06a9, 380},
{0x06aa, 381},
{0x06ab, 1079},
{0x06ac, 897},
{0x06ad, 1314},
{0x06ae, 272},
{0x06af, 358},
{0x06b0, 2070},
{0x06b1, 1068},
{0x06b2, 893},
{0x06b3, 322},
{0x06b4, 1312},
{0x06b5, 892},
{0x06b6, 1311},
{0x06b7, 1313},
{0x06b8, 324},
{0x06b9, 328},
{0x06ba, 329},
{0x06bb, 1073},
{0x06bc, 894},
{0x06bd, 1310},
{0x06be, 271},
{0x06bf, 306},
{0x06c0, 400},
{0x06c1, 352},
{0x06c2, 353},
{0x06c3, 392},
{0x06c4, 357},
{0x06c5, 374},
{0x06c6, 360},
{0x06c7, 367},
{0x06c8, 369},
{0x06c9, 372},
{0x06ca, 389},
{0x06cb, 377},
{0x06cc, 361},
{0x06cd, 362},
{0x06ce, 363},
{0x06cf, 382},
{0x06d0, 384},
{0x06d1, 398},
{0x06d2, 365},
{0x06d3, 366},
{0x06d4, 391},
{0x06d5, 393},
{0x06d6, 402},
{0x06d7, 397},
{0x06d8, 390},
{0x06d9, 399},
{0x06da, 401},
{0x06db, 386},
{0x06dc, 359},
{0x06dd, 387},
{0x06de, 354},
{0x06df, 371},
{0x06e0, 348},
{0x06e1, 300},
{0x06e2, 301},
{0x06e3, 340},
{0x06e4, 305},
{0x06e5, 321},
{0x06e6, 308},
{0x06e7, 315},
{0x06e8, 317},
{0x06e9, 320},
{0x06ea, 337},
{0x06eb, 325},
{0x06ec, 309},
{0x06ed, 310},
{0x06ee, 311},
{0x06ef, 330},
{0x06f0, 332},
{0x06f1, 346},
{0x06f2, 313},
{0x06f3, 314},
{0x06f4, 339},
{0x06f5, 341},
{0x06f6, 350},
{0x06f7, 345},
{0x06f8, 338},
{0x06f9, 347},
{0x06fa, 349},
{0x06fb, 334},
{0x06fc, 307},
{0x06fd, 335},
{0x06fe, 302},
{0x06ff, 318},
{0x07a1, 549},
{0x07a2, 554},
{0x07a3, 556},
{0x07a4, 559},
{0x07a5, 560},
{0x07a7, 570},
{0x07a8, 579},
{0x07a9, 580},
{0x07ab, 568},
{0x07ae, 583},
{0x07af, 595},
{0x07b1, 585},
{0x07b2, 590},
{0x07b3, 592},
{0x07b4, 597},
{0x07b5, 599},
{0x07b6, 598},
{0x07b7, 608},
{0x07b8, 618},
{0x07b9, 620},
{0x07ba, 619},
{0x07bb, 606},
{0x07c1, 548},
{0x07c2, 550},
{0x07c3, 557},
{0x07c4, 552},
{0x07c5, 553},
{0x07c6, 582},
{0x07c7, 555},
{0x07c8, 577},
{0x07c9, 558},
{0x07ca, 562},
{0x07cb, 563},
{0x07cc, 565},
{0x07cd, 566},
{0x07ce, 581},
{0x07cf, 569},
{0x07d0, 572},
{0x07d1, 574},
{0x07d2, 575},
{0x07d4, 576},
{0x07d5, 578},
{0x07d6, 571},
{0x07d7, 551},
{0x07d8, 573},
{0x07d9, 567},
{0x07e1, 584},
{0x07e2, 586},
{0x07e3, 594},
{0x07e4, 588},
{0x07e5, 589},
{0x07e6, 622},
{0x07e7, 591},
{0x07e8, 616},
{0x07e9, 596},
{0x07ea, 600},
{0x07eb, 601},
{0x07ec, 603},
{0x07ed, 604},
{0x07ee, 621},
{0x07ef, 607},
{0x07f0, 610},
{0x07f1, 612},
{0x07f2, 613},
{0x07f3, 593},
{0x07f4, 615},
{0x07f5, 617},
{0x07f6, 609},
{0x07f7, 587},
{0x07f8, 611},
{0x07f9, 605},
{0x08a1, 2028},
{0x08a2, 2200},
{0x08a3, 1912},
{0x08a4, 2198},
{0x08a5, 1415},
{0x08a6, 2247},
{0x08a7, 2201},
{0x08a8, 1417},
{0x08a9, 2204},
{0x08aa, 1420},
{0x08ab, 2199},
{0x08ac, 1416},
{0x08ad, 2203},
{0x08ae, 1419},
{0x08af, 2025},
{0x08b0, 2147},
{0x08b1, 2202},
{0x08b2, 1418},
{0x08b3, 2207},
{0x08b4, 1423},
{0x08b5, 2205},
{0x08b6, 1421},
{0x08b7, 2148},
{0x08bc, 2034},
{0x08bd, 2065},
{0x08be, 1865},
{0x08bf, 1938},
{0x08c0, 2189},
{0x08c1, 2245},
{0x08c2, 1937},
{0x08c5, 2055},
{0x08c8, 1401},
{0x08c9, 2172},
{0x08cd, 1930},
{0x08ce, 1934},
{0x08cf, 1927},
{0x08d6, 2139},
{0x08da, 1935},
{0x08db, 1936},
{0x08dc, 1939},
{0x08dd, 2233},
{0x08de, 2036},
{0x08df, 2037},
{0x08ef, 2119},
{0x08f6, 1856},
{0x08fb, 2022},
{0x08fc, 2235},
{0x08fd, 2144},
{0x08fe, 1790},
{0x09df, 1414},
{0x09e0, 2177},
{0x09e1, 1709},
{0x09e2, 1919},
{0x09e3, 1841},
{0x09e4, 1717},
{0x09e5, 2035},
{0x09e8, 2061},
{0x09e9, 2249},
{0x09ea, 2039},
{0x09eb, 2238},
{0x09ec, 2237},
{0x09ed, 2038},
{0x09ee, 1718},
{0x09ef, 1913},
{0x09f0, 1914},
{0x09f1, 1915},
{0x09f2, 1916},
{0x09f3, 1917},
{0x09f4, 2031},
{0x09f5, 2153},
{0x09f6, 1422},
{0x09f7, 2206},
{0x09f8, 2246},
{0x0aa1, 1823},
{0x0aa2, 1830},
{0x0aa3, 1814},
{0x0aa4, 1815},
{0x0aa5, 1782},
{0x0aa6, 2129},
{0x0aa7, 2190},
{0x0aa8, 1869},
{0x0aa9, 1817},
{0x0aaa, 1824},
{0x0aac, 2171},
{0x0aae, 1813},
{0x0aaf, 1786},
{0x0ab0, 2102},
{0x0ab1, 2214},
{0x0ab2, 2096},
{0x0ab3, 2211},
{0x0ab4, 2193},
{0x0ab5, 1852},
{0x0ab6, 2099},
{0x0ab7, 1849},
{0x0ab8, 1700},
{0x0abb, 1842},
{0x0abc, 2021},
{0x0abd, 1778},
{0x0abe, 2143},
{0x0abf, 2046},
{0x0ac3, 2095},
{0x0ac4, 2192},
{0x0ac5, 1848},
{0x0ac6, 2167},
{0x0ac9, 2208},
{0x0aca, 2170},
{0x0acb, 2209},
{0x0acc, 2026},
{0x0acd, 2149},
{0x0ace, 1820},
{0x0acf, 1821},
{0x0ad0, 2030},
{0x0ad1, 2152},
{0x0ad2, 2024},
{0x0ad3, 2146},
{0x0ad4, 2127},
{0x0ad5, 2123},
{0x0ad6, 2049},
{0x0ad7, 2163},
{0x0ad9, 2017},
{0x0ada, 1911},
{0x0adb, 1844},
{0x0adc, 1843},
{0x0add, 1845},
{0x0ade, 1818},
{0x0adf, 1819},
{0x0ae0, 1828},
{0x0ae1, 1829},
{0x0ae2, 2104},
{0x0ae3, 2107},
{0x0ae4, 2106},
{0x0ae5, 2105},
{0x0ae6, 1825},
{0x0ae7, 1826},
{0x0ae8, 1847},
{0x0ae9, 1846},
{0x0aea, 2027},
{0x0aeb, 2150},
{0x0aec, 1712},
{0x0aed, 1781},
{0x0aee, 1871},
{0x0af0, 2045},
{0x0af1, 1724},
{0x0af2, 1788},
{0x0af3, 1710},
{0x0af4, 1411},
{0x0af5, 2053},
{0x0af6, 2052},
{0x0af7, 2044},
{0x0af8, 1840},
{0x0af9, 2187},
{0x0afa, 2188},
{0x0afb, 2124},
{0x0afc, 1701},
{0x0afd, 2173},
{0x0afe, 1789},
{0x0aff, 1721},
{0x0ba3, 2023},
{0x0ba6, 2145},
{0x0ba8, 1791},
{0x0ba9, 2236},
{0x0bc0, 2111},
{0x0bc2, 1794},
{0x0bc3, 2239},
{0x0bc4, 1793},
{0x0bc6, 2231},
{0x0bca, 1944},
{0x0bcc, 2131},
{0x0bce, 2241},
{0x0bcf, 1711},
{0x0bd3, 2240},
{0x0bd6, 1792},
{0x0bd8, 2151},
{0x0bda, 2029},
{0x0bdc, 2032},
{0x0bfc, 2154},
{0x0cdf, 1879},
{0x0ce0, 1872},
{0x0ce1, 1874},
{0x0ce2, 1886},
{0x0ce3, 1877},
{0x0ce4, 1888},
{0x0ce5, 1905},
{0x0ce6, 1909},
{0x0ce7, 1876},
{0x0ce8, 1903},
{0x0ce9, 1906},
{0x0cea, 1880},
{0x0ceb, 1890},
{0x0cec, 1892},
{0x0ced, 1881},
{0x0cee, 1893},
{0x0cef, 1882},
{0x0cf0, 1894},
{0x0cf1, 1898},
{0x0cf2, 1873},
{0x0cf3, 1883},
{0x0cf4, 1895},
{0x0cf5, 1884},
{0x0cf6, 1907},
{0x0cf7, 1891},
{0x0cf8, 1897},
{0x0cf9, 1900},
{0x0cfa, 1901},
{0x0da1, 1217},
{0x0da2, 1212},
{0x0da3, 1214},
{0x0da4, 1215},
{0x0da5, 1213},
{0x0da6, 1216},
{0x0da7, 1241},
{0x0da8, 1202},
{0x0da9, 1204},
{0x0daa, 1203},
{0x0dab, 1270},
{0x0dac, 1205},
{0x0dad, 1283},
{0x0dae, 1206},
{0x0daf, 1279},
{0x0db0, 1276},
{0x0db1, 1273},
{0x0db2, 1274},
{0x0db3, 1243},
{0x0db4, 1207},
{0x0db5, 1280},
{0x0db6, 1278},
{0x0db7, 1275},
{0x0db8, 1277},
{0x0db9, 1244},
{0x0dba, 1201},
{0x0dbb, 1251},
{0x0dbc, 1249},
{0x0dbd, 1208},
{0x0dbe, 1248},
{0x0dbf, 1209},
{0x0dc0, 1250},
{0x0dc1, 1240},
{0x0dc2, 1282},
{0x0dc3, 1252},
{0x0dc4, 1253},
{0x0dc5, 1230},
{0x0dc6, 1231},
{0x0dc7, 1281},
{0x0dc8, 1269},
{0x0dc9, 1268},
{0x0dca, 1271},
{0x0dcb, 1210},
{0x0dcc, 1229},
{0x0dcd, 1245},
{0x0dce, 1211},
{0x0dcf, 1246},
{0x0dd0, 1254},
{0x0dd1, 1234},
{0x0dd2, 1255},
{0x0dd3, 1259},
{0x0dd4, 1261},
{0x0dd5, 1262},
{0x0dd6, 1265},
{0x0dd7, 1266},
{0x0dd8, 1264},
{0x0dd9, 1267},
{0x0dda, 1247},
{0x0dde, 1235},
{0x0ddf, 1200},
{0x0de0, 1260},
{0x0de1, 1256},
{0x0de2, 1263},
{0x0de3, 1258},
{0x0de4, 1257},
{0x0de5, 1218},
{0x0de6, 1239},
{0x0de7, 1236},
{0x0de8, 1233},
{0x0de9, 1237},
{0x0dea, 1238},
{0x0deb, 1232},
{0x0dec, 1272},
{0x0ded, 1242},
{0x0df0, 1228},
{0x0df1, 1223},
{0x0df2, 1227},
{0x0df3, 1225},
{0x0df4, 1226},
{0x0df5, 1220},
{0x0df6, 1221},
{0x0df7, 1219},
{0x0df8, 1224},
{0x0df9, 1222},
{0x0ea1, 676},
{0x0ea2, 708},
{0x0ea3, 677},
{0x0ea4, 681},
{0x0ea5, 683},
{0x0ea6, 682},
{0x0ea7, 633},
{0x0ea8, 706},
{0x0ea9, 693},
{0x0eaa, 695},
{0x0eab, 696},
{0x0eac, 698},
{0x0ead, 699},
{0x0eae, 700},
{0x0eaf, 697},
{0x0eb0, 694},
{0x0eb1, 679},
{0x0eb2, 688},
{0x0eb3, 709},
{0x0eb4, 689},
{0x0eb5, 704},
{0x0eb6, 710},
{0x0eb7, 641},
{0x0eb8, 674},
{0x0eb9, 707},
{0x0eba, 631},
{0x0ebb, 675},
{0x0ebc, 715},
{0x0ebd, 687},
{0x0ebe, 639},
{0x0ebf, 626},
{0x0ec0, 627},
{0x0ec1, 722},
{0x0ec2, 723},
{0x0ec3, 635},
{0x0ec4, 634},
{0x0ec5, 725},
{0x0ec6, 724},
{0x0ec7, 684},
{0x0ec8, 717},
{0x0ec9, 718},
{0x0eca, 685},
{0x0ecb, 727},
{0x0ecc, 716},
{0x0ecd, 720},
{0x0ece, 719},
{0x0ecf, 721},
{0x0ed0, 728},
{0x0ed1, 636},
{0x0ed2, 726},
{0x0ed3, 640},
{0x0ed4, 648},
{0x0ed5, 668},
{0x0ed6, 649},
{0x0ed7, 652},
{0x0ed8, 654},
{0x0ed9, 653},
{0x0eda, 643},
{0x0edb, 659},
{0x0edc, 661},
{0x0edd, 662},
{0x0ede, 664},
{0x0edf, 665},
{0x0ee0, 666},
{0x0ee1, 663},
{0x0ee2, 660},
{0x0ee3, 651},
{0x0ee4, 657},
{0x0ee5, 658},
{0x0ee6, 667},
{0x0ee7, 669},
{0x0ee8, 645},
{0x0ee9, 646},
{0x0eea, 642},
{0x0eeb, 647},
{0x0eec, 670},
{0x0eed, 656},
{0x0eee, 644},
{0x0eef, 701},
{0x0ef0, 712},
{0x0ef1, 714},
{0x0ef2, 686},
{0x0ef3, 678},
{0x0ef4, 713},
{0x0ef5, 729},
{0x0ef6, 628},
{0x0ef7, 629},
{0x0ef8, 655},
{0x0ef9, 650},
{0x0efa, 671},
{0x0eff, 849},
{0x13bc, 938},
{0x13bd, 2084},
{0x13be, 1360},
{0x20ac, 441},
{0xfd01, 12},
{0xfd02, 17},
{0xfd03, 30},
{0xfd04, 21},
{0xfd05, 6},
{0xfd06, 14},
{0xfd07, 15},
{0xfd08, 29},
{0xfd09, 27},
{0xfd0a, 22},
{0xfd0b, 23},
{0xfd0c, 24},
{0xfd0d, 33},
{0xfd0e, 5},
{0xfd0f, 9},
{0xfd10, 4},
{0xfd11, 20},
{0xfd12, 19},
{0xfd13, 18},
{0xfd14, 31},
{0xfd15, 8},
{0xfd16, 25},
{0xfd17, 32},
{0xfd18, 28},
{0xfd19, 7},
{0xfd1a, 11},
{0xfd1b, 16},
{0xfd1c, 10},
{0xfd1d, 26},
{0xfd1e, 13},
{0xfe01, 772},
{0xfe02, 765},
{0xfe03, 768},
{0xfe04, 766},
{0xfe05, 767},
{0xfe06, 759},
{0xfe07, 760},
{0xfe08, 775},
{0xfe09, 776},
{0xfe0a, 781},
{0xfe0b, 782},
{0xfe0c, 757},
{0xfe0d, 758},
{0xfe0e, 762},
{0xfe0f, 763},
{0xfe11, 771},
{0xfe12, 769},
{0xfe13, 770},
{0xfe20, 764},
{0xfe21, 774},
{0xfe22, 773},
{0xfe23, 778},
{0xfe24, 777},
{0xfe25, 779},
{0xfe26, 780},
{0xfe27, 786},
{0xfe28, 787},
{0xfe29, 784},
{0xfe2a, 785},
{0xfe2b, 783},
{0xfe2c, 754},
{0xfe2d, 755},
{0xfe2e, 756},
{0xfe2f, 753},
{0xfe30, 749},
{0xfe31, 750},
{0xfe32, 751},
{0xfe33, 748},
{0xfe34, 752},
{0xfe50, 1758},
{0xfe51, 1737},
{0xfe52, 1751},
{0xfe53, 1770},
{0xfe54, 1767},
{0xfe55, 1747},
{0xfe56, 1733},
{0xfe57, 1754},
{0xfe58, 1735},
{0xfe59, 1755},
{0xfe5a, 1749},
{0xfe5b, 1750},
{0xfe5c, 1769},
{0xfe5d, 1764},
{0xfe5e, 1777},
{0xfe5f, 1772},
{0xfe60, 1742},
{0xfe61, 1760},
{0xfe62, 1761},
{0xfe63, 1774},
{0xfe64, 1732},
{0xfe65, 1734},
{0xfe66, 1756},
{0xfe67, 1744},
{0xfe68, 1743},
{0xfe69, 1739},
{0xfe6a, 1745},
{0xfe6b, 1738},
{0xfe6c, 1741},
{0xfe6d, 1763},
{0xfe6e, 1740},
{0xfe6f, 1752},
{0xfe70, 50},
{0xfe71, 51},
{0xfe72, 1039},
{0xfe73, 1166},
{0xfe74, 268},
{0xfe75, 1171},
{0xfe76, 916},
{0xfe77, 915},
{0xfe78, 967},
{0xfe79, 968},
{0xfe7a, 240},
{0xfe80, 1731},
{0xfe81, 1726},
{0xfe82, 1757},
{0xfe83, 1727},
{0xfe84, 1762},
{0xfe85, 1728},
{0xfe86, 1768},
{0xfe87, 1729},
{0xfe88, 1776},
{0xfe89, 1730},
{0xfe8a, 1773},
{0xfe8b, 1748},
{0xfe8c, 1759},
{0xfe90, 1766},
{0xfe91, 1736},
{0xfe92, 1746},
{0xfe93, 1765},
{0xfea0, 1708},
{0xfea1, 287},
{0xfea2, 275},
{0xfea3, 1697},
{0xfea4, 277},
{0xfea5, 276},
{0xfed0, 497},
{0xfed1, 1011},
{0xfed2, 933},
{0xfed4, 862},
{0xfed5, 1199},
{0xfee0, 1003},
{0xfee1, 1004},
{0xfee2, 1005},
{0xfee3, 993},
{0xfee4, 1006},
{0xfee5, 1007},
{0xfee6, 994},
{0xfee7, 995},
{0xfee8, 984},
{0xfee9, 979},
{0xfeea, 980},
{0xfeeb, 981},
{0xfeec, 982},
{0xfeed, 983},
{0xfeee, 990},
{0xfeef, 985},
{0xfef0, 986},
{0xfef1, 987},
{0xfef2, 988},
{0xfef3, 989},
{0xfef4, 1001},
{0xfef5, 996},
{0xfef6, 997},
{0xfef7, 998},
{0xfef8, 999},
{0xfef9, 1002},
{0xfefa, 978},
{0xfefb, 991},
{0xfefc, 992},
{0xfefd, 1000},
{0xff08, 262},
{0xff09, 1193},
{0xff0a, 884},
{0xff0b, 288},
{0xff0d, 1041},
{0xff13, 974},
{0xff14, 1063},
{0xff15, 1190},
{0xff1b, 438},
{0xff20, 918},
{0xff21, 842},
{0xff22, 917},
{0xff23, 735},
{0xff24, 1046},
{0xff25, 738},
{0xff26, 844},
{0xff27, 739},
{0xff28, 1370},
{0xff29, 731},
{0xff2a, 1371},
{0xff2b, 1292},
{0xff2c, 902},
{0xff2d, 840},
{0xff2e, 841},
{0xff2f, 432},
{0xff30, 433},
{0xff31, 625},
{0xff32, 711},
{0xff33, 637},
{0xff34, 638},
{0xff35, 672},
{0xff36, 702},
{0xff37, 290},
{0xff38, 673},
{0xff39, 630},
{0xff3a, 691},
{0xff3b, 690},
{0xff3c, 703},
{0xff3d, 680},
{0xff3e, 692},
{0xff3f, 705},
{0xff50, 741},
{0xff51, 882},
{0xff52, 1328},
{0xff53, 1042},
{0xff54, 412},
{0xff55, 972},
{0xff56, 931},
{0xff57, 436},
{0xff58, 264},
{0xff60, 1065},
{0xff61, 1013},
{0xff62, 443},
{0xff63, 797},
{0xff65, 1325},
{0xff66, 1036},
{0xff67, 905},
{0xff68, 496},
{0xff69, 282},
{0xff6a, 734},
{0xff6b, 269},
{0xff7e, 133},
{0xff7f, 936},
{0xff80, 836},
{0xff89, 838},
{0xff8d, 820},
{0xff91, 822},
{0xff92, 823},
{0xff93, 824},
{0xff94, 825},
{0xff95, 826},
{0xff96, 828},
{0xff97, 839},
{0xff98, 834},
{0xff99, 818},
{0xff9a, 832},
{0xff9b, 830},
{0xff9c, 819},
{0xff9d, 814},
{0xff9e, 827},
{0xff9f, 816},
{0xffaa, 829},
{0xffab, 813},
{0xffac, 835},
{0xffad, 837},
{0xffae, 815},
{0xffaf, 817},
{0xffb0, 803},
{0xffb1, 804},
{0xffb2, 805},
{0xffb3, 806},
{0xffb4, 807},
{0xffb5, 808},
{0xffb6, 809},
{0xffb7, 810},
{0xffb8, 811},
{0xffb9, 812},
{0xffbd, 821},
{0xffbe, 446},
{0xffbf, 457},
{0xffc0, 468},
{0xffc1, 475},
{0xffc2, 476},
{0xffc3, 477},
{0xffc4, 478},
{0xffc5, 479},
{0xffc6, 480},
{0xffc7, 447},
{0xffc8, 448},
{0xffc9, 449},
{0xffca, 450},
{0xffcb, 451},
{0xffcc, 452},
{0xffcd, 453},
{0xffce, 454},
{0xffcf, 455},
{0xffd0, 456},
{0xffd1, 458},
{0xffd2, 459},
{0xffd3, 460},
{0xffd4, 461},
{0xffd5, 462},
{0xffd6, 463},
{0xffd7, 464},
{0xffd8, 465},
{0xffd9, 466},
{0xffda, 467},
{0xffdb, 469},
{0xffdc, 470},
{0xffdd, 471},
{0xffde, 472},
{0xffdf, 473},
{0xffe0, 474},
{0xffe1, 1080},
{0xffe2, 1082},
{0xffe3, 294},
{0xffe4, 295},
{0xffe5, 283},
{0xffe6, 1081},
{0xffe7, 909},
{0xffe8, 910},
{0xffe9, 62},
{0xffea, 63},
{0xffeb, 1174},
{0xffec, 1175},
{0xffed, 745},
{0xffee, 746},
{0xfff1, 1429},
{0xfff2, 1431},
{0xfff3, 1432},
{0xfff4, 1433},
{0xfff5, 1434},
{0xfff6, 1435},
{0xfff7, 1436},
{0xfff8, 1437},
{0xfff9, 1438},
{0xfffa, 1430},
{0xffff, 408},
{0xffffff, 1338},
{0x100012c, 791},
{0x100012d, 1925},
{0x1000174, 1344},
{0x1000175, 2252},
{0x1000176, 1359},
{0x1000177, 2260},
{0x100018f, 1052},
{0x100019f, 940},
{0x10001a0, 954},
{0x10001a1, 2088},
{0x10001af, 1304},
{0x10001b0, 2224},
{0x10001b5, 1374},
{0x10001b6, 2272},
{0x10001b7, 417},
{0x10001d1, 942},
{0x10001d2, 2075},
{0x10001e6, 505},
{0x10001e7, 1860},
{0x1000259, 2160},
{0x1000275, 2073},
{0x1000292, 1837},
{0x1000492, 316},
{0x1000493, 368},
{0x1000496, 351},
{0x1000497, 403},
{0x100049a, 326},
{0x100049b, 378},
{0x100049c, 327},
{0x100049d, 379},
{0x10004a2, 312},
{0x10004a3, 364},
{0x10004ae, 343},
{0x10004af, 395},
{0x10004b0, 344},
{0x10004b1, 396},
{0x10004b2, 319},
{0x10004b3, 370},
{0x10004b6, 303},
{0x10004b7, 355},
{0x10004b8, 304},
{0x10004b9, 356},
{0x10004ba, 336},
{0x10004bb, 388},
{0x10004d8, 333},
{0x10004d9, 385},
{0x10004e2, 323},
{0x10004e3, 373},
{0x10004e8, 331},
{0x10004e9, 383},
{0x10004ee, 342},
{0x10004ef, 394},
{0x1000531, 150},
{0x1000532, 151},
{0x1000533, 158},
{0x1000534, 153},
{0x1000535, 184},
{0x1000536, 185},
{0x1000537, 155},
{0x1000538, 149},
{0x1000539, 177},
{0x100053a, 186},
{0x100053b, 161},
{0x100053c, 166},
{0x100053d, 165},
{0x100053e, 178},
{0x100053f, 164},
{0x1000540, 160},
{0x1000541, 154},
{0x1000542, 157},
{0x1000543, 176},
{0x1000544, 167},
{0x1000545, 159},
{0x1000546, 168},
{0x1000547, 175},
{0x1000548, 182},
{0x1000549, 152},
{0x100054a, 170},
{0x100054b, 162},
{0x100054c, 172},
{0x100054d, 174},
{0x100054e, 181},
{0x100054f, 180},
{0x1000550, 173},
{0x1000551, 179},
{0x1000552, 183},
{0x1000553, 171},
{0x1000554, 163},
{0x1000555, 169},
{0x1000556, 156},
{0x100055a, 189},
{0x100055b, 187},
{0x100055c, 188},
{0x100055d, 193},
{0x100055e, 216},
{0x1000561, 191},
{0x1000562, 192},
{0x1000563, 202},
{0x1000564, 195},
{0x1000565, 235},
{0x1000566, 237},
{0x1000567, 197},
{0x1000568, 190},
{0x1000569, 227},
{0x100056a, 238},
{0x100056b, 206},
{0x100056c, 212},
{0x100056d, 210},
{0x100056e, 228},
{0x100056f, 209},
{0x1000570, 204},
{0x1000571, 196},
{0x1000572, 201},
{0x1000573, 226},
{0x1000574, 213},
{0x1000575, 203},
{0x1000576, 214},
{0x1000577, 224},
{0x1000578, 233},
{0x1000579, 194},
{0x100057a, 217},
{0x100057b, 207},
{0x100057c, 220},
{0x100057d, 222},
{0x100057e, 232},
{0x100057f, 230},
{0x1000580, 221},
{0x1000581, 229},
{0x1000582, 234},
{0x1000583, 218},
{0x1000584, 208},
{0x1000585, 215},
{0x1000586, 199},
{0x1000587, 211},
{0x1000589, 200},
{0x100058a, 205},
{0x1000653, 115},
{0x1000654, 98},
{0x1000655, 99},
{0x1000660, 68},
{0x1000661, 69},
{0x1000662, 70},
{0x1000663, 71},
{0x1000664, 72},
{0x1000665, 73},
{0x1000666, 74},
{0x1000667, 75},
{0x1000668, 76},
{0x1000669, 77},
{0x100066a, 121},
{0x1000670, 132},
{0x1000679, 141},
{0x100067e, 120},
{0x1000686, 136},
{0x1000688, 87},
{0x1000691, 125},
{0x1000698, 108},
{0x10006a4, 142},
{0x10006a9, 112},
{0x10006af, 93},
{0x10006ba, 119},
{0x10006be, 105},
{0x10006c1, 106},
{0x10006cc, 88},
{0x10006d2, 145},
{0x10006d4, 92},
{0x10006f0, 483},
{0x10006f1, 484},
{0x10006f2, 485},
{0x10006f3, 486},
{0x10006f4, 487},
{0x10006f5, 488},
{0x10006f6, 489},
{0x10006f7, 490},
{0x10006f8, 491},
{0x10006f9, 492},
{0x1000d82, 1135},
{0x1000d83, 1112},
{0x1000d85, 1085},
{0x1000d86, 1086},
{0x1000d87, 1088},
{0x1000d88, 1090},
{0x1000d89, 1114},
{0x1000d8a, 1116},
{0x1000d8b, 1159},
{0x1000d8c, 1161},
{0x1000d8d, 1148},
{0x1000d8e, 1149},
{0x1000d8f, 1126},
{0x1000d90, 1128},
{0x1000d91, 1105},
{0x1000d92, 1107},
{0x1000d93, 1092},
{0x1000d94, 1141},
{0x1000d95, 1143},
{0x1000d96, 1095},
{0x1000d9a, 1121},
{0x1000d9b, 1122},
{0x1000d9c, 1110},
{0x1000d9d, 1111},
{0x1000d9e, 1136},
{0x1000d9f, 1137},
{0x1000da0, 1099},
{0x1000da1, 1100},
{0x1000da2, 1118},
{0x1000da3, 1119},
{0x1000da4, 1140},
{0x1000da5, 1120},
{0x1000da6, 1138},
{0x1000da7, 1157},
{0x1000da8, 1158},
{0x1000da9, 1101},
{0x1000daa, 1102},
{0x1000dab, 1139},
{0x1000dac, 1133},
{0x1000dad, 1155},
{0x1000dae, 1156},
{0x1000daf, 1103},
{0x1000db0, 1104},
{0x1000db1, 1132},
{0x1000db3, 1134},
{0x1000db4, 1145},
{0x1000db5, 1146},
{0x1000db6, 1097},
{0x1000db7, 1098},
{0x1000db8, 1130},
{0x1000db9, 1131},
{0x1000dba, 1164},
{0x1000dbb, 1147},
{0x1000dbd, 1124},
{0x1000dc0, 1163},
{0x1000dc1, 1153},
{0x1000dc2, 1154},
{0x1000dc3, 1152},
{0x1000dc4, 1113},
{0x1000dc5, 1125},
{0x1000dc6, 1109},
{0x1000dca, 1094},
{0x1000dcf, 1087},
{0x1000dd0, 1089},
{0x1000dd1, 1091},
{0x1000dd2, 1115},
{0x1000dd3, 1117},
{0x1000dd4, 1160},
{0x1000dd6, 1162},
{0x1000dd8, 1150},
{0x1000dd9, 1106},
{0x1000dda, 1108},
{0x1000ddb, 1093},
{0x1000ddc, 1142},
{0x1000ddd, 1144},
{0x1000dde, 1096},
{0x1000ddf, 1127},
{0x1000df2, 1151},
{0x1000df3, 1129},
{0x1000df4, 1123},
{0x10010d0, 508},
{0x10010d1, 509},
{0x10010d2, 517},
{0x10010d3, 514},
{0x10010d4, 515},
{0x10010d5, 542},
{0x10010d6, 545},
{0x10010d7, 539},
{0x10010d8, 524},
{0x10010d9, 527},
{0x10010da, 529},
{0x10010db, 530},
{0x10010dc, 531},
{0x10010dd, 532},
{0x10010de, 533},
{0x10010df, 546},
{0x10010e0, 536},
{0x10010e1, 537},
{0x10010e2, 540},
{0x10010e3, 541},
{0x10010e4, 534},
{0x10010e5, 528},
{0x10010e6, 518},
{0x10010e7, 535},
{0x10010e8, 538},
{0x10010e9, 512},
{0x10010ea, 510},
{0x10010eb, 526},
{0x10010ec, 513},
{0x10010ed, 511},
{0x10010ee, 544},
{0x10010ef, 525},
{0x10010f0, 519},
{0x10010f1, 521},
{0x10010f2, 522},
{0x10010f3, 543},
{0x10010f4, 520},
{0x10010f5, 523},
{0x10010f6, 516},
{0x1001e02, 259},
{0x1001e03, 1409},
{0x1001e0a, 406},
{0x1001e0b, 1723},
{0x1001e1e, 482},
{0x1001e1f, 1839},
{0x1001e36, 879},
{0x1001e37, 2018},
{0x1001e40, 891},
{0x1001e41, 2042},
{0x1001e56, 970},
{0x1001e57, 2114},
{0x1001e60, 1053},
{0x1001e61, 2156},
{0x1001e6a, 1194},
{0x1001e6b, 2184},
{0x1001e80, 1347},
{0x1001e81, 2254},
{0x1001e82, 1342},
{0x1001e83, 2251},
{0x1001e84, 1345},
{0x1001e85, 2253},
{0x1001e8a, 1354},
{0x1001e8b, 2256},
{0x1001ea0, 43},
{0x1001ea1, 1377},
{0x1001ea2, 61},
{0x1001ea3, 1395},
{0x1001ea4, 53},
{0x1001ea5, 1386},
{0x1001ea6, 55},
{0x1001ea7, 1388},
{0x1001ea8, 56},
{0x1001ea9, 1389},
{0x1001eaa, 57},
{0x1001eab, 1390},
{0x1001eac, 54},
{0x1001ead, 1387},
{0x1001eae, 45},
{0x1001eaf, 1380},
{0x1001eb0, 47},
{0x1001eb1, 1382},
{0x1001eb2, 48},
{0x1001eb3, 1383},
{0x1001eb4, 49},
{0x1001eb5, 1384},
{0x1001eb6, 46},
{0x1001eb7, 1381},
{0x1001eb8, 420},
{0x1001eb9, 1799},
{0x1001eba, 431},
{0x1001ebb, 1809},
{0x1001ebc, 440},
{0x1001ebd, 1834},
{0x1001ebe, 423},
{0x1001ebf, 1802},
{0x1001ec0, 425},
{0x1001ec1, 1804},
{0x1001ec2, 426},
{0x1001ec3, 1805},
{0x1001ec4, 427},
{0x1001ec5, 1806},
{0x1001ec6, 424},
{0x1001ec7, 1803},
{0x1001ec8, 795},
{0x1001ec9, 1932},
{0x1001eca, 790},
{0x1001ecb, 1924},
{0x1001ecc, 941},
{0x1001ecd, 2074},
{0x1001ece, 953},
{0x1001ecf, 2087},
{0x1001ed0, 944},
{0x1001ed1, 2077},
{0x1001ed2, 946},
{0x1001ed3, 2079},
{0x1001ed4, 947},
{0x1001ed5, 2080},
{0x1001ed6, 948},
{0x1001ed7, 2081},
{0x1001ed8, 945},
{0x1001ed9, 2078},
{0x1001eda, 955},
{0x1001edb, 2089},
{0x1001edc, 957},
{0x1001edd, 2091},
{0x1001ede, 958},
{0x1001edf, 2092},
{0x1001ee0, 959},
{0x1001ee1, 2093},
{0x1001ee2, 956},
{0x1001ee3, 2090},
{0x1001ee4, 1297},
{0x1001ee5, 2217},
{0x1001ee6, 1303},
{0x1001ee7, 2223},
{0x1001ee8, 1305},
{0x1001ee9, 2225},
{0x1001eea, 1307},
{0x1001eeb, 2227},
{0x1001eec, 1308},
{0x1001eed, 2228},
{0x1001eee, 1309},
{0x1001eef, 2229},
{0x1001ef0, 1306},
{0x1001ef1, 2226},
{0x1001ef2, 1362},
{0x1001ef3, 2263},
{0x1001ef4, 1358},
{0x1001ef5, 2259},
{0x1001ef6, 1363},
{0x1001ef7, 2264},
{0x1001ef8, 1364},
{0x1001ef9, 2265},
{0x1002070, 2271},
{0x1002074, 1854},
{0x1002075, 1851},
{0x1002076, 2175},
{0x1002077, 2169},
{0x1002078, 1811},
{0x1002079, 2060},
{0x1002080, 2270},
{0x1002081, 2100},
{0x1002082, 2212},
{0x1002083, 2195},
{0x1002084, 1853},
{0x1002085, 1850},
{0x1002086, 2174},
{0x1002087, 2168},
{0x1002088, 1810},
{0x1002089, 2059},
{0x10020a0, 428},
{0x10020a1, 291},
{0x10020a2, 297},
{0x10020a3, 481},
{0x10020a4, 885},
{0x10020a5, 911},
{0x10020a6, 925},
{0x10020a7, 975},
{0x10020a8, 1050},
{0x10020a9, 1351},
{0x10020aa, 929},
{0x10020ab, 411},
{0x1002202, 2118},
{0x1002205, 1822},
{0x1002208, 1812},
{0x1002209, 2064},
{0x100220b, 1715},
{0x100221a, 2179},
{0x100221b, 1719},
{0x100221c, 1855},
{0x100222c, 1783},
{0x100222d, 2197},
{0x1002235, 1413},
{0x1002247, 2063},
{0x1002248, 1400},
{0x1002262, 2066},
{0x1002263, 2182},
{0x1002800, 1428},
{0x1002801, 1439},
{0x1002802, 1567},
{0x1002803, 1440},
{0x1002804, 1631},
{0x1002805, 1504},
{0x1002806, 1568},
{0x1002807, 1441},
{0x1002808, 1663},
{0x1002809, 1536},
{0x100280a, 1600},
{0x100280b, 1473},
{0x100280c, 1632},
{0x100280d, 1505},
{0x100280e, 1569},
{0x100280f, 1442},
{0x1002810, 1679},
{0x1002811, 1552},
{0x1002812, 1616},
{0x1002813, 1489},
{0x1002814, 1648},
{0x1002815, 1521},
{0x1002816, 1585},
{0x1002817, 1458},
{0x1002818, 1664},
{0x1002819, 1537},
{0x100281a, 1601},
{0x100281b, 1474},
{0x100281c, 1633},
{0x100281d, 1506},
{0x100281e, 1570},
{0x100281f, 1443},
{0x1002820, 1687},
{0x1002821, 1560},
{0x1002822, 1624},
{0x1002823, 1497},
{0x1002824, 1656},
{0x1002825, 1529},
{0x1002826, 1593},
{0x1002827, 1466},
{0x1002828, 1672},
{0x1002829, 1545},
{0x100282a, 1609},
{0x100282b, 1482},
{0x100282c, 1641},
{0x100282d, 1514},
{0x100282e, 1578},
{0x100282f, 1451},
{0x1002830, 1680},
{0x1002831, 1553},
{0x1002832, 1617},
{0x1002833, 1490},
{0x1002834, 1649},
{0x1002835, 1522},
{0x1002836, 1586},
{0x1002837, 1459},
{0x1002838, 1665},
{0x1002839, 1538},
{0x100283a, 1602},
{0x100283b, 1475},
{0x100283c, 1634},
{0x100283d, 1507},
{0x100283e, 1571},
{0x100283f, 1444},
{0x1002840, 1691},
{0x1002841, 1564},
{0x1002842, 1628},
{0x1002843, 1501},
{0x1002844, 1660},
{0x1002845, 1533},
{0x1002846, 1597},
{0x1002847, 1470},
{0x1002848, 1676},
{0x1002849, 1549},
{0x100284a, 1613},
{0x100284b, 1486},
{0x100284c, 1645},
{0x100284d, 1518},
{0x100284e, 1582},
{0x100284f, 1455},
{0x1002850, 1684},
{0x1002851, 1557},
{0x1002852, 1621},
{0x1002853, 1494},
{0x1002854, 1653},
{0x1002855, 1526},
{0x1002856, 1590},
{0x1002857, 1463},
{0x1002858, 1669},
{0x1002859, 1542},
{0x100285a, 1606},
{0x100285b, 1479},
{0x100285c, 1638},
{0x100285d, 1511},
{0x100285e, 1575},
{0x100285f, 1448},
{0x1002860, 1688},
{0x1002861, 1561},
{0x1002862, 1625},
{0x1002863, 1498},
{0x1002864, 1657},
{0x1002865, 1530},
{0x1002866, 1594},
{0x1002867, 1467},
{0x1002868, 1673},
{0x1002869, 1546},
{0x100286a, 1610},
{0x100286b, 1483},
{0x100286c, 1642},
{0x100286d, 1515},
{0x100286e, 1579},
{0x100286f, 1452},
{0x1002870, 1681},
{0x1002871, 1554},
{0x1002872, 1618},
{0x1002873, 1491},
{0x1002874, 1650},
{0x1002875, 1523},
{0x1002876, 1587},
{0x1002877, 1460},
{0x1002878, 1666},
{0x1002879, 1539},
{0x100287a, 1603},
{0x100287b, 1476},
{0x100287c, 1635},
{0x100287d, 1508},
{0x100287e, 1572},
{0x100287f, 1445},
{0x1002880, 1693},
{0x1002881, 1566},
{0x1002882, 1630},
{0x1002883, 1503},
{0x1002884, 1662},
{0x1002885, 1535},
{0x1002886, 1599},
{0x1002887, 1472},
{0x1002888, 1678},
{0x1002889, 1551},
{0x100288a, 1615},
{0x100288b, 1488},
{0x100288c, 1647},
{0x100288d, 1520},
{0x100288e, 1584},
{0x100288f, 1457},
{0x1002890, 1686},
{0x1002891, 1559},
{0x1002892, 1623},
{0x1002893, 1496},
{0x1002894, 1655},
{0x1002895, 1528},
{0x1002896, 1592},
{0x1002897, 1465},
{0x1002898, 1671},
{0x1002899, 1544},
{0x100289a, 1608},
{0x100289b, 1481},
{0x100289c, 1640},
{0x100289d, 1513},
{0x100289e, 1577},
{0x100289f, 1450},
{0x10028a0, 1690},
{0x10028a1, 1563},
{0x10028a2, 1627},
{0x10028a3, 1500},
{0x10028a4, 1659},
{0x10028a5, 1532},
{0x10028a6, 1596},
{0x10028a7, 1469},
{0x10028a8, 1675},
{0x10028a9, 1548},
{0x10028aa, 1612},
{0x10028ab, 1485},
{0x10028ac, 1644},
{0x10028ad, 1517},
{0x10028ae, 1581},
{0x10028af, 1454},
{0x10028b0, 1683},
{0x10028b1, 1556},
{0x10028b2, 1620},
{0x10028b3, 1493},
{0x10028b4, 1652},
{0x10028b5, 1525},
{0x10028b6, 1589},
{0x10028b7, 1462},
{0x10028b8, 1668},
{0x10028b9, 1541},
{0x10028ba, 1605},
{0x10028bb, 1478},
{0x10028bc, 1637},
{0x10028bd, 1510},
{0x10028be, 1574},
{0x10028bf, 1447},
{0x10028c0, 1692},
{0x10028c1, 1565},
{0x10028c2, 1629},
{0x10028c3, 1502},
{0x10028c4, 1661},
{0x10028c5, 1534},
{0x10028c6, 1598},
{0x10028c7, 1471},
{0x10028c8, 1677},
{0x10028c9, 1550},
{0x10028ca, 1614},
{0x10028cb, 1487},
{0x10028cc, 1646},
{0x10028cd, 1519},
{0x10028ce, 1583},
{0x10028cf, 1456},
{0x10028d0, 1685},
{0x10028d1, 1558},
{0x10028d2, 1622},
{0x10028d3, 1495},
{0x10028d4, 1654},
{0x10028d5, 1527},
{0x10028d6, 1591},
{0x10028d7, 1464},
{0x10028d8, 1670},
{0x10028d9, 1543},
{0x10028da, 1607},
{0x10028db, 1480},
{0x10028dc, 1639},
{0x10028dd, 1512},
{0x10028de, 1576},
{0x10028df, 1449},
{0x10028e0, 1689},
{0x10028e1, 1562},
{0x10028e2, 1626},
{0x10028e3, 1499},
{0x10028e4, 1658},
{0x10028e5, 1531},
{0x10028e6, 1595},
{0x10028e7, 1468},
{0x10028e8, 1674},
{0x10028e9, 1547},
{0x10028ea, 1611},
{0x10028eb, 1484},
{0x10028ec, 1643},
{0x10028ed, 1516},
{0x10028ee, 1580},
{0x10028ef, 1453},
{0x10028f0, 1682},
{0x10028f1, 1555},
{0x10028f2, 1619},
{0x10028f3, 1492},
{0x10028f4, 1651},
{0x10028f5, 1524},
{0x10028f6, 1588},
{0x10028f7, 1461},
{0x10028f8, 1667},
{0x10028f9, 1540},
{0x10028fa, 1604},
{0x10028fb, 1477},
{0x10028fc, 1636},
{0x10028fd, 1509},
{0x10028fe, 1573},
{0x10028ff, 1446},
{0x1008fe01, 1178},
{0x1008fe02, 1182},
{0x1008fe03, 1183},
{0x1008fe04, 1184},
{0x1008fe05, 1185},
{0x1008fe06, 1186},
{0x1008fe07, 1187},
{0x1008fe08, 1188},
{0x1008fe09, 1189},
{0x1008fe0a, 1179},
{0x1008fe0b, 1180},
{0x1008fe0c, 1181},
{0x1008fe20, 1326},
{0x1008fe21, 1350},
{0x1008fe22, 932},
{0x1008fe23, 1010},
{0x1008fe24, 888},
{0x1008fe25, 886},
{0x1008ff02, 914},
{0x1008ff03, 913},
{0x1008ff04, 847},
{0x1008ff05, 846},
{0x1008ff06, 845},
{0x1008ff10, 1169},
{0x1008ff11, 243},
{0x1008ff12, 246},
{0x1008ff13, 251},
{0x1008ff14, 249},
{0x1008ff15, 256},
{0x1008ff16, 250},
{0x1008ff17, 247},
{0x1008ff18, 742},
{0x1008ff19, 899},
{0x1008ff1a, 1170},
{0x1008ff1b, 1064},
{0x1008ff1c, 253},
{0x1008ff1d, 280},
{0x1008ff1e, 904},
{0x1008ff1f, 1286},
{0x1008ff20, 281},
{0x1008ff21, 1008},
{0x1008ff22, 293},
{0x1008ff23, 1045},
{0x1008ff24, 1043},
{0x1008ff25, 1044},
{0x1008ff26, 260},
{0x1008ff27, 498},
{0x1008ff28, 1172},
{0x1008ff29, 1037},
{0x1008ff2a, 1009},
{0x1008ff2b, 1343},
{0x1008ff2c, 434},
{0x1008ff2d, 1059},
{0x1008ff2e, 1341},
{0x1008ff2f, 1165},
{0x1008ff30, 494},
{0x1008ff31, 248},
{0x1008ff32, 244},
{0x1008ff33, 921},
{0x1008ff34, 1335},
{0x1008ff35, 883},
{0x1008ff36, 1083},
{0x1008ff37, 740},
{0x1008ff38, 963},
{0x1008ff39, 58},
{0x1008ff3a, 743},
{0x1008ff3b, 270},
{0x1008ff3c, 495},
{0x1008ff3d, 292},
{0x1008ff3e, 255},
{0x1008ff3f, 261},
{0x1008ff40, 863},
{0x1008ff41, 864},
{0x1008ff42, 865},
{0x1008ff43, 866},
{0x1008ff44, 867},
{0x1008ff45, 868},
{0x1008ff46, 869},
{0x1008ff47, 870},
{0x1008ff48, 871},
{0x1008ff49, 872},
{0x1008ff4a, 873},
{0x1008ff4b, 874},
{0x1008ff4c, 875},
{0x1008ff4d, 876},
{0x1008ff4e, 877},
{0x1008ff4f, 878},
{0x1008ff50, 66},
{0x1008ff51, 67},
{0x1008ff52, 267},
{0x1008ff53, 274},
{0x1008ff55, 1349},
{0x1008ff56, 289},
{0x1008ff57, 296},
{0x1008ff58, 298},
{0x1008ff59, 409},
{0x1008ff5a, 405},
{0x1008ff5b, 410},
{0x1008ff5c, 442},
{0x1008ff5d, 444},
{0x1008ff5e, 503},
{0x1008ff5f, 547},
{0x1008ff60, 1922},
{0x1008ff61, 887},
{0x1008ff62, 901},
{0x1008ff63, 903},
{0x1008ff65, 906},
{0x1008ff66, 907},
{0x1008ff67, 922},
{0x1008ff68, 928},
{0x1008ff69, 930},
{0x1008ff6a, 951},
{0x1008ff6b, 962},
{0x1008ff6c, 964},
{0x1008ff6d, 973},
{0x1008ff6e, 976},
{0x1008ff72, 1040},
{0x1008ff73, 1038},
{0x1008ff74, 1047},
{0x1008ff75, 1049},
{0x1008ff76, 1048},
{0x1008ff77, 1055},
{0x1008ff78, 1062},
{0x1008ff79, 1061},
{0x1008ff7a, 1060},
{0x1008ff7b, 1067},
{0x1008ff7c, 1167},
{0x1008ff7d, 1168},
{0x1008ff7e, 1176},
{0x1008ff7f, 1195},
{0x1008ff80, 1198},
{0x1008ff81, 1287},
{0x1008ff82, 1293},
{0x1008ff84, 1332},
{0x1008ff85, 1330},
{0x1008ff86, 1331},
{0x1008ff87, 1336},
{0x1008ff88, 1348},
{0x1008ff89, 1352},
{0x1008ff8a, 1355},
{0x1008ff8b, 1372},
{0x1008ff8c, 1373},
{0x1008ff8d, 257},
{0x1008ff8e, 908},
{0x1008ff8f, 1346},
{0x1008ff90, 900},
{0x1008ff91, 977},
{0x1008ff92, 920},
{0x1008ff93, 263},
{0x1008ff94, 266},
{0x1008ff95, 1340},
{0x1008ff97, 242},
{0x1008ff98, 254},
{0x1008ff99, 252},
{0x1008ff9a, 1173},
{0x1008ff9b, 241},
{0x1008ff9c, 299},
{0x1008ff9d, 499},
{0x1008ff9e, 500},
{0x1008ff9f, 1285},
{0x1008ffa0, 1066},
{0x1008ffa1, 1337},
{0x1008ffa2, 1288},
{0x1008ffa3, 1035},
{0x1008ffa4, 623},
{0x1008ffa5, 1361},
{0x1008ffa6, 265},
{0x1008ffa7, 1177},
{0x1008ffa8, 737},
{0x1008ffa9, 1291},
{0x1008ffb0, 1290},
{0x1008ffb1, 1289},
{0x1008ffb2, 245},
};

#ifdef __cplusplus
}
#endif

#endif
