/*
 * Copyright © 2012 Collabora, Ltd.
 * Copyright © 2008 Kristian Høgsberg
 * Copyright © 2014 David FORT <contact@hardening-consulting.com>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of the copyright holders not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no representations
 * about the suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#include <uwac/config.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "uwac-utils.h"

/*
 * This part is an adaptation of client/window.c from the weston project.
 */

static void* fail_on_null(void* p)
{
	if (p == NULL)
	{
		(void)fprintf(stderr, "out of memory\n");
		exit(EXIT_FAILURE);
	}

	return p;
}

void* xmalloc(size_t s)
{
	return fail_on_null(malloc(s));
}

void* xzalloc(size_t s)
{
	return fail_on_null(zalloc(s));
}

char* xstrdup(const char* s)
{
	return fail_on_null(strdup(s));
}

void* xrealloc(void* p, size_t s)
{
	return fail_on_null(realloc(p, s));
}
