/* FragmentsCrystal.c */
/**********************************************************************************************************
Copyright (c) 2002-2013 Abdul-Rahman Allouche. All rights reserved

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the Gabedit), to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all copies or substantial portions
  of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
************************************************************************************************************/


#include "../../Config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "../Common/GabeditType.h"
#include "../Utils/Utils.h"
#include "../Utils/Vector3d.h"
#include "../Geometry/Fragments.h"
#include "../MolecularMechanics/PDBTemplate.h"
#include "../Geometry/DrawGeom.h"
#include "../MolecularMechanics/CalculTypesAmber.h"

#define ANG_TO_BOHR  1.0/0.52917726
/*****************************************************************************/
static void SetResidue(Fragment* Frag,gchar* name)
{
	gint i;
	for(i=0;i<Frag->NAtoms;i++)
		Frag->Atoms[i].Residue = g_strdup(name);

}
/********************************************************************************/
/*
static void SetMMTypes(Fragment* Frag)
{
	gint i;
	gchar* residue = NULL;
	gdouble charge;
	if(Frag->NAtoms<1) return;
	residue = Frag->Atoms[0].Residue;

	for(i=0;i<Frag->NAtoms;i++)
	{
		if(Frag->Atoms[i].mmType) g_free(Frag->Atoms[i].mmType);
		Frag->Atoms[i].mmType = getMMTypeFromPDBTpl(residue, Frag->Atoms[i].pdbType,&charge);
		if(strcmp(Frag->Atoms[i].mmType,"UNK"))  Frag->Atoms[i].Charge = charge;
	}
	for(i=0;i<Frag->NAtoms;i++)
		if(!strcmp(Frag->Atoms[i].mmType,"UNK")) break;
	if(i!=Frag->NAtoms) calculTypesAmberForAFragment(Frag);

}
*/
/********************************************************************************/
static void SetAtom(Atom* A,gchar* symb,gdouble x,gdouble y,gdouble z,gdouble charge)
{
	A->mmType = g_strdup(symb);
	A->pdbType = g_strdup(symb);
	A->Symb = g_strdup(symb);
	if(strlen(A->Symb)>0) A->Symb[0] = toupper(symb[0]);
	if(strlen(A->Symb)>1) A->Symb[1] = tolower(symb[1]);
	if(strlen(A->Symb)>2) A->Symb[2] = tolower(symb[2]);

	A->Coord[0] = (gdouble)x*(gdouble)ANG_TO_BOHR;
	A->Coord[1] = (gdouble)y*(gdouble)ANG_TO_BOHR;
	A->Coord[2] = (gdouble)z*(gdouble)ANG_TO_BOHR;
	A->Charge = charge;
}
/*****************************************************************/
static void initFragment(Fragment* F)
{

	F->NAtoms = 0;
	F->Atoms = NULL;
	F->atomToDelete = -1;
	F->atomToBondTo = -1;
	F->angleAtom    = -1;
}
/*****************************************************************/
Fragment GetFragmentPrototypeCrystals(gchar* Name)
{
	Fragment F;
	gchar T[100]="UNK";
	gint i;

	initFragment(&F);
	if(!strcmp(Name,"Fe23Zr6_cF116_Fm-3m_225")){
		F.NAtoms =32;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Fe", 5.32362810,3.07359812, 2.17336207, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Fe", 4.13325576,2.38633633, 0.22949219, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Fe", 2.94288343,3.07359812, 2.17336207, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Fe", 4.13325576,1.01181275, 2.17336207, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Fe", 11.20937807,6.47173745, 4.57620944, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Fe", 12.39975056,7.15899932, 6.52007957, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Fe", 12.39975056,8.53352308, 4.57620944, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Fe", 13.59012305,6.47173745, 4.57620944, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Fe", 4.13325167,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Fe", 4.13325167,4.77266793, 3.37478585, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Fe", 2.06662583,3.57950094, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Fe", 2.06662583,1.19316698, 3.37478585, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Fe", 6.19987750,1.19316698, 3.37478585, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Fe", 6.19987750,3.57950094, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Fe", 2.01702683,1.16453098, 0.82344776, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Fe", 4.13325588,2.38633640, 4.27923533, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Fe", 6.24948494,1.16453098, 0.82344776, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Fe", 4.13325588,4.82994722, 0.82344776, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Fe", 14.51598020,8.38080508, 5.92612410, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Fe", 12.39975118,7.15899968, 2.47033658, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Fe", 12.39975118,4.71538889, 5.92612410, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Fe", 10.28352216,8.38080508, 5.92612410, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Fe", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Zr", 8.26650333,2.83496466, 2.00462274, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Zr", 8.26650333,6.71037119, 4.74494897, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Zr", 6.58840308,5.74151956, 2.00462274, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Zr", 6.58840308,3.80381629, 4.74494897, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Zr", 9.94460359,3.80381629, 4.74494897, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Zr", 9.94460359,5.74151956, 2.00462274, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "Tv", 8.26650333,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "Tv", 4.13325167,7.15900189, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "Tv", 4.13325167,2.38633396, 6.74957171, 0.00000000);
	}
	else if(!strcmp(Name,"CaF2_cF12_Fm-3m_225")){
		F.NAtoms =6;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ca", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "F", 1.36577500,1.36577500, 1.36577500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "F", 4.09732500,4.09732500, 4.09732500, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.73155000, 2.73155000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.73155000,0.00000000, 2.73155000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 2.73155000,2.73155000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"AlCu2Mn_cF16_Fm-3m_225")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Al", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Cu", 1.48750000,1.48750000, 1.48750000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Cu", 4.46250000,4.46250000, 4.46250000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Mn", 2.97500000,2.97500000, 2.97500000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,2.97500000, 2.97500000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 2.97500000,0.00000000, 2.97500000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 2.97500000,2.97500000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"BiF3_cF16_Fm-3m_225")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Bi", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "F", 2.92650000,2.92650000, 2.92650000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "F", 1.46325000,1.46325000, 1.46325000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "F", 4.38975000,4.38975000, 4.38975000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,2.92650000, 2.92650000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 2.92650000,0.00000000, 2.92650000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 2.92650000,2.92650000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Cu2Mg_cF24_Fd-3m_227")){
		F.NAtoms =9;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cu", 3.51000000,1.75500000, 1.75500000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Cu", 1.75500000,3.51000000, 1.75500000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Cu", 1.75500000,1.75500000, 3.51000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Cu", 3.51000000,3.51000000, 3.51000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Mg", 0.87750000,0.87750000, 0.87750000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Mg", 6.14250000,6.14250000, 6.14250000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,3.51000000, 3.51000000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Tv", 3.51000000,0.00000000, 3.51000000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", 3.51000000,3.51000000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"H2O_Ic_cF24_Fd-3m_227")){
		F.NAtoms =27;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "O", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", 0.00000000,3.17549992, 3.17549992, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 3.17549992,3.17549992, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 3.17549992,0.00000000, 3.17549992, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 4.76324987,1.58774996, 4.76324987, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 1.58774996,1.58774996, 1.58774996, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 1.58774996,4.76324987, 4.76324987, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 4.76324987,4.76324987, 1.58774996, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "H", 0.79387498,0.79387498, 0.79387498, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "H", 5.55712485,2.38162494, 3.96937490, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "H", 2.38162494,3.96937490, 5.55712485, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "H", 3.96937490,5.55712485, 2.38162494, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "H", 2.38162494,5.55712485, 3.96937490, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "H", 5.55712485,3.96937490, 2.38162494, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "H", 3.96937490,2.38162494, 5.55712485, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "H", 0.79387498,3.96937490, 3.96937490, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "H", 5.55712485,5.55712485, 0.79387498, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "H", 2.38162494,0.79387498, 2.38162494, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "H", 2.38162494,2.38162494, 0.79387498, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "H", 5.55712485,0.79387498, 5.55712485, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "H", 3.96937490,0.79387498, 3.96937490, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "H", 0.79387498,5.55712485, 5.55712485, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "H", 0.79387498,2.38162494, 2.38162494, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "H", 3.96937490,3.96937490, 0.79387498, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Tv", 6.35099983,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Tv", 0.00000000,6.35099983, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Tv", 0.00000000,0.00000000, 6.35099983, 0.00000000);
	}
	else if(!strcmp(Name,"Cu_cF4_Fm-3m_225")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cu", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,1.80745500, 1.80745500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.80745500,0.00000000, 1.80745500, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.80745500,1.80745500, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"MgAl2O4_cF25_Fd3m_227")){
		F.NAtoms =17;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Al", 4.04160000,2.02080000, 2.02080000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Al", 2.02080000,4.04160000, 2.02080000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Al", 2.02080000,2.02080000, 4.04160000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Al", 4.04160000,4.04160000, 4.04160000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Mg", 1.01040000,1.01040000, 1.01040000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Mg", 7.07280000,7.07280000, 7.07280000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 2.12103168,2.12103168, 2.12103168, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 3.94136832,3.94136832, 2.12103168, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 4.14183168,5.96216832, 4.14183168, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 3.94136832,2.12103168, 3.94136832, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 5.96216832,4.14183168, 4.14183168, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 2.12103168,3.94136832, 3.94136832, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 4.14183168,4.14183168, 5.96216832, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 5.96216832,5.96216832, 5.96216832, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Tv", 0.00000000,4.04160000, 4.04160000, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Tv", 4.04160000,0.00000000, 4.04160000, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Tv", 4.04160000,4.04160000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"C_cF8_Fs-3m_227")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "C", 0.44375000,0.44375000, 0.44375000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "C", 3.10625000,3.10625000, 3.10625000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 0.00000000,1.77500000, 1.77500000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.77500000,0.00000000, 1.77500000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 1.77500000,1.77500000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"NaCl_cF8_Fm-3m_225")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cl", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Na", 2.81965340,2.81965340, 2.81965340, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 0.00000000,2.81965340, 2.81965340, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.81965340,0.00000000, 2.81965340, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.81965340,2.81965340, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"ZnS_cF8_F-43m_216")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "S", 1.35232500,1.35232500, 1.35232500, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Zn", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 0.00000000,2.70465000, 2.70465000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.70465000,0.00000000, 2.70465000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.70465000,2.70465000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Al2Co3O12Si3_cI160_Ia-3d_230")){
		F.NAtoms =83;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Al", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Al", 0.00000000,5.72985000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Al", 5.72985000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Al", 0.00000000,0.00000000, 5.72985000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Al", -2.86492500,2.86492500, 2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Al", 2.86492500,2.86492500, 2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Al", 2.86492500,2.86492500, -2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Al", 2.86492500,-2.86492500, 2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Co", 1.43246250,-0.00000000, 2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Co", -1.43246250,5.72985000, 2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Co", 2.86492500,1.43246250, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Co", 2.86492500,-1.43246250, 5.72985000, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Co", -0.00000000,2.86492500, 1.43246250, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Co", 5.72985000,2.86492500, -1.43246250, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Co", 4.29738750,5.72985000, 2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Co", 7.16231250,-0.00000000, 2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Co", 2.86492500,4.29738750, 5.72985000, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Co", 2.86492500,7.16231250, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Co", 5.72985000,2.86492500, 4.29738750, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Co", -0.00000000,2.86492500, 7.16231250, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "O", 3.97766187,5.34480408, 0.58673664, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "O", 7.48203813,0.38504592, 0.58673664, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "O", 1.75218813,5.34480408, -0.58673664, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "O", 3.97766187,6.11489592, 5.14311336, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "O", 0.58673664,3.97766187, 5.34480408, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "O", 0.58673664,7.48203813, 0.38504592, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "O", -0.58673664,1.75218813, 5.34480408, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "O", 5.14311336,3.97766187, 6.11489592, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "O", 5.34480408,0.58673664, 3.97766187, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "O", 0.38504592,0.58673664, 7.48203813, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "O", 5.34480408,-0.58673664, 1.75218813, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "O", 6.11489592,5.14311336, 3.97766187, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "O", 2.47987908,6.84258687, 2.27818836, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "O", 8.97982092,-1.11273687, 2.27818836, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "O", 2.47987908,4.61711313, 3.45166164, 0.00000000);
		SetAtom(&F.Atoms[ 35 ], "O", 3.24997092,6.84258687, -2.27818836, 0.00000000);
		SetAtom(&F.Atoms[ 36 ], "O", 6.84258687,-2.27818836, 3.24997092, 0.00000000);
		SetAtom(&F.Atoms[ 37 ], "O", 4.61711313,3.45166164, 2.47987908, 0.00000000);
		SetAtom(&F.Atoms[ 38 ], "O", -1.11273687,2.27818836, 8.97982092, 0.00000000);
		SetAtom(&F.Atoms[ 39 ], "O", 6.84258687,2.27818836, 2.47987908, 0.00000000);
		SetAtom(&F.Atoms[ 40 ], "O", 3.45166164,2.47987908, 4.61711313, 0.00000000);
		SetAtom(&F.Atoms[ 41 ], "O", -2.27818836,3.24997092, 6.84258687, 0.00000000);
		SetAtom(&F.Atoms[ 42 ], "O", 2.27818836,2.47987908, 6.84258687, 0.00000000);
		SetAtom(&F.Atoms[ 43 ], "O", 2.27818836,8.97982092, -1.11273687, 0.00000000);
		SetAtom(&F.Atoms[ 44 ], "O", 1.75218813,0.38504592, 5.14311336, 0.00000000);
		SetAtom(&F.Atoms[ 45 ], "O", -1.75218813,5.34480408, 5.14311336, 0.00000000);
		SetAtom(&F.Atoms[ 46 ], "O", 3.97766187,0.38504592, 6.31658664, 0.00000000);
		SetAtom(&F.Atoms[ 47 ], "O", 1.75218813,-0.38504592, 0.58673664, 0.00000000);
		SetAtom(&F.Atoms[ 48 ], "O", 5.14311336,1.75218813, 0.38504592, 0.00000000);
		SetAtom(&F.Atoms[ 49 ], "O", 5.14311336,-1.75218813, 5.34480408, 0.00000000);
		SetAtom(&F.Atoms[ 50 ], "O", 6.31658664,3.97766187, 0.38504592, 0.00000000);
		SetAtom(&F.Atoms[ 51 ], "O", 0.58673664,1.75218813, -0.38504592, 0.00000000);
		SetAtom(&F.Atoms[ 52 ], "O", 0.38504592,5.14311336, 1.75218813, 0.00000000);
		SetAtom(&F.Atoms[ 53 ], "O", 5.34480408,5.14311336, -1.75218813, 0.00000000);
		SetAtom(&F.Atoms[ 54 ], "O", 0.38504592,6.31658664, 3.97766187, 0.00000000);
		SetAtom(&F.Atoms[ 55 ], "O", -0.38504592,0.58673664, 1.75218813, 0.00000000);
		SetAtom(&F.Atoms[ 56 ], "O", 3.24997092,-1.11273687, 3.45166164, 0.00000000);
		SetAtom(&F.Atoms[ 57 ], "O", -3.24997092,6.84258687, 3.45166164, 0.00000000);
		SetAtom(&F.Atoms[ 58 ], "O", 3.24997092,1.11273687, 2.27818836, 0.00000000);
		SetAtom(&F.Atoms[ 59 ], "O", 2.47987908,-1.11273687, 8.00803836, 0.00000000);
		SetAtom(&F.Atoms[ 60 ], "O", -1.11273687,8.00803836, 2.47987908, 0.00000000);
		SetAtom(&F.Atoms[ 61 ], "O", 1.11273687,2.27818836, 3.24997092, 0.00000000);
		SetAtom(&F.Atoms[ 62 ], "O", 6.84258687,3.45166164, -3.24997092, 0.00000000);
		SetAtom(&F.Atoms[ 63 ], "O", -1.11273687,3.45166164, 3.24997092, 0.00000000);
		SetAtom(&F.Atoms[ 64 ], "O", 2.27818836,3.24997092, 1.11273687, 0.00000000);
		SetAtom(&F.Atoms[ 65 ], "O", 8.00803836,2.47987908, -1.11273687, 0.00000000);
		SetAtom(&F.Atoms[ 66 ], "O", 3.45166164,3.24997092, -1.11273687, 0.00000000);
		SetAtom(&F.Atoms[ 67 ], "O", 3.45166164,-3.24997092, 6.84258687, 0.00000000);
		SetAtom(&F.Atoms[ 68 ], "Si", 4.29738750,0.00000000, 2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 69 ], "Si", 1.43246250,0.00000000, 8.59477500, 0.00000000);
		SetAtom(&F.Atoms[ 70 ], "Si", 2.86492500,4.29738750, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 71 ], "Si", 8.59477500,1.43246250, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 72 ], "Si", 0.00000000,2.86492500, 4.29738750, 0.00000000);
		SetAtom(&F.Atoms[ 73 ], "Si", 0.00000000,8.59477500, 1.43246250, 0.00000000);
		SetAtom(&F.Atoms[ 74 ], "Si", 2.86492500,1.43246250, 5.72985000, 0.00000000);
		SetAtom(&F.Atoms[ 75 ], "Si", -2.86492500,4.29738750, 5.72985000, 0.00000000);
		SetAtom(&F.Atoms[ 76 ], "Si", 1.43246250,5.72985000, 2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 77 ], "Si", 4.29738750,5.72985000, -2.86492500, 0.00000000);
		SetAtom(&F.Atoms[ 78 ], "Si", 5.72985000,-2.86492500, 4.29738750, 0.00000000);
		SetAtom(&F.Atoms[ 79 ], "Si", 5.72985000,2.86492500, 1.43246250, 0.00000000);
		SetAtom(&F.Atoms[ 80 ], "Tv", -5.72985000,5.72985000, 5.72985000, 0.00000000);
		SetAtom(&F.Atoms[ 81 ], "Tv", 5.72985000,-5.72985000, 5.72985000, 0.00000000);
		SetAtom(&F.Atoms[ 82 ], "Tv", 5.72985000,5.72985000, -5.72985000, 0.00000000);
	}
	else if(!strcmp(Name,"Mg32AlZn48_cI162_Im-3_204")){
		F.NAtoms =84;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Al", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Mg", 7.08000000,2.54455200, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Mg", 7.08000000,-0.00000000, 4.53544800, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Mg", 4.53544800,7.08000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Mg", 2.54455200,0.00000000, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Mg", 0.00000000,7.08000000, 2.54455200, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Mg", -0.00000000,4.53544800, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Mg", 0.00000000,7.08000000, 5.66683200, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Mg", 7.08000000,-0.00000000, 1.41316800, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Mg", 7.08000000,5.66683200, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Mg", 5.66683200,0.00000000, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Mg", 1.41316800,7.08000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Mg", -0.00000000,1.41316800, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Mg", 2.59977600,2.59977600, -2.59977600, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Mg", 4.48022400,4.48022400, -4.48022400, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Mg", 2.59977600,-2.59977600, 2.59977600, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Mg", 4.48022400,-4.48022400, 4.48022400, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Mg", -2.59977600,2.59977600, 2.59977600, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Mg", 2.59977600,2.59977600, 2.59977600, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Mg", -4.48022400,4.48022400, 4.48022400, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Mg", 4.48022400,4.48022400, 4.48022400, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Mg", 4.16587200,1.69070400, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Mg", 9.99412800,1.69070400, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Mg", 7.08000000,-2.91412800, 5.38929600, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Mg", 5.38929600,7.08000000, -2.91412800, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Mg", 1.69070400,0.00000000, 4.16587200, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Mg", 0.00000000,4.16587200, 1.69070400, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Mg", 7.08000000,2.91412800, 5.38929600, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Mg", 5.38929600,7.08000000, 2.91412800, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "Mg", 1.69070400,0.00000000, 9.99412800, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "Mg", 0.00000000,9.99412800, 1.69070400, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "Mg", -2.91412800,5.38929600, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "Mg", 2.91412800,5.38929600, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "Zn", 7.08000000,5.79427200, -4.95458400, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "Zn", 0.00000000,1.28572800, 12.03458400, 0.00000000);
		SetAtom(&F.Atoms[ 35 ], "Zn", -4.95458400,7.08000000, 5.79427200, 0.00000000);
		SetAtom(&F.Atoms[ 36 ], "Zn", 12.03458400,0.00000000, 1.28572800, 0.00000000);
		SetAtom(&F.Atoms[ 37 ], "Zn", 2.12541600,0.00000000, 1.28572800, 0.00000000);
		SetAtom(&F.Atoms[ 38 ], "Zn", 4.95458400,7.08000000, 5.79427200, 0.00000000);
		SetAtom(&F.Atoms[ 39 ], "Zn", 5.79427200,-4.95458400, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 40 ], "Zn", 1.28572800,2.12541600, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 41 ], "Zn", 0.00000000,1.28572800, 2.12541600, 0.00000000);
		SetAtom(&F.Atoms[ 42 ], "Zn", 7.08000000,5.79427200, 4.95458400, 0.00000000);
		SetAtom(&F.Atoms[ 43 ], "Zn", 1.28572800,12.03458400, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 44 ], "Zn", 5.79427200,4.95458400, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 45 ], "Zn", 7.08000000,4.60483200, -2.82208800, 0.00000000);
		SetAtom(&F.Atoms[ 46 ], "Zn", 4.25791200,0.00000000, 2.47516800, 0.00000000);
		SetAtom(&F.Atoms[ 47 ], "Zn", 9.90208800,0.00000000, 2.47516800, 0.00000000);
		SetAtom(&F.Atoms[ 48 ], "Zn", 2.47516800,4.25791200, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 49 ], "Zn", 4.60483200,-2.82208800, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 50 ], "Zn", 0.00000000,2.47516800, 4.25791200, 0.00000000);
		SetAtom(&F.Atoms[ 51 ], "Zn", 7.08000000,4.60483200, 2.82208800, 0.00000000);
		SetAtom(&F.Atoms[ 52 ], "Zn", 2.47516800,9.90208800, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 53 ], "Zn", 4.60483200,2.82208800, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 54 ], "Zn", -2.82208800,7.08000000, 4.60483200, 0.00000000);
		SetAtom(&F.Atoms[ 55 ], "Zn", 2.82208800,7.08000000, 4.60483200, 0.00000000);
		SetAtom(&F.Atoms[ 56 ], "Zn", 0.00000000,2.47516800, 9.90208800, 0.00000000);
		SetAtom(&F.Atoms[ 57 ], "Zn", -1.37210400,9.45888000, 4.44624000, 0.00000000);
		SetAtom(&F.Atoms[ 58 ], "Zn", 1.37210400,9.45888000, 4.44624000, 0.00000000);
		SetAtom(&F.Atoms[ 59 ], "Zn", 5.70789600,-2.37888000, 2.63376000, 0.00000000);
		SetAtom(&F.Atoms[ 60 ], "Zn", 8.45210400,-2.37888000, 2.63376000, 0.00000000);
		SetAtom(&F.Atoms[ 61 ], "Zn", 4.70112000,4.44624000, -1.37210400, 0.00000000);
		SetAtom(&F.Atoms[ 62 ], "Zn", 9.45888000,4.44624000, -1.37210400, 0.00000000);
		SetAtom(&F.Atoms[ 63 ], "Zn", 2.63376000,5.70789600, -2.37888000, 0.00000000);
		SetAtom(&F.Atoms[ 64 ], "Zn", 4.44624000,-1.37210400, 4.70112000, 0.00000000);
		SetAtom(&F.Atoms[ 65 ], "Zn", 5.70789600,2.37888000, 2.63376000, 0.00000000);
		SetAtom(&F.Atoms[ 66 ], "Zn", 8.45210400,2.37888000, 2.63376000, 0.00000000);
		SetAtom(&F.Atoms[ 67 ], "Zn", 4.70112000,4.44624000, 1.37210400, 0.00000000);
		SetAtom(&F.Atoms[ 68 ], "Zn", 9.45888000,4.44624000, 1.37210400, 0.00000000);
		SetAtom(&F.Atoms[ 69 ], "Zn", 2.63376000,8.45210400, -2.37888000, 0.00000000);
		SetAtom(&F.Atoms[ 70 ], "Zn", 4.44624000,1.37210400, 4.70112000, 0.00000000);
		SetAtom(&F.Atoms[ 71 ], "Zn", 4.44624000,-1.37210400, 9.45888000, 0.00000000);
		SetAtom(&F.Atoms[ 72 ], "Zn", 2.63376000,5.70789600, 2.37888000, 0.00000000);
		SetAtom(&F.Atoms[ 73 ], "Zn", -2.37888000,2.63376000, 5.70789600, 0.00000000);
		SetAtom(&F.Atoms[ 74 ], "Zn", 2.37888000,2.63376000, 5.70789600, 0.00000000);
		SetAtom(&F.Atoms[ 75 ], "Zn", -1.37210400,4.70112000, 4.44624000, 0.00000000);
		SetAtom(&F.Atoms[ 76 ], "Zn", 1.37210400,4.70112000, 4.44624000, 0.00000000);
		SetAtom(&F.Atoms[ 77 ], "Zn", 4.44624000,1.37210400, 9.45888000, 0.00000000);
		SetAtom(&F.Atoms[ 78 ], "Zn", 2.63376000,8.45210400, 2.37888000, 0.00000000);
		SetAtom(&F.Atoms[ 79 ], "Zn", -2.37888000,2.63376000, 8.45210400, 0.00000000);
		SetAtom(&F.Atoms[ 80 ], "Zn", 2.37888000,2.63376000, 8.45210400, 0.00000000);
		SetAtom(&F.Atoms[ 81 ], "Tv", -7.08000000,7.08000000, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 82 ], "Tv", 7.08000000,-7.08000000, 7.08000000, 0.00000000);
		SetAtom(&F.Atoms[ 83 ], "Tv", 7.08000000,7.08000000, -7.08000000, 0.00000000);
	}
	else if(!strcmp(Name,"W_cI2_Im-3m_229")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "W", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.57750000,1.57750000, 1.57750000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.57750000,-1.57750000, 1.57750000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.57750000,1.57750000, -1.57750000, 0.00000000);
	}
	else if(!strcmp(Name,"Mn_cI58_I-43m_217")){
		F.NAtoms =32;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mn", 6.39863266,0.79824738, -0.79824738, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Mn", 6.39863266,-0.79824738, 0.79824738, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Mn", 2.51236734,0.79824738, 0.79824738, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Mn", 3.65725262,3.65725262, -1.94313266, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Mn", 3.65725262,-1.94313266, 3.65725262, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Mn", 0.79824738,2.51236734, 0.79824738, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Mn", 0.79824738,0.79824738, 2.51236734, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Mn", 0.79824738,6.39863266, -0.79824738, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Mn", 0.79824738,-0.79824738, 6.39863266, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Mn", -0.79824738,6.39863266, 0.79824738, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Mn", -0.79824738,0.79824738, 6.39863266, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Mn", -1.94313266,3.65725262, 3.65725262, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Mn", 4.14744673,1.27373834, -1.27373834, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Mn", 4.14744673,-1.27373834, 1.27373834, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Mn", 4.76355327,1.27373834, 1.27373834, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Mn", 1.27373834,4.14744673, -1.27373834, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Mn", 1.27373834,-1.27373834, 4.14744673, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Mn", 3.18176166,3.18176166, 0.30805327, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Mn", 3.18176166,0.30805327, 3.18176166, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Mn", -1.27373834,4.14744673, 1.27373834, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Mn", -1.27373834,1.27373834, 4.14744673, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Mn", 1.27373834,4.76355327, 1.27373834, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Mn", 1.27373834,1.27373834, 4.76355327, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Mn", 0.30805327,3.18176166, 3.18176166, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Mn", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Mn", 1.62296043,1.62296043, -1.62296043, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Mn", 1.62296043,-1.62296043, 1.62296043, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Mn", -1.62296043,1.62296043, 1.62296043, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Mn", 2.83253957,2.83253957, 2.83253957, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "Tv", -4.45550000,4.45550000, 4.45550000, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "Tv", 4.45550000,-4.45550000, 4.45550000, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "Tv", 4.45550000,4.45550000, -4.45550000, 0.00000000);
	}
	else if(!strcmp(Name,"CO2_Cubic_cP12_Pa-3_205")){
		F.NAtoms =15;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "C", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "C", 2.81200004,0.00000000, 2.81200004, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "C", 2.81200004,2.81200004, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "C", 0.00000000,2.81200004, 2.81200004, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 0.66643840,0.66643840, 0.66643840, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 2.14556159,4.95756179, 3.47843831, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 3.47843831,2.14556159, 4.95756179, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 4.95756179,3.47843831, 2.14556159, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 4.95756179,4.95756179, 4.95756179, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 3.47843831,0.66643840, 2.14556159, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 2.14556159,3.47843831, 0.66643840, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 0.66643840,2.14556159, 3.47843831, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Tv", 5.62400007,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Tv", 0.00000000,5.62400007, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Tv", 0.00000000,0.00000000, 5.62400007, 0.00000000);
	}
	else if(!strcmp(Name,"Alpha-Al-Mn_c138_Pm-3_200")){
		F.NAtoms =141;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mn", 2.27859603,3.91177990, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Mn", 10.40140378,8.76822010, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Mn", 10.40140378,3.91177990, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Mn", 2.27859603,8.76822010, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Mn", 6.34000000,2.27859603, 3.91177990, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Mn", 6.34000000,10.40140378, 8.76822010, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Mn", 6.34000000,10.40140378, 3.91177990, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Mn", 6.34000000,2.27859603, 8.76822010, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Mn", 3.91177990,6.34000000, 2.27859603, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Mn", 8.76822010,6.34000000, 10.40140378, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Mn", 3.91177990,6.34000000, 10.40140378, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Mn", 8.76822010,6.34000000, 2.27859603, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Mn", 4.14762811,2.54360797, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Mn", 8.53237151,10.13639164, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Mn", 8.53237151,2.54360797, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Mn", 4.14762811,10.13639164, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Mn", 0.00000000,4.14762811, 2.54360797, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Mn", 0.00000000,8.53237151, 10.13639164, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Mn", 0.00000000,8.53237151, 2.54360797, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Mn", 0.00000000,4.14762811, 10.13639164, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Mn", 2.54360797,0.00000000, 4.14762811, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Mn", 10.13639164,0.00000000, 8.53237151, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Mn", 2.54360797,0.00000000, 8.53237151, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Mn", 10.13639164,0.00000000, 4.14762811, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Al", 2.07444797,1.26419595, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Al", 10.60555241,11.41580433, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Al", 10.60555241,1.26419595, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Al", 2.07444797,11.41580433, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Al", 0.00000000,2.07444797, 1.26419595, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "Al", 0.00000000,10.60555241, 11.41580433, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "Al", 0.00000000,10.60555241, 1.26419595, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "Al", 0.00000000,2.07444797, 11.41580433, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "Al", 1.26419595,0.00000000, 2.07444797, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "Al", 11.41580433,0.00000000, 10.60555241, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "Al", 1.26419595,0.00000000, 10.60555241, 0.00000000);
		SetAtom(&F.Atoms[ 35 ], "Al", 11.41580433,0.00000000, 2.07444797, 0.00000000);
		SetAtom(&F.Atoms[ 36 ], "Al", 4.20849201,5.11891592, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 37 ], "Al", 8.47150799,7.56108408, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 38 ], "Al", 8.47150799,5.11891592, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 39 ], "Al", 4.20849201,7.56108408, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 40 ], "Al", 0.00000000,4.20849201, 5.11891592, 0.00000000);
		SetAtom(&F.Atoms[ 41 ], "Al", 0.00000000,8.47150799, 7.56108408, 0.00000000);
		SetAtom(&F.Atoms[ 42 ], "Al", 0.00000000,8.47150799, 5.11891592, 0.00000000);
		SetAtom(&F.Atoms[ 43 ], "Al", 0.00000000,4.20849201, 7.56108408, 0.00000000);
		SetAtom(&F.Atoms[ 44 ], "Al", 5.11891592,0.00000000, 4.20849201, 0.00000000);
		SetAtom(&F.Atoms[ 45 ], "Al", 7.56108408,0.00000000, 8.47150799, 0.00000000);
		SetAtom(&F.Atoms[ 46 ], "Al", 5.11891592,0.00000000, 8.47150799, 0.00000000);
		SetAtom(&F.Atoms[ 47 ], "Al", 7.56108408,0.00000000, 4.20849201, 0.00000000);
		SetAtom(&F.Atoms[ 48 ], "Al", 1.52793997,1.48990000, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 49 ], "Al", 11.15206039,11.19009991, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 50 ], "Al", 11.15206039,1.48990000, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 51 ], "Al", 1.52793997,11.19009991, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 52 ], "Al", 6.34000000,1.52793997, 1.48990000, 0.00000000);
		SetAtom(&F.Atoms[ 53 ], "Al", 6.34000000,11.15206039, 11.19009991, 0.00000000);
		SetAtom(&F.Atoms[ 54 ], "Al", 6.34000000,11.15206039, 1.48990000, 0.00000000);
		SetAtom(&F.Atoms[ 55 ], "Al", 6.34000000,1.52793997, 11.19009991, 0.00000000);
		SetAtom(&F.Atoms[ 56 ], "Al", 1.48990000,6.34000000, 1.52793997, 0.00000000);
		SetAtom(&F.Atoms[ 57 ], "Al", 11.19009991,6.34000000, 11.15206039, 0.00000000);
		SetAtom(&F.Atoms[ 58 ], "Al", 1.48990000,6.34000000, 11.15206039, 0.00000000);
		SetAtom(&F.Atoms[ 59 ], "Al", 11.19009991,6.34000000, 1.52793997, 0.00000000);
		SetAtom(&F.Atoms[ 60 ], "Al", 4.23765594,5.05931986, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 61 ], "Al", 8.44234368,7.62068014, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 62 ], "Al", 8.44234368,5.05931986, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 63 ], "Al", 4.23765594,7.62068014, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 64 ], "Al", 6.34000000,4.23765594, 5.05931986, 0.00000000);
		SetAtom(&F.Atoms[ 65 ], "Al", 6.34000000,8.44234368, 7.62068014, 0.00000000);
		SetAtom(&F.Atoms[ 66 ], "Al", 6.34000000,8.44234368, 5.05931986, 0.00000000);
		SetAtom(&F.Atoms[ 67 ], "Al", 6.34000000,4.23765594, 7.62068014, 0.00000000);
		SetAtom(&F.Atoms[ 68 ], "Al", 5.05931986,6.34000000, 4.23765594, 0.00000000);
		SetAtom(&F.Atoms[ 69 ], "Al", 7.62068014,6.34000000, 8.44234368, 0.00000000);
		SetAtom(&F.Atoms[ 70 ], "Al", 5.05931986,6.34000000, 8.44234368, 0.00000000);
		SetAtom(&F.Atoms[ 71 ], "Al", 7.62068014,6.34000000, 4.23765594, 0.00000000);
		SetAtom(&F.Atoms[ 72 ], "Al", 1.50258003,2.39905599, 3.77864010, 0.00000000);
		SetAtom(&F.Atoms[ 73 ], "Al", 11.17742008,10.28094420, 8.90136028, 0.00000000);
		SetAtom(&F.Atoms[ 74 ], "Al", 11.17742008,10.28094420, 3.77864010, 0.00000000);
		SetAtom(&F.Atoms[ 75 ], "Al", 1.50258003,2.39905599, 8.90136028, 0.00000000);
		SetAtom(&F.Atoms[ 76 ], "Al", 11.17742008,2.39905599, 8.90136028, 0.00000000);
		SetAtom(&F.Atoms[ 77 ], "Al", 1.50258003,10.28094420, 3.77864010, 0.00000000);
		SetAtom(&F.Atoms[ 78 ], "Al", 1.50258003,10.28094420, 8.90136028, 0.00000000);
		SetAtom(&F.Atoms[ 79 ], "Al", 11.17742008,2.39905599, 3.77864010, 0.00000000);
		SetAtom(&F.Atoms[ 80 ], "Al", 3.77864010,1.50258003, 2.39905599, 0.00000000);
		SetAtom(&F.Atoms[ 81 ], "Al", 8.90136028,11.17742008, 10.28094420, 0.00000000);
		SetAtom(&F.Atoms[ 82 ], "Al", 3.77864010,11.17742008, 10.28094420, 0.00000000);
		SetAtom(&F.Atoms[ 83 ], "Al", 8.90136028,1.50258003, 2.39905599, 0.00000000);
		SetAtom(&F.Atoms[ 84 ], "Al", 8.90136028,11.17742008, 2.39905599, 0.00000000);
		SetAtom(&F.Atoms[ 85 ], "Al", 3.77864010,1.50258003, 10.28094420, 0.00000000);
		SetAtom(&F.Atoms[ 86 ], "Al", 8.90136028,1.50258003, 10.28094420, 0.00000000);
		SetAtom(&F.Atoms[ 87 ], "Al", 3.77864010,11.17742008, 2.39905599, 0.00000000);
		SetAtom(&F.Atoms[ 88 ], "Al", 2.39905599,3.77864010, 1.50258003, 0.00000000);
		SetAtom(&F.Atoms[ 89 ], "Al", 10.28094420,8.90136028, 11.17742008, 0.00000000);
		SetAtom(&F.Atoms[ 90 ], "Al", 10.28094420,3.77864010, 11.17742008, 0.00000000);
		SetAtom(&F.Atoms[ 91 ], "Al", 2.39905599,8.90136028, 1.50258003, 0.00000000);
		SetAtom(&F.Atoms[ 92 ], "Al", 2.39905599,8.90136028, 11.17742008, 0.00000000);
		SetAtom(&F.Atoms[ 93 ], "Al", 10.28094420,3.77864010, 1.50258003, 0.00000000);
		SetAtom(&F.Atoms[ 94 ], "Al", 10.28094420,8.90136028, 1.50258003, 0.00000000);
		SetAtom(&F.Atoms[ 95 ], "Al", 2.39905599,3.77864010, 11.17742008, 0.00000000);
		SetAtom(&F.Atoms[ 96 ], "Al", 4.61298386,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 97 ], "Al", 8.06701614,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 98 ], "Al", 0.00000000,4.61298386, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 99 ], "Al", 0.00000000,8.06701614, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 100 ], "Al", 0.00000000,0.00000000, 4.61298386, 0.00000000);
		SetAtom(&F.Atoms[ 101 ], "Al", 0.00000000,0.00000000, 8.06701614, 0.00000000);
		SetAtom(&F.Atoms[ 102 ], "Al", 4.94139595,3.96503604, 2.47894001, 0.00000000);
		SetAtom(&F.Atoms[ 103 ], "Al", 7.73860405,8.71496358, 10.20105980, 0.00000000);
		SetAtom(&F.Atoms[ 104 ], "Al", 7.73860405,8.71496358, 2.47894001, 0.00000000);
		SetAtom(&F.Atoms[ 105 ], "Al", 4.94139595,3.96503604, 10.20105980, 0.00000000);
		SetAtom(&F.Atoms[ 106 ], "Al", 7.73860405,3.96503604, 10.20105980, 0.00000000);
		SetAtom(&F.Atoms[ 107 ], "Al", 4.94139595,8.71496358, 2.47894001, 0.00000000);
		SetAtom(&F.Atoms[ 108 ], "Al", 4.94139595,8.71496358, 10.20105980, 0.00000000);
		SetAtom(&F.Atoms[ 109 ], "Al", 7.73860405,3.96503604, 2.47894001, 0.00000000);
		SetAtom(&F.Atoms[ 110 ], "Al", 2.47894001,4.94139595, 3.96503604, 0.00000000);
		SetAtom(&F.Atoms[ 111 ], "Al", 10.20105980,7.73860405, 8.71496358, 0.00000000);
		SetAtom(&F.Atoms[ 112 ], "Al", 2.47894001,7.73860405, 8.71496358, 0.00000000);
		SetAtom(&F.Atoms[ 113 ], "Al", 10.20105980,4.94139595, 3.96503604, 0.00000000);
		SetAtom(&F.Atoms[ 114 ], "Al", 10.20105980,7.73860405, 3.96503604, 0.00000000);
		SetAtom(&F.Atoms[ 115 ], "Al", 2.47894001,4.94139595, 8.71496358, 0.00000000);
		SetAtom(&F.Atoms[ 116 ], "Al", 10.20105980,4.94139595, 8.71496358, 0.00000000);
		SetAtom(&F.Atoms[ 117 ], "Al", 2.47894001,7.73860405, 3.96503604, 0.00000000);
		SetAtom(&F.Atoms[ 118 ], "Al", 3.96503604,2.47894001, 4.94139595, 0.00000000);
		SetAtom(&F.Atoms[ 119 ], "Al", 8.71496358,10.20105980, 7.73860405, 0.00000000);
		SetAtom(&F.Atoms[ 120 ], "Al", 8.71496358,2.47894001, 7.73860405, 0.00000000);
		SetAtom(&F.Atoms[ 121 ], "Al", 3.96503604,10.20105980, 4.94139595, 0.00000000);
		SetAtom(&F.Atoms[ 122 ], "Al", 3.96503604,10.20105980, 7.73860405, 0.00000000);
		SetAtom(&F.Atoms[ 123 ], "Al", 8.71496358,2.47894001, 4.94139595, 0.00000000);
		SetAtom(&F.Atoms[ 124 ], "Al", 8.71496358,10.20105980, 4.94139595, 0.00000000);
		SetAtom(&F.Atoms[ 125 ], "Al", 3.96503604,2.47894001, 7.73860405, 0.00000000);
		SetAtom(&F.Atoms[ 126 ], "Al", 3.67339601,0.00000000, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 127 ], "Al", 9.00660361,0.00000000, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 128 ], "Al", 6.34000000,3.67339601, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 129 ], "Al", 6.34000000,9.00660361, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 130 ], "Al", 0.00000000,6.34000000, 3.67339601, 0.00000000);
		SetAtom(&F.Atoms[ 131 ], "Al", 0.00000000,6.34000000, 9.00660361, 0.00000000);
		SetAtom(&F.Atoms[ 132 ], "Al", 1.54188803,6.34000000, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 133 ], "Al", 11.13811159,6.34000000, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 134 ], "Al", 6.34000000,1.54188803, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 135 ], "Al", 6.34000000,11.13811159, 6.34000000, 0.00000000);
		SetAtom(&F.Atoms[ 136 ], "Al", 6.34000000,6.34000000, 1.54188803, 0.00000000);
		SetAtom(&F.Atoms[ 137 ], "Al", 6.34000000,6.34000000, 11.13811159, 0.00000000);
		SetAtom(&F.Atoms[ 138 ], "Tv", 12.68000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 139 ], "Tv", 0.00000000,12.68000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 140 ], "Tv", 0.00000000,0.00000000, 12.68000000, 0.00000000);
	}
	else if(!strcmp(Name,"Mn_cP20_P4_132_213")){
		F.NAtoms =23;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mn", 6.01339560,2.36812500, 5.03785440, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Mn", 0.30160440,5.52562500, 4.43464560, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Mn", 0.78937500,1.27714560, 2.85589560, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Mn", 1.27714560,2.85589560, 0.78937500, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Mn", 1.88035440,3.45910440, 3.94687500, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Mn", 2.36812500,5.03785440, 6.01339560, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Mn", 2.85589560,0.78937500, 1.27714560, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Mn", 3.45910440,3.94687500, 1.88035440, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Mn", 3.94687500,1.88035440, 3.45910440, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Mn", 4.43464560,0.30160440, 5.52562500, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Mn", 5.03785440,6.01339560, 2.36812500, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Mn", 5.52562500,4.43464560, 0.30160440, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Mn", 0.40169715,0.40169715, 0.40169715, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Mn", 5.91330285,3.55919715, 2.75580285, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Mn", 1.17705285,5.13794715, 1.98044715, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Mn", 1.98044715,1.17705285, 5.13794715, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Mn", 2.75580285,5.91330285, 3.55919715, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Mn", 3.55919715,2.75580285, 5.91330285, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Mn", 4.33455285,4.33455285, 4.33455285, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Mn", 5.13794715,1.98044715, 1.17705285, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Tv", 6.31500000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Tv", 0.00000000,6.31500000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Tv", 0.00000000,0.00000000, 6.31500000, 0.00000000);
	}
	else if(!strcmp(Name,"CsCl_cP2_Pm-3m_221")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cl", 2.03962500,2.03962500, 2.03962500, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Cs", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 4.07925000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,4.07925000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 4.07925000, 0.00000000);
	}
	else if(!strcmp(Name,"AuCu3_cP4_PM-3m_221")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Au", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Cu", 0.00000000,1.87010000, 1.87010000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Cu", 1.87010000,0.00000000, 1.87010000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Cu", 1.87010000,1.87010000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 3.74020000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,3.74020000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 3.74020000, 0.00000000);
	}
	else if(!strcmp(Name,"CaTiO3_cP5_Pm-3m_221")){
		F.NAtoms =8;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ca", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", 0.00000000,1.89750000, 1.89750000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 1.89750000,0.00000000, 1.89750000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 1.89750000,1.89750000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Ti", 1.89750000,1.89750000, 1.89750000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 3.79500000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,3.79500000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Tv", 0.00000000,0.00000000, 3.79500000, 0.00000000);
	}
	else if(!strcmp(Name,"Cr3Si_cP8_Pm-3n_223")){
		F.NAtoms =11;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cr", 0.00000000,2.27800000, 1.13900000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Cr", 0.00000000,2.27800000, 3.41700000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Cr", 1.13900000,0.00000000, 2.27800000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Cr", 2.27800000,1.13900000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Cr", 2.27800000,3.41700000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Cr", 3.41700000,0.00000000, 2.27800000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Si", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Si", 2.27800000,2.27800000, 2.27800000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", 4.55600000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", 0.00000000,4.55600000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Tv", 0.00000000,0.00000000, 4.55600000, 0.00000000);
	}
	else if(!strcmp(Name,"Na4Al3Si3ClO12_cP9_P-43n_218")){
		F.NAtoms =49;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Na", 2.89337301,2.89337301, 6.08060816, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Na", 6.08060816,2.89337301, 2.89337301, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Na", 6.08060816,6.08060816, 6.08060816, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Na", 1.59361744,1.59361744, 1.59361744, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Na", 1.59361744,7.38036319, 7.38036319, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Na", 7.38036319,7.38036319, 1.59361744, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Na", 2.89337301,6.08060816, 2.89337301, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Na", 7.38036319,1.59361744, 7.38036319, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Al", 4.48699045,6.73048568, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Al", 2.24349523,0.00000000, 4.48699045, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Al", 0.00000000,4.48699045, 2.24349523, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Al", 4.48699045,2.24349523, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Al", 0.00000000,4.48699045, 6.73048568, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Al", 6.73048568,0.00000000, 4.48699045, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Si", 4.48699045,0.00000000, 2.24349523, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Si", 0.00000000,2.24349523, 4.48699045, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Si", 2.24349523,4.48699045, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Si", 0.00000000,6.73048568, 4.48699045, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Si", 4.48699045,0.00000000, 6.73048568, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Si", 6.73048568,4.48699045, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Cl", 4.48699045,4.48699045, 4.48699045, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Cl", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "O", 3.23775854,0.56040715, 5.82676068, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "O", 7.72474899,7.63421068, 3.92658334, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "O", 5.82676068,3.23775854, 0.56040715, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "O", 3.92658334,1.24923205, 1.33977050, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "O", 1.24923205,7.63421068, 5.04739784, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "O", 0.56040715,3.14721995, 5.73622237, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "O", 5.73622237,8.41357352, 5.82676068, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "O", 1.24923205,1.33977050, 3.92658334, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "O", 5.04739784,7.72474899, 1.33977050, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "O", 5.82676068,5.73622237, 8.41357352, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "O", 3.23775854,8.41357352, 3.14721995, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "O", 1.33977050,5.04739784, 7.72474899, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "O", 3.14721995,5.73622237, 0.56040715, 0.00000000);
		SetAtom(&F.Atoms[ 35 ], "O", 1.33977050,3.92658334, 1.24923205, 0.00000000);
		SetAtom(&F.Atoms[ 36 ], "O", 0.56040715,5.82676068, 3.23775854, 0.00000000);
		SetAtom(&F.Atoms[ 37 ], "O", 5.04739784,1.24923205, 7.63421068, 0.00000000);
		SetAtom(&F.Atoms[ 38 ], "O", 8.41357352,5.82676068, 5.73622237, 0.00000000);
		SetAtom(&F.Atoms[ 39 ], "O", 7.72474899,1.33977050, 5.04739784, 0.00000000);
		SetAtom(&F.Atoms[ 40 ], "O", 7.63421068,3.92658334, 7.72474899, 0.00000000);
		SetAtom(&F.Atoms[ 41 ], "O", 8.41357352,3.14721995, 3.23775854, 0.00000000);
		SetAtom(&F.Atoms[ 42 ], "O", 7.63421068,5.04739784, 1.24923205, 0.00000000);
		SetAtom(&F.Atoms[ 43 ], "O", 3.14721995,3.23775854, 8.41357352, 0.00000000);
		SetAtom(&F.Atoms[ 44 ], "O", 5.73622237,0.56040715, 3.14721995, 0.00000000);
		SetAtom(&F.Atoms[ 45 ], "O", 3.92658334,7.72474899, 7.63421068, 0.00000000);
		SetAtom(&F.Atoms[ 46 ], "Tv", 8.97398090,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 47 ], "Tv", 0.00000000,8.97398090, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 48 ], "Tv", 0.00000000,0.00000000, 8.97398090, 0.00000000);
	}
	else if(!strcmp(Name,"H2OIh_hP12_P6_3/mmc_194")){
		F.NAtoms =39;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "O", 2.60666680,0.00000000, 0.46000001, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", -1.30333340,2.25743967, 0.46000001, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 2.60666657,4.51487894, 0.46000001, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 5.21333314,0.00000000, 4.14000008, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", -2.60666657,4.51487894, 4.14000008, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 1.30333340,2.25743967, 4.14000008, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 5.21333361,0.00000000, 6.90000013, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", -2.60666680,4.51487934, 6.90000013, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 1.30333328,2.25743946, 6.90000013, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 2.60666656,0.00000000, 3.22000006, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", -1.30333328,2.25743946, 3.22000006, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 2.60666680,4.51487934, 3.22000006, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "H", 2.60666680,0.00000000, 1.28063999, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "H", -1.30333340,2.25743967, 1.28063999, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "H", 2.60666657,4.51487894, 1.28063999, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "H", 5.21333314,0.00000000, 4.96064027, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "H", -2.60666657,4.51487894, 4.96064027, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "H", 1.30333340,2.25743967, 4.96064027, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "H", 3.42516003,0.00000000, 0.19136001, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "H", -1.71258001,2.96627560, 0.19136001, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "H", 2.19742019,3.80604341, 0.19136001, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "H", 4.39484038,0.00000000, 3.87136024, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "H", -2.19742019,3.80604341, 3.87136024, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "H", 1.71258001,2.96627560, 3.87136024, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "H", 5.62649025,0.71109345, 7.17600031, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "H", 4.39092996,4.51713662, 7.17600031, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "H", 1.71257989,1.54408859, 7.17600031, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "H", -1.71649008,6.06122520, 3.49600024, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "H", -0.48092993,2.25518199, 3.49600024, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "H", 2.19741996,5.22823022, 3.49600024, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "H", 6.10742004,1.54408859, 3.49600024, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "H", 2.19350986,0.71109345, 3.49600024, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "H", 3.42907021,4.51713662, 3.49600024, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "H", -2.19742013,5.22823022, 7.17600031, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "H", 1.71649008,6.06122520, 7.17600031, 0.00000000);
		SetAtom(&F.Atoms[ 35 ], "H", 0.48092999,2.25518199, 7.17600031, 0.00000000);
		SetAtom(&F.Atoms[ 36 ], "Tv", 7.82000017,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 37 ], "Tv", -3.91000009,6.77231881, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 38 ], "Tv", 0.00000000,0.00000000, 7.36000013, 0.00000000);
	}
	else if(!strcmp(Name,"MgZn2_hP12_P6-3/mmc_194")){
		F.NAtoms =15;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mg", 2.61150000,1.50775023, 0.53845876, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Mg", 2.61150000,1.50775023, 3.74454124, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Mg", 2.61150000,-1.50775023, 8.02754124, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Mg", 2.61150000,-1.50775023, 4.82145876, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Zn", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Zn", 0.00000000,0.00000000, 4.28300000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Zn", 1.32810444,0.76678146, 6.42450000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Zn", 2.61150000,2.98968777, 6.42450000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Zn", 1.32810444,-0.76678146, 2.14150000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Zn", 3.89489556,0.76678146, 6.42450000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Zn", 2.61150000,-2.98968777, 2.14150000, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Zn", 3.89489556,-0.76678146, 2.14150000, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Tv", 2.61150000,-4.52325068, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Tv", 2.61150000,4.52325068, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Tv", 0.00000000,0.00000000, 8.56600000, 0.00000000);
	}
	else if(!strcmp(Name,"MgNi2_hP24_P6_3/mmc_194")){
		F.NAtoms =27;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mg", 0.00000000,0.00000000, 0.72767948, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Mg", 0.00000000,0.00000000, 15.09832052, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Mg", 0.00000000,0.00000000, 7.18532052, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Mg", 0.00000000,0.00000000, 8.64067948, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Mg", 2.41200000,1.39256885, 10.37916558, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Mg", 2.41200000,1.39256885, 13.35983442, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Mg", 2.41200000,-1.39256885, 2.46616558, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Mg", 2.41200000,-1.39256885, 5.44683442, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Ni", 2.41200000,1.39256885, 1.98046564, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Ni", 2.41200000,1.39256885, 5.93253436, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Ni", 2.41200000,-1.39256885, 9.89346564, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Ni", 2.41200000,-1.39256885, 13.84553436, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Ni", 1.20600000,2.08885327, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Ni", 1.20600000,2.08885327, 7.91300000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Ni", 1.20600000,-2.08885327, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Ni", 1.20600000,-2.08885327, 7.91300000, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Ni", 2.41200000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Ni", 2.41200000,0.00000000, 7.91300000, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Ni", 1.18880244,0.68635541, 3.95650000, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Ni", 2.41200000,2.80499573, 3.95650000, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Ni", 1.18880244,-0.68635541, 11.86950000, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Ni", 3.63519756,0.68635541, 3.95650000, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Ni", 2.41200000,-2.80499573, 11.86950000, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Ni", 3.63519756,-0.68635541, 11.86950000, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Tv", 2.41200000,-4.17770655, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Tv", 2.41200000,4.17770655, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Tv", 0.00000000,0.00000000, 15.82600000, 0.00000000);
	}
	else if(!strcmp(Name,"Mg_hP2_p6_3/mmc_194")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mg", 1.60465000,0.92644511, 1.30265000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Mg", 1.60465000,-0.92644511, 3.90795000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.60465000,-2.77933533, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.60465000,2.77933533, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.21060000, 0.00000000);
	}
	else if(!strcmp(Name,"Se_hP3_P3_121_152")){
		F.NAtoms =6;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Se", 0.49207074,0.85229152, 3.30240000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Se", 0.49207074,-0.85229152, 1.65120000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Se", 3.38205852,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.18310000,-3.78124012, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.18310000,3.78124012, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,0.00000000, 4.95360000, 0.00000000);
	}
	else if(!strcmp(Name,"Be3Al2Si6O18_hP40_P6/mmc_192")){
		F.NAtoms =61;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Be", 4.65173578,0.00000000, 2.31939435, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Be", -2.32586789,4.02852136, 6.95818305, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Be", 2.32586789,4.02852136, 6.95818305, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Be", 4.65173578,0.00000000, 6.95818305, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Be", -2.32586789,4.02852136, 2.31939435, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Be", 2.32586789,4.02852136, 2.31939435, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 2.53555420,0.59523014, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 0.75228332,2.49346942, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 3.89945247,5.56357353, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 7.52021493,1.89823118, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 2.86846978,6.15881166, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 2.11618175,7.46181276, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", -2.86847901,6.15881166, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 5.40402853,5.56357353, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 6.76792686,0.59523014, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", -2.11619105,7.46181276, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "O", -0.75229268,2.49346942, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "O", 1.78326620,1.89823118, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "O", 1.65986945,5.20749208, 5.99153353, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "O", -0.68801966,6.89078579, 5.99153353, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "O", -0.97184994,4.01580732, 5.99153353, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "O", 5.62358586,4.04123516, 5.99153353, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "O", 3.96371613,1.16625693, 1.35274497, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "O", 0.97184994,4.01580732, 1.35274497, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "O", -1.65986945,5.20749208, 1.35274497, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "O", 6.31160538,2.84955040, 1.35274497, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "O", 3.67988570,4.04123516, 1.35274497, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "O", -0.68801966,6.89078579, 3.28604359, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "O", 1.65986945,5.20749208, 3.28604359, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "O", 0.68801938,6.89078579, 1.35274497, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "O", -0.97184994,4.01580732, 3.28604359, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "O", 5.62358586,4.04123516, 3.28604359, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "O", 5.33975516,1.16625693, 3.28604359, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "O", 2.99186619,2.84955040, 3.28604359, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "O", 0.68801938,6.89078579, 7.92483257, 0.00000000);
		SetAtom(&F.Atoms[ 35 ], "O", 3.67988570,4.04123516, 7.92483257, 0.00000000);
		SetAtom(&F.Atoms[ 36 ], "O", 6.31160538,2.84955040, 7.92483257, 0.00000000);
		SetAtom(&F.Atoms[ 37 ], "O", -1.65986945,5.20749208, 7.92483257, 0.00000000);
		SetAtom(&F.Atoms[ 38 ], "O", 0.97184994,4.01580732, 7.92483257, 0.00000000);
		SetAtom(&F.Atoms[ 39 ], "O", 5.33975516,1.16625693, 5.99153353, 0.00000000);
		SetAtom(&F.Atoms[ 40 ], "O", 2.99186619,2.84955040, 5.99153353, 0.00000000);
		SetAtom(&F.Atoms[ 41 ], "O", 3.96371613,1.16625693, 7.92483257, 0.00000000);
		SetAtom(&F.Atoms[ 42 ], "Al", 4.65174036,2.68567811, 2.31939435, 0.00000000);
		SetAtom(&F.Atoms[ 43 ], "Al", -0.00000471,5.37136438, 2.31939435, 0.00000000);
		SetAtom(&F.Atoms[ 44 ], "Al", -0.00000471,5.37136438, 6.95818305, 0.00000000);
		SetAtom(&F.Atoms[ 45 ], "Al", 4.65174036,2.68567811, 6.95818305, 0.00000000);
		SetAtom(&F.Atoms[ 46 ], "Si", 1.58379514,7.12969322, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 47 ], "Si", 2.31465723,5.86380293, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 48 ], "Si", -1.58379514,7.12969322, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 49 ], "Si", 3.92087369,4.93645343, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 50 ], "Si", 6.96639301,2.19323979, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 51 ], "Si", -2.31465723,5.86380293, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 52 ], "Si", 0.73086210,3.12058929, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 53 ], "Si", 3.06794065,0.92734950, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 54 ], "Si", -0.73086210,3.12058929, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 55 ], "Si", 5.38259788,4.93645343, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 56 ], "Si", 6.23553092,0.92734950, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 57 ], "Si", 2.33707855,2.19323979, 4.63878870, 0.00000000);
		SetAtom(&F.Atoms[ 58 ], "Tv", 9.30347157,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 59 ], "Tv", -4.65173578,8.05704272, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 60 ], "Tv", 0.00000000,0.00000000, 9.27757740, 0.00000000);
	}
	else if(!strcmp(Name,"NaAlSi2O6_hP40_C2/c_15")){
		F.NAtoms =23;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Al", 4.92578206,6.00559136, 1.24489908, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Al", -0.33202594,1.39188478, 3.73471215, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Na", 1.43931489,2.16941903, 1.24489908, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Na", 3.15444149,5.22805738, 3.73471215, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 1.89422673,4.14800579, 0.02987770, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 3.36554342,2.81081420, 2.45993034, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 2.69952847,3.24947171, 4.94973859, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 1.22821065,4.58666431, 2.51969076, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 3.08602413,6.02856090, 1.46001850, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 5.12396878,4.17639512, 1.02977965, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 1.50773348,1.36891415, 3.51958760, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", -0.53021269,3.22108131, 3.94983165, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 0.44267048,6.26341784, 0.63988068, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 5.60965461,1.56745556, 1.84993239, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 4.15108329,1.13406036, 4.33974064, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", -1.01589391,5.83001662, 3.12968871, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Si", 1.69160280,5.32854748, 1.13385858, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Si", 4.56002228,2.72160718, 1.35594952, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Si", 2.90215047,2.06893711, 3.84576266, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Si", 0.03373208,4.67586494, 3.62367173, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Tv", 6.36661291,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Tv", -0.60671321,6.33763829, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Tv", -1.16614465,1.05983900, 4.97961620, 0.00000000);
	}
	else if(!strcmp(Name,"alpha-La_hP4_P6_3mmc_194")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "La", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "La", 0.00000000,0.00000000, 6.06500000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "La", 1.88500000,1.08830526, 3.03250000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "La", 1.88500000,-1.08830526, 9.09750000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 1.88500000,-3.26491577, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 1.88500000,3.26491577, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 12.13000000, 0.00000000);
	}
	else if(!strcmp(Name,"C_hP4_P6_3mmc_194")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "C", 0.00000000,0.00000000, 1.67775000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "C", 0.00000000,0.00000000, 5.03325000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "C", 1.23200000,0.71129553, 1.67775000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "C", 1.23200000,-0.71129553, 5.03325000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 1.23200000,-2.13388659, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 1.23200000,2.13388659, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 6.71100000, 0.00000000);
	}
	else if(!strcmp(Name,"NiAs_hP4_P6_3mmc_194")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "As", 1.80950000,1.04471531, 1.26100000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "As", 1.80950000,-1.04471531, 3.78300000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Ni", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Ni", 0.00000000,0.00000000, 2.52200000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 1.80950000,-3.13414594, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 1.80950000,3.13414594, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 5.04400000, 0.00000000);
	}
	else if(!strcmp(Name,"ZnS_hP4_P6_3mc_186")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "S", 1.91135000,1.10351844, 2.34651036, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "S", 1.91135000,-1.10351844, 5.47686036, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Zn", 1.91135000,1.10351844, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Zn", 1.91135000,-1.10351844, 3.13035000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 1.91135000,-3.31055531, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 1.91135000,3.31055531, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 6.26070000, 0.00000000);
	}
	else if(!strcmp(Name,"CdI2_hP5_P-3m1_164")){
		F.NAtoms =6;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cd", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "I", -0.00000220,2.50968810, 1.71612409, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "I", 2.17345475,1.25484215, 5.58407744, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 4.34690523,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", -2.17345262,3.76453036, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,0.00000000, 7.30020142, 0.00000000);
	}
	else if(!strcmp(Name,"BaFe12O19_hP64_P6_3/mmc_194")){
		F.NAtoms =67;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ba", 3.00840817,1.73690175, 5.87384176, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ba", -0.00000305,3.47380877, 17.62152529, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Fe", 3.00840234,3.45977106, 2.54356149, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Fe", 3.00840234,3.45977106, 9.20412187, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Fe", 3.00840817,1.73690175, 22.83547601, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Fe", -1.49204263,4.33523838, 14.29124518, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Fe", 3.00840817,1.73690175, 19.02455050, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Fe", 1.51635652,0.87547237, 9.20412187, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Fe", 0.00000305,1.75093945, 14.29124518, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Fe", -0.00000305,3.47380877, 7.27686768, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Fe", -0.00000305,3.47380877, 0.65989086, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Fe", 1.49204846,4.33523838, 20.95180539, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Fe", 1.51635652,0.87547237, 2.54356149, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Fe", 4.50044788,0.87547237, 2.54356149, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Fe", -0.00000305,3.47380877, 4.47081585, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Fe", 1.49204846,4.33523838, 14.29124518, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Fe", 0.00000000,0.00000000, 11.74768353, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Fe", -0.00000305,3.47380877, 11.08779248, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Fe", 0.00000305,1.75093945, 20.95180539, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Fe", 3.00840817,1.73690175, 16.21850008, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Fe", -1.49204263,4.33523838, 20.95180539, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Fe", 3.00840817,1.73690175, 12.40757457, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Fe", 4.50044788,0.87547237, 9.20412187, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Fe", 0.00000000,0.00000000, 17.62152529, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Fe", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Fe", 0.00000000,0.00000000, 5.87384176, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "O", -1.47158253,2.62419217, 19.99352410, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "O", 1.35875829,4.25828658, 5.87384176, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "O", 0.00000000,1.61593512, 1.23186209, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "O", 1.53682887,2.58651866, 3.50184365, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "O", 1.47157643,2.62419217, 19.99352410, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "O", 0.00000000,0.00000000, 3.55355674, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "O", 0.00000000,0.00000000, 8.19412678, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "O", 3.00840539,3.59477539, 12.97954501, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "O", -0.00000305,5.17304259, 15.24952647, 0.00000000);
		SetAtom(&F.Atoms[ 35 ], "O", 1.64964691,0.95242409, 17.62152529, 0.00000000);
		SetAtom(&F.Atoms[ 36 ], "O", 1.39944086,0.80796756, 22.26350557, 0.00000000);
		SetAtom(&F.Atoms[ 37 ], "O", 0.00000000,0.00000000, 19.94181031, 0.00000000);
		SetAtom(&F.Atoms[ 38 ], "O", -1.60896439,4.40274319, 1.23186209, 0.00000000);
		SetAtom(&F.Atoms[ 39 ], "O", 4.61736964,0.80796756, 12.97954501, 0.00000000);
		SetAtom(&F.Atoms[ 40 ], "O", -0.00000305,3.47380877, 13.03240996, 0.00000000);
		SetAtom(&F.Atoms[ 41 ], "O", -1.35875830,4.25828658, 5.87384176, 0.00000000);
		SetAtom(&F.Atoms[ 42 ], "O", -0.00000305,3.47380877, 22.21064061, 0.00000000);
		SetAtom(&F.Atoms[ 43 ], "O", 3.00840835,0.03766823, 8.24583987, 0.00000000);
		SetAtom(&F.Atoms[ 44 ], "O", 3.00840817,1.73690175, 1.28472669, 0.00000000);
		SetAtom(&F.Atoms[ 45 ], "O", 0.00000000,0.00000000, 15.30124027, 0.00000000);
		SetAtom(&F.Atoms[ 46 ], "O", 4.47998783,2.58651866, 8.24583987, 0.00000000);
		SetAtom(&F.Atoms[ 47 ], "O", 4.61736964,0.80796756, 22.26350557, 0.00000000);
		SetAtom(&F.Atoms[ 48 ], "O", 3.00840521,3.30586249, 17.62152529, 0.00000000);
		SetAtom(&F.Atoms[ 49 ], "O", 1.39944086,0.80796756, 12.97954501, 0.00000000);
		SetAtom(&F.Atoms[ 50 ], "O", 1.53682887,2.58651866, 8.24583987, 0.00000000);
		SetAtom(&F.Atoms[ 51 ], "O", 3.00840539,3.59477539, 22.26350557, 0.00000000);
		SetAtom(&F.Atoms[ 52 ], "O", 1.47157643,2.62419217, 15.24952647, 0.00000000);
		SetAtom(&F.Atoms[ 53 ], "O", 4.47998783,2.58651866, 3.50184365, 0.00000000);
		SetAtom(&F.Atoms[ 54 ], "O", 1.60896412,4.40274319, 10.51582134, 0.00000000);
		SetAtom(&F.Atoms[ 55 ], "O", -1.47158253,2.62419217, 15.24952647, 0.00000000);
		SetAtom(&F.Atoms[ 56 ], "O", 3.00840817,1.73690175, 10.46295709, 0.00000000);
		SetAtom(&F.Atoms[ 57 ], "O", 0.00000000,1.61593512, 10.51582134, 0.00000000);
		SetAtom(&F.Atoms[ 58 ], "O", -0.00000305,5.17304259, 19.99352410, 0.00000000);
		SetAtom(&F.Atoms[ 59 ], "O", -1.60896439,4.40274319, 10.51582134, 0.00000000);
		SetAtom(&F.Atoms[ 60 ], "O", -0.00000000,1.90484818, 5.87384176, 0.00000000);
		SetAtom(&F.Atoms[ 61 ], "O", 1.60896412,4.40274319, 1.23186209, 0.00000000);
		SetAtom(&F.Atoms[ 62 ], "O", 4.36716351,0.95242409, 17.62152529, 0.00000000);
		SetAtom(&F.Atoms[ 63 ], "O", 3.00840835,0.03766823, 3.50184365, 0.00000000);
		SetAtom(&F.Atoms[ 64 ], "Tv", 6.01681042,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 65 ], "Tv", -3.00840521,5.21071067, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 66 ], "Tv", 0.00000000,0.00000000, 23.49536705, 0.00000000);
	}
	else if(!strcmp(Name,"Ni3Sn_hP8_P6_3mmc_194")){
		F.NAtoms =11;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ni", 1.27715400,0.73736521, 3.18525000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ni", 2.64750000,3.11087410, 3.18525000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Ni", 1.27715400,-0.73736521, 1.06175000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Ni", 4.01784600,0.73736521, 3.18525000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Ni", 2.64750000,-3.11087410, 1.06175000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Ni", 4.01784600,-0.73736521, 1.06175000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Sn", 2.64750000,1.52853484, 1.06175000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Sn", 2.64750000,-1.52853484, 3.18525000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", 2.64750000,-4.58560451, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", 2.64750000,4.58560451, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Tv", 0.00000000,0.00000000, 4.24700000, 0.00000000);
	}
	else if(!strcmp(Name,"Ti2CS_hP8_P6_3/mmc_194")){
		F.NAtoms =11;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "C", 0.00000000,0.00000000, 5.63175535, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "C", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "S", 1.60234931,0.92511493, 2.81587768, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "S", -0.00000162,1.85023267, 8.44763303, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Ti", -0.00000162,1.85023267, 4.51232000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Ti", 1.60234931,0.92511493, 10.14407569, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Ti", 1.60234931,0.92511493, 6.75119037, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Ti", -0.00000162,1.85023267, 1.11943526, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", 3.20469546,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", -1.60234773,2.77534768, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Tv", 0.00000000,0.00000000, 11.26351070, 0.00000000);
	}
	else if(!strcmp(Name,"SiO2AlphaQuartz_hP9_P3_221_154")){
		F.NAtoms =12;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Si", 2.30931458,0.00000000, 3.60256683, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Si", -1.15465729,1.99992509, 1.80128341, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Si", 1.30153783,2.25432964, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 1.37645169,1.13758770, 4.24526466, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 3.23898439,0.62324828, 2.44398124, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 2.75314919,2.49341862, 0.64269795, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 0.29695400,1.76083598, 1.15858542, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", -1.07974335,3.11666691, 2.95986867, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 0.78278927,3.63100645, 4.76115225, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", 4.91239023,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Tv", -2.45619512,4.25425473, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Tv", 0.00000000,0.00000000, 5.40385008, 0.00000000);
	}
	else if(!strcmp(Name,"SiO2BetaQuartz_hP9_P6_2_171")){
		F.NAtoms =12;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Si", 2.49825001,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Si", -1.24912500,2.16354797, 3.63799996, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Si", 1.24912500,2.16354797, 1.81899998, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 1.55591008,0.89830511, 0.90949999, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 3.44058993,0.89830511, 4.54749970, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 2.49825001,2.53048573, 2.72849989, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 0.94233992,3.42879083, 0.90949999, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", -0.94233992,3.42879083, 4.54749970, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 0.00000000,1.79661021, 2.72849989, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", 4.99650002,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Tv", -2.49825001,4.32709594, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Tv", 0.00000000,0.00000000, 5.45699978, 0.00000000);
	}
	else if(!strcmp(Name,"W6Fe7_hR13_R-3m_166")){
		F.NAtoms =16;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Fe", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Fe", 1.18925000,0.68661381, 19.20773333, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Fe", -1.18925000,-0.68661381, 6.63226667, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Fe", 0.00000000,-1.37322762, 19.20773333, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Fe", 0.00000000,1.37322762, 6.63226667, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Fe", -1.18925000,0.68661381, 19.20773333, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Fe", 1.18925000,-0.68661381, 6.63226667, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "W", 0.00000000,-0.00000000, 4.31528000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "W", 0.00000000,-0.00000000, 21.52472000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "W", 0.00000000,-0.00000000, 8.94064000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "W", 0.00000000,-0.00000000, 16.89936000, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "W", 0.00000000,-0.00000000, 11.57632000, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "W", 0.00000000,-0.00000000, 14.26368000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Tv", 2.37850000,-1.37322762, 8.61333333, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Tv", 0.00000000,2.74645523, 8.61333333, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Tv", -2.37850000,-1.37322762, 8.61333333, 0.00000000);
	}
	else if(!strcmp(Name,"Hg_hR1_R-3m_166")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Po", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 1.72870341,-0.99806738, 2.22113343, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 0.00000000,1.99613476, 2.22113343, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", -1.72870341,-0.99806738, 2.22113343, 0.00000000);
	}
	else if(!strcmp(Name,"As_hR2_R-3m_166")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "As", 0.00000000,0.00000000, 2.37945404, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "As", 0.00000000,0.00000000, 8.07784596, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.87975000,-1.08527417, 3.48576667, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.17054834, 3.48576667, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", -1.87975000,-1.08527417, 3.48576667, 0.00000000);
	}
	else if(!strcmp(Name,"Al2O3_hR30_R-3c_167")){
		F.NAtoms =13;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Al", 2.38035010,1.37429590, 2.41043039, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Al", -0.00000002,2.74859167, 0.24464692, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Al", -2.38035007,4.12288738, 1.92113666, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Al", 0.00000016,2.74859188, 4.08692018, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 1.65172494,2.63631171, 1.08289176, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", -0.72862517,4.23516733, 1.08289176, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", -0.92309975,1.37429585, 1.08289176, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 0.72862530,1.26201603, 3.24867528, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 0.92309979,4.12288755, 3.24867528, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", -1.65172484,2.86087170, 3.24867528, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Tv", 4.76070023,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Tv", -2.38035011,4.12288734, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Tv", -2.38035001,1.37429607, 4.33156705, 0.00000000);
	}
	else if(!strcmp(Name,"Ca2H2Mg5O24Si8_mC78_C3/m_12")){
		F.NAtoms =44;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ca", 4.08198958,2.98008320, 2.55175187, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ca", 11.13336220,6.81619867, 2.55175187, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "H", 6.02328712,7.81049217, 3.92969778, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "H", 9.19206403,1.98579086, 1.17381098, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Mg", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Mg", 2.79962299,1.52306191, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Mg", 13.05328261,7.10129814, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Mg", 1.07310836,1.34317981, 2.55175187, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Mg", 14.14224306,8.45310187, 2.55175187, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 6.97545108,6.06026775, 1.49072833, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 8.23990133,3.73601293, 3.61277023, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 8.69607890,7.37257555, 3.00290163, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 10.27641173,4.46767978, 2.10060211, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 6.51927265,2.42370645, 2.10060211, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 4.93894003,5.32860183, 3.00290163, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", 9.27205243,6.91052553, 0.50626759, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "O", 10.20138935,5.20226074, 4.59724128, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "O", 5.94329910,2.88575765, 4.59724128, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "O", 5.01396210,4.59402257, 0.50626759, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "O", 10.72067772,8.54154580, 4.04860938, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "O", 12.35771563,5.53241731, 1.05488911, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "O", 4.49467444,1.25473493, 1.05488911, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "O", 2.85763671,4.26386309, 4.04860938, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "O", 5.63877222,8.51728978, 3.65003108, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "O", 9.57657878,1.27899321, 1.45347783, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "O", 2.80841319,1.30297644, 3.69494176, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "O", 1.98206680,2.82192871, 1.40857217, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "O", 12.40693772,8.49330794, 1.40857217, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "O", 13.23328406,6.97435575, 3.69494176, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "O", 7.32954121,8.65713835, 1.10797063, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "O", 10.61251125,2.62253245, 3.99552808, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "O", 7.88581103,1.13914259, 3.99552808, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "O", 4.60284125,7.17374801, 1.10797063, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "Si", 9.13477448,8.55259461, 4.10423767, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "Si", 11.50544057,4.19494423, 0.99927116, 0.00000000);
		SetAtom(&F.Atoms[ 35 ], "Si", 6.08057653,1.24368823, 0.99927116, 0.00000000);
		SetAtom(&F.Atoms[ 36 ], "Si", 3.70991033,5.60133881, 4.10423767, 0.00000000);
		SetAtom(&F.Atoms[ 37 ], "Si", 8.03879384,7.27789342, 1.51267856, 0.00000000);
		SetAtom(&F.Atoms[ 38 ], "Si", 9.83985599,3.96728221, 3.59083035, 0.00000000);
		SetAtom(&F.Atoms[ 39 ], "Si", 7.17655149,2.51838115, 3.59083035, 0.00000000);
		SetAtom(&F.Atoms[ 40 ], "Si", 5.37550554,5.82900060, 1.51267856, 0.00000000);
		SetAtom(&F.Atoms[ 41 ], "Tv", 10.27238178,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 42 ], "Tv", 5.58052358,8.62435992, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 43 ], "Tv", -0.63755359,1.17192195, 5.10350374, 0.00000000);
	}
	else if(!strcmp(Name,"ZnWO4_mP12_P2/c_13")){
		F.NAtoms =15;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "O", 3.82740693,4.70815753, 0.62263985, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", 1.09059182,2.85445907, 0.62263985, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 1.03232851,0.33358702, 5.18291393, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 3.76914362,2.18728518, 5.18291393, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 3.56771110,2.02607029, 2.17071977, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 1.23376095,0.49480184, 2.17071977, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 1.29202427,3.01567411, 3.63483414, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 3.62597442,4.54694248, 3.63483414, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Zn", 2.40073610,1.26043610, 3.90086780, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Zn", 2.45899941,3.78130830, 1.90468612, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "W", 0.02913166,1.26043610, 1.01410833, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "W", 0.08739497,3.78130830, 4.79144567, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Tv", 4.74320889,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Tv", 0.11652663,5.04174440, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Tv", 0.00000000,0.00000000, 5.80555391, 0.00000000);
	}
	else if(!strcmp(Name,"CaMgO6Si2Diopside_mP16_C2/c_15")){
		F.NAtoms =23;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ca", 1.54819684,2.22009463, 1.26421174, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ca", 3.40754982,5.30548227, 3.79261986, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Mg", 5.18864609,6.20703188, 1.26421174, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Mg", -0.23289211,1.31853861, 3.79261986, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 0.99005821,5.33338650, 5.03305937, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 3.65453634,2.90047132, 2.55218035, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 3.96570304,2.19217727, 0.02377214, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 1.30121091,4.62509911, 2.50465125, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 3.16846806,6.14486975, 1.60807076, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 5.30990829,4.18953660, 0.92034240, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 1.78728611,1.38070056, 3.44876069, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", -0.35415238,3.33603212, 4.13647903, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 0.60896388,6.52129620, 0.71908069, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 5.91685192,1.67469700, 1.80932743, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 4.34678954,1.00428091, 4.33775091, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", -0.96109413,5.85086398, 3.24748881, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Si", 1.78209169,5.52255201, 1.15942915, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Si", 4.81584797,2.75245171, 1.36897897, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Si", 3.17366311,2.00301737, 3.89739733, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Si", 0.13990176,4.77312230, 3.68783727, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Tv", 6.59880114,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Tv", -0.59830229,6.57162163, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Tv", -1.04474385,0.95394785, 5.05682648, 0.00000000);
	}
	else if(!strcmp(Name,"Bi2Nb2O9Pb_oA56_A2_1am_36")){
		F.NAtoms =59;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "O", 4.05439899,5.43977571, 23.78449373, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", 1.30639908,0.05622411, 1.76550551, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 1.30639908,0.05622411, 23.78449373, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 4.05439899,5.43977571, 1.76550551, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 4.05439899,2.69177580, 11.00949411, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 1.30639908,2.80422401, 14.54050513, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 1.30639908,2.80422401, 11.00949411, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 4.05439899,2.69177580, 14.54050513, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 4.26423622,5.33628603, 15.04613946, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 1.51623631,0.15971379, 10.50385978, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 1.51623631,0.15971379, 15.04613946, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 4.26423622,5.33628603, 10.50385978, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 4.26423622,2.58828612, 2.27113984, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 1.51623631,2.90771369, 23.27885940, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 1.51623631,2.90771369, 2.27113984, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", 4.26423622,2.58828612, 23.27885940, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "O", 3.91732867,5.45648363, 6.42710203, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "O", 1.16932877,0.03951618, 19.12289798, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "O", 1.16932877,0.03951618, 6.42710203, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "O", 3.91732867,5.45648363, 19.12289798, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "O", 3.91732867,2.70848373, 19.20210088, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "O", 1.16932877,2.78751608, 6.34789759, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "O", 1.16932877,2.78751608, 19.20210088, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "O", 3.91732867,2.70848373, 6.34789759, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "O", 2.76937922,3.72931070, 8.69006543, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "O", 0.02137932,1.76668911, 16.85993457, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "O", 0.02137932,1.76668911, 8.69006543, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "O", 2.76937922,3.72931070, 16.85993457, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "O", 2.76937922,0.98131079, 21.46506429, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "O", 0.02137932,4.51468902, 4.08493418, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "O", 0.02137932,4.51468902, 21.46506429, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "O", 2.76937922,0.98131079, 4.08493418, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "O", 2.79482586,1.66468340, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "O", 0.04682596,3.83131641, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "O", 2.79482586,4.41268331, 12.77499962, 0.00000000);
		SetAtom(&F.Atoms[ 35 ], "O", 0.04682596,1.08331651, 12.77499962, 0.00000000);
		SetAtom(&F.Atoms[ 36 ], "Pb", 5.32897625,1.41928707, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 37 ], "Pb", 2.58097651,4.07671290, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 38 ], "Pb", 5.32897625,4.16728682, 12.77499962, 0.00000000);
		SetAtom(&F.Atoms[ 39 ], "Pb", 2.58097651,1.32871284, 12.77499962, 0.00000000);
		SetAtom(&F.Atoms[ 40 ], "Bi", 2.44560997,4.27962528, 5.11664280, 0.00000000);
		SetAtom(&F.Atoms[ 41 ], "Bi", 5.19361004,1.21637453, 20.43335680, 0.00000000);
		SetAtom(&F.Atoms[ 42 ], "Bi", 5.19361004,1.21637453, 5.11664280, 0.00000000);
		SetAtom(&F.Atoms[ 43 ], "Bi", 2.44560997,4.27962528, 20.43335680, 0.00000000);
		SetAtom(&F.Atoms[ 44 ], "Bi", 2.44560997,1.53162538, 17.89164206, 0.00000000);
		SetAtom(&F.Atoms[ 45 ], "Bi", 5.19361004,3.96437444, 7.65835718, 0.00000000);
		SetAtom(&F.Atoms[ 46 ], "Bi", 5.19361004,3.96437444, 17.89164206, 0.00000000);
		SetAtom(&F.Atoms[ 47 ], "Bi", 2.44560997,1.53162538, 7.65835718, 0.00000000);
		SetAtom(&F.Atoms[ 48 ], "Nb", 2.62466975,4.10880956, 10.55214938, 0.00000000);
		SetAtom(&F.Atoms[ 49 ], "Nb", 5.37266981,1.38719025, 14.99784986, 0.00000000);
		SetAtom(&F.Atoms[ 50 ], "Nb", 5.37266981,1.38719025, 10.55214938, 0.00000000);
		SetAtom(&F.Atoms[ 51 ], "Nb", 2.62466975,4.10880956, 14.99784986, 0.00000000);
		SetAtom(&F.Atoms[ 52 ], "Nb", 2.62466975,1.36080966, 23.32714900, 0.00000000);
		SetAtom(&F.Atoms[ 53 ], "Nb", 5.37266981,4.13519015, 2.22285024, 0.00000000);
		SetAtom(&F.Atoms[ 54 ], "Nb", 5.37266981,4.13519015, 23.32714900, 0.00000000);
		SetAtom(&F.Atoms[ 55 ], "Nb", 2.62466975,1.36080966, 2.22285024, 0.00000000);
		SetAtom(&F.Atoms[ 56 ], "Tv", 5.49599981,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 57 ], "Tv", 0.00000000,5.49599981, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 58 ], "Tv", 0.00000000,0.00000000, 25.54999924, 0.00000000);
	}
	else if(!strcmp(Name,"Ga_oC8_Cmca_64")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ga", 2.26150000,2.64381110, 4.15755600, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ga", 2.26150000,1.18668890, 1.89555600, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Ga", 2.26150000,-1.18668890, 2.62844400, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Ga", 2.26150000,-2.64381110, 0.36644400, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.26150000,-3.83050000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 2.26150000,3.83050000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 4.52400000, 0.00000000);
	}
	else if(!strcmp(Name,"AuCu_tP2_P4/mmm_123")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Au", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Cu", 1.40000000,1.40000000, 1.83500000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.80000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.80000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 3.67000000, 0.00000000);
	}
	else if(!strcmp(Name,"U_oC4_Cmcm_63")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "U", 1.42220000,2.33417891, 3.69870000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "U", 1.42220000,-2.33417891, 1.23290000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.42220000,-2.93445000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.42220000,2.93445000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 4.93160000, 0.00000000);
	}
	else if(!strcmp(Name,"B2CoW2_oI10_Immm_71")){
		F.NAtoms =8;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "B", 1.59253079,0.72864429, 1.13416902, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "B", -1.59252979,1.74432071, 2.71511698, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Co", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "W", 0.00000050,2.43833266, 1.15252247, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "W", 0.00000050,0.03463735, 2.69677133, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 3.18506100,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", -1.59253000,4.23227900, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Tv", -1.59253000,-1.75931400, 3.84928600, 0.00000000);
	}
	else if(!strcmp(Name,"Fe3C_oP16_Pnma_62")){
		F.NAtoms =19;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "C", 0.55990000,5.06100000, 2.48765000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "C", 1.98510000,1.68700000, 0.22615000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "C", 3.10490000,5.06100000, 4.29685000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "C", 4.53010000,1.68700000, 2.03535000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Fe", 0.18324000,1.68700000, 3.85359600, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Fe", 4.90676000,5.06100000, 0.66940400, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Fe", 2.36176000,5.06100000, 1.59209600, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Fe", 2.72824000,1.68700000, 2.93090400, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Fe", 0.94674000,0.42512400, 1.48354400, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Fe", 0.94674000,2.94887600, 1.48354400, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Fe", 1.59826000,6.32287600, 3.74504400, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Fe", 1.59826000,3.79912400, 3.74504400, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Fe", 3.49174000,0.42512400, 0.77795600, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Fe", 3.49174000,2.94887600, 0.77795600, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Fe", 4.14326000,3.79912400, 3.03945600, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Fe", 4.14326000,6.32287600, 3.03945600, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Tv", 5.09000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Tv", 0.00000000,6.74800000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Tv", 0.00000000,0.00000000, 4.52300000, 0.00000000);
	}
	else if(!strcmp(Name,"Mg2SiO4_oP28_Pbnm_62")){
		F.NAtoms =31;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mg", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Mg", 5.09650000,0.00000000, 2.37600000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Mg", 0.00000000,2.98850000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Mg", 5.09650000,2.98850000, 2.37600000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Mg", 2.82753820,1.49425000, 4.71160800, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Mg", 2.26896180,4.48275000, 2.33560800, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Mg", 7.36546180,4.48275000, 0.04039200, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Mg", 7.92403820,1.49425000, 2.41639200, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 0.93062090,1.49425000, 3.63860640, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 4.16587910,4.48275000, 1.26260640, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 9.26237910,4.48275000, 1.11339360, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 6.02712090,1.49425000, 3.48939360, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 4.56034820,1.49425000, 1.05256800, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 0.53615180,4.48275000, 3.42856800, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 5.63265180,4.48275000, 3.69943200, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", 9.65684820,1.49425000, 1.32343200, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "O", 1.65942040,0.19783870, 1.31963040, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "O", 3.43707960,5.77916130, 3.69563040, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "O", 8.53357960,3.18633870, 3.43236960, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "O", 6.75592040,2.79066130, 1.05636960, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "O", 8.53357960,5.77916130, 3.43236960, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "O", 6.75592040,0.19783870, 1.05636960, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "O", 1.65942040,2.79066130, 1.31963040, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "O", 3.43707960,3.18633870, 3.69563040, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Si", 0.95814200,1.49425000, 2.02530240, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Si", 4.13835800,4.48275000, 4.40130240, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Si", 9.23485800,4.48275000, 2.72669760, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Si", 6.05464200,1.49425000, 0.35069760, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Tv", 10.19300000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "Tv", 0.00000000,5.97700000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "Tv", 0.00000000,0.00000000, 4.75200000, 0.00000000);
	}
	else if(!strcmp(Name,"Al2SiO5Sillimanite_oP32_Pbnm_62")){
		F.NAtoms =35;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "O", 0.08022906,4.73675301, 2.14925484, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", 2.98897616,2.83641743, 5.62893816, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 5.73726471,0.95016790, 1.73984177, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 2.82851793,6.62300299, 6.03835134, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 5.73726471,2.83641743, 5.62893816, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 2.82851793,4.73675301, 2.14925484, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 0.08022906,6.62300299, 6.03835134, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 2.98897616,0.95016790, 1.73984177, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 4.36312044,0.16405760, 3.89751253, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 1.45437348,7.40911299, 3.88068047, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 1.45437348,3.95064300, 7.76977697, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 4.36312044,3.62252766, 0.00841600, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 4.36312044,2.72092660, 3.19111246, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 1.45437348,4.85224406, 4.58708031, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 1.45437348,6.50751193, 0.69798393, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", 4.36312044,1.06565873, 7.08020919, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "O", 1.45437348,2.70700712, 3.37886251, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "O", 4.36312044,4.86616332, 4.39933049, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "O", 4.36312044,6.49359268, 0.51023394, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "O", 1.45437348,1.07957821, 7.26795901, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Al", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Al", 2.90874696,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Al", 0.00000000,3.78658533, 3.88909650, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Al", 2.90874696,3.78658533, 3.88909650, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Al", 1.45437348,2.70325083, 6.58187577, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Al", 4.36312044,4.86991984, 1.19631723, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Al", 4.36312044,6.48983616, 5.08541373, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Al", 1.45437348,1.08333451, 2.69277927, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Si", 4.36312044,1.15618081, 2.65276825, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "Si", 1.45437348,6.41698985, 5.12542475, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "Si", 1.45437348,4.94276614, 1.23632825, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "Si", 4.36312044,2.63040452, 6.54186475, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "Tv", 5.81749392,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "Tv", 0.00000000,7.57317066, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "Tv", 0.00000000,0.00000000, 7.77819300, 0.00000000);
	}
	else if(!strcmp(Name,"Goethite_AlphaFeO(OH)_oP40_Pnma_62")){
		F.NAtoms =19;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Fe", 8.50725003,2.25749999, 0.20790000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Fe", 6.41774969,0.75250000, 2.51790002, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Fe", 3.53224982,2.25749999, 2.10210001, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Fe", 1.44274993,0.75250000, 4.41209981, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "H", 0.79599996,2.25749999, 1.75559993, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "H", 4.17899979,0.75250000, 4.06559988, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "H", 5.77099972,2.25749999, 0.55439997, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "H", 9.15399999,0.75250000, 2.86439995, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 1.98004997,2.25749999, 3.28943997, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 2.99494993,0.75250000, 0.97943996, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 6.95504988,2.25749999, 3.64055985, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 7.96994984,0.75250000, 1.33055991, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 0.52734998,2.25749999, 0.91475997, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 4.44764988,0.75250000, 3.22475998, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 5.50234963,2.25749999, 1.39523990, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", 9.42265009,0.75250000, 3.70523984, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Tv", 9.94999981,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Tv", 0.00000000,3.00999999, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Tv", 0.00000000,0.00000000, 4.61999989, 0.00000000);
	}
	else if(!strcmp(Name,"Fe3H6KO14S2Jarosite_R60_R-3m_166")){
		F.NAtoms =29;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Fe", 3.56368208,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Fe", 1.68678799,3.13919994, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Fe", 1.68678778,1.00851238, 2.97278989, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "H", 5.47866827,5.37649933, 1.63503447, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "H", 5.47866807,3.27563708, 4.56621133, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "H", 7.32928965,2.28124183, 1.63503447, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "H", 6.54522634,6.01418307, 4.31054548, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "H", 8.39584799,5.01978778, 1.37936853, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "H", 8.39584778,2.91892547, 4.31054548, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "K", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 5.73282264,6.06768978, 1.56101195, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 5.73281896,3.42759118, 5.24453630, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 8.05844828,2.17796371, 1.56101195, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 5.81606729,6.11746094, 4.38456783, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 8.14168937,4.86782906, 0.70104928, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", 8.14169300,2.22773477, 4.38456783, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "O", 5.46045428,3.26474726, 2.33994233, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "O", 8.41406140,5.03067739, 3.60563745, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "O", 3.45621008,3.47208393, 1.00420841, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "O", 3.45621336,2.06643303, 2.96541746, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "O", 4.69443091,1.40109721, 1.00420841, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "O", 9.18008488,6.89432732, 4.94137128, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "O", 10.41830569,6.22899362, 2.98016852, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "O", 10.41830555,4.82334087, 4.94137128, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "S", 4.28486658,2.56187594, 1.83617336, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "S", 9.58964869,5.73354846, 4.10940624, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Tv", 7.12736416,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Tv", 3.37357597,6.27839988, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Tv", 3.37357555,2.01702477, 5.94557978, 0.00000000);
	}
	else if(!strcmp(Name,"Al2Si2O9H4_Kaolinite_tC26_C1_1")){
		F.NAtoms =29;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Al", 0.64879868,4.33299405, 3.37735116, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Al", 3.24039301,8.80537265, 3.37735116, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Al", 3.20287286,2.85131817, 3.36161276, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Al", 0.63906739,7.32369704, 3.36161276, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Si", 4.96228351,3.01552424, 0.65028853, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Si", 2.39847805,7.48790311, 0.65028853, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Si", 2.44191785,1.46978464, 0.65315013, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Si", -0.12188762,5.94216298, 0.65315013, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", -0.33394875,3.09778348, 2.26778298, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 2.25764543,7.57016182, 2.26778298, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 0.04119892,5.83924457, 2.27135988, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 2.60500439,1.36686596, 2.27135988, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 0.01389443,4.47237861, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 2.57769990,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 1.03439420,2.05648633, 0.17670108, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", 3.62598868,6.52886480, 0.17670108, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "O", 1.05246667,6.84831637, 0.02289245, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "O", 3.61627221,2.37593777, 0.02289245, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "O", -0.32169007,8.60579067, 2.30355240, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "O", 2.24211540,4.13341206, 2.30355240, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "O", 3.82982367,1.35994820, 4.32881836, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "O", 1.26601820,5.83232654, 4.32881836, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "O", -0.96209600,4.13578098, 4.34956467, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "O", 1.62949829,8.60815931, 4.34956467, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "O", -0.96140999,7.53538375, 4.35958007, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "O", 1.60239548,3.06300514, 4.35958007, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Tv", 5.15539980,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Tv", 0.02778886,8.94475721, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Tv", -1.89927049,-0.21377277, 7.15388950, 0.00000000);
	}
	else if(!strcmp(Name,"CaSiO3_tC40_C-1_2")){
		F.NAtoms =123;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ca", 3.42650008,5.94750023, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ca", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Ca", 3.50523405,9.94063510, 0.00786922, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Ca", 3.15891113,1.91315931, 19.66518082, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Ca", 0.07873397,3.99313487, 0.00786922, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Ca", 6.58541121,7.86065954, 19.66518082, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Ca", 3.38063787,5.89437258, 4.92022959, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Ca", 3.28350731,5.95942183, 14.75282000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Ca", -0.04586221,11.84187281, 4.92022959, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Ca", 6.71000739,0.01192160, 14.75282000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Ca", 3.38202758,10.02432058, 4.91826255, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Ca", 3.28211759,1.82947384, 14.75478764, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Ca", -0.04447250,4.07682035, 4.91826255, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Ca", 6.70861768,7.77697407, 14.75478764, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Ca", -0.04310195,7.98551808, 4.91826255, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Ca", 6.70724726,3.86827633, 14.75478764, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Ca", 3.38339800,2.03801785, 4.91826255, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Ca", 3.28074697,9.81577656, 14.75478764, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Ca", 3.33207259,5.92689721, 9.83652509, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Ca", -0.09442749,-0.02060302, 9.83652509, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Ca", 3.25404272,9.92006917, 9.82668868, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Ca", 3.41010226,1.93372525, 9.84636091, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Ca", 6.68054300,3.97256894, 9.82668868, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Ca", -0.01639762,7.88122548, 9.84636091, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Si", 1.39224181,6.40268993, 2.45716393, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Si", 5.27190326,5.45110448, 17.21588655, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Si", 4.81874200,0.45518970, 2.45716393, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Si", 1.84540318,11.39860471, 17.21588655, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Si", 1.36191321,9.48122765, 2.40404667, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "Si", 5.30223207,2.37256676, 17.26900321, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "Si", 4.78841319,3.53372742, 2.40404667, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "Si", 1.87573199,8.32006699, 17.26900321, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "Si", 4.03695215,7.96676306, 2.51421587, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "Si", 2.62719303,3.88703136, 17.15883460, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "Si", 0.61045206,2.01926283, 2.51421587, 0.00000000);
		SetAtom(&F.Atoms[ 35 ], "Si", 6.05369311,9.83453159, 17.15883460, 0.00000000);
		SetAtom(&F.Atoms[ 36 ], "Si", 2.71754642,7.95551085, 7.31837484, 0.00000000);
		SetAtom(&F.Atoms[ 37 ], "Si", 3.94659854,3.89828357, 12.35467593, 0.00000000);
		SetAtom(&F.Atoms[ 38 ], "Si", 6.14404671,2.00801062, 7.31837484, 0.00000000);
		SetAtom(&F.Atoms[ 39 ], "Si", 0.52009867,9.84578379, 12.35467593, 0.00000000);
		SetAtom(&F.Atoms[ 40 ], "Si", 5.36568311,6.39238842, 7.37542677, 0.00000000);
		SetAtom(&F.Atoms[ 41 ], "Si", 1.29846206,5.46140599, 12.29762400, 0.00000000);
		SetAtom(&F.Atoms[ 42 ], "Si", 1.93918303,0.44488819, 7.37542677, 0.00000000);
		SetAtom(&F.Atoms[ 43 ], "Si", 4.72496214,11.40890622, 12.29762400, 0.00000000);
		SetAtom(&F.Atoms[ 44 ], "Si", 5.39940081,9.46712701, 7.43247812, 0.00000000);
		SetAtom(&F.Atoms[ 45 ], "Si", 1.26474437,2.38666741, 12.24057206, 0.00000000);
		SetAtom(&F.Atoms[ 46 ], "Si", 1.97290073,3.51962678, 7.43247812, 0.00000000);
		SetAtom(&F.Atoms[ 47 ], "Si", 4.69124445,8.33416764, 12.24057206, 0.00000000);
		SetAtom(&F.Atoms[ 48 ], "O", 1.07563810,5.77048869, 1.02890050, 0.00000000);
		SetAtom(&F.Atoms[ 49 ], "O", 5.58850707,6.08330572, 18.64415013, 0.00000000);
		SetAtom(&F.Atoms[ 50 ], "O", 4.50213819,11.71798892, 1.02890050, 0.00000000);
		SetAtom(&F.Atoms[ 51 ], "O", 2.16200699,0.13580549, 18.64415013, 0.00000000);
		SetAtom(&F.Atoms[ 52 ], "O", 1.04151879,10.04692256, 0.94233908, 0.00000000);
		SetAtom(&F.Atoms[ 53 ], "O", 5.62262650,1.80687186, 18.73071066, 0.00000000);
		SetAtom(&F.Atoms[ 54 ], "O", 4.46801876,4.09942233, 0.94233908, 0.00000000);
		SetAtom(&F.Atoms[ 55 ], "O", 2.19612642,7.75437209, 18.73071066, 0.00000000);
		SetAtom(&F.Atoms[ 56 ], "O", 4.78717180,7.97209280, 1.10562544, 0.00000000);
		SetAtom(&F.Atoms[ 57 ], "O", 1.87697338,3.88170162, 18.56742423, 0.00000000);
		SetAtom(&F.Atoms[ 58 ], "O", 1.36067172,2.02459257, 1.10562544, 0.00000000);
		SetAtom(&F.Atoms[ 59 ], "O", 5.30347346,9.82920185, 18.56742423, 0.00000000);
		SetAtom(&F.Atoms[ 60 ], "O", 1.02778952,5.78356640, 3.87165616, 0.00000000);
		SetAtom(&F.Atoms[ 61 ], "O", 5.63635576,6.07022837, 15.80139402, 0.00000000);
		SetAtom(&F.Atoms[ 62 ], "O", 4.45428950,11.73106627, 3.87165616, 0.00000000);
		SetAtom(&F.Atoms[ 63 ], "O", 2.20985568,0.12272779, 15.80139402, 0.00000000);
		SetAtom(&F.Atoms[ 64 ], "O", 0.95797795,10.10875734, 3.79099675, 0.00000000);
		SetAtom(&F.Atoms[ 65 ], "O", 5.70616723,1.74503707, 15.88205286, 0.00000000);
		SetAtom(&F.Atoms[ 66 ], "O", 4.38447804,4.16125711, 3.79099675, 0.00000000);
		SetAtom(&F.Atoms[ 67 ], "O", 2.27966715,7.69253730, 15.88205286, 0.00000000);
		SetAtom(&F.Atoms[ 68 ], "O", 4.69529401,7.97561690, 3.96608692, 0.00000000);
		SetAtom(&F.Atoms[ 69 ], "O", 1.96885117,3.87817752, 15.70696297, 0.00000000);
		SetAtom(&F.Atoms[ 70 ], "O", 1.26879393,2.02811667, 3.96608692, 0.00000000);
		SetAtom(&F.Atoms[ 71 ], "O", 5.39535125,9.82567775, 15.70696297, 0.00000000);
		SetAtom(&F.Atoms[ 72 ], "O", 2.06402052,7.97164051, 5.86453616, 0.00000000);
		SetAtom(&F.Atoms[ 73 ], "O", 4.60012486,3.88215390, 13.80851402, 0.00000000);
		SetAtom(&F.Atoms[ 74 ], "O", 5.49052040,2.02414028, 5.86453616, 0.00000000);
		SetAtom(&F.Atoms[ 75 ], "O", 1.17362457,9.82965413, 13.80851402, 0.00000000);
		SetAtom(&F.Atoms[ 76 ], "O", 5.72328270,5.78394840, 5.96093426, 0.00000000);
		SetAtom(&F.Atoms[ 77 ], "O", 0.94086247,6.06984567, 13.71211651, 0.00000000);
		SetAtom(&F.Atoms[ 78 ], "O", 2.29678262,11.73144897, 5.96093426, 0.00000000);
		SetAtom(&F.Atoms[ 79 ], "O", 4.36736255,0.12234579, 13.71211651, 0.00000000);
		SetAtom(&F.Atoms[ 80 ], "O", 5.79728137,10.09097531, 6.03372431, 0.00000000);
		SetAtom(&F.Atoms[ 81 ], "O", 0.86686380,1.76281911, 13.63932587, 0.00000000);
		SetAtom(&F.Atoms[ 82 ], "O", 2.37078129,4.14347508, 6.03372431, 0.00000000);
		SetAtom(&F.Atoms[ 83 ], "O", 4.29336389,7.71031934, 13.63932587, 0.00000000);
		SetAtom(&F.Atoms[ 84 ], "O", 1.97379665,7.96095289, 8.69548822, 0.00000000);
		SetAtom(&F.Atoms[ 85 ], "O", 4.69034853,3.89284153, 10.97756139, 0.00000000);
		SetAtom(&F.Atoms[ 86 ], "O", 5.40029673,2.01345266, 8.69548822, 0.00000000);
		SetAtom(&F.Atoms[ 87 ], "O", 1.26384845,9.84034175, 10.97756139, 0.00000000);
		SetAtom(&F.Atoms[ 88 ], "O", 5.69010853,5.75664492, 8.77418058, 0.00000000);
		SetAtom(&F.Atoms[ 89 ], "O", 0.97403664,6.09714985, 10.89887019, 0.00000000);
		SetAtom(&F.Atoms[ 90 ], "O", 2.26360845,11.70414479, 8.77418058, 0.00000000);
		SetAtom(&F.Atoms[ 91 ], "O", 4.40053672,0.14964926, 10.89887019, 0.00000000);
		SetAtom(&F.Atoms[ 92 ], "O", 5.72476228,10.04219902, 8.87648040, 0.00000000);
		SetAtom(&F.Atoms[ 93 ], "O", 0.93938290,1.81159540, 10.79656978, 0.00000000);
		SetAtom(&F.Atoms[ 94 ], "O", 2.29826219,4.09469879, 8.87648040, 0.00000000);
		SetAtom(&F.Atoms[ 95 ], "O", 4.36588298,7.75909563, 10.79656978, 0.00000000);
		SetAtom(&F.Atoms[ 96 ], "O", 0.74215651,7.92768661, 2.42962164, 0.00000000);
		SetAtom(&F.Atoms[ 97 ], "O", 5.92198866,3.92610781, 17.24342868, 0.00000000);
		SetAtom(&F.Atoms[ 98 ], "O", 4.16865660,1.98018638, 2.42962164, 0.00000000);
		SetAtom(&F.Atoms[ 99 ], "O", 2.49548858,9.87360804, 17.24342868, 0.00000000);
		SetAtom(&F.Atoms[ 100 ], "O", 3.04632955,6.63697188, 2.48077171, 0.00000000);
		SetAtom(&F.Atoms[ 101 ], "O", 3.61781562,5.21682254, 17.19227848, 0.00000000);
		SetAtom(&F.Atoms[ 102 ], "O", 6.47282964,0.68947165, 2.48077171, 0.00000000);
		SetAtom(&F.Atoms[ 103 ], "O", 0.19131554,11.16432277, 17.19227848, 0.00000000);
		SetAtom(&F.Atoms[ 104 ], "O", 3.01082595,9.26936439, 2.46700063, 0.00000000);
		SetAtom(&F.Atoms[ 105 ], "O", 3.65331922,2.58443002, 17.20604955, 0.00000000);
		SetAtom(&F.Atoms[ 106 ], "O", 6.43732604,3.32186416, 2.46700063, 0.00000000);
		SetAtom(&F.Atoms[ 107 ], "O", 0.22681914,8.53193025, 17.20604955, 0.00000000);
		SetAtom(&F.Atoms[ 108 ], "O", 3.72454075,6.62199541, 7.35968807, 0.00000000);
		SetAtom(&F.Atoms[ 109 ], "O", 2.93960442,5.23179901, 12.31336270, 0.00000000);
		SetAtom(&F.Atoms[ 110 ], "O", 0.29804067,0.67449518, 7.35968807, 0.00000000);
		SetAtom(&F.Atoms[ 111 ], "O", 6.36610450,11.17929924, 12.31336270, 0.00000000);
		SetAtom(&F.Atoms[ 112 ], "O", 3.74359687,9.26741407, 7.37345915, 0.00000000);
		SetAtom(&F.Atoms[ 113 ], "O", 2.92054830,2.58638034, 12.29959162, 0.00000000);
		SetAtom(&F.Atoms[ 114 ], "O", 0.31709679,3.31991384, 7.37345915, 0.00000000);
		SetAtom(&F.Atoms[ 115 ], "O", 6.34704838,8.53388057, 12.29959162, 0.00000000);
		SetAtom(&F.Atoms[ 116 ], "O", 6.02684681,7.92562091, 7.39116489, 0.00000000);
		SetAtom(&F.Atoms[ 117 ], "O", 0.63729837,3.92817351, 12.28188529, 0.00000000);
		SetAtom(&F.Atoms[ 118 ], "O", 2.60034673,1.97812068, 7.39116489, 0.00000000);
		SetAtom(&F.Atoms[ 119 ], "O", 4.06379845,9.87567373, 12.28188529, 0.00000000);
		SetAtom(&F.Atoms[ 120 ], "Tv", 6.85300016,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 121 ], "Tv", 0.00000000,11.89500046, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 122 ], "Tv", -0.18885499,-0.04120604, 19.67305018, 0.00000000);
	}
	else if(!strcmp(Name,"Fe2B_tI12_I4/mcm_140")){
		F.NAtoms =9;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "B", 1.61581068,2.73254514, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "B", 0.53860356,0.91084838, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Fe", -1.54036263,0.91084840, 2.98199646, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Fe", 0.51390812,-0.30388457, 1.78951433, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Fe", 2.61756960,0.91084842, 0.59703208, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Fe", 0.56329909,2.12558118, 1.78951433, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 4.15793228,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Tv", -2.00351804,3.64339352, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", -1.07720718,-1.82169686, 3.57902865, 0.00000000);
	}
	else if(!strcmp(Name,"CuFeS2_tI16_I-42d_122")){
		F.NAtoms =11;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cu", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Cu", 0.00000000,2.64450000, 2.60575000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Fe", 2.64450000,0.00000000, 2.60575000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Fe", 0.00000000,0.00000000, 5.21150000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "S", 1.36138860,1.32225000, 1.30287500, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "S", 1.32225000,3.92761140, -1.30287500, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "S", 1.28311140,1.32225000, 6.51437500, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "S", 1.32225000,-1.28311140, 3.90862500, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", -2.64450000,2.64450000, 5.21150000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", 2.64450000,-2.64450000, 5.21150000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Tv", 2.64450000,2.64450000, -5.21150000, 0.00000000);
	}
	else if(!strcmp(Name,"ZrSiO4_tI24_I4_1/amd_141")){
		F.NAtoms =15;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "O", 2.08692720,1.65105000, -0.32828004, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", 4.51727280,1.65105000, -0.32828004, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 0.00000000,0.43587720, 1.16661996, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 3.30210000,0.43587720, 1.82318004, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", -0.00000000,2.86622280, 1.16661996, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 3.30210000,2.86622280, 1.82318004, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", -1.21517280,1.65105000, 3.31808004, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 1.21517280,1.65105000, 3.31808004, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Si", 3.30210000,1.65105000, 0.74745000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Si", -0.00000000,1.65105000, 2.24235000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Zr", 3.30210000,-1.65105000, 2.24235000, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Zr", 0.00000000,4.95315000, 0.74745000, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Tv", -3.30210000,3.30210000, 2.98980000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Tv", 3.30210000,-3.30210000, 2.98980000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Tv", 3.30210000,3.30210000, -2.98980000, 0.00000000);
	}
	else if(!strcmp(Name,"In_tI2_I4/mmm_139")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "In", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -2.30010000,2.30010000, 2.47315000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.30010000,-2.30010000, 2.47315000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.30010000,2.30010000, -2.47315000, 0.00000000);
	}
	else if(!strcmp(Name,"beta-Sn_tI4_I4_1_141")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Sn", 2.91590000,-1.45795000, 1.19321250, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Sn", 0.00000000,4.37385000, 0.39773750, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", -2.91590000,2.91590000, 1.59095000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.91590000,-2.91590000, 1.59095000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.91590000,2.91590000, -1.59095000, 0.00000000);
	}
	else if(!strcmp(Name,"La2CuO4_tI5_I4/mmm_139")){
		F.NAtoms =10;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "O", 1.90294226,1.90294226, 4.14192306, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", 0.00000171,0.00000171, 2.45594368, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 0.00000000,1.90294445, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 1.90294445,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Cu", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "La", 1.90294421,1.90294421, 1.83418054, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "La", -0.00000030,-0.00000030, 4.76368601, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Tv", 3.80588889,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", 0.00000000,3.80588889, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", -1.90294487,-1.90294487, 6.59786655, 0.00000000);
	}
	else if(!strcmp(Name,"Nd2CuO4_tI5_I4/mmm_139")){
		F.NAtoms =10;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "O", 1.88039605,1.88039605, 4.09125565, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", -0.00000182,-0.00000182, 2.39846413, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 0.00000000,1.88039410, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 1.88039410,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Cu", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Nd", 1.88039412,1.88039412, 1.79004651, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Nd", 0.00000005,0.00000005, 4.69967347, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Tv", 3.76078820,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", 0.00000000,3.76078820, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", -1.88039403,-1.88039403, 6.48971997, 0.00000000);
	}
	else if(!strcmp(Name,"Al3Ti_tI8_I4/mmm_139")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Al", 0.00000000,0.00000000, 4.29195000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Al", 1.92685000,0.00000000, 2.14597500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Al", 0.00000000,1.92685000, 2.14597500, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Ti", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", -1.92685000,1.92685000, 4.29195000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 1.92685000,-1.92685000, 4.29195000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 1.92685000,1.92685000, -4.29195000, 0.00000000);
	}
	else if(!strcmp(Name,"Al2SiO5Kyanite_tP16_P-1_2")){
		F.NAtoms =35;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "O", 0.69330408,1.80497047, 5.86371664, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", 3.56533384,3.03567613, 1.75202394, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 3.57327257,1.91280521, 5.51100894, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 0.68536519,2.92784135, 2.10473175, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "O", 2.02202008,4.89684190, 0.40503555, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "O", 2.23661768,-0.05619539, 7.21070534, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "O", 2.23231400,3.84270370, 4.22972166, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "O", 2.02632397,0.99794258, 3.38601926, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "O", 0.81919075,5.37939002, 2.81795346, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "O", 3.43944726,-0.53874388, 4.79778723, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "O", 0.64520122,4.41122293, 6.45116426, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "O", 3.61343655,0.42942364, 1.16457620, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "O", 0.57261012,0.45158016, 1.11538615, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "O", 3.68602764,4.38906605, 6.50035431, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "O", 0.86164529,-0.65741499, 5.22463408, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "O", 3.39699262,5.49806125, 2.39110638, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "O", 5.00868924,0.92315775, 3.46342559, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "O", -0.75005142,3.91748881, 4.15231509, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "O", 4.88668553,-0.08618053, 7.11828039, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "O", -0.62804776,4.92682670, 0.49746018, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Al", 3.47174781,6.09266481, 0.62923532, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Al", 0.78688989,-1.25201834, 6.98650531, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Al", 0.78370271,4.99551667, 4.67369633, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Al", 3.47493524,-0.15487021, 2.94204436, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Al", -0.69357657,4.29702028, 2.29421132, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Al", 4.95221452,0.54362607, 5.32152937, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Al", 2.11954300,4.11178340, 2.25411447, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Al", 2.13909464,0.72886295, 5.36162622, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Si", 3.59328118,3.52344003, 5.09112270, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "Si", 0.66535658,1.31720611, 2.52461799, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "Si", 0.68657132,2.89300143, 7.12141072, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "Si", 3.57206644,1.94764508, 0.49433014, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "Tv", 5.63563585,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "Tv", -1.39086793,7.06830762, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "Tv", 0.01386988,-2.22766127, 7.61574069, 0.00000000);
	}
	else if(!strcmp(Name,"Al2Zr3_tP20_P4_2/mnmc_136")){
		F.NAtoms =23;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Al", 0.95375001,0.95375001, 1.46957998, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Al", 6.67625010,6.67625010, 1.46957998, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Al", 4.76875007,2.86125004, 2.02941999, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Al", 2.86125004,4.76875007, 2.02941999, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Al", 6.67625010,6.67625010, 5.52842026, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Al", 0.95375001,0.95375001, 5.52842026, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Al", 4.76875007,2.86125004, 4.96857996, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Al", 2.86125004,4.76875007, 4.96857996, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Zr", 1.52600005,6.10400018, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Zr", 6.10400018,1.52600005, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Zr", 5.34099999,5.34099999, 3.49900007, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Zr", 2.28900013,2.28900013, 3.49900007, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Zr", 2.59420007,2.59420007, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Zr", 5.03580027,5.03580027, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Zr", 6.40919990,1.22079999, 3.49900007, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Zr", 1.22079999,6.40919990, 3.49900007, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Zr", 0.00000000,3.81500006, 1.74950004, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Zr", 3.81500006,0.00000000, 1.74950004, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Zr", 3.81500006,0.00000000, 5.24850011, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Zr", 0.00000000,3.81500006, 5.24850011, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Tv", 7.63000011,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Tv", 0.00000000,7.63000011, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Tv", 0.00000000,0.00000000, 6.99800014, 0.00000000);
	}
	else if(!strcmp(Name,"AuCu_tP2_P4/mmm_123")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Au", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Cu", 1.40000000,1.40000000, 1.83500000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.80000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.80000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 3.67000000, 0.00000000);
	}
	else if(!strcmp(Name,"CrFe_tP30_P4_2/mnm_136")){
		F.NAtoms =33;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Pd", 0.00000000,0.00000000, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Pd", 4.39830017,4.39830017, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Rh", 3.50667682,3.50667682, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Rh", 5.28992326,5.28992326, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Rh", 0.89162335,7.90497726, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Rh", 7.90497726,0.89162335, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Ni", 1.15428988,4.07713637, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Ni", 7.64231059,4.71946397, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Ni", 0.32116380,5.55258992, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Ni", 8.47543654,3.24401042, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Ni", 3.24401042,8.47543654, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Ni", 5.55258992,0.32116380, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Ni", 4.07713637,1.15428988, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Ni", 4.71946397,7.64231059, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Cr", 0.58136734,6.50359048, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Cr", 8.21523313,2.29300986, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Cr", 6.69131003,4.97966738, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Cr", 2.10529031,3.81693296, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Cr", 3.81693296,2.10529031, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Cr", 4.97966738,6.69131003, 2.27909994, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Cr", 6.50359048,0.58136734, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Cr", 2.29300986,8.21523313, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Fe", 1.60687496,1.60687496, 1.14875754, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Fe", 7.18972538,7.18972538, 3.40944234, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Fe", 7.18972538,7.18972538, 1.14875754, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Fe", 1.60687496,1.60687496, 3.40944234, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Fe", 2.79142521,6.00517513, 3.42785748, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Fe", 6.00517513,2.79142521, 1.13034240, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Fe", 6.00517513,2.79142521, 3.42785748, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "Fe", 2.79142521,6.00517513, 1.13034240, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "Tv", 8.79660034,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "Tv", 0.00000000,8.79660034, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "Tv", 0.00000000,0.00000000, 4.55819988, 0.00000000);
	}
	else if(!strcmp(Name,"TiO2_tP6_P4_2/mnm_136")){
		F.NAtoms =9;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "O", 0.89566269,3.69653731, 1.47870000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "O", 1.40043731,1.40043731, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "O", 3.19176269,3.19176269, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "O", 3.69653731,0.89566269, 1.47870000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Ti", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Ti", 2.29610000,2.29610000, 1.47870000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 4.59220000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Tv", 0.00000000,4.59220000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", 0.00000000,0.00000000, 2.95740000, 0.00000000);
	}

	/*CenterFrag(&F);*/
	for(i=1;i<(gint)strlen(Name);i++)
		T[i-1] = toupper(Name[i]);
	if(strlen(Name)-1>0)
	{
		T[strlen(Name)-1] ='\0';
		SetResidue(&F,T);
	}
	else
		SetResidue(&F,"UNK");
	//SetMMTypes(&F);
	return F;

}
/*****************************************************************/
Fragment GetFragmentElementCrystals(gchar* Name)
{
	Fragment F;
	gchar T[100]="UNK";
	gint i;

	initFragment(&F);
	if(!strcmp(Name,"Ac-Actinium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ac", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,2.65550000, 2.65550000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.65550000,0.00000000, 2.65550000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.65550000,2.65550000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Ag-Silver")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ag", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,2.04310000, 2.04310000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.04310000,0.00000000, 2.04310000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.04310000,2.04310000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Al-Aluminum")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Al", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,2.02479000, 2.02479000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.02479000,0.00000000, 2.02479000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.02479000,2.02479000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Am-Americium")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Am", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Am", 0.00000000,0.00000000, 5.62500000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Am", 1.00285742,1.73700000, 8.43750000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Am", 2.00571484,-0.00000000, 2.81250000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 3.00857225,-1.73700000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,3.47400000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 11.25000000, 0.00000000);
	}
	else if(!strcmp(Name,"Ar-Argon")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ar", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,2.62800000, 2.62800000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.62800000,0.00000000, 2.62800000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.62800000,2.62800000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"As-Arsenic")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "As", 0.00000000,0.00000000, 2.38253416, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "As", 0.00000000,0.00000000, 8.15965239, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.17175731,0.00000000, 3.51406218, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", -1.08587865,1.88079700, 3.51406218, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", -1.08587865,-1.88079700, 3.51406218, 0.00000000);
	}
	else if(!strcmp(Name,"As-Arsenolamprite")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "As", 1.81500000,0.40050000, -4.40592000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "As", 1.81500000,2.62550000, -1.07408000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "As", 1.81500000,1.82450000, 1.07408000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "As", 1.81500000,4.04950000, 4.40592000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 1.81500000,0.00000000, -5.48000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,4.45000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 1.81500000,0.00000000, 5.48000000, 0.00000000);
	}
	else if(!strcmp(Name,"Au-Gold")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Au", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,2.03912500, 2.03912500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.03912500,0.00000000, 2.03912500, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.03912500,2.03912500, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Ba-Barium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ba", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -2.51250000,2.51250000, 2.51250000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.51250000,-2.51250000, 2.51250000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.51250000,2.51250000, -2.51250000, 0.00000000);
	}
	else if(!strcmp(Name,"B-Boron")){
		F.NAtoms =15;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "B", -0.91653928,1.58749260, 2.84056090, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "B", 0.91653928,-1.58749260, 9.72643910, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "B", -1.83307856,0.00000000, 9.72643910, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "B", -0.91653928,-1.58749260, 2.84056090, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "B", 1.83307856,0.00000000, 2.84056090, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "B", 0.91653928,1.58749260, 9.72643910, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "B", -0.58330379,1.01031180, 4.49689150, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "B", 0.58330379,-1.01031180, 8.07010850, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "B", -1.16660758,0.00000000, 8.07010850, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "B", -0.58330379,-1.01031180, 4.49689150, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "B", 1.16660758,0.00000000, 4.49689150, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "B", 0.58330379,1.01031180, 8.07010850, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Tv", 2.83363512,0.00000000, 4.18900000, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Tv", -1.41681756,2.45400000, 4.18900000, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Tv", -1.41681756,-2.45400000, 4.18900000, 0.00000000);
	}
	else if(!strcmp(Name,"Be-Beryllium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Be", 0.66008456,1.14330000, 0.89582500, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Be", 1.32016913,-0.00000000, 2.68747500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.98025369,-1.14330000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.28660000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 3.58330000, 0.00000000);
	}
	else if(!strcmp(Name,"Bi-Bismuth")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Bi", 0.00000000,0.00000000, 2.81126896, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Bi", 0.00000000,0.00000000, 9.05062539, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.62482947,0.00000000, 3.95396478, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", -1.31241473,2.27316900, 3.95396478, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", -1.31241473,-2.27316900, 3.95396478, 0.00000000);
	}
	else if(!strcmp(Name,"Br-Bromine")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Br", 3.33500000,0.95920000, -1.63520000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Br", 3.33500000,5.31920000, -0.60480000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Br", 3.33500000,3.40080000, 0.60480000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Br", 3.33500000,7.76080000, 1.63520000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 3.33500000,0.00000000, -2.24000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,8.72000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 3.33500000,0.00000000, 2.24000000, 0.00000000);
	}
	else if(!strcmp(Name,"Ca-Calcium-alpha")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ca", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,2.78800000, 2.78800000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.78800000,0.00000000, 2.78800000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.78800000,2.78800000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Ca-Calcium-beta")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ca", 1.14892704,1.99000000, 1.63000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ca", 2.29785407,-0.00000000, 4.89000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.44678111,-1.99000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.98000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 6.52000000, 0.00000000);
	}
	else if(!strcmp(Name,"Ca-Calcium-gamma")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ca", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -2.19000000,2.19000000, 2.19000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.19000000,-2.19000000, 2.19000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.19000000,2.19000000, -2.19000000, 0.00000000);
	}
	else if(!strcmp(Name,"Cd-Cadmium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cd", 0.85992570,1.48943500, 1.40441250, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Cd", 1.71985140,-0.00000000, 4.21323750, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.57977709,-1.48943500, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.97887000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.61765000, 0.00000000);
	}
	else if(!strcmp(Name,"C-Diamond")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "C", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "C", 0.89169750,0.89169750, 0.89169750, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 0.00000000,1.78339500, 1.78339500, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.78339500,0.00000000, 1.78339500, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 1.78339500,1.78339500, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Ce-Cerium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ce", 1.05366424,1.82500000, 1.49000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ce", 2.10732848,-0.00000000, 4.47000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.16099272,-1.82500000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.65000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.96000000, 0.00000000);
	}
	else if(!strcmp(Name,"C-Graphite")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "C", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "C", 0.00000000,0.00000000, 3.34800000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "C", 0.70898613,1.22800000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "C", 1.41797226,-0.00000000, 3.34800000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.12695839,-1.22800000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,2.45600000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 6.69600000, 0.00000000);
	}
	else if(!strcmp(Name,"Cl-Chlorine")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cl", 3.12000000,0.82600000, -1.65760000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Cl", 3.12000000,4.95600000, -0.58240000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Cl", 3.12000000,3.30400000, 0.58240000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Cl", 3.12000000,7.43400000, 1.65760000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 3.12000000,0.00000000, -2.24000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,8.26000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 3.12000000,0.00000000, 2.24000000, 0.00000000);
	}
	else if(!strcmp(Name,"C-Lonsdaleite")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "C", 0.72746134,1.26000000, 0.25750000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "C", 0.72746134,1.26000000, 1.80250000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "C", 1.45492268,-0.00000000, 2.31750000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "C", 1.45492268,-0.00000000, 3.86250000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.18238402,-1.26000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,2.52000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 4.12000000, 0.00000000);
	}
	else if(!strcmp(Name,"Co-Cobalt")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Co", 0.72373743,1.25355000, 1.01715000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Co", 1.44747486,-0.00000000, 3.05145000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.17121229,-1.25355000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.50710000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 4.06860000, 0.00000000);
	}
	else if(!strcmp(Name,"Cr-Chromium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cr", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.44195000,1.44195000, 1.44195000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.44195000,-1.44195000, 1.44195000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.44195000,1.44195000, -1.44195000, 0.00000000);
	}
	else if(!strcmp(Name,"Cs-Cesium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cs", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -3.03350000,3.03350000, 3.03350000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.03350000,-3.03350000, 3.03350000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 3.03350000,3.03350000, -3.03350000, 0.00000000);
	}
	else if(!strcmp(Name,"Cu-Copper")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Cu", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,1.80748000, 1.80748000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.80748000,0.00000000, 1.80748000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.80748000,1.80748000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Dy-Dysprosium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Dy", 1.03643034,1.79515000, 1.41187500, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Dy", 2.07286067,-0.00000000, 4.23562500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.10929101,-1.79515000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.59030000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.64750000, 0.00000000);
	}
	else if(!strcmp(Name,"Er-Erbium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Er", 1.03643034,1.79515000, 1.41187500, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Er", 2.07286067,-0.00000000, 4.23562500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.10929101,-1.79515000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.59030000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.64750000, 0.00000000);
	}
	else if(!strcmp(Name,"Eu-Europium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Eu", 1.03643034,1.79515000, 1.41187500, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Eu", 2.07286067,-0.00000000, 4.23562500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.10929101,-1.79515000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.59030000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.64750000, 0.00000000);
	}
	else if(!strcmp(Name,"Fe-Iron-alpha")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Fe", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.43325000,1.43325000, 1.43325000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.43325000,-1.43325000, 1.43325000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.43325000,1.43325000, -1.43325000, 0.00000000);
	}
	else if(!strcmp(Name,"Fe-Iron-beta")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Fe", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.45500000,1.45500000, 1.45500000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.45500000,-1.45500000, 1.45500000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.45500000,1.45500000, -1.45500000, 0.00000000);
	}
	else if(!strcmp(Name,"Fe-Iron-delta")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Fe", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.47000000,1.47000000, 1.47000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.47000000,-1.47000000, 1.47000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.47000000,1.47000000, -1.47000000, 0.00000000);
	}
	else if(!strcmp(Name,"Fe-Iron-gamma")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Fe", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,1.79550000, 1.79550000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.79550000,0.00000000, 1.79550000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.79550000,1.79550000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Ga-Gallium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ga", 1.45000000,-2.98371000, 0.79250000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ga", 1.45000000,2.98371000, 2.37750000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.45000000,-4.06500000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.45000000,4.06500000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 3.17000000, 0.00000000);
	}
	else if(!strcmp(Name,"Gd-Gadolinium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Gd", 1.04962279,1.81800000, 1.44565000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Gd", 2.09924558,-0.00000000, 4.33695000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.14886837,-1.81800000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.63600000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.78260000, 0.00000000);
	}
	else if(!strcmp(Name,"Ge-Germanium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ge", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ge", 1.41433750,1.41433750, 1.41433750, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 0.00000000,2.82867500, 2.82867500, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.82867500,0.00000000, 2.82867500, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.82867500,2.82867500, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"He-Helium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "He", 1.03057023,1.78500000, 1.45750000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "He", 2.06114046,-0.00000000, 4.37250000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.09171069,-1.78500000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.57000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.83000000, 0.00000000);
	}
	else if(!strcmp(Name,"Hf-Hafnium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Hf", 0.92280780,1.59835000, 1.26445000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Hf", 1.84561561,-0.00000000, 3.79335000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.76842341,-1.59835000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.19670000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.05780000, 0.00000000);
	}
	else if(!strcmp(Name,"Ho-Holmium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ho", 1.03267756,1.78865000, 1.40395000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ho", 2.06535512,-0.00000000, 4.21185000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.09803268,-1.78865000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.57730000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.61580000, 0.00000000);
	}
	else if(!strcmp(Name,"I-Iodine")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "I", 3.63503500,1.13212166, -1.67986703, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "I", 3.63503500,6.02884166, -0.71515297, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "I", 3.63503500,3.76459834, 0.71515297, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "I", 3.63503500,8.66131834, 1.67986703, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 3.63503500,0.00000000, -2.39502000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,9.79344000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 3.63503500,0.00000000, 2.39502000, 0.00000000);
	}
	else if(!strcmp(Name,"In-Indium")){
                F.NAtoms =7;
                F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
                SetAtom(&F.Atoms[ 0 ], "In", 0.00000000,0.00000000, 0.00000000, 0.00000000);
                SetAtom(&F.Atoms[ 1 ], "In", 2.29150000,2.29150000, 0.00000000, 0.00000000);
                SetAtom(&F.Atoms[ 2 ], "In", 0.00000000,2.29150000, 0.00000000, 0.00000000);
                SetAtom(&F.Atoms[ 3 ], "In", 2.29150000,0.00000000, 0.00000000, 0.00000000);
                SetAtom(&F.Atoms[ 4 ], "Tv", 4.58300000,0.00000000, 0.00000000, 0.00000000);
                SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,4.58300000, 0.00000000, 0.00000000);
                SetAtom(&F.Atoms[ 6 ], "Tv", 2.29150000,2.29150000, 2.46800000, 0.00000000);
        }

	else if(!strcmp(Name,"Ir-Iridium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ir", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,1.91970000, 1.91970000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.91970000,0.00000000, 1.91970000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.91970000,1.91970000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"K-Potassium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "K", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -2.62350000,2.62350000, 2.62350000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.62350000,-2.62350000, 2.62350000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.62350000,2.62350000, -2.62350000, 0.00000000);
	}
	else if(!strcmp(Name,"Kr-Krypton")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Kr", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,2.86050000, 2.86050000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.86050000,0.00000000, 2.86050000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.86050000,2.86050000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"La-Lanthanum")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "La", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "La", 0.00000000,0.00000000, 6.07950000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "La", 1.08830526,1.88500000, 9.11925000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "La", 2.17661051,-0.00000000, 3.03975000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 3.26491577,-1.88500000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,3.77000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 12.15900000, 0.00000000);
	}
	else if(!strcmp(Name,"Li-Lithium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Li", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.75465000,1.75465000, 1.75465000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.75465000,-1.75465000, 1.75465000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.75465000,1.75465000, -1.75465000, 0.00000000);
	}
	else if(!strcmp(Name,"Lu-Lutetium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Lu", 1.01125786,1.75155000, 1.38772500, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Lu", 2.02251573,-0.00000000, 4.16317500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.03377359,-1.75155000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.50310000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.55090000, 0.00000000);
	}
	else if(!strcmp(Name,"Mg-Magnesium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mg", 0.92643645,1.60463500, 1.30258250, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Mg", 1.85287290,-0.00000000, 3.90774750, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.77930935,-1.60463500, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.20927000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.21033000, 0.00000000);
	}
	else if(!strcmp(Name,"Mn-Manganese-alpha")){
		F.NAtoms =32;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mn", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Mn", 2.81939800,2.81939800, 2.81939800, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Mn", -1.62760200,1.62760200, 1.62760200, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Mn", 1.62760200,-1.62760200, 1.62760200, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Mn", 1.62760200,1.62760200, -1.62760200, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Mn", 3.16626400,3.16626400, 0.37354800, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Mn", -1.28073600,4.07345200, 1.28073600, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Mn", 1.28073600,4.82054800, 1.28073600, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Mn", 0.37354800,3.16626400, 3.16626400, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Mn", 3.16626400,0.37354800, 3.16626400, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Mn", 4.07345200,1.28073600, -1.28073600, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Mn", 4.07345200,-1.28073600, 1.28073600, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Mn", 1.28073600,4.07345200, -1.28073600, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Mn", 4.82054800,1.28073600, 1.28073600, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Mn", 1.28073600,-1.28073600, 4.07345200, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Mn", 1.28073600,1.28073600, 4.82054800, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Mn", -1.28073600,1.28073600, 4.07345200, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Mn", 0.79156600,0.79156600, 2.47253200, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Mn", 0.79156600,6.42146800, -0.79156600, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "Mn", 3.65543400,-1.97446800, 3.65543400, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "Mn", 2.47253200,0.79156600, 0.79156600, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "Mn", 0.79156600,2.47253200, 0.79156600, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "Mn", 6.42146800,-0.79156600, 0.79156600, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "Mn", 6.42146800,0.79156600, -0.79156600, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "Mn", -0.79156600,6.42146800, 0.79156600, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "Mn", -1.97446800,3.65543400, 3.65543400, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "Mn", -0.79156600,0.79156600, 6.42146800, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "Mn", 3.65543400,3.65543400, -1.97446800, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "Mn", 0.79156600,-0.79156600, 6.42146800, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "Tv", -4.44700000,4.44700000, 4.44700000, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "Tv", 4.44700000,-4.44700000, 4.44700000, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "Tv", 4.44700000,4.44700000, -4.44700000, 0.00000000);
	}
	else if(!strcmp(Name,"Mn-Manganese-delta")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mn", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.54650000,1.54650000, 1.54650000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.54650000,-1.54650000, 1.54650000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.54650000,1.54650000, -1.54650000, 0.00000000);
	}
	else if(!strcmp(Name,"Mn-Manganese-gamma")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mn", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,1.93150000, 1.93150000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.93150000,0.00000000, 1.93150000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.93150000,1.93150000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Mo-Molybdenum")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Mo", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.57365000,1.57365000, 1.57365000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.57365000,-1.57365000, 1.57365000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.57365000,1.57365000, -1.57365000, 0.00000000);
	}
	else if(!strcmp(Name,"Na-Sodium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Na", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -2.14530000,2.14530000, 2.14530000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.14530000,-2.14530000, 2.14530000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.14530000,2.14530000, -2.14530000, 0.00000000);
	}
	else if(!strcmp(Name,"Nb-Niobium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Nb", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.65020000,1.65020000, 1.65020000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.65020000,-1.65020000, 1.65020000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.65020000,1.65020000, -1.65020000, 0.00000000);
	}
	else if(!strcmp(Name,"Nd-Neodymium")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Nd", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Nd", 0.00000000,0.00000000, 5.89960000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Nd", 1.05594477,1.82895000, 8.84940000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Nd", 2.11188955,-0.00000000, 2.94980000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 3.16783432,-1.82895000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,3.65790000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 11.79920000, 0.00000000);
	}
	else if(!strcmp(Name,"Ne-Neon")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ne", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,2.21450000, 2.21450000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.21450000,0.00000000, 2.21450000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.21450000,2.21450000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Ni-Nickel")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ni", 0.76498911,1.32500000, 1.08250000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ni", 1.52997821,-0.00000000, 3.24750000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.29496732,-1.32500000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.65000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 4.33000000, 0.00000000);
	}
	else if(!strcmp(Name,"N-Nitrogen")){
		F.NAtoms =11;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "N", 0.30477600,0.30477600, 0.30477600, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "N", 3.12677600,2.51722400, 5.33922400, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "N", 0.30477600,2.51722400, 3.12677600, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "N", 3.12677600,0.30477600, 2.51722400, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "N", 2.51722400,5.33922400, 3.12677600, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "N", 2.51722400,3.12677600, 0.30477600, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "N", 5.33922400,3.12677600, 2.51722400, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "N", 5.33922400,5.33922400, 5.33922400, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", 5.64400000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", 0.00000000,5.64400000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Tv", 0.00000000,0.00000000, 5.64400000, 0.00000000);
	}
	else if(!strcmp(Name,"Np-Neptunium-alpha")){
		F.NAtoms =11;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Np", 1.18075000,1.01649600, 0.23986800, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Np", 1.18075000,1.42700400, 3.57136800, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Np", 3.54225000,3.87050400, 6.42313200, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Np", 3.54225000,3.45999600, 3.09163200, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Np", 1.18075000,4.11485400, 2.12549700, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Np", 1.18075000,3.21564600, 5.45699700, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Np", 3.54225000,0.77214600, 4.53750300, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Np", 3.54225000,1.67135400, 1.20600300, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", 4.72300000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", 0.00000000,4.88700000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Tv", 0.00000000,0.00000000, 6.66300000, 0.00000000);
	}
	else if(!strcmp(Name,"Np-Neptunium-beta")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Np", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Np", 2.44850000,2.44850000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Np", 0.00000000,2.44850000, 2.11750000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Np", 2.44850000,0.00000000, 1.27050000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 4.89700000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,4.89700000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 3.38800000, 0.00000000);
	}
	else if(!strcmp(Name,"Np-Neptunium-gamma")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Np", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.76000000,1.76000000, 1.76000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.76000000,-1.76000000, 1.76000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.76000000,1.76000000, -1.76000000, 0.00000000);
	}
	else if(!strcmp(Name,"Os-Osmium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Os", 0.78958423,1.36760000, 1.07975000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Os", 1.57916846,-0.00000000, 3.23925000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.36875268,-1.36760000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.73520000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 4.31900000, 0.00000000);
	}
	else if(!strcmp(Name,"Pb-Lead")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Pb", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,2.47525000, 2.47525000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.47525000,0.00000000, 2.47525000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.47525000,2.47525000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Pd-Palladium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Pd", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,1.94490000, 1.94490000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.94490000,0.00000000, 1.94490000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.94490000,1.94490000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"P-Phosphorus-black")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "P", 1.65500000,0.39420000, -4.22100000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "P", 1.65500000,2.58420000, -1.02900000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "P", 1.65500000,1.79580000, 1.02900000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "P", 1.65500000,3.98580000, 4.22100000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 1.65500000,0.00000000, -5.25000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,4.38000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 1.65500000,0.00000000, 5.25000000, 0.00000000);
	}
	else if(!strcmp(Name,"P-Phosphorus")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "P", 1.65500000,0.39420000, -4.22100000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "P", 1.65500000,2.58420000, -1.02900000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "P", 1.65500000,1.79580000, 1.02900000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "P", 1.65500000,3.98580000, 4.22100000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 1.65500000,0.00000000, -5.25000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,4.38000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 1.65500000,0.00000000, 5.25000000, 0.00000000);
	}
	else if(!strcmp(Name,"Pr-Praseodymium")){
		F.NAtoms =7;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Pr", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Pr", 0.00000000,0.00000000, 5.91770000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Pr", 1.06015943,1.83625000, 8.87655000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Pr", 2.12031886,-0.00000000, 2.95885000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 3.18047830,-1.83625000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,3.67250000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 0.00000000,0.00000000, 11.83540000, 0.00000000);
	}
	else if(!strcmp(Name,"Pt-Platinum")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Pt", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,1.96155000, 1.96155000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.96155000,0.00000000, 1.96155000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.96155000,1.96155000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Pu-Plutonium-alpha")){
		F.NAtoms =19;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Pu", 1.70511205,1.20610000, 1.66487234, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Pu", 2.23445278,3.61830000, 9.07623952, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Pu", 4.39334034,1.20610000, 1.87969457, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Pu", -0.45377552,3.61830000, 8.86141728, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Pu", 0.12524210,1.20610000, 3.66271914, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Pu", 3.81432272,3.61830000, 7.07839271, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Pu", 3.04326462,1.20610000, 4.90868812, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Pu", 0.89630020,3.61830000, 5.83242374, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Pu", -1.29454774,1.20610000, 6.67023046, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Pu", 5.23411257,3.61830000, 4.07088139, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Pu", 1.43023325,1.20610000, 6.91727604, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "Pu", 2.50933158,3.61830000, 3.82383582, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "Pu", 0.00595553,1.20610000, 9.94626958, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "Pu", 3.93360930,3.61830000, 0.79484228, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "Pu", 3.50287215,1.20610000, 9.63477734, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "Pu", 0.43669268,3.61830000, 1.10633452, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "Tv", 6.18350000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "Tv", 0.00000000,4.82440000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "Tv", -2.24393518,0.00000000, 10.74111186, 0.00000000);
	}
	else if(!strcmp(Name,"Pu-Plutonium-epsilon")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Pu", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.81900000,1.81900000, 1.81900000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.81900000,-1.81900000, 1.81900000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.81900000,1.81900000, -1.81900000, 0.00000000);
	}
	else if(!strcmp(Name,"Pu-Plutonium-gamma")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Pu", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Pu", 0.78967500,1.44205000, 2.54050000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.57935000,0.00000000, 5.08100000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.57935000,2.88410000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,2.88410000, 5.08100000, 0.00000000);
	}
	else if(!strcmp(Name,"Rb-Rubidium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Rb", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -2.80250000,2.80250000, 2.80250000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.80250000,-2.80250000, 2.80250000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.80250000,2.80250000, -2.80250000, 0.00000000);
	}
	else if(!strcmp(Name,"Re-Rhenium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Re", 0.79697431,1.38040000, 1.11455000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Re", 1.59394862,-0.00000000, 3.34365000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.39092293,-1.38040000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.76080000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 4.45820000, 0.00000000);
	}
	else if(!strcmp(Name,"Rh-Rhodium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Rh", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,1.90155000, 1.90155000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.90155000,0.00000000, 1.90155000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.90155000,1.90155000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Ru-Ruthenium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ru", 0.78054581,1.35194500, 1.07042000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ru", 1.56109162,-0.00000000, 3.21126000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.34163743,-1.35194500, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.70389000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 4.28168000, 0.00000000);
	}
	else if(!strcmp(Name,"S6-Sulfur")){
		F.NAtoms =9;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "S", 1.77615142,0.56252350, 1.66465000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "S", -0.40091607,-1.81945400, 1.66465000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "S", 1.37523535,-1.25693050, 2.56035000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "S", 0.40091607,1.81945400, 2.56035000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "S", -1.77615142,-0.56252350, 2.56035000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "S", -1.37523535,1.25693050, 1.66465000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "Tv", 6.21575300,0.00000000, 1.40833333, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "Tv", -3.10787650,5.38300000, 1.40833333, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", -3.10787650,-5.38300000, 1.40833333, 0.00000000);
	}
	else if(!strcmp(Name,"S8-Sulfur-alpha")){
		F.NAtoms =35;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "S", 8.95602326,5.82405222, 11.05444956, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "S", 1.50857674,2.60755222, 4.93294956, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "S", 4.12472674,5.82405222, 19.55305044, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "S", 4.12472674,10.25844778, 11.05444956, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "S", 8.95602326,10.25844778, 19.55305044, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "S", 6.33987326,7.04194778, 4.93294956, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "S", 6.33987326,2.60755222, 13.43155044, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "S", 1.50857674,7.04194778, 13.43155044, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "S", 7.40192552,6.17272082, 12.34314774, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "S", 3.06267448,2.95622082, 6.22164774, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "S", 5.67882448,6.17272082, 18.26435226, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "S", 5.67882448,9.90977918, 12.34314774, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "S", 7.40192552,9.90977918, 18.26435226, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "S", 4.78577552,6.69327918, 6.22164774, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "S", 4.78577552,2.95622082, 12.14285226, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "S", 3.06267448,6.69327918, 12.14285226, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "S", 8.20581609,6.82181052, 14.10956778, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "S", 2.25878391,3.60531052, 7.98806778, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "S", 4.87493391,6.82181052, 16.49793222, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "S", 4.87493391,9.26068948, 14.10956778, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "S", 8.20581609,9.26068948, 16.49793222, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "S", 5.58966609,6.04418948, 7.98806778, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "S", 5.58966609,3.60531052, 10.37643222, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "S", 2.25878391,6.04418948, 10.37643222, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "S", 2.99245702,5.24521088, 3.17020242, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "S", 7.47214298,8.46171088, 9.29170242, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "S", 4.85599298,5.24521088, 15.19429758, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "S", 4.85599298,4.40428912, 3.17020242, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "S", 2.99245702,4.40428912, 15.19429758, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "S", 5.60860702,7.62078912, 9.29170242, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "S", 5.60860702,8.46171088, 21.31579758, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "S", 7.47214298,7.62078912, 21.31579758, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "Tv", 5.23230000,0.00000000, 12.24300000, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "Tv", 5.23230000,6.43300000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "Tv", 0.00000000,6.43300000, 12.24300000, 0.00000000);
	}
	else if(!strcmp(Name,"S8-Sulfur-beta")){
		F.NAtoms =35;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "S", 8.95602326,5.82405222, 11.05444956, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "S", 1.50857674,2.60755222, 4.93294956, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "S", 4.12472674,5.82405222, 19.55305044, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "S", 4.12472674,10.25844778, 11.05444956, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "S", 8.95602326,10.25844778, 19.55305044, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "S", 6.33987326,7.04194778, 4.93294956, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "S", 6.33987326,2.60755222, 13.43155044, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "S", 1.50857674,7.04194778, 13.43155044, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "S", 7.40192552,6.17272082, 12.34314774, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "S", 3.06267448,2.95622082, 6.22164774, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "S", 5.67882448,6.17272082, 18.26435226, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "S", 5.67882448,9.90977918, 12.34314774, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "S", 7.40192552,9.90977918, 18.26435226, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "S", 4.78577552,6.69327918, 6.22164774, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "S", 4.78577552,2.95622082, 12.14285226, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "S", 3.06267448,6.69327918, 12.14285226, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "S", 8.20581609,6.82181052, 14.10956778, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "S", 2.25878391,3.60531052, 7.98806778, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "S", 4.87493391,6.82181052, 16.49793222, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "S", 4.87493391,9.26068948, 14.10956778, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "S", 8.20581609,9.26068948, 16.49793222, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "S", 5.58966609,6.04418948, 7.98806778, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "S", 5.58966609,3.60531052, 10.37643222, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "S", 2.25878391,6.04418948, 10.37643222, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "S", 2.99245702,5.24521088, 3.17020242, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "S", 7.47214298,8.46171088, 9.29170242, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "S", 4.85599298,5.24521088, 15.19429758, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "S", 4.85599298,4.40428912, 3.17020242, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "S", 2.99245702,4.40428912, 15.19429758, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "S", 5.60860702,7.62078912, 9.29170242, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "S", 5.60860702,8.46171088, 21.31579758, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "S", 7.47214298,7.62078912, 21.31579758, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "Tv", 5.23230000,0.00000000, 12.24300000, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "Tv", 5.23230000,6.43300000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "Tv", 0.00000000,6.43300000, 12.24300000, 0.00000000);
	}
	else if(!strcmp(Name,"S8-Sulfur-gamma")){
		F.NAtoms =35;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "S", 3.76191423,4.51207640, 2.46813325, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "S", 2.04271116,4.51207640, 1.33250311, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "S", 1.11153962,8.53992360, 6.26876960, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "S", -0.60766345,8.53992360, 5.13313946, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "S", 4.36141227,7.55971840, 3.57867919, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "S", 1.44321312,7.55971840, 0.22195716, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "S", 1.71103766,5.49228160, 7.37931554, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "S", -1.20716149,5.49228160, 4.02259352, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "S", 3.47612449,5.78203600, 4.04311695, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "S", -2.97224832,5.78203600, 7.35879211, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "S", 6.12649910,7.26996400, 0.24248060, 0.00000000);
		SetAtom(&F.Atoms[ 11 ], "S", -0.32187371,7.26996400, 3.55815575, 0.00000000);
		SetAtom(&F.Atoms[ 12 ], "S", 2.89885030,8.83359360, 2.91888872, 0.00000000);
		SetAtom(&F.Atoms[ 13 ], "S", 2.90577509,8.83359360, 0.88174763, 0.00000000);
		SetAtom(&F.Atoms[ 14 ], "S", 0.24847569,4.21840640, 6.71952507, 0.00000000);
		SetAtom(&F.Atoms[ 15 ], "S", 0.25540048,4.21840640, 4.68238399, 0.00000000);
		SetAtom(&F.Atoms[ 16 ], "S", -0.38088482,10.41419080, 1.51493365, 0.00000000);
		SetAtom(&F.Atoms[ 17 ], "S", 6.18551021,10.41419080, 2.28570270, 0.00000000);
		SetAtom(&F.Atoms[ 18 ], "S", -3.03125943,2.63780920, 5.31557000, 0.00000000);
		SetAtom(&F.Atoms[ 19 ], "S", 3.53513560,2.63780920, 6.08633905, 0.00000000);
		SetAtom(&F.Atoms[ 20 ], "S", 0.88533360,0.40461200, 1.67304012, 0.00000000);
		SetAtom(&F.Atoms[ 21 ], "S", 4.91929179,0.40461200, 2.12759623, 0.00000000);
		SetAtom(&F.Atoms[ 22 ], "S", -1.76504101,12.64738800, 5.47367647, 0.00000000);
		SetAtom(&F.Atoms[ 23 ], "S", 2.26891719,12.64738800, 5.92823258, 0.00000000);
		SetAtom(&F.Atoms[ 24 ], "S", 0.74327470,11.66587760, 2.66120557, 0.00000000);
		SetAtom(&F.Atoms[ 25 ], "S", 5.06135069,11.66587760, 1.13943078, 0.00000000);
		SetAtom(&F.Atoms[ 26 ], "S", -1.90709991,1.38612240, 6.46184193, 0.00000000);
		SetAtom(&F.Atoms[ 27 ], "S", 2.41097608,1.38612240, 4.94006713, 0.00000000);
		SetAtom(&F.Atoms[ 28 ], "S", -0.49219029,1.65890920, 2.50385923, 0.00000000);
		SetAtom(&F.Atoms[ 29 ], "S", 6.29681568,1.65890920, 1.29677712, 0.00000000);
		SetAtom(&F.Atoms[ 30 ], "S", -3.14256490,11.39309080, 6.30449558, 0.00000000);
		SetAtom(&F.Atoms[ 31 ], "S", 3.64644107,11.39309080, 5.09741348, 0.00000000);
		SetAtom(&F.Atoms[ 32 ], "Tv", 8.45500000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 33 ], "Tv", 0.00000000,13.05200000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 34 ], "Tv", -5.30074922,0.00000000, 7.60127270, 0.00000000);
	}
	else if(!strcmp(Name,"Sb-Antimony")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Sb", 0.00000000,0.00000000, 2.62685171, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Sb", 0.00000000,0.00000000, 8.64718995, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.48734043,0.00000000, 3.75801388, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", -1.24367021,2.15410000, 3.75801388, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", -1.24367021,-2.15410000, 3.75801388, 0.00000000);
	}
	else if(!strcmp(Name,"Sc-Scandium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Sc", 0.95522602,1.65450000, 1.31832500, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Sc", 1.91045204,-0.00000000, 3.95497500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.86567806,-1.65450000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.30900000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.27330000, 0.00000000);
	}
	else if(!strcmp(Name,"Se-Selenium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Se", 0.95522602,1.65450000, 1.31832500, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Se", 1.91045204,-0.00000000, 3.95497500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.86567806,-1.65450000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.30900000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.27330000, 0.00000000);
	}
	else if(!strcmp(Name,"Si-Silicon")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Si", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Si", 1.35767500,1.35767500, 1.35767500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 0.00000000,2.71535000, 2.71535000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.71535000,0.00000000, 2.71535000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.71535000,2.71535000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Sm-Samarium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Sm", 1.04529266,1.81050000, 6.56250000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Sm", 2.09058532,-0.00000000, 19.68750000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.13587799,-1.81050000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.62100000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 26.25000000, 0.00000000);
	}
	else if(!strcmp(Name,"Sn-Tin-alpha")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Sn", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Sn", 1.62280000,1.62280000, 1.62280000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 0.00000000,3.24560000, 3.24560000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 3.24560000,0.00000000, 3.24560000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 3.24560000,3.24560000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Sn-Tin-beta")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Sn", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Sn", 5.81970000,2.90985000, 0.79372000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 5.81970000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,5.81970000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 2.90985000,2.90985000, 1.58744000, 0.00000000);
	}
	else if(!strcmp(Name,"Sr-Strontium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Sr", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -2.42500000,2.42500000, 2.42500000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.42500000,-2.42500000, 2.42500000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.42500000,2.42500000, -2.42500000, 0.00000000);
	}
	else if(!strcmp(Name,"Ta-Tantalum")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ta", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.65290000,1.65290000, 1.65290000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.65290000,-1.65290000, 1.65290000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.65290000,1.65290000, -1.65290000, 0.00000000);
	}
	else if(!strcmp(Name,"Tb-Terbium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Tb", 1.03951916,1.80050000, 1.42340000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tb", 2.07903832,-0.00000000, 4.27020000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.11855748,-1.80050000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.60100000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.69360000, 0.00000000);
	}
	else if(!strcmp(Name,"Te-Tellurium")){
		F.NAtoms =6;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Te", 1.03596052,-0.59811209, 0.98582000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Te", 2.81519383,1.62535291, 2.95746000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Te", 0.00000000,1.19622417, 4.92910000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 3.85115435,-2.22346500, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,4.44693000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "Tv", 0.00000000,0.00000000, 5.91492000, 0.00000000);
	}
	else if(!strcmp(Name,"Th-Thorium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Th", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -2.05500000,2.05500000, 2.05500000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.05500000,-2.05500000, 2.05500000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.05500000,2.05500000, -2.05500000, 0.00000000);
	}
	else if(!strcmp(Name,"Ti-Titanium-alpha")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ti", 0.85159165,1.47500000, 1.17150000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Ti", 1.70318329,-0.00000000, 3.51450000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.55477494,-1.47500000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.95000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 4.68600000, 0.00000000);
	}
	else if(!strcmp(Name,"Ti-Titanium-beta")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Ti", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.65325000,1.65325000, 1.65325000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.65325000,-1.65325000, 1.65325000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.65325000,1.65325000, -1.65325000, 0.00000000);
	}
	else if(!strcmp(Name,"Tl-Thallium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Tl", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.94100000,1.94100000, 1.94100000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.94100000,-1.94100000, 1.94100000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.94100000,1.94100000, -1.94100000, 0.00000000);
	}
	else if(!strcmp(Name,"Tm-Thulium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Tm", 1.02118829,1.76875000, 1.38865000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tm", 2.04237658,-0.00000000, 4.16595000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.06356487,-1.76875000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.53750000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.55460000, 0.00000000);
	}
	else if(!strcmp(Name,"U-Uranium-alpha")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "U", 1.42700000,-2.33292750, 1.23875000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "U", 1.42700000,2.33292750, 3.71625000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.42700000,-2.93450000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.42700000,2.93450000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 4.95500000, 0.00000000);
	}
	else if(!strcmp(Name,"U-Uranium-gamma")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "U", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.73700000,1.73700000, 1.73700000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.73700000,-1.73700000, 1.73700000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.73700000,1.73700000, -1.73700000, 0.00000000);
	}
	else if(!strcmp(Name,"V-Vanadium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "V", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.51200000,1.51200000, 1.51200000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.51200000,-1.51200000, 1.51200000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.51200000,1.51200000, -1.51200000, 0.00000000);
	}
	else if(!strcmp(Name,"W-Tungsten")){
		F.NAtoms =11;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "W", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "W", 2.54150000,2.54150000, 2.54150000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "W", 0.00000000,2.54150000, 1.27075000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "W", 2.54150000,3.81225000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "W", 3.81225000,0.00000000, 2.54150000, 0.00000000);
		SetAtom(&F.Atoms[ 5 ], "W", 2.54150000,1.27075000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 6 ], "W", 1.27075000,0.00000000, 2.54150000, 0.00000000);
		SetAtom(&F.Atoms[ 7 ], "W", 0.00000000,2.54150000, 3.81225000, 0.00000000);
		SetAtom(&F.Atoms[ 8 ], "Tv", 5.08300000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 9 ], "Tv", 0.00000000,5.08300000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 10 ], "Tv", 0.00000000,0.00000000, 5.08300000, 0.00000000);
	}
	else if(!strcmp(Name,"Xe-Xenon")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Xe", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,3.09850000, 3.09850000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.09850000,0.00000000, 3.09850000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 3.09850000,3.09850000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Yb-Ytterbium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Yb", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", 0.00000000,2.74310000, 2.74310000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.74310000,0.00000000, 2.74310000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 2.74310000,2.74310000, 0.00000000, 0.00000000);
	}
	else if(!strcmp(Name,"Y-Yttrium")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Y", 1.05291369,1.82370000, 1.43265000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Y", 2.10582737,-0.00000000, 4.29795000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 3.15874106,-1.82370000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,3.64740000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 5.73060000, 0.00000000);
	}
	else if(!strcmp(Name,"Zn-Zinc")){
		F.NAtoms =5;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Zn", 0.76926150,1.33240000, 1.23667500, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Zn", 1.53852300,-0.00000000, 3.71002500, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 2.30778450,-1.33240000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 0.00000000,2.66480000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 4 ], "Tv", 0.00000000,0.00000000, 4.94670000, 0.00000000);
	}
	else if(!strcmp(Name,"Zr-Zirconium")){
		F.NAtoms =4;
		F.Atoms = g_malloc(F.NAtoms*sizeof(Atom));
		SetAtom(&F.Atoms[ 0 ], "Zr", 0.00000000,0.00000000, 0.00000000, 0.00000000);
		SetAtom(&F.Atoms[ 1 ], "Tv", -1.81000000,1.81000000, 1.81000000, 0.00000000);
		SetAtom(&F.Atoms[ 2 ], "Tv", 1.81000000,-1.81000000, 1.81000000, 0.00000000);
		SetAtom(&F.Atoms[ 3 ], "Tv", 1.81000000,1.81000000, -1.81000000, 0.00000000);
	}

	/*CenterFrag(&F);*/
	for(i=1;i<(gint)strlen(Name);i++) T[i-1] = toupper(Name[i]);
	if(strlen(Name)-1>0)
	{
		T[strlen(Name)-1] ='\0';
		SetResidue(&F,T);
	}
	else
		SetResidue(&F,"UNK");
	//SetMMTypes(&F);
	return F;

}
/*****************************************************************/
Fragment GetFragmentCrystal(gchar* Name)
{
	Fragment F = GetFragmentPrototypeCrystals(Name);
	if(F.NAtoms<1) F = GetFragmentElementCrystals(Name);
	return F;
}
