// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/aiplatform/v1beta1/persistent_resource.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Describes the PersistentResource state.
type PersistentResource_State int32

const (
	// Not set.
	PersistentResource_STATE_UNSPECIFIED PersistentResource_State = 0
	// The PROVISIONING state indicates the persistent resources is being
	// created.
	PersistentResource_PROVISIONING PersistentResource_State = 1
	// The RUNNING state indicates the persistent resource is healthy and fully
	// usable.
	PersistentResource_RUNNING PersistentResource_State = 3
	// The STOPPING state indicates the persistent resource is being deleted.
	PersistentResource_STOPPING PersistentResource_State = 4
	// The ERROR state indicates the persistent resource may be unusable.
	// Details can be found in the `error` field.
	PersistentResource_ERROR PersistentResource_State = 5
)

// Enum value maps for PersistentResource_State.
var (
	PersistentResource_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PROVISIONING",
		3: "RUNNING",
		4: "STOPPING",
		5: "ERROR",
	}
	PersistentResource_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PROVISIONING":      1,
		"RUNNING":           3,
		"STOPPING":          4,
		"ERROR":             5,
	}
)

func (x PersistentResource_State) Enum() *PersistentResource_State {
	p := new(PersistentResource_State)
	*p = x
	return p
}

func (x PersistentResource_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PersistentResource_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_enumTypes[0].Descriptor()
}

func (PersistentResource_State) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_enumTypes[0]
}

func (x PersistentResource_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PersistentResource_State.Descriptor instead.
func (PersistentResource_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescGZIP(), []int{0, 0}
}

// Represents long-lasting resources that are dedicated to users to runs custom
// workloads.
// A PersistentResource can have multiple node pools and each node
// pool can have its own machine spec.
type PersistentResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Resource name of a PersistentResource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The display name of the PersistentResource.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The spec of the pools of different resources.
	ResourcePools []*ResourcePool `protobuf:"bytes,4,rep,name=resource_pools,json=resourcePools,proto3" json:"resource_pools,omitempty"`
	// Output only. The detailed state of a Study.
	State PersistentResource_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.PersistentResource_State" json:"state,omitempty"`
	// Output only. Only populated when persistent resource's state is `STOPPING`
	// or `ERROR`.
	Error *status.Status `protobuf:"bytes,6,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Time when the PersistentResource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the PersistentResource for the first time entered
	// the `RUNNING` state.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time when the PersistentResource was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The labels with user-defined metadata to organize
	// PersistentResource.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The full name of the Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to peered with
	// Vertex AI to host the persistent resources.
	// For example, `projects/12345/global/networks/myVPC`.
	// [Format](/compute/docs/reference/rest/v1/networks/insert)
	// is of the form `projects/{project}/global/networks/{network}`.
	// Where {project} is a project number, as in `12345`, and {network} is a
	// network name.
	//
	// To specify this field, you must have already [configured VPC Network
	// Peering for Vertex
	// AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
	//
	// If this field is left unspecified, the resources aren't peered with any
	// network.
	Network string `protobuf:"bytes,11,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. Customer-managed encryption key spec for a PersistentResource.
	// If set, this PersistentResource and all sub-resources of this
	// PersistentResource will be secured by this key.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,12,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// Optional. Persistent Resource runtime spec.
	// For example, used for Ray cluster configuration.
	ResourceRuntimeSpec *ResourceRuntimeSpec `protobuf:"bytes,13,opt,name=resource_runtime_spec,json=resourceRuntimeSpec,proto3" json:"resource_runtime_spec,omitempty"`
	// Output only. Runtime information of the Persistent Resource.
	ResourceRuntime *ResourceRuntime `protobuf:"bytes,14,opt,name=resource_runtime,json=resourceRuntime,proto3" json:"resource_runtime,omitempty"`
	// Optional. A list of names for the reserved IP ranges under the VPC network
	// that can be used for this persistent resource.
	//
	// If set, we will deploy the persistent resource within the provided IP
	// ranges. Otherwise, the persistent resource is deployed to any IP
	// ranges under the provided VPC network.
	//
	// Example: ['vertex-ai-ip-range'].
	ReservedIpRanges []string `protobuf:"bytes,15,rep,name=reserved_ip_ranges,json=reservedIpRanges,proto3" json:"reserved_ip_ranges,omitempty"`
}

func (x *PersistentResource) Reset() {
	*x = PersistentResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PersistentResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersistentResource) ProtoMessage() {}

func (x *PersistentResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersistentResource.ProtoReflect.Descriptor instead.
func (*PersistentResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescGZIP(), []int{0}
}

func (x *PersistentResource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PersistentResource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PersistentResource) GetResourcePools() []*ResourcePool {
	if x != nil {
		return x.ResourcePools
	}
	return nil
}

func (x *PersistentResource) GetState() PersistentResource_State {
	if x != nil {
		return x.State
	}
	return PersistentResource_STATE_UNSPECIFIED
}

func (x *PersistentResource) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *PersistentResource) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PersistentResource) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *PersistentResource) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PersistentResource) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *PersistentResource) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *PersistentResource) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

func (x *PersistentResource) GetResourceRuntimeSpec() *ResourceRuntimeSpec {
	if x != nil {
		return x.ResourceRuntimeSpec
	}
	return nil
}

func (x *PersistentResource) GetResourceRuntime() *ResourceRuntime {
	if x != nil {
		return x.ResourceRuntime
	}
	return nil
}

func (x *PersistentResource) GetReservedIpRanges() []string {
	if x != nil {
		return x.ReservedIpRanges
	}
	return nil
}

// Represents the spec of a group of resources of the same type,
// for example machine type, disk, and accelerators, in a PersistentResource.
type ResourcePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The unique ID in a PersistentResource for referring to this
	// resource pool. User can specify it if necessary. Otherwise, it's generated
	// automatically.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Required. Immutable. The specification of a single machine.
	MachineSpec *MachineSpec `protobuf:"bytes,2,opt,name=machine_spec,json=machineSpec,proto3" json:"machine_spec,omitempty"`
	// Optional. The total number of machines to use for this resource pool.
	ReplicaCount *int64 `protobuf:"varint,3,opt,name=replica_count,json=replicaCount,proto3,oneof" json:"replica_count,omitempty"`
	// Optional. Disk spec for the machine in this node pool.
	DiskSpec *DiskSpec `protobuf:"bytes,4,opt,name=disk_spec,json=diskSpec,proto3" json:"disk_spec,omitempty"`
	// Output only. The number of machines currently in use by training jobs for
	// this resource pool. Will replace idle_replica_count.
	UsedReplicaCount int64 `protobuf:"varint,6,opt,name=used_replica_count,json=usedReplicaCount,proto3" json:"used_replica_count,omitempty"`
	// Optional. Optional spec to configure GKE autoscaling
	AutoscalingSpec *ResourcePool_AutoscalingSpec `protobuf:"bytes,7,opt,name=autoscaling_spec,json=autoscalingSpec,proto3" json:"autoscaling_spec,omitempty"`
}

func (x *ResourcePool) Reset() {
	*x = ResourcePool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePool) ProtoMessage() {}

func (x *ResourcePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePool.ProtoReflect.Descriptor instead.
func (*ResourcePool) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescGZIP(), []int{1}
}

func (x *ResourcePool) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ResourcePool) GetMachineSpec() *MachineSpec {
	if x != nil {
		return x.MachineSpec
	}
	return nil
}

func (x *ResourcePool) GetReplicaCount() int64 {
	if x != nil && x.ReplicaCount != nil {
		return *x.ReplicaCount
	}
	return 0
}

func (x *ResourcePool) GetDiskSpec() *DiskSpec {
	if x != nil {
		return x.DiskSpec
	}
	return nil
}

func (x *ResourcePool) GetUsedReplicaCount() int64 {
	if x != nil {
		return x.UsedReplicaCount
	}
	return 0
}

func (x *ResourcePool) GetAutoscalingSpec() *ResourcePool_AutoscalingSpec {
	if x != nil {
		return x.AutoscalingSpec
	}
	return nil
}

// Configuration for the runtime on a PersistentResource instance, including
// but not limited to:
//
// * Service accounts used to run the workloads.
// * Whether to make it a dedicated Ray Cluster.
type ResourceRuntimeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Configure the use of workload identity on the PersistentResource
	ServiceAccountSpec *ServiceAccountSpec `protobuf:"bytes,2,opt,name=service_account_spec,json=serviceAccountSpec,proto3" json:"service_account_spec,omitempty"`
	// Optional. Ray cluster configuration.
	// Required when creating a dedicated RayCluster on the PersistentResource.
	RaySpec *RaySpec `protobuf:"bytes,1,opt,name=ray_spec,json=raySpec,proto3" json:"ray_spec,omitempty"`
}

func (x *ResourceRuntimeSpec) Reset() {
	*x = ResourceRuntimeSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceRuntimeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceRuntimeSpec) ProtoMessage() {}

func (x *ResourceRuntimeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceRuntimeSpec.ProtoReflect.Descriptor instead.
func (*ResourceRuntimeSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescGZIP(), []int{2}
}

func (x *ResourceRuntimeSpec) GetServiceAccountSpec() *ServiceAccountSpec {
	if x != nil {
		return x.ServiceAccountSpec
	}
	return nil
}

func (x *ResourceRuntimeSpec) GetRaySpec() *RaySpec {
	if x != nil {
		return x.RaySpec
	}
	return nil
}

// Configuration information for the Ray cluster.
// For experimental launch, Ray cluster creation and Persistent
// cluster creation are 1:1 mapping: We will provision all the nodes within the
// Persistent cluster as Ray nodes.
type RaySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Default image for user to choose a preferred ML framework
	// (for example, TensorFlow or Pytorch) by choosing from [Vertex prebuilt
	// images](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
	// Either this or the resource_pool_images is required. Use this field if
	// you need all the resource pools to have the same Ray image. Otherwise, use
	// the {@code resource_pool_images} field.
	ImageUri string `protobuf:"bytes,1,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Optional. Required if image_uri isn't set. A map of resource_pool_id to
	// prebuild Ray image if user need to use different images for different
	// head/worker pools. This map needs to cover all the resource pool ids.
	// Example:
	//
	//	{
	//	  "ray_head_node_pool": "head image"
	//	  "ray_worker_node_pool1": "worker image"
	//	  "ray_worker_node_pool2": "another worker image"
	//	}
	ResourcePoolImages map[string]string `protobuf:"bytes,6,rep,name=resource_pool_images,json=resourcePoolImages,proto3" json:"resource_pool_images,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. This will be used to indicate which resource pool will serve as
	// the Ray head node(the first node within that pool). Will use the machine
	// from the first workerpool as the head node by default if this field isn't
	// set.
	HeadNodeResourcePoolId string `protobuf:"bytes,7,opt,name=head_node_resource_pool_id,json=headNodeResourcePoolId,proto3" json:"head_node_resource_pool_id,omitempty"`
	// Optional. Ray metrics configurations.
	RayMetricSpec *RayMetricSpec `protobuf:"bytes,8,opt,name=ray_metric_spec,json=rayMetricSpec,proto3" json:"ray_metric_spec,omitempty"`
}

func (x *RaySpec) Reset() {
	*x = RaySpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RaySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaySpec) ProtoMessage() {}

func (x *RaySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaySpec.ProtoReflect.Descriptor instead.
func (*RaySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescGZIP(), []int{3}
}

func (x *RaySpec) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

func (x *RaySpec) GetResourcePoolImages() map[string]string {
	if x != nil {
		return x.ResourcePoolImages
	}
	return nil
}

func (x *RaySpec) GetHeadNodeResourcePoolId() string {
	if x != nil {
		return x.HeadNodeResourcePoolId
	}
	return ""
}

func (x *RaySpec) GetRayMetricSpec() *RayMetricSpec {
	if x != nil {
		return x.RayMetricSpec
	}
	return nil
}

// Persistent Cluster runtime information as output
type ResourceRuntime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. URIs for user to connect to the Cluster.
	// Example:
	//
	//	{
	//	  "RAY_HEAD_NODE_INTERNAL_IP": "head-node-IP:10001"
	//	  "RAY_DASHBOARD_URI": "ray-dashboard-address:8888"
	//	}
	AccessUris map[string]string `protobuf:"bytes,1,rep,name=access_uris,json=accessUris,proto3" json:"access_uris,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ResourceRuntime) Reset() {
	*x = ResourceRuntime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceRuntime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceRuntime) ProtoMessage() {}

func (x *ResourceRuntime) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceRuntime.ProtoReflect.Descriptor instead.
func (*ResourceRuntime) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescGZIP(), []int{4}
}

func (x *ResourceRuntime) GetAccessUris() map[string]string {
	if x != nil {
		return x.AccessUris
	}
	return nil
}

// Configuration for the use of custom service account to run the workloads.
type ServiceAccountSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. If true, custom user-managed service account is enforced to run
	// any workloads (for example, Vertex Jobs) on the resource. Otherwise, uses
	// the [Vertex AI Custom Code Service
	// Agent](https://cloud.google.com/vertex-ai/docs/general/access-control#service-agents).
	EnableCustomServiceAccount bool `protobuf:"varint,1,opt,name=enable_custom_service_account,json=enableCustomServiceAccount,proto3" json:"enable_custom_service_account,omitempty"`
	// Optional. Default service account that this PersistentResource's workloads
	// run as. The workloads include:
	//
	//   - Any runtime specified via `ResourceRuntimeSpec` on creation time,
	//     for example, Ray.
	//   - Jobs submitted to PersistentResource, if no other service account
	//     specified in the job specs.
	//
	// Only works when custom service account is enabled and users have the
	// `iam.serviceAccounts.actAs` permission on this service account.
	//
	// Required if any containers are specified in `ResourceRuntimeSpec`.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *ServiceAccountSpec) Reset() {
	*x = ServiceAccountSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccountSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccountSpec) ProtoMessage() {}

func (x *ServiceAccountSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccountSpec.ProtoReflect.Descriptor instead.
func (*ServiceAccountSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescGZIP(), []int{5}
}

func (x *ServiceAccountSpec) GetEnableCustomServiceAccount() bool {
	if x != nil {
		return x.EnableCustomServiceAccount
	}
	return false
}

func (x *ServiceAccountSpec) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

// Configuration for the Ray metrics.
type RayMetricSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Flag to disable the Ray metrics collection.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *RayMetricSpec) Reset() {
	*x = RayMetricSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RayMetricSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RayMetricSpec) ProtoMessage() {}

func (x *RayMetricSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RayMetricSpec.ProtoReflect.Descriptor instead.
func (*RayMetricSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescGZIP(), []int{6}
}

func (x *RayMetricSpec) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// The min/max number of replicas allowed if enabling autoscaling
type ResourcePool_AutoscalingSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. min replicas in the node pool,
	// must be ≤ replica_count and < max_replica_count or will throw error
	MinReplicaCount *int64 `protobuf:"varint,1,opt,name=min_replica_count,json=minReplicaCount,proto3,oneof" json:"min_replica_count,omitempty"`
	// Optional. max replicas in the node pool,
	// must be ≥ replica_count and > min_replica_count or will throw error
	MaxReplicaCount *int64 `protobuf:"varint,2,opt,name=max_replica_count,json=maxReplicaCount,proto3,oneof" json:"max_replica_count,omitempty"`
}

func (x *ResourcePool_AutoscalingSpec) Reset() {
	*x = ResourcePool_AutoscalingSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourcePool_AutoscalingSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourcePool_AutoscalingSpec) ProtoMessage() {}

func (x *ResourcePool_AutoscalingSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourcePool_AutoscalingSpec.ProtoReflect.Descriptor instead.
func (*ResourcePool_AutoscalingSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ResourcePool_AutoscalingSpec) GetMinReplicaCount() int64 {
	if x != nil && x.MinReplicaCount != nil {
		return *x.MinReplicaCount
	}
	return 0
}

func (x *ResourcePool_AutoscalingSpec) GetMaxReplicaCount() int64 {
	if x != nil && x.MaxReplicaCount != nil {
		return *x.MaxReplicaCount
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_persistent_resource_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x97, 0x0a, 0x0a, 0x12, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x0e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x54, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5c,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5d,
	0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6d, 0x0a,
	0x15, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x60, 0x0a, 0x10,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x31,
	0x0a, 0x12, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x10, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x56, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c,
	0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x53,
	0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x10, 0x05, 0x3a, 0x85, 0x01, 0xea, 0x41, 0x81, 0x01, 0x0a, 0x2c, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x22, 0xd8, 0x04, 0x0a,
	0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x13, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x57, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0b,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2d, 0x0a, 0x0d, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x09, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64,
	0x69, 0x73, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x12, 0x31, 0x0a, 0x12, 0x75, 0x73, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x75, 0x73, 0x65, 0x64, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x6d, 0x0a, 0x10, 0x61, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53,
	0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x1a, 0xa9, 0x01, 0x0a, 0x0f, 0x41, 0x75,
	0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x34, 0x0a,
	0x11, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x0f, 0x6d, 0x69, 0x6e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x69,
	0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42,
	0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xcb, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x6a, 0x0a, 0x14, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x70,
	0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x48, 0x0a, 0x08, 0x72,
	0x61, 0x79, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x61, 0x79, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x72, 0x61,
	0x79, 0x53, 0x70, 0x65, 0x63, 0x22, 0x89, 0x03, 0x0a, 0x07, 0x52, 0x61, 0x79, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x55, 0x72, 0x69, 0x12, 0x77, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x79, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x1a,
	0x68, 0x65, 0x61, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x68, 0x65, 0x61, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12, 0x5b, 0x0a,
	0x0f, 0x72, 0x61, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x79, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x72, 0x61, 0x79,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x1a, 0x45, 0x0a, 0x17, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xb8, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x66, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x75, 0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x55, 0x72, 0x69, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x69, 0x73, 0x1a, 0x3d, 0x0a,
	0x0f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x55, 0x72, 0x69, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x8a, 0x01, 0x0a,
	0x12, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x46, 0x0a, 0x1d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x1a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x0f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x30, 0x0a, 0x0d, 0x52, 0x61, 0x79,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x42, 0xee, 0x01, 0x0a, 0x23,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x42, 0x17, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31,
	0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c,
	0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_goTypes = []interface{}{
	(PersistentResource_State)(0),        // 0: google.cloud.aiplatform.v1beta1.PersistentResource.State
	(*PersistentResource)(nil),           // 1: google.cloud.aiplatform.v1beta1.PersistentResource
	(*ResourcePool)(nil),                 // 2: google.cloud.aiplatform.v1beta1.ResourcePool
	(*ResourceRuntimeSpec)(nil),          // 3: google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec
	(*RaySpec)(nil),                      // 4: google.cloud.aiplatform.v1beta1.RaySpec
	(*ResourceRuntime)(nil),              // 5: google.cloud.aiplatform.v1beta1.ResourceRuntime
	(*ServiceAccountSpec)(nil),           // 6: google.cloud.aiplatform.v1beta1.ServiceAccountSpec
	(*RayMetricSpec)(nil),                // 7: google.cloud.aiplatform.v1beta1.RayMetricSpec
	nil,                                  // 8: google.cloud.aiplatform.v1beta1.PersistentResource.LabelsEntry
	(*ResourcePool_AutoscalingSpec)(nil), // 9: google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
	nil,                                  // 10: google.cloud.aiplatform.v1beta1.RaySpec.ResourcePoolImagesEntry
	nil,                                  // 11: google.cloud.aiplatform.v1beta1.ResourceRuntime.AccessUrisEntry
	(*status.Status)(nil),                // 12: google.rpc.Status
	(*timestamppb.Timestamp)(nil),        // 13: google.protobuf.Timestamp
	(*EncryptionSpec)(nil),               // 14: google.cloud.aiplatform.v1beta1.EncryptionSpec
	(*MachineSpec)(nil),                  // 15: google.cloud.aiplatform.v1beta1.MachineSpec
	(*DiskSpec)(nil),                     // 16: google.cloud.aiplatform.v1beta1.DiskSpec
}
var file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_depIdxs = []int32{
	2,  // 0: google.cloud.aiplatform.v1beta1.PersistentResource.resource_pools:type_name -> google.cloud.aiplatform.v1beta1.ResourcePool
	0,  // 1: google.cloud.aiplatform.v1beta1.PersistentResource.state:type_name -> google.cloud.aiplatform.v1beta1.PersistentResource.State
	12, // 2: google.cloud.aiplatform.v1beta1.PersistentResource.error:type_name -> google.rpc.Status
	13, // 3: google.cloud.aiplatform.v1beta1.PersistentResource.create_time:type_name -> google.protobuf.Timestamp
	13, // 4: google.cloud.aiplatform.v1beta1.PersistentResource.start_time:type_name -> google.protobuf.Timestamp
	13, // 5: google.cloud.aiplatform.v1beta1.PersistentResource.update_time:type_name -> google.protobuf.Timestamp
	8,  // 6: google.cloud.aiplatform.v1beta1.PersistentResource.labels:type_name -> google.cloud.aiplatform.v1beta1.PersistentResource.LabelsEntry
	14, // 7: google.cloud.aiplatform.v1beta1.PersistentResource.encryption_spec:type_name -> google.cloud.aiplatform.v1beta1.EncryptionSpec
	3,  // 8: google.cloud.aiplatform.v1beta1.PersistentResource.resource_runtime_spec:type_name -> google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec
	5,  // 9: google.cloud.aiplatform.v1beta1.PersistentResource.resource_runtime:type_name -> google.cloud.aiplatform.v1beta1.ResourceRuntime
	15, // 10: google.cloud.aiplatform.v1beta1.ResourcePool.machine_spec:type_name -> google.cloud.aiplatform.v1beta1.MachineSpec
	16, // 11: google.cloud.aiplatform.v1beta1.ResourcePool.disk_spec:type_name -> google.cloud.aiplatform.v1beta1.DiskSpec
	9,  // 12: google.cloud.aiplatform.v1beta1.ResourcePool.autoscaling_spec:type_name -> google.cloud.aiplatform.v1beta1.ResourcePool.AutoscalingSpec
	6,  // 13: google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.service_account_spec:type_name -> google.cloud.aiplatform.v1beta1.ServiceAccountSpec
	4,  // 14: google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.ray_spec:type_name -> google.cloud.aiplatform.v1beta1.RaySpec
	10, // 15: google.cloud.aiplatform.v1beta1.RaySpec.resource_pool_images:type_name -> google.cloud.aiplatform.v1beta1.RaySpec.ResourcePoolImagesEntry
	7,  // 16: google.cloud.aiplatform.v1beta1.RaySpec.ray_metric_spec:type_name -> google.cloud.aiplatform.v1beta1.RayMetricSpec
	11, // 17: google.cloud.aiplatform.v1beta1.ResourceRuntime.access_uris:type_name -> google.cloud.aiplatform.v1beta1.ResourceRuntime.AccessUrisEntry
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_init() }
func file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_persistent_resource_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_machine_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PersistentResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcePool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceRuntimeSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RaySpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceRuntime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccountSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RayMetricSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourcePool_AutoscalingSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes[8].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_persistent_resource_proto = out.File
	file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_persistent_resource_proto_depIdxs = nil
}
