// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/dialogflow/cx/v3beta1/intent.proto

package cxpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the options for views of an intent.
// An intent can be a sizable object. Therefore, we provide a resource view that
// does not return training phrases in the response.
type IntentView int32

const (
	// Not specified. Treated as INTENT_VIEW_FULL.
	IntentView_INTENT_VIEW_UNSPECIFIED IntentView = 0
	// Training phrases field is not populated in the response.
	IntentView_INTENT_VIEW_PARTIAL IntentView = 1
	// All fields are populated.
	IntentView_INTENT_VIEW_FULL IntentView = 2
)

// Enum value maps for IntentView.
var (
	IntentView_name = map[int32]string{
		0: "INTENT_VIEW_UNSPECIFIED",
		1: "INTENT_VIEW_PARTIAL",
		2: "INTENT_VIEW_FULL",
	}
	IntentView_value = map[string]int32{
		"INTENT_VIEW_UNSPECIFIED": 0,
		"INTENT_VIEW_PARTIAL":     1,
		"INTENT_VIEW_FULL":        2,
	}
)

func (x IntentView) Enum() *IntentView {
	p := new(IntentView)
	*p = x
	return p
}

func (x IntentView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IntentView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_enumTypes[0].Descriptor()
}

func (IntentView) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_enumTypes[0]
}

func (x IntentView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IntentView.Descriptor instead.
func (IntentView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{0}
}

// Merge option when display name conflicts exist during import.
type ImportIntentsRequest_MergeOption int32

const (
	// Unspecified. Should not be used.
	ImportIntentsRequest_MERGE_OPTION_UNSPECIFIED ImportIntentsRequest_MergeOption = 0
	// DEPRECATED: Please use
	// [REPORT_CONFLICT][ImportIntentsRequest.REPORT_CONFLICT] instead.
	// Fail the request if there are intents whose display names conflict with
	// the display names of intents in the agent.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/intent.proto.
	ImportIntentsRequest_REJECT ImportIntentsRequest_MergeOption = 1
	// Replace the original intent in the agent with the new intent when display
	// name conflicts exist.
	ImportIntentsRequest_REPLACE ImportIntentsRequest_MergeOption = 2
	// Merge the original intent with the new intent when display name conflicts
	// exist.
	ImportIntentsRequest_MERGE ImportIntentsRequest_MergeOption = 3
	// Create new intents with new display names to differentiate them from the
	// existing intents when display name conflicts exist.
	ImportIntentsRequest_RENAME ImportIntentsRequest_MergeOption = 4
	// Report conflict information if display names conflict is detected.
	// Otherwise, import intents.
	ImportIntentsRequest_REPORT_CONFLICT ImportIntentsRequest_MergeOption = 5
	// Keep the original intent and discard the conflicting new intent when
	// display name conflicts exist.
	ImportIntentsRequest_KEEP ImportIntentsRequest_MergeOption = 6
)

// Enum value maps for ImportIntentsRequest_MergeOption.
var (
	ImportIntentsRequest_MergeOption_name = map[int32]string{
		0: "MERGE_OPTION_UNSPECIFIED",
		1: "REJECT",
		2: "REPLACE",
		3: "MERGE",
		4: "RENAME",
		5: "REPORT_CONFLICT",
		6: "KEEP",
	}
	ImportIntentsRequest_MergeOption_value = map[string]int32{
		"MERGE_OPTION_UNSPECIFIED": 0,
		"REJECT":                   1,
		"REPLACE":                  2,
		"MERGE":                    3,
		"RENAME":                   4,
		"REPORT_CONFLICT":          5,
		"KEEP":                     6,
	}
)

func (x ImportIntentsRequest_MergeOption) Enum() *ImportIntentsRequest_MergeOption {
	p := new(ImportIntentsRequest_MergeOption)
	*p = x
	return p
}

func (x ImportIntentsRequest_MergeOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportIntentsRequest_MergeOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_enumTypes[1].Descriptor()
}

func (ImportIntentsRequest_MergeOption) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_enumTypes[1]
}

func (x ImportIntentsRequest_MergeOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportIntentsRequest_MergeOption.Descriptor instead.
func (ImportIntentsRequest_MergeOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{7, 0}
}

// Data format of the exported intents.
type ExportIntentsRequest_DataFormat int32

const (
	// Unspecified format. Treated as `BLOB`.
	ExportIntentsRequest_DATA_FORMAT_UNSPECIFIED ExportIntentsRequest_DataFormat = 0
	// Intents will be exported as raw bytes.
	ExportIntentsRequest_BLOB ExportIntentsRequest_DataFormat = 1
	// Intents will be exported in JSON format.
	ExportIntentsRequest_JSON ExportIntentsRequest_DataFormat = 2
	// Intents will be exported in CSV format.
	ExportIntentsRequest_CSV ExportIntentsRequest_DataFormat = 3
)

// Enum value maps for ExportIntentsRequest_DataFormat.
var (
	ExportIntentsRequest_DataFormat_name = map[int32]string{
		0: "DATA_FORMAT_UNSPECIFIED",
		1: "BLOB",
		2: "JSON",
		3: "CSV",
	}
	ExportIntentsRequest_DataFormat_value = map[string]int32{
		"DATA_FORMAT_UNSPECIFIED": 0,
		"BLOB":                    1,
		"JSON":                    2,
		"CSV":                     3,
	}
)

func (x ExportIntentsRequest_DataFormat) Enum() *ExportIntentsRequest_DataFormat {
	p := new(ExportIntentsRequest_DataFormat)
	*p = x
	return p
}

func (x ExportIntentsRequest_DataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExportIntentsRequest_DataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_enumTypes[2].Descriptor()
}

func (ExportIntentsRequest_DataFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_enumTypes[2]
}

func (x ExportIntentsRequest_DataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExportIntentsRequest_DataFormat.Descriptor instead.
func (ExportIntentsRequest_DataFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{10, 0}
}

// An intent represents a user's intent to interact with a conversational agent.
//
// You can provide information for the Dialogflow API to use to match user input
// to an intent by adding training phrases (i.e., examples of user input) to
// your intent.
type Intent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the intent.
	// Required for the
	// [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent]
	// method.
	// [Intents.CreateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent]
	// populates the name automatically.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the intent, unique within the agent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The collection of training phrases the agent is trained on to identify the
	// intent.
	TrainingPhrases []*Intent_TrainingPhrase `protobuf:"bytes,3,rep,name=training_phrases,json=trainingPhrases,proto3" json:"training_phrases,omitempty"`
	// The collection of parameters associated with the intent.
	Parameters []*Intent_Parameter `protobuf:"bytes,4,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// The priority of this intent. Higher numbers represent higher
	// priorities.
	//
	//   - If the supplied value is unspecified or 0, the service
	//     translates the value to 500,000, which corresponds to the
	//     `Normal` priority in the console.
	//   - If the supplied value is negative, the intent is ignored
	//     in runtime detect intent requests.
	Priority int32 `protobuf:"varint,5,opt,name=priority,proto3" json:"priority,omitempty"`
	// Indicates whether this is a fallback intent. Currently only default
	// fallback intent is allowed in the agent, which is added upon agent
	// creation.
	// Adding training phrases to fallback intent is useful in the case of
	// requests that are mistakenly matched, since training phrases assigned to
	// fallback intents act as negative examples that triggers no-match event.
	IsFallback bool `protobuf:"varint,6,opt,name=is_fallback,json=isFallback,proto3" json:"is_fallback,omitempty"`
	// The key/value metadata to label an intent. Labels can contain
	// lowercase letters, digits and the symbols '-' and '_'. International
	// characters are allowed, including letters from unicase alphabets. Keys must
	// start with a letter. Keys and values can be no longer than 63 characters
	// and no more than 128 bytes.
	//
	// Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed
	// Dialogflow defined labels include:
	// * sys-head
	// * sys-contextual
	// The above labels do not require value. "sys-head" means the intent is a
	// head intent. "sys-contextual" means the intent is a contextual intent.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Human readable description for better understanding an intent like its
	// scope, content, result etc. Maximum character limit: 140 characters.
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Intent) Reset() {
	*x = Intent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent) ProtoMessage() {}

func (x *Intent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent.ProtoReflect.Descriptor instead.
func (*Intent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{0}
}

func (x *Intent) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Intent) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Intent) GetTrainingPhrases() []*Intent_TrainingPhrase {
	if x != nil {
		return x.TrainingPhrases
	}
	return nil
}

func (x *Intent) GetParameters() []*Intent_Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Intent) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

func (x *Intent) GetIsFallback() bool {
	if x != nil {
		return x.IsFallback
	}
	return false
}

func (x *Intent) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Intent) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// The request message for
// [Intents.ListIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ListIntents].
type ListIntentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list all intents for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The language to list intents for. The following fields are language
	// dependent:
	//
	// *   `Intent.training_phrases.parts.text`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,5,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.cx.v3beta1.IntentView" json:"intent_view,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListIntentsRequest) Reset() {
	*x = ListIntentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIntentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIntentsRequest) ProtoMessage() {}

func (x *ListIntentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIntentsRequest.ProtoReflect.Descriptor instead.
func (*ListIntentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{1}
}

func (x *ListIntentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListIntentsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListIntentsRequest) GetIntentView() IntentView {
	if x != nil {
		return x.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

func (x *ListIntentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListIntentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Intents.ListIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ListIntents].
type ListIntentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of intents. There will be a maximum number of items returned based
	// on the page_size field in the request.
	Intents []*Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListIntentsResponse) Reset() {
	*x = ListIntentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIntentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIntentsResponse) ProtoMessage() {}

func (x *ListIntentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIntentsResponse.ProtoReflect.Descriptor instead.
func (*ListIntentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{2}
}

func (x *ListIntentsResponse) GetIntents() []*Intent {
	if x != nil {
		return x.Intents
	}
	return nil
}

func (x *ListIntentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Intents.GetIntent][google.cloud.dialogflow.cx.v3beta1.Intents.GetIntent].
type GetIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the intent.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The language to retrieve the intent for. The following fields are language
	// dependent:
	//
	// *   `Intent.training_phrases.parts.text`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *GetIntentRequest) Reset() {
	*x = GetIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIntentRequest) ProtoMessage() {}

func (x *GetIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIntentRequest.ProtoReflect.Descriptor instead.
func (*GetIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{3}
}

func (x *GetIntentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetIntentRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for
// [Intents.CreateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent].
type CreateIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create an intent for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The intent to create.
	Intent *Intent `protobuf:"bytes,2,opt,name=intent,proto3" json:"intent,omitempty"`
	// The language of the following fields in `intent`:
	//
	// *   `Intent.training_phrases.parts.text`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *CreateIntentRequest) Reset() {
	*x = CreateIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIntentRequest) ProtoMessage() {}

func (x *CreateIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIntentRequest.ProtoReflect.Descriptor instead.
func (*CreateIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{4}
}

func (x *CreateIntentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateIntentRequest) GetIntent() *Intent {
	if x != nil {
		return x.Intent
	}
	return nil
}

func (x *CreateIntentRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The request message for
// [Intents.UpdateIntent][google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent].
type UpdateIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The intent to update.
	Intent *Intent `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	// The language of the following fields in `intent`:
	//
	// *   `Intent.training_phrases.parts.text`
	//
	// If not specified, the agent's default language is used.
	// [Many
	// languages](https://cloud.google.com/dialogflow/cx/docs/reference/language)
	// are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The mask to control which fields get updated. If the mask is not present,
	// all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateIntentRequest) Reset() {
	*x = UpdateIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateIntentRequest) ProtoMessage() {}

func (x *UpdateIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateIntentRequest.ProtoReflect.Descriptor instead.
func (*UpdateIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateIntentRequest) GetIntent() *Intent {
	if x != nil {
		return x.Intent
	}
	return nil
}

func (x *UpdateIntentRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *UpdateIntentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for
// [Intents.DeleteIntent][google.cloud.dialogflow.cx.v3beta1.Intents.DeleteIntent].
type DeleteIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the intent to delete.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIntentRequest) Reset() {
	*x = DeleteIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIntentRequest) ProtoMessage() {}

func (x *DeleteIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIntentRequest.ProtoReflect.Descriptor instead.
func (*DeleteIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteIntentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Intents.ImportIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ImportIntents].
type ImportIntentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to import the intents into.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The intents to import.
	//
	// Types that are assignable to Intents:
	//
	//	*ImportIntentsRequest_IntentsUri
	//	*ImportIntentsRequest_IntentsContent
	Intents isImportIntentsRequest_Intents `protobuf_oneof:"intents"`
	// Merge option for importing intents. If not specified, `REJECT` is assumed.
	MergeOption ImportIntentsRequest_MergeOption `protobuf:"varint,4,opt,name=merge_option,json=mergeOption,proto3,enum=google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest_MergeOption" json:"merge_option,omitempty"`
}

func (x *ImportIntentsRequest) Reset() {
	*x = ImportIntentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportIntentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportIntentsRequest) ProtoMessage() {}

func (x *ImportIntentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportIntentsRequest.ProtoReflect.Descriptor instead.
func (*ImportIntentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{7}
}

func (x *ImportIntentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *ImportIntentsRequest) GetIntents() isImportIntentsRequest_Intents {
	if m != nil {
		return m.Intents
	}
	return nil
}

func (x *ImportIntentsRequest) GetIntentsUri() string {
	if x, ok := x.GetIntents().(*ImportIntentsRequest_IntentsUri); ok {
		return x.IntentsUri
	}
	return ""
}

func (x *ImportIntentsRequest) GetIntentsContent() *InlineSource {
	if x, ok := x.GetIntents().(*ImportIntentsRequest_IntentsContent); ok {
		return x.IntentsContent
	}
	return nil
}

func (x *ImportIntentsRequest) GetMergeOption() ImportIntentsRequest_MergeOption {
	if x != nil {
		return x.MergeOption
	}
	return ImportIntentsRequest_MERGE_OPTION_UNSPECIFIED
}

type isImportIntentsRequest_Intents interface {
	isImportIntentsRequest_Intents()
}

type ImportIntentsRequest_IntentsUri struct {
	// The [Google Cloud Storage](https://cloud.google.com/storage/docs/) URI
	// to import intents from. The format of this URI must be
	// `gs://<bucket-name>/<object-name>`.
	//
	// Dialogflow performs a read operation for the Cloud Storage object
	// on the caller's behalf, so your request authentication must
	// have read permissions for the object. For more information, see
	// [Dialogflow access
	// control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	IntentsUri string `protobuf:"bytes,2,opt,name=intents_uri,json=intentsUri,proto3,oneof"`
}

type ImportIntentsRequest_IntentsContent struct {
	// Uncompressed byte content of intents.
	IntentsContent *InlineSource `protobuf:"bytes,3,opt,name=intents_content,json=intentsContent,proto3,oneof"`
}

func (*ImportIntentsRequest_IntentsUri) isImportIntentsRequest_Intents() {}

func (*ImportIntentsRequest_IntentsContent) isImportIntentsRequest_Intents() {}

// The response message for
// [Intents.ImportIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ImportIntents].
type ImportIntentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the imported intents.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/intents/<Intent ID>`.
	Intents []string `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
	// Info which resources have conflicts when
	// [REPORT_CONFLICT][ImportIntentsResponse.REPORT_CONFLICT] merge_option is
	// set in ImportIntentsRequest.
	ConflictingResources *ImportIntentsResponse_ConflictingResources `protobuf:"bytes,2,opt,name=conflicting_resources,json=conflictingResources,proto3" json:"conflicting_resources,omitempty"`
}

func (x *ImportIntentsResponse) Reset() {
	*x = ImportIntentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportIntentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportIntentsResponse) ProtoMessage() {}

func (x *ImportIntentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportIntentsResponse.ProtoReflect.Descriptor instead.
func (*ImportIntentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{8}
}

func (x *ImportIntentsResponse) GetIntents() []string {
	if x != nil {
		return x.Intents
	}
	return nil
}

func (x *ImportIntentsResponse) GetConflictingResources() *ImportIntentsResponse_ConflictingResources {
	if x != nil {
		return x.ConflictingResources
	}
	return nil
}

// Metadata returned for the
// [Intents.ImportIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ImportIntents]
// long running operation.
type ImportIntentsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportIntentsMetadata) Reset() {
	*x = ImportIntentsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportIntentsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportIntentsMetadata) ProtoMessage() {}

func (x *ImportIntentsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportIntentsMetadata.ProtoReflect.Descriptor instead.
func (*ImportIntentsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{9}
}

// The request message for
// [Intents.ExportIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ExportIntents].
type ExportIntentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent agent to export intents.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of the intents to export.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/intents/<Intent ID>`.
	Intents []string `protobuf:"bytes,2,rep,name=intents,proto3" json:"intents,omitempty"`
	// The destination to export.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportIntentsRequest_IntentsUri
	//	*ExportIntentsRequest_IntentsContentInline
	Destination isExportIntentsRequest_Destination `protobuf_oneof:"destination"`
	// Optional. The data format of the exported intents. If not specified, `BLOB`
	// is assumed.
	DataFormat ExportIntentsRequest_DataFormat `protobuf:"varint,5,opt,name=data_format,json=dataFormat,proto3,enum=google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest_DataFormat" json:"data_format,omitempty"`
}

func (x *ExportIntentsRequest) Reset() {
	*x = ExportIntentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportIntentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportIntentsRequest) ProtoMessage() {}

func (x *ExportIntentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportIntentsRequest.ProtoReflect.Descriptor instead.
func (*ExportIntentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{10}
}

func (x *ExportIntentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportIntentsRequest) GetIntents() []string {
	if x != nil {
		return x.Intents
	}
	return nil
}

func (m *ExportIntentsRequest) GetDestination() isExportIntentsRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportIntentsRequest) GetIntentsUri() string {
	if x, ok := x.GetDestination().(*ExportIntentsRequest_IntentsUri); ok {
		return x.IntentsUri
	}
	return ""
}

func (x *ExportIntentsRequest) GetIntentsContentInline() bool {
	if x, ok := x.GetDestination().(*ExportIntentsRequest_IntentsContentInline); ok {
		return x.IntentsContentInline
	}
	return false
}

func (x *ExportIntentsRequest) GetDataFormat() ExportIntentsRequest_DataFormat {
	if x != nil {
		return x.DataFormat
	}
	return ExportIntentsRequest_DATA_FORMAT_UNSPECIFIED
}

type isExportIntentsRequest_Destination interface {
	isExportIntentsRequest_Destination()
}

type ExportIntentsRequest_IntentsUri struct {
	// Optional. The [Google Cloud
	// Storage](https://cloud.google.com/storage/docs/) URI to export the
	// intents to. The format of this URI must be
	// `gs://<bucket-name>/<object-name>`.
	//
	// Dialogflow performs a write operation for the Cloud Storage object
	// on the caller's behalf, so your request authentication must
	// have write permissions for the object. For more information, see
	// [Dialogflow access
	// control](https://cloud.google.com/dialogflow/cx/docs/concept/access-control#storage).
	IntentsUri string `protobuf:"bytes,3,opt,name=intents_uri,json=intentsUri,proto3,oneof"`
}

type ExportIntentsRequest_IntentsContentInline struct {
	// Optional. The option to return the serialized intents inline.
	IntentsContentInline bool `protobuf:"varint,4,opt,name=intents_content_inline,json=intentsContentInline,proto3,oneof"`
}

func (*ExportIntentsRequest_IntentsUri) isExportIntentsRequest_Destination() {}

func (*ExportIntentsRequest_IntentsContentInline) isExportIntentsRequest_Destination() {}

// The response message for
// [Intents.ExportIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ExportIntents].
type ExportIntentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exported intents.
	//
	// Types that are assignable to Intents:
	//
	//	*ExportIntentsResponse_IntentsUri
	//	*ExportIntentsResponse_IntentsContent
	Intents isExportIntentsResponse_Intents `protobuf_oneof:"intents"`
}

func (x *ExportIntentsResponse) Reset() {
	*x = ExportIntentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportIntentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportIntentsResponse) ProtoMessage() {}

func (x *ExportIntentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportIntentsResponse.ProtoReflect.Descriptor instead.
func (*ExportIntentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{11}
}

func (m *ExportIntentsResponse) GetIntents() isExportIntentsResponse_Intents {
	if m != nil {
		return m.Intents
	}
	return nil
}

func (x *ExportIntentsResponse) GetIntentsUri() string {
	if x, ok := x.GetIntents().(*ExportIntentsResponse_IntentsUri); ok {
		return x.IntentsUri
	}
	return ""
}

func (x *ExportIntentsResponse) GetIntentsContent() *InlineDestination {
	if x, ok := x.GetIntents().(*ExportIntentsResponse_IntentsContent); ok {
		return x.IntentsContent
	}
	return nil
}

type isExportIntentsResponse_Intents interface {
	isExportIntentsResponse_Intents()
}

type ExportIntentsResponse_IntentsUri struct {
	// The URI to a file containing the exported intents. This field is
	// populated only if `intents_uri` is specified in
	// [ExportIntentsRequest][google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest].
	IntentsUri string `protobuf:"bytes,1,opt,name=intents_uri,json=intentsUri,proto3,oneof"`
}

type ExportIntentsResponse_IntentsContent struct {
	// Uncompressed byte content for intents. This field is populated only if
	// `intents_content_inline` is set to true in
	// [ExportIntentsRequest][google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest].
	IntentsContent *InlineDestination `protobuf:"bytes,2,opt,name=intents_content,json=intentsContent,proto3,oneof"`
}

func (*ExportIntentsResponse_IntentsUri) isExportIntentsResponse_Intents() {}

func (*ExportIntentsResponse_IntentsContent) isExportIntentsResponse_Intents() {}

// Metadata returned for the
// [Intents.ExportIntents][google.cloud.dialogflow.cx.v3beta1.Intents.ExportIntents]
// long running operation.
type ExportIntentsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportIntentsMetadata) Reset() {
	*x = ExportIntentsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportIntentsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportIntentsMetadata) ProtoMessage() {}

func (x *ExportIntentsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportIntentsMetadata.ProtoReflect.Descriptor instead.
func (*ExportIntentsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{12}
}

// Represents an example that the agent is trained on to identify the intent.
type Intent_TrainingPhrase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of the training phrase.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Required. The ordered list of training phrase parts.
	// The parts are concatenated in order to form the training phrase.
	//
	// Note: The API does not automatically annotate training phrases like the
	// Dialogflow Console does.
	//
	// Note: Do not forget to include whitespace at part boundaries, so the
	// training phrase is well formatted when the parts are concatenated.
	//
	// If the training phrase does not need to be annotated with parameters,
	// you just need a single part with only the
	// [Part.text][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part.text]
	// field set.
	//
	// If you want to annotate the training phrase, you must create multiple
	// parts, where the fields of each part are populated in one of two ways:
	//
	//   - `Part.text` is set to a part of the phrase that has no parameters.
	//   - `Part.text` is set to a part of the phrase that you want to annotate,
	//     and the `parameter_id` field is set.
	Parts []*Intent_TrainingPhrase_Part `protobuf:"bytes,2,rep,name=parts,proto3" json:"parts,omitempty"`
	// Indicates how many times this example was added to the intent.
	RepeatCount int32 `protobuf:"varint,3,opt,name=repeat_count,json=repeatCount,proto3" json:"repeat_count,omitempty"`
}

func (x *Intent_TrainingPhrase) Reset() {
	*x = Intent_TrainingPhrase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_TrainingPhrase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_TrainingPhrase) ProtoMessage() {}

func (x *Intent_TrainingPhrase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_TrainingPhrase.ProtoReflect.Descriptor instead.
func (*Intent_TrainingPhrase) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Intent_TrainingPhrase) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Intent_TrainingPhrase) GetParts() []*Intent_TrainingPhrase_Part {
	if x != nil {
		return x.Parts
	}
	return nil
}

func (x *Intent_TrainingPhrase) GetRepeatCount() int32 {
	if x != nil {
		return x.RepeatCount
	}
	return 0
}

// Represents an intent parameter.
type Intent_Parameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the parameter. This field
	// is used by [training
	// phrases][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase] to
	// annotate their
	// [parts][google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part].
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Required. The entity type of the parameter.
	// Format: `projects/-/locations/-/agents/-/entityTypes/<System Entity Type
	// ID>` for system entity types (for example,
	// `projects/-/locations/-/agents/-/entityTypes/sys.date`), or
	// `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/entityTypes/<Entity Type ID>` for developer entity types.
	EntityType string `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Indicates whether the parameter represents a list of values.
	IsList bool `protobuf:"varint,3,opt,name=is_list,json=isList,proto3" json:"is_list,omitempty"`
	// Indicates whether the parameter content should be redacted in log. If
	// redaction is enabled, the parameter content will be replaced by parameter
	// name during logging.
	// Note: the parameter content is subject to redaction if either parameter
	// level redaction or [entity type level
	// redaction][google.cloud.dialogflow.cx.v3beta1.EntityType.redact] is
	// enabled.
	Redact bool `protobuf:"varint,4,opt,name=redact,proto3" json:"redact,omitempty"`
}

func (x *Intent_Parameter) Reset() {
	*x = Intent_Parameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_Parameter) ProtoMessage() {}

func (x *Intent_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_Parameter.ProtoReflect.Descriptor instead.
func (*Intent_Parameter) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Intent_Parameter) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Intent_Parameter) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *Intent_Parameter) GetIsList() bool {
	if x != nil {
		return x.IsList
	}
	return false
}

func (x *Intent_Parameter) GetRedact() bool {
	if x != nil {
		return x.Redact
	}
	return false
}

// Represents a part of a training phrase.
type Intent_TrainingPhrase_Part struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The text for this part.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The [parameter][google.cloud.dialogflow.cx.v3beta1.Intent.Parameter]
	// used to annotate this part of the training phrase. This field is
	// required for annotated parts of the training phrase.
	ParameterId string `protobuf:"bytes,2,opt,name=parameter_id,json=parameterId,proto3" json:"parameter_id,omitempty"`
}

func (x *Intent_TrainingPhrase_Part) Reset() {
	*x = Intent_TrainingPhrase_Part{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Intent_TrainingPhrase_Part) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Intent_TrainingPhrase_Part) ProtoMessage() {}

func (x *Intent_TrainingPhrase_Part) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Intent_TrainingPhrase_Part.ProtoReflect.Descriptor instead.
func (*Intent_TrainingPhrase_Part) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Intent_TrainingPhrase_Part) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *Intent_TrainingPhrase_Part) GetParameterId() string {
	if x != nil {
		return x.ParameterId
	}
	return ""
}

// Conflicting resources detected during the import process. Only filled when
// [REPORT_CONFLICT][ImportIntentsResponse.REPORT_CONFLICT] is set in the
// request and there are conflicts in the display names.
type ImportIntentsResponse_ConflictingResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display names of conflicting intents.
	IntentDisplayNames []string `protobuf:"bytes,1,rep,name=intent_display_names,json=intentDisplayNames,proto3" json:"intent_display_names,omitempty"`
	// Display names of conflicting entities.
	EntityDisplayNames []string `protobuf:"bytes,2,rep,name=entity_display_names,json=entityDisplayNames,proto3" json:"entity_display_names,omitempty"`
}

func (x *ImportIntentsResponse_ConflictingResources) Reset() {
	*x = ImportIntentsResponse_ConflictingResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportIntentsResponse_ConflictingResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportIntentsResponse_ConflictingResources) ProtoMessage() {}

func (x *ImportIntentsResponse_ConflictingResources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportIntentsResponse_ConflictingResources.ProtoReflect.Descriptor instead.
func (*ImportIntentsResponse_ConflictingResources) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP(), []int{8, 0}
}

func (x *ImportIntentsResponse_ConflictingResources) GetIntentDisplayNames() []string {
	if x != nil {
		return x.IntentDisplayNames
	}
	return nil
}

func (x *ImportIntentsResponse_ConflictingResources) GetEntityDisplayNames() []string {
	if x != nil {
		return x.EntityDisplayNames
	}
	return nil
}

var File_google_cloud_dialogflow_cx_v3beta1_intent_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe2, 0x07,
	0x0a, 0x06, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x0b,
	0x69, 0x73, 0x5f, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x69, 0x73, 0x46, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x4e, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0xe2, 0x01, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x68, 0x72, 0x61,
	0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x59, 0x0a, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x68, 0x72, 0x61, 0x73, 0x65, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73, 0x12, 0x21, 0x0a,
	0x0c, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x1a, 0x42, 0x0a, 0x04, 0x50, 0x61, 0x72, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x49, 0x64, 0x1a, 0xa0, 0x01, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x6c, 0x69, 0x73,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x69, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x06, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x3a, 0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x7d, 0x22, 0x88, 0x02, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x12, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x4f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65,
	0x77, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x83, 0x01,
	0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x75, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xc5, 0x01, 0x0a, 0x13, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x22, 0xc0, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x53, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x22, 0x0a, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcc, 0x03, 0x0a, 0x14, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x55, 0x72, 0x69, 0x12, 0x5b, 0x0a, 0x0f, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x67, 0x0a, 0x0c, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0b, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7e,
	0x0a, 0x0b, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a,
	0x18, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x06, 0x52,
	0x45, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x45, 0x52, 0x47,
	0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x04, 0x12,
	0x13, 0x0a, 0x0f, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x4c, 0x49,
	0x43, 0x54, 0x10, 0x05, 0x12, 0x08, 0x0a, 0x04, 0x4b, 0x45, 0x45, 0x50, 0x10, 0x06, 0x42, 0x09,
	0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xda, 0x02, 0x0a, 0x15, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x7a, 0x0a, 0x14, 0x43, 0x6f,
	0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x12, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x12, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x17, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0x9e, 0x03, 0x0a, 0x14, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x12, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0b, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x55, 0x72,
	0x69, 0x12, 0x3b, 0x0a, 0x16, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x14, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x69,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x46, 0x0a, 0x0a, 0x44, 0x61, 0x74,
	0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x41, 0x54, 0x41, 0x5f,
	0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4c, 0x4f, 0x42, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x43, 0x53, 0x56, 0x10,
	0x03, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xa7, 0x01, 0x0a, 0x15, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x55, 0x72, 0x69, 0x12, 0x60, 0x0a,
	0x0f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x0e, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42,
	0x09, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x17, 0x0a, 0x15, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2a, 0x58, 0x0a, 0x0a, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65,
	0x77, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17,
	0x0a, 0x13, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x50, 0x41,
	0x52, 0x54, 0x49, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4e, 0x54, 0x45, 0x4e,
	0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x32, 0xb6, 0x0c,
	0x0a, 0x07, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xca, 0x01, 0x0a, 0x0b, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xb7, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xce, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x59, 0xda, 0x41, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x06,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x39, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0xda, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x65, 0xda, 0x41, 0x12, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x32, 0x40, 0x2f, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa9,
	0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a,
	0x39, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe6, 0x01, 0x0a, 0x0d, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c, 0xca, 0x41, 0x2e, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x15, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01,
	0x2a, 0x22, 0x40, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0xe6, 0x01, 0x0a, 0x0d, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c,
	0xca, 0x41, 0x2e, 0x0a, 0x15, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a, 0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x78, 0xca, 0x41,
	0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xc5, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x42, 0x0b, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63,
	0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46,
	0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33,
	0x42, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_intent_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_dialogflow_cx_v3beta1_intent_proto_goTypes = []interface{}{
	(IntentView)(0),                                    // 0: google.cloud.dialogflow.cx.v3beta1.IntentView
	(ImportIntentsRequest_MergeOption)(0),              // 1: google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption
	(ExportIntentsRequest_DataFormat)(0),               // 2: google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat
	(*Intent)(nil),                                     // 3: google.cloud.dialogflow.cx.v3beta1.Intent
	(*ListIntentsRequest)(nil),                         // 4: google.cloud.dialogflow.cx.v3beta1.ListIntentsRequest
	(*ListIntentsResponse)(nil),                        // 5: google.cloud.dialogflow.cx.v3beta1.ListIntentsResponse
	(*GetIntentRequest)(nil),                           // 6: google.cloud.dialogflow.cx.v3beta1.GetIntentRequest
	(*CreateIntentRequest)(nil),                        // 7: google.cloud.dialogflow.cx.v3beta1.CreateIntentRequest
	(*UpdateIntentRequest)(nil),                        // 8: google.cloud.dialogflow.cx.v3beta1.UpdateIntentRequest
	(*DeleteIntentRequest)(nil),                        // 9: google.cloud.dialogflow.cx.v3beta1.DeleteIntentRequest
	(*ImportIntentsRequest)(nil),                       // 10: google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest
	(*ImportIntentsResponse)(nil),                      // 11: google.cloud.dialogflow.cx.v3beta1.ImportIntentsResponse
	(*ImportIntentsMetadata)(nil),                      // 12: google.cloud.dialogflow.cx.v3beta1.ImportIntentsMetadata
	(*ExportIntentsRequest)(nil),                       // 13: google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest
	(*ExportIntentsResponse)(nil),                      // 14: google.cloud.dialogflow.cx.v3beta1.ExportIntentsResponse
	(*ExportIntentsMetadata)(nil),                      // 15: google.cloud.dialogflow.cx.v3beta1.ExportIntentsMetadata
	(*Intent_TrainingPhrase)(nil),                      // 16: google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase
	(*Intent_Parameter)(nil),                           // 17: google.cloud.dialogflow.cx.v3beta1.Intent.Parameter
	nil,                                                // 18: google.cloud.dialogflow.cx.v3beta1.Intent.LabelsEntry
	(*Intent_TrainingPhrase_Part)(nil),                 // 19: google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
	(*ImportIntentsResponse_ConflictingResources)(nil), // 20: google.cloud.dialogflow.cx.v3beta1.ImportIntentsResponse.ConflictingResources
	(*fieldmaskpb.FieldMask)(nil),                      // 21: google.protobuf.FieldMask
	(*InlineSource)(nil),                               // 22: google.cloud.dialogflow.cx.v3beta1.InlineSource
	(*InlineDestination)(nil),                          // 23: google.cloud.dialogflow.cx.v3beta1.InlineDestination
	(*emptypb.Empty)(nil),                              // 24: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),                    // 25: google.longrunning.Operation
}
var file_google_cloud_dialogflow_cx_v3beta1_intent_proto_depIdxs = []int32{
	16, // 0: google.cloud.dialogflow.cx.v3beta1.Intent.training_phrases:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase
	17, // 1: google.cloud.dialogflow.cx.v3beta1.Intent.parameters:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent.Parameter
	18, // 2: google.cloud.dialogflow.cx.v3beta1.Intent.labels:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent.LabelsEntry
	0,  // 3: google.cloud.dialogflow.cx.v3beta1.ListIntentsRequest.intent_view:type_name -> google.cloud.dialogflow.cx.v3beta1.IntentView
	3,  // 4: google.cloud.dialogflow.cx.v3beta1.ListIntentsResponse.intents:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent
	3,  // 5: google.cloud.dialogflow.cx.v3beta1.CreateIntentRequest.intent:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent
	3,  // 6: google.cloud.dialogflow.cx.v3beta1.UpdateIntentRequest.intent:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent
	21, // 7: google.cloud.dialogflow.cx.v3beta1.UpdateIntentRequest.update_mask:type_name -> google.protobuf.FieldMask
	22, // 8: google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.intents_content:type_name -> google.cloud.dialogflow.cx.v3beta1.InlineSource
	1,  // 9: google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.merge_option:type_name -> google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest.MergeOption
	20, // 10: google.cloud.dialogflow.cx.v3beta1.ImportIntentsResponse.conflicting_resources:type_name -> google.cloud.dialogflow.cx.v3beta1.ImportIntentsResponse.ConflictingResources
	2,  // 11: google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.data_format:type_name -> google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest.DataFormat
	23, // 12: google.cloud.dialogflow.cx.v3beta1.ExportIntentsResponse.intents_content:type_name -> google.cloud.dialogflow.cx.v3beta1.InlineDestination
	19, // 13: google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.parts:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent.TrainingPhrase.Part
	4,  // 14: google.cloud.dialogflow.cx.v3beta1.Intents.ListIntents:input_type -> google.cloud.dialogflow.cx.v3beta1.ListIntentsRequest
	6,  // 15: google.cloud.dialogflow.cx.v3beta1.Intents.GetIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.GetIntentRequest
	7,  // 16: google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.CreateIntentRequest
	8,  // 17: google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.UpdateIntentRequest
	9,  // 18: google.cloud.dialogflow.cx.v3beta1.Intents.DeleteIntent:input_type -> google.cloud.dialogflow.cx.v3beta1.DeleteIntentRequest
	10, // 19: google.cloud.dialogflow.cx.v3beta1.Intents.ImportIntents:input_type -> google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest
	13, // 20: google.cloud.dialogflow.cx.v3beta1.Intents.ExportIntents:input_type -> google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest
	5,  // 21: google.cloud.dialogflow.cx.v3beta1.Intents.ListIntents:output_type -> google.cloud.dialogflow.cx.v3beta1.ListIntentsResponse
	3,  // 22: google.cloud.dialogflow.cx.v3beta1.Intents.GetIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.Intent
	3,  // 23: google.cloud.dialogflow.cx.v3beta1.Intents.CreateIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.Intent
	3,  // 24: google.cloud.dialogflow.cx.v3beta1.Intents.UpdateIntent:output_type -> google.cloud.dialogflow.cx.v3beta1.Intent
	24, // 25: google.cloud.dialogflow.cx.v3beta1.Intents.DeleteIntent:output_type -> google.protobuf.Empty
	25, // 26: google.cloud.dialogflow.cx.v3beta1.Intents.ImportIntents:output_type -> google.longrunning.Operation
	25, // 27: google.cloud.dialogflow.cx.v3beta1.Intents.ExportIntents:output_type -> google.longrunning.Operation
	21, // [21:28] is the sub-list for method output_type
	14, // [14:21] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_intent_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_intent_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_intent_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_inline_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIntentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIntentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportIntentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportIntentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportIntentsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportIntentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportIntentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportIntentsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_TrainingPhrase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_Parameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Intent_TrainingPhrase_Part); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportIntentsResponse_ConflictingResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*ImportIntentsRequest_IntentsUri)(nil),
		(*ImportIntentsRequest_IntentsContent)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*ExportIntentsRequest_IntentsUri)(nil),
		(*ExportIntentsRequest_IntentsContentInline)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*ExportIntentsResponse_IntentsUri)(nil),
		(*ExportIntentsResponse_IntentsContent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_intent_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_intent_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_intent_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_intent_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_intent_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IntentsClient is the client API for Intents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IntentsClient interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Creates an intent in the specified agent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Updates the specified intent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Deletes the specified intent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Imports the specified intents into the agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ImportIntentsMetadata][google.cloud.dialogflow.cx.v3beta1.ImportIntentsMetadata]
	// - `response`:
	// [ImportIntentsResponse][google.cloud.dialogflow.cx.v3beta1.ImportIntentsResponse]
	ImportIntents(ctx context.Context, in *ImportIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports the selected intents.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ExportIntentsMetadata][google.cloud.dialogflow.cx.v3beta1.ExportIntentsMetadata]
	// - `response`:
	// [ExportIntentsResponse][google.cloud.dialogflow.cx.v3beta1.ExportIntentsResponse]
	ExportIntents(ctx context.Context, in *ExportIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type intentsClient struct {
	cc grpc.ClientConnInterface
}

func NewIntentsClient(cc grpc.ClientConnInterface) IntentsClient {
	return &intentsClient{cc}
}

func (c *intentsClient) ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error) {
	out := new(ListIntentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Intents/ListIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Intents/GetIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Intents/CreateIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Intents/UpdateIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Intents/DeleteIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) ImportIntents(ctx context.Context, in *ImportIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Intents/ImportIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) ExportIntents(ctx context.Context, in *ExportIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.Intents/ExportIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IntentsServer is the server API for Intents service.
type IntentsServer interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(context.Context, *ListIntentsRequest) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(context.Context, *GetIntentRequest) (*Intent, error)
	// Creates an intent in the specified agent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreateIntent(context.Context, *CreateIntentRequest) (*Intent, error)
	// Updates the specified intent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateIntent(context.Context, *UpdateIntentRequest) (*Intent, error)
	// Deletes the specified intent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeleteIntent(context.Context, *DeleteIntentRequest) (*emptypb.Empty, error)
	// Imports the specified intents into the agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ImportIntentsMetadata][google.cloud.dialogflow.cx.v3beta1.ImportIntentsMetadata]
	// - `response`:
	// [ImportIntentsResponse][google.cloud.dialogflow.cx.v3beta1.ImportIntentsResponse]
	ImportIntents(context.Context, *ImportIntentsRequest) (*longrunningpb.Operation, error)
	// Exports the selected intents.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ExportIntentsMetadata][google.cloud.dialogflow.cx.v3beta1.ExportIntentsMetadata]
	// - `response`:
	// [ExportIntentsResponse][google.cloud.dialogflow.cx.v3beta1.ExportIntentsResponse]
	ExportIntents(context.Context, *ExportIntentsRequest) (*longrunningpb.Operation, error)
}

// UnimplementedIntentsServer can be embedded to have forward compatible implementations.
type UnimplementedIntentsServer struct {
}

func (*UnimplementedIntentsServer) ListIntents(context.Context, *ListIntentsRequest) (*ListIntentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIntents not implemented")
}
func (*UnimplementedIntentsServer) GetIntent(context.Context, *GetIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIntent not implemented")
}
func (*UnimplementedIntentsServer) CreateIntent(context.Context, *CreateIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIntent not implemented")
}
func (*UnimplementedIntentsServer) UpdateIntent(context.Context, *UpdateIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIntent not implemented")
}
func (*UnimplementedIntentsServer) DeleteIntent(context.Context, *DeleteIntentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIntent not implemented")
}
func (*UnimplementedIntentsServer) ImportIntents(context.Context, *ImportIntentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportIntents not implemented")
}
func (*UnimplementedIntentsServer) ExportIntents(context.Context, *ExportIntentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportIntents not implemented")
}

func RegisterIntentsServer(s *grpc.Server, srv IntentsServer) {
	s.RegisterService(&_Intents_serviceDesc, srv)
}

func _Intents_ListIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).ListIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Intents/ListIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).ListIntents(ctx, req.(*ListIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_GetIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).GetIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Intents/GetIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).GetIntent(ctx, req.(*GetIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_CreateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).CreateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Intents/CreateIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).CreateIntent(ctx, req.(*CreateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_UpdateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).UpdateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Intents/UpdateIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).UpdateIntent(ctx, req.(*UpdateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_DeleteIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).DeleteIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Intents/DeleteIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).DeleteIntent(ctx, req.(*DeleteIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_ImportIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).ImportIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Intents/ImportIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).ImportIntents(ctx, req.(*ImportIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_ExportIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).ExportIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.Intents/ExportIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).ExportIntents(ctx, req.(*ExportIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Intents_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.Intents",
	HandlerType: (*IntentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListIntents",
			Handler:    _Intents_ListIntents_Handler,
		},
		{
			MethodName: "GetIntent",
			Handler:    _Intents_GetIntent_Handler,
		},
		{
			MethodName: "CreateIntent",
			Handler:    _Intents_CreateIntent_Handler,
		},
		{
			MethodName: "UpdateIntent",
			Handler:    _Intents_UpdateIntent_Handler,
		},
		{
			MethodName: "DeleteIntent",
			Handler:    _Intents_DeleteIntent_Handler,
		},
		{
			MethodName: "ImportIntents",
			Handler:    _Intents_ImportIntents_Handler,
		},
		{
			MethodName: "ExportIntents",
			Handler:    _Intents_ExportIntents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/intent.proto",
}
