//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// DO NOT EDIT.

package armconnectedvmware

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AvailablePatchCountByClassification.
func (a AvailablePatchCountByClassification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "critical", a.Critical)
	populate(objectMap, "definition", a.Definition)
	populate(objectMap, "featurePack", a.FeaturePack)
	populate(objectMap, "other", a.Other)
	populate(objectMap, "security", a.Security)
	populate(objectMap, "servicePack", a.ServicePack)
	populate(objectMap, "tools", a.Tools)
	populate(objectMap, "updateRollup", a.UpdateRollup)
	populate(objectMap, "updates", a.Updates)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailablePatchCountByClassification.
func (a *AvailablePatchCountByClassification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "critical":
			err = unpopulate(val, "Critical", &a.Critical)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &a.Definition)
			delete(rawMsg, key)
		case "featurePack":
			err = unpopulate(val, "FeaturePack", &a.FeaturePack)
			delete(rawMsg, key)
		case "other":
			err = unpopulate(val, "Other", &a.Other)
			delete(rawMsg, key)
		case "security":
			err = unpopulate(val, "Security", &a.Security)
			delete(rawMsg, key)
		case "servicePack":
			err = unpopulate(val, "ServicePack", &a.ServicePack)
			delete(rawMsg, key)
		case "tools":
			err = unpopulate(val, "Tools", &a.Tools)
			delete(rawMsg, key)
		case "updateRollup":
			err = unpopulate(val, "UpdateRollup", &a.UpdateRollup)
			delete(rawMsg, key)
		case "updates":
			err = unpopulate(val, "Updates", &a.Updates)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", c.ExtendedLocation)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Cluster.
func (c *Cluster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &c.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &c.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterInventoryItem.
func (c ClusterInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["inventoryType"] = InventoryTypeCluster
	populate(objectMap, "managedResourceId", c.ManagedResourceID)
	populate(objectMap, "moName", c.MoName)
	populate(objectMap, "moRefId", c.MoRefID)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterInventoryItem.
func (c *ClusterInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &c.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &c.ManagedResourceID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &c.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &c.MoRefID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterProperties.
func (c ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customResourceName", c.CustomResourceName)
	populate(objectMap, "datastoreIds", c.DatastoreIDs)
	populate(objectMap, "inventoryItemId", c.InventoryItemID)
	populate(objectMap, "moName", c.MoName)
	populate(objectMap, "moRefId", c.MoRefID)
	populate(objectMap, "networkIds", c.NetworkIDs)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "statuses", c.Statuses)
	populate(objectMap, "uuid", c.UUID)
	populate(objectMap, "vCenterId", c.VCenterID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterProperties.
func (c *ClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customResourceName":
			err = unpopulate(val, "CustomResourceName", &c.CustomResourceName)
			delete(rawMsg, key)
		case "datastoreIds":
			err = unpopulate(val, "DatastoreIDs", &c.DatastoreIDs)
			delete(rawMsg, key)
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &c.InventoryItemID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &c.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &c.MoRefID)
			delete(rawMsg, key)
		case "networkIds":
			err = unpopulate(val, "NetworkIDs", &c.NetworkIDs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &c.Statuses)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &c.UUID)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &c.VCenterID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClustersList.
func (c ClustersList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClustersList.
func (c *ClustersList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Condition.
func (c Condition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "message", c.Message)
	populate(objectMap, "reason", c.Reason)
	populate(objectMap, "severity", c.Severity)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Condition.
func (c *Condition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &c.Severity)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Datastore.
func (d Datastore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", d.ExtendedLocation)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "kind", d.Kind)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Datastore.
func (d *Datastore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &d.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &d.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatastoreInventoryItem.
func (d DatastoreInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "capacityGB", d.CapacityGB)
	populate(objectMap, "freeSpaceGB", d.FreeSpaceGB)
	objectMap["inventoryType"] = InventoryTypeDatastore
	populate(objectMap, "managedResourceId", d.ManagedResourceID)
	populate(objectMap, "moName", d.MoName)
	populate(objectMap, "moRefId", d.MoRefID)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatastoreInventoryItem.
func (d *DatastoreInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityGB":
			err = unpopulate(val, "CapacityGB", &d.CapacityGB)
			delete(rawMsg, key)
		case "freeSpaceGB":
			err = unpopulate(val, "FreeSpaceGB", &d.FreeSpaceGB)
			delete(rawMsg, key)
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &d.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &d.ManagedResourceID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &d.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &d.MoRefID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatastoreProperties.
func (d DatastoreProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customResourceName", d.CustomResourceName)
	populate(objectMap, "inventoryItemId", d.InventoryItemID)
	populate(objectMap, "moName", d.MoName)
	populate(objectMap, "moRefId", d.MoRefID)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "statuses", d.Statuses)
	populate(objectMap, "uuid", d.UUID)
	populate(objectMap, "vCenterId", d.VCenterID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatastoreProperties.
func (d *DatastoreProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customResourceName":
			err = unpopulate(val, "CustomResourceName", &d.CustomResourceName)
			delete(rawMsg, key)
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &d.InventoryItemID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &d.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &d.MoRefID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &d.Statuses)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &d.UUID)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &d.VCenterID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatastoresList.
func (d DatastoresList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatastoresList.
func (d *DatastoresList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDefinition.
func (e ErrorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDefinition.
func (e *ErrorDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GuestAgent.
func (g GuestAgent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "systemData", g.SystemData)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GuestAgent.
func (g *GuestAgent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &g.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GuestAgentList.
func (g GuestAgentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GuestAgentList.
func (g *GuestAgentList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GuestAgentProfile.
func (g GuestAgentProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "agentVersion", g.AgentVersion)
	populate(objectMap, "errorDetails", g.ErrorDetails)
	populateTimeRFC3339(objectMap, "lastStatusChange", g.LastStatusChange)
	populate(objectMap, "status", g.Status)
	populate(objectMap, "vmUuid", g.VMUUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GuestAgentProfile.
func (g *GuestAgentProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentVersion":
			err = unpopulate(val, "AgentVersion", &g.AgentVersion)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &g.ErrorDetails)
			delete(rawMsg, key)
		case "lastStatusChange":
			err = unpopulateTimeRFC3339(val, "LastStatusChange", &g.LastStatusChange)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &g.Status)
			delete(rawMsg, key)
		case "vmUuid":
			err = unpopulate(val, "VMUUID", &g.VMUUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GuestAgentProperties.
func (g GuestAgentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "credentials", g.Credentials)
	populate(objectMap, "customResourceName", g.CustomResourceName)
	populate(objectMap, "httpProxyConfig", g.HTTPProxyConfig)
	populate(objectMap, "provisioningAction", g.ProvisioningAction)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "status", g.Status)
	populate(objectMap, "statuses", g.Statuses)
	populate(objectMap, "uuid", g.UUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GuestAgentProperties.
func (g *GuestAgentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			err = unpopulate(val, "Credentials", &g.Credentials)
			delete(rawMsg, key)
		case "customResourceName":
			err = unpopulate(val, "CustomResourceName", &g.CustomResourceName)
			delete(rawMsg, key)
		case "httpProxyConfig":
			err = unpopulate(val, "HTTPProxyConfig", &g.HTTPProxyConfig)
			delete(rawMsg, key)
		case "provisioningAction":
			err = unpopulate(val, "ProvisioningAction", &g.ProvisioningAction)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &g.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &g.Status)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &g.Statuses)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &g.UUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GuestCredential.
func (g GuestCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "password", g.Password)
	populate(objectMap, "username", g.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GuestCredential.
func (g *GuestCredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &g.Password)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &g.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPProxyConfiguration.
func (h HTTPProxyConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "httpsProxy", h.HTTPSProxy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPProxyConfiguration.
func (h *HTTPProxyConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "httpsProxy":
			err = unpopulate(val, "HTTPSProxy", &h.HTTPSProxy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HardwareProfile.
func (h HardwareProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cpuHotAddEnabled", h.CPUHotAddEnabled)
	populate(objectMap, "cpuHotRemoveEnabled", h.CPUHotRemoveEnabled)
	populate(objectMap, "memoryHotAddEnabled", h.MemoryHotAddEnabled)
	populate(objectMap, "memorySizeMB", h.MemorySizeMB)
	populate(objectMap, "numCPUs", h.NumCPUs)
	populate(objectMap, "numCoresPerSocket", h.NumCoresPerSocket)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HardwareProfile.
func (h *HardwareProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpuHotAddEnabled":
			err = unpopulate(val, "CPUHotAddEnabled", &h.CPUHotAddEnabled)
			delete(rawMsg, key)
		case "cpuHotRemoveEnabled":
			err = unpopulate(val, "CPUHotRemoveEnabled", &h.CPUHotRemoveEnabled)
			delete(rawMsg, key)
		case "memoryHotAddEnabled":
			err = unpopulate(val, "MemoryHotAddEnabled", &h.MemoryHotAddEnabled)
			delete(rawMsg, key)
		case "memorySizeMB":
			err = unpopulate(val, "MemorySizeMB", &h.MemorySizeMB)
			delete(rawMsg, key)
		case "numCPUs":
			err = unpopulate(val, "NumCPUs", &h.NumCPUs)
			delete(rawMsg, key)
		case "numCoresPerSocket":
			err = unpopulate(val, "NumCoresPerSocket", &h.NumCoresPerSocket)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Host.
func (h Host) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", h.ExtendedLocation)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "kind", h.Kind)
	populate(objectMap, "location", h.Location)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "systemData", h.SystemData)
	populate(objectMap, "tags", h.Tags)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Host.
func (h *Host) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &h.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &h.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &h.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &h.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &h.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostInventoryItem.
func (h HostInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["inventoryType"] = InventoryTypeHost
	populate(objectMap, "managedResourceId", h.ManagedResourceID)
	populate(objectMap, "moName", h.MoName)
	populate(objectMap, "moRefId", h.MoRefID)
	populate(objectMap, "parent", h.Parent)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostInventoryItem.
func (h *HostInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &h.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &h.ManagedResourceID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &h.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &h.MoRefID)
			delete(rawMsg, key)
		case "parent":
			err = unpopulate(val, "Parent", &h.Parent)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostProperties.
func (h HostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customResourceName", h.CustomResourceName)
	populate(objectMap, "inventoryItemId", h.InventoryItemID)
	populate(objectMap, "moName", h.MoName)
	populate(objectMap, "moRefId", h.MoRefID)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "statuses", h.Statuses)
	populate(objectMap, "uuid", h.UUID)
	populate(objectMap, "vCenterId", h.VCenterID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostProperties.
func (h *HostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customResourceName":
			err = unpopulate(val, "CustomResourceName", &h.CustomResourceName)
			delete(rawMsg, key)
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &h.InventoryItemID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &h.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &h.MoRefID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &h.Statuses)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &h.UUID)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &h.VCenterID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HostsList.
func (h HostsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HostsList.
func (h *HostsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridIdentityMetadata.
func (h HybridIdentityMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "systemData", h.SystemData)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridIdentityMetadata.
func (h *HybridIdentityMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &h.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridIdentityMetadataList.
func (h HybridIdentityMetadataList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridIdentityMetadataList.
func (h *HybridIdentityMetadataList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridIdentityMetadataProperties.
func (h HybridIdentityMetadataProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", h.Identity)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "publicKey", h.PublicKey)
	populate(objectMap, "vmId", h.VMID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridIdentityMetadataProperties.
func (h *HybridIdentityMetadataProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &h.Identity)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		case "publicKey":
			err = unpopulate(val, "PublicKey", &h.PublicKey)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &h.VMID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Identity.
func (i *Identity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &i.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InventoryItem.
func (i InventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", i.ID)
	populate(objectMap, "kind", i.Kind)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "systemData", i.SystemData)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InventoryItem.
func (i *InventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalInventoryItemPropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &i.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InventoryItemDetails.
func (i InventoryItemDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "inventoryItemId", i.InventoryItemID)
	populate(objectMap, "moName", i.MoName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InventoryItemDetails.
func (i *InventoryItemDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &i.InventoryItemID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &i.MoName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InventoryItemProperties.
func (i InventoryItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["inventoryType"] = i.InventoryType
	populate(objectMap, "managedResourceId", i.ManagedResourceID)
	populate(objectMap, "moName", i.MoName)
	populate(objectMap, "moRefId", i.MoRefID)
	populate(objectMap, "provisioningState", i.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InventoryItemProperties.
func (i *InventoryItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &i.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &i.ManagedResourceID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &i.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &i.MoRefID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &i.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InventoryItemsList.
func (i InventoryItemsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InventoryItemsList.
func (i *InventoryItemsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxParameters.
func (l LinuxParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "classificationsToInclude", l.ClassificationsToInclude)
	populate(objectMap, "packageNameMasksToExclude", l.PackageNameMasksToExclude)
	populate(objectMap, "packageNameMasksToInclude", l.PackageNameMasksToInclude)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxParameters.
func (l *LinuxParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "classificationsToInclude":
			err = unpopulate(val, "ClassificationsToInclude", &l.ClassificationsToInclude)
			delete(rawMsg, key)
		case "packageNameMasksToExclude":
			err = unpopulate(val, "PackageNameMasksToExclude", &l.PackageNameMasksToExclude)
			delete(rawMsg, key)
		case "packageNameMasksToInclude":
			err = unpopulate(val, "PackageNameMasksToInclude", &l.PackageNameMasksToInclude)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineExtension.
func (m MachineExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineExtension.
func (m *MachineExtension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineExtensionInstanceView.
func (m MachineExtensionInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", m.Name)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "typeHandlerVersion", m.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineExtensionInstanceView.
func (m *MachineExtensionInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &m.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineExtensionInstanceViewStatus.
func (m MachineExtensionInstanceViewStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "code", m.Code)
	populate(objectMap, "displayStatus", m.DisplayStatus)
	populate(objectMap, "level", m.Level)
	populate(objectMap, "message", m.Message)
	populateTimeRFC3339(objectMap, "time", m.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineExtensionInstanceViewStatus.
func (m *MachineExtensionInstanceViewStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "displayStatus":
			err = unpopulate(val, "DisplayStatus", &m.DisplayStatus)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &m.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "time":
			err = unpopulateTimeRFC3339(val, "Time", &m.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineExtensionProperties.
func (m MachineExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoUpgradeMinorVersion", m.AutoUpgradeMinorVersion)
	populate(objectMap, "enableAutomaticUpgrade", m.EnableAutomaticUpgrade)
	populate(objectMap, "forceUpdateTag", m.ForceUpdateTag)
	populate(objectMap, "instanceView", m.InstanceView)
	populate(objectMap, "protectedSettings", &m.ProtectedSettings)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "publisher", m.Publisher)
	populate(objectMap, "settings", &m.Settings)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "typeHandlerVersion", m.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineExtensionProperties.
func (m *MachineExtensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &m.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "enableAutomaticUpgrade":
			err = unpopulate(val, "EnableAutomaticUpgrade", &m.EnableAutomaticUpgrade)
			delete(rawMsg, key)
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &m.ForceUpdateTag)
			delete(rawMsg, key)
		case "instanceView":
			err = unpopulate(val, "InstanceView", &m.InstanceView)
			delete(rawMsg, key)
		case "protectedSettings":
			err = unpopulate(val, "ProtectedSettings", &m.ProtectedSettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &m.Publisher)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &m.Settings)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &m.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineExtensionPropertiesInstanceView.
func (m MachineExtensionPropertiesInstanceView) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", m.Name)
	populate(objectMap, "status", m.Status)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "typeHandlerVersion", m.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineExtensionPropertiesInstanceView.
func (m *MachineExtensionPropertiesInstanceView) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &m.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &m.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineExtensionUpdate.
func (m MachineExtensionUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineExtensionUpdate.
func (m *MachineExtensionUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineExtensionUpdateProperties.
func (m MachineExtensionUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoUpgradeMinorVersion", m.AutoUpgradeMinorVersion)
	populate(objectMap, "enableAutomaticUpgrade", m.EnableAutomaticUpgrade)
	populate(objectMap, "forceUpdateTag", m.ForceUpdateTag)
	populate(objectMap, "protectedSettings", &m.ProtectedSettings)
	populate(objectMap, "publisher", m.Publisher)
	populate(objectMap, "settings", &m.Settings)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "typeHandlerVersion", m.TypeHandlerVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineExtensionUpdateProperties.
func (m *MachineExtensionUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &m.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "enableAutomaticUpgrade":
			err = unpopulate(val, "EnableAutomaticUpgrade", &m.EnableAutomaticUpgrade)
			delete(rawMsg, key)
		case "forceUpdateTag":
			err = unpopulate(val, "ForceUpdateTag", &m.ForceUpdateTag)
			delete(rawMsg, key)
		case "protectedSettings":
			err = unpopulate(val, "ProtectedSettings", &m.ProtectedSettings)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &m.Publisher)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &m.Settings)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "typeHandlerVersion":
			err = unpopulate(val, "TypeHandlerVersion", &m.TypeHandlerVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MachineExtensionsListResult.
func (m MachineExtensionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineExtensionsListResult.
func (m *MachineExtensionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterface.
func (n NetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceKey", n.DeviceKey)
	populate(objectMap, "ipAddresses", n.IPAddresses)
	populate(objectMap, "ipSettings", n.IPSettings)
	populate(objectMap, "label", n.Label)
	populate(objectMap, "macAddress", n.MacAddress)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "networkId", n.NetworkID)
	populate(objectMap, "networkMoName", n.NetworkMoName)
	populate(objectMap, "networkMoRefId", n.NetworkMoRefID)
	populate(objectMap, "nicType", n.NicType)
	populate(objectMap, "powerOnBoot", n.PowerOnBoot)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterface.
func (n *NetworkInterface) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceKey":
			err = unpopulate(val, "DeviceKey", &n.DeviceKey)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &n.IPAddresses)
			delete(rawMsg, key)
		case "ipSettings":
			err = unpopulate(val, "IPSettings", &n.IPSettings)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &n.Label)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &n.MacAddress)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &n.NetworkID)
			delete(rawMsg, key)
		case "networkMoName":
			err = unpopulate(val, "NetworkMoName", &n.NetworkMoName)
			delete(rawMsg, key)
		case "networkMoRefId":
			err = unpopulate(val, "NetworkMoRefID", &n.NetworkMoRefID)
			delete(rawMsg, key)
		case "nicType":
			err = unpopulate(val, "NicType", &n.NicType)
			delete(rawMsg, key)
		case "powerOnBoot":
			err = unpopulate(val, "PowerOnBoot", &n.PowerOnBoot)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaceUpdate.
func (n NetworkInterfaceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deviceKey", n.DeviceKey)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "networkId", n.NetworkID)
	populate(objectMap, "nicType", n.NicType)
	populate(objectMap, "powerOnBoot", n.PowerOnBoot)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfaceUpdate.
func (n *NetworkInterfaceUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deviceKey":
			err = unpopulate(val, "DeviceKey", &n.DeviceKey)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "networkId":
			err = unpopulate(val, "NetworkID", &n.NetworkID)
			delete(rawMsg, key)
		case "nicType":
			err = unpopulate(val, "NicType", &n.NicType)
			delete(rawMsg, key)
		case "powerOnBoot":
			err = unpopulate(val, "PowerOnBoot", &n.PowerOnBoot)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkInterfaces", n.NetworkInterfaces)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfile.
func (n *NetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &n.NetworkInterfaces)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfileUpdate.
func (n NetworkProfileUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "networkInterfaces", n.NetworkInterfaces)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfileUpdate.
func (n *NetworkProfileUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &n.NetworkInterfaces)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NicIPAddressSettings.
func (n NicIPAddressSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allocationMethod", n.AllocationMethod)
	populate(objectMap, "ipAddress", n.IPAddress)
	populate(objectMap, "subnetMask", n.SubnetMask)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NicIPAddressSettings.
func (n *NicIPAddressSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocationMethod":
			err = unpopulate(val, "AllocationMethod", &n.AllocationMethod)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &n.IPAddress)
			delete(rawMsg, key)
		case "subnetMask":
			err = unpopulate(val, "SubnetMask", &n.SubnetMask)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NicIPSettings.
func (n NicIPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allocationMethod", n.AllocationMethod)
	populate(objectMap, "dnsServers", n.DNSServers)
	populate(objectMap, "gateway", n.Gateway)
	populate(objectMap, "ipAddress", n.IPAddress)
	populate(objectMap, "ipAddressInfo", n.IPAddressInfo)
	populate(objectMap, "primaryWinsServer", n.PrimaryWinsServer)
	populate(objectMap, "secondaryWinsServer", n.SecondaryWinsServer)
	populate(objectMap, "subnetMask", n.SubnetMask)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NicIPSettings.
func (n *NicIPSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocationMethod":
			err = unpopulate(val, "AllocationMethod", &n.AllocationMethod)
			delete(rawMsg, key)
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &n.DNSServers)
			delete(rawMsg, key)
		case "gateway":
			err = unpopulate(val, "Gateway", &n.Gateway)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &n.IPAddress)
			delete(rawMsg, key)
		case "ipAddressInfo":
			err = unpopulate(val, "IPAddressInfo", &n.IPAddressInfo)
			delete(rawMsg, key)
		case "primaryWinsServer":
			err = unpopulate(val, "PrimaryWinsServer", &n.PrimaryWinsServer)
			delete(rawMsg, key)
		case "secondaryWinsServer":
			err = unpopulate(val, "SecondaryWinsServer", &n.SecondaryWinsServer)
			delete(rawMsg, key)
		case "subnetMask":
			err = unpopulate(val, "SubnetMask", &n.SubnetMask)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationsList.
func (o OperationsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationsList.
func (o *OperationsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsProfile.
func (o OsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "adminPassword", o.AdminPassword)
	populate(objectMap, "adminUsername", o.AdminUsername)
	populate(objectMap, "allowExtensionOperations", o.AllowExtensionOperations)
	populate(objectMap, "computerName", o.ComputerName)
	populate(objectMap, "guestId", o.GuestID)
	populate(objectMap, "linuxConfiguration", o.LinuxConfiguration)
	populate(objectMap, "osName", o.OSName)
	populate(objectMap, "osType", o.OSType)
	populate(objectMap, "toolsRunningStatus", o.ToolsRunningStatus)
	populate(objectMap, "toolsVersion", o.ToolsVersion)
	populate(objectMap, "toolsVersionStatus", o.ToolsVersionStatus)
	populate(objectMap, "windowsConfiguration", o.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsProfile.
func (o *OsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &o.AdminPassword)
			delete(rawMsg, key)
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &o.AdminUsername)
			delete(rawMsg, key)
		case "allowExtensionOperations":
			err = unpopulate(val, "AllowExtensionOperations", &o.AllowExtensionOperations)
			delete(rawMsg, key)
		case "computerName":
			err = unpopulate(val, "ComputerName", &o.ComputerName)
			delete(rawMsg, key)
		case "guestId":
			err = unpopulate(val, "GuestID", &o.GuestID)
			delete(rawMsg, key)
		case "linuxConfiguration":
			err = unpopulate(val, "LinuxConfiguration", &o.LinuxConfiguration)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &o.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &o.OSType)
			delete(rawMsg, key)
		case "toolsRunningStatus":
			err = unpopulate(val, "ToolsRunningStatus", &o.ToolsRunningStatus)
			delete(rawMsg, key)
		case "toolsVersion":
			err = unpopulate(val, "ToolsVersion", &o.ToolsVersion)
			delete(rawMsg, key)
		case "toolsVersionStatus":
			err = unpopulate(val, "ToolsVersionStatus", &o.ToolsVersionStatus)
			delete(rawMsg, key)
		case "windowsConfiguration":
			err = unpopulate(val, "WindowsConfiguration", &o.WindowsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsProfileLinuxConfiguration.
func (o OsProfileLinuxConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "patchSettings", o.PatchSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsProfileLinuxConfiguration.
func (o *OsProfileLinuxConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "patchSettings":
			err = unpopulate(val, "PatchSettings", &o.PatchSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsProfileUpdate.
func (o OsProfileUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "linuxConfiguration", o.LinuxConfiguration)
	populate(objectMap, "windowsConfiguration", o.WindowsConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsProfileUpdate.
func (o *OsProfileUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linuxConfiguration":
			err = unpopulate(val, "LinuxConfiguration", &o.LinuxConfiguration)
			delete(rawMsg, key)
		case "windowsConfiguration":
			err = unpopulate(val, "WindowsConfiguration", &o.WindowsConfiguration)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsProfileUpdateLinuxConfiguration.
func (o OsProfileUpdateLinuxConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "patchSettings", o.PatchSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsProfileUpdateLinuxConfiguration.
func (o *OsProfileUpdateLinuxConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "patchSettings":
			err = unpopulate(val, "PatchSettings", &o.PatchSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsProfileUpdateWindowsConfiguration.
func (o OsProfileUpdateWindowsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "patchSettings", o.PatchSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsProfileUpdateWindowsConfiguration.
func (o *OsProfileUpdateWindowsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "patchSettings":
			err = unpopulate(val, "PatchSettings", &o.PatchSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OsProfileWindowsConfiguration.
func (o OsProfileWindowsConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "patchSettings", o.PatchSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OsProfileWindowsConfiguration.
func (o *OsProfileWindowsConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "patchSettings":
			err = unpopulate(val, "PatchSettings", &o.PatchSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchSettings.
func (p PatchSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentMode", p.AssessmentMode)
	populate(objectMap, "patchMode", p.PatchMode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchSettings.
func (p *PatchSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentMode":
			err = unpopulate(val, "AssessmentMode", &p.AssessmentMode)
			delete(rawMsg, key)
		case "patchMode":
			err = unpopulate(val, "PatchMode", &p.PatchMode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlacementProfile.
func (p PlacementProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clusterId", p.ClusterID)
	populate(objectMap, "datastoreId", p.DatastoreID)
	populate(objectMap, "hostId", p.HostID)
	populate(objectMap, "resourcePoolId", p.ResourcePoolID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlacementProfile.
func (p *PlacementProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterId":
			err = unpopulate(val, "ClusterID", &p.ClusterID)
			delete(rawMsg, key)
		case "datastoreId":
			err = unpopulate(val, "DatastoreID", &p.DatastoreID)
			delete(rawMsg, key)
		case "hostId":
			err = unpopulate(val, "HostID", &p.HostID)
			delete(rawMsg, key)
		case "resourcePoolId":
			err = unpopulate(val, "ResourcePoolID", &p.ResourcePoolID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcePatch.
func (r ResourcePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcePatch.
func (r *ResourcePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcePool.
func (r ResourcePool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", r.ExtendedLocation)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcePool.
func (r *ResourcePool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &r.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcePoolInventoryItem.
func (r ResourcePoolInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["inventoryType"] = InventoryTypeResourcePool
	populate(objectMap, "managedResourceId", r.ManagedResourceID)
	populate(objectMap, "moName", r.MoName)
	populate(objectMap, "moRefId", r.MoRefID)
	populate(objectMap, "parent", r.Parent)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcePoolInventoryItem.
func (r *ResourcePoolInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &r.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &r.ManagedResourceID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &r.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &r.MoRefID)
			delete(rawMsg, key)
		case "parent":
			err = unpopulate(val, "Parent", &r.Parent)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcePoolProperties.
func (r ResourcePoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "cpuLimitMHz", r.CPULimitMHz)
	populate(objectMap, "cpuReservationMHz", r.CPUReservationMHz)
	populate(objectMap, "cpuSharesLevel", r.CPUSharesLevel)
	populate(objectMap, "customResourceName", r.CustomResourceName)
	populate(objectMap, "inventoryItemId", r.InventoryItemID)
	populate(objectMap, "memLimitMB", r.MemLimitMB)
	populate(objectMap, "memReservationMB", r.MemReservationMB)
	populate(objectMap, "memSharesLevel", r.MemSharesLevel)
	populate(objectMap, "moName", r.MoName)
	populate(objectMap, "moRefId", r.MoRefID)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populate(objectMap, "statuses", r.Statuses)
	populate(objectMap, "uuid", r.UUID)
	populate(objectMap, "vCenterId", r.VCenterID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcePoolProperties.
func (r *ResourcePoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpuLimitMHz":
			err = unpopulate(val, "CPULimitMHz", &r.CPULimitMHz)
			delete(rawMsg, key)
		case "cpuReservationMHz":
			err = unpopulate(val, "CPUReservationMHz", &r.CPUReservationMHz)
			delete(rawMsg, key)
		case "cpuSharesLevel":
			err = unpopulate(val, "CPUSharesLevel", &r.CPUSharesLevel)
			delete(rawMsg, key)
		case "customResourceName":
			err = unpopulate(val, "CustomResourceName", &r.CustomResourceName)
			delete(rawMsg, key)
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &r.InventoryItemID)
			delete(rawMsg, key)
		case "memLimitMB":
			err = unpopulate(val, "MemLimitMB", &r.MemLimitMB)
			delete(rawMsg, key)
		case "memReservationMB":
			err = unpopulate(val, "MemReservationMB", &r.MemReservationMB)
			delete(rawMsg, key)
		case "memSharesLevel":
			err = unpopulate(val, "MemSharesLevel", &r.MemSharesLevel)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &r.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &r.MoRefID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &r.Statuses)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &r.UUID)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &r.VCenterID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourcePoolsList.
func (r ResourcePoolsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourcePoolsList.
func (r *ResourcePoolsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceStatus.
func (r ResourceStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "lastUpdatedAt", r.LastUpdatedAt)
	populate(objectMap, "message", r.Message)
	populate(objectMap, "reason", r.Reason)
	populate(objectMap, "severity", r.Severity)
	populate(objectMap, "status", r.Status)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceStatus.
func (r *ResourceStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastUpdatedAt":
			err = unpopulateTimeRFC3339(val, "LastUpdatedAt", &r.LastUpdatedAt)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &r.Reason)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &r.Severity)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecurityProfile.
func (s SecurityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "uefiSettings", s.UefiSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecurityProfile.
func (s *SecurityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "uefiSettings":
			err = unpopulate(val, "UefiSettings", &s.UefiSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StopVirtualMachineOptions.
func (s StopVirtualMachineOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "skipShutdown", s.SkipShutdown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StopVirtualMachineOptions.
func (s *StopVirtualMachineOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "skipShutdown":
			err = unpopulate(val, "SkipShutdown", &s.SkipShutdown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageProfile.
func (s StorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disks", s.Disks)
	populate(objectMap, "scsiControllers", s.ScsiControllers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageProfile.
func (s *StorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disks":
			err = unpopulate(val, "Disks", &s.Disks)
			delete(rawMsg, key)
		case "scsiControllers":
			err = unpopulate(val, "ScsiControllers", &s.ScsiControllers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageProfileUpdate.
func (s StorageProfileUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disks", s.Disks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageProfileUpdate.
func (s *StorageProfileUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disks":
			err = unpopulate(val, "Disks", &s.Disks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UefiSettings.
func (u UefiSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "secureBootEnabled", u.SecureBootEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UefiSettings.
func (u *UefiSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secureBootEnabled":
			err = unpopulate(val, "SecureBootEnabled", &u.SecureBootEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VCenter.
func (v VCenter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VCenter.
func (v *VCenter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VCenterProperties.
func (v VCenterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectionStatus", v.ConnectionStatus)
	populate(objectMap, "credentials", v.Credentials)
	populate(objectMap, "customResourceName", v.CustomResourceName)
	populate(objectMap, "fqdn", v.Fqdn)
	populate(objectMap, "instanceUuid", v.InstanceUUID)
	populate(objectMap, "port", v.Port)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "uuid", v.UUID)
	populate(objectMap, "version", v.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VCenterProperties.
func (v *VCenterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionStatus":
			err = unpopulate(val, "ConnectionStatus", &v.ConnectionStatus)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &v.Credentials)
			delete(rawMsg, key)
		case "customResourceName":
			err = unpopulate(val, "CustomResourceName", &v.CustomResourceName)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &v.Fqdn)
			delete(rawMsg, key)
		case "instanceUuid":
			err = unpopulate(val, "InstanceUUID", &v.InstanceUUID)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &v.Port)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &v.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VCentersList.
func (v VCentersList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VCentersList.
func (v *VCentersList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VICredential.
func (v VICredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "password", v.Password)
	populate(objectMap, "username", v.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VICredential.
func (v *VICredential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &v.Password)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &v.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualDisk.
func (v VirtualDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "controllerKey", v.ControllerKey)
	populate(objectMap, "deviceKey", v.DeviceKey)
	populate(objectMap, "deviceName", v.DeviceName)
	populate(objectMap, "diskMode", v.DiskMode)
	populate(objectMap, "diskObjectId", v.DiskObjectID)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "diskType", v.DiskType)
	populate(objectMap, "label", v.Label)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "unitNumber", v.UnitNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualDisk.
func (v *VirtualDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "controllerKey":
			err = unpopulate(val, "ControllerKey", &v.ControllerKey)
			delete(rawMsg, key)
		case "deviceKey":
			err = unpopulate(val, "DeviceKey", &v.DeviceKey)
			delete(rawMsg, key)
		case "deviceName":
			err = unpopulate(val, "DeviceName", &v.DeviceName)
			delete(rawMsg, key)
		case "diskMode":
			err = unpopulate(val, "DiskMode", &v.DiskMode)
			delete(rawMsg, key)
		case "diskObjectId":
			err = unpopulate(val, "DiskObjectID", &v.DiskObjectID)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &v.DiskType)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &v.Label)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "unitNumber":
			err = unpopulate(val, "UnitNumber", &v.UnitNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualDiskUpdate.
func (v VirtualDiskUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "controllerKey", v.ControllerKey)
	populate(objectMap, "deviceKey", v.DeviceKey)
	populate(objectMap, "deviceName", v.DeviceName)
	populate(objectMap, "diskMode", v.DiskMode)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "diskType", v.DiskType)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "unitNumber", v.UnitNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualDiskUpdate.
func (v *VirtualDiskUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "controllerKey":
			err = unpopulate(val, "ControllerKey", &v.ControllerKey)
			delete(rawMsg, key)
		case "deviceKey":
			err = unpopulate(val, "DeviceKey", &v.DeviceKey)
			delete(rawMsg, key)
		case "deviceName":
			err = unpopulate(val, "DeviceName", &v.DeviceName)
			delete(rawMsg, key)
		case "diskMode":
			err = unpopulate(val, "DiskMode", &v.DiskMode)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &v.DiskType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "unitNumber":
			err = unpopulate(val, "UnitNumber", &v.UnitNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachine.
func (v VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachine.
func (v *VirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineAssessPatchesResult.
func (v VirtualMachineAssessPatchesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentActivityId", v.AssessmentActivityID)
	populate(objectMap, "availablePatchCountByClassification", v.AvailablePatchCountByClassification)
	populate(objectMap, "errorDetails", v.ErrorDetails)
	populateTimeRFC3339(objectMap, "lastModifiedDateTime", v.LastModifiedDateTime)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "patchServiceUsed", v.PatchServiceUsed)
	populate(objectMap, "rebootPending", v.RebootPending)
	populateTimeRFC3339(objectMap, "startDateTime", v.StartDateTime)
	populate(objectMap, "startedBy", v.StartedBy)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineAssessPatchesResult.
func (v *VirtualMachineAssessPatchesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentActivityId":
			err = unpopulate(val, "AssessmentActivityID", &v.AssessmentActivityID)
			delete(rawMsg, key)
		case "availablePatchCountByClassification":
			err = unpopulate(val, "AvailablePatchCountByClassification", &v.AvailablePatchCountByClassification)
			delete(rawMsg, key)
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &v.ErrorDetails)
			delete(rawMsg, key)
		case "lastModifiedDateTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedDateTime", &v.LastModifiedDateTime)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "patchServiceUsed":
			err = unpopulate(val, "PatchServiceUsed", &v.PatchServiceUsed)
			delete(rawMsg, key)
		case "rebootPending":
			err = unpopulate(val, "RebootPending", &v.RebootPending)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateTimeRFC3339(val, "StartDateTime", &v.StartDateTime)
			delete(rawMsg, key)
		case "startedBy":
			err = unpopulate(val, "StartedBy", &v.StartedBy)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineInstallPatchesParameters.
func (v VirtualMachineInstallPatchesParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "linuxParameters", v.LinuxParameters)
	populate(objectMap, "maximumDuration", v.MaximumDuration)
	populate(objectMap, "rebootSetting", v.RebootSetting)
	populate(objectMap, "windowsParameters", v.WindowsParameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineInstallPatchesParameters.
func (v *VirtualMachineInstallPatchesParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linuxParameters":
			err = unpopulate(val, "LinuxParameters", &v.LinuxParameters)
			delete(rawMsg, key)
		case "maximumDuration":
			err = unpopulate(val, "MaximumDuration", &v.MaximumDuration)
			delete(rawMsg, key)
		case "rebootSetting":
			err = unpopulate(val, "RebootSetting", &v.RebootSetting)
			delete(rawMsg, key)
		case "windowsParameters":
			err = unpopulate(val, "WindowsParameters", &v.WindowsParameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineInstallPatchesResult.
func (v VirtualMachineInstallPatchesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorDetails", v.ErrorDetails)
	populate(objectMap, "excludedPatchCount", v.ExcludedPatchCount)
	populate(objectMap, "failedPatchCount", v.FailedPatchCount)
	populate(objectMap, "installationActivityId", v.InstallationActivityID)
	populate(objectMap, "installedPatchCount", v.InstalledPatchCount)
	populateTimeRFC3339(objectMap, "lastModifiedDateTime", v.LastModifiedDateTime)
	populate(objectMap, "maintenanceWindowExceeded", v.MaintenanceWindowExceeded)
	populate(objectMap, "notSelectedPatchCount", v.NotSelectedPatchCount)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "patchServiceUsed", v.PatchServiceUsed)
	populate(objectMap, "pendingPatchCount", v.PendingPatchCount)
	populate(objectMap, "rebootStatus", v.RebootStatus)
	populateTimeRFC3339(objectMap, "startDateTime", v.StartDateTime)
	populate(objectMap, "startedBy", v.StartedBy)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineInstallPatchesResult.
func (v *VirtualMachineInstallPatchesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorDetails":
			err = unpopulate(val, "ErrorDetails", &v.ErrorDetails)
			delete(rawMsg, key)
		case "excludedPatchCount":
			err = unpopulate(val, "ExcludedPatchCount", &v.ExcludedPatchCount)
			delete(rawMsg, key)
		case "failedPatchCount":
			err = unpopulate(val, "FailedPatchCount", &v.FailedPatchCount)
			delete(rawMsg, key)
		case "installationActivityId":
			err = unpopulate(val, "InstallationActivityID", &v.InstallationActivityID)
			delete(rawMsg, key)
		case "installedPatchCount":
			err = unpopulate(val, "InstalledPatchCount", &v.InstalledPatchCount)
			delete(rawMsg, key)
		case "lastModifiedDateTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedDateTime", &v.LastModifiedDateTime)
			delete(rawMsg, key)
		case "maintenanceWindowExceeded":
			err = unpopulate(val, "MaintenanceWindowExceeded", &v.MaintenanceWindowExceeded)
			delete(rawMsg, key)
		case "notSelectedPatchCount":
			err = unpopulate(val, "NotSelectedPatchCount", &v.NotSelectedPatchCount)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "patchServiceUsed":
			err = unpopulate(val, "PatchServiceUsed", &v.PatchServiceUsed)
			delete(rawMsg, key)
		case "pendingPatchCount":
			err = unpopulate(val, "PendingPatchCount", &v.PendingPatchCount)
			delete(rawMsg, key)
		case "rebootStatus":
			err = unpopulate(val, "RebootStatus", &v.RebootStatus)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateTimeRFC3339(val, "StartDateTime", &v.StartDateTime)
			delete(rawMsg, key)
		case "startedBy":
			err = unpopulate(val, "StartedBy", &v.StartedBy)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineInventoryItem.
func (v VirtualMachineInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "folderPath", v.FolderPath)
	populate(objectMap, "host", v.Host)
	populate(objectMap, "ipAddresses", v.IPAddresses)
	populate(objectMap, "instanceUuid", v.InstanceUUID)
	objectMap["inventoryType"] = InventoryTypeVirtualMachine
	populate(objectMap, "managedResourceId", v.ManagedResourceID)
	populate(objectMap, "moName", v.MoName)
	populate(objectMap, "moRefId", v.MoRefID)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "powerState", v.PowerState)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "resourcePool", v.ResourcePool)
	populate(objectMap, "smbiosUuid", v.SmbiosUUID)
	populate(objectMap, "toolsRunningStatus", v.ToolsRunningStatus)
	populate(objectMap, "toolsVersion", v.ToolsVersion)
	populate(objectMap, "toolsVersionStatus", v.ToolsVersionStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineInventoryItem.
func (v *VirtualMachineInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "folderPath":
			err = unpopulate(val, "FolderPath", &v.FolderPath)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &v.Host)
			delete(rawMsg, key)
		case "ipAddresses":
			err = unpopulate(val, "IPAddresses", &v.IPAddresses)
			delete(rawMsg, key)
		case "instanceUuid":
			err = unpopulate(val, "InstanceUUID", &v.InstanceUUID)
			delete(rawMsg, key)
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &v.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &v.ManagedResourceID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &v.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &v.MoRefID)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &v.PowerState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "resourcePool":
			err = unpopulate(val, "ResourcePool", &v.ResourcePool)
			delete(rawMsg, key)
		case "smbiosUuid":
			err = unpopulate(val, "SmbiosUUID", &v.SmbiosUUID)
			delete(rawMsg, key)
		case "toolsRunningStatus":
			err = unpopulate(val, "ToolsRunningStatus", &v.ToolsRunningStatus)
			delete(rawMsg, key)
		case "toolsVersion":
			err = unpopulate(val, "ToolsVersion", &v.ToolsVersion)
			delete(rawMsg, key)
		case "toolsVersionStatus":
			err = unpopulate(val, "ToolsVersionStatus", &v.ToolsVersionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineProperties.
func (v VirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customResourceName", v.CustomResourceName)
	populate(objectMap, "firmwareType", v.FirmwareType)
	populate(objectMap, "folderPath", v.FolderPath)
	populate(objectMap, "guestAgentProfile", v.GuestAgentProfile)
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "instanceUuid", v.InstanceUUID)
	populate(objectMap, "inventoryItemId", v.InventoryItemID)
	populate(objectMap, "moName", v.MoName)
	populate(objectMap, "moRefId", v.MoRefID)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "placementProfile", v.PlacementProfile)
	populate(objectMap, "powerState", v.PowerState)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "resourcePoolId", v.ResourcePoolID)
	populate(objectMap, "securityProfile", v.SecurityProfile)
	populate(objectMap, "smbiosUuid", v.SmbiosUUID)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "storageProfile", v.StorageProfile)
	populate(objectMap, "templateId", v.TemplateID)
	populate(objectMap, "uuid", v.UUID)
	populate(objectMap, "vCenterId", v.VCenterID)
	populate(objectMap, "vmId", v.VMID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineProperties.
func (v *VirtualMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customResourceName":
			err = unpopulate(val, "CustomResourceName", &v.CustomResourceName)
			delete(rawMsg, key)
		case "firmwareType":
			err = unpopulate(val, "FirmwareType", &v.FirmwareType)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &v.FolderPath)
			delete(rawMsg, key)
		case "guestAgentProfile":
			err = unpopulate(val, "GuestAgentProfile", &v.GuestAgentProfile)
			delete(rawMsg, key)
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "instanceUuid":
			err = unpopulate(val, "InstanceUUID", &v.InstanceUUID)
			delete(rawMsg, key)
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &v.InventoryItemID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &v.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &v.MoRefID)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "placementProfile":
			err = unpopulate(val, "PlacementProfile", &v.PlacementProfile)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &v.PowerState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "resourcePoolId":
			err = unpopulate(val, "ResourcePoolID", &v.ResourcePoolID)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &v.SecurityProfile)
			delete(rawMsg, key)
		case "smbiosUuid":
			err = unpopulate(val, "SmbiosUUID", &v.SmbiosUUID)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		case "templateId":
			err = unpopulate(val, "TemplateID", &v.TemplateID)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &v.VCenterID)
			delete(rawMsg, key)
		case "vmId":
			err = unpopulate(val, "VMID", &v.VMID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineTemplate.
func (v VirtualMachineTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineTemplate.
func (v *VirtualMachineTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineTemplateInventoryItem.
func (v VirtualMachineTemplateInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "folderPath", v.FolderPath)
	objectMap["inventoryType"] = InventoryTypeVirtualMachineTemplate
	populate(objectMap, "managedResourceId", v.ManagedResourceID)
	populate(objectMap, "memorySizeMB", v.MemorySizeMB)
	populate(objectMap, "moName", v.MoName)
	populate(objectMap, "moRefId", v.MoRefID)
	populate(objectMap, "numCPUs", v.NumCPUs)
	populate(objectMap, "numCoresPerSocket", v.NumCoresPerSocket)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineTemplateInventoryItem.
func (v *VirtualMachineTemplateInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "folderPath":
			err = unpopulate(val, "FolderPath", &v.FolderPath)
			delete(rawMsg, key)
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &v.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &v.ManagedResourceID)
			delete(rawMsg, key)
		case "memorySizeMB":
			err = unpopulate(val, "MemorySizeMB", &v.MemorySizeMB)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &v.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &v.MoRefID)
			delete(rawMsg, key)
		case "numCPUs":
			err = unpopulate(val, "NumCPUs", &v.NumCPUs)
			delete(rawMsg, key)
		case "numCoresPerSocket":
			err = unpopulate(val, "NumCoresPerSocket", &v.NumCoresPerSocket)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineTemplateProperties.
func (v VirtualMachineTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customResourceName", v.CustomResourceName)
	populate(objectMap, "disks", v.Disks)
	populate(objectMap, "firmwareType", v.FirmwareType)
	populate(objectMap, "folderPath", v.FolderPath)
	populate(objectMap, "inventoryItemId", v.InventoryItemID)
	populate(objectMap, "memorySizeMB", v.MemorySizeMB)
	populate(objectMap, "moName", v.MoName)
	populate(objectMap, "moRefId", v.MoRefID)
	populate(objectMap, "networkInterfaces", v.NetworkInterfaces)
	populate(objectMap, "numCPUs", v.NumCPUs)
	populate(objectMap, "numCoresPerSocket", v.NumCoresPerSocket)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "toolsVersion", v.ToolsVersion)
	populate(objectMap, "toolsVersionStatus", v.ToolsVersionStatus)
	populate(objectMap, "uuid", v.UUID)
	populate(objectMap, "vCenterId", v.VCenterID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineTemplateProperties.
func (v *VirtualMachineTemplateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customResourceName":
			err = unpopulate(val, "CustomResourceName", &v.CustomResourceName)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &v.Disks)
			delete(rawMsg, key)
		case "firmwareType":
			err = unpopulate(val, "FirmwareType", &v.FirmwareType)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &v.FolderPath)
			delete(rawMsg, key)
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &v.InventoryItemID)
			delete(rawMsg, key)
		case "memorySizeMB":
			err = unpopulate(val, "MemorySizeMB", &v.MemorySizeMB)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &v.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &v.MoRefID)
			delete(rawMsg, key)
		case "networkInterfaces":
			err = unpopulate(val, "NetworkInterfaces", &v.NetworkInterfaces)
			delete(rawMsg, key)
		case "numCPUs":
			err = unpopulate(val, "NumCPUs", &v.NumCPUs)
			delete(rawMsg, key)
		case "numCoresPerSocket":
			err = unpopulate(val, "NumCoresPerSocket", &v.NumCoresPerSocket)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "toolsVersion":
			err = unpopulate(val, "ToolsVersion", &v.ToolsVersion)
			delete(rawMsg, key)
		case "toolsVersionStatus":
			err = unpopulate(val, "ToolsVersionStatus", &v.ToolsVersionStatus)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &v.VCenterID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineTemplatesList.
func (v VirtualMachineTemplatesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineTemplatesList.
func (v *VirtualMachineTemplatesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineUpdate.
func (v VirtualMachineUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", v.Identity)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineUpdate.
func (v *VirtualMachineUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &v.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineUpdateProperties.
func (v VirtualMachineUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "hardwareProfile", v.HardwareProfile)
	populate(objectMap, "networkProfile", v.NetworkProfile)
	populate(objectMap, "osProfile", v.OSProfile)
	populate(objectMap, "storageProfile", v.StorageProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineUpdateProperties.
func (v *VirtualMachineUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hardwareProfile":
			err = unpopulate(val, "HardwareProfile", &v.HardwareProfile)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &v.NetworkProfile)
			delete(rawMsg, key)
		case "osProfile":
			err = unpopulate(val, "OSProfile", &v.OSProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &v.StorageProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachinesList.
func (v VirtualMachinesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachinesList.
func (v *VirtualMachinesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetwork.
func (v VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "kind", v.Kind)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetwork.
func (v *VirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &v.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkInventoryItem.
func (v VirtualNetworkInventoryItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["inventoryType"] = InventoryTypeVirtualNetwork
	populate(objectMap, "managedResourceId", v.ManagedResourceID)
	populate(objectMap, "moName", v.MoName)
	populate(objectMap, "moRefId", v.MoRefID)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkInventoryItem.
func (v *VirtualNetworkInventoryItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inventoryType":
			err = unpopulate(val, "InventoryType", &v.InventoryType)
			delete(rawMsg, key)
		case "managedResourceId":
			err = unpopulate(val, "ManagedResourceID", &v.ManagedResourceID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &v.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &v.MoRefID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkProperties.
func (v VirtualNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customResourceName", v.CustomResourceName)
	populate(objectMap, "inventoryItemId", v.InventoryItemID)
	populate(objectMap, "moName", v.MoName)
	populate(objectMap, "moRefId", v.MoRefID)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "statuses", v.Statuses)
	populate(objectMap, "uuid", v.UUID)
	populate(objectMap, "vCenterId", v.VCenterID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkProperties.
func (v *VirtualNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customResourceName":
			err = unpopulate(val, "CustomResourceName", &v.CustomResourceName)
			delete(rawMsg, key)
		case "inventoryItemId":
			err = unpopulate(val, "InventoryItemID", &v.InventoryItemID)
			delete(rawMsg, key)
		case "moName":
			err = unpopulate(val, "MoName", &v.MoName)
			delete(rawMsg, key)
		case "moRefId":
			err = unpopulate(val, "MoRefID", &v.MoRefID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &v.Statuses)
			delete(rawMsg, key)
		case "uuid":
			err = unpopulate(val, "UUID", &v.UUID)
			delete(rawMsg, key)
		case "vCenterId":
			err = unpopulate(val, "VCenterID", &v.VCenterID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksList.
func (v VirtualNetworksList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksList.
func (v *VirtualNetworksList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualSCSIController.
func (v VirtualSCSIController) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "busNumber", v.BusNumber)
	populate(objectMap, "controllerKey", v.ControllerKey)
	populate(objectMap, "scsiCtlrUnitNumber", v.ScsiCtlrUnitNumber)
	populate(objectMap, "sharing", v.Sharing)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualSCSIController.
func (v *VirtualSCSIController) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "busNumber":
			err = unpopulate(val, "BusNumber", &v.BusNumber)
			delete(rawMsg, key)
		case "controllerKey":
			err = unpopulate(val, "ControllerKey", &v.ControllerKey)
			delete(rawMsg, key)
		case "scsiCtlrUnitNumber":
			err = unpopulate(val, "ScsiCtlrUnitNumber", &v.ScsiCtlrUnitNumber)
			delete(rawMsg, key)
		case "sharing":
			err = unpopulate(val, "Sharing", &v.Sharing)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsParameters.
func (w WindowsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "classificationsToInclude", w.ClassificationsToInclude)
	populate(objectMap, "excludeKbsRequiringReboot", w.ExcludeKbsRequiringReboot)
	populate(objectMap, "kbNumbersToExclude", w.KbNumbersToExclude)
	populate(objectMap, "kbNumbersToInclude", w.KbNumbersToInclude)
	populateTimeRFC3339(objectMap, "maxPatchPublishDate", w.MaxPatchPublishDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsParameters.
func (w *WindowsParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "classificationsToInclude":
			err = unpopulate(val, "ClassificationsToInclude", &w.ClassificationsToInclude)
			delete(rawMsg, key)
		case "excludeKbsRequiringReboot":
			err = unpopulate(val, "ExcludeKbsRequiringReboot", &w.ExcludeKbsRequiringReboot)
			delete(rawMsg, key)
		case "kbNumbersToExclude":
			err = unpopulate(val, "KbNumbersToExclude", &w.KbNumbersToExclude)
			delete(rawMsg, key)
		case "kbNumbersToInclude":
			err = unpopulate(val, "KbNumbersToInclude", &w.KbNumbersToInclude)
			delete(rawMsg, key)
		case "maxPatchPublishDate":
			err = unpopulateTimeRFC3339(val, "MaxPatchPublishDate", &w.MaxPatchPublishDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
