//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatacatalog

// ADCCatalog - Azure Data Catalog.
type ADCCatalog struct {
	// Resource etag
	Etag *string `json:"etag,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// Azure Data Catalog properties.
	Properties *ADCCatalogProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ADCCatalogProperties - Properties of the data catalog.
type ADCCatalogProperties struct {
	// Azure data catalog admin list.
	Admins []*Principals `json:"admins,omitempty"`

	// Automatic unit adjustment enabled or not.
	EnableAutomaticUnitAdjustment *bool `json:"enableAutomaticUnitAdjustment,omitempty"`

	// Azure data catalog SKU.
	SKU *SKUType `json:"sku,omitempty"`

	// Azure data catalog provision status.
	SuccessfullyProvisioned *bool `json:"successfullyProvisioned,omitempty"`

	// Azure data catalog units.
	Units *int32 `json:"units,omitempty"`

	// Azure data catalog user list.
	Users []*Principals `json:"users,omitempty"`
}

// ADCCatalogsClientBeginDeleteOptions contains the optional parameters for the ADCCatalogsClient.BeginDelete method.
type ADCCatalogsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ADCCatalogsClientCreateOrUpdateOptions contains the optional parameters for the ADCCatalogsClient.CreateOrUpdate method.
type ADCCatalogsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ADCCatalogsClientGetOptions contains the optional parameters for the ADCCatalogsClient.Get method.
type ADCCatalogsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ADCCatalogsClientListtByResourceGroupOptions contains the optional parameters for the ADCCatalogsClient.ListtByResourceGroup
// method.
type ADCCatalogsClientListtByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ADCCatalogsClientUpdateOptions contains the optional parameters for the ADCCatalogsClient.Update method.
type ADCCatalogsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ADCCatalogsListResult - The response from the List Azure Data Catalog operation.
type ADCCatalogsListResult struct {
	// the list of Azure Data Catalogs.
	Value []*ADCCatalog `json:"value,omitempty"`
}

// ADCOperationsClientListOptions contains the optional parameters for the ADCOperationsClient.List method.
type ADCOperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationDisplayInfo - The operation supported by Azure Data Catalog Service.
type OperationDisplayInfo struct {
	// The description of the operation.
	Description *string `json:"description,omitempty"`

	// The action that users can perform, based on their permission level.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Azure Data Catalog Service.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationEntity - The operation supported by Azure Data Catalog Service.
type OperationEntity struct {
	// The operation supported by Azure Data Catalog Service.
	Display *OperationDisplayInfo `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
}

// OperationEntityListResult - The list of Azure data catalog service operation response.
type OperationEntityListResult struct {
	// The list of operations.
	Value []*OperationEntity `json:"value,omitempty"`
}

// Principals - User principals.
type Principals struct {
	// Object Id for the user
	ObjectID *string `json:"objectId,omitempty"`

	// UPN of the user.
	Upn *string `json:"upn,omitempty"`
}

// Resource - The Resource model definition.
type Resource struct {
	// Resource etag
	Etag *string `json:"etag,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}
