// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates routing priority and age on the contact (QueuePriority and
// QueueTimeAdjustmentInSeconds). These properties can be used to change a
// customer's position in the queue. For example, you can move a contact to the
// back of the queue by setting a lower routing priority relative to other contacts
// in queue; or you can move a contact to the front of the queue by increasing the
// routing age which will make the contact look artificially older and therefore
// higher up in the first-in-first-out routing order. Note that adjusting the
// routing age of a contact affects only its position in queue, and not its actual
// queue wait time as reported through metrics. These properties can also be
// updated by using [the Set routing priority / age flow block].
//
// [the Set routing priority / age flow block]: https://docs.aws.amazon.com/connect/latest/adminguide/change-routing-priority.html
func (c *Client) UpdateContactRoutingData(ctx context.Context, params *UpdateContactRoutingDataInput, optFns ...func(*Options)) (*UpdateContactRoutingDataOutput, error) {
	if params == nil {
		params = &UpdateContactRoutingDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateContactRoutingData", params, optFns, c.addOperationUpdateContactRoutingDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateContactRoutingDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateContactRoutingDataInput struct {

	// The identifier of the contact in this instance of Amazon Connect.
	//
	// This member is required.
	ContactId *string

	// The identifier of the Amazon Connect instance. You can [find the instance ID] in the Amazon Resource
	// Name (ARN) of the instance.
	//
	// [find the instance ID]: https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html
	//
	// This member is required.
	InstanceId *string

	// Priority of the contact in the queue. The default priority for new contacts is
	// 5. You can raise the priority of a contact compared to other contacts in the
	// queue by assigning them a higher priority, such as 1 or 2.
	QueuePriority *int64

	// The number of seconds to add or subtract from the contact's routing age.
	// Contacts are routed to agents on a first-come, first-serve basis. This means
	// that changing their amount of time in queue compared to others also changes
	// their position in queue.
	QueueTimeAdjustmentSeconds *int32

	noSmithyDocumentSerde
}

type UpdateContactRoutingDataOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateContactRoutingDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateContactRoutingData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateContactRoutingData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateContactRoutingData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateContactRoutingDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateContactRoutingData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateContactRoutingData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateContactRoutingData",
	}
}
