---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# X-Powered-By header exposes version information

## Description

The target website returns the `X-Powered-By` header and version information of this website. By
exposing these values, attackers may attempt to identify if the target software is vulnerable to known
vulnerabilities, or catalog known sites running particular versions to exploit in the future when a
vulnerability is identified in the particular version.

## Remediation

We recommend that the version information be removed from the `X-Powered-By` header.

PHP:
For PHP based web sites, set the `expose_php` option to `off` in the `php.ini` configuration file.

For all other server types, please consult your product's documentation on how to redact the version
information from the `X-Powered-By` header.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 16.3 | true | 16 | Passive | Low |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/16.html)
- [PHP `expose_php`](https://www.php.net/manual/en/ini.core.php#ini.expose-php)
