/** 
   PostgreSQLPrivate.m <title>PostgreSQLPrivate: various definitions</title>

   Copyright (C) 2005 Free Software Foundation, Inc.

   Date: Jan 2005

   $Revision: 25326 $
   $Date: 2007-07-12 08:39:22 +0200 (Don, 12. Jul 2007) $

   <abstract></abstract>

   This file is part of the GNUstep Database Library.

   <license>
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
   </license>
**/

#include "config.h"

RCS_ID("$Id: PostgreSQLPrivate.m 25326 2007-07-12 06:39:22Z ayers $")

#include <Foundation/Foundation.h>

#ifndef GNUSTEP
#include <GNUstepBase/GNUstep.h>
#include <GNUstepBase/GSCategories.h>
#endif

#include <EOControl/EONull.h>
#include <EOAccess/EOAttribute.h>

// ==== Classes ====
Class PSQLA_NSStringClass=Nil;
Class PSQLA_NSNumberClass=Nil;
Class PSQLA_NSDecimalNumberClass=Nil;
Class PSQLA_NSCalendarDateClass=Nil;
Class PSQLA_NSDateClass=Nil;
Class PSQLA_NSMutableArrayClass;
Class PSQLA_EOAttributeClass=Nil;

// ==== IMPs ====
IMP PSQLA_NSNumber_allocWithZoneIMP=NULL;
IMP PSQLA_NSDecimalNumber_allocWithZoneIMP=NULL;
IMP PSQLA_NSString_allocWithZoneIMP=NULL;
IMP PSQLA_NSCalendarDate_allocWithZoneIMP=NULL;
IMP PSQLA_NSMutableArray_allocWithZoneIMP=NULL;
IMP PSQLA_EOAttribute_allocWithZoneIMP=NULL;

// ==== Constants ====
NSNumber *PSQLA_NSNumberBool_Yes=nil;
NSNumber *PSQLA_NSNumberBool_No=nil;

EONull   *PSQLA_EONull=nil;
NSArray  *PSQLA_NSArray=nil;
NSString *PSQLA_postgresCalendarFormat=@"%Y-%m-%d %H:%M:%S.%F %z";

// ==== Init Method ====
void
PSQLA_PrivInit(void)
{
  static BOOL initialized=NO;
  if (!initialized)
    {
      initialized = YES;

      // ==== Classes ====
      PSQLA_NSMutableArrayClass=[NSMutableArray class];
      PSQLA_NSStringClass=[NSString class];
      PSQLA_NSNumberClass=[NSNumber class];
      PSQLA_NSDecimalNumberClass=[NSDecimalNumber class];
      PSQLA_NSCalendarDateClass=[NSCalendarDate class];
      PSQLA_NSDateClass=[NSDate class];
      PSQLA_EOAttributeClass = [EOAttribute class];

      // ==== IMPs ====
      PSQLA_NSNumber_allocWithZoneIMP=
        [PSQLA_NSNumberClass methodForSelector:@selector(allocWithZone:)];

      PSQLA_NSDecimalNumber_allocWithZoneIMP=
        [PSQLA_NSDecimalNumberClass methodForSelector:@selector(allocWithZone:)];

      PSQLA_NSString_allocWithZoneIMP=
        [PSQLA_NSStringClass methodForSelector:@selector(allocWithZone:)];

      PSQLA_NSCalendarDate_allocWithZoneIMP=
        [PSQLA_NSCalendarDateClass methodForSelector:@selector(allocWithZone:)];

      PSQLA_NSMutableArray_allocWithZoneIMP=
        [PSQLA_NSMutableArrayClass methodForSelector:@selector(allocWithZone:)];

      PSQLA_EOAttribute_allocWithZoneIMP=
        [PSQLA_EOAttributeClass methodForSelector:@selector(allocWithZone:)];


      // ==== Constants ====
      ASSIGN(PSQLA_NSNumberBool_Yes,[PSQLA_NSNumberClass numberWithBool:YES]);
      ASSIGN(PSQLA_NSNumberBool_No,[PSQLA_NSNumberClass numberWithBool:NO]);

      ASSIGN(PSQLA_EONull,[EONull null]);
      ASSIGN(PSQLA_NSArray,[NSArray array]);

    };
}
