// Code generated by smithy-go-codegen DO NOT EDIT.

package mediatailor

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/mediatailor/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new prefetch schedule for the specified playback configuration.
func (c *Client) CreatePrefetchSchedule(ctx context.Context, params *CreatePrefetchScheduleInput, optFns ...func(*Options)) (*CreatePrefetchScheduleOutput, error) {
	if params == nil {
		params = &CreatePrefetchScheduleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePrefetchSchedule", params, optFns, c.addOperationCreatePrefetchScheduleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePrefetchScheduleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePrefetchScheduleInput struct {

	// The configuration settings for MediaTailor's consumption of the prefetched ads
	// from the ad decision server. Each consumption configuration contains an end time
	// and an optional start time that define the consumption window. Prefetch
	// schedules automatically expire no earlier than seven days after the end time.
	//
	// This member is required.
	Consumption *types.PrefetchConsumption

	// The identifier for the playback configuration.
	//
	// This member is required.
	Name *string

	// The name of the playback configuration.
	//
	// This member is required.
	PlaybackConfigurationName *string

	// The configuration settings for retrieval of prefetched ads from the ad decision
	// server. Only one set of prefetched ads will be retrieved and subsequently
	// consumed for each ad break.
	//
	// This member is required.
	Retrieval *types.PrefetchRetrieval

	// An optional stream identifier that MediaTailor uses to prefetch ads for multiple
	// streams that use the same playback configuration. If StreamId is specified,
	// MediaTailor returns all of the prefetch schedules with an exact match on
	// StreamId. If not specified, MediaTailor returns all of the prefetch schedules
	// for the playback configuration, regardless of StreamId.
	StreamId *string

	noSmithyDocumentSerde
}

type CreatePrefetchScheduleOutput struct {

	// The Amazon Resource Name (ARN) of the prefetch schedule.
	Arn *string

	// Consumption settings determine how, and when, MediaTailor places the prefetched
	// ads into ad breaks. Ad consumption occurs within a span of time that you define,
	// called a consumption window. You can designate which ad breaks that MediaTailor
	// fills with prefetch ads by setting avail matching criteria.
	Consumption *types.PrefetchConsumption

	// The name of the prefetch schedule. The name must be unique among all prefetch
	// schedules that are associated with the specified playback configuration.
	Name *string

	// The name of the playback configuration to create the prefetch schedule for.
	PlaybackConfigurationName *string

	// A complex type that contains settings for prefetch retrieval from the ad
	// decision server (ADS).
	Retrieval *types.PrefetchRetrieval

	// An optional stream identifier that you can specify in order to prefetch for
	// multiple streams that use the same playback configuration.
	StreamId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePrefetchScheduleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreatePrefetchSchedule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreatePrefetchSchedule{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreatePrefetchScheduleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePrefetchSchedule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreatePrefetchSchedule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "mediatailor",
		OperationName: "CreatePrefetchSchedule",
	}
}
