// Code generated by smithy-go-codegen DO NOT EDIT.

package wisdom

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Get a URL to upload content to a knowledge base. To upload content, first make a
// PUT request to the returned URL with your file, making sure to include the
// required headers. Then use CreateContent
// (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_CreateContent.html)
// to finalize the content creation process or UpdateContent
// (https://docs.aws.amazon.com/wisdom/latest/APIReference/API_UpdateContent.html)
// to modify an existing resource. You can only upload content to a knowledge base
// of type CUSTOM.
func (c *Client) StartContentUpload(ctx context.Context, params *StartContentUploadInput, optFns ...func(*Options)) (*StartContentUploadOutput, error) {
	if params == nil {
		params = &StartContentUploadInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartContentUpload", params, optFns, c.addOperationStartContentUploadMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartContentUploadOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartContentUploadInput struct {

	// The type of content to upload.
	//
	// This member is required.
	ContentType *string

	// The identifier of the knowledge base. Can be either the ID or the ARN. URLs
	// cannot contain the ARN.
	//
	// This member is required.
	KnowledgeBaseId *string

	noSmithyDocumentSerde
}

type StartContentUploadOutput struct {

	// The headers to include in the upload.
	//
	// This member is required.
	HeadersToInclude map[string]string

	// The identifier of the upload.
	//
	// This member is required.
	UploadId *string

	// The URL of the upload.
	//
	// This member is required.
	Url *string

	// The expiration time of the URL as an epoch timestamp.
	//
	// This member is required.
	UrlExpiry *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartContentUploadMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartContentUpload{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartContentUpload{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartContentUploadValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartContentUpload(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartContentUpload(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "wisdom",
		OperationName: "StartContentUpload",
	}
}
