// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package keyspaces

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateKeyspace = "CreateKeyspace"

// CreateKeyspaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeyspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKeyspace for more information on using the CreateKeyspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKeyspaceRequest method.
//	req, resp := client.CreateKeyspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/CreateKeyspace
func (c *Keyspaces) CreateKeyspaceRequest(input *CreateKeyspaceInput) (req *request.Request, output *CreateKeyspaceOutput) {
	op := &request.Operation{
		Name:       opCreateKeyspace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyspaceInput{}
	}

	output = &CreateKeyspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeyspace API operation for Amazon Keyspaces.
//
// The CreateKeyspace operation adds a new keyspace to your account. In an Amazon
// Web Services account, keyspace names must be unique within each Region.
//
// CreateKeyspace is an asynchronous operation. You can monitor the creation
// status of the new keyspace by using the GetKeyspace operation.
//
// For more information, see Creating keyspaces (https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-keyspaces.html#keyspaces-create)
// in the Amazon Keyspaces Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation CreateKeyspace for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - ConflictException
//     Amazon Keyspaces could not complete the requested action. This error may
//     occur if you try to perform an action and the same or a different action
//     is already in progress, or if you try to create a resource that already exists.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/CreateKeyspace
func (c *Keyspaces) CreateKeyspace(input *CreateKeyspaceInput) (*CreateKeyspaceOutput, error) {
	req, out := c.CreateKeyspaceRequest(input)
	return out, req.Send()
}

// CreateKeyspaceWithContext is the same as CreateKeyspace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) CreateKeyspaceWithContext(ctx aws.Context, input *CreateKeyspaceInput, opts ...request.Option) (*CreateKeyspaceOutput, error) {
	req, out := c.CreateKeyspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTable = "CreateTable"

// CreateTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTable for more information on using the CreateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTableRequest method.
//	req, resp := client.CreateTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/CreateTable
func (c *Keyspaces) CreateTableRequest(input *CreateTableInput) (req *request.Request, output *CreateTableOutput) {
	op := &request.Operation{
		Name:       opCreateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTableInput{}
	}

	output = &CreateTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTable API operation for Amazon Keyspaces.
//
// The CreateTable operation adds a new table to the specified keyspace. Within
// a keyspace, table names must be unique.
//
// CreateTable is an asynchronous operation. When the request is received, the
// status of the table is set to CREATING. You can monitor the creation status
// of the new table by using the GetTable operation, which returns the current
// status of the table. You can start using a table when the status is ACTIVE.
//
// For more information, see Creating tables (https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-tables.html#tables-create)
// in the Amazon Keyspaces Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation CreateTable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - ConflictException
//     Amazon Keyspaces could not complete the requested action. This error may
//     occur if you try to perform an action and the same or a different action
//     is already in progress, or if you try to create a resource that already exists.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/CreateTable
func (c *Keyspaces) CreateTable(input *CreateTableInput) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	return out, req.Send()
}

// CreateTableWithContext is the same as CreateTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) CreateTableWithContext(ctx aws.Context, input *CreateTableInput, opts ...request.Option) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKeyspace = "DeleteKeyspace"

// DeleteKeyspaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKeyspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKeyspace for more information on using the DeleteKeyspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKeyspaceRequest method.
//	req, resp := client.DeleteKeyspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/DeleteKeyspace
func (c *Keyspaces) DeleteKeyspaceRequest(input *DeleteKeyspaceInput) (req *request.Request, output *DeleteKeyspaceOutput) {
	op := &request.Operation{
		Name:       opDeleteKeyspace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyspaceInput{}
	}

	output = &DeleteKeyspaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteKeyspace API operation for Amazon Keyspaces.
//
// The DeleteKeyspace operation deletes a keyspace and all of its tables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation DeleteKeyspace for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - ConflictException
//     Amazon Keyspaces could not complete the requested action. This error may
//     occur if you try to perform an action and the same or a different action
//     is already in progress, or if you try to create a resource that already exists.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/DeleteKeyspace
func (c *Keyspaces) DeleteKeyspace(input *DeleteKeyspaceInput) (*DeleteKeyspaceOutput, error) {
	req, out := c.DeleteKeyspaceRequest(input)
	return out, req.Send()
}

// DeleteKeyspaceWithContext is the same as DeleteKeyspace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKeyspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) DeleteKeyspaceWithContext(ctx aws.Context, input *DeleteKeyspaceInput, opts ...request.Option) (*DeleteKeyspaceOutput, error) {
	req, out := c.DeleteKeyspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTable = "DeleteTable"

// DeleteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTable for more information on using the DeleteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTableRequest method.
//	req, resp := client.DeleteTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/DeleteTable
func (c *Keyspaces) DeleteTableRequest(input *DeleteTableInput) (req *request.Request, output *DeleteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableInput{}
	}

	output = &DeleteTableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTable API operation for Amazon Keyspaces.
//
// The DeleteTable operation deletes a table and all of its data. After a DeleteTable
// request is received, the specified table is in the DELETING state until Amazon
// Keyspaces completes the deletion. If the table is in the ACTIVE state, you
// can delete it. If a table is either in the CREATING or UPDATING states, then
// Amazon Keyspaces returns a ResourceInUseException. If the specified table
// does not exist, Amazon Keyspaces returns a ResourceNotFoundException. If
// the table is already in the DELETING state, no error is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation DeleteTable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - ConflictException
//     Amazon Keyspaces could not complete the requested action. This error may
//     occur if you try to perform an action and the same or a different action
//     is already in progress, or if you try to create a resource that already exists.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/DeleteTable
func (c *Keyspaces) DeleteTable(input *DeleteTableInput) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	return out, req.Send()
}

// DeleteTableWithContext is the same as DeleteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) DeleteTableWithContext(ctx aws.Context, input *DeleteTableInput, opts ...request.Option) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyspace = "GetKeyspace"

// GetKeyspaceRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyspace for more information on using the GetKeyspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKeyspaceRequest method.
//	req, resp := client.GetKeyspaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/GetKeyspace
func (c *Keyspaces) GetKeyspaceRequest(input *GetKeyspaceInput) (req *request.Request, output *GetKeyspaceOutput) {
	op := &request.Operation{
		Name:       opGetKeyspace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyspaceInput{}
	}

	output = &GetKeyspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyspace API operation for Amazon Keyspaces.
//
// Returns the name and the Amazon Resource Name (ARN) of the specified table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation GetKeyspace for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/GetKeyspace
func (c *Keyspaces) GetKeyspace(input *GetKeyspaceInput) (*GetKeyspaceOutput, error) {
	req, out := c.GetKeyspaceRequest(input)
	return out, req.Send()
}

// GetKeyspaceWithContext is the same as GetKeyspace with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) GetKeyspaceWithContext(ctx aws.Context, input *GetKeyspaceInput, opts ...request.Option) (*GetKeyspaceOutput, error) {
	req, out := c.GetKeyspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTable = "GetTable"

// GetTableRequest generates a "aws/request.Request" representing the
// client's request for the GetTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTable for more information on using the GetTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTableRequest method.
//	req, resp := client.GetTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/GetTable
func (c *Keyspaces) GetTableRequest(input *GetTableInput) (req *request.Request, output *GetTableOutput) {
	op := &request.Operation{
		Name:       opGetTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTableInput{}
	}

	output = &GetTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTable API operation for Amazon Keyspaces.
//
// Returns information about the table, including the table's name and current
// status, the keyspace name, configuration settings, and metadata.
//
// To read table metadata using GetTable, Select action permissions for the
// table and system tables are required to complete the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation GetTable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/GetTable
func (c *Keyspaces) GetTable(input *GetTableInput) (*GetTableOutput, error) {
	req, out := c.GetTableRequest(input)
	return out, req.Send()
}

// GetTableWithContext is the same as GetTable with the addition of
// the ability to pass a context and additional request options.
//
// See GetTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) GetTableWithContext(ctx aws.Context, input *GetTableInput, opts ...request.Option) (*GetTableOutput, error) {
	req, out := c.GetTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListKeyspaces = "ListKeyspaces"

// ListKeyspacesRequest generates a "aws/request.Request" representing the
// client's request for the ListKeyspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeyspaces for more information on using the ListKeyspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKeyspacesRequest method.
//	req, resp := client.ListKeyspacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/ListKeyspaces
func (c *Keyspaces) ListKeyspacesRequest(input *ListKeyspacesInput) (req *request.Request, output *ListKeyspacesOutput) {
	op := &request.Operation{
		Name:       opListKeyspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeyspacesInput{}
	}

	output = &ListKeyspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKeyspaces API operation for Amazon Keyspaces.
//
// Returns a list of keyspaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation ListKeyspaces for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/ListKeyspaces
func (c *Keyspaces) ListKeyspaces(input *ListKeyspacesInput) (*ListKeyspacesOutput, error) {
	req, out := c.ListKeyspacesRequest(input)
	return out, req.Send()
}

// ListKeyspacesWithContext is the same as ListKeyspaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeyspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) ListKeyspacesWithContext(ctx aws.Context, input *ListKeyspacesInput, opts ...request.Option) (*ListKeyspacesOutput, error) {
	req, out := c.ListKeyspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKeyspacesPages iterates over the pages of a ListKeyspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeyspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKeyspaces operation.
//	pageNum := 0
//	err := client.ListKeyspacesPages(params,
//	    func(page *keyspaces.ListKeyspacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Keyspaces) ListKeyspacesPages(input *ListKeyspacesInput, fn func(*ListKeyspacesOutput, bool) bool) error {
	return c.ListKeyspacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKeyspacesPagesWithContext same as ListKeyspacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) ListKeyspacesPagesWithContext(ctx aws.Context, input *ListKeyspacesInput, fn func(*ListKeyspacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKeyspacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKeyspacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKeyspacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTables = "ListTables"

// ListTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTables for more information on using the ListTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTablesRequest method.
//	req, resp := client.ListTablesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/ListTables
func (c *Keyspaces) ListTablesRequest(input *ListTablesInput) (req *request.Request, output *ListTablesOutput) {
	op := &request.Operation{
		Name:       opListTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTablesInput{}
	}

	output = &ListTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTables API operation for Amazon Keyspaces.
//
// Returns a list of tables for a specified keyspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation ListTables for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/ListTables
func (c *Keyspaces) ListTables(input *ListTablesInput) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	return out, req.Send()
}

// ListTablesWithContext is the same as ListTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) ListTablesWithContext(ctx aws.Context, input *ListTablesInput, opts ...request.Option) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTablesPages iterates over the pages of a ListTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTables operation.
//	pageNum := 0
//	err := client.ListTablesPages(params,
//	    func(page *keyspaces.ListTablesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Keyspaces) ListTablesPages(input *ListTablesInput, fn func(*ListTablesOutput, bool) bool) error {
	return c.ListTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTablesPagesWithContext same as ListTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) ListTablesPagesWithContext(ctx aws.Context, input *ListTablesInput, fn func(*ListTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/ListTagsForResource
func (c *Keyspaces) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Keyspaces.
//
// Returns a list of all tags associated with the specified Amazon Keyspaces
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/ListTagsForResource
func (c *Keyspaces) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTagsForResource operation.
//	pageNum := 0
//	err := client.ListTagsForResourcePages(params,
//	    func(page *keyspaces.ListTagsForResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Keyspaces) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRestoreTable = "RestoreTable"

// RestoreTableRequest generates a "aws/request.Request" representing the
// client's request for the RestoreTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreTable for more information on using the RestoreTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreTableRequest method.
//	req, resp := client.RestoreTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/RestoreTable
func (c *Keyspaces) RestoreTableRequest(input *RestoreTableInput) (req *request.Request, output *RestoreTableOutput) {
	op := &request.Operation{
		Name:       opRestoreTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableInput{}
	}

	output = &RestoreTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreTable API operation for Amazon Keyspaces.
//
// Restores the specified table to the specified point in time within the earliest_restorable_timestamp
// and the current time. For more information about restore points, see Time
// window for PITR continuous backups (https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_window)
// in the Amazon Keyspaces Developer Guide.
//
// Any number of users can execute up to 4 concurrent restores (any type of
// restore) in a given account.
//
// When you restore using point in time recovery, Amazon Keyspaces restores
// your source table's schema and data to the state based on the selected timestamp
// (day:hour:minute:second) to a new table. The Time to Live (TTL) settings
// are also restored to the state based on the selected timestamp.
//
// In addition to the table's schema, data, and TTL settings, RestoreTable restores
// the capacity mode, encryption, and point-in-time recovery settings from the
// source table. Unlike the table's schema data and TTL settings, which are
// restored based on the selected timestamp, these settings are always restored
// based on the table's settings as of the current time or when the table was
// deleted.
//
// You can also overwrite these settings during restore:
//
// • Read/write capacity mode
//
// • Provisioned throughput capacity settings
//
// • Point-in-time (PITR) settings
//
// • Tags
//
// For more information, see PITR restore settings (https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_settings)
// in the Amazon Keyspaces Developer Guide.
//
// Note that the following settings are not restored, and you must configure
// them manually for the new table:
//
// • Automatic scaling policies (for tables that use provisioned capacity
// mode)
//
// • Identity and Access Management (IAM) policies
//
// • Amazon CloudWatch metrics and alarms
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation RestoreTable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - ConflictException
//     Amazon Keyspaces could not complete the requested action. This error may
//     occur if you try to perform an action and the same or a different action
//     is already in progress, or if you try to create a resource that already exists.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/RestoreTable
func (c *Keyspaces) RestoreTable(input *RestoreTableInput) (*RestoreTableOutput, error) {
	req, out := c.RestoreTableRequest(input)
	return out, req.Send()
}

// RestoreTableWithContext is the same as RestoreTable with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) RestoreTableWithContext(ctx aws.Context, input *RestoreTableInput, opts ...request.Option) (*RestoreTableOutput, error) {
	req, out := c.RestoreTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/TagResource
func (c *Keyspaces) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Keyspaces.
//
// Associates a set of tags with a Amazon Keyspaces resource. You can then activate
// these user-defined tags so that they appear on the Cost Management Console
// for cost allocation tracking. For more information, see Adding tags and labels
// to Amazon Keyspaces resources (https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
// in the Amazon Keyspaces Developer Guide.
//
// For IAM policy examples that show how to control access to Amazon Keyspaces
// resources based on tags, see Amazon Keyspaces resource access based on tags
// (https://docs.aws.amazon.com/keyspaces/latest/devguide/security_iam_id-based-policy-examples-tags)
// in the Amazon Keyspaces Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/TagResource
func (c *Keyspaces) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/UntagResource
func (c *Keyspaces) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Keyspaces.
//
// Removes the association of tags from a Amazon Keyspaces resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - ConflictException
//     Amazon Keyspaces could not complete the requested action. This error may
//     occur if you try to perform an action and the same or a different action
//     is already in progress, or if you try to create a resource that already exists.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/UntagResource
func (c *Keyspaces) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTable = "UpdateTable"

// UpdateTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTable for more information on using the UpdateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTableRequest method.
//	req, resp := client.UpdateTableRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/UpdateTable
func (c *Keyspaces) UpdateTableRequest(input *UpdateTableInput) (req *request.Request, output *UpdateTableOutput) {
	op := &request.Operation{
		Name:       opUpdateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTableInput{}
	}

	output = &UpdateTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTable API operation for Amazon Keyspaces.
//
// Adds new columns to the table or updates one of the table's settings, for
// example capacity mode, encryption, point-in-time recovery, or ttl settings.
// Note that you can only update one specific table setting per update operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Keyspaces's
// API operation UpdateTable for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The operation failed due to an invalid or malformed request.
//
//   - ServiceQuotaExceededException
//     The operation exceeded the service quota for this resource. For more information
//     on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
//     in the Amazon Keyspaces Developer Guide.
//
//   - InternalServerException
//     Amazon Keyspaces was unable to fully process this request because of an internal
//     server error.
//
//   - ConflictException
//     Amazon Keyspaces could not complete the requested action. This error may
//     occur if you try to perform an action and the same or a different action
//     is already in progress, or if you try to create a resource that already exists.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The operation tried to access a keyspace or table that doesn't exist. The
//     resource might not be specified correctly, or its status might not be ACTIVE.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/keyspaces-2022-02-10/UpdateTable
func (c *Keyspaces) UpdateTable(input *UpdateTableInput) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	return out, req.Send()
}

// UpdateTableWithContext is the same as UpdateTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Keyspaces) UpdateTableWithContext(ctx aws.Context, input *UpdateTableInput, opts ...request.Option) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Amazon Keyspaces has two read/write capacity modes for processing reads and
// writes on your tables:
//
// • On-demand (default)
//
// • Provisioned
//
// The read/write capacity mode that you choose controls how you are charged
// for read and write throughput and how table throughput capacity is managed.
//
// For more information, see Read/write capacity modes (https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
// in the Amazon Keyspaces Developer Guide.
type CapacitySpecification struct {
	_ struct{} `type:"structure"`

	// The throughput capacity specified for read operations defined in read capacity
	// units (RCUs).
	ReadCapacityUnits *int64 `locationName:"readCapacityUnits" min:"1" type:"long"`

	// The read/write throughput capacity mode for a table. The options are:
	//
	// • throughputMode:PAY_PER_REQUEST and
	//
	// • throughputMode:PROVISIONED - Provisioned capacity mode requires readCapacityUnits
	// and writeCapacityUnits as input.
	//
	// The default is throughput_mode:PAY_PER_REQUEST.
	//
	// For more information, see Read/write capacity modes (https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
	// in the Amazon Keyspaces Developer Guide.
	//
	// ThroughputMode is a required field
	ThroughputMode *string `locationName:"throughputMode" type:"string" required:"true" enum:"ThroughputMode"`

	// The throughput capacity specified for write operations defined in write capacity
	// units (WCUs).
	WriteCapacityUnits *int64 `locationName:"writeCapacityUnits" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacitySpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacitySpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacitySpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapacitySpecification"}
	if s.ReadCapacityUnits != nil && *s.ReadCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReadCapacityUnits", 1))
	}
	if s.ThroughputMode == nil {
		invalidParams.Add(request.NewErrParamRequired("ThroughputMode"))
	}
	if s.WriteCapacityUnits != nil && *s.WriteCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("WriteCapacityUnits", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *CapacitySpecification) SetReadCapacityUnits(v int64) *CapacitySpecification {
	s.ReadCapacityUnits = &v
	return s
}

// SetThroughputMode sets the ThroughputMode field's value.
func (s *CapacitySpecification) SetThroughputMode(v string) *CapacitySpecification {
	s.ThroughputMode = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *CapacitySpecification) SetWriteCapacityUnits(v int64) *CapacitySpecification {
	s.WriteCapacityUnits = &v
	return s
}

// The read/write throughput capacity mode for a table. The options are:
//
// • throughputMode:PAY_PER_REQUEST and
//
// • throughputMode:PROVISIONED.
//
// For more information, see Read/write capacity modes (https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
// in the Amazon Keyspaces Developer Guide.
type CapacitySpecificationSummary struct {
	_ struct{} `type:"structure"`

	// The timestamp of the last operation that changed the provisioned throughput
	// capacity of a table.
	LastUpdateToPayPerRequestTimestamp *time.Time `locationName:"lastUpdateToPayPerRequestTimestamp" type:"timestamp"`

	// The throughput capacity specified for read operations defined in read capacity
	// units (RCUs).
	ReadCapacityUnits *int64 `locationName:"readCapacityUnits" min:"1" type:"long"`

	// The read/write throughput capacity mode for a table. The options are:
	//
	// • throughputMode:PAY_PER_REQUEST and
	//
	// • throughputMode:PROVISIONED - Provisioned capacity mode requires readCapacityUnits
	// and writeCapacityUnits as input.
	//
	// The default is throughput_mode:PAY_PER_REQUEST.
	//
	// For more information, see Read/write capacity modes (https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
	// in the Amazon Keyspaces Developer Guide.
	//
	// ThroughputMode is a required field
	ThroughputMode *string `locationName:"throughputMode" type:"string" required:"true" enum:"ThroughputMode"`

	// The throughput capacity specified for write operations defined in write capacity
	// units (WCUs).
	WriteCapacityUnits *int64 `locationName:"writeCapacityUnits" min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacitySpecificationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacitySpecificationSummary) GoString() string {
	return s.String()
}

// SetLastUpdateToPayPerRequestTimestamp sets the LastUpdateToPayPerRequestTimestamp field's value.
func (s *CapacitySpecificationSummary) SetLastUpdateToPayPerRequestTimestamp(v time.Time) *CapacitySpecificationSummary {
	s.LastUpdateToPayPerRequestTimestamp = &v
	return s
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *CapacitySpecificationSummary) SetReadCapacityUnits(v int64) *CapacitySpecificationSummary {
	s.ReadCapacityUnits = &v
	return s
}

// SetThroughputMode sets the ThroughputMode field's value.
func (s *CapacitySpecificationSummary) SetThroughputMode(v string) *CapacitySpecificationSummary {
	s.ThroughputMode = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *CapacitySpecificationSummary) SetWriteCapacityUnits(v int64) *CapacitySpecificationSummary {
	s.WriteCapacityUnits = &v
	return s
}

// The optional clustering column portion of your primary key determines how
// the data is clustered and sorted within each partition.
type ClusteringKey struct {
	_ struct{} `type:"structure"`

	// The name(s) of the clustering column(s).
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Sets the ascendant (ASC) or descendant (DESC) order modifier.
	//
	// OrderBy is a required field
	OrderBy *string `locationName:"orderBy" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusteringKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusteringKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClusteringKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClusteringKey"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.OrderBy == nil {
		invalidParams.Add(request.NewErrParamRequired("OrderBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ClusteringKey) SetName(v string) *ClusteringKey {
	s.Name = &v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *ClusteringKey) SetOrderBy(v string) *ClusteringKey {
	s.OrderBy = &v
	return s
}

// The names and data types of regular columns.
type ColumnDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the column.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The data type of the column. For a list of available data types, see Data
	// types (https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types)
	// in the Amazon Keyspaces Developer Guide.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnDefinition"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ColumnDefinition) SetName(v string) *ColumnDefinition {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ColumnDefinition) SetType(v string) *ColumnDefinition {
	s.Type = &v
	return s
}

// An optional comment that describes the table.
type Comment struct {
	_ struct{} `type:"structure"`

	// An optional description of the table.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Comment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Comment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Comment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Comment"}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessage sets the Message field's value.
func (s *Comment) SetMessage(v string) *Comment {
	s.Message = &v
	return s
}

// Amazon Keyspaces could not complete the requested action. This error may
// occur if you try to perform an action and the same or a different action
// is already in progress, or if you try to create a resource that already exists.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateKeyspaceInput struct {
	_ struct{} `type:"structure"`

	// The name of the keyspace to be created.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`

	// A list of key-value pair tags to be attached to the keyspace.
	//
	// For more information, see Adding tags and labels to Amazon Keyspaces resources
	// (https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
	// in the Amazon Keyspaces Developer Guide.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyspaceInput"}
	if s.KeyspaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyspaceName"))
	}
	if s.KeyspaceName != nil && len(*s.KeyspaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyspaceName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *CreateKeyspaceInput) SetKeyspaceName(v string) *CreateKeyspaceInput {
	s.KeyspaceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKeyspaceInput) SetTags(v []*Tag) *CreateKeyspaceInput {
	s.Tags = v
	return s
}

type CreateKeyspaceOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the keyspace in the format of an Amazon Resource
	// Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKeyspaceOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateKeyspaceOutput) SetResourceArn(v string) *CreateKeyspaceOutput {
	s.ResourceArn = &v
	return s
}

type CreateTableInput struct {
	_ struct{} `type:"structure"`

	// Specifies the read/write throughput capacity mode for the table. The options
	// are:
	//
	// • throughputMode:PAY_PER_REQUEST and
	//
	// • throughputMode:PROVISIONED - Provisioned capacity mode requires readCapacityUnits
	// and writeCapacityUnits as input.
	//
	// The default is throughput_mode:PAY_PER_REQUEST.
	//
	// For more information, see Read/write capacity modes (https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
	// in the Amazon Keyspaces Developer Guide.
	CapacitySpecification *CapacitySpecification `locationName:"capacitySpecification" type:"structure"`

	// This parameter allows to enter a description of the table.
	Comment *Comment `locationName:"comment" type:"structure"`

	// The default Time to Live setting in seconds for the table.
	//
	// For more information, see Setting the default TTL value for a table (https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl)
	// in the Amazon Keyspaces Developer Guide.
	DefaultTimeToLive *int64 `locationName:"defaultTimeToLive" min:"1" type:"integer"`

	// Specifies how the encryption key for encryption at rest is managed for the
	// table. You can choose one of the following KMS key (KMS key):
	//
	// • type:AWS_OWNED_KMS_KEY - This key is owned by Amazon Keyspaces.
	//
	// • type:CUSTOMER_MANAGED_KMS_KEY - This key is stored in your account and
	// is created, owned, and managed by you. This option requires the kms_key_identifier
	// of the KMS key in Amazon Resource Name (ARN) format as input.
	//
	// The default is type:AWS_OWNED_KMS_KEY.
	//
	// For more information, see Encryption at rest (https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
	// in the Amazon Keyspaces Developer Guide.
	EncryptionSpecification *EncryptionSpecification `locationName:"encryptionSpecification" type:"structure"`

	// The name of the keyspace that the table is going to be created in.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`

	// Specifies if pointInTimeRecovery is enabled or disabled for the table. The
	// options are:
	//
	// • ENABLED
	//
	// • DISABLED
	//
	// If it's not specified, the default is DISABLED.
	//
	// For more information, see Point-in-time recovery (https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html)
	// in the Amazon Keyspaces Developer Guide.
	PointInTimeRecovery *PointInTimeRecovery `locationName:"pointInTimeRecovery" type:"structure"`

	// The schemaDefinition consists of the following parameters.
	//
	// For each column to be created:
	//
	// • name - The name of the column.
	//
	// • type - An Amazon Keyspaces data type. For more information, see Data
	// types (https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types)
	// in the Amazon Keyspaces Developer Guide.
	//
	// The primary key of the table consists of the following columns:
	//
	// • partitionKeys - The partition key can be a single column, or it can be
	// a compound value composed of two or more columns. The partition key portion
	// of the primary key is required and determines how Amazon Keyspaces stores
	// your data.
	//
	// • name - The name of each partition key column.
	//
	// • clusteringKeys - The optional clustering column portion of your primary
	// key determines how the data is clustered and sorted within each partition.
	//
	// • name - The name of the clustering column.
	//
	// • orderBy - Sets the ascendant (ASC) or descendant (DESC) order modifier.
	//
	// To define a column as static use staticColumns - Static columns store values
	// that are shared by all rows in the same partition:
	//
	// • name - The name of the column.
	//
	// • type - An Amazon Keyspaces data type.
	//
	// SchemaDefinition is a required field
	SchemaDefinition *SchemaDefinition `locationName:"schemaDefinition" type:"structure" required:"true"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" min:"1" type:"string" required:"true"`

	// A list of key-value pair tags to be attached to the resource.
	//
	// For more information, see Adding tags and labels to Amazon Keyspaces resources
	// (https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
	// in the Amazon Keyspaces Developer Guide.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`

	// Enables Time to Live custom settings for the table. The options are:
	//
	// • status:enabled
	//
	// • status:disabled
	//
	// The default is status:disabled. After ttl is enabled, you can't disable it
	// for the table.
	//
	// For more information, see Expiring data by using Amazon Keyspaces Time to
	// Live (TTL) (https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html)
	// in the Amazon Keyspaces Developer Guide.
	Ttl *TimeToLive `locationName:"ttl" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTableInput"}
	if s.DefaultTimeToLive != nil && *s.DefaultTimeToLive < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DefaultTimeToLive", 1))
	}
	if s.KeyspaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyspaceName"))
	}
	if s.KeyspaceName != nil && len(*s.KeyspaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyspaceName", 1))
	}
	if s.SchemaDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaDefinition"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.CapacitySpecification != nil {
		if err := s.CapacitySpecification.Validate(); err != nil {
			invalidParams.AddNested("CapacitySpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.Comment != nil {
		if err := s.Comment.Validate(); err != nil {
			invalidParams.AddNested("Comment", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionSpecification != nil {
		if err := s.EncryptionSpecification.Validate(); err != nil {
			invalidParams.AddNested("EncryptionSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PointInTimeRecovery != nil {
		if err := s.PointInTimeRecovery.Validate(); err != nil {
			invalidParams.AddNested("PointInTimeRecovery", err.(request.ErrInvalidParams))
		}
	}
	if s.SchemaDefinition != nil {
		if err := s.SchemaDefinition.Validate(); err != nil {
			invalidParams.AddNested("SchemaDefinition", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Ttl != nil {
		if err := s.Ttl.Validate(); err != nil {
			invalidParams.AddNested("Ttl", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacitySpecification sets the CapacitySpecification field's value.
func (s *CreateTableInput) SetCapacitySpecification(v *CapacitySpecification) *CreateTableInput {
	s.CapacitySpecification = v
	return s
}

// SetComment sets the Comment field's value.
func (s *CreateTableInput) SetComment(v *Comment) *CreateTableInput {
	s.Comment = v
	return s
}

// SetDefaultTimeToLive sets the DefaultTimeToLive field's value.
func (s *CreateTableInput) SetDefaultTimeToLive(v int64) *CreateTableInput {
	s.DefaultTimeToLive = &v
	return s
}

// SetEncryptionSpecification sets the EncryptionSpecification field's value.
func (s *CreateTableInput) SetEncryptionSpecification(v *EncryptionSpecification) *CreateTableInput {
	s.EncryptionSpecification = v
	return s
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *CreateTableInput) SetKeyspaceName(v string) *CreateTableInput {
	s.KeyspaceName = &v
	return s
}

// SetPointInTimeRecovery sets the PointInTimeRecovery field's value.
func (s *CreateTableInput) SetPointInTimeRecovery(v *PointInTimeRecovery) *CreateTableInput {
	s.PointInTimeRecovery = v
	return s
}

// SetSchemaDefinition sets the SchemaDefinition field's value.
func (s *CreateTableInput) SetSchemaDefinition(v *SchemaDefinition) *CreateTableInput {
	s.SchemaDefinition = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CreateTableInput) SetTableName(v string) *CreateTableInput {
	s.TableName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTableInput) SetTags(v []*Tag) *CreateTableInput {
	s.Tags = v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *CreateTableInput) SetTtl(v *TimeToLive) *CreateTableInput {
	s.Ttl = v
	return s
}

type CreateTableOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the table in the format of an Amazon Resource Name
	// (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTableOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateTableOutput) SetResourceArn(v string) *CreateTableOutput {
	s.ResourceArn = &v
	return s
}

type DeleteKeyspaceInput struct {
	_ struct{} `type:"structure"`

	// The name of the keyspace to be deleted.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeyspaceInput"}
	if s.KeyspaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyspaceName"))
	}
	if s.KeyspaceName != nil && len(*s.KeyspaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyspaceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *DeleteKeyspaceInput) SetKeyspaceName(v string) *DeleteKeyspaceInput {
	s.KeyspaceName = &v
	return s
}

type DeleteKeyspaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKeyspaceOutput) GoString() string {
	return s.String()
}

type DeleteTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the keyspace of the to be deleted table.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`

	// The name of the table to be deleted.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTableInput"}
	if s.KeyspaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyspaceName"))
	}
	if s.KeyspaceName != nil && len(*s.KeyspaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyspaceName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *DeleteTableInput) SetKeyspaceName(v string) *DeleteTableInput {
	s.KeyspaceName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DeleteTableInput) SetTableName(v string) *DeleteTableInput {
	s.TableName = &v
	return s
}

type DeleteTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTableOutput) GoString() string {
	return s.String()
}

// Amazon Keyspaces encrypts and decrypts the table data at rest transparently
// and integrates with Key Management Service for storing and managing the encryption
// key. You can choose one of the following KMS keys (KMS keys):
//
// • Amazon Web Services owned key - This is the default encryption type.
// The key is owned by Amazon Keyspaces (no additional charge).
//
// • Customer managed key - This key is stored in your account and is created,
// owned, and managed by you. You have full control over the customer managed
// key (KMS charges apply).
//
// For more information about encryption at rest in Amazon Keyspaces, see Encryption
// at rest (https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
// in the Amazon Keyspaces Developer Guide.
//
// For more information about KMS, see KMS management service concepts (https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
// in the Key Management Service Developer Guide.
type EncryptionSpecification struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the customer managed KMS key, for example
	// kms_key_identifier:ARN.
	KmsKeyIdentifier *string `locationName:"kmsKeyIdentifier" min:"1" type:"string"`

	// The encryption option specified for the table. You can choose one of the
	// following KMS keys (KMS keys):
	//
	// • type:AWS_OWNED_KMS_KEY - This key is owned by Amazon Keyspaces.
	//
	// • type:CUSTOMER_MANAGED_KMS_KEY - This key is stored in your account and
	// is created, owned, and managed by you. This option requires the kms_key_identifier
	// of the KMS key in Amazon Resource Name (ARN) format as input.
	//
	// The default is type:AWS_OWNED_KMS_KEY.
	//
	// For more information, see Encryption at rest (https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
	// in the Amazon Keyspaces Developer Guide.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EncryptionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionSpecification"}
	if s.KmsKeyIdentifier != nil && len(*s.KmsKeyIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyIdentifier", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyIdentifier sets the KmsKeyIdentifier field's value.
func (s *EncryptionSpecification) SetKmsKeyIdentifier(v string) *EncryptionSpecification {
	s.KmsKeyIdentifier = &v
	return s
}

// SetType sets the Type field's value.
func (s *EncryptionSpecification) SetType(v string) *EncryptionSpecification {
	s.Type = &v
	return s
}

type GetKeyspaceInput struct {
	_ struct{} `type:"structure"`

	// The name of the keyspace.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyspaceInput"}
	if s.KeyspaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyspaceName"))
	}
	if s.KeyspaceName != nil && len(*s.KeyspaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyspaceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *GetKeyspaceInput) SetKeyspaceName(v string) *GetKeyspaceInput {
	s.KeyspaceName = &v
	return s
}

type GetKeyspaceOutput struct {
	_ struct{} `type:"structure"`

	// The name of the keyspace.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`

	// The ARN of the keyspace.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKeyspaceOutput) GoString() string {
	return s.String()
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *GetKeyspaceOutput) SetKeyspaceName(v string) *GetKeyspaceOutput {
	s.KeyspaceName = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetKeyspaceOutput) SetResourceArn(v string) *GetKeyspaceOutput {
	s.ResourceArn = &v
	return s
}

type GetTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the keyspace that the table is stored in.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTableInput"}
	if s.KeyspaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyspaceName"))
	}
	if s.KeyspaceName != nil && len(*s.KeyspaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyspaceName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *GetTableInput) SetKeyspaceName(v string) *GetTableInput {
	s.KeyspaceName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetTableInput) SetTableName(v string) *GetTableInput {
	s.TableName = &v
	return s
}

type GetTableOutput struct {
	_ struct{} `type:"structure"`

	// The read/write throughput capacity mode for a table. The options are:
	//
	// • throughputMode:PAY_PER_REQUEST
	//
	// • throughputMode:PROVISIONED
	CapacitySpecification *CapacitySpecificationSummary `locationName:"capacitySpecification" type:"structure"`

	// The the description of the specified table.
	Comment *Comment `locationName:"comment" type:"structure"`

	// The creation timestamp of the specified table.
	CreationTimestamp *time.Time `locationName:"creationTimestamp" type:"timestamp"`

	// The default Time to Live settings of the specified table.
	DefaultTimeToLive *int64 `locationName:"defaultTimeToLive" min:"1" type:"integer"`

	// The encryption settings of the specified table.
	EncryptionSpecification *EncryptionSpecification `locationName:"encryptionSpecification" type:"structure"`

	// The name of the keyspace that the specified table is stored in.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`

	// The point-in-time recovery status of the specified table.
	PointInTimeRecovery *PointInTimeRecoverySummary `locationName:"pointInTimeRecovery" type:"structure"`

	// The Amazon Resource Name (ARN) of the specified table.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The schema definition of the specified table.
	SchemaDefinition *SchemaDefinition `locationName:"schemaDefinition" type:"structure"`

	// The current status of the specified table.
	Status *string `locationName:"status" type:"string" enum:"TableStatus"`

	// The name of the specified table.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" min:"1" type:"string" required:"true"`

	// The custom Time to Live settings of the specified table.
	Ttl *TimeToLive `locationName:"ttl" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableOutput) GoString() string {
	return s.String()
}

// SetCapacitySpecification sets the CapacitySpecification field's value.
func (s *GetTableOutput) SetCapacitySpecification(v *CapacitySpecificationSummary) *GetTableOutput {
	s.CapacitySpecification = v
	return s
}

// SetComment sets the Comment field's value.
func (s *GetTableOutput) SetComment(v *Comment) *GetTableOutput {
	s.Comment = v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *GetTableOutput) SetCreationTimestamp(v time.Time) *GetTableOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDefaultTimeToLive sets the DefaultTimeToLive field's value.
func (s *GetTableOutput) SetDefaultTimeToLive(v int64) *GetTableOutput {
	s.DefaultTimeToLive = &v
	return s
}

// SetEncryptionSpecification sets the EncryptionSpecification field's value.
func (s *GetTableOutput) SetEncryptionSpecification(v *EncryptionSpecification) *GetTableOutput {
	s.EncryptionSpecification = v
	return s
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *GetTableOutput) SetKeyspaceName(v string) *GetTableOutput {
	s.KeyspaceName = &v
	return s
}

// SetPointInTimeRecovery sets the PointInTimeRecovery field's value.
func (s *GetTableOutput) SetPointInTimeRecovery(v *PointInTimeRecoverySummary) *GetTableOutput {
	s.PointInTimeRecovery = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetTableOutput) SetResourceArn(v string) *GetTableOutput {
	s.ResourceArn = &v
	return s
}

// SetSchemaDefinition sets the SchemaDefinition field's value.
func (s *GetTableOutput) SetSchemaDefinition(v *SchemaDefinition) *GetTableOutput {
	s.SchemaDefinition = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTableOutput) SetStatus(v string) *GetTableOutput {
	s.Status = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetTableOutput) SetTableName(v string) *GetTableOutput {
	s.TableName = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *GetTableOutput) SetTtl(v *TimeToLive) *GetTableOutput {
	s.Ttl = v
	return s
}

// Amazon Keyspaces was unable to fully process this request because of an internal
// server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the properties of a keyspace.
type KeyspaceSummary struct {
	_ struct{} `type:"structure"`

	// The name of the keyspace.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`

	// The unique identifier of the keyspace in the format of an Amazon Resource
	// Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyspaceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyspaceSummary) GoString() string {
	return s.String()
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *KeyspaceSummary) SetKeyspaceName(v string) *KeyspaceSummary {
	s.KeyspaceName = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *KeyspaceSummary) SetResourceArn(v string) *KeyspaceSummary {
	s.ResourceArn = &v
	return s
}

type ListKeyspacesInput struct {
	_ struct{} `type:"structure"`

	// The total number of keyspaces to return in the output. If the total number
	// of keyspaces available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as an argument
	// of a subsequent API invocation.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token. To resume pagination, provide the NextToken value as
	// argument of a subsequent API invocation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeyspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeyspacesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKeyspacesInput) SetMaxResults(v int64) *ListKeyspacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeyspacesInput) SetNextToken(v string) *ListKeyspacesInput {
	s.NextToken = &v
	return s
}

type ListKeyspacesOutput struct {
	_ struct{} `type:"structure"`

	// A list of keyspaces.
	//
	// Keyspaces is a required field
	Keyspaces []*KeyspaceSummary `locationName:"keyspaces" type:"list" required:"true"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKeyspacesOutput) GoString() string {
	return s.String()
}

// SetKeyspaces sets the Keyspaces field's value.
func (s *ListKeyspacesOutput) SetKeyspaces(v []*KeyspaceSummary) *ListKeyspacesOutput {
	s.Keyspaces = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeyspacesOutput) SetNextToken(v string) *ListKeyspacesOutput {
	s.NextToken = &v
	return s
}

type ListTablesInput struct {
	_ struct{} `type:"structure"`

	// The name of the keyspace.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`

	// The total number of tables to return in the output. If the total number of
	// tables available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as an argument
	// of a subsequent API invocation.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token. To resume pagination, provide the NextToken value as
	// an argument of a subsequent API invocation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTablesInput"}
	if s.KeyspaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyspaceName"))
	}
	if s.KeyspaceName != nil && len(*s.KeyspaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyspaceName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *ListTablesInput) SetKeyspaceName(v string) *ListTablesInput {
	s.KeyspaceName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTablesInput) SetMaxResults(v int64) *ListTablesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesInput) SetNextToken(v string) *ListTablesInput {
	s.NextToken = &v
	return s
}

type ListTablesOutput struct {
	_ struct{} `type:"structure"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of tables.
	Tables []*TableSummary `locationName:"tables" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTablesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTablesOutput) SetNextToken(v string) *ListTablesOutput {
	s.NextToken = &v
	return s
}

// SetTables sets the Tables field's value.
func (s *ListTablesOutput) SetTables(v []*TableSummary) *ListTablesOutput {
	s.Tables = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The total number of tags to return in the output. If the total number of
	// tags available is more than the value specified, a NextToken is provided
	// in the output. To resume pagination, provide the NextToken value as an argument
	// of a subsequent API invocation.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token. To resume pagination, provide the NextToken value as
	// argument of a subsequent API invocation.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A token to specify where to start paginating. This is the NextToken from
	// a previously truncated response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of tags.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The partition key portion of the primary key is required and determines how
// Amazon Keyspaces stores the data. The partition key can be a single column,
// or it can be a compound value composed of two or more columns.
type PartitionKey struct {
	_ struct{} `type:"structure"`

	// The name(s) of the partition key column(s).
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartitionKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PartitionKey) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PartitionKey) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PartitionKey"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *PartitionKey) SetName(v string) *PartitionKey {
	s.Name = &v
	return s
}

// Point-in-time recovery (PITR) helps protect your Amazon Keyspaces tables
// from accidental write or delete operations by providing you continuous backups
// of your table data.
//
// For more information, see Point-in-time recovery (https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html)
// in the Amazon Keyspaces Developer Guide.
type PointInTimeRecovery struct {
	_ struct{} `type:"structure"`

	// The options are:
	//
	// • ENABLED
	//
	// • DISABLED
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"PointInTimeRecoveryStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PointInTimeRecovery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PointInTimeRecovery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PointInTimeRecovery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PointInTimeRecovery"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *PointInTimeRecovery) SetStatus(v string) *PointInTimeRecovery {
	s.Status = &v
	return s
}

// The point-in-time recovery status of the specified table.
type PointInTimeRecoverySummary struct {
	_ struct{} `type:"structure"`

	// Specifies the earliest possible restore point of the table in ISO 8601 format.
	EarliestRestorableTimestamp *time.Time `locationName:"earliestRestorableTimestamp" type:"timestamp"`

	// Shows if point-in-time recovery is enabled or disabled for the specified
	// table.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"PointInTimeRecoveryStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PointInTimeRecoverySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PointInTimeRecoverySummary) GoString() string {
	return s.String()
}

// SetEarliestRestorableTimestamp sets the EarliestRestorableTimestamp field's value.
func (s *PointInTimeRecoverySummary) SetEarliestRestorableTimestamp(v time.Time) *PointInTimeRecoverySummary {
	s.EarliestRestorableTimestamp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PointInTimeRecoverySummary) SetStatus(v string) *PointInTimeRecoverySummary {
	s.Status = &v
	return s
}

// The operation tried to access a keyspace or table that doesn't exist. The
// resource might not be specified correctly, or its status might not be ACTIVE.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The unique identifier in the format of Amazon Resource Name (ARN), for the
	// resource not found.
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestoreTableInput struct {
	_ struct{} `type:"structure"`

	// Specifies the read/write throughput capacity mode for the target table. The
	// options are:
	//
	// • throughputMode:PAY_PER_REQUEST
	//
	// • throughputMode:PROVISIONED - Provisioned capacity mode requires readCapacityUnits
	// and writeCapacityUnits as input.
	//
	// The default is throughput_mode:PAY_PER_REQUEST.
	//
	// For more information, see Read/write capacity modes (https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
	// in the Amazon Keyspaces Developer Guide.
	CapacitySpecificationOverride *CapacitySpecification `locationName:"capacitySpecificationOverride" type:"structure"`

	// Specifies the encryption settings for the target table. You can choose one
	// of the following KMS key (KMS key):
	//
	// • type:AWS_OWNED_KMS_KEY - This key is owned by Amazon Keyspaces.
	//
	// • type:CUSTOMER_MANAGED_KMS_KEY - This key is stored in your account and
	// is created, owned, and managed by you. This option requires the kms_key_identifier
	// of the KMS key in Amazon Resource Name (ARN) format as input.
	//
	// The default is type:AWS_OWNED_KMS_KEY.
	//
	// For more information, see Encryption at rest (https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
	// in the Amazon Keyspaces Developer Guide.
	EncryptionSpecificationOverride *EncryptionSpecification `locationName:"encryptionSpecificationOverride" type:"structure"`

	// Specifies the pointInTimeRecovery settings for the target table. The options
	// are:
	//
	// • ENABLED
	//
	// • DISABLED
	//
	// If it's not specified, the default is DISABLED.
	//
	// For more information, see Point-in-time recovery (https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html)
	// in the Amazon Keyspaces Developer Guide.
	PointInTimeRecoveryOverride *PointInTimeRecovery `locationName:"pointInTimeRecoveryOverride" type:"structure"`

	// The restore timestamp in ISO 8601 format.
	RestoreTimestamp *time.Time `locationName:"restoreTimestamp" type:"timestamp"`

	// The keyspace name of the source table.
	//
	// SourceKeyspaceName is a required field
	SourceKeyspaceName *string `locationName:"sourceKeyspaceName" min:"1" type:"string" required:"true"`

	// The name of the source table.
	//
	// SourceTableName is a required field
	SourceTableName *string `locationName:"sourceTableName" min:"1" type:"string" required:"true"`

	// A list of key-value pair tags to be attached to the restored table.
	//
	// For more information, see Adding tags and labels to Amazon Keyspaces resources
	// (https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
	// in the Amazon Keyspaces Developer Guide.
	TagsOverride []*Tag `locationName:"tagsOverride" min:"1" type:"list"`

	// The name of the target keyspace.
	//
	// TargetKeyspaceName is a required field
	TargetKeyspaceName *string `locationName:"targetKeyspaceName" min:"1" type:"string" required:"true"`

	// The name of the target table.
	//
	// TargetTableName is a required field
	TargetTableName *string `locationName:"targetTableName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreTableInput"}
	if s.SourceKeyspaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceKeyspaceName"))
	}
	if s.SourceKeyspaceName != nil && len(*s.SourceKeyspaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceKeyspaceName", 1))
	}
	if s.SourceTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceTableName"))
	}
	if s.SourceTableName != nil && len(*s.SourceTableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceTableName", 1))
	}
	if s.TagsOverride != nil && len(s.TagsOverride) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagsOverride", 1))
	}
	if s.TargetKeyspaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetKeyspaceName"))
	}
	if s.TargetKeyspaceName != nil && len(*s.TargetKeyspaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetKeyspaceName", 1))
	}
	if s.TargetTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetTableName"))
	}
	if s.TargetTableName != nil && len(*s.TargetTableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetTableName", 1))
	}
	if s.CapacitySpecificationOverride != nil {
		if err := s.CapacitySpecificationOverride.Validate(); err != nil {
			invalidParams.AddNested("CapacitySpecificationOverride", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionSpecificationOverride != nil {
		if err := s.EncryptionSpecificationOverride.Validate(); err != nil {
			invalidParams.AddNested("EncryptionSpecificationOverride", err.(request.ErrInvalidParams))
		}
	}
	if s.PointInTimeRecoveryOverride != nil {
		if err := s.PointInTimeRecoveryOverride.Validate(); err != nil {
			invalidParams.AddNested("PointInTimeRecoveryOverride", err.(request.ErrInvalidParams))
		}
	}
	if s.TagsOverride != nil {
		for i, v := range s.TagsOverride {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsOverride", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacitySpecificationOverride sets the CapacitySpecificationOverride field's value.
func (s *RestoreTableInput) SetCapacitySpecificationOverride(v *CapacitySpecification) *RestoreTableInput {
	s.CapacitySpecificationOverride = v
	return s
}

// SetEncryptionSpecificationOverride sets the EncryptionSpecificationOverride field's value.
func (s *RestoreTableInput) SetEncryptionSpecificationOverride(v *EncryptionSpecification) *RestoreTableInput {
	s.EncryptionSpecificationOverride = v
	return s
}

// SetPointInTimeRecoveryOverride sets the PointInTimeRecoveryOverride field's value.
func (s *RestoreTableInput) SetPointInTimeRecoveryOverride(v *PointInTimeRecovery) *RestoreTableInput {
	s.PointInTimeRecoveryOverride = v
	return s
}

// SetRestoreTimestamp sets the RestoreTimestamp field's value.
func (s *RestoreTableInput) SetRestoreTimestamp(v time.Time) *RestoreTableInput {
	s.RestoreTimestamp = &v
	return s
}

// SetSourceKeyspaceName sets the SourceKeyspaceName field's value.
func (s *RestoreTableInput) SetSourceKeyspaceName(v string) *RestoreTableInput {
	s.SourceKeyspaceName = &v
	return s
}

// SetSourceTableName sets the SourceTableName field's value.
func (s *RestoreTableInput) SetSourceTableName(v string) *RestoreTableInput {
	s.SourceTableName = &v
	return s
}

// SetTagsOverride sets the TagsOverride field's value.
func (s *RestoreTableInput) SetTagsOverride(v []*Tag) *RestoreTableInput {
	s.TagsOverride = v
	return s
}

// SetTargetKeyspaceName sets the TargetKeyspaceName field's value.
func (s *RestoreTableInput) SetTargetKeyspaceName(v string) *RestoreTableInput {
	s.TargetKeyspaceName = &v
	return s
}

// SetTargetTableName sets the TargetTableName field's value.
func (s *RestoreTableInput) SetTargetTableName(v string) *RestoreTableInput {
	s.TargetTableName = &v
	return s
}

type RestoreTableOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the restored table.
	//
	// RestoredTableARN is a required field
	RestoredTableARN *string `locationName:"restoredTableARN" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableOutput) GoString() string {
	return s.String()
}

// SetRestoredTableARN sets the RestoredTableARN field's value.
func (s *RestoreTableOutput) SetRestoredTableARN(v string) *RestoreTableOutput {
	s.RestoredTableARN = &v
	return s
}

// Describes the schema of the table.
type SchemaDefinition struct {
	_ struct{} `type:"structure"`

	// The regular columns of the table.
	//
	// AllColumns is a required field
	AllColumns []*ColumnDefinition `locationName:"allColumns" min:"1" type:"list" required:"true"`

	// The columns that are part of the clustering key of the table.
	ClusteringKeys []*ClusteringKey `locationName:"clusteringKeys" type:"list"`

	// The columns that are part of the partition key of the table .
	//
	// PartitionKeys is a required field
	PartitionKeys []*PartitionKey `locationName:"partitionKeys" min:"1" type:"list" required:"true"`

	// The columns that have been defined as STATIC. Static columns store values
	// that are shared by all rows in the same partition.
	StaticColumns []*StaticColumn `locationName:"staticColumns" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SchemaDefinition"}
	if s.AllColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("AllColumns"))
	}
	if s.AllColumns != nil && len(s.AllColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AllColumns", 1))
	}
	if s.PartitionKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionKeys"))
	}
	if s.PartitionKeys != nil && len(s.PartitionKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PartitionKeys", 1))
	}
	if s.AllColumns != nil {
		for i, v := range s.AllColumns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AllColumns", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ClusteringKeys != nil {
		for i, v := range s.ClusteringKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ClusteringKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.PartitionKeys != nil {
		for i, v := range s.PartitionKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StaticColumns != nil {
		for i, v := range s.StaticColumns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StaticColumns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllColumns sets the AllColumns field's value.
func (s *SchemaDefinition) SetAllColumns(v []*ColumnDefinition) *SchemaDefinition {
	s.AllColumns = v
	return s
}

// SetClusteringKeys sets the ClusteringKeys field's value.
func (s *SchemaDefinition) SetClusteringKeys(v []*ClusteringKey) *SchemaDefinition {
	s.ClusteringKeys = v
	return s
}

// SetPartitionKeys sets the PartitionKeys field's value.
func (s *SchemaDefinition) SetPartitionKeys(v []*PartitionKey) *SchemaDefinition {
	s.PartitionKeys = v
	return s
}

// SetStaticColumns sets the StaticColumns field's value.
func (s *SchemaDefinition) SetStaticColumns(v []*StaticColumn) *SchemaDefinition {
	s.StaticColumns = v
	return s
}

// The operation exceeded the service quota for this resource. For more information
// on service quotas, see Quotas (https://docs.aws.amazon.com/keyspaces/latest/devguide/quotas.html)
// in the Amazon Keyspaces Developer Guide.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The static columns of the table. Static columns store values that are shared
// by all rows in the same partition.
type StaticColumn struct {
	_ struct{} `type:"structure"`

	// The name of the static column.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StaticColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StaticColumn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StaticColumn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StaticColumn"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StaticColumn) SetName(v string) *StaticColumn {
	s.Name = &v
	return s
}

// Returns the name of the specified table, the keyspace it is stored in, and
// the unique identifier in the format of an Amazon Resource Name (ARN).
type TableSummary struct {
	_ struct{} `type:"structure"`

	// The name of the keyspace that the table is stored in.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`

	// The unique identifier of the table in the format of an Amazon Resource Name
	// (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableSummary) GoString() string {
	return s.String()
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *TableSummary) SetKeyspaceName(v string) *TableSummary {
	s.KeyspaceName = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TableSummary) SetResourceArn(v string) *TableSummary {
	s.ResourceArn = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TableSummary) SetTableName(v string) *TableSummary {
	s.TableName = &v
	return s
}

// Describes a tag. A tag is a key-value pair. You can add up to 50 tags to
// a single Amazon Keyspaces resource.
//
// Amazon Web Services-assigned tag names and values are automatically assigned
// the aws: prefix, which the user cannot assign. Amazon Web Services-assigned
// tag names do not count towards the tag limit of 50. User-assigned tag names
// have the prefix user: in the Cost Allocation Report. You cannot backdate
// the application of a tag.
//
// For more information, see Adding tags and labels to Amazon Keyspaces resources
// (https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
// in the Amazon Keyspaces Developer Guide.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag. Tag keys are case sensitive. Each Amazon Keyspaces resource
	// can only have up to one tag with the same key. If you try to add an existing
	// tag (same key), the existing tag value will be updated to the new value.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of the tag. Tag values are case-sensitive and can be null.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which
	// to add tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The tags to be assigned to the Amazon Keyspaces resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Enable custom Time to Live (TTL) settings for rows and columns without setting
// a TTL default for the specified table.
//
// For more information, see Enabling TTL on tables (https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_enabling)
// in the Amazon Keyspaces Developer Guide.
type TimeToLive struct {
	_ struct{} `type:"structure"`

	// Shows how to enable custom Time to Live (TTL) settings for the specified
	// table.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TimeToLiveStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeToLive) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeToLive) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeToLive) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeToLive"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *TimeToLive) SetStatus(v string) *TimeToLive {
	s.Status = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Keyspaces resource that the tags will be removed from. This value
	// is an Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// A list of existing tags to be removed from the Amazon Keyspaces resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UntagResourceInput) SetTags(v []*Tag) *UntagResourceInput {
	s.Tags = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateTableInput struct {
	_ struct{} `type:"structure"`

	// For each column to be added to the specified table:
	//
	// • name - The name of the column.
	//
	// • type - An Amazon Keyspaces data type. For more information, see Data
	// types (https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types)
	// in the Amazon Keyspaces Developer Guide.
	AddColumns []*ColumnDefinition `locationName:"addColumns" min:"1" type:"list"`

	// Modifies the read/write throughput capacity mode for the table. The options
	// are:
	//
	// • throughputMode:PAY_PER_REQUEST and
	//
	// • throughputMode:PROVISIONED - Provisioned capacity mode requires readCapacityUnits
	// and writeCapacityUnits as input.
	//
	// The default is throughput_mode:PAY_PER_REQUEST.
	//
	// For more information, see Read/write capacity modes (https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
	// in the Amazon Keyspaces Developer Guide.
	CapacitySpecification *CapacitySpecification `locationName:"capacitySpecification" type:"structure"`

	// The default Time to Live setting in seconds for the table.
	//
	// For more information, see Setting the default TTL value for a table (https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl)
	// in the Amazon Keyspaces Developer Guide.
	DefaultTimeToLive *int64 `locationName:"defaultTimeToLive" min:"1" type:"integer"`

	// Modifies the encryption settings of the table. You can choose one of the
	// following KMS key (KMS key):
	//
	// • type:AWS_OWNED_KMS_KEY - This key is owned by Amazon Keyspaces.
	//
	// • type:CUSTOMER_MANAGED_KMS_KEY - This key is stored in your account and
	// is created, owned, and managed by you. This option requires the kms_key_identifier
	// of the KMS key in Amazon Resource Name (ARN) format as input.
	//
	// The default is AWS_OWNED_KMS_KEY.
	//
	// For more information, see Encryption at rest (https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
	// in the Amazon Keyspaces Developer Guide.
	EncryptionSpecification *EncryptionSpecification `locationName:"encryptionSpecification" type:"structure"`

	// The name of the keyspace the specified table is stored in.
	//
	// KeyspaceName is a required field
	KeyspaceName *string `locationName:"keyspaceName" min:"1" type:"string" required:"true"`

	// Modifies the pointInTimeRecovery settings of the table. The options are:
	//
	// • ENABLED
	//
	// • DISABLED
	//
	// If it's not specified, the default is DISABLED.
	//
	// For more information, see Point-in-time recovery (https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html)
	// in the Amazon Keyspaces Developer Guide.
	PointInTimeRecovery *PointInTimeRecovery `locationName:"pointInTimeRecovery" type:"structure"`

	// The name of the table.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" min:"1" type:"string" required:"true"`

	// Modifies Time to Live custom settings for the table. The options are:
	//
	// • status:enabled
	//
	// • status:disabled
	//
	// The default is status:disabled. After ttl is enabled, you can't disable it
	// for the table.
	//
	// For more information, see Expiring data by using Amazon Keyspaces Time to
	// Live (TTL) (https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html)
	// in the Amazon Keyspaces Developer Guide.
	Ttl *TimeToLive `locationName:"ttl" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTableInput"}
	if s.AddColumns != nil && len(s.AddColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddColumns", 1))
	}
	if s.DefaultTimeToLive != nil && *s.DefaultTimeToLive < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DefaultTimeToLive", 1))
	}
	if s.KeyspaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyspaceName"))
	}
	if s.KeyspaceName != nil && len(*s.KeyspaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyspaceName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.AddColumns != nil {
		for i, v := range s.AddColumns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddColumns", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CapacitySpecification != nil {
		if err := s.CapacitySpecification.Validate(); err != nil {
			invalidParams.AddNested("CapacitySpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionSpecification != nil {
		if err := s.EncryptionSpecification.Validate(); err != nil {
			invalidParams.AddNested("EncryptionSpecification", err.(request.ErrInvalidParams))
		}
	}
	if s.PointInTimeRecovery != nil {
		if err := s.PointInTimeRecovery.Validate(); err != nil {
			invalidParams.AddNested("PointInTimeRecovery", err.(request.ErrInvalidParams))
		}
	}
	if s.Ttl != nil {
		if err := s.Ttl.Validate(); err != nil {
			invalidParams.AddNested("Ttl", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddColumns sets the AddColumns field's value.
func (s *UpdateTableInput) SetAddColumns(v []*ColumnDefinition) *UpdateTableInput {
	s.AddColumns = v
	return s
}

// SetCapacitySpecification sets the CapacitySpecification field's value.
func (s *UpdateTableInput) SetCapacitySpecification(v *CapacitySpecification) *UpdateTableInput {
	s.CapacitySpecification = v
	return s
}

// SetDefaultTimeToLive sets the DefaultTimeToLive field's value.
func (s *UpdateTableInput) SetDefaultTimeToLive(v int64) *UpdateTableInput {
	s.DefaultTimeToLive = &v
	return s
}

// SetEncryptionSpecification sets the EncryptionSpecification field's value.
func (s *UpdateTableInput) SetEncryptionSpecification(v *EncryptionSpecification) *UpdateTableInput {
	s.EncryptionSpecification = v
	return s
}

// SetKeyspaceName sets the KeyspaceName field's value.
func (s *UpdateTableInput) SetKeyspaceName(v string) *UpdateTableInput {
	s.KeyspaceName = &v
	return s
}

// SetPointInTimeRecovery sets the PointInTimeRecovery field's value.
func (s *UpdateTableInput) SetPointInTimeRecovery(v *PointInTimeRecovery) *UpdateTableInput {
	s.PointInTimeRecovery = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateTableInput) SetTableName(v string) *UpdateTableInput {
	s.TableName = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *UpdateTableInput) SetTtl(v *TimeToLive) *UpdateTableInput {
	s.Ttl = v
	return s
}

type UpdateTableOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the modified table.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTableOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UpdateTableOutput) SetResourceArn(v string) *UpdateTableOutput {
	s.ResourceArn = &v
	return s
}

// The operation failed due to an invalid or malformed request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// EncryptionTypeCustomerManagedKmsKey is a EncryptionType enum value
	EncryptionTypeCustomerManagedKmsKey = "CUSTOMER_MANAGED_KMS_KEY"

	// EncryptionTypeAwsOwnedKmsKey is a EncryptionType enum value
	EncryptionTypeAwsOwnedKmsKey = "AWS_OWNED_KMS_KEY"
)

// EncryptionType_Values returns all elements of the EncryptionType enum
func EncryptionType_Values() []string {
	return []string{
		EncryptionTypeCustomerManagedKmsKey,
		EncryptionTypeAwsOwnedKmsKey,
	}
}

const (
	// PointInTimeRecoveryStatusEnabled is a PointInTimeRecoveryStatus enum value
	PointInTimeRecoveryStatusEnabled = "ENABLED"

	// PointInTimeRecoveryStatusDisabled is a PointInTimeRecoveryStatus enum value
	PointInTimeRecoveryStatusDisabled = "DISABLED"
)

// PointInTimeRecoveryStatus_Values returns all elements of the PointInTimeRecoveryStatus enum
func PointInTimeRecoveryStatus_Values() []string {
	return []string{
		PointInTimeRecoveryStatusEnabled,
		PointInTimeRecoveryStatusDisabled,
	}
}

const (
	// SortOrderAsc is a SortOrder enum value
	SortOrderAsc = "ASC"

	// SortOrderDesc is a SortOrder enum value
	SortOrderDesc = "DESC"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAsc,
		SortOrderDesc,
	}
}

const (
	// TableStatusActive is a TableStatus enum value
	TableStatusActive = "ACTIVE"

	// TableStatusCreating is a TableStatus enum value
	TableStatusCreating = "CREATING"

	// TableStatusUpdating is a TableStatus enum value
	TableStatusUpdating = "UPDATING"

	// TableStatusDeleting is a TableStatus enum value
	TableStatusDeleting = "DELETING"

	// TableStatusDeleted is a TableStatus enum value
	TableStatusDeleted = "DELETED"

	// TableStatusRestoring is a TableStatus enum value
	TableStatusRestoring = "RESTORING"

	// TableStatusInaccessibleEncryptionCredentials is a TableStatus enum value
	TableStatusInaccessibleEncryptionCredentials = "INACCESSIBLE_ENCRYPTION_CREDENTIALS"
)

// TableStatus_Values returns all elements of the TableStatus enum
func TableStatus_Values() []string {
	return []string{
		TableStatusActive,
		TableStatusCreating,
		TableStatusUpdating,
		TableStatusDeleting,
		TableStatusDeleted,
		TableStatusRestoring,
		TableStatusInaccessibleEncryptionCredentials,
	}
}

const (
	// ThroughputModePayPerRequest is a ThroughputMode enum value
	ThroughputModePayPerRequest = "PAY_PER_REQUEST"

	// ThroughputModeProvisioned is a ThroughputMode enum value
	ThroughputModeProvisioned = "PROVISIONED"
)

// ThroughputMode_Values returns all elements of the ThroughputMode enum
func ThroughputMode_Values() []string {
	return []string{
		ThroughputModePayPerRequest,
		ThroughputModeProvisioned,
	}
}

const (
	// TimeToLiveStatusEnabled is a TimeToLiveStatus enum value
	TimeToLiveStatusEnabled = "ENABLED"
)

// TimeToLiveStatus_Values returns all elements of the TimeToLiveStatus enum
func TimeToLiveStatus_Values() []string {
	return []string{
		TimeToLiveStatusEnabled,
	}
}
