/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// NetworkLoadBalancerPut struct for NetworkLoadBalancerPut
type NetworkLoadBalancerPut struct {
	// The resource's unique identifier.
	Id *string `json:"id,omitempty"`
	// The type of object that has been created.
	Type *Type `json:"type,omitempty"`
	// URL to the object representation (absolute path).
	Href       *string                        `json:"href,omitempty"`
	Properties *NetworkLoadBalancerProperties `json:"properties"`
}

// NewNetworkLoadBalancerPut instantiates a new NetworkLoadBalancerPut object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewNetworkLoadBalancerPut(properties NetworkLoadBalancerProperties) *NetworkLoadBalancerPut {
	this := NetworkLoadBalancerPut{}

	this.Properties = &properties

	return &this
}

// NewNetworkLoadBalancerPutWithDefaults instantiates a new NetworkLoadBalancerPut object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewNetworkLoadBalancerPutWithDefaults() *NetworkLoadBalancerPut {
	this := NetworkLoadBalancerPut{}
	return &this
}

// GetId returns the Id field value
// If the value is explicit nil, the zero value for string will be returned
func (o *NetworkLoadBalancerPut) GetId() *string {
	if o == nil {
		return nil
	}

	return o.Id

}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerPut) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Id, true
}

// SetId sets field value
func (o *NetworkLoadBalancerPut) SetId(v string) {

	o.Id = &v

}

// HasId returns a boolean if a field has been set.
func (o *NetworkLoadBalancerPut) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// GetType returns the Type field value
// If the value is explicit nil, the zero value for Type will be returned
func (o *NetworkLoadBalancerPut) GetType() *Type {
	if o == nil {
		return nil
	}

	return o.Type

}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerPut) GetTypeOk() (*Type, bool) {
	if o == nil {
		return nil, false
	}

	return o.Type, true
}

// SetType sets field value
func (o *NetworkLoadBalancerPut) SetType(v Type) {

	o.Type = &v

}

// HasType returns a boolean if a field has been set.
func (o *NetworkLoadBalancerPut) HasType() bool {
	if o != nil && o.Type != nil {
		return true
	}

	return false
}

// GetHref returns the Href field value
// If the value is explicit nil, the zero value for string will be returned
func (o *NetworkLoadBalancerPut) GetHref() *string {
	if o == nil {
		return nil
	}

	return o.Href

}

// GetHrefOk returns a tuple with the Href field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerPut) GetHrefOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Href, true
}

// SetHref sets field value
func (o *NetworkLoadBalancerPut) SetHref(v string) {

	o.Href = &v

}

// HasHref returns a boolean if a field has been set.
func (o *NetworkLoadBalancerPut) HasHref() bool {
	if o != nil && o.Href != nil {
		return true
	}

	return false
}

// GetProperties returns the Properties field value
// If the value is explicit nil, the zero value for NetworkLoadBalancerProperties will be returned
func (o *NetworkLoadBalancerPut) GetProperties() *NetworkLoadBalancerProperties {
	if o == nil {
		return nil
	}

	return o.Properties

}

// GetPropertiesOk returns a tuple with the Properties field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *NetworkLoadBalancerPut) GetPropertiesOk() (*NetworkLoadBalancerProperties, bool) {
	if o == nil {
		return nil, false
	}

	return o.Properties, true
}

// SetProperties sets field value
func (o *NetworkLoadBalancerPut) SetProperties(v NetworkLoadBalancerProperties) {

	o.Properties = &v

}

// HasProperties returns a boolean if a field has been set.
func (o *NetworkLoadBalancerPut) HasProperties() bool {
	if o != nil && o.Properties != nil {
		return true
	}

	return false
}

func (o NetworkLoadBalancerPut) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	if o.Type != nil {
		toSerialize["type"] = o.Type
	}
	if o.Href != nil {
		toSerialize["href"] = o.Href
	}
	if o.Properties != nil {
		toSerialize["properties"] = o.Properties
	}
	return json.Marshal(toSerialize)
}

type NullableNetworkLoadBalancerPut struct {
	value *NetworkLoadBalancerPut
	isSet bool
}

func (v NullableNetworkLoadBalancerPut) Get() *NetworkLoadBalancerPut {
	return v.value
}

func (v *NullableNetworkLoadBalancerPut) Set(val *NetworkLoadBalancerPut) {
	v.value = val
	v.isSet = true
}

func (v NullableNetworkLoadBalancerPut) IsSet() bool {
	return v.isSet
}

func (v *NullableNetworkLoadBalancerPut) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableNetworkLoadBalancerPut(val *NetworkLoadBalancerPut) *NullableNetworkLoadBalancerPut {
	return &NullableNetworkLoadBalancerPut{value: val, isSet: true}
}

func (v NullableNetworkLoadBalancerPut) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableNetworkLoadBalancerPut) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
