// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for Ed25519 Digital Signature Algorithm.
// See https://ed25519.cr.yp.to/ed25519-20110926.pdf and
// https://tools.ietf.org/html/rfc8032.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: ed25519.proto

package ed25519_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Ed25519KeyFormat struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Version       uint32                 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Ed25519KeyFormat) Reset() {
	*x = Ed25519KeyFormat{}
	mi := &file_ed25519_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Ed25519KeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Ed25519KeyFormat) ProtoMessage() {}

func (x *Ed25519KeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_ed25519_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Ed25519KeyFormat.ProtoReflect.Descriptor instead.
func (*Ed25519KeyFormat) Descriptor() ([]byte, []int) {
	return file_ed25519_proto_rawDescGZIP(), []int{0}
}

func (x *Ed25519KeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// key_type: type.googleapis.com/google.crypto.tink.Ed25519PublicKey
type Ed25519PublicKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// The public key is 32 bytes, encoded according to
	// https://tools.ietf.org/html/rfc8032#section-5.1.2.
	// Required.
	KeyValue      []byte `protobuf:"bytes,2,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Placeholder for ctype.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Ed25519PublicKey) Reset() {
	*x = Ed25519PublicKey{}
	mi := &file_ed25519_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Ed25519PublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Ed25519PublicKey) ProtoMessage() {}

func (x *Ed25519PublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_ed25519_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Ed25519PublicKey.ProtoReflect.Descriptor instead.
func (*Ed25519PublicKey) Descriptor() ([]byte, []int) {
	return file_ed25519_proto_rawDescGZIP(), []int{1}
}

func (x *Ed25519PublicKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Ed25519PublicKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

// key_type: type.googleapis.com/google.crypto.tink.Ed25519PrivateKey
type Ed25519PrivateKey struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// The private key is 32 bytes of cryptographically secure random data.
	// See https://tools.ietf.org/html/rfc8032#section-5.1.5.
	// Required.
	KeyValue []byte `protobuf:"bytes,2,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"` // Placeholder for ctype and debug_redact.
	// The corresponding public key.
	PublicKey     *Ed25519PublicKey `protobuf:"bytes,3,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Ed25519PrivateKey) Reset() {
	*x = Ed25519PrivateKey{}
	mi := &file_ed25519_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Ed25519PrivateKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Ed25519PrivateKey) ProtoMessage() {}

func (x *Ed25519PrivateKey) ProtoReflect() protoreflect.Message {
	mi := &file_ed25519_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Ed25519PrivateKey.ProtoReflect.Descriptor instead.
func (*Ed25519PrivateKey) Descriptor() ([]byte, []int) {
	return file_ed25519_proto_rawDescGZIP(), []int{2}
}

func (x *Ed25519PrivateKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Ed25519PrivateKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

func (x *Ed25519PrivateKey) GetPublicKey() *Ed25519PublicKey {
	if x != nil {
		return x.PublicKey
	}
	return nil
}

var File_ed25519_proto protoreflect.FileDescriptor

const file_ed25519_proto_rawDesc = "" +
	"\n" +
	"\red25519.proto\x12\x12google.crypto.tink\",\n" +
	"\x10Ed25519KeyFormat\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\"I\n" +
	"\x10Ed25519PublicKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12\x1b\n" +
	"\tkey_value\x18\x02 \x01(\fR\bkeyValue\"\x8f\x01\n" +
	"\x11Ed25519PrivateKey\x12\x18\n" +
	"\aversion\x18\x01 \x01(\rR\aversion\x12\x1b\n" +
	"\tkey_value\x18\x02 \x01(\fR\bkeyValue\x12C\n" +
	"\n" +
	"public_key\x18\x03 \x01(\v2$.google.crypto.tink.Ed25519PublicKeyR\tpublicKeyBZ\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z8github.com/tink-crypto/tink-go/v2/proto/ed25519_go_protob\x06proto3"

var (
	file_ed25519_proto_rawDescOnce sync.Once
	file_ed25519_proto_rawDescData []byte
)

func file_ed25519_proto_rawDescGZIP() []byte {
	file_ed25519_proto_rawDescOnce.Do(func() {
		file_ed25519_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_ed25519_proto_rawDesc), len(file_ed25519_proto_rawDesc)))
	})
	return file_ed25519_proto_rawDescData
}

var file_ed25519_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_ed25519_proto_goTypes = []any{
	(*Ed25519KeyFormat)(nil),  // 0: google.crypto.tink.Ed25519KeyFormat
	(*Ed25519PublicKey)(nil),  // 1: google.crypto.tink.Ed25519PublicKey
	(*Ed25519PrivateKey)(nil), // 2: google.crypto.tink.Ed25519PrivateKey
}
var file_ed25519_proto_depIdxs = []int32{
	1, // 0: google.crypto.tink.Ed25519PrivateKey.public_key:type_name -> google.crypto.tink.Ed25519PublicKey
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_ed25519_proto_init() }
func file_ed25519_proto_init() {
	if File_ed25519_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_ed25519_proto_rawDesc), len(file_ed25519_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_ed25519_proto_goTypes,
		DependencyIndexes: file_ed25519_proto_depIdxs,
		MessageInfos:      file_ed25519_proto_msgTypes,
	}.Build()
	File_ed25519_proto = out.File
	file_ed25519_proto_goTypes = nil
	file_ed25519_proto_depIdxs = nil
}
