/* vim:set et ts=4: */
/* ibus - The Input Bus
 * Copyright (C) 2008-2009 Huang Peng <shawn.p.huang@gmail.com>
 *
 * Copyright (C) 2009, Intel Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.     See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gmodule.h>
#include <ibus.h>
#include "ibus-imcontext.h"

#define IBUS_LOCALDIR ""
static const ClutterIMContextInfo ibus_im_info = {
    "ibus",
    "IBus (Intelligent Input Bus)",
    "ibus",
    IBUS_LOCALDIR,
    "ja:ko:zh"
};

static const ClutterIMContextInfo *info_list[] = {
    &ibus_im_info
};

G_MODULE_EXPORT const gchar*
g_module_check_init (GModule *module)
{
    return glib_check_version (GLIB_MAJOR_VERSION,
                               GLIB_MINOR_VERSION,
                               GLIB_MICRO_VERSION);
}

G_MODULE_EXPORT void
im_module_init (GTypeModule *type_module)
{
    /* make module resident */
    g_type_module_use (type_module);

    ibus_im_context_register_type (type_module);
}

G_MODULE_EXPORT void
im_module_exit (void)
{
}

G_MODULE_EXPORT ClutterIMContext *
im_module_create (const gchar *context_id)
{
    if (g_strcmp0 (context_id, "ibus") == 0) {
        IBusIMContext *context;
        context = ibus_im_context_new ();
        return (ClutterIMContext *) context;
    }
    return NULL;
}

G_MODULE_EXPORT void
im_module_list (const ClutterIMContextInfo ***contexts,
                gint                     *n_contexts)
{
    *contexts = info_list;
    *n_contexts = G_N_ELEMENTS (info_list);
}

