# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
ALMALINUX_RELEASES ?=
GARDEN_SYSTEMS += $(foreach r,$(ALMALINUX_RELEASES),$(foreach a,x86_64 aarch64,almalinux-cloud-$r.$a))

$(foreach R,$(ALMALINUX_RELEASES),almalinux-cloud-$R.x86_64.run): almalinux-cloud-%.x86_64.run: $(MAKEFILE_LIST) | almalinux-cloud-%.x86_64.qcow2 almalinux-cloud-%.x86_64.efi-code.img almalinux-cloud-%.x86_64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/almalinux" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(ALMALINUX_RELEASES),almalinux-cloud-$R.aarch64.run): almalinux-cloud-%.aarch64.run: $(MAKEFILE_LIST) | almalinux-cloud-%.aarch64.qcow2 almalinux-cloud-%.aarch64.efi-code.img almalinux-cloud-%.aarch64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/almalinux" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(ALMALINUX_RELEASES),almalinux-cloud-$R.x86_64.qcow2): almalinux-cloud-%.x86_64.qcow2: $(GARDEN_DL_DIR)/almalinux/almalinux-cloud-%.x86_64.qcow2 almalinux-cloud-%.seed.iso almalinux-cloud-%.x86_64.efi-code.img almalinux-cloud-%.x86_64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(foreach R,$(ALMALINUX_RELEASES),almalinux-cloud-$R.aarch64.qcow2): almalinux-cloud-%.aarch64.qcow2: $(GARDEN_DL_DIR)/almalinux/almalinux-cloud-%.aarch64.qcow2 almalinux-cloud-%.seed.iso almalinux-cloud-%.aarch64.efi-code.img almalinux-cloud-%.aarch64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(GARDEN_DL_DIR)/almalinux: | $(GARDEN_DL_DIR)
	mkdir -p $@

almalinux-cloud-%.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,almalinux-$*)
almalinux-cloud-%.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

almalinux-cloud-%.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,ALMALINUX,$*),almalinux-$*,almalinux)
almalinux-cloud-%.user-data: $(MAKEFILE_LIST) $(wildcard .image-garden.mk)
	echo "$${USER_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

.PHONY: clean
clean::
	rm -f $(foreach R,$(ALMALINUX_RELEASES),$(foreach A,x86_64 aarch64,almalinux-cloud-$R.$A.qcow2 almalinux-cloud-$R.$A.run))
