/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "setupplay.h"
#include "ui_setupplay.h"

#include "global/global.h"

using namespace Global;

SetupPlay::SetupPlay(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::SetupPlay)
{
    ui->setupUi(this);

    QFont f("Noto Sans CJK SC Regular");
    f.setPixelSize(14);
    ui->cb_AutoFullScreen->setFont(f);
    ui->cb_AutoFullScreen->hide();

    ui->cb_ClearListExit->setFont(f);
    ui->cb_LastPosPlay->setFont(f);
    ui->cb_FindAssociatedPlay->setFont(f);

    ui->cb_FindAssociatedPlay->hide();  // 功能暂时隐藏

    initConnect();
}

SetupPlay::~SetupPlay()
{
    delete ui;
}

/** **********************************************
 * 主题颜色修改
 *************************************************/
void SetupPlay::setBlackTheme()
{
    ui->cb_AutoFullScreen->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->cb_ClearListExit->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->cb_LastPosPlay->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->cb_FindAssociatedPlay->setStyleSheet(QString("color:rgb(249,249,249);"));
}

void SetupPlay::setLightTheme()
{
    ui->cb_AutoFullScreen->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->cb_ClearListExit->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->cb_LastPosPlay->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->cb_FindAssociatedPlay->setStyleSheet(QString("color:rgb(38,38,38);"));
}

void SetupPlay::setWidgetFont(QString family, int size)
{
    QFont f(family);
    f.setPointSize(size);

    ui->cb_AutoFullScreen->setFont(f);
    ui->cb_ClearListExit->setFont(f);
    ui->cb_FindAssociatedPlay->setFont(f);
    ui->cb_LastPosPlay->setFont(f);
}

void SetupPlay::initData()
{
    ui->cb_AutoFullScreen->setChecked(gsetup->fullScreenWhenPlay.first);
    ui->cb_ClearListExit->setChecked(gsetup->clearListWhenExit.first);
    ui->cb_LastPosPlay->setChecked(gsetup->playLastPos.first);
    ui->cb_FindAssociatedPlay->setChecked(gsetup->playRelationFile.first);
}

void SetupPlay::initConnect()
{
    connect(ui->cb_AutoFullScreen, &QCheckBox::clicked, [&](bool cheched){gsetup->fullScreenWhenPlay.second = cheched;});
    connect(ui->cb_ClearListExit, &QCheckBox::clicked, [&](bool cheched){gsetup->clearListWhenExit.second = cheched;});
    connect(ui->cb_LastPosPlay, &QCheckBox::clicked, [&](bool cheched){gsetup->playLastPos.second = cheched;});
    connect(ui->cb_FindAssociatedPlay, &QCheckBox::clicked, [&](bool cheched){gsetup->playRelationFile.second = cheched;});
}
