/* ----- encode/653x3, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_653x3_checksums[] = {
  "601a6ccdda0496001dd407588f0a0e86e7538fbb1916d7192d65165eb33f8607",
  "29700e201920e207a92db544a0e850f0de968596d8d53fafddee93ce95ee0181",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_653x3_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_653x3_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_653x3_ITEMBYTES

static void *storage_encode_653x3_s;
static unsigned char *test_encode_653x3_s;
static void *storage_encode_653x3_x;
static unsigned char *test_encode_653x3_x;
static void *storage_encode_653x3_s2;
static unsigned char *test_encode_653x3_s2;
static void *storage_encode_653x3_x2;
static unsigned char *test_encode_653x3_x2;

#define precomputed_encode_653x3_NUM 4

static const unsigned char precomputed_encode_653x3_s[precomputed_encode_653x3_NUM][crypto_encode_STRBYTES] = {
  {211,38,140,13,214,6,104,179,230,36,166,253,73,215,72,223,6,246,122,54,180,115,17,157,48,192,123,170,194,148,61,189,185,253,106,106,26,175,74,163,254,209,189,1,141,232,15,3,199,15,0,184,103,252,145,208,109,75,231,136,40,181,122,236,94,201,231,238,221,143,201,248,132,28,149,144,1,188,217,46,156,161,62,55,58,29,237,117,217,59,125,93,3,229,69,61,147,47,105,77,204,248,67,39,221,77,242,189,246,225,88,247,192,134,10,14,82,145,0,62,230,102,44,117,210,130,196,121,197,229,49,85,157,139,148,12,124,230,125,201,39,254,138,80,183,40,184,231,250,99,35,202,58,105,166,175,222,85,229,18,71,57,97,188},
  {59,234,204,122,129,33,244,66,17,228,114,66,235,154,79,169,29,181,117,157,53,151,158,49,89,139,103,81,7,74,135,91,6,64,11,153,121,122,90,210,68,238,226,13,24,60,28,205,139,8,100,229,242,168,235,64,121,160,255,144,83,4,108,212,244,26,122,3,96,15,14,182,238,192,140,74,253,222,37,208,127,191,53,114,24,30,210,80,48,120,157,61,11,121,79,22,201,66,193,65,176,7,141,92,13,196,46,71,193,36,7,159,179,125,157,172,185,180,215,30,30,73,219,215,214,219,109,243,150,216,26,255,89,97,243,254,136,82,128,104,114,89,228,125,177,64,198,228,35,49,218,16,121,34,96,190,12,237,87,83,179,116,178,19},
  {253,79,253,183,67,49,189,45,245,0,80,201,72,155,157,120,74,123,250,179,43,189,115,78,117,170,82,33,25,88,138,97,94,31,229,28,161,212,195,225,92,245,127,184,50,202,3,135,156,165,207,229,129,144,16,81,84,213,244,254,86,90,203,47,212,244,185,187,169,61,196,40,214,154,223,178,226,71,199,231,161,117,3,98,10,32,218,223,4,61,176,156,88,7,213,88,108,180,189,45,76,52,42,46,102,126,11,51,40,121,94,41,122,200,15,197,4,248,215,97,97,224,45,152,6,77,91,254,222,69,79,14,216,159,213,242,17,185,152,222,138,35,136,11,123,203,214,4,232,19,49,185,40,98,86,197,30,205,178,115,247,132,152,129},
  {62,168,251,195,207,208,232,101,114,155,2,26,13,29,43,164,34,31,27,58,128,37,64,65,45,187,251,177,107,54,2,204,169,121,9,93,19,206,45,140,113,65,51,120,157,58,48,16,31,138,231,135,114,182,188,223,195,41,208,13,174,52,35,217,126,153,216,97,39,225,211,20,44,72,5,47,106,223,84,167,211,168,0,126,8,147,1,130,108,145,133,47,38,245,161,36,177,68,96,221,207,231,71,108,55,57,131,181,62,96,31,196,167,173,202,103,219,88,74,17,166,80,144,40,219,42,190,167,10,120,236,148,158,117,62,27,85,164,43,215,62,169,59,38,112,36,206,92,109,90,254,172,68,173,162,176,156,240,225,135,241,243,101,171},
} ;

static const unsigned char precomputed_encode_653x3_x[precomputed_encode_653x3_NUM][crypto_encode_ITEMS] = {
  {166,126,10,161,9,210,76,91,235,183,27,79,216,176,206,69,109,53,184,207,209,104,228,104,147,116,83,122,250,49,142,175,177,156,19,137,99,83,234,162,89,26,153,168,172,215,54,185,216,103,212,181,146,76,112,55,71,255,215,249,242,78,54,152,25,166,252,129,229,187,245,138,117,116,42,145,225,248,150,63,135,14,46,27,38,242,151,67,228,254,14,220,72,96,68,197,171,56,25,247,195,2,46,255,122,111,35,75,177,177,38,98,237,128,192,86,55,194,52,135,132,13,103,99,224,82,188,154,228,32,184,218,144,134,164,215,37,56,73,102,229,64,175,33,201,247,114,156,114,78,103,213,201,3,234,30,38,138,56,106,181,17,59,68,112,11,150,126,100,197,3,227,20,78,46,194,64,90,141,127,191,85,232,152,38,185,171,176,154,97,197,73,230,163,116,63,66,238,220,200,187,92,112,190,175,37,30,85,222,65,91,174,31,138,154,219,44,180,92,210,179,214,75,119,188,167,208,191,202,183,161,53,106,14,51,95,131,228,130,148,215,235,13,66,168,146,139,11,65,181,201,26,175,206,75,240,157,227,50,75,64,133,154,90,46,41,124,168,225,126,0,119,240,66,185,180,214,249,248,56,252,6,86,252,155,78,69,46,87,26,191,122,195,213,43,40,60,229,27,175,15,15,55,158,172,244,255,1,3,249,220,215,104,143,226,27,25,64,48,103,247,44,58,156,36,254,175,193,133,209,130,148,170,66,15,69,121,43,104,49,4,181,175,32,184,200,128,15,240,52,94,70,168,143,126,87,54,208,247,220,172,115,207,251,176,18,209,252,158,44,22,136,60,129,181,128,240,44,81,225,56,116,214,206,126,176,56,82,178,246,41,251,20,192,136,254,236,35,164,165,15,6,41,171,63,101,57,181,166,158,209,199,126,129,73,143,252,159,225,80,0,142,184,149,161,135,26,81,240,50,239,79,125,169,180,189,24,61,80,190,235,54,176,189,54,71,201,63,111,79,56,9,9,162,166,193,157,214,72,69,109,247,139,219,225,11,119,26,96,3,77,28,131,178,62,202,113,66,91,159,165,19,98,174,101,135,197,33,75,223,129,172,168,122,89,52,133,134,194,163,113,183,142,24,223,128,77,143,120,67,130,166,16,120,36,165,100,39,141,39,92,220,129,4,116,79,245,64,96,246,189,45,86,236,95,65,43,25,83,202,91,247,132,101,27,23,15,195,97,72,117,159,160,130,172,243,196,224,55,171,82,72,214,140,229,233,122,102,65,185,49,96,119,81,124,154,158,245,43,209,95,177,67,58,79,1,129,108,38,87,245,31,137,59,63,185,134,10,218,75,62,192,137,160,245,60,41,80,145,9,15,85,200,3,124,146,245,83,69,47,114,30,167,196,233,216,80,21,92,161,42,186,148,103,102,156,137,253,60,26,126,169,57,121,4,12,123,164,56,129,21,162,187},
  {194,117,229,232,165,164,94,190,167,12,86,213,117,184,117,222,84,134,164,222,212,146,135,69,47,116,118,169,141,108,91,56,180,110,169,87,71,202,6,131,5,54,20,168,141,76,187,178,58,223,202,181,137,215,90,239,82,206,79,94,84,108,113,213,24,8,113,246,208,224,217,14,192,248,96,34,144,114,11,181,76,109,246,26,222,161,234,217,81,214,218,168,220,152,110,187,68,236,141,61,214,116,149,117,194,188,90,95,12,100,158,214,26,178,37,66,213,12,79,112,86,19,249,128,2,217,246,245,213,151,96,238,203,252,99,188,134,76,36,31,188,86,27,2,20,0,17,72,197,224,102,126,85,148,250,147,149,110,139,238,251,45,224,129,157,127,52,59,141,140,65,219,172,187,226,148,211,180,154,202,179,169,253,239,115,221,54,214,240,66,52,185,86,244,245,223,103,223,125,232,123,145,241,25,132,79,49,31,13,176,125,28,15,21,235,97,190,174,30,245,67,78,175,6,48,81,211,214,227,242,102,133,142,59,155,226,79,39,197,64,78,124,148,166,243,91,157,34,219,79,188,45,155,73,204,40,143,96,193,146,69,96,108,229,37,192,140,141,62,108,80,71,55,45,26,242,130,106,181,69,169,56,139,154,133,7,60,28,241,146,118,12,27,216,95,172,207,174,43,12,73,99,142,21,80,38,216,113,33,194,30,206,228,115,10,190,47,87,47,88,234,44,253,63,86,121,231,27,196,215,24,13,185,177,218,76,167,87,156,44,249,0,85,138,237,44,54,222,7,161,79,202,231,65,211,111,243,24,209,155,104,64,154,197,252,47,103,11,186,115,83,36,128,181,13,8,210,238,91,195,117,239,5,33,236,238,57,149,105,233,166,82,76,24,172,36,164,94,189,76,115,150,17,34,182,131,147,27,0,90,221,100,39,72,180,130,176,230,99,117,91,213,164,146,29,51,87,74,118,207,192,149,48,183,42,11,51,71,124,139,14,245,61,104,22,253,0,77,198,162,189,141,32,150,135,189,160,222,55,15,27,211,203,253,196,176,106,105,239,32,255,84,66,92,137,133,201,228,15,14,13,163,247,139,200,67,178,8,142,170,233,187,242,224,117,15,37,7,188,42,74,71,150,223,220,95,156,88,194,79,2,234,141,145,235,83,19,4,146,117,93,246,237,119,110,231,234,104,220,206,183,2,104,193,98,234,198,94,210,109,157,167,71,236,7,59,252,146,121,241,236,252,71,229,69,252,139,34,224,56,145,235,18,171,236,194,57,138,51,75,167,191,180,117,118,225,84,82,80,235,231,221,181,101,237,213,39,123,27,121,137,40,42,29,235,206,224,179,167,43,101,236,47,34,171,248,59,242,244,160,243,110,237,136,160,195,155,176,155,136,29,131,0,73,251,3,51,210,48,198,141,142,34,144,18,222,58,133,111,79,174,28,116,64,55,98,142,250,141,20,4,33,18},
  {64,82,146,28,150,101,205,28,216,120,247,58,46,129,23,187,250,53,218,234,248,49,90,82,240,206,76,118,216,244,203,18,188,17,78,83,11,228,221,57,11,160,75,171,72,51,234,79,39,199,47,171,126,230,15,221,216,48,159,27,27,234,46,226,129,93,24,6,170,127,20,165,9,199,120,212,102,58,221,137,90,35,239,92,136,108,199,179,10,1,117,139,221,31,54,97,36,115,127,201,153,155,181,68,157,52,33,210,92,236,132,58,176,213,116,66,35,216,184,240,161,93,94,121,240,63,250,18,81,214,62,50,102,137,240,185,160,52,54,243,191,206,181,202,224,63,19,81,27,45,235,28,46,228,159,195,176,115,85,55,95,246,21,158,52,243,174,15,194,42,204,60,135,63,198,14,169,49,251,43,17,93,135,94,10,117,9,93,118,39,202,14,167,224,246,23,236,149,209,52,34,46,130,254,252,21,228,208,48,119,166,19,247,113,236,199,23,225,186,34,4,90,165,145,183,182,35,41,144,4,30,108,219,125,201,181,137,56,152,199,5,151,222,87,81,205,184,192,242,81,128,197,174,99,90,44,147,47,175,5,255,180,101,170,216,67,128,234,74,155,107,20,172,66,190,63,80,34,137,110,119,98,155,99,131,212,196,227,193,40,50,184,61,34,100,5,30,79,27,182,17,71,87,255,73,193,108,250,110,221,253,217,98,220,174,171,70,7,55,139,56,205,90,29,56,18,250,0,186,41,57,243,181,222,86,110,209,233,244,4,119,181,128,146,241,65,253,43,14,207,168,143,59,41,177,191,244,225,187,171,219,240,60,244,111,202,31,11,151,203,196,192,250,230,206,17,204,93,108,46,219,126,15,177,235,211,166,122,167,38,146,28,220,115,212,238,236,115,226,240,127,122,225,18,55,34,94,125,145,249,254,50,165,73,193,212,1,92,14,255,25,8,107,97,26,159,138,2,74,73,243,33,191,61,222,137,204,74,7,79,45,215,232,204,200,151,171,168,165,32,40,198,127,61,208,164,110,119,87,20,152,34,149,64,47,132,255,214,115,244,254,158,186,106,138,246,20,182,58,170,8,181,139,178,127,15,105,57,152,56,210,173,39,151,124,132,229,247,11,125,188,75,5,219,90,239,135,74,141,3,153,30,129,250,250,22,208,228,137,24,14,51,138,162,245,93,29,162,111,57,243,176,70,245,231,51,208,184,253,72,97,123,145,209,200,177,91,58,76,246,76,38,203,130,131,73,217,8,29,163,9,203,192,24,26,181,218,165,163,0,173,115,118,148,207,192,170,223,4,211,162,141,174,151,101,223,234,220,87,118,176,90,247,107,163,15,2,135,202,100,52,218,40,211,180,88,241,201,119,59,251,227,5,58,230,171,89,202,172,19,32,40,187,52,213,205,224,203,84,97,254,219,193,211,129,157,78,20,152,180,114,120,69,216,131,35,2,60,71,95,144,102,128},
  {145,10,167,51,171,82,226,121,138,47,66,13,246,186,193,38,38,253,186,71,107,188,118,167,191,37,0,189,184,222,62,204,137,105,183,246,18,121,173,226,1,87,121,7,33,193,210,22,136,32,119,213,252,127,101,94,146,53,7,108,67,31,237,247,29,64,183,93,30,19,6,244,238,178,133,215,133,232,232,153,187,164,166,246,144,140,129,36,115,30,160,220,232,17,16,135,156,143,92,241,250,99,26,133,26,251,106,36,240,255,179,85,226,245,34,33,9,54,68,119,121,25,253,52,163,65,101,86,148,44,113,236,88,147,76,175,68,248,245,101,172,119,64,130,70,22,250,162,45,135,191,89,200,104,167,228,135,136,173,15,144,111,157,168,80,195,181,13,38,210,127,230,103,95,228,188,108,195,129,243,1,65,34,111,43,24,81,5,107,0,225,77,206,151,90,44,117,80,180,185,250,122,75,44,34,56,111,225,41,181,90,126,97,28,217,252,223,110,101,226,62,179,116,221,178,179,43,97,228,192,223,244,31,135,172,110,240,6,71,57,13,143,93,125,87,78,29,174,110,164,129,195,20,52,90,248,169,232,254,232,156,234,128,20,115,88,19,222,240,59,191,5,86,115,187,32,88,217,221,172,230,166,68,195,183,90,238,163,159,90,173,208,211,64,86,55,216,122,231,42,10,176,61,85,65,113,205,37,86,13,168,166,235,153,95,59,118,171,227,220,142,36,134,156,243,40,140,252,243,158,220,206,113,2,83,22,143,1,234,110,186,153,246,247,200,197,61,68,1,119,53,180,79,30,241,157,100,42,71,19,172,89,34,0,230,93,244,5,249,246,200,14,20,107,250,93,176,135,204,147,195,103,19,137,224,235,141,36,31,172,162,160,35,174,127,145,144,242,99,100,158,235,231,115,138,6,23,42,210,96,170,152,19,81,228,62,170,34,191,243,56,99,42,186,206,116,221,43,164,75,105,20,173,47,36,57,163,10,64,133,50,154,27,210,51,7,74,126,14,109,145,186,52,97,42,224,9,59,208,198,50,124,139,57,230,148,133,152,59,130,136,13,33,185,71,82,176,23,195,186,33,16,115,143,51,242,0,144,135,229,42,74,175,105,192,110,18,13,192,61,201,35,140,135,117,129,11,1,134,251,50,91,21,240,218,49,79,77,50,90,55,176,234,40,215,14,187,14,205,187,73,200,252,5,217,178,229,21,91,248,66,149,223,81,196,143,176,156,219,197,210,29,230,204,124,60,254,221,137,38,169,52,151,60,116,20,141,75,58,187,156,112,161,112,171,39,51,90,148,181,83,55,118,65,177,126,81,31,103,28,255,189,44,11,80,151,217,219,108,80,249,248,5,70,59,199,144,196,63,92,184,103,84,161,184,136,17,7,90,126,99,190,64,204,95,90,216,60,187,192,98,227,144,59,1,0,190,85,66,248,172,44,228,112,202,5,208,127,84,103,94,1,170},
} ;

static void test_encode_653x3_impl(long long impl)
{
  unsigned char *s = test_encode_653x3_s;
  unsigned char *x = test_encode_653x3_x;
  unsigned char *s2 = test_encode_653x3_s2;
  unsigned char *x2 = test_encode_653x3_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_653x3_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_653x3(impl);
    printf("encode_653x3 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_653x3_implementation(impl),ntruprime_dispatch_encode_653x3_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_653x3;
    printf("encode_653x3 selected implementation %s compiler %s\n",ntruprime_encode_653x3_implementation(),ntruprime_encode_653x3_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_653x3_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_653x3_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_653x3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_653x3_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_653x3_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_653x3_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_653x3(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"653x3")) return;
  storage_encode_653x3_s = callocplus(crypto_encode_STRBYTES);
  test_encode_653x3_s = aligned(storage_encode_653x3_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_653x3_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_653x3_x = aligned(storage_encode_653x3_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_653x3_s2 = callocplus(maxalloc);
  test_encode_653x3_s2 = aligned(storage_encode_653x3_s2,crypto_encode_STRBYTES);
  storage_encode_653x3_x2 = callocplus(maxalloc);
  test_encode_653x3_x2 = aligned(storage_encode_653x3_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_653x3 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_653x3();++impl)
      forked(test_encode_653x3_impl,impl);
    ++test_encode_653x3_s;
    ++test_encode_653x3_x;
    ++test_encode_653x3_s2;
    ++test_encode_653x3_x2;
  }
  free(storage_encode_653x3_x2);
  free(storage_encode_653x3_s2);
  free(storage_encode_653x3_x);
  free(storage_encode_653x3_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

