
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MagicsGlobalAttributes.h
    \\brief Definition of MagicsGlobal Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagicsGlobalAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

MagicsGlobalAttributes::MagicsGlobalAttributes():
	silent_(ParameterManager::getBool("magics_silent")),
	compatibility_(ParameterManager::getBool("magics_backward_compatibility"))
	
	 
{
} 


MagicsGlobalAttributes::~MagicsGlobalAttributes()
{
	
}

    
void MagicsGlobalAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "magics_silent", silent_, params);
	setAttribute(prefix, "magics_backward_compatibility", compatibility_, params);
	
	
}

void MagicsGlobalAttributes::copy(const MagicsGlobalAttributes& other)
{
	silent_ = other.silent_;
	compatibility_ = other.compatibility_;
	
} 


bool MagicsGlobalAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void MagicsGlobalAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void MagicsGlobalAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " silent = " <<  silent_;
	out << " compatibility = " <<  compatibility_;
	
	out << "]" << "\n";
}

void MagicsGlobalAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"magics_silent\":";
	niceprint(out,silent_);
	out << ", \"magics_backward_compatibility\":";
	niceprint(out,compatibility_);
	
}

static MagicsParameter<string> magics_silent("magics_silent", "off", "");
static MagicsParameter<string> magics_backward_compatibility("magics_backward_compatibility", "true", "");
