/* NVTV MS-Windows card access -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: back_winio.c,v 1.2 2003/10/10 16:16:57 dthierbach Exp $
 *
 * Contents:
 *
 * Access the graphics card under MS-Windows via WinIo. 
 *
 * For now, we use an alternative file to back_mswin and change card_direct
 * via the HAVE_WINIO define. This is ugly, and eventually back_mswin and
 * back_winio should be merged.
 *
 */

/* FIXME Version with WinIo */

/* Option: Use dlltool:
   dlltool --dllname WinIo.dll --def /cygdrive/c/EXTRA/WinIo/Source/Dll/WinIo.def --output-lib WinIoCygwin.lib

to create lib file, then don't use _declspec and _stdcall, and link with it.
*/

#define INT32 XXX /* Hack to escape redefinition of INT32 */
#include <windows.h>

#undef INT32

#include "local.h" /* before everything else */

#include <stdio.h>

#include "backend.h"
#include "back_direct.h"
#include "card_direct.h"

/* -------- WinIO backend -------- */

static CardPtr card_winio_list = NULL;

/* 
 *  Check if driver access is possible.
 */

Bool back_win_avail (void)
{
  return TRUE;
}

/*
 *  Find all cards in system, and return list.
 */

CardPtr back_win_init (void)
{
  back_access = &bdir_func;
  if (card_winio_list) return card_winio_list; 
    /* only probe once, and never free card_winio_list once allocated. */

  scan_cards_pci (&card_winio_list, DEV_WINIO);
  return card_winio_list;
}


