// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESGeom_Flash_HeaderFile
#define _IGESGeom_Flash_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IGESGeom_Flash.hxx>

#include <gp_XY.hxx>
#include <Standard_Real.hxx>
#include <Handle_IGESData_IGESEntity.hxx>
#include <IGESData_IGESEntity.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
class IGESData_IGESEntity;
class Standard_OutOfRange;
class gp_XY;
class gp_Pnt2d;
class gp_Pnt;


//! defines IGESFlash, Type <125> Form <0 - 4>
//! in package IGESGeom
//! A flash entity is a point in the ZT=0 plane that locates
//! a particular closed area. That closed area can be defined
//! in one of two ways. First, it can be an arbitrary closed
//! area defined by any entity capable of defining a closed
//! area. The points of this entity must all lie in the ZT=0
//! plane. Second, it can be a member of a predefined set of
//! flash shapes.
class IGESGeom_Flash : public IGESData_IGESEntity
{

public:

  
  Standard_EXPORT IGESGeom_Flash();
  
  //! This method is used to set the fields of the class Flash
  //! - aPoint     : Reference of flash
  //! - aDim       : First flash sizing parameter
  //! - anotherDim : Second flash sizing parameter
  //! - aRotation  : Rotation of flash about reference point
  //! in radians
  //! - aReference : Pointer to the referenced entity or Null
  Standard_EXPORT   void Init (const gp_XY& aPoint, const Standard_Real aDim, const Standard_Real anotherDim, const Standard_Real aRotation, const Handle(IGESData_IGESEntity)& aReference) ;
  
  //! Changes FormNumber (indicates the Nature of the Flash :
  //! 0 Unspecified, then given by Reference, 1->4 various
  //! Specialisations (Circle,Rectangle, etc...) )
  //! Error if not in range [0-4]
  Standard_EXPORT   void SetFormNumber (const Standard_Integer form) ;
  
  //! returns the referenced point, Z = 0 always
  Standard_EXPORT   gp_Pnt2d ReferencePoint()  const;
  
  //! returns the referenced point after applying Transf. Matrix
  Standard_EXPORT   gp_Pnt TransformedReferencePoint()  const;
  
  //! returns first flash sizing parameter
  Standard_EXPORT   Standard_Real Dimension1()  const;
  
  //! returns second flash sizing parameter
  Standard_EXPORT   Standard_Real Dimension2()  const;
  
  //! returns the angle in radians of the rotation of flash about the
  //! reference point
  Standard_EXPORT   Standard_Real Rotation()  const;
  
  //! returns the referenced entity or Null handle.
  Standard_EXPORT   Handle(IGESData_IGESEntity) ReferenceEntity()  const;
  
  //! returns True if referenced entity is present.
  Standard_EXPORT   Standard_Boolean HasReferenceEntity()  const;




  DEFINE_STANDARD_RTTI(IGESGeom_Flash)

protected:




private: 


  gp_XY thePoint;
  Standard_Real theDim1;
  Standard_Real theDim2;
  Standard_Real theRotation;
  Handle(IGESData_IGESEntity) theReference;


};







#endif // _IGESGeom_Flash_HeaderFile
