# -----------------------------------------------------------------------------------------------------
# Copyright (c) 2006-2022, Knut Reinert & Freie Universität Berlin
# Copyright (c) 2016-2022, Knut Reinert & MPI für molekulare Genetik
# This file may be used, modified and/or redistributed under the terms of the 3-clause BSD-License
# shipped with this file and also available at: https://github.com/seqan/chopper/blob/master/LICENSE.md
# -----------------------------------------------------------------------------------------------------

cmake_minimum_required (VERSION 3.15)

# Exposes the google-test targets `gtest` and `gtest_main`.
# CMake 3.24: https://cmake.org/cmake/help/latest/module/FetchContent.html#variable:FETCHCONTENT_TRY_FIND_PACKAGE_MODE
macro (chopper_require_test)
    enable_testing ()

    set (gtest_version "1.12.1")
    set (gtest_git_tag "release-${gtest_version}")

    find_package (GTest ${gtest_version} EXACT QUIET)

    if (NOT GTest_FOUND)
        message (STATUS "Fetching Google Test ${gtest_version}")

        include (FetchContent)
        FetchContent_Declare (gtest_fetch_content
                              GIT_REPOSITORY "https://github.com/google/googletest.git"
                              GIT_TAG "${gtest_git_tag}"
        )
        option (BUILD_GMOCK "" OFF)
        option (INSTALL_GTEST "" OFF)
        FetchContent_MakeAvailable (gtest_fetch_content)
    else ()
        message (STATUS "Found Google Test ${gtest_version}")
    endif ()

    if (NOT TARGET gtest_build)
        add_custom_target (gtest_build DEPENDS gtest_main gtest)
    endif ()

endmacro ()
