#pragma once

// Generated by schema-salad code generator

#include <cassert>
#include <cstddef>
#include <cstdint>
#include <map>
#include <string>
#include <string_view>
#include <variant>
#include <vector>
#include <yaml-cpp/yaml.h>
#include <any>

inline auto mergeYaml(YAML::Node n1, YAML::Node n2) {
    for (auto const& e : n1) {
        n2[e.first.as<std::string>()] = e.second;
    }
    return n2;
}

// declaring toYaml
inline auto toYaml(bool v) {
    return YAML::Node{v};
}
inline auto toYaml(float v) {
    return YAML::Node{v};
}
inline auto toYaml(double v) {
    return YAML::Node{v};
}
inline auto toYaml(int32_t v) {
    return YAML::Node{v};
}
inline auto toYaml(int64_t v) {
    return YAML::Node{v};
}
inline auto toYaml(std::any const&) {
    return YAML::Node{};
}
inline auto toYaml(std::monostate const&) {
    return YAML::Node(YAML::NodeType::Undefined);
}

inline auto toYaml(std::string const& v) {
    return YAML::Node{v};
}

inline void addYamlField(YAML::Node node, std::string const& key, YAML::Node value) {
    if (value.IsDefined()) {
        node[key] = value;
    }
}

// fwd declaring toYaml
template <typename T>
auto toYaml(std::vector<T> const& v) -> YAML::Node;
template <typename T>
auto toYaml(T const& t) -> YAML::Node;
template <typename ...Args>
auto toYaml(std::variant<Args...> const& t) -> YAML::Node;

template <typename T>
class heap_object {
    std::unique_ptr<T> data = std::make_unique<T>();
public:
    heap_object() = default;
    heap_object(heap_object const& oth) {
        *data = *oth;
    }
    heap_object(heap_object&& oth) {
        *data = *oth;
    }

    template <typename T2>
    heap_object(T2 const& oth) {
        *data = oth;
    }
    template <typename T2>
    heap_object(T2&& oth) {
        *data = oth;
    }

    auto operator=(heap_object const& oth) -> heap_object& {
        *data = *oth;
        return *this;
    }
    auto operator=(heap_object&& oth) -> heap_object& {
        *data = std::move(*oth);
        return *this;
    }

    template <typename T2>
    auto operator=(T2 const& oth) -> heap_object& {
        *data = oth;
        return *this;
    }
    template <typename T2>
    auto operator=(T2&& oth) -> heap_object& {
        *data = std::move(oth);
        return *this;
    }

    auto operator->() -> T* {
        return data.get();
    }
    auto operator->() const -> T const* {
        return data.get();
    }
    auto operator*() -> T& {
        return *data;
    }
    auto operator*() const -> T const& {
        return *data;
    }

};

namespace https___w3id_org_cwl_salad { struct Documented; }
namespace https___w3id_org_cwl_salad { struct RecordField; }
namespace https___w3id_org_cwl_salad { struct RecordSchema; }
namespace https___w3id_org_cwl_salad { struct EnumSchema; }
namespace https___w3id_org_cwl_salad { struct ArraySchema; }
namespace https___w3id_org_cwl_cwl { struct File; }
namespace https___w3id_org_cwl_cwl { struct Directory; }
namespace https___w3id_org_cwl_cwl { struct Labeled; }
namespace https___w3id_org_cwl_cwl { struct Identified; }
namespace https___w3id_org_cwl_cwl { struct LoadContents; }
namespace https___w3id_org_cwl_cwl { struct FieldBase; }
namespace https___w3id_org_cwl_cwl { struct InputFormat; }
namespace https___w3id_org_cwl_cwl { struct OutputFormat; }
namespace https___w3id_org_cwl_cwl { struct Parameter; }
namespace https___w3id_org_cwl_cwl { struct InputBinding; }
namespace https___w3id_org_cwl_cwl { struct IOSchema; }
namespace https___w3id_org_cwl_cwl { struct InputSchema; }
namespace https___w3id_org_cwl_cwl { struct OutputSchema; }
namespace https___w3id_org_cwl_cwl { struct InputRecordField; }
namespace https___w3id_org_cwl_cwl { struct InputRecordSchema; }
namespace https___w3id_org_cwl_cwl { struct InputEnumSchema; }
namespace https___w3id_org_cwl_cwl { struct InputArraySchema; }
namespace https___w3id_org_cwl_cwl { struct OutputRecordField; }
namespace https___w3id_org_cwl_cwl { struct OutputRecordSchema; }
namespace https___w3id_org_cwl_cwl { struct OutputEnumSchema; }
namespace https___w3id_org_cwl_cwl { struct OutputArraySchema; }
namespace https___w3id_org_cwl_cwl { struct InputParameter; }
namespace https___w3id_org_cwl_cwl { struct OutputParameter; }
namespace https___w3id_org_cwl_cwl { struct ProcessRequirement; }
namespace https___w3id_org_cwl_cwl { struct Process; }
namespace https___w3id_org_cwl_cwl { struct InlineJavascriptRequirement; }
namespace https___w3id_org_cwl_cwl { struct CommandInputSchema; }
namespace https___w3id_org_cwl_cwl { struct SchemaDefRequirement; }
namespace https___w3id_org_cwl_cwl { struct SecondaryFileSchema; }
namespace https___w3id_org_cwl_cwl { struct LoadListingRequirement; }
namespace https___w3id_org_cwl_cwl { struct EnvironmentDef; }
namespace https___w3id_org_cwl_cwl { struct CommandLineBinding; }
namespace https___w3id_org_cwl_cwl { struct CommandOutputBinding; }
namespace https___w3id_org_cwl_cwl { struct CommandLineBindable; }
namespace https___w3id_org_cwl_cwl { struct CommandInputRecordField; }
namespace https___w3id_org_cwl_cwl { struct CommandInputRecordSchema; }
namespace https___w3id_org_cwl_cwl { struct CommandInputEnumSchema; }
namespace https___w3id_org_cwl_cwl { struct CommandInputArraySchema; }
namespace https___w3id_org_cwl_cwl { struct CommandOutputRecordField; }
namespace https___w3id_org_cwl_cwl { struct CommandOutputRecordSchema; }
namespace https___w3id_org_cwl_cwl { struct CommandOutputEnumSchema; }
namespace https___w3id_org_cwl_cwl { struct CommandOutputArraySchema; }
namespace https___w3id_org_cwl_cwl { struct CommandInputParameter; }
namespace https___w3id_org_cwl_cwl { struct CommandOutputParameter; }
namespace https___w3id_org_cwl_cwl { struct CommandLineTool; }
namespace https___w3id_org_cwl_cwl { struct DockerRequirement; }
namespace https___w3id_org_cwl_cwl { struct SoftwareRequirement; }
namespace https___w3id_org_cwl_cwl { struct SoftwarePackage; }
namespace https___w3id_org_cwl_cwl { struct Dirent; }
namespace https___w3id_org_cwl_cwl { struct InitialWorkDirRequirement; }
namespace https___w3id_org_cwl_cwl { struct EnvVarRequirement; }
namespace https___w3id_org_cwl_cwl { struct ShellCommandRequirement; }
namespace https___w3id_org_cwl_cwl { struct ResourceRequirement; }
namespace https___w3id_org_cwl_cwl { struct WorkReuse; }
namespace https___w3id_org_cwl_cwl { struct NetworkAccess; }
namespace https___w3id_org_cwl_cwl { struct InplaceUpdateRequirement; }
namespace https___w3id_org_cwl_cwl { struct ToolTimeLimit; }
namespace https___w3id_org_cwl_salad {
enum class PrimitiveType : unsigned int {
    null,
    boolean,
    int_,
    long_,
    float_,
    double_,
    string
};
inline auto to_string(PrimitiveType v) {
    static auto m = std::vector<std::string_view> {
        "null",
        "boolean",
        "int",
        "long",
        "float",
        "double",
        "string"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_salad::PrimitiveType>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_salad::PrimitiveType& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_salad::PrimitiveType, std::less<>> {
        {"null", https___w3id_org_cwl_salad::PrimitiveType::null},
        {"boolean", https___w3id_org_cwl_salad::PrimitiveType::boolean},
        {"int", https___w3id_org_cwl_salad::PrimitiveType::int_},
        {"long", https___w3id_org_cwl_salad::PrimitiveType::long_},
        {"float", https___w3id_org_cwl_salad::PrimitiveType::float_},
        {"double", https___w3id_org_cwl_salad::PrimitiveType::double_},
        {"string", https___w3id_org_cwl_salad::PrimitiveType::string},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_salad::PrimitiveType v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_salad::PrimitiveType& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_salad {
enum class Any : unsigned int {
    Any
};
inline auto to_string(Any v) {
    static auto m = std::vector<std::string_view> {
        "Any"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_salad::Any>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_salad::Any& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_salad::Any, std::less<>> {
        {"Any", https___w3id_org_cwl_salad::Any::Any},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_salad::Any v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_salad::Any& out) {
    to_enum(n.as<std::string>(), out);
}
enum class anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779 : unsigned int {
    record
};
inline auto to_string(anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779 v) {
    static auto m = std::vector<std::string_view> {
        "record"
    };
    using U = std::underlying_type_t<anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779>;
    return m.at(static_cast<U>(v));
}
inline void to_enum(std::string_view v, anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779& out) {
    static auto m = std::map<std::string, anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779, std::less<>> {
        {"record", anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779::record},
    };
    out = m.find(v)->second;
}
inline auto toYaml(anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779 v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779& out) {
    to_enum(n.as<std::string>(), out);
}
enum class anon_enum_d961d79c225752b9fadb617367615ab176b47d77 : unsigned int {
    enum_
};
inline auto to_string(anon_enum_d961d79c225752b9fadb617367615ab176b47d77 v) {
    static auto m = std::vector<std::string_view> {
        "enum"
    };
    using U = std::underlying_type_t<anon_enum_d961d79c225752b9fadb617367615ab176b47d77>;
    return m.at(static_cast<U>(v));
}
inline void to_enum(std::string_view v, anon_enum_d961d79c225752b9fadb617367615ab176b47d77& out) {
    static auto m = std::map<std::string, anon_enum_d961d79c225752b9fadb617367615ab176b47d77, std::less<>> {
        {"enum", anon_enum_d961d79c225752b9fadb617367615ab176b47d77::enum_},
    };
    out = m.find(v)->second;
}
inline auto toYaml(anon_enum_d961d79c225752b9fadb617367615ab176b47d77 v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, anon_enum_d961d79c225752b9fadb617367615ab176b47d77& out) {
    to_enum(n.as<std::string>(), out);
}
enum class anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc : unsigned int {
    array
};
inline auto to_string(anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc v) {
    static auto m = std::vector<std::string_view> {
        "array"
    };
    using U = std::underlying_type_t<anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc>;
    return m.at(static_cast<U>(v));
}
inline void to_enum(std::string_view v, anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc& out) {
    static auto m = std::map<std::string, anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc, std::less<>> {
        {"array", anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc::array},
    };
    out = m.find(v)->second;
}
inline auto toYaml(anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class CWLVersion : unsigned int {
    draft_2,
    draft_3_dev1,
    draft_3_dev2,
    draft_3_dev3,
    draft_3_dev4,
    draft_3_dev5,
    draft_3,
    draft_4_dev1,
    draft_4_dev2,
    draft_4_dev3,
    v1_0_dev4,
    v1_0,
    v1_1_0_dev1,
    v1_1,
    v1_2_0_dev1,
    v1_2_0_dev2,
    v1_2_0_dev3,
    v1_2_0_dev4,
    v1_2_0_dev5,
    v1_2
};
inline auto to_string(CWLVersion v) {
    static auto m = std::vector<std::string_view> {
        "draft-2",
        "draft-3.dev1",
        "draft-3.dev2",
        "draft-3.dev3",
        "draft-3.dev4",
        "draft-3.dev5",
        "draft-3",
        "draft-4.dev1",
        "draft-4.dev2",
        "draft-4.dev3",
        "v1.0.dev4",
        "v1.0",
        "v1.1.0-dev1",
        "v1.1",
        "v1.2.0-dev1",
        "v1.2.0-dev2",
        "v1.2.0-dev3",
        "v1.2.0-dev4",
        "v1.2.0-dev5",
        "v1.2"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::CWLVersion>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::CWLVersion& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::CWLVersion, std::less<>> {
        {"draft-2", https___w3id_org_cwl_cwl::CWLVersion::draft_2},
        {"draft-3.dev1", https___w3id_org_cwl_cwl::CWLVersion::draft_3_dev1},
        {"draft-3.dev2", https___w3id_org_cwl_cwl::CWLVersion::draft_3_dev2},
        {"draft-3.dev3", https___w3id_org_cwl_cwl::CWLVersion::draft_3_dev3},
        {"draft-3.dev4", https___w3id_org_cwl_cwl::CWLVersion::draft_3_dev4},
        {"draft-3.dev5", https___w3id_org_cwl_cwl::CWLVersion::draft_3_dev5},
        {"draft-3", https___w3id_org_cwl_cwl::CWLVersion::draft_3},
        {"draft-4.dev1", https___w3id_org_cwl_cwl::CWLVersion::draft_4_dev1},
        {"draft-4.dev2", https___w3id_org_cwl_cwl::CWLVersion::draft_4_dev2},
        {"draft-4.dev3", https___w3id_org_cwl_cwl::CWLVersion::draft_4_dev3},
        {"v1.0.dev4", https___w3id_org_cwl_cwl::CWLVersion::v1_0_dev4},
        {"v1.0", https___w3id_org_cwl_cwl::CWLVersion::v1_0},
        {"v1.1.0-dev1", https___w3id_org_cwl_cwl::CWLVersion::v1_1_0_dev1},
        {"v1.1", https___w3id_org_cwl_cwl::CWLVersion::v1_1},
        {"v1.2.0-dev1", https___w3id_org_cwl_cwl::CWLVersion::v1_2_0_dev1},
        {"v1.2.0-dev2", https___w3id_org_cwl_cwl::CWLVersion::v1_2_0_dev2},
        {"v1.2.0-dev3", https___w3id_org_cwl_cwl::CWLVersion::v1_2_0_dev3},
        {"v1.2.0-dev4", https___w3id_org_cwl_cwl::CWLVersion::v1_2_0_dev4},
        {"v1.2.0-dev5", https___w3id_org_cwl_cwl::CWLVersion::v1_2_0_dev5},
        {"v1.2", https___w3id_org_cwl_cwl::CWLVersion::v1_2},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::CWLVersion v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::CWLVersion& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class CWLType : unsigned int {
    null,
    boolean,
    int_,
    long_,
    float_,
    double_,
    string,
    File,
    Directory
};
inline auto to_string(CWLType v) {
    static auto m = std::vector<std::string_view> {
        "null",
        "boolean",
        "int",
        "long",
        "float",
        "double",
        "string",
        "File",
        "Directory"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::CWLType>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::CWLType& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::CWLType, std::less<>> {
        {"null", https___w3id_org_cwl_cwl::CWLType::null},
        {"boolean", https___w3id_org_cwl_cwl::CWLType::boolean},
        {"int", https___w3id_org_cwl_cwl::CWLType::int_},
        {"long", https___w3id_org_cwl_cwl::CWLType::long_},
        {"float", https___w3id_org_cwl_cwl::CWLType::float_},
        {"double", https___w3id_org_cwl_cwl::CWLType::double_},
        {"string", https___w3id_org_cwl_cwl::CWLType::string},
        {"File", https___w3id_org_cwl_cwl::CWLType::File},
        {"Directory", https___w3id_org_cwl_cwl::CWLType::Directory},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::CWLType v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::CWLType& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class File_class_File_class : unsigned int {
    File
};
inline auto to_string(File_class_File_class v) {
    static auto m = std::vector<std::string_view> {
        "File"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::File_class_File_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::File_class_File_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::File_class_File_class, std::less<>> {
        {"File", https___w3id_org_cwl_cwl::File_class_File_class::File},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::File_class_File_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::File_class_File_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class Directory_class_Directory_class : unsigned int {
    Directory
};
inline auto to_string(Directory_class_Directory_class v) {
    static auto m = std::vector<std::string_view> {
        "Directory"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::Directory_class_Directory_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::Directory_class_Directory_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::Directory_class_Directory_class, std::less<>> {
        {"Directory", https___w3id_org_cwl_cwl::Directory_class_Directory_class::Directory},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::Directory_class_Directory_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::Directory_class_Directory_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class LoadListingEnum : unsigned int {
    no_listing,
    shallow_listing,
    deep_listing
};
inline auto to_string(LoadListingEnum v) {
    static auto m = std::vector<std::string_view> {
        "no_listing",
        "shallow_listing",
        "deep_listing"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::LoadListingEnum>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::LoadListingEnum& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::LoadListingEnum, std::less<>> {
        {"no_listing", https___w3id_org_cwl_cwl::LoadListingEnum::no_listing},
        {"shallow_listing", https___w3id_org_cwl_cwl::LoadListingEnum::shallow_listing},
        {"deep_listing", https___w3id_org_cwl_cwl::LoadListingEnum::deep_listing},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::LoadListingEnum v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::LoadListingEnum& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class Expression : unsigned int {
    ExpressionPlaceholder
};
inline auto to_string(Expression v) {
    static auto m = std::vector<std::string_view> {
        "ExpressionPlaceholder"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::Expression>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::Expression& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::Expression, std::less<>> {
        {"ExpressionPlaceholder", https___w3id_org_cwl_cwl::Expression::ExpressionPlaceholder},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::Expression v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::Expression& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class InlineJavascriptRequirement_class_InlineJavascriptRequirement_class : unsigned int {
    InlineJavascriptRequirement
};
inline auto to_string(InlineJavascriptRequirement_class_InlineJavascriptRequirement_class v) {
    static auto m = std::vector<std::string_view> {
        "InlineJavascriptRequirement"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::InlineJavascriptRequirement_class_InlineJavascriptRequirement_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::InlineJavascriptRequirement_class_InlineJavascriptRequirement_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::InlineJavascriptRequirement_class_InlineJavascriptRequirement_class, std::less<>> {
        {"InlineJavascriptRequirement", https___w3id_org_cwl_cwl::InlineJavascriptRequirement_class_InlineJavascriptRequirement_class::InlineJavascriptRequirement},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::InlineJavascriptRequirement_class_InlineJavascriptRequirement_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::InlineJavascriptRequirement_class_InlineJavascriptRequirement_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class SchemaDefRequirement_class_SchemaDefRequirement_class : unsigned int {
    SchemaDefRequirement
};
inline auto to_string(SchemaDefRequirement_class_SchemaDefRequirement_class v) {
    static auto m = std::vector<std::string_view> {
        "SchemaDefRequirement"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::SchemaDefRequirement_class_SchemaDefRequirement_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::SchemaDefRequirement_class_SchemaDefRequirement_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::SchemaDefRequirement_class_SchemaDefRequirement_class, std::less<>> {
        {"SchemaDefRequirement", https___w3id_org_cwl_cwl::SchemaDefRequirement_class_SchemaDefRequirement_class::SchemaDefRequirement},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::SchemaDefRequirement_class_SchemaDefRequirement_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::SchemaDefRequirement_class_SchemaDefRequirement_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class LoadListingRequirement_class_LoadListingRequirement_class : unsigned int {
    LoadListingRequirement
};
inline auto to_string(LoadListingRequirement_class_LoadListingRequirement_class v) {
    static auto m = std::vector<std::string_view> {
        "LoadListingRequirement"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::LoadListingRequirement_class_LoadListingRequirement_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::LoadListingRequirement_class_LoadListingRequirement_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::LoadListingRequirement_class_LoadListingRequirement_class, std::less<>> {
        {"LoadListingRequirement", https___w3id_org_cwl_cwl::LoadListingRequirement_class_LoadListingRequirement_class::LoadListingRequirement},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::LoadListingRequirement_class_LoadListingRequirement_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::LoadListingRequirement_class_LoadListingRequirement_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class stdin_ : unsigned int {
    stdin_
};
inline auto to_string(stdin_ v) {
    static auto m = std::vector<std::string_view> {
        "stdin"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::stdin_>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::stdin_& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::stdin_, std::less<>> {
        {"stdin", https___w3id_org_cwl_cwl::stdin_::stdin_},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::stdin_ v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::stdin_& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class stdout_ : unsigned int {
    stdout_
};
inline auto to_string(stdout_ v) {
    static auto m = std::vector<std::string_view> {
        "stdout"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::stdout_>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::stdout_& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::stdout_, std::less<>> {
        {"stdout", https___w3id_org_cwl_cwl::stdout_::stdout_},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::stdout_ v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::stdout_& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class stderr_ : unsigned int {
    stderr_
};
inline auto to_string(stderr_ v) {
    static auto m = std::vector<std::string_view> {
        "stderr"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::stderr_>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::stderr_& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::stderr_, std::less<>> {
        {"stderr", https___w3id_org_cwl_cwl::stderr_::stderr_},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::stderr_ v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::stderr_& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class CommandLineTool_class_CommandLineTool_class : unsigned int {
    CommandLineTool
};
inline auto to_string(CommandLineTool_class_CommandLineTool_class v) {
    static auto m = std::vector<std::string_view> {
        "CommandLineTool"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::CommandLineTool_class_CommandLineTool_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::CommandLineTool_class_CommandLineTool_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::CommandLineTool_class_CommandLineTool_class, std::less<>> {
        {"CommandLineTool", https___w3id_org_cwl_cwl::CommandLineTool_class_CommandLineTool_class::CommandLineTool},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::CommandLineTool_class_CommandLineTool_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::CommandLineTool_class_CommandLineTool_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class DockerRequirement_class_DockerRequirement_class : unsigned int {
    DockerRequirement
};
inline auto to_string(DockerRequirement_class_DockerRequirement_class v) {
    static auto m = std::vector<std::string_view> {
        "DockerRequirement"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::DockerRequirement_class_DockerRequirement_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::DockerRequirement_class_DockerRequirement_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::DockerRequirement_class_DockerRequirement_class, std::less<>> {
        {"DockerRequirement", https___w3id_org_cwl_cwl::DockerRequirement_class_DockerRequirement_class::DockerRequirement},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::DockerRequirement_class_DockerRequirement_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::DockerRequirement_class_DockerRequirement_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class SoftwareRequirement_class_SoftwareRequirement_class : unsigned int {
    SoftwareRequirement
};
inline auto to_string(SoftwareRequirement_class_SoftwareRequirement_class v) {
    static auto m = std::vector<std::string_view> {
        "SoftwareRequirement"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::SoftwareRequirement_class_SoftwareRequirement_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::SoftwareRequirement_class_SoftwareRequirement_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::SoftwareRequirement_class_SoftwareRequirement_class, std::less<>> {
        {"SoftwareRequirement", https___w3id_org_cwl_cwl::SoftwareRequirement_class_SoftwareRequirement_class::SoftwareRequirement},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::SoftwareRequirement_class_SoftwareRequirement_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::SoftwareRequirement_class_SoftwareRequirement_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class InitialWorkDirRequirement_class_InitialWorkDirRequirement_class : unsigned int {
    InitialWorkDirRequirement
};
inline auto to_string(InitialWorkDirRequirement_class_InitialWorkDirRequirement_class v) {
    static auto m = std::vector<std::string_view> {
        "InitialWorkDirRequirement"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::InitialWorkDirRequirement_class_InitialWorkDirRequirement_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::InitialWorkDirRequirement_class_InitialWorkDirRequirement_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::InitialWorkDirRequirement_class_InitialWorkDirRequirement_class, std::less<>> {
        {"InitialWorkDirRequirement", https___w3id_org_cwl_cwl::InitialWorkDirRequirement_class_InitialWorkDirRequirement_class::InitialWorkDirRequirement},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::InitialWorkDirRequirement_class_InitialWorkDirRequirement_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::InitialWorkDirRequirement_class_InitialWorkDirRequirement_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class EnvVarRequirement_class_EnvVarRequirement_class : unsigned int {
    EnvVarRequirement
};
inline auto to_string(EnvVarRequirement_class_EnvVarRequirement_class v) {
    static auto m = std::vector<std::string_view> {
        "EnvVarRequirement"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::EnvVarRequirement_class_EnvVarRequirement_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::EnvVarRequirement_class_EnvVarRequirement_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::EnvVarRequirement_class_EnvVarRequirement_class, std::less<>> {
        {"EnvVarRequirement", https___w3id_org_cwl_cwl::EnvVarRequirement_class_EnvVarRequirement_class::EnvVarRequirement},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::EnvVarRequirement_class_EnvVarRequirement_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::EnvVarRequirement_class_EnvVarRequirement_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class ShellCommandRequirement_class_ShellCommandRequirement_class : unsigned int {
    ShellCommandRequirement
};
inline auto to_string(ShellCommandRequirement_class_ShellCommandRequirement_class v) {
    static auto m = std::vector<std::string_view> {
        "ShellCommandRequirement"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::ShellCommandRequirement_class_ShellCommandRequirement_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::ShellCommandRequirement_class_ShellCommandRequirement_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::ShellCommandRequirement_class_ShellCommandRequirement_class, std::less<>> {
        {"ShellCommandRequirement", https___w3id_org_cwl_cwl::ShellCommandRequirement_class_ShellCommandRequirement_class::ShellCommandRequirement},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::ShellCommandRequirement_class_ShellCommandRequirement_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::ShellCommandRequirement_class_ShellCommandRequirement_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class ResourceRequirement_class_ResourceRequirement_class : unsigned int {
    ResourceRequirement
};
inline auto to_string(ResourceRequirement_class_ResourceRequirement_class v) {
    static auto m = std::vector<std::string_view> {
        "ResourceRequirement"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::ResourceRequirement_class_ResourceRequirement_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::ResourceRequirement_class_ResourceRequirement_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::ResourceRequirement_class_ResourceRequirement_class, std::less<>> {
        {"ResourceRequirement", https___w3id_org_cwl_cwl::ResourceRequirement_class_ResourceRequirement_class::ResourceRequirement},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::ResourceRequirement_class_ResourceRequirement_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::ResourceRequirement_class_ResourceRequirement_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class WorkReuse_class_WorkReuse_class : unsigned int {
    WorkReuse
};
inline auto to_string(WorkReuse_class_WorkReuse_class v) {
    static auto m = std::vector<std::string_view> {
        "WorkReuse"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::WorkReuse_class_WorkReuse_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::WorkReuse_class_WorkReuse_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::WorkReuse_class_WorkReuse_class, std::less<>> {
        {"WorkReuse", https___w3id_org_cwl_cwl::WorkReuse_class_WorkReuse_class::WorkReuse},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::WorkReuse_class_WorkReuse_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::WorkReuse_class_WorkReuse_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class NetworkAccess_class_NetworkAccess_class : unsigned int {
    NetworkAccess
};
inline auto to_string(NetworkAccess_class_NetworkAccess_class v) {
    static auto m = std::vector<std::string_view> {
        "NetworkAccess"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::NetworkAccess_class_NetworkAccess_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::NetworkAccess_class_NetworkAccess_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::NetworkAccess_class_NetworkAccess_class, std::less<>> {
        {"NetworkAccess", https___w3id_org_cwl_cwl::NetworkAccess_class_NetworkAccess_class::NetworkAccess},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::NetworkAccess_class_NetworkAccess_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::NetworkAccess_class_NetworkAccess_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class InplaceUpdateRequirement_class_InplaceUpdateRequirement_class : unsigned int {
    InplaceUpdateRequirement
};
inline auto to_string(InplaceUpdateRequirement_class_InplaceUpdateRequirement_class v) {
    static auto m = std::vector<std::string_view> {
        "InplaceUpdateRequirement"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::InplaceUpdateRequirement_class_InplaceUpdateRequirement_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::InplaceUpdateRequirement_class_InplaceUpdateRequirement_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::InplaceUpdateRequirement_class_InplaceUpdateRequirement_class, std::less<>> {
        {"InplaceUpdateRequirement", https___w3id_org_cwl_cwl::InplaceUpdateRequirement_class_InplaceUpdateRequirement_class::InplaceUpdateRequirement},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::InplaceUpdateRequirement_class_InplaceUpdateRequirement_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::InplaceUpdateRequirement_class_InplaceUpdateRequirement_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_cwl {
enum class ToolTimeLimit_class_ToolTimeLimit_class : unsigned int {
    ToolTimeLimit
};
inline auto to_string(ToolTimeLimit_class_ToolTimeLimit_class v) {
    static auto m = std::vector<std::string_view> {
        "ToolTimeLimit"
    };
    using U = std::underlying_type_t<https___w3id_org_cwl_cwl::ToolTimeLimit_class_ToolTimeLimit_class>;
    return m.at(static_cast<U>(v));
}
}
inline void to_enum(std::string_view v, https___w3id_org_cwl_cwl::ToolTimeLimit_class_ToolTimeLimit_class& out) {
    static auto m = std::map<std::string, https___w3id_org_cwl_cwl::ToolTimeLimit_class_ToolTimeLimit_class, std::less<>> {
        {"ToolTimeLimit", https___w3id_org_cwl_cwl::ToolTimeLimit_class_ToolTimeLimit_class::ToolTimeLimit},
    };
    out = m.find(v)->second;
}
inline auto toYaml(https___w3id_org_cwl_cwl::ToolTimeLimit_class_ToolTimeLimit_class v) {
    return YAML::Node{std::string{to_string(v)}};
}
inline auto yamlToEnum(YAML::Node n, https___w3id_org_cwl_cwl::ToolTimeLimit_class_ToolTimeLimit_class& out) {
    to_enum(n.as<std::string>(), out);
}
namespace https___w3id_org_cwl_salad {
struct Documented {
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    virtual ~Documented() = 0;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_salad {
struct RecordField
    : https___w3id_org_cwl_salad::Documented {
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::string> name;
    heap_object<std::variant<std::variant<bool, int32_t, int64_t, float, double, std::string>, RecordSchema, EnumSchema, ArraySchema, std::string, std::vector<std::variant<std::variant<bool, int32_t, int64_t, float, double, std::string>, RecordSchema, EnumSchema, ArraySchema, std::string>>>> type;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_salad {
struct RecordSchema {
    heap_object<std::variant<std::monostate, std::vector<RecordField>>> fields;
    heap_object<anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779> type;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_salad {
struct EnumSchema {
    heap_object<std::vector<std::string>> symbols;
    heap_object<anon_enum_d961d79c225752b9fadb617367615ab176b47d77> type;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_salad {
struct ArraySchema {
    heap_object<std::variant<std::variant<bool, int32_t, int64_t, float, double, std::string>, RecordSchema, EnumSchema, ArraySchema, std::string, std::vector<std::variant<std::variant<bool, int32_t, int64_t, float, double, std::string>, RecordSchema, EnumSchema, ArraySchema, std::string>>>> items;
    heap_object<anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc> type;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct File {
    heap_object<File_class_File_class> class_;
    heap_object<std::variant<std::monostate, std::string>> location;
    heap_object<std::variant<std::monostate, std::string>> path;
    heap_object<std::variant<std::monostate, std::string>> basename;
    heap_object<std::variant<std::monostate, std::string>> dirname;
    heap_object<std::variant<std::monostate, std::string>> nameroot;
    heap_object<std::variant<std::monostate, std::string>> nameext;
    heap_object<std::variant<std::monostate, std::string>> checksum;
    heap_object<std::variant<std::monostate, int32_t, int64_t>> size;
    heap_object<std::variant<std::monostate, std::vector<std::variant<File, Directory>>>> secondaryFiles;
    heap_object<std::variant<std::monostate, std::string>> format;
    heap_object<std::variant<std::monostate, std::string>> contents;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct Directory {
    heap_object<Directory_class_Directory_class> class_;
    heap_object<std::variant<std::monostate, std::string>> location;
    heap_object<std::variant<std::monostate, std::string>> path;
    heap_object<std::variant<std::monostate, std::string>> basename;
    heap_object<std::variant<std::monostate, std::vector<std::variant<File, Directory>>>> listing;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct Labeled {
    heap_object<std::variant<std::monostate, std::string>> label;
    virtual ~Labeled() = 0;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct Identified {
    heap_object<std::variant<std::monostate, std::string>> id;
    virtual ~Identified() = 0;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct LoadContents {
    heap_object<std::variant<std::monostate, bool>> loadContents;
    heap_object<std::variant<std::monostate, LoadListingEnum>> loadListing;
    virtual ~LoadContents() = 0;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct FieldBase
    : https___w3id_org_cwl_cwl::Labeled {
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, SecondaryFileSchema, std::vector<SecondaryFileSchema>>> secondaryFiles;
    heap_object<std::variant<std::monostate, bool>> streamable;
    virtual ~FieldBase() = 0;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct InputFormat {
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>, Expression>> format;
    virtual ~InputFormat() = 0;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct OutputFormat {
    heap_object<std::variant<std::monostate, std::string, Expression>> format;
    virtual ~OutputFormat() = 0;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct Parameter
    : https___w3id_org_cwl_cwl::FieldBase
    , https___w3id_org_cwl_salad::Documented
    , https___w3id_org_cwl_cwl::Identified {
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, SecondaryFileSchema, std::vector<SecondaryFileSchema>>> secondaryFiles;
    heap_object<std::variant<std::monostate, bool>> streamable;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> id;
    virtual ~Parameter() = 0;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct InputBinding {
    heap_object<std::variant<std::monostate, bool>> loadContents;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct IOSchema
    : https___w3id_org_cwl_cwl::Labeled
    , https___w3id_org_cwl_salad::Documented {
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    virtual ~IOSchema() = 0;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct InputSchema
    : https___w3id_org_cwl_cwl::IOSchema {
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    virtual ~InputSchema() = 0;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct OutputSchema
    : https___w3id_org_cwl_cwl::IOSchema {
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    virtual ~OutputSchema() = 0;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct InputRecordField
    : https___w3id_org_cwl_salad::RecordField
    , https___w3id_org_cwl_cwl::FieldBase
    , https___w3id_org_cwl_cwl::InputFormat
    , https___w3id_org_cwl_cwl::LoadContents {
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::string> name;
    heap_object<std::variant<CWLType, InputRecordSchema, InputEnumSchema, InputArraySchema, std::string, std::vector<std::variant<CWLType, InputRecordSchema, InputEnumSchema, InputArraySchema, std::string>>>> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, SecondaryFileSchema, std::vector<SecondaryFileSchema>>> secondaryFiles;
    heap_object<std::variant<std::monostate, bool>> streamable;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>, Expression>> format;
    heap_object<std::variant<std::monostate, bool>> loadContents;
    heap_object<std::variant<std::monostate, LoadListingEnum>> loadListing;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct InputRecordSchema
    : https___w3id_org_cwl_salad::RecordSchema
    , https___w3id_org_cwl_cwl::InputSchema {
    heap_object<std::variant<std::monostate, std::vector<InputRecordField>>> fields;
    heap_object<anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct InputEnumSchema
    : https___w3id_org_cwl_salad::EnumSchema
    , https___w3id_org_cwl_cwl::InputSchema {
    heap_object<std::vector<std::string>> symbols;
    heap_object<anon_enum_d961d79c225752b9fadb617367615ab176b47d77> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct InputArraySchema
    : https___w3id_org_cwl_salad::ArraySchema
    , https___w3id_org_cwl_cwl::InputSchema {
    heap_object<std::variant<CWLType, InputRecordSchema, InputEnumSchema, InputArraySchema, std::string, std::vector<std::variant<CWLType, InputRecordSchema, InputEnumSchema, InputArraySchema, std::string>>>> items;
    heap_object<anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct OutputRecordField
    : https___w3id_org_cwl_salad::RecordField
    , https___w3id_org_cwl_cwl::FieldBase
    , https___w3id_org_cwl_cwl::OutputFormat {
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::string> name;
    heap_object<std::variant<CWLType, OutputRecordSchema, OutputEnumSchema, OutputArraySchema, std::string, std::vector<std::variant<CWLType, OutputRecordSchema, OutputEnumSchema, OutputArraySchema, std::string>>>> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, SecondaryFileSchema, std::vector<SecondaryFileSchema>>> secondaryFiles;
    heap_object<std::variant<std::monostate, bool>> streamable;
    heap_object<std::variant<std::monostate, std::string, Expression>> format;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct OutputRecordSchema
    : https___w3id_org_cwl_salad::RecordSchema
    , https___w3id_org_cwl_cwl::OutputSchema {
    heap_object<std::variant<std::monostate, std::vector<OutputRecordField>>> fields;
    heap_object<anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct OutputEnumSchema
    : https___w3id_org_cwl_salad::EnumSchema
    , https___w3id_org_cwl_cwl::OutputSchema {
    heap_object<std::vector<std::string>> symbols;
    heap_object<anon_enum_d961d79c225752b9fadb617367615ab176b47d77> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct OutputArraySchema
    : https___w3id_org_cwl_salad::ArraySchema
    , https___w3id_org_cwl_cwl::OutputSchema {
    heap_object<std::variant<CWLType, OutputRecordSchema, OutputEnumSchema, OutputArraySchema, std::string, std::vector<std::variant<CWLType, OutputRecordSchema, OutputEnumSchema, OutputArraySchema, std::string>>>> items;
    heap_object<anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct InputParameter
    : https___w3id_org_cwl_cwl::Parameter
    , https___w3id_org_cwl_cwl::InputFormat
    , https___w3id_org_cwl_cwl::LoadContents {
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, SecondaryFileSchema, std::vector<SecondaryFileSchema>>> secondaryFiles;
    heap_object<std::variant<std::monostate, bool>> streamable;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> id;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>, Expression>> format;
    heap_object<std::variant<std::monostate, bool>> loadContents;
    heap_object<std::variant<std::monostate, LoadListingEnum>> loadListing;
    heap_object<std::variant<std::monostate, File, Directory, std::any>> default_;
    virtual ~InputParameter() = 0;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct OutputParameter
    : https___w3id_org_cwl_cwl::Parameter
    , https___w3id_org_cwl_cwl::OutputFormat {
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, SecondaryFileSchema, std::vector<SecondaryFileSchema>>> secondaryFiles;
    heap_object<std::variant<std::monostate, bool>> streamable;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> id;
    heap_object<std::variant<std::monostate, std::string, Expression>> format;
    virtual ~OutputParameter() = 0;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct ProcessRequirement {
    virtual ~ProcessRequirement() = 0;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct Process
    : https___w3id_org_cwl_cwl::Identified
    , https___w3id_org_cwl_cwl::Labeled
    , https___w3id_org_cwl_salad::Documented {
    heap_object<std::variant<std::monostate, std::string>> id;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::vector<std::variant<CommandInputParameter>>> inputs;
    heap_object<std::vector<std::variant<CommandOutputParameter>>> outputs;
    heap_object<std::variant<std::monostate, std::vector<std::variant<InlineJavascriptRequirement, SchemaDefRequirement, LoadListingRequirement, DockerRequirement, SoftwareRequirement, InitialWorkDirRequirement, EnvVarRequirement, ShellCommandRequirement, ResourceRequirement, WorkReuse, NetworkAccess, InplaceUpdateRequirement, ToolTimeLimit>>>> requirements;
    heap_object<std::variant<std::monostate, std::vector<std::variant<InlineJavascriptRequirement, SchemaDefRequirement, LoadListingRequirement, DockerRequirement, SoftwareRequirement, InitialWorkDirRequirement, EnvVarRequirement, ShellCommandRequirement, ResourceRequirement, WorkReuse, NetworkAccess, InplaceUpdateRequirement, ToolTimeLimit, std::any>>>> hints;
    heap_object<std::variant<std::monostate, CWLVersion>> cwlVersion;
    heap_object<std::variant<std::monostate, std::vector<std::string>>> intent;
    virtual ~Process() = 0;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct InlineJavascriptRequirement
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<InlineJavascriptRequirement_class_InlineJavascriptRequirement_class> class_;
    heap_object<std::variant<std::monostate, std::vector<std::string>>> expressionLib;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandInputSchema {
    virtual ~CommandInputSchema() = 0;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct SchemaDefRequirement
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<SchemaDefRequirement_class_SchemaDefRequirement_class> class_;
    heap_object<std::vector<std::variant<CommandInputRecordSchema, CommandInputEnumSchema, CommandInputArraySchema>>> types;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct SecondaryFileSchema {
    heap_object<std::variant<std::string, Expression>> pattern;
    heap_object<std::variant<std::monostate, bool, Expression>> required;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct LoadListingRequirement
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<LoadListingRequirement_class_LoadListingRequirement_class> class_;
    heap_object<std::variant<std::monostate, LoadListingEnum>> loadListing;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct EnvironmentDef {
    heap_object<std::string> envName;
    heap_object<std::variant<std::string, Expression>> envValue;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandLineBinding
    : https___w3id_org_cwl_cwl::InputBinding {
    heap_object<std::variant<std::monostate, bool>> loadContents;
    heap_object<std::variant<std::monostate, int32_t, Expression>> position;
    heap_object<std::variant<std::monostate, std::string>> prefix;
    heap_object<std::variant<std::monostate, bool>> separate;
    heap_object<std::variant<std::monostate, std::string>> itemSeparator;
    heap_object<std::variant<std::monostate, std::string, Expression>> valueFrom;
    heap_object<std::variant<std::monostate, bool>> shellQuote;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandOutputBinding
    : https___w3id_org_cwl_cwl::LoadContents {
    heap_object<std::variant<std::monostate, bool>> loadContents;
    heap_object<std::variant<std::monostate, LoadListingEnum>> loadListing;
    heap_object<std::variant<std::monostate, std::string, Expression, std::vector<std::string>>> glob;
    heap_object<std::variant<std::monostate, Expression>> outputEval;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandLineBindable {
    heap_object<std::variant<std::monostate, CommandLineBinding>> inputBinding;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandInputRecordField
    : https___w3id_org_cwl_cwl::InputRecordField
    , https___w3id_org_cwl_cwl::CommandLineBindable {
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::string> name;
    heap_object<std::variant<CWLType, CommandInputRecordSchema, CommandInputEnumSchema, CommandInputArraySchema, std::string, std::vector<std::variant<CWLType, CommandInputRecordSchema, CommandInputEnumSchema, CommandInputArraySchema, std::string>>>> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, SecondaryFileSchema, std::vector<SecondaryFileSchema>>> secondaryFiles;
    heap_object<std::variant<std::monostate, bool>> streamable;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>, Expression>> format;
    heap_object<std::variant<std::monostate, bool>> loadContents;
    heap_object<std::variant<std::monostate, LoadListingEnum>> loadListing;
    heap_object<std::variant<std::monostate, CommandLineBinding>> inputBinding;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandInputRecordSchema
    : https___w3id_org_cwl_cwl::InputRecordSchema
    , https___w3id_org_cwl_cwl::CommandInputSchema
    , https___w3id_org_cwl_cwl::CommandLineBindable {
    heap_object<std::variant<std::monostate, std::vector<CommandInputRecordField>>> fields;
    heap_object<anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    heap_object<std::variant<std::monostate, CommandLineBinding>> inputBinding;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandInputEnumSchema
    : https___w3id_org_cwl_cwl::InputEnumSchema
    , https___w3id_org_cwl_cwl::CommandInputSchema
    , https___w3id_org_cwl_cwl::CommandLineBindable {
    heap_object<std::vector<std::string>> symbols;
    heap_object<anon_enum_d961d79c225752b9fadb617367615ab176b47d77> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    heap_object<std::variant<std::monostate, CommandLineBinding>> inputBinding;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandInputArraySchema
    : https___w3id_org_cwl_cwl::InputArraySchema
    , https___w3id_org_cwl_cwl::CommandInputSchema
    , https___w3id_org_cwl_cwl::CommandLineBindable {
    heap_object<std::variant<CWLType, CommandInputRecordSchema, CommandInputEnumSchema, CommandInputArraySchema, std::string, std::vector<std::variant<CWLType, CommandInputRecordSchema, CommandInputEnumSchema, CommandInputArraySchema, std::string>>>> items;
    heap_object<anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    heap_object<std::variant<std::monostate, CommandLineBinding>> inputBinding;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandOutputRecordField
    : https___w3id_org_cwl_cwl::OutputRecordField {
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::string> name;
    heap_object<std::variant<CWLType, CommandOutputRecordSchema, CommandOutputEnumSchema, CommandOutputArraySchema, std::string, std::vector<std::variant<CWLType, CommandOutputRecordSchema, CommandOutputEnumSchema, CommandOutputArraySchema, std::string>>>> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, SecondaryFileSchema, std::vector<SecondaryFileSchema>>> secondaryFiles;
    heap_object<std::variant<std::monostate, bool>> streamable;
    heap_object<std::variant<std::monostate, std::string, Expression>> format;
    heap_object<std::variant<std::monostate, CommandOutputBinding>> outputBinding;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandOutputRecordSchema
    : https___w3id_org_cwl_cwl::OutputRecordSchema {
    heap_object<std::variant<std::monostate, std::vector<CommandOutputRecordField>>> fields;
    heap_object<anon_enum_d9cba076fca539106791a4f46d198c7fcfbdb779> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandOutputEnumSchema
    : https___w3id_org_cwl_cwl::OutputEnumSchema {
    heap_object<std::vector<std::string>> symbols;
    heap_object<anon_enum_d961d79c225752b9fadb617367615ab176b47d77> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandOutputArraySchema
    : https___w3id_org_cwl_cwl::OutputArraySchema {
    heap_object<std::variant<CWLType, CommandOutputRecordSchema, CommandOutputEnumSchema, CommandOutputArraySchema, std::string, std::vector<std::variant<CWLType, CommandOutputRecordSchema, CommandOutputEnumSchema, CommandOutputArraySchema, std::string>>>> items;
    heap_object<anon_enum_d062602be0b4b8fd33e69e29a841317b6ab665bc> type;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> name;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandInputParameter
    : https___w3id_org_cwl_cwl::InputParameter {
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, SecondaryFileSchema, std::vector<SecondaryFileSchema>>> secondaryFiles;
    heap_object<std::variant<std::monostate, bool>> streamable;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> id;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>, Expression>> format;
    heap_object<std::variant<std::monostate, bool>> loadContents;
    heap_object<std::variant<std::monostate, LoadListingEnum>> loadListing;
    heap_object<std::variant<std::monostate, File, Directory, std::any>> default_;
    heap_object<std::variant<CWLType, stdin_, CommandInputRecordSchema, CommandInputEnumSchema, CommandInputArraySchema, std::string, std::vector<std::variant<CWLType, CommandInputRecordSchema, CommandInputEnumSchema, CommandInputArraySchema, std::string>>>> type;
    heap_object<std::variant<std::monostate, CommandLineBinding>> inputBinding;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandOutputParameter
    : https___w3id_org_cwl_cwl::OutputParameter {
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, SecondaryFileSchema, std::vector<SecondaryFileSchema>>> secondaryFiles;
    heap_object<std::variant<std::monostate, bool>> streamable;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::variant<std::monostate, std::string>> id;
    heap_object<std::variant<std::monostate, std::string, Expression>> format;
    heap_object<std::variant<CWLType, stdout_, stderr_, CommandOutputRecordSchema, CommandOutputEnumSchema, CommandOutputArraySchema, std::string, std::vector<std::variant<CWLType, CommandOutputRecordSchema, CommandOutputEnumSchema, CommandOutputArraySchema, std::string>>>> type;
    heap_object<std::variant<std::monostate, CommandOutputBinding>> outputBinding;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct CommandLineTool
    : https___w3id_org_cwl_cwl::Process {
    heap_object<std::variant<std::monostate, std::string>> id;
    heap_object<std::variant<std::monostate, std::string>> label;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> doc;
    heap_object<std::vector<CommandInputParameter>> inputs;
    heap_object<std::vector<CommandOutputParameter>> outputs;
    heap_object<std::variant<std::monostate, std::vector<std::variant<InlineJavascriptRequirement, SchemaDefRequirement, LoadListingRequirement, DockerRequirement, SoftwareRequirement, InitialWorkDirRequirement, EnvVarRequirement, ShellCommandRequirement, ResourceRequirement, WorkReuse, NetworkAccess, InplaceUpdateRequirement, ToolTimeLimit>>>> requirements;
    heap_object<std::variant<std::monostate, std::vector<std::variant<InlineJavascriptRequirement, SchemaDefRequirement, LoadListingRequirement, DockerRequirement, SoftwareRequirement, InitialWorkDirRequirement, EnvVarRequirement, ShellCommandRequirement, ResourceRequirement, WorkReuse, NetworkAccess, InplaceUpdateRequirement, ToolTimeLimit, std::any>>>> hints;
    heap_object<std::variant<std::monostate, CWLVersion>> cwlVersion;
    heap_object<std::variant<std::monostate, std::vector<std::string>>> intent;
    heap_object<CommandLineTool_class_CommandLineTool_class> class_;
    heap_object<std::variant<std::monostate, std::string, std::vector<std::string>>> baseCommand;
    heap_object<std::variant<std::monostate, std::vector<std::variant<std::string, Expression, CommandLineBinding>>>> arguments;
    heap_object<std::variant<std::monostate, std::string, Expression>> stdin_;
    heap_object<std::variant<std::monostate, std::string, Expression>> stderr_;
    heap_object<std::variant<std::monostate, std::string, Expression>> stdout_;
    heap_object<std::variant<std::monostate, std::vector<int32_t>>> successCodes;
    heap_object<std::variant<std::monostate, std::vector<int32_t>>> temporaryFailCodes;
    heap_object<std::variant<std::monostate, std::vector<int32_t>>> permanentFailCodes;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct DockerRequirement
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<DockerRequirement_class_DockerRequirement_class> class_;
    heap_object<std::variant<std::monostate, std::string>> dockerPull;
    heap_object<std::variant<std::monostate, std::string>> dockerLoad;
    heap_object<std::variant<std::monostate, std::string>> dockerFile;
    heap_object<std::variant<std::monostate, std::string>> dockerImport;
    heap_object<std::variant<std::monostate, std::string>> dockerImageId;
    heap_object<std::variant<std::monostate, std::string>> dockerOutputDirectory;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct SoftwareRequirement
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<SoftwareRequirement_class_SoftwareRequirement_class> class_;
    heap_object<std::vector<SoftwarePackage>> packages;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct SoftwarePackage {
    heap_object<std::string> package;
    heap_object<std::variant<std::monostate, std::vector<std::string>>> version;
    heap_object<std::variant<std::monostate, std::vector<std::string>>> specs;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct Dirent {
    heap_object<std::variant<std::monostate, std::string, Expression>> entryname;
    heap_object<std::variant<std::string, Expression>> entry;
    heap_object<std::variant<std::monostate, bool>> writable;
    virtual auto toYaml() const -> YAML::Node;
};
}

namespace https___w3id_org_cwl_cwl {
struct InitialWorkDirRequirement
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<InitialWorkDirRequirement_class_InitialWorkDirRequirement_class> class_;
    heap_object<std::variant<Expression, std::vector<std::variant<std::monostate, Dirent, Expression, File, Directory, std::vector<std::variant<File, Directory>>>>>> listing;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct EnvVarRequirement
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<EnvVarRequirement_class_EnvVarRequirement_class> class_;
    heap_object<std::vector<EnvironmentDef>> envDef;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct ShellCommandRequirement
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<ShellCommandRequirement_class_ShellCommandRequirement_class> class_;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct ResourceRequirement
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<ResourceRequirement_class_ResourceRequirement_class> class_;
    heap_object<std::variant<std::monostate, int32_t, int64_t, float, Expression>> coresMin;
    heap_object<std::variant<std::monostate, int32_t, int64_t, float, Expression>> coresMax;
    heap_object<std::variant<std::monostate, int32_t, int64_t, float, Expression>> ramMin;
    heap_object<std::variant<std::monostate, int32_t, int64_t, float, Expression>> ramMax;
    heap_object<std::variant<std::monostate, int32_t, int64_t, float, Expression>> tmpdirMin;
    heap_object<std::variant<std::monostate, int32_t, int64_t, float, Expression>> tmpdirMax;
    heap_object<std::variant<std::monostate, int32_t, int64_t, float, Expression>> outdirMin;
    heap_object<std::variant<std::monostate, int32_t, int64_t, float, Expression>> outdirMax;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct WorkReuse
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<WorkReuse_class_WorkReuse_class> class_;
    heap_object<std::variant<bool, Expression>> enableReuse;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct NetworkAccess
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<NetworkAccess_class_NetworkAccess_class> class_;
    heap_object<std::variant<bool, Expression>> networkAccess;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct InplaceUpdateRequirement
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<InplaceUpdateRequirement_class_InplaceUpdateRequirement_class> class_;
    heap_object<bool> inplaceUpdate;
    auto toYaml() const -> YAML::Node override;
};
}

namespace https___w3id_org_cwl_cwl {
struct ToolTimeLimit
    : https___w3id_org_cwl_cwl::ProcessRequirement {
    heap_object<ToolTimeLimit_class_ToolTimeLimit_class> class_;
    heap_object<std::variant<int32_t, int64_t, Expression>> timelimit;
    auto toYaml() const -> YAML::Node override;
};
}

inline https___w3id_org_cwl_salad::Documented::~Documented() = default;
inline auto https___w3id_org_cwl_salad::Documented::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "doc", toYaml(*doc));
    return n;
}
inline auto https___w3id_org_cwl_salad::RecordField::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_salad::Documented::toYaml());
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    addYamlField(n, "type", toYaml(*type));
    return n;
}
inline auto https___w3id_org_cwl_salad::RecordSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "fields", toYaml(*fields));
    addYamlField(n, "type", toYaml(*type));
    return n;
}
inline auto https___w3id_org_cwl_salad::EnumSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "symbols", toYaml(*symbols));
    addYamlField(n, "type", toYaml(*type));
    return n;
}
inline auto https___w3id_org_cwl_salad::ArraySchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "items", toYaml(*items));
    addYamlField(n, "type", toYaml(*type));
    return n;
}
inline auto https___w3id_org_cwl_cwl::File::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "location", toYaml(*location));
    addYamlField(n, "path", toYaml(*path));
    addYamlField(n, "basename", toYaml(*basename));
    addYamlField(n, "dirname", toYaml(*dirname));
    addYamlField(n, "nameroot", toYaml(*nameroot));
    addYamlField(n, "nameext", toYaml(*nameext));
    addYamlField(n, "checksum", toYaml(*checksum));
    addYamlField(n, "size", toYaml(*size));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "format", toYaml(*format));
    addYamlField(n, "contents", toYaml(*contents));
    return n;
}
inline auto https___w3id_org_cwl_cwl::Directory::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "location", toYaml(*location));
    addYamlField(n, "path", toYaml(*path));
    addYamlField(n, "basename", toYaml(*basename));
    addYamlField(n, "listing", toYaml(*listing));
    return n;
}
inline https___w3id_org_cwl_cwl::Labeled::~Labeled() = default;
inline auto https___w3id_org_cwl_cwl::Labeled::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "label", toYaml(*label));
    return n;
}
inline https___w3id_org_cwl_cwl::Identified::~Identified() = default;
inline auto https___w3id_org_cwl_cwl::Identified::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "id", toYaml(*id));
    return n;
}
inline https___w3id_org_cwl_cwl::LoadContents::~LoadContents() = default;
inline auto https___w3id_org_cwl_cwl::LoadContents::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "loadContents", toYaml(*loadContents));
    addYamlField(n, "loadListing", toYaml(*loadListing));
    return n;
}
inline https___w3id_org_cwl_cwl::FieldBase::~FieldBase() = default;
inline auto https___w3id_org_cwl_cwl::FieldBase::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::Labeled::toYaml());
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "streamable", toYaml(*streamable));
    return n;
}
inline https___w3id_org_cwl_cwl::InputFormat::~InputFormat() = default;
inline auto https___w3id_org_cwl_cwl::InputFormat::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "format", toYaml(*format));
    return n;
}
inline https___w3id_org_cwl_cwl::OutputFormat::~OutputFormat() = default;
inline auto https___w3id_org_cwl_cwl::OutputFormat::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "format", toYaml(*format));
    return n;
}
inline https___w3id_org_cwl_cwl::Parameter::~Parameter() = default;
inline auto https___w3id_org_cwl_cwl::Parameter::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::FieldBase::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_salad::Documented::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::Identified::toYaml());
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "streamable", toYaml(*streamable));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "id", toYaml(*id));
    return n;
}
inline auto https___w3id_org_cwl_cwl::InputBinding::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "loadContents", toYaml(*loadContents));
    return n;
}
inline https___w3id_org_cwl_cwl::IOSchema::~IOSchema() = default;
inline auto https___w3id_org_cwl_cwl::IOSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::Labeled::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_salad::Documented::toYaml());
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline https___w3id_org_cwl_cwl::InputSchema::~InputSchema() = default;
inline auto https___w3id_org_cwl_cwl::InputSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::IOSchema::toYaml());
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline https___w3id_org_cwl_cwl::OutputSchema::~OutputSchema() = default;
inline auto https___w3id_org_cwl_cwl::OutputSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::IOSchema::toYaml());
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline auto https___w3id_org_cwl_cwl::InputRecordField::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_salad::RecordField::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::FieldBase::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputFormat::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::LoadContents::toYaml());
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "streamable", toYaml(*streamable));
    addYamlField(n, "format", toYaml(*format));
    addYamlField(n, "loadContents", toYaml(*loadContents));
    addYamlField(n, "loadListing", toYaml(*loadListing));
    return n;
}
inline auto https___w3id_org_cwl_cwl::InputRecordSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_salad::RecordSchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputSchema::toYaml());
    addYamlField(n, "fields", toYaml(*fields));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline auto https___w3id_org_cwl_cwl::InputEnumSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_salad::EnumSchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputSchema::toYaml());
    addYamlField(n, "symbols", toYaml(*symbols));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline auto https___w3id_org_cwl_cwl::InputArraySchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_salad::ArraySchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputSchema::toYaml());
    addYamlField(n, "items", toYaml(*items));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline auto https___w3id_org_cwl_cwl::OutputRecordField::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_salad::RecordField::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::FieldBase::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::OutputFormat::toYaml());
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "streamable", toYaml(*streamable));
    addYamlField(n, "format", toYaml(*format));
    return n;
}
inline auto https___w3id_org_cwl_cwl::OutputRecordSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_salad::RecordSchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::OutputSchema::toYaml());
    addYamlField(n, "fields", toYaml(*fields));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline auto https___w3id_org_cwl_cwl::OutputEnumSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_salad::EnumSchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::OutputSchema::toYaml());
    addYamlField(n, "symbols", toYaml(*symbols));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline auto https___w3id_org_cwl_cwl::OutputArraySchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_salad::ArraySchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::OutputSchema::toYaml());
    addYamlField(n, "items", toYaml(*items));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline https___w3id_org_cwl_cwl::InputParameter::~InputParameter() = default;
inline auto https___w3id_org_cwl_cwl::InputParameter::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::Parameter::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputFormat::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::LoadContents::toYaml());
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "streamable", toYaml(*streamable));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "id", toYaml(*id));
    addYamlField(n, "format", toYaml(*format));
    addYamlField(n, "loadContents", toYaml(*loadContents));
    addYamlField(n, "loadListing", toYaml(*loadListing));
    addYamlField(n, "default", toYaml(*default_));
    return n;
}
inline https___w3id_org_cwl_cwl::OutputParameter::~OutputParameter() = default;
inline auto https___w3id_org_cwl_cwl::OutputParameter::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::Parameter::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::OutputFormat::toYaml());
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "streamable", toYaml(*streamable));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "id", toYaml(*id));
    addYamlField(n, "format", toYaml(*format));
    return n;
}
inline https___w3id_org_cwl_cwl::ProcessRequirement::~ProcessRequirement() = default;
inline auto https___w3id_org_cwl_cwl::ProcessRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    return n;
}
inline https___w3id_org_cwl_cwl::Process::~Process() = default;
inline auto https___w3id_org_cwl_cwl::Process::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::Identified::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::Labeled::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_salad::Documented::toYaml());
    addYamlField(n, "id", toYaml(*id));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "inputs", toYaml(*inputs));
    addYamlField(n, "outputs", toYaml(*outputs));
    addYamlField(n, "requirements", toYaml(*requirements));
    addYamlField(n, "hints", toYaml(*hints));
    addYamlField(n, "cwlVersion", toYaml(*cwlVersion));
    addYamlField(n, "intent", toYaml(*intent));
    return n;
}
inline auto https___w3id_org_cwl_cwl::InlineJavascriptRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "expressionLib", toYaml(*expressionLib));
    return n;
}
inline https___w3id_org_cwl_cwl::CommandInputSchema::~CommandInputSchema() = default;
inline auto https___w3id_org_cwl_cwl::CommandInputSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    return n;
}
inline auto https___w3id_org_cwl_cwl::SchemaDefRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "types", toYaml(*types));
    return n;
}
inline auto https___w3id_org_cwl_cwl::SecondaryFileSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "pattern", toYaml(*pattern));
    addYamlField(n, "required", toYaml(*required));
    return n;
}
inline auto https___w3id_org_cwl_cwl::LoadListingRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "loadListing", toYaml(*loadListing));
    return n;
}
inline auto https___w3id_org_cwl_cwl::EnvironmentDef::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "envName", toYaml(*envName));
    addYamlField(n, "envValue", toYaml(*envValue));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandLineBinding::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputBinding::toYaml());
    addYamlField(n, "loadContents", toYaml(*loadContents));
    addYamlField(n, "position", toYaml(*position));
    addYamlField(n, "prefix", toYaml(*prefix));
    addYamlField(n, "separate", toYaml(*separate));
    addYamlField(n, "itemSeparator", toYaml(*itemSeparator));
    addYamlField(n, "valueFrom", toYaml(*valueFrom));
    addYamlField(n, "shellQuote", toYaml(*shellQuote));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandOutputBinding::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::LoadContents::toYaml());
    addYamlField(n, "loadContents", toYaml(*loadContents));
    addYamlField(n, "loadListing", toYaml(*loadListing));
    addYamlField(n, "glob", toYaml(*glob));
    addYamlField(n, "outputEval", toYaml(*outputEval));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandLineBindable::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "inputBinding", toYaml(*inputBinding));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandInputRecordField::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputRecordField::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::CommandLineBindable::toYaml());
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "streamable", toYaml(*streamable));
    addYamlField(n, "format", toYaml(*format));
    addYamlField(n, "loadContents", toYaml(*loadContents));
    addYamlField(n, "loadListing", toYaml(*loadListing));
    addYamlField(n, "inputBinding", toYaml(*inputBinding));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandInputRecordSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputRecordSchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::CommandInputSchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::CommandLineBindable::toYaml());
    addYamlField(n, "fields", toYaml(*fields));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    addYamlField(n, "inputBinding", toYaml(*inputBinding));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandInputEnumSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputEnumSchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::CommandInputSchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::CommandLineBindable::toYaml());
    addYamlField(n, "symbols", toYaml(*symbols));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    addYamlField(n, "inputBinding", toYaml(*inputBinding));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandInputArraySchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputArraySchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::CommandInputSchema::toYaml());
    n = mergeYaml(n, https___w3id_org_cwl_cwl::CommandLineBindable::toYaml());
    addYamlField(n, "items", toYaml(*items));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    addYamlField(n, "inputBinding", toYaml(*inputBinding));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandOutputRecordField::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::OutputRecordField::toYaml());
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "streamable", toYaml(*streamable));
    addYamlField(n, "format", toYaml(*format));
    addYamlField(n, "outputBinding", toYaml(*outputBinding));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandOutputRecordSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::OutputRecordSchema::toYaml());
    addYamlField(n, "fields", toYaml(*fields));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandOutputEnumSchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::OutputEnumSchema::toYaml());
    addYamlField(n, "symbols", toYaml(*symbols));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandOutputArraySchema::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::OutputArraySchema::toYaml());
    addYamlField(n, "items", toYaml(*items));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "name", toYaml(*name));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandInputParameter::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::InputParameter::toYaml());
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "streamable", toYaml(*streamable));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "id", toYaml(*id));
    addYamlField(n, "format", toYaml(*format));
    addYamlField(n, "loadContents", toYaml(*loadContents));
    addYamlField(n, "loadListing", toYaml(*loadListing));
    addYamlField(n, "default", toYaml(*default_));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "inputBinding", toYaml(*inputBinding));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandOutputParameter::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::OutputParameter::toYaml());
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "secondaryFiles", toYaml(*secondaryFiles));
    addYamlField(n, "streamable", toYaml(*streamable));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "id", toYaml(*id));
    addYamlField(n, "format", toYaml(*format));
    addYamlField(n, "type", toYaml(*type));
    addYamlField(n, "outputBinding", toYaml(*outputBinding));
    return n;
}
inline auto https___w3id_org_cwl_cwl::CommandLineTool::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::Process::toYaml());
    addYamlField(n, "id", toYaml(*id));
    addYamlField(n, "label", toYaml(*label));
    addYamlField(n, "doc", toYaml(*doc));
    addYamlField(n, "inputs", toYaml(*inputs));
    addYamlField(n, "outputs", toYaml(*outputs));
    addYamlField(n, "requirements", toYaml(*requirements));
    addYamlField(n, "hints", toYaml(*hints));
    addYamlField(n, "cwlVersion", toYaml(*cwlVersion));
    addYamlField(n, "intent", toYaml(*intent));
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "baseCommand", toYaml(*baseCommand));
    addYamlField(n, "arguments", toYaml(*arguments));
    addYamlField(n, "stdin", toYaml(*stdin_));
    addYamlField(n, "stderr", toYaml(*stderr_));
    addYamlField(n, "stdout", toYaml(*stdout_));
    addYamlField(n, "successCodes", toYaml(*successCodes));
    addYamlField(n, "temporaryFailCodes", toYaml(*temporaryFailCodes));
    addYamlField(n, "permanentFailCodes", toYaml(*permanentFailCodes));
    return n;
}
inline auto https___w3id_org_cwl_cwl::DockerRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "dockerPull", toYaml(*dockerPull));
    addYamlField(n, "dockerLoad", toYaml(*dockerLoad));
    addYamlField(n, "dockerFile", toYaml(*dockerFile));
    addYamlField(n, "dockerImport", toYaml(*dockerImport));
    addYamlField(n, "dockerImageId", toYaml(*dockerImageId));
    addYamlField(n, "dockerOutputDirectory", toYaml(*dockerOutputDirectory));
    return n;
}
inline auto https___w3id_org_cwl_cwl::SoftwareRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "packages", toYaml(*packages));
    return n;
}
inline auto https___w3id_org_cwl_cwl::SoftwarePackage::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "package", toYaml(*package));
    addYamlField(n, "version", toYaml(*version));
    addYamlField(n, "specs", toYaml(*specs));
    return n;
}
inline auto https___w3id_org_cwl_cwl::Dirent::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    addYamlField(n, "entryname", toYaml(*entryname));
    addYamlField(n, "entry", toYaml(*entry));
    addYamlField(n, "writable", toYaml(*writable));
    return n;
}
inline auto https___w3id_org_cwl_cwl::InitialWorkDirRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "listing", toYaml(*listing));
    return n;
}
inline auto https___w3id_org_cwl_cwl::EnvVarRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "envDef", toYaml(*envDef));
    return n;
}
inline auto https___w3id_org_cwl_cwl::ShellCommandRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    return n;
}
inline auto https___w3id_org_cwl_cwl::ResourceRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "coresMin", toYaml(*coresMin));
    addYamlField(n, "coresMax", toYaml(*coresMax));
    addYamlField(n, "ramMin", toYaml(*ramMin));
    addYamlField(n, "ramMax", toYaml(*ramMax));
    addYamlField(n, "tmpdirMin", toYaml(*tmpdirMin));
    addYamlField(n, "tmpdirMax", toYaml(*tmpdirMax));
    addYamlField(n, "outdirMin", toYaml(*outdirMin));
    addYamlField(n, "outdirMax", toYaml(*outdirMax));
    return n;
}
inline auto https___w3id_org_cwl_cwl::WorkReuse::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "enableReuse", toYaml(*enableReuse));
    return n;
}
inline auto https___w3id_org_cwl_cwl::NetworkAccess::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "networkAccess", toYaml(*networkAccess));
    return n;
}
inline auto https___w3id_org_cwl_cwl::InplaceUpdateRequirement::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "inplaceUpdate", toYaml(*inplaceUpdate));
    return n;
}
inline auto https___w3id_org_cwl_cwl::ToolTimeLimit::toYaml() const -> YAML::Node {
    using ::toYaml;
    auto n = YAML::Node{};
    n = mergeYaml(n, https___w3id_org_cwl_cwl::ProcessRequirement::toYaml());
    addYamlField(n, "class", toYaml(*class_));
    addYamlField(n, "timelimit", toYaml(*timelimit));
    return n;
}

template <typename T>
auto toYaml(std::vector<T> const& v) -> YAML::Node {
    auto n = YAML::Node(YAML::NodeType::Sequence);
    for (auto const& e : v) {
        n.push_back(toYaml(e));
    }
    return n;
}

template <typename T>
auto toYaml(T const& t) -> YAML::Node {
    if constexpr (std::is_enum_v<T>) {
        return toYaml(t);
    } else {
        return t.toYaml();
    }
}

template <typename ...Args>
auto toYaml(std::variant<Args...> const& t) -> YAML::Node {
    return std::visit([](auto const& e) {
        return toYaml(e);
    }, t);
}
