#version 400

in vec4 vertex;
uniform float angle;
uniform vec4 Color;

out vec4 vertPosition;
out vec3 lightDirection;
out vec3 ed;

const float PI = 3.14159265359;

mat4 rmat(vec4 arr){
  float phi=arr.x/180*PI;
  float c=cos(phi);
  float s=sin(phi);
  float omc=1.0-c;
  vec3 ar = arr.yzw;
  mat4 m =
  mat4(c+ar.x*ar.x*omc,ar.x*ar.y*omc-s*ar.z,ar.x*ar.z*omc+s*ar.y,0,
      ar.x*ar.y*omc+s*ar.z,c+ar.y*ar.y*omc,ar.y*ar.z*omc-s*ar.x,0,
      ar.x*ar.z*omc-s*ar.y,ar.y*ar.z*omc+s*ar.x,c+ar.z*ar.z*omc,0,
      0,0,0,1);

  return m;
}

void main( void ){
 vertPosition = vertex * rmat(vec4(-0.2*angle,vec3(0,1,0)));
 lightDirection = normalize(vec3(-1.0, 1.0, -10.0));
 ed = vec3(0.0,0.0,-1.0);
}
