/* $Id: fatal.c,v 1.6 2002/03/02 19:37:36 sverrehu Exp $ */
/*------------------------------------------------------------------------
 |  FILE            fatal.c
 |  MODULE OF       shhmsg - library for displaying messages.
 |
 |  DESCRIPTION     Function for displaying an error message and
 |                  abort the program.
 |
 |  WRITTEN BY      Sverre H. Huseby <shh@thathost.com>
 +----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "internal.h"
#include "shhmsg.h"

/*-----------------------------------------------------------------------+
|  PUBLIC FUNCTIONS                                                      |
+-----------------------------------------------------------------------*/

/*------------------------------------------------------------------------
 |
 |  NAME          msgFatal
 |
 |  FUNCTION      Show given message and abort the program.
 |
 |  SYNOPSIS      #include "shhmsg.h"
 |                void msgFatal(const char *format, ...);
 |
 |  INPUT         format, ...
 |                        Arguments used as with printf().
 |
 |  RETURNS       Never returns. The program is aborted.
 |
 |  DESCRIPTION   Prints the name of this program followed by ": " and
 |                the given message on the _msgErrorStream, then aborts
 |                the program.
 */
void
msgFatal(const char *format, ...)
{
    va_list ap;

    fflush(stdout);
    fprintf(GET_ERROR_STREAM, "%s: ", msgGetName());
    va_start(ap, format);
    vfprintf(GET_ERROR_STREAM, format, ap);
    va_end(ap);
    exit(99);
}
