/*----------------------------------------------------------------------------
 *
 * Filename: wt_44khz.c
 * Purpose: Wavetable sound libary
 *
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

#include "eas_sndlib.h"

/*----------------------------------------------------------------------------
 * Articulations
 *----------------------------------------------------------------------------
*/
const S_ARTICULATION eas_articulations[] =
{
    { /* articulation 0 */
        { 32767, 31730, 0, 31730 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 1 */
        { 32767, 29669, 0, 29669 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 2 */
        { 32767, 31605, 0, 31701 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 3 */
        { 32767, 29434, 0, 29434 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 4 */
        { 32767, 0, 32767, 32742 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 5 */
        { 32767, 26439, 0, 26439 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 6 */
        { 32767, 32322, 0, 32350 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 7 */
        { 32767, 32715, 32767, 32715 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 8 */
        { 32767, 0, 32767, 0 },
        { 32767, 951, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 9 */
        { 32767, 32558, 0, 32558 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 10 */
        { 32767, 0, 32767, 23749 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -1
    },
    { /* articulation 11 */
        { 32767, 32245, 0, 32245 },
        { 32767, 380, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -44
    },
    { /* articulation 12 */
        { 32767, 27897, 0, 27897 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 56
    },
    { /* articulation 13 */
        { 32767, 32245, 0, 32245 },
        { 32767, 380, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -31
    },
    { /* articulation 14 */
        { 4755, 26439, 0, 26439 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 56
    },
    { /* articulation 15 */
        { 32767, 32187, 0, 32187 },
        { 32767, 380, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -6
    },
    { /* articulation 16 */
        { 32767, 32444, 0, 32480 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 56
    },
    { /* articulation 17 */
        { 32767, 32153, 0, 32153 },
        { 32767, 380, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 6
    },
    { /* articulation 18 */
        { 32767, 32072, 0, 32072 },
        { 32767, 476, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 31
    },
    { /* articulation 19 */
        { 32767, 32363, 0, 32363 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 25
    },
    { /* articulation 20 */
        { 32767, 31901, 0, 31901 },
        { 32767, 476, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 63
    },
    { /* articulation 21 */
        { 32767, 32528, 0, 32518 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -37
    },
    { /* articulation 22 */
        { 9511, 32322, 0, 32337 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -37
    },
    { /* articulation 23 */
        { 32767, 32376, 0, 32398 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -37
    },
    { /* articulation 24 */
        { 32767, 0, 32767, 32715 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 12
    },
    { /* articulation 25 */
        { 32767, 32052, 0, 32052 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -25
    },
    { /* articulation 26 */
        { 32767, 0, 32767, 32715 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 25
    },
    { /* articulation 27 */
        { 32767, 32289, 0, 32271 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -25
    },
    { /* articulation 28 */
        { 32767, 31730, 0, 31730 },
        { 32767, 48, 0, 0 },
        0, 0, 476, 240, 0, 0, 0, 0, -56
    },
    { /* articulation 29 */
        { 32767, 32498, 0, 32492 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -37
    },
    { /* articulation 30 */
        { 32767, 29434, 0, 29434 },
        { 32767, 1902, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 50
    },
    { /* articulation 31 */
        { 32767, 27897, 0, 27897 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -50
    },
    { /* articulation 32 */
        { 32767, 31056, 0, 31056 },
        { 32767, 1902, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -50
    },
    { /* articulation 33 */
        { 32767, 31479, 0, 31476 },
        { 32767, 1902, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -44
    },
    { /* articulation 34 */
        { 32767, 32663, 0, 32663 },
        { 32767, 127, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 25
    },
    { /* articulation 35 */
        { 32767, 0, 32767, 32715 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -63
    },
    { /* articulation 36 */
        { 1902, 27897, 0, 27897 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -63
    },
    { /* articulation 37 */
        { 32767, 27897, 0, 27897 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -59
    },
    { /* articulation 38 */
        { 32767, 31730, 0, 31730 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 50
    },
    { /* articulation 39 */
        { 32767, 30725, 0, 30725 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 44
    },
    { /* articulation 40 */
        { 951, 31730, 0, 31730 },
        { 32767, 190, 0, 0 },
        0, 0, 476, -100, 0, 0, 0, 0, 44
    },
    { /* articulation 41 */
        { 32767, 17213, 0, 17213 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 25
    },
    { /* articulation 42 */
        { 32767, 31295, 0, 31295 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 63
    },
    { /* articulation 43 */
        { 32767, 31479, 0, 31476 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 63
    },
    { /* articulation 44 */
        { 9511, 25581, 0, 25581 },
        { 476, 32767, 32767, 0 },
        0, 0, 476, 100, 0, 0, 0, 0, -25
    },
    { /* articulation 45 */
        { 1902, 23749, 0, 23749 },
        { 476, 32767, 32767, 0 },
        0, 0, 476, 500, 0, 0, 0, 0, -25
    },
    { /* articulation 46 */
        { 32767, 23749, 0, 23749 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -56
    },
    { /* articulation 47 */
        { 32767, 31730, 0, 31730 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, -56
    },
    { /* articulation 48 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 49 */
        { 32767, 31964, 0, 31964 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 50 */
        { 9511, 32363, 0, 32418 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 51 */
        { 32767, 31180, 0, 31180 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 52 */
        { 32767, 32251, 0, 32052 },
        { 32767, 147, 0, 0 },
        0, 0, 476, 0, 10000, 7121, 0, 0, 0
    },
    { /* articulation 53 */
        { 32767, 0, 32767, 32072 },
        { 32767, 32767, 32767, 0 },
        0, 0, 778, 0, -2300, 11920, 0, 0, 0
    },
    { /* articulation 54 */
        { 587, 0, 32767, 32376 },
        { 32767, 63, 0, 0 },
        0, 0, 778, 0, 2000, 10721, 0, 8, 15
    },
    { /* articulation 55 */
        { 587, 0, 32767, 32376 },
        { 476, 63, 0, 0 },
        0, 0, 778, 0, 2000, 9023, 0, 5, 15
    },
    { /* articulation 56 */
        { 3804, 0, 32767, 31477 },
        { 32767, 34, 5898, 0 },
        0, 0, 778, 0, 6000, 9080, 0, 0, -2
    },
    { /* articulation 57 */
        { 32767, 0, 32767, 31005 },
        { 32767, 32767, 32767, 0 },
        0, 0, 778, 0, 0, 0, 0, 0, 1
    },
    { /* articulation 58 */
        { 2570, 0, 32767, 31455 },
        { 32767, 32767, 32767, 0 },
        0, 0, 778, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 59 */
        { 32767, 32663, 0, 29434 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 60 */
        { 32767, 32558, 0, 29434 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 61 */
        { 32767, 32418, 0, 32418 },
        { 32767, 48, 0, 0 },
        0, 69, 495, 0, 2400, 9521, 0, 0, 0
    },
    { /* articulation 62 */
        { 32767, 31476, 0, 31476 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 11738, 0, 16, 0
    },
    { /* articulation 63 */
        { 32767, 32558, 0, 31391 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 64 */
        { 32767, 32245, 0, 32115 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 65 */
        { 32767, 32593, 0, 28809 },
        { 32767, 48, 0, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 66 */
        { 32767, 32408, 0, 32363 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 67 */
        { 32767, 32350, 0, 32350 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 68 */
        { 4755, 32715, 18820, 27897 },
        { 951, 29, 13107, 0 },
        0, 0, 495, 0, 6000, 5535, 0, 4, 0
    },
    { /* articulation 69 */
        { 32767, 32257, 0, 32245 },
        { 32767, 951, 0, 0 },
        0, 103, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 70 */
        { 63, 32727, 3811, 32558 },
        { 48, 19, 32767, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 71 */
        { 2378, 32715, 3566, 30725 },
        { 1902, 32767, 32767, 0 },
        0, 0, 495, 100, 0, 11919, 0, 0, 0
    },
    { /* articulation 72 */
        { 32767, 32349, 0, 32349 },
        { 32767, 168, 0, 0 },
        0, 34, 495, 0, 7000, 9023, 0, 0, 0
    },
    { /* articulation 73 */
        { 32767, 32072, 0, 32072 },
        { 32767, 168, 0, 0 },
        0, 3, 476, 0, 7000, 9023, 0, 0, 0
    },
    { /* articulation 74 */
        { 32767, 32698, 6208, 32349 },
        { 190, 48, 0, 0 },
        0, 0, 495, 0, 3840, 8302, 0, 8, 0
    },
    { /* articulation 75 */
        { 32767, 32418, 0, 32468 },
        { 32767, 190, 0, 0 },
        0, 0, 495, 0, 5000, 8321, 0, 0, 0
    },
    { /* articulation 76 */
        { 32767, 32349, 0, 32349 },
        { 32767, 190, 0, 0 },
        0, 0, 476, 0, 5000, 7934, 0, 0, 0
    },
    { /* articulation 77 */
        { 32767, 32441, 0, 31709 },
        { 32767, 32, 0, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 78 */
        { 32767, 32505, 0, 27897 },
        { 32767, 951, 0, 0 },
        0, 345, 495, 0, 1000, 11107, 0, 0, 0
    },
    { /* articulation 79 */
        { 32767, 32715, 6208, 32349 },
        { 48, 48, 0, 0 },
        0, 69, 811, 0, 3560, 8834, 1, 8, 0
    },
    { /* articulation 80 */
        { 32767, 32564, 0, 29434 },
        { 32767, 95, 0, 0 },
        0, 34, 495, 0, 6000, 9907, 0, 0, 0
    },
    { /* articulation 81 */
        { 32767, 32505, 0, 27897 },
        { 32767, 32, 0, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 82 */
        { 32767, 32245, 18820, 17213 },
        { 32767, 32767, 32767, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 83 */
        { 32767, 32742, 128, 32466 },
        { 32767, 63, 0, 0 },
        0, 0, 495, 0, 0, 11920, 0, 8, 0
    },
    { /* articulation 84 */
        { 32767, 32418, 0, 32418 },
        { 32767, 33, 0, 0 },
        3, 0, 286, 0, 5000, 5535, 0, 0, 0
    },
    { /* articulation 85 */
        { 1902, 32715, 18820, 27897 },
        { 32767, 1012, 0, 0 },
        10, 69, 504, -30, 0, 0, 0, 0, 0
    },
    { /* articulation 86 */
        { 9511, 32715, 18820, 27897 },
        { 380, 48, 0, 0 },
        0, 69, 495, 0, 4473, 7131, 0, 8, 0
    },
    { /* articulation 87 */
        { 951, 32698, 6208, 32468 },
        { 317, 19, 16384, 0 },
        0, 0, 495, 0, 2987, 7877, 0, 12, 0
    },
    { /* articulation 88 */
        { 32767, 32680, 0, 32349 },
        { 32767, 48, 0, 0 },
        0, 0, 581, 0, 4053, 7930, 2, 12, 0
    },
    { /* articulation 89 */
        { 190, 32726, 6208, 32349 },
        { 32767, 56, 0, 0 },
        0, 0, 495, 0, 0, 8887, 0, 0, 0
    },
    { /* articulation 90 */
        { 9511, 32715, 18820, 27897 },
        { 634, 48, 0, 0 },
        0, 69, 495, 0, 5113, 7981, 0, 4, 0
    },
    { /* articulation 91 */
        { 951, 32715, 6208, 31730 },
        { 951, 63, 0, 0 },
        0, 69, 495, 0, 3500, 7877, 0, 5, 0
    },
    { /* articulation 92 */
        { 951, 32715, 6208, 31730 },
        { 634, 48, 0, 0 },
        0, 69, 476, 0, 4773, 8355, 0, 5, 0
    },
    { /* articulation 93 */
        { 238, 32715, 10809, 32349 },
        { 32767, 32767, 32767, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 94 */
        { 1902, 32715, 18820, 31476 },
        { 32767, 32767, 32767, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 95 */
        { 3804, 32715, 18820, 23749 },
        { 1268, 130, 0, 0 },
        0, 69, 495, 0, 1200, 11690, 0, 4, 0
    },
    { /* articulation 96 */
        { 19021, 32618, 15076, 31476 },
        { 32767, 32767, 32767, 0 },
        0, 72, 1091, 0, 0, 11919, 1, 0, 0
    },
    { /* articulation 97 */
        { 32767, 0, 32767, 32715 },
        { 190, 32767, 32767, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 98 */
        { 32767, 32072, 0, 32072 },
        { 32767, 317, 0, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 99 */
        { 32767, 32663, 0, 27897 },
        { 634, 95, 13107, 0 },
        0, 69, 495, 0, 3200, 8321, 0, 0, 0
    },
    { /* articulation 100 */
        { 32767, 0, 32767, 0 },
        { 32767, 32767, 32767, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 101 */
        { 32767, 32418, 0, 27897 },
        { 32767, 543, 0, 0 },
        0, 69, 495, 0, 8187, 5535, 0, 5, 0
    },
    { /* articulation 102 */
        { 19021, 32663, 0, 31056 },
        { 32767, 95, 7667, 0 },
        5, 0, 495, 0, 6053, 5535, 0, 5, 0
    },
    { /* articulation 103 */
        { 32767, 32715, 18820, 27897 },
        { 951, 48, 0, 0 },
        0, 0, 495, 0, 2700, 9852, 0, 0, 0
    },
    { /* articulation 104 */
        { 32767, 32715, 18820, 30234 },
        { 951, 48, 0, 0 },
        0, 0, 495, 0, 2700, 9852, 0, 0, 0
    },
    { /* articulation 105 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 634, 0, 0 },
        0, 103, 476, 0, 2500, 10490, 1, 8, 0
    },
    { /* articulation 106 */
        { 32767, 32715, 23493, 27897 },
        { 32767, 190, 0, 0 },
        0, 69, 494, 0, 4000, 10223, 1, 4, 0
    },
    { /* articulation 107 */
        { 32767, 32715, 18820, 30234 },
        { 32767, 63, 7667, 0 },
        0, 0, 495, 0, 1813, 9154, 0, 0, 0
    },
    { /* articulation 108 */
        { 19021, 32245, 0, 32245 },
        { 32767, 190, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 109 */
        { 32767, 31964, 0, 31605 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 11690, 0, 0, 0
    },
    { /* articulation 110 */
        { 32767, 31730, 0, 31730 },
        { 32767, 190, 0, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 111 */
        { 32767, 32558, 18820, 30234 },
        { 32767, 48, 0, 0 },
        12, 69, 476, 0, 3000, 10223, 0, 0, 0
    },
    { /* articulation 112 */
        { 32767, 32558, 18820, 30234 },
        { 32767, 32, 0, 0 },
        12, 69, 476, 0, 1900, 10031, 0, 0, 0
    },
    { /* articulation 113 */
        { 32767, 32715, 18820, 29434 },
        { 32767, 32, 0, 0 },
        12, 69, 494, 0, 1000, 11107, 0, 0, 0
    },
    { /* articulation 114 */
        { 32767, 32715, 18820, 29434 },
        { 32767, 32, 0, 0 },
        12, 69, 494, 0, 2000, 11107, 0, 0, 0
    },
    { /* articulation 115 */
        { 32767, 32636, 0, 29434 },
        { 32767, 95, 0, 0 },
        0, 34, 495, 0, 4000, 8321, 0, 0, 0
    },
    { /* articulation 116 */
        { 32767, 32297, 19893, 17213 },
        { 32767, 238, 0, 0 },
        0, 69, 726, 0, 0, 11919, 0, 0, 0
    },
    { /* articulation 117 */
        { 9511, 32418, 23493, 17213 },
        { 32767, 32767, 32767, 0 },
        0, 69, 678, 0, 0, 11877, 1, 0, 0
    },
    { /* articulation 118 */
        { 32767, 32618, 0, 27897 },
        { 32767, 95, 0, 0 },
        0, 69, 495, 0, 3500, 9023, 0, 0, 0
    },
    { /* articulation 119 */
        { 32767, 23749, 23493, 0 },
        { 32767, 32767, 32767, 0 },
        0, 34, 761, 0, 0, 10925, 1, 0, 0
    },
    { /* articulation 120 */
        { 32767, 32636, 0, 29434 },
        { 32767, 95, 0, 0 },
        0, 103, 495, 0, 3200, 8721, 0, 4, 0
    },
    { /* articulation 121 */
        { 1902, 32715, 18820, 27897 },
        { 32767, 32767, 32767, 0 },
        0, 69, 495, 0, 0, 0, 1, 0, 0
    },
    { /* articulation 122 */
        { 4755, 32715, 18820, 28809 },
        { 32767, 32767, 32767, 0 },
        0, 69, 495, 0, 0, 11877, 0, 8, 0
    },
    { /* articulation 123 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 16, 0, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 124 */
        { 32767, 32663, 0, 27897 },
        { 32767, 190, 0, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 125 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 12, 0, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 126 */
        { 32767, 31730, 0, 31730 },
        { 32767, 380, 0, 0 },
        0, 0, 495, 0, 3000, 10223, 0, 8, 0
    },
    { /* articulation 127 */
        { 63, 0, 32767, 32558 },
        { 32767, 32767, 32767, 0 },
        0, 0, 761, 0, 0, 11423, 4, 0, 0
    },
    { /* articulation 128 */
        { 476, 32595, 0, 32577 },
        { 32767, 10, 0, 0 },
        0, 0, 495, 0, 0, 11423, 0, 0, 0
    },
    { /* articulation 129 */
        { 196, 0, 0, 31964 },
        { 95, 32767, 32767, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 130 */
        { 32767, 31730, 0, 31730 },
        { 32767, 380, 0, 0 },
        0, 0, 495, 1200, 0, 0, 0, 0, 0
    },
    { /* articulation 131 */
        { 32767, 32245, 0, 32349 },
        { 32767, 190, 0, 0 },
        0, 0, 495, 50, 0, 0, 0, 0, 0
    },
    { /* articulation 132 */
        { 32767, 32418, 0, 32418 },
        { 32767, 9511, 0, 0 },
        0, 0, 495, 0, 4700, 7769, 0, 0, 0
    },
    { /* articulation 133 */
        { 32767, 31391, 0, 31391 },
        { 32767, 19021, 0, 0 },
        0, 0, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 134 */
        { 32767, 32663, 32767, 32663 },
        { 32767, 32767, 32767, 0 },
        0, 0, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 135 */
        { 32767, 32715, 18820, 23749 },
        { 32767, 95, 0, 0 },
        10, 68, 476, 0, 2000, 10696, 0, 0, 0
    },
    { /* articulation 136 */
        { 32767, 32715, 10809, 23749 },
        { 32767, 95, 0, 0 },
        12, 69, 491, 0, 0, 10910, 0, 0, 0
    },
    { /* articulation 137 */
        { 32767, 32715, 18820, 23749 },
        { 32767, 95, 0, 0 },
        10, 69, 476, 0, 1200, 10218, 0, 0, 0
    },
    { /* articulation 138 */
        { 19021, 32715, 18820, 23749 },
        { 32767, 95, 0, 0 },
        10, 69, 476, 0, 1100, 9525, 0, 0, 0
    },
    { /* articulation 139 */
        { 9511, 32663, 18820, 27897 },
        { 32767, 10, 0, 0 },
        10, 69, 494, 0, 2000, 10962, 0, 0, 0
    },
    { /* articulation 140 */
        { 32767, 32558, 18820, 27897 },
        { 9511, 317, 0, 0 },
        10, 63, 504, 0, 1200, 10090, 0, 0, 0
    },
    { /* articulation 141 */
        { 1268, 0, 32767, 30234 },
        { 951, 190, 0, 0 },
        7, 69, 494, 0, 1620, 8933, 0, 0, 0
    },
    { /* articulation 142 */
        { 32767, 32558, 10809, 27897 },
        { 19021, 190, 0, 0 },
        7, 69, 494, 0, 2200, 8994, 0, 0, 0
    },
    { /* articulation 143 */
        { 32767, 32715, 15076, 27897 },
        { 32767, 951, 0, 0 },
        10, 69, 491, 0, 2500, 9525, 0, 0, 0
    },
    { /* articulation 144 */
        { 32767, 32715, 15076, 27897 },
        { 32767, 95, 0, 0 },
        10, 69, 476, 0, 1500, 11423, 0, 0, 0
    },
    { /* articulation 145 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 951, 0, 0 },
        9, 69, 491, 0, 1500, 9521, 0, 0, 0
    },
    { /* articulation 146 */
        { 1902, 0, 32767, 30725 },
        { 32767, 32767, 32767, 0 },
        0, 0, 761, 0, 0, 9521, 0, 0, 0
    },
    { /* articulation 147 */
        { 32767, 32663, 0, 27897 },
        { 32767, 9511, 0, 0 },
        0, 34, 495, 0, 5000, 10223, 0, 0, 0
    },
    { /* articulation 148 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 32, 0, 0 },
        10, 69, 476, 0, 1500, 9907, 0, 0, 0
    },
    { /* articulation 149 */
        { 32767, 32733, 11682, 27897 },
        { 32767, 951, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 150 */
        { 32767, 32418, 0, 32418 },
        { 32767, 190, 0, 0 },
        0, 34, 495, 0, 3440, 9260, 0, 0, 0
    },
    { /* articulation 151 */
        { 32767, 31476, 0, 31730 },
        { 32767, 951, 0, 0 },
        0, 34, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 152 */
        { 32767, 32245, 0, 31730 },
        { 32767, 190, 0, 0 },
        0, 34, 495, 0, 4000, 7823, 0, 0, 0
    },
    { /* articulation 153 */
        { 32767, 32663, 3566, 27897 },
        { 391, 32767, 32767, 0 },
        100, 0, 761, 500, 0, 11877, 0, 0, 0
    },
    { /* articulation 154 */
        { 32767, 32715, 18820, 23749 },
        { 32767, 951, 0, 0 },
        8, 69, 495, -22, 0, 0, 0, 0, 0
    },
    { /* articulation 155 */
        { 9511, 30830, 6784, 27897 },
        { 32767, 951, 0, 0 },
        0, 69, 476, 0, 5000, 9521, 1, 0, 0
    },
    { /* articulation 156 */
        { 32767, 32663, 0, 32349 },
        { 951, 127, 16384, 0 },
        0, 103, 495, 0, 3627, 10547, 0, 5, 0
    },
    { /* articulation 157 */
        { 1902, 0, 32767, 27897 },
        { 951, 951, 0, 0 },
        0, 69, 495, 27, 0, 11919, 0, 0, 0
    },
    { /* articulation 158 */
        { 32767, 0, 32767, 32245 },
        { 38, 33, 10092, 0 },
        5, 0, 495, 0, 8007, 5535, 0, 8, 0
    },
    { /* articulation 159 */
        { 32767, 32618, 0, 31056 },
        { 32767, 63, 0, 0 },
        0, 103, 495, 0, 2500, 9032, 0, 0, 0
    },
    { /* articulation 160 */
        { 4755, 32715, 10809, 28809 },
        { 32767, 32767, 32767, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 161 */
        { 9511, 32663, 18820, 27897 },
        { 32767, 95, 0, 0 },
        10, 69, 494, 0, 2600, 9513, 0, 0, 0
    },
    { /* articulation 162 */
        { 32767, 32435, 9568, 27897 },
        { 1174, 196, 0, 0 },
        10, 103, 490, 0, 6500, 9023, 0, 0, 0
    },
    { /* articulation 163 */
        { 32767, 32663, 0, 29434 },
        { 32767, 32, 0, 0 },
        0, 69, 495, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 164 */
        { 32767, 32418, 15076, 23749 },
        { 32767, 634, 0, 0 },
        0, 0, 476, 0, 2000, 10223, 0, 0, 0
    },
    { /* articulation 165 */
        { 32767, 32663, 0, 27897 },
        { 32767, 190, 0, 0 },
        0, 69, 495, 0, 3000, 9366, 0, 0, 0
    },
    { /* articulation 166 */
        { 32767, 32715, 18820, 27897 },
        { 951, 64, 10879, 0 },
        0, 0, 495, 0, 6000, 7121, 0, 4, 0
    },
    { /* articulation 167 */
        { 32767, 32636, 0, 29434 },
        { 32767, 10, 0, 0 },
        0, 103, 495, 0, 3500, 6236, 0, 5, 0
    },
    { /* articulation 168 */
        { 32767, 32636, 0, 29434 },
        { 32767, 95, 0, 0 },
        0, 103, 495, 0, 2800, 7121, 0, 0, 0
    },
    { /* articulation 169 */
        { 32767, 32593, 0, 31056 },
        { 32767, 63, 0, 0 },
        0, 103, 495, 0, 2100, 9626, 0, 0, 0
    },
    { /* articulation 170 */
        { 32767, 32558, 0, 31476 },
        { 32767, 63, 0, 0 },
        0, 103, 495, 0, 3000, 9626, 0, 0, 0
    },
    { /* articulation 171 */
        { 32767, 32527, 0, 30506 },
        { 32767, 63, 0, 0 },
        0, 103, 495, 0, 1000, 9032, 0, 0, 0
    },
    { /* articulation 172 */
        { 32767, 32418, 0, 30725 },
        { 32767, 63, 0, 0 },
        0, 103, 495, 0, 1000, 9032, 0, 0, 0
    },
    { /* articulation 173 */
        { 1902, 32418, 15076, 23749 },
        { 32767, 634, 0, 0 },
        0, 103, 496, 0, 0, 11107, 0, 8, 0
    },
    { /* articulation 174 */
        { 32767, 32558, 15076, 27897 },
        { 3804, 73, 0, 0 },
        0, 0, 495, 0, 4500, 9521, 0, 8, 0
    },
    { /* articulation 175 */
        { 32767, 32715, 18820, 27897 },
        { 32767, 48, 0, 0 },
        0, 0, 495, 0, 2000, 8321, 0, 8, 0
    },
    { /* articulation 176 */
        { 32767, 32742, 128, 31180 },
        { 32767, 865, 0, 0 },
        0, 0, 495, 0, 6000, 7823, 0, 8, 0
    },
    { /* articulation 177 */
        { 9511, 32608, 0, 32322 },
        { 32767, 48, 0, 0 },
        0, 0, 495, 0, 4500, 7121, 0, 8, 0
    },
    { /* articulation 178 */
        { 19021, 32664, 3646, 32436 },
        { 32767, 95, 0, 0 },
        0, 0, 495, 0, 4000, 8321, 0, 8, 0
    },
    { /* articulation 179 */
        { 32767, 32685, 13644, 29434 },
        { 32767, 32, 0, 0 },
        12, 69, 494, 0, 2000, 11107, 0, 0, 0
    },
    { /* articulation 180 */
        { 9511, 31605, 0, 27897 },
        { 32767, 951, 0, 0 },
        0, 0, 495, 0, 5000, 8321, 1, 0, 0
    },
    { /* articulation 181 */
        { 130, 32617, 0, 32350 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 182 */
        { 32767, 32593, 0, 32251 },
        { 1174, 20, 0, 0 },
        0, 69, 495, 0, 3600, 7121, 0, 4, 0
    },
    { /* articulation 183 */
        { 32767, 32427, 0, 32427 },
        { 32767, 317, 0, 0 },
        0, 69, 476, 0, 0, 0, 0, 0, 0
    },
    { /* articulation 184 */
        { 834, 32742, 19242, 31455 },
        { 32767, 148, 0, 0 },
        0, 0, 778, 0, 3000, 9907, 0, 4, 0
    }
}; /*end Articulations */

/*----------------------------------------------------------------------------
 * Regions
 *----------------------------------------------------------------------------
*/
const S_WT_REGION eas_regions[] =
{
    { { 0, 27, 27 }, -4068, 16422, 0, 0, 81, 0 }, /* region 0 */
    { { 0, 28, 28 }, -4768, 32767, 0, 0, 40, 0 }, /* region 1 */
    { { 0, 29, 29 }, -5753, 32767, 0, 0, 32, 1 }, /* region 2 */
    { { 0, 30, 30 }, -6053, 32767, 0, 0, 32, 2 }, /* region 3 */
    { { 0, 31, 31 }, -5068, 23197, 0, 0, 48, 3 }, /* region 4 */
    { { 1536, 32, 32 }, -4400, 20675, 0, 0, 137, 4 }, /* region 5 */
    { { 1537, 33, 33 }, -4903, 20675, 792, 879, 50, 5 }, /* region 6 */
    { { 1537, 34, 34 }, -5003, 16422, 792, 879, 50, 6 }, /* region 7 */
    { { 0, 35, 35 }, -6168, 32767, 0, 0, 83, 7 }, /* region 8 */
    { { 0, 36, 36 }, -6168, 32767, 0, 0, 83, 7 }, /* region 9 */
    { { 0, 37, 37 }, -5251, 18426, 0, 0, 53, 8 }, /* region 10 */
    { { 0, 38, 38 }, -5351, 23197, 0, 0, 16, 9 }, /* region 11 */
    { { 0, 39, 39 }, -4768, 32767, 0, 0, 40, 10 }, /* region 12 */
    { { 0, 40, 40 }, -5351, 23197, 0, 0, 16, 4 }, /* region 13 */
    { { 1, 41, 41 }, -7055, 26028, 798, 993, 45, 11 }, /* region 14 */
    { { 257, 42, 42 }, -5400, 26028, 4288, 7488, 7, 12 }, /* region 15 */
    { { 1, 43, 43 }, -6955, 26028, 798, 993, 45, 13 }, /* region 16 */
    { { 257, 44, 44 }, -5600, 26028, 4288, 7488, 7, 14 }, /* region 17 */
    { { 1, 45, 45 }, -6955, 26028, 798, 993, 45, 15 }, /* region 18 */
    { { 257, 46, 46 }, -5800, 26028, 4288, 7488, 7, 16 }, /* region 19 */
    { { 1, 47, 47 }, -6655, 26028, 798, 993, 45, 17 }, /* region 20 */
    { { 1, 48, 48 }, -6555, 26028, 798, 993, 45, 18 }, /* region 21 */
    { { 1, 49, 49 }, -6400, 16422, 1294, 5778, 8, 19 }, /* region 22 */
    { { 1, 50, 50 }, -6455, 26028, 798, 993, 45, 20 }, /* region 23 */
    { { 1, 51, 51 }, -6468, 16422, 6592, 9921, 6, 21 }, /* region 24 */
    { { 1, 52, 52 }, -6800, 32767, 1294, 5778, 8, 22 }, /* region 25 */
    { { 1, 53, 53 }, -6618, 14636, 6592, 9921, 6, 23 }, /* region 26 */
    { { 0, 54, 54 }, -6951, 26028, 0, 0, 39, 24 }, /* region 27 */
    { { 1, 55, 55 }, -6500, 32767, 1294, 5778, 8, 25 }, /* region 28 */
    { { 0, 56, 56 }, -8455, 32767, 0, 0, 90, 26 }, /* region 29 */
    { { 1, 57, 57 }, -6900, 32767, 1294, 5778, 8, 27 }, /* region 30 */
    { { 1, 58, 58 }, -8253, 23197, 0, 166, 113, 28 }, /* region 31 */
    { { 1, 59, 59 }, -7168, 16422, 6592, 9921, 6, 29 }, /* region 32 */
    { { 1, 60, 60 }, -7653, 23197, 432, 582, 63, 30 }, /* region 33 */
    { { 1, 61, 61 }, -8053, 16422, 432, 582, 63, 30 }, /* region 34 */
    { { 1, 62, 62 }, -8453, 20675, 432, 582, 63, 31 }, /* region 35 */
    { { 1, 63, 63 }, -8553, 23197, 432, 582, 63, 32 }, /* region 36 */
    { { 1, 64, 64 }, -9153, 23197, 432, 582, 63, 33 }, /* region 37 */
    { { 0, 65, 65 }, -8755, 32767, 0, 0, 14, 34 }, /* region 38 */
    { { 0, 66, 66 }, -9155, 20675, 0, 0, 14, 34 }, /* region 39 */
    { { 512, 67, 67 }, -8355, 18426, 0, 0, 90, 35 }, /* region 40 */
    { { 512, 68, 68 }, -8955, 18426, 0, 0, 90, 35 }, /* region 41 */
    { { 0, 69, 69 }, -8955, 32767, 0, 0, 86, 36 }, /* region 42 */
    { { 0, 70, 70 }, -8055, 21900, 0, 0, 86, 37 }, /* region 43 */
    { { 769, 71, 71 }, -7555, 23197, 0, 1226, 35, 38 }, /* region 44 */
    { { 769, 72, 72 }, -8155, 26028, 0, 1226, 35, 38 }, /* region 45 */
    { { 1024, 73, 73 }, -9155, 32767, 0, 0, 22, 39 }, /* region 46 */
    { { 1024, 74, 74 }, -9655, 32767, 0, 0, 22, 40 }, /* region 47 */
    { { 1, 75, 75 }, -9100, 23197, 0, 31, 139, 41 }, /* region 48 */
    { { 0, 76, 76 }, -11655, 23197, 0, 0, 134, 42 }, /* region 49 */
    { { 0, 77, 77 }, -11255, 23197, 0, 0, 134, 43 }, /* region 50 */
    { { 0, 78, 78 }, -10053, 16422, 0, 0, 89, 44 }, /* region 51 */
    { { 0, 79, 79 }, -11453, 16422, 0, 0, 89, 45 }, /* region 52 */
    { { 1281, 80, 80 }, -7500, 13045, 209, 230, 103, 46 }, /* region 53 */
    { { 1281, 81, 81 }, -7600, 16422, 209, 230, 103, 47 }, /* region 54 */
    { { 0, 82, 82 }, -9655, 20675, 0, 0, 87, 48 }, /* region 55 */
    { { 0, 83, 83 }, -10100, 32767, 0, 0, 13, 49 }, /* region 56 */
    { { 1, 84, 84 }, -9600, 23197, 0, 10294, 5, 50 }, /* region 57 */
    { { 0, 85, 85 }, -10855, 32767, 0, 0, 135, 4 }, /* region 58 */
    { { 0, 86, 86 }, -10268, 16422, 0, 0, 24, 51 }, /* region 59 */
    { { 32769, 87, 87 }, -10368, 32767, 1335, 1603, 24, 52 }, /* region 60 */
    { { 1, 12, 67 }, -7805, 23197, 437, 16584, 2, 48 }, /* region 61 */
    { { 1, 68, 73 }, -8396, 23197, 452, 16803, 0, 48 }, /* region 62 */
    { { 32769, 74, 108 }, -9667, 23197, 404, 16698, 1, 48 }, /* region 63 */
    { { 1, 12, 78 }, -7805, 16422, 437, 16584, 2, 48 }, /* region 64 */
    { { 1, 79, 91 }, -8396, 16422, 452, 16803, 0, 48 }, /* region 65 */
    { { 32769, 92, 108 }, -9667, 16422, 404, 16698, 1, 48 }, /* region 66 */
    { { 1, 12, 78 }, -7805, 16422, 437, 16584, 2, 48 }, /* region 67 */
    { { 1, 79, 91 }, -8396, 16422, 452, 16803, 0, 48 }, /* region 68 */
    { { 32769, 92, 108 }, -9667, 16422, 404, 16698, 1, 48 }, /* region 69 */
    { { 1, 12, 70 }, -7800, 23197, 437, 16584, 2, 48 }, /* region 70 */
    { { 1, 71, 88 }, -8391, 23197, 452, 16803, 0, 48 }, /* region 71 */
    { { 32769, 89, 108 }, -9662, 23197, 404, 16698, 1, 48 }, /* region 72 */
    { { 1, 12, 54 }, -7156, 13045, 639, 4368, 10, 48 }, /* region 73 */
    { { 32769, 55, 108 }, -7551, 18426, 702, 3112, 12, 48 }, /* region 74 */
    { { 1, 12, 66 }, -7811, 23197, 437, 16584, 2, 48 }, /* region 75 */
    { { 1, 67, 87 }, -8402, 23197, 452, 16803, 0, 48 }, /* region 76 */
    { { 32769, 88, 108 }, -9673, 16422, 404, 16698, 1, 48 }, /* region 77 */
    { { 1, 12, 43 }, -4255, 23197, 920, 1383, 30, 59 }, /* region 78 */
    { { 32769, 44, 96 }, -6260, 18426, 885, 1176, 37, 59 }, /* region 79 */
    { { 1, 12, 48 }, -4661, 18426, 1148, 1514, 26, 60 }, /* region 80 */
    { { 32769, 49, 96 }, -7453, 16422, 1347, 1420, 29, 60 }, /* region 81 */
    { { 1, 33, 56 }, -6800, 26028, 1064, 1170, 38, 61 }, /* region 82 */
    { { 1, 57, 72 }, -7200, 26028, 930, 1014, 44, 61 }, /* region 83 */
    { { 32769, 73, 108 }, -8800, 26028, 726, 826, 52, 61 }, /* region 84 */
    { { 1, 36, 96 }, -8800, 20675, 635, 735, 58, 62 }, /* region 85 */
    { { 32769, 97, 108 }, -11308, 13045, 0, 31, 139, 62 }, /* region 86 */
    { { 1, 36, 96 }, -8800, 14636, 635, 735, 58, 0 }, /* region 87 */
    { { 32769, 97, 108 }, -11308, 13045, 0, 31, 139, 0 }, /* region 88 */
    { { 1, 36, 83 }, -7206, 13045, 838, 922, 47, 63 }, /* region 89 */
    { { 1, 84, 93 }, -9606, 14636, 209, 230, 103, 63 }, /* region 90 */
    { { 32769, 94, 108 }, -11308, 13045, 0, 31, 139, 63 }, /* region 91 */
    { { 1, 36, 83 }, -7206, 13045, 838, 922, 47, 64 }, /* region 92 */
    { { 1, 84, 93 }, -9606, 13045, 209, 230, 103, 64 }, /* region 93 */
    { { 32769, 94, 108 }, -11308, 13045, 0, 31, 139, 64 }, /* region 94 */
    { { 1, 21, 56 }, -6795, 23197, 1064, 1170, 38, 65 }, /* region 95 */
    { { 1, 57, 72 }, -7195, 23197, 930, 1014, 44, 65 }, /* region 96 */
    { { 32769, 73, 108 }, -8798, 23197, 726, 826, 52, 65 }, /* region 97 */
    { { 1, 12, 83 }, -7206, 16422, 838, 922, 47, 66 }, /* region 98 */
    { { 1, 84, 93 }, -9606, 16422, 209, 230, 103, 66 }, /* region 99 */
    { { 32769, 94, 108 }, -11308, 16422, 0, 31, 139, 66 }, /* region 100 */
    { { 1, 24, 83 }, -7206, 16422, 838, 922, 47, 67 }, /* region 101 */
    { { 1, 84, 93 }, -9606, 16422, 209, 230, 103, 67 }, /* region 102 */
    { { 32769, 94, 108 }, -11308, 16422, 0, 31, 139, 67 }, /* region 103 */
    { { 1, 12, 83 }, -7220, 16422, 0, 83, 126, 68 }, /* region 104 */
    { { 1, 84, 90 }, -9682, 16422, 0, 20, 145, 68 }, /* region 105 */
    { { 32769, 91, 108 }, -10301, 16422, 6, 20, 147, 68 }, /* region 106 */
    { { 1, 21, 75 }, -8441, 16422, 419, 460, 76, 69 }, /* region 107 */
    { { 32769, 76, 108 }, -10890, 14636, 254, 264, 101, 69 }, /* region 108 */
    { { 32769, 36, 84 }, -8955, 16422, 0, 2775, 17, 70 }, /* region 109 */
    { { 32769, 12, 108 }, -7855, 23197, 30, 276, 100, 71 }, /* region 110 */
    { { 0, 12, 60 }, -9114, 26028, 0, 0, 15, 72 }, /* region 111 */
    { { 32768, 61, 96 }, -9114, 26028, 0, 0, 15, 73 }, /* region 112 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 74 }, /* region 113 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 74 }, /* region 114 */
    { { 1, 12, 35 }, -6555, 16422, 2869, 3778, 11, 75 }, /* region 115 */
    { { 1, 36, 48 }, -7755, 20675, 2869, 3778, 11, 75 }, /* region 116 */
    { { 32769, 49, 72 }, -7755, 20675, 2869, 3778, 11, 76 }, /* region 117 */
    { { 1, 16, 55 }, -7424, 20675, 1045, 1119, 41, 77 }, /* region 118 */
    { { 32769, 56, 96 }, -7918, 20675, 907, 963, 46, 77 }, /* region 119 */
    { { 1, 16, 53 }, -7194, 29204, 1140, 1479, 27, 78 }, /* region 120 */
    { { 1, 54, 70 }, -8371, 29204, 726, 812, 55, 78 }, /* region 121 */
    { { 32769, 71, 108 }, -8988, 29204, 718, 748, 56, 78 }, /* region 122 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 79 }, /* region 123 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 79 }, /* region 124 */
    { { 1, 16, 54 }, -6927, 20675, 5362, 5461, 9, 80 }, /* region 125 */
    { { 1, 55, 63 }, -7051, 26028, 1362, 1454, 28, 80 }, /* region 126 */
    { { 32769, 64, 108 }, -7944, 16422, 311, 366, 88, 80 }, /* region 127 */
    { { 1, 16, 48 }, -5998, 20675, 1132, 1301, 31, 81 }, /* region 128 */
    { { 32769, 49, 108 }, -7188, 20675, 1099, 1184, 36, 81 }, /* region 129 */
    { { 1, 21, 68 }, -9658, 20675, 87, 2170, 18, 82 }, /* region 130 */
    { { 1, 69, 82 }, -10160, 20675, 120, 2167, 19, 82 }, /* region 131 */
    { { 32769, 83, 108 }, -11360, 20675, 376, 2041, 20, 82 }, /* region 132 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 83 }, /* region 133 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 83 }, /* region 134 */
    { { 32769, 55, 108 }, -8568, 20675, 0, 477, 75, 84 }, /* region 135 */
    { { 32769, 36, 96 }, -8100, 14636, 101, 151, 116, 85 }, /* region 136 */
    { { 1, 24, 83 }, -7220, 13045, 0, 83, 126, 86 }, /* region 137 */
    { { 1, 84, 90 }, -9682, 13045, 0, 20, 145, 86 }, /* region 138 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 147, 86 }, /* region 139 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 87 }, /* region 140 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 87 }, /* region 141 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 88 }, /* region 142 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 88 }, /* region 143 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 89 }, /* region 144 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 89 }, /* region 145 */
    { { 1, 24, 83 }, -7220, 13045, 0, 83, 126, 90 }, /* region 146 */
    { { 1, 84, 90 }, -9682, 13045, 0, 20, 145, 90 }, /* region 147 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 147, 90 }, /* region 148 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 91 }, /* region 149 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 91 }, /* region 150 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 92 }, /* region 151 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 92 }, /* region 152 */
    { { 1, 12, 62 }, -8253, 16422, 23, 10953, 4, 93 }, /* region 153 */
    { { 32769, 63, 108 }, -8955, 20675, 11, 11753, 3, 93 }, /* region 154 */
    { { 1, 12, 62 }, -8253, 16422, 23, 10953, 4, 94 }, /* region 155 */
    { { 32769, 63, 108 }, -8955, 16422, 11, 11753, 3, 94 }, /* region 156 */
    { { 1, 24, 79 }, -7220, 13045, 0, 83, 126, 95 }, /* region 157 */
    { { 1, 80, 90 }, -9682, 13045, 0, 20, 145, 95 }, /* region 158 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 147, 95 }, /* region 159 */
    { { 1, 12, 65 }, -8253, 13045, 23, 10953, 4, 96 }, /* region 160 */
    { { 32769, 66, 108 }, -8955, 16422, 11, 11753, 3, 96 }, /* region 161 */
    { { 32768, 36, 84 }, -8700, 20675, 0, 0, 25, 97 }, /* region 162 */
    { { 32769, 36, 96 }, -10055, 20675, 1482, 1613, 23, 98 }, /* region 163 */
    { { 32769, 12, 96 }, -5566, 32767, 818, 1033, 42, 99 }, /* region 164 */
    { { 32769, 36, 84 }, -9768, 18426, 0, 293, 98, 100 }, /* region 165 */
    { { 32769, 12, 96 }, -7220, 26028, 0, 83, 125, 101 }, /* region 166 */
    { { 32769, 12, 96 }, -7220, 20675, 0, 83, 125, 102 }, /* region 167 */
    { { 1, 12, 83 }, -7220, 13045, 0, 83, 125, 104 }, /* region 168 */
    { { 1, 84, 90 }, -9682, 13045, 0, 20, 146, 104 }, /* region 169 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 148, 104 }, /* region 170 */
    { { 32769, 36, 108 }, -9770, 32767, 472, 491, 74, 105 }, /* region 171 */
    { { 32769, 36, 108 }, -9770, 20675, 472, 491, 74, 106 }, /* region 172 */
    { { 1, 12, 72 }, -7212, 7336, 2, 86, 124, 107 }, /* region 173 */
    { { 1, 73, 101 }, -9700, 8231, 2, 22, 143, 107 }, /* region 174 */
    { { 32769, 102, 108 }, -10883, 20675, 173, 183, 110, 107 }, /* region 175 */
    { { 1, 21, 96 }, -8968, 13045, 477, 507, 73, 108 }, /* region 176 */
    { { 32769, 97, 108 }, -10883, 13045, 173, 183, 110, 109 }, /* region 177 */
    { { 32769, 12, 108 }, -8971, 16422, 477, 507, 73, 110 }, /* region 178 */
    { { 1, 12, 53 }, -6171, 16422, 388, 541, 68, 111 }, /* region 179 */
    { { 32769, 54, 60 }, -7149, 11626, 473, 560, 65, 111 }, /* region 180 */
    { { 32769, 36, 72 }, -7149, 16422, 473, 560, 65, 112 }, /* region 181 */
    { { 1, 48, 58 }, -8253, 16422, 356, 402, 82, 113 }, /* region 182 */
    { { 1, 59, 65 }, -8774, 16422, 514, 548, 67, 113 }, /* region 183 */
    { { 1, 66, 78 }, -9374, 16422, 505, 529, 71, 113 }, /* region 184 */
    { { 32769, 79, 96 }, -10433, 16422, 178, 191, 109, 113 }, /* region 185 */
    { { 1, 55, 60 }, -8253, 16422, 356, 402, 82, 114 }, /* region 186 */
    { { 1, 61, 69 }, -8774, 16422, 514, 548, 67, 114 }, /* region 187 */
    { { 1, 70, 79 }, -9374, 16422, 505, 529, 71, 114 }, /* region 188 */
    { { 32769, 80, 108 }, -10433, 16422, 178, 191, 109, 114 }, /* region 189 */
    { { 1, 16, 82 }, -9229, 23197, 180, 206, 106, 115 }, /* region 190 */
    { { 32769, 83, 108 }, -8440, 18426, 3, 44, 131, 115 }, /* region 191 */
    { { 32769, 21, 108 }, -10069, 20675, 483, 515, 72, 116 }, /* region 192 */
    { { 1, 21, 89 }, -8405, 18426, 3, 45, 130, 117 }, /* region 193 */
    { { 32769, 90, 108 }, -10301, 10362, 6, 20, 148, 117 }, /* region 194 */
    { { 1, 21, 42 }, -5886, 20675, 0, 180, 111, 118 }, /* region 195 */
    { { 1, 43, 51 }, -6486, 23197, 0, 127, 120, 118 }, /* region 196 */
    { { 1, 52, 58 }, -7492, 26028, 0, 71, 127, 118 }, /* region 197 */
    { { 1, 59, 68 }, -8668, 23197, 0, 36, 136, 118 }, /* region 198 */
    { { 32769, 69, 108 }, -9774, 20675, 0, 19, 149, 118 }, /* region 199 */
    { { 1, 21, 89 }, -8399, 20675, 3, 45, 130, 119 }, /* region 200 */
    { { 32769, 90, 108 }, -10301, 14636, 6, 20, 148, 119 }, /* region 201 */
    { { 1, 21, 46 }, -6851, 26028, 236, 340, 92, 120 }, /* region 202 */
    { { 1, 47, 71 }, -7763, 20675, 824, 885, 49, 120 }, /* region 203 */
    { { 1, 72, 88 }, -9107, 18426, 719, 747, 57, 120 }, /* region 204 */
    { { 1, 89, 93 }, -10076, 16422, 83, 99, 122, 120 }, /* region 205 */
    { { 32769, 94, 108 }, -10889, 16422, 173, 183, 110, 120 }, /* region 206 */
    { { 1, 60, 71 }, -8405, 16422, 0, 42, 132, 121 }, /* region 207 */
    { { 1, 72, 78 }, -9103, 16422, 0, 28, 141, 121 }, /* region 208 */
    { { 32769, 79, 96 }, -9605, 16422, 0, 21, 144, 121 }, /* region 209 */
    { { 1, 48, 65 }, -7516, 11626, 0, 70, 128, 122 }, /* region 210 */
    { { 1, 66, 79 }, -8924, 14636, 0, 31, 138, 122 }, /* region 211 */
    { { 32769, 80, 96 }, -9230, 11626, 0, 26, 142, 122 }, /* region 212 */
    { { 1, 16, 44 }, -7068, 14636, 163, 254, 102, 123 }, /* region 213 */
    { { 1, 45, 51 }, -7618, 16422, 261, 393, 85, 123 }, /* region 214 */
    { { 1, 52, 58 }, -8533, 18426, 190, 229, 104, 123 }, /* region 215 */
    { { 1, 59, 66 }, -9300, 18426, 168, 193, 108, 123 }, /* region 216 */
    { { 1, 67, 70 }, -9776, 18426, 138, 157, 115, 123 }, /* region 217 */
    { { 1, 71, 80 }, -10303, 18426, 166, 180, 112, 123 }, /* region 218 */
    { { 32769, 81, 108 }, -11274, 18426, 135, 151, 117, 123 }, /* region 219 */
    { { 32769, 12, 96 }, -6204, 23197, 570, 719, 59, 124 }, /* region 220 */
    { { 1, 12, 48 }, -7068, 14636, 163, 254, 102, 125 }, /* region 221 */
    { { 1, 49, 54 }, -7618, 16422, 261, 393, 85, 125 }, /* region 222 */
    { { 1, 55, 63 }, -8533, 18426, 190, 229, 104, 125 }, /* region 223 */
    { { 1, 64, 70 }, -9300, 18426, 168, 193, 108, 125 }, /* region 224 */
    { { 1, 71, 75 }, -9776, 18426, 138, 157, 115, 125 }, /* region 225 */
    { { 1, 76, 82 }, -10303, 18426, 166, 180, 112, 125 }, /* region 226 */
    { { 32769, 83, 108 }, -11274, 18426, 135, 151, 117, 125 }, /* region 227 */
    { { 32770, 36, 84 }, -8400, 29204, 0, 0, 0, 126 }, /* region 228 */
    { { 32770, 36, 84 }, -8800, 8231, 0, 0, 0, 127 }, /* region 229 */
    { { 32770, 36, 84 }, -8400, 20675, 0, 0, 0, 128 }, /* region 230 */
    { { 32769, 36, 84 }, -7200, -24285, 1294, 5778, 8, 129 }, /* region 231 */
    { { 32769, 36, 84 }, -7755, 29204, 798, 993, 45, 130 }, /* region 232 */
    { { 32769, 36, 84 }, -8055, 20675, 798, 993, 45, 131 }, /* region 233 */
    { { 32769, 36, 84 }, -8955, 29204, 798, 993, 45, 132 }, /* region 234 */
    { { 32768, 36, 84 }, -9355, 32767, 0, 0, 133, 133 }, /* region 235 */
    { { 32768, 36, 84 }, -7755, 20675, 0, 0, 91, 134 }, /* region 236 */
    { { 1, 24, 62 }, -8200, 23197, 286, 333, 94, 135 }, /* region 237 */
    { { 1, 63, 66 }, -8564, 26028, 297, 335, 93, 135 }, /* region 238 */
    { { 1, 67, 72 }, -8922, 23197, 368, 399, 84, 135 }, /* region 239 */
    { { 32769, 73, 96 }, -9510, 23197, 116, 138, 119, 135 }, /* region 240 */
    { { 1, 24, 48 }, -6341, 23197, 309, 447, 77, 136 }, /* region 241 */
    { { 1, 49, 56 }, -7466, 26028, 211, 283, 99, 136 }, /* region 242 */
    { { 1, 57, 63 }, -8200, 26028, 286, 333, 94, 136 }, /* region 243 */
    { { 32769, 64, 84 }, -8922, 23197, 368, 399, 84, 136 }, /* region 244 */
    { { 1, 24, 56 }, -7466, 29204, 211, 283, 99, 137 }, /* region 245 */
    { { 1, 57, 63 }, -8200, 29204, 286, 333, 94, 137 }, /* region 246 */
    { { 1, 64, 69 }, -8922, 29204, 368, 399, 84, 137 }, /* region 247 */
    { { 32769, 70, 96 }, -9510, 29204, 116, 138, 119, 137 }, /* region 248 */
    { { 1, 24, 68 }, -8922, 18426, 368, 399, 84, 138 }, /* region 249 */
    { { 1, 69, 76 }, -9510, 26028, 116, 138, 119, 138 }, /* region 250 */
    { { 32769, 77, 108 }, -9958, 23197, 127, 144, 118, 138 }, /* region 251 */
    { { 1, 24, 82 }, -8813, 23197, 389, 422, 80, 139 }, /* region 252 */
    { { 32769, 83, 108 }, -9964, 26028, 146, 163, 114, 139 }, /* region 253 */
    { { 1, 12, 58 }, -8098, 29204, 386, 436, 78, 140 }, /* region 254 */
    { { 32769, 59, 96 }, -8571, 26028, 290, 328, 95, 140 }, /* region 255 */
    { { 1, 12, 58 }, -8098, 16422, 386, 436, 78, 141 }, /* region 256 */
    { { 32769, 59, 96 }, -8571, 18426, 290, 328, 95, 141 }, /* region 257 */
    { { 1, 12, 48 }, -8098, -28771, 386, 436, 78, 142 }, /* region 258 */
    { { 32769, 49, 84 }, -8571, 29204, 290, 328, 95, 142 }, /* region 259 */
    { { 1, 12, 60 }, -6653, 20675, 314, 430, 79, 143 }, /* region 260 */
    { { 32769, 61, 84 }, -7753, 18426, 263, 324, 96, 143 }, /* region 261 */
    { { 1, 24, 60 }, -7753, 16422, 263, 324, 96, 144 }, /* region 262 */
    { { 1, 61, 70 }, -8869, 20675, 279, 311, 97, 144 }, /* region 263 */
    { { 32769, 71, 96 }, -9298, 23197, 179, 204, 107, 144 }, /* region 264 */
    { { 1, 24, 84 }, -9683, 20675, 191, 211, 105, 145 }, /* region 265 */
    { { 32769, 85, 108 }, -10883, 20675, 92, 102, 121, 145 }, /* region 266 */
    { { 1, 21, 69 }, -7753, 13045, 263, 324, 96, 146 }, /* region 267 */
    { { 1, 70, 94 }, -8869, 20675, 279, 311, 97, 146 }, /* region 268 */
    { { 1, 95, 96 }, -9298, -24285, 179, 204, 107, 146 }, /* region 269 */
    { { 32769, 97, 108 }, -10883, -24285, 173, 183, 110, 146 }, /* region 270 */
    { { 1, 16, 55 }, -9300, 20675, 168, 193, 108, 147 }, /* region 271 */
    { { 1, 56, 74 }, -9776, 26028, 138, 157, 115, 147 }, /* region 272 */
    { { 32769, 75, 96 }, -11274, 26028, 135, 151, 117, 147 }, /* region 273 */
    { { 1, 24, 72 }, -9298, 26028, 179, 204, 107, 148 }, /* region 274 */
    { { 1, 73, 85 }, -9683, 20675, 191, 211, 105, 148 }, /* region 275 */
    { { 32769, 86, 108 }, -10883, 18426, 92, 102, 121, 148 }, /* region 276 */
    { { 32769, 36, 108 }, -8930, 18426, 1839, 1901, 21, 149 }, /* region 277 */
    { { 32769, 24, 108 }, -8473, 20675, 494, 534, 69, 150 }, /* region 278 */
    { { 32769, 12, 108 }, -8473, 20675, 494, 534, 69, 151 }, /* region 279 */
    { { 32769, 24, 108 }, -8473, 20675, 494, 534, 69, 152 }, /* region 280 */
    { { 1, 36, 60 }, -6100, 5193, 2, 22, 143, 153 }, /* region 281 */
    { { 32769, 61, 84 }, -7283, 20675, 173, 183, 110, 153 }, /* region 282 */
    { { 32769, 24, 96 }, -7753, 14636, 263, 324, 96, 154 }, /* region 283 */
    { { 32769, 36, 96 }, -8930, 26028, 1839, 1901, 21, 155 }, /* region 284 */
    { { 32769, 24, 108 }, -8473, 20675, 494, 534, 69, 156 }, /* region 285 */
    { { 1, 24, 58 }, -9051, 14636, 0, 29, 140, 157 }, /* region 286 */
    { { 32769, 59, 96 }, -9051, 14636, 0, 29, 140, 157 }, /* region 287 */
    { { 1, 12, 83 }, -7220, 13045, 0, 83, 125, 158 }, /* region 288 */
    { { 1, 84, 90 }, -9682, 13045, 0, 20, 146, 158 }, /* region 289 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 148, 158 }, /* region 290 */
    { { 1, 21, 42 }, -5863, 26028, 1047, 1229, 34, 159 }, /* region 291 */
    { { 1, 43, 48 }, -6656, 29204, 1138, 1253, 33, 159 }, /* region 292 */
    { { 1, 49, 53 }, -7045, 26028, 559, 651, 60, 159 }, /* region 293 */
    { { 1, 54, 60 }, -7932, 26028, 508, 563, 64, 159 }, /* region 294 */
    { { 1, 61, 65 }, -8280, 32767, 819, 864, 51, 159 }, /* region 295 */
    { { 1, 66, 70 }, -8066, 26942, 981, 1032, 43, 159 }, /* region 296 */
    { { 1, 71, 76 }, -9366, 26028, 790, 814, 54, 159 }, /* region 297 */
    { { 1, 77, 82 }, -9966, 26028, 592, 609, 61, 159 }, /* region 298 */
    { { 1, 83, 87 }, -10717, 23197, 543, 554, 66, 159 }, /* region 299 */
    { { 1, 88, 96 }, -11271, 18426, 601, 609, 62, 159 }, /* region 300 */
    { { 32769, 97, 108 }, -11766, 18426, 523, 529, 70, 159 }, /* region 301 */
    { { 1, 48, 69 }, -7513, 14636, 0, 70, 128, 160 }, /* region 302 */
    { { 1, 70, 79 }, -8924, 18426, 0, 31, 138, 160 }, /* region 303 */
    { { 32769, 80, 96 }, -9230, 14636, 0, 26, 142, 160 }, /* region 304 */
    { { 1, 36, 72 }, -8334, 29204, 0, 87, 123, 161 }, /* region 305 */
    { { 32769, 73, 96 }, -9160, 29204, 0, 54, 129, 161 }, /* region 306 */
    { { 32769, 36, 96 }, -8930, 26028, 1839, 1901, 21, 162 }, /* region 307 */
    { { 32769, 12, 96 }, -5572, 32767, 818, 1033, 42, 163 }, /* region 308 */
    { { 32769, 36, 108 }, -9770, 26028, 472, 491, 74, 164 }, /* region 309 */
    { { 32769, 12, 96 }, -6204, 29204, 570, 719, 59, 165 }, /* region 310 */
    { { 1, 12, 83 }, -7220, 13045, 0, 83, 125, 166 }, /* region 311 */
    { { 1, 84, 90 }, -9682, 13045, 0, 20, 146, 166 }, /* region 312 */
    { { 32769, 91, 108 }, -10301, 13045, 6, 20, 148, 166 }, /* region 313 */
    { { 1, 21, 46 }, -6851, 32767, 236, 340, 92, 167 }, /* region 314 */
    { { 1, 47, 75 }, -7763, 26028, 824, 885, 49, 167 }, /* region 315 */
    { { 1, 76, 84 }, -9107, 23197, 719, 747, 57, 167 }, /* region 316 */
    { { 1, 85, 93 }, -10076, 20675, 83, 99, 122, 167 }, /* region 317 */
    { { 32769, 94, 108 }, -10889, 20675, 173, 183, 110, 167 }, /* region 318 */
    { { 1, 21, 46 }, -6851, 26028, 236, 340, 92, 168 }, /* region 319 */
    { { 1, 47, 71 }, -7763, 20675, 824, 885, 49, 168 }, /* region 320 */
    { { 1, 72, 88 }, -9107, 18426, 719, 747, 57, 168 }, /* region 321 */
    { { 1, 89, 93 }, -10076, 16422, 83, 99, 122, 168 }, /* region 322 */
    { { 32769, 94, 108 }, -10889, 16422, 173, 183, 110, 168 }, /* region 323 */
    { { 1, 21, 45 }, -5863, 26028, 1047, 1229, 34, 169 }, /* region 324 */
    { { 1, 46, 51 }, -6656, 29204, 1138, 1253, 33, 169 }, /* region 325 */
    { { 1, 52, 54 }, -7045, 26028, 559, 651, 60, 169 }, /* region 326 */
    { { 1, 55, 63 }, -7932, 26028, 508, 563, 64, 169 }, /* region 327 */
    { { 1, 64, 68 }, -8280, 32767, 819, 864, 51, 169 }, /* region 328 */
    { { 1, 69, 73 }, -8066, 26942, 981, 1032, 43, 169 }, /* region 329 */
    { { 1, 74, 79 }, -9366, 26028, 790, 814, 54, 169 }, /* region 330 */
    { { 1, 80, 88 }, -9966, 23197, 592, 609, 61, 169 }, /* region 331 */
    { { 1, 89, 99 }, -11271, 18426, 601, 609, 62, 169 }, /* region 332 */
    { { 32769, 100, 108 }, -11766, 18426, 523, 529, 70, 169 }, /* region 333 */
    { { 1, 21, 45 }, -5863, 26028, 1047, 1229, 34, 170 }, /* region 334 */
    { { 1, 46, 51 }, -6656, 29204, 1138, 1253, 33, 170 }, /* region 335 */
    { { 1, 52, 54 }, -7045, 26028, 559, 651, 60, 170 }, /* region 336 */
    { { 1, 55, 63 }, -7932, 26028, 508, 563, 64, 170 }, /* region 337 */
    { { 1, 64, 68 }, -8280, 32767, 819, 864, 51, 170 }, /* region 338 */
    { { 1, 69, 73 }, -8066, 26942, 981, 1032, 43, 170 }, /* region 339 */
    { { 1, 74, 79 }, -9366, 26028, 790, 814, 54, 170 }, /* region 340 */
    { { 1, 80, 88 }, -9966, 23197, 592, 609, 61, 170 }, /* region 341 */
    { { 1, 89, 99 }, -11271, 18426, 601, 609, 62, 171 }, /* region 342 */
    { { 32769, 100, 108 }, -11766, 18426, 523, 529, 70, 172 }, /* region 343 */
    { { 32769, 36, 108 }, -9770, 20675, 472, 491, 74, 173 }, /* region 344 */
    { { 32769, 12, 108 }, -8930, 20675, 1839, 1901, 21, 174 }, /* region 345 */
    { { 1, 12, 44 }, -7068, 18426, 163, 254, 102, 175 }, /* region 346 */
    { { 1, 45, 51 }, -7618, 20675, 261, 393, 85, 175 }, /* region 347 */
    { { 1, 52, 58 }, -8533, 23197, 190, 229, 104, 175 }, /* region 348 */
    { { 1, 59, 66 }, -9300, 23197, 168, 193, 108, 175 }, /* region 349 */
    { { 1, 67, 70 }, -9776, 23197, 138, 157, 115, 175 }, /* region 350 */
    { { 1, 71, 80 }, -10303, 23197, 166, 180, 112, 175 }, /* region 351 */
    { { 32769, 81, 108 }, -11274, 23197, 135, 151, 117, 175 }, /* region 352 */
    { { 1, 12, 65 }, -8253, 16422, 23, 10953, 4, 176 }, /* region 353 */
    { { 32769, 66, 108 }, -8955, 20675, 11, 11753, 3, 176 }, /* region 354 */
    { { 1, 12, 48 }, -5998, 29204, 1132, 1301, 31, 177 }, /* region 355 */
    { { 32769, 49, 108 }, -7188, 29204, 1099, 1184, 36, 177 }, /* region 356 */
    { { 1, 12, 83 }, -8441, 20675, 419, 460, 76, 178 }, /* region 357 */
    { { 32769, 84, 108 }, -11323, 20675, 0, 31, 139, 178 }, /* region 358 */
    { { 1, 55, 60 }, -8253, 18426, 356, 402, 82, 179 }, /* region 359 */
    { { 1, 61, 69 }, -8774, 18426, 514, 548, 67, 179 }, /* region 360 */
    { { 1, 70, 79 }, -9374, 18426, 505, 529, 71, 179 }, /* region 361 */
    { { 32769, 80, 108 }, -10433, 23197, 178, 191, 109, 179 }, /* region 362 */
    { { 32769, 36, 96 }, -8930, -24285, 1839, 1901, 21, 180 }, /* region 363 */
    { { 1, 12, 83 }, -7206, 16422, 838, 922, 47, 181 }, /* region 364 */
    { { 1, 84, 93 }, -9606, 18426, 209, 230, 103, 181 }, /* region 365 */
    { { 32769, 94, 108 }, -11308, 16422, 0, 31, 139, 181 }, /* region 366 */
    { { 1, 12, 56 }, -6795, 23197, 1064, 1170, 38, 182 }, /* region 367 */
    { { 1, 57, 72 }, -7195, 23197, 930, 1014, 44, 182 }, /* region 368 */
    { { 32769, 73, 108 }, -8798, 23197, 726, 826, 52, 182 }, /* region 369 */
    { { 32769, 24, 108 }, -8800, 23197, 635, 735, 58, 62 }, /* region 370 */
    { { 1, 36, 83 }, -7206, 13045, 838, 922, 47, 183 }, /* region 371 */
    { { 1, 84, 93 }, -9606, 13045, 209, 230, 103, 183 }, /* region 372 */
    { { 32769, 94, 108 }, -11308, 13045, 0, 31, 139, 183 }, /* region 373 */
    { { 1, 12, 66 }, -7811, 23197, 437, 16584, 2, 184 }, /* region 374 */
    { { 1, 67, 87 }, -8402, 23197, 452, 16803, 0, 184 }, /* region 375 */
    { { 32769, 88, 108 }, -9673, 16422, 404, 16698, 1, 184 } /* region 376 */
}; /* end Regions */

/*----------------------------------------------------------------------------
 * Programs
 *----------------------------------------------------------------------------
*/
const S_PROGRAM eas_programs[] =
{
    { 7864320, 0 } /* program 0 */
}; /* end Programs */

/*----------------------------------------------------------------------------
 * Banks
 *----------------------------------------------------------------------------
*/
const S_BANK eas_banks[] =
{
    { /* bank 0 */
        30976,
        {
            291, 324, 314, 334, 202, 319, 95, 195,
            107, 92, 371, 89, 87, 85, 135, 82,
            200, 192, 130, 267, 193, 302, 207, 210,
            128, 125, 190, 120, 118, 213, 221, 271,
            80, 78, 308, 164, 220, 310, 166, 167,
            186, 182, 181, 179, 160, 178, 176, 115,
            155, 153, 151, 149, 75, 73, 374, 111,
            252, 254, 258, 305, 256, 157, 146, 137,
            249, 237, 245, 241, 274, 262, 260, 265,
            172, 171, 309, 277, 284, 307, 136, 344,
            173, 168, 345, 353, 346, 70, 110, 311,
            357, 144, 104, 67, 364, 367, 64, 288,
            142, 140, 98, 355, 133, 123, 61, 113,
            285, 280, 279, 278, 370, 286, 359, 283,
            101, 236, 163, 235, 234, 233, 232, 231,
            162, 363, 230, 281, 165, 229, 109, 228
        }
    }
}; /* end Banks */

/*----------------------------------------------------------------------------
 * Samples
 *----------------------------------------------------------------------------
*/

const EAS_SAMPLE eas_samples[] =
{
       0,    0,   -3,   -4,   -6,   -8,  -10,  -12,  -12,  -11,   -8,   -3,    3,    7,   10,   14,
      16,   16,   15,   12,    9,    4,   -4,  -12,  -18,  -21,  -21,  -19,  -18,  -15,  -10,   -3,
      10,   20,   34,   44,   51,   52,   48,   43,   38,   26,    8,  -15,  -37,  -52,  -61,  -64,
     -66,  -64,  -59,  -47,  -31,  -13,    4,   18,   30,   37,   40,   36,   30,   24,   19,   11,
      -2,  -17,  -24,  -28,  -28,  -21,  -18,  -16,  -10,   -3,   12,   27,   39,   49,   53,   53,
      50,   43,   37,   25,   11,  -11,  -31,  -46,  -57,  -63,  -66,  -63,  -57,  -46,  -34,  -19,
      -3,   13,   27,   35,   39,   37,   32,   26,   20,   11,    0,  -13,  -20,  -24,  -25,  -21,
     -19,  -14,   -8,   -2,    9,   23,   37,   47,   53,   52,   49,   42,   35,   25,   13,   -6,
     -28,  -48,  -60,  -67,  -67,  -64,  -60,  -51,  -39,  -23,   -7,   10,   23,   35,   39,   38,
      32,   26,   21,   15,    4,   -9,  -20,  -22,  -21,  -19,  -14,  -11,   -5,    1,    9,   19,
      31,   45,   51,   52,   47,   39,   35,   25,   15,   -3,  -23,  -42,  -58,  -70,  -71,  -66,
     -60,  -51,  -43,  -30,  -13,    6,   22,   32,   40,   40,   38,   33,   27,   19,    9,   -5,
     -17,  -25,  -26,  -22,  -16,  -11,   -8,   -4,    7,   21,   35,   48,   53,   56,   50,   43,
      34,   22,   13,   -2,  -22,  -44,  -63,  -75,  -76,  -69,  -61,  -51,  -43,  -29,  -13,    6,
      23,   32,   41,   43,   41,   37,   26,   18,    7,   -8,  -19,  -25,  -25,  -22,  -15,   -9,
      -5,    0,   10,   24,   37,   44,   48,   52,   52,   46,   33,   20,    8,   -5,  -20,  -38,
     -59,  -74,  -79,  -73,  -67,  -55,  -43,  -26,  -11,    4,   18,   29,   41,   45,   45,   38,
      29,   21,   11,   -3,  -15,  -25,  -27,  -22,  -16,  -11,   -8,    0,   10,   25,   38,   44,
      47,   50,   53,   49,   37,   20,    7,   -5,  -17,  -34,  -58,  -74,  -82,  -76,  -67,  -59,
     -47,  -29,  -12,    3,   14,   25,   38,   50,   52,   46,   33,   23,   14,    3,  -11,  -25,
     -28,  -27,  -21,  -16,  -13,   -7,    8,   27,   41,   44,   45,   47,   54,   55,   44,   25,
       7,   -7,  -18,  -32,  -53,  -71,  -81,  -81,  -72,  -67,  -55,  -37,  -16,    3,   15,   23,
      34,   48,   57,   56,   44,   30,   19,    5,  -12,  -26,  -33,  -31,  -25,  -19,  -16,  -11,
       7,   25,   45,   49,   49,   52,   57,   59,   48,   32,   11,   -5,  -22,  -39,  -56,  -73,
     -82,  -88,  -84,  -75,  -60,  -38,  -16,    5,   21,   30,   39,   52,   59,   61,   53,   37,
      22,    7,  -12,  -28,  -35,  -36,  -30,  -22,  -19,  -16,   -2,   21,   41,   52,   51,   52,
      57,   62,   54,   40,   18,   -2,  -18,  -36,  -54,  -70,  -80,  -86,  -87,  -81,  -69,  -48,
     -23,    0,   18,   28,   35,   45,   57,   64,   59,   46,   27,    9,  -11,  -24,  -30,  -32,
     -29,  -25,  -20,  -16,   -5,   15,   36,   47,   50,   49,   53,   57,   54,   43,   24,    5,
     -14,  -32,  -50,  -65,  -75,  -82,  -86,  -86,  -77,  -58,  -32,   -8,   14,   25,   30,   41,
      56,   69,   69,   57,   36,   17,   -4,  -20,  -29,  -32,  -27,  -28,  -27,  -23,  -13,   10,
      33,   46,   50,   48,   50,   54,   55,   48,   34,   16,   -6,  -29,  -50,  -68,  -75,  -78,
     -82,  -86,  -84,  -72,  -47,  -16,   11,   28,   34,   41,   51,   64,   70,   64,   49,   27,
       5,  -17,  -30,  -33,  -29,  -29,  -30,  -30,  -22,   -2,   23,   41,   49,   51,   51,   54,
      56,   50,   42,   25,    4,  -20,  -44,  -62,  -70,  -76,  -83,  -87,  -89,  -78,  -56,  -29,
       0,   19,   31,   38,   48,   63,   72,   71,   60,   40,   14,  -12,  -25,  -29,  -26,  -27,
     -33,  -37,  -30,  -12,   11,   31,   41,   48,   51,   53,   55,   55,   51,   39,   17,  -12,
     -38,  -58,  -67,  -74,  -82,  -92,  -98,  -89,  -69,  -41,  -13,   10,   29,   41,   50,   64,
      72,   78,   74,   57,   29,    0,  -18,  -26,  -28,  -32,  -38,  -42,  -38,  -23,   -3,   18,
      30,   42,   52,   58,   60,   61,   57,   48,   28,    2,  -30,  -51,  -62,  -70,  -81,  -94,
    -101,  -93,  -75,  -49,  -23,   -2,   18,   36,   50,   61,   69,   77,   78,   66,   42,   11,
     -11,  -22,  -27,  -32,  -39,  -46,  -46,  -36,  -14,    8,   25,   41,   52,   59,   62,   63,
      62,   57,   38,   11,  -20,  -47,  -61,  -69,  -78,  -89,  -98,  -94,  -80,  -60,  -37,  -12,
      13,   33,   48,   62,   70,   78,   81,   72,   52,   23,    0,  -14,  -24,  -33,  -43,  -49,
     -49,  -39,  -23,   -2,   15,   33,   47,   57,   63,   62,   62,   57,   40,   20,   -7,  -34,
     -52,  -65,  -74,  -83,  -94,  -92,  -81,  -63,  -42,  -22,    0,   21,   39,   54,   63,   73,
      79,   76,   61,   37,   12,   -5,  -19,  -28,  -37,  -46,  -51,  -47,  -32,  -13,    7,   25,
      43,   54,   58,   60,   60,   61,   48,   27,    3,  -25,  -45,  -60,  -72,  -81,  -90,  -92,
     -84,  -71,  -52,  -32,   -9,   14,   33,   50,   61,   74,   80,   78,   67,   47,   24,    6,
     -12,  -26,  -37,  -50,  -56,  -52,  -37,  -19,   -2,   16,   35,   52,   61,   63,   61,   59,
      51,   35,   12,  -15,  -38,  -55,  -66,  -77,  -83,  -83,  -80,  -68,  -55,  -39,  -19,    4,
      25,   41,   54,   66,   73,   75,   68,   52,   31,   11,   -7,  -22,  -33,  -46,  -54,  -51,
     -39,  -24,   -5,   12,   32,   48,   56,   60,   61,   58,   50,   36,   17,   -8,  -30,  -46,
     -63,  -74,  -80,  -80,  -74,  -69,  -58,  -43,  -27,   -5,   15,   31,   48,   60,   68,   72,
      68,   57,   39,   20,    2,  -16,  -30,  -44,  -51,  -50,  -41,  -27,  -10,    9,   28,   43,
      53,   57,   57,   54,   48,   37,   19,   -3,  -25,  -41,  -56,  -69,  -75,  -73,  -69,  -63,
     -59,  -49,  -32,  -13,    9,   25,   37,   48,   58,   66,   65,   58,   42,   25,    8,   -9,
     -22,  -36,  -41,  -43,  -37,  -26,  -14,    4,   21,   37,   48,   52,   53,   47,   42,   34,
      21,    3,  -18,  -39,  -51,  -64,  -67,  -62,  -60,  -60,  -58,  -50,  -36,  -16,    3,   17,
      29,   41,   49,   58,   61,   60,   49,   29,   11,   -7,  -19,  -28,  -32,  -33,  -30,  -25,
     -14,    2,   19,   33,   41,   45,   42,   38,   36,   29,   20,    6,  -14,  -28,  -43,  -54,
     -58,  -55,  -50,  -51,  -54,  -51,  -41,  -22,   -4,   11,   19,   30,   37,   47,   55,   56,
      51,   34,   16,    0,  -15,  -19,  -23,  -22,  -22,  -21,  -14,    0,   15,   29,   39,   43,
      37,   31,   25,   21,   18,    6,  -11,  -28,  -42,  -50,  -51,  -48,  -44,  -41,  -44,  -43,
     -41,  -25,   -8,    9,   16,   22,   26,   35,   43,   50,   48,   33,   16,   -3,  -13,  -16,
     -16,  -15,  -13,  -11,   -6,    5,   16,   28,   38,   41,   35,   24,   15,   12,   10,    4,
     -11,  -27,  -39,  -46,  -46,  -45,  -40,  -36,  -36,  -37,  -38,  -29,  -13,    6,   16,   19,
      22,   27,   37,   43,   42,   32,   19,    2,  -10,  -13,  -12,   -7,   -4,   -2,    2,   10,
      18,   27,   36,   38,   32,   20,    9,    4,   -2,   -4,  -11,  -23,  -34,  -42,  -42,  -38,
     -31,  -28,  -29,  -32,  -33,  -30,  -18,    0,   10,   12,   12,   17,   26,   35,   36,   31,
      19,    5,   -6,  -11,   -9,   -2,    7,   14,   13,   13,   16,   23,   31,   34,   29,   15,
      -3,   -8,  -10,  -10,  -14,  -20,  -26,  -30,  -32,  -30,  -25,  -18,  -17,  -24,  -31,  -32,
     -26,  -11,    2,    7,    8,    9,   17,   25,   29,   28,   21,    9,   -2,   -7,   -5,    4,
      12,   21,   24,   23,   25,   26,   29,   31,   27,   15,   -2,  -15,  -21,  -23,  -23,  -23,
     -28,  -30,  -31,  -27,  -19,  -10,   -9,  -13,  -21,  -22,  -20,  -11,   -4,   -3,   -5,   -2,
       5,   13,   17,   17,   16,   10,    6,    0,    3,   11,   23,   32,   33,   30,   28,   27,
      24,   24,   19,    9,   -6,  -19,  -29,  -29,  -26,  -20,  -19,  -22,  -24,  -23,  -16,  -10,
      -9,  -14,  -20,  -24,  -21,  -16,  -10,   -6,   -5,    1,    5,   11,   12,   13,   11,    8,
       6,    1,    4,    9,   23,   33,   39,   36,   32,   32,   28,   22,   17,    7,   -7,  -22,
     -31,  -33,  -31,  -24,  -19,  -18,  -18,  -16,  -13,   -7,   -6,   -8,  -14,  -21,  -24,  -20,
     -15,  -12,   -9,   -6,    0,    4,    6,    8,    8,    5,    5,    2,    7,   15,   27,   37,
      42,   45,   41,   39,   32,   22,   13,    3,  -11,  -26,  -37,  -41,  -37,  -29,  -21,  -18,
     -15,  -11,   -6,   -2,   -2,   -4,   -7,  -13,  -16,  -20,  -21,  -16,  -14,  -10,   -6,   -3,
      -3,    0,    3,    2,    3,    3,    9,   18,   32,   41,   46,   49,   44,   43,   35,   24,
      12,    1,  -14,  -27,  -39,  -40,  -36,  -31,  -22,  -16,  -13,   -6,   -3,   -3,   -4,   -9,
      -9,  -13,  -16,  -20,  -21,  -16,  -15,  -11,   -6,   -4,   -4,   -5,   -5,   -3,   -3,    0,
      10,   19,   33,   44,   51,   56,   52,   50,   40,   23,   11,   -6,  -19,  -30,  -40,  -43,
     -40,  -35,  -24,  -16,   -7,    2,    6,    5,    1,   -6,   -9,   -9,   -9,  -12,  -19,  -21,
     -21,  -17,   -9,   -7,   -9,  -11,  -15,  -14,   -9,   -7,    7,   19,   36,   51,   57,   61,
      59,   56,   48,   33,   13,   -8,  -24,  -35,  -45,  -51,  -46,  -38,  -26,  -14,   -7,    3,
      11,   15,   12,    3,   -5,   -7,   -6,   -9,  -15,  -22,  -25,  -23,  -17,  -13,  -12,  -16,
     -19,  -21,  -18,  -12,    3,   21,   38,   50,   58,   67,   65,   64,   55,   41,   21,   -4,
     -25,  -38,  -46,  -50,  -49,  -43,  -33,  -23,  -11,    3,   14,   19,   16,    8,    0,   -2,
      -2,    0,   -8,  -19,  -27,  -30,  -25,  -22,  -20,  -20,  -22,  -25,  -24,  -16,    1,   22,
      43,   56,   62,   67,   68,   65,   60,   46,   24,   -3,  -25,  -40,  -45,  -49,  -50,  -46,
     -37,  -23,  -10,    1,   12,   20,   20,   14,    7,    2,    3,    3,   -4,  -15,  -26,  -31,
     -30,  -27,  -26,  -26,  -29,  -33,  -33,  -25,   -8,   17,   41,   57,   65,   71,   73,   73,
      66,   53,   33,    5,  -23,  -41,  -48,  -50,  -48,  -48,  -40,  -30,  -14,    1,   12,   21,
      24,   18,   13,    6,    5,    5,    0,  -11,  -25,  -37,  -39,  -35,  -31,  -31,  -33,  -38,
     -37,  -29,  -12,   15,   40,   59,   67,   71,   72,   73,   69,   59,   39,   14,  -16,  -38,
     -50,  -51,  -50,  -48,  -45,  -36,  -21,   -4,   12,   25,   30,   25,   18,   11,   11,   10,
       6,   -8,  -25,  -39,  -46,  -42,  -38,  -37,  -37,  -40,  -42,  -34,  -15,   13,   40,   57,
      66,   71,   72,   72,   69,   61,   45,   19,  -10,  -34,  -46,  -48,  -47,  -45,  -45,  -41,
     -28,  -12,    7,   23,   27,   25,   18,   15,   17,   17,   12,    1,  -20,  -37,  -47,  -50,
     -46,  -45,  -44,  -45,  -46,  -41,  -21,    7,   37,   60,   69,   73,   72,   72,   72,   67,
      52,   25,   -6,  -33,  -47,  -50,  -47,  -47,  -47,  -45,  -35,  -16,    6,   23,   31,   30,
      24,   23,   24,   25,   18,    4,  -15,  -33,  -50,  -56,  -57,  -53,  -48,  -49,  -49,  -45,
     -29,    2,   35,   58,   68,   71,   72,   74,   73,   68,   56,   34,    5,  -26,  -43,  -48,
     -45,  -42,  -46,  -46,  -41,  -24,    0,   21,   33,   34,   31,   25,   27,   27,   19,    6,
     -14,  -36,  -55,  -64,  -64,  -60,  -50,  -47,  -45,  -44,  -31,   -4,   32,   58,   71,   72,
      68,   70,   70,   66,   57,   36,   11,  -20,  -43,  -50,  -48,  -41,  -37,  -42,  -40,  -28,
      -5,   21,   36,   38,   34,   26,   29,   28,   20,    8,  -13,  -33,  -52,  -68,  -69,  -65,
     -55,  -49,  -47,  -44,  -31,   -3,   30,   55,   67,   70,   68,   70,   70,   65,   57,   39,
      15,  -13,  -38,  -49,  -47,  -40,  -35,  -39,  -41,  -30,   -9,   17,   37,   44,   45,   38,
      32,   29,   22,    9,  -10,  -34,  -54,  -70,  -75,  -73,  -64,  -52,  -45,  -43,  -31,   -7,
      25,   53,   67,   72,   70,   72,   70,   62,   53,   38,   16,  -10,  -32,  -49,  -50,  -43,
     -35,  -33,  -36,  -29,  -10,   16,   35,   46,   46,   41,   35,   30,   23,   10,  -10,  -34,
     -53,  -69,  -75,  -74,  -66,  -53,  -45,  -42,  -34,  -13,   17,   46,   63,   68,   66,   63,
      65,   63,   54,   43,   24,    0,  -20,  -40,  -43,  -42,  -36,  -32,  -32,  -28,  -16,    7,
      29,   47,   52,   47,   39,   31,   21,   10,   -9,  -30,  -50,  -66,  -78,  -77,  -71,  -59,
     -49,  -42,  -34,  -17,    9,   37,   56,   66,   66,   62,   62,   61,   56,   45,   30,    7,
     -13,  -31,  -39,  -40,  -36,  -33,  -32,  -28,  -18,    1,   21,   41,   54,   52,   44,   36,
      26,   13,   -8,  -29,  -48,  -66,  -76,  -80,  -74,  -64,  -55,  -45,  -34,  -18,    5,   29,
      50,   65,   68,   66,   64,   60,   59,   47,   33,   15,   -5,  -23,  -37,  -43,  -41,  -37,
     -35,  -31,  -21,   -4,   16,   36,   52,   59,   54,   45,   33,   17,   -5,  -25,  -45,  -60,
     -74,  -83,  -82,  -71,  -59,  -49,  -37,  -23,   -2,   22,   43,   59,   66,   65,   64,   60,
      58,   50,   39,   23,    2,  -17,  -32,  -39,  -40,  -38,  -35,  -32,  -23,   -6,   14,   33,
      49,   59,   58,   49,   34,   16,   -5,  -25,  -43,  -60,  -74,  -83,  -83,  -76,  -63,  -53,
     -40,  -24,   -5,   16,   36,   54,   65,   67,   65,   61,   57,   52,   43,   27,    9,  -12,
     -26,  -37,  -40,  -39,  -36,  -32,  -28,  -13,    6,   27,   46,   58,   60,   52,   39,   23,
       5,  -16,  -36,  -53,  -66,  -77,  -84,  -81,  -72,  -60,  -45,  -32,  -15,    5,   25,   48,
      62,   69,   71,   69,   65,   58,   50,   34,   16,   -6,  -24,  -36,  -42,  -45,  -44,  -39,
     -33,  -21,   -2,   22,   43,   59,   64,   60,   47,   34,   17,   -6,  -28,  -50,  -66,  -76,
     -84,  -86,  -82,  -72,  -57,  -40,  -21,   -2,   21,   42,   58,   66,   73,   76,   71,   64,
      53,   40,   26,    4,  -17,  -34,  -45,  -49,  -48,  -43,  -38,  -28,  -10,   15,   40,   58,
      66,   64,   56,   42,   25,    4,  -21,  -44,  -62,  -73,  -81,  -87,  -86,  -78,  -65,  -47,
     -31,   -9,   15,   34,   52,   62,   72,   79,   80,   72,   61,   49,   34,   12,  -12,  -32,
     -43,  -49,  -54,  -55,  -48,  -36,  -16,   10,   35,   56,   67,   71,   67,   54,   38,   15,
     -10,  -34,  -57,  -72,  -85,  -93,  -97,  -89,  -76,  -59,  -40,  -20,    8,   32,   50,   67,
      77,   87,   89,   81,   66,   52,   35,   16,   -6,  -30,  -47,  -58,  -61,  -57,  -50,  -37,
     -19,    6,   29,   51,   65,   73,   73,   62,   44,   18,   -6,  -28,  -49,  -67,  -81,  -93,
     -97,  -94,  -83,  -65,  -47,  -28,   -5,   19,   42,   61,   76,   87,   90,   88,   80,   66,
      48,   27,    3,  -17,  -40,  -56,  -65,  -66,  -58,  -49,  -30,   -6,   17,   41,   59,   71,
      77,   70,   56,   36,   11,  -13,  -34,  -53,  -71,  -89,  -98, -100,  -94,  -79,  -62,  -44,
     -21,    3,   27,   52,   74,   90,   98,   95,   86,   75,   59,   37,   12,  -14,  -35,  -54,
     -64,  -67,  -64,  -51,  -34,  -10,   11,   32,   50,   65,   73,   71,   58,   37,   14,  -10,
     -29,  -48,  -64,  -81,  -93,  -98,  -94,  -82,  -63,  -45,  -26,   -5,   16,   40,   65,   83,
      94,   94,   84,   75,   63,   46,   23,   -3,  -27,  -47,  -58,  -64,  -64,  -56,  -39,  -17,
       3,   20,   38,   57,   71,   72,   61,   45,   24,    1,  -19,  -37,  -56,  -73,  -91,  -99,
    -100,  -92,  -74,  -53,  -34,  -16,    7,   31,   59,   82,   97,  101,   92,   78,   65,   48,
      29,    6,  -21,  -43,  -55,  -64,  -66,  -58,  -40,  -18,    3,   17,   32,   51,   69,   71,
      62,   45,   27,    6,  -15,  -34,  -50,  -64,  -81,  -93,  -99,  -96,  -80,  -59,  -40,  -23,
      -4,   21,   50,   77,   94,  100,   93,   81,   67,   53,   36,   14,  -12,  -36,  -53,  -58,
     -63,  -56,  -42,  -22,   -5,   10,   23,   42,   63,   70,   62,   47,   29,   13,   -6,  -27,
     -43,  -57,  -72,  -84,  -98,  -99,  -87,  -66,  -44,  -27,  -11,   10,   38,   67,   91,   99,
      92,   82,   70,   57,   41,   21,   -3,  -27,  -47,  -58,  -63,  -58,  -44,  -23,   -5,    7,
      17,   35,   55,   66,   61,   46,   29,   13,   -4,  -22,  -39,  -51,  -65,  -78,  -90,  -95,
     -85,  -69,  -47,  -30,  -12,    9,   30,   57,   83,   96,   91,   81,   67,   57,   42,   26,
       6,  -18,  -39,  -55,  -62,  -58,  -43,  -24,   -8,    2,   14,   30,   47,   60,   60,   49,
      34,   17,    0,  -16,  -31,  -43,  -58,  -71,  -86,  -93,  -86,  -72,  -52,  -32,  -15,    3,
      22,   48,   76,   90,   89,   78,   69,   59,   46,   32,   14,   -6,  -27,  -47,  -57,  -56,
     -45,  -29,  -12,   -5,    4,   18,   37,   54,   58,   51,   36,   21,    6,   -8,  -20,  -33,
     -52,  -68,  -84,  -90,  -85,  -74,  -58,  -42,  -22,    0,   20,   42,   67,   83,   87,   80,
      68,   58,   47,   34,   19,    0,  -20,  -40,  -52,  -53,  -45,  -27,  -13,   -4,    6,   17,
      33,   47,   53,   52,   38,   21,    3,  -11,  -24,  -35,  -50,  -65,  -80,  -89,  -85,  -71,
     -55,  -39,  -21,   -2,   20,   39,   59,   74,   81,   75,   67,   57,   47,   38,   23,    4,
     -17,  -32,  -43,  -45,  -39,  -26,  -14,   -4,    4,   12,   26,   38,   47,   48,   35,   19,
       4,  -10,  -20,  -29,  -41,  -56,  -71,  -78,  -81,  -71,  -56,  -43,  -23,   -6,   15,   35,
      49,   62,   72,   69,   63,   54,   45,   41,   28,   11,  -11,  -27,  -37,  -40,  -35,  -24,
     -17,   -7,    2,    9,   22,   35,   46,   49,   37,   21,    4,   -9,  -18,  -27,  -41,  -55,
     -71,  -79,  -79,  -70,  -53,  -38,  -23,   -8,    9,   31,   46,   58,   63,   63,   59,   52,
      45,   40,   32,   14,   -6,  -24,  -32,  -31,  -30,  -23,  -18,  -12,    1,    9,   21,   31,
      41,   44,   33,   21,    5,   -6,  -20,  -29,  -43,  -57,  -69,  -77,  -73,  -65,  -52,  -41,
     -27,   -8,   11,   32,   49,   57,   64,   61,   55,   47,   39,   36,   29,   13,   -8,  -25,
     -36,  -35,  -26,  -16,   -9,   -5,    1,    9,   22,   36,   45,   43,   33,   17,    1,  -11,
     -21,  -32,  -45,  -57,  -71,  -78,  -73,  -61,  -45,  -33,  -23,   -8,   11,   31,   46,   53,
      57,   54,   48,   40,   34,   31,   27,   14,   -4,  -20,  -29,  -28,  -22,  -12,   -4,    1,
       4,    8,   21,   34,   43,   43,   31,   17,    1,  -11,  -22,  -31,  -44,  -59,  -72,  -78,
     -70,  -54,  -40,  -28,  -19,   -8,   10,   28,   45,   53,   57,   53,   43,   34,   28,   27,
      26,   18,    0,  -18,  -31,  -29,  -20,  -11,   -3,    2,    5,   10,   19,   31,   43,   44,
      34,   19,    2,  -13,  -23,  -32,  -43,  -55,  -68,  -77,  -73,  -57,  -41,  -26,  -15,   -6,
      11,   28,   43,   52,   52,   49,   41,   33,   24,   22,   21,   14,    1,  -14,  -25,  -24,
     -18,   -7,   -2,    2,    7,   10,   20,   31,   40,   43,   33,   18,    3,  -13,  -24,  -35,
     -44,  -55,  -70,  -78,  -74,  -59,  -40,  -26,  -11,    1,   13,   29,   44,   53,   57,   54,
      45,   32,   24,   18,   13,    9,   -4,  -16,  -26,  -29,  -22,  -10,    1,    8,   13,   18,
      23,   35,   42,   45,   37,   21,    5,  -14,  -30,  -41,  -49,  -57,  -69,  -77,  -76,  -61,
     -39,  -20,   -5,    9,   20,   34,   47,   53,   55,   48,   39,   27,   14,    8,    3,    2,
      -4,  -15,  -23,  -24,  -16,   -3,    6,   11,   19,   24,   30,   34,   41,   43,   35,   18,
       1,  -17,  -31,  -44,  -52,  -59,  -68,  -75,  -73,  -61,  -38,  -19,    1,   13,   23,   30,
      42,   52,   52,   47,   36,   23,   14,    7,    4,    0,   -6,  -11,  -20,  -24,  -18,   -5,
       7,   15,   18,   22,   28,   36,   43,   43,   38,   24,    4,  -13,  -30,  -44,  -55,  -64,
     -69,  -77,  -76,  -65,  -44,  -19,    1,   15,   27,   35,   46,   53,   53,   46,   36,   23,
      11,    3,   -5,   -7,   -9,  -14,  -20,  -23,  -19,   -7,   11,   18,   21,   25,   30,   40,
      43,   43,   38,   24,    7,  -14,  -30,  -41,  -55,  -65,  -73,  -77,  -74,  -66,  -49,  -24,
      -2,   17,   29,   35,   44,   51,   54,   49,   35,   23,   11,    1,   -6,  -12,  -15,  -16,
     -20,  -24,  -21,  -10,    8,   21,   27,   33,   35,   42,   48,   47,   37,   23,    7,  -12,
     -28,  -44,  -60,  -69,  -75,  -78,  -74,  -65,  -49,  -25,   -2,   17,   30,   40,   48,   54,
      55,   48,   36,   20,    6,   -4,   -9,  -14,  -20,  -22,  -24,  -21,  -15,   -6,    7,   21,
      32,   39,   43,   44,   49,   50,   38,   21,    4,  -13,  -28,  -47,  -62,  -74,  -77,  -78,
     -77,  -65,  -48,  -26,   -4,   15,   28,   40,   50,   56,   54,   46,   33,   20,    9,   -2,
     -10,  -16,  -21,  -21,  -23,  -21,  -15,   -5,    9,   19,   30,   38,   42,   44,   46,   47,
      36,   22,    6,  -10,  -23,  -39,  -57,  -74,  -78,  -79,  -75,  -65,  -51,  -33,  -11,    9,
      25,   37,   46,   55,   56,   48,   34,   21,   10,    4,   -4,  -14,  -20,  -25,  -24,  -21,
     -12,   -3,    8,   17,   26,   36,   47,   50,   50,   47,   36,   25,   10,   -5,  -21,  -40,
     -57,  -75,  -82,  -79,  -75,  -64,  -51,  -37,  -16,    5,   25,   40,   48,   55,   55,   49,
      37,   25,   15,    6,   -6,  -18,  -26,  -29,  -25,  -20,  -16,   -7,    5,   17,   29,   39,
      49,   56,   56,   51,   39,   28,   15,    0,  -17,  -38,  -58,  -75,  -86,  -86,  -80,  -70,
     -54,  -37,  -16,    7,   25,   42,   50,   55,   58,   52,   40,   25,   11,    2,   -5,  -14,
     -21,  -26,  -26,  -18,  -12,   -5,    4,   13,   25,   34,   45,   53,   55,   48,   39,   25,
      16,    3,  -13,  -31,  -54,  -70,  -83,  -85,  -78,  -68,  -55,  -38,  -20,    1,   20,   36,
      46,   51,   55,   48,   39,   27,   17,    7,   -5,  -13,  -20,  -23,  -23,  -18,  -10,   -4,
       3,   10,   21,   29,   40,   48,   52,   50,   40,   28,   20,   10,   -5,  -24,  -48,  -67,
     -82,  -87,  -81,  -73,  -56,  -44,  -25,   -5,   15,   34,   46,   52,   55,   51,   39,   27,
      18,    7,   -2,  -13,  -22,  -25,  -24,  -16,   -9,    1,    8,   13,   22,   30,   42,   48,
      50,   47,   38,   26,   15,    6,   -8,  -22,  -41,  -61,  -77,  -86,  -81,  -70,  -54,  -40,
     -27,   -8,   12,   31,   42,   49,   50,   48,   38,   26,   16,    7,   -4,  -11,  -18,  -22,
     -21,  -16,   -9,    0,    9,   15,   21,   26,   35,   47,   50,   46,   36,   28,   18,    7,
      -7,  -22,  -37,  -53,  -70,  -81,  -83,  -72,  -58,  -43,  -30,  -14,    5,   22,   37,   44,
      46,   44,   37,   26,   17,    8,    2,   -7,  -12,  -17,  -16,  -12,   -6,    3,    8,   13,
      17,   22,   31,   42,   43,   43,   35,   29,   25,   14,    2,  -17,  -35,  -51,  -65,  -77,
     -80,  -75,  -63,  -47,  -34,  -18,    4,   21,   32,   38,   41,   41,   36,   28,   17,    8,
       1,   -9,  -12,  -16,  -15,   -9,   -2,    8,   13,   15,   17,   23,   28,   39,   43,   38,
      30,   21,   17,   11,    4,  -12,  -28,  -45,  -60,  -68,  -71,  -66,  -58,  -49,  -38,  -23,
      -5,   15,   27,   34,   34,   32,   28,   23,   18,   13,    4,   -2,   -7,   -9,   -7,   -4,
       5,   14,   16,   16,   14,   15,   24,   35,   39,   35,   23,   17,   15,   11,    8,   -4,
     -19,  -37,  -53,  -62,  -65,  -62,  -57,  -53,  -43,  -31,  -14,    5,   19,   27,   31,   28,
      26,   23,   20,   18,   11,    5,   -2,   -5,    0,    3,    8,   14,   16,   15,   11,    7,
      12,   23,   32,   32,   21,   12,   10,   13,   12,    6,   -9,  -27,  -43,  -50,  -55,  -53,
     -51,  -52,  -44,  -38,  -23,   -6,    7,   18,   22,   19,   16,   15,   16,   19,   17,   12,
       6,    3,    7,   10,   16,   20,   23,   20,   14,    8,    9,   17,   27,   26,   17,    6,
       3,    7,   10,    7,   -5,  -18,  -32,  -41,  -46,  -45,  -45,  -45,  -44,  -40,  -30,  -16,
      -3,    8,   15,   12,   10,   11,   16,   19,   19,   16,   12,   10,   11,   15,   20,   25,
      26,   24,   18,   11,    6,   11,   17,   21,   15,    3,   -6,   -2,    4,    7,    2,  -14,
     -25,  -32,  -36,  -38,  -37,  -37,  -35,  -33,  -33,  -25,  -15,   -4,    3,    4,    0,   -3,
       2,   13,   21,   21,   20,   17,   19,   23,   27,   31,   33,   31,   24,   16,    4,    2,
       7,   13,   13,    3,  -10,   -9,    0,    8,    7,   -3,  -15,  -22,  -24,  -30,  -32,  -37,
     -39,  -38,  -37,  -34,  -28,  -17,   -8,   -2,   -4,   -4,    4,   16,   26,   30,   26,   22,
      22,   25,   29,   31,   30,   29,   24,   17,    6,   -2,    7,   10,   13,    4,  -11,  -15,
     -10,    3,    8,    2,  -10,  -17,  -17,  -17,  -23,  -29,  -35,  -37,  -34,  -36,  -35,  -28,
     -19,  -10,  -11,  -14,   -8,    8,   21,   26,   26,   21,   24,   31,   38,   40,   38,   37,
      33,   26,   15,    4,    1,    2,    1,   -6,  -19,  -24,  -18,   -7,    2,    5,   -4,  -10,
      -9,   -6,   -7,  -16,  -27,  -33,  -35,  -38,  -41,  -38,  -32,  -22,  -20,  -18,  -10,    4,
      20,   29,   31,   30,   28,   32,   38,   43,   42,   39,   34,   28,   14,    4,    1,    3,
       4,   -5,  -21,  -30,  -26,  -14,    1,    3,   -4,   -8,   -8,    0,    0,   -8,  -15,  -26,
     -29,  -35,  -40,  -40,  -36,  -30,  -28,  -29,  -22,  -10,    9,   22,   28,   28,   27,   30,
      39,   46,   50,   50,   43,   33,   21,    9,    3,    3,    1,  -10,  -22,  -35,  -34,  -22,
      -8,    2,    0,   -6,   -7,    0,    5,   -2,   -9,  -18,  -28,  -34,  -41,  -43,  -39,  -35,
     -33,  -33,  -25,  -12,    5,   19,   26,   29,   31,   31,   39,   46,   51,   52,   47,   38,
      27,   18,   10,    5,   -3,  -13,  -22,  -33,  -36,  -28,  -16,   -4,   -2,   -4,   -6,    0,
       8,    7,    0,  -12,  -22,  -33,  -40,  -42,  -39,  -37,  -38,  -39,  -32,  -17,    2,   15,
      24,   25,   28,   33,   39,   47,   51,   53,   51,   44,   35,   23,   15,    8,    1,  -12,
     -25,  -37,  -41,  -33,  -22,  -11,   -4,   -5,   -3,    3,   10,   13,    6,   -5,  -17,  -28,
     -38,  -43,  -44,  -44,  -44,  -43,  -36,  -23,   -7,    7,   20,   26,   29,   35,   43,   51,
      54,   58,   56,   52,   44,   29,   18,    9,   -2,  -12,  -28,  -39,  -45,  -38,  -26,  -16,
      -7,   -3,    1,    6,   12,   15,   12,    3,  -11,  -25,  -37,  -41,  -43,  -46,  -47,  -46,
     -39,  -28,  -15,    0,   11,   21,   25,   31,   38,   46,   53,   60,   62,   59,   53,   42,
      32,   19,    6,  -10,  -27,  -41,  -47,  -47,  -39,  -31,  -21,   -9,   -2,    5,   11,   16,
      19,   13,    2,  -15,  -30,  -35,  -37,  -43,  -47,  -49,  -42,  -32,  -21,  -11,    0,    8,
      19,   27,   38,   47,   51,   58,   63,   63,   59,   50,   41,   28,   10,   -9,  -26,  -37,
     -43,  -44,  -40,  -33,  -23,  -11,    0,    6,    9,   14,   15,   13,    1,  -15,  -25,  -32,
     -34,  -43,  -49,  -50,  -43,  -30,  -20,  -13,   -9,    0,   10,   23,   36,   46,   52,   55,
      62,   65,   66,   61,   51,   36,   15,   -7,  -24,  -34,  -42,  -45,  -46,  -42,  -34,  -20,
      -5,    5,   11,   14,   16,   13,    2,  -10,  -18,  -24,  -31,  -39,  -49,  -48,  -42,  -34,
     -24,  -18,  -15,   -8,    2,   13,   29,   42,   51,   57,   62,   65,   70,   69,   60,   45,
      20,   -3,  -24,  -37,  -43,  -46,  -49,  -48,  -39,  -24,   -6,    5,   12,   17,   20,   16,
       6,   -9,  -15,  -21,  -26,  -38,  -50,  -56,  -50,  -37,  -26,  -23,  -19,  -14,   -4,   11,
      27,   42,   54,   58,   63,   65,   68,   70,   63,   50,   26,    1,  -21,  -37,  -43,  -44,
     -44,  -44,  -40,  -28,  -11,    5,   10,   16,   18,   14,    5,  -12,  -19,  -22,  -24,  -33,
     -47,  -52,  -52,  -38,  -25,  -17,  -17,  -16,  -10,    4,   22,   39,   53,   59,   62,   63,
      66,   68,   66,   55,   32,    9,  -17,  -34,  -43,  -42,  -39,  -38,  -38,  -31,  -19,   -3,
      10,   17,   19,   12,    3,  -12,  -21,  -24,  -24,  -31,  -40,  -49,  -52,  -41,  -30,  -18,
     -15,  -17,  -10,    0,   16,   33,   47,   59,   65,   64,   65,   67,   63,   56,   38,   13,
     -12,  -32,  -41,  -39,  -35,  -33,  -32,  -27,  -17,   -4,    8,   15,   16,   13,    4,  -11,
     -20,  -25,  -27,  -32,  -40,  -48,  -52,  -46,  -37,  -25,  -18,  -16,  -10,    1,   16,   33,
      49,   59,   66,   67,   65,   66,   62,   51,   38,   15,   -9,  -30,  -38,  -41,  -33,  -29,
     -26,  -23,  -17,   -5,    7,   16,   15,   14,    5,   -9,  -19,  -27,  -31,  -34,  -40,  -47,
     -52,  -49,  -40,  -30,  -22,  -16,   -8,    4,   19,   32,   46,   59,   67,   71,   69,   64,
      57,   49,   36,   17,   -7,  -27,  -38,  -40,  -35,  -28,  -23,  -19,  -12,   -5,    6,   12,
      16,   15,   10,   -5,  -19,  -28,  -32,  -36,  -39,  -46,  -53,  -52,  -45,  -34,  -25,  -18,
      -7,    6,   20,   33,   46,   60,   67,   74,   71,   65,   56,   46,   37,   18,   -2,  -20,
     -33,  -38,  -38,  -30,  -22,  -16,  -12,   -6,    2,    6,   15,   15,   11,    1,  -11,  -19,
     -31,  -37,  -42,  -46,  -51,  -54,  -53,  -46,  -35,  -26,  -14,    3,   17,   33,   45,   57,
      67,   75,   77,   71,   62,   50,   36,   18,    0,  -19,  -31,  -36,  -37,  -31,  -23,  -17,
     -11,   -6,    1,    6,   11,   15,   14,    8,   -3,  -16,  -27,  -37,  -41,  -47,  -52,  -58,
     -60,  -55,  -46,  -32,  -16,    0,   17,   32,   46,   59,   70,   79,   80,   75,   65,   51,
      35,   20,    2,  -15,  -27,  -38,  -42,  -36,  -27,  -17,  -10,   -4,    3,    7,   12,   18,
      19,   14,    5,   -7,  -22,  -37,  -46,  -53,  -57,  -62,  -67,  -65,  -58,  -43,  -22,    1,
      20,   35,   48,   60,   69,   79,   82,   79,   68,   53,   36,   21,    4,  -11,  -24,  -36,
     -40,  -38,  -31,  -21,  -14,   -5,    1,    5,   11,   17,   22,   19,   14,   -2,  -17,  -35,
     -48,  -55,  -63,  -67,  -73,  -72,  -64,  -49,  -27,   -4,   19,   36,   52,   64,   73,   81,
      85,   82,   72,   56,   36,   20,    3,  -14,  -24,  -33,  -36,  -35,  -32,  -22,  -13,   -6,
       2,    7,   10,   15,   19,   19,   17,    6,  -10,  -29,  -48,  -58,  -67,  -71,  -75,  -78,
     -72,  -58,  -35,  -10,   16,   35,   52,   65,   74,   80,   86,   87,   79,   62,   39,   21,
       5,  -11,  -22,  -33,  -39,  -39,  -34,  -25,  -15,   -7,    3,    8,   16,   17,   21,   22,
      19,    9,   -6,  -27,  -47,  -60,  -71,  -77,  -80,  -81,  -73,  -61,  -39,  -12,   16,   36,
      52,   63,   73,   80,   85,   87,   76,   59,   41,   23,    8,   -7,  -18,  -29,  -36,  -38,
     -33,  -23,  -13,   -8,    1,    6,   14,   18,   19,   23,   23,   17,    1,  -20,  -43,  -57,
     -67,  -78,  -83,  -89,  -81,  -67,  -45,  -19,    9,   35,   55,   67,   74,   80,   87,   91,
      83,   68,   44,   24,    6,   -9,  -21,  -29,  -36,  -39,  -39,  -31,  -20,  -10,    1,   13,
      20,   26,   26,   27,   28,   22,    8,  -16,  -40,  -60,  -75,  -86,  -93,  -95,  -89,  -75,
     -52,  -24,    7,   37,   57,   69,   77,   83,   90,   93,   85,   70,   48,   27,    8,   -8,
     -19,  -26,  -32,  -35,  -39,  -37,  -28,  -17,   -2,    9,   19,   21,   27,   31,   32,   29,
      12,   -9,  -32,  -54,  -71,  -86,  -94,  -96,  -90,  -82,  -62,  -33,    2,   34,   56,   69,
      78,   87,   94,   94,   85,   69,   49,   29,    9,  -10,  -21,  -27,  -30,  -33,  -37,  -36,
     -29,  -17,   -5,    9,   19,   25,   27,   31,   33,   33,   21,   -2,  -25,  -51,  -71,  -86,
     -95,  -95,  -92,  -85,  -69,  -42,   -8,   27,   52,   67,   74,   83,   92,   95,   89,   75,
      56,   35,   16,   -6,  -17,  -26,  -28,  -34,  -41,  -39,  -37,  -25,   -9,    6,   20,   28,
      31,   37,   37,   34,   24,    3,  -20,  -46,  -69,  -85,  -96,  -99,  -97,  -89,  -73,  -47,
     -11,   21,   45,   61,   73,   84,   92,   95,   89,   77,   61,   41,   20,   -2,  -13,  -20,
     -28,  -36,  -43,  -46,  -40,  -30,  -16,    0,   12,   24,   30,   38,   43,   41,   33,   13,
     -14,  -39,  -63,  -80,  -93,  -98, -100,  -94,  -76,  -52,  -19,   14,   38,   56,   70,   80,
      90,   94,   88,   75,   58,   40,   22,    6,   -8,  -19,  -25,  -33,  -39,  -41,  -38,  -31,
     -19,   -5,    7,   21,   31,   39,   45,   42,   32,   15,   -8,  -32,  -55,  -77,  -93, -102,
    -101,  -94,  -80,  -57,  -29,    5,   34,   54,   70,   78,   88,   96,   92,   80,   62,   41,
      24,    8,   -9,  -21,  -32,  -35,  -38,  -41,  -39,  -35,  -22,   -6,    6,   21,   31,   39,
      46,   44,   35,   18,   -5,  -27,  -49,  -70,  -86,  -97, -102,  -96,  -84,  -58,  -30,   -2,
      26,   45,   62,   74,   82,   89,   89,   80,   66,   46,   28,   12,   -3,  -14,  -26,  -36,
     -39,  -42,  -40,  -36,  -28,  -15,    0,   17,   30,   37,   45,   48,   40,   23,    3,  -20,
     -43,  -64,  -81,  -93,  -98,  -96,  -85,  -65,  -38,   -8,   20,   40,   55,   68,   80,   88,
      88,   82,   68,   54,   35,   18,    2,  -12,  -24,  -35,  -40,  -45,  -45,  -41,  -33,  -20,
      -4,   15,   31,   41,   49,   52,   48,   32,   13,  -14,  -38,  -59,  -77,  -92, -101, -102,
     -91,  -70,  -45,  -15,   15,   38,   53,   65,   77,   89,   91,   85,   71,   52,   38,   21,
       5,  -12,  -26,  -36,  -42,  -45,  -45,  -43,  -34,  -22,   -7,    9,   26,   39,   50,   56,
      50,   34,   14,   -7,  -29,  -50,  -69,  -84,  -96,  -98,  -90,  -72,  -50,  -24,    7,   32,
      48,   57,   68,   84,   91,   88,   74,   58,   44,   30,   11,   -9,  -26,  -38,  -41,  -46,
     -45,  -44,  -38,  -23,   -7,    9,   24,   36,   49,   55,   51,   35,   18,   -3,  -24,  -45,
     -64,  -78,  -89,  -93,  -90,  -75,  -54,  -29,    0,   23,   42,   54,   67,   80,   90,   91,
      81,   65,   48,   31,   13,   -5,  -24,  -41,  -50,  -53,  -51,  -46,  -42,  -28,  -10,    8,
      23,   36,   50,   59,   56,   44,   26,    8,  -13,  -35,  -56,  -77,  -89,  -94,  -92,  -80,
     -61,  -39,  -11,   14,   33,   50,   63,   77,   88,   89,   81,   67,   54,   38,   21,    1,
     -23,  -39,  -50,  -54,  -53,  -46,  -42,  -31,  -17,    1,   17,   33,   46,   56,   56,   46,
      33,   16,   -4,  -24,  -46,  -67,  -82,  -92,  -94,  -87,  -67,  -45,  -19,    4,   22,   43,
      62,   76,   87,   90,   87,   76,   59,   40,   20,    1,  -22,  -40,  -55,  -62,  -58,  -50,
     -40,  -29,  -17,   -3,   14,   33,   49,   59,   58,   49,   35,   21,    2,  -17,  -39,  -59,
     -76,  -90,  -93,  -86,  -70,  -49,  -29,   -8,   12,   33,   57,   75,   84,   87,   84,   78,
      65,   47,   28,    6,  -18,  -39,  -58,  -65,  -64,  -57,  -44,  -33,  -22,  -10,    6,   26,
      44,   56,   56,   48,   40,   27,   11,   -8,  -30,  -49,  -65,  -80,  -86,  -87,  -72,  -51,
     -31,  -13,    5,   24,   48,   70,   81,   86,   83,   79,   69,   51,   30,    8,  -16,  -37,
     -55,  -65,  -67,  -61,  -48,  -36,  -21,  -10,    5,   22,   40,   55,   58,   53,   43,   31,
      16,   -2,  -23,  -45,  -60,  -74,  -82,  -86,  -75,  -56,  -36,  -16,    1,   21,   44,   65,
      81,   88,   85,   81,   72,   54,   33,    8,  -18,  -41,  -58,  -71,  -74,  -70,  -56,  -41,
     -23,   -6,    8,   23,   38,   53,   60,   59,   50,   37,   22,    1,  -20,  -41,  -56,  -69,
     -79,  -83,  -78,  -62,  -42,  -20,    2,   22,   41,   59,   77,   86,   87,   79,   67,   50,
      31,   10,  -15,  -36,  -52,  -63,  -69,  -69,  -59,  -41,  -23,   -9,    4,   15,   29,   44,
      55,   56,   53,   43,   27,   12,   -8,  -27,  -44,  -57,  -68,  -78,  -77,  -67,  -48,  -29,
     -12,   12,   32,   52,   70,   79,   84,   82,   73,   59,   38,   15,   -9,  -33,  -52,  -63,
     -71,  -72,  -66,  -50,  -30,  -13,    2,   12,   27,   42,   50,   54,   54,   46,   34,   19,
      -2,  -19,  -35,  -47,  -61,  -71,  -72,  -66,  -51,  -36,  -19,    5,   27,   46,   63,   74,
      79,   79,   70,   58,   41,   21,    3,  -24,  -44,  -58,  -66,  -66,  -65,  -52,  -36,  -22,
     -10,    4,   18,   34,   43,   49,   52,   48,   43,   31,   14,   -4,  -21,  -35,  -51,  -61,
     -66,  -64,  -56,  -43,  -29,   -8,   16,   37,   54,   67,   72,   74,   70,   61,   46,   27,
       7,  -19,  -40,  -56,  -62,  -62,  -63,  -55,  -43,  -26,  -10,    3,   13,   26,   38,   44,
      47,   43,   39,   30,   19,    5,  -12,  -24,  -40,  -47,  -51,  -53,  -51,  -44,  -32,  -14,
       6,   24,   41,   54,   61,   63,   61,   56,   47,   32,   13,   -9,  -31,  -46,  -56,  -53,
     -54,  -54,  -48,  -37,  -18,   -3,    8,   17,   27,   33,   38,   39,   39,   37,   30,   18,
       1,  -16,  -29,  -35,  -39,  -42,  -47,  -47,  -39,  -22,   -3,   14,   29,   42,   51,   57,
      56,   54,   45,   36,   20,   -2,  -23,  -41,  -50,  -51,  -52,  -53,  -51,  -42,  -27,   -8,
       5,   12,   19,   28,   35,   40,   39,   40,   37,   28,   12,   -7,  -23,  -28,  -30,  -37,
     -43,  -49,  -45,  -32,  -15,    3,   19,   34,   45,   49,   49,   51,   47,   41,   26,    6,
     -18,  -34,  -43,  -45,  -45,  -48,  -51,  -49,  -33,  -15,   -2,    8,   12,   19,   26,   33,
      38,   38,   38,   34,   25,    8,  -11,  -19,  -20,  -23,  -32,  -43,  -48,  -41,  -24,   -8,
      10,   21,   31,   38,   43,   47,   48,   45,   34,   16,   -9,  -31,  -41,  -42,  -42,  -46,
     -52,  -52,  -40,  -23,   -6,    6,   11,   17,   24,   30,   35,   38,   39,   40,   29,   14,
      -3,  -14,  -14,  -15,  -24,  -36,  -47,  -45,  -33,  -15,    3,   14,   23,   29,   35,   39,
      44,   45,   38,   22,   -3,  -26,  -38,  -37,  -37,  -41,  -50,  -56,  -45,  -26,   -8,    5,
      12,   16,   22,   27,   32,   39,   41,   41,   33,   17,    1,   -9,   -8,   -8,  -16,  -30,
     -41,  -45,  -35,  -21,   -5,   10,   18,   24,   28,   31,   38,   42,   39,   25,    2,  -23,
     -36,  -36,  -37,  -39,  -47,  -53,  -47,  -31,  -11,    3,   12,   16,   23,   27,   32,   37,
      40,   41,   33,   18,    2,   -7,   -8,   -6,  -10,  -23,  -36,  -41,  -35,  -20,   -6,    7,
      14,   17,   24,   29,   36,   42,   40,   28,    5,  -20,  -35,  -38,  -38,  -39,  -45,  -51,
     -46,  -33,  -15,    2,   13,   22,   27,   28,   27,   30,   37,   41,   35,   20,    5,   -4,
      -4,   -2,   -3,  -13,  -28,  -35,  -32,  -23,  -10,    3,   11,   14,   14,   20,   28,   37,
      40,   27,    7,  -16,  -31,  -36,  -37,  -36,  -41,  -44,  -45,  -35,  -18,    1,   12,   19,
      25,   26,   27,   31,   34,   39,   34,   20,    8,    0,    0,    1,    0,   -9,  -23,  -33,
     -34,  -24,  -10,    2,    8,    8,   10,   16,   27,   34,   35,   27,   10,  -10,  -27,  -35,
     -35,  -34,  -39,  -46,  -47,  -38,  -22,   -3,   10,   19,   26,   31,   32,   32,   35,   41,
      39,   25,    9,   -2,   -3,   -2,   -2,   -7,  -19,  -30,  -33,  -26,  -14,   -3,    6,    6,
       7,   12,   26,   37,   37,   26,   10,   -8,  -25,  -35,  -39,  -39,  -42,  -47,  -49,  -42,
     -27,   -4,   12,   20,   29,   33,   36,   35,   35,   38,   37,   27,   10,   -3,   -6,   -3,
      -2,   -7,  -16,  -24,  -28,  -24,  -13,   -4,    4,    5,    7,    9,   19,   30,   33,   28,
      12,   -6,  -24,  -35,  -40,  -39,  -42,  -47,  -47,  -41,  -26,   -8,   10,   22,   31,   36,
      41,   39,   34,   33,   33,   29,   15,    2,   -7,   -8,   -6,   -6,  -10,  -18,  -24,  -24,
     -15,   -5,    6,    7,    7,   10,   17,   23,   23,   18,    9,   -7,  -23,  -36,  -42,  -41,
     -41,  -45,  -45,  -39,  -28,  -11,    7,   21,   31,   36,   39,   39,   34,   31,   33,   29,
      19,    7,   -5,   -6,   -6,   -4,   -6,  -13,  -17,  -20,  -16,   -8,    1,    6,    7,    7,
      11,   16,   20,   18,    9,   -7,  -24,  -37,  -43,  -42,  -42,  -42,  -45,  -41,  -28,  -11,
       7,   19,   28,   35,   40,   42,   38,   33,   29,   27,   21,   10,   -2,   -8,   -8,   -6,
      -8,  -11,  -13,  -16,  -14,   -8,    1,    5,    8,    9,   15,   19,   20,   18,    9,   -4,
     -18,  -34,  -42,  -46,  -47,  -45,  -47,  -45,  -36,  -20,    0,   13,   26,   36,   45,   48,
      42,   35,   29,   28,   26,   20,    6,   -6,  -10,  -10,   -6,   -7,   -8,  -10,  -14,  -10,
      -7,    0,    6,    8,   13,   14,   16,   13,    7,   -3,  -13,  -27,  -37,  -44,  -49,  -44,
     -42,  -40,  -37,  -25,   -9,    9,   23,   31,   41,   44,   44,   37,   30,   27,   28,   27,
      15,    2,   -7,   -9,   -6,   -7,   -9,   -8,  -13,  -12,   -8,   -3,    4,    9,   13,   14,
      14,   11,    6,    0,   -9,  -23,  -34,  -43,  -49,  -46,  -42,  -40,  -35,  -29,  -13,    3,
      19,   31,   41,   45,   43,   37,   31,   29,   30,   28,   19,    4,   -5,   -7,   -7,   -5,
      -8,   -7,   -9,  -11,   -9,   -4,    0,    6,   12,   14,   13,    9,    5,   -3,   -9,  -19,
     -28,  -37,  -48,  -48,  -45,  -39,  -34,  -30,  -18,   -5,   12,   23,   34,   42,   44,   39,
      34,   32,   31,   33,   30,   18,    8,    1,   -5,   -6,   -5,   -5,   -8,  -13,  -16,  -14,
      -7,    2,    7,   11,   10,    7,    4,   -2,   -7,  -12,  -22,  -32,  -45,  -50,  -45,  -38,
     -33,  -30,  -24,  -13,    2,   20,   31,   39,   43,   42,   38,   36,   33,   33,   33,   24,
      14,    1,   -8,   -9,   -7,   -4,   -5,  -11,  -16,  -16,  -11,   -4,    2,    9,    8,    7,
       3,   -3,   -6,   -9,  -15,  -24,  -38,  -47,  -48,  -42,  -35,  -32,  -29,  -21,   -9,   11,
      27,   35,   42,   42,   42,   40,   40,   38,   36,   30,   19,    8,   -4,   -9,   -8,   -5,
      -5,  -12,  -18,  -20,  -15,   -5,   -2,    3,    4,    5,    6,    1,   -3,   -8,  -12,  -19,
     -31,  -43,  -47,  -43,  -36,  -35,  -36,  -32,  -19,    2,   19,   30,   38,   42,   46,   49,
      50,   47,   43,   39,   28,   16,    1,  -10,  -13,  -11,   -9,  -14,  -21,  -25,  -20,  -10,
      -4,    1,    3,    4,    7,    4,   -3,   -7,   -7,  -10,  -23,  -38,  -47,  -46,  -41,  -37,
     -38,  -37,  -27,  -11,   11,   24,   33,   38,   45,   50,   53,   52,   48,   43,   37,   25,
      10,   -3,  -11,  -11,  -11,  -13,  -20,  -27,  -29,  -22,  -14,   -7,   -2,    2,    6,    3,
      -2,   -3,    0,    0,  -11,  -28,  -41,  -45,  -39,  -35,  -36,  -39,  -37,  -24,   -7,   11,
      22,   32,   41,   51,   55,   56,   54,   53,   50,   40,   23,    6,   -5,  -10,  -11,  -14,
     -20,  -28,  -34,  -33,  -25,  -16,  -10,   -5,    0,    0,    1,    2,    4,    5,   -4,  -16,
     -29,  -35,  -37,  -37,  -35,  -39,  -39,  -32,  -19,    0,   13,   23,   36,   46,   54,   58,
      57,   59,   56,   47,   33,   16,    3,   -5,   -9,  -11,  -19,  -29,  -36,  -39,  -33,  -26,
     -18,  -12,   -7,   -5,   -2,    4,   11,   15,   10,   -3,  -18,  -29,  -32,  -35,  -36,  -41,
     -44,  -40,  -30,  -18,    0,   13,   28,   41,   50,   59,   63,   66,   66,   60,   44,   26,
      11,    2,   -6,  -12,  -19,  -29,  -38,  -44,  -41,  -33,  -25,  -16,   -9,   -8,   -6,    1,
      11,   18,   16,    8,   -6,  -17,  -27,  -32,  -36,  -39,  -43,  -44,  -37,  -30,  -12,    8,
      26,   39,   46,   56,   64,   70,   72,   66,   51,   36,   18,    7,   -4,  -11,  -18,  -29,
     -42,  -50,  -51,  -45,  -35,  -23,  -14,  -10,   -9,    0,   14,   27,   29,   20,    7,   -5,
     -15,  -23,  -30,  -38,  -45,  -50,  -49,  -43,  -30,   -9,   13,   31,   41,   52,   65,   75,
      79,   77,   66,   50,   30,   13,    3,   -6,  -14,  -26,  -41,  -53,  -57,  -54,  -44,  -32,
     -23,  -17,  -13,   -5,   10,   24,   31,   28,   20,    9,   -5,  -17,  -26,  -35,  -40,  -48,
     -54,  -53,  -44,  -23,    0,   21,   35,   46,   60,   73,   81,   83,   77,   60,   42,   25,
      11,    1,  -11,  -25,  -42,  -57,  -64,  -62,  -54,  -43,  -33,  -24,  -17,   -6,    9,   23,
      37,   37,   33,   19,    6,   -9,  -20,  -30,  -41,  -49,  -57,  -59,  -54,  -38,  -16,   10,
      31,   46,   58,   70,   78,   85,   84,   73,   54,   32,   16,    5,   -5,  -22,  -41,  -60,
     -72,  -71,  -66,  -54,  -43,  -30,  -19,   -6,   10,   25,   41,   47,   43,   32,   20,    7,
     -10,  -25,  -40,  -52,  -61,  -68,  -65,  -54,  -34,  -11,   16,   39,   57,   72,   80,   88,
      91,   83,   67,   46,   28,   13,    1,  -18,  -40,  -62,  -77,  -77,  -70,  -63,  -54,  -43,
     -30,  -12,    7,   25,   40,   51,   51,   42,   31,   19,    3,  -13,  -32,  -48,  -60,  -68,
     -71,  -63,  -49,  -28,   -2,   23,   46,   66,   77,   86,   92,   89,   82,   62,   43,   22,
       7,  -12,  -39,  -59,  -74,  -80,  -78,  -72,  -63,  -50,  -35,  -17,    5,   22,   35,   45,
      49,   49,   42,   31,   13,   -7,  -25,  -38,  -49,  -59,  -66,  -65,  -57,  -42,  -20,    8,
      34,   55,   69,   79,   84,   84,   84,   77,   64,   42,   18,   -6,  -29,  -49,  -69,  -82,
     -87,  -87,  -78,  -66,  -48,  -27,   -4,   17,   33,   47,   56,   60,   58,   49,   31,    8,
     -18,  -36,  -47,  -57,  -67,  -75,  -74,  -60,  -36,   -3,   25,   48,   65,   76,   83,   87,
      90,   88,   77,   52,   24,   -4,  -26,  -42,  -61,  -77,  -91,  -94,  -85,  -70,  -54,  -34,
     -11,   12,   30,   44,   56,   63,   66,   61,   43,   19,   -8,  -27,  -39,  -49,  -62,  -74,
     -80,  -71,  -49,  -20,    9,   34,   56,   70,   79,   86,   93,   96,   91,   70,   41,   11,
     -18,  -39,  -58,  -77,  -91,  -99,  -95,  -83,  -65,  -42,  -17,    7,   27,   43,   57,   66,
      69,   67,   55,   32,    5,  -21,  -32,  -42,  -56,  -73,  -84,  -79,  -60,  -33,   -5,   21,
      44,   61,   72,   80,   92,  100,   99,   82,   54,   23,  -10,  -31,  -51,  -71,  -87, -101,
    -101,  -92,  -76,  -49,  -24,    1,   21,   37,   52,   66,   72,   72,   64,   44,   18,   -7,
     -23,  -31,  -45,  -64,  -79,  -83,  -71,  -46,  -18,    7,   27,   46,   62,   72,   85,   97,
     100,   92,   65,   35,    2,  -22,  -40,  -60,  -78,  -92, -100,  -96,  -82,  -59,  -29,   -6,
      15,   28,   44,   57,   65,   67,   65,   49,   27,    2,  -17,  -23,  -35,  -53,  -70,  -79,
     -73,  -52,  -27,   -4,   16,   35,   54,   65,   77,   88,   95,   93,   73,   44,   12,  -17,
     -38,  -54,  -74,  -86,  -97,  -98,  -89,  -69,  -37,  -11,    9,   27,   42,   56,   65,   68,
      71,   59,   39,   13,   -9,  -20,  -30,  -45,  -62,  -74,  -75,  -60,  -41,  -18,    3,   23,
      43,   60,   74,   83,   91,   91,   78,   52,   22,   -8,  -30,  -46,  -66,  -82,  -90,  -92,
     -85,  -70,  -44,  -17,    5,   22,   33,   45,   56,   60,   63,   56,   39,   21,    5,   -9,
     -20,  -33,  -49,  -62,  -70,  -62,  -47,  -28,   -9,   11,   29,   47,   60,   73,   83,   87,
      81,   62,   32,    4,  -21,  -39,  -60,  -78,  -88,  -90,  -86,  -73,  -55,  -28,   -2,   18,
      30,   42,   50,   57,   58,   53,   44,   27,   15,    4,  -10,  -24,  -40,  -53,  -59,  -57,
     -49,  -38,  -21,   -3,   17,   34,   49,   62,   75,   81,   76,   63,   39,   15,  -11,  -31,
     -50,  -69,  -79,  -84,  -82,  -73,  -57,  -34,   -7,   12,   26,   35,   42,   50,   56,   53,
      42,   31,   20,   13,    1,  -16,  -30,  -43,  -50,  -51,  -49,  -42,  -28,  -11,    7,   23,
      38,   52,   65,   75,   73,   62,   43,   20,   -2,  -24,  -43,  -60,  -69,  -74,  -74,  -69,
     -59,  -42,  -19,    2,   19,   27,   34,   41,   48,   50,   45,   39,   33,   25,   13,   -3,
     -18,  -32,  -42,  -47,  -49,  -47,  -40,  -27,   -8,   11,   28,   43,   57,   69,   73,   65,
      50,   31,    8,  -16,  -36,  -53,  -63,  -70,  -72,  -70,  -62,  -46,  -25,   -6,   11,   23,
      30,   38,   45,   49,   50,   46,   42,   33,   22,    6,  -13,  -25,  -37,  -43,  -48,  -50,
     -45,  -35,  -18,    2,   21,   39,   51,   61,   64,   63,   53,   38,   19,   -6,  -30,  -49,
     -59,  -63,  -65,  -66,  -64,  -52,  -31,  -14,    2,   13,   25,   35,   42,   46,   46,   47,
      48,   44,   33,   15,   -6,  -21,  -32,  -37,  -42,  -48,  -46,  -39,  -26,   -8,   12,   31,
      45,   55,   58,   57,   51,   39,   22,    2,  -21,  -39,  -49,  -56,  -59,  -62,  -59,  -52,
     -38,  -22,   -9,    5,   16,   25,   32,   40,   46,   51,   54,   52,   40,   24,    5,  -11,
     -20,  -28,  -35,  -44,  -48,  -43,  -33,  -17,    0,   18,   32,   44,   48,   49,   48,   40,
      28,   11,  -10,  -26,  -37,  -45,  -52,  -58,  -57,  -51,  -41,  -29,  -19,  -10,    3,   15,
      27,   36,   40,   50,   59,   60,   51,   33,   15,    2,  -11,  -21,  -34,  -45,  -49,  -45,
     -36,  -25,  -11,    8,   26,   38,   43,   42,   41,   39,   31,   16,   -5,  -24,  -31,  -37,
     -43,  -51,  -54,  -49,  -40,  -31,  -24,  -13,   -3,   12,   22,   29,   33,   43,   55,   60,
      53,   37,   18,    5,   -4,  -12,  -23,  -35,  -44,  -42,  -35,  -26,  -15,   -2,   15,   26,
      33,   31,   31,   29,   28,   21,    6,  -13,  -27,  -30,  -37,  -44,  -48,  -45,  -39,  -34,
     -28,  -18,   -8,    4,   17,   23,   31,   40,   51,   58,   56,   42,   25,   12,    2,   -7,
     -16,  -27,  -36,  -39,  -37,  -31,  -21,  -12,    3,   14,   21,   25,   23,   23,   25,   23,
      11,   -4,  -16,  -21,  -26,  -34,  -39,  -40,  -34,  -31,  -30,  -23,  -17,   -3,    9,   16,
      23,   31,   42,   54,   57,   49,   29,   14,    7,    4,   -3,  -15,  -26,  -32,  -32,  -31,
     -24,  -16,   -5,    5,    8,   10,    9,   10,   16,   19,   14,    4,   -8,  -14,  -16,  -21,
     -29,  -34,  -33,  -30,  -29,  -26,  -20,  -10,    2,   11,   20,   28,   40,   51,   55,   51,
      33,   17,    9,    6,    4,   -9,  -20,  -28,  -32,  -29,  -25,  -20,  -11,   -2,    3,    4,
       1,    6,   12,   18,   16,    8,   -5,  -10,  -14,  -17,  -20,  -23,  -25,  -26,  -28,  -26,
     -21,  -12,   -2,    6,   13,   20,   29,   40,   48,   48,   37,   23,   13,    8,    7,    3,
      -6,  -15,  -22,  -24,  -24,  -21,  -16,  -10,   -6,  -11,  -15,  -10,    1,   12,   15,    9,
       4,    3,    1,   -5,  -11,  -18,  -18,  -22,  -25,  -29,  -27,  -19,   -7,    4,   10,   14,
      21,   35,   46,   48,   40,   27,   16,   13,   11,   11,    5,   -5,  -14,  -19,  -21,  -24,
     -19,  -14,  -13,  -17,  -21,  -21,  -11,    1,   11,   12,    5,    3,    2,    5,    6,    0,
      -6,  -16,  -20,  -25,  -26,  -20,  -12,   -4,    1,    5,   11,   25,   38,   46,   41,   33,
      21,   17,   15,   15,   14,    8,   -3,  -14,  -23,  -27,  -26,  -21,  -20,  -22,  -26,  -25,
     -20,   -7,    5,   10,   10,    8,    5,    6,    6,    5,    1,   -7,  -14,  -20,  -23,  -21,
     -17,  -11,   -4,    2,    7,   17,   29,   38,   40,   37,   30,   23,   21,   20,   17,   14,
       5,   -6,  -19,  -26,  -29,  -25,  -24,  -27,  -28,  -28,  -26,  -18,   -4,    6,    9,    8,
       4,    5,   10,   12,   11,    3,   -8,  -15,  -18,  -18,  -15,  -11,  -10,   -5,    1,    8,
      16,   26,   35,   35,   31,   24,   22,   21,   22,   21,   16,    5,  -12,  -24,  -30,  -31,
     -29,  -31,  -32,  -31,  -32,  -22,  -12,    0,    7,   11,   12,   10,   11,   15,   13,   10,
       2,  -10,  -13,  -16,  -17,  -14,  -14,  -12,   -6,    0,   10,   20,   26,   32,   30,   29,
      27,   26,   28,   26,   22,   13,   -2,  -16,  -25,  -30,  -32,  -33,  -35,  -35,  -34,  -28,
     -19,  -12,   -5,    1,    5,    9,   11,   16,   17,   18,   11,    3,   -4,  -10,  -12,  -13,
     -12,  -13,  -14,  -10,   -4,    8,   20,   27,   31,   31,   28,   29,   31,   30,   26,   17,
       5,   -9,  -23,  -32,  -37,  -36,  -34,  -35,  -34,  -32,  -24,  -16,   -7,    2,    4,    6,
      10,   16,   17,   15,   12,    8,    3,   -5,  -11,  -11,  -10,  -11,  -12,  -11,   -5,    3,
      13,   22,   30,   32,   27,   25,   25,   28,   27,   19,    7,   -8,  -22,  -31,  -34,  -32,
     -30,  -28,  -31,  -31,  -29,  -21,  -12,   -4,    1,    1,    3,   10,   16,   18,   18,   14,
      12,    3,   -5,   -8,   -7,   -8,  -10,  -12,  -12,   -5,    6,   16,   26,   30,   29,   24,
      25,   26,   29,   23,   13,   -2,  -16,  -26,  -32,  -33,  -30,  -30,  -30,  -30,  -29,  -25,
     -18,  -12,   -5,   -2,    2,    8,   14,   18,   16,   18,   14,   10,    4,    0,   -5,   -4,
      -7,   -9,  -14,  -10,   -3,    9,   19,   26,   26,   23,   23,   26,   29,   28,   21,    7,
     -10,  -19,  -25,  -26,  -27,  -27,  -29,  -30,  -32,  -31,  -27,  -19,  -13,   -9,   -7,    0,
       9,   18,   24,   26,   21,   13,    9,    8,    4,   -2,   -6,   -9,  -11,  -11,   -7,    4,
      16,   24,   26,   21,   19,   22,   26,   29,   23,    7,  -10,  -17,  -19,  -19,  -23,  -25,
     -25,  -25,  -26,  -26,  -29,  -26,  -17,  -14,   -9,   -7,    1,   12,   21,   26,   23,   18,
      13,   11,   11,    6,   -4,   -6,  -10,  -10,   -9,   -2,    9,   20,   25,   23,   18,   18,
      23,   26,   24,   10,   -5,  -13,  -17,  -14,  -15,  -17,  -20,  -24,  -25,  -29,  -31,  -32,
     -28,  -22,  -16,  -13,   -8,    2,   14,   25,   27,   27,   22,   17,   15,   13,   10,    5,
      -3,   -6,   -8,   -6,    1,   11,   18,   20,   13,   11,   15,   19,   20,   14,    4,   -4,
     -12,  -12,  -12,  -12,  -14,  -17,  -23,  -30,  -35,  -37,  -31,  -26,  -20,  -16,  -12,   -4,
       9,   22,   28,   26,   22,   17,   14,   15,   11,    8,    6,    2,    0,   -2,    4,   11,
      16,   16,   12,    7,    8,   13,   13,   10,    1,   -5,   -8,   -8,   -8,   -7,   -7,  -10,
     -20,  -26,  -34,  -36,  -33,  -31,  -29,  -25,  -19,  -12,    4,   18,   27,   28,   23,   22,
      18,   19,   17,   14,    9,    7,    4,    0,    2,    8,   14,   16,   12,    2,    0,    2,
       5,    6,    2,   -4,   -7,   -6,   -2,   -2,   -3,   -5,  -11,  -19,  -28,  -37,  -37,  -37,
     -34,  -29,  -24,  -18,   -8,    7,   20,   25,   25,   25,   22,   21,   21,   21,   19,   15,
      11,    6,    6,    6,   10,   11,    6,   -2,   -5,   -5,   -2,    0,    0,    0,   -4,    0,
       2,    4,    2,   -2,   -8,  -16,  -25,  -34,  -39,  -42,  -39,  -33,  -26,  -21,  -16,   -4,
      11,   22,   25,   27,   25,   23,   23,   24,   25,   22,   17,   13,   10,    9,   12,   10,
       4,   -5,  -12,  -12,  -11,   -9,   -8,   -6,   -5,    1,    4,    8,   10,    7,    4,   -7,
     -18,  -26,  -34,  -39,  -43,  -42,  -34,  -28,  -22,  -13,    2,   14,   18,   21,   23,   27,
      30,   32,   31,   28,   23,   20,   20,   15,   14,   10,    2,   -5,  -13,  -15,  -16,  -16,
     -12,  -12,   -5,    1,    5,    8,    8,   10,    8,    0,  -13,  -23,  -27,  -33,  -40,  -44,
     -41,  -32,  -24,  -17,   -6,    3,    9,   17,   22,   25,   29,   34,   39,   36,   32,   26,
      25,   23,   19,   11,    1,   -9,  -16,  -18,  -17,  -19,  -21,  -17,   -8,    0,    4,    7,
       8,   10,   11,    6,   -4,  -13,  -21,  -25,  -35,  -40,  -41,  -37,  -26,  -21,  -13,   -8,
      -3,    6,   15,   23,   27,   35,   40,   41,   38,   33,   31,   29,   24,   16,    5,   -5,
     -16,  -23,  -23,  -23,  -18,  -14,   -6,    2,    3,    4,    7,   11,   13,    7,   -5,  -13,
     -21,  -25,  -32,  -40,  -42,  -37,  -28,  -21,  -14,  -13,   -9,    1,   11,   22,   27,   33,
      39,   43,   42,   41,   33,   29,   25,   18,    7,   -6,  -17,  -25,  -24,  -23,  -21,  -16,
      -9,    2,    6,    5,    5,   10,   15,   12,    3,   -8,  -16,  -22,  -29,  -39,  -44,  -42,
     -34,  -27,  -22,  -21,  -17,   -8,    4,   19,   29,   40,   48,   53,   51,   49,   43,   38,
      28,   19,    6,   -9,  -19,  -27,  -30,  -30,  -24,  -16,  -10,   -3,    3,    6,    5,    6,
       9,   11,    7,    2,   -7,  -16,  -25,  -34,  -37,  -37,  -33,  -31,  -28,  -27,  -24,  -20,
     -10,    8,   22,   35,   46,   52,   53,   54,   49,   46,   37,   23,    9,   -7,  -18,  -24,
     -30,  -32,  -28,  -22,  -12,   -5,    1,    6,    4,    8,    9,   11,    9,    3,   -3,  -13,
     -21,  -32,  -37,  -38,  -35,  -34,  -32,  -32,  -32,  -27,  -14,    5,   24,   38,   48,   55,
      56,   56,   54,   50,   40,   23,    4,  -10,  -18,  -24,  -26,  -29,  -29,  -24,  -17,   -5,
       2,    9,    9,    6,    6,    7,   12,   11,    6,   -7,  -18,  -30,  -36,  -36,  -37,  -35,
     -38,  -40,  -41,  -36,  -24,   -2,   20,   35,   47,   55,   60,   62,   62,   61,   47,   26,
       7,  -12,  -18,  -22,  -24,  -28,  -33,  -31,  -24,  -12,   -2,    7,    9,    5,    4,    5,
      11,   14,   13,    7,   -8,  -24,  -37,  -41,  -38,  -34,  -37,  -44,  -50,  -46,  -33,  -10,
      16,   36,   49,   57,   61,   64,   66,   65,   55,   34,   11,  -14,  -24,  -26,  -26,  -24,
     -30,  -34,  -33,  -24,   -7,    5,   12,   10,    5,    6,    9,   16,   22,   21,   10,  -10,
     -32,  -45,  -44,  -38,  -38,  -47,  -61,  -60,  -48,  -21,   11,   34,   51,   60,   63,   66,
      70,   69,   63,   45,   18,  -10,  -27,  -27,  -23,  -20,  -28,  -36,  -37,  -32,  -17,   -2,
       8,    9,    5,    6,    8,   15,   24,   30,   25,    5,  -22,  -41,  -44,  -40,  -38,  -50,
     -64,  -72,  -62,  -37,   -3,   29,   52,   62,   66,   69,   73,   78,   72,   54,   26,   -5,
     -25,  -32,  -29,  -24,  -27,  -34,  -37,  -36,  -26,  -11,    5,   15,   15,   11,    9,   15,
      26,   35,   33,   14,  -14,  -37,  -49,  -47,  -45,  -51,  -63,  -72,  -66,  -42,  -10,   22,
      49,   64,   69,   69,   70,   75,   73,   59,   34,    4,  -20,  -30,  -30,  -25,  -24,  -29,
     -36,  -40,  -35,  -22,   -2,   16,   20,   17,   14,   15,   27,   39,   41,   27,   -4,  -32,
     -48,  -54,  -53,  -59,  -65,  -73,  -71,  -55,  -23,   16,   49,   67,   70,   68,   71,   77,
      78,   65,   40,   10,  -17,  -31,  -34,  -28,  -24,  -26,  -31,  -40,  -40,  -30,  -10,   10,
      21,   18,   15,   16,   26,   40,   48,   40,   13,  -20,  -44,  -55,  -61,  -63,  -69,  -76,
     -76,  -63,  -35,    6,   41,   66,   75,   71,   71,   75,   77,   67,   44,   17,  -10,  -25,
     -34,  -35,  -29,  -27,  -28,  -35,  -40,  -35,  -18,    1,   16,   21,   20,   19,   25,   38,
      47,   43,   23,   -9,  -34,  -50,  -59,  -65,  -72,  -76,  -74,  -66,  -43,   -9,   27,   58,
      71,   69,   70,   71,   73,   67,   48,   25,    2,  -18,  -28,  -33,  -29,  -25,  -25,  -31,
     -39,  -41,  -28,  -10,    8,   19,   20,   23,   27,   36,   45,   45,   31,    4,  -22,  -45,
     -58,  -67,  -74,  -75,  -73,  -66,  -50,  -21,   16,   49,   67,   73,   72,   72,   74,   69,
      53,   33,    9,  -11,  -25,  -34,  -35,  -31,  -27,  -30,  -38,  -43,  -33,  -16,    6,   18,
      24,   27,   30,   38,   45,   46,   34,   10,  -16,  -40,  -61,  -70,  -77,  -76,  -72,  -66,
     -52,  -31,    2,   36,   60,   71,   72,   69,   71,   68,   57,   44,   20,    2,  -17,  -32,
     -36,  -33,  -31,  -31,  -40,  -46,  -41,  -29,   -5,   16,   27,   34,   35,   41,   49,   51,
      41,   17,  -11,  -34,  -56,  -71,  -79,  -80,  -76,  -68,  -57,  -36,  -10,   21,   48,   64,
      71,   71,   73,   69,   61,   48,   32,   11,   -5,  -21,  -31,  -34,  -34,  -37,  -43,  -48,
     -45,  -34,  -14,    8,   25,   34,   41,   43,   49,   51,   43,   26,   -2,  -27,  -49,  -65,
     -74,  -77,  -74,  -70,  -58,  -42,  -20,    9,   38,   56,   64,   67,   69,   71,   66,   53,
      37,   16,    1,  -15,  -30,  -33,  -39,  -38,  -41,  -45,  -42,  -35,  -15,    7,   25,   36,
      41,   45,   49,   49,   40,   23,    1,  -20,  -41,  -59,  -71,  -75,  -73,  -65,  -57,  -45,
     -28,   -6,   22,   42,   56,   63,   67,   71,   70,   59,   44,   28,   12,   -3,  -19,  -32,
     -40,  -41,  -46,  -47,  -46,  -37,  -20,   -2,   20,   34,   45,   48,   52,   53,   42,   26,
       4,  -15,  -35,  -51,  -65,  -70,  -70,  -68,  -61,  -50,  -34,  -15,    9,   28,   45,   54,
      64,   71,   72,   67,   53,   40,   24,    8,  -10,  -27,  -37,  -41,  -49,  -53,  -53,  -42,
     -25,   -8,   14,   31,   43,   52,   56,   56,   46,   30,   11,   -8,  -26,  -43,  -59,  -70,
     -69,  -68,  -62,  -55,  -44,  -25,   -4,   17,   36,   48,   62,   69,   69,   67,   57,   47,
      33,   17,   -2,  -21,  -33,  -41,  -47,  -52,  -53,  -43,  -25,  -10,    9,   23,   36,   46,
      52,   54,   47,   31,   14,   -4,  -19,  -32,  -49,  -57,  -62,  -60,  -57,  -58,  -51,  -39,
     -19,    6,   23,   38,   51,   60,   68,   71,   67,   58,   44,   27,    7,  -17,  -32,  -41,
     -47,  -52,  -54,  -46,  -31,  -12,    7,   22,   35,   45,   51,   53,   46,   33,   18,    2,
     -12,  -26,  -42,  -55,  -61,  -60,  -56,  -57,  -55,  -46,  -29,   -8,   10,   27,   42,   55,
      65,   70,   69,   61,   49,   34,   16,   -5,  -23,  -36,  -45,  -51,  -54,  -50,  -35,  -17,
       3,   17,   29,   37,   44,   51,   47,   39,   21,    6,   -8,  -20,  -31,  -44,  -52,  -58,
     -60,  -58,  -58,  -51,  -39,  -22,   -4,   14,   31,   48,   62,   70,   69,   65,   57,   45,
      28,    7,  -15,  -31,  -44,  -50,  -53,  -50,  -39,  -24,   -6,   11,   24,   33,   43,   46,
      45,   35,   25,   14,    1,  -13,  -23,  -35,  -44,  -53,  -57,  -59,  -59,  -57,  -47,  -33,
     -15,    3,   21,   39,   56,   69,   72,   69,   60,   49,   36,   17,   -5,  -25,  -42,  -52,
     -52,  -48,  -40,  -26,   -9,    9,   20,   29,   34,   39,   40,   34,   25,   16,    6,   -6,
     -16,  -27,  -34,  -44,  -50,  -55,  -58,  -57,  -52,  -41,  -27,  -11,   11,   31,   51,   67,
      70,   68,   61,   53,   43,   30,    7,  -14,  -35,  -49,  -54,  -50,  -40,  -26,  -13,   -2,
       9,   22,   30,   38,   41,   36,   28,   20,   12,    4,   -5,  -15,  -26,  -41,  -52,  -58,
     -60,  -60,  -59,  -55,  -41,  -25,   -5,   19,   42,   62,   74,   75,   70,   63,   55,   43,
      22,   -3,  -24,  -42,  -51,  -50,  -45,  -32,  -22,  -14,   -2,   14,   28,   35,   34,   33,
      30,   25,   21,   11,    4,   -6,  -18,  -32,  -46,  -56,  -61,  -61,  -62,  -60,  -51,  -39,
     -16,   11,   37,   58,   70,   75,   72,   67,   58,   46,   31,   10,  -17,  -35,  -48,  -49,
     -41,  -28,  -17,  -14,   -7,    4,   18,   28,   32,   29,   27,   21,   19,   16,    7,    2,
     -11,  -22,  -35,  -48,  -57,  -61,  -60,  -60,  -56,  -47,  -30,   -5,   23,   48,   63,   72,
      75,   71,   64,   53,   39,   20,   -2,  -22,  -40,  -48,  -45,  -34,  -21,  -17,  -10,   -4,
      10,   22,   27,   28,   29,   26,   26,   22,   14,    7,   -3,  -14,  -30,  -46,  -59,  -65,
     -65,  -65,  -64,  -56,  -41,  -17,   15,   42,   62,   73,   77,   75,   69,   57,   43,   25,
       6,  -12,  -31,  -44,  -46,  -37,  -24,  -16,  -11,   -3,    6,   20,   24,   23,   24,   23,
      25,   23,   16,    9,    1,  -10,  -23,  -41,  -56,  -63,  -67,  -67,  -66,  -59,  -47,  -25,
       3,   32,   54,   70,   75,   76,   70,   62,   47,   32,   15,   -3,  -21,  -38,  -44,  -41,
     -31,  -21,  -15,  -11,   -2,    8,   18,   24,   27,   28,   29,   29,   24,   17,    8,   -2,
     -17,  -35,  -54,  -66,  -73,  -74,  -71,  -66,  -55,  -35,   -6,   24,   50,   69,   77,   79,
      74,   63,   51,   38,   22,    2,  -17,  -35,  -42,  -39,  -32,  -24,  -17,  -11,   -5,    6,
      13,   20,   28,   31,   33,   29,   23,   15,   10,    3,  -12,  -30,  -51,  -65,  -73,  -75,
     -71,  -67,  -58,  -41,  -18,   11,   38,   60,   75,   77,   74,   64,   53,   42,   31,   15,
      -7,  -25,  -38,  -40,  -37,  -29,  -24,  -15,  -11,   -2,    9,   17,   28,   33,   36,   33,
      27,   18,   13,    4,   -8,  -26,  -48,  -65,  -75,  -76,  -72,  -68,  -58,  -43,  -18,   11,
      37,   58,   72,   76,   73,   63,   51,   40,   28,   13,   -6,  -23,  -35,  -41,  -40,  -33,
     -24,  -16,   -9,   -2,    7,   18,   29,   38,   42,   38,   31,   21,   11,    3,  -10,  -26,
     -47,  -65,  -75,  -79,  -75,  -69,  -58,  -39,  -19,    7,   33,   54,   71,   77,   75,   66,
      52,   39,   27,   15,   -2,  -22,  -35,  -41,  -41,  -36,  -27,  -17,   -8,    1,   11,   22,
      33,   41,   47,   45,   35,   21,   11,    4,   -7,  -24,  -46,  -66,  -77,  -81,  -79,  -73,
     -62,  -44,  -24,   -2,   23,   47,   69,   79,   79,   70,   57,   45,   33,   20,    5,  -18,
     -36,  -43,  -41,  -37,  -32,  -23,  -14,   -3,    8,   20,   34,   45,   53,   52,   41,   27,
      16,    7,   -5,  -24,  -47,  -69,  -83,  -86,  -84,  -74,  -62,  -44,  -22,    1,   24,   47,
      66,   78,   76,   69,   57,   43,   31,   17,    5,  -13,  -33,  -43,  -46,  -41,  -31,  -22,
     -12,    0,   11,   24,   39,   49,   57,   58,   48,   30,   15,    4,   -8,  -26,  -52,  -74,
     -86,  -89,  -83,  -74,  -60,  -43,  -21,    1,   22,   45,   65,   78,   79,   68,   54,   40,
      26,   17,    7,   -9,  -31,  -45,  -46,  -40,  -31,  -21,  -11,    0,    8,   21,   39,   51,
      60,   60,   52,   36,   19,    4,   -9,  -25,  -49,  -71,  -87,  -92,  -89,  -79,  -63,  -45,
     -24,    0,   22,   43,   65,   75,   80,   70,   57,   44,   30,   16,    2,  -14,  -31,  -46,
     -52,  -47,  -35,  -21,   -9,    1,   12,   26,   44,   59,   68,   68,   59,   42,   22,    6,
     -11,  -29,  -49,  -72,  -87,  -96,  -95,  -86,  -67,  -46,  -23,   -4,   16,   38,   59,   76,
      82,   74,   61,   45,   31,   20,    3,  -14,  -30,  -44,  -51,  -51,  -41,  -26,  -11,    3,
      13,   25,   44,   61,   71,   72,   59,   45,   28,    9,  -10,  -33,  -53,  -70,  -83,  -93,
     -96,  -91,  -74,  -53,  -27,   -6,   15,   35,   53,   71,   80,   77,   66,   51,   34,   20,
       3,  -15,  -30,  -45,  -53,  -55,  -48,  -32,  -17,    1,   16,   29,   47,   62,   73,   77,
      67,   50,   30,    9,  -10,  -32,  -55,  -73,  -86,  -93,  -94,  -90,  -76,  -54,  -27,   -4,
      17,   32,   48,   64,   74,   78,   68,   55,   38,   17,    1,  -15,  -28,  -39,  -47,  -52,
     -49,  -37,  -21,   -3,   16,   31,   46,   61,   70,   75,   70,   55,   36,   13,   -9,  -32,
     -56,  -72,  -84,  -89,  -93,  -91,  -81,  -61,  -30,   -5,   18,   32,   45,   58,   71,   76,
      70,   57,   40,   18,    1,  -17,  -28,  -35,  -45,  -52,  -50,  -39,  -25,   -7,   15,   33,
      48,   60,   67,   73,   70,   60,   42,   19,   -8,  -34,  -57,  -69,  -77,  -83,  -87,  -92,
     -85,  -66,  -39,  -10,   12,   27,   39,   52,   62,   73,   72,   61,   46,   25,    4,  -14,
     -27,  -34,  -41,  -46,  -48,  -43,  -30,  -11,   14,   38,   53,   63,   66,   69,   72,   65,
      48,   23,   -4,  -31,  -56,  -72,  -81,  -83,  -87,  -91,  -87,  -72,  -46,  -15,   11,   28,
      40,   50,   60,   71,   75,   69,   54,   32,    8,  -13,  -29,  -39,  -45,  -48,  -50,  -48,
     -40,  -21,    9,   37,   57,   66,   71,   74,   75,   71,   55,   32,    2,  -29,  -55,  -73,
     -81,  -84,  -87,  -89,  -88,  -75,  -49,  -19,   10,   29,   39,   48,   53,   62,   72,   68,
      58,   35,    9,  -11,  -27,  -34,  -39,  -42,  -44,  -46,  -41,  -26,    5,   35,   56,   65,
      69,   72,   73,   72,   59,   37,    9,  -22,  -50,  -71,  -83,  -83,  -83,  -86,  -88,  -81,
     -55,  -24,    5,   24,   37,   48,   54,   59,   64,   66,   59,   41,   17,   -9,  -27,  -36,
     -38,  -39,  -42,  -45,  -41,  -28,   -2,   28,   53,   65,   68,   71,   71,   70,   58,   40,
      16,  -14,  -46,  -67,  -79,  -81,  -80,  -83,  -87,  -83,  -64,  -36,   -4,   19,   35,   46,
      51,   58,   65,   69,   64,   49,   26,   -2,  -25,  -38,  -41,  -39,  -40,  -43,  -45,  -33,
      -8,   24,   52,   65,   72,   74,   72,   66,   55,   40,   20,   -7,  -38,  -65,  -80,  -85,
     -80,  -82,  -84,  -82,  -65,  -38,   -9,   13,   29,   41,   49,   57,   62,   64,   59,   48,
      29,    6,  -19,  -36,  -39,  -37,  -35,  -38,  -39,  -31,  -11,   19,   47,   63,   70,   71,
      71,   65,   55,   38,   17,   -4,  -33,  -58,  -76,  -83,  -79,  -79,  -80,  -82,  -70,  -46,
     -19,    8,   25,   36,   43,   51,   59,   63,   62,   50,   34,   14,   -9,  -27,  -35,  -38,
     -36,  -38,  -39,  -30,  -15,   10,   34,   52,   67,   73,   74,   68,   54,   37,   21,    2,
     -21,  -45,  -68,  -78,  -81,  -81,  -80,  -79,  -70,  -51,  -28,   -4,   17,   32,   40,   48,
      56,   59,   57,   46,   34,   18,    3,  -20,  -34,  -39,  -35,  -31,  -30,  -26,  -13,    8,
      31,   48,   61,   67,   69,   66,   53,   38,   16,   -4,  -23,  -41,  -58,  -72,  -78,  -80,
     -76,  -74,  -64,  -50,  -33,   -8,   12,   28,   35,   41,   50,   57,   53,   44,   31,   20,
      10,   -8,  -24,  -34,  -34,  -30,  -25,  -21,  -13,    5,   22,   38,   52,   61,   66,   65,
      53,   36,   15,   -4,  -18,  -33,  -45,  -61,  -73,  -79,  -78,  -72,  -62,  -49,  -33,  -13,
       3,   19,   29,   38,   48,   52,   49,   41,   29,   22,   14,    2,  -11,  -25,  -27,  -25,
     -20,  -15,   -8,    4,   19,   30,   42,   53,   57,   61,   50,   32,   15,   -7,  -18,  -27,
     -37,  -50,  -65,  -73,  -72,  -66,  -57,  -49,  -37,  -19,   -3,   13,   23,   32,   41,   44,
      41,   35,   29,   26,   21,   10,   -2,  -13,  -21,  -18,  -14,   -8,   -4,    3,   12,   21,
      29,   42,   51,   54,   49,   32,   14,   -5,  -15,  -22,  -28,  -39,  -55,  -69,  -68,  -62,
     -52,  -44,  -37,  -25,  -11,    4,   16,   24,   32,   37,   35,   28,   23,   23,   23,   18,
       8,   -4,  -12,  -12,   -8,   -2,    5,    9,   14,   18,   23,   31,   41,   45,   43,   29,
      11,   -8,  -18,  -23,  -21,  -29,  -43,  -60,  -65,  -58,  -50,  -39,  -32,  -26,  -17,   -6,
       8,   18,   25,   31,   29,   24,   17,   20,   24,   25,   19,    8,    0,   -5,   -3,    4,
      11,   13,   12,   14,   16,   22,   31,   38,   37,   27,    9,  -11,  -22,  -24,  -22,  -25,
     -36,  -50,  -57,  -53,  -46,  -37,  -30,  -24,  -17,   -9,    1,   10,   16,   20,   19,   17,
      13,   14,   21,   24,   24,   19,   10,    8,    9,   13,   18,   20,   15,   12,   11,   14,
      21,   27,   30,   21,    8,  -12,  -23,  -24,  -22,  -20,  -29,  -40,  -49,  -47,  -41,  -33,
     -26,  -23,  -20,  -16,  -11,   -2,    7,   12,   14,   14,   13,   14,   19,   26,   30,   26,
      20,   11,   11,   16,   21,   26,   22,   18,   15,   14,   15,   19,   20,   16,    4,  -15,
     -29,  -32,  -27,  -21,  -24,  -34,  -40,  -41,  -33,  -28,  -24,  -21,  -20,  -15,  -14,  -10,
      -5,    1,    7,   10,   10,   12,   18,   26,   36,   34,   27,   21,   17,   20,   23,   25,
      24,   19,   11,   10,    9,   12,   16,   14,    3,  -16,  -32,  -34,  -27,  -19,  -20,  -27,
     -34,  -35,  -31,  -27,  -22,  -18,  -18,  -19,  -19,  -20,  -15,   -7,    2,    6,    8,    9,
      18,   26,   38,   41,   37,   28,   21,   23,   25,   27,   25,   20,   13,    7,    3,    5,
       9,   11,    4,  -14,  -31,  -35,  -29,  -20,  -18,  -23,  -26,  -32,  -29,  -25,  -23,  -15,
     -17,  -18,  -21,  -25,  -23,  -15,   -6,    0,    5,    6,   16,   25,   37,   45,   43,   36,
      27,   25,   28,   30,   29,   26,   16,    7,   -2,   -2,    2,    3,   -2,  -15,  -31,  -38,
     -35,  -23,  -15,  -15,  -19,  -23,  -26,  -23,  -21,  -15,  -12,  -18,  -24,  -27,  -25,  -19,
      -9,   -3,    2,    5,   12,   19,   32,   42,   45,   41,   31,   28,   31,   33,   37,   33,
      26,   14,    4,   -2,   -3,   -3,   -5,  -18,  -34,  -43,  -42,  -31,  -20,  -18,  -17,  -19,
     -18,  -16,  -13,   -9,   -8,  -13,  -22,  -32,  -32,  -28,  -19,  -11,   -6,   -2,    7,   18,
      31,   42,   46,   46,   41,   36,   32,   35,   39,   39,   30,   17,    5,   -3,   -3,   -3,
      -7,  -19,  -32,  -39,  -41,  -36,  -26,  -17,  -12,  -13,  -18,  -20,  -14,   -7,   -6,  -11,
     -23,  -32,  -34,  -28,  -23,  -15,   -9,   -2,    9,   17,   28,   37,   44,   48,   45,   38,
      32,   35,   41,   45,   37,   23,   10,    1,   -3,   -5,   -8,  -20,  -35,  -44,  -44,  -42,
     -34,  -24,  -14,  -10,  -12,  -14,  -11,   -6,   -2,   -5,  -15,  -25,  -32,  -29,  -24,  -19,
     -15,  -10,    1,   10,   20,   31,   40,   45,   48,   43,   39,   39,   45,   51,   43,   28,
      15,    2,   -4,   -8,  -13,  -20,  -34,  -42,  -45,  -45,  -36,  -26,  -13,   -8,  -11,  -13,
      -8,   -2,    1,   -4,  -13,  -22,  -30,  -33,  -28,  -25,  -18,  -12,   -5,    3,   13,   25,
      37,   46,   47,   45,   40,   41,   47,   53,   49,   35,   21,   10,    2,   -6,  -11,  -22,
     -32,  -43,  -50,  -50,  -47,  -34,  -17,   -9,   -9,  -12,   -9,    3,    7,    4,   -8,  -18,
     -25,  -31,  -31,  -27,  -21,  -16,  -11,   -8,    2,   17,   31,   45,   47,   44,   40,   43,
      54,   60,   58,   42,   26,   14,    4,   -5,  -14,  -26,  -37,  -47,  -54,  -53,  -49,  -38,
     -22,  -13,   -9,   -7,   -3,    6,   11,    6,   -5,  -14,  -22,  -28,  -31,  -30,  -29,  -24,
     -18,  -15,   -2,   14,   29,   42,   45,   47,   45,   48,   56,   63,   59,   46,   29,   17,
       5,   -4,  -11,  -23,  -36,  -49,  -53,  -52,  -48,  -40,  -29,  -21,  -16,  -11,   -2,    5,
       6,    3,   -5,  -10,  -13,  -17,  -21,  -25,  -26,  -23,  -19,  -15,   -8,    5,   20,   31,
      38,   42,   41,   46,   55,   62,   63,   50,   36,   24,   12,    5,   -7,  -20,  -33,  -46,
     -51,  -51,  -48,  -40,  -33,  -27,  -20,  -15,    0,    9,    7,    1,   -6,  -10,  -11,  -16,
     -22,  -25,  -30,  -28,  -25,  -21,  -11,    2,   17,   28,   32,   41,   47,   55,   64,   66,
      64,   54,   41,   32,   19,    4,   -9,  -24,  -37,  -48,  -54,  -55,  -51,  -41,  -33,  -29,
     -24,  -15,    0,   13,   14,    8,    1,   -5,   -6,  -10,  -17,  -24,  -30,  -32,  -33,  -32,
     -22,   -9,    9,   21,   25,   35,   45,   56,   67,   71,   71,   63,   49,   37,   25,   11,
      -5,  -19,  -32,  -45,  -54,  -59,  -54,  -43,  -36,  -31,  -27,  -18,   -3,   11,   13,    9,
       2,   -3,   -6,   -9,  -13,  -20,  -25,  -29,  -33,  -30,  -23,   -9,    2,   11,   19,   28,
      40,   51,   63,   68,   71,   66,   55,   44,   31,   16,    1,  -15,  -30,  -41,  -50,  -57,
     -56,  -46,  -37,  -32,  -30,  -21,   -7,    8,   17,   12,    5,    3,   -2,   -6,  -11,  -19,
     -23,  -27,  -33,  -34,  -28,  -19,   -6,    3,   13,   24,   38,   51,   62,   70,   72,   68,
      60,   48,   38,   22,    6,  -13,  -27,  -39,  -46,  -53,  -52,  -48,  -42,  -37,  -36,  -25,
      -9,    4,   11,    9,    7,    8,    6,    2,   -6,  -13,  -20,  -24,  -28,  -31,  -30,  -27,
     -19,  -10,    4,   19,   33,   45,   57,   67,   74,   74,   70,   60,   47,   31,   10,   -8,
     -25,  -36,  -42,  -51,  -56,  -56,  -51,  -40,  -35,  -28,  -16,   -4,    7,    7,   10,   12,
      13,   11,    3,   -8,  -18,  -21,  -25,  -29,  -33,  -33,  -30,  -20,   -8,   11,   27,   42,
      54,   64,   72,   77,   76,   69,   56,   34,   14,   -5,  -20,  -32,  -43,  -50,  -57,  -59,
     -57,  -47,  -39,  -31,  -17,   -5,    6,    8,    9,   17,   19,   16,    5,   -9,  -13,  -18,
     -21,  -26,  -33,  -37,  -35,  -28,  -15,    1,   18,   34,   47,   58,   68,   76,   77,   76,
      65,   47,   25,    6,  -12,  -24,  -37,  -49,  -57,  -62,  -64,  -58,  -50,  -40,  -24,  -12,
       3,    9,   13,   22,   26,   26,   17,    4,   -9,  -21,  -25,  -30,  -36,  -41,  -44,  -41,
     -27,   -8,   12,   31,   44,   57,   68,   77,   81,   80,   72,   56,   34,   12,   -6,  -19,
     -30,  -41,  -53,  -65,  -68,  -65,  -56,  -44,  -30,  -17,   -8,    2,   10,   23,   31,   32,
      25,   10,   -4,  -14,  -20,  -25,  -31,  -39,  -45,  -45,  -35,  -17,    2,   22,   37,   51,
      63,   72,   79,   78,   74,   62,   43,   20,    2,  -12,  -24,  -34,  -49,  -61,  -69,  -70,
     -63,  -48,  -35,  -23,  -11,    0,    9,   20,   31,   36,   32,   20,    7,   -9,  -18,  -24,
     -30,  -38,  -47,  -50,  -44,  -29,   -9,   10,   27,   45,   60,   71,   78,   80,   78,   68,
      54,   33,   13,   -5,  -18,  -29,  -44,  -57,  -68,  -74,  -66,  -54,  -41,  -30,  -18,   -5,
       8,   19,   26,   33,   32,   24,   13,   -4,  -15,  -22,  -24,  -29,  -40,  -44,  -42,  -29,
     -14,    0,   15,   31,   48,   63,   69,   74,   74,   72,   64,   47,   27,   11,   -4,  -17,
     -33,  -50,  -66,  -78,  -78,  -68,  -54,  -38,  -25,  -11,    4,   18,   31,   38,   40,   34,
      21,    5,  -12,  -23,  -28,  -34,  -43,  -50,  -51,  -39,  -22,   -6,   10,   26,   46,   61,
      70,   75,   79,   76,   67,   52,   34,   18,    4,  -11,  -27,  -45,  -63,  -76,  -78,  -70,
     -57,  -44,  -29,  -15,    0,   14,   26,   35,   39,   34,   23,    9,   -7,  -18,  -23,  -30,
     -40,  -49,  -51,  -41,  -24,   -9,    5,   19,   39,   55,   67,   74,   77,   79,   72,   56,
      39,   24,   12,   -5,  -23,  -42,  -60,  -73,  -78,  -74,  -62,  -48,  -33,  -18,   -6,   10,
      25,   34,   37,   34,   26,   16,   -2,  -15,  -23,  -28,  -32,  -42,  -46,  -44,  -31,  -16,
      -4,   11,   28,   44,   56,   64,   69,   75,   73,   63,   50,   37,   22,    6,  -10,  -27,
     -47,  -68,  -81,  -80,  -68,  -52,  -39,  -25,  -13,    2,   17,   29,   36,   37,   32,   23,
       4,  -14,  -24,  -26,  -26,  -36,  -44,  -45,  -36,  -20,   -7,    9,   25,   38,   49,   58,
      66,   75,   77,   67,   52,   39,   26,   14,   -3,  -21,  -43,  -65,  -81,  -84,  -74,  -56,
     -40,  -27,  -15,   -2,   15,   27,   37,   38,   35,   26,    8,  -11,  -23,  -26,  -27,  -34,
     -42,  -45,  -40,  -27,  -13,    4,   19,   33,   45,   54,   60,   67,   72,   67,   57,   44,
      32,   20,    5,  -11,  -32,  -55,  -72,  -82,  -76,  -62,  -46,  -31,  -21,   -5,    6,   19,
      29,   34,   33,   26,   12,   -6,  -17,  -22,  -23,  -28,  -38,  -42,  -38,  -27,  -14,    1,
      14,   27,   40,   48,   53,   62,   68,   67,   58,   44,   32,   21,    9,   -5,  -22,  -43,
     -63,  -76,  -75,  -62,  -46,  -30,  -24,  -13,    0,   10,   20,   28,   31,   27,   12,   -5,
     -16,  -20,  -19,  -21,  -29,  -35,  -35,  -27,  -16,   -6,    9,   21,   33,   41,   47,   53,
      61,   63,   60,   51,   39,   27,   15,    3,  -13,  -33,  -55,  -72,  -75,  -67,  -52,  -37,
     -26,  -18,   -7,    4,   15,   26,   27,   25,   14,    0,  -10,  -15,  -16,  -19,  -24,  -31,
     -32,  -27,  -17,   -5,    5,   15,   26,   35,   43,   49,   54,   57,   57,   52,   42,   29,
      18,   10,   -3,  -23,  -46,  -64,  -71,  -66,  -53,  -39,  -27,  -19,  -11,    0,    5,   16,
      22,   23,   15,    1,  -10,  -15,  -18,  -17,  -17,  -20,  -24,  -22,  -14,   -4,    7,   16,
      25,   31,   36,   41,   47,   49,   49,   46,   41,   32,   21,   13,    3,  -14,  -33,  -51,
     -60,  -60,  -52,  -39,  -28,  -20,  -14,   -7,    1,    9,   14,   16,   10,    1,  -10,  -15,
     -14,  -15,  -15,  -15,  -17,  -14,  -11,   -4,    5,   13,   22,   29,   33,   35,   39,   43,
      45,   45,   42,   35,   26,   17,    7,  -10,  -25,  -38,  -48,  -53,  -53,  -46,  -33,  -23,
     -16,  -13,   -8,   -3,    4,    9,    7,    1,   -6,  -10,  -13,  -12,  -12,   -8,   -7,   -6,
      -2,    3,    6,   10,   14,   23,   28,   29,   30,   29,   34,   39,   40,   36,   30,   21,
      13,    1,  -15,  -27,  -36,  -44,  -48,  -45,  -36,  -26,  -17,  -13,  -10,   -6,   -2,    2,
       3,   -3,   -6,  -10,  -14,  -13,  -12,   -7,   -3,    1,    2,    5,    6,   10,   15,   19,
      25,   25,   26,   26,   29,   34,   35,   32,   29,   20,   13,    4,  -12,  -20,  -27,  -33,
     -38,  -41,  -36,  -27,  -19,  -13,  -10,   -8,   -8,   -7,   -5,   -5,   -7,   -9,  -13,  -18,
     -15,  -12,   -5,    3,    7,   10,   10,   11,   13,   20,   27,   27,   23,   20,   20,   24,
      27,   25,   26,   23,   17,    7,   -6,  -13,  -16,  -20,  -26,  -32,  -33,  -28,  -20,  -13,
     -12,  -12,  -16,  -15,  -15,  -12,  -10,  -13,  -13,  -16,  -12,   -7,    0,    9,   14,   18,
      18,   14,   11,   14,   18,   21,   17,   10,   11,   15,   20,   21,   20,   20,   17,    9,
       2,   -5,  -10,  -14,  -21,  -25,  -29,  -27,  -23,  -17,  -13,  -13,  -16,  -18,  -20,  -20,
     -12,   -8,   -9,  -15,  -16,  -10,   -2,    9,   14,   18,   18,   18,   14,   14,   17,   20,
      18,   12,    8,   11,   13,   16,   18,   19,   16,    9,    3,    1,    1,   -6,  -13,  -20,
     -23,  -21,  -19,  -15,  -15,  -14,  -17,  -21,  -22,  -22,  -17,  -11,  -11,  -13,  -18,  -14,
      -4,   12,   21,   22,   23,   21,   20,   17,   16,   16,   12,    7,    1,    5,    7,    8,
      12,   15,   15,   10,    3,    0,    3,    1,   -5,  -12,  -19,  -19,  -16,  -11,   -9,  -11,
     -14,  -23,  -28,  -29,  -24,  -17,  -13,  -15,  -19,  -18,  -10,    7,   22,   29,   30,   24,
      22,   18,   17,   17,   11,    4,   -2,   -3,    2,    4,    8,   13,   16,   13,    7,    4,
       9,    8,    2,   -7,  -16,  -15,  -14,  -12,  -10,  -12,  -12,  -19,  -25,  -29,  -25,  -18,
     -15,  -18,  -21,  -19,  -12,    1,   16,   28,   34,   32,   29,   23,   18,   15,   11,    4,
      -3,  -10,   -8,   -5,    0,    7,   12,   14,   10,    6,   10,   15,   13,    3,   -7,  -11,
     -13,  -13,  -13,  -12,  -14,  -20,  -28,  -31,  -29,  -20,  -13,  -14,  -18,  -18,  -15,   -3,
      12,   24,   33,   32,   29,   25,   22,   16,   11,    3,   -3,   -6,   -7,   -8,   -3,    2,
       8,   11,   11,    9,   10,   13,   13,    8,    0,   -6,   -9,   -9,   -9,  -10,  -11,  -18,
     -26,  -30,  -29,  -22,  -17,  -18,  -20,  -21,  -17,   -7,    6,   21,   34,   38,   34,   29,
      21,   17,   13,    8,    1,   -8,  -13,  -15,  -10,   -3,    5,   10,   11,   10,   11,   15,
      16,   11,    3,   -4,   -7,   -9,   -8,  -10,  -13,  -19,  -26,  -26,  -23,  -17,  -15,  -16,
     -17,  -17,  -15,   -9,   -2,   10,   26,   31,   31,   24,   21,   18,   13,    6,    1,   -6,
      -8,   -9,   -8,   -4,    0,    6,   10,   12,   15,   14,   13,    9,    5,   -2,   -7,   -8,
      -9,   -8,  -10,  -18,  -25,  -25,  -23,  -18,  -16,  -19,  -22,  -18,  -16,  -10,    0,   10,
      24,   33,   35,   29,   22,   17,   13,    7,   -3,   -8,  -12,  -14,  -12,   -7,   -3,    4,
      10,   14,   16,   17,   16,   16,   11,    3,   -7,  -11,  -10,   -7,  -10,  -19,  -26,  -27,
     -23,  -17,  -14,  -14,  -17,  -18,  -16,  -12,   -3,    7,   20,   26,   28,   24,   20,   16,
      15,   10,    2,   -8,  -13,  -11,   -7,   -2,   -2,    4,    6,    9,   14,   17,   19,   15,
       8,   -4,  -12,  -15,  -11,   -5,   -8,  -18,  -25,  -24,  -17,   -9,   -6,   -7,  -11,  -15,
     -15,  -13,   -6,    4,   11,   15,   16,   15,   16,   13,    9,    5,    1,   -3,   -7,   -5,
      -2,    3,    5,    6,    8,   10,   14,   17,   18,   14,    3,   -8,  -15,  -13,   -9,   -6,
      -9,  -19,  -22,  -19,  -13,   -6,   -4,   -5,   -8,  -13,  -15,  -10,   -5,    5,    8,    8,
       8,   11,   14,   14,    8,    2,    1,    1,    2,   -2,    1,    5,    6,    7,    7,    6,
      11,   13,   16,   13,    3,   -6,  -13,  -14,   -8,   -5,   -6,  -15,  -20,  -15,  -10,   -5,
      -2,   -6,   -6,   -8,  -12,  -10,   -8,   -3,    5,    3,    3,    5,    7,   10,    6,    2,
      -3,   -2,    2,    8,    9,   12,   11,    8,    9,    8,   11,   13,   11,   10,    0,  -12,
     -20,  -21,  -13,  -10,  -11,  -14,  -16,  -10,   -3,    4,    8,    5,    2,   -2,   -4,   -4,
      -7,   -4,   -4,   -5,   -7,   -8,   -5,    0,    2,    2,    0,    1,    6,   11,   15,   19,
      19,   18,   14,   10,   12,   12,   11,    6,   -6,  -16,  -23,  -23,  -17,  -13,  -12,  -12,
     -13,   -8,   -2,    8,   13,   13,    8,    4,    1,   -3,   -3,   -3,   -4,  -11,  -16,  -16,
     -13,   -9,   -5,   -4,   -2,    1,    6,   13,   17,   21,   24,   23,   18,   14,   10,   11,
      12,    8,   -3,  -16,  -26,  -27,  -20,  -17,  -21,  -21,  -17,   -7,    2,   10,   16,   19,
      18,   13,   10,    5,    2,   -2,   -5,  -14,  -22,  -26,  -21,  -15,  -11,  -11,   -6,   -2,
       6,   16,   22,   27,   28,   28,   23,   17,   13,   10,   12,    7,   -4,  -18,  -29,  -32,
     -24,  -20,  -21,  -22,  -18,   -5,    5,   14,   19,   21,   20,   17,   13,    8,    5,   -2,
      -9,  -18,  -26,  -26,  -21,  -14,  -12,  -11,   -8,   -2,   10,   16,   21,   24,   25,   27,
      24,   16,   11,    6,    7,    6,   -4,  -16,  -25,  -29,  -25,  -19,  -19,  -22,  -18,   -7,
       6,   15,   17,   18,   19,   18,   15,   10,    8,    3,   -5,  -15,  -24,  -30,  -27,  -19,
     -15,  -15,  -13,   -8,    5,   14,   20,   25,   28,   31,   30,   26,   18,   11,    9,    7,
      -2,  -14,  -27,  -33,  -30,  -25,  -25,  -27,  -26,  -15,    2,   17,   22,   23,   23,   22,
      22,   18,   14,    7,   -4,  -14,  -24,  -31,  -30,  -25,  -19,  -16,  -16,  -11,   -3,    8,
      17,   24,   29,   31,   31,   29,   22,   17,   12,    8,    2,  -12,  -26,  -36,  -35,  -30,
     -26,  -26,  -29,  -20,   -5,   13,   24,   26,   26,   26,   28,   23,   19,   11,    1,   -9,
     -24,  -34,  -33,  -30,  -24,  -21,  -21,  -17,  -11,    1,    9,   19,   27,   33,   34,   30,
      28,   24,   21,   16,    7,   -6,  -23,  -35,  -40,  -36,  -33,  -31,  -32,  -27,  -13,    3,
      17,   25,   29,   34,   34,   30,   23,   17,   11,    0,  -14,  -27,  -32,  -33,  -30,  -26,
     -21,  -18,  -15,   -9,    1,   11,   22,   29,   32,   33,   30,   28,   23,   21,   13,    3,
     -15,  -30,  -37,  -38,  -35,  -35,  -33,  -28,  -18,   -5,   10,   22,   30,   37,   36,   32,
      26,   21,   14,    7,   -6,  -19,  -28,  -34,  -32,  -27,  -21,  -20,  -21,  -20,  -11,    5,
      17,   25,   29,   30,   33,   35,   31,   27,   19,    8,   -7,  -25,  -37,  -42,  -41,  -39,
     -35,  -30,  -22,  -11,    4,   21,   32,   38,   39,   36,   29,   22,   15,    9,   -4,  -15,
     -24,  -32,  -35,  -31,  -24,  -18,  -18,  -19,  -14,   -3,   11,   21,   27,   31,   32,   34,
      34,   31,   27,   18,    1,  -19,  -33,  -39,  -38,  -40,  -39,  -35,  -28,  -17,   -3,   14,
      28,   37,   41,   40,   34,   30,   24,   18,    7,   -6,  -20,  -30,  -36,  -34,  -30,  -26,
     -26,  -27,  -26,  -16,    0,   16,   26,   30,   33,   36,   42,   43,   38,   27,   10,  -10,
     -27,  -39,  -43,  -43,  -43,  -40,  -34,  -26,  -14,    2,   21,   36,   42,   40,   36,   33,
      30,   24,   16,    5,  -11,  -25,  -34,  -35,  -32,  -29,  -30,  -31,  -31,  -27,  -15,    5,
      21,   27,   30,   34,   42,   51,   48,   40,   20,   -3,  -21,  -32,  -38,  -40,  -43,  -42,
     -38,  -30,  -18,   -3,   15,   29,   40,   41,   39,   34,   31,   28,   20,   10,   -4,  -18,
     -29,  -33,  -34,  -34,  -35,  -37,  -38,  -34,  -21,   -6,   12,   22,   26,   33,   44,   55,
      56,   46,   26,    5,  -11,  -25,  -36,  -42,  -47,  -47,  -43,  -37,  -24,  -11,    9,   25,
      36,   38,   38,   40,   39,   39,   28,   17,    3,  -10,  -23,  -30,  -37,  -38,  -42,  -44,
     -43,  -40,  -30,  -16,    3,   17,   26,   34,   44,   57,   61,   52,   34,    9,   -7,  -21,
     -30,  -38,  -46,  -49,  -48,  -39,  -27,  -13,    5,   22,   32,   35,   35,   37,   41,   43,
      33,   19,    4,   -8,  -16,  -25,  -32,  -39,  -42,  -44,  -42,  -41,  -33,  -20,   -4,   11,
      21,   28,   38,   49,   58,   54,   36,   16,   -6,  -16,  -21,  -28,  -36,  -46,  -49,  -42,
     -29,  -17,    0,   13,   26,   30,   30,   35,   41,   47,   41,   25,    9,   -4,  -12,  -17,
     -28,  -38,  -46,  -52,  -51,  -49,  -39,  -23,   -9,    4,   12,   23,   39,   54,   66,   62,
      43,   23,    2,  -10,  -16,  -26,  -36,  -45,  -51,  -50,  -37,  -20,    0,   16,   27,   28,
      29,   38,   47,   50,   44,   28,   13,   -2,  -10,  -16,  -26,  -35,  -45,  -55,  -57,  -56,
     -44,  -27,  -13,   -4,    5,   17,   34,   53,   64,   64,   46,   29,   13,    1,   -8,  -17,
     -28,  -39,  -48,  -51,  -42,  -26,   -8,    9,   18,   20,   24,   34,   46,   53,   47,   33,
      15,    4,   -4,  -13,  -22,  -35,  -47,  -56,  -59,  -56,  -48,  -32,  -18,   -8,    3,   14,
      33,   52,   65,   64,   49,   31,   17,    5,   -3,  -13,  -25,  -36,  -45,  -49,  -44,  -31,
     -14,    7,   16,   21,   21,   31,   48,   57,   53,   38,   20,    8,   -3,   -9,  -21,  -35,
     -47,  -57,  -62,  -62,  -54,  -38,  -22,  -12,   -5,    7,   26,   49,   66,   69,   56,   37,
      24,   15,    6,   -4,  -17,  -30,  -43,  -53,  -47,  -34,  -18,   -2,    9,   14,   17,   29,
      46,   58,   56,   43,   25,   13,    2,   -5,  -15,  -30,  -45,  -59,  -66,  -65,  -57,  -43,
     -28,  -16,  -10,    2,   21,   44,   66,   71,   62,   43,   28,   19,   13,    3,  -12,  -25,
     -42,  -51,  -50,  -38,  -18,   -3,    5,   12,   17,   30,   48,   59,   58,   45,   26,   11,
       0,   -6,  -15,  -29,  -45,  -63,  -71,  -68,  -58,  -41,  -28,  -19,  -12,   -4,   16,   42,
      62,   70,   61,   43,   29,   21,   16,    8,   -6,  -20,  -35,  -45,  -45,  -37,  -21,   -6,
       3,    8,   14,   24,   42,   54,   58,   47,   29,   16,    3,   -3,  -12,  -27,  -42,  -62,
     -73,  -74,  -66,  -52,  -34,  -23,  -14,   -5,   12,   38,   60,   72,   68,   49,   34,   23,
      17,   10,   -3,  -18,  -31,  -42,  -42,  -36,  -20,   -4,    5,    9,   11,   22,   37,   51,
      55,   46,   29,   13,    2,   -9,  -14,  -25,  -38,  -53,  -67,  -72,  -67,  -53,  -35,  -23,
     -17,  -10,    6,   32,   55,   69,   67,   53,   36,   26,   19,   12,    2,  -13,  -26,  -37,
     -40,  -36,  -24,   -7,    3,    9,   13,   20,   36,   49,   52,   47,   32,   17,    3,  -12,
     -19,  -29,  -38,  -52,  -66,  -75,  -72,  -56,  -36,  -20,  -15,  -10,    2,   25,   48,   63,
      63,   52,   39,   28,   20,   14,    5,   -6,  -19,  -30,  -38,  -35,  -25,   -8,    4,    8,
      11,   17,   33,   47,   54,   47,   34,   18,    4,   -9,  -19,  -28,  -40,  -53,  -65,  -75,
     -74,  -60,  -41,  -22,  -15,  -12,   -2,   18,   43,   59,   63,   55,   41,   31,   27,   20,
      13,    3,  -11,  -24,  -35,  -34,  -26,  -11,    2,    8,    9,   11,   22,   37,   47,   49,
      39,   22,    6,   -7,  -19,  -26,  -36,  -48,  -60,  -74,  -77,  -66,  -47,  -26,  -13,   -8,
       1,   15,   36,   53,   63,   56,   45,   30,   22,   16,   10,    5,   -7,  -19,  -32,  -34,
     -25,   -7,    8,   16,   17,   17,   23,   37,   48,   51,   40,   22,    4,  -14,  -24,  -33,
     -39,  -49,  -61,  -72,  -77,  -66,  -47,  -27,  -13,   -5,    1,   13,   30,   47,   59,   57,
      47,   31,   23,   17,   15,    6,   -5,  -18,  -26,  -30,  -24,  -10,    8,   19,   21,   20,
      22,   30,   40,   48,   41,   25,    3,  -17,  -29,  -32,  -37,  -46,  -59,  -70,  -73,  -65,
     -46,  -27,  -14,   -4,    3,   15,   29,   41,   52,   54,   45,   31,   19,   15,   15,    9,
       1,  -14,  -26,  -27,  -21,   -8,   10,   17,   23,   23,   23,   32,   39,   45,   44,   29,
       7,  -16,  -32,  -40,  -42,  -49,  -61,  -72,  -76,  -69,  -50,  -28,  -12,   -2,    5,   17,
      31,   43,   48,   49,   44,   34,   24,   15,   13,    9,    5,   -8,  -24,  -27,  -21,   -7,
      10,   20,   25,   29,   29,   32,   36,   41,   41,   34,   14,  -12,  -35,  -46,  -49,  -52,
     -61,  -74,  -78,  -73,  -56,  -31,  -14,    2,   10,   19,   31,   44,   54,   53,   47,   34,
      24,   16,    9,    4,   -2,  -12,  -25,  -28,  -22,   -7,    9,   23,   32,   36,   36,   36,
      37,   42,   42,   33,   15,  -14,  -36,  -50,  -57,  -56,  -62,  -74,  -81,  -77,  -59,  -36,
     -15,    2,   11,   20,   31,   44,   56,   56,   51,   39,   26,   15,    7,    1,   -3,  -13,
     -26,  -33,  -31,  -14,    9,   25,   36,   41,   40,   41,   40,   44,   44,   35,   17,  -13,
     -39,  -54,  -61,  -64,  -69,  -76,  -81,  -78,  -63,  -39,  -15,    4,   14,   24,   35,   45,
      54,   56,   53,   41,   25,   14,    7,    3,   -4,  -14,  -26,  -34,  -31,  -15,    9,   25,
      36,   41,   43,   44,   43,   46,   45,   35,   16,   -9,  -31,  -49,  -63,  -69,  -75,  -78,
     -84,  -79,  -66,  -45,  -22,    0,   13,   23,   35,   48,   56,   58,   53,   43,   30,   19,
      10,    4,   -7,  -18,  -26,  -33,  -30,  -17,    4,   24,   37,   44,   50,   50,   49,   46,
      43,   35,   16,   -7,  -30,  -52,  -65,  -75,  -78,  -83,  -85,  -82,  -70,  -50,  -26,   -4,
      14,   26,   39,   53,   63,   64,   59,   49,   35,   18,    6,   -2,  -13,  -25,  -35,  -40,
     -36,  -22,    3,   26,   38,   47,   54,   60,   61,   57,   50,   39,   20,   -5,  -26,  -49,
     -66,  -80,  -87,  -91,  -93,  -88,  -74,  -54,  -34,  -12,    8,   24,   40,   55,   68,   70,
      66,   55,   41,   26,   14,    6,   -9,  -25,  -37,  -43,  -39,  -28,   -9,   15,   32,   41,
      48,   59,   65,   65,   58,   45,   25,    5,  -17,  -38,  -61,  -77,  -91,  -97, -100,  -94,
     -79,  -64,  -44,  -23,   -2,   24,   42,   57,   72,   77,   74,   63,   48,   33,   21,   10,
      -7,  -27,  -43,  -45,  -41,  -29,  -14,    4,   26,   40,   49,   58,   66,   69,   64,   48,
      29,    7,  -13,  -31,  -53,  -73,  -89, -100, -102,  -95,  -83,  -67,  -51,  -29,   -7,   17,
      37,   55,   72,   81,   77,   67,   55,   40,   25,   12,   -4,  -22,  -40,  -45,  -42,  -31,
     -19,   -4,   15,   34,   48,   55,   63,   67,   66,   57,   41,   20,   -4,  -25,  -46,  -69,
     -88, -104, -110, -106,  -95,  -79,  -63,  -39,  -13,   15,   39,   60,   75,   88,   91,   81,
      66,   44,   27,   13,   -3,  -22,  -41,  -50,  -48,  -38,  -26,  -13,    6,   29,   46,   55,
      62,   66,   69,   63,   48,   26,    5,  -14,  -33,  -57,  -84, -105, -115, -113, -102,  -88,
     -73,  -53,  -26,    1,   31,   57,   78,   91,   95,   88,   75,   60,   41,   22,    1,  -19,
     -38,  -51,  -53,  -48,  -36,  -22,   -6,   19,   39,   53,   62,   65,   69,   67,   55,   36,
      14,   -6,  -28,  -54,  -79, -100, -111, -116, -110,  -98,  -83,  -61,  -35,   -6,   26,   53,
      75,   89,   96,   96,   87,   71,   50,   29,   10,   -9,  -30,  -44,  -53,  -50,  -45,  -32,
     -19,    2,   23,   43,   55,   62,   66,   66,   62,   49,   30,   11,  -12,  -39,  -70,  -95,
    -112, -118, -118, -109,  -94,  -74,  -48,  -18,   17,   47,   70,   88,   98,   99,   95,   80,
      61,   37,   14,   -9,  -26,  -43,  -51,  -52,  -48,  -40,  -25,   -6,   17,   37,   52,   57,
      63,   64,   62,   55,   36,   17,   -8,  -34,  -62,  -86, -106, -117, -118, -110,  -99,  -83,
     -57,  -27,   10,   42,   67,   85,   96,  101,  101,   91,   69,   46,   21,    1,  -21,  -38,
     -49,  -54,  -49,  -44,  -35,  -18,    2,   24,   44,   55,   64,   67,   63,   59,   46,   29,
       7,  -21,  -51,  -79, -104, -117, -122, -117, -108,  -94,  -70,  -40,    0,   34,   63,   85,
      96,  104,  105,   99,   82,   59,   31,    4,  -20,  -37,  -46,  -51,  -51,  -50,  -44,  -28,
      -8,   17,   38,   53,   60,   65,   67,   64,   54,   40,   18,  -10,  -40,  -71,  -98, -115,
    -121, -118, -113, -103,  -82,  -52,  -14,   22,   53,   77,   94,  106,  109,  104,   93,   76,
      50,   21,  -11,  -33,  -43,  -48,  -53,  -56,  -56,  -46,  -27,    2,   29,   48,   58,   62,
      63,   62,   58,   49,   33,    5,  -27,  -57,  -87, -108, -119, -118, -114, -106,  -91,  -68,
     -31,    8,   42,   69,   88,  102,  110,  110,  100,   83,   60,   33,    3,  -23,  -39,  -46,
     -52,  -57,  -57,  -51,  -35,  -14,   15,   38,   54,   63,   65,   66,   58,   51,   40,   17,
     -11,  -44,  -76, -101, -114, -116, -111, -106,  -96,  -77,  -47,  -11,   28,   58,   81,   97,
     109,  112,  105,   95,   77,   53,   23,   -9,  -30,  -45,  -52,  -58,  -64,  -61,  -52,  -35,
      -9,   20,   44,   62,   67,   67,   65,   62,   54,   35,    7,  -24,  -60,  -91, -110, -119,
    -116, -112, -105,  -90,  -65,  -31,    8,   43,   73,   94,  109,  117,  113,  105,   91,   68,
      39,    4,  -24,  -43,  -56,  -64,  -67,  -67,  -61,  -47,  -21,    9,   35,   55,   63,   66,
      66,   61,   56,   46,   23,  -10,  -46,  -81, -100, -111, -115, -112, -107,  -94,  -75,  -48,
     -12,   28,   59,   84,  103,  116,  120,  114,  103,   81,   56,   22,  -10,  -35,  -53,  -64,
     -71,  -73,  -71,  -59,  -39,  -10,   19,   43,   60,   66,   68,   67,   64,   53,   33,    7,
     -27,  -64,  -91, -108, -115, -113, -108,  -97,  -82,  -59,  -27,   11,   46,   75,   98,  112,
     119,  117,  109,   89,   64,   34,    4,  -24,  -50,  -62,  -69,  -69,  -70,  -65,  -49,  -23,
       8,   32,   52,   61,   64,   65,   64,   55,   39,   15,  -16,  -46,  -76,  -97, -109, -110,
    -107, -102,  -91,  -71,  -42,   -4,   34,   66,   90,  106,  116,  121,  118,  101,   78,   47,
      15,  -15,  -44,  -60,  -70,  -73,  -75,  -74,  -63,  -39,   -7,   23,   45,   60,   66,   69,
      69,   62,   49,   29,    1,  -32,  -65,  -94, -108, -112, -109, -102,  -97,  -83,  -58,  -22,
      18,   54,   84,  103,  116,  121,  120,  112,   91,   63,   29,   -6,  -34,  -54,  -66,  -75,
     -79,  -81,  -72,  -50,  -22,    9,   33,   50,   59,   67,   70,   70,   60,   43,   13,  -20,
     -51,  -78,  -97, -107, -111, -109, -105,  -94,  -72,  -37,    5,   42,   72,   96,  114,  124,
     127,  118,  100,   75,   42,   10,  -22,  -47,  -62,  -72,  -79,  -84,  -82,  -64,  -35,   -2,
      23,   39,   50,   61,   69,   71,   66,   51,   27,   -6,  -36,  -62,  -81,  -96, -104, -105,
    -106, -101,  -83,  -52,  -11,   27,   57,   82,  103,  120,  127,  122,  107,   82,   53,   19,
     -12,  -39,  -55,  -65,  -73,  -81,  -81,  -67,  -40,   -8,   16,   30,   41,   52,   62,   68,
      66,   56,   34,    3,  -28,  -53,  -71,  -86,  -96, -102, -106, -103,  -88,  -62,  -25,   15,
      47,   72,   90,  109,  120,  123,  115,   93,   63,   31,    1,  -24,  -40,  -52,  -64,  -76,
     -82,  -73,  -50,  -22,    1,   18,   27,   39,   51,   63,   67,   61,   44,   18,  -13,  -38,
     -53,  -69,  -83,  -96, -105, -103,  -93,  -69,  -36,   -3,   30,   56,   77,   95,  111,  116,
     113,   97,   72,   42,   13,  -12,  -25,  -38,  -54,  -70,  -79,  -74,  -57,  -32,  -11,    4,
      15,   26,   40,   55,   65,   62,   51,   28,    1,  -24,  -40,  -56,  -73,  -89, -101, -102,
     -95,  -79,  -50,  -17,   16,   47,   68,   88,  104,  114,  115,  102,   80,   53,   24,    0,
     -18,  -31,  -45,  -60,  -73,  -74,  -63,  -42,  -21,   -6,    6,   16,   28,   45,   56,   59,
      51,   35,   14,   -9,  -26,  -41,  -57,  -73,  -87,  -97,  -95,  -85,  -62,  -32,   -2,   26,
      50,   71,   91,  105,  111,  105,   89,   64,   40,   16,   -4,  -20,  -35,  -49,  -64,  -70,
     -68,  -53,  -35,  -18,   -6,    5,   14,   29,   45,   55,   54,   39,   21,    4,  -13,  -25,
     -42,  -63,  -77,  -89,  -90,  -80,  -66,  -44,  -19,   10,   35,   57,   76,   93,  104,  104,
      91,   68,   48,   29,   13,   -6,  -24,  -42,  -56,  -63,  -61,  -54,  -42,  -27,  -17,   -6,
       5,   18,   33,   44,   47,   39,   25,   10,    0,  -14,  -29,  -50,  -67,  -79,  -85,  -81,
     -70,  -53,  -32,   -5,   24,   47,   67,   84,   98,  103,   95,   77,   56,   37,   22,    6,
     -14,  -34,  -48,  -56,  -57,  -52,  -48,  -37,  -28,  -17,   -6,    8,   23,   34,   41,   38,
      28,   15,    4,   -4,  -16,  -38,  -59,  -73,  -78,  -75,  -66,  -54,  -37,  -19,    7,   32,
      53,   72,   87,   95,   92,   78,   58,   44,   32,   20,    2,  -21,  -38,  -47,  -48,  -47,
     -46,  -42,  -36,  -26,  -14,   -5,    9,   20,   32,   35,   30,   19,   12,    8,   -5,  -25,
     -48,  -63,  -71,  -70,  -63,  -58,  -44,  -26,   -6,   20,   40,   59,   79,   92,   93,   83,
      60,   47,   37,   29,   13,  -10,  -28,  -40,  -44,  -44,  -48,  -47,  -41,  -33,  -22,  -13,
       0,   14,   29,   36,   34,   24,   18,   15,    4,  -13,  -39,  -60,  -69,  -72,  -68,  -62,
     -51,  -34,  -13,    9,   31,   52,   73,   88,   95,   87,   70,   55,   45,   35,   20,   -2,
     -23,  -36,  -42,  -47,  -48,  -51,  -50,  -40,  -30,  -17,   -8,    7,   23,   36,   37,   30,
      22,   19,   13,   -3,  -24,  -49,  -65,  -71,  -71,  -64,  -54,  -40,  -20,   -3,   21,   44,
      65,   85,   92,   87,   72,   57,   48,   39,   29,   11,  -12,  -27,  -36,  -41,  -42,  -47,
     -49,  -45,  -37,  -28,  -17,   -4,   13,   28,   33,   29,   26,   23,   17,    6,  -11,  -33,
     -53,  -64,  -66,  -62,  -55,  -44,  -29,  -12,   10,   31,   51,   71,   84,   85,   77,   61,
      50,   41,   36,   22,    2,  -17,  -33,  -38,  -42,  -45,  -48,  -46,  -41,  -34,  -23,   -9,
       7,   24,   35,   32,   28,   23,   17,   10,   -4,  -26,  -49,  -64,  -68,  -64,  -58,  -46,
     -32,  -13,    8,   28,   45,   65,   78,   82,   76,   62,   52,   45,   37,   23,    6,  -10,
     -26,  -35,  -41,  -45,  -46,  -48,  -48,  -39,  -27,  -11,    3,   14,   23,   27,   28,   25,
      23,   15,    2,  -17,  -34,  -52,  -60,  -61,  -56,  -44,  -32,  -17,   -3,   16,   34,   54,
      66,   73,   68,   58,   47,   42,   37,   29,   17,    3,  -14,  -25,  -31,  -36,  -39,  -44,
     -48,  -44,  -33,  -20,   -9,    2,   13,   22,   26,   24,   20,   14,    5,   -7,  -22,  -39,
     -50,  -55,  -51,  -43,  -32,  -20,   -7,   10,   28,   44,   57,   65,   67,   64,   54,   44,
      36,   28,   18,    4,   -9,  -23,  -32,  -39,  -42,  -46,  -44,  -38,  -29,  -19,  -12,   -4,
      10,   22,   27,   22,   14,    8,    1,   -6,  -17,  -30,  -43,  -49,  -47,  -38,  -26,  -18,
     -10,    3,   17,   34,   45,   54,   59,   57,   53,   45,   37,   30,   22,   11,   -3,  -14,
     -24,  -34,  -40,  -45,  -43,  -39,  -29,  -21,  -14,   -6,    3,   16,   20,   17,   10,    3,
       0,   -6,  -15,  -25,  -33,  -38,  -37,  -31,  -21,  -12,   -6,    5,   15,   27,   39,   46,
      50,   51,   47,   44,   36,   29,   20,   10,    1,  -10,  -18,  -27,  -36,  -40,  -42,  -37,
     -29,  -21,  -14,   -7,    1,   10,   16,   10,    3,   -2,   -3,   -6,  -12,  -22,  -28,  -30,
     -28,  -23,  -16,  -11,   -7,    0,    7,   19,   31,   42,   47,   47,   46,   46,   40,   33,
      21,   10,    2,   -6,  -12,  -24,  -33,  -37,  -38,  -36,  -31,  -21,  -14,   -7,   -2,    2,
       7,    8,    4,   -2,   -7,  -12,  -14,  -19,  -23,  -24,  -20,  -16,  -11,   -6,   -2,    3,
       9,   16,   24,   33,   37,   40,   44,   44,   40,   33,   22,   13,    5,   -3,   -8,  -21,
     -30,  -35,  -34,  -32,  -30,  -23,  -13,   -6,   -3,   -3,   -2,   -2,   -4,   -7,   -9,  -12,
     -13,  -13,  -14,  -14,  -11,  -12,   -4,   -2,    2,    0,    3,   10,   18,   27,   32,   35,
      38,   40,   37,   32,   23,   13,    8,    2,   -4,  -11,  -22,  -27,  -31,  -30,  -29,  -24,
     -14,   -7,   -8,   -7,  -10,  -10,  -10,  -10,  -11,  -12,  -13,  -12,  -11,  -11,   -7,   -2,
       4,    5,    3,   -2,    0,    8,   15,   21,   26,   30,   32,   37,   37,   32,   26,   16,
      10,    4,   -4,   -9,  -16,  -21,  -26,  -29,  -28,  -23,  -15,  -11,   -9,  -11,  -13,  -14,
     -14,  -13,  -13,  -12,  -13,  -12,   -8,   -3,    3,    6,    8,   10,    7,    1,   -3,    2,
       8,   17,   22,   22,   27,   32,   37,   35,   29,   18,   11,    2,   -4,   -8,  -14,  -17,
     -21,  -23,  -25,  -22,  -17,  -11,   -9,  -11,  -16,  -16,  -16,  -16,  -14,  -15,  -14,  -11,
      -5,    0,    4,    5,    6,    7,    6,    4,    0,    3,    8,   16,   21,   20,   24,   28,
      34,   35,   29,   17,    8,    3,    1,   -3,   -9,  -15,  -20,  -21,  -23,  -22,  -21,  -17,
     -13,  -14,  -18,  -23,  -22,  -17,  -13,  -10,   -9,   -8,    0,    6,    9,   10,    8,    6,
       6,    4,    0,   -2,    1,   10,   17,   20,   22,   25,   29,   31,   29,   20,   10,    2,
      -2,    0,   -5,  -11,  -18,  -20,  -19,  -19,  -19,  -18,  -16,  -14,  -18,  -26,  -26,  -22,
     -16,  -13,   -9,   -6,    1,    7,   10,   10,    7,    7,    7,    5,    0,   -4,   -2,    7,
      14,   19,   22,   26,   30,   32,   30,   22,   13,    6,    1,   -2,   -7,  -13,  -16,  -18,
     -19,  -19,  -21,  -21,  -19,  -17,  -16,  -23,  -25,  -23,  -17,  -10,   -9,   -4,    2,    8,
      10,   12,    9,    7,    5,    4,    2,   -3,   -2,    3,    9,   18,   23,   28,   29,   28,
      27,   26,   19,   12,    6,    0,   -7,  -11,  -15,  -17,  -20,  -21,  -20,  -22,  -23,  -25,
     -24,  -26,  -27,  -25,  -20,  -13,   -5,    3,    9,   11,   15,   17,   15,   10,    4,    0,
      -4,   -5,   -4,    2,    5,   13,   19,   25,   29,   28,   26,   25,   20,   16,   11,    2,
      -5,  -10,  -10,  -10,  -14,  -17,  -21,  -24,  -26,  -29,  -27,  -28,  -28,  -26,  -23,  -17,
      -8,    1,   12,   15,   16,   14,   13,   10,    6,    0,   -5,   -6,   -5,    1,    6,   12,
      20,   27,   30,   28,   24,   23,   21,   17,   11,    4,   -6,   -9,  -10,  -10,  -11,  -16,
     -18,  -21,  -24,  -26,  -29,  -28,  -27,  -25,  -23,  -18,  -11,   -2,   11,   15,   15,   12,
      11,    9,    6,    1,   -6,   -6,   -2,    3,    7,   11,   19,   26,   28,   26,   22,   21,
      23,   24,   17,   10,    4,    0,   -2,   -5,  -10,  -15,  -20,  -25,  -32,  -36,  -36,  -35,
     -32,  -30,  -26,  -19,  -10,    2,   14,   21,   21,   17,   13,   10,    7,    1,   -5,   -5,
      -6,   -4,    0,    6,   12,   19,   22,   24,   20,   21,   24,   29,   28,   20,   13,    8,
       3,    2,   -4,   -9,  -16,  -27,  -34,  -41,  -44,  -41,  -38,  -35,  -31,  -27,  -18,   -3,
      13,   26,   29,   23,   18,   14,   11,    8,    4,   -2,   -8,  -11,   -9,   -6,    4,    9,
      16,   17,   16,   16,   23,   33,   37,   33,   26,   19,   12,    8,    1,   -7,  -15,  -30,
     -41,  -50,  -53,  -50,  -43,  -38,  -34,  -28,  -17,   -3,   13,   26,   30,   26,   19,   14,
      12,    9,    4,   -2,  -10,  -14,  -13,   -7,    4,    9,   12,   13,   13,   17,   25,   32,
      40,   39,   32,   24,   15,   11,    8,    1,  -10,  -27,  -43,  -51,  -55,  -52,  -49,  -45,
     -40,  -32,  -21,   -8,    9,   23,   31,   30,   24,   19,   17,   16,   11,    4,   -7,  -15,
     -18,  -14,   -6,    2,    5,    7,    9,   14,   24,   35,   45,   48,   45,   34,   25,   16,
       8,    2,  -11,  -27,  -46,  -59,  -64,  -61,  -53,  -46,  -40,  -35,  -24,   -9,    8,   23,
      30,   31,   27,   24,   21,   17,   12,    4,   -6,  -15,  -19,  -17,  -12,   -3,    3,    4,
       6,   12,   25,   37,   45,   47,   47,   43,   35,   23,   12,    2,  -10,  -24,  -42,  -60,
     -71,  -71,  -63,  -55,  -45,  -36,  -22,   -7,    9,   22,   30,   35,   34,   31,   24,   19,
      13,    6,   -3,  -13,  -20,  -21,  -16,   -9,   -3,   -2,    4,   11,   26,   38,   45,   50,
      49,   48,   42,   31,   16,    4,   -9,  -21,  -38,  -59,  -72,  -77,  -70,  -61,  -53,  -41,
     -26,   -9,    7,   17,   26,   34,   41,   41,   35,   25,   17,    9,    0,  -10,  -21,  -24,
     -22,  -15,   -9,   -7,   -2,   10,   25,   39,   44,   47,   49,   52,   50,   39,   22,    6,
      -8,  -20,  -34,  -54,  -70,  -78,  -77,  -68,  -61,  -49,  -33,  -15,    3,   16,   25,   32,
      43,   49,   47,   37,   25,   16,    3,  -10,  -22,  -29,  -27,  -22,  -15,  -12,   -7,    7,
      25,   42,   47,   50,   53,   57,   57,   46,   31,   11,   -5,  -22,  -39,  -56,  -72,  -81,
     -85,  -81,  -71,  -56,  -36,  -16,    4,   19,   29,   37,   48,   55,   56,   48,   34,   20,
       7,  -10,  -25,  -32,  -34,  -28,  -21,  -17,  -14,    0,   20,   40,   50,   51,   53,   58,
      61,   53,   39,   18,   -2,  -18,  -36,  -53,  -70,  -80,  -85,  -86,  -79,  -67,  -46,  -23,
      -2,   17,   27,   35,   44,   55,   62,   57,   44,   26,    9,  -10,  -23,  -29,  -32,  -28,
     -24,  -20,  -15,   -4,   15,   35,   47,   50,   49,   53,   57,   53,   43,   24,    5,  -14,
     -32,  -50,  -64,   -5,    0,   -2,   -3,   -3,   -3,   -3,   -2,   -2,    1,    2,    3,    5,
       8,   11,   11,   10,    8,    5,    1,   -6,  -13,  -19,  -21,  -18,  -15,  -13,  -10,   -7,
      -2,    4,    8,   12,   17,   28,   33,   29,   23,   14,    7,   -5,  -19,  -33,  -42,  -36,
     -28,  -24,  -17,  -13,   -8,    1,    7,   15,   23,   33,   42,   42,   35,   26,   15,    0,
     -16,  -30,  -44,  -45,  -34,  -27,  -20,  -16,  -13,   -4,    4,   12,   21,   29,   40,   45,
      40,   30,   20,    6,  -13,  -25,  -38,  -45,  -38,  -31,  -24,  -18,  -15,  -10,   -4,    5,
      17,   27,   35,   44,   43,   37,   27,   15,   -4,  -19,  -31,  -44,  -44,  -35,  -30,  -22,
     -19,  -16,   -8,    2,   15,   25,   32,   42,   47,   42,   32,   18,    0,  -16,  -26,  -39,
     -45,  -38,  -31,  -25,  -19,  -18,  -14,   -5,   11,   23,   29,   39,   46,   45,   38,   25,
       7,   -8,  -18,  -31,  -44,  -43,  -35,  -30,  -25,  -25,  -20,   -9,    7,   21,   27,   36,
      48,   51,   44,   32,   14,   -3,  -16,  -28,  -42,  -46,  -41,  -33,  -27,  -24,  -23,  -15,
       1,   16,   27,   33,   42,   47,   46,   38,   21,    5,   -9,  -21,  -34,  -44,  -45,  -39,
     -31,  -28,  -26,  -20,   -8,    9,   25,   34,   41,   49,   51,   47,   31,   11,   -6,  -18,
     -30,  -42,  -48,  -45,  -36,  -28,  -26,  -23,  -12,    6,   23,   33,   38,   43,   51,   50,
      36,   15,    0,  -12,  -22,  -35,  -50,  -50,  -40,  -31,  -29,  -27,  -18,    1,   20,   32,
      36,   43,   52,   56,   45,   23,    2,  -10,  -20,  -33,  -48,  -56,  -49,  -36,  -30,  -26,
     -18,   -5,   17,   33,   39,   40,   46,   52,   49,   32,    9,   -8,  -18,  -26,  -40,  -54,
     -53,  -39,  -30,  -28,  -23,  -12,   10,   31,   39,   38,   42,   54,   54,   41,   17,   -5,
     -15,  -22,  -35,  -53,  -59,  -47,  -36,  -30,  -24,  -14,    6,   27,   40,   42,   43,   51,
      56,   46,   26,    3,  -13,  -22,  -33,  -49,  -61,  -55,  -41,  -32,  -26,  -18,    0,   22,
      38,   45,   43,   48,   55,   50,   33,   11,  -10,  -21,  -29,  -43,  -59,  -60,  -46,  -35,
     -28,  -18,   -6,   15,   35,   45,   46,   45,   52,   53,   41,   20,   -6,  -19,  -26,  -38,
     -54,  -62,  -53,  -39,  -29,  -19,  -11,    6,   29,   44,   48,   45,   47,   52,   49,   32,
       5,  -18,  -26,  -32,  -45,  -61,  -61,  -48,  -35,  -23,  -14,   -2,   22,   42,   52,   50,
      46,   50,   50,   38,   12,  -15,  -26,  -31,  -43,  -59,  -65,  -53,  -37,  -25,  -16,   -6,
      16,   40,   53,   53,   47,   49,   51,   42,   22,  -10,  -27,  -31,  -38,  -54,  -67,  -63,
     -46,  -27,  -18,   -7,   10,   31,   52,   59,   53,   48,   50,   46,   32,    3,  -24,  -34,
     -39,  -50,  -66,  -68,  -54,  -35,  -20,   -8,    6,   23,   47,   62,   59,   52,   50,   48,
      37,   13,  -18,  -35,  -40,  -46,  -62,  -72,  -63,  -43,  -25,  -10,    6,   20,   41,   59,
      63,   55,   49,   46,   39,   21,   -9,  -31,  -39,  -42,  -52,  -68,  -68,  -52,  -32,  -17,
      -4,    9,   31,   54,   66,   63,   54,   51,   44,   32,    6,  -26,  -40,  -44,  -51,  -65,
     -72,  -61,  -41,  -23,   -5,    9,   25,   48,   64,   66,   59,   54,   46,   33,   12,  -17,
     -36,  -45,  -51,  -62,  -73,  -67,  -48,  -31,  -11,    8,   21,   44,   64,   70,   64,   57,
      49,   36,   20,   -8,  -34,  -47,  -52,  -58,  -68,  -73,  -59,  -40,  -19,    4,   17,   36,
      58,   72,   73,   65,   56,   41,   26,    4,  -24,  -44,  -55,  -63,  -69,  -73,  -66,  -51,
     -28,   -2,   18,   32,   51,   67,   75,   72,   62,   46,   29,   11,  -13,  -37,  -54,  -64,
     -70,  -71,  -70,  -58,  -38,  -13,   14,   30,   48,   64,   73,   76,   69,   52,   34,   15,
      -7,  -31,  -50,  -62,  -69,  -71,  -71,  -66,  -47,  -19,    8,   26,   40,   58,   73,   81,
      76,   57,   39,   23,    2,  -22,  -45,  -62,  -71,  -73,  -71,  -69,  -57,  -32,    0,   26,
      41,   55,   70,   81,   83,   64,   41,   24,    6,  -15,  -39,  -60,  -71,  -73,  -69,  -69,
     -62,  -40,  -11,   20,   39,   51,   65,   78,   86,   75,   50,   29,   11,   -8,  -30,  -53,
     -70,  -77,  -71,  -66,  -67,  -53,  -22,   13,   37,   49,   60,   75,   89,   84,   58,   33,
      16,   -2,  -22,  -47,  -68,  -77,  -72,  -67,  -68,  -60,  -34,    0,   29,   47,   56,   69,
      85,   88,   69,   40,   20,    4,  -13,  -35,  -61,  -76,  -74,  -65,  -66,  -65,  -47,  -15,
      20,   43,   53,   64,   81,   89,   77,   50,   26,    9,  -10,  -29,  -51,  -71,  -78,  -71,
     -66,  -64,  -52,  -27,    9,   38,   54,   62,   73,   85,   82,   60,   34,   13,   -3,  -19,
     -40,  -65,  -80,  -74,  -68,  -69,  -61,  -40,   -4,   29,   49,   61,   72,   86,   86,   70,
      45,   21,    3,  -16,  -33,  -56,  -80,  -78,  -70,  -70,  -65,  -50,  -18,   20,   48,   62,
      68,   80,   88,   78,   53,   26,    5,  -12,  -26,  -45,  -72,  -81,  -71,  -67,  -64,  -56,
     -34,    4,   37,   57,   63,   73,   85,   83,   63,   37,   16,    0,  -17,  -36,  -63,  -79,
     -74,  -70,  -69,  -63,  -44,  -10,   26,   52,   62,   69,   81,   84,   69,   45,   22,    3,
     -15,  -28,  -52,  -75,  -76,  -69,  -67,  -64,  -52,  -24,   14,   45,   60,   65,   74,   82,
      75,   54,   32,   12,   -6,  -21,  -44,  -68,  -78,  -74,  -71,  -69,  -60,  -34,    2,   34,
      55,   66,   73,   79,   78,   61,   39,   20,    2,  -16,  -34,  -56,  -72,  -74,  -70,  -71,
     -66,  -47,  -14,   21,   48,   61,   68,   76,   80,   69,   46,   27,   11,   -7,  -26,  -50,
     -68,  -72,  -70,  -70,  -69,  -54,  -24,   10,   39,   57,   66,   72,   76,   70,   52,   33,
      16,   -4,  -20,  -39,  -59,  -70,  -71,  -69,  -67,  -60,  -37,   -6,   27,   50,   62,   67,
      72,   74,   61,   41,   25,   10,  -10,  -31,  -51,  -67,  -74,  -73,  -73,  -68,  -48,  -16,
      17,   45,   60,   66,   73,   75,   66,   48,   29,   15,   -3,  -24,  -45,  -62,  -70,  -72,
     -74,  -70,  -55,  -26,    7,   32,   51,   63,   70,   73,   67,   51,   35,   24,    9,  -16,
     -38,  -54,  -64,  -68,  -75,  -75,  -62,  -36,   -5,   22,   45,   60,   69,   74,   68,   57,
      43,   29,   15,   -9,  -29,  -45,  -60,  -67,  -75,  -76,  -64,  -44,  -16,   10,   32,   52,
      63,   68,   66,   59,   48,   36,   24,    6,  -17,  -35,  -51,  -60,  -70,  -78,  -72,  -55,
     -27,    1,   20,   39,   56,   65,   68,   60,   51,   41,   31,   15,   -9,  -27,  -44,  -58,
     -67,  -75,  -73,  -58,  -35,   -8,   11,   32,   50,   60,   61,   57,   53,   47,   37,   25,
       4,  -19,  -35,  -48,  -60,  -73,  -76,  -67,  -46,  -18,    2,   20,   40,   56,   64,   62,
      56,   49,   43,   34,   15,  -10,  -31,  -45,  -57,  -70,  -78,  -69,  -52,  -27,   -4,   13,
      34,   52,   60,   57,   53,   52,   46,   36,   22,    1,  -19,  -35,  -50,  -65,  -73,  -70,
     -58,  -41,  -17,    4,   22,   42,   55,   58,   57,   55,   50,   43,   32,   12,  -11,  -30,
     -47,  -61,  -71,  -72,  -63,  -46,  -26,   -6,   13,   30,   47,   53,   54,   56,   52,   46,
      38,   24,    5,  -20,  -39,  -52,  -63,  -67,  -66,  -57,  -37,  -15,    3,   18,   37,   50,
      55,   59,   55,   49,   45,   32,   15,  -10,  -34,  -50,  -61,  -66,  -66,  -58,  -42,  -24,
      -4,   11,   27,   44,   50,   54,   57,   53,   49,   39,   23,    2,  -23,  -43,  -57,  -64,
     -67,  -62,  -50,  -33,  -14,    4,   18,   37,   48,   53,   57,   55,   52,   44,   30,   13,
     -14,  -38,  -54,  -62,  -65,  -62,  -54,  -42,  -24,   -2,   13,   28,   41,   48,   56,   57,
      52,   45,   37,   23,    0,  -28,  -47,  -57,  -62,  -63,  -59,  -50,  -34,  -14,    1,   16,
      35,   48,   56,   59,   59,   54,   45,   31,    8,  -20,  -42,  -56,  -62,  -64,  -60,  -52,
     -40,  -23,   -5,   10,   28,   43,   52,   56,   57,   56,   49,   38,   21,   -8,  -33,  -46,
     -56,  -60,  -59,  -56,  -47,  -32,  -15,    0,   17,   34,   47,   55,   58,   57,   53,   43,
      30,    8,  -24,  -42,  -52,  -59,  -58,  -57,  -51,  -42,  -26,   -8,   11,   29,   42,   50,
      57,   59,   55,   48,   34,   15,  -15,  -36,  -45,  -52,  -55,  -58,  -55,  -43,  -31,  -17,
      -2,   16,   37,   50,   56,   58,   58,   54,   43,   23,   -8,  -33,  -40,  -47,  -54,  -57,
     -58,  -48,  -34,  -23,  -10,    9,   31,   48,   54,   55,   55,   57,   50,   32,    3,  -28,
     -37,  -41,  -49,  -55,  -58,  -49,  -36,  -27,  -17,    1,   21,   41,   50,   52,   51,   54,
      55,   41,   13,  -18,  -32,  -35,  -42,  -50,  -57,  -55,  -41,  -32,  -24,  -10,   10,   33,
      47,   50,   51,   54,   59,   49,   24,   -8,  -26,  -30,  -37,  -46,  -56,  -59,  -46,  -35,
     -29,  -18,    2,   25,   44,   48,   47,   51,   57,   56,   36,    5,  -20,  -28,  -31,  -40,
     -51,  -58,  -52,  -39,  -33,  -25,   -8,   15,   38,   49,   47,   50,   56,   60,   46,   15,
     -11,  -25,  -30,  -36,  -49,  -60,  -54,  -39,  -33,  -30,  -14,    8,   32,   47,   44,   44,
      51,   59,   52,   26,   -4,  -20,  -24,  -29,  -41,  -54,  -55,  -43,  -34,  -33,  -26,   -8,
      17,   37,   43,   42,   48,   59,   60,   42,   13,  -11,  -21,  -25,  -36,  -51,  -59,  -51,
     -38,  -34,  -32,  -17,   10,   33,   43,   43,   44,   55,   60,   46,   21,   -6,  -18,  -22,
     -28,  -42,  -54,  -52,  -39,  -30,  -32,  -25,   -4,   20,   36,   39,   39,   48,   60,   57,
      36,   10,  -11,  -19,  -22,  -34,  -51,  -58,  -48,  -35,  -36,  -34,  -13,   13,   35,   41,
      38,   46,   59,   61,   44,   20,   -5,  -20,  -22,  -30,  -46,  -56,  -53,  -39,  -34,  -36,
     -22,    1,   25,   39,   39,   42,   53,   60,   54,   34,   10,  -10,  -17,  -21,  -39,  -57,
     -59,  -48,  -38,  -43,  -35,  -11,   16,   37,   43,   42,   52,   61,   58,   41,   19,   -3,
     -16,  -21,  -31,  -50,  -59,  -53,  -40,  -39,  -39,  -22,    5,   30,   40,   38,   45,   58,
      64,   52,   28,    5,  -12,  -17,  -23,  -44,  -58,  -56,  -46,  -40,  -43,  -33,   -7,   22,
      39,   41,   44,   55,   64,   60,   40,   13,   -7,  -16,  -21,  -35,  -56,  -60,  -52,  -44,
     -43,  -40,  -21,   11,   34,   40,   40,   50,   61,   64,   53,   29,    6,  -10,  -16,  -25,
     -47,  -62,  -61,  -53,  -49,  -47,  -35,   -5,   26,   42,   45,   49,   58,   65,   59,   39,
      15,   -5,  -16,  -22,  -37,  -56,  -61,  -56,  -50,  -47,  -42,  -21,   11,   33,   40,   44,
      53,   63,   66,   54,   29,    8,   -6,  -15,  -28,  -52,  -64,  -60,  -57,  -53,  -49,  -31,
       1,   28,   40,   42,   51,   63,   66,   56,   36,   14,   -3,  -13,  -25,  -45,  -61,  -61,
     -58,  -54,  -47,  -38,  -11,   20,   36,   41,   44,   55,   64,   60,   47,   28,    9,   -4,
     -15,  -32,  -56,  -67,  -64,  -62,  -55,  -48,  -27,    8,   29,   41,   47,   57,   66,   65,
      56,   39,   17,    0,  -13,  -27,  -49,  -66,  -68,  -67,  -58,  -48,  -36,   -8,   22,   38,
      45,   53,   63,   65,   61,   51,   28,   11,   -4,  -20,  -40,  -62,  -70,  -71,  -68,  -55,
     -44,  -24,    9,   30,   42,   52,   66,   69,   64,   58,   42,   20,    4,  -14,  -34,  -57,
     -71,  -73,  -73,  -63,  -51,  -35,   -5,   23,   38,   48,   62,   71,   69,   65,   54,   32,
      14,   -6,  -26,  -48,  -68,  -79,  -82,  -72,  -57,  -42,  -18,   11,   33,   48,   63,   73,
      72,   68,   62,   46,   22,    0,  -21,  -42,  -63,  -76,  -83,  -80,  -65,  -49,  -28,   -2,
      23,   42,   58,   71,   75,   72,   68,   56,   33,   10,  -12,  -32,  -54,  -73,  -84,  -87,
     -73,  -54,  -36,  -15,   11,   34,   52,   67,   73,   73,   72,   66,   48,   21,   -6,  -26,
     -47,  -67,  -80,  -88,  -81,  -62,  -41,  -23,    0,   27,   47,   65,   74,   74,   71,   67,
      57,   33,    4,  -20,  -42,  -64,  -77,  -88,  -88,  -72,  -49,  -27,   -7,   16,   40,   63,
      75,   75,   74,   69,   64,   46,   16,  -13,  -35,  -57,  -74,  -87,  -93,  -81,  -58,  -35,
     -17,    6,   33,   59,   73,   76,   76,   71,   68,   58,   29,   -4,  -29,  -48,  -68,  -83,
     -94,  -92,  -70,  -42,  -22,   -4,   21,   51,   73,   78,   76,   73,   70,   63,   40,    7,
     -24,  -42,  -60,  -79,  -91,  -92,  -76,  -52,  -30,  -12,    9,   39,   66,   76,   76,   75,
      74,   70,   54,   24,  -12,  -36,  -52,  -72,  -93, -100,  -90,  -64,  -38,  -21,   -5,   25,
      61,   81,   81,   77,   78,   76,   63,   33,   -5,  -33,  -49,  -67,  -90, -100,  -92,  -71,
     -44,  -21,   -8,   14,   49,   75,   82,   77,   76,   75,   66,   45,   10,  -27,  -45,  -59,
     -80,  -98,  -98,  -81,  -52,  -26,  -12,    2,   34,   71,   86,   80,   75,   77,   71,   54,
      23,  -17,  -44,  -57,  -74,  -93,  -99,  -87,  -65,  -36,  -14,   -4,   20,   55,   79,   82,
      78,   78,   75,   65,   41,    1,  -34,  -52,  -67,  -88, -104,  -98,  -76,  -47,  -23,  -12,
       6,   45,   81,   90,   81,   79,   81,   72,   50,   11,  -28,  -50,  -61,  -81, -102, -103,
     -84,  -57,  -30,  -13,    1,   30,   70,   92,   88,   81,   80,   75,   59,   27,  -15,  -48,
     -62,  -76,  -97, -106,  -94,  -69,  -39,  -16,   -4,   17,   59,   92,   94,   87,   86,   83,
      67,   36,   -4,  -38,  -61,  -77,  -96, -111, -102,  -80,  -53,  -26,   -8,   14,   50,   89,
     101,   93,   87,   83,   73,   46,    7,  -31,  -58,  -72,  -87, -106, -106,  -88,  -59,  -31,
     -12,    5,   33,   74,   99,   99,   90,   84,   78,   57,   22,  -18,  -49,  -70,  -84, -100,
    -108,  -96,  -72,  -43,  -21,   -3,   24,   61,   95,  106,   99,   90,   82,   65,   34,   -6,
     -40,  -66,  -83,  -96, -106, -102,  -82,  -52,  -27,   -8,   15,   48,   86,  107,  105,   94,
      85,   73,   45,    6,  -32,  -61,  -80,  -91, -102, -106,  -92,  -63,  -35,  -15,    8,   37,
      74,  102,  109,   98,   87,   76,   54,   21,  -16,  -50,  -76,  -89,  -98, -104,  -98,  -76,
     -46,  -23,   -2,   25,   60,   93,  111,  106,   92,   82,   65,   35,   -5,  -39,  -66,  -83,
     -95, -105, -105,  -86,  -57,  -33,  -11,   15,   50,   86,  111,  115,  102,   88,   71,   43,
       7,  -32,  -64,  -86,  -96, -100, -102,  -92,  -67,  -40,  -13,   13,   42,   75,  103,  116,
     106,   90,   74,   49,   16,  -21,  -54,  -80,  -94,  -98, -100,  -94,  -75,  -50,  -23,    4,
      30,   62,   95,  117,  115,  100,   81,   57,   28,  -10,  -46,  -75,  -95, -102, -101,  -97,
     -83,  -61,  -32,   -2,   24,   55,   87,  111,  118,  106,   88,   65,   35,    0,  -36,  -67,
     -89, -101, -102,  -98,  -89,  -68,  -43,  -13,   16,   46,   80,  107,  121,  116,   98,   75,
      47,   11,  -27,  -62,  -87, -101, -104, -100,  -93,  -77,  -51,  -18,   13,   36,   67,   99,
     119,  119,  103,   81,   53,   21,  -16,  -52,  -79,  -96, -106, -102,  -93,  -82,  -60,  -30,
       3,   30,   59,   88,  111,  121,  111,   89,   61,   30,   -4,  -41,  -74,  -94, -106, -104,
     -95,  -87,  -70,  -41,   -8,   22,   49,   81,  106,  120,  118,   98,   73,   41,    8,  -30,
     -64,  -87, -104, -111, -100,  -91,  -77,  -51,  -21,   13,   41,   73,  100,  117,  122,  107,
      83,   52,   19,  -18,  -55,  -82, -101, -111, -105,  -93,  -83,  -60,  -29,    5,   35,   64,
      92,  112,  121,  112,   88,   61,   29,   -7,  -45,  -75,  -94, -108, -108,  -96,  -87,  -67,
     -37,   -5,   26,   52,   83,  105,  116,  116,   97,   70,   41,    7,  -33,  -67,  -91, -105,
    -110,  -99,  -88,  -73,  -48,  -18,   15,   45,   74,   98,  114,  118,  104,   79,   51,   17,
     -21,  -58,  -86, -102, -109, -103,  -90,  -77,  -54,  -23,    9,   36,   62,   88,  107,  114,
     107,   88,   63,   30,   -8,  -46,  -77,  -96, -107, -108,  -97,  -81,  -63,  -36,   -4,   30,
      59,   84,  104,  115,  112,   95,   69,   38,    5,  -33,  -69,  -94, -104, -105,  -99,  -87,
     -72,  -44,  -11,   21,   47,   71,   97,  113,  113,   99,   77,   49,   17,  -19,  -57,  -87,
    -101, -105, -103,  -90,  -72,  -54,  -24,   10,   41,   64,   86,  104,  111,  104,   85,   57,
      25,   -7,  -42,  -75,  -96, -101,  -98,  -92,  -79,  -61,  -36,   -4,   28,   51,   74,   98,
     110,  107,   94,   70,   38,    5,  -30,  -64,  -89, -101, -101,  -95,  -79,  -63,  -43,  -14,
      21,   48,   68,   90,  105,  108,   97,   74,   44,   12,  -20,  -52,  -83,  -96,  -96,  -92,
     -82,  -67,  -49,  -24,   10,   39,   59,   79,   99,  107,  101,   83,   54,   21,  -11,  -41,
     -71,  -92,  -98,  -95,  -84,  -68,  -54,  -35,   -5,   28,   54,   73,   92,  103,  103,   90,
      64,   31,   -4,  -34,  -63,  -85,  -94,  -92,  -84,  -70,  -56,  -38,  -11,   19,   44,   64,
      83,   95,   98,   90,   66,   39,    9,  -22,  -50,  -73,  -86,  -89,  -84,  -72,  -59,  -45,
     -23,    6,   35,   58,   75,   89,   96,   92,   75,   49,   19,  -14,  -42,  -63,  -80,  -88,
     -84,  -74,  -60,  -48,  -30,   -5,   23,   52,   70,   82,   91,   91,   79,   57,   29,   -3,
     -33,  -54,  -70,  -84,  -87,  -79,  -65,  -50,  -35,  -16,   10,   41,   68,   80,   85,   88,
      82,   64,   36,    3,  -28,  -49,  -60,  -72,  -83,  -81,  -66,  -49,  -37,  -22,   -2,   28,
      58,   74,   78,   83,   81,   69,   45,   14,  -18,  -42,  -55,  -66,  -77,  -79,  -68,  -53,
     -39,  -25,   -8,   17,   46,   67,   72,   75,   74,   70,   53,   24,   -9,  -34,  -48,  -55,
     -64,  -74,  -70,  -55,  -40,  -28,  -17,    3,   33,   61,   70,   71,   69,   68,   61,   37,
       3,  -28,  -44,  -50,  -57,  -70,  -73,  -58,  -41,  -30,  -21,   -8,   21,   52,   67,   69,
      66,   66,   64,   44,   10,  -22,  -39,  -48,  -52,  -61,  -72,  -62,  -43,  -29,  -20,  -12,
       7,   38,   62,   68,   61,   56,   60,   51,   23,  -12,  -36,  -43,  -44,  -49,  -65,  -65,
     -45,  -29,  -22,  -19,   -7,   24,   52,   65,   57,   52,   58,   57,   36,    0,  -30,  -38,
     -37,  -39,  -55,  -66,  -52,  -33,  -23,  -21,  -14,   10,   40,   60,   59,   49,   51,   54,
      43,   11,  -21,  -35,  -37,  -33,  -42,  -55,  -49,  -29,  -19,  -20,  -19,   -5,   23,   49,
      54,   43,   42,   50,   49,   23,  -12,  -30,  -34,  -29,  -31,  -49,  -54,  -35,  -19,  -16,
     -18,  -11,   10,   39,   55,   45,   35,   41,   47,   31,   -3,  -26,  -33,  -28,  -23,  -36,
     -47,  -36,  -18,  -11,  -16,  -16,   -3,   21,   42,   42,   32,   32,   40,   35,   13,  -13,
     -25,  -24,  -17,  -22,  -37,  -38,  -25,  -16,  -16,  -19,  -11,    7,   30,   42,   34,   27,
      33,   35,   19,   -6,  -21,  -23,  -17,  -14,  -23,  -29,  -21,  -11,  -10,  -17,  -16,   -4,
      14,   30,   31,   20,   21,   29,   24,    6,  -11,  -16,  -11,   -5,  -10,  -20,  -22,  -15,
     -12,  -17,  -21,  -15,    0,   20,   29,   22,   17,   23,   25,   16,   -2,  -14,  -14,   -7,
      -2,   -9,  -14,  -12,   -9,  -11,  -17,  -17,  -11,    3,   18,   17,    9,   13,   19,   17,
       7,   -5,   -5,    3,    8,    3,   -7,  -10,  -12,  -14,  -20,  -22,  -17,   -7,    9,   17,
      10,    8,   15,   18,   11,    2,   -3,    1,    8,    9,    5,   -3,   -9,  -12,  -18,  -21,
     -21,  -19,   -4,   10,    9,    2,    5,   14,   16,   11,    4,    5,   13,   16,   14,    6,
      -8,  -14,  -19,  -23,  -24,  -21,  -13,   -2,    7,    3,   -2,    8,   12,   11,    9,   10,
      14,   19,   20,   16,    4,   -9,  -17,  -23,  -26,  -27,  -24,  -14,   -2,    1,   -5,    3,
      15,   17,   14,   14,   17,   22,   25,   20,    9,   -8,  -19,  -25,  -30,  -29,  -26,  -22,
     -11,    0,   -3,   -3,    9,   16,   19,   20,   21,   24,   28,   28,   20,    2,  -16,  -25,
     -30,  -34,  -33,  -32,  -23,   -9,   -6,   -8,    2,   15,   21,   24,   26,   29,   33,   34,
      30,   14,  -11,  -26,  -33,  -38,  -38,  -37,  -34,  -23,  -12,   -7,    0,   11,   21,   29,
      34,   35,   37,   39,   35,   21,   -5,  -26,  -34,  -39,  -40,  -42,  -42,  -31,  -17,   -9,
      -4,    7,   19,   31,   38,   38,   41,   42,   40,   28,    3,  -22,  -36,  -42,  -45,  -46,
     -46,  -37,  -23,  -14,   -6,    6,   20,   32,   40,   40,   44,   46,   41,   31,   13,  -12,
     -32,  -44,  -47,  -48,  -49,  -44,  -32,  -20,   -8,    3,   15,   27,   40,   45,   47,   50,
      47,   39,   21,   -6,  -29,  -42,  -46,  -51,  -56,  -52,  -41,  -24,  -13,   -4,   11,   27,
      41,   51,   52,   53,   52,   45,   29,    2,  -25,  -45,  -50,  -52,  -57,  -56,  -49,  -32,
     -16,   -4,    9,   22,   36,   49,   55,   56,   56,   50,   35,   11,  -14,  -37,  -51,  -57,
     -61,  -61,  -56,  -41,  -23,   -8,    8,   21,   33,   48,   61,   64,   60,   54,   40,   17,
      -8,  -34,  -52,  -59,  -62,  -63,  -60,  -49,  -30,  -14,    2,   19,   33,   47,   60,   66,
      67,   65,   50,   25,   -3,  -26,  -47,  -59,  -68,  -72,  -66,  -57,  -38,  -20,   -5,   14,
      30,   44,   61,   71,   71,   68,   57,   34,    7,  -20,  -43,  -58,  -68,  -72,  -69,  -62,
     -45,  -25,  -10,    7,   24,   42,   59,   70,   74,   73,   65,   46,   16,  -15,  -38,  -53,
     -65,  -77,  -77,  -70,  -54,  -34,  -19,    0,   20,   41,   60,   74,   82,   80,   71,   54,
      27,   -8,  -36,  -55,  -68,  -78,  -82,  -76,  -61,  -40,  -20,   -2,   17,   36,   57,   74,
      83,   82,   74,   62,   39,    3,  -31,  -49,  -62,  -75,  -84,  -84,  -69,  -47,  -27,  -13,
       6,   31,   56,   73,   82,   86,   80,   68,   49,   14,  -24,  -46,  -60,  -74,  -83,  -86,
     -76,  -54,  -32,  -15,    3,   23,   48,   71,   85,   87,   80,   71,   57,   27,  -12,  -41,
     -57,  -68,  -78,  -88,  -84,  -64,  -41,  -23,   -5,   16,   40,   65,   84,   90,   87,   77,
      63,   36,   -3,  -34,  -57,  -69,  -76,  -85,  -87,  -73,  -48,  -27,   -8,   13,   34,   60,
      83,   91,   86,   77,   66,   44,    9,  -26,  -53,  -68,  -74,  -83,  -88,  -80,  -56,  -33,
     -13,    9,   29,   55,   79,   93,   89,   76,   67,   52,   21,  -15,  -46,  -69,  -74,  -77,
     -84,  -86,  -67,  -42,  -20,    4,   23,   43,   71,   94,   95,   80,   67,   56,   32,    0,
     -37,  -66,  -74,  -73,  -78,  -87,  -76,  -50,  -25,    1,   21,   37,   61,   88,   97,   84,
      67,   57,   38,    8,  -25,  -59,  -77,  -77,  -76,  -81,  -80,  -61,  -34,   -6,   20,   36,
      55,   80,   96,   91,   70,   54,   39,   17,  -14,  -51,  -75,  -79,  -75,  -77,  -80,  -68,
     -40,  -11,   15,   33,   48,   71,   92,   91,   73,   57,   45,   24,   -3,  -38,  -68,  -79,
     -77,  -76,  -80,  -74,  -51,  -19,   12,   32,   46,   65,   88,   96,   83,   59,   40,   24,
       4,  -31,  -67,  -83,  -80,  -73,  -73,  -72,  -55,  -24,    9,   31,   44,   58,   78,   90,
      84,   63,   42,   28,   10,  -18,  -53,  -77,  -82,  -76,  -73,  -74,  -65,  -37,   -2,   27,
      42,   55,   73,   88,   90,   72,   47,   28,   13,  -12,  -45,  -74,  -84,  -78,  -70,  -68,
     -63,  -43,   -9,   23,   42,   52,   64,   78,   84,   75,   52,   32,   17,   -3,  -32,  -62,
     -79,  -78,  -71,  -67,  -65,  -52,  -19,   15,   38,   50,   61,   73,   80,   79,   59,   34,
      18,    3,  -21,  -51,  -75,  -81,  -72,  -64,  -61,  -54,  -31,    4,   31,   48,   55,   63,
      73,   78,   67,   40,   21,    8,  -12,  -39,  -65,  -80,  -76,  -65,  -58,  -52,  -38,   -8,
      25,   45,   56,   61,   67,   74,   69,   47,   22,    7,  -10,  -31,  -56,  -75,  -77,  -66,
     -57,  -49,  -37,  -14,   16,   40,   53,   57,   61,   67,   69,   55,   30,   11,   -6,  -25,
     -47,  -69,  -78,  -70,  -59,  -51,  -40,  -20,   10,   34,   51,   58,   59,   63,   66,   59,
      36,   14,   -2,  -19,  -40,  -61,  -75,  -71,  -59,  -51,  -41,  -27,   -2,   26,   47,   58,
      58,   59,   64,   63,   46,   19,   -2,  -17,  -35,  -56,  -71,  -75,  -64,  -50,  -40,  -26,
      -6,   21,   43,   55,   57,   56,   58,   59,   47,   23,    1,  -13,  -29,  -48,  -63,  -69,
     -61,  -48,  -40,  -29,  -11,   13,   35,   48,   53,   51,   53,   57,   50,   33,    9,  -10,
     -25,  -42,  -56,  -65,  -64,  -51,  -40,  -29,  -13,    9,   30,   44,   50,   48,   47,   50,
      46,   35,   13,   -8,  -20,  -33,  -47,  -57,  -56,  -48,  -38,  -30,  -16,    1,   21,   35,
      44,   46,   42,   44,   44,   39,   21,   -3,  -18,  -30,  -40,  -51,  -57,  -51,  -37,  -26,
     -14,    0,   16,   33,   42,   43,   37,   34,   37,   35,   22,    1,  -17,  -27,  -34,  -41,
     -48,  -45,  -36,  -25,  -11,    0,   11,   24,   34,   38,   35,   30,   29,   30,   24,    8,
     -11,  -24,  -31,  -36,  -42,  -42,  -35,  -25,  -12,   -2,    9,   21,   29,   33,   32,   27,
      25,   26,   23,    9,   -8,  -21,  -31,  -34,  -36,  -37,  -33,  -26,  -13,   -2,    8,   18,
      24,   28,   29,   27,   22,   20,   21,   14,   -2,  -17,  -27,  -30,  -31,  -33,  -32,  -26,
     -14,   -3,    6,   15,   22,   27,   26,   25,   22,   17,   17,   13,    3,  -12,  -25,  -30,
     -31,  -30,  -27,  -24,  -14,    0,    8,   16,   20,   22,   22,   21,   16,   11,   13,   13,
       3,   -8,  -21,  -27,  -26,  -25,  -25,  -23,  -12,    0,    6,   12,   18,   20,   22,   20,
      15,    9,    9,   10,    3,   -9,  -21,  -29,  -28,  -23,  -20,  -19,  -10,    3,   13,   17,
      19,   19,   21,   17,   11,    4,    1,    4,    0,   -8,  -17,  -25,  -24,  -21,  -19,  -16,
      -9,    4,   13,   17,   19,   20,   22,   19,   11,    3,   -4,   -3,   -4,  -12,  -18,  -26,
     -28,  -23,  -16,  -10,   -5,    5,   18,   25,   25,   22,   21,   19,    9,    0,   -9,  -11,
     -10,  -13,  -16,  -24,  -27,  -22,  -14,   -8,   -2,    7,   17,   25,   25,   22,   20,   17,
      10,   -2,  -10,  -12,  -13,  -15,  -18,  -20,  -24,  -22,  -16,   -8,    3,   11,   17,   25,
      27,   23,   21,   17,    9,    0,  -10,  -12,  -13,  -18,  -19,  -20,  -24,  -23,  -17,  -10,
       0,   11,   19,   26,   30,   26,   24,   20,   12,    3,   -8,  -15,  -18,  -22,  -25,  -25,
     -25,  -24,  -20,  -12,    2,   15,   20,   25,   31,   33,   29,   23,   12,    3,   -5,  -15,
     -23,  -28,  -28,  -25,  -22,  -22,  -18,  -10,    2,   15,   19,   23,   30,   32,   28,   24,
      15,    7,    1,  -13,  -23,  -27,  -29,  -28,  -26,  -24,  -20,  -14,   -2,   13,   20,   24,
      32,   34,   32,   29,   22,    9,   -2,  -10,  -21,  -30,  -34,  -34,  -29,  -22,  -20,  -18,
      -5,   14,   23,   25,   31,   36,   35,   30,   22,   10,    0,   -8,  -21,  -34,  -39,  -36,
     -32,  -27,  -20,  -15,   -5,   14,   27,   28,   32,   36,   35,   33,   25,   14,    0,  -11,
     -21,  -34,  -40,  -41,  -39,  -30,  -20,  -13,   -6,   10,   27,   30,   32,   35,   34,   36,
      29,   17,    5,   -7,  -16,  -33,  -45,  -45,  -43,  -33,  -24,  -18,   -9,    8,   26,   32,
      33,   39,   38,   36,   31,   20,   10,   -6,  -19,  -32,  -45,  -47,  -46,  -39,  -25,  -12,
      -3,    8,   22,   32,   32,   35,   35,   32,   31,   23,   14,    0,  -15,  -26,  -43,  -51,
     -50,  -43,  -29,  -17,   -6,    5,   19,   34,   36,   33,   37,   37,   34,   25,   16,    5,
     -11,  -26,  -41,  -51,  -55,  -51,  -36,  -21,   -7,    7,   16,   28,   37,   35,   35,   36,
      34,   30,   20,    9,   -7,  -22,  -37,  -49,  -56,  -54,  -42,  -25,  -11,    2,   13,   24,
      35,   38,   37,   38,   37,   32,   25,   16,    1,  -21,  -38,  -47,  -56,  -58,  -50,  -34,
     -14,    4,   13,   20,   31,   40,   39,   35,   36,   34,   28,   20,    5,  -15,  -33,  -44,
     -55,  -63,  -54,  -38,  -19,   -2,   10,   17,   30,   40,   41,   36,   38,   41,   33,   22,
       9,  -13,  -36,  -50,  -55,  -63,  -61,  -44,  -22,    2,   18,   22,   28,   38,   42,   39,
      34,   35,   34,   27,   14,   -7,  -29,  -43,  -51,  -60,  -63,  -50,  -30,  -10,    8,   16,
      21,   32,   40,   40,   38,   39,   41,   35,   24,    6,  -20,  -41,  -54,  -62,  -65,  -58,
     -39,  -16,    7,   18,   22,   29,   39,   43,   40,   35,   38,   37,   27,   12,  -14,  -37,
     -51,  -58,  -64,  -64,  -47,  -22,   -2,   14,   18,   24,   36,   44,   45,   41,   43,   43,
      32,   17,   -8,  -35,  -54,  -63,  -67,  -68,  -56,  -29,   -4,   16,   24,   26,   35,   44,
      47,   43,   38,   38,   36,   24,    0,  -30,  -50,  -57,  -59,  -63,  -61,  -40,  -11,   11,
      20,   20,   26,   39,   48,   46,   40,   39,   42,   33,   12,  -20,  -47,  -58,  -60,  -62,
     -61,  -49,  -23,    2,   17,   21,   22,   33,   48,   51,   45,   43,   43,   38,   20,  -10,
     -41,  -58,  -61,  -64,  -62,  -55,  -35,   -9,   10,   21,   23,   32,   50,   57,   49,   45,
      45,   43,   26,   -6,  -38,  -58,  -62,  -65,  -67,  -61,  -44,  -15,   10,   23,   26,   28,
      44,   59,   55,   46,   42,   41,   33,    6,  -30,  -57,  -64,  -62,  -64,  -62,  -50,  -26,
       2,   18,   26,   28,   39,   59,   60,   48,   43,   43,   37,   14,  -22,  -53,  -67,  -63,
     -65,  -66,  -55,  -33,   -2,   19,   28,   31,   37,   55,   64,   53,   41,   39,   37,   20,
     -16,  -48,  -66,  -65,  -62,  -66,  -60,  -43,  -12,   15,   26,   31,   37,   53,   69,   63,
      46,   39,   38,   27,   -5,  -44,  -72,  -73,  -65,  -65,  -63,  -52,  -24,   11,   31,   36,
      38,   48,   65,   70,   53,   38,   34,   28,    5,  -35,  -69,  -78,  -70,  -65,  -63,  -53,
     -30,    2,   26,   38,   43,   49,   62,   69,   58,   40,   33,   28,    9,  -25,  -61,  -78,
     -75,  -69,  -64,  -55,  -37,   -7,   22,   36,   43,   49,   57,   66,   62,   44,   31,   29,
      15,  -16,  -52,  -76,  -77,  -69,  -63,  -57,  -44,  -16,   14,   33,   42,   48,   54,   65,
      68,   52,   33,   27,   19,   -6,  -41,  -72,  -82,  -74,  -65,  -59,  -48,  -24,    7,   29,
      43,   50,   53,   60,   67,   58,   39,   28,   22,    2,  -31,  -64,  -82,  -79,  -71,  -61,
     -49,  -31,   -2,   22,   40,   51,   55,   58,   65,   63,   46,   29,   21,    9,  -21,  -56,
     -79,  -83,  -77,  -65,  -54,  -37,  -10,   16,   36,   50,   57,   60,   65,   64,   50,   33,
      22,   11,  -13,  -47,  -73,  -82,  -80,  -70,  -57,  -42,  -19,    8,   30,   49,   58,   61,
      62,   64,   56,   41,   24,   11,   -6,  -35,  -66,  -80,  -82,  -75,  -61,  -45,  -25,   -2,
      22,   43,   57,   63,   64,   63,   58,   49,   31,   15,   -2,  -26,  -58,  -79,  -85,  -81,
     -66,  -49,  -31,   -9,   17,   39,   55,   64,   69,   67,   61,   53,   35,   16,    1,  -20,
     -49,  -75,  -86,  -85,  -74,  -54,  -34,  -11,   11,   33,   53,   64,   70,   68,   59,   51,
      40,   22,    5,  -15,  -40,  -66,  -79,  -81,  -78,  -63,  -41,  -19,    4,   25,   44,   58,
      67,   72,   65,   57,   47,   29,   11,   -8,  -31,  -61,  -81,  -85,  -82,  -68,  -47,  -25,
      -3,   21,   44,   59,   68,   73,   68,   56,   47,   33,   15,   -7,  -27,  -52,  -76,  -82,
     -82,  -72,  -52,  -30,   -7,   13,   36,   57,   67,   74,   72,   61,   48,   36,   20,   -4,
     -25,  -47,  -71,  -81,  -81,  -75,  -56,  -33,  -10,   11,   30,   49,   63,   73,   74,   63,
      48,   37,   25,    6,  -20,  -41,  -63,  -79,  -81,  -77,  -65,  -43,  -19,    4,   25,   45,
      63,   73,   76,   70,   55,   41,   28,   10,  -15,  -38,  -59,  -77,  -83,  -79,  -70,  -49,
     -25,   -4,   20,   40,   59,   74,   76,   73,   62,   46,   33,   16,  -10,  -34,  -51,  -68,
     -83,  -85,  -75,  -58,  -34,  -11,   14,   35,   55,   73,   79,   76,   69,   51,   33,   20,
      -2,  -30,  -53,  -67,  -81,  -84,  -76,  -61,  -39,  -14,   11,   32,   49,   67,   77,   74,
      68,   55,   37,   23,    5,  -22,  -45,  -59,  -73,  -84,  -82,  -68,  -46,  -24,    3,   26,
      43,   62,   75,   74,   72,   61,   42,   25,   10,  -15,  -40,  -57,  -70,  -83,  -84,  -71,
     -49,  -28,   -6,   20,   41,   59,   72,   72,   69,   63,   48,   29,   13,   -8,  -31,  -51,
     -66,  -79,  -84,  -75,  -56,  -37,  -16,   12,   36,   55,   71,   74,   72,   69,   54,   34,
      16,   -5,  -28,  -47,  -61,  -75,  -85,  -80,  -60,  -38,  -20,    4,   30,   53,   68,   71,
      69,   67,   57,   39,   20,    0,  -21,  -41,  -58,  -71,  -79,  -79,  -66,  -45,  -25,   -3,
      23,   45,   61,   68,   69,   70,   63,   47,   29,    8,  -16,  -37,  -56,  -71,  -80,  -81,
     -71,  -52,  -30,   -7,   17,   41,   60,   67,   67,   68,   65,   50,   30,   10,  -14,  -31,
     -47,  -65,  -77,  -79,  -70,  -53,  -33,  -14,    8,   34,   56,   62,   62,   66,   64,   54,
      36,   15,   -8,  -27,  -42,  -61,  -73,  -75,  -70,  -56,  -36,  -14,    5,   26,   49,   60,
      59,   61,   60,   54,   42,   23,   -2,  -22,  -35,  -53,  -69,  -75,  -70,  -58,  -41,  -20,
      -3,   18,   43,   59,   57,   57,   60,   56,   44,   28,    7,  -17,  -32,  -47,  -63,  -73,
     -72,  -62,  -46,  -23,   -6,   12,   35,   55,   60,   57,   59,   56,   49,   35,   14,  -13,
     -28,  -40,  -58,  -72,  -73,  -62,  -50,  -31,  -13,    5,   30,   51,   59,   56,   58,   61,
      56,   38,   17,   -9,  -26,  -37,  -52,  -68,  -74,  -63,  -50,  -32,  -14,    1,   22,   45,
      57,   56,   51,   54,   54,   41,   21,   -4,  -22,  -31,  -44,  -59,  -69,  -63,  -48,  -36,
     -21,   -7,   11,   35,   52,   56,   53,   54,   58,   48,   30,    8,  -17,  -32,  -43,  -57,
     -68,  -69,  -56,  -39,  -22,   -8,    6,   28,   49,   57,   54,   51,   55,   52,   35,   13,
     -13,  -29,  -36,  -49,  -64,  -70,  -58,  -39,  -23,  -11,    0,   19,   43,   57,   55,   47,
      49,   55,   43,   18,   -9,  -28,  -35,  -42,  -57,  -69,  -65,  -45,  -25,  -11,    1,   14,
      37,   55,   60,   50,   45,   48,   42,   21,   -4,  -25,  -35,  -40,  -50,  -60,  -61,  -46,
     -27,  -15,   -6,    6,   25,   46,   56,   50,   43,   45,   47,   33,    9,  -15,  -30,  -37,
     -45,  -58,  -64,  -56,  -36,  -18,   -8,    4,   18,   40,   58,   59,   47,   39,   41,   35,
      12,  -15,  -32,  -38,  -39,  -46,  -57,  -55,  -37,  -17,   -7,    1,   11,   27,   48,   56,
      47,   37,   38,   38,   21,   -6,  -24,  -32,  -37,  -43,  -54,  -57,  -44,  -25,   -9,    2,
      11,   24,   44,   57,   51,   38,   32,   31,   21,   -5,  -28,  -35,  -36,  -36,  -45,  -51,
     -41,  -25,   -8,    3,    8,   17,   33,   48,   49,   37,   31,   30,   25,    7,  -18,  -30,
     -34,  -37,  -40,  -48,  -47,  -33,  -16,    1,   11,   16,   28,   42,   50,   43,   30,   25,
      22,   10,  -12,  -28,  -33,  -34,  -35,  -41,  -44,  -33,  -18,   -2,    9,   12,   20,   32,
      43,   41,   29,   24,   22,   14,   -3,  -21,  -29,  -30,  -31,  -35,  -41,  -35,  -21,   -6,
       9,   13,   18,   27,   38,   42,   29,   18,   16,   13,    4,  -15,  -27,  -28,  -27,  -28,
     -34,  -34,  -23,  -10,    5,   11,   14,   22,   32,   37,   31,   20,   16,   12,    6,   -9,
     -22,  -25,  -27,  -26,  -32,  -34,  -27,  -15,    0,   10,   12,   18,   28,   36,   35,   23,
      14,   11,    8,   -3,  -19,  -28,  -28,  -25,  -27,  -32,  -28,  -16,   -2,   11,   14,   14,
      22,   30,   31,   24,   15,   11,    8,    2,  -11,  -22,  -25,  -25,  -26,  -30,  -28,  -18,
      -7,    5,   12,   14,   19,   27,   30,   26,   19,   13,    9,    4,   -6,  -20,  -26,  -23,
     -24,  -27,  -27,  -19,   -6,    4,   12,   12,   13,   22,   26,   22,   15,   11,   10,    6,
      -2,  -12,  -19,  -19,  -21,  -25,  -25,  -20,  -11,   -3,    5,    9,   13,   19,   24,   24,
      21,   15,   12,    7,    2,   -9,  -20,  -22,  -22,  -23,  -24,  -22,  -11,   -2,    7,   11,
      13,   17,   21,   21,   18,   13,   11,    7,    1,   -7,  -15,  -19,  -19,  -21,  -20,  -18,
     -12,   -4,    2,    8,   11,   15,   17,   16,   15,   13,   11,    8,    4,   -3,  -11,  -16,
     -15,  -19,  -20,  -16,  -12,   -5,    2,    5,    8,   14,   17,   15,   11,   10,    9,    8,
       4,   -2,   -6,  -11,  -12,  -14,  -18,  -13,   -7,   -6,   -3,    2,    6,   10,   13,   13,
       9,    8,    9,    6,    1,    0,   -5,   -9,  -12,  -12,  -13,  -12,   -4,    1,    3,    4,
       4,    7,   11,   10,    7,    3,    3,    4,    2,   -2,   -3,   -6,   -7,   -6,   -6,   -8,
      -5,    2,    1,    1,    0,    1,    5,    5,    3,    0,    0,    5,    5,    2,    3,    0,
      -3,   -5,   -6,   -8,   -7,   -2,   -3,   -4,   -2,   -2,    3,    6,    4,    1,   -3,    1,
       5,    3,    2,    0,   -2,   -3,   -4,   -5,   -5,    1,    2,   -3,   -3,   -4,   -3,    4,
       4,    0,   -5,   -3,    3,    3,    2,    1,    1,    0,    0,    0,   -3,   -2,    1,   -2,
      -4,   -3,   -4,    1,    5,    2,   -5,   -7,   -2,    2,   -2,   -2,    0,    2,    3,    2,
       2,    3,    6,    4,   -2,   -5,   -6,   -2,    3,   -2,   -9,  -11,   -5,    0,   -3,   -4,
      -2,    3,    7,    8,    4,    2,    4,    3,    0,   -6,   -8,   -6,    2,    4,   -3,  -10,
     -10,   -5,   -2,   -4,   -5,   -3,    5,   11,   11,    8,    5,    5,    4,   -2,   -9,   -9,
      -2,    0,   -5,  -13,  -14,  -10,   -5,   -4,   -2,    2,    6,   14,   15,   11,    8,    6,
       1,   -5,  -10,  -12,   -6,    1,   -2,  -10,  -15,  -11,   -4,   -3,   -6,   -5,    2,   14,
      19,   14,   10,   10,    8,    3,   -6,  -15,  -12,   -4,   -4,  -12,  -18,  -17,  -10,   -2,
       0,    1,    6,   16,   25,   21,   12,    8,    4,   -2,   -8,  -18,  -20,  -11,   -6,   -9,
     -14,  -14,  -10,   -3,    0,    1,    6,   13,   23,   25,   17,   13,    9,    1,   -6,  -13,
     -18,  -14,  -11,  -13,  -17,  -19,  -14,   -8,   -3,    1,    7,   14,   24,   30,   24,   16,
      12,    4,   -5,  -11,  -18,  -19,  -15,  -12,  -14,  -19,  -18,  -14,   -9,    0,    8,   13,
      19,   27,   28,   22,   18,    9,   -4,  -11,  -14,  -16,  -15,  -16,  -16,  -17,  -16,  -14,
     -13,   -6,    4,   12,   19,   26,   31,   27,   19,   13,    3,   -8,  -12,  -16,  -18,  -19,
     -17,  -16,  -20,  -18,  -15,  -10,    1,   10,   18,   24,   31,   30,   22,   18,    9,   -4,
     -10,  -14,  -17,  -20,  -22,  -19,  -19,  -22,  -18,  -13,   -2,    9,   16,   21,   29,   36,
      29,   19,   12,    1,   -7,  -10,  -15,  -22,  -24,  -20,  -18,  -21,  -21,  -17,   -8,    7,
      16,   23,   27,   33,   35,   26,   17,    7,   -5,  -11,  -14,  -22,  -27,  -24,  -19,  -22,
     -25,  -19,  -11,    5,   16,   21,   25,   33,   38,   31,   18,    9,   -2,  -10,  -13,  -22,
     -29,  -28,  -21,  -18,  -24,  -22,  -15,   -3,   14,   21,   24,   30,   38,   36,   24,   13,
       4,   -5,   -9,  -16,  -28,  -32,  -25,  -21,  -25,  -27,  -18,   -7,    8,   18,   24,   31,
      40,   40,   29,   16,    6,   -3,   -8,  -16,  -27,  -31,  -27,  -22,  -24,  -27,  -21,  -10,
       4,   16,   22,   28,   37,   40,   33,   19,    7,    1,   -5,  -12,  -23,  -32,  -28,  -23,
     -23,  -27,  -26,  -15,   -2,   13,   21,   25,   34,   41,   38,   28,   14,    4,   -3,  -11,
     -22,  -34,  -35,  -30,  -26,  -28,  -29,  -20,   -3,   14,   24,   27,   32,   41,   42,   34,
      17,    4,   -4,  -11,  -20,  -32,  -38,  -33,  -28,  -27,  -27,  -22,   -9,    7,   20,   29,
      34,   39,   40,   37,   24,   10,    2,   -7,  -16,  -28,  -40,  -40,  -33,  -29,  -28,  -27,
     -16,    5,   21,   28,   32,   36,   41,   40,   30,   12,    1,   -6,  -11,  -22,  -37,  -42,
     -34,  -30,  -29,  -27,  -20,   -3,   16,   27,   32,   34,   39,   41,   35,   20,    6,   -4,
     -11,  -16,  -32,  -45,  -41,  -33,  -31,  -27,  -23,  -10,   13,   28,   33,   35,   38,   39,
      36,   25,    8,   -6,  -11,  -14,  -26,  -42,  -45,  -34,  -29,  -25,  -23,  -15,    6,   26,
      36,   36,   36,   37,   36,   29,   14,   -2,  -12,  -14,  -23,  -42,  -50,  -42,  -32,  -23,
     -18,  -15,    3,   25,   38,   39,   35,   35,   37,   33,   18,   -3,  -15,  -18,  -20,  -34,
     -48,  -47,  -34,  -22,  -14,  -12,   -4,   17,   35,   41,   37,   34,   33,   33,   24,    6,
     -13,  -22,  -22,  -30,  -45,  -51,  -39,  -23,  -10,   -6,   -3,   13,   32,   41,   37,   30,
      29,   31,   27,   10,  -10,  -22,  -23,  -26,  -38,  -48,  -44,  -28,  -12,   -5,   -3,    9,
      27,   38,   38,   32,   28,   29,   27,   17,   -4,  -21,  -26,  -27,  -35,  -47,  -49,  -33,
     -12,    2,    5,    9,   23,   35,   40,   34,   21,   23,   25,   22,    5,  -20,  -28,  -28,
     -29,  -39,  -50,  -43,  -19,    3,   10,    7,   15,   29,   41,   43,   28,   22,   23,   22,
      12,  -16,  -33,  -32,  -32,  -38,  -46,  -43,  -21,    3,   15,   13,   16,   29,   35,   35,
      27,   19,   19,   19,   15,   -8,  -30,  -31,  -30,  -32,  -40,  -44,  -29,   -2,   18,   17,
      11,   22,   34,   37,   32,   21,   18,   20,   17,   -2,  -28,  -37,  -34,  -34,  -38,  -42,
     -30,   -7,   16,   22,   16,   20,   31,   31,   29,   23,   17,   18,   19,    6,  -21,  -37,
     -35,  -34,  -35,  -38,  -35,  -15,   14,   27,   21,   13,   23,   31,   31,   26,   16,   12,
      16,   12,  -10,  -35,  -39,  -35,  -36,  -36,  -34,  -21,    6,   24,   24,   16,   20,   29,
      28,   27,   22,   16,   17,   15,   -4,  -29,  -41,  -39,  -40,  -39,  -36,  -29,   -6,   20,
      27,   21,   19,   28,   33,   31,   27,   18,   14,   13,    2,  -22,  -41,  -43,  -40,  -39,
     -34,  -28,  -12,   16,   28,   24,   19,   25,   29,   27,   24,   19,   15,   12,    4,  -15,
     -34,  -41,  -40,  -37,  -32,  -26,  -18,    5,   24,   24,   20,   21,   26,   27,   26,   24,
      18,   12,    6,   -9,  -30,  -44,  -45,  -41,  -33,  -26,  -19,   -2,   23,   29,   24,   22,
      24,   28,   25,   22,   18,   13,    7,   -7,  -24,  -40,  -46,  -42,  -36,  -28,  -21,   -6,
      15,   28,   25,   22,   25,   29,   28,   23,   20,   14,    6,   -6,  -22,  -40,  -47,  -42,
     -36,  -28,  -23,  -10,   13,   30,   28,   21,   23,   27,   28,   21,   18,   16,    9,   -2,
     -17,  -33,  -44,  -44,  -38,  -31,  -23,  -14,    5,   25,   32,   25,   23,   26,   29,   24,
      16,   13,    8,   -2,  -15,  -31,  -43,  -44,  -37,  -30,  -23,  -14,    1,   21,   31,   27,
      22,   24,   28,   25,   17,   13,   10,    3,  -10,  -27,  -40,  -44,  -38,  -32,  -26,  -17,
      -3,   16,   31,   31,   25,   25,   30,   29,   17,    8,    7,    3,   -8,  -25,  -39,  -43,
     -37,  -31,  -27,  -18,   -4,   13,   29,   32,   26,   24,   27,   27,   17,    9,    8,    6,
      -5,  -20,  -34,  -39,  -37,  -34,  -30,  -21,   -8,    6,   23,   34,   31,   29,   28,   27,
      22,   13,    6,    5,   -4,  -18,  -34,  -40,  -37,  -34,  -29,  -23,  -10,    5,   21,   32,
      29,   27,   29,   26,   20,   12,    4,    3,    0,  -12,  -28,  -37,  -35,  -31,  -29,  -23,
     -13,    1,   16,   30,   33,   29,   27,   25,   21,   15,    5,   -2,   -3,   -9,  -22,  -35,
     -36,  -31,  -29,  -24,  -14,    0,   12,   27,   35,   31,   29,   26,   21,   16,    8,   -2,
      -3,   -7,  -19,  -34,  -36,  -32,  -31,  -28,  -18,   -3,   11,   22,   32,   32,   30,   29,
      23,   16,   11,    2,   -3,   -6,  -17,  -32,  -37,  -32,  -30,  -31,  -23,   -6,    9,   18,
      30,   36,   32,   31,   25,   17,   13,    4,   -6,   -8,  -14,  -26,  -36,  -34,  -31,  -31,
     -25,  -11,    6,   16,   24,   34,   35,   33,   28,   17,   16,   10,   -3,   -9,  -13,  -23,
     -34,  -36,  -32,  -31,  -27,  -16,    2,   16,   22,   30,   35,   33,   30,   21,   15,   11,
       0,   -7,  -11,  -20,  -31,  -35,  -31,  -31,  -29,  -21,   -6,   13,   21,   25,   32,   34,
      33,   26,   18,   13,    4,   -6,  -10,  -19,  -29,  -34,  -34,  -29,  -27,  -24,  -12,    7,
      20,   25,   30,   33,   32,   29,   21,   13,    7,   -5,  -11,  -18,  -28,  -35,  -36,  -29,
     -25,  -24,  -16,    3,   21,   26,   28,   34,   37,   34,   26,   12,    4,   -5,  -13,  -20,
     -30,  -35,  -39,  -35,  -24,  -19,  -13,   -2,   15,   27,   30,   32,   34,   31,   28,   18,
       5,   -6,  -15,  -20,  -24,  -31,  -37,  -35,  -24,  -19,  -16,   -9,    8,   24,   30,   30,
      33,   35,   35,   24,    5,   -5,  -11,  -20,  -27,  -34,  -40,  -39,  -30,  -21,  -16,   -9,
       4,   20,   32,   36,   36,   36,   35,   31,   13,   -3,  -13,  -23,  -27,  -29,  -41,  -44,
     -33,  -19,  -11,  -10,   -4,   14,   32,   38,   34,   33,   36,   33,   18,   -4,  -13,  -20,
     -25,  -28,  -37,  -43,  -34,  -22,  -14,   -8,   -4,    9,   26,   39,   38,   35,   35,   34,
      23,    3,  -12,  -21,  -28,  -28,  -31,  -41,  -40,  -27,  -15,   -7,   -6,    2,   20,   37,
      42,   36,   34,   35,   28,    9,  -10,  -18,  -24,  -26,  -29,  -38,  -42,  -32,  -21,  -11,
      -6,   -3,   12,   33,   45,   41,   37,   37,   29,   13,   -4,  -17,  -26,  -28,  -28,  -33,
     -39,  -37,  -26,  -15,   -8,   -7,    6,   29,   47,   46,   39,   34,   30,   20,    1,  -18,
     -26,  -26,  -25,  -29,  -37,  -40,  -31,  -17,   -8,   -7,    0,   20,   42,   51,   45,   38,
      30,   18,    7,  -10,  -24,  -27,  -26,  -24,  -29,  -38,  -37,  -27,  -14,   -9,   -6,   11,
      36,   51,   47,   42,   34,   24,   14,   -3,  -20,  -25,  -23,  -22,  -26,  -37,  -42,  -33,
     -17,   -8,   -7,    4,   28,   50,   54,   45,   35,   24,   15,    3,  -16,  -24,  -25,  -22,
     -23,  -32,  -41,  -37,  -22,  -11,   -8,    0,   21,   44,   54,   46,   34,   26,   18,    7,
     -11,  -22,  -21,  -20,  -21,  -28,  -40,  -43,  -30,  -15,  -10,   -3,   16,   40,   56,   52,
      37,   24,   16,    9,   -6,  -21,  -22,  -18,  -17,  -22,  -35,  -43,  -34,  -21,  -14,   -9,
       7,   34,   53,   54,   40,   29,   21,   14,    4,  -14,  -21,  -17,  -17,  -22,  -33,  -46,
     -45,  -31,  -16,   -8,    4,   25,   50,   60,   49,   31,   20,   15,    9,   -5,  -17,  -18,
     -15,  -17,  -26,  -42,  -50,  -40,  -24,  -11,   -2,   18,   43,   56,   52,   35,   21,   17,
      11,    0,  -12,  -18,  -14,  -15,  -22,  -36,  -50,  -46,  -30,  -15,   -3,   12,   35,   53,
      55,   41,   24,   18,   12,    5,   -4,  -15,  -18,  -15,  -20,  -33,  -46,  -49,  -37,  -21,
      -7,    7,   25,   46,   54,   45,   27,   18,   14,   10,    3,   -8,  -15,  -16,  -18,  -28,
     -41,  -49,  -44,  -29,  -12,    4,   17,   35,   49,   49,   34,   19,   16,   15,    9,    1,
     -10,  -14,  -16,  -24,  -38,  -50,  -49,  -36,  -18,   -3,   10,   26,   43,   49,   38,   22,
      18,   20,   16,    9,   -5,  -13,  -16,  -23,  -36,  -50,  -53,  -43,  -25,   -8,    6,   21,
      38,   48,   44,   27,   19,   21,   19,   13,   -2,  -13,  -17,  -21,  -30,  -45,  -52,  -46,
     -29,  -10,    3,   14,   29,   42,   44,   30,   17,   19,   21,   17,    6,   -8,  -14,  -19,
     -26,  -39,  -49,  -48,  -36,  -18,   -2,   11,   27,   37,   42,   37,   22,   18,   21,   19,
       9,   -5,  -13,  -18,  -24,  -33,  -45,  -46,  -39,  -24,   -8,    6,   20,   33,   40,   38,
      27,   19,   22,   23,   17,    4,   -8,  -14,  -22,  -29,  -43,  -48,  -43,  -32,  -16,   -2,
      13,   25,   34,   39,   33,   23,   21,   23,   20,    9,   -4,  -11,  -19,  -25,  -33,  -43,
     -42,  -34,  -20,   -7,    3,   14,   24,   32,   31,   22,   20,   26,   28,   20,    6,   -5,
     -11,  -18,  -28,  -42,  -44,  -38,  -28,  -15,   -5,    8,   19,   28,   31,   24,   21,   25,
      27,   22,   10,    0,   -6,  -12,  -22,  -34,  -38,  -34,  -30,  -20,  -11,    0,   11,   20,
      26,   23,   19,   22,   27,   25,   17,    7,   -2,   -7,  -17,  -29,  -35,  -35,  -34,  -26,
     -16,   -5,    7,   15,   23,   28,   24,   21,   22,   24,   20,   11,   -2,   -8,  -14,  -24,
     -29,  -31,  -31,  -27,  -18,   -9,    0,    8,   15,   22,   23,   20,   21,   24,   24,   19,
       7,   -4,  -10,  -19,  -26,  -32,  -34,  -33,  -24,  -12,   -2,    6,   14,   22,   26,   23,
      22,   22,   22,   21,   10,    0,   -6,  -15,  -21,  -24,  -28,  -31,  -28,  -17,   -7,    2,
       7,   13,   19,   23,   23,   21,   19,   21,   18,    8,   -2,  -11,  -17,  -21,  -24,  -30,
     -33,  -25,  -11,    0,    4,    9,   16,   20,   21,   20,   18,   18,   20,   14,    4,   -6,
     -12,  -15,  -17,  -25,  -32,  -32,  -20,   -6,   -3,   -3,    7,   18,   23,   19,   16,   19,
      26,   24,   11,    0,   -6,   -9,  -15,  -25,  -33,  -35,  -26,  -15,   -9,   -6,    5,   17,
      22,   21,   17,   18,   25,   26,   16,    4,   -5,   -7,   -9,  -18,  -29,  -38,  -35,  -21,
     -11,   -9,   -4,    9,   22,   25,   20,   16,   22,   30,   24,    8,   -4,   -5,   -5,  -13,
     -25,  -36,  -38,  -26,  -16,  -11,  -10,    2,   19,   25,   18,   12,   19,   30,   28,   14,
       1,   -2,    3,   -3,  -17,  -31,  -36,  -29,  -21,  -18,  -19,  -11,    7,   20,   16,   10,
      16,   30,   36,   24,    8,    4,    8,    6,  -12,  -32,  -40,  -35,  -26,  -21,  -20,  -14,
       2,   19,   20,   10,   12,   24,   35,   29,   13,    5,    7,    9,   -3,  -23,  -37,  -37,
     -31,  -23,  -21,  -19,   -8,   12,   19,   10,    6,   19,   36,   37,   23,   11,   12,   16,
       7,  -15,  -35,  -43,  -38,  -30,  -27,  -23,  -16,    2,   18,   16,    7,   13,   30,   38,
      29,   17,   12,   16,   15,   -4,  -27,  -40,  -39,  -32,  -28,  -28,  -24,   -8,   12,   14,
       5,    7,   26,   40,   36,   24,   18,   21,   21,    4,  -20,  -38,  -41,  -37,  -34,  -30,
     -26,  -15,    4,   14,    7,    3,   18,   37,   41,   33,   24,   22,   25,   14,  -10,  -33,
     -44,  -42,  -36,  -32,  -29,  -22,   -6,   10,    9,    2,    9,   29,   40,   37,   32,   28,
      29,   21,    0,  -24,  -39,  -44,  -44,  -38,  -31,  -24,  -16,    0,    7,    3,    8,   24,
      38,   43,   41,   32,   28,   25,    9,  -15,  -34,  -44,  -44,  -39,  -31,  -26,  -20,  -10,
       3,    2,    1,   14,   32,   44,   46,   39,   33,   31,   20,   -7,  -31,  -45,  -47,  -44,
     -38,  -30,  -26,  -16,    0,    5,    4,   12,   30,   45,   52,   47,   36,   30,   22,    0,
     -24,  -40,  -50,  -49,  -42,  -31,  -24,  -19,  -10,   -3,    3,   11,   24,   39,   51,   55,
      49,   37,   27,    8,  -18,  -36,  -50,  -54,  -47,  -36,  -29,  -25,  -16,   -6,    4,   10,
      18,   34,   52,   59,   53,   39,   28,   15,   -8,  -29,  -45,  -53,  -51,  -43,  -34,  -29,
     -23,  -14,   -4,    7,   17,   33,   52,   62,   61,   50,   37,   23,   -4,  -28,  -44,  -55,
     -55,  -48,  -38,  -30,  -25,  -18,   -8,    5,   13,   25,   46,   61,   65,   57,   43,   30,
       8,  -17,  -36,  -50,  -55,  -53,  -47,  -39,  -32,  -24,  -15,   -3,   11,   25,   45,   62,
      68,   63,   51,   37,   14,  -14,  -34,  -46,  -56,  -57,  -51,  -44,  -33,  -25,  -18,   -6,
       8,   19,   36,   55,   67,   65,   53,   42,   23,   -4,  -26,  -40,  -50,  -56,  -54,  -49,
     -41,  -31,  -23,  -12,    1,   15,   34,   53,   65,   68,   59,   49,   33,    6,  -21,  -37,
     -47,  -57,  -60,  -56,  -48,  -38,  -28,  -16,   -2,   14,   33,   51,   64,   70,   63,   53,
      38,   13,  -14,  -34,  -44,  -53,  -59,  -59,  -53,  -42,  -30,  -19,   -8,    5,   26,   47,
      61,   68,   64,   57,   48,   26,   -3,  -26,  -39,  -49,  -58,  -63,  -59,  -49,  -37,  -24,
     -13,    1,   20,   42,   55,   65,   69,   64,   54,   34,    7,  -18,  -34,  -44,  -55,  -65,
     -64,  -54,  -42,  -31,  -19,   -8,   12,   37,   54,   61,   67,   67,   60,   46,   22,   -8,
     -29,  -40,  -50,  -64,  -70,  -63,  -50,  -34,  -21,  -13,    2,   28,   51,   62,   68,   68,
      61,   51,   32,    3,  -23,  -36,  -47,  -60,  -70,  -67,  -58,  -44,  -27,  -14,   -2,   22,
      45,   58,   65,   70,   68,   56,   38,   16,  -11,  -32,  -45,  -58,  -69,  -70,  -62,  -52,
     -34,  -17,   -6,   13,   38,   54,   64,   70,   67,   59,   47,   29,   -2,  -28,  -40,  -51,
     -65,  -74,  -67,  -54,  -37,  -20,  -11,    5,   33,   53,   59,   63,   67,   62,   51,   34,
       7,  -20,  -35,  -46,  -59,  -72,  -70,  -60,  -46,  -27,  -12,    1,   24,   47,   60,   64,
      69,   66,   54,   39,   15,  -13,  -32,  -44,  -54,  -68,  -71,  -60,  -48,  -32,  -18,   -7,
      14,   38,   54,   61,   68,   70,   60,   46,   26,   -2,  -23,  -38,  -50,  -63,  -72,  -68,
     -55,  -39,  -24,  -13,    5,   31,   52,   61,   67,   71,   64,   53,   34,    7,  -21,  -36,
     -46,  -57,  -69,  -72,  -60,  -42,  -27,  -17,   -2,   21,   45,   58,   65,   69,   66,   57,
      42,   15,  -13,  -30,  -43,  -54,  -66,  -72,  -65,  -47,  -30,  -18,   -5,   15,   40,   57,
      64,   67,   62,   56,   46,   23,   -6,  -27,  -39,  -50,  -58,  -67,  -67,  -51,  -32,  -20,
      -9,    9,   31,   51,   60,   64,   64,   58,   48,   27,    1,  -20,  -34,  -46,  -56,  -65,
     -70,  -57,  -37,  -22,  -14,    2,   26,   48,   62,   66,   64,   59,   51,   34,    8,  -18,
     -31,  -42,  -52,  -61,  -70,  -63,  -42,  -24,  -15,   -3,   19,   43,   60,   63,   60,   57,
      52,   39,   14,  -14,  -28,  -36,  -46,  -54,  -65,  -66,  -49,  -29,  -17,   -9,   10,   33,
      54,   64,   62,   58,   53,   42,   23,   -5,  -25,  -35,  -46,  -54,  -63,  -67,  -54,  -33,
     -17,   -7,    7,   30,   51,   61,   58,   55,   51,   43,   28,    3,  -21,  -30,  -37,  -46,
     -56,  -63,  -56,  -39,  -22,  -12,   -5,   16,   40,   57,   58,   55,   53,   48,   38,   19,
     -10,  -27,  -35,  -45,  -56,  -66,  -65,  -49,  -28,  -14,   -6,    8,   34,   57,   60,   55,
      54,   50,   42,   26,   -4,  -28,  -35,  -42,  -52,  -62,  -63,  -51,  -32,  -14,   -5,    3,
      24,   47,   57,   53,   50,   47,   41,   33,   11,  -20,  -35,  -40,  -46,  -56,  -65,  -58,
     -38,  -17,   -4,    1,   15,   41,   57,   55,   47,   45,   42,   35,   17,  -13,  -33,  -38,
     -41,  -49,  -58,  -55,  -41,  -21,   -4,    0,    7,   29,   50,   52,   45,   42,   40,   37,
      25,    0,  -28,  -38,  -38,  -44,  -53,  -58,  -46,  -26,   -6,    3,    4,   18,   42,   53,
      47,   41,   39,   37,   30,   10,  -21,  -41,  -43,  -41,  -47,  -54,  -46,  -29,   -8,    7,
       9,   13,   31,   46,   45,   37,   33,   33,   28,   15,  -10,  -35,  -42,  -38,  -39,  -45,
     -46,  -32,  -10,    6,    9,    8,   19,   38,   44,   38,   30,   29,   30,   19,   -3,  -29,
     -42,  -38,  -34,  -40,  -43,  -32,  -14,    3,   11,   11,   15,   30,   41,   39,   30,   25,
      25,   19,    4,  -21,  -40,  -42,  -32,  -30,  -33,  -29,  -15,    2,   11,   10,    8,   17,
      30,   35,   30,   23,   24,   23,   11,  -11,  -32,  -43,  -34,  -26,  -29,  -29,  -18,   -3,
       9,   12,    9,   12,   26,   35,   32,   21,   18,   18,   12,   -6,  -29,  -43,  -36,  -22,
     -22,  -25,  -15,    1,   10,   11,   10,    8,   17,   29,   29,   21,   16,   17,   15,    2,
     -21,  -39,  -39,  -24,  -17,  -20,  -16,   -5,    9,   13,   10,    7,   12,   24,   28,   23,
      14,   12,   11,    4,  -14,  -33,  -39,  -28,  -15,  -14,  -12,   -6,    5,   11,    9,    7,
       7,   16,   26,   25,   16,   10,   11,    6,   -8,  -24,  -37,  -32,  -17,  -12,  -11,   -5,
       5,   11,   11,   10,    7,   12,   21,   21,   16,    7,    4,    3,   -6,  -20,  -32,  -32,
     -20,   -8,   -5,    0,    5,   11,   11,    9,    8,    8,   13,   17,   16,    9,    3,    2,
      -3,  -13,  -25,  -31,  -23,   -9,   -4,   -2,    5,   11,   14,   11,    7,    6,   12,   15,
      12,    5,   -2,   -2,   -3,  -11,  -22,  -29,  -24,   -9,    0,    3,    8,   13,   13,   12,
       8,    4,    5,    7,    9,    6,   -3,   -5,   -4,   -5,  -14,  -24,  -23,  -13,    0,    4,
       6,   10,   14,   14,    9,    3,    3,    5,    6,    4,   -4,   -6,   -5,   -5,   -9,  -18,
     -20,  -15,   -4,    6,    9,   11,   13,   13,   10,    5,    1,    0,   -3,    0,   -4,   -6,
      -6,   -5,   -4,  -11,  -16,  -16,   -9,    3,    8,   11,   11,   10,   11,    8,    3,   -2,
      -5,   -4,   -3,   -5,   -6,   -6,   -2,   -5,  -12,  -15,  -13,   -2,    8,    9,   11,   11,
      11,    7,    4,    0,   -6,   -6,   -4,   -4,   -6,   -6,   -2,    0,   -7,  -13,  -15,   -5,
       8,   13,   12,    9,   11,    9,    4,   -5,  -11,  -11,   -8,   -5,   -5,   -5,    0,    4,
       3,   -4,  -11,   -8,    3,   11,   12,    8,    7,    4,    2,   -2,  -10,  -14,  -13,   -7,
      -3,   -4,   -2,    3,    4,    1,   -8,   -8,    3,   13,   17,   12,   11,    7,    1,   -6,
     -16,  -21,  -19,  -13,   -7,   -2,    3,    7,   10,   10,    1,   -6,   -2,    8,   14,   12,
      10,    4,   -2,   -6,  -15,  -21,  -20,  -15,   -8,   -2,    3,    5,    9,   14,    5,   -6,
       1,   12,   18,   14,    9,    7,    2,   -4,  -18,  -28,  -27,  -22,  -12,   -5,    3,    9,
      13,   18,   16,    5,    1,    7,   14,   13,    8,    5,   -5,   -9,  -17,  -26,  -26,  -23,
     -15,   -4,    5,    8,   11,   17,   17,    7,    2,    7,   16,   18,   10,    4,   -2,   -6,
     -16,  -31,  -33,  -27,  -18,   -9,    0,    7,   12,   18,   22,   16,    9,    9,   16,   20,
      13,    5,   -2,   -9,  -18,  -33,  -37,  -29,  -22,  -13,   -4,    7,   15,   21,   25,   21,
      15,   13,   17,   20,   14,    5,   -3,   -8,  -18,  -35,  -42,  -36,  -24,  -16,   -6,    5,
      13,   23,   27,   25,   20,   17,   19,   20,   15,    5,   -3,   -8,  -21,  -35,  -45,  -39,
     -25,  -18,  -11,    3,   16,   25,   29,   27,   26,   24,   23,   21,   17,    8,   -4,  -12,
     -23,  -35,  -46,  -46,  -34,  -22,  -15,   -3,   13,   25,   31,   33,   34,   31,   28,   25,
      20,   11,   -4,  -12,  -22,  -38,  -49,  -51,  -39,  -26,  -21,  -11,    8,   24,   34,   35,
      36,   37,   35,   29,   21,   13,    0,  -11,  -20,  -36,  -48,  -52,  -46,  -31,  -22,  -14,
       1,   19,   34,   38,   39,   40,   38,   34,   24,   15,    0,  -14,  -21,  -34,  -47,  -53,
     -50,  -35,  -22,  -17,   -5,   13,   31,   37,   38,   42,   41,   37,   28,   21,    9,   -8,
     -19,  -30,  -44,  -50,  -53,  -46,  -32,  -23,  -11,    7,   26,   39,   43,   49,   48,   42,
      32,   20,    9,   -9,  -21,  -31,  -46,  -52,  -54,  -50,  -35,  -24,  -13,    4,   23,   40,
      46,   48,   49,   46,   37,   26,   13,   -4,  -20,  -29,  -42,  -50,  -53,  -54,  -43,  -31,
     -21,   -2,   17,   36,   47,   53,   56,   51,   42,   29,   17,    3,  -16,  -30,  -41,  -51,
     -55,  -57,  -51,  -35,  -24,   -9,   11,   30,   47,   53,   57,   55,   46,   34,   20,    6,
     -12,  -29,  -43,  -52,  -55,  -55,  -55,  -42,  -29,  -12,    8,   25,   41,   55,   62,   59,
      51,   37,   23,   10,   -6,  -24,  -40,  -51,  -56,  -58,  -58,  -48,  -33,  -19,    2,   22,
      41,   55,   61,   61,   56,   45,   28,   11,   -3,  -19,  -37,  -51,  -57,  -58,  -58,  -54,
     -39,  -23,   -2,   20,   36,   52,   64,   65,   58,   48,   33,   19,    4,  -13,  -35,  -51,
     -58,  -61,  -62,  -60,  -47,  -29,   -7,   17,   34,   50,   67,   70,   62,   50,   35,   20,
       6,   -8,  -29,  -47,  -57,  -62,  -61,  -60,  -54,  -37,  -15,   10,   29,   44,   60,   68,
      66,   56,   42,   24,   12,    1,  -19,  -41,  -55,  -60,  -62,  -61,  -57,  -43,  -21,    7,
      24,   36,   53,   66,   67,   59,   46,   30,   15,    5,  -11,  -32,  -48,  -58,  -63,  -62,
     -59,  -50,  -32,   -3,   22,   35,   49,   60,   66,   63,   53,   38,   19,    8,   -5,  -25,
     -43,  -57,  -64,  -64,  -62,  -54,  -39,  -13,   16,   32,   46,   59,   65,   66,   56,   45,
      26,   11,    3,  -17,  -39,  -56,  -65,  -67,  -62,  -56,  -44,  -21,   10,   29,   40,   54,
      63,   68,   61,   49,   33,   13,    2,  -14,  -34,  -50,  -64,  -67,  -63,  -56,  -44,  -26,
       2,   27,   38,   49,   57,   64,   61,   50,   36,   17,    6,   -7,  -27,  -44,  -60,  -67,
     -63,  -57,  -48,  -32,   -7,   22,   36,   44,   53,   60,   62,   55,   41,   21,    7,   -3,
     -20,  -40,  -58,  -68,  -65,  -57,  -47,  -34,  -14,   16,   37,   42,   47,   55,   59,   53,
      42,   27,   10,   -2,  -14,  -30,  -47,  -60,  -63,  -57,  -49,  -38,  -20,    5,   30,   40,
      44,   52,   57,   57,   46,   31,   13,   -2,  -12,  -27,  -44,  -57,  -64,  -61,  -50,  -38,
     -20,    2,   25,   39,   41,   49,   55,   54,   45,   32,   17,    0,  -12,  -23,  -37,  -50,
     -59,  -61,  -52,  -38,  -22,   -6,   17,   35,   39,   42,   48,   53,   48,   36,   22,    4,
      -9,  -18,  -30,  -45,  -56,  -59,  -54,  -42,  -27,  -10,   12,   29,   37,   38,   44,   50,
      47,   37,   25,    9,   -5,  -13,  -23,  -38,  -50,  -55,  -54,  -45,  -32,  -17,    5,   25,
      34,   35,   39,   46,   48,   40,   29,   13,   -3,  -11,  -21,  -33,  -44,  -51,  -54,  -47,
     -34,  -17,    2,   21,   32,   34,   34,   38,   42,   39,   27,   15,    1,   -7,  -13,  -25,
     -36,  -45,  -49,  -46,  -36,  -23,   -6,   15,   27,   31,   31,   34,   39,   38,   30,   18,
       3,   -6,  -10,  -19,  -32,  -40,  -46,  -45,  -36,  -24,  -11,    8,   24,   29,   27,   29,
      34,   36,   30,   18,    4,   -5,   -5,  -12,  -25,  -34,  -39,  -41,  -37,  -24,  -11,    4,
      18,   24,   25,   25,   29,   29,   26,   19,    5,   -6,   -6,   -6,  -18,  -28,  -33,  -37,
     -34,  -24,  -11,    2,   15,   24,   23,   20,   24,   27,   22,   14,    4,   -4,   -4,   -5,
     -15,  -24,  -26,  -29,  -32,  -27,  -13,    2,   14,   21,   21,   18,   21,   23,   20,   13,
       5,   -3,   -5,   -4,   -9,  -16,  -21,  -25,  -28,  -25,  -14,    1,   10,   16,   19,   16,
      16,   18,   16,   11,    5,   -2,   -5,   -4,   -6,  -12,  -17,  -20,  -22,  -22,  -17,   -4,
       8,   13,   16,   15,   13,   15,   14,   10,    4,   -4,   -6,   -6,   -5,   -7,  -11,  -15,
     -17,  -17,  -15,   -3,   10,   13,   14,   11,    7,    8,    9,    5,   -3,   -8,   -7,   -4,
      -2,   -2,   -6,  -10,   -9,  -10,  -12,   -5,   11,   15,   13,   11,    5,    6,    7,    3,
      -6,  -10,   -8,   -6,   -6,   -2,    1,   -2,   -6,   -6,   -7,   -5,    8,   14,   10,    7,
       4,    0,    1,   -2,   -6,  -12,  -11,   -6,   -2,    4,    8,    4,   -2,   -2,   -4,   -5,
       3,   12,    8,    5,    4,    0,    0,   -2,   -8,  -13,  -15,  -12,   -7,   -3,    6,   10,
       7,    5,    6,    4,    6,   14,   10,    3,    0,   -6,  -10,   -7,  -10,  -16,  -19,  -15,
      -8,    0,   11,   17,   13,   10,   11,    7,    5,    8,    9,    2,   -4,   -7,  -12,  -10,
     -10,  -16,  -21,  -19,  -13,   -4,   10,   21,   22,   17,   17,   14,    9,    9,    9,    3,
      -7,  -12,  -17,  -16,  -14,  -20,  -25,  -21,  -15,   -5,   10,   23,   27,   25,   22,   18,
      11,    8,    4,   -2,   -9,  -14,  -18,  -19,  -14,  -15,  -23,  -25,  -20,  -10,    9,   22,
      29,   29,   26,   23,   16,   12,    6,    1,   -6,  -14,  -18,  -22,  -20,  -19,  -27,  -28,
     -25,  -18,    0,   19,   32,   36,   33,   31,   23,   14,    7,    1,   -4,  -15,  -23,  -25,
     -24,  -19,  -25,  -32,  -29,  -20,   -3,   16,   31,   40,   38,   36,   29,   16,    9,    1,
      -4,  -12,  -23,  -26,  -28,  -24,  -26,  -34,  -33,  -24,   -8,   12,   29,   41,   44,   44,
      37,   22,   11,    4,   -4,  -11,  -24,  -31,  -32,  -31,  -30,  -36,  -39,  -30,  -11,   11,
      29,   43,   51,   50,   44,   32,   15,    4,   -4,  -11,  -24,  -32,  -33,  -33,  -34,  -38,
     -42,  -35,  -17,    4,   24,   42,   56,   60,   52,   38,   19,    7,    1,  -13,  -28,  -37,
     -37,  -35,  -37,  -39,  -43,  -37,  -19,    3,   22,   41,   57,   64,   57,   44,   26,    7,
      -2,  -11,  -24,  -35,  -41,  -40,  -38,  -39,  -43,  -40,  -24,    0,   20,   37,   55,   65,
      63,   50,   32,    9,   -4,  -10,  -24,  -36,  -42,  -42,  -41,  -41,  -41,  -39,  -26,   -2,
      19,   34,   51,   64,   66,   55,   38,   15,   -3,   -8,  -20,  -34,  -42,  -44,  -43,  -44,
     -45,  -45,  -35,  -12,   14,   31,   50,   66,   73,   65,   49,   28,    7,   -6,  -18,  -35,
     -45,  -49,  -51,  -53,  -51,  -47,  -37,  -16,   10,   30,   49,   69,   78,   72,   56,   35,
      14,   -4,  -17,  -33,  -46,  -51,  -55,  -56,  -54,  -51,  -40,  -20,    5,   26,   44,   64,
      76,   77,   64,   41,   19,    1,  -14,  -30,  -43,  -50,  -57,  -60,  -58,  -54,  -43,  -24,
      -2,   21,   39,   61,   76,   79,   72,   52,   28,    9,  -10,  -26,  -41,  -49,  -54,  -61,
     -62,  -59,  -51,  -33,  -10,   14,   34,   55,   75,   81,   79,   63,   39,   19,   -2,  -23,
     -40,  -51,  -56,  -64,  -67,  -64,  -56,  -39,  -16,    9,   29,   51,   73,   83,   82,   73,
      50,   27,    9,  -18,  -40,  -52,  -56,  -63,  -69,  -69,  -61,  -43,  -20,    2,   21,   42,
      66,   81,   82,   76,   59,   36,   19,   -6,  -33,  -50,  -57,  -61,  -71,  -76,  -68,  -52,
     -28,   -2,   17,   36,   62,   83,   86,   82,   69,   43,   22,    2,  -28,  -51,  -60,  -63,
     -67,  -76,  -74,  -57,  -34,   -7,   14,   29,   53,   76,   87,   84,   75,   54,   33,   14,
     -18,  -46,  -58,  -62,  -69,  -80,  -84,  -68,  -44,  -18,    7,   26,   49,   75,   91,   92,
      82,   64,   42,   21,   -8,  -43,  -63,  -68,  -68,  -75,  -86,  -76,  -48,  -22,    4,   23,
      41,   66,   87,   92,   83,   69,   51,   31,    6,  -31,  -59,  -67,  -69,  -74,  -88,  -87,
     -62,  -34,   -7,   17,   36,   62,   87,   96,   90,   76,   60,   39,   14,  -23,  -58,  -70,
     -71,  -73,  -83,  -89,  -68,  -37,  -13,    9,   26,   51,   79,   94,   91,   80,   68,   52,
      28,   -8,  -48,  -67,  -70,  -73,  -84,  -96,  -83,  -49,  -22,    0,   20,   44,   75,   96,
      98,   88,   75,   61,   40,    6,  -39,  -67,  -72,  -75,  -83,  -95,  -91,  -60,  -29,   -7,
      13,   36,   66,   89,   97,   92,   78,   65,   50,   22,  -21,  -58,  -71,  -73,  -78,  -91,
     -98,  -79,  -45,  -15,    4,   25,   56,   84,  101,   99,   86,   73,   60,   35,   -9,  -53,
     -72,  -77,  -80,  -90,  -98,  -85,  -51,  -20,   -2,   18,   48,   77,   96,   99,   87,   75,
      62,   46,    9,  -39,  -68,  -75,  -75,  -83,  -95,  -94,  -67,  -30,   -7,    8,   34,   68,
      92,  102,   93,   82,   72,   58,   26,  -24,  -61,  -75,  -78,  -85,  -97,  -99,  -78,  -42,
     -12,    6,   28,   59,   87,  102,   99,   86,   74,   62,   38,   -7,  -52,  -76,  -81,  -83,
     -93, -100,  -90,  -57,  -23,   -2,   18,   48,   80,  102,  103,   92,   81,   71,   51,    9,
     -41,  -72,  -83,  -85,  -93, -100,  -92,  -65,  -32,   -7,   13,   39,   72,   97,  103,   95,
      85,   73,   55,   25,  -21,  -61,  -79,  -83,  -90,  -99,  -97,  -77,  -45,  -17,    1,   24,
      59,   93,  107,  103,   92,   85,   72,   42,   -6,  -54,  -80,  -86,  -91, -104, -105,  -87,
     -56,  -23,    0,   18,   48,   85,  106,  106,   96,   87,   77,   52,   13,  -35,  -71,  -84,
     -88,  -98, -106,  -96,  -70,  -40,  -14,    6,   31,   70,  103,  111,  103,   95,   88,   68,
      29,  -19,  -61,  -84,  -91,  -99, -106, -101,  -80,  -51,  -22,    2,   23,   56,   91,  109,
     108,   98,   89,   76,   45,    1,  -44,  -76,  -87,  -92, -102, -104,  -90,  -64,  -34,  -11,
       8,   37,   78,  108,  113,  106,   96,   85,   61,   19,  -29,  -68,  -88,  -94, -102, -104,
     -93,  -73,  -46,  -21,    2,   28,   63,   98,  113,  109,  100,   89,   70,   33,  -14,  -55,
     -81,  -91,  -98, -104,  -98,  -79,  -54,  -30,   -9,   18,   52,   89,  108,  110,  104,   96,
      79,   46,    2,  -40,  -71,  -90, -100, -104, -100,  -86,  -67,  -44,  -19,    7,   40,   77,
     105,  115,  109,   99,   86,   58,   17,  -29,  -63,  -86,  -97, -101, -101,  -92,  -74,  -50,
     -26,   -4,   28,   66,   98,  114,  113,  102,   90,   68,   33,  -15,  -53,  -76,  -93, -101,
    -104,  -96,  -79,  -57,  -34,  -15,   15,   56,   90,  110,  115,  105,   93,   75,   44,    0,
     -43,  -68,  -86,  -98, -101,  -98,  -83,  -65,  -42,  -22,    4,   41,   79,  104,  113,  107,
      96,   81,   57,   16,  -31,  -59,  -79,  -95, -101, -100,  -90,  -71,  -49,  -30,   -9,   28,
      67,   97,  110,  107,   97,   86,   65,   30,  -14,  -47,  -67,  -84,  -98, -102,  -96,  -79,
     -59,  -41,  -22,   14,   53,   90,  110,  111,  101,   90,   75,   45,    2,  -39,  -64,  -79,
     -93, -102, -101,  -87,  -64,  -44,  -28,    0,   39,   81,  108,  110,  102,   93,   82,   58,
      18,  -25,  -54,  -70,  -85, -101, -103,  -94,  -72,  -53,  -39,  -14,   25,   70,  104,  112,
     103,   96,   88,   70,   34,  -13,  -48,  -65,  -78,  -97, -108, -101,  -79,  -55,  -42,  -24,
      11,   56,   96,  111,  103,   94,   90,   77,   46,    5,  -34,  -56,  -71,  -92, -109, -109,
     -91,  -64,  -46,  -30,    0,   44,   89,  112,  108,   95,   88,   80,   57,   16,  -27,  -54,
     -66,  -82, -104, -112, -100,  -71,  -46,  -34,  -13,   29,   80,  111,  112,   97,   86,   84,
      69,   32,  -15,  -48,  -61,  -72,  -94, -109, -106,  -82,  -54,  -37,  -23,   11,   61,  101,
     113,  101,   85,   80,   75,   48,    4,  -37,  -56,  -64,  -84, -107, -112,  -90,  -60,  -37,
     -29,   -7,   43,   91,  111,  103,   86,   80,   77,   58,   20,  -24,  -52,  -61,  -75, -100,
    -111,  -99,  -72,  -44,  -27,  -12,   29,   77,  105,  106,   91,   80,   75,   64,   33,   -9,
     -43,  -58,  -69,  -94, -111, -104,  -78,  -49,  -28,  -18,   11,   62,   97,  107,   94,   80,
      75,   69,   47,    6,  -36,  -55,  -62,  -81, -105, -108,  -87,  -59,  -33,  -18,    1,   46,
      86,  103,   97,   83,   75,   69,   52,   19,  -23,  -50,  -59,  -74,  -97, -106,  -91,  -64,
     -38,  -21,   -9,   26,   70,   95,   95,   80,   71,   69,   60,   35,   -6,  -40,  -53,  -64,
     -87, -102,  -96,  -72,  -45,  -25,  -14,   13,   56,   87,   95,   86,   75,   69,   60,   41,
       6,  -32,  -54,  -62,  -77,  -95,  -99,  -79,  -51,  -23,   -8,    6,   39,   75,   92,   87,
      72,   64,   62,   49,   21,  -17,  -47,  -57,  -67,  -86,  -97,  -87,  -59,  -32,  -16,   -4,
      25,   63,   89,   92,   78,   67,   63,   53,   27,  -10,  -40,  -55,  -63,  -78,  -93,  -89,
     -65,  -36,  -17,   -7,   11,   44,   77,   89,   79,   65,   61,   58,   41,    8,  -26,  -50,
     -59,  -67,  -83,  -90,  -76,  -47,  -25,  -13,    3,   30,   63,   85,   82,   70,   63,   58,
      45,   14,  -18,  -43,  -56,  -63,  -74,  -84,  -78,  -52,  -26,  -13,   -2,   19,   46,   73,
      81,   68,   57,   55,   49,   27,   -5,  -32,  -48,  -54,  -63,  -77,  -80,  -60,  -34,  -17,
      -5,   10,   34,   62,   79,   71,   57,   52,   48,   31,    2,  -26,  -45,  -50,  -53,  -65,
     -75,  -63,  -37,  -16,   -6,    4,   19,   45,   68,   70,   57,   49,   49,   39,   16,  -11,
     -33,  -45,  -49,  -56,  -70,  -71,  -51,  -26,   -8,    2,   13,   35,   63,   76,   63,   48,
      43,   38,   23,   -7,  -32,  -45,  -47,  -47,  -58,  -67,  -55,  -30,   -8,    0,    4,   20,
      46,   68,   65,   47,   38,   38,   31,    8,  -19,  -37,  -44,  -42,  -48,  -63,  -62,  -41,
     -16,   -2,    5,   16,   37,   61,   68,   53,   38,   34,   31,   14,  -14,  -33,  -40,  -38,
     -41,  -54,  -60,  -46,  -20,   -5,   -3,    6,   25,   49,   63,   55,   38,   32,   33,   24,
       1,  -23,  -34,  -35,  -36,  -45,  -59,  -55,  -30,   -9,   -3,    2,   16,   39,   59,   59,
      44,   32,   30,   26,    7,  -20,  -33,  -33,  -32,  -40,  -53,  -54,  -35,  -12,   -3,   -2,
      10,   29,   48,   55,   45,   32,   28,   27,   14,  -10,  -27,  -30,  -28,  -34,  -46,  -53,
     -41,  -17,   -5,   -5,    5,   24,   44,   54,   46,   32,   25,   25,   18,   -4,  -25,  -31,
     -24,  -27,  -39,  -47,  -42,  -21,   -4,   -2,    1,   15,   35,   46,   44,   31,   22,   23,
      20,    6,  -15,  -26,  -23,  -20,  -29,  -41,  -42,  -29,  -11,   -4,   -4,    7,   26,   42,
      47,   37,   25,   21,   19,    9,  -10,  -25,  -25,  -18,  -24,  -38,  -40,  -29,  -11,    1,
       0,    3,   19,   34,   42,   33,   19,   14,   15,   10,   -5,  -21,  -24,  -15,  -13,  -26,
     -35,  -31,  -17,   -2,    0,   -2,   11,   26,   37,   34,   20,   14,   13,   12,    2,  -17,
     -25,  -17,  -12,  -21,  -31,  -30,  -19,   -4,    4,    1,    9,   22,   32,   32,   19,    9,
       9,   10,    4,  -11,  -21,  -16,   -9,  -14,  -23,  -26,  -20,   -8,    0,   -2,    3,   15,
      26,   31,   24,   12,    9,   10,    6,   -5,  -17,  -19,  -12,  -11,  -18,  -25,  -22,  -10,
       1,    2,    2,   11,   22,   29,   24,   10,    3,    5,    4,   -4,  -13,  -15,   -8,   -5,
     -10,  -16,  -18,  -14,   -5,   -2,    0,    6,   13,   20,   23,   16,    6,    5,    5,    0,
      -7,  -12,  -12,   -8,   -7,  -12,  -19,  -18,   -7,    0,    2,    7,   13,   18,   20,   13,
       3,   -2,    1,   -2,   -6,   -8,   -6,   -3,   -2,   -2,  -10,  -14,  -10,   -6,   -4,    0,
       4,    9,   14,   15,    6,   -2,   -2,   -2,   -4,   -4,   -5,   -3,    2,    3,   -3,  -10,
      -9,   -5,    0,    0,    0,    3,    8,   10,    3,   -5,   -7,   -6,   -4,    0,   -2,   -2,
       3,    7,    7,    2,   -5,   -6,   -3,    2,    2,    0,    0,    2,    2,   -4,   -9,   -9,
      -7,   -3,    2,    4,    8,    9,    6,    2,   -3,   -4,   -3,   -2,   -2,   -2,    0,    1,
      -3,   -8,  -11,   -8,   -6,   -4,    2,    6,    9,   10,    9,    8,    5,   -4,   -7,   -3,
       1,    1,   -6,   -7,   -6,   -6,  -11,  -14,  -10,   -5,    3,    9,   12,   14,   13,   10,
       9,    1,   -6,   -5,   -4,   -3,   -4,   -6,   -8,  -12,  -12,  -13,  -13,  -11,   -3,    9,
      16,   18,   15,   13,   14,   11,   -2,   -6,   -4,   -3,   -5,  -11,  -13,  -12,  -14,  -15,
     -14,  -10,   -4,    6,   15,   22,   21,   16,   13,   12,    3,   -7,   -8,   -7,   -7,  -10,
     -14,  -17,  -16,  -13,  -12,  -10,   -7,    3,   15,   24,   26,   19,   16,   18,   12,   -3,
      -9,  -10,   -9,  -11,  -18,  -22,  -21,  -17,  -14,  -14,  -10,    0,   14,   26,   32,   28,
      23,   22,   21,    5,   -9,  -12,  -16,  -18,  -22,  -27,  -27,  -23,  -17,  -13,   -8,    2,
      12,   25,   35,   36,   29,   21,   20,   11,   -6,  -14,  -17,  -19,  -22,  -27,  -28,  -24,
     -20,  -15,  -11,   -4,    7,   19,   32,   39,   35,   28,   25,   19,    4,  -10,  -17,  -24,
     -28,  -31,  -33,  -30,  -26,  -19,  -11,   -3,    8,   19,   31,   42,   42,   34,   27,   21,
       9,   -9,  -19,  -26,  -31,  -35,  -34,  -30,  -26,  -23,  -13,   -4,    4,   14,   25,   42,
      49,   41,   31,   27,   20,    3,  -15,  -28,  -37,  -38,  -39,  -38,  -35,  -29,  -16,    0,
       9,   17,   26,   41,   52,   48,   36,   26,   19,    6,  -16,  -30,  -39,  -43,  -41,  -39,
     -33,  -29,  -22,   -5,    7,   13,   21,   36,   55,   56,   46,   34,   24,   15,   -8,  -29,
     -44,  -54,  -50,  -44,  -39,  -35,  -27,   -7,   11,   20,   25,   34,   54,   63,   53,   38,
      22,   14,    0,  -27,  -45,  -56,  -56,  -46,  -39,  -36,  -31,  -14,    8,   19,   23,   29,
      46,   63,   61,   47,   30,   20,    8,  -15,  -39,  -56,  -62,  -54,  -44,  -41,  -38,  -23,
      -2,   16,   23,   28,   42,   63,   69,   58,   41,   25,   13,   -7,  -34,  -56,  -68,  -64,
     -50,  -45,  -43,  -29,   -7,   15,   26,   29,   40,   58,   72,   67,   48,   30,   16,    0,
     -26,  -53,  -68,  -69,  -57,  -47,  -46,  -36,  -16,    9,   25,   30,   38,   53,   71,   74,
      58,   37,   17,    2,  -21,  -49,  -70,  -76,  -64,  -49,  -43,  -38,  -21,    3,   25,   33,
      37,   49,   65,   74,   65,   45,   24,    8,  -11,  -40,  -68,  -79,  -72,  -57,  -48,  -42,
     -29,   -6,   20,   34,   39,   48,   63,   77,   74,   56,   31,   11,   -8,  -33,  -61,  -79,
     -80,  -68,  -53,  -45,  -34,  -16,   11,   31,   41,   51,   61,   75,   78,   64,   42,   19,
      -3,  -27,  -55,  -78,  -84,  -73,  -59,  -48,  -37,  -20,    5,   27,   40,   49,   58,   71,
      80,   71,   49,   23,    2,  -20,  -47,  -72,  -86,  -82,  -66,  -52,  -39,  -26,   -5,   20,
      39,   51,   59,   69,   79,   77,   61,   34,    7,  -16,  -42,  -68,  -88,  -90,  -75,  -58,
     -41,  -26,   -8,   17,   39,   52,   59,   65,   74,   77,   65,   41,   12,  -12,  -35,  -60,
     -81,  -89,  -79,  -60,  -45,  -33,  -17,    6,   31,   49,   59,   64,   73,   80,   74,   51,
      22,   -5,  -29,  -54,  -78,  -92,  -90,  -70,  -49,  -35,  -18,    3,   26,   48,   60,   64,
      68,   75,   75,   58,   31,    1,  -25,  -48,  -73,  -88,  -90,  -77,  -56,  -41,  -23,   -3,
      21,   43,   58,   64,   70,   75,   77,   64,   40,   12,  -18,  -44,  -70,  -87,  -94,  -87,
     -64,  -42,  -22,   -4,   16,   39,   58,   65,   66,   67,   74,   68,   46,   18,  -12,  -38,
     -62,  -82,  -92,  -89,  -67,  -45,  -28,   -9,   13,   31,   52,   64,   67,   66,   72,   71,
      53,   29,   -3,  -34,  -59,  -79,  -94,  -96,  -77,  -50,  -29,   -8,   12,   30,   49,   63,
      68,   67,   68,   70,   56,   34,    6,  -29,  -57,  -77,  -92,  -99,  -84,  -56,  -32,  -10,
      11,   29,   45,   61,   69,   69,   68,   70,   60,   37,   12,  -20,  -50,  -73,  -90, -100,
     -91,  -64,  -37,  -14,    7,   25,   42,   57,   66,   67,   65,   67,   64,   45,   21,   -9,
     -41,  -66,  -84,  -98,  -95,  -74,  -47,  -21,    3,   23,   39,   54,   64,   69,   69,   67,
      63,   50,   27,    0,  -33,  -63,  -83,  -94,  -95,  -79,  -54,  -26,   -2,   18,   35,   49,
      61,   67,   67,   65,   64,   55,   33,    6,  -25,  -55,  -82,  -95,  -98,  -84,  -60,  -32,
      -6,   17,   36,   48,   56,   64,   66,   65,   62,   55,   39,   14,  -16,  -46,  -76,  -92,
     -96,  -88,  -69,  -41,   -9,   15,   33,   46,   54,   62,   68,   66,   59,   54,   44,   20,
     -12,  -41,  -72,  -92,  -97,  -90,  -71,  -46,  -14,   15,   34,   48,   55,   59,   62,   63,
      60,   51,   42,   24,   -6,  -34,  -63,  -87,  -95,  -89,  -75,  -52,  -23,   10,   31,   45,
      54,   58,   62,   66,   63,   51,   42,   30,    1,  -32,  -59,  -84,  -96,  -93,  -80,  -58,
     -28,    7,   32,   45,   53,   60,   64,   67,   62,   52,   41,   31,    9,  -25,  -55,  -78,
     -92,  -91,  -82,  -65,  -39,   -2,   30,   43,   49,   56,   61,   65,   63,   54,   44,   33,
      16,  -15,  -47,  -72,  -88,  -91,  -84,  -70,  -45,  -12,   22,   42,   48,   54,   58,   61,
      63,   56,   43,   32,   20,   -4,  -36,  -65,  -82,  -87,  -82,  -72,  -53,  -23,   15,   40,
      46,   48,   55,   61,   62,   55,   43,   32,   21,    4,  -26,  -57,  -75,  -82,  -80,  -73,
     -58,  -30,    5,   35,   46,   47,   51,   57,   61,   57,   46,   34,   22,    9,  -15,  -47,
     -71,  -81,  -80,  -75,  -62,  -36,   -4,   28,   46,   47,   49,   56,   60,   57,   48,   35,
      23,   12,   -9,  -39,  -67,  -78,  -76,  -71,  -65,  -45,  -13,   21,   45,   50,   46,   50,
      58,   59,   49,   35,   23,   12,   -4,  -31,  -62,  -78,  -74,  -70,  -65,  -49,  -18,   18,
      43,   51,   45,   48,   56,   56,   45,   30,   20,   12,    0,  -24,  -53,  -71,  -69,  -63,
     -60,  -51,  -25,    9,   36,   50,   47,   44,   50,   52,   45,   32,   21,   12,    1,  -18,
     -44,  -66,  -70,  -64,  -59,  -51,  -31,    2,   32,   50,   51,   46,   47,   52,   47,   32,
      17,    9,    0,  -14,  -34,  -57,  -67,  -62,  -56,  -50,  -33,   -6,   24,   44,   51,   48,
      47,   48,   46,   34,   21,   12,    2,  -13,  -32,  -51,  -62,  -62,  -56,  -51,  -38,  -13,
      18,   40,   51,   50,   45,   47,   46,   36,   20,    9,   -2,  -14,  -28,  -45,  -59,  -61,
     -54,  -48,  -37,  -15,   14,   36,   49,   52,   48,   44,   42,   33,   19,   10,    0,  -13,
     -26,  -39,  -52,  -58,  -54,  -47,  -37,  -19,    9,   30,   44,   52,   48,   40,   38,   31,
      19,    7,   -3,  -12,  -22,  -31,  -42,  -51,  -49,  -43,  -36,  -22,    1,   22,   35,   45,
      47,   41,   37,   31,   23,   13,    3,  -11,  -22,  -28,  -36,  -48,  -53,  -46,  -35,  -23,
      -4,   17,   31,   45,   49,   41,   33,   29,   23,   13,    2,  -11,  -22,  -26,  -29,  -38,
     -46,  -45,  -34,  -21,   -6,   14,   25,   38,   46,   43,   35,   27,   19,   10,    3,   -7,
     -20,  -28,  -28,  -32,  -38,  -41,  -35,  -23,   -8,   10,   23,   33,   44,   44,   36,   27,
      18,   10,    0,   -9,  -22,  -28,  -28,  -28,  -33,  -37,  -32,  -21,   -7,    8,   20,   28,
      38,   41,   36,   27,   17,    8,   -2,   -6,  -17,  -28,  -31,  -28,  -27,  -30,  -30,  -22,
      -7,    9,   19,   26,   35,   41,   37,   26,   16,    6,   -5,  -11,  -18,  -28,  -31,  -28,
     -22,  -23,  -23,  -18,   -4,   11,   19,   24,   27,   33,   33,   24,   14,    3,   -8,  -11,
     -15,  -23,  -29,  -29,  -21,  -18,  -19,  -15,   -5,    9,   16,   21,   26,   30,   32,   25,
      13,    2,   -9,  -13,  -16,  -21,  -27,  -27,  -20,  -12,  -13,  -14,   -7,    9,   17,   20,
      24,   25,   26,   27,   15,    2,   -9,  -17,  -17,  -20,  -25,  -28,  -23,  -11,   -6,   -8,
      -5,    7,   19,   23,   24,   24,   24,   25,   16,    0,  -13,  -22,  -22,  -22,  -26,  -28,
     -22,   -8,    2,    1,    0,    8,   18,   24,   24,   20,   18,   20,   15,    1,  -12,  -22,
     -24,  -22,  -23,  -25,  -22,  -13,    2,    7,    3,    8,   16,   25,   28,   21,   15,   15,
      15,    4,  -13,  -25,  -29,  -24,  -20,  -24,  -21,  -12,    1,   12,   10,    9,   16,   23,
      27,   21,   14,   12,   10,    3,  -10,  -21,  -28,  -27,  -22,  -22,  -20,  -14,   -4,   10,
      14,   11,   17,   23,   29,   26,   15,   11,   10,    4,  -12,  -25,  -33,  -33,  -26,  -23,
     -22,  -12,    0,   13,   22,   19,   20,   25,   29,   25,   12,    5,    3,    0,  -12,  -25,
     -32,  -34,  -27,  -21,  -20,  -11,   -2,    7,   18,   21,   22,   26,   30,   29,   21,   11,
       4,   -5,  -14,  -29,  -38,  -38,  -33,  -27,  -23,  -10,    4,   12,   22,   29,   30,   30,
      31,   30,   21,   10,    0,  -11,  -19,  -30,  -39,  -40,  -36,  -28,  -20,   -9,    4,   12,
      20,   29,   32,   30,   32,   32,   23,   12,    3,   -8,  -18,  -27,  -39,  -44,  -40,  -32,
     -25,  -15,    1,   13,   22,   30,   37,   38,   36,   34,   26,   14,    2,  -11,  -22,  -31,
     -40,  -45,  -42,  -35,  -26,  -14,    0,   12,   19,   26,   35,   39,   36,   33,   28,   18,
       6,   -7,  -18,  -28,  -37,  -43,  -43,  -37,  -30,  -19,   -6,    8,   20,   25,   34,   42,
      41,   37,   32,   22,    8,   -7,  -19,  -32,  -40,  -44,  -44,  -38,  -30,  -20,   -6,    8,
      19,   24,   30,   40,   41,   36,   29,   23,   13,   -3,  -16,  -28,  -39,  -43,  -44,  -41,
     -34,  -23,  -11,    2,   16,   25,   32,   41,   46,   42,   34,   26,   15,    0,  -16,  -29,
     -40,  -45,  -45,  -40,  -32,  -24,  -12,   -2,   12,   22,   26,   37,   45,   44,   34,   24,
      18,    6,  -12,  -24,  -37,  -41,  -40,  -40,  -36,  -30,  -17,   -4,    9,   18,   25,   37,
      45,   45,   40,   29,   19,    8,   -8,  -22,  -38,  -43,  -42,  -42,  -35,  -28,  -17,   -4,
       7,   17,   23,   33,   43,   43,   38,   28,   19,   12,   -3,  -19,  -34,  -40,  -38,  -40,
     -38,  -31,  -22,   -8,    5,   14,   21,   31,   44,   47,   41,   31,   20,   13,    3,  -15,
     -33,  -45,  -45,  -41,  -38,  -31,  -24,  -10,    4,   15,   21,   29,   42,   47,   41,   33,
      22,   13,    4,  -13,  -29,  -40,  -41,  -41,  -41,  -36,  -26,  -14,   -2,    8,   17,   29,
      42,   50,   46,   37,   27,   17,    7,   -9,  -27,  -41,  -48,  -45,  -42,  -38,  -29,  -15,
      -2,   10,   18,   26,   38,   50,   51,   40,   28,   17,    6,   -7,  -24,  -36,  -43,  -45,
     -41,  -38,  -31,  -18,   -8,    2,   13,   26,   38,   44,   49,   42,   33,   22,    8,   -4,
     -20,  -32,  -41,  -46,  -44,  -37,  -32,  -21,   -8,    2,   14,   25,   35,   42,   47,   44,
      31,   19,    7,   -4,  -15,  -28,  -36,  -42,  -40,  -34,  -31,  -24,   -9,    0,    7,   18,
      30,   40,   44,   42,   32,   22,   12,    2,  -10,  -23,  -31,  -38,  -42,  -38,  -31,  -26,
     -13,   -3,    2,   14,   29,   40,   41,   40,   36,   26,   13,    1,  -10,  -19,  -26,  -35,
     -43,  -41,  -33,  -27,  -17,   -6,    1,   12,   27,   43,   47,   42,   37,   29,   14,    0,
     -10,  -21,  -29,  -34,  -40,  -42,  -33,  -26,  -18,   -5,    3,   10,   23,   39,   45,   39,
      33,   30,   18,    3,   -8,  -15,  -22,  -29,  -37,  -43,  -36,  -27,  -22,  -13,   -4,    6,
      19,   36,   47,   47,   37,   33,   25,    6,   -8,  -15,  -25,  -31,  -36,  -43,  -42,  -32,
     -21,  -11,    0,    5,   15,   32,   46,   45,   35,   31,   28,   12,   -6,  -13,  -20,  -24,
     -31,  -41,  -46,  -38,  -26,  -18,   -9,    1,   14,   31,   43,   48,   42,   33,   28,   15,
      -5,  -15,  -18,  -24,  -31,  -38,  -41,  -34,  -26,  -19,   -8,    1,   10,   23,   37,   43,
      41,   32,   26,   19,    3,  -12,  -15,  -18,  -24,  -34,  -42,  -38,  -28,  -20,  -13,   -4,
       6,   21,   37,   44,   43,   36,   28,   21,    8,   -9,  -16,  -19,  -25,  -34,  -42,  -39,
     -29,  -21,  -13,   -3,    8,   19,   34,   42,   41,   36,   28,   20,    8,   -7,  -15,  -16,
     -19,  -30,  -41,  -42,  -31,  -23,  -15,   -8,    3,   19,   36,   43,   39,   36,   30,   23,
      13,   -6,  -19,  -21,  -20,  -26,  -38,  -43,  -35,  -25,  -15,   -7,    3,   14,   30,   42,
      40,   35,   28,   23,   16,    0,  -14,  -20,  -19,  -22,  -34,  -42,  -37,  -26,  -15,   -8,
       0,   12,   27,   40,   41,   35,   29,   22,   16,    4,   -9,  -19,  -20,  -20,  -29,  -39,
     -39,  -30,  -19,  -10,   -3,   10,   24,   37,   42,   37,   31,   25,   18,    7,   -7,  -17,
     -21,  -20,  -28,  -38,  -40,  -33,  -22,  -11,   -5,    9,   25,   37,   44,   40,   32,   24,
      17,   10,   -5,  -18,  -24,  -23,  -28,  -35,  -38,  -35,  -26,  -14,   -5,    5,   19,   34,
      44,   42,   33,   23,   18,   13,    0,  -15,  -20,  -22,  -26,  -33,  -39,  -35,  -28,  -18,
     -10,    1,   18,   33,   43,   45,   38,   28,   20,   11,    2,  -12,  -22,  -24,  -28,  -31,
     -36,  -35,  -29,  -21,  -11,    0,   15,   30,   40,   44,   39,   31,   21,   13,    8,   -5,
     -17,  -20,  -25,  -28,  -32,  -36,  -34,  -27,  -18,   -7,    9,   26,   39,   46,   45,   36,
      25,   14,   10,   -2,  -16,  -24,  -29,  -31,  -31,  -36,  -36,  -27,  -16,   -7,    6,   23,
      37,   45,   44,   36,   26,   14,    8,    1,  -14,  -22,  -23,  -29,  -32,  -35,  -36,  -29,
     -21,  -14,    0,   16,   35,   46,   45,   39,   33,   20,    8,    3,   -9,  -21,  -28,  -32,
     -34,  -35,  -36,  -32,  -25,  -15,    1,   17,   32,   45,   49,   44,   35,   23,    7,    0,
      -7,  -17,  -25,  -30,  -31,  -32,  -34,  -31,  -25,  -18,   -7,   10,   27,   43,   50,   45,
      35,   24,   13,    3,   -7,  -17,  -24,  -28,  -30,  -30,  -33,  -34,  -26,  -19,  -11,    5,
      22,   39,   50,   48,   37,   26,   16,    5,   -7,  -18,  -23,  -27,  -28,  -28,  -33,  -34,
     -24,  -16,  -11,    2,   17,   33,   48,   48,   37,   27,   18,    7,   -5,  -14,  -20,  -25,
     -30,  -31,  -32,  -37,  -31,  -20,  -15,   -3,   15,   30,   46,   53,   43,   31,   20,   11,
       0,  -12,  -21,  -27,  -31,  -30,  -30,  -36,  -33,  -20,  -10,   -5,    9,   25,   41,   52,
      46,   34,   23,   15,    6,   -9,  -21,  -27,  -30,  -31,  -31,  -37,  -39,  -25,  -12,   -7,
       1,   18,   36,   52,   53,   40,   28,   22,   13,   -2,  -18,  -29,  -32,  -35,  -34,  -39,
     -40,  -28,  -13,   -7,   -2,   12,   33,   50,   56,   44,   30,   24,   18,    4,  -15,  -29,
     -32,  -33,  -33,  -35,  -40,  -35,  -20,   -7,   -2,    8,   25,   43,   54,   49,   35,   25,
      18,    8,   -7,  -23,  -32,  -32,  -34,  -34,  -37,  -36,  -24,  -11,   -5,    2,   18,   36,
      51,   51,   39,   30,   24,   14,    0,  -19,  -32,  -35,  -35,  -37,  -38,  -39,  -29,  -12,
      -2,    3,   14,   29,   47,   54,   45,   33,   26,   17,    5,  -12,  -31,  -37,  -36,  -38,
     -38,  -38,  -32,  -17,   -3,    3,    9,   25,   42,   53,   49,   39,   31,   23,   10,   -9,
     -27,  -38,  -40,  -41,  -41,  -41,  -36,  -23,   -5,    5,    8,   18,   36,   51,   51,   43,
      34,   26,   16,    1,  -20,  -36,  -40,  -41,  -42,  -40,  -38,  -28,  -10,    4,    7,   14,
      30,   48,   51,   45,   39,   31,   21,    4,  -16,  -33,  -41,  -43,  -43,  -39,  -38,  -32,
     -15,    1,    7,   13,   25,   42,   52,   48,   39,   31,   22,    9,  -10,  -29,  -40,  -40,
     -40,  -38,  -35,  -34,  -20,   -2,    5,    9,   17,   33,   49,   50,   43,   34,   25,   13,
      -4,  -21,  -36,  -44,  -44,  -40,  -35,  -34,  -26,   -8,    5,   11,   17,   26,   43,   51,
      46,   36,   27,   16,    1,  -16,  -31,  -42,  -46,  -43,  -37,  -35,  -29,  -12,    3,   11,
      17,   23,   37,   50,   52,   41,   29,   20,    4,  -15,  -30,  -43,  -49,  -46,  -39,  -37,
     -33,  -15,    3,   13,   19,   23,   35,   52,   55,   44,   29,   20,    8,  -12,  -28,  -40,
     -48,  -45,  -39,  -35,  -32,  -20,   -2,   12,   16,   19,   28,   45,   55,   49,   35,   24,
      14,   -3,  -20,  -36,  -49,  -53,  -45,  -38,  -35,  -27,   -9,    8,   19,   23,   26,   40,
      55,   55,   41,   25,   15,   -2,  -19,  -33,  -46,  -53,  -47,  -39,  -35,  -29,  -14,    6,
      19,   24,   25,   35,   53,   59,   47,   29,   17,    7,  -12,  -30,  -47,  -58,  -56,  -47,
     -39,  -35,  -22,   -2,   17,   28,   30,   34,   50,   63,   56,   35,   19,    8,   -9,  -26,
     -43,  -56,  -58,  -49,  -42,  -38,  -27,   -9,   12,   26,   33,   34,   44,   60,   62,   44,
      23,    9,   -4,  -20,  -40,  -56,  -63,  -56,  -44,  -39,  -30,  -14,    8,   26,   35,   35,
      43,   60,   64,   50,   28,   13,    2,  -16,  -37,  -53,  -62,  -61,  -50,  -42,  -32,  -17,
       2,   18,   32,   40,   44,   54,   63,   55,   37,   17,    4,  -10,  -31,  -48,  -61,  -67,
     -59,  -45,  -36,  -24,   -5,   17,   33,   43,   47,   54,   64,   59,   42,   20,    3,  -10,
     -28,  -49,  -63,  -68,  -63,  -50,  -37,  -25,   -7,   13,   31,   44,   48,   54,   61,   59,
      48,   27,    6,  -10,  -24,  -43,  -59,  -67,  -67,  -56,  -39,  -28,  -13,    8,   24,   42,
      51,   54,   58,   58,   52,   37,   14,   -6,  -20,  -38,  -54,  -65,  -70,  -63,  -45,  -29,
     -17,    2,   18,   37,   52,   56,   58,   56,   51,   42,   23,   -2,  -19,  -34,  -50,  -62,
     -70,  -69,  -52,  -30,  -17,   -3,   15,   33,   50,   58,   58,   56,   52,   46,   29,    3,
     -15,  -31,  -45,  -58,  -68,  -71,  -60,  -38,  -20,   -5,   11,   25,   42,   58,   62,   58,
      51,   44,   36,   15,  -10,  -29,  -43,  -53,  -64,  -72,  -67,  -45,  -21,   -8,    4,   20,
      40,   60,   65,   57,   53,   48,   42,   21,   -8,  -27,  -40,  -50,  -62,  -71,  -71,  -54,
     -29,   -9,    3,   18,   34,   54,   68,   65,   57,   48,   40,   28,    2,  -23,  -41,  -52,
     -60,  -71,  -75,  -60,  -34,  -12,    0,   13,   31,   52,   69,   66,   56,   50,   44,   33,
       7,  -21,  -38,  -47,  -55,  -65,  -75,  -67,  -41,  -15,    2,   11,   23,   41,   61,   68,
      59,   49,   40,   34,   17,  -11,  -35,  -47,  -48,  -55,  -69,  -72,  -50,  -21,    0,    8,
      15,   33,   56,   69,   62,   52,   44,   40,   26,   -4,  -30,  -44,  -48,  -56,  -69,  -77,
     -59,  -28,   -7,    7,   15,   30,   52,   68,   66,   55,   45,   38,   30,    6,  -24,  -43,
     -49,  -52,  -64,  -75,  -65,  -35,  -10,    4,   11,   25,   45,   65,   67,   55,   48,   43,
      34,   13,  -18,  -39,  -45,  -49,  -61,  -75,  -72,  -45,  -17,   -2,    9,   20,   39,   61,
      70,   62,   52,   45,   36,   18,   -9,  -34,  -47,  -52,  -58,  -69,  -72,  -52,  -23,   -5,
       7,   17,   35,   54,   65,   63,   55,   45,   37,   23,    0,  -27,  -45,  -49,  -53,  -63,
     -71,  -59,  -31,   -8,    7,   15,   28,   47,   61,   65,   58,   47,   38,   27,    6,  -21,
     -41,  -49,  -53,  -62,  -69,  -62,  -39,  -14,    3,   14,   28,   46,   59,   64,   62,   51,
      39,   29,   11,  -16,  -40,  -52,  -55,  -58,  -65,  -65,  -47,  -20,    1,   14,   24,   39,
      52,   59,   64,   56,   43,   33,   16,   -8,  -32,  -49,  -55,  -58,  -63,  -65,  -54,  -29,
      -3,   12,   21,   36,   51,   60,   65,   59,   46,   35,   21,   -4,  -28,  -48,  -56,  -57,
     -59,  -60,  -55,  -37,  -12,    9,   19,   32,   46,   54,   58,   58,   48,   36,   26,    7,
     -18,  -41,  -53,  -53,  -52,  -57,  -58,  -45,  -19,    6,   15,   26,   42,   54,   59,   59,
      52,   39,   28,   10,  -16,  -40,  -56,  -56,  -52,  -51,  -53,  -45,  -22,    4,   17,   24,
      35,   46,   56,   57,   52,   40,   30,   18,   -7,  -33,  -54,  -58,  -52,  -49,  -53,  -51,
     -33,   -5,   17,   26,   34,   43,   54,   58,   53,   42,   31,   19,    0,  -24,  -47,  -60,
     -55,  -46,  -46,  -50,  -39,  -13,   13,   25,   32,   38,   48,   56,   52,   41,   30,   20,
       7,  -15,  -41,  -58,  -55,  -44,  -41,  -44,  -40,  -19,   10,   25,   28,   32,   41,   53,
      52,   42,   31,   21,   13,   -5,  -32,  -55,  -60,  -47,  -36,  -38,  -40,  -26,    2,   24,
      29,   28,   32,   46,   48,   40,   29,   21,   14,    1,  -23,  -48,  -56,  -46,  -34,  -33,
     -36,  -29,   -7,   20,   28,   25,   26,   37,   46,   42,   30,   19,   15,    7,  -13,  -39,
     -58,  -54,  -37,  -27,  -27,  -29,  -17,   13,   29,   28,   24,   31,   42,   42,   34,   21,
      11,    5,  -10,  -32,  -51,  -52,  -40,  -28,  -24,  -24,  -18,    6,   27,   30,   26,   28,
      36,   38,   33,   22,   11,    6,   -7,  -26,  -44,  -49,  -42,  -30,  -21,  -17,  -16,   -5,
      18,   29,   26,   25,   29,   33,   33,   25,   13,    7,    0,  -18,  -36,  -46,  -45,  -31,
     -20,  -16,  -16,   -9,   12,   28,   29,   24,   25,   29,   31,   26,   13,    2,   -5,  -15,
     -26,  -39,  -46,  -37,  -19,   -9,   -9,  -11,    1,   21,   31,   26,   21,   23,   26,   25,
      15,    4,   -4,  -10,  -20,  -32,  -41,  -38,  -22,  -10,   -7,   -9,   -6,   11,   26,   29,
      22,   20,   21,   24,   19,    7,   -6,  -12,  -17,  -23,  -30,  -36,  -27,  -12,   -3,    0,
      -5,    3,   18,   28,   25,   18,   15,   16,   15,    7,   -4,  -10,  -14,  -19,  -24,  -30,
     -26,  -13,   -3,    2,   -3,   -2,   12,   23,   26,   18,   13,   13,   14,    9,    0,  -11,
     -14,  -15,  -18,  -24,  -26,  -16,   -4,    4,    0,   -5,    6,   17,   25,   21,   11,    7,
       8,    8,    1,  -11,  -14,  -11,  -10,  -13,  -20,  -18,   -7,    5,    7,   -3,   -2,    8,
      21,   23,   12,    4,    4,    8,    7,   -5,  -15,  -14,  -11,   -9,  -15,  -20,  -13,    1,
       8,    3,    0,    6,   17,   24,   16,    3,   -2,    1,    0,  -10,  -17,  -14,   -8,   -4,
      -5,  -11,  -12,    0,    9,    6,   -3,    1,   10,   18,   16,    5,   -3,    0,    3,   -4,
     -13,  -15,  -10,   -6,   -4,   -8,  -13,   -8,    5,    8,    5,    3,    9,   17,   18,   13,
       0,   -7,   -5,   -5,  -11,  -14,  -11,   -6,    2,    2,   -6,   -9,    1,    8,    5,   -2,
       1,    8,   14,   12,    2,   -6,   -5,   -2,   -6,  -12,  -10,   -2,    3,    4,   -5,  -11,
      -6,    5,    6,    0,    0,    7,   12,   14,    6,   -7,   -8,   -6,   -6,   -9,  -10,   -5,
       4,    8,    4,   -7,  -11,   -2,    6,    3,   -2,    2,    9,   15,   12,   -2,   -8,   -6,
      -3,   -5,  -11,   -9,    2,   10,    7,   -5,  -15,  -10,    4,    6,   -2,   -2,    8,   14,
      14,    3,   -9,   -8,   -5,   -4,   -8,  -10,    0,    8,    9,    3,   -9,  -12,   -3,    6,
       3,   -3,    1,    8,   13,    5,   -9,  -13,   -7,   -2,   -2,   -6,   -2,    9,   13,    6,
      -6,  -13,  -10,    2,    4,   -3,   -2,    7,   13,    9,   -6,  -12,  -11,   -6,    0,   -5,
      -5,    7,   15,   13,    1,  -10,  -13,   -4,    5,   -2,   -7,   -2,    9,    9,   -3,  -11,
     -11,   -8,    2,    1,   -3,    7,   15,   12,    4,   -7,  -13,  -11,   -2,    1,   -4,   -3,
       7,   11,    3,   -8,  -11,  -10,    0,    1,   -5,    2,   12,   17,   11,   -2,  -11,  -11,
      -3,    4,   -4,   -9,    1,   10,    3,   -9,  -11,   -8,    0,    5,    1,    2,   11,   14,
       9,    1,  -11,  -15,  -11,   -3,    1,   -3,    3,   12,   11,    1,   -7,   -9,   -6,   -3,
      -5,   -5,    5,   12,    9,    4,   -3,   -8,   -8,   -5,    0,   -4,   -3,    5,    6,   -3,
     -10,   -7,   -3,    0,    2,    3,   10,   14,   11,    4,   -3,  -11,  -15,  -15,   -9,   -5,
      -5,    5,   13,    5,   -2,    0,    2,    4,    1,   -3,    4,   12,   11,    2,   -5,  -10,
     -13,  -13,  -11,   -6,   -4,    3,   13,    9,    1,   -2,    4,    5,    1,   -5,    3,   12,
      13,    4,   -9,  -12,  -14,  -16,  -17,  -12,   -5,    5,   16,   17,    6,    3,    9,    9,
       2,   -8,   -7,    2,    7,    4,   -8,  -12,  -10,  -13,  -14,  -13,   -6,    4,   13,   19,
      10,    0,    6,   14,    8,   -6,   -9,    0,    7,    5,   -8,  -17,  -13,   -9,  -14,  -18,
     -13,    2,   15,   23,   16,    4,    5,   16,   15,    0,  -10,   -6,    3,    6,   -4,  -15,
     -15,  -10,  -11,  -16,  -16,   -5,   10,   21,   18,    7,    2,   12,   18,    6,   -7,   -9,
       1,    7,    1,  -14,  -19,  -15,  -13,  -16,  -18,   -8,    7,   19,   24,   16,    5,    8,
      16,    9,   -4,   -9,   -5,    3,    4,   -9,  -19,  -18,  -13,  -12,  -17,  -12,    2,   16,
      22,   17,    6,    4,   14,   13,    1,   -8,   -6,    2,    6,   -5,  -18,  -20,  -16,  -14,
     -18,  -17,   -5,   12,   23,   24,   14,    9,   15,   19,    9,   -5,   -8,   -3,    2,   -6,
     -17,  -23,  -19,  -14,  -16,  -17,   -8,    7,   19,   24,   19,   10,   11,   17,   13,    3,
      -5,   -3,   -2,   -4,  -14,  -24,  -25,  -20,  -18,  -16,  -10,    3,   16,   26,   28,   18,
      11,   15,   17,    9,   -4,   -7,   -6,   -6,  -12,  -24,  -29,  -22,  -16,  -15,  -10,    0,
      13,   24,   27,   22,   14,   13,   16,   13,    2,   -6,   -7,   -9,  -12,  -21,  -29,  -27,
     -21,  -15,  -10,   -3,    8,   21,   29,   26,   17,   13,   17,   19,    9,   -5,  -10,   -9,
     -12,  -21,  -30,  -29,  -22,  -14,  -10,   -4,    7,   17,   26,   23,   17,   13,   12,   18,
      16,    5,   -6,  -10,  -11,  -19,  -29,  -32,  -27,  -18,  -10,   -4,    4,   13,   25,   26,
      21,   16,   11,   16,   17,    8,   -5,  -12,  -12,  -16,  -25,  -30,  -27,  -19,  -10,   -6,
       0,   10,   21,   24,   18,   15,   13,   16,   20,   14,    1,  -10,  -12,  -15,  -26,  -31,
     -29,  -22,  -12,   -5,    0,    8,   19,   25,   22,   17,   14,   14,   19,   17,    4,  -10,
     -15,  -15,  -22,  -30,  -30,  -26,  -16,   -6,    1,    7,   15,   23,   23,   18,   17,   17,
      17,   17,    8,   -6,  -15,  -18,  -24,  -31,  -29,  -26,  -19,   -8,    2,    7,   15,   23,
      24,   21,   17,   15,   15,   17,   13,   -4,  -16,  -20,  -23,  -30,  -32,  -27,  -19,   -8,
       3,    7,   14,   23,   24,   20,   16,   16,   15,   14,   10,    0,  -12,  -20,  -24,  -31,
     -32,  -25,  -19,  -10,    0,    9,   14,   22,   27,   23,   17,   17,   18,   12,    8,    1,
     -12,  -18,  -23,  -31,  -34,  -26,  -17,   -9,   -2,    6,   14,   22,   27,   22,   16,   15,
      18,   17,   10,    3,   -9,  -17,  -21,  -31,  -38,  -32,  -23,  -13,   -5,    4,   14,   21,
      30,   30,   21,   17,   18,   17,   10,    3,   -8,  -20,  -23,  -29,  -38,  -34,  -25,  -12,
       0,    3,   11,   17,   26,   31,   23,   15,   13,   16,   14,    5,   -4,  -15,  -19,  -23,
     -35,  -38,  -32,  -19,   -7,   -5,    6,   16,   25,   36,   32,   22,   19,   19,   15,    3,
      -7,  -16,  -23,  -26,  -35,  -42,  -34,  -19,   -3,    1,    6,   18,   26,   37,   34,   20,
      15,   14,   14,    5,   -7,  -15,  -21,  -23,  -28,  -39,  -37,  -22,   -5,    1,    3,   15,
      25,   35,   40,   27,   14,   14,   14,    6,   -7,  -14,  -20,  -25,  -27,  -36,  -41,  -28,
      -8,    2,    4,   14,   24,   33,   40,   32,   17,   13,   12,    5,   -7,  -14,  -17,  -24,
     -28,  -34,  -40,  -32,  -14,    1,    4,   13,   26,   33,   41,   40,   26,   15,   12,    4,
      -9,  -17,  -20,  -25,  -31,  -34,  -41,  -38,  -20,    0,    7,   12,   24,   32,   40,   41,
      30,   17,   11,    4,  -10,  -18,  -19,  -21,  -27,  -31,  -35,  -36,  -24,   -5,    5,    9,
      21,   31,   37,   41,   36,   21,   11,    4,   -8,  -15,  -18,  -21,  -26,  -31,  -34,  -37,
     -30,  -12,    3,    9,   18,   30,   38,   44,   42,   29,   15,    7,   -6,  -18,  -23,  -24,
     -25,  -31,  -34,  -36,  -33,  -15,    3,    9,   17,   28,   38,   44,   42,   34,   20,    8,
      -5,  -18,  -23,  -22,  -24,  -30,  -35,  -35,  -35,  -24,   -6,    6,   14,   25,   36,   42,
      45,   42,   28,   13,    1,  -15,  -26,  -27,  -26,  -29,  -35,  -39,  -38,  -28,  -10,    5,
      13,   21,   36,   47,   48,   45,   36,   21,    6,  -11,  -25,  -31,  -30,  -29,  -35,  -41,
     -41,  -34,  -18,    1,   15,   24,   35,   47,   52,   51,   42,   26,    8,   -9,  -25,  -32,
     -34,  -32,  -34,  -40,  -41,  -35,  -22,   -5,   11,   21,   30,   44,   52,   51,   45,   32,
      15,   -3,  -19,  -28,  -33,  -34,  -36,  -42,  -44,  -41,  -30,  -13,    6,   20,   29,   43,
      54,   56,   50,   37,   22,    4,  -17,  -31,  -39,  -39,  -38,  -40,  -44,  -41,  -31,  -14,
       4,   18,   26,   37,   52,   57,   54,   44,   29,   11,   -9,  -26,  -38,  -42,  -40,  -41,
     -45,  -46,  -39,  -24,   -2,   17,   25,   35,   49,   59,   59,   52,   36,   19,   -2,  -22,
     -38,  -46,  -45,  -43,  -44,  -47,  -41,  -28,   -7,   12,   22,   32,   45,   58,   60,   52,
      40,   26,    9,  -14,  -36,  -46,  -47,  -44,  -44,  -50,  -47,  -34,  -14,    8,   21,   30,
      42,   58,   65,   58,   46,   32,   14,   -7,  -30,  -47,  -51,  -50,  -45,  -50,  -51,  -38,
     -20,    4,   19,   28,   38,   53,   67,   63,   50,   40,   23,    2,  -22,  -43,  -54,  -55,
     -50,  -53,  -57,  -48,  -31,   -6,   17,   28,   39,   53,   69,   72,   60,   47,   29,    7,
     -18,  -39,  -54,  -59,  -56,  -53,  -55,  -52,  -37,  -16,   10,   25,   36,   48,   65,   75,
      68,   54,   40,   20,   -6,  -31,  -52,  -61,  -61,  -59,  -63,  -62,  -46,  -24,    2,   20,
      33,   50,   67,   79,   75,   62,   49,   30,    2,  -29,  -50,  -63,  -66,  -65,  -64,  -64,
     -50,  -28,   -6,   18,   34,   48,   62,   74,   79,   70,   54,   38,   14,  -19,  -45,  -62,
     -70,  -71,  -67,  -68,  -61,  -39,  -15,   10,   28,   45,   63,   77,   82,   77,   62,   47,
      25,   -9,  -40,  -61,  -70,  -73,  -69,  -70,  -66,  -47,  -23,    2,   23,   41,   57,   71,
      79,   83,   72,   55,   37,    6,  -27,  -51,  -67,  -76,  -78,  -77,  -75,  -60,  -35,  -12,
      13,   37,   59,   75,   82,   86,   81,   66,   48,   17,  -23,  -50,  -66,  -77,  -83,  -83,
     -78,  -66,  -43,  -18,    7,   31,   54,   73,   83,   87,   87,   74,   55,   29,  -10,  -41,
     -61,  -76,  -85,  -88,  -84,  -72,  -53,  -28,   -3,   22,   51,   75,   84,   88,   92,   87,
      67,   40,    0,  -38,  -60,  -77,  -89,  -94,  -89,  -77,  -59,  -34,   -7,   17,   44,   73,
      88,   90,   91,   88,   74,   49,   12,  -29,  -57,  -73,  -84,  -93,  -94,  -84,  -68,  -44,
     -17,    8,   33,   64,   85,   90,   92,   91,   83,   63,   30,  -15,  -50,  -71,  -82,  -92,
     -96,  -90,  -74,  -52,  -26,    0,   24,   56,   82,   92,   93,   92,   89,   74,   42,    0,
     -41,  -67,  -80,  -93, -100,  -97,  -83,  -62,  -35,   -8,   16,   43,   74,   91,   96,   96,
      93,   83,   56,   16,  -28,  -61,  -79,  -92,  -99,  -99,  -90,  -71,  -45,  -16,    9,   36,
      66,   88,   98,   97,   93,   87,   68,   31,  -16,  -52,  -75,  -89,  -98, -103,  -98,  -81,
     -54,  -23,    1,   25,   56,   83,   97,   98,   92,   88,   76,   46,    1,  -42,  -68,  -81,
     -91,  -99,  -97,  -82,  -58,  -30,   -6,   15,   44,   73,   91,   94,   89,   85,   78,   55,
      16,  -28,  -59,  -77,  -87,  -93,  -95,  -85,  -65,  -40,  -16,    6,   33,   62,   85,   94,
      90,   86,   81,   66,   32,  -15,  -52,  -73,  -84,  -90,  -93,  -87,  -69,  -45,  -22,    0,
      22,   48,   75,   88,   88,   85,   80,   67,   42,    4,  -36,  -62,  -77,  -87,  -90,  -85,
     -72,  -52,  -30,  -11,   11,   36,   63,   83,   86,   86,   82,   74,   54,   17,  -25,  -55,
     -72,  -81,  -88,  -87,  -77,  -57,  -34,  -16,    4,   26,   54,   77,   84,   84,   82,   75,
      58,   27,  -12,  -45,  -65,  -76,  -84,  -84,  -76,  -61,  -41,  -24,   -7,   15,   41,   67,
      78,   81,   80,   76,   67,   42,    5,  -30,  -54,  -67,  -79,  -85,  -79,  -67,  -50,  -32,
     -16,    6,   32,   58,   73,   77,   81,   78,   68,   49,   16,  -19,  -45,  -63,  -74,  -80,
     -77,  -67,  -53,  -35,  -20,   -3,   20,   45,   65,   72,   76,   75,   68,   56,   29,   -6,
     -33,  -52,  -65,  -75,  -77,  -70,  -57,  -42,  -28,  -13,    9,   34,   57,   70,   73,   75,
      72,   63,   41,    7,  -24,  -46,  -60,  -70,  -75,  -72,  -59,  -45,  -31,  -18,    0,   25,
      48,   63,   68,   70,   71,   65,   47,   17,  -13,  -33,  -49,  -62,  -73,  -73,  -61,  -48,
     -37,  -25,  -10,   14,   39,   57,   64,   67,   70,   69,   54,   28,   -3,  -27,  -44,  -57,
     -68,  -74,  -66,  -50,  -39,  -26,  -13,    5,   30,   50,   60,   62,   64,   65,   58,   38,
       9,  -17,  -35,  -46,  -59,  -69,  -67,  -52,  -40,  -31,  -20,   -6,   18,   42,   55,   58,
      60,   65,   62,   47,   20,  -10,  -28,  -39,  -51,  -66,  -70,  -58,  -44,  -34,  -23,  -10,
      11,   34,   51,   57,   58,   62,   63,   51,   29,    2,  -21,  -34,  -46,  -60,  -69,  -63,
     -49,  -37,  -27,  -15,    3,   26,   45,   55,   56,   58,   62,   55,   37,   11,  -14,  -29,
     -39,  -52,  -65,  -66,  -52,  -40,  -30,  -18,   -5,   17,   39,   52,   54,   55,   58,   57,
      44,   21,   -8,  -24,  -33,  -45,  -59,  -66,  -57,  -43,  -31,  -20,  -11,    7,   30,   47,
      53,   51,   52,   55,   51,   33,    4,  -20,  -29,  -36,  -49,  -64,  -63,  -50,  -36,  -24,
     -14,    0,   22,   43,   55,   53,   49,   52,   51,   39,   12,  -16,  -27,  -33,  -45,  -60,
     -66,  -53,  -37,  -25,  -16,   -6,   16,   40,   53,   53,   47,   49,   51,   43,   22,    0,
       0,    0,    0,    0,    0,    0,    0,   22,    0,    0,   -2,   -2,   -2,   -2,    0,   -2,
       0,    0,    1,    2,    3,    4,    4,    4,    5,    6,    7,    6,    3,    1,    0,   -3,
      -5,  -11,  -17,  -20,  -20,  -18,  -16,  -17,  -17,  -14,  -10,   -9,  -13,  -18,  -19,  -15,
     -13,  -12,  -13,   -8,    1,   12,   25,   32,   40,   45,   50,   49,   41,   32,   24,   16,
       9,    1,  -12,  -20,  -23,  -24,  -20,  -20,  -18,  -12,  -11,  -12,   -7,    0,   10,   17,
      23,   25,   24,   21,   22,   23,   21,   10,    1,   -5,   -8,  -11,  -19,  -29,  -33,  -32,
     -26,  -19,  -16,  -14,  -12,   -8,   -7,  -11,  -19,  -27,  -29,  -27,  -25,  -25,  -24,  -17,
      -4,   13,   26,   34,   43,   54,   59,   56,   46,   33,   23,   15,    5,  -11,  -23,  -32,
     -35,  -32,  -30,  -27,  -23,  -16,  -11,   -5,    3,   11,   23,   31,   36,   33,   28,   27,
      26,   21,   11,    1,   -9,  -14,  -18,  -23,  -28,  -35,  -33,  -26,  -18,  -12,  -11,   -7,
      -4,   -2,    0,   -8,  -19,  -29,  -33,  -32,  -30,  -30,  -25,  -17,   -4,   13,   26,   36,
      47,   55,   59,   53,   43,   32,   23,   12,    0,  -14,  -23,  -30,  -35,  -35,  -35,  -33,
     -28,  -19,  -11,   -6,    3,   11,   22,   33,   39,   38,   34,   30,   27,   20,   11,    0,
      -9,  -17,  -21,  -26,  -31,  -34,  -29,  -19,   -8,   -3,    0,   -3,    1,    4,    1,  -11,
     -25,  -35,  -37,  -39,  -35,  -32,  -27,  -17,    0,   15,   29,   42,   55,   63,   62,   55,
      47,   38,   27,   14,   -4,  -20,  -31,  -40,  -44,  -46,  -45,  -41,  -34,  -25,  -14,   -3,
       8,   22,   32,   43,   44,   40,   36,   34,   26,   18,    8,   -2,  -11,  -20,  -25,  -29,
     -33,  -31,  -21,  -10,   -2,   -2,   -2,    4,    6,    9,    0,  -14,  -28,  -35,  -39,  -38,
     -38,  -36,  -30,  -16,    0,   16,   29,   41,   55,   65,   67,   59,   49,   39,   28,   13,
      -3,  -19,  -32,  -42,  -48,  -51,  -53,  -47,  -36,  -22,  -12,    0,   10,   24,   38,   46,
      48,   43,   39,   32,   26,   17,    6,   -7,  -16,  -21,  -26,  -31,  -34,  -28,  -16,   -2,
       3,    1,    2,    8,   16,   12,    2,  -15,  -27,  -34,  -37,  -41,  -47,  -44,  -33,  -16,
       1,   16,   31,   47,   65,   75,   73,   63,   52,   41,   27,    9,  -14,  -34,  -47,  -54,
     -55,  -58,  -57,  -50,  -35,  -17,    0,    8,   20,   34,   47,   54,   49,   42,   36,   29,
      21,    9,   -4,  -14,  -21,  -26,  -30,  -33,  -28,  -18,   -5,    4,    6,    6,    8,   13,
      17,   12,   -4,  -21,  -33,  -39,  -44,  -49,  -50,  -46,  -35,  -15,    4,   22,   36,   55,
      72,   81,   78,   69,   54,   42,   27,    6,  -19,  -38,  -52,  -57,  -62,  -65,  -64,  -52,
     -35,  -17,   -3,    8,   19,   33,   45,   50,   48,   42,   35,   29,   18,    7,   -5,  -11,
     -20,  -26,  -29,  -27,  -20,  -13,   -4,    3,    8,    9,   11,   12,   12,    5,   -8,  -22,
     -33,  -42,  -50,  -53,  -51,  -42,  -27,  -11,    9,   27,   45,   62,   75,   78,   73,   60,
      48,   32,   14,   -8,  -30,  -46,  -54,  -60,  -64,  -62,  -53,  -39,  -23,   -8,    5,   17,
      30,   41,   46,   44,   38,   30,   22,   11,    4,   -5,  -12,  -20,  -25,  -26,  -24,  -17,
      -7,    3,    8,   11,   12,   14,   15,   14,    9,   -4,  -17,  -32,  -44,  -54,  -57,  -56,
     -48,  -36,  -22,   -5,   18,   41,   61,   74,   79,   75,   67,   55,   39,   20,   -2,  -20,
     -37,  -47,  -56,  -62,  -63,  -57,  -44,  -31,  -18,   -5,    7,   16,   28,   35,   38,   37,
      32,   25,   16,    8,    3,   -2,   -5,  -11,  -19,  -21,  -16,   -7,    3,    6,    8,    7,
       8,   10,    9,    5,   -4,  -13,  -23,  -37,  -49,  -54,  -54,  -47,  -38,  -25,   -9,    9,
      30,   50,   67,   77,   75,   69,   58,   42,   26,    7,  -12,  -31,  -46,  -52,  -56,  -59,
     -58,  -49,  -36,  -19,   -5,    8,   14,   22,   28,   33,   35,   30,   23,   13,    4,    3,
       3,    0,   -8,  -12,  -13,  -10,   -6,    2,    8,   11,   12,   11,    9,    4,   -2,   -5,
     -12,  -23,  -35,  -46,  -52,  -54,  -48,  -36,  -22,   -8,    9,   28,   46,   61,   70,   72,
      68,   58,   45,   27,    9,   -8,  -22,  -35,  -43,  -48,  -48,  -46,  -39,  -33,  -23,  -12,
       1,    8,   11,   14,   16,   19,   19,   17,   11,    7,    8,   11,   13,    7,    5,    2,
       2,    2,    4,    6,    6,    5,    2,   -3,   -5,   -9,  -11,  -17,  -23,  -29,  -34,  -40,
     -45,  -41,  -32,  -18,   -5,    7,   19,   36,   54,   64,   67,   61,   55,   48,   36,   18,
       3,  -11,  -23,  -36,  -45,  -46,  -42,  -39,  -34,  -27,  -20,  -11,    0,   10,   13,   14,
      12,   13,   13,   10,    7,    6,    9,   11,   11,   11,   10,   10,    8,    9,    9,    9,
       6,    1,   -4,  -12,  -16,  -22,  -25,  -28,  -29,  -30,  -39,  -43,  -39,  -26,  -11,    0,
       8,   19,   33,   48,   58,   63,   61,   56,   50,   40,   25,    8,   -5,  -15,  -24,  -35,
     -41,  -42,  -39,  -32,  -29,  -25,  -21,  -13,   -6,    0,    4,    2,    2,    3,    6,    6,
       7,   11,   17,   20,   22,   23,   24,   23,   21,   17,   12,    4,   -5,  -13,  -22,  -29,
     -37,  -41,  -40,  -36,  -31,  -32,  -34,  -34,  -22,   -6,    8,   14,   20,   29,   41,   50,
      56,   56,   49,   45,   39,   30,   17,    5,   -8,  -19,  -28,  -34,  -35,  -32,  -27,  -25,
     -25,  -23,  -19,  -12,   -7,   -4,   -6,  -10,  -11,   -7,    0,    4,   10,   14,   19,   26,
      32,   35,   34,   31,   25,   16,    6,   -5,  -17,  -29,  -39,  -47,  -51,  -50,  -44,  -35,
     -28,  -27,  -25,  -18,   -6,   10,   18,   21,   25,   31,   40,   46,   49,   48,   44,   42,
      37,   29,   19,    8,   -5,  -14,  -21,  -29,  -30,  -30,  -27,  -28,  -32,  -33,  -31,  -22,
     -17,  -15,  -17,  -19,  -19,   -9,    5,   16,   22,   25,   31,   38,   44,   47,   43,   34,
      20,    6,   -9,  -21,  -35,  -49,  -59,  -62,  -60,  -53,  -42,  -30,  -22,  -15,   -6,    4,
      14,   23,   27,   28,   27,   30,   35,   38,   39,   42,   38,   35,   30,   25,   20,   12,
       4,   -6,  -18,  -23,  -22,  -20,  -22,  -30,  -37,  -39,  -34,  -29,  -27,  -27,  -26,  -23,
     -16,   -3,   10,   21,   29,   35,   43,   46,   50,   49,   41,   28,   15,   -2,  -19,  -35,
     -50,  -62,  -67,  -67,  -60,  -50,  -36,  -23,  -14,   -6,    3,   11,   21,   27,   27,   24,
      25,   27,   29,   31,   36,   41,   42,   39,   33,   27,   22,   17,    8,   -3,  -11,  -15,
     -15,  -18,  -25,  -35,  -42,  -45,  -42,  -41,  -41,  -40,  -38,  -28,  -12,    7,   22,   34,
      43,   51,   59,   62,   59,   49,   37,   20,    1,  -19,  -38,  -54,  -65,  -73,  -74,  -69,
     -55,  -35,  -19,  -10,   -2,    8,   18,   23,   25,   25,   22,   20,   19,   20,   22,   30,
      39,   44,   42,   39,   35,   32,   29,   18,    4,   -8,  -13,  -15,  -17,  -24,  -33,  -43,
     -47,  -44,  -42,  -40,  -40,  -39,  -32,  -17,    3,   16,   28,   39,   47,   53,   56,   56,
      52,   40,   24,    5,  -12,  -29,  -43,  -54,  -65,  -72,  -71,  -56,  -36,  -20,  -13,   -4,
       5,   12,   18,   21,   23,   20,   18,   14,   16,   19,   27,   38,   45,   45,   42,   41,
      42,   37,   27,   15,    1,   -8,  -12,  -13,  -17,  -30,  -40,  -47,  -48,  -47,  -46,  -46,
     -45,  -41,  -28,   -9,   11,   26,   38,   45,   51,   55,   58,   55,   47,   31,   10,  -12,
     -27,  -39,  -49,  -58,  -67,  -69,  -62,  -46,  -26,  -13,   -4,    2,    7,   14,   18,   21,
      20,   15,   11,   12,   14,   21,   32,   40,   44,   42,   42,   40,   37,   33,   22,   11,
       1,   -7,  -11,  -11,  -19,  -30,  -39,  -43,  -43,  -42,  -43,  -44,  -44,  -36,  -20,    0,
      14,   25,   35,   42,   46,   50,   50,   48,   36,   17,   -3,  -18,  -30,  -36,  -43,  -52,
     -59,  -60,  -49,  -35,  -20,  -12,   -7,   -4,    2,    8,   12,   12,    9,    9,   12,   16,
      23,   29,   39,   45,   46,   46,   43,   41,   37,   30,   20,    7,   -5,  -10,  -11,  -15,
     -25,  -39,  -46,  -45,  -43,  -42,  -45,  -46,  -39,  -26,   -8,    8,   20,   31,   41,   45,
      48,   46,   44,   36,   21,    1,  -20,  -31,  -33,  -36,  -44,  -53,  -59,  -54,  -41,  -26,
     -17,  -12,   -6,   -3,    5,    7,    9,   11,   11,   12,   15,   20,   29,   36,   42,   46,
      45,   42,   40,   38,   33,   25,   13,    4,   -7,  -10,  -11,  -17,  -29,  -38,  -38,  -34,
     -35,  -39,  -41,  -39,  -31,  -16,   -6,    4,   14,   24,   30,   34,   34,   35,   32,   22,
       8,   -9,  -16,  -16,  -17,  -22,  -33,  -43,  -46,  -41,  -34,  -30,  -25,  -19,  -14,   -9,
      -6,   -2,    5,    9,   13,   15,   21,   29,   36,   43,   47,   46,   46,   42,   39,   37,
      31,   20,   10,    0,   -6,   -9,  -14,  -22,  -29,  -33,  -31,  -30,  -34,  -37,  -37,  -30,
     -21,  -12,   -5,    1,   10,   20,   28,   31,   31,   28,   20,   12,    0,   -8,  -10,  -10,
     -16,  -24,  -33,  -39,  -44,  -42,  -35,  -28,  -23,  -18,  -14,  -10,   -4,    6,   12,   16,
      17,   22,   29,   33,   35,   38,   41,   43,   41,   38,   34,   30,   24,   16,    9,    3,
      -4,  -10,  -15,  -21,  -23,  -23,  -23,  -24,  -28,  -32,  -31,  -28,  -22,  -15,  -10,   -6,
       2,   11,   20,   23,   25,   19,   14,    9,    5,    3,    2,   -2,   -8,  -19,  -28,  -36,
     -42,  -44,  -39,  -33,  -28,  -26,  -20,  -11,    0,    8,   15,   22,   28,   33,   35,   36,
      37,   38,   41,   40,   38,   32,   27,   21,   17,   11,    4,   -3,   -8,  -12,  -17,  -18,
     -16,  -16,  -15,  -18,  -22,  -25,  -26,  -25,  -23,  -19,  -15,   -9,   -2,    8,   13,   17,
      18,   17,   16,   15,   13,   10,    6,    0,   -9,  -21,  -32,  -42,  -47,  -46,  -43,  -36,
     -30,  -22,  -15,   -6,    4,   14,   22,   28,   33,   36,   37,   36,   35,   37,   36,   36,
      32,   27,   23,   16,   10,    5,    0,   -7,  -10,  -12,  -11,  -11,  -11,  -10,   -9,  -11,
     -16,  -22,  -27,  -30,  -30,  -30,  -25,  -19,   -9,    0,    7,   13,   18,   23,   27,   27,
      26,   20,   12,    1,  -13,  -27,  -40,  -50,  -54,  -54,  -49,  -42,  -33,  -21,  -10,    1,
      14,   24,   30,   39,   44,   43,   38,   36,   38,   37,   34,   31,   28,   22,   13,    7,
       5,   -2,   -7,  -11,  -14,  -13,  -13,   -8,   -6,   -6,  -10,  -12,  -14,  -19,  -26,  -34,
     -38,  -33,  -26,  -15,   -7,    2,    7,   17,   26,   35,   40,   37,   29,   19,    7,  -12,
     -31,  -44,  -53,  -56,  -61,  -62,  -59,  -46,  -27,   -9,    5,   14,   25,   36,   47,   53,
      51,   45,   37,   34,   32,   29,   26,   23,   18,   13,    5,    0,   -3,   -4,   -6,  -10,
     -12,  -12,   -6,    2,    6,    2,   -6,  -12,  -17,  -21,  -31,  -41,  -47,  -43,  -32,  -20,
     -11,   -4,    9,   21,   40,   50,   48,   42,   34,   22,    5,  -16,  -36,  -53,  -58,  -63,
     -69,  -73,  -63,  -43,  -19,   -2,    9,   19,   34,   50,   60,   61,   53,   42,   37,   32,
      30,   24,   21,   16,   11,    4,   -4,   -7,   -6,   -5,   -5,  -10,  -14,  -11,   -4,    3,
       2,   -2,   -8,  -13,  -19,  -26,  -36,  -42,  -40,  -33,  -21,   -9,    1,   10,   22,   36,
      49,   53,   47,   36,   19,    1,  -18,  -36,  -51,  -60,  -65,  -67,  -67,  -63,  -47,  -24,
      -4,   11,   20,   33,   48,   57,   57,   52,   42,   33,   30,   28,   25,   19,   16,   12,
       8,    3,   -2,   -2,   -2,   -2,   -5,   -8,  -10,   -5,   -2,    0,    0,   -5,   -8,  -15,
     -23,  -32,  -39,  -38,  -33,  -24,  -15,   -7,    5,   16,   30,   45,   52,   49,   40,   23,
       4,  -14,  -29,  -42,  -55,  -63,  -67,  -67,  -61,  -50,  -35,  -19,    0,   16,   31,   46,
      56,   59,   56,   47,   38,   34,   31,   28,   23,   16,   10,    4,    0,   -2,   -2,    0,
      -5,   -9,  -12,  -11,   -7,   -3,   -3,   -4,   -5,   -4,   -7,  -14,  -26,  -33,  -32,  -27,
     -20,  -15,   -7,    2,   13,   21,   34,   42,   46,   40,   25,    7,  -13,  -27,  -35,  -44,
     -54,  -62,  -64,  -60,  -51,  -39,  -26,  -10,    8,   24,   40,   51,   58,   60,   54,   44,
      36,   29,   24,   19,   13,    8,    0,   -6,   -5,    0,    1,    0,   -4,   -3,   -2,    0,
       1,   -2,   -5,   -5,   -4,   -7,  -17,  -27,  -31,  -29,  -24,  -19,  -15,   -9,   -3,    7,
      18,   27,   34,   39,   37,   26,    9,   -9,  -24,  -32,  -39,  -47,  -55,  -60,  -57,  -51,
     -42,  -32,  -20,   -6,   14,   31,   48,   57,   60,   58,   52,   45,   35,   25,   21,   17,
       9,    0,   -8,  -10,   -8,   -7,   -6,   -9,   -9,   -6,   -2,    0,   -3,   -6,   -6,   -2,
       1,   -6,  -15,  -25,  -25,  -20,  -17,  -13,  -11,   -7,    1,    8,   16,   24,   31,   34,
      29,   16,   -3,  -17,  -28,  -35,  -41,  -47,  -54,  -56,  -54,  -46,  -37,  -27,  -15,    4,
      23,   40,   50,   58,   60,   58,   50,   42,   34,   26,   19,   14,    4,   -6,  -13,  -13,
     -13,  -14,  -16,  -15,  -12,   -9,   -7,   -7,   -4,   -4,    2,    7,    5,    0,   -8,  -11,
     -13,  -13,  -11,  -10,  -11,  -11,   -9,    0,    8,   14,   22,   24,   19,    9,   -3,  -14,
     -23,  -29,  -32,  -38,  -47,  -54,  -52,  -44,  -32,  -23,   -9,    8,   23,   39,   52,   59,
      58,   51,   46,   43,   33,   25,   16,    9,    4,   -4,  -11,  -15,  -16,  -16,  -15,  -14,
     -15,  -16,  -13,   -7,   -5,    2,    5,    5,    5,    6,    3,   -4,   -6,   -4,   -5,  -10,
     -16,  -16,  -13,   -6,    4,   12,   15,   17,   14,   10,    4,   -8,  -17,  -23,  -30,  -38,
     -46,  -52,  -51,  -41,  -30,  -20,   -8,    9,   29,   47,   56,   57,   55,   52,   50,   45,
      34,   20,   10,    2,   -2,   -9,  -16,  -22,  -24,  -22,  -21,  -22,  -19,  -14,   -7,   -4,
       1,    5,   11,   15,   20,   17,    9,    3,    3,    0,   -6,  -15,  -21,  -23,  -16,   -9,
      -3,    4,   10,   13,   15,   13,    4,   -9,  -15,  -20,  -27,  -39,  -48,  -51,  -47,  -38,
     -29,  -21,   -7,   16,   36,   48,   51,   52,   55,   60,   59,   49,   33,   20,   12,    7,
      -2,  -13,  -24,  -28,  -27,  -26,  -30,  -32,  -29,  -20,   -9,    0,    3,    8,   16,   25,
      28,   23,   17,   12,    6,   -2,  -14,  -26,  -31,  -27,  -18,  -10,   -3,    7,   15,   22,
      24,   18,    9,    0,   -9,  -19,  -34,  -46,  -57,  -57,  -51,  -44,  -38,  -26,   -5,   21,
      42,   48,   53,   58,   67,   75,   71,   57,   37,   23,   12,    3,  -12,  -27,  -39,  -43,
     -43,  -45,  -47,  -42,  -28,  -12,    2,    7,   12,   20,   32,   38,   37,   30,   21,   13,
       1,  -13,  -26,  -34,  -33,  -26,  -17,  -10,   -3,    9,   20,   25,   22,   13,    5,   -3,
     -13,  -28,  -43,  -53,  -56,  -51,  -46,  -40,  -31,  -14,   10,   31,   41,   47,   56,   67,
      76,   73,   63,   46,   30,   19,    9,   -7,  -25,  -39,  -47,  -50,  -54,  -52,  -50,  -38,
     -22,   -9,    4,   12,   22,   30,   39,   41,   39,   31,   22,   12,   -3,  -19,  -30,  -32,
     -29,  -23,  -17,   -9,    1,   12,   20,   24,   18,   10,    2,   -7,  -19,  -35,  -50,  -59,
     -59,  -54,  -49,  -43,  -31,   -9,   15,   32,   41,   53,   70,   85,   87,   80,   64,   49,
      37,   23,    2,  -23,  -42,  -52,  -59,  -66,  -69,  -68,  -56,  -38,  -18,   -2,    9,   19,
      31,   41,   49,   51,   44,   35,   21,    5,   -9,  -22,  -29,  -30,  -26,  -20,  -14,   -7,
       5,   15,   17,   14,    9,    2,   -4,  -16,  -29,  -45,  -55,  -56,  -50,  -46,  -44,  -36,
     -19,    1,   19,   33,   46,   63,   79,   86,   84,   73,   60,   47,   32,   12,  -10,  -30,
     -48,  -59,  -68,  -72,  -73,  -64,  -49,  -30,  -12,    2,   12,   26,   35,   45,   51,   51,
      44,   30,   15,    3,   -9,  -17,  -20,  -21,  -19,  -18,  -14,    0,   10,   16,   15,    7,
      -4,  -10,  -14,  -24,  -38,  -51,  -58,  -55,  -50,  -44,  -36,  -23,   -7,   10,   26,   41,
      57,   76,   89,   89,   81,   70,   59,   45,   25,    0,  -24,  -41,  -56,  -67,  -75,  -80,
     -76,  -63,  -45,  -26,   -9,    6,   20,   32,   44,   52,   54,   53,   47,   35,   18,    3,
      -6,  -11,  -14,  -16,  -19,  -19,  -12,   -4,    5,    5,    0,   -8,  -12,  -15,  -21,  -34,
     -47,  -51,  -45,  -39,  -34,  -30,  -23,  -12,    4,   17,   31,   45,   60,   72,   78,   75,
      69,   62,   53,   40,   18,   -5,  -24,  -38,  -50,  -62,  -73,  -78,  -74,  -59,  -41,  -28,
     -17,   -4,   14,   33,   47,   55,   58,   55,   48,   39,   29,   16,    4,   -5,  -11,  -18,
     -21,  -20,  -15,   -8,   -7,   -9,  -13,  -15,  -16,  -17,  -23,  -33,  -43,  -44,  -41,  -34,
     -28,  -23,  -16,   -8,    5,   21,   36,   50,   62,   73,   76,   73,   68,   59,   48,   30,
       9,  -16,  -35,  -48,  -59,  -70,  -77,  -79,  -72,  -54,  -38,  -24,   -8,    8,   29,   45,
      56,   61,   62,   56,   51,   39,   27,   16,    4,   -8,  -16,  -22,  -23,  -25,  -19,  -16,
     -17,  -19,  -20,  -21,  -18,  -19,  -25,  -32,  -38,  -34,  -24,  -19,  -15,  -12,   -7,    3,
      15,   28,   39,   48,   56,   63,   63,   63,   57,   47,   32,   14,   -5,  -22,  -36,  -46,
     -58,  -68,  -73,  -71,  -61,  -47,  -35,  -23,   -9,   10,   29,   43,   52,   56,   56,   56,
      52,   45,   33,   19,    6,   -5,  -15,  -22,  -25,  -26,  -26,  -29,  -29,  -26,  -24,  -20,
     -19,  -23,  -27,  -30,  -27,  -21,  -18,  -14,  -10,   -7,    0,    8,   18,   30,   40,   47,
      52,   54,   54,   55,   49,   39,   22,    7,   -9,  -24,  -37,  -50,  -58,  -65,  -71,  -67,
     -59,  -50,  -39,  -23,   -6,   15,   32,   43,   51,   57,   61,   64,   61,   52,   37,   21,
       4,  -11,  -20,  -26,  -30,  -35,  -37,  -39,  -35,  -29,  -22,  -17,  -20,  -22,  -20,  -18,
     -17,  -16,  -13,   -8,   -3,    2,    7,   10,   17,   27,   35,   42,   43,   44,   45,   44,
      38,   28,   16,    3,  -10,  -22,  -33,  -46,  -57,  -64,  -64,  -59,  -53,  -46,  -34,  -17,
       3,   21,   32,   41,   48,   55,   60,   60,   54,   44,   31,   18,    3,  -10,  -19,  -27,
     -30,  -32,  -34,  -35,  -30,  -23,  -17,  -17,  -20,  -20,  -20,  -17,  -15,  -13,  -11,   -8,
       1,    8,   12,   17,   23,   30,   39,   39,   37,   36,   35,   34,   27,   14,    0,  -10,
     -15,  -23,  -34,  -46,  -56,  -60,  -56,  -49,  -39,  -32,  -23,   -8,    8,   23,   32,   38,
      44,   54,   58,   57,   48,   37,   29,   17,    4,  -11,  -21,  -28,  -29,  -31,  -34,  -35,
     -27,  -20,  -15,  -16,  -16,  -17,  -13,  -10,  -10,  -11,  -10,   -4,    5,   11,   13,   15,
      21,   29,   33,   32,   28,   25,   25,   23,   16,    5,   -6,  -10,  -16,  -21,  -30,  -42,
     -48,  -48,  -43,  -34,  -29,  -21,  -13,   -3,   11,   22,   27,   34,   39,   48,   53,   48,
      42,   32,   23,   16,    4,   -7,  -18,  -24,  -24,  -26,  -28,  -24,  -19,  -14,  -13,  -16,
     -18,  -18,  -16,  -14,  -15,  -16,  -15,   -7,    3,   11,   14,   21,   27,   33,   36,   33,
      30,   25,   22,   17,    9,   -4,  -15,  -21,  -24,  -31,  -39,  -44,  -44,  -39,  -30,  -23,
     -16,   -8,    4,   14,   21,   23,   25,   29,   37,   43,   42,   36,   31,   25,   18,   11,
       4,   -7,  -11,  -13,  -16,  -21,  -22,  -18,  -14,  -13,  -16,  -19,  -21,  -21,  -19,  -19,
     -20,  -18,  -11,   -2,    8,   14,   18,   23,   30,   34,   35,   31,   27,   21,   13,    2,
     -11,  -17,  -23,  -28,  -36,  -39,  -40,  -37,  -31,  -23,  -14,   -9,    0,    7,   13,   15,
      15,   16,   22,   27,   30,   28,   29,   32,   29,   23,   16,    9,    4,    1,   -2,   -7,
     -14,  -19,  -14,  -10,  -10,  -14,  -18,  -22,  -24,  -23,  -26,  -28,  -27,  -18,   -8,   -3,
       2,    9,   22,   33,   40,   40,   36,   30,   25,   20,    8,   -8,  -22,  -29,  -32,  -39,
     -48,  -50,  -42,  -30,  -19,  -13,   -8,    2,   11,   22,   25,   21,   17,   15,   20,   23,
      21,   20,   20,   19,   19,   16,   11,    9,    7,    7,    3,    0,   -3,   -5,   -5,   -5,
      -7,  -12,  -22,  -28,  -32,  -35,  -35,  -36,  -30,  -21,  -12,   -4,    3,   16,   29,   39,
      46,   45,   40,   34,   26,   13,   -2,  -17,  -28,  -37,  -48,  -57,  -60,  -52,  -36,  -19,
     -12,   -8,    2,   16,   28,   33,   28,   23,   21,   22,   21,   19,   18,   16,   14,   12,
       8,    6,    5,    5,    7,    5,    4,    5,    7,    9,    7,    3,   -5,  -13,  -22,  -28,
     -35,  -44,  -49,  -48,  -38,  -26,  -14,   -7,    4,   20,   38,   49,   54,   53,   49,   40,
      26,    8,  -11,  -24,  -33,  -46,  -61,  -70,  -67,  -52,  -31,  -14,   -5,    4,   14,   27,
      36,   36,   33,   29,   26,   25,   21,   14,   10,    7,    8,    6,    5,    5,    6,    8,
       9,   10,   14,   18,   17,   13,    5,   -4,  -12,  -20,  -28,  -37,  -49,  -56,  -56,  -48,
     -36,  -25,  -15,   -2,   16,   36,   51,   55,   57,   55,   48,   37,   20,    1,  -17,  -30,
     -43,  -60,  -73,  -76,  -63,  -43,  -24,  -14,   -6,    7,   23,   39,   44,   38,   34,   31,
      32,   30,   24,   16,    8,    5,    6,    6,    5,    5,    6,   10,   10,   13,   16,   19,
      19,   14,    5,   -7,  -18,  -25,  -34,  -45,  -55,  -61,  -59,  -51,  -39,  -25,  -12,    5,
      27,   48,   58,   60,   61,   58,   49,   32,   14,   -4,  -20,  -36,  -54,  -69,  -79,  -75,
     -57,  -35,  -21,  -15,   -4,   12,   28,   39,   42,   41,   38,   38,   38,   33,   23,   13,
       8,    9,   11,    9,    5,    3,    6,   10,   13,   14,   15,   17,   16,    9,   -6,  -16,
     -21,  -27,  -40,  -56,  -65,  -67,  -57,  -45,  -33,  -23,   -5,   21,   44,   60,   66,   67,
      65,   61,   47,   25,    2,  -16,  -34,  -53,  -72,  -83,  -82,  -70,  -51,  -33,  -20,   -8,
       8,   25,   39,   46,   43,   43,   43,   43,   38,   27,   17,    9,    8,   10,   11,    9,
       5,    5,    8,   13,   14,   18,   20,   18,   12,   -2,  -13,  -19,  -25,  -34,  -48,  -62,
     -69,  -67,  -58,  -46,  -32,  -14,    9,   30,   48,   60,   69,   72,   69,   57,   36,   13,
      -6,  -27,  -47,  -66,  -79,  -83,  -77,  -64,  -46,  -29,  -13,    4,   17,   30,   39,   41,
      46,   48,   45,   40,   31,   20,   12,   10,   13,   14,   12,   11,   10,   10,   15,   17,
      20,   20,   17,   12,    0,  -14,  -24,  -30,  -37,  -47,  -60,  -69,  -68,  -62,  -51,  -36,
     -18,    5,   25,   45,   58,   65,   68,   67,   59,   42,   20,   -2,  -22,  -42,  -61,  -75,
     -81,  -77,  -66,  -51,  -35,  -20,   -4,   14,   28,   37,   38,   38,   42,   47,   43,   35,
      24,   17,   14,   14,   17,   20,   20,   17,   13,   14,   17,   18,   18,   17,   11,   -2,
     -15,  -24,  -31,  -38,  -46,  -52,  -58,  -62,  -61,  -52,  -38,  -22,   -4,   16,   35,   48,
      55,   60,   62,   57,   46,   26,    6,  -17,  -35,  -53,  -68,  -76,  -75,  -66,  -51,  -38,
     -23,   -7,   10,   25,   35,   38,   37,   39,   40,   39,   30,   21,   16,   15,   15,   16,
      20,   24,   26,   27,   27,   26,   24,   21,   19,   11,   -3,  -16,  -29,  -40,  -44,  -50,
     -54,  -57,  -58,  -55,  -48,  -36,  -21,   -5,   13,   29,   41,   48,   52,   53,   50,   41,
      26,    7,  -14,  -33,  -49,  -62,  -70,  -69,  -61,  -48,  -36,  -21,   -5,   16,   30,   35,
      35,   35,   32,   31,   29,   24,   17,   13,   13,   14,   15,   18,   26,   34,   39,   37,
      32,   29,   26,   22,   13,    1,  -15,  -29,  -40,  -46,  -51,  -54,  -55,  -52,  -46,  -40,
     -32,  -22,  -10,    5,   19,   28,   33,   35,   37,   38,   33,   21,    8,   -7,  -20,  -35,
     -50,  -57,  -57,  -49,  -37,  -28,  -21,   -8,   10,   25,   32,   32,   31,   27,   24,   22,
      20,   15,   13,   13,   15,   15,   19,   26,   36,   42,   43,   40,   33,   27,   22,   16,
       3,  -13,  -26,  -37,  -44,  -50,  -55,  -54,  -48,  -42,  -32,  -24,  -18,  -10,   -3,    8,
      20,   30,   31,   26,   22,   20,   15,    7,   -7,  -20,  -32,  -43,  -52,  -52,  -46,  -36,
     -25,  -16,   -5,    9,   24,   38,   42,   39,   30,   23,   19,   15,   11,    8,    6,    6,
       6,    9,   18,   30,   42,   47,   45,   43,   38,   31,   22,    8,   -9,  -21,  -33,  -45,
     -55,  -59,  -56,  -47,  -37,  -29,  -21,  -13,   -5,    2,    8,   13,   19,   22,   20,   15,
       9,    5,   -3,   -9,  -20,  -30,  -39,  -46,  -45,  -40,  -31,  -24,  -16,   -6,    7,   21,
      35,   39,   36,   31,   24,   22,   15,   10,    8,    5,    6,    3,    4,   12,   25,   40,
      48,   50,   48,   43,   37,   30,   17,   -2,  -18,  -33,  -45,  -57,  -64,  -62,  -53,  -40,
     -31,  -23,  -13,   -3,    4,   11,   16,   19,   18,   17,   13,    7,   -3,  -10,  -16,  -22,
     -31,  -40,  -45,  -45,  -41,  -32,  -24,  -15,   -5,    8,   24,   39,   47,   44,   38,   32,
      26,   20,   12,    3,   -4,   -4,   -5,   -4,    1,   11,   29,   41,   49,   51,   49,   45,
      38,   27,    9,  -11,  -27,  -38,  -52,  -60,  -64,  -58,  -45,  -32,  -21,  -14,   -5,    3,
      10,   13,   13,   14,   14,   12,    4,   -6,  -12,  -17,  -21,  -25,  -31,  -35,  -40,  -39,
     -33,  -27,  -19,  -12,    1,   16,   29,   38,   42,   40,   36,   33,   30,   22,   11,    1,
      -2,   -2,   -3,   -2,    2,   16,   32,   44,   48,   46,   44,   39,   31,   19,    1,  -21,
     -36,  -48,  -58,  -62,  -59,  -49,  -38,  -28,  -20,  -12,   -2,    9,   16,   16,   15,   16,
      14,    9,    2,   -7,  -14,  -19,  -25,  -31,  -36,  -38,  -38,  -36,  -34,  -28,  -20,   -7,
       8,   22,   33,   41,   46,   46,   42,   39,   33,   25,   14,    4,   -4,   -8,   -8,   -4,
       4,   16,   30,   38,   42,   46,   45,   38,   25,   10,   -7,  -24,  -39,  -51,  -58,  -59,
     -53,  -43,  -34,  -28,  -21,   -9,    5,   15,   17,   16,   15,   16,   15,   10,    2,  -10,
     -17,  -21,  -26,  -33,  -38,  -40,  -37,  -34,  -33,  -28,  -17,    0,   15,   29,   40,   48,
      50,   48,   44,   40,   34,   26,   15,    3,   -6,  -11,  -11,   -4,    7,   18,   24,   30,
      36,   38,   35,   31,   24,   13,   -7,  -25,  -40,  -50,  -53,  -51,  -47,  -41,  -38,  -33,
     -25,  -10,    4,   14,   19,   21,   22,   19,   19,   17,    7,   -5,  -15,  -23,  -31,  -39,
     -46,  -49,  -49,  -46,  -41,  -33,  -19,    0,   21,   39,   53,   61,   64,   63,   56,   50,
      42,   31,   15,   -2,  -13,  -19,  -19,  -11,    0,   10,   15,   19,   27,   33,   37,   35,
      25,    9,  -13,  -28,  -38,  -44,  -46,  -50,  -53,  -51,  -46,  -38,  -23,   -7,   10,   20,
      21,   24,   25,   28,   28,   19,    8,   -7,  -18,  -28,  -36,  -43,  -52,  -56,  -57,  -51,
     -44,  -31,  -13,    7,   29,   46,   60,   66,   71,   68,   61,   54,   45,   32,   13,   -5,
     -17,  -22,  -20,  -15,   -8,   -2,    8,   14,   24,   31,   35,   32,   21,    4,  -13,  -24,
     -34,  -42,  -49,  -55,  -58,  -54,  -48,  -38,  -23,   -4,   14,   26,   32,   31,   32,   36,
      34,   23,    7,  -12,  -25,  -35,  -47,  -61,  -68,  -68,  -61,  -53,  -42,  -26,   -7,   22,
      45,   61,   71,   75,   78,   74,   66,   56,   42,   24,    7,  -13,  -24,  -29,  -25,  -18,
     -11,   -7,    2,   14,   27,   36,   38,   32,   19,    1,  -14,  -22,  -33,  -44,  -56,  -64,
     -65,  -60,  -47,  -32,  -16,    3,   18,   31,   37,   37,   38,   41,   35,   20,    0,  -18,
     -31,  -43,  -56,  -64,  -69,  -68,  -60,  -50,  -36,  -15,    6,   31,   50,   62,   71,   77,
      78,   74,   66,   54,   38,   20,    2,  -15,  -23,  -26,  -24,  -22,  -17,   -7,    8,   20,
      29,   35,   33,   25,   13,   -2,  -14,  -29,  -42,  -57,  -67,  -72,  -67,  -57,  -42,  -24,
      -5,   13,   31,   43,   46,   47,   48,   43,   32,   14,   -5,  -22,  -40,  -55,  -63,  -68,
     -69,  -66,  -57,  -44,  -25,   -5,   18,   37,   55,   66,   75,   78,   75,   70,   62,   47,
      28,    9,   -7,  -19,  -27,  -30,  -27,  -21,  -11,    5,   18,   28,   34,   36,   32,   24,
      12,   -4,  -20,  -38,  -55,  -68,  -75,  -71,  -65,  -53,  -35,  -14,    6,   24,   39,   47,
      50,   48,   44,   36,   22,    5,  -16,  -34,  -47,  -56,  -60,  -60,  -59,  -54,  -45,  -28,
      -9,    9,   25,   41,   53,   63,   67,   66,   65,   62,   54,   40,   22,    6,   -8,  -16,
     -22,  -23,  -20,  -11,    1,   13,   22,   27,   29,   26,   24,   15,    2,  -15,  -33,  -49,
     -64,  -74,  -74,  -67,  -55,  -39,  -20,   -2,   16,   32,   45,   50,   49,   43,   35,   26,
      11,   -9,  -25,  -35,  -44,  -49,  -52,  -54,  -50,  -39,  -26,  -12,    1,   14,   27,   39,
      48,   53,   55,   57,   56,   48,   36,   25,   15,    6,   -5,  -12,  -17,  -14,   -8,    3,
      14,   21,   26,   23,   21,   21,   14,    3,  -11,  -26,  -44,  -61,  -72,  -72,  -68,  -56,
     -42,  -25,  -11,    7,   24,   37,   44,   44,   40,   33,   25,   13,    0,  -12,  -24,  -32,
     -39,  -41,  -39,  -36,  -30,  -24,  -18,  -10,    1,   11,   21,   29,   36,   41,   47,   51,
      51,   42,   35,   27,   19,   10,    1,   -6,  -10,   -9,   -2,    6,   11,   13,   13,   15,
      14,   10,    4,   -9,  -19,  -31,  -45,  -58,  -67,  -68,  -56,  -43,  -31,  -20,   -9,    7,
      21,   31,   35,   35,   33,   27,   18,    7,   -3,   -9,  -13,  -20,  -27,  -32,  -33,  -29,
     -23,  -19,  -16,  -12,   -4,    6,   15,   23,   30,   39,   47,   49,   42,   35,   31,   27,
      22,   14,    2,   -8,   -9,   -4,    5,    8,    8,    9,    7,    6,    3,    0,   -5,  -12,
     -22,  -35,  -50,  -58,  -58,  -50,  -39,  -32,  -26,  -19,   -8,    7,   21,   26,   27,   25,
      22,   18,   11,    5,    2,    1,   -3,  -10,  -19,  -24,  -23,  -16,  -15,  -17,  -20,  -17,
     -10,   -2,    6,   12,   21,   32,   44,   45,   38,   30,   27,   31,   31,   21,    8,    1,
       0,    2,    8,   10,    7,    1,   -3,   -2,   -4,   -9,  -12,  -17,  -25,  -37,  -47,  -53,
     -50,  -42,  -32,  -27,  -26,  -22,  -11,    5,   15,   18,   20,   22,   23,   22,   18,   15,
      14,   11,    7,   -3,  -14,  -18,  -17,  -18,  -22,  -27,  -27,  -21,  -14,   -6,    3,   12,
      24,   34,   40,   39,   35,   32,   31,   34,   30,   19,   10,    4,    2,    5,    7,    7,
       1,   -6,  -10,   -9,   -8,   -8,  -11,  -16,  -25,  -34,  -41,  -41,  -36,  -32,  -33,  -33,
     -29,  -22,  -11,   -2,    6,   13,   17,   22,   23,   22,   22,   24,   23,   20,   12,    0,
      -7,  -11,  -14,  -20,  -26,  -28,  -26,  -22,  -15,   -9,    2,   13,   25,   32,   33,   35,
      36,   37,   38,   35,   29,   19,    9,    5,    7,    6,    4,   -3,   -9,  -12,  -11,   -6,
      -4,   -5,  -10,  -17,  -26,  -33,  -37,  -38,  -38,  -38,  -41,  -39,  -31,  -20,   -9,   -2,
       6,   15,   23,   31,   31,   31,   30,   29,   28,   21,   13,    2,   -9,  -17,  -20,  -23,
     -26,  -27,  -26,  -20,  -14,   -6,    6,   14,   22,   26,   32,   34,   35,   37,   37,   36,
      27,   15,    6,    6,    7,    5,   -3,  -13,  -17,  -17,  -11,   -5,   -5,   -6,  -11,  -18,
     -24,  -27,  -30,  -35,  -40,  -44,  -44,  -39,  -28,  -16,   -6,    1,    9,   20,   31,   34,
      36,   37,   36,   33,   23,   14,    5,   -3,  -10,  -17,  -23,  -30,  -34,  -31,  -22,  -14,
      -8,    0,    7,   15,   20,   26,   30,   35,   40,   40,   34,   27,   18,   14,    9,    8,
       5,   -2,  -11,  -15,  -13,   -8,   -4,    0,    1,   -6,  -12,  -18,  -23,  -29,  -38,  -45,
     -52,  -53,  -47,  -37,  -28,  -16,   -5,    6,   17,   28,   37,   42,   43,   40,   37,   31,
      19,    8,    1,   -7,  -14,  -22,  -27,  -33,  -34,  -28,  -18,   -8,    0,    5,   10,   14,
      19,   25,   33,   38,   39,   35,   27,   18,   13,    9,    8,    4,   -3,   -8,  -12,  -13,
     -10,   -4,    4,    4,   -2,   -7,  -14,  -21,  -28,  -36,  -45,  -53,  -54,  -50,  -44,  -34,
     -20,   -5,    7,   18,   28,   37,   39,   42,   40,   35,   28,   17,    7,    0,   -7,  -12,
     -18,  -23,  -28,  -28,  -23,  -17,   -8,    2,    8,    9,   10,   12,   17,   25,   32,   33,
      28,   20,   13,   10,   10,    8,    6,    5,    1,   -5,   -6,   -3,    3,   10,   10,    5,
      -6,  -15,  -21,  -28,  -38,  -49,  -59,  -62,  -59,  -51,  -39,  -25,   -8,    7,   17,   28,
      37,   42,   44,   43,   38,   30,   17,    7,    0,   -4,  -10,  -16,  -24,  -26,  -27,  -21,
     -14,   -9,   -2,    5,   11,   14,   12,   13,   19,   26,   29,   26,   19,   13,    8,    8,
       9,    5,    2,    2,    4,    3,    1,    1,    5,    8,    7,    0,  -10,  -18,  -25,  -32,
     -42,  -52,  -56,  -53,  -48,  -38,  -29,  -14,    1,   14,   23,   30,   33,   33,   35,   33,
      26,   17,    9,    2,    1,    0,   -5,  -12,  -19,  -22,  -21,  -13,   -8,   -4,    5,   10,
      12,   10,   10,   14,   21,   25,   24,   15,    5,    3,    5,    7,    5,    2,    5,   10,
      12,   10,    9,   11,   13,   10,    2,   -8,  -18,  -25,  -32,  -40,  -50,  -55,  -53,  -45,
     -35,  -27,  -17,   -4,   11,   20,   28,   30,   28,   29,   30,   28,   19,   10,    6,    6,
       5,    0,  -10,  -18,  -20,  -18,  -14,  -11,  -10,   -4,    6,   13,   13,   11,   13,   20,
      25,   24,   15,    7,    3,    4,    5,    4,    0,    3,    9,   14,   15,   11,    9,    8,
       8,    6,   -5,  -16,  -24,  -29,  -35,  -43,  -48,  -47,  -42,  -31,  -23,  -17,   -7,    5,
      17,   24,   26,   22,   19,   19,   20,   17,   11,    5,    2,    2,    0,   -4,  -10,  -14,
     -14,  -10,   -8,   -6,    1,   10,   19,   23,   22,   17,   16,   19,   18,   11,    1,   -8,
     -11,  -10,   -7,   -4,    1,    7,   15,   22,   22,   18,   17,   16,   12,    4,   -8,  -21,
     -29,  -34,  -39,  -46,  -49,  -46,  -37,  -28,  -19,   -9,   -2,    8,   19,   22,   20,   18,
      18,   19,   19,   12,    6,    3,    2,    0,   -5,  -10,  -16,  -18,  -14,   -9,   -8,   -3,
       6,   17,   25,   27,   26,   24,   25,   22,   15,    3,   -8,  -13,  -13,  -12,  -11,   -6,
       0,    9,   16,   19,   19,   16,   13,   10,    6,   -5,  -14,  -22,  -26,  -32,  -37,  -41,
     -39,  -32,  -23,  -17,  -14,  -10,   -3,    9,   17,   18,   10,    7,   10,   16,   18,   12,
       5,    1,    1,   -4,  -13,  -18,  -18,  -15,  -12,  -11,  -10,    1,   15,   29,   37,   35,
      31,   30,   30,   24,   11,   -8,  -18,  -18,  -15,  -17,  -20,  -17,   -6,    8,   15,   18,
      16,   15,   11,   12,    8,    0,  -10,  -16,  -20,  -28,  -35,  -38,  -33,  -27,  -23,  -21,
     -19,  -13,    0,   11,   14,   12,    9,   11,   18,   21,   19,   10,    2,   -3,   -5,  -12,
     -21,  -28,  -26,  -20,  -15,  -12,   -6,    9,   25,   38,   43,   42,   40,   38,   34,   23,
       6,  -12,  -18,  -18,  -18,  -23,  -25,  -22,  -13,    0,    7,    9,    8,    8,   11,   12,
       9,    6,    2,   -5,  -14,  -21,  -24,  -24,  -22,  -22,  -21,  -22,  -20,  -12,   -3,    4,
       5,    5,    6,   11,   15,   16,   10,    4,   -2,   -7,  -11,  -20,  -25,  -27,  -21,  -13,
     -11,   -5,    6,   22,   37,   46,   50,   49,   44,   39,   31,   16,   -3,  -15,  -21,  -24,
     -27,  -32,  -33,  -28,  -17,   -5,    5,    7,    7,   10,   15,   16,   15,   10,    4,   -4,
     -11,  -18,  -22,  -22,  -20,  -22,  -21,  -21,  -17,  -10,    1,    6,    9,   10,   15,   19,
      18,   12,    5,    0,   -9,  -15,  -23,  -31,  -36,  -32,  -24,  -17,  -11,   -4,   12,   31,
      47,   53,   58,   60,   56,   49,   35,   15,   -4,  -16,  -21,  -25,  -32,  -42,  -45,  -35,
     -23,  -14,   -8,    0,    6,   13,   20,   21,   19,   15,    9,    1,   -6,  -11,  -13,  -16,
     -18,  -20,  -23,  -20,  -14,   -8,    0,    2,    5,   11,   18,   18,   14,    6,   -2,  -10,
     -18,  -27,  -34,  -41,  -40,  -31,  -20,  -12,   -7,    4,   23,   47,   64,   71,   71,   63,
      56,   46,   30,   12,   -7,  -22,  -35,  -42,  -49,  -52,  -48,  -34,  -22,  -14,   -7,    3,
      15,   24,   27,   27,   24,   15,    6,   -4,   -8,  -11,  -13,  -13,  -15,  -16,  -14,  -12,
      -7,   -2,    3,   10,   12,   14,   15,    7,    0,   -7,  -16,  -25,  -32,  -40,  -44,  -44,
     -36,  -24,  -11,    0,    6,   16,   36,   58,   72,   76,   71,   62,   51,   38,   24,    5,
     -13,  -30,  -42,  -50,  -52,  -53,  -46,  -33,  -21,  -15,   -6,    7,   20,   25,   25,   21,
      18,   14,    7,    2,   -5,   -9,   -9,   -7,   -8,   -9,  -10,   -7,   -3,    1,    6,    7,
       8,    9,    6,   -2,  -13,  -23,  -30,  -35,  -41,  -45,  -44,  -38,  -26,  -15,   -3,   11,
      19,   33,   52,   69,   75,   72,   65,   54,   42,   29,   13,   -6,  -25,  -41,  -49,  -54,
     -55,  -48,  -38,  -26,  -18,   -8,    1,   13,   24,   29,   26,   19,   11,    5,    2,   -2,
      -6,   -6,   -6,   -5,   -7,   -5,    1,    5,    9,   11,    8,    8,    7,    4,   -6,  -17,
     -28,  -35,  -42,  -47,  -48,  -45,  -39,  -29,  -16,   -5,    7,   18,   32,   45,   57,   64,
      67,   62,   54,   45,   35,   22,    5,  -13,  -28,  -40,  -47,  -49,  -46,  -42,  -32,  -21,
     -11,   -4,    6,   15,   21,   21,   16,   12,    6,    1,   -3,   -5,   -3,    3,    8,    9,
       8,    7,    7,   11,   12,   11,    6,   -2,   -9,  -13,  -20,  -29,  -40,  -47,  -47,  -45,
     -42,  -37,  -29,  -16,   -5,    7,   17,   27,   38,   48,   56,   59,   53,   44,   40,   37,
      30,   17,   -2,  -16,  -25,  -32,  -35,  -36,  -35,  -31,  -23,  -16,  -10,   -3,    4,   10,
      11,    8,    1,    0,    0,    0,    0,    1,    6,   14,   20,   21,   19,   15,   14,   13,
      11,    7,    0,  -13,  -21,  -28,  -37,  -46,  -51,  -48,  -43,  -37,  -32,  -28,  -21,   -9,
       4,   17,   27,   32,   40,   45,   50,   51,   46,   40,   38,   35,   27,   12,   -3,  -13,
     -23,  -27,  -29,  -30,  -29,  -28,  -23,  -15,  -10,   -5,    2,    5,    5,    1,   -2,   -2,
       1,    4,    4,    8,   14,   19,   25,   26,   21,   15,   13,   12,   12,    5,   -9,  -21,
     -30,  -37,  -43,  -50,  -51,  -47,  -42,  -38,  -34,  -27,  -17,   -5,   10,   22,   30,   38,
      44,   49,   50,   46,   40,   37,   38,   33,   19,    4,   -8,  -14,  -18,  -22,  -24,  -24,
     -22,  -18,  -16,  -14,  -10,   -6,    1,    1,   -6,   -8,   -9,   -6,    0,    2,    8,   14,
      21,   28,   31,   27,   24,   21,   20,   16,    9,   -3,  -16,  -26,  -33,  -42,  -50,  -55,
     -56,  -50,  -43,  -39,  -38,  -29,  -13,    6,   18,   27,   33,   42,   51,   54,   53,   48,
      41,   39,   38,   29,   12,   -5,  -15,  -19,  -20,  -23,  -24,  -22,  -18,  -17,  -13,  -12,
     -10,   -4,   -3,   -4,   -7,   -8,   -9,   -9,   -7,    2,    9,   14,   21,   26,   27,   27,
      22,   20,   19,   17,   12,    1,  -14,  -25,  -35,  -41,  -45,  -50,  -53,  -54,  -51,  -47,
     -41,  -31,  -18,   -3,   12,   24,   35,   47,   55,   58,   57,   55,   49,   46,   40,   26,
      11,   -5,  -17,  -22,  -23,  -23,  -22,  -21,  -21,  -18,  -15,   -9,   -5,   -3,   -4,   -6,
      -7,   -9,  -12,  -12,   -8,    1,    7,   13,   14,   19,   23,   27,   26,   25,   25,   20,
      13,    4,   -9,  -22,  -36,  -42,  -48,  -55,  -61,  -62,  -59,  -54,  -43,  -32,  -18,    0,
      18,   35,   49,   57,   60,   62,   63,   61,   57,   48,   33,   15,   -2,  -15,  -24,  -28,
     -27,  -22,  -23,  -24,  -21,  -13,   -4,    3,    3,    1,   -2,   -4,   -4,   -9,  -15,  -16,
     -13,   -9,   -5,    2,    7,   11,   19,   24,   28,   31,   29,   28,   24,   12,   -4,  -21,
     -33,  -38,  -48,  -61,  -72,  -76,  -71,  -61,  -47,  -34,  -20,    2,   26,   45,   58,   65,
      69,   74,   75,   68,   55,   41,   28,   13,   -7,  -22,  -32,  -32,  -29,  -24,  -23,  -22,
     -19,   -7,    6,    7,    2,   -2,   -3,    0,   -3,  -10,  -20,  -24,  -19,  -12,   -5,    1,
       5,   14,   23,   30,   33,   37,   39,   36,   24,    8,  -10,  -25,  -33,  -43,  -55,  -71,
     -82,  -82,  -71,  -57,  -44,  -29,  -11,   13,   34,   52,   64,   70,   73,   77,   76,   65,
      50,   35,   20,    4,  -13,  -26,  -31,  -32,  -27,  -26,  -25,  -21,  -10,    2,    8,    5,
       3,    0,    1,    2,   -3,  -12,  -22,  -24,  -21,  -16,   -9,   -3,    6,   14,   22,   28,
      34,   41,   42,   35,   23,    6,  -10,  -21,  -32,  -45,  -61,  -76,  -85,  -82,  -70,  -54,
     -43,  -29,   -7,   18,   40,   55,   64,   71,   77,   81,   76,   62,   48,   32,   19,    6,
     -10,  -23,  -30,  -29,  -28,  -30,  -27,  -20,  -10,   -2,    3,    1,    0,    3,    6,    4,
      -9,  -18,  -24,  -22,  -18,  -14,   -8,    0,    8,   16,   24,   32,   38,   42,   42,   31,
      15,   -2,  -14,  -25,  -38,  -52,  -67,  -81,  -85,  -76,  -63,  -49,  -37,  -19,    3,   26,
      43,   57,   67,   75,   82,   79,   70,   56,   41,   28,   15,    1,  -12,  -22,  -27,  -27,
     -28,  -26,  -21,  -12,   -3,    3,   -2,   -2,    1,    3,    1,  -12,  -22,  -28,  -29,  -27,
     -23,  -18,  -11,    3,   16,   25,   34,   44,   51,   52,   43,   27,   12,   -2,  -17,  -34,
     -51,  -71,  -82,  -86,  -83,  -75,  -61,  -45,  -27,   -7,   16,   37,   53,   63,   72,   78,
      77,   68,   60,   45,   33,   20,   10,   -2,   -9,  -15,  -18,  -22,  -23,  -19,  -15,   -8,
      -5,   -7,   -8,   -7,   -4,   -3,  -10,  -22,  -29,  -29,  -24,  -21,  -18,  -14,   -3,   12,
      23,   27,   35,   44,   49,   47,   34,   18,    1,  -11,  -23,  -40,  -57,  -73,  -81,  -80,
     -74,  -64,  -50,  -36,  -19,    2,   22,   38,   49,   61,   69,   74,   69,   60,   50,   40,
      29,   20,   10,    2,   -5,   -9,  -12,  -16,  -18,  -14,   -9,   -6,  -10,  -13,  -12,  -10,
     -11,  -15,  -23,  -30,  -31,  -27,  -25,  -23,  -19,   -8,    8,   20,   28,   36,   45,   49,
      49,   41,   29,   15,   -2,  -15,  -31,  -49,  -65,  -76,  -79,  -77,  -67,  -55,  -43,  -30,
     -13,    7,   25,   40,   51,   60,   66,   66,   62,   54,   45,   37,   29,   22,   14,    7,
       3,   -3,   -7,  -10,  -12,  -10,   -8,  -12,  -18,  -19,  -16,  -13,  -15,  -23,  -31,  -33,
     -29,  -26,  -25,  -23,  -15,    1,   14,   23,   31,   40,   50,   52,   46,   36,   21,    7,
      -8,  -24,  -41,  -58,  -70,  -75,  -74,  -67,  -57,  -43,  -30,  -18,   -3,   13,   26,   39,
      48,   56,   60,   58,   51,   45,   42,   36,   29,   25,   20,   14,    9,    6,    3,    0,
      -5,   -6,  -12,  -17,  -22,  -21,  -20,  -24,  -33,  -37,  -38,  -35,  -30,  -28,  -24,  -17,
      -3,   12,   24,   33,   43,   50,   52,   49,   40,   28,   13,   -3,  -18,  -34,  -51,  -63,
     -71,  -72,  -67,  -59,  -49,  -37,  -24,  -10,    3,   16,   27,   37,   46,   50,   53,   51,
      49,   46,   43,   37,   32,   29,   25,   21,   17,   10,    4,   -3,   -8,  -10,  -11,  -18,
     -25,  -29,  -31,  -34,  -37,  -40,  -40,  -37,  -31,  -25,  -20,  -13,    0,   17,   31,   41,
      48,   50,   49,   46,   36,   22,    8,   -5,  -20,  -36,  -49,  -61,  -67,  -67,  -61,  -51,
     -44,  -36,  -23,   -9,    4,   13,   20,   30,   38,   46,   48,   47,   44,   44,   44,   46,
      42,   35,   31,   28,   24,   15,    5,   -3,   -6,  -10,  -18,  -28,  -35,  -39,  -41,  -41,
     -43,  -45,  -42,  -36,  -29,  -23,  -15,    1,   15,   28,   40,   47,   51,   51,   46,   37,
      27,   14,    2,  -14,  -29,  -42,  -49,  -54,  -62,  -63,  -57,  -49,  -41,  -31,  -21,  -12,
      -3,    6,   17,   25,   32,   40,   45,   49,   50,   48,   49,   49,   48,   44,   39,   34,
      26,   13,    4,   -4,  -11,  -17,  -23,  -32,  -41,  -48,  -48,  -49,  -48,  -44,  -39,  -36,
     -31,  -21,   -5,   13,   24,   35,   44,   51,   52,   47,   39,   30,   21,    8,   -6,  -18,
     -34,  -44,  -50,  -54,  -59,  -58,  -53,  -46,  -38,  -28,  -18,  -10,   -4,    6,   16,   24,
      30,   37,   42,   48,   49,   47,   48,   51,   51,   49,   45,   35,   27,   17,    9,    0,
     -12,  -23,  -32,  -41,  -48,  -53,  -55,  -54,  -53,  -49,  -43,  -38,  -27,  -13,    5,   20,
      33,   44,   52,   58,   57,   50,   40,   29,   16,    5,  -11,  -29,  -43,  -53,  -56,  -62,
     -65,  -63,  -54,  -42,  -33,  -24,  -16,   -8,    3,   16,   23,   29,   33,   38,   44,   46,
      45,   43,   45,   49,   52,   48,   42,   37,   28,   19,   10,    0,  -13,  -25,  -36,  -42,
     -47,  -56,  -58,  -56,  -53,  -49,  -48,  -40,  -26,   -6,   13,   27,   39,   49,   59,   64,
      62,   53,   42,   29,   16,    2,  -18,  -37,  -52,  -60,  -65,  -71,  -75,  -68,  -55,  -41,
     -30,  -19,  -10,    0,   14,   24,   33,   37,   38,   39,   42,   45,   45,   43,   45,   48,
      47,   46,   41,   35,   28,   19,    8,   -6,  -20,  -30,  -38,  -44,  -50,  -55,  -57,  -59,
     -57,  -53,  -46,  -35,  -19,    0,   17,   32,   45,   59,   66,   66,   59,   54,   46,   32,
      15,   -5,  -24,  -43,  -57,  -65,  -71,  -76,  -78,  -71,  -58,  -41,  -27,  -16,   -5,    5,
      15,   27,   37,   43,   43,   42,   42,   42,   43,   46,   46,   46,   45,   42,   41,   35,
      28,   18,    7,   -6,  -18,  -29,  -37,  -44,  -51,  -56,  -59,  -61,  -60,  -55,  -45,  -33,
     -18,   -2,   18,   37,   50,   61,   67,   68,   65,   59,   47,   31,   10,  -11,  -32,  -47,
     -58,  -71,  -81,  -86,  -83,  -70,  -52,  -36,  -21,   -9,    2,   13,   25,   35,   41,   44,
      43,   40,   39,   39,   40,   43,   43,   40,   39,   40,   40,   36,   28,   18,    9,   -5,
     -18,  -28,  -36,  -44,  -52,  -57,  -61,  -64,  -63,  -56,  -43,  -27,  -13,    6,   26,   44,
      56,   66,   71,   71,   64,   55,   42,   23,    3,  -19,  -38,  -52,  -66,  -76,  -82,  -86,
     -81,  -67,  -49,  -32,  -19,   -8,    3,   15,   28,   36,   42,   43,   43,   41,   41,   40,
      40,   41,   40,   40,   41,   41,   36,   30,   24,   17,   10,   -5,  -19,  -29,  -37,  -43,
     -50,  -57,  -64,  -66,  -60,  -50,  -40,  -28,  -10,   12,   32,   45,   54,   59,   64,   67,
      63,   54,   35,   14,   -6,  -22,  -35,  -50,  -64,  -75,  -82,  -81,  -73,  -59,  -46,  -33,
     -21,   -8,    5,   19,   27,   33,   40,   44,   44,   42,   40,   42,   41,   40,   38,   39,
      38,   38,   35,   30,   21,   13,    4,   -8,  -16,  -25,  -35,  -45,  -53,  -62,  -65,  -63,
     -56,  -47,  -39,  -25,   -6,   15,   32,   45,   53,   58,   64,   65,   60,   48,   30,    9,
      -7,  -19,  -31,  -47,  -60,  -72,  -79,  -79,  -73,  -61,  -50,  -37,  -24,  -10,    3,   12,
      22,   33,   43,   47,   46,   44,   43,   45,   46,   45,   45,   43,   41,   38,   34,   26,
      16,    7,   -2,  -10,  -19,  -29,  -39,  -50,  -59,  -64,  -62,  -58,  -51,  -44,  -34,  -22,
      -2,   16,   30,   41,   52,   56,   57,   58,   54,   42,   29,   13,    2,  -12,  -27,  -42,
     -56,  -67,  -71,  -73,  -70,  -63,  -55,  -42,  -26,  -10,    2,   11,   20,   33,   41,   46,
      45,   43,   49,   53,   52,   48,   44,   43,   42,   38,   33,   22,   12,    4,   -5,  -13,
     -23,  -34,  -43,  -50,  -57,  -61,  -60,  -55,  -49,  -40,  -29,  -14,   -2,   12,   25,   35,
      44,   51,   56,   56,   49,   39,   30,   20,   10,   -2,  -17,  -32,  -48,  -60,  -67,  -74,
     -77,  -74,  -66,  -50,  -36,  -21,   -9,    0,   14,   30,   43,   51,   53,   57,   62,   64,
      62,   58,   53,   48,   42,   36,   25,   12,    4,   -4,  -12,  -21,  -31,  -38,  -43,  -45,
     -47,  -49,  -47,  -44,  -40,  -34,  -28,  -22,  -11,    1,   11,   21,   28,   39,   49,   53,
      52,   49,   44,   38,   29,   16,   -4,  -24,  -41,  -57,  -74,  -86,  -90,  -86,  -73,  -59,
     -44,  -30,  -16,    1,   21,   40,   54,   61,   66,   67,   71,   72,   65,   57,   49,   41,
      33,   24,   12,    1,   -8,  -12,  -15,  -22,  -31,  -37,  -35,  -31,  -33,  -36,  -39,  -40,
     -38,  -34,  -32,  -29,  -24,  -14,   -2,   11,   24,   36,   48,   56,   61,   63,   59,   54,
      44,   27,    6,  -19,  -46,  -68,  -84,  -94,  -99,  -98,  -90,  -72,  -51,  -30,  -15,    1,
      22,   46,   64,   76,   78,   80,   81,   78,   72,   60,   45,   34,   24,   13,    0,  -13,
     -18,  -18,  -18,  -22,  -28,  -29,  -24,  -19,  -19,  -26,  -33,  -38,  -40,  -40,  -41,  -42,
     -41,  -32,  -15,    6,   22,   37,   50,   62,   74,   79,   76,   65,   50,   30,    6,  -24,
     -54,  -78,  -94, -106, -110, -103,  -89,  -69,  -49,  -29,  -10,   11,   36,   57,   73,   78,
      80,   82,   83,   77,   66,   51,   37,   24,   14,    5,   -5,  -12,  -17,  -17,  -17,  -18,
     -19,  -17,  -13,  -13,  -19,  -28,  -37,  -44,  -44,  -48,  -53,  -59,  -54,  -35,  -12,   11,
      29,   46,   61,   78,   88,   90,   84,   68,   49,   24,   -6,  -39,  -71,  -92, -104, -115,
    -116, -108,  -89,  -66,  -43,  -21,    1,   24,   49,   68,   78,   82,   81,   81,   79,   71,
      56,   37,   24,   15,    6,   -4,   -9,  -11,   -9,   -6,   -6,  -10,  -11,   -6,   -4,   -8,
     -20,  -33,  -44,  -55,  -61,  -65,  -70,  -68,  -55,  -31,   -6,   15,   38,   61,   82,   97,
     101,   94,   80,   61,   37,    9,  -25,  -60,  -88, -107, -119, -123, -116,  -99,  -77,  -53,
     -30,   -5,   20,   47,   68,   80,   82,   82,   80,   77,   70,   57,   40,   23,   10,    3,
      -2,   -3,   -4,   -3,    2,    5,    7,    5,    5,    4,   -4,  -17,  -32,  -45,  -60,  -69,
     -74,  -79,  -80,  -70,  -47,  -20,    9,   32,   55,   76,   94,  104,  103,   91,   71,   46,
      16,  -16,  -48,  -75,  -97, -115, -121, -117, -101,  -80,  -57,  -32,   -8,   15,   39,   58,
      68,   73,   73,   73,   69,   61,   50,   39,   26,   15,    7,    4,    7,   12,   18,   19,
      20,   18,   17,   15,   10,   -4,  -20,  -41,  -57,  -68,  -77,  -85,  -91,  -90,  -76,  -53,
     -25,    2,   28,   55,   79,   97,  106,  104,   94,   77,   52,   22,   -9,  -39,  -67,  -92,
    -111, -119, -115,  -99,  -79,  -55,  -33,  -11,   15,   37,   55,   67,   71,   68,   61,   51,
      44,   40,   35,   24,   10,    3,    4,   13,   25,   36,   42,   41,   34,   29,   20,   12,
      -2,  -21,  -43,  -66,  -84,  -94,  -96,  -96,  -93,  -81,  -55,  -26,    4,   30,   56,   80,
      98,  107,  106,   95,   77,   53,   24,   -8,  -38,  -64,  -85, -101, -109, -109, -100,  -80,
     -55,  -31,   -8,   13,   31,   46,   56,   61,   59,   52,   43,   36,   30,   25,   16,    8,
       7,   11,   23,   37,   48,   56,   59,   56,   48,   33,   17,   -5,  -29,  -54,  -79,  -96,
    -106, -109, -105,  -96,  -82,  -57,  -25,    8,   38,   61,   79,   94,  103,  102,   92,   73,
      46,   19,  -10,  -36,  -62,  -81,  -95, -101, -100,  -90,  -71,  -47,  -25,   -3,   18,   31,
      41,   49,   53,   50,   42,   32,   21,   13,    9,    7,    8,    8,   12,   30,   49,   63,
      71,   76,   75,   67,   48,   25,   -3,  -30,  -59,  -87, -107, -120, -124, -117, -105,  -89,
     -63,  -31,    5,   40,   63,   81,   92,  100,  100,   88,   69,   46,   20,   -6,  -31,  -55,
     -73,  -87,  -91,  -88,  -80,  -64,  -45,  -22,    1,   16,   27,   34,   39,   45,   41,   31,
      20,    9,    4,    3,    1,    3,    6,   15,   32,   53,   71,   81,   85,   86,   78,   61,
      35,    3,  -29,  -63,  -93, -113, -124, -128, -124, -110,  -89,  -64,  -32,    5,   38,   62,
      80,   91,   98,   93,   80,   63,   42,   19,   -5,  -29,  -51,  -68,  -78,  -81,  -79,  -72,
     -58,  -40,  -19,    0,   13,   21,   29,   35,   35,   29,   21,   14,    8,    2,   -2,   -3,
       1,   10,   20,   36,   56,   73,   84,   89,   89,   81,   65,   41,    6,  -32,  -63,  -90,
    -110, -124, -127, -123, -110,  -89,  -61,  -30,    2,   33,   56,   71,   81,   86,   85,   74,
      58,   38,   17,   -5,  -21,  -38,  -52,  -62,  -69,  -69,  -64,  -50,  -34,  -18,   -5,    5,
      13,   23,   28,   27,   22,   15,   10,    6,    1,    0,   -2,    2,    9,   23,   41,   56,
      72,   84,   88,   89,   81,   66,   45,   15,  -20,  -55,  -84, -106, -119, -121, -116, -105,
     -89,  -67,  -38,   -7,   21,   44,   58,   69,   75,   74,   64,   50,   36,   22,    8,  -10,
     -26,  -39,  -47,  -54,  -56,  -53,  -47,  -36,  -25,  -11,   -2,    5,   14,   23,   24,   20,
      12,    7,    6,    6,    6,    4,    5,   10,   22,   39,   57,   72,   80,   82,   80,   73,
      62,   45,   18,  -13,  -48,  -78,  -96, -105, -105, -104,  -97,  -81,  -64,  -40,  -15,   10,
      28,   40,   49,   54,   53,   49,   42,   31,   22,   13,    2,   -9,  -17,  -22,  -30,  -38,
     -40,  -37,  -33,  -28,  -22,  -16,  -10,   -5,    5,   11,   11,    6,    3,    5,   11,   16,
      16,   18,   22,   29,   40,   54,   68,   75,   74,   72,   63,   49,   35,   15,  -10,  -37,
     -63,  -83,  -94,  -95,  -89,  -82,  -73,  -63,  -46,  -24,   -2,   16,   25,   31,   35,   39,
      41,   37,   30,   22,   15,   11,    4,   -3,  -11,  -18,  -25,  -31,  -35,  -33,  -28,  -22,
     -18,  -16,  -13,   -4,    5,   10,   11,   10,    5,    6,   14,   21,   23,   24,   27,   33,
      45,   59,   68,   72,   67,   57,   46,   34,   19,    0,  -24,  -49,  -70,  -81,  -82,  -77,
     -70,  -65,  -60,  -49,  -34,  -15,    2,    9,   13,   14,   18,   20,   21,   19,   18,   17,
      16,   15,   13,   10,    5,   -3,  -12,  -20,  -26,  -28,  -27,  -24,  -26,  -25,  -18,   -9,
       3,    9,   10,   10,   11,   18,   27,   32,   33,   33,   35,   42,   51,   58,   59,   55,
      46,   36,   25,   16,    3,  -15,  -33,  -50,  -61,  -65,  -64,  -59,  -57,  -56,  -52,  -42,
     -29,  -14,   -5,   -2,   -3,    1,    8,   12,   13,   13,   16,   16,   18,   19,   19,   14,
       4,   -3,  -10,  -19,  -24,  -24,  -22,  -20,  -24,  -23,  -16,   -2,   10,   16,   14,   13,
      16,   28,   35,   36,   35,   32,   33,   40,   45,   49,   47,   41,   31,   20,   12,    4,
      -8,  -16,  -29,  -41,  -50,  -53,  -50,  -49,  -51,  -51,  -48,  -40,  -30,  -20,  -13,  -13,
     -12,   -6,    2,    8,   12,   13,   16,   21,   26,   27,   23,   15,    8,    0,  -10,  -19,
     -23,  -24,  -24,  -26,  -25,  -21,   -9,    5,   15,   19,   20,   22,   28,   36,   39,   38,
      36,   33,   33,   35,   37,   38,   36,   30,   20,    9,    4,   -3,  -10,  -17,  -26,  -35,
     -40,  -45,  -47,  -51,  -52,  -49,  -46,  -39,  -30,  -23,  -19,  -17,  -12,   -5,    1,    4,
       7,   11,   18,   22,   22,   22,   20,   17,   12,    3,   -8,  -16,  -18,  -16,  -17,  -19,
     -18,  -12,    3,   13,   19,   20,   24,   29,   34,   35,   33,   32,   31,   31,   30,   26,
      24,   24,   25,   21,   14,    6,    0,   -4,   -5,  -10,  -19,  -31,  -37,  -40,  -47,  -51,
     -50,  -49,  -45,  -39,  -31,  -25,  -19,  -12,   -6,   -3,    0,    2,    6,   13,   17,   18,
      16,   15,   16,   14,    7,   -3,  -10,  -12,  -13,  -13,  -14,  -13,   -6,    6,   18,   24,
      25,   26,   29,   33,   32,   26,   24,   23,   23,   22,   18,   14,   15,   21,   24,   22,
      14,    6,    4,    4,    1,   -9,  -21,  -32,  -41,  -47,  -50,  -54,  -54,  -51,  -47,  -37,
     -30,  -21,  -10,   -3,    1,    4,    6,    7,    8,    7,    7,    7,    7,    6,    6,    5,
       2,   -3,   -8,   -8,   -6,   -3,    1,    3,    9,   17,   25,   29,   32,   33,   29,   26,
      24,   23,   20,   17,   14,   11,    8,    8,   14,   21,   22,   17,   13,    9,    9,    7,
       1,  -11,  -25,  -37,  -44,  -52,  -53,  -55,  -55,  -51,  -43,  -35,  -24,  -14,   -4,    3,
       4,    4,    6,    7,    6,    3,   -2,   -2,    2,    6,    5,    1,   -4,   -8,   -7,   -5,
       3,    9,    9,   12,   17,   25,   32,   37,   37,   32,   25,   21,   19,   17,   15,    9,
       6,    6,    6,    8,   14,   23,   24,   20,   15,   14,   11,    3,   -6,  -18,  -31,  -44,
     -53,  -54,  -57,  -58,  -55,  -47,  -37,  -26,  -16,   -4,    7,   10,   10,    9,    7,    3,
      -2,   -6,   -8,   -6,   -5,   -4,   -7,  -10,   -8,   -6,    0,    6,   12,   16,   20,   27,
      33,   35,   35,   36,   34,   28,   21,   16,   10,    7,    7,    5,    3,    1,    5,   12,
      21,   25,   23,   17,   14,   13,    9,   -3,  -17,  -30,  -41,  -50,  -54,  -59,  -61,  -55,
     -46,  -37,  -26,  -15,   -4,    7,   14,   15,   12,    6,    1,   -3,   -7,  -12,  -14,  -15,
     -13,  -12,  -12,  -12,   -8,    0,    8,   15,   20,   25,   31,   36,   40,   41,   41,   38,
      33,   27,   21,   12,    4,    1,    0,   -4,   -5,   -2,    5,   12,   17,   19,   19,   18,
      14,   11,    2,   -9,  -21,  -32,  -42,  -49,  -55,  -57,  -56,  -49,  -39,  -30,  -20,   -8,
       3,   12,   17,   18,   12,    5,   -2,   -8,  -14,  -18,  -21,  -22,  -21,  -21,  -19,  -13,
      -7,    4,   14,   24,   32,   39,   44,   48,   47,   44,   41,   38,   33,   27,   17,    7,
      -3,   -5,   -5,   -5,   -5,   -5,    3,   12,   17,   19,   16,   11,    7,    3,   -6,  -15,
     -26,  -36,  -42,  -48,  -53,  -54,  -50,  -40,  -31,  -22,  -12,   -2,   11,   19,   20,   13,
       6,    2,   -5,  -12,  -21,  -26,  -29,  -31,  -30,  -27,  -21,  -13,   -2,   12,   25,   36,
      48,   57,   62,   60,   51,   46,   43,   37,   28,   15,    3,   -8,  -12,  -14,  -12,  -10,
      -7,   -4,    8,   16,   20,   17,   14,   10,    6,   -2,  -12,  -24,  -32,  -39,  -45,  -51,
     -54,  -52,  -43,  -32,  -21,  -12,   -2,   11,   22,   28,   24,   13,    4,   -6,  -14,  -23,
     -32,  -38,  -41,  -42,  -39,  -31,  -20,   -8,    6,   21,   37,   50,   63,   69,   68,   61,
      55,   48,   39,   29,   20,    9,   -6,  -15,  -17,  -13,  -11,   -7,   -4,    3,   11,   13,
      16,   15,   10,    5,    0,   -8,  -15,  -25,  -31,  -37,  -42,  -49,  -52,  -46,  -37,  -30,
     -21,  -12,    0,   14,   25,   28,   25,   15,    2,  -11,  -22,  -29,  -36,  -44,  -49,  -49,
     -43,  -32,  -18,   -5,   13,   30,   50,   66,   74,   75,   71,   68,   61,   50,   37,   26,
      15,    3,  -13,  -22,  -22,  -20,  -16,  -14,   -9,    1,    9,   11,   11,    9,    9,    9,
       6,   -3,  -15,  -25,  -32,  -37,  -41,  -50,  -53,  -50,  -41,  -30,  -20,   -8,    6,   21,
      31,   33,   26,   15,    0,  -12,  -23,  -34,  -46,  -56,  -60,  -54,  -44,  -31,  -19,   -2,
      21,   44,   66,   77,   81,   79,   75,   72,   63,   51,   35,   23,   10,   -4,  -16,  -25,
     -28,  -26,  -22,  -16,  -12,   -7,   -2,    4,    8,   10,   14,   14,    7,   -3,  -12,  -20,
     -28,  -36,  -42,  -48,  -53,  -53,  -43,  -31,  -19,   -6,   12,   25,   31,   30,   26,   15,
      -2,  -17,  -28,  -40,  -52,  -60,  -61,  -53,  -40,  -25,   -9,   11,   32,   56,   74,   84,
      85,   81,   76,   72,   61,   46,   29,   13,   -2,  -16,  -23,  -29,  -33,  -31,  -25,  -19,
     -14,   -8,    2,   10,   14,   18,   19,   17,    8,    1,  -12,  -24,  -35,  -42,  -49,  -54,
     -57,  -53,  -43,  -30,  -13,    7,   22,   32,   34,   32,   26,   11,   -8,  -24,  -40,  -50,
     -60,  -66,  -63,  -53,  -36,  -17,    2,   23,   45,   67,   84,   90,   91,   85,   78,   72,
      62,   44,   24,    4,   -9,  -21,  -32,  -39,  -41,  -36,  -30,  -23,  -17,   -9,    2,   13,
      23,   27,   26,   19,   12,    2,  -12,  -26,  -38,  -47,  -54,  -59,  -59,  -53,  -41,  -23,
      -5,   14,   28,   36,   36,   31,   21,    6,  -13,  -31,  -46,  -58,  -66,  -70,  -65,  -50,
     -28,   -7,   14,   35,   58,   76,   89,   96,   94,   90,   82,   72,   54,   35,   16,   -5,
     -21,  -31,  -40,  -48,  -47,  -38,  -28,  -20,  -13,    1,   15,   28,   33,   33,   27,   18,
       8,   -6,  -21,  -37,  -52,  -64,  -66,  -65,  -58,  -47,  -30,   -9,   13,   28,   38,   43,
      40,   31,   15,   -5,  -24,  -40,  -57,  -69,  -75,  -74,  -65,  -48,  -26,   -2,   24,   47,
      66,   83,   97,  102,  102,  101,   91,   73,   51,   28,    7,  -15,  -33,  -45,  -56,  -60,
     -54,  -42,  -28,  -17,   -4,   13,   26,   36,   38,   36,   29,   16,    2,  -14,  -34,  -52,
     -62,  -66,  -65,  -63,  -53,  -36,  -15,    9,   27,   36,   41,   40,   35,   25,    8,  -16,
     -37,  -55,  -68,  -77,  -81,  -75,  -60,  -37,  -12,   12,   35,   57,   75,   94,  105,  107,
     103,   97,   84,   64,   41,   18,   -6,  -25,  -40,  -51,  -57,  -56,  -46,  -32,  -19,   -6,
       7,   20,   30,   34,   32,   24,   12,    0,  -17,  -33,  -47,  -60,  -65,  -64,  -58,  -46,
     -31,  -12,    8,   26,   37,   43,   44,   41,   28,   11,  -12,  -31,  -49,  -67,  -81,  -87,
     -85,  -72,  -52,  -30,   -6,   21,   45,   69,   87,  101,  110,  113,  110,  100,   77,   51,
      27,    8,  -11,  -32,  -49,  -59,  -59,  -53,  -41,  -27,  -11,    3,   14,   24,   28,   28,
      24,   17,    5,  -15,  -32,  -45,  -54,  -61,  -58,  -54,  -44,  -32,  -13,    8,   26,   37,
      41,   40,   36,   29,   16,   -3,  -24,  -47,  -66,  -81,  -89,  -88,  -76,  -58,  -37,  -16,
      10,   34,   58,   78,   94,  106,  111,  107,   97,   81,   58,   37,   17,    0,  -17,  -33,
     -45,  -51,  -48,  -38,  -26,  -14,   -3,    9,   16,   19,   17,   14,   10,    0,  -15,  -30,
     -42,  -49,  -52,  -49,  -44,  -37,  -25,   -8,    9,   21,   29,   32,   35,   33,   29,   19,
       1,  -18,  -38,  -58,  -75,  -85,  -85,  -79,  -70,  -52,  -29,   -6,   20,   44,   67,   89,
     101,  110,  114,  107,   93,   72,   49,   28,   10,   -9,  -25,  -38,  -48,  -49,  -42,  -31,
     -20,  -11,    0,    9,   13,   12,    7,    5,    0,  -11,  -24,  -36,  -42,  -44,  -43,  -38,
     -28,  -16,   -4,    8,   16,   22,   29,   30,   29,   24,   13,    2,  -14,  -32,  -51,  -68,
     -79,  -83,  -77,  -69,  -56,  -41,  -19,    6,   31,   53,   74,   90,  101,  108,  109,  101,
      83,   60,   38,   24,    9,  -10,  -25,  -36,  -40,  -37,  -29,  -21,  -13,   -8,    0,    3,
       0,   -5,   -6,   -8,  -16,  -27,  -35,  -39,  -40,  -33,  -27,  -21,  -11,    3,   14,   21,
      24,   27,   26,   22,   19,   13,    3,  -14,  -32,  -53,  -66,  -74,  -80,  -80,  -75,  -63,
     -47,  -28,   -4,   19,   41,   66,   85,   99,  105,  106,  104,   95,   76,   51,   29,   13,
       2,  -12,  -27,  -36,  -38,  -32,  -22,  -15,  -12,   -8,   -3,   -4,   -9,  -12,  -14,  -18,
     -26,  -31,  -35,  -36,  -29,  -20,  -10,   -2,    7,   16,   25,   25,   24,   19,   15,   10,
       4,   -4,  -16,  -30,  -44,  -57,  -67,  -73,  -75,  -70,  -60,  -48,  -34,  -16,    5,   27,
      51,   71,   85,   92,   99,  101,   95,   82,   64,   44,   28,   14,    1,  -12,  -22,  -28,
     -27,  -22,  -18,  -17,  -15,  -15,  -15,  -21,  -23,  -25,  -24,  -27,  -31,  -34,  -30,  -21,
      -6,    7,   13,   17,   22,   27,   28,   24,   16,    7,   -3,  -10,  -17,  -27,  -35,  -43,
     -50,  -58,  -68,  -70,  -65,  -53,  -42,  -32,  -22,   -4,   15,   36,   54,   70,   83,   89,
      92,   91,   82,   68,   54,   42,   29,   14,    2,   -9,  -17,  -21,  -22,  -20,  -21,  -20,
     -23,  -26,  -30,  -32,  -32,  -29,  -27,  -28,  -30,  -26,  -15,    0,   15,   25,   25,   25,
      26,   27,   21,   11,    0,   -9,  -17,  -24,  -30,  -38,  -45,  -47,  -49,  -55,  -59,  -56,
     -48,  -39,  -28,  -20,   -9,    7,   26,   44,   55,   65,   72,   79,   80,   77,   66,   57,
      49,   41,   30,   19,    7,   -2,   -7,  -12,  -17,  -22,  -25,  -29,  -33,  -36,  -39,  -41,
     -36,  -29,  -26,  -26,  -22,  -11,    2,   17,   28,   32,   31,   29,   28,   23,   11,   -2,
      -9,  -17,  -24,  -36,  -44,  -48,  -49,  -50,  -53,  -54,  -54,  -47,  -36,  -25,  -17,   -7,
       7,   21,   36,   47,   55,   63,   70,   72,   69,   60,   52,   46,   42,   34,   23,   15,
       8,    3,    0,   -7,  -14,  -21,  -24,  -27,  -32,  -39,  -44,  -43,  -37,  -29,  -25,  -23,
     -16,   -2,   14,   26,   32,   33,   32,   30,   25,   16,    4,   -6,  -16,  -25,  -36,  -45,
     -50,  -54,  -51,  -51,  -54,  -54,  -48,  -36,  -23,  -15,   -6,    5,   17,   31,   42,   51,
      59,   62,   63,   61,   56,   51,   43,   40,   38,   28,   20,   13,    9,    7,    2,   -8,
     -16,  -23,  -27,  -31,  -36,  -40,  -43,  -39,  -31,  -23,  -20,  -15,   -4,   11,   24,   31,
      32,   31,   30,   25,   17,    7,   -3,  -13,  -23,  -36,  -48,  -56,  -58,  -57,  -53,  -50,
     -52,  -51,  -40,  -25,  -12,    0,    7,   16,   25,   36,   49,   58,   60,   59,   57,   54,
      49,   43,   36,   31,   26,   18,   13,   10,    6,    4,    0,   -6,  -12,  -19,  -22,  -26,
     -31,  -35,  -35,  -32,  -27,  -22,  -16,   -7,    4,   13,   21,   26,   30,   29,   27,   22,
      15,    4,   -7,  -19,  -31,  -44,  -55,  -59,  -59,  -58,  -54,  -52,  -49,  -41,  -28,  -14,
       0,   10,   18,   26,   33,   44,   50,   53,   51,   50,   48,   46,   41,   37,   30,   24,
      21,   18,   15,   13,    8,    4,    0,   -6,   -9,  -14,  -19,  -23,  -27,  -33,  -33,  -31,
     -25,  -19,  -11,   -3,    3,   11,   20,   28,   31,   28,   22,   14,    8,   -3,  -15,  -29,
     -40,  -49,  -57,  -62,  -60,  -56,  -50,  -47,  -42,  -32,  -18,   -3,   11,   20,   25,   29,
      35,   43,   49,   51,   47,   43,   41,   37,   33,   29,   24,   18,   15,   14,   13,   11,
       8,    5,    1,    0,   -5,  -11,  -19,  -23,  -24,  -25,  -25,  -26,  -22,  -15,   -9,   -3,
       4,   12,   19,   25,   26,   24,   17,   11,    2,  -11,  -26,  -37,  -45,  -53,  -58,  -59,
     -57,  -53,  -47,  -42,  -35,  -25,  -10,    5,   15,   19,   22,   29,   37,   45,   48,   47,
      44,   44,   43,   40,   33,   24,   19,   14,   13,   12,    8,    2,   -2,    1,    1,    1,
      -4,  -12,  -15,  -14,  -13,  -14,  -18,  -18,  -15,  -12,   -8,   -5,    2,   10,   18,   21,
      20,   15,   10,    3,   -7,  -18,  -31,  -42,  -47,  -50,  -53,  -57,  -57,  -51,  -42,  -34,
     -25,  -15,   -5,    7,   16,   22,   30,   35,   40,   43,   42,   39,   39,   38,   38,   31,
      22,   16,   14,   15,   17,   16,   12,    6,    4,    5,    7,    6,    0,   -8,  -12,  -13,
     -15,  -19,  -21,  -20,  -17,  -14,  -11,   -6,    2,   10,   18,   21,   21,   19,   11,   -2,
     -17,  -29,  -37,  -42,  -46,  -52,  -55,  -58,  -52,  -42,  -34,  -24,  -15,   -5,    5,   12,
      17,   24,   32,   37,   37,   36,   33,   33,   35,   35,   32,   26,   22,   16,   17,   19,
      19,   14,    7,    5,    5,    6,    5,    0,   -7,  -10,   -9,   -6,   -7,  -13,  -17,  -15,
     -11,   -8,   -7,   -6,    1,    7,   12,   13,   11,    7,    0,  -12,  -25,  -35,  -40,  -42,
     -43,  -44,  -47,  -49,  -43,  -34,  -22,  -12,   -7,    0,    4,    9,   17,   25,   31,   33,
      33,   31,   30,   27,   28,   30,   29,   25,   20,   17,   20,   24,   22,   17,   11,   10,
       9,    9,    5,   -6,  -11,  -13,   -9,   -5,   -9,  -16,  -19,  -16,   -9,   -6,   -6,   -2,
       4,    8,   11,   11,    6,   -4,  -11,  -21,  -34,  -39,  -41,  -40,  -38,  -40,  -44,  -38,
     -28,  -17,  -10,   -6,   -5,   -3,    3,   10,   15,   17,   20,   23,   26,   25,   24,   26,
      28,   30,   30,   28,   25,   24,   23,   25,   22,   18,   14,    9,    5,    0,   -7,  -12,
     -13,  -12,   -7,   -6,   -9,  -12,  -10,   -4,    2,    2,    3,    3,    3,    6,    7,    3,
      -9,  -21,  -28,  -35,  -40,  -40,  -37,  -37,  -36,  -36,  -29,  -22,  -11,   -3,    2,    3,
       0,    1,    3,    6,    9,   10,   10,   10,   13,   16,   21,   24,   29,   31,   33,   33,
      33,   32,   30,   27,   23,   16,   12,    7,   -2,   -7,  -14,  -19,  -16,  -10,   -5,   -7,
      -9,   -9,   -6,    2,    6,    8,    7,    4,    3,    1,   -3,   -9,  -16,  -25,  -34,  -39,
     -41,  -37,  -33,  -31,  -31,  -29,  -22,  -12,   -4,    2,    7,    5,    1,   -2,    0,    4,
       4,    2,    2,    5,   10,   14,   19,   24,   28,   32,   36,   38,   36,   34,   31,   27,
      23,   18,   11,    3,   -5,  -12,  -15,  -15,  -11,   -6,   -5,   -6,   -8,   -7,   -3,    1,
       4,    6,    3,   -2,   -7,   -9,  -12,  -19,  -24,  -30,  -34,  -36,  -35,  -32,  -29,  -26,
     -22,  -16,  -10,   -3,    4,    8,    9,    4,    0,   -3,    0,    1,   -5,   -7,   -5,    1,
       7,   13,   14,   17,   27,   35,   38,   37,   35,   33,   31,   29,   25,   19,   11,    3,
       0,   -6,  -10,  -10,   -7,   -5,   -5,   -7,   -7,   -6,   -3,    1,    4,    3,    0,   -8,
     -15,  -18,  -20,  -23,  -27,  -30,  -32,  -33,  -29,  -28,  -25,  -20,  -16,  -13,   -6,    1,
       6,    7,    4,    0,   -5,   -5,   -5,   -6,   -7,   -6,   -2,    5,   10,   15,   20,   25,
      32,   34,   34,   34,   32,   29,   24,   22,   19,   14,    9,    6,    4,    2,    0,    0,
       2,    2,   -2,   -4,   -6,   -5,   -5,   -4,   -4,   -7,  -12,  -19,  -25,  -26,  -26,  -26,
     -26,  -29,  -28,  -28,  -25,  -22,  -18,  -14,  -10,   -5,    0,    3,    4,    5,    4,    3,
      -2,   -7,  -10,  -12,   -9,   -6,    0,    6,   11,   14,   16,   22,   30,   33,   34,   29,
      25,   23,   21,   22,   22,   20,   18,   16,   14,   13,   11,   11,   11,    6,   -4,  -12,
     -16,  -17,  -16,  -13,  -16,  -22,  -26,  -30,  -30,  -25,  -21,  -18,  -17,  -19,  -18,  -20,
     -19,  -15,  -13,   -9,   -7,   -6,   -5,   -2,    3,    5,    4,    0,   -5,   -8,   -6,   -6,
      -6,   -2,    4,    9,   11,   13,   15,   19,   23,   25,   22,   19,   16,   17,   20,   21,
      22,   23,   24,   25,   24,   23,   22,   21,   16,    7,   -4,  -14,  -21,  -23,  -24,  -24,
     -28,  -34,  -38,  -36,  -31,  -21,  -13,   -9,   -8,  -10,  -11,  -12,  -14,  -13,  -12,   -9,
     -10,  -12,  -11,   -9,   -4,    3,    4,    1,   -3,   -4,    1,    4,    7,   10,   10,   11,
      12,   11,    8,    9,   11,   13,   11,    5,    4,   11,   20,   26,   29,   32,   35,   39,
      39,   34,   30,   23,   15,    5,  -10,  -23,  -31,  -34,  -32,  -33,  -37,  -42,  -41,  -32,
     -21,  -11,   -6,   -3,   -3,   -6,   -8,  -11,  -14,  -15,  -14,  -14,  -14,  -19,  -20,  -15,
      -7,    0,   -2,   -3,    0,    4,   10,   17,   19,   18,   18,   20,   18,   11,    5,    1,
      -2,   -4,   -7,   -8,   -4,    4,   14,   24,   32,   38,   46,   51,   52,   46,   37,   28,
      19,    5,  -12,  -29,  -39,  -44,  -46,  -46,  -50,  -48,  -39,  -29,  -14,   -4,    6,    9,
       8,    6,    0,   -8,  -13,  -15,  -18,  -22,  -28,  -30,  -26,  -18,   -9,   -7,   -4,    2,
      10,   18,   24,   26,   26,   23,   22,   21,   14,    3,   -5,   -9,  -14,  -16,  -16,  -11,
      -4,    6,   14,   24,   37,   50,   58,   58,   53,   45,   36,   28,   17,    1,  -18,  -36,
     -47,  -53,  -54,  -53,  -51,  -43,  -33,  -20,   -8,    5,   15,   17,   13,    5,   -4,  -12,
     -14,  -18,  -23,  -30,  -34,  -32,  -24,  -15,  -10,   -6,   -3,    7,   18,   27,   32,   33,
      30,   28,   24,   19,   12,    2,  -10,  -18,  -24,  -26,  -23,  -16,   -6,    4,   12,   25,
      39,   53,   60,   60,   58,   51,   42,   30,   16,    0,  -20,  -37,  -49,  -57,  -61,  -57,
     -50,  -40,  -29,  -17,   -4,    9,   17,   17,   11,    5,   -3,   -8,  -13,  -21,  -30,  -35,
     -34,  -29,  -22,  -16,  -11,   -6,    1,   12,   24,   34,   39,   39,   35,   28,   21,   16,
       8,   -3,  -16,  -29,  -35,  -34,  -26,  -16,   -9,    1,   14,   30,   46,   56,   60,   62,
      59,   57,   46,   32,   15,   -2,  -17,  -35,  -51,  -61,  -61,  -55,  -46,  -39,  -30,  -19,
      -4,   10,   14,   13,    7,    3,   -2,   -6,  -15,  -24,  -31,  -33,  -31,  -26,  -23,  -19,
     -11,   -2,    6,   17,   30,   38,   41,   39,   34,   25,   18,   14,    6,   -9,  -24,  -34,
     -38,  -34,  -28,  -18,   -9,    0,   14,   32,   44,   52,   58,   63,   66,   59,   45,   31,
      18,    4,  -17,  -36,  -53,  -60,  -59,  -54,  -46,  -39,  -30,  -18,   -3,    6,    8,    6,
       3,    1,   -3,  -11,  -22,  -29,  -28,  -23,  -20,  -20,  -18,  -10,   -2,    7,   17,   27,
      34,   37,   38,   33,   26,   19,   15,   11,    0,  -17,  -31,  -39,  -40,  -34,  -27,  -20,
     -11,    1,   16,   31,   43,   52,   59,   67,   70,   62,   47,   32,   19,    4,  -18,  -39,
     -53,  -60,  -57,  -51,  -44,  -37,  -30,  -17,   -6,    1,    2,    1,    0,   -2,   -7,  -15,
     -23,  -27,  -25,  -19,  -16,  -15,  -12,   -4,    5,   15,   25,   33,   37,   34,   31,   27,
      22,   17,   11,    2,  -11,  -25,  -35,  -41,  -41,  -34,  -23,  -13,   -4,    6,   18,   31,
      43,   54,   61,   65,   62,   53,   44,   34,   22,    2,  -20,  -38,  -47,  -50,  -47,  -43,
     -42,  -41,  -32,  -19,  -13,  -11,  -10,   -7,   -5,   -5,   -9,  -14,  -18,  -17,  -12,   -9,
      -8,   -6,    1,    6,   12,   16,   21,   25,   25,   23,   19,   18,   14,   11,    8,    0,
     -10,  -23,  -34,  -36,  -32,  -24,  -16,  -12,   -6,    4,   15,   30,   42,   52,   59,   60,
      58,   53,   46,   39,   27,    5,  -19,  -35,  -43,  -44,  -43,  -45,  -49,  -48,  -39,  -31,
     -27,  -24,  -19,  -11,   -6,   -3,   -4,   -6,   -8,   -5,    3,    5,    7,    6,    7,    9,
      12,   13,   15,   14,   12,   11,   11,    9,    8,    5,    4,    0,  -12,  -22,  -28,  -26,
     -21,  -17,  -13,  -10,   -5,    4,   14,   22,   32,   44,   56,   61,   59,   56,   48,   38,
      25,    7,  -10,  -24,  -33,  -38,  -44,  -50,  -51,  -47,  -41,  -41,  -41,  -37,  -26,  -14,
      -6,    0,   -2,   -3,    5,   13,   19,   21,   16,   12,    9,    9,   10,    7,    3,    2,
       2,    1,   -2,    0,    3,    4,    1,   -4,  -12,  -16,  -16,   -9,   -9,  -10,   -9,   -5,
       2,    7,   11,   17,   27,   39,   51,   54,   52,   52,   49,   42,   28,   10,   -4,  -15,
     -25,  -36,  -48,  -56,  -58,  -56,  -52,  -53,  -54,  -45,  -28,  -11,   -2,    3,    8,   15,
      24,   30,   34,   30,   22,   16,   12,    6,   -4,   -9,   -9,   -8,  -12,  -14,  -12,   -5,
       3,    4,    2,   -3,   -4,    0,    3,    2,   -4,   -6,   -6,   -5,   -4,   -5,   -3,    8,
      21,   36,   44,   50,   55,   58,   55,   45,   33,   20,    5,  -11,  -27,  -43,  -55,  -60,
     -61,  -62,  -64,  -66,  -58,  -40,  -20,   -6,    3,    8,   16,   26,   34,   39,   38,   30,
      21,   11,    2,   -9,  -14,  -13,  -13,  -15,  -16,  -14,   -6,    1,    4,    4,    3,    4,
       7,   10,   10,    5,   -3,   -7,   -8,   -9,  -12,  -14,  -11,    0,   13,   28,   40,   51,
      58,   61,   60,   56,   47,   33,   15,   -8,  -28,  -44,  -55,  -62,  -72,  -81,  -83,  -74,
     -58,  -39,  -21,   -6,    8,   18,   30,   40,   47,   49,   44,   33,   19,    6,   -6,  -14,
     -19,  -23,  -26,  -24,  -19,  -13,   -5,   -2,    2,    5,    8,   11,   14,   13,    9,    2,
      -4,   -8,  -12,  -15,  -19,  -18,  -13,   -3,   14,   30,   44,   53,   62,   66,   66,   59,
      48,   33,   12,  -10,  -31,  -46,  -58,  -71,  -79,  -84,  -81,  -71,  -54,  -34,  -14,    1,
      14,   26,   37,   44,   48,   49,   41,   29,   12,   -3,  -13,  -17,  -19,  -24,  -26,  -22,
     -16,   -8,   -3,   -2,    3,    6,   10,   13,   12,   10,    6,    2,   -4,  -11,  -18,  -22,
     -22,  -19,  -14,   -3,   13,   30,   46,   61,   68,   71,   70,   64,   52,   32,   10,  -12,
     -31,  -51,  -67,  -81,  -88,  -91,  -84,  -69,  -51,  -32,  -12,    8,   25,   37,   43,   47,
      52,   50,   40,   23,    5,   -8,  -13,  -18,  -23,  -28,  -26,  -19,  -12,   -6,   -4,   -2,
       2,    6,   11,   11,    5,    3,    4,    1,   -9,  -17,  -21,  -23,  -22,  -19,  -14,    0,
      17,   37,   54,   65,   70,   75,   76,   67,   50,   30,    6,  -15,  -35,  -56,  -75,  -88,
     -93,  -88,  -78,  -64,  -47,  -26,   -3,   17,   31,   37,   42,   46,   48,   42,   27,   10,
       0,   -3,   -7,  -14,  -21,  -21,  -13,   -4,    1,   -2,   -3,    1,    5,    7,    4,   -3,
      -8,   -7,   -7,  -14,  -19,  -22,  -23,  -21,  -20,  -16,   -6,   12,   32,   51,   63,   70,
      76,   78,   75,   63,   44,   20,   -5,  -26,  -46,  -67,  -83,  -94,  -93,  -83,  -69,  -55,
     -40,  -17,    8,   25,   34,   38,   43,   48,   45,   35,   20,    8,    2,    3,   -2,  -12,
     -18,  -15,   -8,    0,    0,   -5,   -6,   -4,   -3,   -5,  -11,  -15,  -14,  -12,  -13,  -16,
     -19,  -20,  -20,  -16,  -10,   -2,   11,   24,   42,   57,   64,   70,   73,   72,   64,   48,
      26,    4,  -15,  -35,  -50,  -68,  -81,  -88,  -81,  -68,  -55,  -44,  -29,  -10,    9,   22,
      25,   30,   37,   38,   35,   24,   14,   11,   13,   14,    9,    0,   -5,   -3,    3,    4,
      -2,  -10,  -15,  -15,  -15,  -19,  -25,  -24,  -20,  -18,  -19,  -20,  -18,  -16,  -13,   -9,
       1,   12,   25,   37,   53,   63,   69,   74,   73,   69,   56,   37,   15,   -6,  -25,  -42,
     -59,  -75,  -82,  -81,  -72,  -61,  -50,  -35,  -17,   -2,   13,   20,   27,   31,   34,   34,
      28,   19,   14,   13,   15,   14,    8,    4,    3,    5,    5,    1,   -6,  -15,  -18,  -22,
     -27,  -33,  -34,  -31,  -25,  -24,  -20,  -19,  -17,  -10,   -2,    9,   18,   28,   39,   51,
      60,   67,   71,   72,   67,   53,   35,   16,   -4,  -21,  -40,  -57,  -70,  -76,  -74,  -65,
     -55,  -44,  -34,  -21,   -7,    6,   15,   18,   20,   24,   24,   21,   16,   15,   16,   17,
      17,   16,   13,   12,   13,   13,    9,    0,  -12,  -17,  -22,  -31,  -40,  -43,  -40,  -35,
     -30,  -26,  -24,  -20,  -11,   -2,    9,   19,   29,   39,   46,   54,   60,   66,   67,   66,
      58,   41,   21,    5,  -11,  -29,  -47,  -62,  -68,  -68,  -65,  -57,  -49,  -39,  -27,  -13,
      -2,    6,   11,   18,   23,   24,   21,   19,   19,   21,   21,   18,   15,   11,   13,   15,
      15,   10,   -2,   -8,  -14,  -21,  -30,  -39,  -44,  -44,  -40,  -33,  -29,  -27,  -21,  -12,
      -3,    6,   16,   28,   40,   48,   54,   56,   59,   61,   62,   57,   44,   28,   12,   -3,
     -22,  -40,  -55,  -64,  -63,  -61,  -56,  -51,  -41,  -29,  -15,   -6,    1,    8,   15,   20,
      20,   18,   17,   18,   23,   23,   20,   17,   15,   18,   20,   20,   15,    4,   -5,  -11,
     -20,  -32,  -43,  -49,  -48,  -43,  -36,  -32,  -29,  -21,  -13,    0,   11,   20,   30,   38,
      46,   50,   51,   53,   56,   53,   48,   41,   30,   19,    5,  -10,  -26,  -42,  -50,  -56,
     -57,  -56,  -53,  -46,  -38,  -27,  -18,  -10,   -2,    8,   16,   19,   24,   24,   22,   23,
      25,   23,   17,   16,   15,   16,   14,   10,    3,   -5,  -11,  -20,  -28,  -35,  -42,  -44,
     -42,  -35,  -29,  -25,  -19,  -11,    0,   10,   20,   26,   31,   38,   45,   48,   46,   46,
      44,   41,   37,   30,   22,   13,    1,  -15,  -27,  -36,  -44,  -49,  -51,  -52,  -49,  -44,
     -37,  -27,  -20,  -12,    1,   10,   19,   23,   28,   29,   28,   28,   24,   19,   17,   16,
      15,   14,   10,    4,   -3,  -10,  -15,  -23,  -31,  -36,  -41,  -41,  -39,  -32,  -24,  -19,
     -11,   -3,    5,   15,   24,   31,   36,   42,   45,   44,   41,   37,   33,   31,   29,   23,
      14,    2,   -8,  -16,  -22,  -31,  -40,  -44,  -46,  -46,  -46,  -44,  -37,  -28,  -20,  -10,
       2,   11,   20,   28,   32,   32,   29,   26,   22,   19,   17,   14,   12,   11,    8,    2,
      -5,  -14,  -20,  -24,  -30,  -34,  -37,  -38,  -36,  -30,  -21,  -14,   -6,    2,   11,   19,
      26,   30,   34,   41,   44,   42,   38,   32,   27,   25,   24,   21,   11,    1,   -9,  -16,
     -25,  -34,  -40,  -43,  -45,  -48,  -50,  -49,  -40,  -27,  -15,   -6,    4,   15,   27,   36,
      40,   37,   32,   27,   22,   15,   11,   10,    8,    6,    0,   -8,  -14,  -16,  -17,  -18,
     -24,  -31,  -33,  -33,  -27,  -22,  -17,  -10,   -4,    6,   13,   17,   22,   27,   33,   38,
      39,   37,   35,   33,   31,   27,   23,   19,   11,    3,   -7,  -20,  -30,  -38,  -42,  -42,
     -46,  -53,  -58,  -53,  -41,  -27,  -13,   -2,   10,   19,   30,   39,   43,   38,   29,   23,
      18,   12,    8,    6,    6,    4,   -3,   -8,  -12,  -13,  -10,  -12,  -17,  -24,  -25,  -23,
     -23,  -23,  -19,  -12,   -4,    2,    5,    9,   14,   22,   32,   37,   39,   39,   37,   37,
      33,   28,   27,   21,   12,    0,  -14,  -25,  -33,  -38,  -43,  -48,  -54,  -60,  -59,  -48,
     -36,  -20,   -8,    2,   12,   26,   39,   44,   40,   32,   27,   23,   16,    8,    3,    3,
       2,    1,   -4,   -9,   -9,   -6,   -6,   -8,  -13,  -16,  -18,  -21,  -22,  -21,  -16,   -7,
      -2,    0,   -2,    2,   13,   25,   30,   34,   34,   34,   34,   33,   33,   31,   26,   21,
      11,   -3,  -15,  -25,  -31,  -37,  -48,  -57,  -62,  -63,  -56,  -46,  -35,  -25,  -12,    5,
      18,   32,   40,   40,   36,   32,   29,   22,   15,    7,    3,    0,    0,    0,    1,   -2,
      -2,    0,    0,   -3,   -4,   -7,  -13,  -22,  -28,  -25,  -17,  -10,  -10,  -11,  -10,   -4,
      12,   26,   36,   39,   40,   41,   40,   37,   35,   33,   28,   19,    3,  -11,  -22,  -30,
     -37,  -46,  -56,  -63,  -65,  -59,  -52,  -43,  -29,  -17,   -4,   10,   23,   32,   36,   36,
      34,   29,   24,   19,   12,    5,   -2,    0,    4,    7,   10,    9,    6,    5,    5,    5,
       0,  -10,  -20,  -26,  -29,  -26,  -20,  -18,  -19,  -17,   -9,    3,   16,   28,   36,   40,
      42,   43,   41,   40,   36,   33,   26,   16,    3,  -10,  -21,  -31,  -42,  -53,  -61,  -65,
     -63,  -58,  -52,  -41,  -31,  -18,   -4,    9,   21,   26,   29,   30,   31,   31,   28,   21,
      12,    6,    5,   10,   13,   13,   14,    9,    8,    7,    5,    0,   -8,  -17,  -24,  -28,
     -27,  -23,  -17,  -14,  -12,   -8,    2,   15,   26,   32,   36,   39,   38,   37,   36,   33,
      28,   21,   16,   10,    1,  -13,  -25,  -34,  -41,  -50,  -59,  -62,  -62,  -53,  -44,  -37,
     -28,  -19,   -6,    7,   14,   18,   22,   26,   28,   28,   21,   13,    6,    6,   15,   19,
      21,   20,   20,   18,   16,   13,    7,   -3,  -12,  -21,  -27,  -31,  -30,  -24,  -15,  -11,
      -8,    0,   10,   23,   29,   32,   34,   34,   34,   33,   32,   27,   23,   20,   17,   10,
      -2,  -15,  -25,  -34,  -43,  -52,  -61,  -63,  -58,  -49,  -43,  -41,  -33,  -22,   -9,    3,
      11,   17,   21,   26,   30,   28,   23,   17,   15,   18,   22,   22,   20,   21,   21,   18,
      12,    4,   -5,  -11,  -16,  -22,  -28,  -32,  -24,  -14,   -7,   -5,    1,   11,   20,   27,
      30,   26,   25,   29,   30,   29,   22,   17,   18,   22,   20,    9,   -8,  -18,  -25,  -31,
     -40,  -53,  -60,  -58,  -54,  -46,  -45,  -42,  -32,  -20,  -10,   -2,    5,   12,   19,   25,
      27,   22,   18,   18,   21,   24,   25,   22,   24,   26,   27,   22,   10,    0,   -7,   -9,
     -12,  -21,  -28,  -28,  -20,   -9,   -4,   -2,    5,   14,   22,   24,   21,   15,   18,   24,
      28,   24,   19,   21,   26,   30,   22,    7,   -6,  -15,  -23,  -34,  -50,  -61,  -66,  -61,
     -52,  -50,  -49,  -45,  -36,  -22,  -10,    1,   11,   15,   20,   26,   26,   24,   21,   21,
      27,   28,   24,   21,   22,   26,   24,   16,    5,   -5,   -7,   -5,  -11,  -17,  -22,  -17,
      -7,    0,    1,    4,    9,   16,   19,   18,   13,   12,   16,   22,   24,   23,   23,   28,
      33,   27,   16,    2,  -12,  -23,  -33,  -45,  -57,  -64,  -64,  -55,  -51,  -52,  -49,  -39,
     -25,  -13,   -6,    1,    6,   12,   16,   18,   20,   18,   20,   25,   28,   28,   29,   31,
      36,   37,   28,   15,    7,    3,    0,   -4,  -14,  -21,  -23,  -16,   -7,   -4,   -3,    1,
      10,   16,   17,   10,    7,    9,   18,   24,   24,   24,   28,   34,   34,   26,   12,   -3,
     -15,  -26,  -40,  -53,  -61,  -65,  -62,  -59,  -57,  -55,  -49,  -39,  -27,  -18,   -6,    3,
       8,   14,   17,   21,   25,   26,   27,   28,   30,   32,   32,   31,   32,   28,   22,   14,
       6,    3,    0,   -3,   -8,  -12,  -12,   -5,    0,    2,    1,    3,    6,   11,   11,    7,
       4,    6,   13,   20,   24,   28,   31,   32,   28,   19,    7,   -7,  -20,  -32,  -44,  -53,
     -58,  -58,  -55,  -54,  -53,  -50,  -46,  -40,  -27,  -14,   -6,   -6,   -5,    0,    8,   16,
      20,   23,   25,   30,   37,   42,   43,   41,   39,   34,   28,   18,    9,    4,    3,    0,
     -10,  -13,  -12,  -10,   -5,    1,    1,    0,    4,    8,    7,    5,    6,   11,   19,   23,
      27,   32,   33,   27,   20,   10,    0,  -15,  -30,  -41,  -49,  -52,  -54,  -55,  -55,  -53,
     -50,  -45,  -40,  -32,  -24,  -16,  -11,  -10,   -8,   -3,    6,   13,   17,   21,   29,   37,
      43,   48,   47,   43,   38,   35,   30,   19,   11,    7,    2,   -5,   -9,   -9,   -5,    1,
       1,    0,   -2,    1,    3,    6,    5,    4,    5,   10,   16,   20,   24,   27,   25,   18,
      10,    3,   -9,  -21,  -31,  -39,  -44,  -47,  -47,  -44,  -46,  -48,  -48,  -45,  -39,  -36,
     -30,  -26,  -25,  -23,  -19,   -9,    4,   14,   24,   32,   41,   48,   54,   56,   57,   52,
      47,   40,   28,   17,   10,    4,   -3,   -8,  -10,   -8,   -6,   -5,   -5,   -5,   -3,    0,
       3,    4,    4,    5,    7,   12,   19,   26,   27,   24,   18,   12,    5,   -3,  -12,  -24,
     -34,  -43,  -46,  -48,  -48,  -46,  -46,  -45,  -44,  -42,  -38,  -33,  -29,  -26,  -26,  -22,
     -14,   -5,    5,   13,   23,   32,   40,   47,   52,   56,   57,   55,   52,   47,   36,   27,
      19,   11,    3,   -5,   -6,   -8,  -10,  -13,  -15,  -14,  -13,  -11,   -6,    1,    4,    7,
      11,   17,   21,   26,   28,   26,   19,   10,    2,   -7,  -17,  -26,  -36,  -41,  -45,  -47,
     -45,  -44,  -44,  -41,  -39,  -40,  -40,  -37,  -33,  -34,  -32,  -26,  -18,   -9,    2,   12,
      26,   40,   47,   56,   63,   66,   66,   63,   60,   53,   40,   27,   14,    3,   -8,  -11,
     -12,  -15,  -19,  -19,  -18,  -15,  -12,   -8,    0,    6,   11,   13,   14,   17,   23,   29,
      27,   18,    9,    1,   -7,  -16,  -25,  -35,  -43,  -49,  -47,  -44,  -43,  -42,  -40,  -36,
     -34,  -33,  -33,  -33,  -35,  -34,  -30,  -23,  -16,   -9,    2,   14,   27,   39,   49,   58,
      66,   69,   68,   66,   61,   53,   45,   32,   18,    1,  -11,  -14,  -17,  -17,  -20,  -23,
     -21,  -17,  -13,   -3,    4,   10,   13,   14,   17,   18,   21,   24,   22,   15,    6,   -4,
     -12,  -22,  -28,  -38,  -49,  -51,  -48,  -45,  -43,  -40,  -38,  -36,  -35,  -34,  -33,  -33,
     -34,  -35,  -33,  -29,  -18,   -6,    6,   19,   33,   46,   59,   71,   78,   78,   78,   74,
      67,   54,   39,   22,    6,   -8,  -16,  -22,  -25,  -25,  -26,  -22,  -17,  -12,   -3,    6,
      15,   17,   16,   14,   14,   16,   17,   16,   13,    6,   -2,  -11,  -20,  -27,  -34,  -43,
     -49,  -48,  -44,  -41,  -39,  -36,  -33,  -34,  -33,  -34,  -32,  -33,  -35,  -35,  -30,  -21,
     -11,    0,    9,   23,   38,   52,   65,   74,   76,   76,   74,   70,   62,   47,   28,   13,
       2,   -6,  -14,  -21,  -23,  -20,  -18,  -16,  -13,   -7,    1,    8,   10,   11,    9,   11,
      11,   13,   15,   16,   13,    8,   -2,  -11,  -19,  -27,  -37,  -47,  -52,  -51,  -48,  -46,
     -43,  -40,  -38,  -36,  -35,  -35,  -38,  -38,  -33,  -27,  -21,  -16,   -7,    6,   21,   36,
      49,   61,   70,   75,   79,   78,   73,   62,   49,   35,   22,    8,   -3,  -12,  -17,  -20,
     -18,  -14,  -13,  -15,  -12,   -5,    4,    7,    8,    8,    9,    8,    9,   11,   14,   14,
      10,    4,   -6,  -15,  -25,  -35,  -41,  -48,  -54,  -53,  -47,  -42,  -38,  -37,  -35,  -31,
     -31,  -30,  -30,  -29,  -26,  -24,  -19,  -12,   -2,   10,   22,   35,   48,   60,   70,   76,
      76,   73,   67,   57,   44,   28,   14,    5,   -3,   -8,  -13,  -14,  -13,  -10,  -11,  -11,
      -8,   -2,    4,    6,    5,    5,    5,    6,   10,   11,   10,    8,    4,   -2,   -9,  -15,
     -24,  -35,  -44,  -50,  -52,  -49,  -45,  -42,  -42,  -40,  -37,  -37,  -37,  -33,  -29,  -26,
     -24,  -21,  -16,   -7,    6,   18,   30,   41,   54,   66,   75,   77,   79,   76,   67,   53,
      37,   21,    8,    2,   -5,  -10,  -14,  -14,  -12,  -12,  -11,  -10,   -5,    4,    7,    4,
       1,    2,    6,    9,    9,    7,    5,    4,    0,   -7,  -14,  -23,  -32,  -37,  -43,  -48,
     -50,  -51,  -47,  -42,  -34,  -32,  -32,  -34,  -32,  -26,  -21,  -18,  -17,  -14,  -11,   -4,
       5,   13,   24,   40,   55,   67,   72,   74,   76,   75,   67,   51,   37,   23,   11,    4,
      -4,  -11,  -15,  -17,  -17,  -16,  -14,  -13,   -8,   -2,    1,    1,    1,    3,    5,    9,
       7,    5,    4,    4,    3,   -5,  -14,  -24,  -32,  -38,  -41,  -47,  -52,  -53,  -49,  -41,
     -35,  -34,  -35,  -33,  -29,  -24,  -19,  -13,  -10,   -9,   -7,   -2,    8,   17,   29,   43,
      56,   67,   74,   75,   75,   72,   64,   53,   38,   23,   13,    4,   -5,  -12,  -16,  -20,
     -21,  -18,  -16,  -14,  -11,   -8,   -5,   -3,    0,    2,    6,    6,    6,    5,    5,    6,
       3,   -6,  -19,  -31,  -37,  -41,  -45,  -50,  -52,  -53,  -48,  -39,  -32,  -30,  -26,  -25,
     -22,  -16,  -10,   -7,  -11,  -10,   -8,   -2,    6,   17,   31,   45,   58,   68,   78,   80,
      76,   70,   65,   55,   37,   18,    5,   -4,  -10,  -19,  -25,  -26,  -24,  -18,  -13,  -11,
      -9,   -6,   -2,    4,    6,    5,    4,    3,    4,    2,    1,   -3,   -4,  -11,  -20,  -29,
     -38,  -43,  -45,  -48,  -51,  -48,  -44,  -39,  -35,  -34,  -31,  -30,  -25,  -15,   -8,   -8,
     -10,   -8,    1,   11,   22,   33,   42,   54,   66,   76,   80,   75,   70,   66,   59,   42,
      23,    6,   -4,   -9,  -17,  -22,  -27,  -25,  -19,   -9,   -7,   -8,   -5,    0,    4,    5,
       2,   -2,   -5,   -5,   -4,   -6,   -7,   -6,  -10,  -16,  -21,  -29,  -34,  -37,  -38,  -41,
     -44,  -42,  -36,  -32,  -33,  -37,  -39,  -35,  -27,  -17,  -12,  -13,  -12,   -6,    6,   22,
      36,   44,   54,   66,   77,   82,   80,   75,   68,   59,   47,   29,   10,   -3,  -13,  -18,
     -23,  -26,  -27,  -24,  -16,   -9,   -5,   -4,   -2,    3,    6,    4,   -2,   -6,   -8,   -7,
      -8,   -8,   -9,  -10,  -13,  -16,  -22,  -29,  -31,  -30,  -34,  -36,  -36,  -32,  -28,  -30,
     -36,  -39,  -38,  -33,  -28,  -24,  -24,  -22,  -15,   -2,   13,   26,   38,   53,   67,   78,
      84,   88,   85,   81,   71,   59,   39,   13,   -5,  -14,  -19,  -26,  -32,  -34,  -30,  -22,
     -13,   -5,    0,    6,    7,   10,    8,    2,   -4,  -10,  -12,  -15,  -18,  -20,  -20,  -20,
     -22,  -24,  -26,  -26,  -23,  -23,  -23,  -24,  -21,  -17,  -18,  -25,  -31,  -35,  -37,  -37,
     -36,  -33,  -29,  -22,  -10,    5,   19,   31,   45,   62,   75,   84,   86,   88,   87,   80,
      66,   45,   22,    4,   -9,  -18,  -26,  -34,  -37,  -33,  -24,  -15,   -9,   -3,    6,   13,
      15,   11,    2,   -5,  -10,  -13,  -20,  -25,  -27,  -26,  -25,  -26,  -29,  -29,  -23,  -18,
     -16,  -19,  -18,  -15,   -9,   -6,  -12,  -21,  -32,  -36,  -36,  -40,  -39,  -36,  -30,  -21,
     -10,    6,   20,   36,   55,   69,   79,   85,   90,   92,   88,   75,   56,   33,   12,   -3,
     -15,  -24,  -33,  -37,  -35,  -28,  -20,  -12,   -4,    6,   14,   18,   16,    9,    0,   -8,
     -15,  -19,  -27,  -33,  -35,  -34,  -34,  -36,  -36,  -29,  -19,  -10,  -10,  -10,   -8,   -4,
      -2,   -2,   -8,  -18,  -28,  -36,  -43,  -48,  -46,  -36,  -25,  -14,   -4,   10,   27,   46,
      65,   78,   86,   89,   87,   85,   78,   64,   42,   19,    0,  -12,  -20,  -29,  -34,  -36,
     -30,  -22,  -12,   -6,    1,    8,   16,   18,   13,    2,   -7,  -12,  -17,  -24,  -33,  -38,
     -39,  -36,  -36,  -36,  -34,  -26,  -18,  -11,   -7,   -6,   -5,   -5,    1,    1,   -5,  -14,
     -24,  -33,  -41,  -42,  -37,  -28,  -19,  -10,    3,   16,   30,   47,   64,   76,   83,   85,
      83,   78,   69,   54,   37,   17,   -2,  -14,  -21,  -28,  -32,  -32,  -27,  -18,  -11,   -6,
       2,   12,   18,   16,    5,   -5,  -11,  -14,  -19,  -30,  -40,  -47,  -45,  -38,  -36,  -34,
     -33,  -26,  -15,   -6,   -2,    1,    1,    3,    5,    4,   -3,  -13,  -26,  -35,  -41,  -39,
     -33,  -23,  -13,   -5,    7,   21,   36,   53,   68,   79,   82,   78,   72,   66,   59,   47,
      30,   10,   -6,  -16,  -21,  -22,  -25,  -27,  -25,  -18,  -10,   -4,    4,   10,   11,    6,
      -4,  -11,  -13,  -18,  -25,  -34,  -43,  -45,  -41,  -36,  -34,  -32,  -27,  -19,  -10,   -5,
       0,    2,    5,    5,    5,    1,   -7,  -16,  -25,  -33,  -38,  -35,  -25,  -13,   -6,    0,
      11,   27,   46,   60,   69,   70,   68,   69,   68,   62,   52,   39,   22,    8,   -2,  -11,
     -18,  -21,  -22,  -23,  -24,  -17,  -10,   -5,    1,    5,    5,    2,   -3,   -5,   -9,  -17,
     -28,  -41,  -46,  -48,  -43,  -42,  -42,  -39,  -30,  -19,   -9,   -3,    6,   11,   15,   16,
      12,    5,   -2,  -12,  -23,  -33,  -37,  -34,  -25,  -18,   -8,    1,   15,   32,   48,   62,
      69,   68,   67,   63,   62,   58,   50,   34,   15,   -2,   -8,  -10,  -11,  -16,  -24,  -24,
     -19,  -12,   -6,   -2,    2,    3,    1,    0,   -6,  -10,  -17,  -26,  -37,  -46,  -48,  -45,
     -44,  -42,  -38,  -32,  -22,  -12,   -6,    4,   10,   14,   16,   15,   11,    5,   -2,  -11,
     -23,  -31,  -29,  -22,  -18,  -16,  -11,    3,   17,   34,   50,   56,   59,   61,   63,   62,
      59,   53,   44,   32,   16,    3,   -8,   -9,  -13,  -20,  -26,  -27,  -21,  -16,  -11,   -9,
      -6,    1,    7,    7,    0,  -10,  -15,  -20,  -30,  -39,  -45,  -48,  -48,  -46,  -41,  -36,
     -29,  -20,  -11,    3,   11,   14,   19,   21,   19,   15,    6,   -3,  -13,  -18,  -18,  -17,
     -20,  -19,  -12,    2,   15,   26,   36,   43,   51,   59,   61,   61,   57,   54,   49,   37,
      21,    9,    1,   -8,  -17,  -25,  -29,  -28,  -27,  -23,  -19,  -13,   -5,    2,    8,    5,
      -4,  -11,  -13,  -17,  -27,  -40,  -49,  -53,  -53,  -50,  -44,  -37,  -28,  -19,   -7,    8,
      18,   22,   26,   26,   23,   17,   10,    0,   -8,  -15,  -20,  -25,  -23,  -19,  -11,    0,
      13,   25,   34,   44,   54,   60,   62,   60,   58,   56,   52,   38,   21,    6,   -6,  -16,
     -26,  -32,  -33,  -30,  -26,  -24,  -17,   -8,    3,   13,   16,   10,    1,   -7,  -12,  -18,
     -34,  -50,  -61,  -63,  -58,  -54,  -50,  -45,  -33,  -13,    6,   21,   27,   34,   37,   36,
      30,   20,   11,   -2,  -13,  -24,  -32,  -37,  -34,  -24,  -10,    2,   12,   25,   41,   55,
      61,   64,   65,   67,   64,   59,   48,   32,   16,    0,  -12,  -20,  -27,  -33,  -33,  -31,
     -28,  -23,  -12,    0,   10,   13,    9,    2,   -2,   -7,  -13,  -25,  -41,  -56,  -65,  -66,
     -62,  -56,  -53,  -42,  -25,   -5,   13,   24,   34,   39,   42,   39,   32,   22,   11,   -2,
     -15,  -27,  -36,  -37,  -31,  -22,  -13,    0,   12,   27,   43,   55,   61,   64,   65,   63,
      60,   53,   42,   28,   10,   -6,  -20,  -27,  -28,  -28,  -25,  -23,  -20,  -13,   -2,   11,
      16,   14,    8,    2,   -6,  -14,  -25,  -38,  -53,  -67,  -73,  -73,  -67,  -58,  -46,  -32,
     -14,    6,   24,   36,   43,   45,   44,   39,   30,   18,    5,  -11,  -25,  -35,  -39,  -37,
     -28,  -17,   -7,    4,   16,   32,   48,   58,   64,   66,   63,   61,   56,   46,   31,   18,
       3,  -13,  -21,  -25,  -23,  -19,  -15,  -11,   -7,   -2,    6,   13,   14,    8,   -3,  -12,
     -21,  -32,  -40,  -55,  -70,  -78,  -75,  -67,  -56,  -47,  -29,  -12,   10,   29,   40,   47,
      49,   48,   43,   31,   15,    0,  -16,  -29,  -39,  -45,  -41,  -32,  -18,   -6,    3,   13,
      27,   43,   57,   64,   65,   61,   58,   52,   43,   32,   18,    6,   -9,  -18,  -20,  -17,
     -12,   -4,    1,    3,    7,   12,   17,   16,    9,   -3,  -15,  -27,  -39,  -48,  -60,  -72,
     -82,  -82,  -73,  -58,  -45,  -33,  -14,    7,   28,   42,   49,   51,   51,   48,   38,   22,
       2,  -16,  -30,  -37,  -42,  -45,  -40,  -26,  -11,    3,   11,   20,   34,   52,   65,   69,
      64,   54,   46,   38,   28,   16,    4,  -11,  -18,  -16,  -10,   -4,    3,   13,   21,   23,
      22,   20,   18,   11,   -2,  -16,  -34,  -47,  -59,  -70,  -76,  -83,  -83,  -76,  -64,  -48,
     -31,  -12,   10,   30,   42,   50,   53,   51,   46,   37,   25,    8,  -13,  -30,  -41,  -45,
     -43,  -35,  -23,  -15,   -5,    8,   17,   28,   40,   56,   64,   63,   55,   45,   34,   24,
      14,    7,   -4,  -12,  -13,   -9,   -2,   11,   23,   31,   33,   33,   31,   26,   17,    4,
     -14,  -31,  -48,  -62,  -75,  -86,  -90,  -87,  -79,  -68,  -54,  -39,  -18,    4,   23,   39,
      47,   52,   52,   47,   39,   29,   15,   -5,  -23,  -35,  -41,  -40,  -34,  -26,  -16,   -8,
       2,   12,   22,   30,   43,   52,   58,   54,   45,   36,   25,   16,    7,   -2,   -7,   -8,
      -3,    4,   13,   24,   32,   39,   42,   39,   30,   19,    6,  -10,  -25,  -44,  -62,  -79,
     -88,  -90,  -85,  -78,  -70,  -59,  -45,  -24,    0,   20,   35,   43,   48,   48,   46,   42,
      33,   20,    2,  -19,  -32,  -38,  -41,  -37,  -29,  -19,   -8,    1,   11,   19,   26,   35,
      43,   48,   48,   41,   35,   26,   16,    7,    0,    0,    3,    6,   10,   16,   24,   32,
      40,   44,   43,   33,   21,    8,   -5,  -19,  -37,  -54,  -72,  -84,  -87,  -81,  -75,  -68,
     -61,  -50,  -33,  -12,    8,   22,   29,   34,   40,   42,   41,   35,   24,   13,   -2,  -16,
     -27,  -33,  -33,  -27,  -22,  -17,  -13,   -4,    9,   18,   25,   31,   36,   42,   44,   40,
      32,   21,   12,    9,    7,    8,    9,   13,   17,   23,   29,   35,   40,   40,   35,   26,
      13,    0,  -11,  -24,  -41,  -60,  -74,  -80,  -79,  -73,  -68,  -63,  -56,  -43,  -27,  -10,
       6,   18,   24,   29,   34,   38,   37,   30,   20,    9,   -3,  -14,  -24,  -27,  -27,  -25,
     -23,  -18,   -9,    2,   10,   19,   25,   30,   37,   40,   41,   33,   22,   16,   10,    6,
       6,   10,   16,   21,   28,   31,   35,   38,   44,   45,   34,   19,    5,   -5,  -17,  -33,
     -52,  -68,  -76,  -78,  -75,  -71,  -67,  -62,  -51,  -37,  -20,   -7,    4,   13,   21,   29,
      34,   36,   33,   26,   17,   10,    0,   -8,  -13,  -19,  -21,  -21,  -17,  -11,   -6,    4,
      10,   13,   19,   25,   30,   31,   28,   20,   14,   10,    7,    7,   11,   20,   26,   32,
      36,   39,   41,   44,   46,   41,   30,   13,    0,  -13,  -27,  -44,  -62,  -72,  -74,  -74,
     -74,  -71,  -66,  -57,  -47,  -32,  -19,   -9,    2,   14,   24,   28,   32,   34,   33,   25,
      17,    9,    2,   -5,  -10,  -17,  -22,  -18,  -13,   -7,    0,    4,   10,   17,   23,   26,
      25,   21,   15,    9,    9,    7,    4,    7,   16,   27,   34,   39,   43,   48,   49,   52,
      49,   39,   24,    9,   -3,  -17,  -32,  -52,  -67,  -75,  -75,  -71,  -70,  -70,  -66,  -56,
     -43,  -31,  -21,  -12,   -2,   11,   21,   27,   30,   33,   31,   29,   22,   15,    8,    0,
      -6,  -13,  -14,  -14,  -11,   -5,    0,    4,    8,   13,   16,   18,   15,   12,   10,    7,
       7,    6,    7,   14,   24,   36,   44,   46,   46,   49,   52,   53,   47,   35,   21,    9,
      -6,  -23,  -43,  -59,  -68,  -71,  -74,  -74,  -76,  -73,  -64,  -52,  -39,  -31,  -25,  -15,
       0,   12,   20,   24,   29,   32,   30,   26,   21,   16,   10,    4,   -2,   -7,   -7,   -5,
      -3,    0,    3,    5,    6,    9,    8,    8,    6,    3,    2,    4,    5,    7,   14,   22,
      34,   43,   49,   57,   57,   55,   52,   48,   43,   31,   17,    2,  -13,  -33,  -49,  -59,
     -63,  -66,  -72,  -75,  -76,  -70,  -61,  -52,  -44,  -37,  -30,  -18,   -4,   11,   20,   25,
      28,   32,   32,   30,   26,   19,   13,    5,    0,   -4,   -5,   -3,    1,    2,    1,   -3,
      -2,    2,    6,    4,    2,   -3,   -2,    3,   10,   13,   18,   27,   40,   49,   56,   59,
      60,   56,   52,   47,   41,   30,   17,    1,  -19,  -39,  -55,  -64,  -67,  -70,  -76,  -81,
     -78,  -69,  -56,  -46,  -40,  -33,  -24,  -12,    3,   15,   22,   25,   26,   29,   27,   23,
      19,   14,    9,    4,    0,   -2,    1,    5,    9,    7,    2,   -3,   -3,    3,    3,   -2,
     -10,  -13,  -10,   -2,    7,   14,   22,   31,   45,   59,   65,   68,   65,   62,   58,   50,
      41,   28,   12,   -9,  -31,  -49,  -59,  -65,  -70,  -76,  -84,  -84,  -77,  -63,  -50,  -45,
     -40,  -32,  -21,   -7,    7,   16,   24,   28,   29,   28,   23,   18,   15,   11,    6,    0,
      -4,   -3,    4,   11,   14,   11,    6,    5,    7,    7,    2,   -7,  -12,  -16,  -13,   -6,
       1,    8,   17,   32,   50,   63,   68,   68,   69,   70,   65,   56,   43,   27,    7,  -17,
     -38,  -52,  -62,  -71,  -78,  -86,  -88,  -84,  -73,  -59,  -50,  -43,  -34,  -25,  -11,    2,
      11,   19,   23,   26,   26,   21,   17,   12,    9,    7,    5,    2,    2,    4,   11,   16,
      14,   10,    9,   10,    9,    1,   -8,  -16,  -19,  -16,  -11,   -6,    0,    8,   24,   43,
      57,   66,   70,   72,   72,   67,   63,   52,   37,   18,   -5,  -23,  -41,  -54,  -62,  -70,
     -78,  -81,  -82,  -76,  -67,  -56,  -45,  -36,  -31,  -22,  -12,    0,   10,   16,   20,   21,
      17,   13,    7,    3,    3,    6,    6,    6,    9,   14,   20,   21,   20,   17,   17,   15,
       9,   -3,  -15,  -23,  -27,  -20,  -14,   -9,   -4,    9,   31,   49,   64,   70,   75,   78,
      76,   70,   60,   45,   31,   12,  -11,  -31,  -46,  -58,  -66,  -70,  -73,  -77,  -74,  -67,
     -59,  -52,  -44,  -36,  -29,  -22,  -14,   -6,    1,   11,   14,   14,   11,    6,    6,    7,
      10,   11,   12,   15,   18,   24,   23,   21,   19,   20,   18,   12,    0,  -13,  -20,  -27,
     -27,  -22,  -16,  -11,    1,   19,   36,   52,   64,   73,   79,   81,   77,   69,   56,   43,
      26,    5,  -16,  -37,  -54,  -62,  -66,  -69,  -72,  -71,  -65,  -62,  -56,  -47,  -39,  -33,
     -26,  -19,  -14,  -12,   -3,    9,    9,    3,   -6,   -4,    5,   11,   12,   11,   12,   20,
      29,   31,   29,   25,   25,   27,   24,   11,   -6,  -17,  -25,  -31,  -32,  -30,  -26,  -16,
       0,   17,   35,   51,   66,   78,   87,   88,   84,   73,   57,   40,   23,    3,  -20,  -42,
     -57,  -65,  -69,  -71,  -70,  -68,  -63,  -58,  -52,  -45,  -38,  -30,  -26,  -24,  -23,  -16,
      -8,   -2,   -5,   -9,   -6,    1,    9,   12,   13,   17,   24,   32,   37,   37,   34,   32,
      33,   31,   19,    2,  -15,  -25,  -31,  -36,  -38,  -35,  -27,  -13,    4,   23,   40,   59,
      76,   91,   96,   91,   80,   69,   55,   35,   13,  -12,  -35,  -52,  -61,  -66,  -71,  -70,
     -63,  -54,  -48,  -44,  -42,  -36,  -31,  -30,  -34,  -36,  -33,  -26,  -20,  -20,  -21,  -18,
      -9,    5,   13,   18,   21,   29,   40,   47,   50,   49,   44,   40,   34,   23,    6,  -14,
     -27,  -39,  -45,  -48,  -45,  -35,  -23,   -7,   11,   30,   51,   73,   89,   97,   96,   89,
      80,   63,   44,   25,    4,  -18,  -39,  -53,  -59,  -63,  -61,  -58,  -55,  -52,  -49,  -45,
     -39,  -35,  -37,  -41,  -46,  -43,  -38,  -33,  -29,  -25,  -18,  -11,    3,   13,   20,   25,
      30,   38,   46,   51,   50,   47,   43,   37,   26,    9,   -7,  -19,  -32,  -45,  -52,  -51,
     -40,  -28,  -12,    4,   19,   38,   61,   83,   94,   95,   89,   82,   67,   50,   30,   12,
      -8,  -26,  -40,  -52,  -57,  -56,  -52,  -48,  -46,  -44,  -40,  -34,  -32,  -32,  -37,  -44,
     -47,  -45,  -41,  -39,  -35,  -28,  -17,   -6,    7,   15,   23,   32,   40,   47,   52,   52,
      51,   46,   39,   32,   17,    1,  -14,  -26,  -37,  -46,  -50,  -45,  -35,  -25,  -11,    5,
      24,   44,   62,   79,   88,   86,   79,   70,   59,   45,   25,    7,  -13,  -25,  -36,  -46,
     -50,  -51,  -50,  -46,  -43,  -41,  -37,  -34,  -33,  -36,  -40,  -43,  -46,  -46,  -41,  -36,
     -31,  -22,  -10,    4,   13,   21,   30,   40,   47,   50,   53,   52,   47,   39,   30,   18,
       3,  -12,  -22,  -33,  -42,  -47,  -45,  -36,  -25,  -14,   -2,   14,   34,   52,   67,   76,
      77,   72,   65,   55,   43,   27,   12,   -7,  -21,  -29,  -36,  -41,  -44,  -43,  -39,  -36,
     -32,  -27,  -26,  -26,  -29,  -33,  -36,  -43,  -49,  -48,  -44,  -38,  -32,  -22,  -11,    4,
      15,   25,   34,   44,   50,   53,   54,   52,   44,   35,   23,    9,   -4,  -15,  -27,  -37,
     -43,  -45,  -42,  -34,  -21,   -9,    5,   19,   34,   50,   63,   70,   69,   63,   54,   46,
      35,   20,    4,  -11,  -23,  -29,  -33,  -37,  -41,  -40,  -33,  -25,  -20,  -19,  -21,  -22,
     -23,  -26,  -34,  -42,  -47,  -46,  -43,  -36,  -30,  -22,  -11,    5,   17,   28,   37,   45,
      52,   55,   53,   49,   41,   30,   19,    4,  -12,  -23,  -33,  -41,  -45,  -45,  -40,  -31,
     -18,   -3,   11,   23,   38,   51,   63,   64,   58,   51,   45,   36,   25,   10,   -4,  -15,
     -24,  -28,  -32,  -36,  -35,  -29,  -19,  -13,  -13,  -14,  -13,  -13,  -13,  -21,  -33,  -43,
     -45,  -45,  -41,  -38,  -34,  -25,  -11,    4,   17,   29,   39,   49,   57,   60,   55,   48,
      39,   29,   16,    1,  -14,  -27,  -35,  -42,  -47,  -48,  -42,  -29,  -15,   -3,   10,   20,
      34,   48,   56,   57,   51,   45,   38,   30,   20,    7,   -7,  -17,  -22,  -26,  -32,  -36,
     -31,  -21,   -9,   -6,   -8,   -8,   -4,    1,   -4,  -13,  -26,  -35,  -39,  -40,  -42,  -44,
     -40,  -29,  -13,    3,   16,   29,   43,   58,   67,   67,   59,   49,   39,   27,   11,   -9,
     -28,  -39,  -47,  -50,  -53,  -52,  -44,  -29,  -12,    5,   13,   25,   38,   51,   57,   52,
      45,   38,   30,   21,    9,   -4,  -14,  -21,  -26,  -29,  -33,  -28,  -18,   -7,    2,    2,
       2,    4,    8,   10,    5,  -10,  -25,  -36,  -42,  -45,  -49,  -49,  -45,  -33,  -14,    5,
      22,   35,   54,   69,   78,   76,   67,   53,   41,   27,    6,  -17,  -36,  -50,  -55,  -60,
     -63,  -62,  -51,  -34,  -16,   -2,    9,   20,   34,   45,   50,   48,   42,   35,   29,   18,
       7,    0,    0,    0,    0,    0,    0,    7,    0,   -1,   -7,  -18,  -16,    3,    6,  -18,
     -29,  -21,    6,    6,  -12,  -10,  -10,   -2,    4,   15,   21,   14,    4,    9,   29,   27,
      15,    9,   13,   20,    0,  -21,  -11,    3,  -11,  -37,  -36,   -7,   11,   -4,  -26,  -23,
      -4,   15,   -4,  -15,  -11,  -10,   -1,    9,   23,   15,    8,    6,   24,   35,   19,   14,
       6,   17,   10,  -15,  -26,   -7,   -1,  -23,  -40,  -24,    4,   10,  -16,  -25,  -13,   11,
      10,  -14,  -15,  -12,   -6,    1,   19,   22,    6,    7,   15,   40,   31,   22,    7,    7,
      15,    5,  -22,  -21,   -5,   -9,  -33,  -32,  -15,    5,   -4,  -19,  -20,    1,   17,   -4,
     -15,  -11,  -12,   -4,    9,   27,   13,    7,   11,   32,   44,   30,   14,    2,    7,    9,
      -8,  -25,  -18,   -9,  -19,  -30,  -21,   -4,    2,  -10,  -21,  -13,   15,    8,  -11,  -13,
     -16,  -12,    0,   20,   24,    9,    9,   19,   44,   47,   25,    6,    2,   11,   -1,  -21,
     -27,  -19,  -17,  -20,  -23,  -17,   -5,   -5,  -14,  -20,    0,   15,   -4,   -7,  -17,  -17,
      -8,    7,   25,   18,    7,   11,   31,   54,   41,   14,   -1,   10,    3,  -14,  -27,  -29,
     -21,  -16,  -16,  -18,  -17,  -11,  -10,  -16,  -16,   10,    6,   -3,   -9,  -19,  -16,   -2,
      18,   27,   16,    8,   19,   45,   54,   29,    5,    6,    4,   -9,  -18,  -29,  -30,  -18,
     -10,   -9,  -14,  -20,  -12,  -13,  -17,   -5,   12,    7,    2,  -16,  -22,  -13,    8,   25,
      23,   12,   11,   32,   53,   48,   17,    9,    9,   -7,  -16,  -24,  -37,  -28,  -12,   -4,
      -2,  -18,  -21,  -18,  -23,  -17,    7,   11,   10,   -4,  -16,  -22,   -7,   21,   28,   18,
       9,   20,   43,   55,   37,   11,   11,    1,  -14,  -17,  -31,  -34,  -21,  -10,    4,   -2,
     -20,  -23,  -26,  -29,   -3,    6,   13,    8,   -5,  -23,  -27,    7,   28,   27,   15,   12,
      32,   48,   50,   24,    9,    8,  -12,  -19,  -26,  -37,  -35,  -19,    3,    6,  -12,  -21,
     -31,  -38,  -17,    6,    4,   14,    6,   -8,  -35,  -15,   19,   26,   21,    7,   23,   43,
      52,   42,   14,    9,   -2,  -16,  -21,  -25,  -33,  -33,   -4,   13,    3,  -13,  -30,  -47,
     -37,    1,    6,    7,   12,    6,  -15,  -31,   -1,   22,   30,   14,    9,   37,   48,   50,
      26,    8,    6,  -11,  -22,  -22,  -25,  -45,  -22,   13,   15,    1,  -22,  -43,  -56,  -21,
       7,    6,   10,   15,   -7,  -25,  -21,    7,   28,   21,    2,   25,   47,   53,   39,   11,
      10,    1,  -20,  -22,  -18,  -37,  -42,    2,   15,   15,   -8,  -32,  -57,  -48,   -9,    9,
       5,   14,    8,  -14,  -20,  -13,   17,   33,    8,    9,   37,   52,   55,   25,    7,    8,
     -11,  -23,  -15,  -23,  -47,  -20,   12,   21,   10,  -23,  -50,  -57,  -31,    2,   10,    9,
      11,   -8,  -10,  -18,   -3,   30,   22,    1,   22,   45,   57,   45,   11,   11,    0,  -23,
     -22,  -16,  -36,  -36,   -6,   15,   18,   -3,  -43,  -56,  -49,  -21,    5,   11,   12,   -2,
      -8,   -9,  -15,   12,   31,    9,   10,   34,   48,   60,   29,   16,   10,  -17,  -24,  -21,
     -27,  -31,  -17,    5,   14,   12,  -22,  -50,  -48,  -41,   -9,    7,   13,   -1,   -8,   -2,
     -11,   -5,   26,   19,    6,   21,   37,   55,   49,   25,   22,   -5,  -20,  -24,  -26,  -29,
     -23,   -9,    8,   13,   -1,  -41,  -48,  -47,  -30,   -3,   12,    7,  -12,   -2,    1,   -8,
      10,   20,   11,   16,   26,   40,   54,   42,   36,    7,  -13,  -18,  -26,  -29,  -26,  -14,
      -2,    7,    8,  -18,  -45,  -48,  -45,  -19,    6,   11,  -10,   -8,    5,   -7,    2,   12,
      17,   15,   16,   23,   45,   55,   48,   27,   -7,  -12,  -18,  -30,  -31,  -17,   -5,   -3,
       4,    5,  -24,  -40,  -50,  -38,   -8,    8,    1,  -13,    1,   -1,    3,    8,   15,   18,
      15,   15,   28,   52,   59,   47,    9,   -9,  -10,  -25,  -40,  -29,   -3,   -5,  -13,    1,
       3,  -26,  -47,  -53,  -23,   -2,    5,  -11,   -6,    4,    6,   10,   10,   19,   11,   13,
      15,   42,   61,   61,   32,    3,   -5,  -12,  -35,  -43,  -14,    1,  -16,  -13,    9,   -1,
     -33,  -57,  -46,  -19,   -3,   -1,  -16,   -2,    5,   15,    6,   17,    9,    5,    9,   26,
      54,   65,   52,   21,    3,   -6,  -21,  -48,  -33,   -4,   -7,  -22,   -2,   18,   -4,  -47,
     -58,  -33,  -11,    2,  -13,  -15,    3,   16,   15,    9,   15,   -1,    5,   14,   48,   66,
      65,   37,   23,    2,  -11,  -42,  -48,  -20,   -4,  -23,  -18,   18,   19,  -17,  -61,  -52,
     -27,   -2,   -5,  -24,   -7,    9,   20,   14,   18,    2,   -3,    7,   34,   63,   68,   50,
      37,   19,   -9,  -25,  -49,  -38,  -14,  -14,  -28,    6,   25,    9,  -40,  -62,  -45,  -17,
       3,  -21,  -16,   -3,   12,   18,   18,   10,   -6,    0,   16,   56,   69,   63,   43,   38,
       2,  -20,  -42,  -44,  -33,  -14,  -25,  -10,   22,   18,  -11,  -55,  -57,  -37,   -3,  -10,
     -26,  -10,    2,   17,   21,   20,   -3,   -2,    5,   39,   67,   73,   56,   47,   22,  -17,
     -35,  -43,  -36,  -28,  -18,  -20,    9,   22,    8,  -33,  -56,  -53,  -26,   -2,  -23,  -24,
     -11,    4,   23,   30,    4,   -3,    0,   27,   60,   71,   69,   58,   43,   -6,  -35,  -43,
     -35,  -36,  -27,  -18,   -2,   19,   17,   -9,  -41,  -51,  -45,  -10,  -12,  -31,  -21,   -9,
       8,   33,   17,    0,    2,    8,   50,   69,   75,   70,   64,   16,  -31,  -47,  -35,  -32,
     -34,  -25,  -14,   10,   16,    5,  -26,  -42,  -50,  -32,   -8,  -22,  -31,  -22,   -8,   22,
      32,    7,    6,    4,   28,   63,   69,   71,   78,   43,  -20,  -51,  -41,  -23,  -34,  -30,
     -22,    2,   13,    9,  -10,  -31,  -45,  -44,  -21,  -19,  -27,  -36,  -26,    2,   29,   24,
      12,   11,   13,   45,   69,   68,   81,   70,    6,  -47,  -52,  -28,  -23,  -27,  -26,  -14,
      11,   10,   -2,  -18,  -33,  -43,  -34,  -25,  -22,  -36,  -44,  -14,   14,   29,   27,   22,
      18,   29,   60,   65,   71,   86,   41,  -32,  -57,  -41,  -23,  -22,  -22,  -24,   -4,   10,
       0,  -11,  -21,  -31,  -37,  -37,  -29,  -29,  -53,  -33,   -3,   16,   33,   31,   27,   23,
      46,   64,   65,   85,   71,   -4,  -48,  -47,  -31,  -20,  -15,  -15,  -19,    1,    0,   -5,
     -14,  -21,  -26,  -40,  -39,  -28,  -51,  -50,  -18,    4,   26,   38,   36,   30,   32,   61,
      64,   70,   80,   31,  -35,  -43,  -40,  -25,  -19,   -6,  -17,  -11,    0,   -6,  -11,  -17,
     -15,  -31,  -47,  -39,  -45,  -62,  -34,   -8,   12,   36,   38,   41,   37,   51,   65,   60,
      71,   56,   -7,  -36,  -38,  -35,  -27,  -11,   -5,  -17,   -8,   -8,   -9,  -17,  -13,  -20,
     -37,  -47,  -50,  -62,  -49,  -16,    1,   25,   34,   43,   53,   49,   62,   58,   62,   65,
      22,  -23,  -31,  -34,  -35,  -19,   -3,   -8,  -18,   -7,   -4,  -14,  -17,   -9,  -27,  -40,
     -56,  -68,  -64,  -27,   -4,    9,   28,   37,   54,   60,   61,   59,   54,   63,   43,   -1,
     -25,  -23,  -37,  -28,   -8,    4,  -10,  -15,   -3,   -7,  -26,  -15,  -11,  -29,  -51,  -71,
     -71,  -49,   -8,    5,   14,   30,   48,   66,   68,   63,   51,   56,   51,   18,  -18,  -20,
     -25,  -39,  -23,   -5,    3,  -13,   -6,   -5,  -21,  -28,  -10,  -18,  -43,  -67,  -78,  -64,
     -25,    1,    8,   15,   38,   60,   75,   74,   58,   54,   57,   28,   -7,  -18,   -8,  -31,
     -34,  -15,    4,   -2,   -4,    0,  -15,  -32,  -21,   -8,  -28,  -57,  -77,  -75,  -44,  -12,
       6,    8,   20,   49,   68,   77,   71,   53,   61,   41,    3,  -18,   -4,  -14,  -36,  -28,
      -7,    1,    7,    6,   -8,  -34,  -35,  -16,  -15,  -41,  -66,  -75,  -59,  -31,   -4,   10,
      11,   31,   56,   72,   85,   63,   58,   55,   14,  -17,  -10,   -1,  -24,  -30,  -22,   -6,
      11,   16,    9,  -27,  -43,  -27,  -15,  -26,  -53,  -63,  -66,  -46,  -21,    3,   13,   15,
      40,   63,   83,   78,   60,   67,   38,   -9,  -20,    4,   -7,  -23,  -25,  -22,    6,   24,
      20,   -8,  -48,  -43,  -24,  -16,  -39,  -55,  -57,  -57,  -36,  -10,    9,   11,   22,   50,
      73,   88,   71,   65,   59,   14,  -24,   -9,   -3,  -15,  -18,  -31,  -14,   25,   28,   10,
     -36,  -56,  -41,  -21,  -29,  -48,  -47,  -51,  -50,  -26,   -2,   11,    6,   30,   57,   82,
      83,   69,   65,   35,  -12,  -16,   -3,  -10,  -12,  -21,  -26,   11,   33,   26,   -7,  -56,
     -54,  -32,  -26,  -41,  -39,  -37,  -52,  -41,  -16,    5,    7,   11,   37,   72,   91,   78,
      66,   55,   11,  -19,  -14,  -15,   -9,   -7,  -19,   -8,   22,   30,   13,  -32,  -62,  -44,
     -31,  -34,  -40,  -29,  -40,  -46,  -29,   -8,    2,    1,   18,   49,   84,   86,   72,   67,
      39,   -6,  -21,  -25,  -16,    2,   -6,  -12,    6,   23,   18,   -7,  -51,  -56,  -39,  -33,
     -41,  -30,  -24,  -41,  -36,  -17,   -8,   -5,    7,   32,   66,   84,   78,   75,   58,   20,
     -15,  -29,  -33,    2,    4,   -1,    1,   11,   17,    4,  -27,  -56,  -46,  -36,  -37,  -39,
     -22,  -24,  -38,  -23,  -16,  -16,   -7,   18,   46,   72,   82,   81,   72,   44,   -1,  -25,
     -41,  -18,   14,    8,   10,    0,    5,    2,  -11,  -40,  -50,  -42,  -38,  -37,  -33,  -11,
     -27,  -26,  -20,  -22,  -13,    0,   31,   52,   73,   82,   80,   61,   26,  -16,  -37,  -40,
       0,   18,   17,   12,   -5,   -8,  -10,  -21,  -41,  -43,  -44,  -36,  -35,  -20,  -12,  -23,
     -14,  -32,  -21,  -12,   15,   38,   58,   76,   82,   72,   46,    4,  -26,  -41,  -23,   14,
      25,   18,    2,  -23,  -18,  -14,  -29,  -35,  -45,  -42,  -35,  -29,  -15,  -19,   -3,  -23,
     -32,  -19,   -1,   27,   40,   67,   81,   76,   61,   26,  -11,  -33,  -36,   -6,   28,   28,
      13,  -15,  -38,  -19,  -20,  -26,  -36,  -46,  -35,  -32,  -20,  -21,   -4,   -4,  -28,  -25,
     -16,   13,   31,   49,   74,   79,   69,   48,    8,  -16,  -33,  -21,    7,   33,   24,    5,
     -32,  -38,  -22,  -21,  -22,  -41,  -43,  -32,  -25,  -23,  -16,    6,   -9,  -29,  -28,   -5,
      20,   39,   58,   75,   71,   60,   22,    0,  -18,  -27,  -10,   16,   30,   15,  -14,  -49,
     -34,  -19,  -16,  -27,  -43,  -31,  -25,  -27,  -24,   -1,    7,  -15,  -32,  -22,    3,   28,
      50,   61,   67,   59,   38,   13,    5,  -17,  -16,   -3,   21,   23,    3,  -34,  -49,  -28,
     -17,  -19,  -34,  -34,  -18,  -26,  -32,  -16,   14,    6,  -23,  -34,  -11,   14,   44,   54,
      56,   60,   44,   25,   18,    2,  -18,   -9,    3,   21,    9,  -14,  -45,  -39,  -24,  -22,
     -28,  -32,  -18,  -17,  -36,  -30,    5,   21,   -5,  -31,  -27,    1,   30,   56,   46,   50,
      47,   32,   29,   20,   -4,   -9,   -9,    4,   10,   -2,  -28,  -38,  -31,  -33,  -26,  -26,
     -19,   -9,  -24,  -38,  -11,   24,   10,  -17,  -36,  -14,   14,   48,   49,   37,   43,   39,
      33,   32,   11,    1,   -5,  -11,   -6,   -3,  -16,  -29,  -28,  -40,  -38,  -27,  -20,   -6,
     -11,  -31,  -29,   15,   22,    0,  -25,  -25,    2,   31,   51,   38,   35,   41,   41,   34,
      27,    8,    6,   -7,  -20,  -14,   -7,  -20,  -19,  -34,  -52,  -35,  -23,  -11,   -5,  -18,
     -33,   -5,   26,    5,  -11,  -27,  -11,   17,   43,   43,   30,   29,   46,   45,   38,   17,
       6,    2,  -22,  -27,  -16,  -16,  -18,  -18,  -53,  -48,  -23,  -19,   -3,  -10,  -21,  -19,
      18,   12,   -6,  -20,  -21,    6,   29,   42,   31,   23,   37,   54,   48,   31,   13,   13,
     -13,  -31,  -25,  -16,  -16,  -11,  -38,  -62,  -33,  -28,   -7,   -3,  -12,  -17,    6,   16,
       2,  -11,  -17,   -5,   15,   35,   34,   25,   23,   44,   55,   41,   22,   14,    2,  -29,
     -32,  -23,  -11,  -13,  -18,  -60,  -50,  -32,  -16,   -6,  -11,   -4,    3,   11,    3,   -1,
     -14,   -8,    5,   20,   39,   31,   24,   26,   54,   57,   37,   16,    8,  -19,  -32,  -27,
     -17,  -17,  -17,  -36,  -58,  -40,  -32,  -11,  -11,   -2,    6,   10,    2,    0,   -4,  -12,
       1,    8,   33,   42,   26,   17,   35,   63,   53,   26,    6,   -9,  -27,  -30,  -25,  -17,
     -23,  -24,  -47,  -51,  -38,  -17,  -11,   -6,   12,   17,    8,   -8,   -1,  -10,   -7,    4,
      18,   40,   33,   18,   22,   49,   70,   46,   12,  -11,  -16,  -23,  -27,  -19,  -28,  -26,
     -36,  -50,  -48,  -31,  -13,  -13,   10,   20,   21,    0,   -6,   -1,   -7,    3,   15,   32,
      40,   24,   17,   31,   58,   67,   28,   -2,  -21,  -14,  -31,  -18,  -24,  -33,  -33,  -49,
     -49,  -41,  -18,  -20,   -2,   20,   23,   19,  -12,   -7,   -2,   -3,   10,   22,   33,   37,
      21,   23,   39,   72,   51,   10,  -17,  -18,  -20,  -29,  -17,  -33,  -36,  -49,  -48,  -47,
     -24,  -16,  -15,   11,   24,   30,    6,  -12,   -2,   -2,   -1,   18,   29,   35,   27,   25,
      25,   56,   63,   23,   -5,  -19,  -14,  -23,  -21,  -21,  -38,  -52,  -54,  -40,  -32,  -15,
     -23,   -7,   18,   31,   22,   -2,   -7,    3,    0,   12,   21,   34,   31,   28,   22,   35,
      66,   40,    2,  -19,  -19,  -15,  -21,  -16,  -30,  -60,  -62,  -42,  -33,  -18,  -18,  -22,
       4,   29,   29,   14,   -2,   -4,    5,    6,   16,   28,   36,   24,   29,   26,   52,   49,
      14,  -13,  -24,  -19,  -14,  -15,  -17,  -53,  -75,  -54,  -32,  -18,  -11,  -26,  -18,   18,
      28,   25,   13,   -6,    4,   13,    9,   17,   37,   24,   28,   33,   37,   49,   26,    1,
     -19,  -26,  -16,  -11,   -7,  -33,  -77,  -71,  -45,  -15,   -8,  -18,  -30,    1,   25,   21,
      26,    3,    5,   17,   14,   11,   33,   27,   17,   34,   38,   42,   33,    6,  -11,  -28,
     -22,  -12,   -3,  -16,  -60,  -81,  -62,  -25,   -2,  -14,  -27,  -17,   20,   18,   24,   18,
       6,   16,   21,   12,   24,   28,   12,   26,   44,   42,   35,   13,   -5,  -21,  -31,  -18,
      -2,   -2,  -42,  -77,  -76,  -47,  -10,   -6,  -22,  -24,    4,   16,   18,   25,   18,   18,
      24,   20,   20,   32,   14,   11,   40,   49,   41,   21,   -6,  -13,  -27,  -28,   -5,    5,
     -18,  -59,  -79,  -63,  -30,   -6,  -11,  -28,  -11,    8,   10,   23,   27,   17,   24,   25,
      25,   28,   19,    8,   25,   47,   46,   27,   -5,  -15,  -18,  -33,  -20,   -5,   -3,  -35,
     -70,  -66,  -51,  -22,   -7,  -21,  -19,   -3,    6,   17,   29,   26,   23,   28,   25,   32,
      23,   14,   11,   39,   50,   38,    3,  -19,  -10,  -21,  -29,  -12,   -3,  -12,  -55,  -65,
     -56,  -42,  -14,  -10,  -23,  -11,   -3,   10,   23,   32,   26,   28,   28,   35,   29,   22,
      13,   18,   41,   43,   18,  -16,  -18,  -14,  -29,  -21,  -11,   -8,  -32,  -61,  -52,  -52,
     -30,  -11,  -18,  -16,  -10,    2,   22,   35,   30,   25,   32,   34,   40,   27,   19,   11,
      23,   39,   32,   -1,  -22,  -14,  -22,  -23,  -14,  -11,  -17,  -45,  -52,  -51,  -51,  -22,
     -17,  -19,  -17,  -10,   11,   35,   39,   29,   26,   34,   43,   43,   27,   16,   12,   25,
      31,   18,  -13,  -20,  -19,  -22,  -12,  -14,  -15,  -28,  -44,  -47,  -53,  -33,  -15,  -22,
     -24,  -20,    5,   27,   38,   31,   21,   27,   46,   51,   40,   18,    8,   13,   23,   24,
       3,  -21,  -22,  -22,   -8,   -9,  -22,  -26,  -31,  -40,  -51,  -44,  -17,  -15,  -26,  -31,
     -10,   24,   35,   37,   25,   21,   42,   57,   53,   30,   11,    7,   11,   21,   12,  -11,
     -23,  -25,  -12,    0,  -18,  -32,  -31,  -30,  -45,  -46,  -26,  -13,  -25,  -39,  -25,   15,
      36,   29,   25,   20,   37,   58,   63,   46,   15,    3,   -2,   19,   16,   -2,  -19,  -25,
     -23,    4,   -4,  -31,  -36,  -29,  -32,  -43,  -37,  -17,  -16,  -39,  -43,   -2,   34,   31,
      21,   17,   30,   62,   67,   62,   27,    9,   -9,    3,   26,    8,  -18,  -26,  -26,   -5,
       9,  -23,  -44,  -33,  -26,  -33,  -40,  -28,  -12,  -30,  -52,  -24,   23,   33,   15,   14,
      22,   54,   75,   68,   47,   14,   -9,  -12,   19,   23,  -12,  -20,  -20,  -13,   11,   -6,
     -40,  -41,  -19,  -23,  -34,  -34,  -14,  -13,  -48,  -48,    4,   35,   23,    7,   13,   40,
      77,   78,   57,   31,   -3,  -18,    3,   27,    7,  -24,  -19,  -16,    1,    5,  -29,  -49,
     -28,  -13,  -26,  -34,  -26,   -4,  -30,  -57,  -24,   22,   30,    6,    7,   31,   63,   86,
      68,   42,   10,  -19,  -13,   15,   25,  -10,  -22,  -14,   -7,    6,  -11,  -45,  -40,  -14,
     -24,  -35,  -31,  -12,   -8,  -51,  -44,   -2,   29,   11,   -1,   22,   47,   74,   78,   49,
      25,   -8,  -26,   -4,   26,   12,  -16,  -19,  -11,   -1,   -1,  -28,  -45,  -22,  -13,  -29,
     -29,  -23,   -1,  -26,  -55,  -26,   14,   20,   -3,   13,   39,   63,   80,   61,   33,    8,
     -22,  -25,   10,   22,   -1,  -14,  -15,   -7,   -1,  -14,  -37,  -26,  -13,  -25,  -28,  -26,
      -2,   -5,  -48,  -44,   -7,   18,    3,    9,   30,   49,   71,   70,   45,   23,  -13,  -33,
      -5,   22,   11,   -7,  -17,  -14,   -6,   -8,  -29,  -29,  -15,  -19,  -26,  -31,  -15,    6,
     -25,  -52,  -30,    7,    7,    2,   21,   40,   60,   67,   52,   33,    7,  -29,  -19,   16,
      22,    4,   -8,  -15,  -11,   -6,  -23,  -24,  -10,  -11,  -23,  -27,  -22,    1,    0,  -34,
     -45,  -14,    2,    1,   15,   35,   52,   62,   49,   36,   21,  -16,  -26,    1,   20,   12,
      -7,  -10,  -20,  -10,  -19,  -28,   -9,   -8,  -15,  -26,  -27,  -11,    2,  -15,  -41,  -34,
     -10,   -7,    6,   32,   48,   56,   51,   35,   26,    1,  -24,  -10,   15,   18,    2,   -9,
     -17,  -18,  -11,  -32,   -6,    2,   -9,  -18,  -22,  -17,   -3,   -2,  -21,  -34,  -26,  -13,
      -8,   20,   47,   53,   52,   38,   24,    5,  -14,  -15,    9,   14,    4,   -6,  -14,  -21,
     -14,  -28,  -22,   12,    0,  -10,  -23,  -24,  -13,    2,  -10,  -23,  -34,  -26,  -13,    4,
      39,   58,   51,   45,   28,    6,   -9,  -11,    3,   17,    7,   -3,  -10,  -18,  -15,  -22,
     -35,    2,   18,    2,  -11,  -23,  -20,   -1,    0,  -15,  -24,  -39,  -25,   -6,   17,   52,
      56,   47,   35,    6,  -10,   -8,    0,   13,   13,   -2,   -9,  -13,  -13,  -25,  -43,  -16,
      21,   19,   -3,  -21,  -25,  -10,    2,   -5,  -14,  -30,  -40,  -13,   -1,   34,   58,   51,
      44,   18,  -10,   -9,   -2,    6,   12,    7,   -7,  -12,  -12,  -18,  -40,  -33,    9,   32,
      19,   -9,  -23,  -15,    1,    3,   -9,  -18,  -40,  -28,   -4,    7,   47,   59,   49,   24,
       1,  -13,   -5,    1,   10,   11,    5,  -12,  -12,  -15,  -35,  -42,   -9,   23,   33,    9,
     -22,  -24,   -5,    1,   -5,  -12,  -30,  -40,   -7,   -3,   22,   56,   58,   35,   11,  -12,
      -9,   -5,   -1,    7,   13,   -4,  -13,  -13,  -25,  -43,  -29,   10,   34,   32,   -6,  -27,
      -8,    3,   -5,  -13,  -22,  -40,  -18,   -3,   -1,   37,   61,   46,   23,   -5,  -13,   -4,
      -4,   -7,   12,   14,  -10,  -18,  -22,  -34,  -35,  -10,   22,   39,   23,  -15,  -14,    5,
       3,   -8,  -15,  -36,  -23,   -1,   -7,   14,   51,   57,   37,    8,  -13,   -7,   -2,  -14,
      -6,   20,    3,  -21,  -26,  -27,  -30,  -27,    1,   28,   36,    7,  -10,    0,    5,   -8,
     -14,  -30,  -29,   -3,  -10,   -5,   31,   56,   46,   19,   -7,  -10,    3,  -11,  -21,    9,
      19,  -10,  -30,  -29,  -19,  -24,  -20,   10,   35,   29,    8,   -1,    5,   -2,  -13,  -28,
     -33,   -3,   -1,  -13,   12,   49,   55,   31,   -1,  -12,    2,   -3,  -26,   -2,   21,    2,
     -28,  -34,  -21,  -17,  -29,  -12,   23,   34,   19,    6,    7,    4,   -4,  -23,  -40,  -10,
       7,  -12,   -2,   34,   55,   36,    8,  -10,    1,    3,  -19,  -18,   15,   15,  -10,  -33,
     -30,   -9,  -19,  -25,    4,   32,   30,   16,   11,   10,    3,  -15,  -35,  -27,    9,   -4,
     -10,   16,   52,   42,   12,   -7,   -6,    4,   -6,  -21,   -2,   17,    0,  -20,  -41,  -13,
      -9,  -31,  -16,   18,   34,   23,   14,    9,   10,   -7,  -26,  -34,   -3,   10,  -10,    2,
      42,   51,   16,   -8,  -11,   -2,   -2,  -11,   -9,    9,    2,   -8,  -36,  -31,    3,  -23,
     -30,   -1,   27,   27,   23,   15,   18,    3,  -17,  -31,  -19,    8,    1,   -4,   24,   51,
      30,  -11,  -16,   -6,   -3,   -5,  -10,    3,    1,  -10,  -22,  -41,   -4,   -6,  -29,  -18,
      12,   25,   26,   23,   20,   11,  -10,  -21,  -27,   -4,    7,    0,   13,   41,   40,    3,
     -24,  -11,   -1,   -2,   -3,    5,    5,  -14,  -15,  -35,  -20,    0,  -19,  -24,   -4,   11,
      23,   31,   24,   16,   -3,  -13,  -23,  -14,    2,    3,   18,   32,   38,   21,  -20,  -29,
      -5,   -2,    0,    5,   11,  -14,  -22,  -25,  -26,   -3,  -11,  -26,  -11,   -2,    8,   32,
      34,   24,    2,   -8,  -16,  -13,    1,    1,   10,   31,   31,   33,    1,  -36,  -22,    0,
       0,    8,   18,   -3,  -27,  -22,  -22,  -10,   -9,  -24,  -16,   -5,  -16,   16,   40,   34,
       8,   -3,  -13,  -12,    1,    1,    3,   30,   30,   24,   18,  -28,  -35,  -13,   -2,    6,
      19,   10,  -25,  -28,  -15,   -9,  -10,  -19,  -20,   -3,  -15,   -8,   27,   42,   25,    1,
     -14,  -18,    7,    9,   -1,   19,   37,   19,   23,  -10,  -41,  -26,   -9,    2,   20,   19,
     -17,  -35,  -21,    0,   -9,  -18,  -20,   -7,   -8,  -24,    6,   37,   43,   14,  -10,  -22,
       3,   18,    4,    6,   36,   23,   16,    4,  -32,  -37,  -19,   -3,   17,   27,    0,  -37,
     -34,   -3,    7,  -17,  -27,  -19,   -1,  -20,  -13,   17,   44,   35,    2,  -22,   -9,   19,
      20,    2,   26,   32,   15,    5,  -17,  -40,  -29,   -9,   10,   28,   17,  -23,  -41,  -21,
       9,   -2,  -27,  -30,   -5,   -7,  -21,   -4,   27,   47,   27,  -14,  -21,   11,   29,   14,
      15,   32,   20,    4,  -11,  -31,  -38,  -15,    2,   22,   22,   -3,  -32,  -34,   -6,    8,
     -13,  -38,  -19,    0,  -16,  -14,    6,   37,   39,   11,  -18,   -4,   25,   25,   16,   24,
      27,    7,  -10,  -24,  -38,  -25,    0,   12,   23,    8,  -16,  -31,  -23,    0,    0,  -27,
     -33,   -2,   -9,  -16,  -11,   17,   41,   32,    5,  -15,   12,   25,   24,   21,   27,   14,
      -4,  -21,  -31,  -29,   -4,    9,   19,    9,   -9,  -19,  -25,  -10,   -5,  -15,  -38,  -13,
      -6,  -13,  -17,   -1,   30,   36,   27,   -2,    2,   20,   24,   25,   24,   19,    2,  -16,
     -32,  -29,  -13,    8,   18,   16,   -6,  -13,  -21,  -15,  -14,  -13,  -26,  -22,   -6,  -11,
     -14,  -14,   11,   30,   37,   17,    1,   13,   20,   23,   24,   21,    5,  -10,  -32,  -31,
     -15,    0,   17,   22,   -3,  -15,  -17,  -11,  -15,  -19,  -23,  -22,   -8,   -8,  -13,  -18,
      -8,   18,   40,   38,   12,   12,   15,   21,   23,   24,    7,   -9,  -22,  -34,  -19,   -6,
      11,   30,    9,  -17,  -20,  -16,  -11,  -22,  -30,  -27,   -8,   -7,  -10,  -19,  -16,   -2,
      32,   52,   31,   17,   16,   13,   21,   19,   19,   -9,  -17,  -30,  -25,   -7,    3,   29,
      25,   -9,  -21,  -20,  -11,  -14,  -29,  -37,  -14,    2,   -5,  -14,  -22,  -12,   13,   50,
      49,   27,   23,   15,   13,    9,   18,    7,  -22,  -22,  -28,  -11,   -5,   19,   35,   13,
     -20,  -24,  -18,   -8,  -22,  -38,  -31,    2,    3,   -6,  -26,  -22,   -3,   38,   56,   42,
      34,   21,   12,    6,   11,   17,  -15,  -24,  -20,  -15,   -6,    9,   29,   29,   -4,  -28,
     -23,  -14,  -13,  -30,  -39,  -16,    9,    6,  -12,  -33,  -16,   19,   57,   49,   41,   30,
      13,    4,   -1,    6,   -4,  -27,  -21,  -13,   -6,    2,   12,   34,   12,  -24,  -24,  -20,
     -16,  -24,  -38,  -33,    2,   12,   -2,  -30,  -31,    2,   45,   59,   46,   41,   24,    8,
      -3,   -6,    1,  -15,  -25,  -16,   -3,    5,    2,   21,   28,  -11,  -26,  -23,  -18,  -20,
     -32,  -40,  -14,   14,   11,  -10,  -40,  -20,   30,   60,   55,   42,   34,   15,    6,  -12,
     -12,   -4,  -19,  -21,   -9,    8,    4,   10,   28,    6,  -25,  -22,  -20,  -22,  -29,  -38,
     -27,    5,   16,    4,  -24,  -39,   12,   51,   61,   51,   41,   27,   10,   -7,  -25,   -9,
     -10,  -17,  -15,    0,    9,    5,   21,   15,  -13,  -27,  -17,  -21,  -23,  -38,  -33,  -11,
      10,    6,   -4,  -38,  -17,   36,   55,   55,   45,   35,   21,    4,  -27,  -25,   -2,  -10,
     -14,  -13,    3,    5,   14,   16,    0,  -24,  -21,  -18,  -22,  -36,  -39,  -17,   -3,    5,
       3,  -15,  -28,   16,   50,   53,   52,   43,   29,   13,  -14,  -36,  -10,   -1,  -15,  -15,
      -6,    6,    5,   13,    4,  -11,  -24,  -17,  -18,  -27,  -43,  -18,  -12,   -7,    4,    3,
     -17,   -4,   38,   53,   52,   48,   41,   23,    0,  -31,  -30,    2,   -7,  -14,  -13,   -5,
       3,   11,    7,   -4,  -21,  -25,  -21,  -19,  -39,  -23,   -9,  -19,   -8,    5,   -1,  -10,
      24,   46,   48,   46,   44,   32,   10,  -18,  -37,   -7,    0,  -12,  -14,  -13,   -4,    8,
       9,    1,  -16,  -29,  -28,  -17,  -33,  -31,   -6,  -21,  -21,   -4,   12,    3,   13,   41,
      46,   44,   46,   44,   20,   -7,  -36,  -27,    6,   -3,  -18,  -21,  -12,    2,   12,    6,
      -5,  -27,  -36,  -21,  -20,  -34,  -12,   -8,  -29,  -16,   11,   15,   10,   28,   47,   46,
      41,   45,   35,    5,  -24,  -30,   -5,    3,  -14,  -26,  -16,   -7,    7,    8,   -3,  -18,
     -39,  -32,  -16,  -28,  -26,   -8,  -23,  -26,    0,   19,   16,   20,   42,   55,   45,   38,
      39,   20,  -11,  -24,  -13,   -2,   -6,  -25,  -22,   -7,   -5,   13,    0,  -11,  -36,  -41,
     -20,  -16,  -29,  -16,  -14,  -28,  -12,   13,   17,   15,   32,   50,   57,   41,   38,   30,
       2,  -14,   -9,   -3,   -3,  -19,  -33,  -10,   -7,    7,    7,  -13,  -30,  -42,  -28,  -13,
     -17,  -26,  -14,  -22,  -15,    7,   19,   15,   26,   46,   59,   51,   34,   33,   12,   -7,
     -11,   -4,   -5,  -13,  -38,  -23,   -3,    3,   15,   -7,  -32,  -45,  -34,  -21,  -11,  -27,
     -25,  -21,  -19,   -1,   13,   15,   22,   37,   53,   62,   46,   34,   15,   -2,    0,   -4,
      -8,   -9,  -34,  -38,   -8,    4,   17,    3,  -25,  -50,  -44,  -26,  -12,  -13,  -32,  -24,
     -20,   -7,   11,   18,   17,   33,   50,   65,   57,   41,   24,    0,    5,    5,   -9,  -11,
     -25,  -44,  -25,   -1,   17,   13,  -18,  -42,  -51,  -33,  -20,   -7,  -27,  -29,  -23,  -16,
       0,   14,   14,   28,   48,   60,   66,   51,   34,    4,    0,   15,   -3,  -14,  -20,  -35,
     -37,  -12,   12,   27,   -7,  -37,  -50,  -40,  -29,  -15,  -15,  -30,  -24,  -15,   -7,    6,
      17,   25,   46,   59,   68,   63,   43,   20,   -6,   14,   10,   -8,  -20,  -30,  -34,  -22,
      -2,   24,   15,  -30,  -49,  -49,  -37,  -28,  -15,  -26,  -28,  -18,  -11,   -7,    7,   27,
      42,   58,   70,   70,   53,   35,    4,    0,   18,   -1,  -15,  -32,  -31,  -26,  -12,   12,
      28,   -4,  -44,  -53,  -44,  -39,  -25,  -23,  -28,  -19,  -11,  -12,  -16,   13,   42,   56,
      71,   71,   57,   45,   23,   -3,   10,   11,   -6,  -27,  -35,  -25,  -22,   -1,   23,   17,
     -29,  -54,  -46,  -44,  -39,  -29,  -28,  -21,  -15,  -15,  -26,  -12,   39,   57,   70,   73,
      60,   49,   41,   13,    1,   11,    0,  -16,  -32,  -25,  -15,  -14,   10,   23,   -5,  -48,
     -46,  -42,  -49,  -43,  -31,  -24,  -15,  -13,  -24,  -32,   18,   59,   71,   77,   67,   57,
      47,   33,    3,    5,    5,   -9,  -23,  -33,  -16,  -14,   -5,   17,   12,  -29,  -44,  -35,
     -50,  -57,  -43,  -30,  -18,  -11,  -22,  -39,   -9,   44,   68,   82,   69,   61,   49,   42,
      18,    5,    5,   -8,  -12,  -26,  -14,   -7,   -9,    5,   16,   -6,  -36,  -32,  -42,  -62,
     -55,  -39,  -29,  -15,  -14,  -34,  -30,   20,   59,   82,   79,   66,   58,   45,   38,    9,
       1,   -7,  -11,  -16,  -19,   -3,   -6,   -6,    9,    5,  -22,  -32,  -32,  -58,  -70,  -56,
     -42,  -24,  -16,  -25,  -39,   -9,   41,   72,   86,   73,   65,   46,   40,   30,   -4,   -7,
     -14,  -12,  -20,   -3,    4,   -5,    1,    8,   -9,  -27,  -25,  -40,  -67,  -67,  -55,  -38,
     -24,  -17,  -25,  -28,   16,   61,   81,   82,   71,   60,   37,   42,   17,  -14,  -17,  -11,
     -13,   -8,   10,    2,   -2,    1,   -1,  -17,  -20,  -26,  -54,  -69,  -70,  -58,  -34,  -25,
     -16,  -23,   -9,   37,   70,   87,   80,   68,   44,   38,   39,   -5,  -27,  -19,  -12,   -6,
      13,   10,    4,    1,    1,   -5,  -19,  -20,  -37,  -59,  -71,  -71,  -54,  -35,  -17,   -9,
     -20,   11,   49,   80,   86,   72,   54,   36,   45,   23,  -25,  -34,  -16,   -9,   11,   17,
       8,    5,   -4,   -2,  -15,  -19,  -26,  -50,  -69,  -77,  -71,  -51,  -29,   -7,  -11,   -6,
      26,   64,   87,   78,   60,   40,   42,   45,    2,  -38,  -34,  -12,   10,   24,   10,   11,
       3,   -1,   -6,  -20,  -16,  -31,  -61,  -81,  -80,  -69,  -41,  -16,   -5,   -8,   10,   47,
      81,   86,   70,   44,   36,   48,   32,  -21,  -48,  -31,   -3,   24,   24,   10,   15,    0,
       2,  -17,  -21,  -18,  -45,  -81,  -87,  -80,  -57,  -33,  -11,   -6,    2,   30,   74,   86,
      77,   55,   34,   42,   48,   13,  -39,  -50,  -20,   15,   34,   14,   16,   12,    4,   -5,
     -26,  -16,  -19,  -64,  -92,  -91,  -65,  -43,  -26,  -12,   -1,   16,   47,   83,   76,   66,
      40,   33,   45,   33,   -8,  -52,  -41,   -5,   32,   30,   15,   25,   13,    8,  -22,  -28,
     -11,  -34,  -85, -101,  -86,  -52,  -36,  -25,  -13,   15,   32,   69,   80,   69,   52,   32,
      37,   39,   19,  -30,  -54,  -24,   10,   38,   25,   25,   22,   18,   -6,  -35,  -20,  -14,
     -59,  -98,  -99,  -68,  -41,  -30,  -23,    5,   28,   52,   74,   67,   59,   43,   32,   35,
      32,   -2,  -47,  -38,  -13,   23,   33,   31,   26,   27,   16,  -29,  -37,  -15,  -33,  -80,
    -104,  -89,  -54,  -35,  -31,  -11,   17,   42,   63,   68,   60,   59,   37,   27,   33,   22,
     -28,  -37,  -26,    3,   32,   38,   30,   25,   30,   -3,  -41,  -29,  -23,  -55,  -90,  -98,
     -76,  -39,  -32,  -21,    4,   36,   52,   61,   61,   63,   48,   24,   28,   34,  -10,  -31,
     -29,  -14,   15,   37,   37,   28,   31,   19,  -27,  -40,  -24,  -38,  -69,  -95,  -96,  -60,
     -32,  -26,  -10,   19,   45,   53,   58,   59,   58,   29,   23,   39,   14,  -21,  -25,  -23,
       1,   27,   43,   34,   34,   21,    0,  -36,  -32,  -31,  -49,  -84, -102,  -83,  -41,  -22,
     -19,   -1,   35,   49,   52,   53,   56,   39,   23,   34,   33,   -3,  -23,  -22,  -10,   17,
      36,   36,   39,   26,    8,  -16,  -34,  -29,  -36,  -61,  -93,  -95,  -58,  -26,  -18,  -11,
      22,   48,   53,   53,   51,   41,   31,   33,   37,   16,  -15,  -24,  -14,    4,   29,   34,
      41,   32,    8,   -7,  -19,  -28,  -30,  -54,  -83, -101,  -76,  -40,  -20,  -21,    1,   36,
      54,   55,   44,   33,   32,   35,   36,   30,    7,  -26,  -19,   -5,   22,   36,   37,   37,
      15,   -3,   -5,  -15,  -24,  -43,  -75,  -94,  -87,  -47,  -29,  -25,  -14,   26,   48,   62,
      49,   29,   23,   35,   45,   38,   19,  -16,  -28,   -7,   10,   29,   32,   38,   23,   -2,
     -10,   -6,  -12,  -28,  -67,  -90,  -98,  -59,  -32,  -28,  -25,    3,   43,   56,   59,   25,
      16,   24,   46,   43,   31,    0,  -31,  -14,    5,   25,   29,   32,   29,    6,  -13,   -6,
      -3,   -8,  -49,  -85,  -97,  -75,  -31,  -30,  -30,  -12,   31,   50,   61,   40,   12,   14,
      34,   53,   43,   20,  -23,  -20,   -3,   21,   29,   23,   24,   15,  -10,   -8,   -1,    2,
     -25,  -75,  -98,  -92,  -42,  -31,  -35,  -24,   14,   41,   50,   49,   22,   11,   20,   45,
      52,   39,    0,  -26,  -12,    9,   35,   25,   18,   14,    1,  -13,   -6,    4,    3,  -49,
     -89, -102,  -61,  -27,  -30,  -27,   -4,   34,   46,   46,   32,   17,   13,   26,   47,   50,
      29,  -19,  -22,   -4,   30,   37,   15,    7,    7,   -5,  -10,   -4,    9,  -20,  -72, -100,
     -86,  -41,  -33,  -31,  -16,   18,   43,   34,   32,   27,   23,   15,   31,   47,   48,    9,
     -24,  -16,   12,   43,   25,   -2,    0,    9,   -9,  -15,    2,    8,  -40,  -87,  -99,  -69,
     -37,  -31,  -19,    6,   38,   35,   25,   31,   35,   26,   18,   36,   49,   40,  -10,  -22,
      -9,   29,   40,    6,  -12,    6,    6,  -16,  -11,    9,   -6,  -61,  -95,  -90,  -58,  -35,
     -26,   -5,   23,   36,   18,   21,   36,   41,   28,   22,   38,   52,   23,  -17,  -17,    7,
      39,   21,  -12,  -13,   16,   -8,  -22,   -5,    6,  -25,  -77,  -93,  -79,  -46,  -30,  -11,
      15,   36,   22,    5,   29,   47,   47,   24,   22,   41,   48,    7,  -15,   -4,   22,   33,
       6,  -23,    4,    8,  -21,  -15,   -1,   -5,  -49,  -79,  -92,  -71,  -43,  -20,   11,   31,
      29,    4,   16,   40,   55,   41,   22,   31,   50,   25,   -9,   -2,    8,   23,   16,  -17,
      -6,    8,  -10,  -15,   -6,   -4,  -29,  -56,  -80,  -86,  -61,  -42,    0,   30,   33,   12,
       2,   24,   47,   55,   37,   28,   39,   40,    4,   -1,    6,    6,   16,   -4,  -13,    1,
      -2,   -9,  -11,  -11,  -21,  -35,  -55,  -82,  -80,  -64,  -24,   27,   36,   23,    3,   10,
      35,   61,   55,   40,   35,   35,   19,    6,   12,    4,    1,    3,  -12,   -3,   -2,   -4,
      -4,  -14,  -23,  -30,  -37,  -58,  -83,  -84,  -58,    8,   37,   33,   11,    3,   20,   46,
      62,   55,   50,   28,   16,   12,   15,    9,   -4,   -9,   -9,   -4,   -5,   -7,    2,   -7,
     -28,  -35,  -31,  -36,  -67,  -90,  -86,  -23,   28,   38,   25,    5,   13,   34,   58,   58,
      69,   50,   15,   10,   20,   16,   -3,  -14,  -14,   -2,    1,  -12,   -3,    3,  -20,  -36,
     -39,  -26,  -46,  -81,  -98,  -61,    6,   27,   30,   16,   12,   25,   50,   57,   66,   74,
      31,    4,   16,   21,    8,  -13,  -21,  -10,    8,   -5,  -11,    6,   -8,  -31,  -40,  -29,
     -30,  -66,  -93,  -84,  -22,   17,   22,   26,   16,   20,   43,   56,   56,   70,   60,   17,
       8,   18,   15,  -10,  -26,  -21,    6,    7,  -12,   -1,    1,  -20,  -33,  -34,  -31,  -51,
     -79,  -92,  -52,   -6,    9,   19,   23,   21,   40,   57,   59,   60,   72,   43,   17,   13,
      18,    3,  -23,  -32,   -5,   14,   -7,  -11,    7,  -12,  -26,  -31,  -37,  -46,  -66,  -85,
     -67,  -21,   -5,    3,   16,   22,   37,   54,   59,   55,   60,   58,   30,   16,   13,   11,
     -15,  -34,  -23,    9,    7,  -12,   -2,   -4,  -19,  -16,  -31,  -49,  -64,  -76,  -72,  -35,
     -12,  -14,    0,   15,   34,   53,   60,   58,   53,   57,   43,   30,   18,   12,   -4,  -27,
     -28,   -8,   14,   -3,   -9,   -2,  -13,   -9,  -17,  -49,  -66,  -70,  -69,  -44,  -15,  -19,
     -11,    2,   21,   53,   64,   68,   55,   48,   44,   36,   28,   15,   -1,  -18,  -23,  -19,
      -4,    5,   -3,    1,   -9,   -7,   -1,  -35,  -70,  -74,  -70,  -50,  -21,  -14,  -22,   -7,
      -1,   39,   66,   77,   69,   46,   38,   36,   38,   22,    5,  -12,  -16,  -12,  -17,   -8,
      -5,    2,    1,   -6,    5,  -13,  -64,  -78,  -73,  -60,  -31,  -14,  -17,  -16,  -10,    7,
      61,   79,   81,   57,   38,   28,   32,   24,    9,   -4,  -10,   -4,  -11,  -20,  -13,   -2,
      11,    4,    4,   -2,  -41,  -76,  -76,  -69,  -43,  -22,  -12,  -17,  -14,  -14,   25,   74,
      92,   79,   47,   31,   26,   26,   11,    3,   -5,    0,    0,  -20,  -26,  -11,    9,   14,
       9,    4,  -24,  -61,  -76,  -74,  -53,  -30,  -13,   -8,  -12,  -25,   -8,   51,   90,   93,
      63,   42,   21,   18,   13,    6,    2,    1,    8,  -12,  -30,  -27,   -2,   14,   18,   11,
     -13,  -48,  -68,  -79,  -70,  -44,  -19,   -2,   -5,  -21,  -31,   18,   77,  100,   81,   55,
      29,    7,    8,    6,    7,    4,   14,    0,  -26,  -34,  -13,    9,   16,   17,    1,  -35,
     -58,  -70,  -82,  -62,  -29,   -2,    1,  -14,  -36,  -15,   50,   89,   95,   71,   46,    5,
      -6,    4,   11,    3,   11,   14,  -12,  -31,  -22,   -2,    8,   16,   16,  -15,  -53,  -56,
     -80,  -81,  -41,   -5,    9,   -3,  -30,  -34,   17,   73,   97,   86,   63,   25,  -12,   -6,
      11,   13,    1,   15,    4,  -19,  -25,   -5,    2,    9,   19,   10,  -39,  -48,  -61,  -95,
     -67,  -17,   12,    8,  -23,  -43,   -9,   49,   85,   91,   76,   50,    1,  -23,    2,   22,
       5,    2,   14,   -5,  -23,  -12,    0,   -2,   13,   17,  -15,  -48,  -43,  -83,  -88,  -38,
       5,   17,  -11,  -41,  -28,   27,   67,   83,   82,   65,   29,  -21,  -18,   21,   19,   -7,
       3,    6,   -8,  -14,    1,    0,    0,   13,    2,  -34,  -42,  -59,  -99,  -63,  -12,   17,
       0,  -35,  -42,    1,   53,   69,   79,   72,   53,   -1,  -34,    2,   32,    3,   -8,    1,
       2,   -2,   -3,    8,   -2,    3,    7,  -18,  -40,  -39,  -76,  -81,  -35,    9,   17,  -22,
     -46,  -24,   34,   59,   68,   74,   66,   27,  -26,  -22,   31,   24,  -10,  -11,    0,   14,
       1,    5,    8,   -5,   -2,  -10,  -34,  -35,  -48,  -77,  -59,  -13,   20,   -4,  -37,  -35,
       8,   47,   55,   68,   74,   49,   -4,  -34,   10,   39,    1,  -13,  -11,   14,   14,    3,
      20,    6,   -9,  -14,  -29,  -37,  -28,  -56,  -66,  -42,    9,    9,  -25,  -38,  -14,   27,
      45,   54,   72,   61,   21,  -25,  -14,   31,   19,  -10,  -15,   -2,   22,    6,   22,   24,
      -4,  -20,  -28,  -38,  -24,  -28,  -54,  -57,  -20,   14,  -10,  -29,  -26,    2,   29,   39,
      61,   66,   39,   -6,  -25,   16,   30,    0,  -16,   -8,   12,   13,   18,   38,   10,  -20,
     -36,  -34,  -31,  -16,  -33,  -56,  -42,    0,    0,  -21,  -22,  -12,   11,   25,   49,   68,
      53,   14,  -20,   -3,   29,   15,  -11,  -12,    3,   13,   13,   42,   34,  -12,  -39,  -37,
     -27,  -22,  -18,  -44,  -50,  -21,    3,  -12,  -15,  -18,   -5,    9,   27,   60,   60,   32,
      -6,  -12,   21,   25,   -4,  -12,   -2,    7,    8,   33,   53,    8,  -37,  -41,  -25,  -22,
     -16,  -27,  -47,  -34,  -10,  -10,  -15,  -15,  -15,   -5,    5,   41,   63,   44,   12,  -11,
      10,   32,   10,  -14,   -8,    8,    5,   19,   53,   34,  -24,  -43,  -25,  -14,  -15,  -19,
     -35,  -35,  -20,  -12,   -8,  -14,  -17,  -19,  -13,   19,   55,   53,   22,   -8,    4,   31,
      26,   -8,  -13,    6,   10,    7,   39,   50,   -2,  -41,  -31,  -10,  -13,  -23,  -31,  -33,
     -24,  -15,   -7,  -13,  -16,  -22,  -23,   -6,   38,   55,   34,    1,   -1,   23,   34,    9,
     -18,   -3,   14,    9,   20,   51,   24,  -28,  -37,   -6,    2,  -20,  -30,  -27,  -21,  -22,
      -6,  -12,  -17,  -21,  -32,  -27,    9,   49,   43,   12,   -4,   14,   34,   24,   -9,  -12,
      12,   19,   13,   30,   37,   -3,  -35,  -15,   12,  -10,  -31,  -30,  -15,  -18,  -13,   -3,
     -19,  -20,  -31,  -35,  -17,   28,   44,   22,    0,    7,   28,   27,    5,  -15,    1,   20,
      20,   17,   28,   19,  -21,  -23,   12,    8,  -22,  -32,  -20,   -8,  -15,    0,  -13,  -23,
     -25,  -43,  -36,    4,   37,   30,   11,    4,   22,   28,   15,    0,  -10,    9,   23,   14,
      11,   24,    5,  -21,    2,   17,   -8,  -27,  -27,   -7,  -10,   -6,   -1,  -20,  -26,  -39,
     -53,  -20,   23,   36,   17,    7,   14,   28,   16,   12,   -3,    2,   19,   16,    2,   14,
      19,   -8,   -5,   17,    4,  -15,  -26,  -10,   -4,  -12,    1,   -8,  -23,  -38,  -58,  -41,
       0,   29,   23,   11,   16,   21,   15,    9,   11,   -6,   11,   20,    4,    3,   24,    5,
      -5,   10,   17,   -6,  -15,  -15,    6,  -15,   -8,    0,  -11,  -37,  -54,  -56,  -24,   13,
      29,   12,   15,   20,   19,    6,   16,    5,   -2,   10,   11,   -3,   22,   18,    0,    6,
      20,   10,   -6,  -12,    1,   -6,  -23,    0,    1,  -23,  -56,  -60,  -43,  -10,   19,   22,
      15,   22,   18,    6,   11,   17,   -2,   -5,   10,    4,    7,   23,    1,    3,   16,   22,
       5,   -1,    0,    5,  -21,  -14,    6,   -6,  -46,  -64,  -54,  -29,    1,   17,   18,   24,
      25,   10,    1,   17,    9,   -8,   -1,   15,    6,   20,   11,    2,   14,   25,   16,    9,
       5,    7,  -11,  -26,   -5,    4,  -27,  -62,  -62,  -40,  -17,    8,   11,   21,   29,   17,
      -2,   10,   17,   -8,  -16,    6,   13,   11,   15,    3,    8,   24,   26,   14,   12,   12,
       4,  -26,  -15,    1,  -12,  -50,  -64,  -48,  -27,  -10,    5,    8,   32,   31,    1,   -1,
      18,    0,  -23,   -6,   18,   14,   11,    5,    3,   17,   35,   25,   16,   18,   14,  -11,
     -27,   -8,   -6,  -30,  -55,  -53,  -36,  -20,   -5,    5,   14,   43,   13,   -6,   11,   11,
     -22,  -22,    7,   19,   13,   10,    1,    7,   30,   36,   22,   23,   23,    6,  -28,  -20,
      -6,  -23,  -43,  -49,  -43,  -29,  -19,    3,    1,   34,   29,   -4,    3,   13,  -13,  -32,
      -3,   20,   14,   11,    5,    2,   23,   42,   34,   22,   23,   21,  -13,  -26,  -14,  -19,
     -32,  -38,  -43,  -32,  -29,   -6,    4,   16,   35,    9,   -4,   11,    0,  -33,  -22,    9,
      13,   12,    9,    3,   14,   35,   47,   34,   23,   27,    8,  -22,  -19,  -16,  -30,  -29,
     -42,  -33,  -32,  -23,    4,    9,   24,   20,   -1,    3,   10,  -20,  -36,   -5,   13,    9,
      11,    8,    8,   21,   43,   48,   27,   22,   23,   -7,  -25,  -20,  -28,  -25,  -31,  -36,
     -28,  -33,   -8,   11,   14,   14,    6,   -8,    7,   -5,  -39,  -25,    7,   14,    9,   10,
      12,   15,   29,   55,   41,   23,   22,    9,  -12,  -23,  -28,  -24,  -23,  -34,  -26,  -31,
     -21,    9,   19,    9,    1,   -3,   -1,    7,  -32,  -38,   -9,   13,   11,    9,   11,   14,
      21,   46,   53,   32,   24,   12,   -2,  -16,  -26,  -24,  -17,  -34,  -33,  -25,  -24,   -4,
      17,   14,   -3,   -4,   -7,    3,  -13,  -46,  -25,    2,   17,    5,    8,   12,   18,   32,
      56,   38,   29,   15,    8,   -4,  -22,  -30,  -14,  -22,  -42,  -25,  -15,  -10,    6,   17,
       1,   -5,   -7,  -10,   -2,  -38,  -37,   -7,   15,    9,    2,    8,   21,   26,   43,   44,
      29,   18,    7,   12,   -9,  -25,  -24,  -11,  -35,  -43,  -17,   -5,    3,   10,    9,   -3,
      -3,  -23,   -9,  -23,  -45,  -22,    7,   15,    2,    4,   17,   33,   31,   45,   35,   23,
       8,   17,    6,  -16,  -26,  -14,  -20,  -48,  -27,   -2,    6,   11,    9,   -1,    6,  -15,
     -28,  -18,  -39,  -32,   -7,   11,    7,    6,    7,   33,   30,   31,   41,   27,    7,   13,
      24,   -3,  -18,  -22,   -9,  -40,  -41,  -10,    4,    9,   17,    3,    5,   -4,  -37,  -29,
     -29,  -35,  -19,    1,   10,    3,    7,   25,   41,   19,   31,   32,   13,    5,   27,   14,
      -6,  -19,  -12,  -23,  -48,  -22,    7,    8,   16,   11,    1,    6,  -29,  -46,  -32,  -32,
     -20,   -5,    7,    4,    3,   21,   43,   32,   15,   29,   16,    8,   19,   26,    3,   -9,
     -22,  -13,  -42,  -37,   -8,   11,   14,   25,    9,    4,  -17,  -50,  -44,  -30,  -25,  -14,
      -1,   11,    1,   18,   36,   41,   12,   14,   18,   14,   15,   20,   17,    6,  -14,  -18,
     -27,  -39,  -19,    5,   12,   24,   27,    8,  -13,  -49,  -53,  -32,  -27,  -19,  -12,    7,
       7,   12,   31,   43,   26,    2,    8,   14,   22,   13,   17,   18,    6,  -17,  -26,  -36,
     -28,   -6,   14,   25,   35,   20,   -6,  -42,  -57,  -37,  -23,  -23,  -20,    0,    9,    8,
      25,   41,   40,    7,   -4,    1,   23,   21,   14,   22,   20,   -2,  -24,  -34,  -31,  -13,
       8,   24,   37,   33,    8,  -32,  -62,  -44,  -20,  -22,  -27,   -9,    9,    7,   16,   31,
      42,   20,  -10,  -13,   10,   26,    7,   13,   25,   18,  -11,  -35,  -39,  -20,    0,   17,
      37,   37,   19,  -17,  -58,  -55,  -26,  -18,  -25,  -21,    0,   14,   12,   20,   38,   35,
       0,  -19,   -9,   24,   19,    3,   21,   31,   17,  -24,  -42,  -30,   -3,   13,   34,   42,
      28,   -2,  -45,  -62,  -38,  -22,  -19,  -20,  -12,   12,   17,   11,   29,   42,   18,  -16,
     -20,    3,   24,    2,    4,   26,   36,    0,  -38,  -45,  -13,   12,   27,   41,   34,   14,
     -27,  -62,  -55,  -30,  -19,  -15,  -16,   -2,   18,   11,   14,   37,   31,   -6,  -22,  -12,
      15,   10,  -10,   12,   36,   30,  -19,  -46,  -33,   11,   24,   28,   35,   28,   -5,  -44,
     -65,  -44,  -23,  -11,   -9,   -8,    5,   14,   10,   25,   37,   14,  -17,  -18,   -2,   14,
      -7,   -6,   23,   43,   10,  -33,  -38,   -9,   24,   24,   28,   30,   11,  -21,  -57,  -61,
     -39,  -12,   -5,   -5,   -3,    7,   10,   17,   31,   30,   -3,  -20,  -14,    6,    1,  -16,
       2,   38,   38,   -5,  -30,  -24,   13,   25,   21,   28,   15,    1,  -34,  -64,  -62,  -23,
       0,    2,   -1,   -1,    5,   14,   24,   33,   14,  -12,  -23,   -4,    7,  -18,  -18,   18,
      43,   25,   -9,  -22,   -2,   21,   19,   24,   20,   11,  -13,  -47,  -69,  -46,   -7,    5,
       6,   -1,   -4,    9,   21,   31,   25,    5,  -15,  -20,    3,   -8,  -33,   -7,   29,   37,
      20,  -10,  -10,    9,   15,   17,   14,   12,    1,  -23,  -55,  -70,  -30,    5,   13,    2,
      -8,   -1,   15,   25,   30,   15,   -1,  -20,   -8,   -3,  -31,  -28,    8,   31,   41,   15,
      -6,    0,    9,   14,   12,    9,    8,  -10,  -28,  -63,  -55,  -12,   17,   11,   -7,  -13,
       8,   22,   26,   19,    9,   -7,  -13,   -5,  -23,  -39,  -10,   17,   41,   38,    8,    0,
       5,    7,   12,    5,    7,   -6,   -8,  -39,  -60,  -35,    7,   19,    6,  -10,   -6,   15,
      26,   22,   15,    9,   -8,  -13,  -24,  -45,  -29,   -1,   29,   48,   30,    2,    6,    5,
       9,    5,   -1,   -5,   -4,  -13,  -51,  -51,  -16,   20,   13,    0,  -11,    7,   25,   22,
      18,   17,   10,   -8,  -22,  -50,  -43,  -13,   15,   46,   42,   16,    7,    8,    7,    7,
      -1,   -6,  -10,   -4,  -27,  -45,  -36,    5,   16,    7,   -5,   -5,   20,   22,   19,   19,
      22,    7,  -15,  -43,  -62,  -29,    3,   35,   43,   27,   11,    9,    8,    4,    2,   -9,
     -13,   -7,  -15,  -30,  -43,  -16,   12,   13,    4,   -8,   12,   24,   17,   16,   24,   25,
      -3,  -38,  -72,  -52,   -9,   25,   42,   30,   21,    8,   14,    4,    6,   -3,  -13,  -12,
     -13,  -18,  -36,  -34,    3,   14,    9,   -9,    5,   26,   18,   13,   26,   34,   13,  -31,
     -69,  -68,  -16,   19,   35,   29,   22,    6,   16,    3,    2,    6,   -5,  -15,  -20,  -19,
     -21,  -34,  -17,    8,   16,   -2,   -3,   24,   27,   16,   23,   34,   32,  -10,  -56,  -80,
     -45,    6,   29,   29,   22,   10,   14,   13,   -4,    6,    7,   -8,  -27,  -27,  -18,  -20,
     -28,   -8,   14,    8,   -7,   11,   29,   21,   17,   25,   35,   16,  -36,  -77,  -67,  -14,
      25,   30,   22,   11,   10,   19,    5,    2,    6,    5,  -18,  -34,  -25,  -13,  -23,  -19,
       4,   13,    0,    7,   24,   32,   24,   22,   31,   30,  -12,  -62,  -76,  -41,    9,   28,
      24,   15,    6,   18,   16,    6,    6,    7,   -7,  -32,  -37,  -16,  -18,  -24,   -8,   11,
       7,    7,   20,   31,   35,   25,   24,   33,    9,  -40,  -72,  -58,  -16,   17,   27,   16,
       6,   10,   22,   12,    8,    8,    2,  -23,  -43,  -26,  -16,  -24,  -18,    2,    6,    7,
      21,   29,   36,   32,   21,   27,   22,  -21,  -57,  -67,  -38,   -4,   26,   21,    9,    3,
      18,   25,   18,   10,    2,  -11,  -42,  -36,  -24,  -27,  -23,   -9,    5,    2,   17,   32,
      42,   36,   27,   18,   25,   -2,  -39,  -58,  -51,  -27,   11,   27,   11,    1,    9,   24,
      25,   21,    5,   -8,  -31,  -37,  -30,  -33,  -24,  -15,    0,   -2,   13,   31,   48,   47,
      33,   15,   18,   10,  -27,  -50,  -52,  -44,  -12,   21,   21,    5,   -1,   13,   33,   30,
      16,   -6,  -26,  -39,  -33,  -35,  -28,  -20,  -10,   -8,    4,   27,   51,   61,   45,   21,
      13,   14,  -11,  -39,  -40,  -44,  -36,    1,   25,   16,    1,    2,   27,   40,   28,    3,
     -22,  -38,  -38,  -32,  -33,  -21,  -18,  -14,   -8,   18,   50,   66,   60,   27,    7,   12,
      -3,  -31,  -36,  -37,  -46,  -27,   18,   26,    5,   -3,    8,   35,   43,   16,  -14,  -36,
     -43,  -32,  -32,  -25,  -16,  -23,  -14,    6,   46,   64,   74,   49,    9,    4,    7,  -23,
     -37,  -34,  -41,  -44,   -8,   31,   19,   -5,    0,   21,   47,   33,   -2,  -33,  -43,  -43,
     -32,  -29,  -14,  -22,  -23,   -6,   34,   62,   75,   71,   30,    0,    8,  -13,  -37,  -34,
     -35,  -45,  -34,   18,   31,    5,   -5,    7,   35,   44,   12,  -23,  -45,  -49,  -40,  -29,
     -18,  -18,  -27,  -15,   22,   57,   74,   80,   57,   15,    4,   -1,  -39,  -34,  -34,  -40,
     -46,   -4,   25,   13,   -3,    2,   22,   44,   25,  -10,  -38,  -44,  -50,  -34,  -20,  -14,
     -31,  -21,    5,   47,   63,   81,   76,   38,    8,    9,  -30,  -45,  -35,  -36,  -43,  -20,
       9,   14,    5,    3,    7,   36,   32,    3,  -32,  -43,  -50,  -40,  -28,  -13,  -24,  -28,
      -2,   35,   56,   73,   86,   58,   23,   21,  -10,  -49,  -45,  -33,  -39,  -25,   -3,    5,
       5,    8,    5,   18,   32,   17,  -19,  -45,  -49,  -41,  -35,  -22,  -19,  -31,  -12,   28,
      52,   59,   76,   74,   41,   31,   10,  -39,  -58,  -41,  -32,  -27,   -5,   -3,    3,    8,
       8,   10,   24,   22,   -4,  -39,  -52,  -42,  -35,  -30,  -18,  -28,  -22,   20,   53,   52,
      60,   73,   62,   43,   31,  -18,  -56,  -61,  -35,  -28,   -9,   -6,   -3,    3,    9,   10,
      12,   18,    8,  -23,  -53,  -50,  -31,  -35,  -24,  -28,  -26,    3,   48,   55,   52,   59,
      66,   57,   46,    7,  -37,  -67,  -53,  -24,  -11,   -4,   -6,    0,    3,   13,   10,    7,
      10,   -6,  -38,  -58,  -36,  -30,  -30,  -26,  -26,  -11,   33,   60,   56,   49,   59,   67,
      58,   32,  -15,  -58,  -69,  -34,  -14,   -8,   -6,    1,   -4,    7,    8,    2,    4,    4,
     -21,  -54,  -49,  -30,  -30,  -28,  -29,  -18,   13,   53,   60,   50,   44,   63,   61,   49,
      11,  -33,  -71,  -49,  -19,   -9,  -10,    5,    2,   -1,    4,   -1,    4,    5,   -5,  -38,
     -55,  -40,  -28,  -21,  -25,  -26,   -2,   40,   61,   56,   39,   53,   66,   54,   33,   -4,
     -55,  -63,  -29,  -18,  -12,    3,   11,   -4,   -4,   -9,   -3,    4,    4,  -18,  -49,  -49,
     -35,  -18,  -18,  -25,  -16,   24,   51,   60,   42,   43,   66,   57,   42,   21,  -23,  -63,
     -44,  -26,  -18,  -10,   13,    9,   -8,  -18,  -17,    5,    5,   -4,  -35,  -47,  -42,  -24,
     -11,  -20,  -21,    5,   36,   56,   53,   37,   60,   59,   40,   34,   11,  -34,  -52,  -33,
     -21,  -15,    1,   21,    2,  -19,  -33,  -10,    8,    3,  -20,  -42,  -41,  -33,  -14,  -16,
     -18,   -7,   21,   43,   54,   39,   47,   61,   44,   31,   27,   -4,  -41,  -47,  -28,  -23,
      -9,   11,   15,   -9,  -34,  -34,    1,   10,   -2,  -30,  -38,  -34,  -18,  -15,  -17,  -10,
      10,   27,   43,   42,   42,   53,   54,   36,   24,   14,  -15,  -42,  -36,  -32,  -22,    1,
      13,    7,  -26,  -48,  -24,   11,   10,  -14,  -35,  -32,  -19,  -16,  -15,  -11,    5,   18,
      31,   34,   41,   48,   51,   46,   28,   26,    8,  -26,  -36,  -33,  -35,  -12,    7,   12,
      -8,  -45,  -47,   -9,   13,    5,  -24,  -32,  -17,  -14,  -16,  -11,    6,   14,   20,   26,
      27,   47,   49,   49,   34,   25,   22,   -6,  -31,  -27,  -39,  -30,  -10,   13,    6,  -28,
     -57,  -31,   -3,   12,   -7,  -28,  -19,   -8,  -21,  -18,   -2,   18,   17,   17,   19,   34,
      47,   53,   42,   34,   30,   13,  -22,  -20,  -30,  -44,  -32,   -4,   15,   -7,  -45,  -49,
     -18,    4,   10,  -14,  -18,    0,  -11,  -26,   -7,   15,   23,   10,   10,   20,   34,   51,
      49,   38,   41,   30,   -8,  -28,  -15,  -39,  -47,  -28,    5,   10,  -26,  -55,  -34,   -9,
      10,    3,  -13,   -4,    1,  -21,  -19,    3,   25,   13,    5,    9,   18,   36,   54,   39,
      40,   46,   16,  -27,  -17,  -23,  -47,  -47,  -18,    9,   -2,  -47,  -51,  -23,    0,    4,
       0,    1,    9,  -11,  -20,   -9,   20,   23,    4,    2,    8,   20,   45,   46,   38,   53,
      41,  -13,  -30,  -19,  -36,  -52,  -40,   -9,    5,  -23,  -53,  -35,   -6,    4,    3,    6,
      10,    5,  -16,  -17,    6,   30,   12,    0,   -4,    9,   32,   47,   43,   55,   57,   16,
     -27,  -30,  -28,  -44,  -52,  -31,   -6,   -8,  -43,  -43,  -15,   -1,   -1,    8,   10,   13,
       2,  -18,  -11,   21,   23,    6,   -5,    0,   19,   33,   41,   56,   67,   44,   -5,  -34,
     -35,  -32,  -46,  -47,  -27,   -7,  -30,  -44,  -23,   -2,   -2,    3,    7,   14,   18,   -1,
     -19,    4,   20,   16,   -5,   -9,   10,   27,   30,   46,   65,   63,   26,  -22,  -42,  -34,
     -41,  -46,  -40,  -18,  -25,  -39,  -28,   -4,    1,   -1,    5,   10,   24,   19,   -8,   -6,
      11,   20,    4,  -13,    2,   22,   24,   36,   59,   70,   51,    5,  -39,  -39,  -43,  -47,
     -45,  -31,  -30,  -39,  -33,   -7,    1,   -2,    1,    4,   19,   25,    5,   -5,    1,   12,
      13,  -12,  -12,   18,   25,   21,   46,   68,   69,   36,  -17,  -39,  -44,  -51,  -43,  -33,
     -35,  -41,  -38,  -15,    8,    0,    0,    0,   13,   26,   19,    5,    0,   -1,   10,   -2,
     -14,    5,   25,   19,   29,   54,   71,   59,    9,  -31,  -43,  -56,  -50,  -32,  -38,  -47,
     -42,  -26,    8,   10,   -3,   -3,    7,   20,   23,   16,    8,   -5,    3,    2,  -17,   -6,
      22,   20,   18,   40,   66,   71,   37,  -13,  -36,  -52,  -61,  -38,  -32,  -47,  -51,  -38,
      -7,   19,    6,   -6,    4,   14,   19,   21,   19,    2,   -5,    0,  -13,  -12,   14,   21,
      13,   27,   53,   71,   57,   12,  -25,  -42,  -61,  -54,  -33,  -38,  -52,  -50,  -22,   13,
      17,   -4,    1,   16,   17,   19,   25,   11,   -2,   -2,  -11,  -18,    6,   21,   15,   18,
      43,   66,   67,   34,   -7,  -30,  -49,  -58,  -42,  -36,  -42,  -54,  -36,   -2,   20,    4,
      -4,   11,   16,   17,   26,   17,    4,    1,   -8,  -22,   -8,   17,   16,   17,   27,   55,
      66,   48,   10,  -25,  -36,  -49,  -52,  -42,  -39,  -47,  -46,  -18,   13,   14,   -1,    3,
      13,   19,   27,   18,    2,    5,    1,  -14,  -17,    6,   13,   16,   26,   44,   64,   54,
      27,  -15,  -30,  -33,  -49,  -50,  -43,  -44,  -45,  -30,   -1,   13,    3,    6,   10,   22,
      30,   21,    3,    2,    2,   -3,  -18,   -9,    8,   11,   23,   35,   55,   58,   37,    1,
     -25,  -18,  -33,  -51,  -48,  -46,  -41,  -30,  -17,    6,    3,    7,    9,   16,   30,   27,
       9,    3,    3,    1,  -10,  -18,    0,    3,   12,   37,   46,   52,   40,   15,  -23,  -16,
     -14,  -39,  -48,  -48,  -45,  -31,  -20,   -7,    1,    4,   14,   13,   21,   26,   16,    2,
       1,    1,    1,  -16,  -12,    1,    5,   29,   50,   47,   39,   21,  -11,  -21,   -3,  -23,
     -41,  -45,  -47,  -37,  -21,  -13,   -6,    1,   16,   20,   22,   22,   18,   10,    2,    1,
       6,   -7,  -16,  -10,    0,   16,   51,   53,   38,   22,   -1,  -21,   -1,   -4,  -30,  -41,
     -45,  -45,  -28,  -13,  -13,   -8,   13,   24,   26,   15,   13,   15,    8,   -4,    1,   -2,
     -11,  -15,  -11,    2,   40,   56,   44,   21,    1,  -16,  -10,    5,  -16,  -32,  -38,  -41,
     -36,  -22,  -14,  -15,    4,   24,   32,   18,    7,   14,   14,    4,   -2,   -1,   -8,  -12,
     -15,   -6,   24,   50,   51,   28,    1,  -13,  -14,    4,    1,  -18,  -31,  -35,  -36,  -33,
     -21,  -21,   -5,   19,   38,   23,    3,    5,   17,   15,    2,   -3,   -7,   -8,  -18,  -14,
      12,   39,   50,   35,    2,  -14,  -14,   -3,    6,   -6,  -24,  -27,  -32,  -40,  -25,  -22,
     -12,    8,   35,   34,   10,    2,    5,   19,    9,   -6,   -4,   -3,  -15,  -18,    4,   30,
      42,   40,   13,  -17,  -16,   -7,    3,    5,  -14,  -21,  -24,  -41,  -37,  -23,  -18,   -1,
      22,   37,   17,    4,   -1,   11,   17,    1,   -7,   -4,  -12,  -22,   -6,   24,   35,   33,
      25,   -7,  -26,  -15,    2,   14,    3,  -16,  -19,  -33,  -42,  -27,  -23,  -10,   15,   28,
      27,    8,    2,    5,   20,   11,   -4,   -6,   -7,  -19,  -11,   17,   31,   26,   25,    6,
     -24,  -25,   -6,   11,   14,   -3,  -13,  -25,  -39,  -33,  -23,  -17,    7,   19,   26,   19,
       4,    1,   15,   14,   -1,   -5,  -10,  -14,  -22,    8,   33,   28,   20,   16,  -13,  -26,
     -17,    9,   22,    5,   -8,  -18,  -37,  -35,  -28,  -23,   -4,   12,   16,   28,   12,    1,
      12,   18,    3,   -2,   -9,  -10,  -27,  -10,   29,   34,   18,   16,    2,  -26,  -29,   -3,
      27,   19,   -4,  -10,  -29,  -36,  -30,  -29,  -12,    9,    3,   18,   21,    7,   12,   17,
       3,   -2,   -7,   -7,  -19,  -26,   15,   36,   21,   12,    9,  -15,  -30,  -18,   19,   30,
       6,   -5,  -21,  -32,  -25,  -29,  -22,    6,    0,    3,   20,   14,   12,   18,   12,    0,
      -9,  -12,   -9,  -26,   -4,   31,   28,   11,   10,   -6,  -24,  -29,    3,   35,   19,   -3,
     -15,  -26,  -19,  -23,  -31,   -6,    4,   -7,   13,   19,   17,   20,   18,    9,   -9,  -19,
      -5,  -17,  -20,   16,   34,   18,    9,    0,  -16,  -25,  -10,   30,   29,    3,  -10,  -19,
     -19,  -16,  -29,  -19,    3,   -9,   -5,   13,   21,   24,   16,   13,    1,  -23,  -14,  -12,
     -19,   -2,   28,   21,    8,    1,  -11,  -23,  -19,   16,   41,   14,   -8,  -13,   -9,  -13,
     -18,  -27,   -4,   -5,  -12,   -1,   19,   31,   18,   10,   16,  -20,  -22,  -13,  -14,  -12,
      18,   26,   12,    4,   -4,  -17,  -18,   -1,   38,   31,   -5,  -14,   -7,   -7,  -14,  -24,
     -13,   -3,  -13,  -12,    7,   30,   34,   14,   18,   -5,  -33,  -18,  -10,  -14,    1,   19,
      14,    6,   -8,  -13,  -15,   -2,   19,   40,    8,  -13,   -9,   -4,   -8,  -18,  -20,   -9,
     -14,  -16,   -7,   22,   37,   23,   16,   10,  -26,  -28,  -13,   -9,   -5,   14,   14,    9,
      -9,  -17,  -13,   -1,    8,   31,   26,   -6,  -10,   -4,   -2,  -12,  -19,  -11,  -11,  -17,
     -12,    6,   34,   29,   15,   16,   -7,  -35,  -25,   -9,   -6,    8,   14,   12,    1,  -15,
     -14,    3,   10,   19,   29,    8,  -10,   -9,    1,   -7,  -20,  -10,   -9,  -17,  -17,   -1,
      30,   35,   18,   15,    5,  -28,  -33,  -17,   -6,   -4,    8,   13,    5,  -14,  -19,    1,
      14,   14,   20,   17,    0,   -8,   -2,   -3,  -14,  -18,   -9,  -12,  -18,   -6,   21,   37,
      26,    7,   10,  -13,  -33,  -24,   -6,   -2,    0,    9,   11,   -5,  -19,   -7,   16,   18,
      13,   18,   11,   -2,   -6,   -3,   -6,  -22,  -10,  -11,  -16,  -11,   17,   34,   32,    9,
       9,    2,  -26,  -30,  -14,   -2,   -5,    3,    8,    3,  -16,  -12,    8,   21,   13,   13,
      15,    2,   -3,   -5,   -5,  -20,  -16,   -8,  -16,  -20,    6,   32,   34,   14,   -4,    6,
     -12,  -26,  -20,   -7,   -6,   -4,    4,    7,   -2,  -15,    1,   17,   15,    9,   15,   10,
       0,   -3,   -7,  -15,  -22,   -4,   -7,  -19,   -7,   29,   36,   20,   -6,   -1,    0,  -17,
     -19,  -12,   -9,   -7,   -1,    2,    6,   -3,   -8,   10,   18,    9,    8,   21,    4,   -2,
      -8,  -13,  -20,  -12,   -2,  -16,  -14,   14,   39,   26,   -3,  -17,    1,   -6,  -16,  -12,
      -7,   -9,   -9,    0,    3,   11,   -3,    0,   15,   13,    3,   19,   12,   -8,   -6,  -14,
     -19,  -16,    0,   -6,  -17,    3,   33,   35,    5,  -18,   -9,    1,  -15,  -11,   -8,   -8,
     -16,   -8,    1,   15,   15,    3,   11,   19,    2,   12,   26,    0,  -10,  -13,  -21,  -11,
       1,   -1,  -18,   -2,   23,   35,   17,  -12,  -21,   -2,   -8,   -9,   -8,   -9,  -12,  -17,
      -5,   10,   22,    8,    7,   18,    7,   -1,   23,   13,  -13,  -19,  -23,  -14,    5,    2,
     -15,  -13,   17,   30,   22,   -3,  -24,   -7,   -2,   -9,   -6,  -10,   -8,  -21,  -19,    5,
      22,   22,   13,   15,   13,   -3,   11,   18,   -4,  -20,  -28,  -20,    4,   11,  -10,  -18,
       6,   26,   17,    3,  -20,  -12,   -2,  -11,   -7,   -8,   -8,  -16,  -27,   -7,   19,   30,
      21,   19,   15,    4,    3,   18,    2,  -17,  -33,  -24,    0,   17,    1,  -16,   -6,   24,
      19,    5,  -17,  -18,    1,   -8,  -12,   -7,  -11,  -10,  -22,  -14,   10,   29,   29,   32,
      23,   13,    0,    9,    6,  -12,  -28,  -36,   -7,   13,   12,   -8,  -17,   12,   24,    6,
     -10,  -20,    1,    1,  -13,   -9,  -12,  -16,  -20,  -17,    0,   21,   27,   31,   35,   20,
       7,    0,    2,  -13,  -19,  -37,  -19,    8,   18,    9,  -16,   -9,   20,   11,   -2,  -25,
     -13,    8,   -4,  -16,  -13,  -18,  -23,  -17,    0,   14,   29,   27,   43,   35,   17,   -1,
      -4,  -13,  -22,  -29,  -31,   -2,   17,   20,   -5,  -21,    6,   16,    5,  -16,  -25,    4,
      11,  -12,  -17,  -20,  -27,  -19,   -2,   13,   26,   27,   36,   46,   32,    7,   -8,  -18,
     -26,  -25,  -32,  -16,   12,   26,   11,  -18,  -11,    4,   13,   -1,  -27,  -12,   14,    2,
     -21,  -23,  -31,  -26,  -11,   10,   24,   30,   29,   43,   50,   24,   -4,  -16,  -34,  -28,
     -28,  -27,   -1,   27,   24,   -5,  -21,  -12,    6,   16,  -13,  -28,    1,   13,   -9,  -23,
     -33,  -32,  -18,    2,   24,   34,   33,   34,   50,   49,   12,  -11,  -34,  -37,  -28,  -25,
     -14,   14,   28,   10,  -10,  -25,   -9,   21,   15,  -27,  -15,   12,    2,  -18,  -33,  -36,
     -24,   -7,   13,   30,   39,   42,   35,   54,   36,    1,  -29,  -45,  -35,  -26,  -17,   -1,
      20,   19,    2,  -23,  -30,    1,   30,   -5,  -32,    1,    7,   -8,  -27,  -37,  -25,  -12,
      -1,   23,   37,   51,   38,   41,   49,   16,  -15,  -41,  -40,  -31,  -21,  -11,    4,   19,
      15,   -8,  -33,  -19,   22,   20,  -21,  -13,    2,   -6,  -17,  -36,  -32,  -11,   -8,    9,
      28,   48,   54,   36,   48,   30,    3,  -30,  -41,  -34,  -24,  -15,   -6,    2,   17,    8,
     -19,  -37,    0,   31,    3,  -20,   -6,   -4,   -7,  -31,  -35,   -9,   -3,   -4,   16,   37,
      62,   44,   41,   33,   13,  -11,  -36,  -39,  -29,  -21,  -11,  -11,    6,   14,   -2,  -28,
     -24,   15,   22,   -5,  -10,  -11,  -10,  -20,  -35,  -13,    2,   -5,    2,   21,   55,   64,
      46,   37,   19,    2,  -23,  -36,  -28,  -23,  -17,  -18,  -17,   10,   11,  -12,  -32,   -7,
      23,   16,   -7,  -14,  -17,   -8,  -27,  -23,    1,    1,    0,    6,   31,   63,   60,   46,
      21,    7,  -12,  -29,  -24,  -18,  -24,  -23,  -27,  -11,   11,    5,  -16,  -19,   11,   21,
       4,   -9,  -21,  -15,  -17,  -30,   -5,    7,    2,   -1,    9,   48,   65,   59,   30,   13,
      -4,  -25,  -19,   -6,  -22,  -33,  -32,  -31,   -3,    7,   -3,  -20,   -4,   14,   11,   -1,
     -11,  -19,  -13,  -20,  -16,    9,    7,    2,   -3,   27,   60,   69,   44,   12,    7,  -18,
     -20,    1,   -4,  -35,  -38,  -34,  -22,   -9,    4,   -2,  -11,    8,    8,    2,   -6,  -19,
     -23,  -14,  -16,    3,   13,    2,    2,   12,   47,   65,   62,   22,   10,   -3,  -21,   -9,
       9,  -17,  -46,  -40,  -34,  -23,   -6,    4,   -1,    3,    7,    2,   -4,  -13,  -25,  -18,
     -11,   -4,   18,    3,   -2,    5,   30,   58,   66,   39,   12,    9,  -10,  -18,    8,    5,
     -41,  -49,  -38,  -33,  -18,   -4,    2,    7,    8,    2,   -7,  -12,  -18,  -23,  -12,   -6,
      18,   15,   -8,    0,   21,   44,   62,   48,   22,   14,    7,  -16,   -7,   18,  -18,  -52,
     -44,  -42,  -32,  -18,   -1,   12,   10,    6,   -8,  -20,  -11,  -18,  -19,  -10,   14,   24,
       2,   -5,   14,   34,   57,   51,   27,   19,   20,   -1,  -13,   15,   -1,  -42,  -45,  -49,
     -38,  -28,  -15,   13,   19,   10,   -1,  -23,  -16,  -11,  -24,  -10,    6,   21,   14,   -5,
       3,   24,   48,   58,   29,   17,   24,   18,   -6,    4,    8,  -28,  -38,  -46,  -50,  -36,
     -29,    3,   22,   15,    4,  -18,  -31,   -7,  -20,  -17,    5,   11,   18,    4,   -2,   15,
      37,   58,   35,   11,   26,   31,   11,   -2,    6,  -13,  -32,  -39,  -55,  -45,  -38,  -17,
      21,   23,   11,  -10,  -31,  -18,  -11,  -25,    1,    9,   14,   15,    0,    7,   26,   49,
      49,   13,   10,   33,   26,    8,    4,   -5,  -25,  -35,  -46,  -53,  -41,  -35,    5,   24,
      17,    0,  -25,  -26,  -14,  -24,   -9,    6,    5,   17,    6,    6,   20,   38,   55,   30,
       3,   25,   38,   18,   10,   -4,  -16,  -30,  -42,  -51,  -46,  -41,  -16,   21,   23,   14,
     -16,  -30,  -16,  -17,  -17,    0,    2,   12,   16,    3,   17,   28,   46,   49,   14,   13,
      39,   30,   17,    4,   -9,  -20,  -38,  -49,  -50,  -50,  -34,    4,   21,   20,    4,  -29,
     -23,  -15,  -15,   -8,   -3,    7,   19,    8,    9,   26,   35,   47,   29,    6,   29,   35,
      26,   13,   -5,  -18,  -29,  -42,  -49,  -51,  -50,  -16,   11,   23,   18,  -17,  -34,  -14,
     -15,   -9,  -10,   -2,   17,   14,    5,   21,   33,   44,   38,   14,   23,   37,   30,   20,
       6,   -8,  -26,  -34,  -47,  -52,  -54,  -34,    0,   16,   19,    5,  -29,  -20,  -13,  -10,
      -9,  -10,    4,   19,   11,   13,   29,   37,   36,   22,   22,   39,   32,   23,   10,    2,
     -18,  -32,  -40,  -54,  -56,  -49,  -23,    8,   17,   11,  -15,  -26,  -11,  -13,   -9,  -15,
     -11,   14,   17,   10,   23,   34,   36,   24,   21,   35,   42,   26,   12,    2,   -4,  -23,
     -31,  -47,  -57,  -50,  -33,   -7,   17,   11,   -2,  -18,  -12,  -12,  -11,  -10,  -21,   -6,
      18,   19,   21,   33,   35,   28,   23,   34,   51,   40,   12,   -2,    1,   -9,  -27,  -43,
     -59,  -53,  -39,  -23,    4,   15,    1,  -10,  -14,   -9,   -8,  -10,  -22,  -18,    5,   19,
      16,   27,   34,   28,   23,   27,   47,   53,   27,   -3,   -4,   -1,  -13,  -33,  -53,  -57,
     -45,  -31,  -13,   14,    4,   -4,  -11,   -9,   -9,  -11,  -19,  -28,  -16,   10,   24,   23,
      35,   24,   26,   26,   38,   60,   44,    2,  -13,   -3,   -5,  -19,  -44,  -58,  -49,  -33,
     -26,    1,   14,    1,   -4,   -5,    0,   -7,  -14,  -29,  -26,  -11,   20,   27,   30,   32,
      21,   27,   34,   59,   58,   22,  -11,  -10,   -6,  -10,  -29,  -55,  -53,  -38,  -34,  -16,
      12,    9,   -5,   -8,    5,    1,  -16,  -31,  -32,  -28,    0,   26,   26,   33,   23,   24,
      33,   49,   61,   37,    3,  -15,   -8,  -11,  -19,  -43,  -56,  -44,  -34,  -25,   -2,   17,
       5,  -11,    2,   12,   -2,  -23,  -32,  -35,  -23,   14,   26,   27,   35,   23,   32,   45,
      58,   47,   19,   -5,   -9,  -10,  -16,  -27,  -46,  -48,  -41,  -34,  -18,   11,   20,   -6,
     -10,   12,    9,  -18,  -34,  -38,  -29,   -7,   17,   27,   32,   30,   30,   46,   52,   51,
      28,    6,   -8,   -9,  -15,  -24,  -32,  -41,  -45,  -40,  -30,   -1,   23,   10,  -12,    2,
      17,   -2,  -31,  -39,  -32,  -18,   -6,   18,   29,   38,   32,   45,   54,   54,   33,   11,
       2,   -9,  -11,  -19,  -32,  -33,  -41,  -45,  -40,  -18,   16,   19,    2,   -6,   13,   12,
     -20,  -43,  -35,  -21,  -18,   -5,   21,   35,   36,   46,   58,   52,   38,   17,    9,   -5,
      -9,  -13,  -29,  -32,  -28,  -41,  -43,  -36,    0,   22,   18,   -4,   -3,   17,    2,  -33,
     -43,  -25,  -18,  -16,    4,   27,   38,   47,   64,   57,   40,   18,   10,    5,   -7,  -10,
     -22,  -39,  -24,  -30,  -42,  -39,  -22,   13,   28,   14,   -9,    3,   17,  -16,  -51,  -36,
     -17,  -23,  -18,    8,   35,   50,   66,   68,   43,   23,   12,   13,   -1,  -11,  -17,  -32,
     -27,  -22,  -40,  -38,  -37,  -10,   22,   34,    1,  -10,    8,    6,  -39,  -48,  -27,  -19,
     -25,  -10,   18,   49,   66,   78,   54,   26,   17,   16,    3,   -7,  -15,  -25,  -29,  -12,
     -32,  -37,  -35,  -28,    3,   38,   26,   -7,   -4,   11,  -15,  -46,  -42,  -26,  -23,  -24,
      -2,   34,   66,   81,   70,   30,   19,   21,   10,   -5,  -11,  -25,  -29,  -12,  -20,  -37,
     -33,  -39,  -17,   25,   46,    6,  -11,    2,    0,  -29,  -44,  -41,  -30,  -27,  -17,   12,
      58,   79,   84,   46,   19,   22,   19,    2,   -7,  -26,  -35,  -12,   -1,  -29,  -33,  -39,
     -36,    3,   46,   31,  -11,   -6,   -1,  -14,  -38,  -46,  -39,  -32,  -22,   -5,   40,   76,
      88,   64,   23,   22,   30,   12,   -8,  -20,  -39,  -22,    0,  -13,  -29,  -33,  -43,  -20,
      24,   49,   13,  -12,    2,   -6,  -26,  -45,  -45,  -39,  -32,  -15,   19,   68,   85,   77,
      32,   22,   35,   27,    0,  -18,  -36,  -38,   -6,    3,  -17,  -29,  -44,  -37,   -2,   40,
      34,   -8,   -6,    3,  -18,  -44,  -47,  -44,  -43,  -21,    3,   49,   76,   80,   53,   21,
      35,   39,   15,  -18,  -35,  -42,  -23,    2,   -3,  -19,  -33,  -42,  -23,   16,   46,   16,
      -8,    2,   -6,  -37,  -45,  -47,  -51,  -33,   -8,   31,   68,   74,   66,   33,   35,   45,
      36,   -3,  -33,  -40,  -34,   -7,    5,   -8,  -18,  -35,  -39,  -13,   32,   32,    3,   -1,
       5,  -26,  -46,  -50,  -52,  -44,  -20,   15,   59,   68,   69,   50,   32,   42,   48,   21,
     -26,  -42,  -42,  -24,    2,    2,   -8,  -20,  -38,  -35,    6,   33,   17,   -2,    5,   -6,
     -41,  -55,  -57,  -46,  -33,   -6,   40,   64,   62,   63,   45,   38,   54,   40,   -4,  -42,
     -50,  -40,  -11,    6,   -2,   -8,  -24,  -41,  -19,   17,   28,   10,    0,    1,  -26,  -52,
     -64,  -51,  -40,  -23,   19,   54,   56,   61,   60,   38,   52,   55,   24,  -30,  -50,  -47,
     -27,    4,    8,   -6,  -11,  -30,  -36,   -6,   19,   25,    4,    1,   -9,  -38,  -64,  -61,
     -42,  -36,    0,   44,   55,   51,   66,   50,   49,   62,   46,   -5,  -48,  -51,  -40,  -11,
      11,    4,  -14,  -15,  -36,  -25,    1,   19,   15,   -1,   -2,  -18,  -53,  -69,  -48,  -42,
     -20,   21,   51,   45,   56,   62,   51,   60,   59,   23,  -32,  -53,  -49,  -28,    5,   17,
     -12,  -18,  -22,  -32,  -12,    9,   20,    1,   -6,   -5,  -29,  -70,  -62,  -48,  -32,    2,
      36,   45,   44,   62,   62,   60,   64,   47,  -10,  -45,  -54,  -42,  -11,   21,    5,  -19,
     -18,  -23,  -20,   -1,   15,    4,   -6,   -2,   -6,  -51,  -72,  -57,  -44,  -13,   19,   40,
      41,   51,   65,   66,   69,   63,   14,  -32,  -47,  -50,  -30,   10,   14,  -12,  -16,  -18,
     -16,  -14,    7,    8,   -6,   -8,   -1,  -21,  -65,  -67,  -54,  -29,    1,   26,   38,   44,
      53,   69,   77,   73,   37,  -17,  -41,  -46,  -37,  -10,   13,   -1,  -11,  -14,  -14,  -10,
      -6,    9,   -5,   -6,  -11,   -3,  -43,  -67,  -68,  -42,  -15,   12,   27,   40,   47,   65,
      80,   83,   55,    7,  -34,  -43,  -34,  -22,   -5,    2,   -3,   -2,  -13,  -10,  -11,    3,
      -2,   -4,  -13,   -5,  -15,  -51,  -72,  -63,  -31,   -3,   16,   29,   42,   55,   78,   91,
      68,   25,  -11,  -40,  -32,  -22,  -21,   -9,   -1,    8,   -1,  -19,  -11,   -3,    1,   -5,
     -11,  -12,   -3,  -29,  -58,  -70,  -48,  -18,    6,   15,   35,   50,   68,   89,   84,   37,
      11,  -27,  -38,  -19,  -20,  -23,   -8,   10,   18,  -10,  -19,   -8,    4,    0,  -11,  -14,
      -7,  -20,  -42,  -63,  -60,  -37,   -4,    7,   23,   41,   67,   82,   90,   53,   19,   -4,
     -34,  -23,  -20,  -31,  -22,    5,   25,    8,  -17,  -20,    0,   10,   -5,  -20,   -9,  -12,
     -31,  -47,  -60,  -53,  -26,   -3,   12,   32,   58,   81,   85,   70,   27,    9,  -19,  -26,
     -19,  -28,  -31,   -8,   24,   21,   -2,  -26,  -11,   14,   10,  -20,  -18,   -8,  -24,  -33,
     -53,  -56,  -44,  -23,    3,   22,   44,   77,   85,   74,   40,   17,   -3,  -21,  -21,  -24,
     -36,  -25,   11,   22,   15,  -13,  -28,    5,   23,    0,  -28,  -12,  -19,  -26,  -42,  -56,
     -48,  -39,  -17,   12,   34,   62,   84,   73,   52,   26,    9,  -12,  -21,  -22,  -31,  -30,
      -1,   15,   16,    6,  -25,  -14,   23,   19,  -17,  -21,  -13,  -24,  -34,  -54,  -44,  -39,
     -36,   -9,   27,   46,   79,   79,   59,   38,   16,   -2,  -17,  -25,  -25,  -27,  -10,    5,
      10,   15,   -4,  -24,    5,   29,    5,  -24,  -18,  -19,  -28,  -48,  -50,  -35,  -38,  -28,
      10,   33,   62,   82,   62,   46,   27,    4,   -8,  -23,  -24,  -25,  -15,   -3,    0,    8,
       6,  -12,   -9,   22,   25,   -6,  -21,  -22,  -28,  -45,  -53,  -39,  -30,  -37,  -11,   20,
      43,   75,   66,   53,   41,   10,   -8,  -16,  -25,  -23,  -15,   -2,   -4,   -5,    4,    1,
      -7,    8,   29,   19,   -9,  -21,  -24,  -42,  -55,  -48,  -30,  -31,  -19,    5,   23,   61,
      74,   58,   53,   26,   -7,  -11,  -18,  -25,  -14,    0,    1,  -16,   -8,    4,    0,    3,
      20,   28,   11,  -16,  -19,  -38,  -58,  -55,  -35,  -27,  -16,   -1,    5,   32,   63,   61,
      56,   44,    3,  -17,  -13,  -22,  -19,   -4,    5,   -8,  -21,   -6,    7,    8,   12,   25,
      25,    2,  -17,  -26,  -54,  -64,  -47,  -32,  -11,    5,    3,   16,   40,   60,   58,   56,
      26,  -16,  -19,  -16,  -20,   -8,    0,   -4,  -20,  -22,    1,   12,    9,   17,   30,   20,
      -2,  -15,  -42,  -68,  -57,  -44,  -19,   11,    6,   10,   19,   42,   58,   58,   45,    6,
     -23,  -18,  -13,  -13,   -3,   -3,  -10,  -26,  -14,    9,   15,   12,   26,   27,   10,   -7,
     -25,  -61,  -68,  -54,  -36,   10,   15,   13,   16,   19,   42,   55,   52,   31,   -9,  -25,
     -18,  -15,   -7,   -3,   -9,  -23,  -26,   -2,   15,   19,   19,   26,   18,    7,  -10,  -41,
     -72,  -60,  -51,   -8,   25,   22,   20,   13,   19,   45,   51,   44,   19,  -15,  -28,  -15,
      -7,   -4,   -9,  -19,  -28,  -14,    6,   18,   18,   24,   22,   12,    1,  -17,  -55,  -67,
     -56,  -35,   19,   33,   30,   20,    9,   23,   44,   48,   39,    6,  -22,  -25,   -9,   -8,
      -9,  -15,  -29,  -21,   -3,   10,   16,   20,   23,   13,    7,   -4,  -31,  -63,  -61,  -50,
     -11,   33,   37,   30,   12,    7,   24,   44,   48,   28,   -4,  -28,  -14,   -4,  -14,  -14,
     -27,  -27,   -8,    5,   13,   15,   19,   19,   11,    3,  -12,  -44,  -64,  -58,  -31,   17,
      40,   39,   24,    8,    3,   30,   46,   42,   16,  -18,  -21,   -6,  -16,  -18,  -26,  -32,
     -15,    1,    6,   10,   10,   15,   12,   10,   -3,  -23,  -51,  -63,  -50,   -4,   34,   41,
      33,   17,   -4,   10,   35,   42,   32,    5,  -15,   -8,  -10,  -18,  -21,  -30,  -22,    0,
       3,   -2,   -2,    6,    5,    4,    3,   -7,  -25,  -45,  -45,  -18,   25,   33,   32,   21,
       7,    8,   20,   30,   31,   20,    3,   -7,  -10,  -14,  -17,  -23,  -29,  -12,    6,   -2,
     -11,  -11,   -4,    2,    3,   -7,  -10,  -27,  -33,  -21,   13,   27,   23,   19,    8,   15,
      17,   18,   21,   23,   19,    2,  -12,  -10,   -9,  -15,  -27,  -28,   -2,    9,   -8,  -18,
     -17,   -4,    9,   -6,   -7,  -10,  -17,  -13,    2,   21,   20,   14,    4,   15,   25,   15,
      11,   14,   19,   13,  -13,  -17,   -6,   -5,  -20,  -36,  -23,    4,    6,  -18,  -28,  -20,
       6,    6,    0,    3,    5,    5,   28,   31,   31,   49,   55,   35,   11,   27,   26,    4,
       7,   11,   31,   54,   38,   26,   34,   35,   20,  -10,  -32,  -43,  -47,  -43,  -20,   -7,
     -37,  -55,  -62,  -61,  -63,  -34,  -21,  -35,  -28,  -10,   15,   24,   23,    5,  -31,  -38,
      -6,   23,   19,   15,   24,   20,   31,   57,   54,   28,   13,   33,   20,    1,    4,   17,
      38,   44,   33,   31,   43,   36,   10,  -14,  -34,  -53,  -53,  -46,  -22,  -22,  -38,  -46,
     -54,  -60,  -58,  -29,  -25,  -39,  -29,  -12,   11,   25,   27,    6,  -31,  -33,   -3,   27,
      32,   21,   13,   16,   38,   60,   53,   26,   18,   28,   11,   -2,    8,   26,   37,   34,
      36,   42,   47,   31,    6,  -14,  -41,  -61,  -54,  -49,  -26,  -30,  -41,  -40,  -44,  -54,
     -48,  -23,  -28,  -41,  -33,   -7,   14,   26,   29,    3,  -32,  -27,    6,   33,   35,   18,
       5,   21,   45,   61,   49,   25,   30,   22,    0,   -5,    9,   37,   39,   27,   33,   47,
      50,   31,    1,  -22,  -51,  -65,  -59,  -45,  -31,  -40,  -36,  -29,  -35,  -49,  -41,  -28,
     -39,  -44,  -26,   -8,    6,   27,   31,   -5,  -31,  -18,   14,   33,   31,   17,    4,   25,
      48,   57,   45,   32,   27,    9,   -6,   -5,   14,   43,   36,   29,   39,   51,   50,   31,
       0,  -32,  -65,  -73,  -62,  -37,  -36,  -46,  -36,  -23,  -26,  -37,  -32,  -35,  -46,  -42,
     -22,  -11,    2,   30,   28,   -8,  -29,  -12,   22,   33,   32,   15,    4,   25,   49,   58,
      50,   36,   20,    2,   -9,   -3,   21,   43,   37,   32,   44,   55,   53,   33,   -7,  -42,
     -67,  -72,  -64,  -43,  -43,  -46,  -35,  -17,  -17,  -24,  -31,  -40,  -47,  -39,  -18,  -15,
       0,   33,   22,  -14,  -22,    5,   29,   29,   28,   11,    7,   23,   49,   54,   50,   37,
      13,   -6,  -11,   -6,   25,   44,   38,   26,   40,   57,   54,   28,  -12,  -48,  -70,  -73,
     -66,  -43,  -43,  -43,  -29,  -12,  -15,  -16,  -32,  -48,  -51,  -38,  -24,  -19,    4,   31,
      12,  -16,  -14,   21,   34,   24,   24,   13,   10,   27,   49,   53,   53,   33,    6,   -9,
     -16,   -4,   33,   48,   37,   24,   45,   61,   54,   23,  -15,  -60,  -76,  -76,  -60,  -48,
     -45,  -38,  -26,  -11,   -3,   -5,  -33,  -49,  -52,  -35,  -25,  -21,    7,   24,    1,  -15,
      -1,   34,   30,   23,   29,   17,    5,   26,   49,   55,   53,   26,   -3,  -16,  -16,    4,
      38,   43,   33,   33,   49,   59,   45,   19,  -18,  -63,  -78,  -79,  -58,  -50,  -39,  -31,
     -21,  -11,   -2,   -3,  -30,  -49,  -51,  -35,  -29,  -20,    8,   12,  -10,  -11,   17,   37,
      27,   29,   29,   13,    2,   33,   56,   55,   38,   18,   -7,  -19,  -17,   13,   40,   42,
      33,   35,   52,   58,   40,   10,  -28,  -68,  -84,  -78,  -56,  -47,  -36,  -30,  -17,   -7,
       5,   -4,  -30,  -49,  -51,  -34,  -30,  -18,   10,    1,  -18,   -9,   30,   39,   26,   32,
      28,    9,    7,   38,   51,   45,   35,   16,  -13,  -28,  -11,   27,   41,   41,   34,   45,
      58,   54,   29,    7,  -33,  -69,  -80,  -78,  -59,  -43,  -31,  -24,  -15,   -3,    9,   -4,
     -29,  -51,  -51,  -33,  -27,   -8,    8,  -13,  -24,   -1,   40,   41,   29,   31,   22,    7,
      15,   46,   48,   38,   33,   11,  -19,  -28,   -7,   26,   42,   36,   39,   54,   54,   48,
      20,    3,  -39,  -68,  -79,  -78,  -54,  -37,  -32,  -27,  -16,    5,   11,   -6,  -31,  -50,
     -49,  -33,  -24,   -3,   -3,  -29,  -26,   13,   44,   36,   30,   32,   17,    7,   28,   43,
      37,   31,   28,    4,  -17,  -27,   -5,   24,   46,   43,   48,   56,   50,   41,   20,   -1,
     -47,  -64,  -82,  -78,  -48,  -35,  -34,  -26,  -14,    6,    9,  -10,  -31,  -46,  -43,  -33,
     -21,    1,  -16,  -38,  -15,   24,   38,   35,   44,   33,   10,   15,   37,   43,   30,   22,
      18,    4,  -20,  -29,    0,   30,   43,   48,   54,   52,   46,   35,   19,   -9,  -41,  -60,
     -83,  -73,  -44,  -29,  -37,  -27,  -12,    6,    8,  -10,  -28,  -45,  -43,  -25,   -9,   -3,
     -33,  -43,   -4,   32,   35,   37,   49,   24,    7,   26,   47,   35,   17,   11,   14,    3,
     -21,  -30,    6,   30,   44,   60,   56,   44,   37,   33,   15,  -11,  -40,  -63,  -82,  -61,
     -36,  -33,  -39,  -26,  -13,    0,    4,   -9,  -29,  -42,  -37,  -18,   -7,  -13,  -39,  -34,
       2,   30,   34,   45,   49,   16,   11,   37,   45,   26,   11,    8,    9,   -1,  -26,  -25,
      17,   31,   46,   62,   52,   42,   29,   26,   15,  -12,  -45,  -64,  -71,  -48,  -34,  -35,
     -33,  -27,  -16,    1,    2,  -10,  -23,  -41,  -32,  -12,   -6,  -29,  -46,  -28,   12,   26,
      36,   54,   43,   10,   23,   52,   43,   18,   -2,    5,    5,   -7,  -25,  -11,   19,   22,
      49,   61,   50,   40,   24,   20,   15,  -10,  -47,  -62,  -62,  -45,  -34,  -30,  -30,  -23,
     -16,   -6,   -1,   -8,  -25,  -38,  -29,   -9,  -10,  -39,  -42,  -19,    5,   23,   48,   57,
      33,    7,   32,   57,   39,    8,   -7,    3,   -2,  -16,  -16,    1,   20,   22,   48,   55,
      46,   39,   17,   16,   17,   -9,  -48,  -58,  -54,  -40,  -37,  -28,  -26,  -22,  -23,   -5,
       2,  -11,  -28,  -37,  -27,  -10,  -18,  -44,  -35,  -18,    3,   31,   54,   52,   25,   13,
      45,   61,   29,   -4,  -10,    0,   -5,  -16,   -8,    4,   21,   21,   50,   54,   45,   31,
       4,   20,   18,  -15,  -43,  -48,  -48,  -39,  -33,  -28,  -25,  -22,  -21,    0,   -1,  -19,
     -29,  -29,  -22,  -11,  -29,  -42,  -30,  -17,    3,   38,   61,   46,   24,   25,   53,   58,
      20,  -10,   -9,   -5,  -16,  -12,    4,   11,   22,   17,   48,   51,   43,   16,    2,   18,
      13,  -15,  -35,  -46,  -43,  -38,  -31,  -23,  -27,  -24,  -13,    3,   -8,  -25,  -29,  -27,
     -22,  -18,  -36,  -38,  -31,  -19,    6,   46,   60,   36,   24,   33,   56,   44,   10,   -8,
      -9,  -12,  -24,   -7,   14,   23,   18,   11,   45,   47,   39,   13,    5,   16,    1,  -19,
     -22,  -39,  -45,  -45,  -31,  -20,  -24,  -16,   -6,   -3,  -19,  -24,  -25,  -26,  -22,  -24,
     -39,  -35,  -25,  -13,    8,   54,   64,   36,   29,   41,   56,   36,    5,  -12,  -11,  -14,
     -26,   -6,   24,   33,    7,   12,   45,   44,   30,   13,   10,   17,   -4,  -17,  -16,  -34,
     -46,  -50,  -30,  -20,  -23,  -12,    1,  -11,  -26,  -27,  -24,  -21,  -19,  -34,  -48,  -32,
     -23,  -10,   13,   66,   65,   33,   32,   48,   55,   25,    0,   -8,   -1,  -18,  -36,   -4,
      40,   33,   -1,   17,   37,   35,   25,   10,   14,   10,  -13,  -15,   -9,  -26,  -46,  -51,
     -32,  -18,  -15,   -4,    3,  -17,  -31,  -28,  -25,  -20,  -26,  -48,  -48,  -27,  -20,  -13,
      19,   71,   61,   28,   33,   56,   50,   12,   -8,   -2,    5,  -24,  -41,    2,   52,   29,
      -1,   24,   36,   26,   16,   14,   19,    6,  -19,  -12,    1,  -21,  -49,  -50,  -28,  -12,
      -3,    2,   -2,  -25,  -32,  -29,  -24,  -14,  -31,  -61,  -44,  -17,  -15,   -9,   28,   72,
      61,   25,   38,   61,   41,    7,   -7,    4,    3,  -32,  -36,    9,   45,   21,    4,   30,
      33,   15,   11,   18,   17,   -1,  -18,   -7,   -4,  -22,  -47,  -45,  -24,   -6,    2,    5,
      -7,  -27,  -34,  -28,  -21,  -14,  -42,  -69,  -40,  -11,  -16,   -3,   41,   68,   53,   29,
      48,   61,   32,    0,   -5,    8,    2,  -33,  -28,    9,   31,   16,   16,   34,   22,    0,
      10,   24,   10,   -9,  -19,   -6,   -8,  -26,  -38,  -34,  -20,  -10,    1,   11,   -9,  -33,
     -31,  -32,  -25,  -18,  -50,  -65,  -40,  -15,   -8,   13,   47,   65,   50,   33,   54,   62,
      24,   -2,    2,   12,   -6,  -31,  -20,   12,   21,   10,   28,   34,    9,   -5,   20,   20,
      -2,  -13,  -10,   -4,  -18,  -33,  -26,  -16,  -19,  -14,    6,    8,  -14,  -31,  -32,  -29,
     -29,  -31,  -51,  -69,  -47,  -12,    2,   21,   49,   56,   43,   45,   62,   54,   16,   -2,
       7,    9,  -13,  -22,   -4,   12,    7,   13,   37,   33,    7,   -4,   23,    9,   -8,   -8,
      -2,   -8,  -33,  -38,   -7,   -1,  -22,  -19,   11,    7,  -21,  -29,  -29,  -29,  -31,  -32,
     -55,  -80,  -49,   -7,   16,   31,   43,   45,   44,   56,   66,   45,   12,    2,   10,    3,
     -18,  -13,    7,    9,   -2,   17,   38,   22,    1,    5,   17,    4,  -14,  -12,   -1,  -11,
     -43,  -38,    6,    5,  -22,  -15,   12,    0,  -23,  -26,  -28,  -31,  -32,  -36,  -60,  -82,
     -46,    3,   24,   35,   38,   41,   46,   59,   62,   41,   13,   -1,    3,   -6,  -18,    3,
      22,    2,   -9,   20,   36,   18,   10,    7,    4,   -5,  -17,   -9,   -2,  -18,  -55,  -30,
      17,    6,  -20,  -10,    6,   -5,  -16,  -26,  -32,  -27,  -30,  -42,  -69,  -84,  -41,   13,
      31,   42,   37,   38,   45,   63,   65,   41,   12,    3,    1,  -18,  -10,   23,   27,   -2,
     -12,   17,   36,   26,   13,    4,   -2,   -5,  -14,  -14,  -11,  -26,  -54,  -19,   21,    8,
     -16,   -8,    6,   -7,  -20,  -30,  -33,  -24,  -33,  -50,  -74,  -82,  -32,   18,   34,   42,
      38,   34,   50,   69,   58,   34,   16,    7,   -9,  -29,   -2,   41,   32,   -7,  -15,   11,
      34,   30,    9,    2,   -3,   -7,  -23,  -21,  -15,  -30,  -52,  -10,   18,   10,   -8,   -4,
       5,   -4,  -25,  -33,  -26,  -22,  -42,  -59,  -79,  -72,  -20,   23,   36,   41,   37,   34,
      54,   74,   53,   22,   17,   15,  -17,  -34,   10,   52,   37,   -8,  -11,   12,   33,   23,
       8,    4,   -1,  -16,  -31,  -25,  -18,  -38,  -49,   -3,   19,   11,   -4,    0,    7,   -8,
     -34,  -31,  -19,  -26,  -52,  -62,  -79,  -55,   -7,   23,   41,   47,   41,   33,   61,   75,
      43,   22,   21,   13,  -26,  -33,   17,   58,   39,   -6,   -8,   13,   27,   10,    5,   13,
      -2,  -32,  -43,  -32,  -19,  -38,  -36,   -3,   12,    4,    4,   13,    6,  -22,  -41,  -31,
     -13,  -33,  -59,  -71,  -76,  -35,    2,   20,   39,   53,   47,   39,   60,   62,   37,   26,
      22,    5,  -33,  -29,   26,   64,   40,    0,   -5,   12,   21,    8,   16,   10,  -13,  -39,
     -49,  -37,  -25,  -41,  -30,   -6,    9,    9,   13,   23,    0,  -30,  -44,  -26,  -13,  -45,
     -67,  -76,  -68,  -20,   10,   19,   39,   55,   50,   46,   57,   50,   37,   30,   16,   -3,
     -34,  -22,   34,   65,   40,   13,   -2,    6,   19,   12,   21,    5,  -23,  -49,  -52,  -38,
     -33,  -36,  -24,   -9,   10,   12,   25,   23,  -11,  -29,  -43,  -27,  -21,  -55,  -73,  -77,
     -50,   -2,   19,   19,   35,   59,   59,   49,   45,   40,   36,   27,    4,  -10,  -24,  -12,
      31,   59,   44,   22,   -5,    4,   19,   20,   12,   -4,  -27,  -52,  -50,  -45,  -39,  -24,
     -23,  -13,   16,   20,   30,   15,  -16,  -28,  -37,  -30,  -36,  -64,  -79,  -73,  -28,   17,
      24,   14,   36,   65,   68,   45,   33,   39,   40,   22,   -2,   -5,  -11,  -11,   28,   58,
      57,   20,  -13,    0,   27,   23,    1,  -15,  -35,  -58,  -55,  -52,  -39,  -20,  -22,   -9,
      20,   29,   30,   10,  -15,  -31,  -39,  -32,  -48,  -72,  -86,  -59,   -4,   27,   19,   17,
      44,   77,   69,   31,   26,   40,   38,   14,   -6,    0,    1,  -11,   26,   67,   62,   10,
     -18,    6,   31,   20,   -5,  -22,  -44,  -66,  -61,  -50,  -31,  -17,  -24,   -7,   24,   34,
      31,    3,  -17,  -31,  -36,  -40,  -61,  -73,  -76,  -46,   11,   34,   20,   22,   56,   83,
      60,   22,   24,   46,   32,    5,   -4,    9,    0,   -8,   31,   73,   53,    0,  -13,   16,
      28,   14,  -15,  -31,  -51,  -74,  -64,  -43,  -25,  -22,  -25,   -1,   30,   37,   20,   -2,
     -20,  -36,  -39,  -55,  -69,  -75,  -69,  -32,   21,   36,   22,   31,   63,   76,   50,   22,
      25,   49,   29,    3,    4,    9,    2,    0,   43,   74,   37,   -8,   -1,   28,   24,    8,
     -22,  -42,  -65,  -80,  -60,  -31,  -25,  -31,  -24,    8,   41,   37,   10,   -3,  -22,  -40,
     -45,  -60,  -69,  -69,  -55,  -15,   32,   37,   25,   42,   72,   70,   37,   21,   32,   41,
      20,    5,   15,    8,    0,    9,   46,   62,   26,   -7,    8,   28,   21,    4,  -29,  -53,
     -79,  -82,  -57,  -25,  -27,  -32,  -21,   14,   48,   35,   -1,   -7,  -24,  -44,  -52,  -70,
     -69,  -60,  -38,    1,   34,   33,   32,   57,   70,   58,   34,   26,   31,   31,   16,   14,
      14,    3,    8,   25,   47,   47,   18,   -2,   13,   25,   19,   -2,  -33,  -64,  -87,  -83,
     -53,  -24,  -29,  -32,  -17,   21,   46,   27,   -4,  -12,  -30,  -51,  -61,  -73,  -60,  -46,
     -17,    9,   25,   32,   47,   69,   61,   48,   41,   30,   26,   24,   18,   24,   15,    2,
      14,   37,   42,   34,   17,    9,   19,   20,   11,   -7,  -35,  -79,  -97,  -79,  -45,  -21,
     -29,  -33,  -12,   26,   43,   27,   -3,  -15,  -43,  -58,  -66,  -69,  -52,  -37,   -2,   16,
      24,   38,   61,   72,   56,   43,   41,   32,   28,   22,   22,   26,   12,    1,   23,   45,
      34,   21,    8,   17,   22,   19,    4,  -18,  -47,  -93,  -97,  -70,  -40,  -29,  -33,  -22,
      -5,   24,   44,   19,   -6,  -23,  -53,  -60,  -74,  -63,  -41,  -20,   10,   18,   19,   40,
      70,   70,   47,   41,   43,   37,   27,   14,   24,   32,   10,    1,   29,   44,   27,   12,
       7,   28,   32,    9,  -11,  -27,  -56, -100,  -94,  -64,  -43,  -38,  -31,   -7,    0,   27,
      41,   11,   -7,  -35,  -60,  -62,  -75,  -54,  -29,   -5,   17,   22,   14,   46,   80,   72,
      46,   42,   44,   42,   24,   16,   31,   32,    9,    4,   33,   45,   22,    5,    8,   41,
      34,    0,  -22,  -36,  -69, -100,  -92,  -65,  -40,  -44,  -25,    0,    5,   28,   36,    4,
     -12,  -50,  -64,  -64,  -68,  -46,  -19,    2,   25,   28,   19,   44,   72,   67,   46,   45,
      44,   39,   21,   21,   38,   29,    1,    9,   39,   39,   13,   -4,    9,   54,   41,  -11,
     -38,  -51,  -76,  -91,  -92,  -65,  -44,  -47,  -17,   12,   11,   21,   27,    6,  -24,  -59,
     -65,  -67,  -61,  -40,  -17,    8,   31,   26,   20,   49,   74,   65,   45,   48,   47,   36,
      25,   28,   36,   25,    5,   19,   42,   28,    6,   -2,   21,   56,   27,  -22,  -45,  -62,
     -83,  -92,  -84,  -65,  -49,  -37,   -8,   15,   16,   22,   23,   -1,  -38,  -65,  -66,  -65,
     -51,  -35,  -15,   20,   42,   26,   25,   51,   70,   60,   45,   52,   47,   25,   25,   39,
      33,   24,   16,   31,   37,   14,    3,    2,   33,   55,   14,  -35,  -55,  -67,  -84,  -88,
     -84,  -68,  -47,  -28,   -1,   17,   22,   24,   17,  -14,  -54,  -66,  -64,  -61,  -46,  -32,
     -10,   26,   45,   24,   29,   52,   66,   57,   49,   56,   41,   16,   29,   46,   31,   22,
      24,   37,   30,   12,   -1,    5,   40,   39,    1,  -41,  -63,  -72,  -89,  -89,  -77,  -62,
     -48,  -17,    5,   13,   26,   31,   10,  -29,  -62,  -64,  -65,  -54,  -41,  -25,   -4,   32,
      52,   29,   32,   55,   61,   55,   56,   57,   35,   17,   33,   40,   28,   27,   37,   36,
      26,   14,   -3,   13,   41,   22,  -13,  -45,  -65,  -78,  -90,  -87,  -70,  -56,  -47,  -12,
       9,   18,   35,   27,   -5,  -41,  -63,  -61,  -65,  -52,  -37,  -17,    5,   35,   52,   34,
      38,   55,   58,   53,   60,   54,   31,   21,   33,   34,   30,   35,   40,   32,   29,   15,
      -4,   18,   30,   11,  -25,  -53,  -69,  -85,  -91,  -82,  -66,  -54,  -36,   -7,    6,   20,
      40,   19,  -17,  -52,  -63,  -60,  -65,  -50,  -32,  -11,    9,   34,   50,   40,   46,   51,
      56,   60,   60,   50,   28,   23,   33,   33,   31,   40,   43,   38,   38,   13,   -6,   13,
      19,   -2,  -34,  -57,  -78,  -91,  -85,  -73,  -63,  -55,  -28,   -1,    6,   26,   39,   13,
     -28,  -56,  -61,  -55,  -61,  -43,  -27,  -13,   12,   38,   48,   49,   54,   46,   52,   64,
      64,   48,   27,   22,   28,   33,   36,   44,   42,   39,   44,   15,   -3,   10,    6,  -19,
     -46,  -60,  -81,  -92,  -83,  -73,  -52,  -44,  -22,   -5,    5,   38,   37,   -6,  -41,  -55,
     -54,  -49,  -53,  -45,  -28,   -9,   19,   41,   47,   56,   57,   41,   56,   69,   64,   42,
      26,   23,   27,   36,   39,   44,   39,   48,   53,   12,   -4,    2,   -8,  -33,  -61,  -72,
     -84,  -87,  -80,  -73,  -49,  -36,  -12,   -5,    9,   42,   24,  -15,  -44,  -50,  -51,  -51,
     -51,  -45,  -26,   -4,   20,   40,   47,   64,   58,   38,   61,   71,   55,   37,   32,   23,
      30,   34,   39,   50,   43,   58,   53,    9,    4,   -3,  -27,  -49,  -71,  -79,  -79,  -79,
     -82,  -70,  -44,  -26,   -7,   -5,   16,   36,    9,  -18,  -40,  -47,  -49,  -45,  -42,  -43,
     -20,    1,   21,   40,   53,   72,   54,   36,   64,   66,   41,   30,   36,   26,   28,   31,
      44,   57,   48,   62,   45,   13,    3,  -14,  -47,  -65,  -77,  -87,  -78,  -71,  -75,  -68,
     -43,  -16,   -2,   -1,   18,   20,   -4,  -18,  -37,  -46,  -50,  -36,  -39,  -46,  -15,    7,
      23,   41,   62,   72,   49,   41,   69,   59,   33,   29,   38,   24,   28,   31,   52,   59,
      49,   61,   45,   21,    2,  -31,  -64,  -73,  -78,  -89,  -79,  -71,  -77,  -62,  -36,   -8,
       3,    5,   15,    5,  -10,  -17,  -34,  -49,  -50,  -27,  -37,  -43,  -12,   14,   25,   45,
      67,   68,   48,   48,   64,   48,   27,   33,   41,   25,   24,   32,   64,   66,   51,   62,
      41,   21,   -7,  -43,  -77,  -81,  -83,  -87,  -74,  -71,  -77,  -54,  -29,   -1,    7,   13,
      12,   -6,   -9,  -18,  -38,  -54,  -44,  -21,  -37,  -41,   -8,   16,   28,   53,   73,   61,
      46,   52,   60,   35,   25,   34,   38,   20,   25,   42,   73,   62,   60,   58,   39,   22,
     -19,  -54,  -85,  -88,  -95,  -88,  -65,  -69,  -73,  -47,  -22,    3,   14,   15,   -5,  -14,
      -6,  -23,  -42,  -52,  -34,  -19,  -42,  -38,    0,   18,   30,   62,   76,   61,   49,   52,
      49,   26,   23,   34,   33,   22,   21,   50,   78,   68,   66,   47,   40,   22,  -23,  -66,
     -95, -102,  -97,  -74,  -61,  -77,  -68,  -36,  -12,    9,   15,   13,  -18,  -14,   -5,  -31,
     -50,  -44,  -21,  -25,  -49,  -25,    8,   16,   30,   70,   82,   56,   45,   55,   39,   21,
      25,   31,   24,   21,   28,   64,   81,   68,   64,   47,   44,   15,  -30,  -77, -101, -104,
     -96,  -71,  -66,  -76,  -53,  -22,   -9,    6,   22,   10,  -22,  -15,  -13,  -38,  -48,  -32,
      -9,  -33,  -49,  -14,   10,   11,   37,   77,   85,   51,   44,   48,   30,   18,   21,   26,
      16,   21,   36,   71,   76,   73,   68,   48,   35,    4,  -38,  -81, -103, -109,  -91,  -67,
     -71,  -69,  -40,  -15,  -12,    3,   23,    7,  -23,  -17,  -24,  -41,  -45,  -24,  -11,  -46,
     -46,   -1,   10,    8,   49,   84,   83,   48,   50,   48,   27,   16,   18,   20,   14,   26,
      44,   72,   75,   82,   71,   47,   26,   -6,  -45,  -80, -107, -110,  -88,  -70,  -69,  -58,
     -28,   -9,  -12,    2,   23,    2,  -21,  -19,  -35,  -38,  -33,  -13,  -17,  -50,  -35,    8,
       9,   10,   57,   89,   74,   45,   52,   41,   24,   15,   11,   14,   13,   22,   54,   72,
      74,   86,   72,   41,   13,  -14,  -47,  -86, -113, -111,  -88,  -72,  -67,  -42,  -18,  -11,
     -11,    2,   18,   -2,  -17,  -27,  -44,  -37,  -28,  -12,  -26,  -49,  -22,    9,    3,   21,
      69,   87,   63,   46,   49,   36,   24,   13,   11,   11,    8,   26,   64,   68,   76,   89,
      74,   38,    3,  -17,  -44,  -86, -117, -114,  -86,  -65,  -58,  -38,  -19,   -7,    0,    8,
       9,   -5,  -20,  -37,  -45,  -29,  -19,  -15,  -36,  -39,  -10,    6,    4,   33,   79,   81,
      55,   48,   42,   30,   23,   10,   13,   10,    3,   27,   62,   60,   76,   88,   68,   30,
      -5,  -21,  -49,  -89, -120, -115,  -81,  -54,  -46,  -34,  -14,   -1,    7,    9,    1,   -6,
     -18,  -45,  -52,  -29,  -16,  -17,  -35,  -36,  -12,    5,   11,   47,   81,   72,   53,   51,
      39,   28,   24,    9,   13,    7,    5,   36,   57,   55,   82,   90,   62,   31,  -10,  -29,
     -55,  -91, -121, -115,  -76,  -47,  -38,  -34,  -13,    1,   13,    9,   -4,   -9,  -17,  -49,
     -56,  -26,   -9,  -12,  -33,  -40,  -17,   12,   25,   57,   71,   62,   52,   50,   35,   22,
      21,   14,   11,   -2,   10,   41,   50,   48,   85,   87,   66,   29,  -15,  -34,  -64,  -97,
    -121, -108,  -73,  -43,  -37,  -28,   -7,    7,   16,    6,   -7,   -5,  -15,  -59,  -56,  -19,
      -4,  -14,  -37,  -42,  -10,   21,   38,   66,   63,   57,   52,   49,   28,   22,   28,   16,
       5,   -3,   22,   47,   38,   45,   79,   85,   68,   23,  -16,  -34,  -70, -100, -122, -107,
     -62,  -39,  -38,  -25,   -4,   15,   18,    2,   -3,    0,  -27,  -70,  -51,  -17,   -3,  -16,
     -44,  -40,   -1,   27,   45,   67,   57,   54,   48,   39,   17,   18,   28,   17,    3,   -3,
      27,   49,   37,   42,   69,   86,   66,   16,  -17,  -37,  -72,  -99, -117, -101,  -55,  -39,
     -36,  -24,    1,   20,   13,    4,    4,   -5,  -46,  -74,  -43,   -9,   -4,  -28,  -49,  -33,
       6,   33,   63,   68,   54,   53,   49,   33,   18,   21,   24,   15,    7,    9,   33,   42,
      35,   39,   70,   85,   55,   10,  -16,  -40,  -75,  -98, -113,  -92,  -47,  -38,  -35,  -21,
       1,   21,   15,    8,    7,  -14,  -62,  -70,  -30,  -11,  -15,  -34,  -49,  -23,    9,   39,
      64,   58,   51,   56,   42,   20,   16,   19,   16,   16,    4,   13,   40,   46,   33,   31,
      65,   83,   49,    3,  -24,  -41,  -73,  -98, -105,  -77,  -45,  -41,  -30,  -13,    7,   19,
      12,   13,    8,  -26,  -68,  -61,  -22,  -14,  -25,  -38,  -40,  -18,   12,   47,   68,   59,
      49,   51,   42,   19,   17,   17,   12,   13,    5,   18,   41,   47,   26,   26,   67,   78,
      44,   -2,  -31,  -47,  -71,  -97,  -96,  -67,  -44,  -42,  -29,  -11,   13,   21,   13,   17,
       8,  -34,  -68,  -54,  -17,  -18,  -36,  -43,  -35,  -12,   14,   50,   69,   56,   49,   44,
      35,   16,   13,   17,   13,   13,    6,   27,   46,   50,   24,   28,   66,   64,   28,    0,
     -25,  -49,  -75,  -99,  -87,  -54,  -42,  -38,  -28,   -8,   20,   19,   11,   17,    1,  -41,
     -62,  -49,  -18,  -27,  -41,  -39,  -29,   -8,   15,   55,   73,   55,   42,   42,   33,   16,
      12,   12,    9,    6,   14,   40,   52,   48,   21,   31,   60,   50,   23,    0,  -32,  -60,
     -76,  -90,  -73,  -44,  -39,  -36,  -32,    1,   29,   20,    6,   13,   -3,  -41,  -53,  -43,
     -21,  -34,  -47,  -38,  -22,   -2,   22,   54,   65,   49,   38,   42,   32,   17,   12,    7,
       6,    3,   21,   48,   53,   42,   24,   39,   53,   38,   15,   -3,  -38,  -65,  -76,  -85,
     -59,  -36,  -35,  -40,  -26,   15,   26,   12,    6,   10,  -12,  -40,  -49,  -33,  -26,  -41,
     -53,  -36,  -12,    5,   28,   50,   61,   46,   34,   37,   31,   20,   12,    1,    0,    5,
      32,   53,   56,   41,   23,   39,   48,   35,   13,  -10,  -44,  -72,  -81,  -79,  -50,  -27,
     -34,  -41,  -18,   20,   27,   12,    5,    1,  -19,  -36,  -40,  -22,  -34,  -50,  -55,  -33,
      -3,   14,   33,   52,   54,   35,   27,   36,   37,   25,    7,  -13,    1,   19,   41,   50,
      50,   38,   32,   43,   41,   32,    6,  -17,  -46,  -69,  -79,  -75,  -43,  -20,  -34,  -38,
      -8,   23,   26,   12,    6,   -8,  -23,  -30,  -30,  -23,  -46,  -56,  -52,  -29,    6,   23,
      35,   44,   47,   31,   25,   33,   40,   26,   -4,  -22,    3,   28,   39,   40,   50,   40,
      28,   34,   37,   28,    0,  -22,  -50,  -70,  -81,  -72,  -34,  -22,  -36,  -33,    2,   24,
      25,   12,    4,  -15,  -24,  -26,  -25,  -23,  -46,  -56,  -50,  -24,   10,   33,   36,   40,
      35,   21,   25,   43,   47,   25,  -13,  -25,   11,   40,   36,   40,   56,   38,   27,   31,
      33,   24,   -4,  -24,  -53,  -71,  -80,  -59,  -34,  -27,  -31,  -27,    8,   24,   25,   17,
       2,  -22,  -25,  -26,  -19,  -24,  -51,  -58,  -40,   -9,   14,   37,   36,   35,   27,   14,
      28,   48,   46,   19,  -19,  -24,   18,   40,   29,   41,   50,   29,   29,   27,   33,   18,
     -12,  -29,  -53,  -71,  -75,  -48,  -33,  -32,  -25,  -14,   13,   24,   19,   17,    2,  -25,
     -28,  -28,  -18,  -28,  -55,  -59,  -30,   -3,   20,   41,   34,   24,   15,   15,   36,   49,
      39,   17,  -17,  -17,   22,   41,   33,   45,   38,   26,   30,   24,   27,   10,  -11,  -34,
     -58,  -70,  -66,  -38,  -32,  -36,  -21,   -2,   14,   28,   19,   14,    0,  -25,  -29,  -28,
     -17,  -30,  -57,  -51,  -22,    3,   23,   39,   34,   15,   11,   17,   38,   46,   39,   15,
     -18,  -14,   27,   40,   37,   45,   32,   28,   30,   29,   28,    1,  -16,  -38,  -55,  -65,
     -62,  -37,  -31,  -34,  -17,    9,   18,   27,   18,    9,   -1,  -22,  -35,  -29,  -17,  -32,
     -57,  -45,  -17,   15,   30,   30,   25,    8,   10,   19,   35,   46,   37,    4,  -19,   -8,
      31,   33,   33,   42,   28,   22,   24,   29,   23,   -6,  -21,  -43,  -54,  -59,  -55,  -32,
     -34,  -39,  -10,   19,   30,   25,    9,    2,   -2,  -20,  -38,  -30,  -23,  -41,  -51,  -35,
     -12,   24,   32,   22,   12,    8,   16,   23,   32,   48,   33,    1,  -16,    0,   29,   30,
      33,   36,   24,   23,   22,   33,   14,  -14,  -20,  -42,  -55,  -50,  -44,  -27,  -38,  -41,
      -3,   31,   35,   23,    5,   -2,   -4,  -15,  -34,  -33,  -38,  -47,  -40,  -26,   -3,   31,
      31,    9,    2,   13,   14,   20,   38,   53,   27,   -6,  -14,   11,   30,   23,   32,   28,
      25,   22,   24,   32,    5,  -20,  -26,  -45,  -49,  -40,  -36,  -37,  -48,  -40,    8,   40,
      37,   16,   -3,   -6,   -2,   -9,  -27,  -42,  -52,  -48,  -32,  -21,    8,   39,   28,   -2,
      -5,   13,   17,   23,   40,   45,   19,   -4,   -3,   18,   15,   19,   33,   30,   29,   22,
      21,   22,    0,  -17,  -27,  -46,  -48,  -33,  -31,  -38,  -53,  -33,   23,   43,   31,   11,
      -7,   -5,   -3,   -8,  -26,  -49,  -59,  -48,  -25,  -14,   15,   41,   23,   -8,   -6,   11,
      10,   26,   49,   41,   12,    0,   10,   19,    4,   22,   31,   25,   25,   24,   20,   12,
      -4,  -10,  -37,  -50,  -37,  -23,  -26,  -43,  -55,  -18,   34,   41,   28,   10,   -9,   -6,
      -3,   -8,  -27,  -57,  -62,  -37,  -15,   -8,   24,   44,   23,  -10,   -6,    3,    8,   39,
      55,   30,   12,   11,   20,    8,    3,   27,   26,   20,   21,   24,   19,   -1,  -10,  -14,
     -42,  -47,  -25,  -14,  -28,  -49,  -50,   -5,   38,   38,   23,    9,  -11,   -9,   -1,   -5,
     -33,  -64,  -59,  -34,  -14,   -2,   32,   49,   17,  -11,   -6,   -2,   11,   46,   46,   19,
      16,   23,   24,   -3,    3,   29,   29,   16,   17,   22,   11,  -12,  -12,  -18,  -50,  -43,
     -15,  -11,  -30,  -53,  -38,   10,   31,   31,   25,    3,  -16,   -3,    3,   -8,  -41,  -67,
     -53,  -24,  -14,    3,   35,   46,   17,   -2,   -7,   -9,   16,   49,   41,   20,   22,   34,
      21,   -5,    5,   31,   29,   12,   14,   18,    8,  -22,  -17,  -20,  -52,  -38,  -13,  -19,
     -32,  -48,  -25,   11,   23,   29,   26,    1,  -14,    1,    1,  -18,  -47,  -60,  -47,  -31,
     -11,   13,   45,   39,    8,   -2,   -2,  -11,   16,   43,   35,   25,   34,   40,   18,   -7,
       6,   34,   28,   14,    7,   11,    2,  -23,  -25,  -29,  -51,  -30,  -11,  -24,  -38,  -40,
     -15,    9,   18,   29,   32,   -1,  -10,    0,   -9,  -27,  -48,  -52,  -46,  -30,   -2,   27,
      47,   30,   10,    7,   -6,  -15,   12,   35,   28,   30,   45,   42,   19,   -4,   11,   29,
      21,    6,    1,    3,   -3,  -27,  -31,  -34,  -40,  -22,  -18,  -31,  -35,  -30,  -18,    5,
      19,   32,   28,   -9,   -7,    1,  -14,  -30,  -42,  -45,  -47,  -28,    7,   38,   45,   23,
      14,   20,   -2,  -24,    7,   32,   30,   37,   43,   41,   22,    7,   18,   22,   14,    4,
      -7,    4,   -7,  -36,  -37,  -37,  -27,  -15,  -26,  -34,  -34,  -29,  -18,    4,   19,   31,
      20,   -4,    0,   -3,  -21,  -32,  -37,  -41,  -40,  -25,   14,   49,   44,   18,   19,   25,
      -1,  -19,    5,   26,   35,   38,   46,   41,   18,   18,   16,   13,   12,    2,   -5,   -3,
     -23,  -44,  -37,  -32,  -20,  -20,  -33,  -28,  -32,  -32,  -16,    1,   17,   31,   17,   -2,
       2,   -3,  -22,  -33,  -39,  -40,  -34,  -23,   15,   56,   44,   15,   27,   23,   -4,  -14,
       2,   22,   38,   37,   48,   40,   25,   24,   15,   11,    2,   -2,   -3,  -15,  -31,  -40,
     -37,  -33,  -17,  -17,  -28,  -29,  -41,  -34,   -7,    1,   13,   31,   17,   -2,    4,    1,
     -20,  -35,  -47,  -37,  -24,  -10,   22,   52,   38,   26,   35,   26,   -2,   -9,    4,   23,
      40,   38,   46,   39,   32,   31,   16,    2,   -7,   -8,   -2,  -21,  -38,  -44,  -38,  -31,
     -18,  -15,  -29,  -35,  -45,  -32,   -1,   -3,    4,   30,   16,    3,    8,    4,  -20,  -42,
     -48,  -30,  -17,   -8,   21,   49,   41,   30,   38,   23,   -2,   -5,    1,   21,   35,   37,
      44,   40,   40,   33,   17,    1,  -13,  -10,   -9,  -35,  -41,  -41,  -39,  -33,  -19,  -12,
     -27,  -40,  -48,  -28,   -4,  -10,   10,   28,   15,    9,   12,    5,  -24,  -43,  -43,  -23,
     -18,    0,   26,   47,   43,   35,   40,   20,   -1,    1,    4,   20,   28,   37,   42,   42,
      46,   31,   22,    8,  -17,  -15,  -15,  -42,  -41,  -37,  -44,  -37,  -16,  -13,  -33,  -41,
     -41,  -20,  -11,  -17,   10,   18,   13,   16,   17,    1,  -24,  -38,  -38,  -27,  -21,    9,
      29,   46,   44,   43,   38,   18,    3,    6,    6,   12,   19,   38,   41,   47,   44,   28,
      29,   11,  -26,  -25,  -27,  -45,  -39,  -39,  -48,  -41,  -18,  -13,  -33,  -38,  -36,  -21,
     -19,  -14,   13,   11,   11,   26,   17,   -6,  -25,  -32,  -32,  -35,  -14,   21,   31,   38,
      49,   49,   34,   19,   13,   10,    4,    9,   20,   37,   41,   45,   39,   29,   35,    6,
     -28,  -28,  -35,  -43,  -37,  -42,  -50,  -44,  -20,  -20,  -37,  -37,  -27,  -16,  -23,  -11,
      10,    5,   17,   36,   16,  -16,  -23,  -21,  -33,  -38,   -5,   23,   28,   35,   55,   55,
      31,   17,   18,   12,    3,    4,   21,   33,   41,   45,   31,   32,   39,    3,  -29,  -35,
     -41,  -40,  -38,  -45,  -55,  -45,  -26,  -31,  -36,  -26,  -22,  -22,  -29,    1,    9,   -1,
      24,   39,    8,  -19,  -17,  -14,  -32,  -34,    5,   29,   29,   35,   58,   51,   32,   29,
      23,   11,    1,    6,   29,   37,   38,   36,   24,   43,   39,   -2,  -32,  -44,  -45,  -36,
     -36,  -45,  -55,  -51,  -37,  -35,  -30,  -22,  -20,  -32,  -24,    6,    2,    3,   30,   36,
       3,  -17,  -16,  -18,  -29,  -24,   10,   31,   25,   34,   58,   44,   33,   37,   26,    8,
       5,   10,   37,   36,   35,   29,   22,   47,   36,   -6,  -36,  -51,  -49,  -34,  -38,  -48,
     -58,  -53,  -46,  -42,  -24,  -23,  -22,  -32,  -13,    4,   -7,    8,   35,   30,    6,  -14,
     -20,  -19,  -21,  -20,   14,   34,   29,   43,   52,   37,   39,   43,   24,    8,    7,   15,
      45,   33,   36,   24,   25,   43,   25,  -10,  -39,  -53,  -47,  -34,  -39,  -53,  -56,  -54,
     -56,  -42,  -21,  -23,  -29,  -25,   -5,    1,  -10,   12,   35,   27,    7,  -14,  -25,  -19,
     -11,  -10,   13,   31,   37,   44,   42,   37,   45,   44,   24,   14,   13,   24,   40,   28,
      35,   23,   31,   35,   15,  -16,  -38,  -53,  -45,  -37,  -48,  -56,  -54,  -63,  -63,  -40,
     -23,  -24,  -27,  -19,    3,    1,  -11,   14,   33,   24,    5,  -16,  -28,  -17,   -6,   -1,
      15,   38,   39,   38,   29,   36,   54,   42,   20,   20,   19,   32,   38,   30,   31,   23,
      33,   23,   -1,  -17,  -35,  -44,  -43,  -47,  -51,  -51,  -56,  -71,  -67,  -45,  -28,  -23,
     -23,  -13,   12,   -1,  -15,   15,   33,   20,   -2,  -22,  -25,  -17,   -3,   10,   24,   46,
      44,   31,   26,   41,   53,   42,   23,   23,   26,   39,   37,   32,   24,   28,   36,   11,
      -7,  -19,  -38,  -39,  -37,  -49,  -54,  -51,  -62,  -76,  -68,  -51,  -28,  -19,  -21,    1,
      22,   -3,  -11,   14,   25,   16,   -5,  -25,  -25,  -15,   -2,   20,   36,   51,   42,   19,
      19,   43,   58,   43,   25,   21,   35,   46,   41,   34,   17,   26,   33,    5,  -15,  -25,
     -39,  -34,  -37,  -55,  -50,  -49,  -69,  -80,  -67,  -50,  -31,  -18,  -12,   12,   17,   -5,
      -5,   14,   17,    6,  -15,  -27,  -22,  -14,    3,   37,   49,   48,   40,   22,   22,   36,
      51,   44,   29,   22,   42,   49,   41,   29,   16,   29,   31,   -9,  -30,  -33,  -35,  -29,
     -38,  -55,  -45,  -54,  -79,  -80,  -65,  -51,  -34,  -16,   -2,   18,   18,    5,    7,    8,
       6,    3,  -19,  -21,  -22,  -19,   12,   51,   53,   48,   39,   22,   18,   36,   46,   42,
      35,   31,   44,   46,   42,   31,   24,   35,   21,  -25,  -39,  -33,  -30,  -24,  -41,  -53,
     -47,  -60,  -81,  -81,  -63,  -53,  -40,  -14,    6,   24,   20,    8,    7,    0,   -1,   -4,
     -21,  -23,  -29,  -16,   30,   60,   55,   50,   37,   19,   19,   35,   43,   46,   37,   29,
      43,   49,   43,   32,   27,   31,   13,  -35,  -46,  -36,  -26,  -28,  -44,  -52,  -47,  -65,
     -84,  -84,  -68,  -49,  -27,    0,   10,   15,   19,   15,    9,   -3,  -10,  -16,  -20,  -26,
     -28,   -2,   41,   59,   62,   56,   37,   16,   15,   31,   43,   50,   42,   30,   41,   49,
      49,   38,   28,   23,    5,  -42,  -55,  -42,  -21,  -22,  -40,  -49,  -54,  -71,  -86,  -81,
     -62,  -44,  -21,    5,   17,   16,   25,   23,    0,  -13,  -17,  -17,  -24,  -32,  -21,   15,
      45,   58,   66,   52,   33,   15,    9,   35,   42,   44,   44,   36,   38,   50,   52,   40,
      28,   16,  -11,  -48,  -60,  -43,  -22,  -21,  -40,  -53,  -58,  -78,  -90,  -79,  -61,  -42,
      -9,   14,   15,   16,   22,   21,   -4,  -20,  -21,  -19,  -30,  -31,  -10,   26,   54,   63,
      69,   51,   33,   12,   13,   40,   42,   45,   42,   33,   36,   53,   57,   44,   24,    3,
     -24,  -53,  -63,  -45,  -21,  -15,  -39,  -57,  -63,  -78,  -89,  -76,  -55,  -34,    3,   18,
       9,   16,   21,   15,   -8,  -26,  -28,  -25,  -32,  -24,    4,   34,   56,   67,   75,   48,
      22,    7,   23,   44,   39,   40,   40,   35,   40,   59,   59,   44,   18,   -6,  -31,  -54,
     -58,  -44,  -20,  -13,  -43,  -63,  -69,  -80,  -88,  -71,  -48,  -21,   12,   16,   12,   18,
      13,    6,  -12,  -27,  -32,  -30,  -34,  -20,   13,   46,   63,   74,   73,   40,   15,   13,
      39,   46,   33,   32,   35,   36,   48,   58,   61,   43,   16,  -13,  -36,  -57,  -62,  -41,
     -22,  -16,  -42,  -66,  -73,  -79,  -85,  -65,  -38,   -7,   13,    9,    7,   16,   11,   -2,
     -18,  -36,  -39,  -26,  -25,  -16,   21,   53,   64,   74,   68,   36,   19,   22,   38,   44,
      32,   28,   32,   38,   52,   60,   56,   43,   13,  -25,  -39,  -54,  -52,  -35,  -30,  -27,
     -46,  -70,  -79,  -80,  -79,  -58,  -26,    3,   15,    6,    0,   12,    6,   -8,  -27,  -45,
     -39,  -17,  -16,  -13,   28,   57,   67,   71,   57,   37,   22,   25,   41,   46,   29,   24,
      34,   44,   56,   55,   52,   44,    7,  -27,  -38,  -48,  -44,  -35,  -31,  -29,  -46,  -77,
     -83,  -73,  -70,  -48,  -15,    6,    9,    1,    1,    9,   -3,  -20,  -41,  -48,  -30,   -5,
     -14,   -9,   39,   63,   70,   66,   47,   36,   25,   32,   40,   43,   26,   21,   36,   47,
      59,   50,   49,   35,    0,  -26,  -36,  -44,  -41,  -36,  -35,  -33,  -50,  -79,  -79,  -66,
     -63,  -36,   -8,    6,   -3,   -9,    2,    3,  -13,  -30,  -49,  -46,  -18,   -2,  -15,    4,
      42,   58,   65,   61,   50,   38,   28,   37,   40,   38,   28,   30,   38,   48,   50,   42,
      46,   28,   -3,  -28,  -37,  -36,  -36,  -39,  -36,  -37,  -59,  -79,  -69,  -62,  -52,  -24,
      -2,    3,  -12,  -11,    4,   -5,  -29,  -42,  -53,  -39,  -12,   -4,   -4,   14,   37,   52,
      63,   58,   50,   37,   34,   37,   36,   37,   38,   36,   35,   47,   46,   44,   42,   18,
      -7,  -30,  -34,  -32,  -34,  -41,  -37,  -45,  -66,  -74,  -64,  -57,  -36,  -12,    1,   -8,
     -23,   -7,    6,  -18,  -39,  -49,  -53,  -29,   -5,   -1,   10,   19,   30,   46,   59,   58,
      50,   36,   37,   37,   32,   40,   46,   38,   34,   44,   42,   41,   36,    9,   -9,  -27,
     -29,  -26,  -34,  -40,  -40,  -56,  -69,  -66,  -56,  -46,  -22,   -7,   -7,  -19,  -21,    3,
       1,  -35,  -48,  -53,  -49,  -22,   -3,   12,   23,   18,   22,   46,   66,   59,   47,   38,
      43,   35,   30,   46,   51,   39,   33,   41,   37,   42,   24,    2,   -8,  -22,  -23,  -24,
     -33,  -39,  -50,  -66,  -69,  -59,  -49,  -31,  -13,  -10,  -17,  -25,  -16,    1,  -17,  -50,
     -55,  -58,  -42,  -17,   -1,   20,   31,   14,   15,   48,   70,   59,   42,   38,   45,   33,
      33,   51,   53,   36,   35,   37,   36,   37,   12,    0,   -9,  -16,  -18,  -22,  -33,  -42,
     -59,  -67,  -62,  -52,  -40,  -20,  -11,  -15,  -23,  -23,  -11,   -3,  -28,  -51,  -59,  -61,
     -38,  -14,    4,   26,   30,   10,   18,   53,   71,   56,   40,   42,   45,   32,   34,   53,
      52,   37,   36,   32,   37,   32,   10,   -3,  -10,  -10,  -11,  -17,  -31,  -46,  -62,  -63,
     -54,  -44,  -30,  -14,  -14,  -23,  -27,  -22,  -11,  -11,  -35,  -51,  -65,  -59,  -32,  -11,
      11,   29,   25,    8,   24,   63,   73,   51,   38,   46,   44,   29,   34,   51,   51,   39,
      34,   27,   34,   23,    3,   -5,   -9,   -6,  -10,  -18,  -33,  -51,  -66,  -60,  -50,  -35,
     -20,  -10,  -21,  -33,  -29,  -17,   -9,  -20,  -39,  -55,  -71,  -57,  -26,   -7,   11,   23,
      22,   11,   35,   70,   71,   46,   39,   48,   42,   29,   33,   51,   47,   38,   31,   28,
      35,   17,    0,  -12,   -7,    0,   -4,  -15,  -36,  -56,  -67,  -56,  -42,  -26,  -15,  -12,
     -29,  -36,  -28,  -15,  -13,  -25,  -40,  -58,  -70,  -49,  -23,   -6,    8,   19,   17,   18,
      49,   76,   66,   40,   42,   49,   39,   25,   35,   51,   43,   40,   30,   31,   32,   15,
      -1,  -14,   -7,    1,   -2,  -17,  -40,  -59,  -61,  -51,  -38,  -21,  -10,  -17,  -34,  -35,
     -28,  -18,  -17,  -24,  -40,  -64,  -65,  -40,  -18,   -8,    5,   13,   17,   31,   61,   75,
      60,   41,   43,   47,   34,   20,   36,   47,   43,   41,   31,   32,   26,    7,   -7,  -16,
      -6,    0,   -3,  -22,  -44,  -60,  -56,  -47,  -34,  -19,   -8,  -20,  -39,  -40,  -27,  -18,
     -20,  -29,  -44,  -63,  -56,  -38,  -23,  -11,    4,   14,   21,   42,   65,   71,   59,   45,
      42,   34,   21,   20,   42,   48,   44,   41,   31,   34,   24,    6,  -10,  -20,  -11,    4,
       0,  -20,  -48,  -57,  -47,  -39,  -30,  -17,   -4,  -24,  -43,  -40,  -26,  -19,  -24,  -29,
     -45,  -59,  -51,  -37,  -25,  -14,    3,   15,   27,   51,   72,   76,   61,   44,   38,   23,
      12,   21,   43,   46,   45,   40,   31,   35,   21,    5,  -17,  -22,  -13,    3,    1,  -24,
     -51,  -52,  -43,  -37,  -28,   -8,   -7,  -38,  -46,  -36,  -21,  -21,  -31,  -33,  -45,  -51,
     -47,  -40,  -30,  -13,    4,   14,   33,   60,   76,   76,   61,   47,   30,   16,    8,   20,
      40,   45,   48,   37,   37,   37,   22,    3,  -19,  -20,  -10,    4,   -6,  -30,  -49,  -44,
     -41,  -38,  -23,   -1,  -14,  -41,  -44,  -36,  -22,  -26,  -35,  -33,  -45,  -52,  -48,  -40,
     -32,   -9,    6,   18,   35,   65,   85,   80,   62,   46,   24,    6,   -1,   23,   41,   48,
      45,   31,   42,   40,   23,   -6,  -21,  -15,   -6,    0,  -13,  -31,  -44,  -41,  -38,  -32,
     -15,    0,  -22,  -40,  -41,  -36,  -24,  -31,  -28,  -32,  -46,  -49,  -47,  -43,  -30,   -6,
       9,   19,   46,   77,   87,   77,   61,   42,   18,   -2,   -7,   22,   39,   51,   41,   32,
      43,   35,   13,  -18,  -18,  -10,   -5,   -8,  -21,  -29,  -39,  -42,  -41,  -23,   -3,   -3,
     -32,  -39,  -38,  -34,  -31,  -35,  -23,  -32,  -46,  -50,  -51,  -46,  -26,    0,   12,   20,
      54,   87,   91,   72,   60,   38,   13,  -10,  -11,   24,   44,   52,   43,   39,   45,   34,
       2,  -19,   -8,   -1,   -8,  -19,  -19,  -25,  -35,  -42,  -39,  -17,    7,   -7,  -38,  -36,
     -36,  -37,  -37,  -31,  -20,  -34,  -49,  -53,  -50,  -43,  -19,    6,   10,   25,   66,   91,
      84,   67,   60,   36,    1,  -18,  -10,   27,   48,   52,   42,   42,   38,   25,   -3,  -18,
      -5,   -2,  -13,  -22,  -24,  -28,  -35,  -45,  -35,   -4,   14,  -17,  -41,  -36,  -33,  -35,
     -41,  -29,  -20,  -38,  -51,  -54,  -46,  -33,  -14,    6,   14,   37,   74,   87,   76,   65,
      64,   29,   -9,  -22,   -7,   23,   52,   55,   46,   42,   25,   17,   -5,  -12,   -4,   -3,
     -17,  -25,  -33,  -36,  -33,  -39,  -30,    5,   12,  -25,  -37,  -33,  -34,  -42,  -41,  -25,
     -22,  -41,  -52,  -53,  -40,  -25,  -10,   11,   21,   43,   72,   78,   74,   69,   58,   15,
     -13,  -15,   -4,   22,   54,   58,   53,   41,   15,    6,   -2,   -1,   -3,   -6,  -18,  -24,
     -42,  -40,  -29,  -32,  -20,   13,    8,  -25,  -35,  -34,  -29,  -42,  -43,  -27,  -27,  -42,
     -51,  -50,  -30,  -14,   -5,   17,   26,   46,   70,   72,   72,   69,   48,    2,  -13,   -9,
      -3,   19,   55,   59,   53,   30,    1,   -1,    5,    8,   -7,  -15,  -19,  -25,  -48,  -45,
     -31,  -28,  -10,   15,    1,  -24,  -35,  -35,  -22,  -37,  -43,  -36,  -35,  -41,  -47,  -45,
     -18,   -6,   -1,   24,   32,   51,   65,   65,   67,   63,   37,   -3,  -13,   -9,    1,   29,
      54,   60,   50,   18,   -4,   -4,   13,    9,  -10,  -15,  -17,  -30,  -54,  -47,  -29,  -20,
      -8,    4,   -8,  -15,  -29,  -35,  -21,  -37,  -43,  -46,  -37,  -33,  -48,  -39,  -10,    3,
      13,   31,   34,   54,   56,   57,   63,   56,   32,   -3,  -16,   -6,   14,   38,   48,   53,
      40,   11,   -3,    1,    6,   -2,  -11,   -9,  -11,  -28,  -54,  -54,  -29,   -8,    2,   -8,
     -16,  -13,  -27,  -31,  -21,  -32,  -45,  -54,  -36,  -27,  -44,  -33,    1,   16,   25,   29,
      39,   56,   48,   51,   57,   48,   22,    3,  -14,    0,   22,   39,   42,   46,   36,    7,
      -7,    0,    0,   -3,   -8,   -8,  -15,  -34,  -50,  -49,  -27,   -3,    0,  -15,  -14,  -16,
     -28,  -26,  -21,  -34,  -56,  -55,  -32,  -30,  -41,  -23,    8,   20,   31,   33,   45,   53,
      38,   42,   54,   40,   18,   -3,   -9,   14,   33,   37,   34,   34,   27,    8,   -5,   -1,
      -9,   -3,   -1,   -8,  -19,  -35,  -43,  -42,  -28,   -7,    1,  -18,  -13,  -17,  -29,  -24,
     -21,  -34,  -55,  -52,  -34,  -30,  -26,   -9,   15,   28,   28,   32,   55,   50,   29,   38,
      45,   35,   17,   -3,   -1,   18,   36,   40,   27,   24,   19,    0,   -5,   -1,  -14,   -7,
      -2,  -12,  -20,  -30,  -40,  -42,  -25,   -5,   -5,  -24,  -14,  -16,  -25,  -20,  -26,  -38,
     -52,  -49,  -35,  -31,  -13,    8,   16,   28,   29,   42,   57,   40,   23,   32,   35,   30,
      12,   -5,    9,   22,   40,   38,   19,   17,   16,   -1,   -9,   -7,  -12,   -6,   -5,  -13,
     -18,  -29,  -39,  -39,  -18,   -3,  -19,  -26,  -11,  -18,  -24,  -19,  -30,  -40,  -51,  -45,
     -30,  -24,    0,   19,   22,   28,   36,   49,   54,   41,   22,   30,   31,   26,   10,    2,
      10,   26,   43,   28,   14,   16,    7,   -6,  -12,   -9,   -9,   -5,  -12,  -19,  -16,  -29,
     -35,  -34,   -8,   -8,  -35,  -20,   -7,  -26,  -23,  -23,  -30,  -39,  -53,  -38,  -25,  -12,
      11,   24,   24,   29,   47,   50,   48,   36,   20,   29,   24,   15,    5,    8,   12,   32,
      40,   21,   17,   11,    0,   -3,  -15,  -14,   -7,   -4,  -13,  -17,  -16,  -28,  -31,  -23,
      -6,  -20,  -37,  -15,  -12,  -29,  -22,  -28,  -30,  -38,  -54,  -34,  -20,   -4,   21,   33,
      24,   33,   50,   45,   40,   33,   27,   28,   14,    8,    8,   11,   11,   30,   33,   26,
      20,   -1,   -8,   -4,  -17,  -16,   -2,   -7,  -22,  -20,  -20,  -26,  -26,  -15,  -10,  -27,
     -35,  -12,  -19,  -31,  -21,  -23,  -23,  -42,  -57,  -31,  -11,    9,   35,   33,   23,   39,
      53,   47,   40,   31,   31,   21,   10,    9,   11,   10,   13,   26,   35,   33,   13,  -11,
     -10,   -4,  -19,  -22,    3,   -2,  -28,  -26,  -16,  -21,  -24,  -12,  -12,  -31,  -34,  -17,
     -27,  -34,  -25,  -17,  -19,  -48,  -59,  -29,   -2,   27,   46,   26,   22,   43,   54,   44,
      38,   30,   29,   16,    6,   15,   15,    6,    9,   22,   36,   37,    9,  -20,  -10,   -5,
     -21,  -21,    2,   -5,  -29,  -31,  -18,  -11,  -17,  -11,  -15,  -32,  -34,  -23,  -30,  -30,
     -25,  -15,  -22,  -52,  -50,  -17,    9,   36,   42,   26,   29,   50,   53,   40,   33,   32,
      27,   14,    7,    9,    7,    4,   12,   22,   36,   36,    3,  -27,  -16,   -9,  -20,  -21,
      -1,  -12,  -31,  -27,  -13,  -12,  -18,  -12,  -17,  -33,  -39,  -29,  -34,  -35,  -23,   -7,
     -25,  -55,  -42,  -10,   20,   43,   40,   27,   33,   51,   51,   37,   34,   31,   21,    9,
       8,    5,    2,   11,   16,   18,   34,   35,    3,  -22,  -17,  -16,  -20,  -17,   -7,  -20,
     -32,  -28,  -14,  -12,  -10,   -8,  -17,  -34,  -41,  -35,  -34,  -31,  -19,   -8,  -27,  -48,
     -29,   -4,   26,   50,   44,   32,   37,   50,   49,   40,   36,   22,   11,   11,   12,    5,
       3,   14,   12,   13,   34,   37,    9,  -23,  -24,  -16,  -21,  -16,  -17,  -30,  -27,  -27,
     -20,  -10,  -10,   -9,  -18,  -39,  -46,  -42,  -35,  -31,  -14,   -9,  -33,  -42,  -19,    1,
      36,   55,   41,   32,   46,   55,   47,   35,   32,   18,    6,    7,    9,   -2,    7,   17,
       8,   13,   34,   32,   10,  -22,  -27,  -14,  -20,  -21,  -26,  -31,  -23,  -27,  -22,   -6,
      -5,  -11,  -21,  -39,  -46,  -46,  -37,  -30,  -14,  -12,  -33,  -31,   -8,    6,   41,   55,
      40,   38,   54,   57,   39,   30,   33,   17,    2,    1,    4,    7,   14,   14,   -2,   11,
      37,   31,   11,  -26,  -30,  -16,  -20,  -18,  -21,  -27,  -32,  -28,  -12,    0,   -4,  -11,
     -23,  -40,  -46,  -43,  -33,  -26,  -16,  -15,  -29,  -19,   -1,   13,   44,   58,   41,   49,
      68,   59,   36,   28,   36,   18,   -9,   -9,    4,   17,   20,    7,   -6,   18,   36,   22,
      -1,  -30,  -26,  -19,  -25,  -26,  -31,  -35,  -33,  -21,   -3,   -8,  -10,  -14,  -24,  -40,
     -45,  -43,  -35,  -20,  -18,  -20,  -22,  -12,    0,   15,   48,   58,   41,   58,   77,   57,
      30,   27,   33,    7,  -23,  -16,   11,   23,   21,    2,   -5,   24,   33,   10,  -10,  -24,
     -19,  -25,  -37,  -30,  -30,  -34,  -29,  -14,   -5,  -16,   -8,   -8,  -26,  -50,  -47,  -41,
     -30,  -16,  -25,  -24,  -14,   -6,    3,   23,   50,   51,   49,   69,   81,   56,   29,   33,
      30,   -2,  -29,  -14,   15,   26,   18,    2,   -1,   31,   28,    0,  -20,  -21,  -21,  -32,
     -43,  -34,  -33,  -36,  -23,   -4,   -8,  -20,   -8,  -11,  -25,  -44,  -41,  -39,  -32,  -17,
     -30,  -22,   -4,    1,    6,   31,   48,   47,   63,   80,   82,   52,   31,   38,   23,  -13,
     -33,  -11,   20,   29,   14,   -1,    9,   34,   19,  -12,  -26,  -13,  -23,  -46,  -46,  -38,
     -39,  -35,  -24,   -3,   -7,  -17,  -15,  -16,  -25,  -45,  -37,  -37,  -33,  -26,  -36,  -20,
       5,    3,    4,   32,   42,   50,   76,   83,   75,   49,   34,   36,   17,  -24,  -33,  -12,
      23,   32,   10,    1,   23,   30,    7,  -17,  -22,   -8,  -27,  -49,  -50,  -42,  -38,  -28,
     -18,   -3,   -8,  -13,  -14,  -15,  -24,  -43,  -35,  -33,  -29,  -27,  -34,  -15,   16,    8,
       5,   32,   43,   62,   84,   84,   73,   53,   40,   30,    6,  -26,  -34,  -15,   25,   28,
       8,    9,   38,   27,   -4,  -26,  -21,  -12,  -33,  -54,  -47,  -48,  -38,  -21,  -14,   -2,
      -3,  -11,  -25,  -18,  -26,  -32,  -34,  -34,  -29,  -31,  -35,  -10,   18,   11,    7,   33,
      47,   68,   83,   81,   71,   58,   42,   20,   -5,  -25,  -36,  -15,   23,   23,    7,   20,
      40,   21,  -14,  -35,  -21,  -16,  -40,  -58,  -52,  -52,  -31,  -11,   -9,   -6,   -1,  -15,
     -26,  -15,  -29,  -31,  -36,  -31,  -29,  -36,  -32,   -4,   17,    8,   15,   36,   48,   66,
      77,   83,   77,   59,   38,    9,  -11,  -20,  -34,  -12,   22,   20,   14,   33,   39,   16,
     -22,  -36,  -23,  -21,  -40,  -56,  -52,  -47,  -24,  -10,   -4,    3,    1,  -17,  -22,  -18,
     -28,  -26,  -32,  -30,  -32,  -30,  -22,    1,   15,   15,   27,   42,   52,   62,   75,   85,
      80,   59,   35,    1,  -16,  -20,  -35,  -12,   18,   17,   18,   40,   34,    5,  -34,  -38,
     -27,  -28,  -42,  -60,  -58,  -48,  -18,   -4,    0,    3,   -4,  -18,  -20,  -22,  -35,  -29,
     -27,  -34,  -42,  -28,  -12,    3,    8,   19,   31,   40,   45,   60,   75,   79,   76,   62,
      37,   -2,  -20,  -22,  -31,  -11,   13,   15,   31,   43,   27,    0,  -28,  -33,  -36,  -37,
     -43,  -58,  -61,  -47,  -13,    1,    1,    3,   -5,  -12,  -17,  -25,  -36,  -27,  -25,  -39,
     -45,  -24,    1,    0,    8,   25,   43,   45,   42,   57,   76,   76,   73,   60,   37,   -8,
     -25,  -22,  -25,   -6,    9,   21,   41,   41,   15,   -6,  -18,  -33,  -48,  -40,  -38,  -57,
     -64,  -46,   -6,    9,   -4,    1,   -1,   -9,  -18,  -28,  -33,  -24,  -27,  -42,  -45,  -18,
       2,    3,   13,   31,   49,   43,   37,   60,   74,   68,   68,   60,   30,  -12,  -28,  -23,
     -19,   -8,    5,   26,   48,   37,   11,  -12,  -17,  -37,  -54,  -40,  -41,  -58,  -65,  -42,
       5,   12,   -8,    0,    2,   -6,  -22,  -29,  -30,  -28,  -37,  -44,  -42,   -9,    6,    7,
      17,   33,   44,   42,   40,   61,   72,   57,   63,   61,   24,  -16,  -34,  -21,  -15,  -12,
       3,   31,   47,   28,    7,  -10,  -15,  -43,  -51,  -38,  -45,  -61,  -61,  -31,   10,    8,
      -3,    6,    5,   -8,  -24,  -27,  -28,  -31,  -44,  -42,  -29,   -3,    6,   10,   24,   40,
      44,   45,   46,   57,   62,   56,   65,   56,   16,  -13,  -32,  -18,  -12,  -10,   11,   32,
      39,   25,    6,  -10,  -19,  -48,  -44,  -38,  -49,  -63,  -61,  -19,   12,    3,    4,    6,
       3,   -9,  -25,  -26,  -27,  -38,  -46,  -39,  -18,    1,   12,   20,   29,   33,   36,   49,
      47,   54,   59,   49,   63,   51,    8,  -12,  -25,  -18,  -18,   -6,   20,   33,   28,   19,
       4,   -9,  -27,  -43,  -41,  -45,  -55,  -64,  -51,  -13,    7,   -3,    0,    7,    3,  -12,
     -28,  -27,  -33,  -46,  -51,  -33,  -10,   -5,   15,   31,   34,   26,   32,   47,   51,   53,
      47,   50,   61,   41,    1,   -8,  -12,  -21,  -20,    5,   27,   29,   16,   13,    8,   -9,
     -28,  -40,  -40,  -44,  -55,  -62,  -40,   -8,    5,   -2,    4,   11,    4,  -15,  -26,  -26,
     -37,  -49,  -47,  -27,   -8,   -3,   22,   45,   38,   22,   34,   47,   55,   52,   39,   44,
      58,   32,    2,    0,   -7,  -25,  -21,   10,   29,   30,    9,    0,    0,   -7,  -26,  -38,
     -40,  -53,  -61,  -53,  -30,   -5,    1,   -2,    5,   10,    3,  -18,  -25,  -33,  -43,  -51,
     -46,  -20,  -10,   -8,   26,   52,   35,   19,   32,   47,   56,   46,   33,   44,   48,   20,
      10,   11,   -7,  -29,  -20,   15,   35,   28,    2,   -9,   -8,   -6,  -26,  -32,  -36,  -54,
     -64,  -52,  -22,    1,    3,    2,    3,   15,    2,  -22,  -24,  -34,  -41,  -45,  -39,  -19,
      -9,    1,   35,   57,   37,   18,   27,   46,   52,   41,   37,   44,   40,   18,   16,   13,
      -7,  -29,  -14,   23,   36,   17,   -6,  -17,   -2,    1,  -24,  -38,  -43,  -59,  -62,  -44,
     -22,   -4,    7,    2,    5,   16,   -2,  -24,  -27,  -36,  -43,  -48,  -37,  -20,   -5,   14,
      40,   52,   36,   20,   26,   43,   46,   40,   41,   42,   28,   19,   19,    9,   -4,  -21,
     -10,   27,   32,   10,   -6,  -16,   -4,   -5,  -14,  -37,  -48,  -59,  -58,  -36,  -24,   -1,
      13,   -3,    7,   16,   -5,  -19,  -32,  -38,  -46,  -43,  -32,  -22,   -7,   22,   49,   57,
      37,   22,   20,   37,   41,   36,   46,   41,   21,   19,   16,    9,   -2,  -25,   -9,   27,
      24,    8,  -12,  -11,   -2,   -9,  -10,  -39,  -51,  -59,  -59,  -35,  -21,    2,   15,   -5,
      10,   11,  -12,  -19,  -35,  -39,  -46,  -35,  -29,  -26,   -5,   37,   60,   53,   36,   26,
      19,   33,   37,   33,   48,   41,   18,   17,   19,   11,   -8,  -23,   -3,   30,   21,   -5,
     -14,   -2,   -6,   -9,   -9,  -42,  -59,  -64,  -54,  -33,  -16,    6,   14,    0,   15,    4,
     -14,  -17,  -35,  -45,  -46,  -33,  -27,  -22,    2,   42,   56,   49,   37,   26,   19,   26,
      23,   36,   58,   44,   11,    8,   23,   10,   -7,  -15,    3,   26,   12,  -10,   -8,    3,
     -10,   -7,  -13,  -46,  -58,  -60,  -57,  -40,  -11,    9,    9,    3,   13,   -6,  -12,  -17,
     -42,  -53,  -45,  -28,  -23,  -14,   11,   49,   60,   49,   40,   27,   14,   16,   13,   43,
      62,   46,    6,    8,   22,    7,   -9,  -10,   11,   23,    4,  -17,    2,    6,   -6,   -7,
     -21,  -51,  -58,  -58,  -55,  -38,  -12,   12,   10,   13,    1,  -15,   -7,  -14,  -47,  -62,
     -45,  -29,  -19,   -2,   21,   51,   63,   46,   37,   31,   16,    0,    4,   43,   64,   43,
       6,    9,   24,    4,  -15,   -2,   14,    9,   -9,  -15,   14,    7,  -11,  -10,  -29,  -53,
     -54,  -57,  -48,  -35,   -9,   13,    9,   11,   -5,   -6,   -2,  -22,  -57,  -60,  -39,  -24,
     -11,    5,   30,   52,   62,   49,   42,   38,   11,   -9,    7,   45,   61,   44,   10,   15,
      21,   -4,  -15,    3,   13,    1,  -13,   -9,   13,    7,   -9,  -13,  -32,  -51,  -53,  -56,
     -44,  -35,   -9,   15,   11,    7,   -8,    0,   -2,  -34,  -65,  -56,  -31,  -24,   -7,   20,
      37,   49,   56,   47,   47,   39,   -3,  -16,   12,   40,   53,   45,   16,   23,   17,   -7,
      -8,    7,    8,   -5,  -12,   -7,    7,    7,   -4,  -17,  -38,  -56,  -60,  -50,  -37,  -33,
      -8,    7,    9,    0,   -6,    7,   -8,  -47,  -71,  -50,  -25,  -23,    0,   33,   41,   46,
      52,   53,   54,   35,   -6,   -9,   13,   32,   50,   48,   23,   25,   13,   -4,   -3,    0,
      -1,   -7,   -7,   -8,    3,    6,   -3,  -22,  -41,  -55,  -62,  -46,  -30,  -24,   -5,    0,
       5,    2,    3,   10,  -20,  -57,  -69,  -41,  -19,  -16,    5,   37,   47,   46,   49,   54,
      58,   29,   -4,   -6,    7,   21,   49,   49,   24,   24,   12,   -2,   -5,   -9,    0,    0,
     -10,  -15,    2,    8,   -4,  -23,  -42,  -57,  -66,  -43,  -22,  -16,  -11,   -8,    3,    5,
       7,    4,  -28,  -61,  -61,  -36,  -19,  -11,   10,   45,   51,   43,   46,   52,   54,   26,
       3,   -8,   -3,   15,   52,   48,   27,   30,   15,   -1,   -9,  -14,    0,   -2,  -15,  -17,
      -2,   -1,   -5,  -23,  -37,  -62,  -64,  -34,  -17,  -15,  -19,   -8,    4,    7,    8,   -8,
     -37,  -55,  -50,  -33,  -19,   -5,   16,   49,   54,   44,   45,   52,   53,   32,    3,  -12,
      -5,   14,   46,   46,   38,   34,   21,    6,  -13,  -21,   -2,   -3,  -18,  -19,  -14,   -9,
      -2,  -14,  -44,  -74,  -56,  -26,  -15,  -16,  -18,   -6,   -1,    7,    6,  -20,  -43,  -48,
     -35,  -32,  -24,    1,   23,   51,   54,   41,   42,   52,   49,   32,    3,  -14,   -5,   19,
      42,   47,   43,   38,   27,   10,  -18,  -19,   -5,   -7,  -18,  -27,  -23,   -9,    2,   -8,
     -51,  -75,  -41,  -19,  -15,  -13,  -15,  -11,   -5,   10,    1,  -30,  -37,  -40,  -30,  -33,
     -24,    6,   30,   49,   49,   45,   43,   52,   39,   24,    7,  -10,   -7,   12,   33,   44,
      48,   43,   36,    7,  -29,  -18,   -6,  -14,  -23,  -36,  -32,  -12,    2,  -16,  -60,  -65,
     -27,  -22,  -22,   -9,   -6,  -14,   -6,   11,  -10,  -38,  -35,  -27,  -26,  -35,  -15,   18,
      39,   47,   48,   51,   55,   51,   28,   22,   13,   -5,   -6,    5,   27,   46,   57,   49,
      39,    1,  -29,  -12,   -7,  -15,  -28,  -48,  -39,  -11,   -1,  -28,  -61,  -51,  -22,  -30,
     -22,   -3,   -4,  -21,   -6,    8,  -23,  -45,  -29,  -18,  -27,  -32,  -11,   24,   44,   40,
      46,   56,   61,   44,   17,   18,   19,    1,  -11,   -2,   24,   48,   57,   54,   45,    2,
     -27,  -12,  -11,  -18,  -32,  -49,  -41,  -16,  -10,  -32,  -47,  -33,  -25,  -34,  -13,    6,
      -5,  -24,  -13,   -4,  -29,  -43,  -29,  -18,  -25,  -21,   -1,   25,   44,   40,   49,   67,
      60,   31,   12,   18,   24,   -2,  -18,   -5,   22,   45,   62,   65,   46,   -5,  -21,  -12,
     -12,  -17,  -36,  -57,  -48,  -23,  -15,  -29,  -35,  -28,  -33,  -31,   -3,   12,  -16,  -32,
     -12,  -19,  -36,  -33,  -25,  -22,  -29,  -10,   14,   30,   41,   35,   51,   73,   57,   27,
      16,   21,   14,   -4,  -12,   -2,   21,   41,   62,   71,   43,   -7,  -12,  -19,  -22,  -23,
     -46,  -57,  -51,  -35,  -20,  -17,  -22,  -26,  -37,  -27,    7,   12,  -24,  -31,  -14,  -29,
     -34,  -30,  -22,  -20,  -21,    2,   15,   26,   40,   45,   55,   66,   52,   28,   20,   17,
      10,   -1,  -12,   -4,   21,   43,   65,   74,   39,    1,   -9,  -25,  -27,  -24,  -45,  -61,
     -55,  -43,  -22,   -9,  -12,  -24,  -32,  -26,    9,    7,  -25,  -31,  -30,  -40,  -31,  -26,
     -19,  -20,  -11,   14,   18,   27,   45,   54,   52,   61,   49,   33,   24,   15,    5,    0,
     -14,   -2,   24,   44,   62,   67,   37,   12,   -9,  -30,  -29,  -33,  -49,  -66,  -58,  -51,
     -25,   -2,   -6,  -19,  -31,  -24,    6,    3,  -21,  -37,  -43,  -42,  -31,  -25,  -17,  -19,
      -5,   15,   19,   30,   52,   56,   45,   54,   52,   38,   22,   11,    8,    0,  -16,    2,
      27,   44,   63,   60,   34,   16,  -10,  -25,  -31,  -38,  -55,  -68,  -62,  -53,  -18,    5,
      -2,  -17,  -31,  -16,    5,   -4,  -22,  -43,  -50,  -38,  -32,  -21,  -16,  -11,    8,   10,
      19,   32,   60,   60,   43,   46,   51,   37,   24,   13,    8,   -6,  -17,    4,   32,   52,
      56,   52,   39,   23,   -5,  -23,  -41,  -48,  -64,  -65,  -63,  -57,  -14,    9,    3,  -18,
     -28,   -9,    0,  -11,  -25,  -47,  -53,  -38,  -30,  -19,  -11,    0,   10,   11,   23,   42,
      66,   60,   42,   49,   53,   36,   24,   20,    9,  -17,  -18,    3,   39,   59,   49,   41,
      39,   26,    1,  -24,  -53,  -59,  -70,  -61,  -66,  -58,  -12,   17,    7,  -20,  -26,   -7,
      -7,  -16,  -30,  -51,  -60,  -45,  -26,  -11,   -5,    5,    8,   10,   23,   48,   66,   55,
      40,   48,   48,   33,   30,   25,    2,  -21,  -15,   10,   41,   51,   44,   37,   41,   27,
       6,  -28,  -60,  -65,  -70,  -63,  -70,  -55,   -6,   21,    1,  -20,  -15,   -2,  -15,  -24,
     -32,  -54,  -66,  -45,  -22,   -8,    6,   13,    5,   15,   31,   51,   64,   58,   41,   42,
      44,   35,   36,   29,    0,  -20,   -9,   14,   43,   53,   46,   39,   39,   24,    7,  -33,
     -69,  -75,  -73,  -70,  -75,  -46,    4,   17,   -2,  -18,   -6,    3,  -18,  -32,  -38,  -61,
     -65,  -39,  -17,   -2,   10,   10,    5,   19,   33,   55,   61,   54,   39,   40,   41,   41,
      40,   30,   -6,  -25,   -6,   22,   44,   48,   42,   42,   37,   23,   11,  -42,  -73,  -77,
     -75,  -74,  -75,  -39,    4,    8,   -5,  -15,    1,   -1,  -30,  -33,  -38,  -69,  -66,  -40,
     -14,    3,   16,    8,    5,   21,   39,   60,   59,   48,   40,   38,   39,   42,   42,   30,
      -8,  -20,    0,   26,   48,   51,   48,   43,   29,   21,    1,  -47,  -70,  -80,  -83,  -80,
     -70,  -25,    0,   -2,   -9,   -6,    9,   -7,  -29,  -33,  -49,  -72,  -59,  -29,   -3,    3,
      11,    6,   14,   27,   47,   61,   54,   47,   43,   34,   42,   45,   39,   21,  -10,  -17,
       4,   29,   53,   54,   47,   39,   29,   22,  -11,  -53,  -70,  -83,  -86,  -77,  -61,  -19,
      -6,   -7,  -12,   -2,    9,  -14,  -29,  -35,  -61,  -70,  -54,  -25,   -8,    2,   11,    8,
      17,   27,   54,   60,   50,   45,   42,   40,   43,   39,   35,   18,   -9,   -7,    8,   28,
      55,   56,   49,   32,   30,   15,  -21,  -53,  -71,  -88,  -87,  -74,  -45,  -12,  -11,  -15,
     -14,    6,   12,  -12,  -30,  -48,  -66,  -60,  -44,  -18,   -8,    5,   13,   15,   21,   31,
      51,   57,   48,   43,   42,   40,   43,   37,   29,   16,   -3,   -1,    7,   35,   60,   54,
      38,   26,   29,    5,  -30,  -54,  -72,  -93,  -87,  -69,  -34,  -14,  -19,  -25,  -12,   13,
       6,  -17,  -37,  -56,  -66,  -49,  -38,  -18,  -11,    1,   17,   24,   26,   32,   47,   52,
      50,   49,   45,   39,   40,   33,   32,   13,    4,    3,    3,   47,   65,   52,   29,   27,
      20,   -5,  -35,  -56,  -76,  -90,  -79,  -63,  -27,  -17,  -26,  -24,    0,   12,   -2,  -16,
     -33,  -61,  -61,  -42,  -33,  -17,  -16,   -6,   22,   30,   25,   29,   45,   50,   46,   53,
      41,   37,   37,   33,   28,   17,   15,    2,   15,   54,   64,   46,   21,   25,    9,  -12,
     -39,  -58,  -77,  -87,  -75,  -46,  -21,  -23,  -34,  -24,    9,    9,   -7,  -17,  -40,  -67,
     -53,  -33,  -27,  -22,  -26,   -4,   34,   34,   25,   27,   46,   44,   52,   59,   37,   30,
      35,   32,   26,   25,   16,    2,   30,   62,   57,   33,   19,   17,   -7,  -25,  -43,  -58,
     -80,  -82,  -64,  -36,  -26,  -26,  -33,  -17,   11,    4,   -9,  -18,  -45,  -62,  -44,  -30,
     -24,  -28,  -29,    5,   38,   32,   25,   30,   48,   41,   53,   57,   35,   28,   26,   27,
      31,   29,   14,   12,   47,   63,   48,   35,   24,    4,  -19,  -32,  -46,  -55,  -76,  -77,
     -58,  -31,  -30,  -33,  -36,   -8,   12,   -4,   -9,  -22,  -51,  -57,  -30,  -23,  -27,  -40,
     -31,   18,   36,   31,   30,   33,   39,   36,   56,   51,   32,   27,   20,   24,   39,   30,
      16,   29,   55,   53,   43,   36,   21,   -5,  -28,  -39,  -45,  -55,  -71,  -70,  -47,  -27,
     -35,  -36,  -25,   -2,    1,   -4,   -6,  -23,  -48,  -48,  -25,  -16,  -25,  -46,  -23,   24,
      30,   35,   34,   29,   33,   37,   51,   41,   30,   21,   12,   27,   47,   33,   19,   38,
      51,   43,   39,   36,   15,  -17,  -35,  -35,  -42,  -55,  -68,  -62,  -45,  -33,  -40,  -36,
     -19,   -5,   -4,   -3,   -6,  -24,  -47,  -38,  -17,  -13,  -37,  -48,  -13,   26,   30,   36,
      32,   27,   29,   36,   48,   38,   27,    9,    5,   34,   47,   31,   30,   49,   47,   36,
      38,   28,   11,  -21,  -32,  -32,  -47,  -56,  -60,  -54,  -40,  -39,  -42,  -31,  -12,   -5,
      -7,   -1,   -4,  -21,  -39,  -28,  -11,  -13,  -45,  -42,   -2,   23,   25,   42,   33,   26,
      26,   33,   44,   34,   20,    1,    5,   36,   47,   38,   40,   47,   37,   35,   38,   20,
       1,  -23,  -26,  -35,  -49,  -56,  -55,  -48,  -40,  -46,  -42,  -28,  -12,  -12,  -10,    2,
      -6,  -25,  -32,  -25,  -13,  -22,  -43,  -30,    5,   18,   24,   45,   35,   29,   21,   27,
      39,   28,   16,    2,    9,   39,   40,   44,   55,   45,   25,   31,   34,   15,   -1,  -18,
     -25,  -41,  -49,  -50,  -52,  -46,  -42,  -48,  -40,  -23,   -9,  -18,  -13,    9,   -1,  -24,
     -27,  -22,  -14,  -30,  -41,  -26,    8,   15,   25,   40,   36,   26,   15,   26,   35,   21,
      11,    2,   17,   44,   37,   54,   63,   37,   16,   31,   27,   12,   -3,  -12,  -24,  -45,
     -47,  -46,  -45,  -40,  -44,  -55,  -40,  -17,  -12,  -22,   -7,   19,   -2,  -22,  -24,  -15,
     -17,  -36,  -36,  -11,   16,   10,   17,   38,   43,   25,   15,   25,   26,   14,    7,    2,
      25,   39,   38,   63,   67,   30,   16,   25,   18,   14,   -5,   -9,  -26,  -43,  -45,  -47,
     -42,  -38,  -52,  -57,  -35,  -14,  -22,  -27,    0,   23,   -5,  -24,  -22,  -12,  -21,  -40,
     -31,    1,   19,    6,   11,   35,   44,   22,   18,   28,   14,    4,    4,   11,   32,   34,
      38,   70,   68,   22,   18,   17,   15,   17,    0,  -10,  -31,  -45,  -43,  -42,  -34,  -36,
     -62,  -61,  -25,  -11,  -28,  -29,    3,   25,   -3,  -26,  -15,  -12,  -28,  -34,  -21,    9,
      17,    2,   10,   31,   40,   24,   23,   28,    5,   -3,    6,   19,   35,   33,   42,   72,
      59,   22,   22,   12,   17,   17,    2,  -11,  -31,  -40,  -40,  -36,  -28,  -40,  -66,  -57,
     -18,  -15,  -32,  -22,    9,   22,   -3,  -23,   -8,  -12,  -31,  -32,  -12,   18,   15,   -1,
       9,   25,   36,   26,   27,   20,   -7,   -5,   12,   23,   29,   33,   45,   70,   48,   25,
      20,    8,   16,    9,    4,  -11,  -33,  -39,  -37,  -34,  -30,  -46,  -65,  -50,  -23,  -22,
     -30,  -19,   13,   22,   -4,  -21,   -6,  -15,  -32,  -28,   -3,   18,    9,    0,    9,   21,
      30,   28,   30,   12,  -14,   -1,   17,   19,   27,   41,   51,   63,   35,   28,   22,   12,
      10,    6,    9,  -14,  -31,  -36,  -31,  -27,  -38,  -49,  -62,  -48,  -29,  -25,  -27,  -13,
      13,   13,   -3,   -9,   -9,  -21,  -30,  -20,    4,   12,    4,    5,   12,   19,   27,   33,
      29,    6,  -12,    2,   21,   17,   31,   45,   54,   55,   31,   31,   25,   14,    3,    5,
      11,  -14,  -27,  -33,  -24,  -27,  -41,  -49,  -63,  -53,  -37,  -26,  -22,   -7,   11,    8,
       0,   -3,  -14,  -19,  -27,  -14,    8,    5,    2,    9,   12,   20,   25,   31,   18,    0,
      -6,    8,   20,   14,   27,   43,   59,   48,   24,   28,   25,   14,    2,    8,    6,  -15,
     -26,  -30,  -16,  -28,  -44,  -53,  -61,  -58,  -37,  -27,  -21,   -4,    8,    3,    1,   -2,
     -18,  -21,  -24,  -11,    3,   -4,    3,   15,   17,   20,   22,   29,   15,    3,   -2,    8,
      17,   18,   30,   46,   56,   40,   21,   29,   26,   14,   -1,    5,    4,   -6,  -22,  -29,
     -13,  -27,  -46,  -51,  -62,  -61,  -37,  -28,  -14,    2,    7,    0,    5,   -2,  -16,  -17,
     -19,  -10,   -7,   -9,   11,   20,   22,   18,   17,   25,   19,    4,   -1,   10,   19,   25,
      32,   44,   53,   36,   19,   29,   24,   10,   -4,    5,    4,   -2,  -22,  -24,  -13,  -31,
     -48,  -56,  -63,  -60,  -40,  -31,  -11,    8,    8,    2,    8,   -6,  -20,  -17,  -12,  -10,
     -20,  -12,   14,   30,   26,   10,   14,   24,   24,   -1,   -7,   12,   25,   27,   30,   40,
      52,   34,   17,   28,   24,    7,   -9,    1,    8,    3,  -20,  -20,  -16,  -33,  -53,  -59,
     -62,  -61,  -47,  -29,   -5,   15,    5,    1,    9,   -8,  -20,  -14,   -5,  -12,  -30,  -11,
      20,   37,   25,   10,   19,   25,   19,   -5,   -2,   18,   28,   26,   29,   41,   49,   31,
      20,   30,   24,    1,   -8,    4,   10,    3,  -17,  -12,  -18,  -40,  -57,  -61,  -62,  -59,
     -48,  -23,    0,   18,    5,    5,   12,   -9,  -19,   -9,   -2,  -20,  -37,   -7,   25,   39,
      23,   11,   25,   26,   10,  -10,    5,   23,   24,   26,   30,   40,   42,   27,   23,   31,
      18,   -7,   -5,    2,    7,   -1,  -10,  -10,  -22,  -45,  -59,  -63,  -62,  -58,  -45,  -21,
      -1,   17,   10,   13,    7,  -18,  -21,   -5,   -3,  -27,  -38,   -7,   26,   38,   21,   20,
      31,   23,    0,   -9,   15,   25,   21,   28,   33,   35,   35,   29,   28,   31,   12,   -5,
       0,    0,    4,    0,   -3,  -14,  -27,  -48,  -57,  -69,  -66,  -61,  -40,  -19,    1,   16,
      13,   16,   -3,  -18,  -17,   -4,   -9,  -30,  -33,   -1,   24,   35,   28,   34,   31,   16,
      -4,   -2,   22,   29,   20,   27,   38,   33,   30,   30,   31,   33,    9,    1,   -3,   -7,
       2,    6,   -1,  -22,  -31,  -50,  -61,  -74,  -67,  -52,  -34,  -25,    1,   19,   21,   14,
      -8,  -18,  -14,  -10,  -14,  -27,  -26,   -5,   21,   35,   38,   40,   31,   12,   -1,    5,
      22,   29,   19,   31,   41,   28,   30,   28,   31,   28,   12,    7,  -13,  -11,   -2,   13,
      -5,  -26,  -32,  -52,  -67,  -80,  -65,  -46,  -34,  -26,    2,   15,   25,    9,   -8,  -14,
     -16,  -10,  -18,  -25,  -25,   -9,   20,   37,   46,   35,   26,   10,    7,    8,   18,   27,
      18,   31,   39,   25,   29,   29,   34,   26,   20,    2,  -18,  -10,   -5,   12,   -9,  -22,
     -31,  -48,  -74,  -79,  -66,  -42,  -34,  -22,   -1,   14,   25,   13,   -6,  -19,  -16,   -8,
     -19,  -22,  -21,   -5,   21,   41,   51,   32,   25,   14,   19,   13,   14,   21,   21,   32,
      34,   26,   26,   30,   32,   25,   25,   -3,  -19,  -13,   -2,    8,  -12,  -24,  -32,  -46,
     -75,  -79,  -67,  -43,  -33,  -18,   -7,   12,   25,   18,    0,  -23,  -13,   -7,  -23,  -18,
     -15,   -4,   21,   48,   51,   27,   27,   23,   22,   12,   12,   19,   22,   28,   28,   28,
      28,   31,   28,   23,   28,   -3,  -20,  -22,   -5,    0,  -14,  -23,  -28,  -50,  -78,  -81,
     -63,  -44,  -34,  -19,  -14,   10,   25,   18,   -6,  -19,   -5,  -11,  -30,  -17,   -8,    2,
      21,   54,   45,   25,   28,   33,   25,    9,   12,   21,   26,   23,   24,   33,   37,   35,
      20,   23,   32,   -1,  -21,  -25,  -12,  -11,  -12,  -19,  -27,  -53,  -78,  -79,  -55,  -42,
     -31,  -26,  -18,   12,   24,   13,   -9,  -12,    0,  -20,  -33,  -13,    1,    6,   26,   55,
      38,   25,   33,   45,   26,    7,   13,   21,   26,   16,   18,   38,   44,   33,   14,   25,
      30,    4,  -24,  -32,  -21,  -18,  -19,  -19,  -25,  -54,  -79,  -78,  -53,  -43,  -29,  -28,
     -20,    6,   20,   12,   -3,    0,   -3,  -35,  -28,    1,    9,    8,   25,   46,   34,   30,
      37,   44,   19,   13,   20,   17,   20,   12,   18,   49,   49,   23,   13,   28,   33,    3,
     -34,  -37,  -28,  -30,  -21,  -10,  -26,  -57,  -77,  -74,  -52,  -40,  -25,  -32,  -22,    3,
      17,   12,    3,    8,  -15,  -40,  -18,   10,   10,    4,   32,   39,   27,   38,   48,   39,
      11,   18,   28,   17,   15,    5,   23,   61,   46,   21,   23,   35,   26,   -3,  -31,  -37,
     -39,  -38,  -23,   -3,  -29,  -60,  -74,  -68,  -58,  -37,  -27,  -35,  -22,   -7,   15,   23,
      14,    8,  -27,  -41,   -6,   19,   14,    9,   35,   31,   31,   48,   54,   35,   11,   27,
      26,    4,    7,   11,   31,   54,   38,   25,   34,   35,   20,  -10,   19,    3,   -8,  -45,
      64,  -15,  -41,   23,   40,  -58,   22,   29,  -27,  -28,   42,  -36,   21,  -12,  -19,   39,
     -14,    3,  -18,   32,  -27,   18,   -8,  -43,   43,   25,  -52,    6,   19,   13,   -7,  -50,
      55,    5,  -46,  -22,   94,  -53,  -33,   35,   27,  -45,   -2,   20,   19,  -30,  -23,   47,
       8,  -58,    5,   76,  -67,  -22,   42,   30,  -54,    8,   23,   11,  -51,    3,   47,  -33,
      -7,    5,   27,  -33,   34,  -35,   17,    4,  -26,    5,   17,  -30,   33,    5,  -29,   -5,
      44,  -18,  -50,   60,  -33,   10,   -5,   10,   -7,    1,   -5,   19,  -36,    3,   37,  -17,
     -51,   52,   37,  -64,    9,    4,   37,  -44,  -13,   25,   45,  -75,   -9,   79,  -34,  -57,
      53,   24,  -59,   18,   22,   -3,  -24,   10,   -2,   18,  -53,   29,   35,  -20,  -43,   37,
      18,  -17,  -31,    8,   45,  -49,    8,   11,    9,  -23,   30,  -24,  -22,   29,   14,  -43,
      27,   13,  -22,   -1,    2,   22,  -37,    5,   -5,   38,  -43,    6,   36,  -21,  -20,   20,
       0,   -5,  -27,   27,   21,  -53,    4,   52,   -2,  -84,   70,    5,  -29,  -19,   36,   -6,
      -8,  -12,    3,   35,  -32,  -25,   48,    6,  -60,   49,    4,  -27,  -13,   31,  -15,   -9,
      -4,   31,  -13,  -25,   29,   12,  -34,   -6,   30,  -41,   36,  -23,    6,   31,  -30,    0,
      17,  -45,   47,   -5,  -47,   19,   28,   -8,  -30,   27,   -6,   15,  -54,   34,   21,  -27,
      -9,   25,    3,  -45,   26,   27,  -52,   22,   20,  -29,   34,  -46,   22,   40,  -69,  -27,
     108,  -49,  -54,   69,  -11,   -3,  -18,    3,   15,  -12,  -23,   29,   -8,    4,  -23,   50,
     -38,   -8,   33,  -32,   -2,   26,  -27,   12,   13,  -39,   56,  -31,  -22,   28,    2,  -39,
      54,  -20,  -36,   51,   -6,  -34,   15,    2,    1,    2,  -36,   42,    2,  -10,  -39,   64,
     -36,  -16,   24,    1,   -1,  -18,  -10,   54,  -27,  -54,   80,  -18,  -61,   51,   27,  -76,
      64,  -30,   -1,    9,  -19,   24,   13,  -29,  -13,   49,  -18,  -46,   43,    6,  -47,   42,
     -28,   14,   18,  -18,    2,   14,  -39,   25,   16,  -58,   33,   29,  -49,   16,   41,  -62,
      43,  -17,  -17,   25,  -10,  -28,   41,   -5,  -30,   27,   14,  -53,   27,   35,  -63,   16,
      30,    0,  -30,  -10,   22,   31,  -57,    0,   68,  -59,    2,   37,  -30,    6,   -3,  -19,
      35,  -29,    1,   20,   22,  -68,   33,   39,  -71,   21,   27,  -22,   -1,    3,    0,   18,
     -16,  -13,   17,    4,  -37,   44,  -15,  -26,   48,  -29,  -11,   34,  -25,   -4,   25,  -48,
      43,    4,  -49,   28,   42,  -72,    7,   59,  -36,  -28,   45,   -9,  -28,   25,  -19,   23,
      -9,  -40,   47,   18,  -85,   78,   -2,  -53,   39,  -17,    2,   14,  -36,   10,   63,  -78,
      17,   59,  -66,   -8,   54,  -49,   14,    1,    5,    2,  -18,   16,  -12,   30,  -58,   22,
      53,  -83,   17,   79,  -84,   19,   17,  -34,   44,  -33,  -27,   82,  -62,  -19,   91,  -93,
      22,   49,  -51,  -25,   48,  -12,   -6,    1,   -2,   -1,   22,  -32,   -1,   59,  -78,   12,
      58,  -49,  -26,   70,  -40,   -8,   16,   -8,   12,   10,  -65,   74,   -1,  -97,   90,    0,
     -56,   23,   25,  -17,   11,  -23,   14,    9,  -24,  -31,   77,  -41,  -48,   95,  -38,  -46,
      59,   -1,  -57,   49,  -33,   19,   18,  -46,   34,   31,  -79,   47,   11,  -38,   10,   19,
     -14,  -10,   26,  -29,   28,  -17,  -27,   48,  -15,  -51,   78,  -14,  -73,   64,   12,  -55,
      29,    3,  -24,   52,  -65,   26,   50,  -75,   -5,   81,  -76,    0,   42,   -6,  -26,   10,
      18,  -14,    4,  -24,   33,    2,  -69,   61,   43, -101,   40,   54,  -73,   22,   18,  -41,
      44,  -19,  -43,   94,  -69,  -13,   65,  -26,  -46,   35,   24,  -34,   -2,   23,  -13,    6,
     -19,    4,   38,  -56,   14,   40,  -37,  -19,   66,  -57,   -9,   50,  -47,   21,    6,  -31,
      55,  -34,  -50,   98,  -44,  -47,   44,   28,  -51,    6,   31,   -3,  -34,    8,   11,    6,
     -18,  -27,   78,  -48,  -28,   55,   -2,  -60,   57,  -37,   14,   15,  -48,   49,   22,  -96,
      74,   23,  -83,   36,   18,  -17,  -25,   41,  -12,   -4,   -2,    1,    9,  -14,  -18,   36,
      12,  -77,   54,   32,  -67,   20,   38,  -67,   61,  -53,   32,   21,  -60,   27,   41,  -74,
      27,   33,  -30,   -6,   22,   -1,  -30,   20,    1,   -4,  -22,    9,    8,   37,  -65,   18,
      61,  -69,   -3,   37,  -19,  -15,   15,  -16,   57,  -78,   20,   66,  -67,  -27,   76,  -37,
     -16,   11,   11,   -5,  -18,   10,   16,   -5,  -38,   36,    9,  -20,  -32,   73,  -41,  -36,
      62,  -33,   -9,   34,  -41,   35,   -7,  -40,   65,  -35,  -26,   33,    2,  -43,   42,   -4,
      -9,    5,  -11,   19,  -10,  -16,   11,   16,  -28,   -9,   41,    2,  -70,   67,   -3,  -55,
      23,   33,  -26,    6,  -29,   43,   16,  -85,   51,   28,  -54,    7,   27,   -9,    2,  -18,
      27,   -4,  -42,   31,   10,  -19,   -9,   18,    8,  -24,   -3,   45,  -57,   25,    0,   -7,
      15,  -28,   10,   33,  -46,   -6,   52,  -36,  -15,   46,  -29,   -4,   12,  -14,   34,  -57,
      16,   40,  -41,    3,   16,    8,  -32,   16,   15,  -17,  -27,   47,  -30,   -1,   14,   -5,
      16,  -17,  -33,   70,  -44,  -42,   84,  -34,  -27,   18,   15,    3,  -20,  -22,   55,  -35,
     -22,   31,   10,  -11,  -27,   27,   13,  -28,  -10,   41,  -21,   -3,  -22,   41,  -21,  -13,
       6,   34,  -68,   46,   25,  -65,   50,  -21,   -1,   10,  -33,   34,    1,  -43,   58,  -34,
      -2,   13,    8,  -25,    0,   -2,   34,  -29,  -26,   45,  -12,    4,  -34,   32,   15,  -54,
      17,   53,  -76,   41,    4,  -17,   13,  -26,   13,   31,  -47,    1,   52,  -53,   11,    8,
      14,  -31,   -7,   19,   30,  -60,   26,   27,  -22,  -10,    0,   18,  -13,  -24,   52,  -38,
     -17,   68,  -60,   26,   -9,  -25,   41,  -29,   -8,   40,  -25,   -9,   26,  -28,   15,   -9,
      -3,   11,  -21,   -1,   44,  -47,   19,    0,    3,  -14,  -12,   38,  -22,  -23,   37,  -10,
     -13,    9,   -6,   21,  -14,  -39,   61,   -4,  -68,   60,    6,  -43,   28,  -14,   21,  -22,
     -13,   36,   -7,  -40,   46,  -14,   -5,  -18,   20,   22,  -49,   22,   10,  -18,   21,  -30,
       9,   34,  -54,   19,   22,  -34,   27,    7,  -45,   30,    0,  -20,   23,  -23,   29,  -10,
     -21,   25,    3,  -23,   -1,    5,   16,  -33,   14,   25,  -21,  -11,   16,    3,  -22,    5,
       6,   32,  -73,   27,   62,  -72,    5,   26,  -21,   30,  -37,    4,   40,  -45,    5,   18,
     -18,   -1,   12,   -3,    0,  -18,   28,   -8,  -14,   11,  -11,   13,  -15,   -3,   27,  -17,
     -30,   65,  -45,   -5,   28,  -25,    1,   20,  -36,   38,  -11,  -20,   35,  -23,  -20,   27,
      11,  -42,   13,   17,    1,  -25,   20,   10,  -33,   10,    6,   -7,    9,  -26,   40,   -3,
     -63,   74,  -30,  -11,   10,  -10,    5,   17,  -47,   53,  -10,  -47,   29,   31,  -45,    4,
      16,   14,  -15,  -33,   40,  -11,   -3,  -10,    2,   18,  -20,    9,   22,  -44,   19,   20,
     -42,   25,   -5,  -11,   25,  -25,   -3,   47,  -63,   28,   20,  -42,    7,   39,  -41,    2,
      13,   10,  -24,   -8,   41,  -26,   -1,  -13,    9,   42,  -60,    0,   61,  -54,   -4,   19,
      -6,   11,  -19,  -13,   52,  -37,  -26,   66,  -38,  -30,   49,  -18,  -11,    5,    7,   10,
     -30,    4,   17,    2,  -12,  -15,   38,  -19,  -20,   30,  -16,  -23,   38,  -13,  -16,   29,
     -22,   26,  -17,  -35,   62,  -30,  -35,   51,  -16,  -27,   40,  -16,    3,   -8,   -4,    9,
       4,  -26,   11,   20,  -11,  -38,   56,  -19,  -29,   31,    7,  -39,   17,   10,    6,   -8,
     -41,   45,   26,  -79,   36,   42,  -58,   21,    6,  -10,    7,  -19,   17,   -1,  -15,  -12,
      53,  -22,  -32,   24,   25,  -59,   24,   22,  -36,   10,   18,  -27,   44,  -45,    0,   42,
     -45,   -2,   30,  -27,   12,   23,  -38,   13,    5,    4,   -4,  -20,    1,   43,  -27,  -36,
      43,   14,  -51,   12,   40,  -41,    5,   18,  -11,   -1,   -5,  -11,   53,  -56,  -29,   91,
     -41,  -45,   57,   -7,  -18,   -3,   -4,   29,  -20,  -19,   20,   26,  -57,   31,   17,  -22,
     -13,   28,  -31,    3,   36,  -33,    9,   17,  -39,   42,   -9,  -54,   58,    6,  -69,   44,
      30,  -50,   24,    3,  -17,    9,  -20,   17,    8,  -23,    1,   46,  -50,    1,   27,    1,
     -49,   37,    5,  -17,    4,   -5,    7,   18,  -55,   39,   36,  -85,   37,   48,  -63,    5,
      27,  -13,   -6,   -4,    5,   24,  -26,  -12,   42,  -25,  -34,   33,   20,  -33,  -13,   29,
      -2,    7,  -34,   12,   37,  -50,    1,   47,  -46,   -1,   56,  -54,  -18,   59,  -35,   -6,
      12,  -16,   20,   -2,  -27,   43,  -12,  -34,   22,   25,  -41,   -7,   43,  -20,  -18,   19,
      -1,    1,   -6,  -20,   54,  -55,  -12,   67,  -24,  -56,   56,   -8,  -12,   -7,   -3,   16,
      20,  -48,   20,   32,  -46,    8,   23,  -17,  -38,   54,    1,  -34,    2,   30,   -1,  -21,
     -18,   38,  -14,  -35,   41,    3,  -36,   19,   22,  -45,   40,  -32,   12,   12,  -26,    2,
      35,  -54,   34,   14,  -25,  -30,   47,   10,  -53,   24,   13,   -4,  -18,    3,    5,   27,
     -61,   38,   15,  -39,    6,   40,  -36,    0,    2,   -6,   28,  -40,    7,   46,  -37,  -30,
      59,  -21,  -29,    6,   48,  -55,   12,   30,  -21,   -6,    5,   -2,    1,  -14,   -7,   46,
     -41,   -4,   35,   -8,  -33,   29,  -20,   26,  -31,  -10,   63,  -46,   -4,   12,    7,  -11,
     -15,   26,  -14,  -22,   54,  -47,   12,    9,   -1,   -8,   -7,   -8,   41,  -12,  -60,   77,
     -21,  -26,   11,   13,    1,  -26,   -9,   59,  -45,  -16,   38,   -3,  -27,   -1,   28,   -8,
     -19,   11,   20,  -41,   34,  -23,   22,  -20,   -9,    6,   51,  -79,   40,   18,  -40,   23,
      -5,  -19,   13,    2,    3,   -4,  -35,   71,  -39,    5,  -30,   33,    6,  -29,   -3,   38,
     -29,   -5,   18,   -9,   -4,  -11,   16,   15,  -32,  -14,   77,  -83,   30,   10,  -10,  -19,
      20,   15,  -17,  -19,   29,    7,  -32,    6,   -1,   14,  -14,   -6,    5,   36,  -58,   47,
     -18,  -14,    4,    8,    8,  -24,  -15,   60,  -36,  -20,   43,  -32,    3,   -2,    1,    9,
      -5,   -8,   30,  -33,    6,    6,    2,  -12,  -11,   24,    1,  -22,    9,   34,  -61,   25,
      11,   -5,  -18,   -1,   38,  -19,  -33,   49,  -19,  -21,   18,   -7,    1,    5,   -4,   -3,
      13,  -30,   25,   -5,  -12,    2,    8,   17,  -37,    0,   50,  -38,  -26,   40,  -15,    7,
     -24,   31,  -11,   -8,    6,   -6,   -3,    1,    9,   -8,    6,  -20,   25,    0,  -21,    7,
      22,  -48,   29,   -4,   10,  -22,    7,   22,   -9,  -34,   45,  -15,  -31,   30,   -2,    0,
     -30,   46,  -18,   -6,  -17,   31,   -6,   -7,  -21,    8,   45,  -47,   -7,   31,  -17,  -11,
      25,  -20,   17,  -30,   47,  -38,   -2,    5,   16,  -36,   24,   -2,    3,   -7,    6,   10,
     -23,    5,  -11,   35,  -42,   17,    0,   21,  -35,   11,   16,  -18,  -15,   36,  -24,   -3,
       9,    5,   13,  -49,   36,  -11,   -2,  -14,   37,  -32,   13,   -1,    0,   -2,   -2,   -8,
      17,  -11,  -21,   30,   -1,   -1,  -41,   72,  -65,   14,   14,   12,  -41,   21,    4,   15,
     -32,   -1,   25,   -9,  -18,    3,   29,  -38,   35,  -22,   14,  -20,   16,   -6,   -6,  -13,
      29,   -4,  -17,    7,   14,   -6,  -38,   54,  -32,    3,  -16,   36,  -39,   42,  -40,   36,
     -22,  -13,   17,   14,  -36,   12,   23,  -25,    6,  -25,   53,  -33,  -12,    5,   37,  -46,
       6,   20,    9,  -53,   52,  -16,  -22,   24,   -9,   10,  -17,   12,  -20,   48,  -73,   40,
      18,  -30,  -20,   52,  -34,   11,   -6,    0,    1,  -15,   24,  -16,   16,  -30,   44,  -27,
     -10,    0,   34,  -52,   24,    3,    2,   -6,   12,  -25,   35,  -38,  -14,   72,  -73,    7,
      31,   15,  -50,   20,   12,   -5,  -25,   23,    3,  -10,   -9,   15,    9,  -41,   28,    6,
      -5,  -36,   44,  -13,   10,  -19,    2,   14,  -10,  -29,   56,  -27,  -35,   58,  -19,  -27,
      17,   16,  -30,   10,   -7,   15,  -12,   -3,   11,   18,  -30,  -13,   38,  -17,  -16,    3,
      32,  -37,   23,  -24,   30,  -12,  -26,   40,  -14,  -52,   59,   12,  -55,   16,   35,  -20,
     -30,   39,  -24,   21,  -26,   12,   13,  -10,  -19,   23,    2,  -35,   17,   33,  -30,  -17,
      39,  -15,   12,  -53,   50,  -13,  -25,    2,   50,  -42,   -1,   25,  -22,    6,   -5,    3,
      -4,    2,  -18,   39,  -25,   -3,    1,   29,  -57,   22,   26,  -22,  -18,   34,  -10,  -10,
     -11,   13,   31,  -77,   46,   23,  -22,  -35,   61,  -24,  -13,    7,   -3,    0,    4,  -24,
      27,   12,  -50,   35,   13,  -19,  -37,   69,  -46,   -4,   13,    5,   -8,    6,  -25,   40,
     -26,  -13,   38,  -12,  -28,   21,   22,  -57,   40,  -15,   11,  -19,    4,   19,    9,  -36,
       3,   42,  -35,  -30,   46,    0,  -50,   59,  -26,    9,  -16,   12,  -10,   10,  -33,   44,
      -8,  -29,    8,   42,  -43,   -6,   26,  -19,   14,  -30,   34,    4,  -21,  -17,   49,  -31,
     -24,   34,   14,  -53,   32,   13,  -26,   12,  -22,   26,   -3,  -22,  -11,   66,  -59,    0,
      43,  -27,  -23,   42,  -32,    7,   -7,   11,    9,  -19,   -1,   15,   16,  -58,   43,    1,
     -32,   11,   36,  -44,   18,    0,    4,   -4,   -7,  -22,   50,  -22,  -44,   67,  -14,  -43,
      37,    2,  -32,   15,    7,    8,  -22,   -1,   14,   19,  -43,    0,   40,  -30,  -14,   28,
      10,  -32,   11,    1,   21,  -33,   -9,   31,   15,  -72,   61,    4,  -40,   21,   14,  -37,
      22,    4,   -4,   -9,    5,   -8,   23,  -16,  -22,   35,  -24,    0,   12,    3,  -17,   15,
       2,  -10,   -6,   -8,   21,    7,  -58,   40,   43,  -75,   25,   28,  -25,  -18,   28,  -15,
       6,   -5,   -4,   22,   -5,  -39,   37,    1,  -30,   12,   23,  -27,   -8,   34,  -22,    0,
     -12,   15,   10,  -28,    2,   45,  -45,   -9,   36,  -22,   -7,   13,   -7,    6,    2,  -18,
      17,   10,  -34,    9,   18,  -22,   -1,   22,   -9,  -17,   23,   -1,  -22,   21,  -20,   20,
     -17,   -6,   38,  -33,  -18,   55,  -32,  -21,   26,   -5,   -9,    5,   -8,   16,    9,  -47,
      36,   11,  -36,   -3,   38,   -7,  -48,   44,   -2,  -11,    2,  -16,   15,   11,  -36,   33,
      -3,  -18,    9,   19,  -46,   26,   -1,  -11,   20,  -24,   12,   16,  -16,  -17,   37,  -32,
      -6,   13,   13,  -33,   25,   14,  -27,    8,    1,  -18,   22,   -5,  -15,   32,  -46,   37,
      -2,  -19,  -13,   38,  -32,    8,    2,   -4,   15,  -12,   -4,   19,  -25,  -10,   37,  -19,
     -11,  -10,   57,  -54,   19,  -17,   18,    3,  -18,   -9,   27,   -6,  -36,   57,  -23,  -21,
      14,   11,  -23,   32,  -53,   56,  -24,   -5,   -3,   11,  -16,   16,   -7,  -20,   17,   11,
      -3,  -31,   42,  -33,   14,   -6,   -2,   -8,   39,  -56,   48,  -21,  -20,   30,   -8,  -20,
      12,   15,  -32,   41,  -36,   29,  -25,   14,  -22,   22,  -19,    9,    4,   10,  -31,   17,
      11,  -14,   -1,   -7,   17,  -16,    6,  -18,   64,  -88,   47,    6,  -20,   -5,   22,  -13,
      18,  -28,    2,   25,  -19,  -10,   -3,   29,  -23,   11,  -22,   39,  -25,   13,  -27,   20,
      -2,  -18,   15,   -3,    3,    9,  -17,   -8,   38,  -57,   35,    1,   -9,  -24,   43,  -32,
      30,  -30,   -3,   19,   -3,  -21,   12,   14,  -12,    2,   -5,   11,  -37,   37,   -3,  -13,
      -4,   10,   11,   -4,  -38,   41,   -9,  -27,   37,  -37,   16,   17,   -7,  -15,   22,  -40,
      33,   -2,  -16,    4,    3,    8,   -4,  -20,   21,   -3,  -10,    8,  -26,   37,  -21,    8,
       0,   -3,   -3,    0,   -8,   20,  -15,  -32,   54,  -10,  -26,   17,  -12,   10,   24,  -71,
      51,    3,  -21,    9,   -3,   17,  -22,    2,   15,  -21,  -11,   39,  -25,   11,  -27,   28,
       3,  -11,  -26,   45,  -43,   24,    7,  -39,   47,  -24,  -15,   27,  -13,  -15,   35,  -27,
      15,  -17,    9,    0,   -7,    0,    4,   -9,   13,   -3,  -16,   28,  -29,   21,  -23,   11,
      -4,   10,  -30,   64,  -63,   13,   28,  -30,   16,  -13,    0,   25,  -39,   -2,   53,  -40,
       5,  -19,   41,  -25,   -6,   -3,   37,  -40,    6,    8,    0,    6,  -34,   32,    4,  -27,
      13,   15,  -34,   52,  -63,   40,   -5,  -22,    5,   24,  -32,   22,   11,  -26,   14,  -22,
      26,  -21,   10,   -8,    5,  -10,   46,  -66,   44,  -20,   14,   -7,  -27,   23,   30,  -53,
      24,   10,  -37,   44,  -40,   21,  -11,    3,    6,   20,  -47,   27,    5,   -2,  -18,   -4,
      29,  -13,  -20,   27,    9,  -47,   43,  -37,   55,  -62,   14,   33,  -13,  -28,   24,   -9,
      23,  -35,   -4,   32,  -14,  -13,   28,  -10,  -30,   46,  -43,   43,  -46,   13,   13,  -10,
       7,   -3,  -20,   39,  -19,  -19,   14,  -15,   39,  -31,  -10,   25,    2,  -34,   41,  -35,
      15,   -4,   -3,   22,  -18,  -27,   46,   -1,  -36,   10,   -4,   42,  -56,   13,   31,  -19,
     -18,   28,  -29,   27,  -32,   24,   10,  -44,   20,   32,  -32,  -17,   32,  -13,   13,  -35,
      20,   32,  -53,   20,    9,  -16,   16,  -36,   39,   -3,  -33,   43,  -26,    2,    2,    2,
     -17,   24,  -22,   14,   -3,  -12,   31,  -28,   -8,   26,  -29,   19,   -4,  -15,   33,  -39,
      22,   16,  -37,    6,   17,   -4,  -13,  -12,   37,    9,  -65,   34,   25,  -27,   -9,    7,
       5,   10,  -36,   45,  -11,  -41,   42,   -6,  -21,    7,   -5,   31,   -5,  -57,   62,  -12,
     -15,  -16,   23,    4,  -24,   12,   26,  -35,  -11,   44,  -25,   -8,   -1,   -4,   28,  -11,
     -37,   61,  -48,   23,   -1,  -30,   29,   -8,   -2,    6,  -19,   18,   15,  -41,   30,   -4,
     -11,  -11,   28,  -10,   -4,  -37,   81,  -45,  -43,   61,  -19,    1,  -11,    0,   31,  -30,
     -25,   68,  -43,  -11,    0,   27,   -1,  -33,   -7,   77,  -54,  -30,   44,   -6,   -5,  -14,
      17,   -6,  -10,    6,   30,  -68,   50,  -16,    5,    5,  -30,   30,   26,  -69,   36,    8,
     -34,   37,  -28,   11,    0,   -1,    9,    1,  -41,   53,  -22,  -24,   23,    5,   -9,  -11,
      12,   28,  -61,   28,   36,  -68,   51,  -33,   25,   -6,  -26,    7,   53,  -65,    2,   47,
     -25,  -23,   17,   20,   -4,  -51,   38,   29,  -67,   31,    1,   22,  -35,   -8,   40,   -9,
     -46,   47,  -13,   -8,    5,  -15,   37,  -27,  -20,   45,  -16,  -45,   59,  -37,   19,   -6,
       2,    1,  -11,   -3,   34,  -42,    0,   33,  -30,   16,  -13,   13,    2,  -23,   18,   -5,
     -26,   43,  -24,   15,  -26,    4,   35,  -15,  -62,   64,   19,  -75,   50,   -8,    8,  -14,
     -12,   31,  -19,  -30,   45,  -10,  -12,  -10,   36,    3,  -53,   14,   45,  -37,  -22,   42,
     -25,   21,  -36,   21,   37,  -61,    5,   47,  -49,   19,   -4,    5,    1,  -12,    7,    3,
     -11,    2,   18,  -28,   13,   -4,   18,  -13,  -20,   33,  -22,   -8,   21,  -12,  -10,   24,
      -9,    2,  -27,   15,   33,  -41,  -18,   56,  -40,    9,   -5,    6,   20,  -44,   11,   39,
     -35,  -22,   50,   -7,  -36,   -6,   41,  -10,  -30,   15,   20,  -22,    7,  -11,   16,    6,
     -51,   59,  -21,  -26,   24,   12,  -24,    8,   -7,   12,    3,  -36,   27,   18,  -42,   22,
       9,  -22,   11,   -2,   15,  -40,   38,  -13,  -16,    8,   24,  -33,   15,  -13,    4,   23,
     -42,   17,   30,  -34,   -5,   28,  -22,   11,  -23,   30,  -14,  -28,   37,   12,  -46,   11,
      31,  -23,  -12,   -7,   36,  -17,   -6,   -4,   25,  -18,    4,  -29,   53,  -48,    4,   24,
      -9,  -21,   30,   -1,  -20,    2,  -13,   51,  -51,   -1,   39,  -23,  -18,   33,  -23,    3,
       3,    2,  -13,   11,    4,  -13,   15,  -14,   -3,    1,   24,  -53,   55,  -24,  -17,   36,
      -1,  -49,   45,   -7,  -12,   -2,   -4,   24,  -23,    1,    6,   23,  -51,   30,   -8,   14,
     -29,   17,   12,   -9,  -21,   21,    1,    3,  -32,   21,   30,  -59,   27,   25,  -21,  -26,
      36,  -24,   16,  -23,   15,   10,  -15,   11,  -11,   -3,   14,    1,  -30,   32,  -24,   27,
     -25,   10,  -12,   29,  -33,    7,   -5,   25,  -29,   14,   15,  -42,   20,   18,  -27,    1,
      21,  -19,   17,  -18,    2,   19,  -12,  -34,   47,  -21,   -6,    9,   -2,   14,  -32,   32,
     -23,   14,  -21,   21,    0,  -13,   -8,   42,  -35,  -19,   33,    4,  -34,   23,   -5,   -6,
      22,  -31,   21,   -8,   -5,   -3,   15,  -22,   10,    2,    7,  -17,   11,    3,  -10,    2,
      -1,   -2,   -9,   25,  -20,   11,  -18,   17,   -3,  -12,    2,    9,   -1,  -10,    5,    0,
      15,  -40,   36,   -5,  -28,   16,   24,  -34,   16,   -1,   13,  -32,   11,    9,    5,  -26,
       5,   32,  -32,    4,   -1,   29,  -38,    8,    7,   -6,    5,   -2,   -5,   18,  -26,   -2,
      39,  -42,    0,   26,    2,  -43,   45,  -30,   20,  -11,   -6,   -3,   16,   -7,   -6,    3,
      12,  -13,    5,   -7,  -21,   47,  -29,  -11,    9,   36,  -45,    8,    0,   22,  -28,   -7,
      32,  -22,   -9,   20,   12,  -40,   24,   -8,   14,  -28,   10,    9,   12,  -29,   15,   -7,
      15,  -23,    5,   14,  -24,   12,    8,    4,  -38,   36,   -4,   -7,  -30,   47,  -13,  -24,
      16,   23,  -46,   29,   -3,  -10,   20,  -43,   35,    0,   -4,  -30,   47,  -18,  -21,   16,
      19,  -35,   11,   19,  -21,  -11,   27,  -12,   -9,   16,  -21,   23,  -32,   30,    3,  -22,
     -15,   51,  -38,   -1,   -2,   11,   15,  -28,   -1,   16,   13,  -42,   23,    4,   -6,  -32,
      61,  -24,  -35,   34,   29,  -55,    4,   13,    9,   -6,  -26,   35,   -6,  -11,  -11,   19,
      -6,   -3,  -15,   43,  -41,    4,   22,   -1,  -34,   18,   15,  -35,   18,   -1,   23,  -35,
      18,   -2,   -9,    1,   10,  -18,   17,  -18,   21,   -8,  -17,   24,   -1,  -20,   -7,   26,
     -11,    6,  -33,   42,    0,  -40,    9,   46,  -48,   -6,   24,   13,  -39,    8,   41,  -43,
       3,    6,    6,   -7,   -6,   -8,   42,  -37,  -11,   39,  -16,  -26,   25,    3,  -24,    9,
      11,    6,  -34,   17,   14,  -12,  -22,   20,    0,   14,  -38,   27,   10,  -37,   22,   -1,
      -5,   -7,   11,    4,   -3,  -29,   38,   -5,  -26,    4,   20,  -17,    6,    2,   11,  -17,
     -10,   40,  -49,   10,   26,   -8,  -24,   11,   12,    5,  -36,   21,   20,  -22,  -29,   28,
      30,  -30,  -24,   31,   25,  -70,   39,    4,  -16,    3,    9,  -13,   16,  -26,   23,   19,
     -46,    1,   29,    6,  -37,    8,   27,   -8,  -33,   36,  -24,    5,   14,   -8,   -8,    1,
       4,   15,  -27,  -11,   44,  -38,    6,   12,   -3,  -12,   20,  -17,   16,  -35,   28,   -4,
       0,  -13,    8,   23,  -24,  -16,   28,   11,  -58,   48,    6,  -39,   11,   24,   -9,   -8,
     -25,   42,  -16,  -14,   12,    2,   13,  -31,    6,   26,  -10,  -48,   64,  -22,  -21,    6,
      28,  -15,  -11,   -2,   22,  -30,   11,   15,  -25,   13,    2,   -1,   -7,   -4,    6,   17,
     -37,   17,    0,    1,   14,  -23,    4,   16,  -23,    6,   12,  -31,   30,    6,  -18,  -25,
      45,   -7,  -20,  -15,   44,  -38,    9,   22,  -37,   24,    6,  -20,   14,  -17,   -8,   44,
     -27,  -22,   16,   30,  -33,  -18,   20,   31,  -50,   11,   27,  -21,   -4,   -3,   26,  -15,
     -24,   15,   20,  -27,   16,  -12,    9,    5,  -24,    3,   26,  -27,    5,   15,  -19,    9,
      -9,   26,  -25,   -5,   10,   -4,   -6,   31,  -45,   18,   24,  -23,  -23,   27,   -3,    2,
     -18,    9,   13,  -18,   19,  -17,    7,   -1,  -24,   31,    5,  -49,   31,   32,  -40,   -7,
      10,   14,  -12,  -12,    5,   21,  -30,   25,  -12,    4,  -18,    9,   11,  -13,  -20,   37,
      -8,   -3,  -13,   -3,   33,  -21,  -32,   44,   -7,  -22,   28,  -24,    5,   12,  -19,    2,
       6,    2,  -16,   11,   10,   -6,  -23,   31,  -25,    7,    6,  -16,   18,    1,  -35,   40,
      -9,  -18,   12,    4,   -2,  -25,   20,   19,  -16,  -35,   46,  -14,   -8,   -3,   -1,   24,
     -12,  -25,   26,   -4,   -6,    3,  -12,   20,  -24,   18,    9,  -20,   -2,   18,  -13,   -1,
     -16,    8,   26,  -35,   12,   10,  -11,    6,    2,  -30,   46,  -43,   16,    6,    1,  -20,
      26,  -18,    8,  -13,    9,   -3,    3,    1,  -25,   29,   13,  -50,   12,   41,  -47,   15,
      14,  -12,    2,   -3,   -1,   14,  -25,   -3,   26,  -23,   19,  -35,   41,   -5,  -23,   -1,
      31,  -30,    8,  -15,   32,  -29,   -7,   22,   10,  -35,   12,    6,   -2,   20,  -50,   36,
       7,  -17,   -4,   -1,    7,    2,  -21,   19,  -12,    1,   28,  -25,   -5,    9,   -3,  -12,
      32,  -45,   16,   21,    0,  -43,   21,   28,  -19,  -38,   45,  -15,   -8,   28,  -43,   39,
     -12,  -23,   13,   19,  -39,   23,   -3,   17,  -32,    6,   20,   -5,  -32,   23,    8,  -15,
      -1,   11,    9,  -28,    5,   20,  -18,   -6,    9,  -18,   50,  -50,   -8,   49,  -30,   -5,
      -4,   14,  -19,   28,  -21,    2,    4,   11,  -20,    6,    3,   -5,  -24,   54,  -34,  -14,
      26,   -4,   -2,  -16,    5,   20,  -23,    1,    6,   -9,   32,  -37,    1,   25,  -22,   -8,
      31,   -6,  -37,   31,    0,    3,  -37,   24,   25,  -27,  -20,   27,    1,    4,  -26,   13,
       3,  -14,   12,   -6,    6,   -3,   -6,   18,  -14,  -27,   38,    5,  -36,   14,   13,  -22,
      26,  -13,  -22,   36,  -23,   -5,    3,   18,  -12,  -23,   31,   -5,  -24,   23,  -15,   17,
      -7,  -23,   20,    6,   -4,  -19,   20,   -8,   15,  -32,   13,   17,  -30,   17,   13,  -19,
      -8,    4,   24,  -18,  -29,   36,    7,  -21,  -20,   28,   13,  -17,  -31,   36,   -9,   -7,
       7,    6,   -9,   -4,    7,   -6,   10,  -32,   41,  -26,   12,  -10,  -12,   35,  -10,  -39,
      36,   -9,   -7,    7,    6,   -9,   -4,   11,  -14,    5,   -7,    9,  -13,   24,  -27,    4,
      14,    7,  -31,   19,  -14,   17,   -5,  -34,   57,  -31,   -7,   -6,   28,  -15,  -11,    2,
      25,  -21,  -14,   15,   18,  -35,   12,    1,    9,  -20,   -2,   32,  -37,   26,  -17,    7,
       1,  -10,  -18,   54,  -37,  -16,   23,   11,  -13,  -23,   34,   -5,  -16,  -10,   25,  -28,
      30,  -10,   -7,   -5,   18,  -24,   25,  -24,   18,  -11,    0,    3,  -19,   34,  -12,  -12,
       2,    3,  -13,   32,  -37,   20,    4,   -6,  -25,   29,   -3,   -2,  -11,   -2,   28,  -38,
      18,    7,   -5,   -7,    0,   -4,   21,  -36,   30,  -19,   25,  -29,  -15,   48,  -11,  -43,
      33,   33,  -64,   17,   26,  -12,  -18,    9,   -1,   18,  -33,   23,  -13,   21,  -18,  -13,
      18,   -2,  -20,   20,    6,  -15,    4,  -12,   28,  -27,    1,   10,   -5,    3,    0,  -17,
      15,   17,  -30,    2,    5,   -8,   17,  -11,   -2,    9,  -20,   23,  -27,   23,  -10,   -3,
       7,   -3,  -25,   31,    9,  -28,   -9,   30,   -5,  -28,   15,   29,  -36,   -9,   29,  -11,
     -20,   33,  -27,   21,  -14,  -12,   21,   -3,   -9,   -2,   12,   -5,  -27,   27,    7,  -20,
     -11,   32,   -9,  -15,   -1,    9,   20,  -42,   12,    9,   -4,    3,   -6,   -3,    6,    0,
     -12,   15,  -25,   27,   -6,   -6,   -6,    6,   -2,   -4,    5,    9,  -20,   12,    8,  -17,
     -10,   30,  -12,  -24,   25,  -15,   18,  -21,   21,   -8,   -6,   -9,   12,   -6,   15,  -33,
      26,    8,  -32,   13,   21,  -12,  -28,   20,   11,   -6,  -28,   27,   11,  -21,  -10,   22,
      -1,  -11,   -7,   24,  -12,  -27,   35,   -8,    0,  -20,   23,  -10,    9,  -30,   32,  -15,
       3,   -7,    6,   -2,   10,  -17,    1,    8,   -4,   -5,   -3,   14,   -9,    1,  -11,   18,
     -13,   15,  -33,   22,   14,  -32,   11,    9,   -1,  -17,   14,    0,   -3,  -16,   29,  -21,
      -4,   -1,   28,  -24,   -2,  -11,   41,  -25,  -23,   24,    6,  -18,  -13,   37,  -21,   -2,
      -4,   29,  -40,   11,   12,    4,  -25,   12,   -9,   23,  -17,  -14,   27,   -2,  -26,    9,
      18,  -14,   -1,  -15,   29,  -18,   -4,    5,   12,  -26,   18,   -3,   -7,    3,   13,  -10,
     -25,   44,  -38,   11,    8,   -2,  -25,   28,   -9,   12,  -13,  -13,   10,   27,  -53,   19,
      16,   -4,  -20,   12,   12,  -21,    5,   12,    3,  -35,   22,    8,    0,  -28,   18,   16,
     -25,   -3,    9,    8,   -3,  -19,    8,   24,  -34,   -4,   38,  -16,  -30,   29,   -1,   -2,
     -25,   28,   -1,  -21,   11,   10,  -18,   -1,   10,    1,   -7,    0,    1,   -7,   15,  -15,
      -5,   16,    2,  -22,    8,    0,   -1,   26,  -34,  -22,   56,  -26,  -11,   12,    9,   -9,
      -9,    4,    7,   -8,   -1,    8,    0,  -21,   10,   19,   -8,  -25,   17,   10,  -18,    3,
      -4,   26,  -15,  -29,   30,    9,  -46,   36,   12,  -33,    1,   18,   -2,  -16,    4,   16,
     -10,  -16,   11,    2,    8,  -19,    5,    1,   10,  -21,   20,   -8,   -1,   -3,    1,    7,
     -19,    7,   11,  -12,    5,    5,  -26,   29,  -11,   -5,   -2,   12,  -13,    9,  -22,   23,
       3,  -20,    4,   17,  -16,  -13,   17,   15,  -16,  -34,   37,   -5,    8,  -32,   23,   17,
     -36,   -2,   36,  -25,   -4,   28,  -18,  -20,   15,    4,    7,  -12,  -24,   43,  -19,    0,
     -11,   25,   -9,  -12,   -7,   10,   -1,   11,   -2,  -12,   13,  -27,   30,   -9,  -15,    8,
      17,  -28,   18,   -9,    3,    7,   -8,  -10,   16,  -26,   35,  -22,  -10,   37,  -35,    1,
      11,   11,  -19,   -2,    9,   17,  -37,   11,   10,    9,  -16,  -12,   27,  -11,  -22,   16,
      24,  -48,   25,   -1,   -3,    4,  -20,   13,   39,  -72,   34,    1,    2,   -6,    4,   -1,
      -8,    2,   -8,   18,  -10,   -1,   -5,   19,  -30,    5,   30,  -16,  -26,   36,  -26,    3,
      21,  -27,   10,    4,  -10,    0,   -4,   15,    9,  -41,   32,  -11,    2,  -11,   15,   -3,
      -7,   -8,   16,   -3,  -21,   23,   -2,   -9,   -4,   -2,   20,   -5,  -37,   49,  -20,   -6,
      -9,   17,   17,  -36,   -8,   40,  -24,   -5,    3,    8,    5,  -12,   -6,   15,    2,  -27,
      28,   -4,  -23,   16,    5,   -1,  -26,   29,   11,  -38,   22,  -12,   -8,   38,  -34,   -3,
      10,    4,   -2,   -5,   -8,   24,  -16,  -20,   21,    1,   -7,   11,   -7,   -4,  -15,   15,
      15,  -21,   -6,   10,   -1,   17,  -45,   23,   29,  -42,    2,   18,   -5,   -6,   -1,   22,
     -20,  -19,   16,   21,  -20,  -18,   23,    2,    5,  -41,   36,   10,  -34,   12,   12,  -25,
      11,    1,    6,   -6,  -11,   20,  -11,   10,  -11,  -12,   13,    8,  -21,    5,   -1,   14,
       3,  -26,    5,   27,  -39,   18,    7,  -27,   34,  -20,   13,  -20,    7,   -4,   25,  -23,
     -16,    7,   47,  -35,  -29,   37,   10,  -35,    4,   12,   -1,    0,  -15,   25,  -23,  -12,
      35,    7,  -51,   28,   -1,   16,  -33,    5,   27,  -21,    2,   -5,   13,   -3,    0,  -20,
      27,  -30,    8,   16,   -4,  -13,   14,  -15,   19,  -12,   -6,    8,   -9,   19,  -27,    4,
      20,   -9,  -12,   21,  -37,   41,  -22,    1,    1,   13,  -33,   20,   14,  -30,   -2,   22,
      21,  -51,    3,   38,   -7,  -35,   17,    6,   11,  -43,   33,    9,  -36,   10,   31,  -24,
     -13,   16,   -6,   24,  -36,   -1,   16,   19,  -45,   20,   11,    2,  -30,   31,  -21,  -14,
      29,   -4,  -12,    3,   -6,    9,   15,  -37,   20,   -4,    8,  -18,   12,   -7,   17,   -8,
     -12,   -9,   23,    8,  -28,    1,   29,  -19,  -18,   27,   -2,   -8,  -28,   44,   -4,  -36,
      15,   33,  -30,  -13,   13,   14,  -20,   -7,   25,  -11,   -5,   -8,   21,   -1,   -8,  -37,
      50,    1,  -53,   27,   28,  -21,  -10,    4,   16,  -24,   10,    6,  -12,    0,    2,    6,
       1,  -13,    2,   21,  -26,    3,   13,  -19,   10,    9,  -18,   -3,   22,  -18,   -1,   -2,
      14,   -1,  -23,   21,   -6,   -2,   -9,   20,    5,  -35,    1,   34,  -21,  -16,   22,    1,
      -8,   -5,    1,   18,  -12,  -23,   18,    5,  -17,   -7,   37,   -6,  -35,    6,   47,  -44,
      -7,   20,    5,  -10,  -23,   35,   -6,  -12,  -12,   39,  -27,  -10,    9,   21,  -21,   -6,
       2,    5,    1,    6,  -28,   17,   20,  -31,   -3,   15,    7,  -26,   31,  -40,   43,  -32,
      23,  -19,   11,  -22,   26,   -6,   -1,  -25,   33,    2,  -25,   -7,    9,   26,  -16,  -30,
      29,   20,  -47,   13,   16,   -9,  -19,   18,   23,  -32,  -17,   32,   21,  -38,  -13,   14,
      43,  -66,   19,   23,    5,  -50,   47,  -20,    2,  -11,   22,   -5,   -6,  -21,    4,   38,
     -15,  -32,   12,   35,  -35,   -4,    7,   18,  -17,   -1,   -7,    6,    5,    0,    0,   -7,
       0,   -8,   21,  -10,    5,  -28,   30,    3,  -17,  -29,   57,  -16,  -17,  -10,   28,   -9,
     -20,   26,  -12,    3,  -20,   27,   -3,   -7,  -42,   65,   -9,  -45,   -3,   63,  -33,  -11,
      -6,   28,  -17,   -1,   -6,    6,    7,  -12,    0,   25,  -21,  -30,   54,   -9,  -37,    1,
      28,    7,  -42,   18,   11,   17,  -46,   24,   -9,   27,  -38,   22,  -20,   23,  -21,   11,
      -6,   42,  -71,   20,   32,  -11,  -43,   44,   -3,   -4,  -27,   12,   24,   -8,  -18,   -8,
      30,  -19,  -23,   44,   -8,  -30,    0,   45,  -39,    0,   -1,   28,  -16,  -17,  -15,   44,
     -13,  -11,  -13,   36,  -24,  -11,   12,   17,  -30,    8,   17,  -10,  -18,    9,   22,  -18,
     -15,    3,   25,  -25,   11,   -6,    5,    7,  -18,   -3,   15,   -1,  -17,    8,   28,  -32,
     -17,   36,    8,  -41,   12,    7,   13,  -22,  -14,   18,   41,  -57,   -1,   25,   10,  -40,
      18,   11,   -8,  -23,   25,  -16,   37,  -45,   17,   10,    2,  -60,   64,  -15,   -3,  -16,
      22,   -9,    9,  -27,   30,   -7,  -21,    3,   20,  -10,    6,  -12,   15,  -19,   14,  -19,
       3,   22,   -8,  -29,   37,  -28,   29,  -26,   11,  -15,   15,  -17,   21,  -26,   18,    5,
      -5,  -11,    2,   16,  -10,  -10,   -5,   29,  -30,    4,    3,   18,  -21,    4,    1,    8,
     -13,  -10,    1,   40,  -35,  -26,   44,    5,  -38,    8,   30,  -24,    0,   -1,    0,   12,
     -18,   -1,   18,   -8,  -28,   39,  -18,   24,  -35,   24,  -36,   46,  -41,   12,   -3,   24,
     -37,   31,  -28,   32,  -16,    2,  -27,   39,  -34,    7,   24,  -19,   -6,   14,  -10,   -1,
      14,  -16,   -4,   25,  -26,   -4,    8,   22,  -40,   33,  -30,   22,  -15,   36,  -63,   39,
       1,   10,  -54,   36,    9,    5,  -51,   49,  -13,    5,   -7,   -7,   15,   -9,  -10,    2,
      12,  -18,    6,    3,   18,  -29,    9,   10,  -10,    1,  -20,   20,   -3,   -1,  -13,   21,
     -26,   41,  -36,    2,   23,  -23,  -10,   39,  -41,   17,  -10,    8,    7,  -13,   23,  -54,
      66,  -26,  -50,   54,   17,  -66,   59,  -46,   30,  -10,    6,   -8,  -18,   19,   16,  -32,
      12,    6,   -2,    3,  -36,   33,   -6,   -7,   12,  -16,    6,   14,  -21,   14,   16,  -58,
      37,    3,    0,  -35,   44,  -16,   17,  -38,   28,  -14,   25,  -45,   28,  -21,   32,  -31,
      11,   17,  -24,   11,    5,  -24,   18,   -6,   -3,    0,   -3,   21,  -33,   24,   20,  -78,
      66,   -8,  -24,    3,   17,  -14,   24,  -41,   34,  -25,   27,  -32,   17,   -5,   13,  -26,
      28,  -29,   22,   -8,  -16,   33,  -30,    2,   25,  -27,    1,   31,  -36,   -7,   31,   -8,
     -12,   -5,   17,   -7,    5,  -26,   32,    1,  -18,  -16,   27,   -7,  -10,    2,   21,  -42,
      30,   -3,  -19,   33,  -40,   19,    6,  -13,   -5,   17,  -10,   28,  -63,   40,    6,  -10,
      -9,    7,   -3,   12,  -20,   -1,   17,   -1,   -6,  -14,   18,    1,  -19,   12,    5,   -9,
      -2,  -14,   33,   -3,  -44,   51,  -17,   -6,  -16,   36,  -35,   29,  -31,   31,  -24,   15,
     -23,   33,  -35,   20,   -4,   -1,  -19,   27,   -1,  -29,   25,    1,  -20,   25,  -23,  -13,
      62,  -50,  -18,   43,  -20,    1,   -4,   16,  -18,    4,  -16,   36,  -42,   42,  -42,   38,
     -28,    9,  -10,   31,  -40,   30,  -39,   30,    8,  -28,   11,    9,   -7,   -6,   -8,   10,
      22,  -36,   -5,   26,    4,  -41,   30,   12,  -11,  -10,  -14,   37,  -29,    3,   -6,    9,
      -5,   15,  -30,   40,  -26,   12,  -25,   25,  -21,  -12,   46,  -17,  -39,   47,    7,  -57,
      45,  -14,    1,  -13,   21,  -21,   14,   -7,    7,  -11,   18,  -34,   25,    7,  -28,   22,
       1,  -12,   11,  -24,    4,   38,  -44,   17,    2,  -12,   19,  -17,    0,    9,   17,  -55,
      29,    3,    3,  -27,   48,  -38,   16,  -17,   24,  -19,   26,  -49,   29,    9,  -18,  -25,
      50,    2,  -31,  -20,   43,   -3,  -35,   23,   13,  -34,    9,   20,  -15,   -8,   29,  -37,
      29,  -21,    4,   -8,   36,  -52,   29,   -8,    6,  -18,   35,  -34,   22,  -21,   10,    5,
     -11,  -13,   35,  -26,   -3,   12,  -17,   13,    1,  -12,   -4,   24,  -18,   -6,   18,   -7,
     -13,   17,   -4,  -30,   48,  -41,   10,   34,  -39,  -22,   73,  -48,  -12,   12,   22,  -14,
     -31,   18,   29,  -17,  -21,   22,   -3,   -8,  -12,   25,  -11,   13,  -41,   36,   -3,   -2,
     -27,   37,   -6,  -36,   17,   18,   -7,  -10,    4,   -5,   10,  -21,   13,   15,  -21,    2,
      -1,   -5,    8,   -1,  -16,   29,  -24,   14,  -18,   26,  -24,   17,  -26,   21,  -18,   24,
     -49,   82,  -52,  -11,   36,  -22,  -17,   30,  -21,    1,    1,   -1,    8,   -2,   -7,    2,
      17,   -9,  -36,   37,   -5,  -15,   -4,   27,  -20,   11,  -31,   46,  -18,  -13,  -11,   58,
     -67,   19,   -4,   40,  -43,    9,  -14,   41,  -32,  -16,   46,  -19,  -13,    5,   -5,    6,
       2,  -16,   10,   -9,   18,  -13,    3,   24,  -37,   11,    1,    0,   -8,   -9,   28,   -1,
     -41,   40,  -10,    6,  -13,    1,  -11,   30,  -28,  -10,   30,    1,  -36,   17,   28,  -54,
      51,  -24,    1,   -6,    6,  -12,   33,  -48,   23,   18,  -17,  -23,   27,   11,  -23,  -13,
      27,   -7,   -1,  -24,   35,    3,  -48,   35,    8,  -20,   -3,    3,   16,  -11,    8,  -35,
      32,    7,  -27,  -22,   81,  -85,   36,   -7,   16,  -16,    2,    0,   13,  -28,   12,  -16,
      24,    6,  -25,  -14,   47,  -15,  -25,    3,   37,  -41,   -5,   32,  -25,   11,    6,  -16,
      25,  -34,   14,    8,   13,  -52,   30,    6,   13,  -56,   56,  -27,   13,  -11,   -6,   16,
     -12,   -1,   18,  -40,   18,   19,  -13,  -11,    7,   -2,    9,   10,  -39,    9,   46,  -48,
     -18,   59,  -32,   -3,   14,  -10,   10,  -13,   10,  -13,   14,  -11,  -10,    5,   31,  -43,
      10,   23,  -16,    3,  -29,   50,  -23,  -19,   16,   15,  -19,    3,  -20,   39,  -19,  -14,
      -6,   54,  -44,  -12,   18,   30,  -56,   28,  -15,   22,  -16,  -15,   31,   -8,   -9,   -1,
       1,    1,    2,   -8,    9,   10,  -43,   41,   -9,    8,  -48,   62,  -30,   -9,   13,    6,
     -24,   32,  -31,    8,   -4,   16,  -27,   27,  -19,   -1,   -6,   37,  -40,   14,   -3,    0,
      25,  -59,   34,   18,  -18,  -21,   17,   13,  -11,   -8,  -11,   43,  -40,    1,    6,   24,
     -37,   10,   14,   -4,  -12,   -2,   17,   11,  -40,   10,   16,   17,  -51,   24,   14,   -4,
     -31,   22,   18,  -32,   15,  -24,   46,  -38,    9,    2,   -2,   14,  -15,  -12,   15,    3,
     -28,   29,   -7,   -6,   13,   -7,   -6,    2,    3,  -17,   28,  -28,   -9,   37,  -17,    0,
       3,   10,  -19,   -5,   19,  -17,   12,  -25,   30,  -19,    8,  -27,   49,  -15,  -27,    9,
      10,    7,  -31,    6,   30,  -12,  -45,   41,   24,  -42,   -1,   28,   -2,  -38,   29,  -18,
      23,   -4,  -43,   35,   26,  -54,   23,    7,    6,  -30,   17,  -14,   32,  -40,   24,  -13,
      17,  -15,  -11,   16,   16,  -20,  -26,   47,  -10,  -26,   -6,   41,  -19,  -22,   36,  -41,
      33,    5,  -32,   12,   28,  -51,   19,   27,  -40,    7,   35,  -34,    9,  -22,   42,  -20,
     -15,   -3,   43,  -55,   15,   23,  -10,  -11,    3,   14,  -32,   31,  -26,   21,    7,  -44,
      15,   40,  -22,  -41,   54,  -17,  -17,    8,   -6,   10,   11,  -17,   -6,   15,   -2,  -20,
      31,  -19,    4,  -17,   22,    0,    2,  -36,   39,    0,  -31,   23,  -38,   59,  -15,  -29,
     -13,   69,  -50,  -22,   43,  -11,  -16,    0,   16,   -9,  -10,   13,    5,   -8,  -18,   27,
      -8,   -2,  -12,   13,   -1,  -16,   16,  -18,   27,  -11,  -19,   39,  -28,  -26,   28,   36,
     -85,   72,  -40,   24,  -10,    0,   -9,   30,  -29,  -11,   22,  -13,   -7,   23,  -10,  -14,
       6,   13,  -15,   22,  -31,   12,    0,    0,   -3,  -15,   19,   14,  -21,  -22,   27,   35,
     -72,   36,   -3,   18,  -54,   50,  -29,   38,  -47,   14,   19,  -11,  -25,   27,    9,  -23,
      -2,    2,   16,   -6,  -24,   22,   10,  -27,    7,   16,  -30,   11,   24,  -40,   31,  -28,
      29,    1,  -28,    7,   17,    3,  -45,   40,  -11,   -7,    4,   19,  -45,   24,   24,  -50,
      48,  -35,   11,    9,  -12,  -14,   30,  -23,    8,    7,  -15,   -7,   53,  -59,   13,    5,
      15,  -46,   49,  -48,   57,  -36,  -20,   34,    1,  -10,  -15,   15,   20,  -36,   -9,   35,
       6,  -39,    7,   14,   27,  -81,   70,  -21,    5,  -22,   21,   -6,    1,  -13,   19,  -19,
       4,  -10,   35,  -43,   31,   -3,   -7,  -15,   40,  -56,   33,   -1,  -33,   51,  -35,   -2,
      24,  -18,    5,    0,    4,  -16,   10,   -6,    9,  -28,   37,  -38,   45,  -35,    0,   37,
     -38,    7,   19,  -32,    3,   17,   -2,  -23,   19,   15,  -23,    5,   -2,   13,    1,  -37,
       8,   59,  -80,   26,   13,   15,  -31,   -8,   30,   -7,   -7,  -19,   22,   -2,   -9,   -2,
      12,   -7,    3,    1,  -25,   47,  -53,   35,   -5,  -27,   21,   15,  -25,   13,  -24,   42,
     -41,   19,    2,  -13,    1,   23,  -40,   37,  -45,   46,   -8,  -41,   44,  -11,  -17,   23,
      -9,  -20,   22,   -3,  -15,   22,  -23,   19,   -7,    2,  -34,   65,  -56,    7,   28,   -8,
     -37,   37,    3,   -8,  -34,   39,  -11,    9,  -29,    6,   35,  -14,  -49,   48,    5,  -25,
       5,  -25,   66,  -47,   -9,   28,   -7,  -12,    0,   17,  -20,   -2,   21,  -12,  -23,   54,
     -50,   20,    7,  -20,    7,   -2,    3,    4,  -26,   26,   -6,  -14,   15,   -3,  -10,   12,
     -10,   -4,   23,  -33,   14,  -12,   38,  -55,   36,    0,   -6,   -5,    0,   -4,    7,    0,
     -14,    2,    8,  -11,   13,    5,  -33,   41,    4,  -62,   40,    8,   -6,   -8,  -31,   52,
      -4,  -44,   25,   20,  -18,  -24,   32,  -11,   -9,   -4,   30,  -37,   34,  -31,    7,   30,
     -29,  -14,   28,  -10,   -9,    6,    0,   -5,   14,   -9,   -3,   -2,   10,  -22,   29,  -22,
      -2,    6,   -5,   16,  -25,    6,   27,  -19,   -9,  -11,   29,  -13,   -5,   -6,   16,    5,
     -20,   -1,   30,  -20,   -8,    7,   -8,   -2,    3,   14,   -9,  -24,   35,   -7,  -14,  -12,
      32,   -5,  -18,  -15,   35,   -7,  -13,   -1,   -4,   27,  -20,  -30,   58,  -15,  -29,    9,
      15,  -16,   -3,    1,    4,    5,   -4,  -11,   17,    3,  -29,   28,  -10,  -18,   20,   -7,
      -2,    4,    2,  -17,   22,   -3,  -31,   23,   23,  -32,  -14,   34,   -3,  -14,  -13,   11,
      21,  -26,  -16,   36,   -7,  -13,   15,   -8,   -3,   -1,  -11,   15,   -8,   -4,   -4,   24,
     -21,    1,   11,    3,  -22,    5,   15,  -24,    0,   37,  -31,    7,  -18,   15,   16,  -15,
     -19,   26,    0,  -10,  -26,   31,    6,  -19,   -6,   21,  -19,   20,  -13,   -3,   13,   -2,
     -32,   24,    2,   -8,  -10,   36,  -29,  -10,   19,   10,  -25,    5,   -9,   31,  -23,  -21,
      21,   26,  -25,   -9,   -5,   35,  -17,  -34,   17,   42,  -44,  -11,   30,   11,  -40,   18,
       8,   -6,  -11,   11,  -26,   39,  -18,  -23,   37,  -12,  -32,   45,   -8,  -22,    5,   16,
     -15,  -10,    6,   17,  -15,   -3,    9,  -22,   41,  -22,  -25,   29,    5,  -30,    6,   12,
      17,  -32,    7,   20,  -26,    9,    9,  -10,    7,  -17,   10,   11,  -16,   -7,   12,    5,
      -4,  -26,   25,   24,  -46,   -4,   50,  -39,  -11,    8,   35,  -36,    2,   -9,   33,   -7,
     -22,  -26,   76,  -37,  -41,   33,   28,  -43,   14,    6,    2,   -8,    2,  -20,   34,  -19,
      -2,   -4,   15,   -6,  -23,   28,   -3,  -32,   33,  -16,    7,  -11,   14,    9,  -10,  -30,
      35,  -25,   17,  -14,    1,   14,   12,  -38,   16,   15,   -7,  -30,   15,   18,  -24,   -6,
      47,  -38,    6,    7,   -9,   -2,   -3,    1,   12,   -8,  -23,   20,   35,  -47,  -14,   51,
      -9,  -48,   19,   20,    0,  -25,   -2,   20,   16,  -29,  -25,   60,  -17,  -23,   -8,   31,
      -4,  -30,   12,   20,  -14,   -4,   -1,   17,  -11,   -9,    7,    7,  -17,    1,  -12,   25,
      -5,  -20,   15,   19,  -29,    2,    5,   11,  -19,  -18,   31,    1,  -27,   18,  -17,   51,
     -53,   -2,   29,    4,  -37,   17,   11,  -11,  -23,   41,  -17,  -10,   13,   -4,   -8,   18,
     -27,   17,    1,  -19,   -7,   51,  -37,  -28,   53,    4,  -47,    5,   18,   17,  -32,   -8,
      14,   36,  -46,    3,   11,   11,  -24,    4,    0,   16,   -7,  -26,   25,   20,  -44,    7,
      20,  -12,    2,  -14,    4,   33,  -38,    1,    8,   20,  -34,  -12,   61,  -46,  -19,   44,
     -10,   -4,  -18,   12,   12,   -8,  -26,   16,   22,    2,  -51,   18,   53,  -56,   -5,   30,
      -9,  -22,   32,  -11,  -18,   18,   13,  -25,   -7,    8,    9,    3,  -20,    1,   32,  -27,
      -9,    5,   19,  -20,  -13,   18,    8,    3,  -35,   22,   31,  -47,   -2,   16,   -8,   15,
     -10,  -22,   54,  -20,  -23,   -6,   51,  -52,  -13,   48,  -23,  -11,   28,  -30,   38,   -6,
     -50,   28,   33,  -58,    2,   34,   16,  -53,   -1,   55,  -13,  -42,   15,   23,   -7,  -33,
      13,   21,  -14,   -6,    2,   -2,   27,  -43,   27,   11,  -19,  -16,   26,  -16,   -4,   16,
     -17,    1,   20,  -17,    8,  -17,    6,   26,  -25,  -24,   40,  -13,    6,  -14,  -14,   29,
       3,  -32,   -5,   46,  -21,  -28,   38,  -30,    6,   28,  -47,    3,   65,  -67,   -5,   61,
     -34,  -27,   31,   12,  -30,   -7,   11,   19,    0,  -43,   18,   47,  -52,  -20,   52,  -14,
      -9,  -10,   -5,   55,  -45,  -29,   55,   16,  -83,   28,   36,  -23,    6,   -8,  -13,   37,
     -17,  -30,   32,   -9,   -6,   10,  -19,   16,    4,    9,  -35,   22,   -1,  -17,    3,    8,
      10,  -10,  -21,   40,  -27,   -5,   16,   -6,  -27,   47,  -23,  -26,   48,  -18,  -19,   14,
      -1,   -9,    5,    1,  -20,   58,  -57,  -14,   55,  -16,  -40,   37,   -6,   11,  -19,  -22,
      43,    2,  -55,   27,   37,  -38,  -29,   58,   -6,  -11,  -22,    4,   26,   -7,  -67,   67,
      21,  -56,   19,   15,   -5,    0,    2,  -41,   37,   10,  -65,   49,    8,    1,  -19,    1,
       9,    8,  -20,   -9,   22,  -14,   -3,    4,   -1,   13,   -6,  -11,   15,   -8,  -15,   13,
      16,  -38,   14,   24,  -39,   20,    9,  -17,   14,  -15,    7,    3,  -12,   -3,   30,  -25,
     -24,   43,   -1,  -40,   18,   17,    0,  -22,  -14,   31,   20,  -68,   35,   32,  -43,   -9,
      35,  -16,    4,    2,  -35,   35,   27,  -81,   40,   31,  -21,  -30,   29,  -12,   13,   10,
     -42,   26,   17,  -33,   -1,   16,   12,  -29,    6,    4,   21,  -27,   -9,   39,   -6,  -54,
      40,  -14,   15,   -4,  -17,   20,    4,  -18,   -4,   23,  -24,   -3,   30,  -41,   15,   17,
      -4,  -29,   19,    4,   -9,  -10,   12,   17,  -21,   -7,   26,  -19,  -17,   17,    3,    1,
      -3,  -30,   47,   16,  -62,   -4,   68,  -29,  -54,   43,   -1,   -4,   20,  -42,   22,   34,
     -32,  -43,   63,  -12,  -26,    8,   -6,   10,   22,  -66,   55,   25,  -65,   15,    9,   21,
     -22,  -28,   36,    5,  -16,  -51,  102,  -49,  -12,    6,   21,  -12,  -23,   24,  -15,   11,
     -14,   -8,   31,    4,  -53,   64,  -35,   13,  -28,   23,  -23,   22,  -16,   13,  -22,   23,
      27,  -51,   -8,   41,    6,  -66,   36,   13,    4,  -26,    7,   11,    9,  -34,    0,   35,
     -21,  -15,   10,   34,  -57,   60,  -69,   60,  -22,    1,  -27,   27,   14,  -27,    1,  -13,
      35,   -2,  -51,   36,   35,  -49,    5,   -1,   31,  -42,   25,  -26,   34,   -7,  -60,   98,
     -46,  -22,   -1,   49,  -45,   -2,   10,   26,  -33,   25,  -36,   37,  -19,    4,   -3,   -7,
       9,    7,   -8,  -29,   48,  -23,    0,  -33,   45,    0,  -23,  -16,   47,   -7,  -31,   -9,
      38,   -2,  -36,   18,   -8,   43,  -55,   16,   -1,   41,  -72,   54,  -35,   24,    4,  -46,
      47,  -11,    6,  -40,   24,   10,    8,  -38,   16,   16,   24,  -98,   80,    2,  -28,  -28,
      44,   11,  -47,   31,   -7,   35,  -42,  -25,   41,   12,  -64,   34,   14,   -2,  -21,   24,
     -14,   11,   -3,  -24,   22,  -28,   46,  -51,   38,  -22,   35,  -40,    2,   11,   22,  -48,
      23,   -9,   34,  -35,  -24,   52,   -7,  -37,    9,   36,  -21,    0,  -32,   61,  -44,    6,
      -1,  -16,   41,  -28,   19,  -37,   49,  -11,  -38,   -8,   65,  -53,    9,  -21,   59,  -37,
       8,  -33,   59,  -13,  -80,   67,   19,  -39,  -28,   70,  -21,  -25,   -3,   23,   17,  -29,
     -44,   83,  -41,    0,  -23,   53,  -27,  -12,   21,  -19,   21,  -21,   13,   -4,  -12,   -5,
      38,  -58,   34,   10,  -22,  -16,   47,   -8,  -39,   19,   12,    4,  -46,   39,  -24,   48,
     -69,   45,  -18,   10,   -5,   -2,   -4,   10,   -5,    7,  -17,   -3,   20,    0,  -40,   26,
      40,  -64,   11,   34,    1,  -49,   11,   35,  -22,  -14,  -32,   98,  -47,  -37,    9,   76,
     -70,   -8,    7,   63,  -92,   56,  -49,   77,  -64,    2,   41,  -28,  -25,   37,    0,  -26,
      35,  -40,   16,    3,   14,  -46,   22,   18,   -6,   -9,  -11,   22,   26,  -44,  -46,   94,
     -60,   18,  -37,   69,  -33,    5,  -20,   42,  -32,  -20,   24,   -1,  -10,  -12,   39,  -31,
      13,    1,    9,  -47,   42,  -26,   39,  -73,   48,   48,  -73,  -13,   56,   14,  -78,   38,
      11,   12,  -50,    8,   39,    3,  -79,   73,    2,  -25,  -17,   23,   27,  -58,   26,  -37,
      67,  -49,   11,  -12,   62,  -82,   64,  -41,    3,   26,  -17,  -45,   55,   -4,  -22,   10,
      -2,   38,  -54,    8,    5,   47,  -79,    7,   54,   -7,  -64,   41,   49,  -73,   29,  -24,
      54,  -51,   -4,   14,   33,  -84,   82,  -46,   17,  -25,   57,  -44,   -2,   11,    8,   15,
     -66,   46,   19,  -25,  -44,   58,   10,  -38,  -23,   77,  -48,   -3,  -12,   24,   24,  -70,
      37,   21,  -15,  -48,   81,  -66,   44,  -29,    6,    4,    9,  -30,   31,  -24,    5,   19,
     -51,   34,   21,   11,  -92,   78,   19,  -44,  -54,  104,  -47,   -8,  -19,   29,   45,  -78,
       6,   55,  -11,  -75,   66,  -10,    8,  -38,   24,   10,    4,  -57,   66,  -20,  -25,   20,
       6,    9,  -71,  100,  -60,   -6,    8,   28,  -37,   29,  -42,   78,  -58,  -22,   42,   10,
     -69,   34,   33,  -36,   29,  -54,   81,  -54,    0,    7,    1,  -19,   22,  -14,    4,   -3,
      32,  -13,  -59,   86,  -54,    4,    0,   21,  -35,   43,  -68,   91,  -31,  -53,   38,   48,
     -72,  -15,   50,    3,  -11,  -72,   96,   -1,  -49,  -23,   81,  -21,  -57,   15,   63,  -67,
       5,   25,  -27,   34,  -48,   49,  -26,   12,  -33,   66,  -73,   14,   35,  -20,  -27,   45,
     -24,   12,  -12,    0,   24,  -50,   33,  -26,   45,  -65,   47,   -7,   -4,   -9,   19,  -19,
      -2,   15,  -17,   30,  -39,   25,    2,   -3,  -57,  109,  -86,   10,   14,   31,  -53,    7,
      32,    5,  -44,  -20,   84,  -35,  -34,   -6,   99,  -97,    1,   23,   40,  -65,   15,    9,
      36,  -45,  -22,   55,    4,  -55,   -3,   73,  -80,   63,  -49,   28,    2,  -10,  -19,   24,
     -13,    8,    1,  -15,    5,   22,   -4,  -57,   72,  -41,   16,  -45,   76,  -57,   30,  -26,
      38,  -16,  -34,   32,   12,  -53,   22,   47,  -46,   -4,    6,   45,  -65,   32,  -21,   45,
     -44,  -22,   69,  -44,  -16,   29,   19,  -59,   40,   -7,   42,  -77,   39,   -4,   29,  -74,
      27,   38,  -12,  -60,   69,    7,  -32,    1,   -9,   50,  -56,  -15,   19,   47,  -75,   44,
       5,  -22,   27,   -7,  -22,    0,   23,  -30,    1,    4,   33,  -44,   29,  -24,   57,  -67,
      17,   18,    4,  -59,   32,   48,  -72,   28,   -2,   13,  -10,  -21,   16,   58, -117,   85,
     -14,   -5,  -34,   21,   29,  -27,  -20,   31,   23,  -49,   16,  -14,   51,  -74,   24,   38,
     -38,  -16,   56,  -33,   -7,    3,    0,   36,  -80,   49,   23,  -19,  -48,   76,  -61,   43,
     -41,   27,  -11,   23,  -30,    8,    3,   15,  -14,  -22,   16,    3,   15,  -39,   11,   38,
     -13,  -70,   88,  -41,    2,    4,  -30,   80,  -84,   15,   37,   -6,  -61,   58,  -19,   27,
     -72,   64,   -6,  -16,  -30,   59,  -21,  -21,  -12,   44,   22, -101,   78,  -10,  -16,  -11,
      20,  -21,   31,  -36,   37,  -18,  -20,   46,  -24,  -23,   10,   21,  -36,   32,  -38,   68,
     -50,   12,   -6,   19,  -33,   14,  -16,   20,  -11,  -14,   47,  -59,   56,  -14,  -27,    5,
      29,  -43,   49,  -96,  106,  -35,  -41,   28,   35,  -30,  -29,   37,   12,  -11,  -58,   79,
     -31,  -16,  -11,   43,  -13,  -25,    3,   71,  -76,  -13,   64,  -39,    3,  -45,   66,  -13,
      -1,  -45,   80,  -40,    6,  -29,   26,  -12,    6,  -19,   21,   -4,    9,    0,  -37,   44,
     -28,   11,  -22,   19,    7,    1,  -45,   60,  -13,  -42,   32,  -16,   31,  -50,   35,   10,
     -22,  -23,   60,  -62,   21,   -2,   39,  -49,   -4,   24,   30,  -53,  -23,   66,  -33,    2,
     -34,   69,  -33,  -10,    7,   24,  -51,   28,    0,    9,  -24,   -3,   38,  -24,  -16,   -9,
      68,  -81,   38,  -16,   35,  -34,   -4,   16,   20,  -43,   10,    7,   -3,   14,  -30,   38,
     -39,   38,  -20,  -12,  -20,   78,  -79,   22,   -4,   44,  -48,   -6,   37,   -2,  -25,  -24,
      60,  -41,   15,  -30,   50,  -43,    7,    9,   27,  -64,   45,    5,  -15,  -17,    1,   49,
     -56,    3,  -11,   69,  -78,   37,   -5,   38,  -60,   26,   -2,    9,  -51,   53,  -20,   -3,
       9,   -1,   38,  -74,   40,    6,  -13,  -54,   69,  -24,    6,  -22,   31,    0,  -17,   12,
     -13,    8,   -9,   20,  -53,   56,  -27,   29,  -63,   41,    8,   11,  -73,   59,   15,  -25,
     -21,   -1,   61,  -69,   10,   17,   28,  -59,   34,  -14,   32,  -54,   17,   22,  -11,  -47,
      63,    7,  -56,   46,  -28,   50,  -96,   60,    2,    0,  -37,   36,  -11,   15,  -38,   41,
     -19,  -31,   46,  -12,  -25,    9,   49,  -67,   47,  -48,   51,  -30,  -15,   23,   19,  -43,
       8,   17,    4,  -11,  -29,   54,  -48,   38,  -28,   10,   -9,   38,  -48,   27,  -47,   55,
       3,  -59,   22,   41,   -5,  -59,   38,    5,   31, -101,   72,   11,  -36,  -18,   54,  -25,
      -1,  -30,   54,  -28,  -34,   61,  -27,   13,  -46,   55,  -21,  -10,  -21,   52,  -34,   -8,
      30,  -21,   20,  -11,  -21,   22,   -2,  -46,   79,  -84,   60,   -9,   13,  -57,   51,    2,
     -16,  -38,   34,   15,  -23,   -7,   -6,   53,  -38,  -22,   29,   23,  -63,   65,  -34,  -21,
      34,   -7,  -19,   -8,   24,   13,   -8,  -63,  110,  -56,   -8,  -37,   79,  -56,   -3,   -3,
      62,  -57,   19,    9,    8,  -20,  -29,   27,   13,  -28,  -19,   79,  -80,   58,  -31,   24,
     -16,  -35,   46,    0,  -52,   36,   21,  -29,   16,  -23,   26,  -29,   38,  -42,   26,  -41,
      60,  -29,  -16,   -4,   42,    7,  -85,   53,   47,  -54,  -29,   67,  -53,   39,  -58,   45,
      -5,    5,  -37,   61,  -56,   27,   17,  -40,    1,   15,   17,  -43,   19,    4,   30,  -49,
      12,   -1,   49,  -64,  -27,   96,  -41,  -47,   45,    8,  -38,   35,  -50,   74,  -81,   54,
     -14,   24,  -64,   57,   -5,  -25,  -19,   27,   16,  -27,    4,   16,    2,  -25,   26,  -31,
      22,  -35,   56,  -54,    0,   55,  -23,  -29,    9,   38,  -38,   12,  -41,   74,  -28,  -29,
      -3,   61,  -71,   36,  -32,   43,  -19,  -14,   21,    0,  -10,  -19,   32,  -42,   20,   11,
      23,  -94,  107,  -13,  -53,    5,   35,  -17,  -11,  -25,   32,   40,  -76,   29,   32,   -9,
     -65,   80,  -42,    6,  -22,   42,  -27,   -2,   10,   -2,   13,  -41,   32,   10,  -17,  -26,
      53,  -50,   40,  -42,   30,  -19,   41,  -50,   33,  -20,   -1,   40,  -67,    8,   29,   15,
     -58,   25,   32,   15,  -81,   46,   14,   -8,  -51,   24,   40,  -44,   17,   10,    2,  -26,
      47,  -68,   49,  -49,   50,  -27,   -3,  -20,   84,  -62,  -32,   52,   12,  -52,    0,   42,
     -30,   24,  -47,   45,  -16,   11,  -51,   74,  -47,   -9,   45,  -19,  -18,   -5,   41,  -39,
      11,  -33,   56,  -20,  -14,   -8,   64,  -85,   60,  -23,  -13,   -3,   33,  -20,  -25,   57,
     -34,    2,  -23,   42,  -21,    3,  -49,   85,  -35,  -27,    1,   54,  -34,  -31,   24,   15,
       6,  -45,   54,  -30,   12,  -27,   40,  -61,   39,    1,   -5,  -18,   17,   14,    7,  -33,
     -27,   83,  -44,  -40,   21,   66,  -82,   32,   -7,   33,  -54,   27,    3,    2,  -13,  -15,
      52,  -57,   14,   14,   -6,  -27,   54,  -45,   23,  -11,   16,  -27,   27,  -33,   -3,   36,
     -46,   47,  -15,   -8,   -7,   67,  -93,   12,   34,   17,  -73,   32,   15,   29,  -44,  -17,
      47,    2,  -40,  -31,   81,  -43,    3,  -24,   52,  -32,    4,    1,   20,  -48,   20,   40,
     -68,   23,   14,   19,  -64,   46,   -8,   17,  -48,   55,  -29,   23,  -59,   48,   -2,  -27,
      11,    1,   21,  -30,   25,  -24,   29,  -41,   21,    0,  -15,  -17,   64,  -47,    1,   31,
     -22,    2,  -11,   22,  -56,   69,  -53,   32,  -30,   31,  -16,   32,  -68,   29,   42,  -39,
     -49,   80,   17,  -74,   17,    0,   55,  -88,   25,   29,   14,  -72,   56,    0,    0,  -33,
      20,    5,  -34,   35,  -33,   45,  -37,   23,   -9,   10,  -54,   67,  -22,  -13,  -15,   41,
     -14,  -16,    8,    0,   19,  -51,   56,  -51,   39,  -20,   19,  -34,   26,  -18,   19,  -31,
      23,    0,   12,  -31,    7,   45,  -65,   22,    4,   24,  -73,   74,  -13,  -34,   18,   23,
     -16,  -25,   -2,   40,    5,  -84,   76,   -4,    6,  -74,   75,   -7,  -10,  -51,   60,  -13,
       0,  -45,   50,   18,  -57,   20,   21,   -7,  -26,   47,  -51,   28,  -19,   12,  -13,    3,
      -1,   20,  -23,    1,   28,  -18,    3,  -41,   67,  -72,   34,  -11,   33,  -47,   47,   -9,
     -20,   -2,   28,  -21,  -27,   11,   26,  -15,  -25,   57,  -44,   46,  -67,   49,   -5,  -30,
       1,   42,  -36,   -9,   22,    7,  -13,  -34,   67,  -29,  -16,  -26,   84,  -49,  -21,  -11,
      77,  -53,  -43,   62,    0,   -3,  -32,   23,   13,   -5,  -69,   88,  -42,    7,  -17,   37,
     -35,   27,   -6,  -13,  -11,   31,  -17,  -28,   45,  -17,    8,  -32,   41,  -48,   39,  -35,
      41,  -16,  -28,   41,   -3,  -13,  -26,   23,   12,  -22,  -50,  104,  -57,    9,  -28,   67,
     -53,   -7,    0,   45,  -41,  -22,   50,   -8,  -21,   -9,   38,  -19,  -18,   -2,   55,  -76,
      38,  -12,   39,  -49,  -14,   64,  -24,  -45,   25,   50,  -66,   23,  -15,   32,  -36,   32,
     -46,   44,  -14,    2,  -16,   22,   -7,  -11,   14,  -28,   21,    4,  -10,  -18,   63,  -66,
      30,  -20,   36,  -35,  -16,   26,   12,  -37,    6,   50,  -35,  -15,    6,   48,  -64,    4,
      12,   46,  -85,   33,   12,   25,  -49,  -11,   77,  -53,  -18,   19,   29,  -41,   -1,    3,
      39,  -70,   55,   -6,   -1,  -23,   38,  -22,  -12,    1,  -11,   36,  -39,    5,   15,   33,
     -55,   32,   -8,    6,  -37,   39,  -32,    4,   27,  -23,   11,   -1,   10,  -28,   19,  -24,
      52,  -69,   27,   21,   11,  -72,   52,   17,  -35,  -13,   16,   33,  -44,    4,   19,   18,
     -60,   13,   35,   12,  -93,   82,    9,  -35,  -20,   26,   40,  -74,   14,   18,   28,  -66,
      37,    4,    9,  -43,   34,  -15,   17,  -35,   38,  -11,  -14,   14,   -5,    2,  -36,   54,
     -35,    2,    1,   29,  -35,    9,   -4,   24,  -32,   -5,   31,  -19,  -17,   28,   34,  -86,
      49,   13,  -16,  -52,   71,  -29,    3,  -30,   51,   -1,  -36,    6,   25,    4,  -75,   56,
      10,  -21,  -18,   37,  -16,   17,  -53,   60,   -7,  -38,   -9,   63,  -18,  -70,   67,    1,
     -19,  -32,   50,  -20,   11,  -23,   24,  -10,   -3,  -21,   32,  -26,    7,   12,  -19,   35,
     -29,   26,  -41,   32,  -22,   14,  -43,   41,    7,  -16,  -24,   57,  -20,  -35,   25,    7,
     -11,  -20,   31,  -18,   10,  -34,   44,   -7,  -22,   -9,   49,  -33,  -18,   26,   -4,   12,
     -63,   51,   11,  -16,  -40,   80,  -28,  -37,    5,   61,  -78,   22,   16,   -3,  -10,   -5,
      26,   -8,   -2,  -43,   68,  -42,  -24,   39,   11,  -31,   15,   -9,   18,  -20,   -1,    7,
     -17,   26,  -30,   31,  -31,   42,  -28,   -1,  -15,   49,  -51,   -2,   26,    3,  -12,  -11,
       7,   22,   -9,  -51,   70,  -27,  -14,  -13,   53,  -37,  -12,    9,   44,  -57,  -14,   51,
      -6,  -27,  -10,   60,  -55,    2,   14,   18,  -45,   32,  -19,   29,  -27,  -12,   31,   14,
     -54,   17,   41,  -62,   51,  -40,   40,  -40,   12,   -8,   28,  -39,   16,   10,   10,  -46,
      37,   12,  -42,   17,   -4,    2,  -17,   35,  -34,   38,  -30,   21,   -6,  -36,   36,   13,
     -56,   14,   53,  -36,  -13,   -1,   61,  -64,    7,   -3,   54,  -63,    5,   14,   34,  -67,
      10,   46,  -27,  -18,   26,   20,  -41,   14,  -13,   40,  -66,   20,   38,  -34,  -11,   39,
     -16,   11,  -26,    7,   28,  -58,   26,    0,   30,  -61,   44,   11,  -30,  -17,   66,  -40,
     -33,   35,    6,  -21,   -2,    9,   16,  -13,  -39,   79,  -71,   27,    9,   -9,  -29,   28,
       4,  -17,    1,   14,    2,  -20,   -2,   16,   24,  -67,   20,   37,   -4,  -80,   75,   18,
     -46,    2,   10,   25,  -31,  -28,   43,   19,  -75,   59,  -13,   14,  -40,   29,    7,  -22,
     -20,   44,  -20,  -16,   10,   32,  -21,  -42,   61,  -19,  -29,   12,   39,  -55,   32,   -4,
       0,   -2,  -24,   40,  -19,  -38,   34,   22,  -33,   11,   -3,   31,  -49,   21,  -16,   40,
     -54,   12,   29,  -19,   -8,   17,   17,  -52,   28,   22,  -39,   -2,   45,  -42,   23,  -46,
      51,   11,  -68,   26,   55,  -34,  -44,   45,    9,  -19,  -43,   57,  -16,   -5,   -9,   40,
     -24,  -12,    8,   29,  -54,   -4,   50,  -37,    0,   11,    7,   -4,    0,  -25,   57,  -62,
      19,   18,   -7,  -22,   12,   19,  -27,    9,   -5,   15,  -19,    2,   15,    4,  -45,   36,
      -5,    8,  -48,   60,  -13,  -35,   36,  -19,   21,  -24,   -7,   23,  -24,  -22,   73,  -58,
      -5,   34,   25,  -71,   19,   30,    0,  -43,   -4,   50,   -9,  -21,  -21,   69,  -28,  -46,
      24,   29,  -45,   12,    3,   21,  -13,  -28,   47,   -9,  -37,   21,   22,  -46,   21,    8,
      -1,  -32,   42,  -22,   14,  -27,   19,   16,  -29,    3,   17,   -1,  -39,   28,   21,  -42,
       8,   47,  -45,    2,  -16,   50,  -20,  -54,   50,    9,  -25,  -12,   41,  -29,    8,   -3,
      -5,  -13,   25,  -16,   19,  -30,   15,   15,   -2,  -52,   38,   38,  -69,   12,   37,    9,
     -54,   10,   36,    5,  -79,   27,   57,  -35,  -40,   48,   21,  -41,   13,   -3,   10,  -29,
       4,   18,    4,  -50,   52,    1,  -28,   -6,   41,  -25,  -22,   34,  -22,   10,   -5,    3,
      -6,   -1,    2,   26,  -48,   24,   12,    5,  -54,   36,   18,  -32,   -6,   -3,   48,  -28,
     -21,   22,   35,  -63,    6,   43,  -28,  -27,   42,   -7,  -22,    6,   21,    8,  -56,   31,
      23,  -10,  -73,   76,   18,  -49,  -26,   70,  -21,  -23,   -8,   35,    0,  -42,    7,   42,
     -26,  -28,   47,  -31,    0,   13,   11,  -25,   14,   -6,   10,  -13,  -26,   40,  -14,   -5,
      -8,   42,  -36,    1,   15,  -10,  -34,   47,  -24,    5,  -22,   38,   14,  -39,  -10,   53,
     -26,  -67,   72,    0,  -15,  -25,   29,   19,  -29,  -25,   50,  -14,  -31,   10,   42,  -44,
     -24,   81,  -40,  -32,   12,   45,  -41,   -5,   -1,   47,  -27,  -54,   54,   32,  -64,    4,
      26,    1,   -1,  -41,   44,    4,  -22,  -22,   47,  -30,    7,    5,    3,  -37,   45,    1,
     -53,   44,   -1,  -20,    7,   12,  -13,    9,  -23,   26,   -2,  -47,   32,   37,  -61,    6,
      42,    0,  -25,  -43,   76,  -23,  -38,  -10,   73,  -24,  -57,   47,   45,  -70,    3,   19,
       7,  -19,   -8,   10,   24,  -12,  -36,   66,  -60,   -1,   50,  -32,  -19,    8,   26,    2,
     -44,   11,   53,  -42,  -26,   20,   42,  -52,   14,   16,  -26,  -11,   42,  -41,   16,   16,
     -23,   13,    1,   -6,   17,  -18,  -41,   71,  -39,  -23,   40,   13,  -30,    2,   19,    0,
     -39,   10,   24,  -15,  -25,   12,   66,  -81,    6,   47,    9,  -69,   12,   47,   -9,  -36,
     -27,   76,    9, -107,   58,   53,  -68,   19,  -10,   39,  -49,    8,   14,  -11,  -17,   21,
      18,  -25,  -17,   47,   -4,  -48,   32,   -9,   -4,   -3,    8,   -5,   29,  -40,   13,   14,
     -31,   24,    7,  -48,   27,   37,  -61,   22,   15,    7,  -46,   17,   10,   22,  -45,   -9,
      56,    1,  -73,   43,   34,  -51,  -15,   40,    2,  -47,   35,    8,   27,  -87,   31,   86,
     -94,  -27,   67,   10,  -44,  -15,   43,   11,  -46,    6,    9,   33,  -71,   35,   26,  -30,
     -18,   37,  -18,   -9,   20,  -15,    1,    5,    9,   -2,  -23,  -11,   50,  -42,   -3,   24,
       6,  -21,   17,   -5,   -8,   11,  -26,   24,  -19,   -9,   33,   22,  -78,   38,   44,  -48,
     -53,   80,    6,  -66,   14,   36,    8,  -37,  -15,   66,  -24,  -75,   87,  -14,  -27,  -10,
      45,  -12,  -38,   13,   33,    7,  -67,   20,   75,  -55,  -67,   85,    8,  -52,  -11,   45,
     -10,   13,  -34,   12,   26,  -36,    7,   -1,   -1,   -7,   23,  -27,   18,   15,  -12,  -28,
      27,   -6,    9,  -52,   40,   26,  -50,    3,   51,  -10,  -71,   67,   10,  -59,    4,   56,
     -27,  -20,  -19,   58,    6,  -81,   38,   49,  -39,  -39,   47,   14,  -25,  -40,   54,   -2,
     -20,  -38,   82,  -25,  -51,   44,   24,  -60,    8,   51,  -47,   -2,    6,   22,    9,  -34,
     -20,   78,  -56,  -25,   36,   19,  -49,   17,   32,  -50,   44,  -29,    4,  -11,   14,    3,
     -13,  -11,   19,   13,  -24,   28,  -32,   33,  -37,   39,  -61,  119,  -76,  120,  -70,   99,
    -122,   89, -113,   91, -123,  122, -123,   77,   86, -116,    6, -118,  123,  -23,   64,  -93,
      17,   24, -125,  124, -125,  124,  -24,  -12,   56,   87,  -54,   38,  -91,   64,   -2,  -41,
     126, -127,   20,    8,  -48,  -62,  127, -128,   88,  -43,  -18,   86, -100,   44,  -32,  -26,
      71,  -13,    6,   51,  -33,  -50,  106,  -59,   33,    5,  -20,   69,  -56,   54,  -48,   -6,
      38,   -5,  -38,   35,   -1,   12,   -1,    4,   23,  -56,   19,   -7,    5,   -4,   31,  -38,
       3,  -12,   -9,  -25,   -7,   24,  -32,   17,  -21,  -22,   24,  -20,    6,  -18,    0,  -15,
       5,  -16,   15,    3,    2,  -10,    3,   27,  -31,   37,  -12,   32,   -5,    2,  -21,   27,
     -14,   20,   -8,    5,   15,   -7,  -11,   20,  -37,    7,  -23,   17,  -22,   11,  -14,    8,
     -44,   39,  -52,   26,    3,   14,  -10,   51,  -45,   29,  -19,   19,   -3,   41,  -21,   46,
     -23,   10,   16,  -25,    3,    7,  -30,   19,   -9,   -5,   -1,    1,  -19,    1,  -24,  -23,
      51,  -48,  -10,   17,  -34,  -38,   60,  -71,   26,  -43,   65,  -59,   70,  -26,   61,  -51,
      63,  -51,   42,  -25,   58,  -36,   31,   10,  -14,   -9,    8,  -18,    8,    4,    8,    7,
      31,  -52,   39,  -53,   53,  -56,   24,   11,    1,  -20,   -8,  -32,  -18,  -10,  -25,    4,
       1,   37,  -37,   42,  -42,   53,  -57,   52,  -18,   30,   11,   20,  -52,   55,  -61,   56,
     -50,   24,  -26,   38,  -42,   36,   -1,  -43,   58,  -46,    6,   18,  -35,   31,  -36,   28,
     -55,   55,  -98,   52,  -41,   26,  -24,   48,  -31,   48,  -26,   30,   19,  -17,   23,   -8,
      13,   15,   19,   -7,  -23,   41,  -36,   20,  -39,   65,  -64,   66,  -38,   -9,    7,  -14,
     -10,   -3,    6,   15,  -19,  -40,   53,  -67,  -11,  -12,  -25,   23,  -11,  -12,   46,  -48,
      39,  -20,   20,  -14,   31,  -54,   71,  -25,    2,   -8,   -5,   -9,    1,    7,   27,   17,
     -14,   43,  -31,   27,   11,  -33,   20,   -2,  -33,   45,  -38,   17,   -9,  -11,  -17,  -22,
     -19,   20,  -25,    4,   29,  -35,   14,  -17,    1,   -7,   19,    2,   16,   32,   -3,  -17,
       4,    0,   -9,   17,    5,   -8,   52,  -32,   40,  -39,   -5,  -18,   14,  -21,   31,   10,
     -17,    8,  -34,   -7,    1,  -44,    7,   10,   -8,   -6,  -18,  -25,   -1,  -19,   16,  -29,
      62,    6,    9,   21,    0,  -14,    4,    5,   20,   13,   27,   -1,   18,   -5,   21,  -31,
      11,    2,   -9,   -4,   21,  -27,    8,  -21,  -28,  -19,   14,  -12,    5,  -20,   20,  -36,
       4,  -18,  -27,   -4,   -4,   15,    4,   48,   -7,  -11,   20,   -6,    7,   20,    1,   20,
       0,   35,  -35,   28,  -37,    7,  -43,   21,  -22,   23,  -18,   12,  -22,  -13,  -20,  -11,
       7,   23,  -10,   19,  -18,   17,  -41,    4,  -16,   -8,   21,   11,   -4,   10,   30,  -24,
      32,  -15,   15,  -13,   28,   -5,   38,  -10,    0,  -22,  -13,  -12,   24,  -18,   30,   -7,
       4,  -16,   27,  -28,   -3,   -1,   18,  -14,   31,  -24,   -3,  -13,  -19,  -36,   -2,  -31,
       9,   -2,  -12,   17,   12,  -50,   46,  -49,   43,  -15,   13,   22,   15,  -25,   10,   -8,
      -6,   14,   -2,   24,   15,    9,   17,  -13,    5,   14,  -15,    7,   20,    4,    4,   18,
     -16,    3,  -47,   31,  -46,   19,  -24,    5,  -19,   -1,  -42,   14,  -44,   18,   -7,   -1,
      15,    9,  -35,   32,  -44,   39,  -46,   23,  -16,   36,  -25,   45,  -34,   32,   -8,   10,
       5,   28,    0,   12,   11,    3,   20,  -23,    6,   -8,   16,    7,   17,  -19,   32,  -44,
       3,   -8,  -21,   -8,   -5,    2,  -29,    2,   -3,  -19,  -14,    3,    7,  -23,   10,    1,
       3,    8,   13,  -44,   20,   21,  -16,   23,    3,    5,   10,  -11,   32,  -11,   13,   -7,
      30,    4,   16,   -7,   -6,   -7,   14,  -40,    4,  -16,  -26,    3,   -1,    0,   -6,    5,
     -50,   37,  -27,   18,  -16,  -14,    6,   -1,   -4,  -15,    8,  -12,   14,    9,  -22,   42,
     -10,   23,  -11,   36,  -15,   13,   30,    1,   47,  -20,   33,  -14,  -12,    1,  -20,   -9,
      -9,  -11,  -13,    7,  -37,   25,  -47,   14,  -13,    4,  -12,    9,  -32,   18,  -48,   -1,
     -35,   -1,   -7,   35,  -20,   53,   -4,   34,   -7,   13,   19,    9,   30,    6,   45,  -22,
      23,  -18,   -6,   -1,    3,  -30,   14,  -15,    9,  -39,   10,  -33,  -13,  -24,   10,   14,
      14,  -10,    2,  -34,   -4,  -20,  -21,  -14,   40,  -10,   17,  -14,   28,  -17,   37,  -26,
      69,  -15,   38,    2,   21,  -25,   37,  -61,   13,   -9,    5,  -17,   18,  -41,   22,  -57,
      -1,   -9,  -13,   24,  -10,   38,   -5,    8,  -16,   -2,    1,   12,  -25,   -2,  -13,    2,
       2,  -16,  -19,   32,  -30,   22,   20,   -4,   12,   11,  -17,   19,  -17,   -3,   20,  -33,
      65,  -27,   32,  -14,    8,   -8,   13,  -19,    9,   -2,    7,   33,  -40,   18,  -18,  -18,
       6,  -23,  -11,  -11,  -28,    4,  -11,  -15,  -14,   -8,   -5,   34,   -6,   19,    1,   -3,
       9,   -1,    5,    5,   14,  -11,   40,   -3,   18,  -20,   16,   -7,    2,   -5,    9,  -16,
       9,  -17,    0,  -17,    4,  -17,   -3,    3,    8,  -14,  -19,   12,  -21,   -7,    1,   -2,
      -8,   16,    3,   -6,   35,  -23,   33,  -13,   11,   12,    3,   -7,   26,  -11,   19,  -18,
      23,  -22,   39,  -49,   39,  -50,   11,  -38,   26,  -29,   10,   -6,  -22,   15,   -8,   15,
     -37,   36,  -43,   39,  -43,   18,  -26,    1,   11,    4,   -2,    9,    7,    2,    7,   19,
       1,    1,   -4,   16,   -5,   16,   -9,   -3,    4,   -4,   -1,  -17,    0,   11,   16,  -27,
      12,  -15,   15,   -3,    0,   10,   -3,   -5,   12,  -13,   -7,  -13,  -31,   -1,   -3,  -17,
      15,  -31,   25,  -10,   15,   -1,    2,    4,   10,    7,   32,  -13,    7,  -22,    2,  -10,
      16,    1,  -15,   19,  -24,   16,  -18,  -12,   18,   -9,    9,   24,   -8,    8,   11,    0,
     -31,   17,  -55,   21,  -43,   40,  -40,   29,  -54,   44,  -34,   22,   11,   16,    7,   19,
      21,   -6,    2,   -7,  -16,   22,    0,   -1,   -4,    5,   -8,   26,  -42,    4,   -6,  -21,
      35,  -16,    8,    0,  -22,  -13,   11,  -31,    7,  -28,    4,   17,  -12,  -18,   -2,  -23,
      23,   -1,   19,   34,    7,    7,   35,  -19,   11,   -8,  -17,    8,    4,   16,  -16,  -13,
       9,  -15,   -5,   -1,   -6,    7,    3,   11,    1,   -7,  -24,   21,  -31,   36,   -3,  -10,
       8,    2,  -17,   12,  -24,    6,   -3,    9,   15,    3,   13,   -8,  -13,   -3,    6,  -19,
      14,  -33,   16,  -17,   -5,  -31,    3,  -29,   24,   -7,   -6,   35,  -20,   -5,   34,  -20,
      25,   -3,   10,   25,    8,   14,  -13,    0,    1,   17,  -33,   51,  -38,   45,  -32,   39,
      -3,   -2,  -24,    3,  -18,   14,   -4,  -44,    2,  -25,  -15,   -2,  -23,    3,   -2,   -2,
      20,  -14,    8,  -10,   -4,   21,   11,  -13,   32,   -4,    8,   19,  -16,   -2,   -2,   -2,
      14,   -2,   -1,   27,  -26,   20,   11,  -13,   10,   -3,   -7,   12,  -13,   -3,  -30,  -16,
      10,  -26,   -3,  -10,   -2,   -9,   15,  -17,    1,   -2,   -7,   14,   -8,   12,   -3,   -1,
       2,   47,  -26,   22,  -19,   16,    2,   13,   -3,   21,  -10,   22,  -32,   43,  -24,   16,
       0,    5,   -2,   12,  -44,  -12,    1,  -26,    1,  -36,    5,    2,    9,  -17,   20,  -37,
      14,   -9,   -5,    6,   -3,  -13,   23,  -19,   25,  -33,    6,   17,   10,   19,   15,   -4,
      12,    5,   -9,   33,  -20,   26,   -9,   11,   -2,   11,  -21,   -7,  -13,   -4,   -8,  -12,
       0,  -10,   -9,    8,  -33,    9,  -26,    8,    6,   -8,   12,    7,   -8,    0,    7,  -16,
      25,   -8,   27,   12,    0,    9,   -9,    4,  -17,   14,  -16,   11,   -8,   18,   -2,    4,
       2,  -20,  -18,   22,  -16,   -5,    3,  -24,   13,  -10,  -12,  -10,    2,  -16,   33,  -15,
      21,  -15,   -4,  -19,   29,  -22,   18,    2,   20,   12,   18,  -22,   -7,  -16,    7,  -19,
      14,    1,  -17,   33,  -22,   38,   -8,    3,   -3,   21,  -17,   51,  -43,   15,  -22,  -23,
      -6,  -12,  -14,   14,    9,    6,    4,  -31,    3,  -16,  -14,   22,  -22,    5,   13,  -25,
      17,   -2,  -18,    7,    1,    5,   36,  -16,   23,    4,  -15,   29,  -20,   10,    1,   24,
      17,   16,   -4,  -16,  -37,  -11,    1,  -33,   27,  -36,   17,  -22,    2,  -33,   16,  -29,
      32,   -7,   24,  -12,   14,  -12,   22,  -16,   15,  -20,   19,    9,   14,   12,   -1,  -24,
      13,   -6,   -1,   32,  -19,   24,   12,  -26,    4,  -31,  -38,   18,  -16,  -13,    3,  -14,
      -1,   11,  -15,   15,    0,   -2,   30,   -6,   35,  -23,   10,  -35,    5,  -14,   17,  -21,
      20,    4,    7,    8,   -5,  -15,   20,  -25,   26,    6,   -3,    3,    5,  -24,   26,  -35,
       4,    0,   -6,   13,  -23,    8,  -25,    1,   -2,    9,    3,   17,    4,    0,   13,  -15,
       3,  -21,  -16,    4,   -5,  -10,   11,   -2,    7,   23,  -22,   25,  -19,   18,   25,   -9,
      14,  -21,   -7,   11,  -24,   22,  -12,   -7,    6,    9,  -33,   11,  -20,    2,   -9,    2,
       3,  -13,   12,  -15,   23,  -21,   16,  -16,   -2,    8,   13,  -12,   18,  -10,   16,  -12,
      20,  -18,   18,   -1,   21,  -21,   20,  -30,   -6,   10,   -2,   13,   -6,  -15,    6,    2,
      -1,    1,  -19,    9,  -15,   -3,  -11,    0,   -5,    1,    5,    1,   -4,   -8,    1,  -16,
      23,    0,  -23,    2,    8,   -6,   38,   -4,    2,   13,  -17,   31,   -4,   -8,   22,  -14,
       0,   12,  -22,    7,   -7,   11,    4,   -4,  -12,   -9,  -22,    2,  -17,  -17,  -11,    7,
     -17,   19,  -24,    9,   -8,   -6,   29,   -4,   10,    4,    4,   23,   -1,    9,   -6,  -12,
      23,   16,   -6,   33,  -29,   12,   -7,  -10,   17,   -4,  -18,   21,    0,  -14,   -2,  -20,
     -21,   10,  -28,    5,  -18,   -4,    0,  -11,    1,    5,  -17,    3,    9,   20,    6,    1,
      -7,    2,   -7,    3,    9,  -22,   29,    6,   -1,   25,  -10,    6,   -1,    4,   12,   18,
     -13,   28,  -11,    6,  -15,  -14,  -22,   -7,    5,  -14,    1,  -16,  -12,   -5,    5,   -9,
       4,   -1,  -14,   21,  -10,   -5,    0,  -17,   -7,    2,  -10,    6,   11,    1,   37,  -17,
       6,   21,  -24,   41,    2,   23,    0,   10,  -18,   16,  -26,   14,  -21,  -19,   18,   -9,
     -14,   -1,   -9,  -14,   -3,   -7,  -10,    7,   -7,   19,  -11,   15,  -25,   -3,   -6,    2,
       8,  -10,    4,   12,   -3,   11,   -2,   -2,    5,   31,   -9,   39,  -21,   14,  -23,   18,
     -16,   -1,   -3,   -6,    0,   22,   -9,   -5,  -17,   -4,  -12,    2,   -3,   -7,   10,  -10,
       7,  -20,  -19,  -10,    0,  -14,   32,  -15,  -18,   13,   -9,    2,   17,  -14,    6,   36,
      -9,   28,    1,    0,   17,  -10,    5,   17,   -8,   12,   -2,    3,    2,  -22,   -6,  -14,
       6,    8,  -11,  -14,    2,  -23,   25,  -35,    3,  -18,    1,  -14,   22,   -1,  -12,   -7,
      -9,   13,   -4,   12,    4,   -3,   18,    0,    1,    8,  -14,   14,   -2,    1,   17,   -3,
     -14,   35,  -17,   19,  -14,   -6,    1,   -9,   18,  -17,   -4,  -13,   -2,  -14,   10,  -10,
      -6,    0,    3,    5,  -12,  -13,   -3,   -6,   -6,   11,  -13,   -7,   13,   -2,    6,   13,
      -7,   11,   -5,   23,    1,   29,  -17,   23,  -10,   18,  -16,   12,  -20,   10,    7,   -9,
      -5,  -21,   -9,    5,  -13,   -2,    0,  -15,  -11,    3,    0,  -18,    5,  -25,   -2,    3,
      -2,   -3,    4,    8,   14,   -7,   15,    4,    8,   19,    9,   11,    7,   -3,   14,  -11,
       1,   15,  -35,    3,    3,  -10,  -16,    0,  -15,    2,    3,  -12,   27,  -23,   32,  -15,
      10,  -14,    3,  -27,   10,  -15,   12,  -24,    7,    2,    9,   -2,   -2,   -1,    3,    1,
       1,    8,   -4,    0,    6,   -6,    1,    1,   -1,    8,  -11,   31,  -27,   13,    4,   -3,
       5,   -1,    0,    2,    9,    0,   12,  -31,    4,  -27,    1,  -25,   20,  -21,  -14,   12,
     -14,    0,   -5,  -23,   18,   -1,   15,   19,   -5,   20,   -8,   14,   -7,   16,    3,    0,
       8,   10,    0,   -8,  -10,    3,   -8,    9,  -12,    4,   15,   -6,    2,  -12,  -29,   -3,
     -16,  -11,   35,  -18,   -1,  -28,    7,  -12,    0,    7,   -5,   22,   10,   10,   -4,    6,
     -13,   21,  -23,   20,    8,  -13,   11,   15,   -6,   -6,  -22,   -1,    3,   14,    7,   11,
     -27,   12,  -17,  -12,    8,  -15,    3,   -8,   12,  -12,    5,  -30,   12,  -18,    9,   -2,
       3,    4,   15,    1,    5,   -9,    0,   -8,   24,   -2,   21,    5,   -4,   -4,   14,  -15,
       0,   -1,    3,   17,   -5,   13,  -19,  -10,   -4,   -6,   -4,   -7,   18,  -27,    8,    1,
     -12,  -21,  -13,    1,   -9,   11,    1,   -3,   -1,   22,  -21,    9,    6,   -3,   20,   -2,
      17,    7,  -12,    1,    4,    4,   -9,    9,  -20,   24,    7,   -9,   -3,   -7,   -6,   10,
       7,    3,    9,   -2,   -3,   -4,    1,  -19,   -8,  -16,    0,  -12,    0,  -25,    4,  -22,
      10,   -9,    0,   -3,   15,   -1,    8,   11,  -15,   10,   13,    1,   22,   -5,   15,    1,
      24,    6,    0,   -6,    5,    5,   10,    8,   -1,  -11,  -14,    3,  -31,    2,  -22,   -4,
      -8,  -15,   -2,  -31,  -12,    6,   -7,    5,    2,    3,   -4,   19,    3,    4,    7,    7,
      -8,   31,   -6,   26,    1,   -2,    2,   -3,  -10,   -4,   -4,    9,    3,   12,  -16,   16,
      -9,   -1,    5,    4,   -7,   13,  -17,    0,  -11,  -13,  -22,    1,   -9,    4,   -7,    7,
     -10,    5,   -1,   -6,   -3,  -21,    7,  -10,   18,   -3,    1,   -7,  -11,   11,   -8,   12,
      20,    3,   13,   16,   -1,    3,   13,   -3,   23,   16,   -3,   15,  -14,   12,   -6,   -8,
     -28,    0,  -33,    4,  -11,  -12,  -13,  -21,  -17,  -16,   -5,  -12,   16,   -7,   15,   -6,
      -5,    3,   -9,   21,   17,   13,   14,   11,   21,  -12,   31,  -18,    7,   12,    8,    9,
       7,    1,   -3,   -7,  -14,   17,  -35,  -10,   -2,  -18,   -8,  -10,  -20,  -22,    2,  -10,
      -3,    1,   -1,    4,   -5,   11,  -20,   11,   -6,   27,    7,   18,    8,   -1,    2,    3,
      11,   -9,    5,    5,   -7,   29,   -6,   20,  -21,   23,  -15,   19,  -19,    2,  -22,   11,
     -26,   -7,  -10,  -30,   -1,   -3,   -6,   15,  -22,   16,   -7,   -9,   -2,   -7,   -5,   11,
      17,  -13,    2,    8,   -5,    6,   27,   -6,   12,   -6,    4,   15,    3,   14,   -3,  -12,
      11,   -2,    6,    5,    4,   -6,  -12,    0,  -32,    2,  -22,   22,  -12,   -5,   -7,  -11,
      -7,    6,   -1,   -3,   -3,  -16,    2,   -1,    0,    0,   -7,   -2,    1,   12,   -4,    5,
      20,    1,   16,   -2,   14,   -1,   19,    8,   29,   -8,    7,  -14,   -2,    3,  -13,    8,
     -40,   22,  -18,    2,  -14,   -8,  -11,   -8,   12,  -21,   -1,  -10,  -12,   -6,   -4,  -14,
       6,  -19,    7,   14,    1,   11,   11,  -11,   25,    1,   14,   -5,   31,    0,   22,    4,
       1,    3,    6,   -3,    4,   -2,  -20,   -7,  -26,    1,  -12,   -7,  -10,    2,   -1,   -5,
      -7,   -8,  -10,    6,   -7,   -6,   10,  -17,    6,    3,   15,   -8,   15,   -7,   12,    1,
       9,   -4,   -2,   10,    9,   -1,   10,   -4,    9,   -8,   17,    0,  -13,   -7,   -2,  -11,
       3,   -2,  -15,   -4,  -11,   -5,   -9,    1,    8,  -10,    8,   -8,   -6,  -18,   21,  -19,
      26,  -19,   -1,  -11,   10,    4,   12,  -10,   16,  -10,   17,    8,   13,   -1,   17,    1,
       5,   -1,   11,   -8,    9,   16,  -17,    3,  -26,  -17,  -14,    6,  -17,    4,  -20,    0,
      -1,   -6,   -4,    2,  -15,   13,   -3,   -1,    0,   -2,   -8,   11,    7,   -3,   -8,    5,
      14,   -1,   28,  -19,   13,   -4,    8,    1,   11,    7,    6,   -8,   -2,  -13,  -10,  -22,
       6,   11,   -1,   -1,   -5,  -13,   18,    3,  -10,    9,  -17,   -8,    9,   -9,    1,  -17,
      -4,  -16,   18,   -6,   15,  -10,   17,    5,    0,   -5,    0,  -11,   12,   15,    4,    8,
       5,   -4,    0,   -2,    3,  -17,   -2,   -1,   11,   -6,   -7,    2,  -33,   23,   -6,   -1,
      -2,   -2,   -1,   -8,    3,  -29,   -2,  -34,   16,   -3,   16,    1,   10,  -12,   23,    0,
      -3,   16,   12,   19,   23,   -1,    8,  -26,   16,  -32,   26,  -13,    2,  -11,    5,   -1,
     -15,   -9,  -16,    7,   -6,   14,  -15,    5,  -10,   -7,   -9,   -9,    6,  -17,   13,   18,
      -5,   -3,   -4,   -4,  -18,   28,   -6,   13,   17,   24,   -2,    9,  -14,    1,  -11,    7,
      17,    1,  -15,   10,  -23,   -4,  -12,    5,  -20,   17,  -10,    6,    0,   -9,    4,   -8,
     -15,    6,  -16,    7,    9,    3,    6,  -12,  -17,    0,    4,   13,   22,   -4,   10,   -8,
       7,  -12,    5,    5,    1,   11,    2,   10,   -3,   -2,    3,  -10,   -5,   -7,   -4,  -18,
      17,   -2,  -14,  -16,   -7,  -10,   -3,    6,   -1,   14,  -11,   15,  -18,    2,   -6,    0,
      -1,    0,   20,  -17,    1,    6,    2,    6,   12,   -3,    7,   25,   -5,   17,  -14,    0,
      -6,    0,   -2,   -5,   -1,  -10,    8,    2,   -9,  -19,   -7,  -17,    5,    3,   -7,    4,
     -15,   -5,    9,  -12,   -1,   -5,    3,   -5,   26,   -2,    3,   -4,    5,    3,    7,   10,
       5,    6,    6,   26,  -17,    0,   -1,    3,   -3,   10,   -7,   -7,   -9,   11,  -18,    0,
     -16,   -6,   -5,    3,    7,  -14,  -14,    0,  -21,   14,   -8,   -1,  -12,    2,    1,    2,
      -3,   -1,   -3,   18,    5,    5,    9,   12,    7,   18,    8,    5,  -25,   16,  -15,   16,
      -7,    9,  -22,    1,   14,  -13,   -5,    2,   -6,   -8,   13,  -17,    6,  -16,    1,   -5,
     -14,   -6,   -6,  -15,   -2,    9,   -9,  -18,   15,  -19,   12,    7,    4,    8,   14,   15,
       6,   10,   -3,    9,   -7,   23,  -17,   21,  -20,    7,    0,   -9,    8,  -10,    1,    4,
       2,    3,   -9,   -9,  -15,   -6,  -21,  -16,   -6,    0,  -11,   19,   -8,   -9,    5,   -6,
       0,    5,   14,    7,    1,   12,    8,    7,   -5,   12,    8,   -4,   19,    4,   -7,    2,
       3,  -12,   -8,   -1,    0,    5,    7,   -5,   -8,  -22,   -8,  -21,   -2,   -9,   10,  -20,
      13,   -6,    8,  -17,   -9,   -6,    2,    5,    8,    6,   -3,   10,   -9,   -2,   15,   -6,
      20,    7,   11,   10,   -3,   -4,   -8,   25,  -25,   18,  -12,   17,   -6,   20,  -22,   -1,
     -17,  -10,    5,  -10,    9,  -13,   -9,   -6,   10,  -25,   -5,   -2,   -5,   13,    2,   -5,
      -8,  -10,   11,  -27,   10,   -4,   11,    0,   33,   -4,   10,  -14,    1,   12,   -2,   27,
      -8,    6,   11,    9,  -12,   -4,  -10,  -13,   12,    5,    1,  -10,  -14,  -15,   -8,   -7,
      -9,    3,   -5,   10,    3,  -11,  -12,  -13,   -3,   -3,    3,    2,    9,   17,   -6,   25,
      -3,   -3,   -8,   19,    3,   30,  -10,   12,  -22,    7,   -5,  -10,   -3,   21,   -8,   12,
       6,   -5,  -13,  -13,   -9,   -9,   -1,  -23,   13,  -17,   15,  -22,  -11,  -18,    8,  -14,
      20,    1,    4,   -5,    3,    3,    5,   11,    1,    2,   27,    1,   10,   -7,   -8,   -2,
      -2,    7,   -1,   17,   -5,   24,   -7,    5,  -10,  -20,   -6,    5,   -4,   -5,   -1,  -18,
      -5,  -14,   -1,  -20,    1,    7,   -7,   12,   -4,   -2,   -4,    2,    8,    0,    7,    1,
       6,   -2,   18,   -5,   -7,    4,    3,   -2,   13,    4,    0,    2,   -3,    2,  -10,   -6,
       1,   -6,    6,   -7,   -3,  -21,   -2,  -12,    5,   -1,   -9,    7,   -3,   13,    5,    5,
      -8,    0,   -8,   19,   -5,   13,   13,   -7,    3,    0,  -10,    0,   -8,   20,   -8,   13,
     -20,   -5,   -7,    3,    5,   -7,    2,   -5,   -4,  -14,   11,  -23,  -13,    2,   -1,   12,
      13,    5,   -6,   23,   -9,    9,   -6,   -9,   18,  -13,   16,   -3,   -7,  -17,    3,  -13,
      12,   -9,    4,    0,    0,   13,  -18,   -1,    3,  -13,   20,   -5,    1,  -20,   15,  -23,
      18,   -4,   -8,    5,   -7,   16,    4,    6,   -3,    7,  -21,   19,  -17,   -7,    9,    5,
       3,   -5,   -3,  -16,   -9,   25,   -9,   12,   -5,   10,   -5,    9,   -4,   -6,   -3,    4,
      10,   -2,   11,  -12,   -2,  -14,    8,  -23,   -5,    0,   -8,    9,   -2,  -11,   -3,   -9,
       9,    2,    2,    4,   -5,    7,   11,  -16,    0,   -6,    7,    6,   25,    5,    6,   -4,
       3,    4,    3,    2,   -8,   -3,    5,   -1,  -11,   -4,   -9,   -3,  -15,   10,  -12,   -5,
      11,   -4,   -7,    6,  -29,   -5,    6,   11,    3,    9,  -18,   13,  -14,   19,   -1,   -2,
       4,    5,   12,    1,    5,   -8,    3,    1,   20,   -6,    2,    3,  -16,   10,  -10,  -18,
     -11,   -7,   -7,    9,   -4,   -8,    9,  -15,   13,  -13,   -3,   -7,    3,    8,   11,   -6,
     -16,    1,   -8,   20,    4,   15,   -5,   -3,   11,   -5,    6,    0,   -5,   10,   13,    0,
      -6,  -11,    0,   11,  -11,   10,   -7,   -8,    1,   16,   -9,    2,  -22,   -9,    0,    4,
       5,  -12,  -22,    2,   -8,   -8,   14,  -16,    0,   13,    0,    9,   -7,    2,   -1,    7,
       8,   -3,   -3,    2,   15,    5,   10,   -7,   12,   -4,   22,   -4,   -3,  -12,   -2,  -15,
       8,   -2,  -22,    7,  -10,    5,   12,  -20,   -9,  -11,   -2,  -12,    2,   -9,    5,   -3,
      11,    7,   -9,    4,   -4,   24,   -7,   21,  -15,   -3,    2,   14,   -1,    5,   18,  -12,
      13,    3,    5,  -10,  -11,    0,   -8,   -2,   -4,    2,  -15,    9,  -10,  -16,   -9,   -7,
       0,   -1,    3,   -8,  -10,    5,   -8,    4,   -3,    8,   -2,   20,    1,    6,   -4,   -9,
       4,   14,    7,   -1,    3,   -5,   18,   -7,   20,   -6,  -10,    8,    1,   -2,    3,   -4,
      -5,   -3,   -6,    0,  -16,   -7,   12,    0,  -17,    4,  -31,   -7,    1,    1,   -4,    8,
     -11,    6,   -1,   11,   -5,   -7,   -4,    2,    4,   15,   -3,   21,   -5,   20,    3,  -12,
      21,   -1,   10,    5,    6,  -20,   -1,  -18,    2,    3,   -4,   -5,   -1,    6,   -2,  -11,
     -17,  -15,  -13,    0,    6,  -18,    7,  -18,    7,   -7,    6,    7,  -10,   18,   16,    2,
      -1,    3,  -11,    6,   14,    1,   15,   -2,   29,   -8,   17,  -14,    2,  -19,   12,    8,
      -6,   -1,  -23,    6,  -11,    7,  -19,  -18,    0,    1,   -8,   -8,   -4,  -20,    8,   -8,
       4,   10,  -12,   13,    0,   18,  -10,   -3,   -4,    6,    4,   17,    7,   -2,   18,   -9,
      14,  -10,   -4,  -11,    4,    3,   23,  -17,   -6,   -2,   -7,   -7,    9,  -10,    1,    2,
      -4,  -14,   -7,   -6,   -8,   -4,    7,    2,   -3,    3,    0,   13,  -10,   -4,   -9,   -6,
      18,   11,   -4,   16,   -8,   -4,    1,   -1,    7,    3,    3,    3,   10,  -15,   -2,   -9,
       9,    0,    2,    2,   -9,   12,   -7,    0,  -23,   -7,  -19,    2,   -1,    0,    4,  -15,
       7,    3,   -3,    0,    9,  -12,   19,    4,    8,  -13,   -6,    5,   -1,   14,   10,    9,
      13,   -3,   16,  -18,   13,  -18,    7,  -10,   13,   -6,  -11,   -3,    7,  -23,   -6,  -11,
     -21,    9,   -1,    4,   -3,  -16,    0,  -12,    7,   14,   -5,   15,    0,    6,   -5,   -3,
      -9,    9,    4,   10,    4,   -2,   -7,   10,   -1,   10,   -6,  -14,   15,   -4,   13,   -4,
      -4,  -14,    5,   -2,    4,   -9,    3,  -14,    2,    3,  -10,   -1,   -9,    0,    3,   -6,
      12,  -16,    0,    4,   10,  -25,    6,   -5,    2,    8,    3,   -2,   -4,   15,    4,    7,
       2,   -1,   -6,   10,   11,    2,   -2,  -14,    6,   -3,    0,   -3,   -9,  -10,    1,   -1,
     -15,    9,  -29,    9,  -10,    7,   -3,   -3,  -10,   -2,   14,    4,   -6,    0,    1,   12,
       4,   18,  -15,   19,    1,   15,    1,    1,    3,  -10,    8,   -1,    7,  -30,    8,  -19,
      -2,   -5,   -9,  -10,    0,   -1,    6,   -4,  -12,    1,  -18,   10,   -1,  -12,    2,    7,
      12,   11,    0,   -4,   -1,    6,   10,   17,   -8,    1,  -12,    5,   -2,    1,   -7,   -1,
       4,    3,   -3,   -1,  -18,    8,   -9,    0,   -2,    8,  -12,   12,    7,   -5,   -2,  -16,
      -7,    9,   -5,   11,   -9,   -4,    3,    1,   -9,   -1,   -2,   -6,    7,   12,    0,   -8,
       9,  -10,    3,    0,    2,   -3,   11,   14,    4,    3,  -12,    3,   -3,    2,   12,   -4,
      -2,   -2,    9,  -21,   -5,  -28,   -6,  -10,    6,    7,   -6,   -3,  -24,    7,  -11,   10,
       0,    8,   13,   10,    6,   -7,   -2,   -5,    7,   -1,    9,   18,   -2,   12,   -4,    7,
     -26,   13,   -6,   19,    6,    6,   -5,  -16,   -6,   -8,  -18,   -2,    1,  -11,    3,    4,
     -16,   -8,  -10,   -3,    2,   -3,    5,    5,    0,   11,    0,  -14,    0,    1,   14,   11,
      13,    0,   -2,    5,   -1,   -4,   -2,   -4,    5,   21,    3,   14,   -5,  -22,    5,  -11,
      -3,   -6,   -3,  -11,    0,   -5,  -13,  -10,  -18,    3,    9,  -10,    2,    3,  -11,   11,
     -11,    5,  -19,   23,   -1,   20,   18,    4,   -3,   -6,    9,    4,   -3,    8,    4,    6,
       2,    5,  -14,   -6,   -3,    2,   -6,   -4,   -3,  -11,    0,   -5,    0,  -21,   -2,  -10,
      11,    5,   -4,   -5,   -5,   -8,   10,  -10,    4,   -1,    6,   12,    9,    2,    8,  -20,
       8,   -2,   11,  -11,    1,   -4,    5,    6,   -6,    6,  -14,   14,    4,   -2,   12,   -3,
     -10,    8,   -5,  -15,   -9,   -1,    5,    8,   -3,    0,  -23,   -9,  -11,    4,  -12,    3,
      -4,    4,    1,   15,  -12,    3,   13,    2,    5,    8,   -8,    7,   11,   -3,   17,  -11,
       5,    3,   19,   13,    3,  -11,  -11,   -2,   -9,   -7,   -4,  -24,   -1,  -17,   -3,  -17,
       0,  -15,    2,   -1,   -5,   -4,    3,    2,    2,   11,   -4,    3,   -6,   11,    8,    3,
       6,    3,    7,    7,    6,   -6,    2,    0,   14,   14,    3,    8,   -6,    4,   -3,    6,
     -13,   -2,   -9,   -4,    5,  -13,   -5,  -21,   -1,   -6,   -1,   -5,  -14,    8,   -7,    5,
      -7,  -17,  -11,    7,    3,   20,    7,    1,   -3,    4,    5,   14,   -3,    5,    3,   10,
       8,    6,   -6,   -2,    6,    3,    7,   -6,   -3,   -3,   -6,   -1,  -27,  -11,  -17,    0,
      11,    7,    1,   -7,   -9,  -13,    5,  -11,    0,  -10,   15,    2,    5,   -2,   -5,    1,
       6,    6,   -6,   -5,    6,    2,    5,    3,   10,  -16,   11,    8,   18,    3,   13,  -11,
       7,    5,   -7,   -6,  -20,   15,   -1,   10,   -1,  -13,  -17,  -11,   -3,  -13,   -4,  -14,
      -3,   -2,   -6,    6,  -28,    9,   -8,   10,    0,   12,   -2,   10,    9,    1,    3,   -6,
       5,   17,   24,   18,    3,    4,   -9,   -4,    2,   -8,   -4,   -2,  -11,    1,   -8,  -12,
      -9,  -10,    5,    0,   -7,   -9,    7,  -18,    6,  -10,  -12,   -1,   -1,   13,    1,   18,
       2,   -3,    4,    3,    3,   -3,    3,   10,    9,    7,    5,   -8,   -7,    0,    3,   -7,
       7,   -2,   -2,    5,  -10,    2,   -5,   -3,   -1,    4,    1,   -2,  -10,    4,   -9,   -5,
     -12,  -18,    3,    6,   -3,    3,  -15,   -1,  -13,    6,   -2,    8,    0,    8,   16,   -2,
      17,   -4,    8,    3,   23,   -1,   11,   -8,   10,   -4,   -5,   -3,  -13,   -2,   -1,   -2,
       2,   -9,  -13,  -13,   -2,  -11,   -2,  -20,   -5,    0,    3,    2,   -1,  -10,    1,    8,
       3,    9,    6,    4,   -3,   13,    3,    4,   11,    2,   11,    8,   -2,   -1,   -2,   -2,
      -2,   -1,  -21,   -1,  -14,    8,    6,   -8,  -10,    2,  -16,    4,   -3,   -1,  -10,    7,
      -1,    4,   -4,  -12,    3,   -2,   13,    2,   -3,   -9,   -2,    6,   -7,    8,   -8,   -5,
      12,    7,    8,   -3,    6,   -1,   16,    0,    7,   -8,    3,   -7,   -1,    0,   -6,   -4,
      -8,    6,   -1,    4,  -19,    2,   -3,   -8,   -3,  -12,    4,   -6,    2,   -7,    1,  -13,
       2,    9,   -1,   17,  -19,    3,   -3,   23,    9,    6,    3,    6,    6,   -5,   11,  -11,
       1,    0,   -5,    6,   -6,   -4,   -5,   -7,    3,   -4,  -14,   -9,   -7,   -1,    5,  -11,
       4,  -19,   14,   -4,    3,    4,    2,    0,    9,   -2,   -3,    2,   -2,   10,   15,   -3,
      14,   -6,   -4,    6,    1,   -8,   11,   -9,    4,    3,   -9,    2,    2,   -2,    2,   -2,
      -9,   -2,   -2,    1,   -6,   -6,  -22,  -16,  -10,   12,    0,    5,   -8,   -2,   -4,   -2,
       5,   -1,    7,    7,    9,    1,    7,    6,   -1,   10,   11,    5,   -3,    8,    1,   -1,
       8,  -15,   -6,  -10,   12,    0,    2,   -5,   -9,  -12,   -7,   -4,  -14,   -4,    0,   -1,
       5,   -7,   -8,  -12,    0,    2,   16,   -3,   11,   -4,   16,   11,    2,   -3,    2,    8,
      -1,    7,  -13,    4,   -3,   -1,    3,  -10,   -2,  -11,    3,    2,    3,   -7,  -10,   -5,
     -10,   12,   -8,    5,   -7,   15,    1,  -10,    7,  -16,    1,    3,    4,   -5,    7,   -7,
       4,   -2,   -1,   -8,    0,   -2,   17,   10,   -2,    6,   -5,    3,   10,   -7,    2,   -3,
       4,    5,    5,   -3,   -8,   -8,   -1,    1,    7,   -5,  -11,   -2,  -10,   -4,  -15,   -7,
     -10,   -2,    2,   -4,  -10,   -8,    0,    2,    6,    3,    2,    3,   10,   14,    8,    7,
       3,    5,   -5,   20,   -6,   -1,   -2,    0,    1,   -2,   -2,   -8,    3,   -3,   10,  -14,
       3,   -3,   -2,    0,   -5,    0,  -15,    4,   -2,    0,    4,   -7,    3,   -8,    7,  -14,
      -2,   -6,    4,    2,    3,  -10,   -2,    5,   -3,   12,   -2,   -5,   -9,    1,    4,    1,
      11,  -12,   15,    5,   20,   10,   -5,    1,    5,    3,  -13,    6,  -16,    5,    1,   -5,
      -8,   -3,  -14,   -6,   -2,   -5,   -8,  -17,   -9,    3,   -6,   -2,   -3,   -3,    1,   14,
       2,    4,    5,    3,    8,    7,   12,    0,   11,    4,   16,    2,   -3,   -9,   -1,    1,
      -1,   -3,   -6,  -14,    4,   -6,    2,  -14,   -9,  -11,   -1,    0,    0,   -5,   -6,  -10,
       5,   -5,    2,   -3,    2,    2,   17,   -2,   -1,   -3,    3,   11,    1,   10,    2,    7,
       6,    5,   -5,   -3,   -3,   -2,    7,    2,    1,  -18,   -5,   -2,   -3,   -5,    0,   -2,
       0,    8,   -9,  -10,  -15,   -7,   -2,   -1,    6,   -8,   16,  -10,   13,   -4,    2,   -4,
       4,    7,    9,    6,   -5,   -2,    8,   -1,   11,   -6,   -1,    5,    8,    0,    9,  -20,
       0,   -9,    4,   -3,    1,   -4,  -11,    2,   -6,    0,  -12,    0,    1,    5,   -2,    1,
      -7,   -4,    3,   -1,  -10,    3,   -3,    7,    4,    8,   -9,   -6,  -10,    0,    0,    2,
      -4,    6,    9,   10,    2,    0,   -1,    2,   14,    3,    7,   -7,    2,   -2,   -2,   -6,
      -9,    2,   -3,    6,   -3,   -7,   -9,  -10,   -2,    2,   -1,  -11,    2,    1,    7,   -4,
      -7,  -19,    3,   -1,    6,    6,    6,    6,    0,    6,    7,    3,   -1,    3,    8,    3,
       4,  -10,   -5,   -7,    5,   -4,  -14,    2,   -8,    5,   -2,    2,  -16,   -4,  -11,    2,
       4,   -1,    2,   -1,    0,    5,    4,  -12,    3,    9,    7,   13,   -3,   -7,    2,    6,
      -1,    7,   -1,   -1,    5,   -5,    7,  -11,   -9,  -13,    2,    5,    2,   -2,   -7,    5,
       4,   -4,   -2,  -15,   -4,    3,    0,    0,   -5,    2,   -7,   -1,    9,   -2,   -1,    5,
       1,    1,   -4,   -5,   -4,    6,    8,    7,   -5,    4,   -7,    4,    0,    1,   -6,   -5,
      -2,    5,   -1,    0,    1,    1,    3,    9,   -4,   -2,   -4,   -9,   -1,    4,  -17,    1,
     -13,   11,   -1,    6,   -9,   -1,    5,    1,    8,   -3,    4,   -5,    1,    7,   -5,    1,
      -3,    5,    3,    4,   -7,  -11,   -7,    1,    5,  -13,   11,  -11,    1,    3,    6,   -9,
       6,   -5,   -7,    4,  -13,    5,   -7,   10,    5,    6,  -15,   -1,    6,    4,   18,   -7,
      -7,   -3,   -4,    2,   -5,    3,   -4,    9,   -4,    3,    3,   -3,  -10,    0,   -1,    2,
       5,   -3,    7,    3,    2,   -6,  -11,   -2,   -1,    4,   -5,    4,   -5,    0,   -5,    5,
      -5,   -4,    2,    4,    2,    5,   -8,  -13,   -3,    0,   -1,   -2,    4,    6,    9,    1,
       3,   -7,   -1,    1,   12,    1,    1,   -1,   -5,   -1,    2,   -8,   -9,   -7,   -2,    3,
      10,   -6,   -7,  -12,   -7,   -4,   -5,    6,    0,   10,    5,    7,   -4,   -2,   -8,   10,
       5,    9,    4,   -1,   -1,   -1,   -1,   -1,   -2,   -3,    3,    9,   -2,    9,  -14,  -13,
      -8,  -10,    1,    1,    3,    3,    1,   -3,  -12,   -5,   -7,    1,    6,    6,   -2,   -7,
      -3,   -3,    2,    2,    4,   -9,   14,    8,   11,   -3,    5,  -11,    1,   -1,    5,    3,
       8,    2,    8,   -2,   -6,  -13,  -10,    0,    4,    3,    4,   -3,   -9,    1,   -5,   -5,
      -6,    1,   -2,    2,  -10,   -6,  -15,    1,   -5,    4,   -1,    2,    2,    4,   10,    4,
       2,  -13,    0,    4,    8,   17,    2,    5,    4,    2,   -6,    5,   -5,    0,    8,   -2,
      -1,   -5,   -4,   -5,   -1,   -5,   -4,   -5,    0,    0,    1,   -9,  -15,   -3,  -12,    1,
      -1,   -7,   10,    2,    5,   -1,    2,   -6,    2,    2,   10,   10,   -1,    2,   -2,    4,
       5,    0,   -6,   12,    5,    3,   -1,   -8,   -8,   -4,   -4,    3,  -11,    0,   -1,   -1,
       0,   -2,  -14,   -6,   -9,    2,    1,    7,   -4,    3,   -1,    0,   -3,    1,    2,    7,
       5,    4,    3,   -2,   -3,    1,    6,   -1,    6,  -11,    7,    2,   -6,    2,   -4,    0,
       2,    3,   -7,   -9,    3,    0,    4,   -6,    0,  -21,    0,   -5,   -1,    0,   -1,    1,
      -6,   -1,   -1,    0,   -7,    5,    7,   -2,    8,   -4,   -1,    3,    9,   -6,   10,   -6,
       7,    9,   10,    9,   -6,    5,  -14,    6,   -5,    1,    2,   -3,    0,   -9,  -10,  -14,
      -2,   -3,    6,   -8,  -15,    3,   -9,    0,   -3,    0,   -6,   -1,    3,    9,   10,    3,
       3,  -10,    6,    1,    3,   -1,    9,   12,    4,    4,   -9,   -7,   -5,    8,    6,    1,
       1,   -4,   -5,   -5,   -1,  -11,   -3,   -4,    1,   -1,    1,  -10,   -7,   -2,   -3,   -4,
      -3,   -6,   11,    5,    3,    2,   -8,   -5,   -2,    3,    9,   13,    5,    4,    4,    0,
      -5,   -1,   -5,    9,    2,    3,   -9,   -4,    3,   -6,    2,    1,   -9,    5,   -2,    3,
      -2,   -9,   -8,  -15,   -5,   -3,    3,  -13,   11,    6,   -3,    1,   -6,   -6,   -1,    6,
       4,    6,    7,    1,    5,    0,    8,   -6,    7,    2,    6,    2,   -5,    0,   -3,   -1,
       3,   -7,   -1,   -3,    5,    7,    6,  -18,  -10,  -11,   -7,   -3,   10,   -4,    3,   -4,
      -8,   -5,  -12,   -3,   -4,   12,   10,    2,   -4,    6,    3,    1,    2,    0,   -3,    3,
       7,    7,   -5,    2,   -4,    1,    3,   11,    2,    3,    4,   -2,   -7,   -5,  -17,  -11,
       4,   -3,    5,   -7,   -7,   -6,   -1,   -8,   -5,   -5,    1,    7,    1,    2,   -1,   -9,
       7,    1,    7,    3,    3,    6,    9,    6,    1,   -6,   -4,    2,    5,    7,    4,   -2,
       1,    3,  -11,   -1,  -16,   -2,   -6,    1,    3,   -8,  -15,  -11,    4,   -1,    9,   -2,
      -5,    0,    6,    0,   -7,    0,   -8,    4,    2,    6,    2,    0,    2,    6,    2,   -2,
       4,   -2,    4,   14,    2,    2,   -6,   -6,   -3,    4,   -4,   -1,   -4,    1,   -3,   -6,
      -1,  -13,   -1,   -2,    7,   -8,   -7,  -10,    0,    4,    3,   -8,   -3,    1,    4,    6,
       4,    6,   -3,    5,    3,    4,    0,    6,    1,    4,    7,   -3,  -10,    8,   -1,    9,
      -1,    1,  -11,   -7,   -3,   -3,   -6,   -8,   -9,   -6,    1,   -3,   -6,   -6,   -5,    0,
       0,    2,   -3,    0,    6,    4,    3,    2,    7,    4,   11,   14,    5,   -1,   -5,    1,
      -2,    7,    3,    0,    1,    2,   -5,   -7,  -10,  -12,  -10,   -5,   -5,   -6,   -6,   -9,
       1,   -8,   -2,   -1,   -9,    1,    8,    2,   -5,   -2,   -5,    0,    5,    6,    6,    7,
       8,   10,    2,    0,   -3,   -1,    2,   13,    3,    0,   -6,    0,    1,   -3,    0,  -12,
      -2,    4,   -4,    4,   -8,  -11,   -1,   -2,    1,   -1,    2,  -12,    3,   -6,    1,  -12,
      -7,   -7,    3,    0,    9,    0,    1,    6,    1,   -1,    2,    1,    2,    8,    9,   -3,
      -1,    0,    7,    3,    8,   -1,   -4,   -1,    1,    3,   -9,   -1,  -17,   -3,   -2,   -4,
      -4,   -3,   -4,   -6,  -11,  -15,   -2,   -5,    6,   10,    1,    3,   -1,   -3,   13,    7,
       1,    6,    4,    4,    9,    5,   -3,   -5,    9,    3,    5,   -3,    1,   -3,    3,    0,
      -7,   -5,   -7,    0,   -5,    0,   -1,  -15,  -11,   -4,   -5,  -10,    2,   -7,    5,   -4,
       1,   -9,    2,    1,    8,    7,   10,    2,    2,    0,    4,    3,   -2,    0,    4,    2,
       6,    8,   -2,    4,    4,   -2,    5,   -3,   -6,    3,   -3,   -5,   -9,   -8,  -11,   -5,
      -1,   -1,   -5,   -7,   -5,   -8,    0,   -3,    5,   -7,   11,    1,    0,    2,   -3,   -1,
       3,    9,    6,   -3,    8,    1,   11,    2,    8,   -3,   -3,    6,    2,    1,    2,   -7,
      -3,   -2,   -4,   -8,   -3,   -3,    5,  -10,  -10,   -4,  -12,   -2,    3,   -5,    3,   -6,
      -8,   -2,    5,   -3,    0,    1,    4,    8,    4,    5,    0,    4,    8,    1,    7,   -3,
       0,    3,    4,    4,   -5,   -2,   -7,   -3,    0,    5,   -5,   -9,    3,   -2,   -1,   -2,
      -5,   -1,   -4,   -3,  -11,   -4,   -5,   -6,    0,    5,    0,   -5,    5,    3,    8,   -1,
       3,    3,    2,    5,    7,   -4,    3,    1,    3,   10,    2,   -7,    1,    0,    6,   -4,
      -3,   -5,   -7,   -2,   -4,   -3,   -6,    0,  -10,    4,   -6,   -4,   -7,   -2,    1,   -4,
      -1,   -3,   -1,    2,    6,    2,    4,   -2,    2,    4,    2,    5,   -3,    4,    2,    1,
       0,    8,   -3,    2,    5,   -5,    3,   -5,   -2,    5,   -5,    3,   -1,   -4,   -3,    4,
     -10,   -5,   -7,   -4,   -4,    0,    0,   -7,   -1,   -1,    2,    1,   -2,  -12,   -4,   -1,
       0,    4,   -5,    2,    0,    3,   12,   11,    3,   11,   -1,   -3,    6,   -6,    1,    1,
       7,    6,   -7,   -1,   -7,   -4,   -4,   -7,   -8,   -1,   -6,   -6,   -2,   -3,   -5,    0,
      -4,    8,   -7,    1,    4,   -3,    6,    1,   -7,    3,    5,    6,    5,   13,    2,    2,
      -4,    4,   -3,    1,    4,   -4,    2,   -3,  -10,  -10,   -7,   -2,   -2,   -2,    0,   -6,
      -2,    1,   -3,   -4,   -2,   -5,   -2,    7,    1,    6,   -5,    6,   -1,   -1,    2,   -3,
       4,   11,    2,   -1,    2,   -7,   -5,    8,    0,    3,   -3,   -5,   -1,   -2,    3,    1,
      -4,    4,    7,    0,    2,    3,   -3,    0,    1,   -5,  -15,   -5,   -3,    1,    3,   -3,
     -11,   -4,   -7,    1,   -2,   -1,   -1,    0,    1,    1,   -5,   -1,    3,   -2,    7,    1,
      -4,   -1,    0,    4,    5,    3,    3,   -1,    8,   11,    1,    4,    1,   -5,    7,   -6,
      -4,   -2,   -4,   -2,    3,   -8,   -3,  -13,   -6,    3,   -3,   -7,   -4,   -7,    3,    3,
      -3,    2,   -1,    1,   -4,   -2,   -2,   -5,    1,   11,    9,   -2,    6,   -3,    7,    7,
       1,    1,   -7,    2,   -3,    1,    4,   -4,   -4,    5,    1,    0,   -3,   -6,    2,   -3,
       0,   -8,  -12,   -6,   -2,   -3,    6,   -1,   -9,    0,   -1,    1,    3,   -2,   -1,    0,
       1,    6,    0,   -3,    5,    1,    6,    1,   -1,    4,    1,    7,   -3,   -1,   -1,   -4,
       4,   14,   -1,   -1,    2,   -4,   -1,   -6,   -8,   -8,   -3,   -2,    2,   -9,   -5,   -7,
     -12,    5,    0,   -3,   -4,   -3,    5,    4,    3,   -2,   -6,    4,    7,    3,    5,    7,
      -3,    8,    0,   -5,   -1,   -1,   11,   10,    3,    4,   -8,   -3,   -3,    1,   -3,    0,
      -4,   -3,    1,   -7,   -8,  -16,   -7,   -6,   -2,    3,   -7,   -2,    1,   -4,    0,   -5,
      -5,    1,    5,   10,    5,    0,    3,    0,    1,   13,    0,    5,    9,    6,    8,   -1,
      -4,    0,   -3,    6,    4,   -4,    0,   -3,  -15,   -2,  -12,  -15,   -3,   -6,    2,    1,
      -3,   -4,   -9,   -9,   -3,   -3,   -2,    3,    4,    9,    0,    2,    1,    2,   14,    5,
       3,    8,    2,    7,    4,   -4,   -4,   -1,   -9,    9,   -5,   -1,   -7,  -10,   -2,   -7,
      -4,    0,   -5,    2,    5,    1,    0,   -5,   -5,   -1,   -1,   -3,    4,   -8,    5,    3,
      -4,    4,   -5,   -3,    9,    4,    8,    0,    0,    2,    0,   -2,    0,   -2,   -7,   12,
      -1,    5,   -4,    2,   -3,    0,    2,   -2,   -4,   -2,    2,   -5,    3,   -7,   -9,   -4,
      -3,   -2,   -6,   -6,   -2,   -6,   -1,   -7,   -8,    1,    3,    6,   10,    4,    5,    0,
       5,    8,    1,    3,    8,    5,   11,   12,   -7,    4,    0,   -3,    2,   -1,   -8,   -7,
      -4,   -2,   -6,   -9,   -6,  -13,   -4,   -1,    0,   -9,   -5,   -3,   -4,   -2,    3,    1,
       1,    9,    4,    2,    6,   -1,    3,    6,    2,    0,   -3,    3,    2,    6,    3,   -1,
      -4,    4,    1,    2,    2,   -5,   -8,   -1,   -3,   -1,   -9,   -4,    1,   -5,    5,   -7,
      -4,    0,    3,  -10,    3,   -3,   -5,    1,    5,    4,    1,   -5,    1,   -5,    4,    1,
      -6,    0,    5,    8,    8,    1,    6,    0,    3,    4,    2,   -3,    1,   -3,   -3,    3,
     -10,   -6,   -8,   -2,   -1,   -3,   -6,   -6,   -5,   -6,   -6,   -5,    5,   -3,    5,    6,
      -2,   -1,   -1,   -4,    6,   -2,    6,    6,    2,   12,    8,   -2,    3,   -6,   -2,    5,
       4,   -3,   -2,   -5,   -4,   -7,   -6,    1,   -5,    2,    2,    0,    1,   -7,    0,   -4,
      -2,   -1,   -2,   -5,    7,   -5,   -2,   -3,   -2,   -3,    4,    4,    9,    0,    1,    1,
      -5,   -3,   -4,   -4,    4,    3,    6,    1,   -2,   -2,   -7,    4,    1,    1,   -3,    3,
      -1,    2,    0,   -7,    0,    0,   -1,   -3,   -2,   -1,   -5,   -2,   -3,   -8,   -5,   -5,
      -1,    5,    5,    2,    2,   -3,    4,    3,    4,    6,    3,   -1,   10,   -4,   -3,   -2,
      -3,    0,   -4,    0,   -2,   -2,    0,    2,   -5,   -2,   -5,   -9,    8,   -2,   -1,   -1,
      -3,   -3,   -2,   -6,    2,    1,    2,    9,    0,    1,    4,   -5,    2,    4,   -6,   -1,
       2,   -1,    6,    3,    0,   -5,   -3,   -1,    0,    3,   -3,    0,   -6,   -2,   -3,   -4,
      -2,    0,    3,    2,    2,    0,  -10,    1,   -6,   -5,   -1,   -2,    5,    3,    6,   -2,
      -6,   -1,   -3,    2,    4,    1,   -1,    0,    1,    1,    3,   -1,    5,   -1,    7,    6,
       1,   -2,    0,   -6,   -2,   -2,   -8,   -2,   -2,   -3,   -5,   -5,   -8,   -3,   -1,    5,
      -3,    1,    2,    1,    2,   -3,   -2,   -3,    2,    6,    2,    6,    0,    0,   -2,    9,
      -1,    3,   -2,    3,    0,    0,    0,   -6,   -6,   -1,   -5,   -7,    1,   -3,   -6,    2,
      -2,   -1,   -5,   -2,    1,    4,    2,    2,   -3,   -1,    6,   -2,    2,    4,   -3,    2,
       2,    2,   -3,    1,    0,   -4,    2,   -1,   -2,    3,    1,    1,   -1,   -5,   -8,   -2,
      -5,    0,    1,   -6,    3,   -4,    2,    3,   -6,    3,    0,    2,   -2,   -1,   -4,   -2,
      -4,    4,    0,   -3,    0,   -6,   -3,   10,   -3,    3,    0,    4,    7,    3,    0,    5,
       1,    5,    1,   -3,   -2,    0,   -6,    3,   -1,   -7,   -5,   -7,   -1,   -2,   -2,   -2,
      -3,   -2,    2,   -2,   -1,   -3,   -3,    2,   -2,   -6,   -3,   -3,    4,    3,    2,    0,
      -1,    5,    5,    8,    2,    2,   -2,    4,    0,    5,   -5,   -3,   -1,   -3,   -3,   -6,
      -4,   -2,    3,    0,   -2,   -2,   -5,    5,   -1,    3,   -1,   -1,   -3,    0,    0,   -5,
      -4,   -3,   -2,    5,    0,   -4,   -4,    1,    2,    6,    0,   -3,   -1,    2,    3,    7,
      -3,    0,   -4,   -2,    4,    3,    0,    1,    3,   -3,    1,   -7,   -4,    0,    1,    1,
      -4,   -4,   -4,   -9,   -1,   -2,   -3,   -2,   -3,   -3,    4,    3,   -1,   -4,    2,    4,
       4,    3,    2,   -1,    0,    9,   -1,    4,    2,    7,   -1,    6,   -2,   -2,   -5,   -1,
      -9,   -2,   -2,   -6,   -1,   -1,    1,   -8,   -6,   -5,   -1,   -1,    1,   -4,   -5,    3,
       1,    5,    3,   -3,    0,   -2,    7,    0,    1,   -2,    3,   -1,    5,   -1,   -5,    7,
      -1,    3,    2,   -5,   -6,   -2,    4,    2,   -1,   -3,   -1,   -1,   -1,   -1,   -2,   -4,
       1,   -5,    3,   -1,   -3,   -5,    2,    6,   -6,   -1,   -5,   -4,    4,   -1,   -1,   -2,
      -1,    2,    0,    3,    1,    4,    2,    7,   -1,    2,    0,   -2,    1,    4,   -5,   -3,
      -7,   -2,    0,   -1,   -1,   -3,    0,    0,   -2,   -6,    2,   -4,    2,   -4,    1,   -7,
      -2,   -1,    5,    3,   -2,   -7,   -4,    1,    6,    4,    5,    1,    4,    0,    5,    1,
      -1,    2,    0,   -3,   -3,   -5,   -6,    3,   -1,    5,   -1,   -2,    1,    1,    4,    2,
      -6,   -3,   -4,   -3,    2,   -2,   -8,   -3,   -6,   -4,   -2,  -11,    0,    0,    1,    6,
      -3,   -2,    1,    2,   10,    8,    4,   -2,   -1,    2,    2,    1,   -2,    3,    1,    5,
       3,   -1,    0,   -4,    4,   -7,   -2,   -7,   -8,   -4,   -3,   -2,   -7,   -7,   -3,   -1,
       5,   -2,    0,   -7,    2,   -1,    3,    1,    4,    6,    5,    8,    3,    2,   -1,    3,
      -3,    0,    0,   -5,   -1,    1,    1,   -5,   -3,   -2,    6,    4,    5,   -4,   -8,   -4,
      -3,   -2,   -5,   -4,   -4,   -4,    2,   -3,   -2,   -4,   -4,   -4,    6,    1,    0,    1,
       3,    3,    5,    2,    1,    0,    6,    2,   -1,    1,   -3,   -3,    2,   -1,    0,    1,
       3,    1,    4,   -4,   -5,  -10,   -8,    1,   -6,   -3,   -4,   -6,   -3,    0,    2,   -3,
      -1,    2,    0,    8,    1,    4,    4,    3,    6,    3,    1,    3,    5,    1,    2,   -4,
      -7,   -3,   -3,    3,    0,   -7,   -5,    0,   -3,   -1,   -2,   -4,    0,   -5,    1,   -6,
      -1,   -5,   -3,    1,    4,   -1,   -3,    3,    3,    5,   -1,   -2,    2,   -1,    2,    1,
      -1,   -5,    5,    1,    2,    2,   -4,    0,   -1,    3,    0,   -2,   -1,    2,    1,    5,
       4,   -3,   -5,    0,   -2,   -2,   -6,   -3,   -3,   -4,   -1,   -5,   -4,   -1,   -2,    0,
       2,   -2,   -6,   -3,    1,    1,    1,   -1,    3,    4,    7,    2,    3,    4,   -1,    7,
       2,    3,    1,   -1,    1,   -2,    0,   -4,   -5,   -6,    0,   -2,   -7,   -2,   -5,   -5,
       1,   -4,   -5,   -5,    3,   -1,    1,    2,   -2,    0,    1,    4,    1,   -4,    2,    2,
       0,    9,    2,    0,    4,    3,    1,    2,   -4,   -2,   -4,    3,   -4,   -2,   -6,    0,
      -1,    5,    2,   -4,    0,   -4,   -4,   -1,   -5,   -4,   -7,   -3,    1,    0,   -2,   -1,
      -5,    1,    0,   -1,    0,    2,    4,    0,    3,   -2,    1,    2,    6,    0,    1,    5,
       0,    3,    3,    2,   -5,   -2,    1,    5,    2,   -2,   -5,   -9,    0,   -6,   -1,   -6,
      -7,   -5,   -4,    0,   -2,   -5,   -3,    2,   -2,    3,    2,    0,    9,    2,    0,    4,
      -3,    4,    5,    8,    6,   -2,   -4,   -1,    0,   -2,   -2,    1,   -5,    2,   -5,   -1,
      -4,   -3,   -4,    0,   -2,   -7,   -3,   -1,    0,   -1,    0,   -6,    3,   -2,    5,    2,
      -1,   -2,    1,    0,    1,   -1,   -3,    2,    3,    1,    2,   -4,   -3,   -1,    5,    5,
       3,   -4,    0,    1,    2,    5,   -5,    1,   -5,    2,   -2,    2,   -4,   -3,    0,   -4,
      -3,   -9,   -7,   -4,    2,   -2,    1,   -6,   -3,    0,    1,    5,    1,   -5,    0,    0,
       2,    1,    2,    0,    6,    4,    6,    3,    2,    3,    1,   -2,   -2,   -9,   -4,   -1,
       4,    0,   -1,   -5,   -8,   -5,   -4,    0,   -4,   -1,   -3,    0,    0,   -4,   -3,   -1,
       1,    2,    0,   -2,   -3,    1,    3,    2,    3,    3,    0,    8,    2,    7,   -1,    3,
      -2,    4,    0,    0,    1,   -4,    5,   -1,   -3,   -3,   -6,   -4,    2,    1,   -5,   -4,
      -7,   -4,   -4,   -7,   -2,  -10,    1,    0,    1,   -3,    4,   -2,    5,    2,    1,   -3,
      -1,    2,    8,    4,    5,    0,    1,    4,    5,    2,    2,   -2,    1,   -4,    0,   -3,
      -3,   -1,    0,    2,   -4,   -4,   -5,   -1,   -7,    0,   -4,   -5,   -1,   -3,    2,   -2,
       0,    3,    0,    2,    0,    1,   -2,    2,    4,   -1,    0,   -3,   -1,    1,    3,    2,
      -3,    2,    0,    2,    2,   -1,    2,   -2,   -3,    0,    0,   -2,    2,   -2,    4,   -3,
      -6,   -7,   -6,    2,   -1,   -4,   -1,   -7,   -1,   -3,    3,   -1,    0,   -2,    2,    2,
      -3,    3,   -4,    5,    7,    6,    3,    1,   -1,    6,    2,    1,    0,   -1,   -1,    1,
      -3,    1,   -3,   -5,   -5,   -3,   -8,   -3,  -11,   -1,   -1,    0,   -8,   -2,   -5,    3,
       4,    0,    1,   -2,    2,    0,    6,    4,    1,    4,    1,    5,    0,    0,    1,    2,
       5,    0,    1,  -10,    0,   -5,    2,    0,   -6,   -6,   -2,   -2,    2,   -3,    0,   -4,
       2,   -4,    1,   -3,   -4,    1,   -2,    2,    1,   -2,    0,    3,    2,   -3,   -1,   -5,
      -3,    4,    2,    3,   -1,    4,    1,    5,   -1,    2,   -3,    2,   -3,    0,   -3,   -2,
       1,    1,    5,    1,   -2,   -5,    1,   -1,   -4,   -3,   -7,    0,   -5,   -4,   -4,    0,
      -4,    4,    0,   -1,    1,   -8,    1,    0,    9,    1,    2,   -2,    5,    5,    1,    6,
      -1,    6,    3,    1,    1,   -2,   -2,   -4,   -3,   -2,   -3,   -7,   -4,   -4,   -1,   -3,
      -8,   -1,   -8,    4,   -5,    0,   -3,    1,    0,    4,   -1,    0,    1,    3,    3,    4,
      -4,    6,   -2,    2,    5,    4,   -3,    4,   -3,    5,    0,   -4,    0,    0,   -1,    0,
      -4,   -4,    3,   -1,   -2,   -4,   -8,   -9,   -5,   -4,    4,   -4,    1,   -4,    1,    1,
      -1,   -1,   -1,    3,    2,    3,    0,    1,    2,    1,    5,    3,    1,    0,    5,    3,
       3,    0,   -5,   -4,   -2,    5,    0,   -2,   -5,   -2,   -6,   -2,   -5,   -8,   -2,    1,
      -1,   -3,   -7,   -8,   -6,    0,    4,    7,   -2,    7,   -1,    7,    3,    2,   -5,    0,
       2,    0,    1,   -3,    2,    2,    3,    3,   -3,    0,   -2,    3,   -1,   -1,   -4,   -6,
      -2,   -3,    4,   -4,    0,   -4,    6,   -2,   -6,   -2,   -7,    1,    2,   -1,   -3,   -2,
      -2,    3,   -1,    0,   -3,   -1,    4,    7,    4,    0,    2,   -1,    0,    6,   -2,    1,
       1,    5,    4,    1,   -3,   -3,   -2,    2,    2,    1,   -6,   -6,   -3,   -4,   -2,   -6,
      -5,   -4,   -5,   -2,   -8,   -8,   -3,    0,    4,    0,    1,   -1,    2,    5,    4,    2,
       2,    3,    3,    4,   10,    0,    2,    0,    3,    1,    1,    0,   -3,    1,   -3,    1,
      -7,    0,    1,   -2,    1,   -6,   -4,  -10,   -1,   -4,   -2,   -2,   -3,    2,   -4,    1,
      -5,   -4,   -4,    2,    1,    1,   -4,   -1,    3,    1,    6,    2,   -2,   -2,    3,    3,
       2,    7,   -5,    5,    0,    8,    1,   -1,    2,    3,   -1,   -6,    0,  -10,    3,   -1,
      -1,   -5,   -6,   -8,   -2,    0,   -3,   -5,   -8,   -4,    2,   -3,   -1,   -2,    0,   -1,
       7,   -1,    3,    2,    4,    7,    3,    4,   -1,    5,    1,    9,    1,   -2,   -1,   -1,
       1,   -3,   -2,   -6,   -7,    1,   -3,   -1,   -9,   -4,   -6,    0,    2,   -3,   -2,   -4,
      -3,    0,   -4,   -1,   -4,    0,    1,    6,   -1,    1,   -1,    3,    5,   -1,    3,    4,
       5,    7,    4,   -2,    0,   -2,    0,    3,    1,   -1,   -8,   -2,   -1,   -2,   -5,   -1,
      -2,   -2,    2,   -5,   -7,   -9,   -2,   -3,   -2,    1,   -5,    4,   -4,    5,   -1,   -1,
      -3,    2,    3,    7,    3,   -1,    3,    4,   -1,    5,   -4,    0,    4,    4,    3,    4,
      -9,    1,   -5,    2,   -2,   -2,   -3,   -7,   -1,   -2,   -2,   -5,   -3,   -1,    1,   -2,
      -1,   -4,   -4,    1,   -1,   -7,    0,   -1,    2,    5,    4,   -4,   -5,   -4,    0,    2,
       1,   -1,    3,    5,    4,    0,    0,   -1,    3,    8,    3,    3,   -4,    0,    1,    0,
      -2,   -6,   -2,   -4,    3,   -2,   -3,   -5,   -6,   -3,   -1,   -1,   -7,    0,    0,    3,
      -5,   -4,  -11,    0,    0,    3,    3,    1,    1,    1,    4,    6,    1,    1,    2,    9,
       3,    3,   -4,   -4,   -3,    2,   -1,   -6,    1,   -5,    2,    0,   -1,   -8,   -5,   -6,
       1,    0,   -2,   -1,   -2,   -1,    2,    0,   -9,    0,    5,    4,    7,   -3,   -3,    3,
       4,    2,    4,    0,   -1,    3,    1,    5,   -5,   -6,   -7,    0,    3,    0,   -2,   -4,
       3,    3,   -3,   -4,   -7,   -2,    4,    1,   -1,   -4,   -1,   -6,   -2,    3,   -2,   -3,
       1,    4,    1,   -1,   -4,   -3,    3,    4,    5,   -2,    2,   -3,    4,    0,    3,   -3,
      -3,    0,    3,    1,   -2,   -1,   -3,    2,    4,   -2,   -2,   -3,   -1,   -1,    3,  -11,
      -2,   -8,    5,   -1,    3,   -5,   -2,    2,   -1,    3,   -3,    0,   -1,   -1,    5,   -2,
       0,   -2,    3,    2,    3,   -2,   -6,   -3,    2,    4,   -6,    5,   -6,    1,    2,    3,
      -6,    2,   -3,   -4,    3,   -9,    2,   -6,    3,    4,    2,   -9,   -1,    1,    2,    8,
      -3,   -4,   -1,   -2,    2,   -2,    2,   -3,    3,   -1,    1,    2,   -1,   -6,    1,    2,
       2,    1,   -2,    2,    3,    1,   -3,   -6,   -3,    0,    1,   -3,    0,   -3,   -1,   -4,
       2,   -4,   -3,   -1,    4,    0,    5,   -6,   -7,   -1,    0,    0,   -3,   -1,    2,    4,
       0,    3,   -4,   -1,    1,    7,    4,    2,   -1,   -4,    0,    2,   -4,   -5,   -5,   -1,
       1,    4,   -5,   -4,   -6,   -3,   -2,   -3,    2,   -2,    5,    2,    3,   -4,   -2,   -5,
       6,    3,    4,    2,   -3,    1,    0,    0,    1,   -3,   -1,    1,    7,    0,    6,   -6,
      -7,   -2,   -7,    0,   -1,    0,    2,    1,   -2,   -7,   -2,   -5,    0,    2,    0,   -3,
      -5,   -1,   -3,    0,   -1,    0,   -6,    8,    4,    5,   -1,    1,   -4,    1,    1,    4,
       2,    5,    3,    6,    0,   -2,   -9,   -4,   -1,    0,    0,    1,   -1,   -4,   -1,   -5,
      -5,   -5,    0,    0,    1,   -6,   -5,   -9,    0,   -3,    0,   -2,    0,    0,    3,    4,
       2,    1,   -7,    1,    3,    4,    9,    1,    4,    4,    2,   -4,    2,   -2,    1,    5,
      -2,    0,   -3,   -4,   -3,   -2,   -4,   -4,   -4,    1,   -1,    2,   -6,   -8,   -3,   -8,
      -1,   -2,   -4,    5,    2,    3,   -1,    0,   -4,    2,   -1,    5,    5,   -1,    3,    0,
       3,    3,    0,   -4,    9,    4,    2,   -1,   -6,   -4,   -2,   -2,    2,   -7,    0,    0,
      -2,   -2,   -2,  -10,   -4,   -7,    0,   -2,    2,   -2,    2,    1,    0,   -3,    0,    1,
       6,    3,    2,    0,    0,   -1,    2,    3,   -1,    4,   -5,    6,    2,   -3,    0,   -3,
       0,    1,    0,   -5,   -6,    1,    0,    1,   -5,   -2,  -14,    0,   -4,   -1,   -1,   -1,
       1,   -3,    0,   -2,   -1,   -4,    4,    5,   -1,    5,   -1,    3,    3,    5,   -3,    5,
      -3,    5,    5,    6,    4,   -6,    2,   -9,    4,   -4,    0,    1,   -2,   -1,   -8,   -6,
     -11,   -2,   -3,    3,   -6,   -8,    3,   -5,    1,   -3,    1,   -3,    1,    3,    5,    6,
       2,    1,   -6,    4,   -1,    1,    0,    7,    7,    2,    3,   -6,   -4,   -4,    3,    3,
       0,    1,   -1,   -2,   -4,    0,   -8,   -2,   -3,    1,   -2,    1,   -5,   -2,   -1,   -3,
      -3,   -4,   -3,    7,    4,    1,   -1,   -6,   -5,   -3,    2,    5,    8,    3,    3,    2,
       1,   -4,   -1,   -2,    6,    3,    2,   -4,   -1,    1,   -5,   -1,   -1,   -5,    2,   -2,
       1,   -2,   -7,   -5,  -11,   -4,   -3,    3,   -8,    8,    4,   -2,   -2,   -4,   -4,   -1,
       4,    3,    5,    5,    2,    4,   -1,    6,   -3,    6,    2,    3,    0,   -4,    0,   -2,
      -2,    0,   -5,   -2,   -1,    4,    3,    1,  -13,   -8,   -8,   -5,   -3,    7,   -2,    3,
      -2,   -5,   -3,   -8,   -2,   -3,    8,    6,    1,   -2,    5,    3,    1,    2,    0,   -1,
       2,    4,    3,   -5,    1,   -3,    0,    1,    7,    1,    2,    3,   -1,   -4,   -4,  -10,
      -7,    3,    0,    2,   -5,   -5,   -4,   -1,   -7,   -3,   -3,    1,    3,    0,    0,   -1,
      -6,    6,    1,    4,    1,    2,    5,    6,    4,   -1,   -4,   -3,    1,    2,    5,    2,
      -1,    1,    3,   -8,   -1,  -10,   -2,   -5,    0,   -1,   -6,  -10,   -7,    2,   -2,    6,
      -1,   -2,    1,    4,   -1,   -5,   -1,   -5,    4,    1,    4,    2,    1,    3,    4,    0,
      -2,    1,   -1,    3,    8,    2,    1,   -4,   -3,   -3,    3,   -3,   -1,   -4,    0,   -4,
      -6,   -2,   -8,    1,   -2,    5,   -6,   -5,   -6,    0,    3,    1,   -6,   -3,    1,    2,
       4,    2,    4,   -2,    3,    3,    3,    1,    5,    1,    2,    3,   -2,   -6,    6,   -1,
       6,   -2,    1,   -7,   -5,   -2,   -3,   -6,   -6,   -6,   -4,    0,   -2,   -4,   -4,   -3,
       0,   -1,    1,   -3,   -1,    3,    1,    1,    0,    6,    4,    8,   10,    5,    0,   -3,
       1,   -2,    5,    2,    1,    1,    1,   -4,   -6,   -8,   -8,   -8,   -5,   -4,   -5,   -4,
      -5,    0,   -5,   -3,    0,   -7,    0,    4,    1,   -4,   -1,   -4,   -2,    4,    4,    5,
       6,    6,    7,    0,    0,   -1,    0,    2,    9,    2,    1,   -3,    0,    1,   -3,    1,
      -9,   -1,    3,   -4,    3,   -6,   -7,   -2,   -1,   -1,   -1,    1,   -9,    2,   -5,    1,
      -8,   -6,   -6,    1,   -1,    6,    0,    2,    5,    2,    0,    2,    1,    2,    6,    5,
      -2,   -1,    0,    4,    1,    6,    0,   -2,    1,    0,    3,   -7,   -1,  -13,   -4,   -3,
      -3,   -3,   -2,   -3,   -5,   -9,  -11,   -2,   -3,    4,    7,   -1,    2,    0,   -2,    8,
       5,    1,    4,    3,    2,    7,    3,   -2,   -4,    7,    2,    3,   -2,    1,   -1,    2,
       0,   -5,   -4,   -4,    0,   -4,    0,   -1,  -10,   -9,   -3,   -5,   -8,    1,   -5,    3,
      -3,    0,   -7,    1,    0,    5,    4,    7,    1,    1,    0,    2,    2,   -2,   -1,    2,
       1,    4,    6,   -1,    4,    3,   -1,    4,   -2,   -3,    3,   -1,   -2,   -6,   -6,   -7,
      -3,   -1,    0,   -4,   -6,   -5,   -6,    0,   -3,    3,   -5,    7,    0,   -1,    1,   -3,
      -1,    1,    6,    3,   -3,    7,    1,   10,    1,    6,   -1,   -2,    5,    2,    1,    1,
      -4,   -2,    0,   -3,   -7,   -2,   -4,    4,   -8,   -8,   -4,  -10,   -2,    2,   -4,    1,
      -5,   -7,   -1,    3,   -1,    1,    1,    4,    6,    2,    2,    0,    4,    7,    0,    5,
      -2,    0,    3,    3,    3,   -3,   -1,   -5,   -2,    0,    3,   -4,   -6,    2,   -1,    0,
      -2,   -4,    0,   -4,   -3,   -9,   -3,   -4,   -4,    0,    3,   -1,   -4,    3,    1,    5,
      -2,    1,    2,    2,    4,    5,   -3,    2,    1,    3,    7,    1,   -5,    1,    0,    5,
      -3,   -2,   -3,   -4,    0,   -3,   -2,   -5,    0,   -8,    3,   -6,   -4,   -6,   -2,    2,
      -4,   -2,   -3,   -2,    1,    4,    2,    3,   -2,    2,    4,    1,    4,   -2,    3,    2,
       1,    1,    7,   -1,    2,    4,   -4,    2,   -4,   -2,    5,   -4,    3,   -1,   -3,   -2,
       3,   -8,   -4,   -6,   -3,   -3,   -1,    0,   -6,   -1,    0,    1,    1,   -2,  -10,   -3,
      -1,    0,    2,   -5,    1,    1,    2,   10,    8,    2,    8,   -1,   -2,    4,   -5,    2,
       2,    7,    6,   -6,   -1,   -5,   -4,   -3,   -6,   -7,    0,   -5,   -5,   -1,   -2,   -5,
       0,   -4,    6,   -6,    0,    3,   -3,    4,    0,   -6,    2,    5,    5,    4,   10,    0,
       2,   -3,    3,   -2,    0,    3,   -3,    2,   -3,   -8,   -8,   -5,   -1,   -1,   -1,    0,
      -5,   -2,    0,   -3,   -4,   -1,   -5,   -2,    5,    0,    5,   -4,    4,   -1,   -1,    1,
      -3,    3,    9,    2,   -1,    1,   -6,   -3,    7,    1,    3,   -2,   -4,    0,   -1,    3,
       1,   -3,    4,    6,    0,    1,    2,   -3,    0,    0,   -5,  -13,   -4,   -2,    1,    2,
      -3,  -10,   -4,   -7,    1,   -2,   -2,   -1,    0,    1,    1,   -4,   -1,    2,   -2,    7,
       1,   -3,    0,    0,    4,    5,    2,    2,   -1,    6,    9,    1,    3,    1,   -5,    5,
      -6,   -5,   -2,   -4,   -2,    2,   -7,   -4,  -11,   -5,    3,   -3,   -6,   -4,   -6,    3,
       3,   -3,    2,    0,    1,   -3,   -1,   -2,   -4,    1,   10,    8,   -2,    4,   -3,    6,
       6,    1,    0,   -7,    2,   -2,    1,    3,   -4,   -4,    4,    1,    0,   -2,   -5,    2,
      -2,    0,   -7,  -11,   -5,   -2,   -2,    5,   -1,   -8,   -1,   -1,    1,    2,   -2,   -1,
       1,    1,    5,    0,   -3,    5,    1,    6,    1,   -1,    3,    1,    6,   -3,   -1,   -1,
      -3,    4,   12,   -1,   -1,    2,   -4,   -1,   -6,   -8,   -7,   -3,   -2,    1,   -9,   -5,
      -6,  -10,    5,    1,   -2,   -3,   -2,    5,    4,    3,   -1,   -5,    4,    6,    3,    4,
       6,   -2,    7,    0,   -4,   -1,   -1,    9,    8,    2,    2,   -8,   -3,   -3,    0,   -2,
       0,   -4,   -2,    0,   -6,   -7,  -14,   -6,   -5,   -1,    3,   -6,   -2,    1,   -3,    0,
      -4,   -5,    1,    5,    9,    4,    0,    3,    0,    1,   12,    0,    4,    8,    5,    7,
      -1,   -4,    0,   -3,    5,    4,   -4,    0,   -3,  -13,   -2,  -10,  -14,   -3,   -5,    2,
       1,   -3,   -4,   -8,   -8,   -3,   -2,   -2,    3,    4,    8,    0,    2,    1,    2,   12,
       5,    3,    8,    2,    6,    3,   -4,   -4,   -2,   -8,    8,   -5,   -2,   -6,  -10,   -2,
      -6,   -4,    0,   -4,    2,    5,    1,    0,   -4,   -4,   -1,   -1,   -3,    4,   -7,    4,
       3,   -3,    4,   -4,   -3,    8,    4,    7,    0,    0,    2,   -1,   -2,   -1,   -2,   -7,
      11,   -1,    5,   -4,    2,   -2,    0,    2,   -2,   -4,   -2,    1,   -5,    3,   -6,   -9,
      -3,   -3,   -2,   -5,   -5,   -2,   -6,   -2,   -7,   -8,    1,    3,    5,    9,    4,    4,
       0,    5,    8,    1,    3,    7,    5,   10,   11,   -7,    3,    0,   -3,    1,   -1,   -7,
      -7,   -3,   -2,   -6,   -9,   -6,  -12,   -4,   -1,    0,   -8,   -5,   -3,   -3,   -2,    3,
       1,    1,    9,    4,    2,    5,   -1,    2,    6,    2,    0,   -3,    2,    2,    5,    2,
      -1,   -4,    4,    1,    1,    2,   -5,   -8,   -1,   -3,   -1,   -9,   -4,    1,   -4,    5,
      -6,   -4,    0,    3,   -9,    3,   -3,   -5,    1,    4,    4,    1,   -4,    1,   -4,    4,
       1,   -6,    0,    5,    7,    8,    1,    6,    0,    3,    4,    2,   -3,    1,   -3,   -3,
       3,   -9,   -6,   -7,   -2,   -1,   -3,   -5,   -6,   -5,   -5,   -6,   -5,    4,   -3,    5,
       5,   -2,   -1,   -1,   -3,    6,   -2,    5,    6,    2,   11,    8,   -1,    3,   -6,   -2,
       5,    4,   -3,   -3,   -5,   -3,   -7,   -5,    0,   -5,    2,    1,    0,    1,   -7,    0,
      -3,   -2,   -1,   -2,   -5,    7,   -4,   -2,   -3,   -2,   -3,    4,    4,    9,    0,    1,
       1,   -5,   -3,   -4,   -4,    4,    3,    6,    0,   -2,   -2,   -6,    4,    1,    1,   -3,
       3,   -1,    2,    0,   -7,    0,    0,   -1,   -3,   -2,   -1,   -5,   -2,   -3,   -8,   -5,
      -5,   -1,    5,    5,    2,    2,   -3,    4,    3,    3,    6,    3,   -1,   10,   -4,   -3,
      -2,   -3,    0,   -4,    0,   -2,   -2,    0,    1,   -4,   -2,   -5,   -9,    8,   -2,   -1,
      -1,   -3,   -3,   -2,   -6,    2,    1,    2,    9,    0,    1,    3,   -4,    2,    4,   -6,
      -1,    2,   -1,    6,    3,    0,   -5,   -3,   -1,    0,    3,   -3,    0,   -6,   -2,   -3,
      -4,   -2,    0,    3,    2,    2,    0,  -10,    1,   -6,   -5,   -1,   -2,    5,    3,    6,
      -2,   -6,   -1,   -3,    2,   -1,    0,    0,   -1,    0,    0,    0,    1,   -2,    2,   -2,
      -5,   -1,   -2,   16,   12,  -18,  -10,    3,  -14,  -10,   16,   -1,   -3,  -16,   28,    3,
      -1,   -1,   12,   -5,   -6,    6,    7,   -7,  -18,  -28,   11,    0,    6,   -2,   26,  -21,
     -10,   -1,   24,   -3,   20,  -19,   15,  -14,   -3,   -3,   15,  -35,   -2,    6,  -14,   30,
       6,  -36,   -8,   17,    0,  -27,   26,   16,  -38,    8,  -14,   57,    3,  -31,  -14,   34,
     -20,   33,    2,   -6,   -7,  -28,   20,  -24,    8,   13,    8,  -39,   17,   40,  -42,  -11,
      13,  -46,    1,   28,  -22,   11,   -3,  -14,    5,   20,  -12,   -4,   49,  -22,  -24,   39,
     -11,   -1,   -9,   37,  -30,   13,   34,    4,  -11,  -25,   18,  -22,    1,   29,  -17,   -3,
     -26,  -16,  -21,   12,  -18,    7,  -17,   -6,   51,    0,  -21,   10,   24,  -45,    8,   14,
      31,  -10,  -37,    6,    0,   24,    3,  -18,  -13,   14,   11,    0,    7,   -1,  -38,  -29,
     -21,   32,  -30,   22,  -26,   14,  -40,   55,  -36,   30,  -12,    8,   31,  -16,   19,  -15,
      23,  -48,   36,    1,   63,    3,   24,    0,   -3,   14,   26,  -21,   15,   47,  -21,  -80,
      14,   -4,  -25,  -33,   11,   25,  -35,  -44,   13,   -2,  -48,  -11,  -23,   -7,   27,   -4,
     -15,  -22,    5,   26,  -36,   50,   23,   11,  -23,  -14,   19,   32,   14,   38,  -66,   56,
     -11,   26,   18,  -12,   17,  -30,   -6,  -54,   22,   77,  -62,  -12,  -16,   34,  -25,    2,
      14,  -62,   12,   20,  -22,  -50,   58,  -29,  -58,    4,   28,   30,   13,   25,  -78,   38,
      45,  -19,   -7,   52,  -61,   27,   17,  -21,   -4,    6,   37,  -24,  -38,   73,    8,  -16,
      21,   -2,  -15,  -19,  -19,   18,    3,    7,  -48,  -10,  -10,   10,    4,   13,  -13,   -4,
       0,   46,  -12,    6,  -18,  -25,    4,   14,   27,  -22,  -37,   14,   -6,  -17,   55,   40,
    -111,   63,    9,  -38,  -16,   46,  -35,    4,    0,  -10,   -8,  -12,   58,  -69,    1,   66,
     -38,   21,  -33,   -6,   10,    0,   10,  -11,   18,  -16,   32,   -7,  -10,  -25,   65,  -42,
      42,  -62,   18,   -3,   -2,   -8,   21,    4,  -71,   13,   40,   -3,   18,  -19,  -29,   15,
     -66,   60,  -50,   -6,   67,  -80,   17,   66,  -21,  -20,  -15,   68,  -16,   72,   -4,  -23,
       4,   53,   -8,    8,   -4,    0,   27,  -26,  -22,   25,  -31,    7,  -39,  -18,   27,  -43,
     -25,  -33,   -6,   17,  -16,    0,  -55,    6,   26,   -3,  -67,    7,   60,  -83,   25,   15,
      45,   -8,   51,  -55,   28,   42,   42,  -17,   37,   -6,   17,    8,   11,   -1,   59,   -7,
     -45,   14,  -41,  107,  -49,  -50,  -25,   63,  -58,  -27,  -57,   19,   13,  -13,  -27,   19,
     -42,   63, -113,   -1,   44,    8,    1,  -10,  -33,    0,   55,  -41,   15,    0,   76,  -17,
     -39,   60,  -20,   28,   54,  -93,   15,   83,  -30,    4,  -56,   49,  -58,   30,  -28,    2,
      54,  -64,   83, -128,   86,   24,  -40,  -27,  -66,   51,   11,  -51,   59,    6,   20,  -58,
     -24,   78,   -7,  -23,  -27,    1,   -3,  -24,   10,   -6,  -16,   34,   39,  -37,  -17,   26,
      52,  -69,   -7,   11,   24,  -62,   38,  -13,   41,    5,   -2,   -5,  -12,   15,   77,  -49,
     -10,   74,  -12,  -11,  -38,   32,  -24,   25,   -6,   19,  -24,   -2,  -38,   63,  -91,   64,
     -27,  -11,  -56,  -43,   27,  -41,  -55,  -15,    1,   -4,   27,    8,   37,  -57,    3,   28,
     -11,   -4,   46,  -39,    3,   12,  100,  -33,   39,   17,    6,   49,    5,   38,  -12,   10,
      21,  -35,   23,   -6,  -36,   10,   -9,    3,   -1,   13,  -65,  -40,   36,  -25,  -28,    5,
     -37,  -20,  -14,   31,  -16,  -32,  -16,    4,   15,  -11,   26,  -16,   29,  -42,   46,    7,
      39,   -1,   -5,   -9,   33,  -31,   35,  -33,   -7,   17,   56,  -24,   22,   14,  -22,  -34,
      44,   16,   11,  -46,   43,  -48,  -27,   43,   36,  -45,   21,   11,    0,  -98,  -22,   87,
    -126,   52,  -45,   34,  -28,  -17,  -31,   23,  -38,   23,   25,  -11,   25,  -63,   21,   13,
      19,   47,   28,  -23,   20,   21,   -5,  -14,  112,  -30,  -67,   37,   43,  -12,  -57,   34,
      -9,  -29,   52,  -19,   14,  -51,    0,   26,  -69,    3,  -18,  -24,  -34,   31,  -15,  -33,
     -36,   10,  -20,  -38,   63,    0,   44,  -50,   72,   25,  -16,   -6,    6,   15,   23,   31,
       3,  -20,   -9,   19,   63,   17,  -18,   -5,  -12,  -87,   31,   26,  -37,  -29,   49,  -42,
     -15,   14,   11,  -16,  -31,   46,  -19,  -13,  -37,   59,  -91,   47,    4,  -11,  -26,   39,
     -29,  -24,   48,   10,   39,  -11,   45,  -51,   -1,  -24,   47,  -19,   39,  -34,  -29,  -17,
       1,   56,  -25,  -16,  -13,    0,   48,  -71,   49,    2,   -2,  -45,  -10,   59,  -17,  -25,
       9,    9,   44,   42,  -32,  -23,  -49,   46,  -11,  -50,   76,  -43,  -45,   -1,   41,   -8,
       2,   71,  -36,  -61,   35,   21,  -13,  -36,   44,  -45,   26,  -45,  -21,   28,  -37,   39,
     -29,   15,    4,   -5,   24,   -7,    7,    3,   68,  -80,   26,   24,  -22,    8,   26,   28,
      10,  -26,   -3,   16,  -51,   85,   -8,  -14,  -54,   39,  -28,   -9,  -25,   46,  -39,  -20,
      34,   11,  -25,   -7,  -12,  -41,   12,  -17,   -5,  -43,   -8,    0,   18,   13,    9,   28,
     -40,   34,    0,   13,   40,  -20,    5,   22,  -25,  -13,   51,    9,  -34,   43,  -16,  -18,
       2,   35,   -4,  -28,   14,  -37,    6,   -8,   31,  -49,    9,  -31,   61,  -55,   35,  -46,
     -37,  -12,   32,   74,  -59,  -30,  -21,    5,   38,    3,   48,  -35,  -42,    2,   29,   81,
      -8,  -37,   24,   42,  -31,   18,  -11,  -21,  -67,   98,  -18,   11,  -26,  -14,  -76,   11,
      71,  -70,   30,  -52,   37,  -45,   61,    6,  -33,  -44,   58,   24,  -16,  -51,   49,  -28,
      51,   -6,  -15,   46,   10,  -24,   36,   -4,    6,  -30,   46,  -66,   54,   27,  -16,  -34,
     -23,   90,  -61,  -49,   22,   -3,  -22,   17,  -35,  -11,  -59,   23,    2,  -25,   69,  -24,
     -26,  -28,   37,   12,   11,  -63,   27,   18,    3,   34,  -25,    9,  -14,   29,    4,   24,
      21,  -77,   12,   14,   37,    1,   45,  -63,    1,   49,  -14,  -23,   -7,   -4,  -42,   48,
     -57,   18,  -36,   17,   15,  -37,   47,    1,  -41,  -14,   11,   49,  -32,   32,  -36,  -19,
      21,  -11,   39,  -31,   43,    0,  -24,   15,    6,    9,  -46,    5,   21,  -23,    2,  -28,
     -15,   59,  -13,  -29,   50,   -7,  -45,  -12,   23,   -1,   27,    6,  -17,    7,   -4,   -3,
      -3,   53,  -10,   17,  -52,   19,   24,   -8,   -7,   19,  -51,  -30,   55,  -22,  -22,   29,
     -38,  -25,   39,    3,   34,  -84,   26,  -37,   42,   15,    4,   -4,  -16,  -33,   29,   17,
      43,  -93,   24,   -6,  -20,  -14,  107,  -29,  -36,   69,  -21,   10,   -7,   74,  -67,   38,
     -23,   -8,   27,  -35,  -49,   29,   -8,   -4,    7,   -8,    5,  -38,  -28,  -33,   22,   70,
     -37,  -10,  -56,   26,    5,    7,   59,  -21,  -58,   10,   -2,    6,   49,  -16,   -9,  -38,
      60,   13,   43,  -43,   23,  -14,   -9,   38,   17,  -38,  -15,   29,    6,   -5,  -11,   -3,
      -4,  -65,   45,  -13,   26,  -13,   -4,   -5,  -38,   48,    0,    4,  -40,   40,  -48,   23,
      21,   23,  -42,    5,  -17,   13,   -9,   12,   -3,    5,  -25,   34,  -24,   -3,  -18,   16,
     -44,   13,   27,  -30,   44,  -54,    6,  -18,   -3,    4,   21,  -25,  -13,   22,  -20,  -12,
      37,  -10,  -10,    5,   24,  -17,   23,    9,    0,    4,    3,   12,   26,  -27,   17,    9,
     -41,   69,   -1,   15,  -37,   15,   -6,    0,   -1,    3,  -13,  -23,  -18,   27,   -5,   21,
     -16,  -41,   -2,   20,   13,  -27,    6,  -21,    8,    6,    0,    6,   -5,  -21,  -22,   73,
     -40,    4,    6,   21,   -8,   -5,   29,  -47,   -1,    1,   19,    3,  -10,   -1,    2,  -48,
     -11,   45,  -27,   11,  -33,  -21,   21,    7,   12,  -22,   21,  -40,   13,   27,  -20,   37,
       5,  -18,  -18,   35,   40,  -11,   20,  -25,   10,   -4,   33,   12,  -29,    9,  -20,  -30,
      34,   24,   -9,  -10,  -24,  -16,    8,   22,    6,  -58,   -5,  -13,   18,    5,  -43,   10,
     -16,  -25,   13,   70,  -25,   -7,  -25,  -19,   16,   58,  -46,   -5,    6,   -5,   40,  -24,
      22,   50,  -73,   -7,    7,   32,   39,  -27,  -23,  -23,   56,  -35,   21,   17,  -40,   40,
     -52,    4,    0,   49,  -29,  -42,   24,    9,   31,    2,  -46,    0,   -9,   -5,    9,  -31,
      64,   -5,  -45,  -26,   42,   -4,  -34,   -8,   -3,   32,  -15,   -8,   22,  -24,   13,  -31,
      -2,   31,   10,  -10,  -18,    8,   24,   20,  -29,    2,   14,   23,   25,   -4,  -19,   20,
     -25,   -5,   -3,   23,   -8,   52,  -42,  -17,   -7,   29,  -26,    2,  -19,   55,  -50,  -28,
       1,  -10,   -7,    7,  -41,   16,   21,    1,  -20,    0,   16,  -19,   14,  -39,   86,  -17,
     -34,  -64,   73,    0,   20,  -28,   30,  -22,    9,   58,   -4,   -8,  -18,  -20,   31,  -21,
       1,   26,  -49,    5,   41,  -25,  -13,   -6,   -7,    6,   10,   42,  -30,  -26,  -43,   11,
      44,  -54,   31,  -10,  -11,  -17,   25,   32,  -43,   64,  -23,    3,  -37,   33,  -30,   -4,
     -35,   47,  -29,    9,   23,  -34,   -5,   64,  -37,   32,  -11,  -44,   21,   25,  -19,    8,
       6,  -25,   34,    2,  -18,  -23,   38,   20,    7,   21,    1,  -32,  -37,   50,   -9,  -25,
      34,  -61,   55,  -32,    7,  -48,   20,   13,    0,  -35,   17,    9,  -42,  -28,   14,   42,
     -33,  -25,   -5,   21,   41,  -60,   32,   -7,   38,   -9,   -3,   20,   -4,   29,  -69,   62,
     -16,   35,  -64,   45,   10,    5,   -1,  -18,  -18,   -1,    5,   32,    0,  -21,  -12,  -23,
      29,  -15,   13,  -39,   -3,   -3,    6,   35,  -24,  -23,   -7,   -2,   44,  -10,  -37,   25,
      25,  -25,  -23,    7,   40,    4,  -40,  -18,   21,   -2,   -3,    1,  -16,   45,  -26,   -2,
     -16,   18,   41,  -64,    8,  -26,   40,    5,  -32,    8,   18,   -1,   15,   -1,    9,    2,
       2,  -13,  -12,   35,   -9,   13,  -62,  -29,   72,   18,    7,  -30,   26,   -7,  -29,   39,
     -38,   31,  -56,  -25,   -3,   17,    2,   -3,  -46,   35,    6,   27,  -39,   -3,    3,   31,
     -25,  -19,   -2,   38,   26,  -77,   22,   18,   40,    3,  -22,   65,  -48,   33,  -16,  -37,
      78,  -34,    1,  -52,   23,   16,    1,  -37,   17,   12,    1,   -4,    8,  -27,   -1,  -11,
     -18,   27,  -23,  -10,  -11,  -19,   -6,   -7,   51,  -74,   16,   20,   17,  -14,    7,    7,
     -13,   -8,   -5,  -11,   39,   21,   -5,  -44,   31,   64,  -38,  -18,   20,   40,   -4,  -10,
      10,  -23,   23,   -6,  -20,   11,    9,   10,    6,  -23,  -11,    1,   17,  -56,   56,  -40,
       0,  -17,  -60,   84,  -80,   16,  -13,    4,  -25,   12,   17,  -42,  -26,   54,  -29,   12,
      -5,   37,   16,  -62,   94,   -5,   -2,   -2,   -2,   -9,    5,   51,  -25,   -5,  -11,    5,
      16,  -14,   -9,   43,  -44,   -8,   27,    2,   -1,    9,  -18,   -6,    5,   23,  -46,   -9,
      13,   16,  -10,  -10,  -23,   59,  -47,  -14,   23,   29,  -15,  -14,  -30,   21,  -21,    0,
      14,   -3,   25,  -16,  -35,   -2,   -8,   32,  -19,   22,  -23,  -37,   30,  -33,  -19,   11,
      12,  -32,   47,   -4,   27,   11,    9,  -35,   39,   29,  -18,   -2,  -11,   27,   -2,   13,
       0,   18,  -26,   15,  -25,   26,   -4,   21,  -29,  -33,   18,   -8,  -31,   -5,   21,   -1,
     -38,  -28,   41,  -18,   -4,  -22,   47,  -12,  -44,   55,  -79,   -5,   19,  -10,   25,    4,
      21,   15,  -28,   13,   -6,   45,  -24,   25,   10,  -26,    4,    2,   31,    3,   -7,    3,
       5,  -23,   51,   -9,  -32,   -5,   35,  -32,  -21,  -20,   35,  -40,  -10,   20,   -8,    7,
      -5,  -38,   -1,  -24,   39,  -26,   20,  -16,   -9,  -27,   25,   34,  -32,    1,   12,  -13,
       3,   37,   13,    3,  -31,   27,   30,    5,  -15,  -21,    2,   10,  -13,   16,   36,   -9,
     -59,   41,  -10,   61,  -60,  -35,  -11,    7,    5,  -28,   30,    5,  -23,  -66,   34,   50,
     -26,  -19,  -10,   11,    8,    8,  -35,   -5,  -11,   56,  -24,   10,   35,   16,  -10,  -19,
      30,    4,  -11,   23,    0,   -6,    6,   36,  -15,    0,   15,  -14,  -26,   -8,   -5,   15,
     -31,  -45,   42,  -30,    0,   -9,    6,  -22,    9,  -22,    7,   -8,   15,  -19,   -3,  -13,
      29,  -14,    9,  -16,    3,   -5,  -10,   63,    0,    4,    4,   20,   16,  -21,   18,   31,
     -24,  -19,   31,   54,  -39,   -7,  -16,    5,   -3,    0,  -29,   16,    6,  -29,  -25,  -52,
      49,   -9,  -66,   -3,   50,   -3,   -2,  -14,    4,   -8,   33,  -40,    2,   15,   -6,  -17,
      -4,   10,   48,  -16,   14,   -9,   27,   10,    2,    2,   40,  -35,    5,  -10,    7,   28,
       1,    4,  -30,   -4,    0,    1,  -14,  -13,  -11,   26,  -17,   13,  -44,   -9,   -6,  -23,
      17,   11,   11,  -21,  -11,    0,    9,    8,    8,  -30,   29,   10,  -26,  -12,   15,   17,
       4,  -26,   14,   19,   20,   -9,  -24,   39,   23,  -10,  -35,    8,   -6,   18,  -25,   15,
     -17,   41,  -48,  -31,   -5,   47,  -14,  -20,   -4,   -7,    5,  -19,    3,   21,   12,  -23,
      15,  -24,    8,    3,  -25,    2,   28,   14,   21,   25,  -72,   15,   26,   -6,   45,  -27,
      29,  -30,  -17,   23,    6,   -2,   27,  -46,   13,    9,   15,  -57,   27,    1,  -18,    1,
     -11,   -2,  -20,  -16,  -23,   24,   18,  -21,   -5,  -15,  -14,   26,  -12,   30,  -48,   37,
     -24,   -3,   23,    9,   -5,    9,    8,  -43,   23,   26,    6,   28,  -29,   30,   -8,  -12,
      25,  -18,   33,  -48,   -4,   29,    1,   -8,   -4,  -20,   41,  -22,    1,   12,  -33,    0,
     -17,  -16,   29,   -3,   -2,  -36,    6,   -1,  -11,    4,  -24,   40,  -24,   -5,   26,   -2,
     -28,   13,  -11,   35,   -9,   -2,   -3,   -6,   13,   10,    1,   11,  -22,   22,  -27,   -5,
      20,   11,   -1,    8,  -23,    8,    7,   -7,   17,   -6,   16,   -9,  -10,    3,   13,   -3,
     -17,   19,  -21,    6,  -13,  -15,   -7,   22,  -15,   -7,   11,  -20,  -19,   -6,    0,   28,
     -10,   -7,  -13,    9,    7,    1,  -11,   -6,   21,  -33,   -4,   52,  -11,   -1,   -2,   -2,
      -4,   32,   17,  -31,    7,   12,    2,   -5,   11,   -1,   -6,    1,    3,  -11,    5,    4,
     -15,   -8,   10,    5,  -18,    5,  -26,  -11,   22,  -15,  -23,   22,   19,  -30,    3,    1,
      -5,   10,  -17,   10,   -2,   10,    7,  -17,   -5,   36,  -12,  -24,   27,   22,   -3,  -11,
      -6,   -7,   20,    5,  -21,    0,   23,  -31,  -27,   14,    2,    8,    7,  -15,    0,   13,
      -7,   -3,  -21,   33,   -4,  -26,    7,    5,   -7,   -7,    1,    3,    4,   11,  -24,    6,
      11,   -7,   14,   -9,  -11,   -1,   34,  -22,   11,    1,  -18,   17,    4,  -19,   28,  -15,
      -7,  -11,   12,    1,   -7,   -9,  -12,   17,  -20,    6,    5,    2,  -10,   12,  -23,   -3,
      26,   -1,    4,    6,  -25,   12,   -3,  -26,    2,   15,   14,  -18,   -6,  -17,   14,    4,
     -10,   21,  -13,    5,  -15,  -20,   27,    6,    8,  -11,   18,   15,  -34,   17,   -2,  -13,
      41,   -9,  -10,   -6,   -2,    7,  -11,   -4,   28,  -26,   -6,   25,   17,  -36,   -2,   33,
     -39,  -15,   11,   -2,   26,  -32,  -31,   21,   26,  -11,  -24,   12,  -17,    4,  -33,   24,
      14,  -10,   12,  -19,   -3,   28,   11,   -8,    0,   26,  -17,   -7,    8,   -6,   20,   26,
     -29,  -27,   25,  -14,   -2,   10,  -16,   39,  -24,  -17,   -4,  -13,   24,  -10,   -3,  -20,
      25,   -1,  -24,   24,  -20,   -5,   21,  -26,    7,   21,  -26,   15,   17,    6,  -34,    5,
      11,  -27,   20,   17,  -13,   -8,  -16,    9,   33,  -36,   19,    5,    4,   -2,  -33,  -12,
      38,  -17,  -10,   -4,   19,   14,   -4,  -32,  -41,   64,    5,  -38,   28,    6,   -2,  -11,
     -22,   11,   17,   17,  -24,   23,   -7,    9,   10,  -38,    0,   25,   -9,   -6,  -27,   20,
       2,  -27,   34,  -23,   17,  -22,    4,   12,  -43,   29,   -8,   25,  -19,   13,  -17,  -11,
      27,   -8,   14,  -19,   12,    9,  -22,   -6,   11,  -10,   17,   -4,    2,   -3,   15,  -47,
      32,  -18,   11,   14,    0,    8,  -33,  -14,  -12,   23,   17,  -12,   -4,   13,  -27,   10,
     -17,   20,   -2,  -11,  -11,   27,   18,  -21,   -6,   26,  -18,    9,   -7,   27,  -12,    3,
      -9,   -9,   22,    7,  -38,   -2,   14,  -16,   12,  -21,  -10,   22,    1,  -28,   20,   31,
     -11,  -49,    9,   16,   -4,   -7,   -4,   -5,   46,  -39,    9,  -18,   16,   22,  -24,  -13,
      14,   29,  -10,    3,  -23,    4,   11,  -33,   30,   18,   -9,    5,  -11,    4,  -20,   30,
      -9,  -14,   -7,   -9,    4,    0,    4,  -15,  -11,   23,    5,  -24,   26,   -6,   -8,  -17,
      21,    0,    3,   13,  -10,  -13,   19,  -16,  -10,   -5,   10,    8,   22,  -19,    4,   -8,
       0,  -24,   38,   12,  -33,   10,   -9,    5,  -13,   11,    3,    7,  -18,  -12,   11,   -4,
       8,  -17,   -7,   16,   -9,   -2,   -9,    0,   10,   -2,   -1,   -1,   12,   -6,   13,  -18,
      18,   -6,   10,    1,   -3,    9,   -2,  -30,   23,   -9,   29,  -11,  -31,   10,    6,  -21,
     -19,   54,  -30,   18,  -12,  -26,   23,  -10,  -31,   23,   -5,   49,  -34,    4,  -18,    3,
      11,  -24,   27,   12,  -24,    3,  -13,    3,   16,   -6,   -7,    1,   19,   -8,   -3,  -11,
      13,  -14,   19,   10,   17,  -21,   14,  -40,   12,   13,   -5,   -3,   21,  -14,  -29,   16,
     -24,    1,   10,   -1,   -3,    6,  -15,  -16,   16,   -4,    2,   23,  -32,   -1,    7,   -5,
      13,    4,  -15,   33,    1,   -7,   -7,  -12,   13,    6,   -8,    2,   21,    2,  -21,   17,
     -14,  -19,   36,   -2,  -16,   -4,    3,    9,   15,  -39,    3,    9,  -10,   -3,  -12,   -7,
      28,  -19,    8,  -18,   22,  -18,  -11,   -2,   17,   23,  -15,  -24,   11,   13,  -14,  -10,
       9,    4,   14,  -10,  -13,   13,   -3,  -12,   25,    6,  -12,   12,  -19,   -3,   19,  -10,
     -13,   19,   10,   18,  -31,  -15,   19,   -9,  -14,   -6,   25,  -18,    2,   17,  -41,   11,
      16,  -20,    3,  -10,   16,    9,   14,  -27,   -1,   -3,    9,  -19,   36,   -6,   -4,   -4,
     -16,    5,   -7,   24,   -1,  -30,   13,   -8,   -4,   -9,   47,  -37,    3,   21,  -24,    1,
       3,   11,    5,  -10,   -8,   20,  -31,   16,   10,   -1,    0,   -9,   -1,   -6,   14,   -6,
       6,  -17,   20,    3,  -23,   10,  -14,   17,  -16,   -2,   26,    7,  -20,  -10,    9,  -18,
      31,  -35,    3,   14,   -8,   13,  -27,   -4,   -4,   26,  -20,   -9,   14,   22,  -27,   -4,
      18,    9,    9,    3,  -13,  -20,   15,  -13,    6,   12,   -5,   -6,  -12,    0,    4,  -10,
      18,   -7,   -8,  -15,    1,  -11,   17,    5,  -11,   14,   -6,  -11,    4,   10,   -5,   13,
       0,   -7,   15,   -2,  -16,    2,   -3,    9,   -6,    2,   34,  -11,  -17,   -8,   21,   13,
     -21,   -4,   14,   -7,   -7,  -19,   13,   -7,    4,  -25,    7,   16,  -14,  -40,  -11,   36,
       3,  -10,    4,  -10,    7,   -1,   -1,    4,   14,    6,  -14,  -14,   17,   23,  -13,   -2,
      -1,  -12,    9,    8,    1,   -7,   22,  -29,    7,    7,    0,  -24,   13,  -10,   18,   -1,
      -3,   13,  -24,   30,  -32,   -5,   18,   -2,   -6,   -8,   11,  -18,  -12,   17,  -11,    0,
       5,   -4,  -14,   31,  -15,  -16,   13,   12,   -4,    4,   -4,   -1,  -11,  -15,   26,  -18,
      29,  -15,   -3,   -8,    6,    6,  -34,   22,    0,   11,  -18,   16,   20,  -19,  -21,   -5,
      11,   21,   10,   10,  -27,   -5,    3,    2,   -5,    9,   -9,   -1,    1,  -11,   -3,    8,
       4,    1,   -1,  -11,   19,   -1,  -21,   -5,   -2,   11,   -2,   -8,   10,   -7,   -1,    2,
     -18,    3,    0,    7,    2,    7,    1,    1,  -28,  -14,   10,   19,   12,  -21,    7,  -19,
      20,   -2,   -3,   -1,   17,  -11,  -13,  -16,   32,    4,   -5,   -3,    4,   -4,   18,   -2,
     -17,   -6,   16,   -3,    4,  -12,    4,   -2,    2,    6,  -18,   20,  -24,   17,  -10,   19,
     -16,  -17,    8,   -7,   -5,   16,  -12,  -18,   11,    9,    2,   -8,   17,   -9,   -3,  -13,
       7,   -6,   30,  -15,  -11,    5,   14,   -2,  -15,   -5,   14,   13,  -12,  -24,  -10,   22,
      -2,   -8,   -1,   21,   -5,  -19,  -16,    8,   42,   -6,  -27,  -12,   23,   10,  -17,  -14,
      16,   14,  -16,   -2,    9,   -2,   16,   -9,  -31,   22,    0,   -2,    3,    4,   -5,   20,
     -24,   -5,   13,   -1,   -5,  -10,   -6,    8,  -11,    2,    8,   -8,   -5,   -9,    1,   -6,
      16,   -1,  -18,    4,    9,   -3,    6,   -4,    6,    9,   -7,   -9,   -1,   10,   -7,    4,
       3,   -3,    4,   -8,   -5,    3,   -4,   10,    6,  -15,    2,    3,   -5,   -2,   -3,  -12,
      18,    2,  -16,    7,   13,    0,  -19,   -8,   11,   -6,   -1,   -9,    5,   13,   -8,   -6,
       6,    7,   11,  -11,   -6,   13,   -2,   -5,   -1,    9,   -2,   -7,  -15,   10,    5,   -1,
     -13,    8,    0,   -6,   -2,   -2,   18,  -16,   -7,    2,    3,   -4,    6,  -11,    4,    6,
       1,   -5,   22,  -11,   -5,   -6,   -3,   11,   -1,   -1,    4,    1,   -4,  -13,   -4,   11,
      -9,    1,    9,   -1,   -8,    1,   -5,   -7,    5,  -14,   18,   -1,  -12,   11,  -12,   16,
      -5,  -11,   11,   -2,   15,   -7,  -18,  -10,    0,   18,  -12,    8,    3,    6,  -16,   -3,
       3,    6,    0,   -1,   -3,    4,    9,    3,  -17,   -7,   11,   11,  -19,    5,   15,  -12,
      -3,  -12,    4,   11,  -19,    0,    0,  -14,   21,  -15,    2,    8,    3,    8,   -8,    5,
     -18,    9,   -2,   -8,   23,   -5,  -16,    5,    3,  -20,   13,   11,   -6,  -15,    5,    4,
     -12,    2,   10,   -5,  -12,    5,  -14,   -2,   18,   11,  -14,    0,   28,  -10,  -20,    4,
       7,    9,  -13,   -6,   15,   11,   -9,   -6,   14,   -8,   10,    4,  -12,   11,  -18,   13,
     -17,   -9,   16,   -4,  -14,   -7,   17,  -24,   -5,    4,    6,   -6,   14,    2,  -24,  -22,
      11,   13,    8,  -16,    6,   13,  -28,   10,   -2,   11,    8,   -1,   -8,  -14,   22,    3,
      -5,  -13,   18,    7,  -26,   15,   20,   -6,  -10,    4,   11,    5,   -8,   -3,   -5,    0,
      -1,   -6,    0,    4,    4,  -14,   -1,    1,    8,  -14,  -10,   -4,    6,    4,   -8,    3,
      -9,    0,   11,   -4,   -7,    5,    4,    6,  -29,   18,   22,  -19,  -16,  -11,   17,    7,
      -4,    3,  -23,   20,    8,  -19,    3,   13,   13,  -16,  -18,   15,   -6,    0,    3,   17,
      -7,   -4,    2,  -22,   21,   -1,   -2,   -1,  -15,   13,    3,   -7,    4,    0,   -7,    8,
      -7,   11,    3,   -2,   -8,   10,  -15,    0,    9,  -14,   -8,    8,   -2,   -9,   10,  -13,
       9,    7,   -6,    2,  -12,   -4,    6,  -12,    8,   12,    3,  -10,    6,    7,    1,   -2,
     -11,   -1,    7,   -7,    8,  -13,  -10,   11,   -9,  -10,   -8,   20,    9,  -11,    8,   -5,
      -4,    6,   -3,    5,   13,  -13,   -7,   -7,    6,   19,    0,   -9,    9,   -1,   -3,    4,
      -7,    0,   -2,   -4,   -5,    5,    0,   -5,   14,  -19,  -14,   18,   -1,   -5,    3,  -12,
      18,  -19,    4,  -15,  -10,   10,   10,  -17,   -4,   19,   -6,   -2,    5,   11,   -4,   -3,
       9,  -22,   28,   -6,   -5,    0,   -1,   11,  -11,  -13,   22,    3,   -8,   -9,    1,    3,
       0,    1,    2,    7,   -5,  -25,   10,    6,    6,    2,  -11,    8,  -16,   15,  -20,    5,
       9,   -6,  -13,   -5,   14,    6,  -21,   22,   -7,  -14,    4,   26,   -8,  -13,    8,    1,
     -10,  -13,   11,   10,  -10,    2,  -13,   -9,   15,    0,   10,  -30,   14,    7,  -13,   -5,
     -12,    8,   10,   -4,   10,   12,  -15,   -7,    5,    2,    2,   10,  -13,   -3,    0,   21,
      -2,  -16,    9,    3,   -1,    6,   15,   -3,  -21,   10,   -8,    5,    1,    1,    2,  -19,
      10,   -7,   -3,   -1,    8,    6,  -26,  -10,   18,  -28,   -3,   -3,    4,    0,   -7,    6,
     -10,   -2,   25,  -19,    5,  -11,   -2,   14,    4,   -5,   -3,    4,   -5,    6,   -2,   -3,
      11,   -1,   13,  -12,    5,   20,  -15,   -3,   17,    4,  -14,   -5,   11,    3,    1,    6,
      11,  -20,   10,   -4,   -4,   -4,   -4,  -18,   -7,    5,   10,  -25,    7,   -9,  -15,    1,
      -4,    4,    4,   -4,   -1,  -18,    9,   -6,    4,    7,  -19,   10,    0,    3,   -6,   12,
      18,   -5,    2,    4,   -4,   11,    2,    5,    2,    1,    3,   -4,    3,    4,   -3,   -2,
      -8,   11,    5,  -10,  -12,   12,   -6,    6,   -9,   -6,    4,    9,    0,   -9,    4,    3,
      -7,   -5,  -12,   19,    2,  -28,    1,    0,    9,  -10,   -6,    3,    3,  -11,   -4,    6,
       7,   -7,   -3,    5,  -12,    9,   10,  -12,    7,    5,    5,   -6,   -9,   16,    6,  -16,
       3,    8,  -17,   12,   -5,    2,    1,   21,  -25,  -10,    5,   -2,   15,   -6,    1,    3,
       5,  -16,   -2,  -16,   32,  -17,    7,  -13,    6,   -1,   -4,    0,   -4,   10,   -2,  -17,
      -7,   29,    0,  -13,   -1,   -1,    2,   12,   -4,    3,   -2,    4,  -19,   -1,   18,    2,
      -3,  -15,   -2,   10,   -4,    1,   -2,   -5,   20,   -5,   -6,   -7,    9,    0,   -2,  -24,
       5,   15,   -2,  -11,    1,    0,   -2,  -14,   -2,   -4,    7,    4,   -4,   -9,    2,    4,
      -8,    8,   -1,    2,   10,  -13,    4,   10,   -4,   27,  -22,   17,  -18,   -2,    5,    8,
      -1,    4,   -6,    2,   -1,    9,    1,   -3,   16,  -21,  -18,    2,   10,  -14,    9,    3,
     -14,   -9,    0,  -16,    9,  -10,   11,  -12,   -3,    1,  -10,    3,   -2,    2,  -13,   13,
      10,   -1,    4,    4,    1,   -3,    9,    0,    4,    8,  -14,   10,   -4,    0,    8,   11,
      -2,    2,  -11,    3,  -13,   -8,   11,    4,    1,   -7,    4,  -21,    0,    1,   -4,  -22,
      17,   -8,  -16,   10,    4,   -2,    0,   -4,    2,   -2,    2,   -6,   10,    3,    3,    5,
      -1,    6,    5,    2,   -6,   -3,   -2,    7,   -4,   -4,   12,    1,  -30,   12,   -7,    3,
       4,   -6,   -7,   -9,    9,   -1,    7,  -10,   12,  -16,    2,   -8,   23,   -5,   -5,   -1,
      -8,   10,    3,  -14,  -12,   25,    7,  -13,   -6,    4,   15,   -3,  -23,    9,   12,   -9,
     -13,   18,   -9,    5,    1,  -17,   -4,   13,  -10,   11,  -10,   -1,    6,    0,   -7,   -2,
       9,   -4,    9,  -24,    7,    6,   -5,    4,   15,  -15,   11,   -5,  -24,    9,   11,  -16,
       2,    0,   -9,   -2,   10,    7,  -12,    8,  -12,   -6,   10,    6,   10,  -14,   -5,   20,
     -16,    7,    8,   -1,  -19,   24,    2,  -10,   15,    6,   -6,  -21,    3,   -3,   15,   -9,
      -3,    3,   -2,   -4,   -3,   -9,    5,    0,   -5,   -3,  -15,   -4,   -1,    1,  -14,   33,
     -12,  -18,    9,   -2,  -10,    9,    9,   -1,   -1,   -5,   10,   -3,    2,    4,    2,   -9,
      -1,   25,   -2,   -3,   15,  -17,   -7,    8,   -7,    0,   10,  -13,    9,  -11,    0,   -3,
      18,  -15,  -11,    5,    0,  -12,   -2,    7,   -6,   -4,   -9,   11,   -6,    8,    1,  -14,
       3,   16,  -10,   -3,    2,    6,    4,    9,   -9,   -2,    0,    2,   -3,   15,    3,  -10,
      -4,   -8,   -1,   10,  -13,   -9,   16,   -9,   -3,   -2,    5,   -6,   -6,   -9,   10,    8,
      -4,   14,   -7,  -19,   12,    1,    2,    1,    4,   -1,   -6,   -3,   -3,    5,    7,   -2,
       0,    0,   -5,    0,   -6,    1,    6,   -5,   -4,    5,   -6,    5,   -4,   -8,   15,   -5,
      -7,    0,    3,   -8,    0,    3,   -8,   -4,    6,   -4,   -4,   15,   -5,   -8,   -7,    4,
       7,  -10,   -6,   15,   -4,  -13,    7,    2,    2,    1,   -4,    5,    0,    0,    1,    4,
      -7,    4,    4,   -2,    4,    5,    1,  -18,   12,    4,   -3,   -6,   11,    0,  -13,   -1,
       1,  -12,    3,   13,   -9,  -15,    7,    0,   -4,   -8,    0,    5,    0,   -9,    1,    1,
      -3,    0,    3,    5,  -10,    6,   -1,   -4,    4,   15,  -15,   -5,   -9,   18,   -2,    0,
      15,  -11,   -9,    0,    6,   -2,    8,    1,   -8,   -9,    7,    3,   -7,   -3,    6,    1,
      -5,    0,   -5,   -5,    0,   -3,   11,    1,   -3,   -8,   -4,   -4,    5,    9,   -6,   -7,
       4,   15,  -13,    5,   -4,    2,   -6,   -2,    0,    5,    4,   -4,    0,   -6,    8,    3,
      -2,   -4,   -4,  -11,    4,   10,   -1,   -4,   -2,   -1,   -3,    1,   -4,   -2,    3,    1,
      -4,  -11,   12,   -4,    5,   -2,    7,  -12,   -2,    4,   -4,    5,    8,    1,   -8,   14,
     -11,   -1,    1,    4,    0,    5,   -5,    2,   -7,   -7,   10,    3,    1,  -13,    0,   -4,
       5,   -9,   -1,    1,  -11,   -5,    5,    2,   -6,    5,   -5,   -8,   12,   -2,    7,   -1,
     -10,   -5,   -7,   14,    9,    3,   -5,   -2,    5,    4,   -2,    0,   -5,    2,    3,    3,
     -12,    6,    3,    2,   -9,   -1,   24,  -13,   -9,   -1,   -2,    0,    7,   -6,  -17,   14,
     -12,   -5,   10,    1,   -4,   -1,   -1,    1,   -3,    2,   -2,  -11,    1,   -1,   -1,    1,
      10,   -3,    2,    1,    5,   -7,    1,   -1,   -5,    7,    1,    7,   -4,    5,  -11,   -8,
      -8,    7,    8,    6,    0,  -15,   -1,    7,    0,   -6,   -3,    7,   -4,   -3,   -2,    1,
       5,    8,   -6,   -4,   11,    3,  -14,   -6,   -3,   -6,    9,   -5,    4,   -5,    2,    3,
     -13,   -3,    1,   -4,   -3,   11,   -1,    0,    7,  -16,   -6,   11,    5,    0,    4,    5,
      -2,   -3,   -2,    8,    7,  -16,    1,    2,    6,    3,  -17,   11,   -2,   -2,   -9,    6,
       0,   -7,    6,  -22,   -2,   14,    3,  -11,    0,   -6,   -2,   -7,   -7,    1,    4,   14,
      -1,   -6,    0,    7,    3,  -14,    4,   15,   -4,   -9,   -2,   12,   14,  -10,    5,    9,
     -11,   -2,   -9,    2,   -9,   11,    2,  -21,    7,    6,  -11,   -1,    0,    0,    1,   -9,
       4,    0,  -10,    1,    3,   -3,   -7,   12,   -9,   -2,    4,    6,    3,   -8,    0,    1,
      -2,  -14,   12,   11,   -5,   10,   -3,   -1,    3,   -6,    1,    0,   -3,    8,   -1,  -18,
      12,    5,  -13,   -4,   17,   -1,   -6,    1,  -11,    0,   -6,    2,   -2,   -2,    5,    3,
     -17,    2,   -5,   11,   -4,    8,    8,  -19,   -6,   14,   -6,   -6,    0,    5,    0,   -8,
       7,   13,   -6,   -5,    6,   -2,   -9,   -1,    8,    3,   -4,   -4,   10,  -10,   -9,    7,
       2,   -6,   14,    0,  -15,    3,    5,   -4,  -10,    8,    0,   -6,  -11,    3,   10,   -9,
       1,    8,   -7,    2,   -1,   -6,   -8,    6,    2,   -8,   -2,   16,   -3,   -3,   -1,    5,
      -3,   -8,    6,    9,   -6,    1,   -1,   -1,    2,   -6,    6,   -1,   -9,    3,    9,  -10,
       1,    5,   -4,  -14,    2,    1,    7,   -5,    3,   -2,  -13,    5,   10,   -9,   -8,   14,
      -6,  -19,   -3,   19,   -3,   -3,    6,   -4,  -10,    3,   -1,   -4,    5,    5,    1,    0,
      -1,   11,    4,  -10,    3,   -5,    4,   -7,    1,    8,   -3,    1,    2,    0,  -10,    2,
       5,  -15,   -3,    8,   -8,   -6,    5,   -2,   -5,   -5,   11,    0,  -12,   -7,    5,    2,
      -5,    2,   -1,   -4,    2,    7,  -12,    5,    6,   -3,    5,   -1,   12,    7,  -13,   -3,
       0,    3,    0,   13,   -1,   -4,    0,   -9,    5,   -6,    5,   -2,  -10,   -6,   -2,    9,
      -8,    5,   -6,  -10,    5,    4,   -6,   -2,    1,    1,    6,  -14,   10,   -3,   -4,   -5,
       1,    8,  -16,    7,    7,   -1,    0,    3,   -5,    2,   -1,   -3,   11,  -11,    9,    8,
     -18,    3,    8,   13,   -4,   -5,   -9,    4,   -2,   -4,    9,    5,   -6,   -5,  -15,   -3,
      17,   -6,    2,   -8,    4,    4,   -4,  -12,   -3,   -2,   -2,   -4,    5,   -4,    1,    7,
     -12,   -6,    8,    6,   -2,    1,   -3,    3,   10,   -3,    7,  -11,   12,    4,   -1,   -1,
       1,    0,  -11,   11,    4,    0,   -2,   -9,   -2,   -2,   -8,   -1,    5,   -4,   -5,   -5,
       1,   10,   -8,  -11,   -5,   -4,    5,   -1,    1,    6,   -2,   -5,   -5,    3,    6,   -2,
       6,   -3,    0,    4,    5,    2,    4,   -2,    1,    5,   -2,   -6,   11,   -1,   -5,    8,
     -14,    6,   -2,   -6,  -11,    4,    2,  -14,    6,   -9,    5,   -4,   -3,    4,  -12,   -2,
       2,   -5,    4,    7,   -5,    3,    6,   -1,   -3,   -6,    0,    7,    0,    1,    6,    9,
       4,   -2,   -7,   -4,    7,    4,    4,   -5,   -5,    0,    3,   -6,   -1,    7,   -2,  -18,
      -1,    3,  -15,    5,   -2,   -2,    0,    4,  -10,   -4,    3,    4,  -10,    4,   -1,    5,
       4,   -7,    8,   -7,    0,    3,    2,   -7,   13,    0,   -2,   -6,   -6,    5,   10,  -10,
       4,   -1,    2,   -1,   -5,    7,    5,   -3,   -7,    1,   -5,   10,    1,  -11,    7,    6,
     -10,  -15,   12,    2,   -4,    1,    0,   -5,    3,    0,   -2,    6,   -5,   -4,  -13,   -2,
       3,    1,    4,    3,    3,  -10,   -7,   -7,   11,   -2,    2,    2,   -7,    4,   -1,    6,
       2,    0,    8,    3,    0,   -7,    8,    3,    5,   -8,   -3,   -2,    2,    3,  -12,   -4,
      -3,   12,  -12,   -4,    7,   -3,  -10,  -10,   -4,    6,   -2,   -8,    9,    1,    1,    1,
      -3,   -6,   12,   -5,   -6,   -1,   11,   -7,    5,    6,    2,    9,  -11,    6,   -2,    8,
       1,   -6,    4,    3,   -6,   -3,    5,   -4,    4,    1,  -19,   -1,    3,    4,    0,    0,
     -10,   -1,   -3,   -5,   -3,    0,   11,   -1,  -12,   -2,    6,    0,   -3,    3,    4,   -1,
      -7,    1,   -2,   -1,    2,   -1,    0,    2,   -2,    4,   -5,   -4,   11,   -4,   -5,   -3,
       7,    5,   -8,    3,    6,   -9,    0,    9,   -5,   -2,    5,   -4,   -6,    0,    7,   -1,
      -2,    0,   -1,   -6,   -9,   -6,   -1,    8,    4,   -1,   -9,   -5,   13,    2,  -11,   -5,
       9,    0,   -8,   -1,    5,   -2,   -5,   -3,   -2,    7,    5,   -4,  -13,    3,   11,   -8,
       3,    0,    2,    5,  -12,   -6,    6,    3,   -4,   -1,    8,    1,   -5,   -7,   -6,    2,
       8,    5,   -2,   -9,    7,   -6,   -2,   13,   -7,    2,    1,   -1,   -5,    3,    7,   -1,
     -11,    9,   -6,   -4,   -2,   -5,   -1,    2,   -1,    3,    8,   -7,   -1,   -9,    0,    0,
      -1,    2,    5,   -2,    1,   -2,   -3,    6,    6,   -3,   -6,   -5,    4,   -1,    1,    5,
       1,   -1,   -2,   -3,   -4,    4,    3,    1,   -7,    5,   -1,    0,   -8,   -6,    1,    7,
      -3,   -6,   -2,    3,   -1,   -3,    2,    2,    0,   -9,    1,   -2,    4,    4,   -5,    1,
      -1,    1,    6,   -2,    2,   -5,   -4,   -1,   14,   -3,    2,   -9,    1,   -2,   -4,    1,
      -1,    7,   -9,    5,    2,   -3,    2,   -2,   -9,   -2,    4,   -1,    2,   -2,   -2,    0,
      -1,   -1,   -2,    3,    1,   -1,   -3,   -6,    3,    7,   -5,   -3,    9,   -5,   -4,   -5,
       8,   -4,    2,    2,    8,  -10,   -1,    8,  -14,    0,    6,   -7,   -1,    2,   -3,    2,
      -4,    5,    2,   -5,   -4,    5,    1,   -6,    3,    6,   -4,   -1,   -3,    3,   -7,    0,
       1,    0,   -4,    7,    6,  -13,   -3,    3,    2,  -15,    8,    3,   -3,   -6,    9,   -4,
      -1,    9,    1,   -6,   -6,    7,    1,    1,   -2,    6,   -1,   -4,   -1,   -1,   -7,    5,
       3,    0,   -5,   -2,    8,   -2,   -8,    6,    7,  -16,   -5,    6,   -6,   -1,    1,    7,
      -4,   -3,   -6,    3,  -10,   -3,    8,   -9,   -1,    5,   -1,   -7,    5,    2,   -1,    1,
       5,    1,    2,   -4,   -5,    1,    1,    3,    1,   -5,   -2,    3,    2,   -7,   -1,    7,
       5,   -5,   -7,    5,    0,    3,   -1,   -4,   -4,    4,    0,   -4,    1,    6,   -3,   -7,
       0,   -3,   -3,   -1,    0,   -2,   -4,    2,    1,   -2,    3,   -1,    0,   -1,   -6,    9,
      -5,    4,   -1,   -1,    4,   -2,    5,   -8,    2,   -3,   -2,    2,   -3,   10,    2,   -3,
      -5,    2,   -4,   -1,   -3,   -7,    9,    1,    0,    0,   -5,    1,   -2,  -12,    6,    8,
     -18,    4,   -1,    4,   -1,    5,   -5,   -3,    3,   -1,    4,   -5,    9,   -5,   -4,   -5,
       2,    5,   -1,   -4,    0,   -3,   -2,    8,   -5,    2,    1,  -13,    3,    1,    4,    5,
      -8,    2,    8,    1,   -1,    1,   -9,    1,   -2,   -4,    1,    4,   -3,    4,   -4,   -5,
       6,    5,   -6,   -3,   -3,    1,    1,   -7,    1,    2,    1,   -5,   -4,   -2,    2,   -6,
       6,    3,    7,  -10,   -9,    4,    1,   -5,    6,    9,    3,    1,   -2,   -4,    3,    4,
      -1,   -6,    3,    1,   -2,   -9,    4,    4,   -5,    4,  -10,    2,   -4,   -5,   -1,    1,
       2,    0,    2,   -8,    1,    3,   -4,  -13,    0,   10,   -1,   -4,    5,    0,   -4,    5,
      -3,    2,   -5,    2,    1,    2,    4,    2,    2,  -10,    5,    3,  -11,   -2,    3,    3,
       0,   -6,   -2,    1,    1,    2,   -1,   -8,   -1,   -5,   -4,   -3,    5,    8,   -4,   -4,
       2,    0,   -2,   -2,    1,   -5,    0,   13,   -8,   -6,    4,    8,   -6,   -1,    6,   -2,
       4,   -5,    3,    5,   -7,   -8,   -2,   -3,    7,    8,   -8,   -3,    1,    5,   -5,   -5,
       9,   -4,   -7,   -5,    4,    3,   -6,    5,    1,   -1,    3,    0,   -6,   -9,    0,   -6,
       1,    4,   10,    5,  -13,    0,    6,   -2,   -4,    2,   -2,    6,   -1,   -4,    0,  -11,
       6,    3,   -1,   -3,   14,   -1,  -15,    1,    2,    3,   -1,    4,   -3,   -6,    0,    3,
       0,   -6,   10,   -3,  -14,   -2,   10,   -3,   -9,   -4,    0,    6,   -1,    7,   -3,   -5,
      -6,    1,    0,   -5,   11,   -2,    1,   -2,    5,   -1,   -4,   -1,   -3,   -4,    2,   11,
       2,   -4,    1,    2,  -12,    7,    3,   -1,  -11,    3,   15,   -8,  -11,    0,    0,    2,
      -7,    1,   -3,   -4,   -3,   -5,   -4,    6,   11,   -7,   -8,   -1,    6,   -5,   -3,    6,
       8,    3,   -6,    1,   -1,   -1,   -1,   -5,   -3,    8,    7,    4,   -9,    1,   -2,   -4,
      -6,    9,   -4,    3,   -8,    0,    6,   -2,   -4,   -2,   -2,   -6,    8,   -7,    3,    1,
       3,   -1,   -3,    2,    1,   -6,   -9,    3,   -5,    8,    5,  -10,    7,    5,   -3,   -2,
      -1,   -3,   -1,   -4,   -7,    6,    6,    3,   -7,    0,    0,    1,    0,   -7,    3,   -1,
       0,    1,    2,    2,    2,  -11,   -8,    9,    6,    2,   -6,   -1,    1,   -3,    3,    1,
      -6,    2,   -3,   -2,   -1,    2,   -4,    0,   -4,   -2,    0,   -3,   -2,   -6,    5,    2,
       0,   -1,   -3,   -1,    3,    1,   -2,    0,    2,    2,    0,    1,    7,    1,   -4,   -2,
      -6,    4,    3,   -1,   -4,   -1,    3,    3,   -9,   -2,    0,   -2,   -1,   -5,    6,    1,
      -5,    1,   -5,    9,  -10,   -4,    0,   -4,    6,    1,   -3,   -5,    9,   -2,   -5,    2,
       0,    6,   -6,    2,    5,   10,   -8,   -3,   -2,   -1,    4,   -3,   -1,   -4,    0,   -1,
       1,   -4,    0,    5,   -8,   -1,   -5,   -1,   -1,    3,    3,    3,    2,  -14,   -5,    1,
       2,    3,    1,   -1,    2,    5,   -2,    2,   -5,    2,    3,   -2,   -2,   -3,    4,    4,
       4,   -6,    3,    1,  -10,    1,   -6,    6,   -2,   -3,    0,   -3,    1,   -3,    1,   -1,
      -4,   -5,   -4,    7,   -2,   -2,   -3,    6,   -5,   -5,    2,   -6,    1,    4,    3,   -8,
      11,    4,   -4,   -1,    2,    3,   -5,   -2,    1,    7,   -4,    2,    4,  -10,    7,   -7,
      -1,    0,   -3,    5,   -4,   -1,   -4,    5,   -7,    3,    3,  -11,   -2,   -1,    5,    1,
      -1,    0,    6,  -11,    0,    1,   -2,    1,    0,   -1,   -4,    2,    9,   -2,   -9,   -4,
       2,    0,    2,   -1,    1,    1,   -7,    5,   -3,    4,   -1,   -3,   -8,    5,    7,   -1,
      -1,   -3,    3,   -7,    0,    4,   -3,   -3,    1,    6,    0,   -1,    0,   -5,   -1,    0,
      -4,    0,    0,   -3,    1,   -4,    1,    7,   -3,  -13,   -2,   -2,   -1,    3,    5,    2,
      -6,    1,    6,   -2,   -6,    8,   -1,   -6,    0,    4,    6,   -2,    0,   -2,   -4,    3,
       5,   -4,   -7,    2,    5,   -3,   -3,    3,    1,  -10,   -7,    3,    1,   -3,    2,    4,
      -7,   -3,    0,    2,   -5,   -3,    3,   -2,    0,    3,    5,   -6,   -1,    4,   -2,    0,
       5,    1,   -2,   -2,    3,    2,   -1,   -3,   -3,   -7,    7,    3,   -1,   -2,    0,    0,
       1,   -2,    1,    0,  -15,   -1,    3,    2,   -3,    4,    0,   -7,    0,   -1,   -1,   -4,
      -3,    2,   -1,   -1,   11,   -3,   -1,   -5,   -1,    2,    2,    0,    1,    2,    3,    4,
      -6,   -3,   -2,    1,    0,   -4,    2,    1,   -1,   -5,    1,   -1,   -7,    2,   -2,   -5,
       0,    2,   -2,    3,    5,    0,   -2,   -6,    6,   -7,    3,   -4,   -6,    1,    6,    3,
       1,   -2,   -3,   -4,   -6,   -1,    7,   -2,    0,   -3,    0,    9,   -3,   -5,   -1,    3,
       0,   -1,   -3,    6,    1,   -6,   -3,    3,    6,    0,   -6,   -4,    2,    1,   -1,    2,
      -5,    4,    1,   -2,   -5,    0,    7,   -9,    3,   -1,    1,   -6,    0,   -5,   -1,    1,
      -1,    0,   -4,    2,   -2,   -2,    1,    6,   -1,   -5,    0,    0,    0,    1,    3,    2,
       2,   -1,   -3,    0,    1,    5,    1,   -5,   -7,    2,    6,   -3,   -3,   -3,    2,   -7,
      -5,    5,    0,    0,   -3,   -4,   -1,    3,   -4,   -5,    1,    5,   -1,   -2,   -4,    0,
       5,    2,    0,    2,    2,   -1,   -1,   -5,    5,    3,   -1,   -4,    1,    0,   -1,   -2,
      -1,    2,    2,   -4,   -4,    2,   -2,   -3,   -4,   -3,    0,    3,   -3,   -2,   -2,    4,
       1,   -2,   -2,    1,    2,   -6,   -1,    2,    6,    1,   -2,    0,    4,   -3,   -1,   -2,
      -1,    5,    1,  -11,    4,    3,   -1,   -6,    2,   -2,    3,   -4,   -8,   -2,   -1,    4,
       0,    3,   -2,   -1,   -2,   -2,    1,    3,    3,   -7,    0,    2,   10,    0,   -4,    3,
      -3,    0,    0,    3,   -4,    6,   -4,   -8,    2,    1,    3,  -14,    1,   -1,   -2,    0,
       0,   -5,   -1,    2,   -6,   -1,    3,    0,   -5,   -3,    3,    1,    6,   -2,    0,    6,
       2,   -7,    1,    3,   -5,    5,    8,    0,   -1,    1,   -4,   -6,   -2,    6,    4,   -4,
      -1,    1,  -10,    0,   -4,    0,   -3,    2,    0,   -8,    3,   -3,    0,    2,   -1,    1,
      -8,   -1,   -1,   -3,   -1,    4,    1,    6,    1,    0,    0,   -2,    0,   -2,    7,   -4,
       3,   -1,    2,    0,   -2,   -2,   -8,    3,    2,   -1,   -4,    3,    0,   -3,   -5,    2,
      -3,   -3,   -2,    5,    2,    1,    1,   -4,    1,   -1,    4,    6,   -4,    0,   -6,   -4,
       1,    3,    3,   -1,   -2,   -7,   -1,   -3,    6,   -6,    2,    1,    5,   -8,   -5,   -1,
       2,   -1,   -3,   -1,   -1,    5,   -7,    3,    3,    1,    4,   -4,   -3,   -3,    8,    1,
      -2,    4,    4,   -2,   -8,    2,    1,    0,    2,    0,   -6,    3,   -2,   -8,   -2,    5,
      -1,   -6,    0,    2,   -1,   -5,   -2,   -2,    6,    0,   -5,   -2,    3,    0,   -5,   -1,
       6,    7,    2,   -8,   -4,    6,    2,   -6,   -4,   12,    2,   -5,   -2,   -6,    1,    1,
      -3,   -7,   -3,   11,   -3,   -6,   -1,    3,   -2,   -4,   -4,    4,   -3,    4,   -2,   -3,
       1,    7,    0,   -8,    7,    1,   -2,   -4,   -6,   13,    0,   -3,    1,    2,   -1,   -4,
      -3,    1,    3,   -2,   -3,   -1,    0,    3,   -1,  -10,   -1,    2,   -8,   -3,    3,    2,
       1,    4,   -6,   -2,    1,   -3,   -1,   -4,    6,    5,   -1,   -5,   -1,    9,   -2,    0,
      -4,    0,    1,   -3,    4,   -5,    1,    3,   -4,   -6,    0,    4,   -2,   -6,    9,   -1,
      -3,    2,   -4,    0,    4,   -7,   -4,   -1,    1,    4,    0,   -1,    6,   -2,   -2,    4,
      -3,   -1,   -6,   -2,    2,    3,    1,   -3,    8,  -10,  -10,    7,    0,   -2,   -1,   -4,
       3,   -6,    0,   -5,   -5,    5,    3,   -6,    1,    5,    0,   -1,    1,   -1,    0,    0,
       0,   -5,    7,   -2,   -1,    2,   -1,    3,    0,   -6,    4,   -3,   -2,   -3,   -2,    1,
       3,    3,    0,   -2,   -1,   -9,    2,    2,   -1,    4,   -4,    4,  -10,    7,   -8,    2,
       1,   -1,    0,   -1,    4,    2,   -7,    7,   -6,   -4,    3,   11,   -5,   -6,    1,    3,
      -4,   -6,    2,    2,   -2,   -3,   -7,   -4,    6,    0,    7,  -13,    6,    2,   -9,   -2,
      -5,    3,    8,    0,    0,    5,   -5,   -4,    3,    0,    2,    4,   -7,    0,   -1,   10,
      -3,   -6,    7,    2,   -1,    0,    6,   -2,   -7,    4,   -2,   -1,   -2,    1,   -3,   -9,
       6,    0,   -4,    0,    3,    3,  -11,   -4,    7,  -16,   -2,    0,    2,    1,   -2,    2,
      -5,   -1,   12,   -6,    2,   -7,    2,    6,    0,   -4,   -1,    1,   -3,    2,   -1,    0,
       7,   -2,    2,   -6,    2,    7,   -9,   -4,    8,    2,   -9,   -3,    8,    1,   -1,    4,
       5,  -11,    2,    1,   -1,    0,    0,   -6,   -2,    2,    6,  -13,    2,   -3,   -8,    1,
       1,    3,   -2,   -3,   -2,   -7,    4,   -6,   -2,    3,  -10,    5,   -2,    1,   -3,    5,
       8,   -4,   -1,    2,   -1,    6,    2,    3,    2,   -2,    0,   -1,    0,    4,    1,   -1,
      -2,    7,    1,   -7,   -5,    7,   -5,    2,   -5,   -4,    0,    3,    3,   -2,    0,   -1,
      -9,   -4,   -9,   10,    1,  -14,    0,   -1,    6,   -8,   -3,    3,   -1,   -6,   -1,    5,
       3,   -5,   -1,    3,   -6,    5,    7,  -10,    5,    5,    2,   -4,   -3,    9,    4,  -11,
       0,    5,  -11,    7,   -6,    2,    2,   12,  -15,   -8,    2,   -3,    7,   -5,    3,    3,
       1,  -10,    0,   -9,   17,  -11,    7,   -6,    2,    1,   -3,    0,   -1,    5,   -2,  -10,
      -4,   16,   -1,   -7,   -1,   -3,    1,   11,   -3,    1,   -3,    2,  -12,   -2,   12,    3,
      -1,  -10,   -2,    6,   -3,    1,   -1,   -4,   12,   -1,   -2,   -7,    6,   -1,   -1,  -16,
       5,   11,   -3,   -7,    1,   -1,   -2,   -6,   -4,   -5,    3,    4,   -3,   -8,   -1,    3,
      -5,    3,    1,    2,    6,  -10,    1,    7,    0,   21,  -15,   11,  -12,    0,    1,    4,
       1,    4,   -4,   -1,    3,    7,    0,   -5,   10,  -15,  -14,    2,    6,  -11,    5,    3,
     -10,   -6,   -1,  -11,    4,   -9,    6,   -9,   -2,    2,   -8,    3,    0,    2,   -9,    7,
       7,    2,    2,    0,    3,    1,    6,    0,    3,    6,  -10,    6,   -4,    1,    7,    9,
      -1,    0,   -7,    1,  -11,   -8,    9,    4,    0,   -6,    2,  -16,    0,    1,   -2,  -16,
      10,   -7,  -12,    7,    4,   -1,   -1,   -4,    2,   -1,    2,   -5,    8,    3,    3,    4,
      -2,    4,    3,    2,   -4,   -2,   -1,    5,   -5,   -3,    9,    2,  -22,    8,   -6,    1,
       3,   -5,   -4,   -6,    7,    0,    5,   -8,    9,  -13,    0,   -6,   18,   -3,   -3,   -1,
      -6,    7,    3,  -11,   -9,   19,    6,  -10,   -6,    3,   12,   -2,  -18,    7,    8,   -7,
     -10,   14,   -8,    5,    1,  -15,   -4,   11,   -6,    9,   -8,   -1,    5,    1,   -6,   -2,
       7,   -3,    7,  -20,    6,    5,   -4,    3,   12,  -12,   11,   -4,  -22,    7,    9,  -13,
       1,    0,   -8,   -1,    9,    6,  -10,    5,   -9,   -5,    8,    5,    8,  -12,   -4,   16,
     -14,    7,    6,   -1,  -16,   21,    2,   -9,   13,    5,   -4,  -19,    2,   -3,   12,   -7,
      -2,    3,   -2,   -4,   -3,   -8,    4,    1,   -4,   -4,  -14,   -3,   -1,    1,  -11,   30,
     -11,  -16,    8,   -2,   -9,    8,    8,   -1,   -1,   -5,   10,   -4,    1,    4,    3,   -8,
      -1,   23,   -2,   -2,   14,  -15,   -7,    7,   -7,    0,    9,  -12,    8,  -10,    0,   -3,
      16,  -13,  -11,    5,   -1,  -10,   -2,    6,   -5,   -4,   -9,   10,   -6,    7,    1,  -13,
       2,   14,   -9,   -3,    2,    6,    4,    8,   -8,   -2,    0,    2,   -3,   14,    3,  -10,
      -4,   -8,   -1,   10,  -13,   -8,   15,   -9,   -3,   -2,    5,   -5,   -6,   -9,    9,    7,
      -4,   14,   -7,  -18,   12,    1,    2,    1,    4,   -2,   -6,   -3,   -2,    5,    7,   -2,
       0,    0,   -4,    0,   -6,    1,    5,   -5,   -4,    5,   -6,    5,   -4,   -8,   15,   -5,
      -6,    0,    3,   -8,    0,    3,    0,   -1,    0,   -4,    6,  -16,   22,   -7,    3,   -5,
       2,    2,    1,   -3,    4,   -8,    4,    4,    0,   -5,   -9,    4,   -5,   -4,    3,    2,
       1,    3,   -4,    6,  -15,   -1,    4,    1,   -9,    3,    1,   -8,    3,   -6,   11,   -5,
       6,  -11,   17,  -15,   -2,  -19,  -11,    1,   -4,    8,    0,    5,   18,  -11,    0,   13,
      -4,    6,  -13,    4,  -11,   -1,   -7,   -7,   11,   10,   -9,   17,  -11,   20,   -6,    7,
     -14,   23,   -7,   -2,   -2,    7,  -10,    2,    0,    2,    5,    6,   -8,    5,   -4,  -10,
       9,   -4,    6,    0,   -7,    8,   -7,    1,  -20,   -4,   -1,   -3,    6,  -10,   -6,  -15,
     -11,   10,   -5,   19,    3,    1,  -19,  -11,   -1,   -9,    9,   22,   24,   10,   -5,  -18,
      -8,  -23,   14,   11,    0,   31,   43,   -9,    0,   -7,  -15,  -28,  -35,  -30,    3,    5,
      -5,   11,   52,   55,    7,   -5,  -10,  -12,  -25,  -43,  -12,    4,  -37,  -47,  -21,   -5,
       4,  -11,    1,   31,   27,   34,   46,   48,   61,   10,   16,    8,    7,  -14,  -40,  -47,
     -36,  -51,  -42,  -15,    4,   12,  -32,  -42,  -10,   -4,   10,    1,   15,   50,   31,    5,
      15,   38,   37,   29,   15,   22,   11,   -4,  -35,   10,    3,  -18,    1,  -14,  -33,   -5,
     -47,  -25,  -13,   -2,   15,   -6,    5,  -29,  -17,  -19,   -1,    3,    7,    2,   17,   28,
      -8,  -23,    7,    7,   36,   15,    2,    1,   -2,   -9,    1,    6,   20,    6,   14,   -3,
      21,  -11,  -12,  -35,   11,  -20,  -18,  -36,  -23,  -27,  -19,    1,   10,   14,   27,    6,
      44,   14,   -9,    3,   20,   27,   45,   -8,  -13,   16,  -16,   24,  -10,   -9,   -3,  -38,
     -19,  -14,  -38,  -38,  -41,   13,   40,  -37,    5,   -7,   -7,   -4,    4,  -31,   32,   22,
      15,    9,   13,   10,   10,  -17,   22,   30,    9,   -6,   27,   66,   47,  -17,  -21,  -20,
      -9,  -36,  -73,   -3,   22,  -35,  -12,    6,    7,    4,  -17,  -45,   22,   17,  -17,    3,
      -9,   -4,   11,  -10,   13,   -4,    8,   38,    3,   20,   42,  -22,    9,   23,  -28,  -21,
       3,   10,    1,   26,  -28,  -18,   -9,    7,  -30,  -41,  -24,   -9,   10,   -6,   31,   -5,
       2,   29,   -9,    1,  -27,  -24,    7,  -19,   -5,   10,  -13,   21,   21,    3,   30,  -11,
     -17,   34,  -11,    8,    7,   -8,    1,   11,   -1,    7,  -13,    1,   -3,   23,  -12,    8,
     -19,   -3,   20,  -78,   42,  -23,    4,  -29,  -16,   -5,   38,  -49,   30,  -26,   26,   16,
       8,  -33,   53,   19,  -20,   12,    5,   23,  -11,    4,   -6,   42, -111,   67,  -40,   29,
     -32,  -20,  -77,  113,  -46,  -12,    8,   -5,  -14,   35,  -52,   94,   -5,  -61,   58,  -36,
      41,  -83,   21,  -19,   61,  -68,   37,  -37,   12,   66,  -69,  -16,  100,  -88,   48,   21,
     -39,   73,  -24,   -2,   45,   65,  -59,   53, -103,   95,  -97,    1,  -14,   -4,  -41,    9,
     -13,  -18,   16,  -26,    9,   26,  -15,   25,  -16,    6,    8,   26,  -52,   35,  -21,    4,
      -2,  -11,   -4,   22,    0,   21,  -40,   65,   -6,  -13,  -11,   -7,   32,  -46,  -48,   16,
     -26,   -3,    0,  -42,   87,  -68,   34,   17,  -14,   43,   23,  -15,   30,   20,   47,  -19,
     -33,  -12,   15,    1,  -37,   15,  -12,  -11,   -7,   15,  -75,   36,  -41,   27,   -8,   -7,
     -12,   10,   -4,   49,   -6,   42,  -32,    4,   20,   33,  -65,   24,  -52,   10,   13,  -17,
     -15,   60,  -14,  -55,   35,  -16,   50,  -83,   -3,   29,   58,  -75,   71,  -46,   47,  -32,
      44,  -57,   10,  -43,   33,   22,  -48,   51,  -41,    6,    7,   39,   -3,  -41,    7,   -9,
      37,  -66,   22,   26,  -13,   74,  -87,  127,  -39,  -16,  -29,  -11,   -8,  -57,  -15,  -45,
      52,  -74,   -5,   -2,  103, -126,   85,   20,   28,   -7,   53,  -38,   58,  -10,  -11,   33,
     -70,   20,    1,   40,  -36,   26,  -58,   58,  -23,   61,  -71,   -7,  -39,   43,   22,  -18,
      -1,  -61,   90,  -37,   35,  -58,   30,  -62,   27,  -45,   47,  -59,   -6,  -35,   70,  -49,
       9,  -30,   92,  -15,   21,    1,   26,    6,  -19,   90,  -43,   49,  -46,   10,    6,   15,
     -90,   67,  -51,  -11,    4,   28,  -36,   24,   41,  -68,   24,  -34,   63,  -40,   17,  -30,
      18,  -39,   14,  -38,   15,    9,  -54,   54,  -20,   36,  -21,  -14,  -13,   11,   23,   11,
     -54,   56,  -25,   37,  -46,   49,  -74,   81,  -40,   51,  -44,   57,  -69,   51,  -50,   61,
      27, -112,  111, -114,  106,  -85,   49,  -61,   75,  -18,   26,  -68,   32,  -15,  -25,   21,
     -15,   38,  -46,   80, -119,  126,  -85,   41,  -40,   77,  -65,   28,   -6,  -39,   45,  -87,
      39,  -63,   81,  -32,    4,  -32,   44,  -25,   42,  -12,  -15,   21,   -1,  -56,   21,   23,
     -30,   33,  -28,   -3,   32,    4,  -36,   60,  -20,   13,   -3,   22,  -43,  101,  -88,   59,
     -53,   18,    8,   22,  -33,  -52,   34,  -32,   35,  -90,  112, -107,   56,  -59,   43,  -60,
     -18,   -4,  -21,   45,   11,  -48,   11,   38,  -27,   58,  -49,   65,   19,   54,  -38,   35,
     -37,   24,  -11,   44,  -62,   41,  -16,  -48,   -8,   31,  -68,   17,   -3,   -5,   52,  -51,
     -10,   16,  -26,   18,  -29,   56,  -41,    3,    5,  -10,  -37,   61,  -14,  -10,   -9,   20,
      -8,    8,   -2,  -16,   44,  -17,   14,  -33,   30,   -2,  -27,   16,    3,    0,   51,  -42,
      32,  -20,    8,  -11,  -24,   10,   12,  -15,    6,  -32,   10,   21,  -38,  -11,  -12,   23,
      13,  -64,   19,   34,  -23,  -23,   16,   10,   39,    2,  -36,   55,  -31,    0,  -29,   18,
       8,   12,  -61,   73,  -28,   54,  -34,   21,    9,    7,   53,  -34,  -29,   19,   -7,  -44,
       7,   15,  -16,  -18,  -31,   10,  -29,   36,  -69,    7,    4,   33,  -72,   45,   14,    0,
      -8,   35,  -13,   26,   16,  -28,   -3,  -32,   45,   -4,    8,  -20,   65,  -24,    2,  -24,
      40,  -16,  -16,   20,    8,    2,   -3,   -2,   23,  -15,  -11,  -30,   19,  -51,  -19,   -5,
     -36,   18,   24,   -4,   -1,   46,  -90,   60,    4,   23,  -17,   16,   60,  -24,    0,   18,
       0,    5,   -6,  -24,   27,  -34,  -28,   -7,   -4,   22,  -30,  -11,   -3,   -1,  -44,   36,
     -38,   -6,   -9,   55,  -34,   16,   27,   28,  -65,   62,   22,  -32,   36,    7,    2,   27,
     -19,   50,  -71,   44,  -19,  -67,   13,   -3,  -14,  -30,   33,    5,  -12,  -48,   60,  -47,
     -28,    9,   -6,   24,  -11,   -1,   13,   62,  -53,   26,    7,   -9,    6,   58,  -38,  -10,
       0,    5,  -23,   23,    8,  -14,  -19,   21,   -9,   35,  -17,  -28,   14,   27,  -17,  -14,
     -29,   24,    6,  -85,   74,  -16,  -18,   -2,  -19,   47,  -29,  -18,  -15,   52,    0,    7,
     -10,  -23,   45,   13,  -11,   12,  -28,   27,  -26,   19,  -69,   74,  -55,   35,  -21,   41,
     -24,  -11,   39,  -19,    7,    0,    7,  -31,   10,    7,  -45,  -17,   25,  -12,    9,  -19,
       3,   28,  -53,   76,  -19,  -25,   49,   -2,    6,  -11,   24,  -12,  -23,   17,   -1,  -15,
     -10,  -36,   26,  -25,    0,  -44,   59,  -67,   45,  -31,    5,   15,   56,  -12,  -14,   12,
      10,   24,  -52,   37,    5,  -35,   52,   23,  -55,   -6,   24,  -49,   26,   31,  -24,   10,
     -33,   33,  -11,    1,  -49,    8,    7,    6,  -78,   12,  -22,   10,  -11,   13,   13,  -18,
      38,   50,  -18,   -5,   64,  -52,   59,   33,    3,   -9,   -6,   -6,   26,  -64,   18,  -38,
     -47,   18,  -33,    4,  -39,   40,  -31,   -1,  -23,   48,  -30,   18,   17,   32,  -20,   32,
      19,   24,  -58,   49,  -38,   -9,   15,  -28,   16,   -3,   -2,  -28,   33,  -22,   23,   -1,
     -34,   33,  -48,   67,  -55,   21,   51,  -66,   -2,   21,   -5,  -17,   24,  -63,   53,    8,
     -19,    9,  -11,   36,  -37,  -35,   43,  -35,   -3,  -44,   68,  -43,   53,  -24,   -5,   45,
     -16,   -7,   14,   49,    3,  -16,   22,  -10,    2,  -28,   -9,   -6,   -5,   32,  -76,  -22,
      35,  -26,  -35,  -12,    0,    3,   13,    6,   36,    7,  -32,   69,  -15,   45,  -20,  -21,
      35,   35,    1,  -25,   11,   34,  -24,  -33,   -9,    5,  -25,  -49,   31,  -41,   15,  -42,
      25,  -30,   42,  -80,   32,    2,  -18,   33,  -12,   -9,   43,   -1,    4,  -12,   54,  -51,
      22,   -1,   18,   28,  -29,   18,    7,   10,  -19,    8,   -1,   12,  -21,   -6,  -11,    4,
       4,  -28,   -8,   22,  -27,   -5,    9,  -25,   20,  -19,  -36,   41,   -8,   20,  -32,   16,
     -29,   29,  -13,   13,    4,    1,   17,    8,    0,    9,   22,   -1,   -3,   28,  -11,  -39,
      36,  -31,    5,  -11,  -27,   22,  -39,    7,   15,  -24,   19,    8,  -37,   75,  -52,   54,
     -65,   22,  -13,   23,  -26,   32,  -19,   10,   -8,   -3,   12,   16,  -44,   25,  -23,   14,
       9,  -46,   20,    2,   -4,   -8,   -6,   18,    4,   -2,   -3,  -15,    4,   16,   -9,   -5,
      34,  -29,   27,  -54,   98,  -65,   11,  -18,   16,  -13,    0,   -2,    0,   22,  -43,   31,
     -46,   58,    2,  -25,   -2,   16,   -2,  -29,   17,   18,  -26,   21,  -17,    5,   -4,   -9,
       0,  -34,   50,  -27,   -3,    4,   31,   -3,  -47,   32,  -25,   36,    6,  -47,   33,  -28,
      39,  -36,   42,  -28,    5,   -3,   -2,   25,   27,  -47,   20,   22,   -5,  -15,    1,   -9,
      16,  -25,  -10,  -43,   40,  -12,  -19,   22,  -24,   -5,   14,  -44,   42,  -32,   32,  -45,
      40,   41,  -17,   27,  -44,   38,  -16,   15,  -36,   39,  -13,  -19,   -4,   34,    1,   -9,
       9,  -16,   -2,  -29,   31,  -31,   -4,   35,  -21,  -52,   63,  -41,    2,   -7,   30,  -35,
      13,    9,   15,   -4,   14,  -36,   18,  -14,   55,  -50,   -6,   22,  -23,  -11,   -5,   12,
      17,  -13,  -43,   44,  -33,   41,  -42,   45,    3,  -12,   26,   11,  -11,   35,  -76,   39,
       2,    0,    3,   -4,   15,  -19,   -6,  -33,   11,    5,   16,  -25,   -2,   19,   -7,  -43,
      30,   20,  -27,  -18,   12,   14,   33,  -50,   14,  -15,   23,    8,    2,  -10,   -4,   53,
     -86,   24,   -9,   41,  -34,  -21,   22,   24,  -54,   27,   13,    2,   -9,   14,  -29,   21,
      40,  -43,   -9,   -3,   27,   -3,  -22,   18,   10,  -23,  -15,    1,   14,  -12,    3,  -30,
      30,  -22,  -28,   36,  -15,   39,  -57,   21,    3,   -3,   33,  -13,   -2,    6,   20,   -6,
       4,  -13,   -5,  -18,   13,   -7,    7,   26,  -26,   16,    7,  -64,   37,   -7,   10,  -20,
      12,  -11,    7,  -34,   37,  -12,  -24,   34,  -18,  -18,   39,    9,  -42,  -24,   43,    2,
     -16,   25,   12,  -16,    8,   12,  -44,   32,   -9,   23,    1,  -37,   40,  -23,  -17,   18,
     -42,   23,  -12,   -7,   10,   -6,    6,  -13,  -13,   30,  -23,   36,   -4,    7,   17,  -18,
      18,   -3,    8,    5,   -1,  -13,  -15,    2,   -5,  -16,    7,  -52,   23,  -38,   30,  -30,
      16,  -26,   21,  -22,   24,    3,   20,  -28,   22,   22,  -31,   42,  -16,  -11,   32,  -26,
       0,   31,  -14,   11,  -15,   14,  -17,   -9,   10,   11,   27,  -38,   -4,   14,  -18,   36,
     -44,    0,  -11,   16,  -14,   -2,   16,  -34,  -23,   22,    4,  -24,   14,  -13,   16,   31,
     -28,  -10,   -6,   51,  -27,   13,  -49,    3,   68,  -38,    1,    8,  -27,   26,  -16,    0,
      15,  -36,    7,   -6,   38,  -11,    0,  -14,   10,   -4,   22,  -48,   31,   -1,   23,  -38,
       1,   15,   -7,   10,   -1,   -3,    4,   -1,   10,   -2,  -12,    3,  -22,    5,    9,    8,
       4,  -14,   12,   -3,   -7,   22,  -20,    3,   -6,   13,  -15,   -8,   -7,   16,  -14,   -1,
      -3,    6,  -17,   12,   22,  -44,   68,  -67,   50,   13,  -20,  -11,   -4,  -20,   -3,   22,
     -13,  -20,   28,   -7,    2,   11,   -9,  -23,    5,    5,  -26,   24,  -31,    2,   20,   15,
       2,   -7,    4,   19,   -6,   41,  -51,   -3,   24,   27,  -30,   25,  -37,    1,   -7,   -2,
      -4,  -26,   -1,   12,    5,  -12,    9,  -30,    5,   11,   26,  -18,  -32,   42,    7,    0,
     -23,   10,   10,  -20,   53,  -49,    6,  -39,   18,    3,  -27,   41,  -21,   16,   28,   14,
     -24,  -15,   19,    5,   16,  -31,   -1,   45,  -25,   -6,  -16,   -4,  -19,   37,  -47,   21,
       2,  -14,   -7,   30,  -35,   13,  -30,   14,   21,   11,  -18,  -28,   37,   12,  -18,    9,
       5,   -1,   33,  -41,    3,   -7,  -19,    8,  -14,   12,   15,  -18,   -4,   44,  -25,   22,
     -46,   19,   40,  -25,  -12,   -5,   17,    7,  -53,   25,    4,  -10,   14,   16,  -31,   40,
     -27,  -11,   -4,   28,  -40,   -5,   -9,   -3,   34,  -47,   33,   -5,   11,  -33,   33,    0,
     -14,   35,  -18,  -27,   11,   14,  -37,   35,  -20,    7,   15,    2,   27,  -17,   15,  -31,
      -1,   11,  -27,   24,  -26,   14,   13,  -35,   20,  -13,   -2,   16,   16,   -6,    2,   15,
      -7,  -22,   51,  -36,   -2,   20,  -19,   23,  -20,  -19,   -9,  -14,    8,   -4,  -13,   35,
     -66,   36,  -37,    3,   19,   -1,   15,   32,  -45,   71,  -15,   -5,   12,   34,  -33,   24,
      -5,   20,  -43,   42,  -59,   13,  -12,  -69,   66,  -29,  -34,   17,    7,  -28,   24,    5,
     -27,   51,  -40,   -9,   46,    3,  -17,   36,  -56,   63,   -7,  -31,  -19,   53,  -12,  -10,
       4,   19,  -47,   35,    0,  -40,   17,  -14,   13,  -11,   11,    3,  -39,   22,    5,   21,
     -19,  -11,   25,   -4,   -5,   20,  -13,   25,   -6,  -16,  -16,   29,  -61,   25,  -33,   12,
     -17,    7,  -19,   34,  -27,   15,  -19,   32,  -26,   54,  -46,    6,    9,   14,   -6,   -6,
      23,  -32,   58,  -19,   -5,   15,   46,  -42,   39,   -7,  -23,   -7,  -14,  -22,   42,  -66,
       0,    4,   -8,  -11,   -4,   -3,   -7,    7,  -23,   30,  -14,   19,    8,   -9,   20,   36,
       5,  -24,   25,   12,  -20,   16,  -53,   60,  -49,  -26,   24,  -87,   67,  -49,   13,   -7,
       5,  -14,    5,   11,   38,   -3,  -15,   27,   26,  -36,   20,   30,  -47,   29,   -5,    9,
     -10,   38,  -65,   47,  -49,   -4,  -10,   -6,    1,   -1,  -28,   16,  -14,    3,  -14,   27,
      -8,    1,    2,   23,   21,  -53,   40,   24,  -16,  -12,   -2,   11,   17,   -8,  -18,    8,
     -25,   28,  -10,  -12,   13,  -51,   10,   35,  -10,   -8,   -9,    8,   10,   14,  -20,    4,
      -9,   37,   -5,   -2,    2,    4,   -9,   -5,   16,  -16,  -23,   13,    7,   -9,   14,  -49,
      13,    8,   -3,  -13,   -9,   22,   -8,   12,  -13,   36,  -36,   35,  -17,   23,  -12,    0,
     -37,   50,  -31,   -8,  -31,   43,   -4,  -11,    0,    3,   -7,  -19,   16,  -16,  -28,   46,
     -28,   27,  -13,   33,  -21,   -1,   39,  -13,    3,   -4,    4,  -39,   74,  -30,  -17,   33,
      -3,  -20,  -12,   24,  -94,   75,  -63,   54,  -62,   23,    4,   12,  -33,   22,  -35,   16,
      12,  -28,   34,    2,  -12,   -3,   22,   23,  -31,   -6,   26,    4,  -41,    8,   37,  -15,
      21,   -7,   18,  -51,   42,  -27,   35,  -45,   35,  -30,   18,    9,  -20,    1,   18,  -12,
     -51,   61,  -61,   24,  -20,    1,   11,   -5,   -2,  -12,   11,   20,  -35,   -2,   37,  -21,
      23,  -15,   -2,   19,  -51,   82,  -50,   20,   29,  -26,  -34,   49,   -2,  -16,   11,  -17,
      -4,    6,   15,  -35,   13,  -15,  -10,  -17,   15,    4,  -42,   43,  -31,   34,  -30,   53,
     -43,   40,  -22,    9,    9,  -24,   64,  -41,   29,  -17,    8,  -15,    8,    2,  -27,    7,
      10,  -28,    0,   30,  -50,    6,  -13,  -14,  -21,   11,    9,   13,  -47,   35,  -11,   32,
      28,  -28,    1,   32,    2,  -19,   28,  -24,    9,    0,   19,   -6,   16,  -33,    6,  -23,
      33,  -31,   -1,   -4,   26,  -22,  -22,  -10,  -11,   18,  -26,   19,   -8,   -4,   21,  -14,
      36,   -2,   12,  -48,   49,   -1,  -13,   -5,    8,   -3,    9,   -4,  -18,   15,   28,  -50,
      10,    4,   -7,    4,  -39,   37,  -39,   11,    2,  -20,   13,    4,   -6,    0,   35,  -17,
      -9,    6,   38,  -21,   -1,   -1,   12,   -2,  -16,   15,    7,  -22,   18,  -23,   11,    3,
      -9,  -39,   29,  -31,   44,  -41,    0,    5,   21,   -9,  -25,   25,   -6,   38,  -55,   38,
     -14,    6,  -26,   38,  -24,   39,  -39,  -15,   17,   16,  -20,  -27,   17,   24,  -20,  -20,
      33,    8,  -31,    2,    2,   27,   11,   -4,   -7,   31,  -20,   -9,    4,   -4,   17,  -32,
       2,  -18,   31,  -35,   38,  -52,   42,   -1,  -28,  -26,   25,    3,  -51,   42,  -35,   35,
     -39,   44,  -38,   20,   20,  -51,   34,   45,  -10,   -7,   27,  -19,   33,  -49,   22,    2,
      -7,   -5,  -27,   59,  -24,  -20,   21,   -8,  -15,   24,  -51,    3,    9,  -23,   24,  -30,
       2,   29,  -26,   -2,    4,   10,    0,  -18,   50,    3,    9,  -14,   17,  -18,   24,  -13,
     -33,    7,   25,  -50,    2,   -2,   30,  -58,   31,   -8,   23,  -11,   -1,  -24,   21,    1,
     -41,   47,  -30,   28,  -39,   56,  -16,  -20,   51,  -45,   33,    6,   23,  -12,  -19,   -2,
       7,    1,  -14,   -5,  -11,  -20,   25,  -17,    7,  -22,   21,  -19,   34,  -47,   -2,    1,
      33,  -30,   14,   20,    6,   -9,   17,   13,  -22,   19,  -58,   23,   26,  -15,  -52,    2,
      18,   10,  -13,   46,   -5,   -8,   -6,    4,  -14,    5,   11,  -13,   -7,   42,  -25,    8,
     -37,   35,  -10,    6,  -25,   16,   15,  -15,   -9,  -20,   18,  -23,   26,  -34,   35,  -22,
     -10,    9,   14,   -6,  -21,   27,   -8,    4,    1,    3,  -19,   28,    2,   -7,   30,   -8,
     -13,   11,   -9,   -9,  -19,   12,    0,  -23,   -1,  -23,   -6,   27,  -31,   41,  -28,   13,
       5,    9,  -21,    6,    2,   -2,   18,  -16,   31,  -25,   40,  -38,   39,  -13,    8,   14,
      -3,    9,  -30,    6,  -12,   -7,  -15,   30,  -64,    6,  -22,   13,   -8,   14,  -40,    9,
      32,  -35,   14,   -1,   12,  -25,   63,  -25,   35,   -2,   19,   -5,   -3,   20,  -29,   -1,
      35,  -37,   53,  -46,    4,  -14,   22,  -27,   23,  -64,    8,    5,  -25,   41,  -18,   14,
     -42,   53,  -56,   35,  -42,   71,  -63,   45,  -38,   29,  -12,   33,  -22,    0,   24,  -13,
       3,   13,    1,  -10,  -19,   11,   19,  -38,    5,   -2,  -18,  -21,   33,  -54,   41,    9,
       4,   -1,  -21,    3,    3,   37,  -31,   34,  -40,   34,  -19,   30,  -26,   23,  -53,   55,
      -8,  -13,  -16,    7,  -13,   46,  -38,    2,   -3,   17,   -1,  -26,   18,  -57,   68,  -27,
      23,  -19,   32,  -39,    2,    2,  -18,   12,  -16,    4,  -23,   38,  -65,   40,   -5,   13,
      19,  -26,  -13,   60,  -25,    7,    1,   10,   22,  -24,   23,  -20,  -16,  -17,   14,  -32,
      26,   -4,   17,  -15,    9,  -29,    4,  -29,   11,   36,  -18,  -19,   -2,    5,   28,  -23,
      31,    6,    4,   18,  -14,    4,   -7,    0,  -45,   61,  -31,    5,  -15,  -23,  -21,   52,
     -62,    4,   22,    1,   -9,   15,  -24,  -27,   60,  -49,   38,    0,   -6,    1,   13,    7,
       4,   19,    6,    0,   27,  -28,  -14,  -21,   17,   -1,  -30,   23,   10,  -36,   18,  -19,
       2,  -18,    0,    6,   -1,    7,   -1,  -37,   26,   15,  -35,   41,  -24,   10,   10,   -9,
     -12,   12,    7,    3,   10,  -11,   11,  -14,   27,  -49,   71,  -55,   25,    8,  -11,   11,
      -5,  -22,    7,   15,  -17,  -11,   18,    4,  -54,   43,  -38,   27,   -1,    7,  -13,   19,
      10,  -41,   50,  -41,   13,    9,   10,  -41,   38,  -13,   13,   -2,   -2,   -4,    9,  -36,
      -5,   22,  -31,  -18,    8,   21,  -22,   21,  -24,   12,    3,   16,  -24,   25,  -16,   22,
     -35,   14,    3,   11,   12,  -22,   40,  -11,  -25,   14,    0,   14,   -2,    2,  -10,  -12,
      14,  -51,   11,  -21,   55,  -27,    9,    3,   38,    7,  -25,    5,  -19,    6,  -14,    0,
     -10,   21,  -57,   35,   18,  -21,   21,  -40,  -13,   24,  -24,  -12,   10,   -1,   11,   10,
     -12,   -5,   38,  -45,   23,   26,  -13,   -9,   32,    6,   -3,   30,  -28,  -28,   27,    3,
     -10,  -11,  -10,   16,  -28,   21,  -12,   -3,   -1,  -33,   14,  -30,   12,  -20,   40,  -15,
       7,   19,  -18,   -1,   -1,    9,    4,  -23,   32,   17,  -19,   12,   16,  -45,    4,   -6,
      18,  -28,   36,  -44,   44,  -29,   10,    4,   14,   -8,  -13,    9,  -30,   39,  -17,   -5,
      10,  -10,    5,   -1,  -16,   17,   -7,   -9,  -10,   15,  -21,    9,   10,    8,  -10,   -6,
       3,  -21,   34,   -3,    6,   -4,   15,    3,   -2,    4,   26,  -44,   30,  -43,    2,    9,
      -5,   -7,  -18,   16,  -28,    0,    5,   -7,    0,    7,    0,   -7,   21,  -14,   17,   15,
       2,  -40,    7,   44,  -30,   55,  -33,  -19,   40,  -30,   17,   -1,  -20,  -20,  -20,    5,
      14,    1,   -7,  -32,   26,  -11,  -11,   24,  -23,   17,   17,    8,  -19,   18,   11,   -6,
      17,   -4,  -13,   14,   -9,   21,    9,  -16,   -8,    2,  -16,    3,   -9,  -32,    6,  -36,
      -4,    0,   10,  -36,   26,  -11,    3,   31,  -20,    1,    7,    4,   45,  -35,   39,    0,
       4,   28,  -21,   29,  -39,   27,   15,   -6,  -14,   17,  -25,  -33,   16,  -15,   18,  -43,
      28,  -61,   33,    1,  -27,   13,  -19,  -20,   26,   11,  -27,   16,  -21,   33,  -13,   43,
     -44,   13,   24,  -10,   35,  -39,   36,   20,  -39,   68,  -68,   23,  -16,   -7,    0,   36,
     -30,  -13,  -27,   42,  -21,   -4,  -23,   -2,   23,    0,   -3,   -3,    2,    4,  -15,   -5,
      28,  -10,  -20,   24,   -7,   27,  -58,   31,   -7,  -29,   39,  -40,   41,  -35,    8,  -25,
      30,   31,  -17,   -9,    3,   36,   -8,  -18,  -11,   29,   -2,    6,  -25,   21,   -5,   -8,
     -17,  -24,   20,  -26,   20,  -23,   46,  -26,  -13,    8,   13,    2,  -15,    4,   -9,   28,
     -25,  -19,   49,   18,  -50,   45,  -11,  -17,    5,  -61,   15,    4,  -22,   -1,   22,   23,
      33,  -55,   46,  -25,   37,   18,    2,   -9,   11,  -47,   23,   -8,  -25,   37,  -32,    2,
       5,   12,  -18,   -5,   19,  -27,   -7,   20,  -40,   32,  -44,  -21,  -29,   58,    8,   -9,
      57,  -28,   29,  -32,   14,  -14,    4,   23,  -33,   16,   -4,  -16,   21,   38,  -37,   23,
      10,  -32,   17,   17,  -12,  -59,    9,   -3,  -12,   22,  -13,   -8,  -26,   16,    1,   33,
      -9,  -17,   16,   -7,   21,  -44,   26,    5,   35,  -36,   -1,   13,   36,  -36,   39,  -36,
      17,  -13,    2,  -33,   20,  -13,  -51,   -2,    9,   -2,   35,  -21,   19,  -20,   18,  -19,
      -5,   30,  -39,   30,   22,  -35,   74,  -52,   33,  -15,   17,  -21,  -13,   11,    6,  -25,
      25,  -31,   29,  -18,   18,  -52,   40,  -11,  -17,  -26,   56,  -56,   69,  -53,  -14,   32,
     -10,   -8,   -2,   18,  -14,   20,  -18,   20,   22,  -27,    0,  -25,   56,  -46,   16,  -28,
      52,   -5,  -33,   76,  -75,   36,   -1,  -42,   42,  -46,   13,  -13,   25,   -7,   35,  -55,
       5,   63,  -56,   11,  -24,   13,   -8,  -10,  -27,   15,  -15,   44,  -66,   52,   -3,   -6,
       0,   23,  -33,   79,  -55,   30,  -27,   37,  -18,   -6,   -2,  -19,   52,  -22,  -50,   60,
     -32,   28,  -56,   44,  -28,   15,  -37,   -9,  -28,   63,  -75,    9,   39,   28,  -21,    5,
     -17,   15,    2,  -13,   30,   13,  -14,   10,  -12,   30,  -22,  -10,    4,   -8,   -9,   14,
       6,  -39,   34,   -6,    4,    1,   -5,    0,   33,  -73,   34,  -12,   23,   -9,   53,  -47,
      17,    3,  -18,   -6,    2,  -19,  -12,   -7,  -45,   72,   -9,  -71,   55,  -58,   50,  -18,
     -36,   37,   19,  -11,   13,  -35,   32,    6,    5,   18,   -6,   19,  -26,   32,   16,   20,
     -43,   20,  -10,   -7,   16,   -7,  -68,   21,  -36,    7,   19,  -22,   19,   -3,  -35,  -37,
      25,   21,  -57,   67,   -9,    9,   32,  -11,   28,  -18,   35,  -41,   60,  -19,   29,    0,
     -38,   29,   -6,  -35,    0,   25,  -37,   -1,  -31,  -42,   30,  -19,  -21,   36,  -66,   53,
     -33,   15,   16,  -13,   20,  -35,   73,   -4,   18,   39,    4,    1,    3,   21,   -2,  -12,
     -18,  -51,   44,  -17,  -50,   48,  -30,  -16,  -13,  -35,   -7,   25,  -33,  -14,   14,    0,
       8,  -30,   45,  -13,   50,  -53,   28,   60,  -33,   23,   -7,   -2,   15,   36,  -11,    9,
      19,  -44,    4,  -21,   19,   -5,  -27,  -45,   48,    9,  -47,  -23,   12,    3,  -25,   -8,
     -21,   63,    1,  -29,   31,  -18,   19,   16,  -24,  -17,   50,  -65,   65,  -56,   93,  -45,
     -17,  -25,   45,  -18,   23,  -53,   50,  -15,  -12,  -39,   51,  -11,   11,   13,  -31,   54,
     -14,  -29,   22,  -11,   10,  -41,  -19,   52,   10,  -51,  -60,   72,  -13,   12,  -38,   19,
      -2,   31,  -56,   37,   -4,  -10,   22,  -14,  -33,   48,  -40,   38,  -14,   27,  -24,   19,
      29,   17,  -31,   -2,  -41,   34,  -17,    2,    5,    5,  -13,  -30,   14,    9,   -9,    7,
     -11,   15,    5,  -28,   -2,    0,   45,  -30,  -25,    1,   10,   29,  -55,  -24,   52,   -5,
       5,   20,  -25,   20,  -15,   14,  -64,   95,  -53,   32,   13,  -26,   31,   -8,  -27,   18,
      48,  -57,   -3,  -10,   25,  -24,  -32,   -9,   18,   18,  -33,  -15,   27,  -22,   14,   -5,
      10,   51,  -21,  -25,   19,    5,  -15,  -29,   16,    1,   33,  -39,  -12,   56,   14,  -63,
      36,   -2,  -17,   52,  -11,  -37,    5,   19,  -52,   38,  -23,  -60,   93,  -75,   52,  -30,
      -2,  -11,   49,  -11,  -25,    1,   42,  -35,   26,  -35,   -9,   24,   -1,   10,   -6,  -12,
       7,    4,   22,  -10,   41,  -25,   -8,   -4,   -2,   28,  -43,   19,  -32,    4,  -27,    9,
     -47,   51,  -16,   12,  -52,   49,    8,    7,  -37,   27,  -33,   80,  -44,    6,    5,   28,
     -15,   16,   15,    2,  -12,   50,  -77,   38,  -38,  -45,   30,    8,  -37,  -13,   -8,  -18,
      50,    3,  -54,   29,   29,  -20,    4,   52,  -57,   62,  -52,   -2,   -9,   62,  -64,   -5,
      24,   23,    0,   -7,  -23,   48,   25,  -78,   -9,   38,   18,  -46,   30,  -51,   39,    4,
     -48,   22,   15,   13,  -39,    8,   10,   31,  -20,  -22,   21,  -17,   17,  -23,   22,   22,
     -24,  -36,   11,   31,  -16,  -28,   34,   -4,    0,  -20,    6,   -2,   35,  -13,  -60,   36,
      24,  -45,   21,   -2,   36,    0,  -73,   66,  -37,   39,  -66,  -18,   22,   17,  -17,  -25,
      24,   36,  -47,    3,   25,    7,    8,    0,    1,   14,   20,  -21,    4,   21,   12,  -77,
      17,   -4,  -12,   31,  -57,   38,  -11,   -4,  -31,   -6,   29,  -34,   11,   13,  -20,   82,
     -36,  -36,   40,  -28,   77,  -68,   12,    2,   34,  -23,    5,  -31,   11,   -5,   44, -105,
      79,  -31,  -29,  -16,   37,    8,   18,  -14,   -9,   32,  -10,  -11,   -7,    0,   41,   34,
     -56,    7,   13,   -2,  -31,   33,  -67,   42,  -31,   -2,   22,  -49,   18,  -34,  -11,   38,
     -40,   56,  -16,   14,   -2,   24,    0,    0,   41,  -21,   -8,    6,  -11,   11,   11,  -45,
      26,    4,  -17,   -7,  -26,  -30,    7,  -21,  -29,   56,  -29,   37,   -3,    2,   -8,   -3,
      22,   11,   40,  -13,   58,   -6,  -38,   48,  -23,   15,  -52,  -14,   -6,   49,  -66,  -20,
     -11,   34,  -32,  -44,   41,    4,   20,  -59,  -24,   77,   23,  -24,  -17,   42,   19,   -3,
     -19,  -34,   54,   17,  -22,  -17,   46,  -24,   -9,    3,  -22,   40,  -47,  -49,   72,    4,
     -18,  -48,  -33,   55,   -4,  -41,  -51,  105,  -26,   -3,  -22,   64,   28,  -51,   31,    2,
      15,   27,  -62,   18,   21,    6,  -15,  -54,   52,  -14,  -46,    7,  -30,   32,   -1,    6,
     -37,   39,   -3,  -23,  -20,   24,   23,   17,  -25,   -6,   67,  -36,  -11,  -37,   56,  -79,
       3,   30,   45,  -39,  -17,   -2,   21,    2,   -4,   -3,    3,    1,   16,  -16,    9,   30,
     -37,    8,   -6,   46,  -65,    3,   14,  -59,  104,  -60,    2,   46,  -29,  -30,   -2,  -10,
      24,  -52,   63,  -31,   81,  -85,   18,   35,   16,  -32,  -18,  -24,   45,  -16,  -15,  -13,
      37,  -15,  -20,  -42,   91,  -45,  -15,   -9,  -16,   64,  -11,  -23,   31,  -18,   38,  -42,
       3,   12,    1,    5,   -5,   22,  -44,   69,  -31,  -18,   15,   21,  -64,  -13,   34,  -37,
      30,  -26,  -15,    6,   -3,   44,  -28,   11,   -3,   -1,   16,  -18,   25,  -14,  -26,   69,
     -56,   -5,   31,  -51,   24,    3,  -36,    9,   52,  -34,   31,   21,  -11,  -68,   31,  -24,
      53,  -25,  -29,   31,   23,  -20,    9,  -15,  -11,   19,   12,  -47,   84,  -60,  -16,  -11,
      17,   -4,  -15,   30,  -45,   32,   34,  -63,   -7,   68,    0,  -35,   17,    7,   33,  -31,
      -8,    7,  -32,   43,  -13,  -18,   15,   31,  -32,  -34,    5,    8,  -16,   20,  -26,  -29,
      32,   -9,  -20,   17,   33,  -31,  -13,   -5,   86,  -52,   23,  -19,    2,   13,   14,   -7,
     -20,   36,  -16,   -3,    8,    0,   14,  -69,   76,  -77,   25,  -14,  -17,    3,   39,  -14,
     -46,   31,   -2,   -7,   37,  -45,   -6,   24,   28,  -37,   22,   13,  -35,    4,    8,   23,
       7,  -43,   53,  -59,   23,   16,    4,  -25,  -15,   23,   -9,  -20,   26,  -18,   -1,   25,
      -3,  -48,   53,    2,  -43,    7,   14,  -34,   15,   28,  -33,   53,   -2,  -59,   31,  -34,
      40,   19,  -27,   20,   -2,    8,    2,    3,   -8,   -8,    4,  -57,   62,   24,  -72,   -4,
      17,  -17,   -3,  -10,  -26,   42,  -30,   12,  -29,   31,  -10,    3,   24,    2,   21,   -1,
     -36,   52,   -7,   21,   14,  -32,  -18,   73,  -45,   -6,    8,  -12,  -66,   21,   25,  -17,
      -6,  -35,  -14,   27,   26,  -47,   40,  -51,   56,  -19,  -24,   31,    6,    4,   11,   -3,
      37,  -47,   41,  -32,   50,    0,  -72,   25,   16,  -19,   -1,   -2,   -4,  -41,   20,    6,
       9,   -3,  -44,   32,  -54,   83,  -30,  -26,   -8,   46,  -47,   29,    5,  -19,   37,   -9,
     -20,   65,  -14,  -21,   -4,   10,   28,  -28,   18,  -29,   35,  -25,    3,  -17,  -31,    4,
      -4,    0,   -9,   41,  -42,  -34,   40,  -15,    8,  -24,   -8,   36,   22,  -18,  -27,   70,
     -39,   39,    1,   -5,   57,  -54,   12,   36,    3,  -13,   -1,  -32,   69,    6,  -64,  -50,
      13,  -13,  -34,   22,  -13,    0,  -10,  -38,   41,  -11,  -22,   -3,   11,    4,   38,   22,
     -10,   24,   32,  -23,   23,   -6,    8,   -4,   21,  -61,   66,  -35,  -41,    7,    5,  -29,
     -19,  -45,   23,   -2,   46,  -84,   78,  -59,   40,  -10,  -18,   79,  -35,   -5,   -1,   36,
      16,   13,  -21,  -31,   52,    2,  -50,   34,   -5,  -36,  -37,   65,  -42,    1,   16,  -42,
      35,   -8,  -50,   -6,   41,  -16,   27,  -41,   22,   64,  -50,  -11,   31,  -18,  -17,    5,
      -3,   34,   34,  -40,  -41,   66,  -37,   20,  -11,  -20,   29,   -5,  -14,  -15,   45,  -33,
     -37,  -11,   36,  -25,   18,   -8,   20,    1,  -23,   60,  -32,    0,   34,  -24,  -32,   64,
     -39,  -35,   48,   -7,  -13,    4,  -39,   32,    0,    1,  -31,    2,  -12,   43,  -38,   -8,
      26,    0,  -57,   53,   19,  -22,  -10,   17,  -30,   57,    6,  -31,   33,   10,    0,  -48,
      29,   -4,  -23,    6,   -7,   31,  -39,   15,  -41,   38,  -19,    5,  -37,   23,   11,  -28,
     -14,   59,  -48,    8,   22,  -20,   50,   15,  -34,  -26,   67,   -8,  -15,  -21,   53,  -27,
      -9,   13,  -24,  -35,  -10,    9,  -15,  -13,   18,  -38,   28,   22,  -14,    2,  -22,   42,
     -20,   22,   12,  -20,   45,  -16,   17,  -16,   22,   34,  -27,  -13,   -7,    1,  -21,   -1,
      13,  -44,   36,  -51,   -8,   16,   -7,  -30,  -46,   90,  -54,   35,    1,   11,    9,    5,
       1,  -19,   20,   11,   21,   -1,  -49,   41,   -6,    0,   37,  -74,    9,   20,  -12,  -47,
      65,  -68,   28,   -5,  -26,   15,   14,   -3,  -23,    8,   18,  -22,   13,    3,   31,  -21,
      -5,    8,   24,  -21,   48,  -20,  -21,   41,  -43,    4,   18,   21,  -60,    9,  -27,    1,
      13,  -15,  -33,   15,   23,  -48,   -8,   53,  -50,    1,    6,  -40,   90,  -10,  -15,   51,
     -52,   53,   29,  -68,   50,   52,  -30,  -21,    7,   -1,   -8,  -29,   11,  -47,    6,   18,
     -12,  -25,   53,  -34,  -23,   -6,   19,   -7,  -13,    7,    5,   -2,   14,   11,  -15,   51,
     -29,    6,   12,   20,  -27,   29,  -12,    4,  -18,   -5,    2,  -17,   10,  -19,    2,   -8,
      -5,   56,  -82,   49,    0,  -42,   48,  -25,   19,    6,  -41,   17,   35,  -18,  -17,  -29,
      26,   10,    4,  -24,   26,  -35,   47,  -36,    2,    2,  -23,   27,  -42,   55,    0,  -21,
      19,   21,   -8,    1,   -3,  -15,    7,   12,  -23,  -29,   47,  -12,    4,  -28,   17,   16,
      -7,  -31,   -8,   25,   -6,    0,   13,  -20,    6,    3,   -7,   19,  -21,  -37,   27,   41,
       7,  -14,   12,  -59,   57,    6,  -49,   -2,   -8,    0,   19,   13,  -20,   -5,   16,   23,
       4,  -15,  -33,   14,    2,   15,  -26,  -28,   10,   45,  -17,  -24,   14,   17,  -39,   22,
      -8,   48,  -51,   -1,  -16,   52,  -34,  -21,   11,   13,   18,  -57,   26,   15,   27,  -36,
     -12,   40,   -7,  -14,   15,  -86,   91,  -20,  -13,   -7,   53,  -43,   33,  -25,   13,    3,
     -38,  -19,   28,   28,  -18,  -74,   58,   -3,   40,  -27,  -34,   30,   28,   -1,  -22,    2,
       9,   -8,  -12,   12,   21,  -35,   -2,  -17,   17,    2,  -27,   22,  -36,   38,  -11,    2,
     -20,    7,   20,  -29,   39,   11,   -3,    9,  -24,   47,  -36,   28,  -14,  -16,   38,  -37,
      12,  -15,   18,  -69,   56,  -31,   17,  -16,  -18,  -13,   21,   -6,   -9,  -25,   37,    6,
      -1,   -2,    5,   -1,  -26,   39,    6,   -3,  -10,    0,   12,   30,  -12,  -31,   24,   13,
     -14,    9,  -23,   31,  -43,  -17,   -2,   13,  -23,  -14,  -21,   21,   19,  -22,  -12,   24,
      41,  -26,   10,   12,   19,   -3,    9,  -12,   26,   12,  -52,   -4,   16,   -3,    0,  -43,
       7,    5,  -14,   -9,   12,  -28,   15,  -23,   -2,   35,  -12,   -8,  -10,   24,   57,  -55,
      26,  -18,   19,   44,  -30,    0,   -5,   50,  -56,   -1,    8,   -5,  -39,    9,   19,  -39,
      38,  -73,   30,   -1,    2,   16,  -24,    6,   29,  -71,   70,  -18,   -6,    8,   31,    4,
     -13,   23,  -11,   31,  -56,   57,  -25,   10,   15,  -44,  -10,   16,  -17,  -44,   18,  -28,
      10,    8,  -21,   -4,   -9,   28,   20,  -16,   17,  -17,   -6,   30,    0,   11,  -21,   25,
      25,   -1,   31,  -56,   31,   14,  -32,    2,  -19,    4,  -17,  -26,  -13,   42,  -59,   15,
     -29,   53,   -4,    1,  -23,   13,   31,    5,  -22,    3,   30,  -28,    2,  -24,   37,    1,
      -3,  -18,   18,   41,  -40,    3,  -40,   48,  -31,   -5,  -20,    5,    9,    0,  -30,   -1,
      26,  -15,   -5,   -6,   51,  -25,  -27,    7,   44,  -11,   10,  -32,   14,   46,  -31,    6,
     -11,   37,  -33,  -14,   19,   -4,   22,  -50,   26,  -45,   21,    1,  -23,   10,  -15,   17,
     -63,   53,  -14,  -18,   56,  -49,   21,   25,   -7,    4,  -21,   52,  -33,   19,    3,   11,
      -9,   -7,    0,  -49,   22,  -17,   25,  -10,  -11,    5,  -19,   35,  -26,   20,   -7,  -21,
      37,  -25,   29,  -23,    3,    6,   17,  -26,   27,    5,  -16,   10,   -9,  -24,   11,   -4,
     -17,    9,   -5,  -13,    1,   -2,   10,    5,  -13,   21,    0,    8,    9,  -22,   12,   13,
     -24,   -3,  -22,   42,  -18,    3,   -4,  -15,    1,   -2,    8,  -17,  -13,   -2,    1,   23,
      10,   -2,  -31,   23,   17,  -15,   -9,  -24,   31,    2,   19,  -24,    4,  -22,   28,   -5,
     -20,   34,  -57,   26,   71,  -51,   28,  -24,  -12,   28,   10,  -35,   -4,   -6,    7,   -7,
       8,  -52,   61,  -52,    7,   -9,  -21,    9,   18,  -19,    3,   34,  -53,   56,  -29,   20,
     -11,   22,    4,   -1,   23,    2,    1,   24,  -15,    3,  -32,   13,   21,  -37,    6,  -11,
     -25,   22,    7,   -2,  -41,    4,   10,  -30,   39,  -24,   -7,    8,   12,    9,   -1,  -35,
      13,    3,    9,  -18,   21,   26,  -14,   41,   -8,  -35,   31,  -29,   17,  -20,  -12,   20,
     -30,   27,  -26,   21,   -9,   -6,    5,  -14,    3,  -11,   15,    2,    8,  -14,   -5,   20,
       4,    0,  -31,    9,    4,   25,  -24,    5,   -5,  -13,   27,   -7,  -32,    1,   -5,  -10,
      28,    7,   -4,   11,   10,   22,   -3,  -22,  -15,    6,   -3,   -3,  -27,  -25,    5,    8,
     -10,  -17,   18,  -18,   12,   32,  -18,    1,   25,  -25,   50,    7,    2,    0,   -3,   -3,
      16,  -20,    9,  -14,  -15,   21,  -27,   -3,  -17,   23,  -31,   -4,  -18,   31,  -21,    6,
       0,   18,  -16,   27,    3,   -7,  -17,   17,  -15,  -11,   19,  -16,    6,    1,   12,  -18,
       5,   -6,   24,    0,  -19,   22,  -23,   43,  -35,   18,   22,  -40,    1,   12,   -4,  -18,
      26,  -53,   34,    1,  -10,    1,  -18,   27,  -25,  -24,   33,  -31,    9,  -43,   53,  -29,
      33,  -17,    5,   23,   -7,    2,   23,   29,    1,   -8,   20,  -10,   -1,  -22,   -3,  -17,
       4,   22,  -61,  -23,   31,  -26,  -29,  -12,    2,   -3,   12,   10,   26,    5,  -29,   61,
      -9,   32,  -18,  -14,   29,   31,    2,  -19,    9,   31,  -20,  -31,   -7,    5,  -22,  -47,
      31,  -40,   15,  -39,   22,  -27,   40,  -78,   31,    4,  -19,   33,  -13,   -8,   41,   -1,
       5,  -12,   53,  -51,   22,   -1,   18,   28,  -29,   -1,    0,    0,   11,   13,   -2,   -7,
      -5,   -3,   -3,    1,    2,   -6,    0,    3,    8,    9,    5,    0,   14,   -5,  -28,  -39,
     -39,  -36,  -37,  -27,  -43,  -49,  -13,    4,    6,   -7,    0,   -1,    3,   23,   39,   29,
      35,   41,   21,   35,    0,    0,   21,   59,   67,   31,   21,   13,   -3,   18,   34,   28,
       5,    3,   13,    3,    0,   12,   -7,  -33,  -27,  -39,  -14,  -34,  -50,  -30,  -37,  -35,
     -53,  -74,  -70,  -61,  -62,  -62,  -50,  -44,  -61,  -36,   -3,  -23,  -15,  -12,  -17,  -20,
      -6,   11,   -6,  -12,   -6,  -17,    7,   46,   71,   87,   79,   70,   77,  104,  109,   66,
      37,   34,   27,   31,   40,   43,   31,   23,   17,    2,   10,   24,   32,   66,   56,   17,
     -13,  -55,  -54,  -21,   19,  -19,  -56,  -77,  -37,  -27,  -10,   -6,  -38,  -36,  -37,   -3,
      23,   25,   25,   19,   35,   34,   -7,   -5,   28,   60,   66,   65,   51,   34,   22,   53,
      51,   15,   20,   11,   21,   21,   16,   24,   -2,  -23,  -36,  -35,  -21,  -29,  -51,  -51,
     -47,  -57,  -85,  -80,  -70, -100,  -97,  -82,  -78,  -76,  -64,  -51,  -56,  -54,  -49,  -70,
     -62,  -53,  -54,  -60,  -57,  -65,  -78,  -76,  -62,  -39,    0,   31,   13,    6,   31,   54,
      55,   43,   30,   13,    9,   31,   23,   43,   28,   24,   36,   36,   24,   30,   54,   70,
     113,  103,   75,    4,   -3,   40,   55,   50,   23,    9,   25,   29,   48,   41,   29,   14,
       6,   40,   63,   49,   39,   71,   80,   64,   21,   12,   17,   29,   68,   71,   52,   36,
      24,   37,   24,    1,    5,    3,   -6,   -4,    1,   13,   -3,  -22,  -35,  -31,  -27,  -58,
     -59,  -43,  -55,  -71,  -76,  -71,  -88, -103,  -95,  -98,  -85,  -77,  -68,  -71,  -58,  -50,
     -47,  -52,  -46,  -40,  -47,  -44,  -48,  -56,  -60,  -91,  -96,  -68,  -15,   -6,  -16,    9,
       3,   29,   31,   29,    8,   10,   -6,    5,   10,   -6,   -4,   -6,   15,    7,   -2,    2,
      -5,   30,   91,  107,   74,    8,   -3,   14,   27,   32,   26,   17,   21,   18,   34,   49,
      20,   -3,    2,   30,   42,   20,   36,   68,   79,   81,   52,   27,   22,   37,   80,   95,
      77,   77,   72,   74,   57,   55,   56,   41,   35,   22,   40,   58,   32,   23,   24,   26,
       0,   -7,    6,   -2,  -16,  -26,  -31,  -45,  -46,  -64,  -77,  -79,  -73,  -72,  -75,  -59,
     -49,  -56,  -35,  -48,  -44,  -50,  -43,  -59,  -58,  -40,  -78, -119, -123,  -95,  -73,  -40,
     -52,  -45,  -29,  -18,   -3,   -1,  -11,  -21,  -28,  -12,  -24,  -29,  -21,  -29,  -16,   -3,
      -5,  -30,  -40,    1,   69,   96,   78,   31,   14,   23,   17,   19,   33,   20,    9,    9,
      45,   50,   14,    3,   12,   13,   16,    7,   14,   35,   54,   75,   56,   24,    1,   18,
      47,   47,   60,   62,   66,   69,   46,   54,   53,   38,   11,   18,   44,   41,   28,   33,
      37,   22,   14,   15,   13,   13,    1,   -1,  -13,   -6,  -11,  -38,  -33,  -47,  -40,  -46,
     -31,  -29,  -22,   -9,   -5,   -9,    9,    4,  -23,  -14,   -4,   -3,  -26,  -69,  -87,  -74,
     -60,  -42,  -49,  -33,  -28,  -16,    9,    2,  -16,  -22,  -25,  -25,  -33,  -32,  -44,  -58,
     -41,  -11,  -19,  -51,  -77,  -43,   24,   47,   49,   34,   21,    5,   -9,    5,   18,  -10,
     -14,    2,   23,   26,   -3,   -7,   -4,    2,   -3,  -10,   -4,   -6,   38,   64,   50,   25,
       1,   11,   17,   21,   36,   58,   62,   46,   46,   61,   56,   27,   11,   20,   18,   27,
      15,   31,   26,   23,   17,    7,   16,    0,   -9,  -10,   -3,   -8,  -14,  -25,  -36,  -56,
     -41,  -39,  -50,  -30,  -12,  -23,   -8,   10,   23,   17,   -2,    3,   14,   26,    7,  -33,
     -48,  -53,  -52,  -35,  -30,  -30,  -23,    3,   21,   17,    8,    7,   -8,   -1,    0,   -6,
     -29,  -50,  -26,   10,    5,  -38,  -64,  -41,    5,   22,   49,   63,   38,   20,   13,   26,
      15,   -7,   -9,   -1,   28,    9,    1,   -4,  -12,   -1,   -5,  -20,  -38,  -32,    6,   38,
      36,   16,   10,    0,   -8,  -13,   15,   41,   25,   30,   30,   52,   35,   17,    8,    3,
      -5,   -5,   -6,    4,    7,    4,    4,    3,    3,  -20,  -25,  -23,  -28,  -22,  -18,  -47,
     -50,  -54,  -62,  -67,  -62,  -48,  -43,  -44,  -31,  -10,   17,   10,   -8,    1,   22,   24,
      17,   -1,  -21,  -40,  -39,  -26,  -38,  -32,  -21,    2,   17,   26,   29,   18,    5,   15,
      35,   19,  -11,  -37,   -9,   33,   17,   -6,  -30,  -23,  -10,   22,   65,   73,   71,   47,
      57,   66,   38,   15,   16,   23,   34,   35,   27,   10,   11,   21,   32,   -4,  -26,  -29,
       4,   29,   28,   38,   32,   17,   -6,   -6,   17,   32,   21,   31,   39,   49,   36,   27,
      25,   13,   -1,  -11,   -8,   -1,  -15,  -11,    4,   -7,   -9,  -14,  -38,  -46,  -35,  -31,
     -43,  -53,  -54,  -72,  -84,  -88,  -86,  -79,  -73,  -86,  -69,  -40,  -16,  -23,  -28,  -13,
      -9,    5,    5,  -10,  -34,  -45,  -48,  -52,  -61,  -59,  -42,  -38,   -9,   13,   19,    8,
     -14,   18,   42,   28,  -18,  -31,   -3,   11,   21,   13,   -9,  -17,  -22,    9,   57,   71,
      62,   68,   83,   82,   65,   38,   38,   31,   52,   57,   45,   23,   25,   51,   56,   21,
      -2,   -8,    7,   21,   28,   55,   55,   37,   15,   17,   30,   30,   30,   48,   55,   65,
      55,   54,   61,   42,   24,   22,   13,    6,    6,    4,    4,   17,   19,    1,  -20,  -23,
     -25,  -27,  -26,  -44,  -44,  -62,  -79,  -91,  -83,  -76,  -99, -104,  -87,  -63,  -51,  -40,
     -42,  -40,  -29,  -16,   -6,  -31,  -40,  -47,  -63,  -68,  -81,  -76,  -81,  -75,  -49,  -15,
      -5,  -34,  -38,    2,   15,    8,  -29,  -43,  -33,  -18,  -11,    8,   -9,  -42,  -45,  -14,
      25,   33,   41,   54,   67,   75,   71,   46,   30,   23,   52,   55,   38,   20,   25,   53,
      59,   35,   17,    6,    3,    5,   27,   64,   61,   49,   40,   40,   45,   36,   38,   63,
      69,   69,   77,   85,   78,   76,   63,   48,   38,   42,   28,   15,   30,   35,   41,   27,
      14,    0,   -4,   -2,  -14,  -16,  -15,  -35,  -65,  -63,  -56,  -64,  -80,  -94,  -77,  -71,
     -46,  -34,  -42,  -37,  -21,   -6,   -5,  -16,  -20,  -35,  -44,  -62,  -66,  -66,  -96,  -94,
     -58,  -26,  -32,  -44,  -50,  -14,    2,   -9,  -26,  -41,  -53,  -49,  -27,   -5,  -28,  -59,
     -65,  -47,  -20,  -11,    7,   15,   28,   51,   57,   32,    7,    2,   30,   32,   15,    0,
       7,   30,   30,   24,   21,   -2,  -19,  -20,    6,   37,   40,   31,   40,   45,   30,   29,
      35,   49,   52,   69,   74,   78,   89,   79,   72,   62,   60,   51,   37,   29,   29,   42,
      51,   46,   30,   32,   18,    2,    8,   13,   15,  -13,  -35,  -35,  -38,  -40,  -53,  -71,
     -70,  -58,  -34,  -38,  -32,  -28,   -9,   10,   10,    7,   11,   -7,  -28,  -21,  -26,  -47,
     -80,  -84,  -49,  -18,  -28,  -38,  -32,   -8,   -4,    4,    3,  -23,  -46,  -44,  -19,   -5,
     -22,  -42,  -55,  -56,  -35,  -25,  -12,   -8,   11,   43,   51,   33,    1,    0,   24,   18,
       1,   -5,    0,    1,    9,   15,   21,   -2,  -38,  -36,  -19,    2,    2,   19,   26,   19,
      20,   10,   11,   20,   31,   37,   49,   62,   64,   61,   60,   61,   50,   51,   32,   10,
      16,   27,   31,   33,   33,   36,    7,   -6,    3,   14,   12,  -10,  -21,  -40,  -34,  -33,
     -47,  -65,  -67,  -60,  -40,  -40,  -44,  -25,  -10,   -4,   14,   26,   22,    4,   -7,    8,
       8,  -22,  -67,  -65,  -33,  -19,  -24,  -20,  -18,   -8,    1,   26,   30,   -2,  -22,  -25,
      -6,    5,   -1,  -13,  -38,  -43,  -31,  -21,  -16,  -16,    9,   47,   61,   35,   22,   22,
      31,   24,   10,   13,    5,   -2,    0,   28,   34,    1,  -21,  -30,  -28,  -18,   -5,    5,
      18,   20,   14,    6,    6,   12,    9,   20,   33,   39,   51,   51,   42,   51,   51,   48,
      20,    9,    7,    5,    7,   15,   28,   19,   -1,  -16,  -15,   -4,    4,  -16,  -30,  -41,
     -45,  -41,  -50,  -79,  -77,  -69,  -65,  -64,  -56,  -45,  -40,  -28,   -4,   21,   17,   -8,
      -9,   21,   16,  -18,  -56,  -58,  -44,  -39,  -24,  -22,  -28,  -22,   -4,   29,   31,   13,
      -9,  -16,   -3,   11,   13,    1,  -18,  -33,  -15,  -11,  -23,  -22,   11,   52,   58,   50,
      46,   50,   49,   36,   40,   40,   17,    6,   20,   37,   45,   29,    9,   -7,  -12,  -11,
      -6,    9,   30,   25,   26,   26,   17,   19,   15,   21,   24,   46,   55,   47,   43,   56,
      64,   52,   33,   25,   13,   -3,    2,   10,   21,   26,    4,  -15,  -16,  -13,   -2,  -11,
     -32,  -43,  -37,  -44,  -61,  -77,  -78,  -82,  -82,  -80,  -71,  -61,  -72,  -59,  -21,    5,
      -2,  -27,  -10,   15,    7,  -14,  -44,  -59,  -67,  -55,  -37,  -38,  -50,  -45,  -23,    5,
      23,    9,   -6,  -19,  -15,    5,   14,    2,  -22,  -22,  -10,  -17,  -35,  -38,   -3,   35,
      38,   43,   57,   51,   44,   49,   57,   46,   25,   14,   24,   35,   54,   41,   31,   22,
       1,   -7,   -4,   12,   23,   34,   37,   35,   35,   36,   26,   24,   33,   55,   62,   53,
      58,   70,   70,   73,   62,   51,   38,   14,    6,   20,   31,   32,   27,    4,   -9,   -1,
       9,   -8,  -21,  -22,  -27,  -33,  -53,  -64,  -67,  -82,  -86,  -83,  -67,  -75,  -97,  -77,
     -36,  -15,  -27,  -32,  -18,   -1,   -1,   -6,  -31,  -62,  -73,  -68,  -52,  -52,  -68,  -69,
     -50,  -21,   -2,    4,  -10,  -33,  -29,   -4,    2,  -10,  -29,  -22,   -8,  -27,  -55,  -49,
     -27,   -6,   12,   31,   43,   31,   38,   44,   54,   48,   25,   11,   19,   30,   36,   41,
      41,   29,   11,   -1,   -9,    0,   15,   27,   34,   36,   46,   46,   26,   27,   39,   51,
      59,   62,   62,   73,   76,   77,   85,   78,   58,   35,   23,   21,   37,   53,   37,   22,
      15,   16,   20,    3,    0,   -2,   -2,  -14,  -33,  -35,  -45,  -69,  -77,  -59,  -53,  -76,
     -96,  -74,  -41,  -30,  -25,  -26,  -19,   -4,    7,   11,   -8,  -40,  -62,  -62,  -51,  -55,
     -69,  -74,  -71,  -44,  -15,   -2,  -14,  -36,  -38,   -8,   -7,  -27,  -33,  -17,  -12,  -38,
     -51,  -57,  -58,  -41,  -14,    8,   19,   15,   15,   31,   46,   40,   21,    9,    7,   10,
      20,   25,   33,   28,   16,    1,  -18,  -13,    0,    6,   12,   30,   39,   39,   26,   20,
      32,   41,   45,   53,   64,   63,   62,   80,   84,   87,   81,   51,   29,   21,   44,   52,
      41,   33,   29,   31,   27,   12,    8,   16,   10,   -4,   -7,   -7,  -29,  -62,  -57,  -37,
     -44,  -68,  -81,  -70,  -48,  -33,  -23,  -22,  -17,   -5,   16,   31,   14,  -15,  -33,  -42,
     -41,  -37,  -53,  -65,  -74,  -54,  -16,    2,  -12,  -33,  -19,   -1,  -10,  -22,  -17,   -8,
      -8,  -18,  -33,  -48,  -62,  -57,  -31,   -1,    7,    0,    9,   22,   40,   40,   27,   14,
       4,    3,   10,   14,   21,   31,   20,    0,  -13,  -19,  -17,  -15,   -7,   12,   29,   28,
      13,   20,   18,   18,   31,   38,   47,   49,   51,   56,   67,   87,   84,   56,   30,   20,
      31,   41,   31,   24,   32,   33,   20,    7,   14,   15,   -2,   -1,   13,    4,  -28,  -53,
     -45,  -34,  -38,  -59,  -75,  -72,  -58,  -44,  -26,  -26,  -29,   -8,   14,   34,   28,   10,
      -9,  -22,  -26,  -24,  -30,  -54,  -78,  -56,  -13,   -4,  -17,  -16,   -5,    1,   -6,   -9,
      -8,   -1,    3,   -2,   -4,  -28,  -53,  -58,  -37,  -10,    1,   -1,    6,   20,   34,   46,
      40,   25,   19,   11,    7,   10,   23,   33,   28,   16,   -3,   -3,  -17,  -31,  -14,    4,
      15,   20,   20,   16,   10,   14,   19,   23,   37,   45,   35,   37,   53,   76,   83,   62,
      34,   20,   27,   28,   13,   17,   29,   21,    7,    9,   13,   -4,  -17,   -4,   13,    2,
     -27,  -53,  -47,  -39,  -46,  -56,  -77,  -87,  -77,  -58,  -45,  -46,  -47,  -33,   -6,   17,
      22,   16,    1,  -20,  -25,  -10,  -21,  -57,  -79,  -57,  -32,  -24,  -23,  -18,   -3,   -1,
      -6,   -4,   -4,   -5,    3,   13,   14,   -6,  -38,  -51,  -39,  -22,   -4,   -1,    3,   14,
      32,   45,   46,   46,   33,   25,   15,    9,   28,   38,   32,   28,   26,   14,   -9,  -21,
     -15,   -5,   10,   24,   22,   22,   21,   15,   15,   23,   36,   42,   35,   31,   41,   72,
      87,   68,   46,   42,   34,   19,   14,   25,   25,   11,   14,   18,   14,   -7,  -24,   -7,
      12,    4,  -19,  -41,  -47,  -44,  -41,  -52,  -74,  -92,  -88,  -72,  -59,  -63,  -68,  -53,
     -34,  -11,   12,   19,   -7,  -27,  -15,   -5,  -22,  -54,  -76,  -66,  -52,  -47,  -41,  -29,
     -17,  -12,  -12,  -10,  -11,  -19,   -7,   12,   19,    3,  -23,  -42,  -48,  -31,  -19,  -14,
      -6,    1,   20,   35,   39,   50,   51,   33,   16,   17,   30,   31,   32,   41,   39,   28,
      14,   -7,  -14,   -5,    8,   18,   27,   34,   29,   22,   21,   26,   38,   51,   39,   27,
      43,   75,   84,   73,   75,   68,   46,   32,   31,   35,   27,   15,   23,   36,   26,    0,
     -13,   -4,   12,   14,    1,  -23,  -36,  -36,  -32,  -36,  -60,  -83,  -84,  -70,  -67,  -70,
     -66,  -67,  -62,  -27,    8,   13,  -11,  -22,   -7,    4,  -16,  -44,  -63,  -67,  -63,  -63,
     -53,  -42,  -33,  -25,  -15,  -10,  -22,  -27,  -18,   -1,   16,    9,  -13,  -32,  -46,  -42,
     -31,  -30,  -24,   -8,    5,   11,   25,   49,   50,   33,   25,   20,   21,   24,   29,   34,
      41,   41,   26,    5,   -5,   -7,   -4,   12,   23,   33,   37,   29,   19,   24,   49,   53,
      33,   33,   49,   65,   73,   80,   89,   85,   63,   48,   50,   46,   30,   20,   35,   46,
      39,   17,    0,    2,   15,   23,   18,   -2,  -20,  -24,  -12,  -19,  -45,  -60,  -66,  -70,
     -66,  -56,  -61,  -74,  -74,  -38,    0,    6,   -8,  -15,    3,   13,   -1,  -24,  -42,  -52,
     -65,  -64,  -54,  -54,  -47,  -31,  -19,  -12,  -21,  -32,  -27,  -12,    7,   13,   -2,  -24,
     -36,  -37,  -44,  -47,  -32,  -20,  -18,   -9,   12,   30,   38,   35,   26,   18,   17,   16,
      13,   25,   36,   37,   32,   18,    2,  -11,  -10,   -5,    3,   28,   38,   20,    8,   25,
      42,   40,   28,   30,   40,   46,   54,   70,   87,   82,   66,   61,   59,   48,   28,   20,
      32,   43,   43,   24,    8,    1,    7,   23,   25,    3,  -13,   -9,   -8,  -15,  -28,  -40,
     -58,  -71,  -60,  -49,  -58,  -80,  -82,  -50,  -17,   -5,  -13,  -12,    6,   13,    8,   -3,
     -24,  -42,  -54,  -59,  -57,  -60,  -59,  -43,  -24,  -15,  -20,  -30,  -35,  -25,    1,   11,
      -2,  -12,  -18,  -33,  -48,  -49,  -41,  -37,  -32,  -21,   -8,   13,   27,   27,   27,   23,
      16,    8,    7,   15,   22,   32,   35,   22,    9,    0,  -18,  -26,   -8,   20,   25,   11,
       4,   18,   32,   29,   22,   29,   30,   27,   38,   60,   75,   70,   68,   69,   67,   52,
      30,   19,   27,   36,   40,   34,   10,   -2,    6,   21,   20,    4,   -2,   -4,   -7,   -9,
     -12,  -25,  -52,  -66,  -53,  -42,  -53,  -79,  -86,  -58,  -33,  -23,  -16,  -12,    0,   12,
      17,   13,   -5,  -24,  -38,  -44,  -50,  -59,  -61,  -51,  -33,  -15,  -11,  -28,  -36,  -23,
      -4,    5,    5,    7,   -3,  -17,  -31,  -40,  -38,  -37,  -36,  -29,  -14,    4,   15,   25,
      34,   30,   24,   19,    9,    8,   22,   33,   31,   30,   31,   16,  -14,  -26,  -13,   14,
      17,    7,    8,   18,   24,   23,   28,   31,   23,   18,   30,   50,   62,   61,   63,   75,
      73,   59,   40,   23,   20,   30,   43,   35,   11,    0,    8,   15,   12,    6,    3,   -6,
     -10,   -3,   -1,  -15,  -46,  -62,  -47,  -38,  -54,  -77,  -84,  -70,  -53,  -40,  -30,  -21,
     -12,    1,   16,   20,    5,  -12,  -21,  -33,  -44,  -52,  -64,  -64,  -44,  -17,  -15,  -27,
     -30,  -26,  -15,   -3,    6,   12,    9,   -2,  -17,  -26,  -29,  -36,  -41,  -32,  -21,  -10,
       6,   18,   27,   34,   37,   25,   11,   14,   21,   26,   27,   37,   48,   33,   -1,  -19,
      -8,    7,    8,    8,   16,   16,   17,   25,   34,   36,   23,   16,   28,   44,   53,   54,
      61,   74,   79,   75,   56,   30,   19,   31,   45,   35,   15,    9,    9,    9,   11,    9,
       5,   -8,  -14,    0,    9,  -10,  -40,  -53,  -44,  -38,  -51,  -72,  -84,  -80,  -69,  -58,
     -45,  -38,  -30,  -13,    5,   13,    8,    0,  -14,  -25,  -30,  -46,  -67,  -72,  -55,  -34,
     -26,  -28,  -31,  -31,  -26,  -17,   -4,    9,   11,    2,   -4,  -12,  -22,  -33,  -38,  -40,
     -34,  -18,   -7,    2,   17,   33,   38,   29,   19,   20,   22,   17,   19,   38,   57,   43,
      15,    2,   -1,    1,    3,   10,   18,   15,   14,   25,   38,   40,   27,   21,   28,   38,
      46,   50,   55,   66,   81,   90,   71,   40,   30,   37,   44,   39,   26,   18,   12,    8,
      14,   19,    8,  -11,  -13,    5,   15,   -2,  -28,  -42,  -36,  -34,  -45,  -60,  -76,  -83,
     -77,  -65,  -59,  -55,  -43,  -28,  -13,    5,   11,    2,   -9,  -11,  -17,  -37,  -61,  -71,
     -65,  -49,  -38,  -36,  -34,  -35,  -36,  -32,  -16,   -2,    1,    3,    0,   -7,  -13,  -25,
     -39,  -46,  -42,  -30,  -22,  -15,    2,   21,   30,   24,   22,   28,   19,    5,   11,   33,
      50,   45,   31,   17,    6,   -1,    0,    8,   16,   12,   11,   23,   37,   40,   33,   29,
      29,   33,   45,   48,   46,   58,   83,   97,   84,   59,   45,   46,   47,   46,   42,   31,
      16,   12,   23,   29,   16,   -5,   -9,   10,   21,   10,  -12,  -24,  -25,  -25,  -29,  -42,
     -64,  -73,  -70,  -66,  -63,  -58,  -52,  -42,  -22,    0,    8,    4,    1,    3,   -1,  -19,
     -44,  -61,  -63,  -57,  -50,  -39,  -33,  -37,  -39,  -36,  -27,  -14,   -4,    0,    0,    0,
      -1,  -13,  -30,  -42,  -43,  -37,  -36,  -30,  -10,    8,   12,   15,   26,   31,   16,    1,
       4,   21,   37,   41,   38,   29,   13,    0,   -1,    6,    8,    3,    7,   17,   26,   34,
      35,   27,   24,   32,   40,   37,   32,   45,   72,   89,   86,   70,   57,   48,   45,   49,
      50,   37,   16,   11,   25,   34,   20,   -3,   -7,    7,   18,   15,    2,  -14,  -20,  -15,
     -17,  -32,  -49,  -61,  -67,  -65,  -60,  -61,  -63,  -54,  -33,  -12,   -1,    1,    2,   10,
      12,   -3,  -26,  -43,  -57,  -60,  -54,  -45,  -38,  -38,  -39,  -39,  -35,  -23,  -13,   -6,
      -3,    2,    7,   -2,  -20,  -30,  -34,  -42,  -47,  -38,  -19,   -9,   -5,    7,   24,   31,
      19,    3,    0,   10,   23,   33,   40,   36,   18,    5,    4,    4,    0,    0,    0,    5,
      16,   29,   30,   22,   22,   31,   36,   27,   21,   32,   54,   74,   81,   77,   65,   49,
      44,   50,   55,   40,   16,   10,   24,   31,   20,    3,   -6,   -1,   11,   16,    5,   -9,
     -13,  -12,  -14,  -22,  -36,  -53,  -63,  -62,  -59,  -63,  -69,  -67,  -48,  -25,  -14,  -10,
      -1,   10,   16,   10,   -6,  -26,  -45,  -54,  -55,  -50,  -42,  -39,  -39,  -40,  -39,  -29,
     -19,  -15,   -8,    4,   11,    3,   -6,  -11,  -21,  -38,  -48,  -40,  -26,  -21,  -16,   -3,
      18,   30,   24,   12,    6,    4,   11,   29,   41,   39,   28,   18,   11,    8,    5,    1,
      -4,   -2,   11,   25,   25,   19,   23,   33,   35,   25,   17,   23,   39,   57,   74,   81,
      72,   53,   47,   56,   60,   44,   23,   16,   22,   29,   25,   10,   -4,   -3,    7,   11,
       6,   -3,   -9,  -11,   -9,  -12,  -26,  -42,  -56,  -59,  -55,  -61,  -73,  -75,  -60,  -42,
     -32,  -23,  -12,    0,   12,   15,    7,  -10,  -30,  -46,  -53,  -53,  -46,  -41,  -43,  -45,
     -41,  -32,  -30,  -26,  -14,   -1,    5,    2,    3,    3,   -9,  -30,  -43,  -40,  -31,  -31,
     -28,  -12,    8,   20,   25,   22,    9,    0,    6,   21,   34,   39,   35,   26,   18,   16,
      14,    4,   -7,   -5,    9,   21,   19,   16,   23,   35,   37,   28,   20,   20,   26,   43,
      67,   82,   74,   57,   54,   62,   63,   52,   33,   21,   23,   30,   28,   14,    1,   -1,
       3,    8,    7,   -1,   -7,   -9,   -6,   -5,  -15,  -34,  -49,  -51,  -51,  -60,  -72,  -76,
     -70,  -57,  -46,  -37,  -25,  -13,    3,   14,   14,    3,  -15,  -33,  -48,  -52,  -47,  -45,
     -49,  -49,  -41,  -37,  -39,  -35,  -21,  -10,   -5,   -2,    6,   12,    1,  -19,  -32,  -34,
     -36,  -39,  -34,  -23,   -9,    9,   23,   25,   14,    3,    2,   12,   25,   36,   37,   30,
      24,   25,   24,   10,   -5,   -4,    9,   18,   15,   14,   23,   34,   38,   36,   30,   19,
      15,   32,   61,   78,   75,   63,   60,   67,   71,   62,   42,   29,   30,   33,   32,   20,
       8,    4,    6,    8,    8,    3,   -5,   -9,   -2,    3,   -7,  -25,  -37,  -42,  -45,  -54,
     -66,  -74,  -74,  -67,  -58,  -49,  -40,  -27,   -9,    5,   13,   13,    0,  -21,  -39,  -45,
     -44,  -49,  -54,  -50,  -44,  -44,  -47,  -42,  -29,  -21,  -19,  -11,    5,   12,    4,   -8,
     -18,  -28,  -36,  -40,  -40,  -36,  -24,   -4,   14,   21,   17,    7,    0,    3,   17,   32,
      34,   29,   28,   34,   33,   17,    0,    0,    9,   13,   12,   14,   20,   27,   38,   46,
      39,   21,   11,   24,   51,   71,   74,   66,   64,   73,   78,   71,   54,   40,   38,   41,
      38,   28,   17,   11,    9,   12,   14,    7,   -3,   -5,    3,    9,    2,  -12,  -23,  -28,
     -35,  -45,  -55,  -65,  -71,  -68,  -62,  -57,  -50,  -37,  -22,   -7,   10,   20,   12,   -8,
     -24,  -32,  -39,  -48,  -52,  -49,  -45,  -49,  -52,  -44,  -34,  -33,  -30,  -18,   -3,    5,
       5,    1,   -8,  -19,  -29,  -37,  -43,  -45,  -37,  -18,    0,   13,   18,   10,   -1,   -3,
      10,   24,   26,   23,   29,   38,   37,   21,    8,    5,    6,    8,   10,   12,   11,   16,
      34,   49,   46,   27,   10,   15,   38,   59,   67,   63,   63,   72,   81,   77,   61,   48,
      45,   45,   42,   35,   23,   13,   11,   17,   18,    9,   -3,   -5,    3,   10,    6,   -3,
     -12,  -19,  -24,  -34,  -46,  -57,  -64,  -65,  -66,  -63,  -56,  -48,  -39,  -22,    1,   17,
      16,    3,   -8,  -17,  -30,  -44,  -47,  -44,  -47,  -53,  -52,  -44,  -41,  -41,  -38,  -28,
     -14,   -3,    3,    3,   -2,   -9,  -17,  -28,  -42,  -49,  -46,  -34,  -17,    3,   14,    9,
      -3,   -6,    5,   15,   13,   15,   26,   36,   35,   25,   16,    8,    2,    4,    9,    6,
       1,    4,   22,   43,   48,   31,   11,    7,   24,   45,   55,   54,   55,   68,   79,   77,
      66,   54,   48,   47,   47,   41,   27,   14,   11,   18,   20,   10,   -2,   -6,    0,    7,
       8,    2,   -6,  -12,  -14,  -23,  -38,  -49,  -55,  -62,  -66,  -63,  -60,  -59,  -53,  -37,
     -12,    8,   13,   10,    7,   -4,  -21,  -35,  -37,  -39,  -47,  -53,  -51,  -45,  -44,  -44,
     -42,  -36,  -24,  -10,    0,    2,    1,    1,   -3,  -15,  -30,  -42,  -49,  -45,  -30,   -6,
      10,    7,   -2,   -3,    5,    9,    6,   11,   23,   32,   35,   33,   25,   14,    6,    9,
      12,    8,   -2,   -4,   13,   36,   48,   39,   18,    7,   17,   34,   43,   45,   50,   62,
      74,   78,   71,   59,   51,   49,   52,   48,   32,   16,   12,   19,   21,   13,    1,   -6,
      -5,    2,    6,    2,   -4,   -6,   -9,  -18,  -29,  -40,  -51,  -60,  -65,  -63,  -63,  -68,
     -68,  -53,  -30,  -12,    0,   10,   13,    3,  -14,  -25,  -29,  -35,  -45,  -52,  -52,  -49,
     -47,  -47,  -47,  -46,  -35,  -20,  -10,   -5,   -1,    4,    4,   -4,  -15,  -30,  -47,  -54,
     -41,  -15,    1,    0,   -2,    2,    6,    4,    3,    7,   16,   26,   35,   38,   32,   20,
      12,   14,   18,   12,   -1,   -8,    3,   27,   46,   44,   26,   14,   17,   28,   35,   38,
      44,   55,   69,   78,   77,   66,   55,   54,   60,   58,   41,   24,   17,   19,   23,   20,
       7,   -4,   -4,    0,    2,    1,    0,   -2,   -4,  -10,  -17,  -28,  -42,  -55,  -59,  -56,
     -61,  -72,  -74,  -63,  -47,  -32,  -14,    5,   13,    7,   -4,  -12,  -19,  -28,  -38,  -46,
     -51,  -50,  -46,  -47,  -51,  -52,  -43,  -30,  -20,  -13,   -5,    0,    4,    4,    2,  -13,
     -40,  -55,  -47,  -25,  -12,   -8,   -3,    3,    5,    4,    2,    3,    7,   18,   32,   41,
      36,   25,   18,   21,   25,   21,    5,   -9,   -3,   19,   41,   45,   34,   24,   23,   27,
      30,   33,   38,   47,   62,   78,   82,   72,   61,   61,   67,   66,   54,   37,   24,   23,
      28,   25,   15,    5,    0,    0,    0,    1,    2,    2,   -1,   -4,   -5,  -15,  -34,  -47,
     -49,  -49,  -58,  -69,  -73,  -70,  -63,  -51,  -30,   -8,    5,    7,    3,   -4,  -11,  -20,
     -29,  -41,  -49,  -50,  -46,  -49,  -54,  -56,  -50,  -42,  -33,  -22,  -13,  -10,   -6,    5,
      12,   -1,  -30,  -50,  -50,  -38,  -27,  -18,  -10,   -3,    1,    2,    2,   -2,   -4,    6,
      24,   36,   36,   27,   19,   22,   30,   28,   10,   -8,  -10,    9,   30,   39,   35,   30,
      26,   26,   28,   29,   29,   35,   53,   73,   80,   74,   65,   63,   69,   72,   64,   47,
      33,   28,   29,   28,   21,   12,    6,    2,   -2,    1,    4,    1,   -2,    2,    6,   -4,
     -23,  -35,  -38,  -42,  -51,  -60,  -66,  -70,  -71,  -63,  -45,  -23,   -5,    4,    6,    3,
      -2,   -7,  -18,  -32,  -42,  -43,  -43,  -47,  -52,  -54,  -53,  -51,  -42,  -27,  -20,  -21,
     -14,    4,   17,   10,  -13,  -35,  -45,  -44,  -37,  -26,  -17,  -11,   -3,    3,    3,   -3,
      -9,   -4,   13,   31,   35,   27,   19,   23,   34,   36,   19,   -3,  -10,    2,   19,   31,
      35,   33,   29,   30,   32,   28,   22,   26,   43,   63,   76,   75,   67,   65,   71,   75,
      70,   57,   43,   36,   34,   30,   26,   21,   14,    5,    1,    4,    3,   -2,   -2,    6,
      11,    3,  -11,  -22,  -29,  -36,  -43,  -50,  -57,  -67,  -74,  -72,  -60,  -40,  -19,   -5,
       2,    4,    6,    3,   -8,  -23,  -32,  -35,  -40,  -45,  -47,  -51,  -57,  -58,  -47,  -33,
     -30,  -32,  -24,   -5,   13,   14,    1,  -18,  -36,  -45,  -42,  -35,  -27,  -20,  -11,    0,
       3,   -3,  -12,  -12,    1,   21,   31,   25,   16,   20,   34,   40,   26,    5,   -7,   -6,
       7,   21,   27,   26,   27,   31,   33,   27,   17,   15,   28,   50,   65,   68,   64,   62,
      68,   74,   72,   61,   51,   44,   35,   29,   28,   25,   15,    7,    5,    5,   -1,   -8,
      -5,    3,    8,    4,   -4,  -12,  -22,  -32,  -38,  -42,  -50,  -61,  -72,  -77,  -73,  -57,
     -36,  -20,  -11,   -2,    7,    8,   -3,  -14,  -22,  -30,  -38,  -41,  -42,  -49,  -60,  -62,
     -52,  -41,  -40,  -41,  -34,  -18,    0,   11,   10,   -3,  -23,  -38,  -42,  -40,  -36,  -31,
     -20,   -6,    2,   -1,  -13,  -19,   -9,   12,   25,   20,   12,   17,   30,   39,   34,   17,
      -2,   -8,    1,   13,   19,   21,   23,   31,   37,   32,   18,   10,   18,   36,   55,   62,
      60,   60,   67,   73,   72,   68,   61,   51,   41,   35,   34,   28,   18,   12,   11,    8,
      -2,   -9,   -7,    0,    4,    5,    3,   -3,  -14,  -24,  -31,  -36,  -41,  -50,  -64,  -77,
     -80,  -68,  -51,  -37,  -26,  -11,    3,    6,    2,   -3,  -13,  -24,  -32,  -33,  -34,  -46,
     -60,  -62,  -54,  -47,  -46,  -47,  -43,  -31,  -13,    4,   12,    6,   -9,  -23,  -34,  -39,
     -40,  -38,  -29,  -14,    0,    2,  -11,  -22,  -15,    4,   17,   16,   11,   13,   25,   39,
      41,   28,    9,   -3,    0,    9,   15,   15,   19,   30,   40,   39,   26,   12,   11,   28,
      45,   54,   56,   60,   66,   70,   73,   74,   69,   58,   49,   45,   42,   32,   22,   18,
      19,   14,    3,   -6,   -7,   -4,    0,    5,    6,    3,   -5,  -14,  -24,  -30,  -32,  -38,
     -53,  -71,  -78,  -72,  -63,  -54,  -39,  -22,   -8,    1,    6,    6,   -4,  -18,  -25,  -23,
     -25,  -39,  -54,  -58,  -54,  -49,  -49,  -50,  -49,  -42,  -26,   -7,    7,    9,    2,   -9,
     -20,  -30,  -38,  -43,  -39,  -22,   -2,    3,   -9,  -20,  -16,   -2,   11,   14,   10,   10,
      20,   36,   46,   40,   22,    8,    6,   11,   13,   12,   15,   26,   41,   46,   36,   20,
      14,   24,   38,   47,   54,   60,   64,   69,   76,   81,   76,   66,   60,   58,   53,   40,
      30,   27,   27,   22,   12,    3,   -3,   -4,   -1,    4,    8,    8,    5,   -4,  -15,  -21,
     -21,  -25,  -41,  -58,  -69,  -71,  -70,  -64,  -51,  -35,  -23,   -9,    5,   10,    1,  -13,
     -17,  -15,  -19,  -32,  -46,  -54,  -54,  -51,  -50,  -52,  -55,  -53,  -40,  -22,   -6,    3,
       4,   -2,  -10,  -19,  -32,  -47,  -49,  -32,  -11,   -3,  -10,  -20,  -20,  -10,    2,    7,
       5,    2,   10,   28,   42,   41,   29,   16,   10,   11,   11,    7,    6,   17,   35,   45,
      39,   26,   18,   19,   26,   37,   47,   53,   56,   61,   73,   81,   76,   68,   65,   65,
      59,   46,   36,   31,   28,   25,   19,    9,   -1,   -6,   -4,   -1,    2,    8,    9,    0,
     -10,  -15,  -14,  -18,  -32,  -46,  -57,  -68,  -74,  -71,  -61,  -51,  -41,  -23,   -2,    8,
       2,   -8,  -11,  -10,  -13,  -23,  -37,  -48,  -53,  -51,  -49,  -53,  -59,  -60,  -53,  -37,
     -19,   -7,   -3,   -2,   -1,   -6,  -22,  -43,  -52,  -42,  -21,   -9,  -12,  -20,  -23,  -16,
      -4,    3,   -1,   -6,    0,   18,   34,   40,   33,   22,   16,   16,   13,    5,    0,    9,
      27,   39,   40,   32,   24,   18,   19,   29,   40,   44,   46,   55,   69,   77,   75,   71,
      70,   70,   65,   55,   45,   37,   32,   30,   26,   17,    7,    0,   -5,   -6,   -1,    8,
      11,    4,   -5,   -7,   -7,  -13,  -21,  -30,  -44,  -59,  -69,  -69,  -65,  -63,  -56,  -36,
     -13,    1,    1,   -4,   -6,   -5,   -6,  -12,  -25,  -40,  -47,  -47,  -46,  -50,  -56,  -62,
     -61,  -48,  -30,  -18,  -12,   -6,    4,    6,   -7,  -32,  -49,  -46,  -30,  -16,  -12,  -19,
     -25,  -20,   -7,    0,   -3,   -9,   -7,    8,   26,   36,   34,   27,   24,   24,   19,    7,
      -2,    4,   18,   31,   38,   38,   30,   20,   18,   26,   34,   35,   38,   48,   62,   71,
      73,   72,   73,   72,   70,   64,   53,   43,   38,   35,   30,   23,   16,    7,   -4,  -10,
      -4,    6,    8,    3,   -1,   -2,   -4,   -9,  -12,  -19,  -33,  -51,  -61,  -65,  -69,  -73,
     -70,  -52,  -30,  -13,   -6,   -5,   -7,   -5,   -2,   -5,  -17,  -31,  -41,  -45,  -44,  -45,
     -53,  -64,  -67,  -58,  -43,  -31,  -26,  -17,   -1,   10,    3,  -19,  -41,  -48,  -39,  -23,
     -16,  -21,  -27,  -24,  -12,   -3,   -5,  -13,  -15,   -3,   16,   28,   29,   26,   28,   31,
      24,   10,    0,    0,    8,   20,   33,   38,   32,   22,   19,   24,   28,   28,   30,   40,
      52,   61,   68,   71,   72,   73,   73,   69,   59,   51,   45,   39,   32,   28,   26,   15,
       0,   -9,   -5,    2,    4,    2,    1,   -1,   -4,   -6,   -5,  -10,  -24,  -41,  -50,  -56,
     -66,  -76,  -77,  -66,  -47,  -27,  -15,  -11,  -10,   -5,    0,   -1,   -8,  -20,  -33,  -40,
     -40,  -40,  -48,  -62,  -70,  -64,  -51,  -43,  -39,  -29,  -11,    7,   10,   -5,  -28,  -43,
     -41,  -28,  -20,  -22,  -29,  -28,  -17,   -6,   -5,  -14,  -20,  -12,    6,   19,   22,   23,
      30,   35,   31,   20,    8,    0,    1,   13,   29,   37,   33,   26,   25,   27,   27,   25,
      26,   33,   43,   54,   63,   67,   70,   74,   76,   72,   66,   61,   54,   44,   37,   36,
      34,   24,    8,   -3,   -4,   -2,    0,    2,    3,   -1,   -5,   -3,    2,   -2,  -16,  -29,
     -36,  -44,  -57,  -70,  -79,  -76,  -60,  -41,  -27,  -19,  -14,   -8,   -1,    3,    0,  -10,
     -24,  -33,  -33,  -32,  -40,  -55,  -65,  -63,  -56,  -51,  -48,  -40,  -23,   -1,   12,    7,
     -13,  -32,  -37,  -29,  -21,  -21,  -28,  -29,  -19,   -6,   -2,  -12,  -20,  -14,    0,   11,
      16,   22,   30,   37,   38,   33,   21,    7,    0,    9,   26,   36,   35,   32,   32,   32,
      31,   28,   27,   30,   38,   50,   58,   63,   70,   78,   79,   76,   74,   72,   64,   53,
      46,   45,   44,   34,   20,    9,    3,   -1,    1,    7,    7,    0,   -4,    2,    8,    5,
      -5,  -15,  -23,  -30,  -41,  -58,  -73,  -77,  -68,  -53,  -38,  -28,  -21,  -14,   -5,    4,
       7,   -1,  -15,  -25,  -25,  -24,  -32,  -48,  -59,  -61,  -59,  -57,  -57,  -54,  -39,  -16,
       4,    8,   -5,  -24,  -33,  -30,  -24,  -24,  -32,  -35,  -26,  -11,   -6,  -14,  -20,  -19,
     -10,   -2,    5,   13,   21,   29,   37,   40,   30,   11,    0,    4,   17,   27,   30,   31,
      31,   32,   32,   29,   23,   23,   31,   40,   45,   52,   63,   72,   74,   73,   75,   75,
      67,   56,   51,   50,   46,   38,   29,   18,    6,   -3,   -1,    5,    3,   -4,   -7,   -2,
       4,    5,   -2,  -11,  -17,  -21,  -30,  -47,  -66,  -78,  -77,  -66,  -53,  -42,  -34,  -27,
     -16,   -3,    6,    1,  -12,  -21,  -21,  -21,  -28,  -42,  -54,  -60,  -60,  -61,  -65,  -67,
     -57,  -35,  -11,    1,   -3,  -18,  -30,  -30,  -25,  -27,  -36,  -41,  -32,  -19,  -13,  -17,
     -22,  -22,  -19,  -14,   -6,    2,    7,   17,   31,   41,   34,   17,    3,    1,    8,   17,
      23,   25,   26,   30,   32,   28,   22,   21,   25,   30,   34,   42,   54,   63,   66,   70,
      77,   77,   69,   61,   57,   55,   49,   44,   39,   28,   11,    2,    2,    5,    3,   -3,
      -8,   -4,    3,    6,    2,   -4,   -9,  -11,  -16,  -31,  -52,  -68,  -75,  -71,  -61,  -50,
     -43,  -38,  -26,   -8,    5,    4,   -6,  -13,  -14,  -13,  -19,  -31,  -44,  -51,  -52,  -55,
     -64,  -71,  -67,  -49,  -24,   -4,   -1,  -12,  -22,  -21,  -18,  -22,  -33,  -39,  -33,  -22,
     -16,  -16,  -17,  -19,  -20,  -16,   -9,   -4,   -2,    5,   18,   31,   37,   32,   21,   11,
       9,   12,   17,   20,   24,   28,   32,   31,   28,   26,   26,   26,   28,   34,   43,   51,
      57,   65,   74,   77,   75,   72,   68,   63,   59,   56,   53,   44,   31,   19,   12,   11,
       8,    3,   -2,   -3,    0,    4,    5,    2,    0,   -1,   -3,  -11,  -25,  -42,  -58,  -66,
     -65,  -59,  -54,  -51,  -42,  -27,  -11,   -2,   -3,   -6,   -7,   -7,   -9,  -16,  -27,  -36,
     -40,  -44,  -52,  -63,  -70,  -66,  -49,  -28,  -15,  -13,  -16,  -16,  -13,  -16,  -24,  -31,
     -33,  -29,  -24,  -19,  -17,  -19,  -20,  -18,  -14,  -13,  -12,   -6,    7,   22,   33,   35,
      28,   18,   12,   12,   14,   17,   21,   27,   31,   31,   30,   30,   28,   25,   25,   30,
      36,   42,   49,   58,   67,   74,   76,   75,   71,   66,   62,   60,   59,   53,   41,   29,
      19,   14,   11,    7,    1,   -3,   -2,    1,    3,    3,    1,    0,    0,   -3,  -11,  -26,
     -44,  -59,  -65,  -63,  -60,  -57,  -52,  -41,  -25,  -11,   -4,   -4,   -6,   -6,   -6,   -9,
     -17,  -27,  -35,  -39,  -44,  -53,  -65,  -71,  -65,  -47,  -28,  -16,  -15,  -16,  -15,  -14,
     -17,  -25,  -32,  -33,  -29,  -24,  -19,  -17,  -19,  -20,  -18,  -14,  -13,  -12,   -6,   -2,
       1,    6,    5,   21,   46,   42,   15,    0,    5,   34,   48,   29,   -4,  -31,  -33,  -17,
      26,   49,   32,    0,  -21,  -15,   14,   24,   24,   16,    0,    3,   11,   11,   11,    5,
       9,    9,    8,   11,   30,   27,   22,    7,   -3,   -3,   10,    2,   -2,   -4,  -13,   -4,
      -4,   -2,   -2,   -3,   -7,   -6,  -14,  -15,  -14,  -14,  -13,   -3,  -14,  -16,  -18,  -13,
     -15,  -16,  -22,  -20,  -14,   -3,   -6,   -4,  -14,  -11,   -6,  -10,  -15,  -15,  -16,   -9,
     -10,  -19,   -3,   -5,  -17,  -15,  -18,  -16,  -14,  -14,  -12,  -15,   -7,  -22,  -19,  -17,
     -20,  -11,  -17,  -14,  -11,   -8,  -10,  -13,  -12,  -11,   -6,   -6,   -9,    1,    1,   -3,
       0,    6,   -2,   -9,    7,   -8,    8,    4,    3,    1,   -6,   -2,   -2,    2,   -5,   -7,
      -4,   -7,   -8,   -9,   -6,   -6,    0,   -8,  -12,  -12,  -13,   -8,   -4,   -7,   -3,  -11,
      -6,  -15,   -7,   -9,   -9,   -3,  -10,   -8,   -9,  -15,  -10,   -2,    2,   -7,  -16,  -17,
     -15,  -13,   -9,   -6,   -5,   -7,   -9,  -15,  -17,  -12,  -19,  -12,   -8,   -8,   -4,   -6,
      -3,    0,   -4,  -11,  -13,   -7,   -6,   -2,    4,    4,    8,   10,    4,    3,    3,    4,
       7,   12,   11,   14,   15,   20,   20,   18,   16,   17,   15,   14,   15,   22,   23,   28,
      34,   29,   28,   17,   22,   24,   23,   25,   28,   28,   30,   24,   19,   16,   13,   18,
      20,   15,    8,    2,    3,    0,    2,    0,   -3,   -2,   -9,  -20,  -23,  -25,  -24,  -23,
     -27,  -33,  -38,  -39,  -44,  -36,  -42,  -44,  -48,  -53,  -54,  -56,  -52,  -50,  -40,  -35,
     -44,  -43,  -44,  -39,  -28,  -24,  -23,  -22,  -15,   -9,    2,   11,   19,   28,   31,   31,
      32,   35,   43,   61,   70,   78,   81,   73,   78,   78,   78,   85,   82,   85,   88,   87,
      84,   83,   83,   79,   74,   62,   49,   45,   42,   43,   44,   38,   30,   18,    6,   -5,
     -15,  -17,  -15,  -22,  -28,  -38,  -46,  -48,  -50,  -58,  -59,  -72,  -80,  -83,  -89,  -88,
     -89,  -87,  -81,  -84,  -93, -105, -110, -109, -110, -102,  -96,  -82,  -65,  -62,  -60,  -60,
     -60,  -51,  -43,  -37,  -28,  -16,    1,   15,   28,   35,   41,   46,   53,   56,   60,   66,
      77,   91,  101,  102,  101,   99,  104,  103,   97,   91,   86,   90,   91,   86,   85,   79,
      75,   71,   59,   48,   39,   35,   33,   32,   28,   22,   15,   13,    7,    3,   -7,  -15,
     -16,  -18,  -19,  -23,  -28,  -29,  -33,  -37,  -47,  -52,  -56,  -63,  -61,  -70,  -67,  -70,
     -72,  -72,  -80,  -93,  -91,  -99, -103,  -96, -108, -105, -109, -112,  -94,  -81,  -73,  -67,
     -71,  -77,  -69,  -63,  -57,  -38,  -27,  -15,    0,    4,    6,   19,   26,   41,   53,   49,
      56,   58,   69,   84,   91,   95,  101,  103,   98,   93,   85,   87,  102,  102,  103,   95,
      81,   78,   78,   71,   66,   60,   51,   50,   44,   39,   34,   34,   32,   27,   15,    0,
      -6,   -8,   -3,   -3,  -11,  -10,  -18,  -21,  -26,  -35,  -39,  -38,  -44,  -48,  -53,  -63,
     -61,  -61,  -71,  -63,  -86,  -89,  -86, -107,  -99, -109, -108, -109, -108, -121, -128, -105,
    -102,  -83,  -67,  -88,  -82,  -76,  -78,  -62,  -47,  -41,  -19,   -6,    1,    7,   13,   33,
      44,   64,   61,   59,   68,   73,   93,   98,  107,  114,  109,  123,  107,  100,  105,  100,
     111,  117,  100,   93,   92,   86,   85,   80,   70,   59,   58,   47,   38,   41,   33,   40,
      38,   25,   16,    1,   -2,   -3,   -3,   -4,  -10,  -16,  -12,  -21,  -28,  -28,  -36,  -38,
     -39,  -52,  -61,  -61,  -67,  -63,  -65,  -76,  -77,  -86,  -95,  -95, -107, -109, -112, -112,
    -121, -121, -122, -105,  -79,  -80,  -71,  -80,  -84,  -73,  -70,  -56,  -43,  -28,  -10,    6,
      11,   17,   31,   43,   63,   69,   69,   65,   77,   88,  101,  113,  112,  127,  122,  122,
     115,  104,  112,  116,  122,  117,  106,   99,   97,   96,   94,   86,   75,   70,   61,   53,
      44,   41,   46,   47,   45,   28,   19,    9,    5,    9,    1,   -8,  -14,  -20,  -24,  -26,
     -28,  -29,  -36,  -39,  -42,  -45,  -41,  -42,  -45,  -46,  -49,  -47,  -50,  -55,  -53,  -61,
     -63,  -67,  -83,  -78,  -89,  -91,  -88, -100,  -93, -108, -110, -110, -115,  -90, -100,  -91,
     -80,  -91,  -73,  -62,  -60,  -41,  -33,  -36,  -25,  -16,   -9,    8,   18,   35,   40,   57,
      61,   66,   95,   94,  106,  114,  105,  117,  111,  117,  118,  115,  120,  111,  109,  111,
     104,  102,  106,   93,   88,   76,   66,   63,   52,   53,   31,   27,   25,    5,   12,    1,
      -5,    0,  -15,  -17,  -23,  -27,  -27,  -31,  -31,  -37,  -44,  -41,  -43,  -43,  -35,  -45,
     -43,  -41,  -50,  -49,  -51,  -57,  -58,  -62,  -72,  -76,  -79,  -81,  -82,  -86,  -92,  -94,
    -100, -109, -110, -102,  -99,  -96,  -83,  -96,  -83,  -67,  -73,  -45,  -41,  -42,  -27,  -27,
     -19,   -5,    7,   14,   30,   44,   46,   57,   75,   84,   98,  108,  102,  112,  114,  110,
     120,  115,  116,  117,  108,  112,  107,  104,  108,   99,   96,   90,   73,   69,   66,   57,
      48,   36,   26,   18,   13,    6,   -3,    3,   -8,  -14,  -15,  -26,  -25,  -26,  -33,  -33,
     -40,  -45,  -45,  -45,  -42,  -43,  -44,  -45,  -48,  -46,  -55,  -57,  -58,  -62,  -67,  -73,
     -78,  -80,  -81,  -82,  -89,  -93,  -99, -106, -108, -115, -100,  -95, -103,  -77,  -91,  -85,
     -59,  -63,  -48,  -32,  -36,  -33,  -18,  -14,   -6,   11,   21,   27,   47,   55,   56,   81,
      92,   96,  114,  106,  111,  116,  110,  121,  113,  115,  115,  105,  111,  106,  101,  103,
     100,   92,   84,   74,   66,   60,   58,   43,   29,   29,   13,    9,   10,   -6,   -2,   -6,
     -16,  -18,  -22,  -27,  -30,  -30,  -35,  -44,  -43,  -46,  -46,  -42,  -44,  -48,  -45,  -46,
     -50,  -54,  -51,  -61,  -63,  -61,  -85,  -76,  -80,  -94,  -75,  -98,  -97,  -93, -111, -103,
    -106,  -97,  -97,  -90,  -79,  -93,  -73,  -64,  -67,  -39,  -38,  -41,  -20,  -20,  -12,   11,
      10,   30,   40,   48,   62,   62,   85,   91,   99,  111,  101,  112,  111,  113,  120,  112,
     119,  111,  108,  114,  101,  102,  104,   89,   91,   79,   63,   67,   56,   52,   41,   29,
      26,   12,   14,    3,   -5,    1,  -14,  -15,  -19,  -27,  -24,  -30,  -31,  -34,  -43,  -43,
     -45,  -48,  -40,  -48,  -48,  -45,  -51,  -49,  -53,  -56,  -57,  -63,  -69,  -76,  -86,  -80,
     -86,  -90,  -87,  -98, -101, -101, -108, -103,  -88,  -96,  -88,  -77,  -89,  -70,  -60,  -56,
     -39,  -34,  -30,  -26,  -11,   -4,    6,   26,   27,   42,   54,   57,   72,   86,   95,  105,
     107,  108,  112,  109,  116,  118,  112,  117,  108,  109,  107,  104,  103,   99,   97,   83,
      77,   71,   57,   60,   49,   35,   30,   21,   11,   11,    4,   -2,   -3,  -13,  -17,  -22,
     -24,  -28,  -29,  -29,  -39,  -39,  -44,  -44,  -41,  -45,  -44,  -50,  -49,  -49,  -56,  -50,
     -60,  -62,  -55,  -82,  -70,  -82,  -90,  -80,  -95,  -95, -100, -105, -112, -112,  -93, -102,
     -91,  -81,  -91,  -77,  -60,  -65,  -45,  -33,  -40,  -25,  -21,  -14,    5,   10,   30,   35,
      49,   61,   61,   87,   94,  102,  109,  109,  112,  112,  116,  117,  116,  118,  116,  106,
     113,  108,  101,  110,   96,   91,   84,   69,   66,   58,   54,   38,   29,   26,   12,   11,
       6,   -2,   -2,   -8,  -16,  -20,  -23,  -27,  -28,  -33,  -34,  -44,  -43,  -43,  -47,  -39,
     -44,  -47,  -43,  -47,  -49,  -50,  -52,  -57,  -58,  -68,  -75,  -76,  -83,  -86,  -86,  -91,
     -97,  -98, -103, -109, -102,  -91,  -99,  -84,  -81,  -93,  -65,  -66,  -60,  -37,  -42,  -33,
     -25,  -18,   -9,    6,   16,   28,   41,   49,   57,   68,   84,   93,  102,  106,  106,  110,
     107,  116,  114,  111,  119,  106,  111,  108,  101,  104,   99,   94,   85,   76,   68,   61,
      56,   49,   34,   28,   21,   10,   10,    2,   -3,   -3,  -13,  -15,  -24,  -26,  -28,  -34,
     -31,  -42,  -45,  -43,  -48,  -44,  -43,  -47,  -47,  -47,  -48,  -51,  -57,  -57,  -63,  -70,
     -72,  -80,  -86,  -81,  -92,  -88,  -96, -103, -100, -113, -110,  -96, -101,  -96,  -79,  -91,
     -82,  -59,  -68,  -47,  -34,  -39,  -29,  -18,  -13,   -5,   18,   22,   32,   54,   52,   64,
      83,   90,  100,  108,  109,  110,  113,  113,  116,  113,  117,  113,  106,  111,  103,  100,
     101,   98,   86,   82,   73,   59,   61,   53,   36,   34,   24,   12,   10,    5,   -5,   -3,
      -8,  -17,  -18,  -24,  -27,  -29,  -30,  -35,  -40,  -41,  -45,  -43,  -43,  -42,  -45,  -46,
     -44,  -50,  -49,  -55,  -58,  -55,  -71,  -70,  -79,  -87,  -77,  -92,  -88,  -95, -104, -100,
    -115, -107,  -91, -105,  -85,  -83,  -97,  -67,  -68,  -65,  -37,  -43,  -33,  -29,  -21,   -9,
       0,   18,   23,   35,   55,   48,   69,   87,   86,  108,  107,  103,  117,  106,  117,  118,
     113,  122,  109,  111,  111,  102,  110,  101,   98,   92,   77,   73,   62,   59,   54,   34,
      34,   21,   11,   15,    2,    2,    2,  -14,  -12,  -23,  -26,  -26,  -33,  -30,  -40,  -44,
     -42,  -49,  -41,  -41,  -44,  -43,  -46,  -49,  -51,  -59,  -54,  -63,  -67,  -64,  -84,  -79,
     -76,  -91,  -82,  -87, -100, -100, -101, -118, -101,  -89, -107,  -81,  -82,  -93,  -65,  -57,
     -57,  -36,  -26,  -39,  -17,   -9,  -13,   14,   21,   26,   45,   53,   54,   76,   88,   95,
     111,  106,  111,  114,  109,  120,  115,  115,  116,  110,  105,  109,  104,   98,  105,   94,
      83,   81,   68,   60,   62,   49,   32,   33,   18,    9,   12,    0,   -3,   -3,  -13,  -18,
     -20,  -24,  -27,  -26,  -31,  -37,  -40,  -42,  -42,  -43,  -42,  -44,  -48,  -48,  -47,  -51,
     -54,  -52,  -56,  -64,  -68,  -75,  -84,  -79,  -89,  -91,  -93, -104, -105, -110, -114,  -97,
     -97,  -96,  -78,  -89,  -81,  -58,  -66,  -47,  -34,  -40,  -31,  -23,  -14,   -6,   14,   22,
      31,   54,   55,   63,   87,   91,  103,  113,  105,  111,  113,  109,  119,  112,  117,  114,
     106,  113,  106,  105,  105,   99,   93,   81,   74,   61,   58,   55,   36,   30,   25,   10,
      11,    6,   -5,    1,   -8,  -16,  -19,  -25,  -27,  -32,  -32,  -37,  -44,  -41,  -47,  -43,
     -39,  -43,  -44,  -45,  -46,  -46,  -56,  -53,  -55,  -72,  -64,  -74,  -91,  -72,  -88,  -97,
     -80, -100, -105, -100, -111, -111,  -88, -100,  -99,  -74,  -97,  -79,  -54,  -68,  -43,  -32,
     -41,  -26,  -10,  -16,    6,   22,   19,   41,   51,   49,   69,   86,   88,  103,  107,  100,
     119,  110,  111,  125,  110,  115,  115,  104,  108,  106,   99,   98,   98,   82,   76,   71,
      60,   60,   52,   34,   30,   25,    9,   11,    3,   -6,    0,  -15,  -18,  -21,  -27,  -27,
     -30,  -31,  -38,  -39,  -43,  -43,  -39,  -43,  -44,  -46,  -47,  -47,  -54,  -53,  -59,  -58,
     -65,  -71,  -75,  -81,  -75,  -90,  -83,  -90, -100,  -95, -111, -109, -101,  -97, -100,  -84,
     -86,  -89,  -62,  -64,  -50,  -34,  -37,  -30,  -21,  -11,   -8,   10,   19,   26,   47,   49,
      59,   76,   89,   99,  107,  109,  110,  115,  113,  119,  115,  114,  115,  106,  111,  103,
     103,  101,   98,   94,   81,   78,   65,   63,   59,   43,   34,   25,   17,   10,    7,   -4,
      -3,   -6,  -14,  -16,  -23,  -24,  -28,  -29,  -33,  -41,  -41,  -46,  -43,  -40,  -44,  -44,
     -46,  -46,  -47,  -50,  -54,  -56,  -58,  -69,  -70,  -76,  -83,  -75,  -87,  -87,  -91, -100,
    -100, -109, -108,  -97,  -98,  -93,  -83,  -88,  -76,  -61,  -59,  -43,  -36,  -33,  -28,  -18,
     -11,   -4,   14,   21,   31,   52,   51,   63,   84,   90,  101,  111,  104,  113,  113,  111,
     118,  112,  114,  109,  108,  109,  102,  106,  101,   98,   94,   79,   74,   66,   58,   55,
      39,   29,   24,   13,   11,    5,   -4,    0,  -10,  -15,  -17,  -24,  -25,  -28,  -29,  -34,
     -41,  -41,  -47,  -42,  -44,  -46,  -45,  -50,  -45,  -50,  -55,  -48,  -60,  -60,  -65,  -76,
     -77,  -83,  -84,  -91,  -92,  -94, -106, -103, -109, -106,  -89, -101,  -82,  -81,  -88,  -63,
     -66,  -54,  -36,  -40,  -31,  -25,  -16,   -7,    6,   17,   30,   41,   55,   56,   73,   89,
      92,  109,  104,  106,  114,  104,  117,  113,  110,  116,  105,  108,  106,  100,  102,   98,
      94,   85,   74,   67,   59,   55,   48,   31,   28,   19,   10,   12,    0,    2,   -2,  -11,
     -11,  -21,  -21,  -26,  -30,  -30,  -40,  -43,  -43,  -44,  -40,  -39,  -41,  -43,  -42,  -46,
     -52,  -52,  -58,  -63,  -65,  -75,  -79,  -83,  -80,  -89,  -85,  -88, -101,  -94, -104, -114,
     -93,  -97, -104,  -78,  -92,  -89,  -60,  -68,  -48,  -36,  -36,  -26,  -21,   -8,   -5,   12,
      23,   26,   47,   50,   54,   77,   85,   96,  109,  102,  114,  112,  109,  125,  112,  114,
     118,  102,  110,  103,   99,  101,   96,   92,   79,   76,   66,   59,   61,   43,   32,   31,
      14,   10,    9,   -5,   -2,   -9,  -17,  -18,  -28,  -25,  -31,  -31,  -31,  -42,  -38,  -43,
     -41,  -39,  -43,  -44,  -47,  -45,  -48,  -51,  -53,  -54,  -61,  -64,  -67,  -77,  -76,  -82,
     -81,  -89,  -93,  -97, -106, -108, -105,  -96,  -99,  -88,  -82,  -92,  -67,  -64,  -60,  -38,
     -38,  -36,  -24,  -20,  -16,    4,   11,   21,   36,   46,   53,   66,   85,   88,  103,  108,
     102,  115,  107,  112,  115,  109,  114,  104,  106,  106,   99,  102,  101,   92,   89,   81,
      67,   66,   58,   47,   39,   28,   21,   11,   12,    2,   -2,    2,  -12,  -12,  -17,  -25,
     -24,  -29,  -30,  -36,  -39,  -41,  -41,  -41,  -39,  -41,  -44,  -44,  -47,  -51,  -52,  -54,
     -59,  -63,  -65,  -75,  -79,  -75,  -90,  -81,  -89,  -99,  -92, -109, -109, -105,  -99,  -97,
     -92,  -80,  -90,  -71,  -58,  -60,  -37,  -32,  -37,  -19,  -15,  -14,    9,   14,   23,   42,
      46,   56,   67,   83,   96,  100,  111,  106,  111,  114,  111,  117,  111,  112,  109,  103,
     107,  100,   99,  103,   92,   88,   82,   65,   66,   59,   48,   39,   27,   22,   12,    9,
       5,   -5,    0,  -12,  -16,  -17,  -26,  -25,  -26,  -31,  -34,  -40,  -41,  -41,  -41,  -40,
     -42,  -47,  -43,  -46,  -46,  -52,  -50,  -52,  -61,  -59,  -74,  -75,  -77,  -83,  -84,  -91,
     -92, -105, -100, -106, -109,  -81, -103,  -86,  -73,  -96,  -64,  -62,  -59,  -38,  -39,  -36,
     -28,  -15,  -11,    3,   18,   25,   37,   53,   53,   67,   89,   85,  106,  103,   98,  115,
      99,  114,  115,  103,  116,  103,  104,  109,   98,  101,   98,   91,   84,   75,   67,   60,
      55,   50,   31,   28,   20,    7,   15,    0,   -3,    2,  -15,  -12,  -19,  -25,  -24,  -32,
     -32,  -38,  -44,  -44,  -45,  -42,  -41,  -44,  -43,  -46,  -44,  -44,  -58,  -48,  -63,  -67,
     -63,  -87,  -75,  -83,  -90,  -81,  -94,  -95,  -95, -107, -109,  -99,  -95,  -99,  -85,  -85,
     -90,  -68,  -62,  -60,  -36,  -34,  -39,  -15,  -13,   -9,   14,   15,   29,   42,   50,   55,
      68,   87,   91,  101,  107,  106,  110,  113,  114,  115,  114,  112,  108,  105,  106,   98,
      98,  100,   88,   84,   75,   63,   63,   57,   46,   34,   28,   18,   10,    8,    0,   -5,
      -5,  -15,  -19,  -20,  -26,  -26,  -26,  -31,  -36,  -40,  -42,  -43,  -42,  -39,  -44,  -44,
     -42,  -44,  -47,  -51,  -52,  -54,  -65,  -63,  -76,  -81,  -68,  -93,  -84,  -85, -104,  -92,
    -105, -109,  -95,  -95,  -96,  -84,  -82,  -84,  -64,  -64,  -52,  -39,  -37,  -33,  -23,  -11,
      -9,   10,   20,   25,   49,   46,   60,   76,   82,   98,  101,  104,  110,  108,  108,  116,
     111,  111,  113,  104,  108,  106,  101,   98,   99,   92,   80,   79,   63,   61,   59,   41,
      35,   27,   18,   13,    9,    2,    0,   -5,  -12,  -15,  -20,  -22,  -26,  -27,  -30,  -38,
     -39,  -42,  -40,  -39,  -40,  -40,  -45,  -43,  -47,  -49,  -54,  -53,  -57,  -70,  -59,  -80,
     -77,  -72,  -93,  -75,  -91,  -99,  -93, -105, -108,  -97,  -92,  -99,  -80,  -84,  -84,  -61,
     -59,  -49,  -35,  -28,  -34,  -14,   -9,  -10,   19,   17,   27,   47,   47,   61,   72,   87,
      95,  105,  104,  110,  111,  109,  117,  109,  111,  109,  103,  103,  102,   97,   95,  100,
      85,   81,   77,   61,   64,   55,   42,   34,   26,   17,   10,    9,   -3,   -2,   -5,  -13,
     -15,  -20,  -23,  -27,  -27,  -32,  -37,  -38,  -41,  -40,  -41,  -39,  -43,  -43,  -40,  -48,
     -47,  -49,  -55,  -61,  -59,  -70,  -80,  -69,  -87,  -83,  -79,  -97,  -89,  -98, -101, -107,
     -96,  -93, -101,  -77,  -90,  -84,  -62,  -63,  -49,  -36,  -34,  -30,  -15,  -12,   -2,   11,
      20,   32,   39,   53,   56,   71,   87,   89,  103,  101,  109,  109,  109,  118,  106,  114,
     111,  101,  107,  102,   93,   99,   94,   84,   85,   71,   65,   62,   54,   45,   32,   30,
      16,   12,    8,   -5,   -2,   -9,  -14,  -16,  -24,  -22,  -27,  -29,  -31,  -38,  -41,  -38,
     -44,  -42,  -41,  -47,  -45,  -44,  -48,  -50,  -50,  -52,  -62,  -57,  -69,  -79,  -69,  -83,
     -88,  -78,  -99,  -97,  -92, -109, -106,  -91, -100,  -93,  -76,  -91,  -80,  -60,  -66,  -48,
     -37,  -38,  -32,  -18,  -15,   -4,   11,   14,   31,   42,   48,   60,   69,   85,   94,   96,
     102,  107,  103,  109,  115,  104,  112,  109,  100,  106,  103,   95,   97,   96,   84,   82,
      73,   60,   62,   54,   41,   33,   27,   17,   14,    7,    0,    0,   -8,  -11,  -16,  -23,
     -23,  -29,  -29,  -32,  -39,  -40,  -40,  -40,  -41,  -40,  -46,  -48,  -45,  -50,  -51,  -54,
     -56,  -64,  -63,  -71,  -78,  -73,  -84,  -82,  -87,  -95,  -93, -102, -102, -108,  -95,  -96,
     -95,  -76,  -90,  -77,  -57,  -61,  -42,  -33,  -35,  -26,  -13,  -14,    3,   15,   17,   36,
      45,   54,   60,   80,   89,   96,  108,  101,  111,  110,  109,  118,  107,  110,  109,  102,
     103,  103,   95,   97,   96,   83,   82,   70,   60,   61,   51,   38,   28,   23,   11,    8,
       4,   -7,   -3,  -10,  -16,  -17,  -22,  -25,  -27,  -29,  -35,  -38,  -43,  -42,  -41,  -40,
     -39,  -43,  -42,  -44,  -45,  -46,  -53,  -51,  -55,  -68,  -65,  -75,  -79,  -77,  -88,  -83,
     -94,  -93, -101, -105,  -96,  -96,  -92,  -85,  -85,  -83,  -71,  -64,  -57,  -41,  -41,  -31,
     -27,  -17,   -7,    2,   18,   23,   38,   48,   51,   68,   78,   91,   98,  102,  106,  108,
     110,  112,  115,  110,  115,  107,  107,  108,   99,  102,   97,   94,   87,   76,   70,   63,
      60,   49,   39,   30,   22,   16,    8,    4,    0,   -4,  -10,  -14,  -20,  -24,  -25,  -31,
     -30,  -37,  -41,  -40,  -41,  -38,  -39,  -40,  -42,  -41,  -43,  -48,  -44,  -55,  -58,  -57,
     -71,  -71,  -73,  -78,  -79,  -80,  -88,  -89,  -95,  -99, -103, -101,  -88,  -98,  -85,  -79,
     -90,  -62,  -60,  -54,  -35,  -35,  -27,  -21,   -9,   -3,    7,   22,   26,   38,   52,   54,
      67,   87,   89,  101,  105,  103,  114,  107,  117,  112,  107,  116,  100,  105,  103,   94,
      98,   93,   87,   80,   73,   65,   59,   56,   45,   31,   28,   19,    6,   10,   -3,   -5,
      -4,  -17,  -16,  -22,  -24,  -25,  -30,  -28,  -39,  -37,  -40,  -44,  -40,  -44,  -46,  -46,
     -47,  -51,  -50,  -55,  -55,  -60,  -67,  -65,  -81,  -75,  -78,  -93,  -78,  -97, -101,  -94,
    -113, -104,  -92,  -96,  -91,  -79,  -86,  -79,  -58,  -58,  -49,  -34,  -34,  -33,  -14,  -12,
      -5,   20,   19,   34,   49,   49,   66,   76,   91,   98,   98,  105,  104,  107,  111,  110,
     109,  108,  108,  103,  101,  102,   97,   95,   96,   80,   75,   71,   56,   58,   49,   33,
      28,   20,   13,    7,    4,   -4,   -7,   -9,  -18,  -22,  -22,  -28,  -30,  -30,  -38,  -41,
     -41,  -43,  -40,  -41,  -40,  -44,  -43,  -45,  -48,  -49,  -55,  -55,  -59,  -67,  -66,  -82,
     -70,  -81,  -86,  -78, -101,  -92,  -98, -111,  -98,  -95,  -95,  -89,  -76,  -91,  -70,  -56,
     -61,  -38,  -34,  -33,  -25,  -12,  -10,    1,   21,   15,   39,   47,   48,   68,   75,   90,
      97,  101,  103,  106,  106,  110,  111,  104,  111,  101,   99,  103,   96,   94,   95,   92,
      75,   79,   64,   55,   64,   43,   36,   30,   17,   13,    9,    3,   -4,   -3,  -12,  -16,
     -18,  -23,  -25,  -26,  -29,  -35,  -38,  -42,  -40,  -39,  -41,  -38,  -48,  -42,  -45,  -50,
     -49,  -52,  -57,  -63,  -57,  -78,  -76,  -67,  -94,  -75,  -88, -100,  -92, -103, -106,  -97,
     -88,  -96,  -81,  -77,  -85,  -60,  -55,  -51,  -35,  -30,  -33,  -19,   -9,  -10,   17,   16,
      30,   46,   48,   64,   72,   86,   96,  101,  104,  105,  111,  104,  116,  109,  107,  110,
     104,  101,  104,  100,   93,  100,   86,   77,   78,   59,   60,   54,   40,   32,   23,   18,
       9,    9,    0,   -5,   -6,  -14,  -17,  -20,  -23,  -25,  -26,  -31,  -35,  -39,  -40,  -36,
     -40,  -37,  -40,  -45,  -42,  -45,  -48,  -51,  -50,  -57,  -64,  -62,  -76,  -78,  -71,  -90,
     -84,  -88, -101,  -97, -105, -108,  -94,  -97,  -92,  -81,  -87,  -76,  -63,  -58,  -42,  -36,
     -33,  -27,  -15,  -10,   -2,   18,   19,   34,   49,   47,   66,   78,   86,  102,  104,  104,
     111,  109,  112,  115,  112,  110,  108,  106,  101,  102,   98,   96,   97,   86,   79,   72,
      62,   61,   51,   39,   32,   20,   15,   10,    2,    1,   -4,   -9,  -13,  -18,  -22,  -24,
     -25,  -29,  -33,  -37,  -41,  -39,  -37,  -39,  -39,  -43,  -46,  -46,  -49,  -49,  -56,  -54,
     -57,  -68,  -66,  -73,  -77,  -79,  -83,  -90,  -96,  -95, -107, -110,  -98,  -97,  -98,  -76,
     -87,  -83,  -56,  -68,  -49,  -34,  -43,  -28,  -26,  -18,   -8,    3,   14,   22,   39,   47,
      54,   70,   83,   90,  101,  100,  104,  107,  102,  113,  103,  106,  109,   95,  106,   99,
      95,  101,   92,   93,   83,   74,   66,   60,   56,   44,   33,   26,   17,   12,    8,    1,
       2,   -4,  -11,  -10,  -21,  -19,  -25,  -29,  -28,  -39,  -38,  -41,  -41,  -37,  -40,  -42,
     -43,  -42,  -45,  -47,  -48,  -56,  -52,  -59,  -69,  -67,  -78,  -78,  -79,  -88,  -86,  -95,
    -100,  -99, -112,  -95,  -92, -101,  -77,  -86,  -86,  -62,  -65,  -51,  -39,  -35,  -31,  -26,
      -8,  -11,    7,   26,   21,   45,   53,   50,   76,   86,   90,  105,  102,  105,  109,  108,
     115,  107,  112,  110,  100,  108,  100,   96,  100,   93,   89,   79,   72,   64,   58,   56,
      42,   31,   28,   14,   10,    9,   -5,   -2,   -6,  -14,  -15,  -22,  -22,  -27,  -28,  -31,
     -41,  -37,  -41,  -42,  -37,  -41,  -45,  -43,  -45,  -47,  -48,  -49,  -58,  -53,  -64,  -71,
     -68,  -82,  -75,  -83,  -91,  -87, -103,  -97, -104, -111,  -90,  -98,  -95,  -77,  -91,  -76,
     -61,  -63,  -43,  -41,  -35,  -29,  -23,   -7,   -7,   13,   22,   24,   50,   50,   59,   82,
      82,   99,  102,  100,  110,  105,  111,  113,  104,  114,  103,  104,  107,   96,  102,   97,
      92,   90,   77,   73,   64,   58,   53,   38,   31,   23,   13,   12,    3,    0,   -2,  -11,
     -10,  -17,  -21,  -20,  -29,  -27,  -33,  -40,  -38,  -44,  -39,  -39,  -43,  -41,  -42,  -42,
     -46,  -42,  -53,  -53,  -52,  -71,  -67,  -73,  -83,  -80,  -81,  -89,  -93,  -91, -100, -106,
     -97,  -96,  -93,  -88,  -81,  -85,  -79,  -59,  -58,  -48,  -30,  -36,  -28,  -11,   -9,   -2,
      21,   22,   32,   50,   52,   58,   79,   89,   90,  104,  104,  100,  113,  111,  109,  114,
     109,  107,  103,  104,   99,   94,   97,   91,   78,   79,   65,   58,   61,   47,   37,   30,
      23,   14,   10,    7,   -7,   -4,   -8,  -21,  -17,  -23,  -30,  -26,  -30,  -36,  -37,  -39,
     -38,  -38,  -36,  -38,  -45,  -41,  -45,  -49,  -51,  -56,  -57,  -63,  -64,  -69,  -78,  -70,
     -80,  -84,  -84,  -91, -100,  -98, -106, -108,  -90, -103,  -90,  -80,  -93,  -65,  -64,  -52,
     -38,  -37,  -27,  -26,  -12,   -6,    3,   18,   22,   36,   48,   54,   69,   84,   89,  105,
     103,  106,  117,  105,  117,  113,  106,  113,  101,  105,  101,   99,   98,   93,   94,   83,
      75,   70,   60,   55,   49,   33,   27,   19,   10,    8,   -2,   -2,   -7,  -13,  -12,  -22,
     -20,  -23,  -28,  -28,  -35,  -39,  -40,  -41,  -40,  -42,  -40,  -43,  -42,  -42,  -44,  -46,
     -49,  -52,  -59,  -60,  -70,  -74,  -71,  -84,  -82,  -88,  -96,  -98, -100, -105, -102,  -88,
     -95,  -83,  -79,  -87,  -62,  -62,  -52,  -40,  -39,  -31,  -27,  -14,  -10,    7,   17,   25,
      42,   49,   59,   72,   85,   92,  103,  103,  102,  111,  104,  113,  110,  104,  112,  102,
     107,  103,  101,   99,   97,   92,   81,   76,   64,   61,   54,   42,   33,   24,   17,   11,
       8,   -2,   -2,   -5,  -13,  -12,  -22,  -23,  -26,  -31,  -32,  -38,  -40,  -43,  -39,  -40,
     -41,  -40,  -44,  -41,  -44,  -47,  -51,  -49,  -62,  -55,  -68,  -78,  -68,  -89,  -79,  -81,
     -96,  -85, -101, -100, -103,  -98,  -91,  -97,  -79,  -83,  -87,  -61,  -64,  -55,  -31,  -41,
     -29,  -15,  -19,    3,    9,   18,   33,   36,   56,   54,   71,   87,   87,  103,  103,  103,
     110,  107,  113,  112,  108,  111,  101,  104,  103,   92,  101,   92,   84,   84,   66,   65,
      59,   51,   45,   31,   27,   16,   10,    6,   -3,   -3,   -9,  -15,  -16,  -22,  -24,  -25,
     -30,  -28,  -36,  -40,  -36,  -42,  -38,  -41,  -45,  -44,  -47,  -47,  -49,  -51,  -52,  -54,
     -62,  -68,  -73,  -78,  -81,  -84,  -83,  -97,  -94, -101, -113, -100,  -99,  -96,  -87,  -83,
     -85,  -75,  -60,  -60,  -43,  -36,  -38,  -27,  -20,  -15,    0,   14,   19,   33,   47,   49,
      67,   78,   90,  100,  103,  105,  107,  108,  110,  112,  109,  109,  107,  102,  105,  100,
      99,   98,   95,   84,   80,   69,   59,   60,   48,   36,   31,   18,   14,    9,    3,   -2,
      -5,  -10,  -15,  -19,  -24,  -25,  -28,  -31,  -34,  -39,  -41,  -40,  -38,  -40,  -38,  -43,
     -43,  -42,  -48,  -47,  -53,  -54,  -58,  -67,  -63,  -79,  -73,  -78,  -90,  -80,  -98,  -97,
    -101, -109, -105,  -93,  -98,  -90,  -76,  -93,  -66,  -60,  -59,  -33,  -42,  -32,  -26,  -18,
      -9,    0,   17,   21,   38,   48,   53,   69,   82,   93,  101,  107,  102,  112,  108,  111,
     115,  105,  112,  103,  105,  104,   96,  103,   95,   95,   85,   76,   68,   63,   59,   47,
      38,   26,   19,   13,    7,    1,   -3,   -4,  -14,  -12,  -19,  -23,  -21,  -29,  -29,  -35,
     -40,  -41,  -42,  -39,  -43,  -42,  -46,  -43,  -47,  -45,  -48,  -54,  -47,  -66,  -61,  -68,
     -85,  -66,  -90,  -84,  -84, -103,  -91, -106, -105,  -96,  -90,  -92,  -81,  -79,  -86,  -59,
     -59,  -53,  -34,  -36,  -33,  -19,  -10,  -10,   17,   20,   26,   52,   48,   60,   75,   85,
      95,  102,  104,  102,  111,  107,  113,  110,  109,  111,  103,  107,  102,   97,   96,   95,
      85,   77,   73,   56,   60,   52,   37,   33,   22,   16,   11,    7,   -3,   -4,   -6,  -16,
     -14,  -21,  -24,  -24,  -28,  -32,  -37,  -38,  -42,  -36,  -37,  -39,  -39,  -43,  -40,  -42,
     -48,  -50,  -50,  -64,  -57,  -70,  -84,  -63,  -90,  -81,  -77, -101,  -85,  -99, -105, -102,
    -100,  -92,  -99,  -79,  -89,  -86,  -58,  -65,  -49,  -29,  -41,  -26,  -11,  -19,    6,   12,
      14,   39,   37,   52,   60,   68,   90,   90,  104,  102,  106,  111,  108,  118,  109,  109,
     111,   98,  106,  101,   90,  101,   90,   82,   86,   63,   65,   63,   48,   47,   29,   25,
      16,   10,    6,   -6,   -3,  -13,  -18,  -16,  -26,  -25,  -25,  -32,  -30,  -39,  -43,  -37,
     -43,  -39,  -39,  -48,  -44,  -46,  -53,  -50,  -56,  -59,  -59,  -67,  -72,  -77,  -76,  -84,
     -83,  -84, -100,  -95, -103, -115,  -98,  -93, -103,  -82,  -82,  -91,  -60,  -62,  -54,  -34,
     -35,  -31,  -23,  -13,  -11,    7,   19,   21,   43,   48,   55,   73,   85,   94,  104,  102,
     109,  110,  105,  118,  107,  109,  113,   98,  106,  103,   96,   99,   98,   90,   82,   79,
      62,   62,   58,   41,   34,   26,   14,   10,    8,   -3,   -2,   -5,  -14,  -13,  -20,  -20,
     -24,  -26,  -28,  -38,  -39,  -42,  -42,  -41,  -41,  -42,  -48,  -41,  -43,  -50,  -41,  -49,
     -59,  -50,  -68,  -74,  -67,  -82,  -80,  -89,  -87, -101, -101,  -93, -121,  -85,  -90, -105,
     -65,  -93,  -82,  -55,  -69,  -49,  -38,  -46,  -32,  -27,  -19,   -5,    3,   19,   26,   41,
      53,   52,   81,   81,   95,  104,   90,  113,  101,  105,  118,   99,  113,  109,  100,  109,
     104,   98,  104,   96,   89,   83,   71,   66,   57,   56,   38,   28,   29,    8,   17,    6,
      -2,    3,  -24,  -13,  -79, -103, -120, -116, -104,  -87,  -76,  -63,   63,   82,   97,  108,
     119,   99,   70,   69,   80,   91,   92,   98,  115,  124,  127,  113,   82,   42,    4,  -44,
     -70,  -82, -100,  -87,  -62,  -58,  -71,  -65,  -79,  -60, -102, -113,  -62,  -44,  -31,  -31,
     -22,  -18,   -3,    4,   11,   20,   28,   11,   15,   18,   27,   18,    7,   13,   26,   11,
     -19,  -69, -108,  -84,  -51,  -21,   -3,   -6,  -18,  -17,  -31,  -33,  -18,    2,    4,   26,
      47,   48,   77,  117,  127,  127,  127,  121,  110,   86,   72,   62,   46,   11,   17,   -2,
      -7,  -13,  -44,  -60,  -61,  -61,  -63,  -72,  -79,  -99, -116, -127, -128, -128, -124,  -81,
     -51,   -4,    5,   -6,    7,    8,    9,   31,   31,   16,   34,   28,   34,   34,   46,   78,
      84,   93,   69,   47,   40,   64,   44,   27,   22,    0,  -29,   -8,   15,   -6,  -36,  -66,
     -68,  -42,    0,    6,    1,   13,   24,   41,   64,   58,   50,   40,    4,    0,    3,  -24,
      -3,   21,   28,   26,    9,  -30,  -42,  -61,  -85,  -92,  -91,  -96,  -87,  -74,  -31,  -20,
     -38,  -14,  -44,  -17,   18,  -25,   -9,    7,    1,   11,   -2,  -19,   12,   47,   76,   72,
      58,   68,   69,   82,   86,   76,   58,    9,  -23,  -12,   -7,  -22,   -2,    0,   -9,   -2,
     -15,  -10,   -3,  -22,  -17,  -38,  -44,  -33,  -24,  -27,  -16,    0,  -15,   20,   19,   18,
       1,   10,   41,   -1,  -25,  -25,  -11,   30,   37,    9,   45,   37,  -30,  -30,   21,    5,
     -26,  -43,  -56,  -42,  -48,  -48,  -29,  -62,  -76,  -42,  -23,  -12,  -14,    8,   45,   36,
      40,   25,   14,   11,   40,   46,   55,   65,   30,   17,   30,   36,   33,   18,   13,   16,
      15,   46,   37,    2,   -1,  -26,  -36,  -19,  -21,  -36,  -62,  -51,  -48,  -20,   -2,    3,
     -12,  -12,  -10,  -35,  -37,  -49,  -22,   14,   61,   40,   60,   75,   33,   41,   48,   38,
      29,  -32,  -45,  -56,  -64,  -61,  -30,  -20,   30,   10,  -46,  -37,  -35,  -30,  -24,  -12,
     -23,  -34,  -29,  -22,  -20,  -14,    4,   44,   77,   49,   10,    8,   24,   20,   28,   31,
      27,   40,   35,   69,   39,   54,   38,   26,   22,   43,   36,    7,   14,    2,  -25,  -50,
     -51,  -56,  -42,  -55,  -46,  -36,  -44,  -36,  -35,    1,   23,   11,   -3,  -34,  -66,  -33,
     -12,  -31,  -27,  -13,   -1,   21,   31,   23,    0,  -11,   -3,   -2,    9,   27,    5,   -8,
      -2,  -17,  -13,   10,    9,    3,   35,   32,   43,   24,   15,    2,  -15,   -9,   -5,    2,
       5,   27,   25,   42,   76,   61,   17,   25,   14,   -5,  -17,  -24,   -6,   11,   23,    7,
      -8,    5,  -11,  -23,  -27,  -48,  -30,  -12,  -26,  -36,  -37,  -39,  -46,  -61,  -55,  -23,
     -20,  -22,  -14,  -10,  -16,  -16,  -22,  -11,   -3,  -14,  -34,  -16,    9,   28,   25,   50,
      63,   52,   56,   46,   50,   54,   56,   45,   54,   29,   20,   21,    0,    0,    6,   16,
      28,   14,   -1,   -9,  -10,   -4,   -9,  -13,   -7,  -21,  -27,  -29,  -40,  -41,  -35,  -42,
     -64,  -11,    9,    2,  -12,  -24,  -37,  -40,  -34,  -29,  -34,  -12,  -26,  -20,   -6,   -4,
       5,    5,   27,    1,  -17,    2,   21,   12,    8,    9,   15,   23,   24,    1,    5,   22,
      25,   28,   57,   55,   41,   33,   36,   27,    5,    1,   15,   34,   23,    4,   20,   18,
      -1,  -21,  -22,  -15,  -17,   -8,   -6,   -6,  -12,  -15,  -26,    1,   29,   -8,  -40,  -52,
     -55,  -19,  -21,  -36,  -48,  -56,  -29,  -15,  -29,  -39,  -46,  -35,  -14,  -11,  -16,    1,
      27,   22,  -10,  -14,   -7,  -12,  -12,   23,   55,   48,   65,   42,   20,   46,   45,   49,
      42,   38,   34,   25,   33,   21,   10,   38,   40,   26,   22,   37,   33,   12,    4,    7,
     -14,  -49,  -41,  -36,  -53,  -40,  -35,  -44,  -31,  -22,  -19,  -50,  -78,  -80,  -78,  -48,
     -31,  -18,  -27,  -28,   -7,  -17,  -11,    5,   32,   39,   19,   14,   22,   34,   37,   23,
      20,   40,   40,   27,   14,   11,    7,   29,   34,   19,   32,    7,  -15,  -12,  -24,  -12,
       8,    6,   21,   34,   29,   -6,  -22,  -15,    1,   -1,   24,   27,   20,   36,   42,   45,
      27,  -14,  -50,  -34,  -14,  -26,  -25,  -10,   10,   -4,  -28,  -30,  -34,  -69,  -91,  -85,
     -74,  -51,  -38,  -24,  -19,   -9,   -7,  -30,  -35,  -30,  -36,  -12,   25,   32,   44,   50,
      45,   51,   68,   94,   90,   74,   60,   52,   64,   48,   30,   11,   11,   11,    2,   14,
      24,   16,   13,   -7,  -17,   -9,  -12,  -20,  -32,  -45,  -54,  -58,  -35,  -23,  -46,  -51,
     -33,  -28,  -29,  -24,  -36,  -30,  -24,  -22,  -20,  -13,   -9,  -14,   -7,   10,   26,   22,
       9,    9,   10,   -2,   -9,  -15,  -11,   -1,   19,   27,   33,   28,    5,    3,    5,    6,
      10,   14,   24,   32,   36,   40,   41,   37,   19,   11,    3,   -7,  -10,   -7,    6,   27,
      38,   28,   23,   16,   18,   15,   -7,  -33,  -20,  -13,  -24,  -25,  -19,  -15,  -26,  -52,
     -56,  -48,  -41,  -36,  -30,  -32,  -30,  -15,  -38,  -49,  -47,  -32,  -17,  -17,  -11,   -3,
       3,    8,   24,   28,   16,    6,    1,    7,   28,   41,   42,   69,   87,   78,   73,   62,
      30,   14,    9,    7,   15,   32,   20,   10,   -8,  -20,    2,    9,   -2,    5,   12,   -4,
     -12,  -19,  -32,  -37,  -29,  -24,  -28,  -39,  -43,  -40,  -44,  -28,  -25,  -33,  -39,  -37,
     -34,  -29,  -28,  -25,  -19,   -1,   -5,  -22,  -12,    2,    6,   38,   46,   25,   30,   41,
      47,   37,   21,    7,   -7,   -8,   11,   39,   48,   43,   35,   27,   25,   22,   -1,  -22,
     -11,   13,   -4,  -13,   -3,   -8,   -7,  -11,  -17,   -5,    5,    9,    8,   15,   25,   16,
      22,   20,    5,  -16,  -27,  -29,  -30,   -9,    9,    9,    3,  -14,  -50,  -56,  -56,  -79,
     -92,  -80,  -57,  -24,   12,   10,   11,    4,  -22,  -21,  -13,   -2,    4,   10,   15,    8,
      35,   72,   53,   44,   25,   25,   48,   56,   69,   53,   50,   75,   85,   71,   33,   12,
     -16,  -32,  -25,  -14,   -5,  -16,  -23,  -19,  -22,  -39,  -41,  -47,  -45,  -33,  -35,  -39,
     -38,  -35,  -34,  -29,  -28,  -28,  -23,  -10,   -7,   -9,  -11,  -18,   -5,   13,    1,  -13,
      -8,   -5,    6,   27,   46,   43,   25,    8,   11,   16,   18,   23,   30,   12,    5,   10,
       7,    5,   -6,   -4,   -5,    1,   10,    9,   15,   21,   17,   10,   -8,  -16,   10,   33,
      34,   23,   13,   17,   17,    9,   11,    7,   -4,   -8,   -8,  -22,  -27,  -26,  -19,   -7,
     -18,  -16,  -16,  -47,  -62,  -55,  -36,  -16,  -25,  -33,  -30,  -34,  -42,  -49,  -41,  -43,
     -31,  -20,   -3,   28,   48,   66,   64,   36,   20,   26,   21,   22,   39,   51,   45,   39,
      40,   53,   56,   39,   24,   16,   12,   16,   24,   27,   16,   13,    7,  -18,  -33,  -50,
     -47,  -33,  -24,  -20,  -26,  -32,  -31,  -46,  -53,  -58,  -56,  -29,  -13,  -11,   -2,    8,
     -11,  -24,  -11,   -9,   -6,   -2,   -6,    1,    4,    5,   11,    6,    7,   16,   30,   28,
      19,   15,    7,    4,   11,   27,   22,    6,    9,   11,    3,    4,   17,   27,   18,   11,
      12,    5,    2,   -2,   -6,   -7,   -2,   10,   12,    9,    1,   -2,    3,    4,   11,   21,
      30,   28,    6,   -9,  -18,  -22,  -22,  -38,  -41,  -27,  -18,  -18,  -27,  -27,  -23,  -32,
     -35,  -32,  -34,  -30,  -25,  -24,  -18,   -9,   -5,    5,   -5,  -26,  -19,  -11,   -4,   11,
      37,   48,   46,   50,   53,   50,   45,   45,   37,   18,   24,   44,   38,   43,   47,   29,
      15,   11,   10,   12,    4,   -8,   -6,   -4,  -17,  -27,  -28,  -36,  -34,  -37,  -53,  -53,
     -46,  -38,  -38,  -37,  -28,  -24,  -23,  -37,  -42,  -30,    0,   20,   18,   12,   14,    9,
       2,    6,   15,   13,   10,   14,   12,    2,   12,   29,   21,    1,    7,   21,   19,   14,
      15,   15,    4,   -1,    5,   -1,   -4,    0,   -2,    3,    6,    6,   13,   21,   15,    7,
       3,    5,    2,   -3,    3,    3,    5,    8,   10,   16,   14,   -1,   -7,    2,   11,   12,
     -10,  -35,  -42,  -26,  -21,  -37,  -44,  -44,  -47,  -42,  -27,  -27,  -23,  -15,  -16,  -20,
     -21,  -14,  -12,   -9,   -7,   -6,    0,   13,   30,   32,   37,   38,   31,   24,   25,   43,
      54,   49,   46,   44,   40,   41,   30,    9,   -1,    6,   22,   31,   22,    9,    0,  -14,
     -23,  -29,  -29,  -28,  -35,  -39,  -39,  -39,  -33,  -25,  -30,  -44,  -49,  -45,  -45,  -35,
     -19,    2,   16,   16,    9,    0,    0,    6,    2,   -1,   11,   27,   40,   32,   16,   -2,
      -2,    1,    3,    1,    7,   12,    6,    8,   11,    5,   -1,   -2,   -1,    1,    8,   10,
       5,    4,   14,   17,    6,   -1,    0,    4,    4,   17,   23,   19,   25,   20,    5,   -8,
      -9,   -2,   -1,   -6,   -3,   13,   16,    1,  -13,  -19,  -21,  -26,  -34,  -37,  -23,  -13,
     -13,  -24,  -40,  -42,  -40,  -39,  -29,  -22,  -21,  -18,  -12,   -2,   18,   24,   10,    0,
      -6,   -4,   15,   33,   34,   34,   44,   41,   31,   33,   44,   43,   31,   22,   20,   17,
      16,   23,   22,   19,   21,   10,   -5,   -6,   -9,   -8,   -2,   -5,  -16,  -28,  -36,  -47,
     -53,  -39,  -23,  -21,  -24,  -32,  -43,  -39,  -34,  -24,  -18,  -14,  -11,  -12,   -6,   10,
      29,   41,   40,   27,   14,   10,    4,    1,    3,    2,    9,   19,   21,    9,  -10,  -16,
     -10,    8,   18,   20,   13,   -3,   -8,   -4,   -1,    2,    5,    5,   -1,    3,    9,   12,
      16,   16,   14,    9,    3,    5,   10,    4,   -6,    1,    6,    5,   13,   20,   11,    1,
      -7,  -21,  -30,  -25,  -12,   -9,  -13,  -19,  -24,  -29,  -34,  -30,  -32,  -39,  -33,  -24,
     -20,  -22,  -24,  -13,    3,    6,    2,    1,    3,    5,   16,   30,   35,   35,   24,   16,
      15,   19,   31,   37,   33,   28,   29,   29,   30,   26,   20,   15,   13,   10,   10,   12,
       9,    7,   -3,  -21,  -39,  -44,  -43,  -42,  -34,  -26,  -23,  -18,  -12,  -18,  -32,  -36,
     -31,  -27,  -20,  -10,   -7,   -9,  -11,   -5,    2,   12,   19,   19,   25,   24,   11,    3,
      15,   29,   30,   20,    9,    1,   -1,    1,    5,    2,   -3,   -2,    0,   -6,  -18,  -27,
     -20,   -3,    8,   13,   15,   11,    7,   10,   18,   16,   10,    6,    3,   -1,    1,   11,
      19,   19,   15,   14,    5,   -2,   -2,   -7,  -12,  -15,  -20,  -16,  -10,   -5,    2,    1,
     -13,  -29,  -33,  -24,  -10,   -6,  -13,  -18,  -23,  -31,  -32,  -26,  -22,  -18,  -13,   -3,
       2,    3,    7,    8,   10,   19,   27,   32,   33,   33,   35,   38,   43,   41,   29,    9,
      -4,   -9,    2,   16,   17,   13,   15,   17,   13,   10,    5,   -1,   -8,  -18,  -29,  -32,
     -27,  -21,  -22,  -30,  -31,  -31,  -33,  -31,  -27,  -18,   -7,   -6,  -15,  -16,   -8,   -1,
       4,   12,   18,   22,   20,   16,   11,   10,   14,   18,   16,   15,   14,    9,    6,    4,
       3,    3,    0,   -5,  -13,  -18,  -15,  -13,   -9,   -7,   -8,   -5,   -2,   -5,   -1,    5,
       8,   10,   11,   12,   17,   19,   16,   10,    4,    4,    8,    8,    8,   13,   14,    9,
       3,    0,   -1,    0,    0,   -7,  -19,  -24,  -20,  -15,  -12,  -15,  -21,  -23,  -24,  -26,
     -28,  -29,  -28,  -21,  -10,   -1,    5,    6,   -3,  -12,  -14,  -11,   -1,   12,   16,   17,
      28,   36,   28,   20,   25,   27,   24,   25,   28,   21,   15,   11,    3,    4,   12,   11,
       0,   -7,   -5,   -1,   -1,   -5,   -8,  -11,  -17,  -23,  -22,  -19,  -21,  -20,  -20,  -22,
     -24,  -22,  -17,  -20,  -24,  -20,  -10,    2,   10,   13,   14,   14,   11,    8,    8,   12,
      17,   18,   20,   20,   14,    4,   -1,   -2,   -1,    3,   11,   12,    6,    0,   -9,  -20,
     -25,  -18,   -9,   -8,  -13,  -18,  -19,  -14,   -6,    0,    4,   11,   19,   22,   20,   19,
      15,   13,   14,   18,   17,   12,    7,    9,   14,    9,   -1,   -4,   -1,   -5,  -10,  -12,
     -16,  -23,  -19,   -7,   -5,  -10,  -10,  -11,  -19,  -27,  -24,  -14,   -6,   -3,  -10,  -21,
     -24,  -15,   -6,    0,    9,   15,   12,    8,    6,    9,    9,   11,   20,   26,   31,   35,
      30,   21,   16,   16,   13,    6,    2,    4,    5,    3,   -2,  -10,  -13,  -11,   -8,   -9,
     -13,  -16,  -18,  -18,  -19,  -22,  -18,   -8,   -3,   -1,    0,   -5,  -11,  -10,   -9,  -11,
      -9,   -2,    2,    4,   10,   15,   18,   19,   21,   21,   22,   22,   15,    4,   -4,   -8,
      -7,   -6,  -10,  -14,  -18,  -23,  -20,  -15,   -8,   -1,    0,   -4,   -7,   -9,   -9,   -6,
      -2,    2,    6,    7,    4,    1,    0,    7,   13,   11,   14,   22,   22,   15,    8,    2,
       4,   10,   16,   17,   13,   10,    9,    6,   -3,  -13,  -23,  -26,  -21,  -17,  -14,  -12,
     -13,  -16,  -14,   -9,   -8,   -8,  -11,  -18,  -18,  -12,   -4,    0,    2,    6,    6,   -1,
      -6,    0,    8,   11,   13,   11,    6,    6,    9,   13,   16,   16,   15,   10,    7,   10,
      10,    4,    0,   -2,   -3,   -1,    2,    2,   -1,   -5,  -13,  -21,  -27,  -30,  -26,  -16,
      -4,    5,    8,    6,    2,   -3,   -5,   -1,    4,    8,    9,   11,   11,    6,    0,    0,
       7,   12,   13,   11,    7,    1,   -4,   -3,    0,    5,    6,    5,   -2,  -10,  -13,  -13,
     -10,   -5,   -4,   -9,  -18,  -28,  -31,  -24,  -14,  -10,   -4,    2,    5,    4,    2,    4,
      13,   20,   21,   19,   14,   11,   11,   12,   13,   14,   15,   17,   18,   18,   14,    5,
      -3,   -5,   -8,  -11,  -11,  -12,  -15,  -15,  -13,  -13,  -15,  -13,  -12,  -15,  -16,  -11,
      -7,   -6,   -4,   -1,    4,    6,   -1,  -10,  -11,   -7,   -4,   -1,    4,    9,   11,   12,
       9,    7,    8,    8,    7,    9,   13,   15,   12,    4,    1,    1,   -2,   -9,  -10,   -7,
      -1,    3,    3,   -1,   -9,  -12,   -9,   -5,    1,    3,   -2,  -10,  -10,   -7,   -4,    2,
       8,    6,    4,    6,    5,   -1,   -1,    7,   17,   20,   17,   16,   19,   16,    7,   -3,
      -8,   -9,   -9,  -11,  -15,  -24,  -27,  -20,  -15,  -12,  -11,   -7,   -3,   -4,   -6,   -7,
      -6,   -8,  -14,  -18,  -18,  -15,  -10,   -5,    3,   12,   18,   20,   17,   11,   10,   16,
      21,   22,   23,   23,   22,   17,    9,    0,   -3,    2,   10,   15,   16,   11,    2,   -9,
     -19,  -23,  -22,  -15,  -10,   -8,  -11,  -13,  -15,  -17,  -19,  -18,  -15,  -10,   -3,    1,
      -2,   -6,   -3,    0,   -3,   -3,    0,    6,   10,    9,    7,    4,   -1,   -4,    0,   10,
      17,   16,   11,    5,    0,   -1,    2,    5,    1,   -6,  -10,  -10,   -8,   -6,   -4,   -2,
      -4,   -7,   -9,   -9,   -6,    2,   12,   17,   16,   11,    8,    7,    6,    5,    7,    9,
      12,   14,   14,    9,    3,   -1,   -3,   -5,   -4,    0,    4,   -1,  -10,  -18,  -24,  -29,
     -28,  -20,  -14,  -13,  -12,   -8,   -5,   -5,   -9,  -13,  -14,  -11,  -10,   -9,   -4,    1,
       3,    2,    3,    8,   16,   20,   18,   13,   10,   14,   24,   29,   29,   27,   23,   17,
      14,   16,   17,   15,    9,   -1,   -7,  -10,  -14,  -18,  -16,  -11,   -8,   -7,   -8,  -12,
     -18,  -26,  -29,  -26,  -19,  -11,   -5,   -3,   -3,   -2,    0,    2,    0,   -3,   -3,   -2,
      -3,   -4,   -2,   -1,    3,    7,    9,    8,    7,    3,    1,    4,    5,    2,    3,    5,
       5,    0,   -7,   -9,   -6,   -1,    5,    9,    8,    3,   -2,   -6,   -5,    3,    9,   12,
      11,    8,    4,    3,    4,    6,   11,   13,    8,    1,    0,    4,    9,   13,   12,    5,
       2,    3,    3,    0,   -6,  -16,  -26,  -30,  -28,  -26,  -22,  -18,  -17,  -19,  -22,  -24,
     -19,  -12,   -7,   -2,    1,    0,   -2,   -4,   -5,   -2,    4,   10,   14,   15,   15,   16,
      16,   17,   19,   22,   26,   25,   19,   13,   10,    7,    9,   11,   10,    7,    4,    1,
      -5,   -8,   -8,   -4,    0,    1,   -4,  -11,  -16,  -17,  -16,  -14,  -12,  -10,  -11,  -14,
     -15,  -16,  -13,   -9,   -3,    1,    2,    1,    0,    0,   -3,   -9,  -13,  -10,   -8,   -7,
      -4,    0,    3,    6,    9,    9,    5,    3,    3,    5,    8,   12,   12,    6,   -1,   -2,
       2,    8,    8,    4,   -2,   -5,   -1,    4,   10,   13,   14,   13,   13,   14,   14,   12,
      10,    8,    8,    8,    6,    6,    9,    6,   -1,   -9,  -15,  -19,  -22,  -24,  -23,  -25,
     -25,  -23,  -20,  -19,  -19,  -21,  -20,  -20,  -21,  -19,  -11,   -2,    2,    1,    0,    3,
       9,   13,   15,   16,   14,   10,    5,    3,    8,   14,   16,   18,   20,   22,   24,   21,
      15,    9,    6,    8,   14,   18,   15,    9,    4,    1,    0,   -2,   -4,   -4,   -3,   -3,
      -4,   -7,  -11,  -13,  -12,  -11,  -15,  -19,  -22,  -25,  -25,  -21,  -14,  -11,  -15,  -19,
     -18,  -14,   -7,   -1,    4,    2,   -3,   -6,   -4,    0,    5,   10,   16,   17,   12,    7,
       2,   -1,   -3,    0,    3,    6,   10,   14,   12,    6,    2,    5,   10,   15,   18,   18,
      16,   14,   11,    6,    4,    3,    1,    1,    2,    6,    9,    9,    3,   -2,   -3,   -4,
      -6,   -8,  -10,  -15,  -19,  -20,  -19,  -18,  -17,  -15,  -16,  -17,  -18,  -20,  -22,  -21,
     -16,  -11,   -4,    1,    0,   -4,   -4,   -1,    1,    2,    4,    4,    3,    3,    4,    7,
      11,   16,   21,   20,   15,   11,    9,   12,   16,   21,   24,   23,   21,   17,   13,   11,
       9,    4,    0,    0,    1,    3,    4,    0,   -4,   -7,   -7,   -9,  -13,  -17,  -20,  -22,
     -23,  -21,  -16,  -12,  -12,  -15,  -17,  -17,  -15,  -12,  -10,  -10,  -11,  -12,  -15,  -15,
     -10,   -4,    0,   -1,   -1,    1,    4,    7,   13,   19,   22,   23,   21,   19,   18,   17,
      11,    5,    2,    5,   10,   13,   15,   15,   14,   13,   10,    5,    1,    0,    2,    5,
       8,   10,    9,    6,    4,    2,   -1,   -5,   -7,   -8,   -7,   -8,  -11,  -13,  -14,  -16,
     -19,  -21,  -22,  -22,  -24,  -23,  -20,  -17,  -16,  -16,  -15,  -16,  -16,  -15,  -13,  -11,
      -9,   -5,    0,    6,   12,   15,   18,   18,   17,   17,   19,   20,   19,   19,   20,   23,
      25,   25,   23,   20,   17,   13,   11,    9,    9,    8,    6,    3,    1,   -2,   -5,   -5,
      -2,   -1,   -3,   -7,   -6,   -3,    0,   -2,   -9,  -21,  -29,  -32,  -32,  -30,  -27,  -27,
     -29,  -30,  -28,  -24,  -23,  -21,  -16,   -7,    0,    1,    2,    2,    4,    7,   10,   14,
      16,   14,   12,   13,   15,   18,   20,   22,   23,   20,   15,    8,    3,    2,    7,   13,
      15,   13,    7,    2,    0,    0,   -1,   -2,   -1,    1,    2,    1,    0,    2,    3,    4,
       4,    6,    7,    5,    0,  -10,  -21,  -30,  -36,  -36,  -33,  -28,  -23,  -18,  -15,  -14,
     -17,  -19,  -19,  -17,  -12,   -5,   -2,   -2,   -3,   -1,    2,    6,   10,   12,   14,   13,
      12,   13,   18,   25,   29,   28,   24,   19,   14,   10,    6,    6,    9,   12,   13,   15,
      17,   18,   18,   14,    7,    0,   -1,    1,    1,   -2,   -6,   -8,  -10,  -11,  -13,  -17,
     -19,  -18,  -17,  -16,  -14,  -14,  -15,  -17,  -19,  -22,  -26,  -26,  -24,  -20,  -17,  -14,
     -13,  -12,  -10,   -7,   -4,    1,    5,    7,    9,   10,   13,   15,   17,   18,   21,   24,
      22,   21,   19,   17,   15,   13,   14,   14,   16,   17,   18,   16,   12,   10,    8,    6,
       5,    3,    0,   -3,   -6,   -7,   -5,   -4,   -4,   -5,   -5,   -4,   -4,   -4,   -8,  -13,
     -19,  -24,  -27,  -28,  -27,  -25,  -25,  -27,  -27,  -25,  -19,  -14,   -8,   -3,    1,    6,
       9,    8,    3,   -3,   -6,   -4,   -1,    4,    9,   14,   18,   20,   22,   22,   23,   23,
      22,   21,   20,   20,   21,   21,   19,   15,    9,    3,   -2,   -4,   -3,    0,    2,    2,
       2,    3,    3,    1,   -4,  -10,  -15,  -19,  -19,  -16,  -11,   -7,   -7,   -9,  -13,  -17,
     -23,  -28,  -30,  -29,  -24,  -20,  -18,  -19,  -20,  -19,  -18,  -19,  -18,  -13,   -5,    1,
       6,    9,   11,   13,   16,   21,   26,   29,   30,   29,   29,   28,   26,   23,   20,   20,
      21,   21,   20,   18,   15,    9,    2,   -4,   -6,   -5,   -3,   -3,   -4,   -6,   -7,   -9,
     -10,  -10,  -10,  -10,  -11,  -13,  -12,  -11,   -8,   -6,   -6,  -10,  -17,  -26,  -32,  -35,
     -35,  -34,  -32,  -27,  -19,   -9,   -3,   -1,   -2,   -5,   -7,   -6,   -1,    7,   14,   18,
      21,   23,   25,   26,   26,   23,   20,   20,   23,   24,   24,   21,   19,   14,    8,    2,
      -1,    0,    1,    2,    3,    6,    8,    8,    5,    2,   -2,   -5,   -5,   -4,   -1,    1,
       1,   -1,   -6,   -9,  -11,  -13,  -17,  -20,  -24,  -26,  -27,  -26,  -23,  -21,  -20,  -23,
     -26,  -27,  -26,  -24,  -20,  -15,   -9,   -2,    4,    8,   10,   13,   16,   19,   21,   23,
      25,   28,   33,   36,   38,   38,   35,   32,   29,   24,   16,   11,    6,    2,   -2,   -6,
      -6,   -5,   -4,   -4,   -7,  -11,  -14,  -13,  -10,   -8,   -8,   -8,   -9,  -11,  -12,  -12,
     -11,  -11,  -12,  -14,  -17,  -19,  -19,  -18,  -18,  -20,  -22,  -23,  -21,  -18,  -14,  -11,
      -8,   -4,   -1,    5,   11,   13,   11,    8,    6,    7,    9,   11,   13,   15,   19,   22,
      23,   25,   27,   27,   22,   17,   11,    6,    4,    5,    9,   13,   15,   15,   11,    6,
       0,   -4,   -7,   -8,   -6,   -3,   -2,   -3,   -6,   -9,  -13,  -18,  -22,  -23,  -20,  -15,
     -11,  -10,  -11,  -14,  -19,  -24,  -27,  -28,  -28,  -27,  -26,  -23,  -19,  -15,  -10,   -6,
      -1,    4,    8,   10,   11,   11,   13,   15,   17,   20,   23,   24,   24,   26,   28,   28,
      28,   27,   26,   24,   22,   20,   16,   13,   10,    8,    6,    3,   -3,   -9,  -15,  -17,
     -16,  -15,  -13,  -13,  -14,  -17,  -19,  -20,  -20,  -17,  -14,  -12,  -13,  -14,  -13,  -13,
     -14,  -15,  -14,  -13,  -12,  -12,  -12,  -10,   -8,   -7,   -8,   -9,   -9,   -7,   -4,    0,
       3,    6,    8,   10,   12,   14,   18,   22,   25,   26,   27,   28,   28,   27,   24,   20,
      16,   13,   11,    9,    6,    3,    0,   -3,   -3,   -2,    1,    3,    5,    3,    0,   -4,
      -8,  -12,  -17,  -21,  -22,  -20,  -17,  -15,  -14,  -14,  -13,  -15,  -19,  -22,  -21,  -18,
     -14,  -13,  -15,  -16,  -17,  -17,  -19,  -19,  -16,  -11,   -4,    1,    6,   10,   13,   17,
      20,   23,   24,   24,   24,   25,   28,   33,   37,   38,   35,   30,   24,   20,   16,   13,
       9,    2,   -4,   -8,   -8,   -8,   -7,   -7,   -9,  -12,  -16,  -18,  -18,  -16,  -15,  -16,
     -16,  -16,  -13,  -10,  -10,  -11,  -13,  -15,  -15,  -15,  -15,  -16,  -17,  -16,  -14,  -13,
     -13,  -13,  -13,  -12,   -9,   -5,   -2,    1,    3,    6,   12,   18,   22,   22,   21,   18,
      16,   16,   19,   23,   29,   32,   30,   24,   18,   13,    9,    6,    3,    0,   -2,   -4,
      -6,   -8,  -10,  -11,  -10,   -6,   -3,   -2,   -3,   -5,   -5,   -6,   -6,   -7,   -6,   -5,
      -4,   -5,   -8,  -10,  -11,  -12,  -14,  -16,  -18,  -20,  -21,  -21,  -22,  -23,  -24,  -24,
     -22,  -18,  -11,   -4,    1,    4,    5,    6,    8,   11,   15,   20,   24,   26,   27,   28,
      31,   32,   31,   30,   28,   27,   24,   20,   17,   14,   12,    9,    3,   -3,   -9,  -12,
     -15,  -16,  -17,  -15,  -13,  -10,  -10,  -11,  -13,  -14,  -15,  -17,  -19,  -21,  -23,  -24,
     -22,  -18,  -13,   -9,   -8,   -8,   -8,   -9,   -9,   -9,   -7,   -4,    0,    2,    3,    5,
       5,    3,    3,    4,    5,    6,    7,   10,   14,   17,   20,   20,   20,   21,   22,   20,
      18,   16,   15,   14,   12,    9,    7,    6,    4,    2,   -2,   -5,   -7,   -9,   -9,   -8,
      -5,   -2,    0,    0,   -1,   -3,   -7,  -12,  -16,  -16,  -15,  -13,  -12,  -13,  -13,  -12,
     -11,  -11,  -12,  -15,  -19,  -23,  -24,  -22,  -19,  -16,  -13,  -10,   -5,   -1,    3,    6,
       7,    8,    8,   10,   13,   17,   21,   25,   27,   28,   28,   26,   24,   24,   25,   27,
      28,   29,   28,   25,   19,   12,    4,   -3,  -10,  -15,  -19,  -22,  -24,  -25,  -26,  -25,
     -23,  -21,  -20,  -18,  -17,  -16,  -14,  -12,  -11,  -12,  -14,  -14,  -13,  -13,  -15,  -16,
     -16,  -16,  -15,  -11,   -4,    0,   -2,    0,    0,    3,   14,   34,   24,   -3,  -14,  -12,
       6,    6,  -11,  -23,   -5,   15,   20,   15,  -19,  -12,    3,   19,   11,   -5,    1,    4,
       7,  -13,   -3,    5,  -13,    0,   -2,    8,    0,   -6,   16,   23,   13,    6,    2,   14,
      25,    2,   11,    3,   -7,   -8,  -24,   -6,   -4,  -18,    6,   30,   14,    9,    0,    0,
      13,   -7,    0,   -3,    9,    8,   -6,  -14,  -15,  -23,  -19,   -7,    0,   -3,    1,   -8,
     -10,  -10,  -17,  -12,   -7,  -10,    1,  -12,  -13,    0,  -15,  -20,  -25,  -16,   -6,   -7,
      -6,   -6,   -2,   -4,  -13,  -12,   -6,   -6,   -5,    2,    8,   -5,  -13,   -3,   -4,  -11,
     -16,   -3,   12,   -2,   -8,   -4,   -4,    4,  -15,  -17,   -6,   -2,    5,   -4,    3,   -2,
     -10,   -4,   -5,   -7,   -8,    4,   17,    1,   -3,  -14,   -4,   -2,   -7,   -4,   -6,   10,
       5,   -6,   -7,   -8,   10,   -5,   -3,    3,   -8,   11,    7,   -5,   -3,  -13,   -7,    0,
      -6,    4,    0,   -7,   12,   -9,  -17,   -7,    5,    2,   -3,   -4,   -7,    7,   -2,  -13,
      -5,   -2,    5,    4,    0,    7,   -3,    4,    1,   -2,   -4,    6,    8,    8,    0,   -2,
       2,    3,    2,    1,   -2,    5,   12,    6,    3,    2,   -3,    2,    3,    1,    8,    6,
       7,    2,   -5,   -3,    1,    5,    2,    0,   -3,    2,    7,    2,    0,   -9,    0,    5,
       1,    3,    1,    4,    6,   -5,   -3,   -2,    2,    6,    4,    6,    1,    2,    4,    4,
      -2,    2,    5,    5,    7,    7,    2,    6,    0,    3,    0,   -3,    8,    4,    4,    9,
      -3,    2,    1,    1,    2,    1,    5,    5,    4,    6,    1,   -6,   -2,    3,    5,    6,
       4,    3,    4,    1,    2,   -4,    0,    6,    2,    2,    4,    3,    5,   -3,   -2,   -5,
      -3,    5,    2,    1,    3,    1,   -2,   -3,   -4,   -6,    3,    5,    1,   -2,    1,    2,
      -2,   -2,   -2,   -3,    3,    5,    3,    4,    2,    2,    1,    0,    1,    4,    9,    9,
       5,    2,    1,    6,    4,    4,    5,    5,    7,    8,    4,    5,    1,    2,    3,    1,
       1,    4,    2,    3,    0,   -4,   -7,   -5,    0,   -3,   -3,   -3,   -5,    0,   -8,   -7,
      -8,   -5,   -3,   -6,   -3,   -4,   -5,    0,   -7,   -4,   -5,   -3,    1,    1,   -2,    1,
      -2,    2,    0,    0,   -2,    3,    5,    4,    5,    4,    2,    4,    2,    4,    5,    6,
       5,    6,    4,    4,    4,    4,    3,    4,    2,    4,    4,    2,   -2,   -2,    0,   -3,
      -3,   -3,   -4,   -2,   -7,   -6,   -7,   -9,   -7,  -10,   -9,  -10,  -10,   -8,  -11,   -9,
      -9,  -12,  -10,  -13,  -12,   -7,   -8,   -6,   -6,   -9,   -6,   -5,   -3,    0,    0,    1,
       1,    4,    3,    4,    8,    6,    8,    7,    6,   10,    9,   12,   12,   11,   12,    8,
      13,   10,   11,   10,    8,    9,    8,    6,    9,    4,    5,    0,   -3,   -5,   -5,   -6,
      -7,   -9,  -12,  -15,  -17,  -21,  -18,  -22,  -21,  -23,  -25,  -24,  -27,  -27,  -26,  -30,
     -27,  -27,  -28,  -20,  -22,  -19,  -14,  -15,  -12,  -10,  -10,   -2,    3,    4,   12,   12,
      14,   20,   17,   25,   27,   29,   33,   35,   35,   40,   38,   41,   39,   36,   38,   36,
      36,   38,   31,   33,   25,   21,   14,    8,    1,    2,    0,   -3,   -5,  -15,  -23,  -28,
     -40,  -39,  -43,  -46,  -43,  -52,  -53,  -59,  -66,  -62,  -69,  -63,  -64,  -64,  -50,  -56,
     -44,  -45,  -43,  -38,  -36,  -31,  -20,   -8,    4,   12,   19,   18,   28,   31,   40,   52,
      57,   68,   73,   73,   77,   73,   81,   79,   82,   82,   77,   82,   77,   75,   69,   59,
      53,   42,   33,   24,   22,   17,   11,    1,  -17,  -25,  -36,  -42,  -46,  -55,  -60,  -64,
     -73,  -77,  -88,  -90,  -92,  -97,  -98, -100, -100,  -92,  -85,  -79,  -80,  -76,  -79,  -69,
     -56,  -50,  -32,  -24,  -15,    0,   -2,   11,   15,   29,   45,   55,   67,   72,   82,   88,
      95,  101,  102,  109,  109,  112,  109,  110,  110,  106,  104,   91,   81,   77,   68,   66,
      54,   42,   32,   14,    6,   -6,  -12,  -20,  -29,  -43,  -55,  -65,  -76,  -76,  -85,  -89,
     -97, -105, -107, -114, -115, -117, -117, -113, -112, -104, -101,  -91,  -85,  -84,  -70,  -72,
     -55,  -42,  -34,  -14,   -8,    5,   16,   22,   35,   44,   57,   69,   78,   89,   94,  101,
     104,  109,  109,  119,  118,  117,  120,  110,  114,  114,   99,  102,   84,   74,   72,   57,
      52,   43,   32,   22,   10,   -7,  -20,  -28,  -34,  -47,  -54,  -60,  -67,  -71,  -80,  -87,
     -90, -105, -105, -110, -120, -115, -120, -123, -113, -111, -109,  -97,  -98,  -92,  -83,  -82,
     -76,  -63,  -61,  -48,  -39,  -30,  -16,   -3,   10,   22,   32,   42,   49,   61,   67,   76,
      84,   91,  101,  105,  115,  116,  117,  125,  115,  119,  116,  106,  111,  102,   97,   92,
      84,   79,   70,   64,   50,   45,   31,   19,   14,   -2,   -9,  -19,  -30,  -35,  -47,  -54,
     -62,  -67,  -73,  -82,  -86,  -96, -100, -105, -109, -116, -118, -120, -120, -117, -111, -110,
     -97,  -96,  -90,  -84,  -78,  -73,  -64,  -55,  -50,  -39,  -25,  -20,    1,   11,   19,   37,
      40,   51,   61,   68,   76,   85,   94,   97,  105,  114,  112,  120,  122,  119,  121,  117,
     110,  106,  105,   92,   90,   84,   69,   71,   57,   48,   45,   29,   22,   14,   -2,   -9,
     -22,  -31,  -40,  -47,  -59,  -62,  -68,  -76,  -80,  -87,  -97,  -96, -111, -111, -116, -124,
    -119, -123, -120, -109, -109,  -98,  -95,  -93,  -84,  -81,  -75,  -66,  -55,  -51,  -37,  -28,
     -16,    1,   12,   23,   39,   40,   55,   59,   68,   77,   86,   94,  103,  104,  116,  117,
     118,  125,  122,  117,  120,  107,  108,  104,   95,   92,   85,   72,   70,   60,   48,   43,
      29,   18,   10,   -7,  -12,  -22,  -30,  -38,  -49,  -58,  -63,  -72,  -75,  -84,  -90,  -93,
    -100, -110, -103, -121, -115, -115, -124, -110, -112, -111,  -92,  -98,  -86,  -81,  -77,  -69,
     -61,  -53,  -48,  -34,  -27,  -13,    1,    9,   28,   37,   45,   58,   59,   76,   78,   85,
      97,   98,  109,  114,  111,  123,  120,  119,  121,  116,  111,  110,  101,   93,   92,   79,
      73,   68,   55,   52,   40,   30,   21,   10,    0,  -13,  -23,  -29,  -41,  -47,  -58,  -64,
     -69,  -75,  -84,  -89,  -93, -103, -105, -110, -120, -115, -117, -128, -105, -114, -109,  -88,
    -102,  -86,  -76,  -84,  -64,  -63,  -56,  -43,  -37,  -25,  -10,    4,   11,   31,   36,   46,
      56,   58,   74,   78,   84,  100,   95,  110,  114,  110,  124,  120,  116,  121,  110,  105,
     108,   97,   96,   91,   79,   75,   66,   57,   51,   38,   29,   17,    5,   -3,  -13,  -20,
     -28,  -40,  -46,  -55,  -66,  -68,  -76,  -85,  -88,  -97, -102, -106, -110, -117, -115, -120,
    -122, -108, -117, -103,  -98,  -96,  -86,  -79,  -77,  -66,  -59,  -54,  -46,  -33,  -31,  -10,
      -2,   11,   27,   36,   47,   58,   62,   74,   78,   86,   94,   96,  106,  109,  115,  120,
     118,  121,  119,  112,  114,  104,   98,   94,   85,   77,   72,   63,   56,   49,   37,   31,
      20,    6,   -2,  -15,  -24,  -33,  -44,  -50,  -58,  -63,  -68,  -76,  -82,  -89,  -95, -105,
    -105, -116, -118, -117, -126, -114, -111, -118,  -92, -105,  -92,  -83,  -88,  -72,  -71,  -65,
     -51,  -50,  -31,  -25,   -9,    2,   16,   29,   35,   50,   53,   67,   73,   75,   92,   88,
     104,  112,  108,  122,  117,  119,  123,  114,  116,  110,  104,   98,   94,   86,   80,   75,
      63,   59,   47,   36,   29,   13,    9,   -5,  -16,  -21,  -36,  -40,  -50,  -61,  -61,  -73,
     -77,  -85,  -93,  -95, -103, -108, -117, -120, -118, -125, -117, -108, -116,  -96,  -98,  -97,
     -83,  -82,  -78,  -66,  -61,  -54,  -43,  -32,  -25,   -2,    3,   16,   33,   36,   52,   56,
      66,   75,   78,   94,   91,  103,  113,  108,  122,  119,  119,  121,  116,  112,  110,  106,
      93,   96,   83,   76,   74,   59,   58,   47,   34,   28,   14,    6,   -6,  -17,  -27,  -36,
     -44,  -54,  -61,  -63,  -70,  -76,  -86,  -90,  -99, -102, -108, -117, -115, -121, -123, -111,
    -120, -102, -100, -101,  -84,  -91,  -76,  -74,  -70,  -54,  -56,  -41,  -30,  -20,   -3,    8,
      23,   31,   46,   47,   59,   70,   71,   83,   89,   90,  108,  108,  115,  120,  121,  122,
     118,  118,  109,  110,  102,   93,   93,   82,   78,   72,   62,   57,   45,   37,   22,   15,
       4,  -10,  -18,  -30,  -36,  -42,  -54,  -57,  -63,  -68,  -77,  -86,  -91, -102, -103, -108,
    -117, -114, -119, -117, -115, -110, -106, -100,  -91,  -99,  -79,  -81,  -77,  -59,  -61,  -50,
     -36,  -33,  -16,   -4,   10,   16,   35,   39,   48,   62,   64,   76,   85,   89,   98,  105,
     110,  113,  120,  119,  118,  123,  112,  111,  110,  100,   98,   93,   82,   78,   70,   58,
      54,   45,   30,   24,   12,    0,   -7,  -20,  -28,  -36,  -45,  -55,  -61,  -66,  -73,  -79,
     -88,  -93, -103, -105, -112, -119, -115, -124, -123, -109, -119, -103,  -98, -102,  -92,  -84,
     -83,  -75,  -62,  -59,  -50,  -34,  -34,  -12,    1,    7,   26,   33,   42,   50,   62,   67,
      76,   88,   90,  101,  110,  108,  118,  121,  119,  122,  121,  111,  113,  110,   98,   98,
      91,   80,   78,   66,   58,   53,   40,   29,   20,    8,   -4,  -11,  -22,  -33,  -37,  -49,
     -57,  -61,  -68,  -77,  -81,  -90,  -96, -101, -110, -112, -116, -120, -116, -121, -119, -104,
    -111,  -96,  -91,  -96,  -79,  -79,  -76,  -59,  -57,  -46,  -33,  -25,  -14,    5,   11,   26,
      39,   42,   55,   61,   70,   81,   86,   94,  101,  105,  114,  116,  120,  121,  119,  119,
     115,  111,  107,  102,   94,   90,   82,   73,   68,   59,   50,   41,   28,   20,    7,   -4,
     -12,  -22,  -30,  -41,  -48,  -56,  -62,  -69,  -75,  -83,  -90,  -98, -100, -107, -111, -119,
    -112, -124, -120, -107, -119, -101,  -93, -104,  -80,  -85,  -83,  -61,  -65,  -55,  -40,  -38,
     -25,   -7,   -3,   13,   29,   34,   45,   57,   59,   74,   79,   87,   98,   98,  108,  111,
     112,  122,  117,  119,  119,  111,  110,  107,   96,   96,   89,   76,   74,   63,   54,   51,
      35,   27,   19,    5,   -3,  -12,  -25,  -29,  -43,  -52,  -58,  -64,  -71,  -78,  -82,  -92,
     -98, -101, -108, -110, -114, -120, -119, -118, -115, -110, -106,  -95,  -97,  -82,  -84,  -76,
     -62,  -63,  -51,  -42,  -39,  -20,  -12,    2,   15,   29,   36,   47,   58,   62,   74,   80,
      85,   95,  101,  106,  111,  116,  118,  117,  122,  113,  115,  111,   99,  103,   90,   85,
      80,   68,   63,   56,   46,   36,   28,   17,    5,   -5,  -19,  -25,  -35,  -43,  -52,  -58,
     -62,  -72,  -75,  -83,  -94,  -94, -105, -105, -115, -115, -116, -122, -114, -112, -108,  -98,
     -99,  -89,  -86,  -82,  -72,  -69,  -58,  -52,  -44,  -31,  -21,   -6,    4,   17,   28,   39,
      48,   53,   66,   72,   80,   88,   92,  104,  108,  113,  116,  119,  121,  116,  119,  112,
     108,  107,   94,   94,   85,   79,   72,   62,   57,   48,   37,   25,   17,    8,   -8,  -15,
     -26,  -35,  -42,  -55,  -59,  -65,  -73,  -75,  -87,  -89,  -97, -104, -109, -116, -116, -121,
    -120, -120, -109, -108, -103,  -90,  -97,  -78,  -78,  -77,  -60,  -64,  -50,  -41,  -34,  -16,
      -7,    9,   19,   33,   42,   52,   60,   65,   77,   79,   87,   96,   99,  109,  113,  118,
     124,  117,  121,  117,  109,  110,   99,   94,   93,   83,   77,   73,   63,   55,   50,   32,
      26,   18,    0,   -6,  -20,  -29,  -34,  -49,  -53,  -57,  -63,  -71,  -76,  -83,  -91,  -97,
    -108, -112, -114, -122, -115, -124, -112, -105, -112,  -89,  -99,  -90,  -78,  -89,  -72,  -66,
     -61,  -49,  -41,  -28,  -16,    2,    6,   25,   35,   36,   53,   54,   67,   77,   79,   93,
      97,  105,  112,  111,  122,  118,  119,  117,  112,  109,  108,   99,   95,   92,   82,   76,
      71,   59,   56,   43,   30,   24,   10,    0,   -9,  -18,  -26,  -36,  -45,  -55,  -59,  -68,
     -75,  -81,  -88,  -94,  -99, -106, -109, -110, -119, -117, -119, -116, -111, -105, -101,  -91,
     -92,  -83,  -75,  -75,  -61,  -52,  -52,  -35,  -29,  -18,    0,    9,   22,   36,   41,   51,
      64,   68,   78,   88,   90,  101,  103,  109,  113,  115,  121,  117,  118,  116,  109,  109,
     102,   94,   90,   80,   71,   67,   57,   47,   42,   30,   19,   14,   -4,   -9,  -19,  -31,
     -36,  -50,  -55,  -61,  -68,  -74,  -79,  -87,  -93, -101, -107, -107, -115, -118, -118, -123,
    -112, -110, -109,  -92,  -93,  -94,  -74,  -83,  -71,  -57,  -61,  -45,  -34,  -31,  -10,    0,
      12,   27,   37,   42,   55,   61,   70,   77,   87,   95,   96,  106,  112,  113,  123,  122,
     117,  122,  112,  109,  110,   96,   96,   92,   76,   74,   68,   55,   50,   40,   28,   20,
       7,   -6,  -10,  -23,  -31,  -42,  -51,  -59,  -65,  -70,  -76,  -82,  -88,  -92, -104, -104,
    -105, -122, -113, -122, -126, -106, -119, -103,  -91,  -99,  -82,  -80,  -76,  -66,  -59,  -54,
     -46,  -34,  -30,   -9,    1,   13,   33,   34,   51,   57,   63,   76,   77,   91,   95,   95,
     110,  108,  115,  122,  120,  120,  123,  112,  110,  110,   94,   95,   87,   70,   74,   62,
      55,   50,   39,   29,   20,    7,   -5,  -13,  -26,  -35,  -44,  -56,  -61,  -65,  -69,  -75,
     -83,  -86,  -98, -104, -104, -121, -115, -119, -128, -110, -117, -116,  -92, -100,  -90,  -78,
     -83,  -75,  -63,  -64,  -55,  -41,  -39,  -20,   -7,    1,   21,   31,   40,   51,   55,   67,
      72,   77,   91,   93,   99,  110,  109,  118,  125,  118,  124,  119,  108,  114,  101,   93,
      96,   81,   75,   73,   59,   57,   48,   35,   27,   15,    1,   -7,  -20,  -29,  -37,  -49,
     -56,  -61,  -65,  -69,  -74,  -83,  -91,  -98, -107, -113, -117, -120, -122, -118, -115, -111,
    -103, -101,  -92,  -89,  -85,  -80,  -77,  -65,  -61,  -51,  -41,  -33,  -16,   -4,    8,   21,
      34,   40,   49,   57,   63,   73,   82,   89,   98,  104,  109,  117,  118,  123,  122,  119,
     116,  110,  108,  100,   97,   93,   83,   80,   70,   64,   55,   45,   34,   22,   12,   -2,
     -10,  -20,  -30,  -35,  -48,  -55,  -62,  -67,  -71,  -78,  -86,  -91, -101, -104, -110, -117,
    -117, -120, -123, -111, -111, -110,  -90,  -99,  -90,  -76,  -85,  -71,  -58,  -63,  -45,  -37,
     -33,  -14,    1,    4,   27,   34,   41,   53,   59,   66,   79,   84,   92,  100,  103,  110,
     115,  116,  123,  118,  118,  117,  107,  110,  101,   95,   93,   79,   76,   68,   57,   52,
      43,   30,   23,   11,   -3,   -8,  -20,  -30,  -34,  -48,  -55,  -60,  -69,  -74,  -81,  -89,
     -92, -101, -105, -108, -114, -117, -118, -122, -112, -113, -108,  -95, -101,  -87,  -82,  -83,
     -68,  -60,  -56,  -45,  -38,  -28,  -17,   -2,    6,   23,   33,   40,   54,   60,   68,   80,
      85,   94,   96,  103,  109,  110,  119,  118,  118,  121,  113,  112,  110,  100,   98,   90,
      77,   73,   66,   55,   51,   41,   29,   25,    8,    1,   -9,  -23,  -28,  -42,  -51,  -59,
     -64,  -67,  -75,  -79,  -86,  -94,  -98, -105, -111, -115, -117, -121, -123, -111, -120, -102,
     -95, -100,  -79,  -84,  -81,  -61,  -69,  -55,  -46,  -42,  -27,  -14,   -3,   11,   30,   35,
      49,   57,   60,   76,   76,   86,   95,   95,  109,  108,  116,  122,  121,  123,  120,  116,
     114,  106,  100,   94,   88,   78,   73,   65,   59,   52,   38,   33,   20,   10,   -2,  -15,
     -22,  -32,  -42,  -51,  -58,  -62,  -67,  -77,  -80,  -86,  -94, -100, -106, -113, -115, -119,
    -122, -118, -117, -107, -106,  -98,  -89,  -89,  -78,  -76,  -71,  -57,  -56,  -46,  -36,  -25,
     -12,    0,   16,   26,   39,   49,   54,   67,   72,   80,   88,   94,  101,  104,  115,  113,
     121,  125,  116,  123,  116,  110,  109,   98,   93,   88,   78,   69,   65,   56,   47,   42,
      27,   20,    8,   -6,  -15,  -27,  -33,  -43,  -53,  -58,  -64,  -68,  -74,  -86,  -87,  -96,
    -106, -103, -117, -116, -117, -123, -117, -106, -114,  -97,  -96,  -96,  -81,  -81,  -80,  -62,
     -64,  -49,  -45,  -34,  -19,   -8,    4,   17,   28,   40,   47,   54,   66,   73,   79,   93,
      95,  102,  113,  110,  117,  123,  119,  121,  117,  113,  111,  106,   96,   95,   88,   78,
      72,   63,   55,   47,   35,   26,   14,    4,   -9,  -19,  -24,  -35,  -43,  -51,  -61,  -65,
     -72,  -79,  -88,  -88,  -99, -107, -107, -120, -114, -120, -122, -113, -116, -102, -106,  -95,
     -89,  -95,  -72,  -80,  -70,  -50,  -58,  -37,  -30,  -20,   -5,    6,   18,   29,   44,   45,
      57,   72,   68,   89,   89,   97,  109,  104,  120,  113,  118,  124,  112,  120,  112,  107,
     106,   96,   91,   87,   78,   66,   65,   52,   40,   39,   17,   17,    4,  -13,  -13,  -30,
     -35,  -44,  -58,  -59,  -66,  -72,  -78,  -85,  -93,  -97, -106, -114, -110, -120, -120, -118,
    -120, -109, -110,  -98, -100,  -89,  -81,  -87,  -68,  -68,  -59,  -44,  -46,  -29,  -18,   -5,
       5,   22,   32,   39,   54,   56,   68,   79,   79,   94,   98,  102,  110,  112,  117,  119,
     124,  117,  116,  116,  104,  106,   97,   89,   86,   74,   67,   60,   53,   41,   34,   24,
      12,    4,   -9,  -19,  -28,  -38,  -47,  -58,  -60,  -68,  -73,  -77,  -88,  -93,  -96, -111,
    -109, -115, -124, -118, -122, -120, -107, -109, -102,  -91,  -95,  -82,  -78,  -78,  -60,  -59,
     -51,  -36,  -35,  -14,   -3,    6,   24,   34,   41,   56,   59,   67,   81,   82,   92,  103,
     102,  112,  119,  114,  123,  123,  116,  121,  112,  106,  107,   93,   91,   84,   74,   69,
      61,   52,   43,   32,   21,   13,   -2,  -10,  -22,  -31,  -38,  -51,  -56,  -59,  -69,  -71,
     -76,  -87,  -90, -100, -107, -110, -119, -118, -120, -123, -108, -118, -101,  -92, -102,  -77,
     -85,  -83,  -63,  -71,  -58,  -45,  -44,  -27,  -15,   -2,   10,   30,   32,   46,   57,   56,
      74,   73,   84,   93,   95,  109,  108,  117,  117,  124,  119,  119,  119,  112,  109,  100,
      96,   90,   81,   75,   65,   59,   51,   41,   33,   22,   12,    0,  -12,  -23,  -30,  -40,
     -51,  -57,  -64,  -71,  -73,  -83,  -84,  -95, -102, -102, -116, -117, -118, -128, -116, -114,
    -116, -102,  -99,  -95,  -86,  -80,  -80,  -71,  -58,  -61,  -46,  -38,  -30,  -10,   -4,   12,
      26,   37,   47,   54,   67,   68,   79,   89,   86,  104,  104,  111,  118,  118,  123,  121,
     119,  116,  112,  109,   99,   96,   88,   80,   75,   66,   58,   49,   41,   29,   19,   10,
      -5,  -10,  -25,  -35,  -39,  -53,  -58,  -64,  -69,  -75,  -81,  -87, -100,  -99, -112, -116,
    -118, -126, -123, -115, -120, -111, -102, -100,  -93,  -86,  -85,  -76,  -69,  -64,  -56,  -47,
     -38,  -25,  -10,    4,   16,   31,   40,   46,   61,   65,   70,   83,   86,   93,  103,  105,
     114,  125,  118,  124,  125,  112,  120,  111,   98,  103,   91,   86,   83,   71,   66,   61,
      49,   38,   32,   16,    7,   -4,  -17,  -26,  -36,  -44,  -54,  -60,  -59,  -71,  -75,  -79,
     -94,  -95, -103, -117, -112, -120, -127, -120, -118, -117, -104, -102,  -99,  -88,  -84,  -86,
     -73,  -70,  -64,  -51,  -47,  -37,  -17,  -10,    7,   19,   32,   40,   52,   56,   67,   73,
      80,   87,   92,  103,  109,  110,  123,  119,  121,  126,  111,  113,  112,   98,   98,   91,
      80,   80,   71,   60,   61,   47,   36,   30,   13,    5,   -5,  -19,  -27,  -35,  -43,  -52,
     -58,  -62,  -71,  -76,  -84,  -96, -100, -105, -118, -115, -121, -123, -121, -114, -117, -110,
     -98, -105,  -91,  -83,  -90,  -71,  -68,  -64,  -48,  -43,  -33,  -17,   -5,    3,   23,   32,
      38,   54,   59,   66,   79,   82,   92,  100,  105,  108,  116,  119,  117,  126,  116,  115,
     118,  106,  105,   99,   91,   85,   78,   67,   60,   54,   41,   33,   24,   11,    0,    3,
      10,   14,   -8,   46,    7,  -20,  -23,  -28,   17,    9,   47,   -7,  -15,  -35,   -1,  -26,
      44,   34,  -31,   31,  -47,  -32,   30,   -2,   32,   15,  -15,  -17,  -39,   16,   -2,   26,
      23,    3,  -43,   11,  -37,   14,   37,    7,    4,  -21,  -30,   -9,   14,   18,   38,  -13,
     -16,  -21,  -24,    8,   38,    3,   16,  -29,  -11,  -26,   20,   15,   24,   -9,    0,  -34,
     -21,   32,  -16,   41,   -1,  -20,   -7,   -7,   -7,   27,    0,   -2,   -2,  -11,  -11,   19,
     -16,   32,  -19,   -4,   11,  -40,   49,  -13,  -12,   12,  -32,   12,   17,    1,   23,  -34,
     -20,   14,  -20,   33,   44,  -51,    7,  -21,  -38,   46,   19,   37,  -28,  -29,  -17,  -40,
      63,   36,  -33,   42,  -45,  -57,   16,   37,   -3,   54,    0,  -64,  -25,   -7,   15,   37,
      34,   -2,  -65,  -12,   -3,   -7,   76,   -2,   -6,  -28,  -22,  -30,   40,   11,   12,   21,
     -43,   -6,   -1,  -31,   73,  -35,   33,   -1,  -67,   29,  -24,   16,   42,    4,  -26,   17,
     -71,   32,    0,    0,   72,  -56,    4,   -2,  -75,   76,  -25,   39,   24,  -42,   -6,  -20,
     -31,   56,    1,    3,   49,  -63,  -12,  -16,  -10,   49,   12,   29,  -32,  -59,   35,  -39,
      35,   45,  -33,  -21,   46,  -68,   13,   16,   12,    0,    2,   32,  -70,   12,   30,  -62,
      64,    5,  -31,   22,  -30,   11,  -30,   43,    2,   -8,   16,   -3,  -60,   39,  -11,  -13,
      63,  -32,    8,   -6,  -45,   39,  -38,   30,   49,  -89,   96,  -84,    0,   43,  -51,   52,
      -4,   -6,    7,  -31,  -10,   12,  -22,   62,    8,  -57,   65, -101,    1,   69,  -46,   76,
     -18,  -34,  -24,  -33,   50,   -6,   55,   16,  -70,  -19,    2,  -33,   59,   61,  -40,    7,
     -44,  -33,   -7,   61,   31,  -15,    5,  -32,  -70,   47,   34,    8,   22,  -16,  -44,  -47,
      56,   -6,   12,   56,  -46,  -32,   -3,    7,   -4,   42,   19,  -41,  -35,   41,  -59,   43,
      45,  -44,    9,   -9,   -7,  -19,   36,    2,  -50,   49,   -6,  -34,   33,   -1,  -38,   17,
      44,  -33,    5,   28,  -68,  -13,   62,  -25,   15,   45,  -57,  -32,   23,  -14,   37,   11,
      29,  -56,  -48,   46,  -55,   48,   94,  -74,   22,  -40,  -59,   36,    9,   75,  -19,  -31,
       6, -104,   39,   80,  -23,   59,  -12, -104,   10,  -12,   24,   59,    5,    9,  -78,  -12,
      24,  -47,  116,   -6,  -51,   34,  -71,  -26,   55,    3,   11,   38,  -31,   -9,  -45,   21,
     -11,    4,   92,  -79,   16,  -16,  -41,   29,   27,   19,   -5,  -19,  -13,  -35,   29,   22,
      -7,   20,  -35,    6,  -21,   30,   -2,    6,   -8,  -20,  -12,   30,  -13,    8,   23,  -52,
      21,    8,  -16,   40,  -20,   -7,  -15,  -38,   62,  -33,   48,    5,  -66,   28,  -25,   15,
      39,    5,  -46,    8,  -46,   32,   12,   37,   -9,  -49,   43,  -78,   43,   46,  -43,   39,
     -41,  -36,   13,   19,   48,  -21,    9,  -37,  -54,   45,   32,  -14,   41,  -32,  -66,   42,
      -8,   37,   12,  -10,  -12,  -74,   71,  -30,   16,   65,  -64,   -1,  -13,  -12,   17,   24,
      10,  -16,  -31,   -1,   -3,    1,   68,  -47,   -7,   -8,  -41,   74,  -16,   32,  -27,  -42,
      22,  -49,   80,  -11,    0,   23,  -84,   34,  -24,   31,   48,  -37,   23,  -55,  -25,   22,
      14,   22,   59,  -78,  -11,   -1,  -45,   90,  -35,   32,    0,  -75,   63,  -65,   34,   52,
     -71,   70,  -56,  -14,   30,  -22,   10,   55,  -74,   41,  -19,  -47,   88,  -62,   50,  -11,
     -57,   44,  -54,   59,   17,  -23,   12,  -40,  -41,   60,    3,   15,   28,  -71,   -1,  -17,
      11,   61,  -28,   47,  -59,  -48,   35,  -18,   51,   27,  -20,  -35,  -36,   14,    6,   44,
      23,  -30,  -33,  -17,   -1,   14,   49,   -2,  -32,  -12,  -20,    5,   29,   34,  -33,    9,
     -34,  -26,   36,   -2,   40,  -28,    5,  -26,  -39,   65,  -27,   19,   31,  -54,    0,   -8,
      12,    2,   30,   -5,  -25,  -22,   24,  -29,   26,   52,  -57,    7,    5,  -56,   46,    1,
       8,    4,   -5,    1,  -51,   28,   14,  -21,   48,  -17,  -46,    4,   11,   -6,   35,    7,
     -16,  -31,  -10,   25,  -49,   95,  -28,  -29,   19,  -46,   -5,   32,   21,    8,   -1,  -24,
     -36,  -17,   59,   -7,   33,   10,  -76,  -14,   19,   -1,   56,   16,  -23,  -64,   -8,    7,
       8,   85,    0,  -57,  -21,  -35,   -7,   72,   23,   28,  -66,  -16,  -47,    2,   68,   24,
       5,    0,  -69,  -26,   22,   -7,   72,    0,  -12,  -20,  -51,   15,  -11,   44,   44,  -46,
      36,  -59,  -38,   32,   19,   -3,   71,  -45,  -28,  -29,  -17,   36,    8,   79,  -47,  -53,
      18,  -65,   38,   75,  -24,   20,  -36,  -34,  -26,   38,   39,   -7,   -3,    7,  -85,   44,
      26,  -17,   42,  -20,  -29,  -26,   26,   18,   -8,   36,  -17,  -73,   40,    4,   -1,   52,
     -16,  -47,  -15,   14,    4,   29,   30,  -41,  -44,   15,   -2,   16,   60,  -26,  -54,   17,
     -33,   22,   48,   -5,  -15,  -20,  -13,  -15,   31,   37,  -28,    6,  -17,  -22,  -10,   64,
     -43,   16,   22,  -71,   41,    3,   -1,    6,  -12,   12,  -38,   11,   38,  -49,   37,   24,
     -64,   27,   18,  -73,   81,  -33,   14,   -3,  -32,   43,  -60,   53,   24,  -76,   70,  -29,
     -33,   50,  -18,  -34,   48,  -38,   37,  -15,   -5,   25,  -80,   70,   -4,  -45,   89,  -72,
      -3,   13,  -23,   28,   21,   -9,   -9,  -25,  -11,   24,  -26,   62,  -14,  -49,   67,  -97,
      57,   12,  -23,   46,  -46,    9,  -20,   -4,   25,   -1,    5,   18,  -31,  -25,   38,  -43,
      44,   17,  -42,   37,  -66,   37,  -16,   26,   18,  -16,  -17,   -4,  -17,    7,   38,  -11,
       4,   -3,  -51,   32,  -17,   38,   18,  -34,   23,  -58,    4,   25,    0,   26,    3,  -35,
     -11,  -10,   16,   24,    8,    4,  -33,  -30,   22,   -2,   14,   52,  -61,   10,  -23,   -4,
      20,   10,   32,  -44,   -2,    1,  -36,   37,   32,  -25,    2,    0,  -40,   14,   24,   -5,
      13,  -28,   20,  -51,   41,   15,  -23,   25,  -12,  -41,   30,   -2,  -11,   40,  -34,   14,
     -24,    3,   22,  -31,   44,  -22,  -31,   57,  -55,   28,    0,   -9,    1,   11,  -10,    8,
     -13,    3,   -2,  -23,   60,  -49,   23,   10,  -59,   36,   -3,   -3,   35,  -23,    5,  -42,
      15,    7,   -2,   35,    0,  -45,    8,   -4,  -27,   63,   -4,  -14,    9,  -39,    1,    1,
      27,   19,  -27,   24,  -49,   -6,   34,   -5,   10,   19,  -32,  -20,   14,  -12,   16,   26,
      -9,  -19,   -9,   -8,    8,    7,   40,  -29,  -14,   -4,  -25,    7,   56,  -15,    6,  -20,
     -36,    3,   10,   33,   20,  -23,   -5,  -42,  -18,   54,  -17,   63,   -5,  -59,    2,  -44,
      12,   57,   17,   15,  -33,  -44,  -16,  -17,   65,   40,   -9,   10,  -72,  -51,   39,   10,
      65,   19,  -25,  -47,  -51,   17,   20,   53,   30,  -35,  -35,  -34,  -16,   36,   48,   12,
      -3,  -35,  -42,   -9,   28,   34,   12,   15,  -42,  -39,    7,    8,   24,   28,    1,  -31,
     -36,    9,   -1,   28,   29,  -14,  -34,   14,  -43,   23,   34,   -7,   24,  -44,   10,  -28,
      -5,   53,  -29,   29,   -7,  -33,    2,   -1,    5,   19,   10,  -17,    2,  -33,   14,    1,
       8,   32,  -36,   17,  -28,  -18,   36,  -22,   29,    2,  -25,    5,  -17,   13,    1,   16,
      -1,  -10,  -12,    3,   -9,   10,   19,  -22,   16,   -3,  -20,   24,  -22,   15,   -3,  -14,
      22,  -30,   31,  -14,  -11,   12,  -11,    8,   17,   -9,   -4,  -13,  -13,    7,   10,   19,
      -6,   -7,   -2,  -32,   24,    8,    0,   17,  -20,  -10,  -15,   13,   10,   11,    4,   -1,
     -40,   19,   -4,   -6,   42,  -31,   -1,   -5,  -12,   19,    6,    7,   -5,  -26,   10,  -12,
      15,   20,   -8,  -19,   12,  -40,   31,   15,   -3,   16,  -23,  -27,    7,   -5,   31,    6,
       3,   -6,  -41,   14,   -2,    7,   38,  -10,  -29,   11,  -44,   17,   29,    6,   20,  -26,
       1,  -45,    9,   31,  -18,   40,   -1,  -47,    8,  -10,   -4,   29,   33,  -25,    1,  -31,
     -12,   -9,   35,   30,  -25,   31,  -48,  -28,   20,   17,    9,   30,  -19,  -39,  -13,    6,
       8,   38,   15,  -10,  -42,    0,  -24,   15,   49,   -9,  -12,    5,  -44,   -5,   42,    4,
       6,    8,  -27,  -29,    5,   24,   -2,   10,   28,  -56,    1,   23,  -29,   29,   15,  -19,
     -11,    1,   -4,   -8,   24,    6,  -15,    2,    7,  -27,   12,   21,  -40,   36,  -15,  -12,
      22,  -16,   17,  -17,   15,   -6,  -18,   23,   -3,  -26,   39,  -27,   -5,   26,  -20,    8,
       5,  -11,    7,  -21,   19,  -11,   -8,   35,  -25,    2,   18,  -35,    9,   16,  -21,   29,
     -16,    1,  -13,  -13,   28,  -18,   23,   13,  -36,    6,   -1,  -23,   26,   12,  -15,   17,
     -20,   -2,   -7,    3,   22,  -22,   27,  -11,  -34,   36,  -30,   11,   17,    2,  -12,   13,
     -22,  -11,   11,   -5,   26,  -17,   26,  -25,  -32,   44,  -47,   39,   25,  -31,   16,  -35,
      -1,   -4,   26,   16,    3,  -16,  -10,  -23,   -8,   55,  -27,   26,    0,  -63,   41,  -26,
      28,   22,  -23,   14,  -42,    5,   20,  -13,   28,    3,  -42,   20,   -6,  -17,   52,  -32,
       6,   -2,  -37,   42,  -27,   29,   15,  -51,   40,  -38,    2,   33,  -19,    6,   11,  -43,
      25,    0,  -19,   57,  -54,   31,   -9,  -43,   58,  -52,   36,   11,  -44,   50,  -44,    8,
      23,  -24,   12,    6,  -34,   25,   -9,  -15,   50,  -55,   35,   -7,  -25,   49,  -48,   32,
     -23,  -18,   37,  -30,   28,    8,  -27,    7,   -2,  -19,   22,   10,  -11,   10,  -27,    4,
     -16,   18,   29,  -19,   20,  -22,  -36,   16,   -2,   18,   14,    3,  -24,  -15,   -5,   12,
      13,   20,    4,  -40,    2,  -23,    8,   29,    7,    9,  -23,  -10,  -13,    5,   19,    9,
      -3,  -14,   -7,  -19,   21,    6,    5,   10,  -20,    0,  -14,   12,    0,    2,    5,  -13,
       1,   -3,   12,  -12,   20,  -13,   -7,    6,  -11,    5,    0,    5,   -5,   -4,   10,  -10,
       2,    6,   -5,  -12,   18,  -13,   -9,   19,  -17,   11,   -1,    8,   -5,  -22,   26,  -26,
       1,   29,  -17,   -7,   16,  -22,   -8,   23,   -3,    4,   -3,   -2,  -15,  -20,   42,  -21,
       4,   40,  -55,    8,    8,  -22,   21,   20,  -17,    2,  -14,   -7,   -2,   10,   31,  -25,
      10,   -3,  -54,   40,    5,  -12,   42,  -17,  -37,   13,  -12,    7,   24,   10,   -6,  -36,
      12,   -9,  -25,   74,  -24,  -19,   38,  -64,    5,   25,    0,   16,    1,   -9,  -25,  -23,
      36,   -8,    6,   50,  -58,  -12,   22,  -53,   52,   18,  -12,   16,  -51,   15,  -30,   25,
      46,  -37,   31,  -26,  -49,   30,    9,   -1,   42,  -19,  -28,  -13,   -5,   16,    4,   42,
     -18,  -40,   20,  -30,    1,   49,   -4,  -15,    0,  -21,  -19,   21,   26,    0,   -9,    9,
     -43,   -1,   26,   -5,   21,   -7,   -6,  -32,    9,   12,   -3,   34,  -17,  -12,  -17,   -4,
       9,    7,   28,  -19,   -3,  -13,  -11,    7,   15,   15,  -19,   15,  -38,   -5,   17,   -1,
      29,  -20,   15,  -39,  -11,   41,  -33,   45,   -8,  -21,  -11,   -3,    7,    0,   28,   -7,
     -19,   -8,    7,  -20,   23,   24,  -40,   24,  -17,  -16,   26,   -9,   21,  -27,   13,  -11,
     -22,   29,   -7,    0,   22,  -22,  -16,   14,  -12,   12,   11,   -5,   -6,  -17,   14,  -15,
       9,   30,  -28,    5,    1,  -26,    8,   18,   -7,    1,    6,  -12,  -15,    9,   13,  -13,
      13,   13,  -42,   14,    3,  -16,   20,    7,   -3,  -22,   25,  -26,    4,   16,   -7,    3,
      -8,   17,  -33,   14,    9,  -21,   25,   -3,  -11,   -1,    1,  -13,    1,   23,  -20,   26,
     -18,    0,  -18,    3,   24,  -25,   36,  -15,  -29,   22,  -22,    3,   24,   -5,   -1,    0,
     -18,    2,  -11,   20,   10,  -17,   30,  -37,  -15,   29,  -33,   39,   11,  -23,    7,  -34,
       8,    0,   11,   36,  -27,  -12,    9,  -47,   29,   31,  -29,   40,  -37,  -14,    3,  -17,
      45,  -11,    8,   12,  -60,   20,   -2,   -2,   41,  -12,  -18,    3,  -37,   27,   12,   -4,
      37,  -56,   17,  -21,   -5,   44,  -20,   14,   -2,  -40,   20,    0,    3,   22,  -13,  -10,
      -6,  -16,   29,  -12,   14,   15,  -49,   24,  -11,   -7,   39,  -18,    3,  -20,  -12,   19,
     -10,   32,    2,  -34,   10,  -13,  -13,   37,    1,   -7,    3,  -33,    4,    2,   18,   25,
     -25,    8,  -33,  -13,   34,   -7,   24,    4,  -33,  -10,   -2,    2,   25,   12,   -1,  -25,
     -12,    3,  -18,   34,   12,  -15,    4,   -9,  -25,   10,   17,   -3,    9,    2,  -13,  -23,
       9,    8,  -13,   37,  -10,  -15,    1,  -13,   -1,    0,   31,  -15,    0,    5,  -29,    6,
       5,   15,   -9,   16,   -9,  -29,   15,  -10,    3,   15,    9,  -11,  -12,   11,  -29,   17,
      14,   -7,    6,   -6,   -7,  -24,   30,  -11,    9,   18,  -20,   -8,   -6,    6,  -10,   22,
      10,  -29,   14,  -13,   -8,   13,   17,  -13,    2,    1,  -24,    5,    5,   12,  -10,   15,
      -7,  -28,   21,   -2,   -8,   22,   -9,  -14,   -2,    6,   -5,    5,   12,   -7,  -15,   14,
      -4,  -16,   27,  -10,  -14,   13,   -5,   -9,   10,    5,   -8,   -5,   16,  -20,    2,   13,
     -14,   -3,   17,  -18,    2,   10,  -12,    9,   -6,   -2,  -16,   13,   10,  -15,   33,  -24,
     -17,   10,   -4,   15,    1,    9,  -23,   -9,    6,   -5,    5,   21,  -10,  -13,   11,  -21,
      -2,   19,  -10,   23,  -20,   10,  -16,  -21,   33,  -17,   17,   18,  -30,    1,  -14,   -1,
      20,   -2,   18,  -15,  -24,    6,   -5,    6,   36,  -26,    6,  -18,  -23,   34,  -12,   25,
       1,  -30,   -1,  -11,   10,   22,   -1,    4,  -19,  -28,   21,  -11,   22,   25,  -33,    4,
     -21,   -7,   22,    7,   19,  -23,  -13,   -3,  -13,   21,   17,  -11,    7,  -19,  -12,   12,
     -10,   30,  -13,   -5,    4,  -30,   27,   -9,   17,   -3,  -25,   13,  -23,   13,   27,  -15,
      -5,    3,  -35,   17,   19,   -8,   29,  -37,    1,  -15,  -10,   48,  -20,   26,   -7,  -49,
      22,  -23,   21,   33,  -10,   -8,  -17,  -34,   11,   19,   12,   40,  -39,  -14,  -13,  -36,
      64,   -4,   20,    9,  -55,    3,  -24,   21,   31,   10,   -1,  -22,  -30,   -7,   12,   18,
      29,  -10,   -7,  -28,  -22,   22,    3,   26,    4,  -13,  -18,  -16,   21,   -9,   28,   -1,
     -21,    0,  -12,    5,    6,    5,   10,  -20,    1,    3,  -20,   21,    7,  -23,   24,  -25,
      -6,   21,  -13,   25,  -19,   -8,    2,  -14,   20,   13,  -23,   25,  -31,   -7,   24,  -16,
      20,    6,  -25,    8,  -24,   12,   15,  -10,   24,  -25,   -2,    0,  -12,   14,   10,  -13,
       4,    1,  -17,    9,    6,   -9,    9,    0,   -3,   -8,   11,  -10,   -2,    7,   -1,   -6,
       6,    1,  -12,    1,   18,  -31,   23,   -2,  -21,   21,   -6,   -8,   15,  -14,    4,   -6,
      -1,   17,  -22,   20,   -6,  -35,   37,  -17,   -6,   47,  -41,    6,   -6,  -16,   12,   16,
       6,    1,  -36,   18,  -26,    4,   59,  -36,   -1,   16,  -64,   30,   14,    1,   16,  -13,
       0,  -35,   17,   13,   -8,   12,   14,  -45,   11,   12,  -24,   27,   12,  -27,   10,   -6,
      -9,    1,   14,   -7,   -6,    8,   -4,   -8,    8,    8,  -24,   13,    7,  -27,   28,   -1,
     -28,   27,  -19,   -2,   17,   -5,    6,  -10,   -5,    4,  -25,   32,    2,  -22,   32,  -28,
     -20,   35,  -20,   16,    7,  -18,    1,  -22,   20,    0,    2,   20,  -15,  -25,   24,  -25,
      12,   25,  -23,   10,  -19,   -5,    8,    2,   20,   -6,  -13,    0,  -22,   12,   15,   -3,
      13,  -13,  -25,   12,   -6,   18,   13,   -3,  -14,  -22,    3,   -2,   14,   25,  -10,  -16,
      -5,  -13,    2,   22,    9,   -2,  -11,  -12,  -20,   15,   20,    1,   14,  -19,  -17,   -9,
       1,   19,    5,    0,    4,  -35,   17,   -7,    5,   20,  -16,    2,   -8,  -11,   11,   -2,
       2,    7,  -19,   15,  -10,    2,   12,  -14,   -3,    2,   -9,   17,   -3,    2,   -7,  -16,
      10,    2,    9,   10,  -14,   -9,   -6,  -11,   21,    5,    4,    6,  -24,   -5,   -4,    6,
      18,    0,    8,  -21,  -18,    8,   -8,   21,   16,  -11,   -9,  -12,  -15,   15,    3,   27,
      -9,  -16,    5,  -30,   13,   23,  -11,   21,  -19,  -15,   -3,   -9,   30,   -9,   14,   -6,
     -22,   -5,   15,  -11,   23,   -1,  -14,   -4,   -9,    8,    4,    1,   20,  -34,    9,    1,
     -17,   24,   -6,    1,   -9,    1,   -4,    3,    6,    8,  -16,    0,    2,  -13,   11,   21,
     -31,   24,  -21,   -4,   13,   -2,    7,   -9,   -3,    0,  -18,   29,   -4,   -9,   16,  -19,
     -13,   25,   -5,   -1,   15,  -24,    4,  -15,   22,    4,  -11,   20,  -21,  -25,   39,  -23,
      14,   14,  -23,    1,   -8,    3,   12,   -9,   23,  -19,  -18,   24,  -22,    5,   30,  -32,
      11,    2,  -21,   18,   -6,    5,    1,   -9,   13,  -22,    4,   19,  -28,   26,    3,  -28,
      21,   -4,  -25,   32,  -15,    5,    0,   -2,   -4,   -9,   15,    0,  -13,   21,  -14,  -20,
      31,  -19,    2,   17,  -14,   -9,   12,   -6,    4,   -1,    4,  -17,   -1,   12,   -2,    0,
      20,  -31,   -8,   12,   -8,   17,   14,  -13,  -16,   -9,   -7,   20,   11,   18,  -13,  -28,
      -3,  -12,   13,   40,  -12,    4,  -20,  -32,    8,   17,   14,   21,  -10,  -28,  -18,   -2,
      11,   22,   17,    0,  -34,   -6,   -3,  -17,   50,    1,  -13,    4,  -22,  -21,   17,   16,
       4,    7,    0,  -27,  -11,    4,   10,    2,   24,   -6,  -28,    7,  -12,   -2,   33,   -3,
      -6,    2,  -37,    3,    9,    7,   24,   -4,  -14,   -6,  -24,   25,   -1,   11,   16,  -36,
      -9,   12,  -25,   45,    5,  -20,   11,  -36,   11,    7,    0,   30,  -32,   -1,    7,  -33,
      37,    0,   -9,   15,  -21,  -10,   12,  -15,   24,   -8,    3,    4,  -20,    7,    3,  -15,
      28,  -14,   -7,   13,  -23,    2,   11,    0,    4,    7,   -9,  -16,    1,    7,   -7,   19,
      -3,  -12,  -14,   15,  -10,    7,   30,  -26,  -13,   15,  -30,   15,   26,  -12,   -1,   -8,
      -9,   -5,   13,   22,  -12,  -12,    7,  -36,   17,   31,  -24,   27,  -21,  -24,   15,  -10,
      26,    4,  -12,    4,  -36,   13,   14,   -5,   27,  -14,  -22,    7,  -12,    6,   23,  -13,
       7,  -19,   -2,    7,   -8,   25,   -5,  -17,   18,  -25,    3,   14,   -8,    4,    0,   -1,
     -11,    4,   12,  -18,   15,    2,  -23,   12,   -2,   -7,   12,    1,   -1,  -15,   11,   -3,
     -17,   41,  -24,   -7,   13,  -25,    3,   22,   -9,   15,  -12,   -9,    0,  -17,   32,   -5,
      -5,   19,  -49,   19,    3,  -11,   45,  -30,    2,   -4,  -28,   29,    0,    7,   12,  -34,
       6,  -10,    1,   33,   -9,   -6,    4,  -41,   25,    2,    4,   29,  -40,    8,  -17,   -9,
      42,  -16,   16,  -10,  -33,   11,   -7,   22,   12,   -6,   -6,  -25,   -4,   18,   -3,   25,
      -4,  -29,    5,  -17,    8,   22,    1,    4,  -22,    1,  -13,    2,   31,  -19,    9,    2,
     -36,   17,    5,   -7,   20,  -11,   -2,  -13,    4,    9,  -18,   24,   -3,  -30,   33,  -19,
     -11,   31,  -21,    6,    0,   -5,    3,  -10,   17,   -7,  -19,   30,  -24,    0,   26,  -23,
       3,    7,  -17,    9,   -3,    9,   -1,  -17,   23,  -25,   -3,   34,  -27,   10,   15,  -34,
       9,    1,    1,    7,   -1,   12,  -31,    4,   16,  -27,   32,   10,  -33,   10,   -1,  -27,
      29,    9,   -9,    0,   -1,  -16,   -6,   24,    2,  -17,   23,  -20,  -24,   33,  -11,   -2,
      17,   -7,  -21,   13,    1,   -7,   10,    1,  -12,   -9,   13,   -1,   -5,   20,  -16,  -15,
      15,   -8,    5,   13,  -10,   -7,   -9,    5,    2,   10,    7,   -7,  -22,   12,  -13,    6,
      26,  -14,   -6,    0,  -17,    3,   16,    6,    0,  -11,    3,  -26,   13,   15,   -6,    7,
       4,  -29,    6,    7,   -3,   13,    1,  -11,   -9,    2,   -1,    3,    9,   -3,   -8,    1,
      -4,    0,    5,    0,    0,   -2,    0,   -1,    0,    0,   -2,   11,   23,   22,   24,   25,
      20,   21,   15,   40,   -1,  -24,  -42,   -5,  -19,  -11,   -8,    4,  -46,  -31,  -14,  -33,
     -40,  -44,  -48,  -89,  -63,  -47,  -33,  -27,  -10,   -6,   22,   25,   26,   28,   37,   11,
      15,   51,   44,   54,   66,   66,   71,  111,   84,   70,   63,   47,   39,   22,   47,  -28,
     -79, -111,  -90,  -91, -112,  -81,  -87,  -49,  -46,   -5,  -24,   26,   24,   47,   29,   23,
      30,   30,   13,   -1,    4,  -14,   17,   35,   62,   31,   53,   59,   72,   64,   27,   26,
       9,    9,  -61,  -44,  -88,  -74,  -81,  -83, -124,  -96,  -37,  -78,  -48,  -56,  -68,  -60,
       7,   44,   39,   54,   77,  102,  110,  108,   89,  101,  100,  105,   64,   22,   -1,   44,
      40,  -19,  -29,  -35,  -16,  -27,  -40,  -77,  -82, -113, -104,  -93,  -57,  -72,  -56,   -3,
       1,    7,   -1,   49,   39,   30,   31,   23,   10,   31,   11,    7,  -19,   -2,   -2,   28,
      62,   92,   75,   33,   34,  -20,  -47,  -61,  -85, -105,  -93, -119, -112,  -54,  -70,  -67,
     -32,   -1,    4,    4,   20,   29,   62,   70,   54,   62,   78,  115,   92,   85,   78,   52,
      21,   19,   27,    2,   -8,   13,    0,    5,    3,    9,   18,    0,  -59,  -61,  -45,  -57,
     -65,  -76,  -89, -102,  -48,  -24,   17,    6,   26,   33,   35,   26,   41,   63,   20,   12,
      29,   34,    8,    7,   31,   21,   31,   39,   33,   -5,   -8,  -55,  -57,  -98,  -94,  -88,
     -64,  -82,  -74,  -39,  -14,    3,   16,   22,    8,    2,   17,    5,   36,   76,   74,   71,
      57,   73,   62,   47,   30,   32,   19,    4,    7,  -14,  -18,   -2,   17,   -5,   13,   22,
      31,   10,    8,  -13,  -47,  -80,  -85,  -86,  -71,  -73,  -60,  -35,  -10,    9,   19,   49,
      53,   47,   60,   73,   43,   33,   20,   13,   -1,   -7,   -7,    7,    9,   -2,    5,  -14,
     -40,  -69,  -61,  -66,  -67,  -84,  -58,  -58,  -33,    2,   -7,   -5,   12,   32,   18,   25,
      19,   24,   65,   59,   62,   64,   63,   55,   60,   52,   31,   19,  -12,  -26,   -4,   -7,
     -10,   -3,    6,  -22,  -14,   12,   19,    4,  -26,  -38,  -40,  -56,  -61,  -66,  -59,  -65,
     -51,  -20,   29,   40,   51,   52,   62,   61,   53,   26,   20,    6,    8,    6,    9,  -14,
     -14,  -15,   -2,  -11,  -23,  -36,  -38,  -60,  -77,  -69,  -60,  -51,  -56,  -44,  -27,   10,
      -2,   14,   10,   22,   16,   41,   60,   39,   35,   60,   62,   43,   45,   63,   52,   17,
      12,   15,   -1,   -2,    0,  -38,  -48,  -32,  -22,   -7,    3,   13,   10,   -2,   -1,   -8,
     -12,  -25,  -48,  -46,  -52,  -49,  -36,  -17,    9,   17,   26,   48,   57,   55,   69,   60,
      32,    6,    4,   -6,  -20,  -24,   -9,  -21,  -25,  -14,  -18,  -38,  -38,  -32,  -51,  -52,
     -60,  -34,   -6,   -6,  -16,  -11,   -2,   -1,   17,   19,    3,   11,   25,   31,   41,   39,
      33,   33,   41,   34,   34,   23,   21,   15,    6,  -13,  -24,  -28,  -20,   -8,  -12,  -19,
     -12,   -5,    9,   14,    2,  -12,  -25,  -28,  -21,  -28,  -23,  -22,  -18,  -26,   -5,   24,
      45,   46,   47,   39,   33,   36,   42,   29,    7,   -5,  -10,  -21,  -29,  -39,  -39,  -31,
     -24,  -29,  -39,  -51,  -43,  -27,  -22,  -18,  -25,  -26,  -20,    9,   19,   18,    4,   -2,
      19,   30,   38,   25,   24,   28,   33,   41,   38,   34,   32,   38,   24,    8,    4,   -8,
     -11,  -15,  -25,  -31,  -25,  -20,  -22,  -15,  -11,   -9,  -12,  -17,  -20,  -20,  -15,   -6,
     -11,   -8,    0,   11,   29,   19,   17,   17,   18,   28,   31,   25,   18,   23,   18,   10,
       1,   -7,  -18,  -26,  -24,  -30,  -41,  -38,  -44,  -32,  -31,  -31,  -35,  -25,  -12,   -2,
      -8,  -11,  -13,  -13,   -2,    8,   15,   19,   29,   35,   37,   39,   43,   42,   40,   35,
      27,   25,   18,   15,    9,    4,   -4,  -15,  -28,  -28,  -26,  -28,  -18,  -15,  -25,  -23,
     -12,  -11,  -14,  -10,   -2,   -4,   -1,    8,   15,   19,   22,   25,   16,   16,   17,    5,
       7,   13,   18,   13,    9,    6,    6,    4,   -4,  -21,  -31,  -28,  -37,  -39,  -34,  -38,
     -38,  -32,  -17,   -6,   -4,  -14,  -19,   -9,    3,   -2,    3,    4,    7,    8,   13,   23,
      35,   38,   43,   42,   31,   25,   23,   17,    8,    3,    4,   -7,   -7,  -10,  -13,  -20,
     -19,  -28,  -33,  -30,  -23,  -18,  -13,  -17,  -12,    3,   14,   23,   31,   27,   23,   21,
      22,   19,   12,    4,    2,    2,   -2,    0,    4,   11,   11,    6,    4,   -2,   -5,  -14,
     -17,  -30,  -38,  -44,  -42,  -28,  -21,  -23,  -21,  -15,  -15,   -4,    8,   11,    4,   -7,
     -15,   -7,    5,   10,   21,   26,   28,   27,   34,   37,   36,   28,   19,   10,   11,    8,
      -2,  -18,  -17,  -19,  -19,  -22,  -24,  -21,  -24,  -18,  -17,  -13,  -19,  -13,   -1,   12,
      19,   22,   21,   19,   19,   30,   34,   24,   13,    7,    2,    1,    1,    2,   -1,   -2,
      -6,    0,    0,   -2,  -15,  -21,  -17,  -21,  -28,  -32,  -31,  -31,  -32,  -27,  -24,  -17,
      -4,    1,   -3,   -1,    1,    4,    7,    8,   15,   16,   15,   15,   20,   32,   36,   38,
      32,   19,   12,    3,    2,   -2,   -4,  -11,  -19,  -17,  -15,  -11,  -16,  -20,  -27,  -30,
     -28,  -22,  -13,   -6,   -2,    2,   12,   23,   29,   45,   44,   36,   32,   21,   16,   14,
      10,    1,   -9,   -8,   -2,   -1,   -7,  -13,  -13,  -12,   -9,  -11,  -18,  -24,  -26,  -28,
     -30,  -24,  -21,  -21,  -21,  -11,  -11,  -10,    0,   -2,    0,    4,   12,   13,   14,   12,
      17,   22,   28,   30,   28,   20,   16,   13,    8,    2,   -2,   -6,  -15,  -14,  -18,  -15,
     -15,  -16,  -18,  -18,  -16,  -19,  -18,  -17,  -10,    0,   -1,    4,   13,   22,   37,   39,
      36,   27,   27,   32,   26,   15,    6,   -1,   -4,   -5,   -7,  -11,  -11,   -9,  -15,  -15,
     -14,  -18,  -21,  -19,  -17,  -21,  -19,  -15,  -15,  -10,  -15,  -14,  -12,  -11,   -6,   -2,
       1,   -2,    1,    5,   14,   22,   33,   35,   23,   18,   16,   13,   11,    6,    1,   -9,
     -18,  -11,   -6,   -7,   -8,   -9,  -11,  -11,  -12,  -13,  -17,  -21,  -24,  -24,  -15,   -4,
       7,   12,   17,   25,   30,   28,   31,   32,   31,   27,   22,   15,   12,    3,   -2,   -8,
      -6,   -3,   -9,  -13,  -22,  -24,  -20,  -18,  -22,  -24,  -18,  -14,  -13,  -10,  -11,   -9,
      -3,   -2,   -3,   -5,  -10,  -10,   -5,   -1,    4,   11,   15,   19,   22,   27,   23,   20,
      16,   14,    5,   -3,  -11,  -15,  -16,  -12,  -12,  -11,   -5,    1,   -3,  -10,  -13,  -15,
     -11,  -10,  -10,  -11,   -8,   -3,    2,    7,    9,   15,   25,   30,   33,   31,   25,   21,
      20,   16,   13,    7,   -2,   -8,   -5,   -4,  -11,  -20,  -21,  -22,  -21,  -17,  -20,  -21,
     -22,  -19,  -19,  -11,   -4,   -2,   -2,   -2,    2,    5,    2,    0,    0,   -3,    1,    8,
      16,   13,   14,   17,   15,   13,    8,    5,   -1,   -6,  -10,  -13,  -14,  -14,  -13,  -10,
      -7,   -8,   -8,   -6,   -6,   -3,   -1,   -1,   -9,  -12,   -7,    3,   13,   17,   14,   13,
      17,   22,   23,   24,   18,   15,   18,   18,   18,   15,    8,    0,   -5,   -8,  -11,  -15,
     -17,  -21,  -26,  -26,  -24,  -26,  -24,  -13,   -9,   -6,   -3,   -2,    3,    4,    6,    7,
       5,    2,    4,    2,   -2,   -4,   -3,    5,   13,   17,   10,    3,   -1,   -2,   -4,   -5,
     -11,  -14,  -13,  -11,   -8,   -8,   -8,   -6,   -3,    0,   -1,   -5,   -5,    0,    4,    3,
       1,    2,    0,    0,    6,   13,   20,   17,   17,   18,   21,   18,   14,   13,   11,   11,
       7,    9,    3,   -5,  -12,  -14,  -18,  -21,  -23,  -26,  -26,  -13,   -3,   -6,  -13,  -14,
      -5,    5,    8,    3,    0,    1,    3,    6,    4,   -1,   -1,    1,    3,    7,    5,    3,
       0,    1,   -1,    3,    0,   -3,  -11,  -11,   -9,  -10,   -9,   -8,   -5,   -7,   -7,  -10,
      -9,   -6,   -1,    4,    6,    4,    2,    5,   10,   13,    9,   12,   13,   14,   15,   16,
      13,   12,   10,   13,   14,   13,    8,    2,   -1,   -4,   -6,   -9,  -15,  -20,  -21,  -19,
     -14,  -16,  -22,  -21,  -13,   -5,   -3,   -3,   -1,    3,    5,   10,    9,    9,    6,    8,
       7,    7,    7,    3,   -4,   -6,   -4,   -1,   -4,   -8,  -10,  -11,   -8,   -4,   -6,  -10,
      -7,   -8,  -11,  -11,   -8,   -5,   -4,    0,    3,    3,    8,   10,   10,   12,   12,   11,
      10,   13,   12,   10,    6,    8,    9,    9,   11,   13,   11,    9,   10,    7,    2,   -3,
      -8,   -9,  -14,  -16,  -16,  -19,  -18,  -14,  -13,  -11,  -11,  -10,   -5,   -1,    3,    5,
       2,    2,    9,   14,   11,    9,   10,    7,    2,    0,    2,   -2,   -9,  -13,  -15,  -18,
     -17,  -15,  -13,  -10,   -5,   -5,   -7,   -7,   -4,   -1,    0,   -2,   -4,   -2,    1,    4,
       9,   10,   10,   11,   11,   13,   14,   10,   11,    9,    9,    4,    6,    5,    4,    5,
       7,    8,   10,    9,    4,   -4,   -8,   -9,  -10,  -11,  -12,  -14,  -15,  -17,  -15,   -9,
      -4,   -1,   -6,   -5,    2,    8,    8,    6,    5,    3,    4,    5,    9,   10,   10,    5,
      -1,   -5,  -10,  -12,  -14,  -16,  -18,  -17,  -11,  -10,  -11,   -8,   -5,   -2,   -2,    0,
       3,    4,    5,    3,    2,    3,    5,    9,   12,   12,   11,   10,   12,   14,   12,    8,
       5,    0,   -1,    1,    3,    0,    1,    3,    5,    6,    5,    0,   -5,  -11,  -10,  -13,
     -12,  -13,  -15,  -14,   -8,   -4,   -3,   -3,   -4,    0,    4,    5,    3,    6,    4,    4,
       7,   10,    9,    9,    8,    5,    5,    2,   -4,  -10,  -15,  -17,  -20,  -22,  -22,  -19,
     -14,  -11,  -10,   -8,   -6,    0,    3,    5,    3,    4,    8,   11,   11,   12,   13,   12,
      12,   15,   15,   16,   16,   13,   11,    6,    3,   -2,   -5,   -5,   -3,   -2,   -1,    2,
       0,   -3,   -4,   -5,   -7,  -10,  -12,  -11,  -12,  -11,   -8,   -4,   -2,    0,    1,    2,
       2,    2,    4,    3,    3,    4,    5,    9,   10,    6,    2,    1,    2,    0,   -3,   -7,
     -13,  -18,  -19,  -18,  -16,  -18,  -20,  -19,  -14,   -8,   -4,   -1,    3,    3,    5,    7,
       9,    9,   10,   12,   13,   13,   13,   13,   16,   15,   13,    9,    6,    3,    2,    1,
       0,   -3,   -5,   -6,   -4,   -2,   -2,   -4,   -4,   -5,   -5,   -3,   -3,   -4,   -6,   -6,
      -7,   -4,    0,    2,    3,    2,    2,    1,    2,    2,    1,    4,    5,    4,    1,    0,
       2,    2,    0,   -2,   -6,   -8,   -6,   -7,   -9,  -11,  -15,  -18,  -19,  -18,  -18,  -17,
     -13,   -9,   -2,    2,    3,    5,   10,   12,   13,   14,   14,   15,   17,   17,   16,   16,
      15,   13,   11,    7,    2,   -6,  -10,   -8,   -6,   -8,   -8,   -7,   -6,   -6,   -3,   -4,
      -6,   -5,   -3,   -2,   -2,    0,    1,    0,    2,    2,    3,    2,    3,    2,    3,    3,
       5,    2,    0,    4,    6,    5,   -1,   -4,   -2,   -1,   -2,   -6,   -8,   -9,  -10,  -12,
     -10,  -14,  -17,  -22,  -22,  -21,  -19,  -15,   -8,   -3,    1,    7,   12,   12,   15,   19,
      22,   21,   18,   16,   16,   16,   13,   12,    6,    3,    3,    2,   -3,   -6,   -7,  -12,
     -12,  -11,   -8,   -9,   -8,   -7,   -3,    0,    0,    0,    0,   -2,   -2,    0,    1,    2,
       2,    4,    6,    6,    7,    5,    4,    3,    4,    5,    3,    0,   -2,   -2,   -4,   -6,
     -10,   -8,   -8,  -10,  -11,  -12,  -12,  -12,  -13,  -16,  -16,  -16,  -14,  -11,   -8,   -4,
      -2,    1,    6,   12,   17,   19,   20,   20,   21,   21,   19,   13,   10,    9,    5,    0,
      -3,   -4,   -4,   -5,   -6,   -6,   -4,   -7,  -10,  -12,  -12,  -12,  -10,   -7,   -4,   -2,
       4,    6,    8,    7,    7,    7,    7,    8,    8,    7,    5,    6,    6,    4,    1,   -1,
      -1,    0,   -3,   -7,  -10,  -10,   -8,  -11,  -14,  -14,  -12,  -11,   -9,   -6,   -8,   -8,
      -8,  -11,  -13,  -12,   -9,   -8,   -5,    0,    4,    8,   11,   14,   18,   18,   20,   23,
      23,   20,   14,    9,    4,    0,   -3,   -6,   -8,   -8,   -8,   -8,   -9,  -10,  -11,  -10,
      -9,   -8,   -8,   -7,   -6,   -3,    0,    3,    6,   12,   16,   16,   14,   10,    8,    9,
       7,    4,    1,    0,    0,   -2,   -1,    0,    0,   -3,   -7,  -10,  -13,  -13,  -12,  -13,
     -15,  -14,  -13,   -9,   -6,   -5,   -5,   -7,   -8,   -9,   -7,   -6,   -5,   -7,   -5,    1,
       8,   13,   17,   19,   20,   21,   22,   22,   18,   12,    9,    5,   -1,   -5,   -9,  -11,
     -13,  -12,  -12,  -11,  -10,   -8,   -7,   -7,   -6,   -7,   -6,   -3,    0,    1,    3,    7,
      10,   11,   12,   15,   15,   14,    9,    6,    3,    1,    0,   -2,   -2,   -2,   -3,   -6,
      -8,  -10,  -11,  -13,  -15,  -15,  -15,  -13,  -12,  -12,   -7,   -5,   -5,   -5,   -4,   -3,
      -3,   -4,   -4,   -1,   -1,    1,    4,    7,   10,   12,   14,   17,   20,   22,   19,   14,
       8,    5,    2,   -2,   -5,  -10,  -14,  -13,  -11,  -10,  -10,  -10,  -10,   -8,   -6,   -3,
      -3,   -3,   -1,   -1,    2,    6,   10,   13,   14,   15,   15,   15,   13,   11,    8,    5,
       1,   -1,   -3,   -3,   -6,  -10,  -12,  -12,  -12,  -12,  -13,  -15,  -18,  -19,  -15,  -11,
      -6,   -4,   -3,   -4,   -4,   -2,    1,    4,    2,   -1,   -2,    1,    4,    6,    8,    7,
       7,   11,   14,   15,   15,   15,   13,   10,    6,    1,   -3,   -6,   -9,  -13,  -15,  -15,
     -13,  -11,   -9,   -9,   -9,   -7,   -3,    0,    2,    2,    4,    7,   11,   15,   16,   14,
      11,   12,   13,   15,   13,    9,    4,    1,   -1,   -4,   -6,   -8,  -11,  -15,  -17,  -17,
     -17,  -17,  -15,  -13,  -13,  -12,  -10,   -7,   -6,   -4,    1,    2,    2,    3,    4,    5,
       4,    4,    3,    5,    6,    6,    8,    7,    7,    9,   11,   10,    9,    8,    5,    2,
       0,   -2,   -6,  -10,  -13,  -13,  -14,  -14,  -13,  -11,   -9,   -4,   -1,   -1,   -1,    2,
       6,    8,   10,   11,   12,   14,   14,   14,   13,   11,   10,    7,    4,    2,    3,    1,
      -3,   -6,  -10,  -14,  -17,  -18,  -18,  -19,  -19,  -17,  -15,  -13,   -9,   -5,   -1,    1,
       0,    1,    3,    5,    6,    6,    6,    7,    8,    9,    8,    4,    1,    0,    2,    4,
       5,    6,    5,    4,    4,    4,    3,    1,   -3,   -7,   -9,  -11,  -12,  -12,  -12,  -11,
     -10,   -7,   -4,   -2,    1,    4,    5,    8,   11,   13,   14,   14,   11,   11,   11,   10,
      10,    9,    6,    5,    3,    1,   -2,   -5,  -10,  -14,  -16,  -17,  -18,  -19,  -20,  -19,
     -17,  -14,  -10,   -5,   -1,    1,    3,    5,    6,    6,    6,    6,    6,    6,    6,    6,
       8,    7,    6,    4,    2,    0,   -1,    0,    0,    1,    2,    1,    1,    2,    1,   -2,
      -5,   -8,   -9,  -10,  -11,  -12,  -12,  -10,   -7,   -4,   -1,    2,    8,   11,   13,   15,
      15,   13,   12,   11,   10,    9,    8,    6,    5,    4,    4,    3,    0,   -3,   -6,  -10,
     -14,  -18,  -21,  -22,  -21,  -18,  -16,  -13,  -10,   -6,   -3,    0,    3,    5,    5,    5,
       6,    7,    8,    8,    8,    7,    8,    7,    6,    5,    4,    1,    0,   -2,   -4,   -4,
      -5,   -4,   -4,   -3,   -2,   -1,   -2,   -3,   -4,   -7,   -8,   -9,   -9,   -9,   -8,   -5,
      -2,    2,    4,    8,   11,   14,   15,   15,   14,   12,   10,    7,    5,    4,    4,    2,
       1,    1,    2,   -1,   -3,   -7,  -10,  -15,  -18,  -18,  -18,  -18,  -17,  -15,  -11,   -7,
      -3,    1,    3,    4,    5,    6,    7,    7,    8,    8,    9,   10,   10,    9,    6,    4,
       2,    0,   -3,   -4,   -6,   -7,   -7,   -6,   -5,   -3,   -2,   -2,   -2,   -2,   -3,   -4,
      -5,   -6,   -6,   -6,   -6,   -5,   -4,   -1,    4,    7,    9,   11,   12,   12,   11,   10,
       9,    8,    7,    5,    3,    3,    2,    1,    0,   -1,   -4,   -7,   -8,  -10,  -13,  -14,
     -15,  -15,  -15,  -14,  -11,   -9,   -6,   -3,    0,    2,    4,    5,    6,    7,    8,    9,
      10,   10,    9,    8,    6,    5,    3,    1,   -3,   -6,   -8,   -8,   -7,   -7,   -7,   -6,
      -4,   -2,    0,   -1,   -2,   -3,   -3,   -3,   -3,   -4,   -3,   -3,   -1,    1,    3,    4,
       6,    7,    8,    9,   10,   10,    9,    7,    6,    6,    4,    3,    2,    1,   -1,   -2,
      -4,   -6,   -9,  -11,  -12,  -12,  -12,  -11,  -11,  -10,   -9,   -8,   -7,   -5,   -4,   -1,
       1,    3,    5,    7,    9,   10,   11,   10,    9,    8,    7,    6,    2,   -1,   -3,   -4,
      -6,   -7,   -7,   -7,   -7,   -6,   -5,   -5,   -4,   -3,   -3,   -4,   -4,   -4,   -3,   -2,
       0,    0,    1,    1,    2,    4,    6,    6,    7,    7,    8,    7,    7,    7,    7,    7,
       6,    5,    2,    0,   -2,   -4,   -5,   -7,   -8,   -8,   -8,   -9,  -10,  -10,   -9,   -8,
      -7,   -7,   -7,   -5,   -3,   -2,    0,    1,    2,    4,    6,    9,   10,   11,   12,   10,
       8,    6,    3,    1,   -2,   -4,   -6,   -7,   -7,   -7,   -7,   -8,   -7,   -7,   -6,   -6,
      -5,   -4,   -3,   -3,   -2,   -1,    1,    2,    2,    3,    4,    5,    5,    5,    6,    6,
       6,    5,    5,    6,    6,    6,    4,    3,    2,    1,   -1,   -3,   -4,   -6,   -8,   -9,
      -9,   -8,   -8,   -6,   -5,   -5,   -5,   -6,   -6,   -6,   -5,   -4,   -2,    0,    2,    4,
       6,    7,    8,    9,    9,    9,    9,    6,    4,    1,   -1,   -3,   -5,   -6,   -7,   -7,
      -7,   -6,   -6,   -6,   -6,   -6,   -5,   -4,   -3,   -3,   -2,   -1,    1,    3,    4,    5,
       5,    5,    5,    5,    5,    4,    4,    4,    4,    4,    4,    4,    4,    4,    2,    1,
      -1,   -3,   -4,   -5,   -6,   -7,   -7,   -7,   -7,   -7,   -6,   -5,   -4,   -4,   -3,   -3,
      -3,   -3,   -2,   -1,    0,    1,    3,    5,    7,    8,    8,    8,    7,    6,    4,    2,
       0,   -2,   -3,   -4,   -5,   -6,   -7,   -7,   -7,   -7,   -6,   -6,   -5,   -5,   -5,   -3,
      -2,    0,    1,    2,    3,    4,    5,    6,    6,    6,    5,    5,    4,    3,    3,    3,
       3,    3,    3,    2,    1,    1,   -1,   -2,   -3,   -4,   -5,   -6,   -6,   -7,   -6,   -5,
      -4,   -3,   -3,   -3,   -3,   -3,   -2,   -1,   -1,    0,    1,    1,    1,    2,    3,    5,
       6,    6,    6,    5,    4,    2,    1,    0,   -2,   -4,   -5,   -5,   -6,   -6,   -6,   -7,
      -7,   -7,   -6,   -5,   -4,   -3,   -2,   -1,    0,    2,    3,    3,    4,    4,    5,    5,
       5,    4,    4,    4,    4,    3,    3,    2,    1,    1,    0,    0,   -1,   -1,   -2,   -3,
      -4,   -5,   -5,   -5,   -5,   -5,   -4,   -4,   -3,   -3,   -2,   -1,   -1,   -1,   -1,    0,
       0,    0,    1,    2,    3,    3,    4,    4,    4,    4,    4,    3,    1,    0,    0,   -2,
      -3,   -4,   -5,   -5,   -6,   -6,   -6,   -5,   -4,   -4,   -4,   -3,   -2,   -2,   -1,    0,
       2,    3,    3,    4,    4,    4,    4,    3,    3,    3,    3,    2,    2,    1,    1,    1,
       0,   -1,   -1,   -2,   -3,   -3,   -3,   -3,   -3,   -3,   -3,   -3,   -3,   -3,   -2,   -2,
      -2,   -1,   -1,   -1,    0,    0,    0,    0,    1,    1,    1,    1,    1,    2,    2,    2,
       2,    1,    1,    0,    0,   -1,   -1,   -2,   -3,   -3,   -3,   -4,   -4,   -4,   -4,   -3,
      -3,   -2,   -1,   -1,   -1,    0,    1,    1,    1,    2,    2,    2,    3,    3,    2,    2,
       1,    1,    1,    0,    0,    0,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -5,  -41,  -25,  -37,   -9,   28,   14,    6,    1,
      19,   16,  -83,  -53,  -35,  -44,  -29,    8,  -23,  -29,   -6,  -20,  -22,  -19,  -40,   -2,
      14,   34,   78,   59,   73,   93,   73,   83,  124,   94,   87,   61,   98,   80,   29,   27,
       6,    8,   -9,   -8,  -26,  -33,  -35,  -32,  -25,  -32,  -28,  -59,  -46,  -31,  -19,  -12,
     -12,   14,   14,  -41,  -59,  -46,  -33,  -32,  -52,  -31,  -29,  -49,  -51,  -53,  -85,  -53,
     -60, -100,  -85,  -84,  -66,  -37,  -26,  -11,   -8,   22,   41,   33,   39,   27,   29,   75,
      59,   45,   52,   69,   66,   73,   90,   91,  103,   81,   46,   16,  -21,  -32,  -13,  -34,
     -22,  -42,  -51,  -35,  -53,  -62,  -45,  -35,  -34,  -29,   25,   62,   61,   39,   -8,  -20,
      -5,   -7,    2,   28,    1,  -24,    8,   29,   11,   -9,  -54,  -34,  -35,  -57,  -41,  -63,
     -50,  -16,  -18,   26,   23,   -2,   38,    9,   17,   41,   39,   82,   64,   64,  103,   64,
      43,   43,   51,   26,   -3,   30,    1,    9,   14,  -26,   20,  -27,  -50,  -39,  -47,  -31,
     -23,  -33,   25,   56,   51,   20,  -19,  -60,  -41,  -27,  -10,    3,  -36,  -30,  -22,  -46,
      -5,  -12,   -7,   -4,  -54,    3,  -25,  -10,   -1,  -42,  -75,  -27,  -84,  -60,  -88, -107,
     -73,  -29,  -67,  -53,    9,  -10,   17,  -29,  -33,   55,   12,    7,  121,   70,   42,  123,
      96,  127,   74,   28,   51,   21,   60,   23,  -10,   25,  103,  113,   65,   45,   15,   -1,
      10,    2,  -26,    1,  -16,   19,   27,   -8,   -8,  -24,  -20,  -17,  -35,  -86,  -87,  -32,
     -51,  -26,  -60,  -60,  -50,  -15,  -31,  -30,  -50,  -55,  -19,   22,   14,   30,   49,   42,
      15,  -11,  -57,  -15,  -29,  -65,  -37,  -56,  -29,   15,   70,   69,   36,   24,   19,   21,
      19,    4,   60,   55,   18,  -17,    0,   -2,  -21,   51,   49,   -6,   22,   14,  -24,  -63,
      -5,    4,  -53,  -33,   -1,  -37,  -34,   40,   30,   12,   -6,   -1,   12,   12,   23,   20,
      43,   34,   11,  -26,  -40,   25,   56,   -1,  -41,  -50,  -37,  -10,   20,  -58,  -65,  -43,
     -26,   42,   57,   77,   57,   26,   -4,  -10,  -57,  -45,  -23,  -49,   -1,  -59,  -41,  -26,
     -27,   24,   52,   -3,  -12,   19,  -44,  -31,   33,   11,  -14,   43,   31,    7,   58,   84,
      45,   35,   18,   -5,    6,  -21,   -6,  -20,   -7,   41,   53,   29,   25,   55,   68,   37,
     -29,  -17,  -41,  -67,  -76,  -90, -112, -104,  -60,  -21,   25,   16,  -23,   -9,   30,   47,
      17,    3,   19,    4,   -2,   30,   24,    1,   26,   33,   34,   10,   14,    1,   -5,   16,
      -2,  -60,  -32,  -51,  -48,  -38,  -34,  -42,  -20,   16,   17,  -16,  -32,   -6,    4,  -39,
     -18,    1,  -20,  -22,   55,   70,   34,    5,   -1,   13,    2,    1,   28,   20,  -31,   -2,
      51,   26,   24,   19,   11,   -1,    2,   30,   13,    2,   70,   36,   15,   24,    5,    9,
      14,   48,   43,    8,    2,  -10,   18,   33,   22,  -27,  -19,  -17,  -22,   11,   19,   -5,
       0,  -55,  -60,  -49,  -63,  -72,  -45,  -80,  -55,  -18,   -8,   32,   52,   22,    0,  -40,
     -42,  -30,  -68,  -51,   -9,  -67,  -52,  -10,    7,   35,   12,   36,   64,   23,   13,   64,
      39,   32,   73,    3,    6,  -10,   -6,   16,   18,   53,   51,   21,  -20,  -15,   13,   -3,
       2,  -39,  -30,   -7,   -3,    6,   10,   -4,  -25,   -7,  -10,  -10,  -18,  -31,  -23,  -38,
     -48,   -3,  -26,  -43,   -7,   11,   31,   62,   41,   -7,  -34,  -42,  -24,   17,   12,   44,
      25,   24,   18,   11,   32,   51,   46,   46,   51,   33,   24,   32,   30,   40,    8,  -30,
     -39,  -30,  -44,  -19,  -33,  -55,  -41,  -36,  -70,  -67,  -64,  -34,  -37,  -46,    1,   19,
      27,   81,   23,   13,   10,   -5,  -18,  -19,  -51,  -14,  -48,  -75,   11,   51,   43,   63,
      37,   20,   19,    4,  -23,   27,   47,   71,   29,   16,   15,  -17,  -11,   32,   40,   22,
       6,   16,   -7,    5,   34,   61,   12,  -21,  -24,  -13,  -38,  -41,  -36,  -33,    2,    9,
     -45,  -54,  -36,   12,  -18,  -41,  -25,  -18,   19,   31,  -11,  -16,  -22,  -62,  -65,  -68,
     -42,   -4,  -48,  -49,    4,   38,   65,   47,   12,  -20,  -20,   -8,    3,   32,   69,   84,
      44,   28,   31,   18,   36,   57,   74,   35,   19,    6,   24,   29,   36,   35,    6,  -13,
     -25,  -43,  -45,  -35,  -33,  -44,  -23,  -41,  -57,  -52,  -41,  -35,  -21,  -16,  -22,  -11,
      33,   42,   14,   19,   16,    0,   -6,  -34,  -17,  -37,  -25,   -7,    6,   48,   47,    3,
     -14,  -17,  -19,  -11,   -9,  -11,   42,   42,   16,    1,    6,   15,   51,   42,   33,   29,
      20,   -5,   -3,    4,   54,   42,    8,  -30,  -19,  -15,  -15,  -20,   -6,   -7,  -24,  -32,
     -24,  -17,   -1,  -16,  -18,  -36,  -55,  -38,   -2,    8,   16,    7,  -21,  -35,  -56,  -67,
     -17,  -58,  -67,  -36,   21,   67,   48,   15,    8,   13,   -9,   -8,   -1,   21,  107,   56,
      40,   56,   32,   33,   71,   60,   36,   30,    3,   31,   15,    4,   21,    2,   -2,  -25,
     -30,  -26,  -13,   -9,  -26,  -20,  -34,  -34,  -51,  -28,    6,   -9,  -24,  -49,  -67,  -54,
     -54,  -52,  -41,  -42,  -58,  -37,   16,   39,   31,   16,   19,   11,   -4,  -23,   -5,   24,
       1,   10,   24,   26,   15,   34,   70,   77,   56,   33,   43,   28,   17,   25,   12,    2,
       0,  -12,  -15,   -2,   10,  -19,  -28,  -45,  -41,  -28,  -17,   -3,   -2,   -9,   -3,  -25,
     -45,  -14,   23,   10,   -5,  -19,  -32,  -22,  -10,   -1,  -15,  -16,   -6,   13,   48,   70,
      55,   23,   23,   10,   -8,  -14,    6,    8,  -12,   -5,   13,   10,  -14,    0,   33,   23,
      18,   43,   21,   26,   33,   13,  -14,   -7,   -3,  -31,  -29,   -5,   -5,  -25,  -27,  -35,
     -56,  -45,  -21,  -17,  -40,  -14,    2,  -23,  -38,   -9,    8,  -16,  -16,   -7,  -13,  -25,
      -4,  -12,  -21,  -14,    3,   13,   44,   65,   60,   40,   15,    5,  -20,  -22,   -3,    3,
      20,   39,   39,    9,    6,   21,   48,   24,   25,   25,   11,    0,    4,   -5,  -31,  -34,
     -22,  -45,  -40,  -24,  -24,  -41,  -38,  -47,  -54,  -45,  -16,  -22,  -32,   -7,   16,   -1,
     -11,   23,   31,   -1,  -10,  -20,  -19,   -9,   15,  -10,  -28,  -21,    4,   24,   45,   60,
      56,   46,   30,   26,   23,   36,   48,   33,   46,   40,   34,   19,   12,   23,   43,   37,
      41,   43,   22,   24,   11,  -11,   -2,   -5,    8,  -28,  -33,  -11,   -5,  -26,  -30,  -25,
     -45,  -21,   -8,  -26,  -35,  -37,  -39,  -54,  -56,  -20,  -23,  -42,  -52,  -49,  -63,  -47,
     -31,  -29,  -16,  -21,   -7,   14,   26,   48,   32,   12,  -10,  -22,  -24,   -6,    0,   33,
      44,   31,   25,   15,   10,   34,   48,   38,   14,    9,   16,   12,  -23,  -15,  -15,   -8,
      -9,  -19,  -22,   -2,   -8,  -10,  -32,  -27,    4,   12,   -5,    1,   -1,    4,   -5,   -3,
      -5,   10,   37,   18,   -8,  -19,   -3,    0,  -10,   -5,  -31,  -32,  -29,   -2,   18,   32,
      33,   14,  -12,  -15,    6,    8,   36,   66,   48,   38,   37,   42,   29,   49,   50,   42,
      28,   25,   33,   15,    2,    4,    2,    4,    2,  -11,   -1,    6,    3,    9,  -14,  -12,
      -5,  -12,  -33,  -36,  -29,  -26,  -38,  -44,  -42,  -38,  -38,  -52,  -67,  -70,  -50,  -32,
     -27,  -29,  -38,  -26,  -27,    1,   21,   23,   16,  -17,  -34,  -26,  -18,  -20,    2,   11,
      13,    5,   10,   13,   12,   28,   33,   35,   14,   14,   14,   -8,  -24,  -25,   -8,  -16,
     -23,  -14,   12,    8,   21,   25,   13,   25,   29,   25,    6,    3,   36,   26,   34,   11,
      30,   29,   34,   23,    0,    1,    7,    8,    1,  -10,   -9,  -13,    5,   17,   30,   26,
      25,    3,  -11,   -4,   -4,    9,   13,   17,    6,    4,   17,   -1,   -4,    9,   16,   22,
       3,   -2,   -4,  -16,  -28,  -22,  -13,  -34,  -37,  -31,   -9,   -7,  -12,  -16,  -26,  -12,
     -14,  -11,  -23,  -16,  -24,  -33,  -24,  -30,  -17,  -28,  -34,  -44,  -51,  -34,  -24,  -22,
     -25,   -2,   14,   23,   38,   46,   43,   28,   10,   -6,  -11,    1,    0,    5,   18,   16,
      -3,   12,   27,   23,   32,   48,   42,   34,   21,   21,   10,   -3,  -10,  -10,  -20,  -38,
     -34,  -29,  -22,  -16,  -15,  -17,   -9,    7,    6,    6,   -6,    1,    7,    6,    3,   11,
      30,   30,   15,   11,   11,   10,   17,   22,   23,   24,    9,   15,    5,   -2,    4,    3,
     -17,  -21,   -4,  -21,   -6,    8,   -9,   -1,    0,    8,   -7,  -18,  -16,   -3,  -14,  -13,
      -8,  -17,  -10,   -8,  -26,  -37,  -28,  -17,  -35,  -17,  -10,    1,   -6,    1,   25,   32,
      26,    9,  -18,  -19,    1,  -12,  -20,    2,   12,    5,   -4,   15,   14,   15,   15,   17,
      14,    2,    6,    3,  -18,  -21,   -9,   -1,  -15,  -11,  -15,  -22,   -1,    3,   -7,    0,
      14,   14,   -4,  -13,    4,   18,   12,   15,   19,   25,   28,   27,   12,    9,    9,  -10,
     -17,   -4,   -5,   -4,  -20,  -19,   11,   20,   13,    0,  -19,   -8,    6,   -9,    6,   26,
      18,   14,   17,   22,   24,   18,   21,   37,   20,    7,   11,   -8,  -11,   -4,   -3,   -8,
     -22,  -16,  -18,  -15,   -4,   -9,  -21,  -10,    5,   -8,   -7,  -17,   -7,   -9,  -20,  -28,
     -35,  -31,  -23,  -23,  -29,  -28,  -28,  -33,  -28,  -24,   -6,    0,   -4,    7,   29,   25,
      15,   -6,  -19,    1,   -2,  -22,    4,   10,    1,    9,   10,   13,    4,    6,   21,   15,
       5,   21,   11,  -18,  -21,  -15,   -3,   -4,  -15,  -15,  -19,    4,   19,   11,    2,   17,
      16,    2,   14,   14,   17,   20,   22,   20,   10,   16,   27,   12,    8,   11,    5,   -9,
     -10,   -6,   -1,   -7,  -12,   -3,    3,    8,    9,   -5,   -3,    6,   -5,   -6,   23,   14,
      11,   12,   21,   21,    4,   18,   30,    7,   12,   25,    3,  -11,  -16,  -15,  -10,  -13,
      -8,   -6,  -21,    2,   -2,  -25,  -18,   -8,  -22,  -22,  -17,  -12,   -7,  -12,  -15,  -20,
     -41,  -28,  -24,  -23,  -12,  -12,  -15,  -10,   -7,    2,    1,    6,   18,   29,   23,   21,
      20,    9,   -3,   -9,   -9,  -10,  -15,   -8,  -11,   -2,    6,   14,    7,    7,   11,    9,
      14,    2,    3,    7,    6,    6,  -21,  -20,  -10,  -12,  -15,  -16,  -18,  -14,  -11,  -14,
       0,    0,   -5,    3,   14,   12,    9,    0,  -11,    5,    5,   12,   11,   -1,    5,    3,
       1,    4,   -1,   -1,   13,   16,    8,   14,    9,   -2,   -7,  -11,  -17,  -12,   -5,   -9,
     -10,  -13,   -4,    1,    0,    4,    5,    0,    2,    3,    5,   14,   18,    9,   -3,    2,
      15,   14,    6,    2,    1,   -1,   -5,   -6,    0,    0,    0,    7,   20,   22,   23,   13,
      13,   17,   20,   35,   25,   20,   20,   14,   17,   16,    3,    7,   18,   15,   13,   17,
       6,   -5,   -6,  -13,  -23,  -19,  -19,  -22,  -22,  -24,  -17,  -18,  -22,  -27,  -31,  -30,
     -29,  -30,  -33,  -36,  -34,  -37,  -47,  -38,  -24,  -28,  -27,  -31,  -30,  -28,  -26,  -20,
     -14,  -14,   -9,    4,   17,   21,   15,   12,   25,   29,   33,   33,   30,   30,   31,   19,
      20,   14,    4,   10,   17,   18,   21,   28,   19,   20,   20,    5,   -2,   -3,   -7,  -10,
      -2,    1,    4,    6,    4,    5,    3,    2,   -1,   -4,   -7,  -10,   -3,   -6,  -16,   -5,
      -1,   -8,   -7,   -6,   -9,  -10,  -11,   -7,   -6,  -10,  -11,    2,   11,    7,    1,    6,
      12,   16,   18,   15,   11,   14,   16,    9,   11,    6,    5,   13,   14,   13,   11,    0,
     -11,   -4,   -4,   -8,   -7,   -5,   -6,   -3,   -1,    2,   -1,   -6,   -7,   -9,   -9,   -9,
     -15,  -11,  -14,  -17,  -16,  -18,  -17,  -12,   -7,   -8,   -7,   -6,   -2,   -3,  -12,  -15,
     -15,  -18,  -13,  -19,  -23,  -24,  -21,  -21,  -13,  -12,   -7,   -3,   -7,   -6,   -4,    2,
       1,    1,    3,    9,   23,   28,   23,   17,   24,   27,   22,   19,   16,   19,   10,    9,
      10,   10,   19,    8,   11,   16,   15,   11,   13,   14,    7,    5,   -3,   -7,  -12,  -15,
     -16,  -17,  -10,   -5,    4,   -2,   -2,   -9,  -13,   -9,   -8,  -10,  -10,  -12,   -5,    3,
       7,    3,    9,    3,    4,   -1,   -2,    2,   -4,   -9,   -4,    0,    4,    4,   -6,   -3,
      12,   10,   15,   12,    7,    7,    1,   -1,    8,   11,    9,    9,   13,   17,   17,    9,
      11,    4,    0,   -3,   -6,   -8,   -9,  -10,  -17,  -20,  -24,  -17,  -19,  -22,  -20,  -21,
     -15,  -16,  -19,  -23,  -21,  -28,  -26,  -15,  -14,   -4,   -1,   -6,   -3,   -1,    4,    9,
       2,    4,    7,    7,   11,   15,    6,   17,   24,   16,   15,    9,    6,    6,    3,    1,
       3,    2,   -2,    6,    6,    6,    3,   -6,   -3,   -8,   -7,  -10,  -13,  -17,  -18,  -16,
     -19,  -13,   -9,   -3,    4,   10,    7,    7,   12,   11,   13,   10,    6,    1,    2,    4,
       4,   10,   10,    7,    4,    1,    4,   -5,  -12,   -3,    1,   10,    7,    6,    4,   19,
      22,   20,   23,   16,   15,   19,   17,   14,    9,    7,    4,    4,    2,    5,    3,    0,
       0,   -7,   -7,   -8,   -7,  -14,  -15,  -18,  -25,  -21,  -21,  -16,  -13,  -14,  -17,  -18,
     -23,  -21,  -23,  -29,  -32,  -33,  -30,  -23,  -13,  -11,  -10,   -8,   -7,   -2,    1,   -3,
      -1,    5,   13,   17,   13,   11,   13,   16,   14,   10,   11,    8,   16,   13,    4,    0,
       7,   13,   14,   15,   15,   17,   17,    9,    8,    9,    9,    2,    5,   11,   14,    7,
       4,   11,   10,    5,    7,    2,   -1,   -4,   -9,  -16,  -15,  -12,   -9,  -15,  -23,  -21,
     -22,  -22,  -20,  -22,  -22,  -21,  -22,  -22,  -13,   -6,    4,    2,   -2,    2,    7,    6,
      10,    8,    9,   12,   21,   16,   11,    7,   11,   13,   11,   10,   11,   13,    9,    6,
       6,    5,    4,   -5,    1,    4,    5,   -1,   -2,    6,    3,    3,   -3,  -10,  -14,  -14,
     -14,  -16,   -8,   -6,   -1,   -6,   -7,   -5,   -7,   -6,   -9,   -8,   -8,   -4,   -5,   -8,
      -6,    3,   12,    4,   -2,    3,    1,    1,   -1,   -4,   -4,    5,    6,    1,   -4,   -3,
       5,    9,    8,   18,   20,   22,   15,   11,   11,   15,   12,    9,   11,   11,   11,    5,
      10,   12,    5,    3,   -2,   -4,   -9,   -9,  -16,  -17,  -14,  -12,  -14,  -20,  -15,  -16,
     -17,  -17,  -19,  -20,  -19,  -15,  -17,  -15,  -13,   -2,   -3,  -13,   -8,    0,    4,    7,
       6,    4,   11,   13,   14,   11,    5,    6,    3,   -1,   -2,    2,    3,   -1,   -2,   -6,
      -4,   -1,   -3,    0,    3,    1,   -2,   -5,   -5,   -3,   -6,   -9,   -7,  -15,  -13,  -10,
      -8,   -4,    1,    9,    7,    2,    8,    8,    9,   12,   14,    7,   12,   12,   12,    8,
      14,   19,   11,    7,   10,   13,   10,    2,   -2,   -6,   -1,    2,    6,    3,    1,    4,
       2,    2,    5,    8,    8,    7,    7,    2,    0,   -3,   -6,   -3,   -1,   -6,  -12,   -9,
      -6,   -7,   -9,  -10,  -14,  -16,  -12,  -12,  -11,  -13,  -16,  -16,  -20,  -18,  -14,  -10,
      -8,   -9,  -13,   -9,   -8,   -9,   -7,   -9,   -8,   -3,   -4,   -3,   -6,    0,    2,    3,
      -3,    2,    5,    1,    6,    5,    5,   10,   11,   17,   15,   20,   25,   20,   15,   17,
      13,   12,   11,    7,    4,   -1,   -2,    6,    7,    7,    9,   10,    7,    9,    7,    5,
       5,    1,   -6,   -2,   -5,   -6,   -3,   -3,   -1,   -3,   -5,   -3,   -6,   -8,   -7,   -8,
     -11,  -12,  -16,  -19,  -19,  -14,  -14,  -17,  -17,  -11,  -12,  -15,   -6,   -8,  -12,  -12,
      -9,   -7,   -6,    2,    9,    6,    8,   11,   13,   15,   14,   11,    7,    3,    3,    4,
       7,    9,   10,    6,    6,    5,    7,   11,   11,    4,    1,    1,   -3,   -5,   -1,   -1,
      -1,   -5,   -2,   -1,   -1,    1,    1,   -3,   -7,   -7,   -9,  -12,  -11,   -3,   -3,   -7,
      -6,   -6,   -5,   -5,    0,   -3,   -4,   -2,    2,   -1,    0,    6,    7,    7,    4,    3,
       5,   -1,    0,   -1,   -7,   -9,   -8,  -11,   -5,    0,   -1,    0,    2,    2,    5,   10,
      10,    7,    7,    7,    8,    8,    9,   11,    9,    8,    9,    6,    4,    2,    0,   -3,
      -5,   -8,   -8,  -12,   -8,   -1,   -4,   -4,   -5,   -7,   -9,   -6,   -5,   -6,   -8,   -6,
      -3,   -7,    0,    5,    6,    3,    1,    6,    6,    4,    3,    1,   -2,   -4,   -6,   -4,
       3,    7,    3,    0,   -1,   -3,   -2,   -1,   -2,   -5,   -8,   -9,   -7,   -9,   -8,   -6,
      -9,   -7,   -9,   -7,   -6,   -7,   -6,   -7,   -7,   -7,   -7,   -8,   -2,    1,    2,    4,
       3,    5,    6,   10,   11,    9,   10,   12,    9,    9,   11,    9,   10,    8,    7,    7,
       6,    7,    5,    4,    5,    4,   -1,   -4,   -3,   -5,   -1,   -2,   -4,   -4,   -4,   -4,
      -2,   -2,   -3,   -4,   -2,   -1,    0,    1,    8,    8,    4,    4,    4,    2,   -2,   -3,
      -5,   -6,   -9,  -10,   -8,   -5,    2,    1,   -2,   -2,   -2,   -2,   -2,   -5,   -5,   -7,
      -7,   -3,   -4,   -6,   -4,   -3,   -5,   -7,   -5,   -4,   -7,   -9,   -6,   -6,   -9,   -7,
      -6,   -2,    3,    3,    4,    5,    3,    4,    5,    2,    0,    2,    3,    2,    5,    7,
      10,    9,    7,    7,    6,    4,    1,   -2,   -5,   -6,  -10,  -10,   -8,    2,    8,    7,
       6,    7,    5,    5,    7,    6,    3,    4,    3,    4,    1,    3,    2,    4,    2,    1,
       1,   -1,   -3,   -3,   -4,   -6,   -9,   -9,   -9,   -7,   -6,   -5,   -5,   -4,   -5,   -2,
      -1,   -2,   -3,   -1,   -1,   -3,   -2,    2,    2,    3,    4,    4,    2,    0,   -1,   -3,
      -4,   -4,   -5,   -7,   -2,    2,    2,   -1,   -3,   -1,   -4,   -3,   -2,   -4,   -4,   -2,
      -1,   -2,   -4,   -2,   -2,   -1,   -2,   -2,   -2,   -3,   -2,    0,    2,    0,   -2,   -2,
       0,    2,    3,    5,    4,    4,    4,    6,    3,    1,    0,    0,    0,    0,    5,    5,
       4,    6,    4,    2,    0,   -2,   -3,   -6,   -9,   -8,  -10,  -10,   -2,    3,    4,    4,
       4,    5,    4,    4,    5,    4,    4,    4,    4,    2,    3,    2,    2,    2,    1,    1,
       0,   -2,   -3,   -3,   -4,   -6,   -8,   -7,   -4,   -6,   -3,   -3,   -3,   -2,    1,    0,
      -1,   -2,   -2,   -1,   -1,    0,    1,    0,    0,    1,    0,    0,    0,   -1,   -2,   -3,
      -3,   -4,   -5,   -4,   -3,   -3,   -3,   -3,   -3,   -3,   -2,   -1,    0,   -1,    0,    0,
       1,    1,    1,    1,    1,    1,    0,    0,    1,    1,    1,    1,    0,    1,    2,    3,
       3,    2,    2,    0,   -1,   -1,   -2,   -3,   -3,   -4,   -5,   -4,    0,    3,    3,    3,
       3,    2,    3,    4,    6,    4,    4,    3,    2,    1,    2,    1,    0,    0,   -1,   -2,
      -3,   -3,   -2,   -2,   -3,   -3,   -3,   -3,   -3,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
      -2,   -3,   -2,   -3,   -2,   -2,    0,    0,    0,    0,    0,   -1,   -1,   -2,   -2,   -3,
      -2,   -4,   -4,   -3,    0,   -1,    0,    0,    0,    0,    0,    1,    2,    1,    1,    1,
       0,    0,    0,   -1,    0,   -1,   -1,   -1,   -1,   -1,    0,    0,   -1,    0,    0,    0,
       1,    1,    1,    1,    1,    1,    0,    0,    0,   -1,    0,   -1,    0,    0,    0,    0,
       0,    0,   -1,   -1,   -2,   -2,   -2,   -2,   -2,   -3,   -3,   -1,    0,    0,    0,    0,
       0,    0,    0,    1,    1,    1,    0,    0,    0,   -8,  -33,  -24,  -25,  -25,  -26,  -27,
     -32,  -28,  -36,  -31,  -36,  -22,  -34,   11,  -74,  -14,   94,   41,   28,   33,   30,   40,
      34,   23,   41,   40,   60,   56,   59,   60,   44,   39,   54,   45,   52,   17,   44,   62,
      34,   33,   19,   18,   43,   35,   22,   36,  -15,  -10,   32,   -7,  -12,   -6,   -8,  -50,
     -47,  -44,   -4,  -25,  -48,  -76,  -58,  -75,  -96,  -85, -118, -114,  -63, -106, -103,  -83,
    -110,  -99,  -84,  -76,  -58,  -63,  -61,  -51,  -53,  -36,  -32,  -41,  -27,  -11,   11,    8,
      27,   19,   30,   35,   28,   57,   53,   38,   71,   51,   68,  110,   78,   89,  109,   97,
      82,   94,  115,  114,   79,   70,   79,   94,   85,   76,   84,   95,   83,   82,   55,   54,
      54,   41,   41,   27,   20,    6,  -11,  -21,  -16,  -14,  -33,  -33,  -52,  -54,  -59,  -62,
     -71,  -79,  -88,  -88,  -78,  -78,  -72,  -71,  -94,  -99,  -93,  -90,  -78,  -87, -105, -103,
     -79,  -62,  -71,  -78,  -63,  -61,  -66,  -49,  -23,  -10,  -11,  -24,  -20,   -4,  -22,    9,
       8,   27,   43,   34,   38,   51,   83,   65,   58,   74,   75,   70,   73,   71,   65,  100,
      89,   94,   65,   84,   49,   49,   61,   54,   43,   51,   58,   53,   35,   40,   36,   38,
      34,   23,   14,  -12,  -10,   -1,   -1,  -11,  -12,  -19,  -33,  -66,  -52,  -42,  -37,  -55,
     -42,  -28,  -32,  -29,  -35,  -41,  -28,  -25,  -46,  -85,  -64,  -62,  -55,  -49,  -68,  -55,
     -53,  -52,  -47,  -43,  -26,  -32,  -41,  -34,  -35,  -40,  -26,   -8,   -1,   -6,  -11,    5,
      -2,    8,    3,    8,    6,    4,   20,   29,   43,   24,   33,   20,   30,   24,   39,   38,
      40,   29,   37,   36,   39,   61,   58,   41,   51,   59,   51,   55,   58,   48,   32,   45,
      40,   27,   30,   41,   44,   26,   19,   23,   -3,    7,    0,   -3,    2,    3,   -6,   -5,
     -14,   -6,  -10,  -27,  -45,  -47,  -41,  -38,  -50,  -51,  -46,  -43,  -45,  -65,  -65,  -80,
     -95,  -82,  -74,  -66,  -69,  -67,  -33,  -31,  -53,  -48,  -51,  -43,  -18,  -24,  -24,  -33,
     -26,  -10,    0,  -17,   -6,   17,   31,    2,   23,   45,   46,   12,   75,   38,   63,   69,
      31,   38,   80,   57,   48,   59,   81,   74,   32,   52,   72,   24,   60,   44,   55,   40,
      28,   48,   33,   24,   10,   -2,   21,   34,   13,   18,    7,   -1,  -12,  -20,  -18,  -30,
      -9,   -7,  -30,  -27,  -26,  -38,  -20,  -54,  -55,  -64,  -53,  -36,  -62,  -37,  -71,  -47,
     -42,  -71,  -45,  -55,  -50,  -54,  -56,  -36,  -37,  -54,  -36,  -12,  -38,  -33,  -26,   -7,
     -22,  -44,  -10,    2,    3,   15,    8,   18,    6,   12,    8,   15,   28,   22,   50,   35,
      55,   42,   36,   49,   52,   64,   48,   60,   49,   60,   62,   40,   47,   68,   52,   59,
      61,   44,   53,   44,   35,   31,   31,   47,   22,    6,    4,   -7,    5,   -4,  -21,  -13,
      -9,  -10,  -27,  -46,  -32,  -44,  -46,  -62,  -44,  -51,  -67,  -53,  -59,  -63,  -74,  -67,
     -61,  -61,  -65,  -47,  -58,  -57,  -45,  -41,  -46,  -41,  -38,  -22,  -25,  -34,  -16,  -10,
     -18,    0,    1,   -6,    5,   17,   15,   10,   23,   38,   28,   28,   54,   40,   19,   55,
      55,   41,   46,   53,   40,   49,   51,   52,   41,   56,   39,   53,   38,   33,   35,   18,
      15,   38,   30,   23,   27,   13,   11,    7,   16,   -1,    0,    0,   13,   -6,  -10,  -15,
     -10,  -10,  -24,  -20,  -16,  -38,  -36,  -21,  -40,  -32,  -42,  -38,  -52,  -53,  -41,  -48,
     -58,  -50,  -47,  -37,  -41,  -45,  -29,  -41,   -6,  -48,  -24,  -25,  -15,   -9,  -10,  -10,
     -10,   -1,  -17,    4,    3,   10,   -4,    9,   15,   25,   24,   19,   23,   34,   28,   33,
      37,   38,   26,   36,   47,   35,   46,   45,   28,   35,   32,   32,   24,   21,   26,   23,
      19,   37,   20,    9,   29,   -2,   26,   24,    8,    4,   14,   21,   11,   -9,   -8,    4,
      -9,  -31,  -11,  -15,  -21,  -24,  -29,  -22,  -33,  -26,  -29,  -48,  -32,  -44,  -28,  -22,
     -35,  -30,  -38,  -31,  -46,  -44,  -36,  -27,  -23,  -29,  -24,  -11,  -20,  -28,  -13,  -34,
     -19,   -1,    7,   -3,   -1,    6,   -3,    5,    4,    8,   17,   26,   19,   33,   27,   16,
      35,   14,   36,   39,   22,   32,   31,   19,   32,   23,   29,   21,   30,   29,   23,   31,
      13,   24,   17,   11,   26,   18,   12,    5,   23,   16,    9,   15,  -10,    3,   18,  -15,
      -4,   -4,    6,  -14,  -15,   -5,  -34,  -11,  -20,  -18,   -8,  -17,  -29,  -30,  -29,  -19,
     -34,  -35,  -20,  -36,  -20,  -16,  -21,  -38,  -16,  -30,  -24,  -25,  -19,  -18,  -15,   -7,
      -5,   -5,  -10,  -23,   -3,  -14,    0,   -1,  -12,   -9,    7,    7,    2,   12,    5,    7,
      19,   10,   21,   21,   27,   30,   22,   18,   34,   22,   11,   26,   24,   20,   21,   25,
      29,   22,   27,   27,   20,   10,   20,   16,   22,   15,   16,   16,    5,   19,   10,    3,
      22,   -5,   -5,   -7,  -16,   -4,  -11,  -22,   -7,  -16,  -11,  -23,  -16,  -30,  -24,  -28,
     -20,  -29,  -24,  -32,  -22,  -22,  -30,  -17,  -23,  -28,  -22,  -20,  -21,  -21,  -17,  -30,
     -15,  -14,  -20,   -9,    3,    6,    5,  -20,   10,   13,   -2,   11,    8,   -1,    7,   16,
       5,   22,   23,   13,   22,   13,   22,   25,   15,   16,   11,   15,   13,    7,   12,   19,
      18,   20,   12,   23,   11,    6,   10,    1,   11,   19,    5,   20,    0,   11,   11,    1,
      14,   15,   -3,   -1,   -7,    6,   -6,   -9,   -9,    4,   -3,  -10,  -20,  -14,   -9,  -14,
      -7,  -10,   -5,   -4,  -29,  -14,  -12,  -26,  -21,  -27,  -18,  -10,  -19,  -27,  -18,   -8,
     -25,   -8,  -13,  -15,  -14,  -15,    5,  -13,   -7,  -11,   -4,  -12,    0,   15,    5,    4,
       1,   11,    6,    4,    3,    6,   21,   19,    8,   15,   13,    6,   14,   16,   18,   17,
      20,   15,   11,   15,   24,   13,   11,   19,    7,   17,   14,    6,   17,    7,    7,    6,
       6,    5,   11,    0,    6,    0,   -6,    5,    1,  -11,   -6,   -1,   -8,   -9,  -15,   -7,
      -4,  -16,  -17,  -13,  -13,  -17,  -14,  -12,  -12,  -28,  -13,  -19,  -25,  -31,  -24,  -17,
     -17,  -16,   -7,  -15,  -12,   -8,  -15,   -8,  -16,  -10,   -4,   -1,   -2,    3,    5,    2,
      -2,    5,    3,    6,   10,    8,   11,   14,   14,   13,   15,   22,   16,   14,   18,   13,
      17,   19,   16,   10,   17,    8,   17,   14,    3,   14,    7,   10,   10,    7,    6,    6,
      -1,    6,    1,    0,   12,   -6,    6,   12,   -4,   -5,   -4,   -2,   -2,   -1,   -2,   -8,
     -11,   -9,  -11,  -11,  -18,   -6,   -5,  -16,   -9,  -14,  -10,  -13,  -10,  -11,  -15,  -14,
     -14,  -12,  -17,  -17,  -17,   -7,  -11,  -14,  -15,  -12,   -6,  -15,   -5,  -13,   -9,    0,
      12,   -2,   -2,    6,    2,   -7,    4,   10,    2,    9,    8,    7,    4,    5,   11,   15,
      11,   10,   18,    9,   13,   13,   13,   21,   11,   18,   19,   13,   14,   16,    6,    8,
       1,   19,   11,   10,   11,    1,    3,   -1,   -1,    5,  -11,    5,   -1,   -5,   -3,  -13,
     -10,   -6,   -7,   -5,  -15,  -10,  -11,  -18,   -8,  -16,  -20,  -18,   -9,  -12,  -17,  -21,
     -21,  -13,  -21,   -8,  -10,  -10,   -5,  -16,   -7,    2,   -6,   -6,   -9,   -7,   -2,   -9,
      -5,    6,   -7,    1,    3,   -1,    2,    1,    2,    9,    8,    5,   15,   12,    1,   11,
       9,    8,   10,   15,   14,    5,   13,   17,   14,   15,   10,    7,   16,    5,    5,    5,
       8,    9,   10,   10,    7,    0,    4,    6,    9,  -10,   -4,    5,    2,   -1,    0,   -3,
      -4,   -5,  -10,   -5,   -8,   -9,  -10,   -3,  -13,   -6,   -9,  -20,  -15,  -11,  -18,  -14,
     -10,  -12,  -20,  -14,  -14,   -7,  -12,  -21,  -14,   -9,   -8,  -11,   -5,   -2,   -7,   -4,
       4,   -2,   -3,   -1,    0,   -1,    8,    6,    9,    7,   10,    6,    3,    4,    7,   10,
      11,    6,    9,   17,   11,    9,    7,   -2,   16,   13,   12,   18,    5,   16,    9,    4,
       9,    6,    8,    9,    4,    4,    3,   -2,   -3,    2,   -6,   -3,    1,   -7,   -6,   -3,
      -6,  -14,   -8,   -9,   -4,  -13,   -9,   -8,  -16,  -10,  -12,  -13,  -11,   -7,   -8,  -12,
      -9,   -8,   -7,  -11,   -4,   -8,   -7,   -8,   -3,  -13,  -10,   -3,    6,   -5,   -5,    0,
      -5,   -3,    6,   -2,   -2,    4,   -2,    6,    2,   -2,    5,    5,   -2,    5,   15,   13,
       4,    6,    6,   14,    9,    4,    8,    7,    3,   11,   12,    2,   10,    7,   10,    8,
       4,    6,    2,    0,    3,    2,    4,    2,   -6,   -2,    2,   -4,    3,   -5,   -6,   -5,
      -5,   -5,   -4,   -8,   -7,   -4,   -4,   -7,   -8,   -7,  -13,  -10,  -10,  -11,   -9,   -8,
      -8,   -7,  -11,   -7,   -3,   -9,   -6,   -7,   -3,   -4,   -5,    3,   -3,   -1,   -2,   -4,
       1,    4,    0,    3,    0,    5,    2,    0,    5,    4,    1,    3,    1,    0,    1,    7,
       3,    0,    4,    3,    6,    5,    0,    9,    5,    7,    6,    3,    6,    2,    3,    5,
      -4,    9,    0,    4,   10,    0,    5,    1,   -2,    4,   -3,   -3,   -2,    0,    2,   -7,
       3,  -10,   -1,   -6,   -9,   -2,   -4,  -10,   -3,   -7,   -6,   -4,  -10,   -6,   -6,  -11,
      -6,    0,   -6,   -8,   -4,   -1,   -9,  -10,    0,   -6,   -7,   -2,   -7,    1,   -5,   -5,
      -1,    1,   -6,    2,    0,   -3,   -1,    7,   -4,    0,    7,    0,    8,    2,    3,    4,
       4,    2,    5,   -1,    6,    7,    5,    6,    4,    2,    4,    6,    8,    6,    3,    1,
       8,    9,    2,   -1,    4,    3,    4,    3,   -3,    7,    4,    3,   -2,    2,   -4,   -6,
      -2,   -5,   -2,   -3,    0,   -5,   -6,  -13,   -5,   -6,  -11,   -9,  -10,   -5,   -4,   -9,
      -9,   -7,   -7,   -8,   -8,   -6,   -5,   -7,   -5,   -1,   -3,   -4,   -2,   -2,    2,   -3,
       1,    2,   -3,    1,    2,    1,    0,    1,    5,    0,    2,    5,    2,    0,    4,    1,
       7,    3,    2,    6,    0,    5,    7,    5,    5,    1,    3,    3,    5,   10,    3,    4,
       8,    2,    7,    3,   -2,    3,    0,   -1,   -1,    1,    0,    1,   -3,   -2,   -5,   -4,
      -3,   -1,   -7,   -8,   -4,   -4,  -10,   -2,   -8,   -8,   -8,   -8,   -9,   -6,   -8,   -9,
      -4,   -2,   -7,   -5,   -2,   -7,   -6,   -9,   -2,    0,   -4,    4,   -6,   -3,   -4,   -1,
       2,    1,    2,    9,    0,    3,    0,    6,    4,    0,    5,    6,    2,    7,    7,    5,
       7,    6,    8,    6,    6,    5,    5,    1,    6,    5,   -1,    3,    4,   -1,    4,    1,
       4,    3,   -5,    0,    4,    1,    4,   -2,   -3,   -4,    0,   -4,   -8,   -2,   -5,   -4,
      -8,   -6,   -5,   -3,   -3,   -7,   -9,   -6,  -10,  -10,   -6,   -6,   -5,   -4,   -7,   -6,
      -4,  -10,   -3,  -10,    0,   -2,   -2,   -6,   -1,    3,   -3,   -3,    1,    2,    1,    4,
       3,    4,    3,    4,    1,    2,    6,    5,    5,    5,    7,    9,    1,    5,    4,    4,
       7,    2,    9,    2,    4,    8,    2,    5,    6,    3,   -2,   -2,   -1,   -2,   -1,    1,
      -2,   -4,    1,   -6,   -2,   -5,   -3,   -5,   -5,   -6,   -4,   -3,   -4,  -10,   -4,   -3,
      -8,   -4,    0,   -3,   -5,   -6,   -6,   -3,   -1,   -7,   -3,    1,   -1,   -4,   -2,    1,
      -2,    0,   -1,   -2,    0,    0,    5,   -2,    0,    3,    3,    1,    5,    2,    4,    1,
       4,    1,    2,    3,    3,    3,    4,    3,    3,    5,    1,    4,    2,    3,    1,    2,
       0,    2,    1,   -2,   -2,   -1,    0,   -2,   -1,   -1,   -3,   -5,   -2,    0,   -5,   -1,
       0,   -5,   -2,   -2,   -2,   -3,   -3,   -1,   -4,   -1,   -2,   -4,   -2,   -1,   -2,   -1,
       0,   -3,   -1,   -1,    0,    1,   -1,   -1,    3,   -4,   -2,   -2,    4,   -2,   -1,   -1,
      -1,    0,    0,   -1,   -1,   -1,   -1,    2,    0,   -1,    2,   -1,    0,   -1,    2,    0,
       3,    5,   -2,    1,    2,    0,    5,    0,   -3,    4,   -3,    1,    2,    0,    4,   -1,
      -2,    1,    0,    0,    0,   -1,    1,   -2,    0,    1,    1,    0,   -5,    1,   -2,   -1,
       0,   -2,   -3,   -1,   -3,    0,   -2,   -3,   -4,    1,   -2,   -3,   -2,   -2,   -1,   -1,
      -2,   -1,   -4,   -5,    2,   -4,    0,    1,   -1,    2,   -2,   -1,    0,    0,    1,   -3,
       3,    2,    0,   -2,    2,    1,    2,   -2,    5,    3,   -2,   -2,   -1,    1,    0,    0,
       1,    3,    2,    0,    0,   -1,   -2,    1,    1,    2,    1,    1,   -1,    0,   -1,   -1,
      -1,   -3,    1,    1,    2,   -2,   -1,    0,    0,   -2,    0,   -1,   -1,    2,   -2,    1,
      -1,    0,    0,   -1,   -1,   -2,    0,   -1,    1,   -1,   -1,    2,   -2,    0,   -1,   -1,
       2,   -1,    0,   -3,   -1,    0,    0,    0,   -3,   -3,   -2,    0,    0,   -1,   -1,    0,
      -4,    2,    0,   -2,    0,    1,   -3,   -1,    2,    1,    0,   -1,    0,    0,   -1,    0,
       2,   -1,   -1,    0,    0,   -2,    1,    1,    0,    1,    0,    2,   -3,   -2,    2,   -1,
      -1,    2,   -2,    1,    1,    0,    0,    1,    1,    0,   -4,    3,   -1,    2,    0,    2,
      -1,   -2,    0,    1,    1,   -1,   -1,   -1,   -1,   -1,   -2,   -2,   -2,   -2,   -2,   -1,
      -1,    1,    0,   -5,    0,   -1,   -1,   -1,    1,   -1,    1,   -1,    1,    0,   -2,    0,
      -2,    1,   -1,    1,    0,   -1,   -2,    0,   -1,    0,    0,    2,    0,    0,    0,    1,
       0,    0,    2,    0,   -1,    0,    0,    0,    2,   -1,    1,    1,   -1,   -1,    0,    0,
       1,    1,    0,    0,    0,    0,   -1,    0,    0,   -2,    0,    0,   -1,    1,   -2,   -1,
      -1,   -1,   -2,   -1,   -2,    1,   -1,    0,   -2,   -2,    1,   -2,   -1,    1,    0,    1,
       1,   -1,   -1,    0,   -1,    0,    0,    0,   -2,    0,   -1,    0,    0,   -1,   -2,   -2,
      -2,    1,   -1,    0,    0,   -1,    1,    1,   -2,   -1,   -2,   -1,    1,   -1,   -1,   -2,
      -2,    0,    0,    1,   -1,   -1,   -1,   -1,   -2,    2,    0,    0,    1,    1,    1,   -2,
       0,   -1,    0,   -1,   -1,    2,    0,   -1,   -1,   -1,    1,   -1,    2,    0,   -1,    1,
       1,    0,    1,    0,   -1,   -1,   -1,   -1,   -3,    0,    0,   -1,    1,    0,    0,   -2,
      -2,   -2,    0,   -1,    0,    0,   -1,    0,   -1,   -2,   -1,   -2,    0,   -2,    0,    0,
      -1,   -2,    1,   -2,    0,   -1,   -2,    2,    0,   -1,    2,   -1,    1,   -1,    0,    0,
      -1,    0,    0,    0,   -1,    0,    1,    0,    0,    1,    0,   -1,   -1,    0,   -2,   -1,
       0,    0,    1,    0,    0,    0,    0,   -1,   -1,    1,   -1,   -2,   -1,    0,    0,   -2,
       0,   -1,    0,    0,    0,    1,    0,    0,   -1,    1,    0,   -1,    0,    1,   -1,    0,
      -1,   -2,    0,   -1,    0,   -1,   -1,   -1,    0,   -1,    0,    0,    0,   -1,   -1,    0,
      -2,    0,    0,    0,   -2,   -2,    0,   -2,   -1,   -1,   -1,   -2,    0,   -1,   -1,   -1,
       0,    0,   -1,   -1,    0,    1,   -1,   -1,    0,   -1,    0,    0,    1,    1,    0,    0,
      -1,    0,    0,    0,    0,    0,    1,   -1,    0,    0,    0,    1,    0,    0,   -1,    0,
       0,   -1,   -1,    0,   -1,   -1,    0,   -1,    0,   -1,   -1,    0,   -2,   -1,    0,   -1,
      -1,   -1,   -1,    0,   -1,    0,    0,    0,    0,   -1,    1,    0,    0,    0,   -1,   -1,
       0,   -1,   -1,    0,    0,    0,    0,    0,   -1,   -1,    0,   -1,   -1,    0,    0,   -1,
       0,   -2,    0,   -1,   -1,   -1,    0,   -1,   -1,    0,   -1,    0,    0,    0,   -2,   -1,
       0,   -1,   -1,    0,    1,   -1,   -1,    0,    0,    0,    0,   -1,   -1,   -1,   -1,    0,
       1,    0,    0,    0,    0,    0,   -1,    0,    0,    0,    0,    0,    0,   -1,    0,    0,
      -1,    0,    0,   -1,   -1,   -1,    0,    0,   -1,   -1,    0,   -1,    0,    0,    0,   -1,
       0,   -1,   -1,    0,   -2,   -1,   -1,   -1,    0,   -1,    0,   -1,   -1,    0,    0,   -1,
       0,   -1,    0,   -1,   -1,   -1,    0,   -1,    0,   -1,    0,    0,   -1,    0,   -1,    0,
       0,   -1,   -1,    0,    0,    0,   -1,    0,   -1,    0,    1,   -1,    0,    0,    0,    0,
       0,   -1,    0,    0,    0,   -1,    0,    0,   -1,   -1,    0,    0,    0,   -1,    0,    1,
      -1,   -1,   -1,    0,    0,   -1,   -1,   -1,   -1,    0,   -1,    0,    0,    0,    0,    0,
       0,   -1,   -1,    0,   -1,   -1,    0,   -1,    0,   -1,   -1,   -1,   -1,    0,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,    0,   -1,    0,   -1,    0,    0,   -1,   -1,    0,   -1,    0,
      -1,    0,    0,   -1,    0,   -1,   -1,   -1,    0,   -1,    0,    0,    0,    0,    0,   -1,
      -1,    0,    0,    0,    0,    0,    0,    0,    0,   -1,    0,    0,   -1,    0,    0,    0,
       0,   -1,    0,   -1,    0,    0,    0,   -1,   -1,    0,    0,   -1,   -1,   -1,   -1,   -1,
      -1,   -1,   -1,   -1,    0,    0,   -1,   -1,   -1,    0,    0,    0,   -1,    0,   -1,   -1,
       0,   -1,    0,    0,   -1,   -1,   -1,   -1,   -1,    0,    0,   -1,    0,    0,   -1,    0,
       0,    0,    0,    0,    0,    0,   -1,    0,    0,    0,    0,   -1,    0,    0,    0,    0,
      -1,    0,    0,    0,    0,   -1,    0,    0,   -1,    0,   -1,    0,    0,   -1,   -1,   -1,
       0,   -1,   -1,    0,   -1,   -1,    0,    0,   -1,   -1,   -1,   -1,    0,   -1,   -1,    0,
       0,   -1,    0,    0,    0,   -1,   -1,    0,   -1,   -1,   -1,    0,    0,   -1,   -1,   -1,
      -1,   -1,    0,   -1,    0,    0,   -1,   -1,    0,    0,   -1,    0,    0,   -1,   -1,   -1,
       0,   -1,    0,    0,   -1,   -1,    0,    0,   -1,   -1,    0,    0,    0,   -1,    0,    0,
       0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,   -1,   -1,
       0,    0,    0,   -1,    0,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -4,   11,    6,   16,   10,  -16,  -48,
     -44,    2,   67,   42,  -17,  -51,   15,   71,   12,  -22,  -14,  -44,  -35,   11,   17,  -18,
       2,  -15,   19,   12,   -1,  -44,  -15,   50,   45,  -25,  -61,   17,   10,  -10,   31,   18,
     -72,  -27,   57,   26,  -13,  -17,   -2,    6,   -1,  -23,  -54,   17,   39,    8,   30,   28,
      -6,  -71,   -5,   33,   27,   -5,   17,   10,  -23,   -6,   12,  -26,   -6,   -7,   -9,  -14,
      11,   37,   41,    8,  -33,  -14,    8,  -31,  -38,   13,    9,   15,   35,   33,   11,   17,
     -41,  -48,  -33,   29,   25,   16,   -9,   -9,  -17,  -19,  -29,   43,   64,   -2,  -55,  -42,
      -1,  -21,   -4,   29,   34,  -25,  -67,  -29,    1,   51,   49,   25,   -6,  -15,  -48,  -76,
      -3,   60,   78,   33,   19,   13,  -38,  -35,  -35,   -2,   62,   19,   -4,  -12,   -4,   -4,
     -32,  -30,    8,   68,  -43,  -66,  -28,   55,   51,   20,  -28,  -29,  -19,   20,   -2,    8,
      21,  -15,  -43,   24,   22,   -7,   -2,   35,   15,   -2,  -24,  -12,    3,   31,   13,  -15,
     -20,  -17,  -17,   26,  -26,   24,   -3,    7,   21,   26,   -3,  -17,  -26,  -50,  -26,   33,
      58,   49,  -22,  -67,  -17,   24,    7,  -57,    5,   42,  -11,   -3,   32,   -3,    7,   13,
     -11,   -9,   27,   17,    1,   -5,   -9,  -18,  -19,   -3,  -23,   -5,    7,   -8,    9,   13,
      12,   -5,    7,  -37,   22,   26,   21,   24,  -20,  -35,   23,   24,  -35,  -15,   46,  -38,
     -48,  -14,   -4,    0,  -22,    3,   43,   38,   -1,  -14,   -8,   -5,  -14,    1,   21,   23,
      29,  -19,  -47,  -42,  -49,  -10,   66,   77,   48,  -29,  -32,    1,  -11,    8,   17,  -17,
       3,   43,   33,  -22,  -19,  -41,   29,   22,  -42,    9,   63,   28,  -23,  -59,  -65,    7,
      53,  -22,  -10,  -27,  -30,   36,   48,   -4,   -6,  -22,  -16,   10,   14,   -7,   22,   50,
      -4,  -25,  -41,  -55,  -62,   23,   68,  -16,  -31,   49,   57,   21,  -38,   14,   12,  -43,
     -49,  -16,   28,    7,  -12,  -50,  -17,   49,   65,   18,    1,   -8,   28,    2,  -27,  -13,
      12,  -11,  -52,    4,   31,  -32,  -39,   15,    8,  -19,    6,   25,   -1,  -23,   13,   34,
      59,   36,  -16,   -5,   -7,  -28,  -30,    1,  -14,  -42,   10,   43,   26,  -25,  -37,  -61,
       1,   63,   62,    1,  -36,  -24,   38,   -7,  -26,   27,   10,    4,    2,  -19,  -22,  -27,
     -24,    0,   33,   -8,  -57,  -12,   62,   77,   51,  -10,  -42,  -27,  -28,  -31,   -3,    5,
      21,   10,   15,  -27,  -18,  -18,  -10,    3,   17,   19,   18,  -16,  -20,   25,   -3,  -19,
      -5,   32,   17,   -3,  -32,   -8,    2,  -11,  -24,  -17,  -11,    3,   42,   15,  -12,   -2,
      26,    9,   -4,  -30,   -3,   16,    7,   13,   34,   40,  114,   11, -104,  -71,    7,  -14,
     -34,  -26,   35,   45,   47,    7,   -7,  -16,   11,   -6,  -29,  -32,    1,   24,   32,   10,
      29,  -10,  -74,  -80,  -20,   18,    9,   18,   61,   38,  -27,  -44,   13,   16,  -26,   20,
      69,   14,  -14,  -46,   -7,   -6,  -35,    0,    9,    5,   58,   71,  -36,  -78,  -15,   43,
      34,  -61, -101,  -27,   45,   26,  -10,   23,   69,   69,    5,  -72,  -62,   19,   16,  -37,
     -60,   37,   60,   10,  -49,  -10,   -2,   -1,   43,   44,   10,  -50,   -5,   19,    8,  -43,
     -58,  -17,   32,   28,    4,   -1,  -18,  -10,   13,    8,    1,    1,   22,   -3,   -4,    9,
      -8,   -9,   17,    3,  -15,   -8,   14,   11,  -14,  -11,   -5,   13,  -24,  -34,   -1,  -16,
      -4,   32,   35,  -32,    9,   22,   12,  -27,  -16,   14,   15,    0,   -2,  -12,  -31,  -24,
      14,   48,   10,  -14,   -7,  -22,    4,   -8,  -14,   19,   21,  -21,  -25,  -12,   19,   24,
      19,   27,   -3,  -15,  -16,   10,   21,  -14,    3,    8,    3,  -11,  -33,  -16,    7,    5,
      -8,    2,   -3,   12,    5,  -34,  -19,   -6,   26,   19,    0,   -4,  -12,    5,   12,   20,
      16,   19,   18,  -13,  -42,  -26,   -1,    0,  -18,  -16,   10,   27,   23,   -5,   -7,    9,
      -8,    7,   22,   10,  -28,  -51,  -26,   13,   44,   17,   16,   25,   14,  -32,  -45,  -36,
     -40,   -3,   22,   41,   34,  -12,  -35,  -31,   18,    3,   31,   28,    4,  -21,    2,  -14,
     -24,  -23,   19,   -6,   -7,  -10,   -1,  -13,  -13,   21,   52,   28,    7,    1,  -25,  -36,
       2,   34,   10,  -37,  -31,  -13,   19,   11,   -4,  -20,   15,   -5,  -18,   40,  -13,   15,
     -36,   14,   18,   17,  -21,    6,  -39,   21,    7,  -26,    8,  -33,   24,   30,   32,  -11,
     -26,  -47,  -39,   62,   10,   11,    5,  -17,  -21,   10,    0,   18,   15,  -22,    7,   13,
      14,   -8,   -9,   30,   33,  -34,  -41,  -32,   37,   24,  -19,  -15,    1,    2,   10,   10,
     -27,  -46,  -14,   -9,    9,   47,    1,  -22,  -18,    5,   37,   29,   -3,  -19,  -19,  -18,
       8,   17,    1,  -11,   -6,  -20,   27,   37,   -2,  -28,  -34,   -3,   22,   54,   34,  -31,
     -43,  -28,  -30,  -33,   26,   49,   45,   43,  -15,  -58,  -13,   -2,  -27,   -7,   41,   11,
      19,  -50,  -74,  -28,   31,   75,   39,  -45,   -7,   99,   44,  -83,  -47,   45,   -1,  -30,
      23,   29,  -55,  -30,   31,   28,  -19,    2,  -44,  -46,  -49,   30,   22,   58,   31,  -50,
     -20,    9,  -38,  -53,   49,   37,   -9,   13,  -25,  -18,   18,  -27,   -7,   17,    3,   24,
      57,   26,  -51,  -52,  -54,  -43,   53,   85,   31,  -36,  -44,    7,   13,   19,  -23,  -33,
      36,   47,  -38,  -11,   37,  -19,   -6,   18,   17,    2,   31,   54,  -29,  -72,  -80,   -1,
      27,   52,   10,  -29,  -40,  -48,  -72,   24,  108,   66,  -44,  -76,  -32,  -24,   21,   69,
      54,   24,   -2,   -8,  -28,  -44,  -50,   34,   95,   45,  -40,  -72,  -32,    6,   28,   -1,
      18,   -7,   27,    1,  -14,   21,   -8,  -51,  -62,  -24,   64,   56,   12,   19,  -36,  -22,
      10,   20,  -10,   -1,   -5,  -51,   36,   72,  -42,  -51,   70,   45,  -48,  -27,   54,   19,
     -46,    8,    0,  -46,   10,   37,   35,  -21,  -32,  -22,  -44,  -82,  -33,   59,  105,   48,
     -32,  -36,  -31,   18,   60,  -12,  -49,   10,   89,   28,   12,    8,  -45,  -21,   -6,  -16,
     -32,  -17,  -18,    3,   29,   -3,    0,  -20,  -51,  -31,   24,   52,    1,  -17,  -20,    1,
      35,   15,    5,   35,   27,   18,  -19,    8,  -71,  -74,   -8,   88,   57,  -45,  -37,   17,
      51,   -1,  -13,   -4,    3,  -13,  -24,   -7,   30,   -7,  -25,   -1,   16,   -8,  -43,  -70,
      11,   85,   77,   12,  -62,  -57,   35,   53,  -33,  -96,    8,   82,   21,  -38,   25,   39,
      -1,  -27,  -14,   18,  -16,  -45,  -24,   42,    7,   -9,   22,   32,  -39,   -5,   -8,  -49,
     -17,   60,   88,   21,  -93,  -20,   82,   31,  -26,  -63,  -17,   52,  -28,  -25,   13,   -2,
     -32,  -46,   55,   56,  -37,    6,  -57,  -33,   65,   63,    5,  -25,  -31,   69,   86,  -32,
     -34,  -56,  -23,  -47,   14,   44,  -23,   19,    6,   60,  -27,  -69,  -37,   20,  -14,   -5,
      50,   44,   15,   13,  -23,  -60,  -46,   23,   40,   -5,  -25,    6,   46,   -4,  -10,  -27,
     -12,   28,   45,   10,  -13,  -33,  -19,  -39,   42,   32,  -23,  -25,   24,  -17,   13,   25,
      13,  -32,   13,   48,    4,  -93,   -5,   40,   -7,   37,  -39,  -37,   41,    1,  -13,  -33,
      43,  -53,  106,    8,  -57,  -93,   55,   40,   56,  -24,   -4,  -19,    7,  -23,  -65,  -18,
      34,  -30,    7,   66,   92,    3,  -43,  -37,  -23,   12,   -7,  -17,   14,  -15,   -9,  -18,
      18,   51,   -1,  -57,  -17,   23,   19,   15,  -40,   -1,    0,   -8,   39,  -13,  -43,   72,
      57,   -1,  -54,  -17,   32,  -19,   11,    0,   36,   25,  -23,  -86,   21,   -3,   14,  -17,
      76,   37,   23,    2,  -23,  -54,  -42,  -80,   61,   60,   63,  -12,  -57,  -44,   15,   35,
      26,   11,  -44,  -22,    8,   33,  -24,  -17,   21,   38,  -25,  -39,   16,   43,  -36,  -28,
      54,   10,  -52,  -18,  -34,  -14,   76,   60,   24,  -32,  -19,   16,  -13,  -68,   -5,   30,
     -13,  -23,  -14,   61,   24,   35,   39,    4,  -50,  -58,  -39,    0,   43,   43,   21,   24,
     -20,  -46,  -36,   38,    8,  -67,   -8,   61,   38,   10,  -12,    5,   -4,  -16,  -47,   -5,
     -18,  -20,   37,   41,   24,    4,    7,  -19,   11,  -52,    0,   17,   20,  -30,  -33,  -16,
      60,   34,  -15,  -46,  -77,   14,   29,   26,   21,   25,    8,    7,   36,   23,  -39,  -16,
      21,   11,  -23,   11,   -4,   -6,  -35,   13,   -8,  -49,  -17,   44,   19,  -25,  -17,    9,
      -5,   -5,   -1,  -31,   11,   15,   17,   -8,  -31,  -51,   12,   54,   85,   32,    4,  -58,
     -35,  -31,    0,   10,   21,  -20,  -20,  -29,   15,   26,   -7,    8,    4,    0,   30,    2,
     -26,    2,   19,   15,  -18,  -13,  -20,  -19,   47,   33,   -6,  -51,  -30,  -12,   12,   30,
      34,   31,    4,  -45,  -81,   -7,  -22,    1,   73,   98,   24,  -67,  -13,   19,  -32,  -86,
       6,   94,    4,  -47,   21,  -11,  -50,   22,   -3,   -2,   50,   20,  -37,  -59,   35,   28,
     -16,  -36,  -30,  -11,    4,   69,   98,  -65,  -84,   73,   27,  -90,  -17,   84,   10,  -51,
     -14,   40,  -24,  -11,   16,  -34,  -26,   38,  -43,  -34,   58,   85,  -33,  -51,   17,    7,
       4,   52,   25,  -35,    0,   44,  -21,  -47,   40,   44,  -69,  -65,   37,   35,  -21,    4,
      32,  -60,  -75,   21,   64,   60,   -6,  -11,    6,    2,  -41,  -34,   19,   31,    9,    7,
      -1,   11,    6,  -11,  -26,  -23,   16,   35,  -39,  -68,    6,   56,   -3,  -42,   29,   28,
       3,   28,   14,  -37,  -16,   11,   -8,  -18,   15,   -1,   -8,   43,  -20,  -67,  -12,   34,
       7,  -12,   -9,    5,   -4,    7,  -12,   27,   -3,  -68,   26,   96,   30,  -33,  -28,  -25,
      19,   27,  -33,  -48,   -3,   37,   -1,  -35,  -11,    5,   42,   36,    6,  -48,  -38,   26,
      54,  -23,  -41,   52,   44,  -32,  -22,   28,  -23,  -32,   12,   41,  -16,   -6,   -6,  -17,
     -18,  -14,  -12,   -5,   18,   52,   45,  -10,  -16,   29,   11,  -36,  -26,    7,   36,   12,
     -57,  -48,   48,   70,   16,   21,  -13,  -46,  -33,  -62,  -63,  -21,   94,   94,   20, -110,
     -47,   41,   67,  -16,  -57,  -40,   85,   71,    7,  -39,   15,  -29,  -50,  -41,   18,  -40,
     -42,   38,   69,   21,   -8,  -58,  -19,   23,   24,  -20,  -10,   11,   41,    7,   -6,  -30,
     -23,    2,   16,   57,   38,  -11,  -50,   36,  -16,  -51,  -51,   81,   24,  -68,  -84,   39,
     112,   62,  -79, -104,   24,  102,   15,  -38,   20,   22,  -49,  -91,   15,   51,   30,   -1,
     -15,  -30,  -12,   17,   42,  -17,  -48,    0,   49,   35,    2,  -19,  -16,  -30,    9,   17,
     -12,   -4,  -15,    5,   34,   -1,  -56,  -64,    7,   48,   54,  -16,  -51,   20,   62,  -17,
     -27,   -9,  -10,  -29,   -1,   35,   44,  -20,  -23,   -2,  -12,   -4,   31,   24,  -24,  -14,
       2,  -28,  -27,   49,   61,  -54,  -61,    6,   23,  -20,    2,   41,   26,    2,   15,   -5,
       6,  -16,  -36,  -16,    2,  -54,  -53,  -18,   62,   64,   10,   -3,   91,   39,  -54, -103,
      -5,   16,  -31,  -28,   75,  105,  -32, -114,  -52,   68,   32,  -52,  -19,   25,   54,   61,
      14,  -40,   12,    1,  -56,  -31,   74,   40,  -73,  -66,    0,   49,   36,   24,  -20,    0,
      13,  -40,  -99,  -11,   55,   31,  -33,   39,   24,    3,  -18,    7,   10,    4,  -29,   17,
      19,   27,  -30,  -41,    9,   33,  -24,  -25,   30,   28,  -34,  -57,    8,   -7,  -46,    5,
      48,  -22,   -6,   57,   58,  -31,  -72,   -2,   72,   44,  -53,  -42,   41,    1,  -54,   30,
      54,   -6,  -79,  -14,   33,   -6,  -22,   14,   10,   -5,   -8,   13,   23,   21,  -47,  -74,
      22,   24,  -10,   -7,   39,    2,   12,   -7,   -2,    4,   33,  -20,  -33,   18,   22,  -88,
     -71,   26,   81,   14,  -37,    3,  -24,    6,   -8,   11,   40,   18,   -7,  -17,   20,   -8,
     -15,  -41,  -11,   27,   52,  -27,  -46,   33,   21,   46,  -30,  -13,   26,  -91, -106,  -47,
      54,  109,   67,  -87,  -90,   38,   92,   31,  -10,  -69,  -73,  -27,   -6,   24,   -6,   20,
      30,   45,   33,  -13,  -25,   10,   57,  -16,  -32,    0,  -14,  -55,  -20,    4,    7,   -4,
       3,   18,  -11,   34,   11,  -45,  -45, -125,  -38,   -2,   19,   72,   82,   99,   98,   35,
     -51,  -81,  -53,    3,  -39,   23,   -4,  -58,  -63,  -24,   40,   84,   48,   -7,  -18,   -2,
      -8,  -20,  -10,    3,   21,   17,  -39,  -66,  -20,   -2,   37,   30,   39,   34,   -5,  -41,
     -26,   33,   40,   18,   -2,   11,   13,  -20,  -60,  -21,   33,  -25,  -35,   30,   65,   22,
      13,  -15,    2,   16,   11,  -68,  -18,   74,   10,  -74,  -34,  -39,  -17,    8,   59,   39,
     -22,  -38,   -8,    9,   30,   23,   11,   -3,  -12,   10,   -1,   59,    9,  -28,  -72,  -27,
      32,   68,  -11,   -3,   27,    4,  -33,  -39,    7,   -1,   -5,   -7,   26,  -14,  -26,  -40,
     -12,    5,    5,    1,  -12,   64,   63,  -41,  -56,   10,   26,   40,  -26,  -44,  -42,   25,
      -6,    3,   -1,   10,    9,   -1,    9,    1,  -28,   10,   24,   26,  -33,  -36,   46,   20,
     -43,  -52,  -35,   22,   53,   30,   -6,   18,  -16,  -49,  -36,   45,   10,   21,    7,    9,
     -33,  -50,   21,   73,   33,  -42,  -46,   42,  -12,  -18,    5,  -50,  -25,   68,   55,  -31,
     -79,   -7,   77,   25,   -6,   29,   78,   24,  -87,  -41,  -30,  -41,  -23,   75,   35,  -32,
     -65,   -7,  -13,    3,   41,   34,  -24,  -33,   25,   14,  -52,  -28,   19,   76,   45,  -45,
     -47,   -5,   24,    9,  -14,  -41,   -5,   49,   22,   10,  -31,  -35,   -1,   -6,    3,   10,
      -1,  -12,  -20,  -51,    9,   79,   53,  -36,  -38,  -13,  -14,  -15,   50,   50,  -36,  -33,
       0,    5,   22,   23,   24,  -51,  -81,  -27,   56,   42,  -10,  -16,    0,    0,   -5,   16,
      12,  -19,   11,   10,  -15,   -1,  -32,  -17,    1,   11,   62,  -16,  -21,    9,   21,  -29,
     -50,   16,   82,   17,  -35,   -4,   11,    3,    8,    8,   -9,  -13,   10,  -39,  -63,  -19,
      54,   58,  -16,  -25,   18,   38,   -8,  -50,  -54,  -17,   18,   47,   17,  -33,  -45,    0,
      52,   57,   -5,  -34,  -17,   32,   10,  -28,  -10,  -21,   -3,   -9,  -20,   20,   47,   22,
       5,   -4,  -15,  -37,  -22,  -28,    9,   37,  -18,  -13,    3,   15,  -33,  -47,   20,   73,
       0,  -36,   33,   60,  -11,  -77,  -13,   42,   13,  -20,    9,   47,   22,  -27,   29,    6,
     -71,  -78,  -20,   21,    4,   27,   23,   19,   31,   45,  -29,  -54,  -10,   37,  -78,  -46,
     -14,   67,  108,   57,   12,  -62, -108,  -15,  116,   56,  -58, -110,  -33,   33,   30,  -39,
     -26,   11,   29,   22,    8,   52,   76,   31,    0,  -31,  -50,  -10,   59,   54,  -13,  -84,
     -65,  -60,    0,   35,  105,   61,  -30, -117,  -62,   35,   88,   57,   48,  -38,  -85,   41,
      12,  -21,   -6,    7,   15,   73,  -30,  -72,  -37,   25,    0,   -5,   65,   76,  -90,  -78,
      24,   47,    2,  -14,   40,   83,    0,  -32,  -46,  -62,  -26,   50,   37,   -4,  -44,  -40,
      55,   31,  -38,  -13,  -17,  -30,   -4,    7,   68,   39,    1,  -23,  -38,  -30,    6,  -35,
      14,   52,   -9,  -62,  -47,   45,   44,   11,  -17,   -9,    6,   16,   34,   -3,  -32,  -21,
     -33,   -3,   21,   26,  -39,   11,   65,   33,   19,   -1,  -49,  -85,  -97,   66,   58,  -93,
     -15,   15,    5,   81,   76,   29,   -2,  -52,  -51,  -30,   65,   38,  -45,  -14,    1,   28,
      22,   43,   19,  -59, -109,  -29,   29,  -14,  -22,  -41,    0,   54,   76,   16,    8,   23,
      15,  -47,  -39,   -8,    5,   36,   -6,   -3,   -4,   13,   13,   21,  -47,  -53,   -6,   -9,
     -27,  -44,    8,   86,   64,   12,   -5,  -32,  -10,  -20,  -27,  -23,    8,   30,    1,   16,
      42,  -35,   -8,    4,  -39,  -11,  -62,  -29,  108,   87,  -20, -104,  -18,  -55,    8,   47,
     -16,   29,   38,    4,  -44,  -39,  -20,   38,  -13,   23,   82,   30,  -67,  -93,   26,   79,
      20,  -79,  -74,  -23,   33,   59,   80,   39,  -42, -100,    0,   19,   38,    9,  -55,    9,
     -15,   22,   68,  -17,  -55,  -23,    1,   87,   19,  -56,  -60,   32,   37,   38,  -67,  -33,
      -1,   31,   24,   15,  -30,   -5,  -36,  -29,  -27,    8,   27,   -9,   12,   29,   38,   33,
       0,  -39,  -18,    6,   19,   18,    8,    1,  -33,    9,   -1,    2,  -29,  -66,    0,   41,
       6,  -50,  -13,    9,   73,  -28,  -47,  -21,   30,   68,   31,   32,   29,  -46,  -14,   13,
     -44,  -75,   -3,   62,   55,    9,  -49,   -1,   54,   19,   -6,    7,   16,   38,   13,  -26,
     -55,  -76,  -23,   16,   21,  -33,  -22,   16,   61,   25,  -14,  -35,   12,   23,   -7,  -17,
     -32,  -10,  -16,   -1,    7,   18,   -1,   19,   -2,   -1,   21,  -14,    1,  -44,  -44,  -23,
     -29,   -1,   28,  -28,   47,   64,   12,   -4,  -15,  -37,   -7,   24,   50,    6,  -15,  -26,
      -5,   20,   12,  -25,  -21,   -2,  -18,  -23,    9,   16,   24,   36,  -30,  -35,  -12,   32,
      19,  -13,   19,   -6,    2,   -2,  -22,  -11,   14,   50,   10,  -21,  -55,  -14,   23,    6,
       6,   -6,  -26,  -25,   -8,   25,   14,   24,   14,  -13,   18,   11,   23,  -34,  -49,  -45,
       6,   39,   37,    3,    0,  -29,    8,   26,   -6,   -7,  -21,    2,  -11,    6,   16,   -1,
     -17,    6,   32,   -4,  -54,   -9,   22,  -14,    6,   27,   -1,   -2,   34,   33,    8,    1,
      -8,  -14,  -32,   23,  -22,  -23,  -29,  -12,    5,   25,   22,   -4,   14,    5,   24,  -39,
     -29,   17,  -21,  -80,  -60,   -9,   78,   99,   81,  -41,  -53,   22,   11,  -69,  -22,   -2,
      70,   80,   18,  -56,  -54,  -79,  -27,   56,   46,   28,   -1,   12,  -37,  -76,   23,   64,
      -4,   -5,    4,    0,   -2,   -5,   10,   -4,   -9,    5,    3,    3,   -2,    6,   -2,   -1,
       0,    2,    0,    1,   -2,    2,   -3,   -2,    0,    1,   -1,    0,    0,   -1,   -1,   -1,
       0,   -1,   -1,   -1,   -1,    0,    0,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,    0,
      -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
       0,    0,    0,    0,    0,    0,    0,    0,    0,   -1,   -2,   -3,   -5,   -6,   -5,   -5,
      -3,    0,   -1,   -3,   -1,    7,   16,   20,    8,   -8,  -24,  -35,  -39,  -36,  -35,  -42,
     -47,  -35,  -14,    0,    8,   17,   28,   45,   60,   65,   64,   66,   67,   60,   50,   39,
      26,   14,    5,  -14,  -40,  -54,  -56,  -56,  -55,  -47,  -36,  -20,    1,   13,   15,   16,
      12,    2,  -10,  -20,  -33,  -43,  -42,  -38,  -43,  -40,  -28,  -17,   -7,    6,   21,   34,
      48,   60,   63,   64,   66,   61,   54,   51,   41,   23,   10,    1,  -18,  -37,  -46,  -54,
     -63,  -60,  -46,  -30,  -13,    5,   15,   16,   17,   11,   -2,  -11,  -21,  -34,  -44,  -45,
     -43,  -42,  -33,  -21,  -17,  -10,    5,   23,   39,   54,   62,   61,   62,   63,   59,   53,
      47,   38,   23,   10,   -5,  -23,  -36,  -42,  -51,  -61,  -61,  -48,  -26,   -2,   14,   16,
      13,   13,    9,   -1,  -14,  -27,  -36,  -42,  -44,  -48,  -44,  -31,  -17,  -10,   -8,    1,
      21,   47,   65,   67,   58,   54,   58,   61,   54,   41,   31,   23,   11,   -9,  -30,  -41,
     -44,  -45,  -54,  -61,  -52,  -21,   11,   25,   19,    8,    4,    7,    2,  -15,  -33,  -39,
     -39,  -44,  -51,  -48,  -34,  -12,   -2,   -4,   -2,   19,   54,   74,   72,   58,   47,   51,
      59,   54,   40,   26,   20,    7,  -16,  -37,  -46,  -44,  -42,  -51,  -58,  -47,  -15,   19,
      31,   25,    9,   -1,   -1,   -4,  -15,  -30,  -37,  -41,  -51,  -55,  -48,  -28,  -11,   -4,
      -2,    6,   28,   58,   73,   74,   63,   50,   45,   46,   49,   42,   31,   19,   -6,  -30,
     -43,  -44,  -42,  -51,  -54,  -49,  -33,   -3,   18,   30,   31,   17,    2,  -13,  -15,  -15,
     -25,  -31,  -45,  -62,  -60,  -45,  -24,  -16,  -10,    6,   20,   40,   58,   68,   74,   69,
      55,   41,   37,   44,   43,   34,   15,  -17,  -41,  -48,  -46,  -51,  -59,  -51,  -34,  -16,
       3,   17,   29,   33,   23,    2,  -15,  -18,  -18,  -22,  -31,  -50,  -64,  -61,  -42,  -30,
     -24,   -8,   13,   35,   50,   57,   65,   70,   70,   58,   42,   40,   41,   40,   32,    6,
     -23,  -45,  -53,  -55,  -64,  -60,  -45,  -24,   -1,   10,   19,   27,   28,   23,    4,   -9,
     -17,  -22,  -23,  -36,  -53,  -61,  -60,  -47,  -36,  -22,   -3,   19,   44,   56,   60,   65,
      65,   65,   60,   52,   45,   39,   37,   23,   -2,  -26,  -49,  -63,  -66,  -63,  -55,  -42,
     -16,    3,   14,   25,   25,   22,   19,   11,   -2,  -17,  -20,  -29,  -44,  -50,  -58,  -64,
     -53,  -32,  -13,    0,   25,   45,   53,   65,   68,   61,   60,   63,   60,   47,   42,   33,
       7,  -10,  -26,  -56,  -73,  -68,  -57,  -53,  -37,  -12,   -1,   14,   32,   26,   16,   17,
      16,    1,  -12,  -19,  -38,  -52,  -47,  -55,  -65,  -50,  -23,   -9,    4,   27,   40,   48,
      68,   72,   59,   58,   67,   64,   52,   42,   21,   -5,  -16,  -31,  -60,  -73,  -62,  -54,
     -49,  -34,  -17,   -4,   17,   32,   24,   13,   18,   20,    6,  -11,  -29,  -46,  -48,  -46,
     -54,  -59,  -41,  -17,   -5,    6,   20,   35,   54,   71,   68,   55,   60,   74,   71,   53,
      27,    5,   -6,  -16,  -35,  -62,  -70,  -57,  -49,  -45,  -40,  -25,    4,   25,   29,   15,
       7,   23,   27,   10,  -20,  -46,  -47,  -41,  -39,  -47,  -55,  -34,  -11,   -1,    4,   11,
      38,   67,   72,   62,   48,   61,   83,   76,   49,    9,   -9,   -7,  -15,  -31,  -59,  -70,
     -55,  -48,  -46,  -43,  -21,   16,   29,   22,    6,    1,   25,   32,   10,  -28,  -57,  -47,
     -34,  -30,  -38,  -49,  -33,  -12,   -4,    3,   17,   50,   72,   68,   55,   44,   61,   86,
      77,   41,   -2,  -16,  -10,  -13,  -28,  -56,  -69,  -58,  -52,  -47,  -35,   -7,   22,   25,
      13,   -4,   -2,   25,   33,    7,  -35,  -58,  -46,  -29,  -22,  -32,  -44,  -34,  -16,   -5,
       8,   30,   59,   72,   65,   46,   39,   62,   87,   76,   33,   -8,  -20,  -13,  -10,  -28,
     -57,  -70,  -62,  -51,  -42,  -24,    3,   23,   23,    4,  -15,   -4,   25,   34,    3,  -38,
     -55,  -45,  -23,  -17,  -32,  -43,  -34,  -15,   -1,   14,   41,   64,   73,   59,   35,   35,
      64,   89,   73,   26,  -11,  -23,  -14,  -11,  -33,  -60,  -69,  -59,  -48,  -39,  -14,   11,
      25,   17,  -11,  -24,   -3,   30,   35,   -3,  -40,  -54,  -41,  -18,  -19,  -36,  -41,  -28,
     -10,    0,   21,   51,   70,   71,   47,   24,   36,   72,   93,   65,   17,  -14,  -22,  -13,
     -17,  -43,  -62,  -63,  -52,  -48,  -36,   -5,   19,   26,    5,  -26,  -27,    5,   40,   31,
     -12,  -42,  -50,  -34,  -20,  -28,  -37,  -33,  -17,   -8,   -1,   29,   61,   75,   64,   31,
      19,   44,   85,   93,   51,    9,  -15,  -18,  -16,  -30,  -50,  -57,  -52,  -48,  -52,  -32,
       3,   25,   20,  -10,  -34,  -21,   19,   42,   20,  -17,  -40,  -43,  -35,  -30,  -32,  -32,
     -21,  -12,  -12,    3,   37,   67,   72,   50,   25,   24,   57,   92,   81,   42,    6,  -12,
     -18,  -25,  -39,  -53,  -52,  -44,  -49,  -51,  -28,    6,   25,   13,  -17,  -32,  -11,   29,
      39,    8,  -24,  -38,  -37,  -33,  -36,  -39,  -30,  -10,   -3,   -9,    3,   38,   68,   71,
      46,   23,   32,   68,   92,   71,   31,    5,   -7,  -16,  -31,  -50,  -55,  -45,  -37,  -49,
     -53,  -27,    8,   23,    8,  -20,  -24,    3,   34,   28,   -6,  -28,  -32,  -30,  -35,  -46,
     -43,  -23,    0,    0,  -10,    5,   41,   67,   65,   42,   30,   47,   77,   83,   52,   23,
      10,    2,  -16,  -43,  -60,  -55,  -38,  -36,  -53,  -53,  -25,    8,   19,    3,  -14,   -8,
      17,   29,    9,  -17,  -24,  -22,  -26,  -43,  -53,  -42,  -14,    4,   -3,   -9,   10,   44,
      63,   58,   43,   43,   63,   77,   64,   38,   24,   20,    7,  -23,  -52,  -62,  -49,  -38,
     -45,  -57,  -49,  -19,    6,   11,    2,   -1,   12,   22,   13,   -7,  -18,  -15,  -17,  -32,
     -50,  -52,  -32,  -11,   -4,   -8,   -3,   21,   44,   55,   53,   52,   63,   70,   64,   49,
      35,   34,   24,    0,  -29,  -53,  -54,  -50,  -51,  -56,  -57,  -37,  -17,   -2,    7,    9,
      20,   21,   12,    1,  -13,  -11,  -13,  -24,  -36,  -49,  -40,  -30,  -22,  -12,   -9,   10,
      25,   38,   51,   57,   70,   71,   62,   57,   44,   42,   34,   15,   -4,  -30,  -42,  -53,
     -65,  -61,  -61,  -49,  -35,  -22,   -2,   10,   25,   27,   15,   11,   -1,   -8,  -14,  -22,
     -27,  -37,  -37,  -37,  -40,  -26,  -14,   -2,   10,   24,   42,   54,   68,   73,   65,   65,
      60,   49,   36,   27,   15,   -7,  -25,  -43,  -63,  -69,  -65,  -61,  -54,  -36,  -13,    3,
      18,   26,   23,   20,   16,    1,  -16,  -21,  -20,  -31,  -37,  -38,  -40,  -38,  -25,  -15,
      -7,   11,   34,   48,   56,   66,   71,   72,   73,   61,   43,   34,   29,   11,  -14,  -31,
     -46,  -63,  -69,  -72,  -69,  -53,  -28,   -7,    3,   16,   27,   30,   28,   15,   -3,  -14,
     -19,  -25,  -39,  -42,  -37,  -38,  -35,  -30,  -19,   -2,   18,   39,   47,   56,   69,   75,
      78,   71,   60,   49,   35,   22,   -1,  -20,  -32,  -50,  -65,  -76,  -75,  -63,  -49,  -27,
      -9,    6,   22,   28,   31,   27,   16,    6,  -13,  -26,  -36,  -43,  -41,  -42,  -42,  -36,
     -27,  -10,    2,   18,   38,   52,   64,   70,   73,   79,   76,   70,   50,   27,   11,   -5,
     -21,  -41,  -62,  -69,  -72,  -68,  -61,  -50,  -26,   -4,   13,   21,   23,   32,   35,   27,
       6,  -21,  -33,  -37,  -42,  -48,  -53,  -45,  -31,  -19,   -8,    3,   23,   45,   59,   65,
      65,   73,   88,   88,   69,   40,   19,   10,   -6,  -30,  -54,  -69,  -69,  -68,  -67,  -59,
     -43,  -18,    2,   10,   15,   22,   39,   46,   27,   -3,  -28,  -34,  -37,  -48,  -56,  -60,
     -48,  -29,  -16,   -1,   14,   35,   52,   58,   60,   64,   80,   96,   88,   64,   34,   16,
       6,  -11,  -36,  -62,  -77,  -75,  -68,  -58,  -47,  -33,  -14,   -1,    7,   15,   28,   43,
      44,   24,   -6,  -30,  -38,  -40,  -49,  -63,  -68,  -56,  -30,   -5,   15,   27,   40,   51,
      59,   63,   72,   84,   91,   83,   60,   32,   12,    1,  -14,  -45,  -73,  -84,  -78,  -62,
     -46,  -36,  -28,  -17,    0,   11,   20,   31,   38,   35,   20,   -6,  -28,  -40,  -46,  -58,
     -72,  -71,  -52,  -26,    4,   26,   37,   45,   54,   64,   69,   74,   81,   80,   73,   59,
      35,   13,   -5,  -28,  -54,  -75,  -79,  -74,  -63,  -43,  -30,  -21,  -11,    0,   14,   23,
      29,   33,   23,   14,   -2,  -25,  -41,  -58,  -69,  -71,  -64,  -43,  -24,    3,   33,   47,
      56,   60,   64,   73,   74,   75,   73,   62,   56,   38,   13,  -12,  -42,  -57,  -69,  -77,
     -71,  -63,  -44,  -25,  -15,   -3,    2,   13,   26,   23,   24,   19,    8,   -2,  -24,  -44,
     -64,  -74,  -64,  -60,  -45,  -16,    9,   34,   53,   63,   68,   66,   75,   73,   63,   66,
      62,   49,   34,   11,  -17,  -43,  -54,  -66,  -82,  -72,  -52,  -43,  -28,  -10,    0,    4,
      18,   27,   16,   13,   20,    8,  -11,  -26,  -47,  -66,  -63,  -59,  -63,  -47,   -7,   20,
      34,   56,   69,   65,   73,   81,   67,   54,   61,   63,   44,   25,    6,  -23,  -37,  -44,
     -69,  -85,  -69,  -48,  -39,  -26,   -7,   -4,    5,   27,   25,    9,   10,   15,    5,  -17,
     -34,  -52,  -62,  -54,  -54,  -60,  -40,   -5,   21,   41,   59,   67,   66,   78,   81,   64,
      53,   58,   56,   39,   18,   -3,  -24,  -34,  -45,  -64,  -76,  -67,  -51,  -37,  -21,   -8,
      -3,   11,   22,   20,   11,    9,   11,   -4,  -23,  -38,  -56,  -57,  -53,  -50,  -42,  -31,
      -5,   21,   41,   63,   67,   72,   77,   69,   67,   58,   56,   49,   28,   16,   -8,  -28,
     -35,  -50,  -53,  -62,  -65,  -53,  -44,  -20,   -2,    2,   14,   10,   14,   17,    7,    5,
     -13,  -27,  -37,  -60,  -58,  -55,  -42,  -22,  -18,   -2,   13,   36,   69,   73,   76,   71,
      62,   70,   60,   53,   42,   23,   16,  -13,  -35,  -45,  -51,  -40,  -46,  -58,  -60,  -52,
     -17,    4,    8,   11,    5,   14,   15,    4,   -4,  -20,  -23,  -37,  -62,  -67,  -59,  -27,
      -2,   -3,   -3,    3,   36,   70,   77,   75,   66,   67,   70,   57,   46,   32,   29,   19,
     -17,  -49,  -62,  -46,  -25,  -33,  -54,  -68,  -51,  -15,    4,    8,    6,   11,   18,    8,
      -7,  -19,  -16,  -12,  -35,  -68,  -83,  -56,   -9,   13,    7,   -7,    4,   40,   66,   73,
      69,   73,   80,   69,   46,   27,   31,   42,   24,  -23,  -68,  -69,  -36,  -14,  -25,  -57,
     -66,  -43,  -16,   -3,   -2,   11,   28,   23,   -2,  -31,  -29,   -4,   -1,  -34,  -83,  -89,
     -45,    3,   22,    6,   -3,   16,   41,   56,   55,   68,   93,   93,   65,   23,   12,   38,
      53,   27,  -38,  -80,  -64,  -29,  -12,  -31,  -54,  -49,  -34,  -22,  -24,  -11,   28,   47,
      25,  -24,  -51,  -27,    5,    5,  -43,  -90,  -79,  -34,    6,   11,    4,   17,   31,   39,
      34,   38,   79,  114,  105,   50,    3,   12,   44,   56,   16,  -49,  -72,  -54,  -28,  -29,
     -44,  -37,  -27,  -28,  -41,  -45,   -5,   46,   61,   17,  -44,  -53,  -20,    7,   -6,  -53,
     -78,  -62,  -27,   -7,   -6,   14,   41,   45,   26,   11,   38,   93,  127,  101,   34,    1,
      20,   48,   42,   -1,  -41,  -53,  -45,  -40,  -51,  -44,  -18,   -9,  -34,  -61,  -47,    7,
      57,   58,    2,  -46,  -43,  -14,   -5,  -27,  -52,  -58,  -46,  -31,  -26,  -12,   28,   59,
      45,   10,    6,   50,  104,  124,   87,   30,   11,   30,   40,   19,   -9,  -26,  -35,  -44,
     -58,  -62,  -38,   -4,   -6,  -46,  -67,  -37,   21,   56,   43,   -4,  -37,  -30,  -15,  -25,
     -40,  -44,  -38,  -38,  -43,  -38,   -9,   40,   64,   37,    5,   14,   65,  106,  107,   75,
      36,   26,   34,   24,    4,   -8,  -10,  -24,  -53,  -70,  -64,  -30,    0,  -16,  -53,  -61,
     -22,   28,   43,   29,   -2,  -21,  -20,  -26,  -39,  -43,  -34,  -26,  -43,  -54,  -40,    0,
      46,   56,   30,   12,   30,   75,   97,   90,   69,   47,   38,   29,   13,    2,    0,   -1,
     -27,  -61,  -71,  -55,  -25,  -14,  -32,  -50,  -41,   -6,   22,   25,   17,    4,   -8,  -19,
     -31,  -38,  -35,  -28,  -35,  -53,  -54,  -29,    7,   31,   32,   23,   28,   51,   72,   78,
      72,   65,   55,   42,   30,   19,   15,   11,   -8,  -36,  -58,  -58,  -42,  -35,  -35,  -43,
     -40,  -18,    0,   12,   14,   11,    9,   -4,  -15,  -25,  -31,  -28,  -36,  -49,  -53,  -45,
     -18,    1,   12,   19,   23,   43,   58,   64,   68,   64,   64,   57,   46,   40,   28,   22,
       9,  -17,  -35,  -48,  -47,  -44,  -47,  -45,  -44,  -31,  -12,   -2,    7,   10,    9,    7,
      -2,   -8,  -19,  -28,  -32,  -44,  -51,  -48,  -37,  -21,   -9,    5,   16,   26,   43,   55,
      60,   64,   63,   61,   58,   55,   48,   34,   21,    6,  -13,  -27,  -39,  -49,  -53,  -50,
     -46,  -41,  -32,  -16,   -3,    5,   11,    9,    6,    5,   -4,  -17,  -32,  -40,  -42,  -44,
     -42,  -40,  -32,  -12,    5,   17,   24,   35,   50,   58,   64,   64,   60,   65,   61,   50,
      34,   18,   10,   -2,  -18,  -38,  -58,  -56,  -49,  -45,  -41,  -38,  -22,   -4,    8,   14,
       8,   11,   10,   -5,  -20,  -38,  -41,  -36,  -37,  -40,  -48,  -37,  -12,    4,   14,   19,
      27,   46,   59,   66,   63,   62,   70,   64,   50,   34,   22,   17,    8,  -11,  -38,  -59,
     -57,  -50,  -49,  -47,  -43,  -28,   -6,   10,   16,   10,   14,    8,    1,   -5,   -5,   -4,
      -5,    5,    2,    2,    1,   -1,    0,    1,    0,    2,    0,    0,   -2,   -1,   -1,    2,
       1,    1,    0,    0,   -1,    0,   -1,    0,    0,    0,    0,    0,    0,   -1,   -1,   -1,
       0,    0,    0,    0,    0,    0,   -1,    0,    0,    0,    0,    0,    0,    0,    0,   -1,
      -1,   -1,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,   -1,
      -1,    0,    1,    0,    0,    0,    1,    0,    1,    0,   -3,  -10,  -11,   -8,  -13,  -25,
     -21,  -10,    0,    2,   18,   41,   44,   42,   66,   62,   28,   10,   17,   17,  -16,  -10,
      25,   28,   29,   34,   47,   34,   -7,    7,   25,  -12,  -43,  -44,  -40,  -61,  -85,  -78,
     -55,  -42,  -33,  -10,   17,   31,   43,   59,   51,   25,   25,   40,   27,   -1,    2,   25,
      30,   15,   12,   27,   26,   13,   16,    9,  -24,  -43,  -37,  -49,  -83,  -92,  -62,  -40,
     -42,  -36,    1,   33,   34,   45,   61,   46,   27,   32,   33,   10,   -6,   15,   38,   26,
       4,   15,   35,   19,    7,   17,    3,  -26,  -41,  -50,  -67,  -91,  -82,  -48,  -40,  -46,
     -24,   18,   33,   32,   54,   62,   46,   30,   22,   20,    7,    4,   28,   33,   15,   10,
      22,   25,    9,   13,   18,   -2,  -29,  -54,  -65,  -74,  -86,  -68,  -49,  -46,  -32,   -8,
      17,   29,   45,   65,   60,   43,   23,   13,   17,   12,   18,   28,   22,   19,   16,   13,
      14,   16,   24,   13,  -13,  -40,  -66,  -72,  -75,  -74,  -64,  -55,  -36,  -20,   -9,   15,
      43,   63,   65,   51,   37,   17,    9,   19,   23,   21,   19,   24,   21,    3,    4,   24,
      31,   18,   -2,  -20,  -49,  -77,  -74,  -65,  -71,  -69,  -47,  -27,  -27,  -10,   38,   66,
      59,   52,   51,   34,    4,   11,   36,   26,   12,   22,   26,    2,  -11,   25,   45,   18,
       0,   -1,  -23,  -72,  -83,  -55,  -65,  -83,  -61,  -34,  -37,  -36,   23,   71,   55,   43,
      60,   55,   11,    1,   40,   37,    8,   16,   31,    6,  -22,   14,   55,   27,   -3,    8,
       2,  -52,  -83,  -57,  -56,  -89,  -79,  -43,  -43,  -55,   -4,   66,   61,   35,   56,   68,
      31,    4,   32,   46,   13,    7,   31,   16,  -24,   -4,   50,   42,    2,    7,   16,  -25,
     -67,  -60,  -54,  -86,  -95,  -55,  -44,  -63,  -32,   40,   62,   40,   47,   67,   48,   22,
      32,   42,   18,    4,   25,   25,  -15,  -16,   29,   44,   21,   11,   15,   -5,  -39,  -49,
     -59,  -85,  -96,  -72,  -52,  -62,  -50,    7,   45,   49,   50,   56,   56,   43,   42,   39,
      19,    9,   16,   21,    1,  -16,    9,   32,   31,   24,   14,    5,  -14,  -34,  -52,  -81,
     -94,  -85,  -71,  -62,  -55,  -21,   21,   41,   53,   55,   55,   57,   51,   44,   26,   13,
      15,   11,    3,   -3,    0,   19,   27,   29,   26,   11,    0,  -16,  -41,  -70,  -90,  -88,
     -85,  -80,  -57,  -34,   -3,   26,   42,   57,   57,   60,   64,   50,   33,   20,   17,    9,
      -6,   -1,    6,   10,   23,   26,   28,   22,   10,    1,  -27,  -60,  -78,  -87,  -90,  -94,
     -74,  -42,  -20,   10,   34,   44,   57,   65,   71,   58,   35,   30,   23,    8,   -5,   -7,
       4,    7,   19,   33,   23,   19,   24,   17,  -13,  -53,  -65,  -75,  -96,  -98,  -83,  -61,
     -40,   -7,   32,   38,   38,   66,   83,   65,   36,   36,   37,    8,   -7,    1,    0,   -5,
      11,   39,   34,   10,   21,   36,    4,  -45,  -59,  -59,  -89, -106,  -84,  -67,  -62,  -32,
      21,   41,   30,   47,   85,   80,   41,   34,   45,   20,   -8,    0,    9,   -7,   -6,   31,
      45,   21,   12,   32,   25,  -27,  -55,  -52,  -76, -104,  -95,  -70,  -64,  -57,   -7,   33,
      34,   38,   67,   84,   57,   35,   46,   29,   -1,   -4,    7,    7,   -8,   12,   41,   31,
      21,   24,   25,   -5,  -43,  -45,  -65,  -98,  -98,  -82,  -62,  -58,  -35,   13,   27,   38,
      59,   70,   67,   45,   49,   39,    2,   -3,    2,    9,    9,    6,   30,   30,   24,   31,
      20,    3,  -26,  -37,  -48,  -91, -100,  -88,  -75,  -53,  -41,   -9,   12,   23,   55,   65,
      61,   54,   51,   51,   14,   -6,    1,    1,   15,   18,   26,   29,   16,   30,   28,    4,
     -14,  -29,  -36,  -71, -100,  -93,  -87,  -64,  -38,  -16,    2,    6,   33,   61,   59,   56,
      54,   55,   32,    1,   -3,   -4,    5,   25,   36,   36,   17,   14,   25,   14,   -4,  -19,
     -30,  -53,  -84,  -94,  -95,  -82,  -49,  -16,    4,    2,   10,   37,   56,   61,   58,   54,
      42,   19,    3,   -9,   -8,   14,   41,   53,   32,   10,    7,   10,   10,   -7,  -25,  -43,
     -65,  -81,  -97,  -99,  -72,  -29,    9,   11,    3,   10,   33,   61,   65,   55,   46,   30,
      19,    0,  -17,   -5,   29,   62,   57,   24,   -1,   -6,   10,    8,  -16,  -35,  -54,  -64,
     -80, -105,  -99,  -57,   -2,   26,   13,   -2,    6,   42,   67,   60,   49,   36,   31,   22,
     -10,  -24,    1,   49,   77,   53,    9,  -14,   -4,   10,   -4,  -26,  -47,  -56,  -58,  -89,
    -115,  -93,  -34,   23,   33,    6,   -6,   16,   50,   62,   53,   39,   34,   40,   16,  -24,
     -26,   15,   71,   82,   38,   -5,  -13,   -1,    3,  -13,  -39,  -53,  -48,  -61, -103, -119,
     -80,   -6,   42,   27,   -1,    2,   26,   51,   56,   43,   33,   43,   42,    4,  -34,  -23,
      37,   87,   70,   20,   -6,  -10,   -3,   -5,  -27,  -49,  -48,  -44,  -72, -115, -118,  -56,
      22,   43,   17,    3,   12,   33,   51,   45,   34,   38,   51,   38,  -11,  -42,   -9,   59,
      86,   53,   13,   -5,   -5,   -3,  -19,  -42,  -50,  -43,  -45,  -85, -127, -105,  -28,   34,
      37,   15,    8,   23,   41,   42,   34,   33,   45,   55,   26,  -27,  -38,   12,   69,   77,
      40,    9,    1,    0,  -13,  -33,  -48,  -49,  -39,  -55, -102, -124,  -83,   -8,   37,   31,
      14,   19,   35,   39,   34,   30,   35,   51,   50,    9,  -31,  -25,   27,   72,   65,   30,
      12,    9,   -2,  -23,  -42,  -52,  -46,  -43,  -71, -109, -112,  -63,    7,   36,   25,   20,
      33,   42,   35,   29,   29,   40,   52,   35,   -2,  -28,  -12,   40,   69,   51,   26,   18,
      13,   -8,  -33,  -48,  -50,  -46,  -57,  -84, -107,  -98,  -43,   14,   29,   24,   30,   44,
      43,   30,   26,   34,   44,   40,   19,   -8,  -20,    4,   46,   59,   42,   29,   25,   10,
     -18,  -40,  -46,  -47,  -57,  -73,  -91, -100,  -78,  -30,   13,   25,   30,   44,   48,   39,
      29,   31,   41,   35,   23,    9,   -9,   -5,   16,   43,   52,   40,   37,   25,    0,  -23,
     -41,  -43,  -54,  -74,  -82,  -93,  -86,  -60,  -26,   12,   26,   41,   53,   44,   40,   33,
      36,   38,   19,   12,    2,   -3,    9,   18,   40,   48,   42,   41,   16,   -6,  -23,  -41,
     -45,  -68,  -84,  -86,  -90,  -71,  -52,  -22,   15,   32,   52,   54,   45,   45,   36,   36,
      25,    6,    6,    0,    5,   15,   21,   41,   46,   46,   37,   10,   -7,  -24,  -42,  -57,
     -81,  -88,  -88,  -83,  -62,  -43,  -14,   16,   41,   59,   55,   48,   48,   40,   27,   10,
       2,    2,    0,    8,   22,   30,   36,   45,   50,   32,    5,   -9,  -23,  -48,  -75,  -86,
     -86,  -88,  -81,  -54,  -26,  -11,   16,   52,   65,   55,   50,   53,   39,    9,   -2,    4,
       2,   -4,   11,   36,   34,   27,   47,   51,   26,    0,   -9,  -23,  -63,  -91,  -85,  -81,
     -89,  -79,  -38,  -13,  -11,   23,   62,   67,   55,   52,   56,   29,   -8,   -7,    7,    0,
      -5,   19,   44,   30,   28,   49,   46,   21,   -2,  -10,  -32,  -79,  -96,  -83,  -81,  -87,
     -67,  -27,  -11,    0,   36,   65,   67,   58,   54,   48,   14,  -15,   -7,    3,    1,    6,
      26,   35,   30,   38,   46,   37,   18,   -2,  -18,  -48,  -85,  -96,  -89,  -81,  -70,  -52,
     -30,   -8,   20,   48,   63,   66,   59,   50,   33,    6,  -14,  -15,   -2,   13,   20,   21,
      25,   36,   45,   42,   31,   12,  -10,  -31,  -56,  -84, -103,  -96,  -70,  -50,  -43,  -31,
       0,   35,   58,   68,   65,   51,   37,   26,    8,  -19,  -25,    2,   27,   27,   17,   20,
      36,   45,   45,   29,    0,  -27,  -41,  -55,  -87, -111,  -93,  -57,  -37,  -33,  -23,    5,
      41,   70,   77,   59,   36,   26,   24,    4,  -24,  -22,    7,   31,   33,   19,   14,   29,
      49,   50,   22,  -16,  -39,  -48,  -63,  -92, -104,  -86,  -51,  -25,  -19,  -16,   10,   53,
      82,   74,   47,   26,   19,   16,   -1,  -18,  -16,    7,   35,   37,   18,   10,   31,   55,
      41,    4,  -25,  -45,  -57,  -73,  -90,  -95,  -82,  -42,   -9,   -8,  -11,   20,   71,   84,
      57,   39,   27,   13,    2,   -6,   -9,  -12,    8,   45,   41,    8,    5,   42,   56,   20,
     -10,  -24,  -50,  -73,  -83,  -83,  -87,  -76,  -25,   10,   -5,   -9,   39,   84,   71,   44,
      38,   26,    2,   -9,   -2,   -4,  -11,   17,   52,   36,    0,   11,   50,   43,    3,  -19,
     -31,  -57,  -84,  -84,  -77,  -82,  -59,   -9,   14,    1,    7,   55,   81,   61,   38,   29,
      20,   -2,  -10,   -1,   -4,    0,   26,   42,   30,    8,   20,   41,   28,   -4,  -31,  -46,
     -64,  -84,  -82,  -79,  -66,  -37,   -7,   15,   18,   30,   58,   68,   57,   33,   17,    9,
       0,   -3,   -7,    0,   15,   23,   31,   29,   23,   24,   22,   14,  -12,  -43,  -63,  -72,
     -73,  -83,  -75,  -47,  -26,   -2,   20,   37,   48,   50,   57,   52,   30,    6,   -1,   11,
       0,   -9,    7,   16,   24,   28,   32,   33,   15,    7,    2,  -21,  -55,  -79,  -66,  -67,
     -81,  -63,  -38,  -12,    9,   29,   53,   48,   42,   51,   47,   22,   -6,    5,   18,   -4,
      -7,    6,   22,   28,   26,   39,   28,    2,   -2,   -8,  -35,  -73,  -76,  -56,  -67,  -77,
     -55,  -20,    4,   16,   40,   54,   42,   41,   51,   37,    7,    0,   17,   13,  -12,   -9,
      20,   31,   25,   29,   33,   15,   -5,   -8,  -22,  -57,  -74,  -62,  -57,  -74,  -71,  -33,
       0,   11,   26,   44,   45,   41,   47,   45,   22,    3,   12,   19,    0,  -15,    4,   30,
      32,   27,   26,   17,    3,   -4,  -14,  -44,  -69,  -66,  -56,  -63,  -74,  -52,  -11,   12,
      21,   29,   35,   41,   49,   51,   31,    9,   11,   19,   11,   -8,   -7,   20,   36,   34,
      22,   10,    6,    5,   -4,  -33,  -64,  -66,  -58,  -58,  -67,  -63,  -29,    4,   20,   21,
      21,   35,   52,   57,   39,   12,   10,   18,   16,    3,   -7,    8,   31,   39,   25,    5,
       3,   10,    5,  -22,  -58,  -67,  -58,  -56,  -60,  -64,  -45,  -11,   15,   19,   12,   24,
      50,   62,   46,   17,    9,   18,   20,   12,    0,    2,   21,   37,   31,    7,    0,   11,
      14,  -12,  -51,  -66,  -58,  -53,  -54,  -59,  -54,  -29,    3,   16,    9,   17,   44,   62,
      51,   22,    8,   17,   24,   21,    9,    1,   11,   30,   31,   14,    3,   11,   16,   -4,
     -43,  -65,  -58,  -49,  -50,  -53,  -55,  -43,  -16,    5,   10,   16,   38,   59,   54,   26,
       7,   18,   29,   24,   18,    8,    5,   16,   27,   23,   11,   14,   18,   -1,  -36,  -63,
     -56,  -43,  -48,  -47,  -49,  -52,  -36,  -12,    8,   17,   35,   55,   50,   28,    9,   17,
      33,   25,   24,   20,    5,    4,   15,   27,   23,   20,   22,    0,  -32,  -58,  -55,  -40,
     -47,  -44,  -39,  -52,  -54,  -34,   -2,   19,   35,   53,   46,   27,   12,   18,   34,   26,
      26,   33,   13,   -6,    0,   22,   34,   32,   28,    3,  -31,  -53,  -51,  -39,  -47,  -45,
     -30,  -45,  -66,  -56,  -19,   15,   38,   52,   43,   22,   13,   22,   35,   26,   26,   41,
      25,   -7,  -13,   10,   35,   46,   39,   10,  -29,  -50,  -46,  -37,  -47,  -46,  -27,  -35,
     -65,  -72,  -42,    2,   38,   55,   43,   19,   11,   24,   36,   27,   26,   43,   37,    2,
     -19,   -6,   25,   53,   56,   20,  -24,  -46,  -43,  -36,  -46,  -48,  -29,  -28,  -56,  -77,
     -64,  -22,   31,   61,   45,   16,   10,   23,   35,   30,   26,   41,   42,   16,  -14,  -21,
       7,   51,   70,   36,  -15,  -38,  -40,  -35,  -42,  -49,  -35,  -29,  -44,  -71,  -81,  -49,
      14,   60,   50,   18,   10,   21,   34,   34,   26,   37,   43,   30,    0,  -27,  -13,   37,
      74,   54,    2,  -29,  -35,  -32,  -37,  -49,  -42,  -32,  -36,  -57,  -85,  -73,  -12,   46,
      57,   27,    9,   17,   32,   38,   28,   30,   41,   39,   18,  -20,  -27,   15,   62,   68,
      26,  -17,  -30,  -28,  -29,  -45,  -51,  -40,  -34,  -45,  -77,  -86,  -42,   18,   54,   43,
      14,   12,   29,   42,   34,   25,   33,   41,   30,   -2,  -24,   -5,   36,   65,   50,    3,
     -24,  -24,  -19,  -33,  -54,  -52,  -42,  -45,  -61,  -75,  -58,  -15,   32,   48,   25,   10,
      24,   45,   45,   27,   26,   32,   28,   13,   -4,   -6,   14,   44,   55,   24,  -11,  -18,
     -12,  -20,  -46,  -57,  -53,  -54,  -57,  -63,  -57,  -33,    4,   35,   32,   16,   22,   40,
      49,   36,   26,   28,   23,   17,    8,    1,   10,   27,   43,   33,    5,   -6,   -8,  -14,
     -33,  -53,  -57,  -61,  -62,  -61,  -59,  -38,  -10,   15,   26,   20,   26,   40,   44,   41,
      30,   27,   25,   18,   12,    3,    9,   26,   33,   28,   13,    5,    5,   -8,  -25,  -45,
     -57,  -60,  -64,  -66,  -65,  -49,  -17,    6,   13,   16,   26,   43,   47,   39,   32,   27,
      27,   25,   13,    3,    6,   22,   35,   26,   13,   10,   12,    5,  -17,  -40,  -54,  -58,
     -58,  -68,  -74,  -61,  -31,   -1,    9,   10,   23,   40,   50,   45,   31,   24,   27,   31,
      20,    3,    2,   17,   32,   31,   16,   12,   15,   12,   -4,  -31,  -51,  -55,  -54,  -62,
     -76,  -73,  -47,  -17,    2,    8,   19,   37,   51,   50,   34,   24,   26,   31,   25,    9,
       4,   13,   26,   34,   25,    9,   13,   20,   -2,  -33,  -44,  -43,  -58,  -78,  -77,  -59,
     -44,  -33,  -10,   17,    6,   12,   -9,   32,   13,    4,   -4,    6,   -9,   27,    8,    2,
      -1,   -3,   -2,    3,   -4,   -3,    2,    0,   -2,    1,   -2,    1,   -4,    2,    1,    0,
      -2,   -1,   -3,    2,    0,   -1,   -2,   -2,   -2,   -1,   -2,   -2,   -1,   -2,   -2,   -2,
      -2,   -1,   -2,   -1,    0,   -1,   -2,   -2,   -2,   -1,    0,   -2,   -2,   -2,   -2,   -1,
      -1,   -2,   -1,   -2,   -2,   -2,   -3,   -1,   -1,    0,    0,   -1,   -3,   -2,    1,    3,
       0,    0,   -2,   -8,  -21,  -17,   -2,   12,   20,   19,    6,  -13,  -28,  -73,  -67,  -64,
     -58,  -39,  -11,   19,   38,   60,   96,   80,   38,   12,    6,  -20,  -65,  -83,  -65,  -61,
     -56,  -17,   22,   35,   49,   74,   94,   55,   16,   20,   -5,  -52,  -89,  -81,  -53,  -65,
     -36,   21,   37,   48,   51,   85,   82,   25,   23,    9,  -36,  -80, -105,  -58,  -57,  -54,
       7,   36,   54,   44,   58,   97,   48,   26,   16,  -21,  -61, -115,  -83,  -45,  -57,  -12,
      23,   57,   54,   36,   86,   77,   37,   21,  -16,  -40, -103, -110,  -54,  -46,  -24,    6,
      43,   68,   36,   62,   86,   60,   30,  -12,  -34,  -80, -119,  -76,  -44,  -24,   -5,   24,
      64,   51,   50,   76,   72,   48,    0,  -34,  -68, -106,  -94,  -56,  -26,   -7,   11,   45,
      59,   58,   66,   71,   60,   23,  -27,  -68,  -93,  -93,  -72,  -37,   -8,   10,   25,   50,
      70,   68,   62,   62,   45,  -10,  -70,  -88,  -83,  -79,  -57,  -15,   15,   13,   31,   73,
      80,   59,   53,   61,   15,  -67,  -89,  -73,  -75,  -75,  -33,   21,   11,   10,   66,   92,
      65,   42,   63,   42,  -56,  -92,  -66,  -66,  -84,  -57,   16,   19,   -5,   50,   98,   76,
      39,   56,   60,  -35,  -95,  -64,  -53,  -84,  -79,    0,   28,   -8,   29,   96,   89,   42,
      46,   69,  -10,  -90,  -69,  -41,  -74,  -95,  -25,   28,   -1,   13,   81,  101,   53,   37,
      69,   11,  -77,  -75,  -38,  -53, -103,  -55,   22,    8,    6,   61,  104,   75,   29,   59,
      31,  -61,  -76,  -43,  -36,  -91,  -88,    6,   17,    1,   46,   96,   94,   34,   40,   48,
     -40,  -80,  -47,  -27,  -69, -107,  -27,   26,    4,   29,   87,  105,   51,   24,   46,  -10,
     -76,  -58,  -21,  -49, -107,  -62,   17,   16,   17,   70,  110,   67,   22,   38,   10,  -60,
     -71,  -24,  -28,  -97,  -85,   -6,   25,   18,   50,  106,   84,   28,   31,   16,  -38,  -71,
     -38,  -17,  -78,  -94,  -30,   15,   30,   41,   86,   92,   44,   31,   15,  -25,  -54,  -53,
     -26,  -57,  -88,  -51,   -2,   33,   45,   68,   88,   59,   35,   17,  -15,  -42,  -55,  -41,
     -48,  -73,  -60,  -19,   24,   50,   61,   74,   67,   46,   21,   -8,  -32,  -48,  -54,  -53,
     -57,  -57,  -34,    9,   50,   63,   59,   65,   58,   29,   -1,  -24,  -38,  -62,  -67,  -48,
     -47,  -40,   -8,   43,   68,   48,   58,   66,   38,    6,  -19,  -26,  -62,  -85,  -45,  -35,
     -39,  -21,   28,   72,   41,   47,   74,   45,   15,  -14,  -17,  -53, -102,  -50,  -24,  -36,
     -26,   10,   69,   42,   32,   81,   52,   21,   -4,  -15,  -39, -109,  -64,  -12,  -35,  -26,
      -1,   54,   47,   21,   79,   65,   20,    7,  -12,  -33, -100,  -82,   -8,  -27,  -32,   -2,
      36,   47,   21,   66,   77,   25,   12,   -2,  -36,  -88,  -87,  -18,  -16,  -36,   -8,   27,
      36,   30,   56,   77,   39,   12,    6,  -33,  -84,  -79,  -30,  -11,  -29,  -20,   19,   27,
      31,   58,   66,   50,   21,    5,  -25,  -81,  -75,  -32,  -17,  -17,  -27,    2,   24,   28,
      61,   61,   48,   35,    4,  -22,  -71,  -77,  -31,  -19,  -12,  -23,  -18,   16,   29,   59,
      65,   45,   41,   10,  -23,  -59,  -76,  -37,  -14,  -11,  -18,  -29,   -2,   29,   57,   68,
      51,   37,   16,  -21,  -55,  -67,  -44,  -12,   -5,  -21,  -29,  -19,   19,   59,   68,   61,
      36,   14,  -12,  -55,  -61,  -44,  -16,    3,  -21,  -29,  -25,    0,   55,   72,   69,   43,
       8,   -6,  -49,  -63,  -39,  -18,    5,  -15,  -31,  -26,  -18,   39,   78,   75,   53,    8,
      -8,  -40,  -67,  -37,  -15,    2,   -8,  -30,  -26,  -29,   16,   79,   84,   59,   14,  -11,
     -33,  -66,  -42,   -9,   -2,   -6,  -23,  -26,  -33,   -7,   66,   94,   67,   22,   -9,  -32,
     -62,  -48,   -8,    0,   -9,  -16,  -20,  -35,  -24,   46,   96,   78,   31,   -2,  -29,  -59,
     -51,  -13,    1,  -10,  -13,   -9,  -31,  -35,   23,   86,   88,   42,    5,  -22,  -57,  -53,
     -18,   -3,  -10,  -13,    0,  -19,  -44,    2,   69,   90,   57,   12,  -13,  -50,  -57,  -21,
      -9,  -13,  -13,    1,   -3,  -41,  -17,   51,   82,   69,   23,   -9,  -37,  -57,  -25,  -12,
     -22,  -15,    0,   10,  -25,  -32,   32,   69,   71,   37,   -4,  -25,  -48,  -30,  -12,  -32,
     -23,   -3,   14,   -2,  -33,   11,   56,   63,   49,    3,  -18,  -32,  -31,  -13,  -37,  -38,
      -9,   11,   17,  -16,   -6,   41,   53,   51,   11,  -17,  -15,  -23,  -14,  -35,  -54,  -22,
       4,   26,   10,  -10,   26,   43,   46,   19,  -19,   -6,   -5,  -10,  -30,  -65,  -42,   -9,
      24,   35,    3,   12,   32,   37,   24,  -20,   -8,   14,    2,  -23,  -68,  -62,  -26,   10,
      50,   28,   11,   22,   27,   24,  -19,  -19,   24,   21,   -8,  -63,  -78,  -45,  -11,   47,
      53,   23,   21,   19,   22,  -17,  -34,   21,   40,   15,  -48,  -89,  -65,  -34,   30,   68,
      44,   27,   16,   16,  -11,  -47,    3,   49,   39,  -22,  -89,  -82,  -55,    3,   68,   61,
      44,   21,   11,   -6,  -53,  -21,   45,   56,   11,  -74,  -96,  -72,  -26,   52,   73,   60,
      39,   10,   -3,  -48,  -44,   27,   61,   42,  -43, -101,  -88,  -52,   27,   73,   70,   59,
      21,   -1,  -40,  -60,    2,   52,   60,   -4,  -90, -100,  -74,   -2,   62,   72,   76,   42,
       5,  -30,  -66,  -22,   34,   63,   33,  -62, -104,  -92,  -31,   44,   68,   84,   66,   21,
     -21,  -64,  -41,   13,   54,   55,  -26,  -94, -104,  -57,   20,   56,   82,   84,   43,   -6,
     -57,  -54,  -10,   36,   60,    7,  -70, -107,  -78,   -6,   40,   73,   92,   66,   12,  -45,
     -57,  -27,   16,   52,   29,  -41,  -96,  -90,  -32,   20,   60,   91,   83,   34,  -27,  -52,
     -37,   -3,   34,   36,  -15,  -77,  -91,  -52,   -1,   43,   83,   93,   53,   -5,  -42,  -40,
     -17,   14,   32,    1,  -54,  -81,  -65,  -21,   23,   71,   96,   67,   16,  -25,  -37,  -24,
      -5,   21,    6,  -36,  -64,  -69,  -37,    3,   54,   93,   73,   35,   -6,  -28,  -25,  -19,
       8,    4,  -27,  -46,  -65,  -46,  -14,   34,   86,   73,   49,   15,  -17,  -19,  -28,   -4,
      -3,  -28,  -32,  -56,  -48,  -24,   15,   74,   67,   55,   36,   -2,  -10,  -28,  -14,   -9,
     -36,  -25,  -42,  -50,  -29,    1,   60,   59,   50,   55,   16,   -3,  -22,  -20,  -14,  -46,
     -29,  -28,  -48,  -33,   -5,   47,   50,   40,   64,   40,    4,  -14,  -17,  -19,  -53,  -40,
     -18,  -40,  -41,   -6,   39,   39,   28,   61,   62,   17,  -10,   -7,  -21,  -59,  -53,  -20,
     -28,  -47,  -11,   38,   29,   15,   52,   77,   36,   -6,    1,  -12,  -63,  -66,  -25,  -20,
     -46,  -19,   37,   28,    0,   38,   83,   54,    5,    5,   -2,  -57,  -81,  -34,  -15,  -44,
     -22,   29,   31,   -4,   16,   85,   68,   17,   15,    1,  -44,  -87,  -54,   -8,  -42,  -27,
      25,   24,    2,    0,   69,   88,   24,   25,   11,  -42,  -76,  -75,  -14,  -25,  -40,   23,
      18,   -3,    3,   42,   96,   45,   22,   29,  -39,  -70,  -75,  -40,   -8,  -39,    7,   24,
     -17,    8,   33,   79,   76,   22,   35,  -21,  -75,  -64,  -60,  -15,  -17,  -14,   21,  -21,
      -4,   40,   59,   88,   45,   24,   -3,  -71,  -61,  -59,  -38,    1,  -14,    0,  -17,  -18,
      41,   54,   82,   74,   22,   -3,  -53,  -61,  -53,  -54,   -2,    3,  -19,  -25,  -22,   30,
      57,   73,   92,   38,  -15,  -40,  -51,  -50,  -58,  -17,   17,  -23,  -44,  -22,   19,   55,
      72,   97,   60,  -22,  -40,  -35,  -45,  -55,  -32,   14,  -17,  -60,  -26,   11,   46,   75,
      97,   78,  -17,  -46,  -23,  -38,  -45,  -37,   -1,  -14,  -66,  -31,    3,   34,   80,   98,
      85,   -4,  -47,  -19,  -33,  -33,  -30,  -20,  -25,  -63,  -34,   -4,   18,   79,  104,   84,
       9,  -38,  -18,  -29,  -27,  -14,  -30,  -46,  -63,  -32,   -5,    3,   68,  111,   84,   18,
     -23,  -12,  -25,  -28,   -2,  -25,  -67,  -75,  -29,    1,   -6,   46,  112,   91,   22,  -11,
       0,  -18,  -33,   -1,   -9,  -76,  -96,  -34,    9,   -8,   22,  101,  102,   27,   -2,   14,
      -7,  -36,   -9,    4,  -68, -114,  -48,   13,   -3,    5,   80,  109,   40,    4,   26,    6,
     -33,  -18,    6,  -52, -120,  -67,    7,    4,   -1,   55,  103,   58,   14,   31,   17,  -21,
     -24,   -4,  -39, -110,  -84,  -10,    6,    2,   34,   87,   71,   29,   36,   25,   -7,  -23,
     -16,  -33,  -96,  -90,  -29,   -1,    6,   22,   68,   75,   45,   45,   31,    4,  -15,  -24,
     -37,  -84,  -87,  -43,  -15,    3,   18,   53,   68,   57,   58,   38,   11,   -7,  -22,  -45,
     -81,  -79,  -48,  -29,  -10,   17,   45,   57,   61,   71,   50,   17,    0,  -15,  -49,  -85,
     -74,  -45,  -40,  -25,   10,   42,   49,   55,   82,   65,   22,    7,   -9,  -43,  -89,  -80,
     -34,  -47,  -40,   -1,   35,   52,   43,   85,   84,   25,   17,   -4,  -38,  -85,  -92,  -28,
     -44,  -55,   -9,   21,   53,   42,   75,  100,   35,   22,    6,  -38,  -74,  -99,  -38,  -34,
     -65,  -18,   12,   42,   51,   63,  102,   52,   25,   21,  -36,  -70,  -90,  -56,  -30,  -64,
     -30,    7,   27,   55,   63,   90,   69,   33,   26,  -26,  -69,  -79,  -66,  -43,  -54,  -37,
      -1,   17,   49,   69,   79,   72,   50,   30,  -15,  -61,  -75,  -68,  -58,  -52,  -33,  -12,
       9,   42,   69,   78,   64,   60,   42,   -9,  -49,  -71,  -69,  -68,  -61,  -25,  -17,   -1,
      38,   64,   77,   59,   62,   58,   -3,  -37,  -62,  -72,  -72,  -73,  -24,  -12,  -11,   35,
      55,   73,   59,   58,   69,    8,  -29,  -48,  -75,  -76,  -82,  -31,   -4,  -14,   28,   49,
      63,   61,   54,   73,   22,  -21,  -36,  -71,  -82,  -88,  -42,    0,   -9,   21,   43,   53,
      57,   56,   73,   33,  -12,  -25,  -62,  -89,  -95,  -49,   -2,   -2,   18,   37,   43,   49,
      60,   75,   38,   -2,  -16,  -49,  -89, -105,  -54,   -7,    1,   19,   31,   37,   38,   59,
      81,   39,    4,   -7,  -35,  -83, -115,  -62,  -10,    0,   20,   27,   32,   30,   53,   87,
      43,    4,    0,  -24,  -70, -118,  -75,  -12,   -2,   19,   24,   27,   27,   45,   89,   52,
       4,    1,  -14,  -55, -113,  -87,  -18,   -3,   13,   20,   24,   28,   41,   85,   60,    7,
      -3,   -9,  -40, -100,  -91,  -28,   -4,    7,   10,   21,   30,   43,   82,   62,   13,   -8,
     -11,  -26,  -85,  -87,  -36,  -10,    2,   -4,   14,   35,   47,   81,   62,   18,   -9,  -21,
     -20,  -65,  -78,  -38,  -19,   -4,  -16,    0,   39,   54,   85,   65,   20,   -7,  -31,  -24,
     -47,  -62,  -33,  -26,  -15,  -25,  -19,   35,   63,   90,   73,   22,   -3,  -39,  -39,  -35,
     -43,  -20,  -26,  -30,  -34,  -36,   24,   71,   94,   85,   29,   -3,  -40,  -58,  -34,  -24,
      -4,  -16,  -46,  -47,  -47,    6,   73,  100,   97,   42,   -4,  -39,  -73,  -45,   -8,   12,
       0,  -51,  -64,  -56,  -13,   66,  104,  106,   64,    2,  -40,  -82,  -63,   -3,   27,   18,
     -43,  -82,  -68,  -28,   51,  104,  112,   86,   19,  -42,  -86,  -81,  -10,   40,   34,  -26,
     -90,  -86,  -41,   31,   98,  116,  104,   46,  -38,  -92,  -95,  -25,   46,   48,   -6,  -84,
    -105,  -55,   13,   84,  117,  114,   76,  -20,  -95, -105,  -45,   41,   54,    8,  -65, -112,
     -70,   -1,   65,  109,  115,  100,   14,  -85, -106,  -62,   21,   50,   13,  -44, -104,  -84,
     -14,   45,   98,  112,  111,   53,  -62, -105,  -75,   -3,   44,   12,  -31,  -85,  -93,  -27,
      27,   82,  110,  110,   81,  -27,  -95,  -81,  -27,   31,   11,  -31,  -66,  -90,  -39,   12,
      61,  106,  107,   94,   12,  -73,  -79,  -48,   11,   13,  -32,  -57,  -78,  -46,   -1,   38,
      97,  109,   96,   43,  -41,  -69,  -62,  -13,   13,  -30,  -58,  -68,  -46,  -11,   17,   81,
     112,   97,   59,   -7,  -51,  -67,  -37,    6,  -23,  -62,  -67,  -42,  -14,    2,   60,  110,
      99,   65,   20,  -24,  -63,  -56,   -7,  -15,  -63,  -75,  -40,  -12,   -8,   39,  102,  103,
      67,   35,    6,  -48,  -68,  -25,  -11,  -56,  -85,  -46,   -7,  -10,   22,   86,  107,   72,
      41,   29,  -25,  -70,  -42,  -14,  -42,  -91,  -62,   -5,   -6,    9,   67,  105,   84,   40,
      40,    3,  -64,  -56,  -23,  -30,  -83,  -85,  -12,    3,    1,   50,   97,   96,   44,   36,
      28,  -45,  -69,  -33,  -22,  -67, -101,  -34,   13,    2,   31,   88,  104,   56,   28,   37,
     -16,  -71,  -51,  -18,  -49, -103,  -62,    9,   14,   18,   70,  109,   68,   26,   36,    6,
     -58,  -68,  -23,  -28,  -97,  -84,   -7,   23,   19,   50,  106,   84,   28,   31,  -21,  -26,
     -18,  -30,  -24,  -77,  -76,  -48,  -46,   31,    0,   -1,    0,    0,    2,    0,    1,   -2,
       1,    0,   -6,   -7,   -5,   -3,    0,   -3,   -4,   -2,    2,    0,   -8,  -11,  -14,  -10,
      -8,   -4,    6,   13,   14,    9,    2,   -6,  -10,   -9,   -6,    9,   17,   15,    8,    0,
       1,   -4,  -12,  -19,  -14,   -8,   -4,    3,    6,   -2,   -4,   -6,   -7,  -10,   -8,  -12,
     -11,    3,   23,   27,   11,    4,   -3,   -5,    0,   -9,   -3,    6,   11,   19,    4,   -8,
     -17,  -20,  -21,   -3,    5,    8,    2,    3,    5,    2,   -3,   -3,  -12,    4,    1,    3,
      -7,    0,    5,    6,    0,   -7,   -8,   -5,   -7,   -5,   -3,    4,    9,    5,   -5,   -5,
      -5,  -17,   -7,    3,   17,   15,    7,   -2,   -5,   -3,    3,   -8,   -5,   -3,    3,    8,
      12,    5,  -10,  -27,  -20,    1,    5,   -4,   -9,  -17,    4,   10,    9,   -2,  -12,  -16,
     -12,   -2,    8,   16,   13,   11,   16,   19,   10,   -2,  -16,  -21,  -11,   14,   15,   21,
      11,    6,  -10,   -8,  -11,  -24,  -35,  -31,  -13,    9,   24,   17,   -2,  -11,  -20,  -11,
     -19,   -7,    3,    8,   22,   21,   21,    2,   -7,  -10,   12,   24,   18,   -3,  -19,   -6,
       0,   -5,  -18,  -17,    6,   12,    7,  -16,  -20,  -22,  -27,  -19,  -14,   12,   14,    3,
       0,    2,    8,   -3,   -5,   -3,   21,   29,   17,    6,   -8,    3,    3,   10,   10,    3,
      12,    4,   -9,  -18,  -20,  -20,   -9,    6,    3,   -9,   -7,  -14,   -9,   -8,   -9,  -23,
     -19,    7,   17,   20,    9,    8,    5,    9,   18,    9,    8,  -10,  -10,   -4,    9,   25,
      -6,  -19,  -19,   -5,   -4,   -7,   -7,  -17,  -15,   -7,   -4,    0,    2,   -2,  -17,   -4,
      14,   23,   15,    2,   -7,   -5,    9,   11,    1,    0,   -3,    0,    0,   15,   14,   -4,
     -15,  -20,  -26,  -22,  -13,    0,    6,   12,    5,  -10,    2,    8,   -2,  -18,   -8,    6,
      20,   28,   23,    0,  -16,   -7,    9,    7,   10,  -12,  -21,  -19,    7,   12,    4,  -17,
     -28,  -24,   -3,   14,    4,  -19,  -18,   -9,   11,   22,   16,  -13,  -23,  -15,   18,   32,
      32,   17,   -4,    1,   14,   11,    1,  -20,  -19,   -3,    9,   13,   -4,  -13,  -16,  -18,
     -23,  -12,  -17,  -16,  -20,  -15,  -14,   -4,    8,   12,    0,    8,    5,   12,   17,   26,
      25,   14,   10,   11,   11,   18,   15,    4,   -9,  -13,   -8,   -9,  -14,  -20,  -28,  -32,
     -12,   -9,  -16,  -17,  -24,  -18,  -12,    5,   10,    4,    6,    8,   18,   35,   31,   17,
       1,   12,   21,   33,   18,    6,  -10,  -11,   -4,   -9,  -13,  -19,  -24,  -24,  -24,  -18,
     -20,  -18,  -20,  -13,  -15,  -10,   -9,   -5,    8,   10,   13,   23,   26,   29,   14,   13,
      13,   13,   16,   25,   19,   17,    4,  -15,  -18,  -15,  -14,  -17,  -34,  -23,  -16,  -12,
     -16,  -26,  -33,  -23,  -15,   -4,    4,   10,   16,   19,   22,   29,   28,    7,    1,    2,
      18,   26,   30,   21,    9,    3,   -4,  -10,  -16,  -29,  -31,  -27,   -4,   -9,  -11,  -28,
     -23,  -17,  -15,  -13,  -11,    4,   11,    9,   13,   16,   25,   18,    8,   10,   18,   17,
       8,   18,   17,   11,   -5,  -19,  -17,  -12,  -19,  -38,  -27,   -8,    0,   -3,  -14,  -19,
     -20,  -14,  -10,  -13,   -3,    6,   12,   26,   38,   34,   14,    2,   -2,   11,   19,   14,
       8,    5,   16,    9,   -7,  -19,  -24,  -29,  -36,  -26,  -13,  -12,  -22,  -28,  -20,    5,
      -3,  -10,  -19,    7,   20,   18,   17,   24,   25,   14,   18,   19,   29,   21,   11,   10,
       9,   13,  -13,  -29,  -27,  -20,  -24,  -30,  -22,  -12,   -7,  -15,  -22,  -21,  -13,  -14,
     -20,   -8,   12,   26,   25,   21,   33,   27,   25,   16,   13,   16,   16,   -2,    2,   11,
       9,   -2,  -17,  -18,  -16,  -25,  -25,  -26,  -27,  -30,  -35,  -30,  -12,   -6,   -6,   -6,
      -5,   19,   19,   11,   15,   17,   24,   23,   34,   28,   23,   13,    2,    9,   18,   16,
     -14,  -18,  -12,   -7,   -9,  -31,  -37,  -33,  -24,  -14,  -24,  -20,  -16,  -21,  -15,   -7,
       5,    9,   15,   20,   28,   38,   29,   21,   15,   22,   17,    4,   12,    6,   12,   -4,
      -9,  -15,  -16,  -19,  -40,  -38,  -34,  -23,  -18,  -17,   -8,  -10,   -3,   -7,    1,    3,
       4,   11,   13,   36,   41,   36,   24,    9,   17,   20,   21,   14,   -5,   -9,  -11,   -8,
     -19,  -14,  -24,  -30,  -23,  -18,  -25,  -30,  -24,  -17,  -20,   -9,   -3,    6,    8,   22,
      23,   20,   27,   18,   10,   10,   14,   18,   14,   23,   17,    6,    5,   -4,   -8,  -26,
     -19,  -24,  -25,  -24,  -21,  -27,  -28,  -15,  -19,  -16,   -9,    0,    7,    9,   17,   14,
      15,   24,   30,   29,   29,   32,   16,   10,    8,    0,   -3,  -10,   -7,  -17,  -22,  -25,
     -30,  -36,  -32,  -25,  -26,  -22,  -12,  -16,  -11,   -3,    5,    7,   13,   21,   21,   26,
      32,   28,   26,   28,   31,   17,   15,   15,    5,   -4,  -14,  -18,  -28,  -25,  -24,  -28,
     -32,  -33,  -32,  -29,  -18,  -17,  -20,  -10,   -4,    6,    6,   18,   22,   22,   37,   38,
      31,   27,   26,   23,   22,   23,   12,    4,   -5,   -2,  -11,  -19,  -25,  -35,  -35,  -36,
     -36,  -43,  -32,  -24,  -20,  -12,   -7,   -3,   -7,    3,   13,   23,   29,   35,   37,   35,
      42,   33,   26,   22,   17,   12,    6,    4,   -9,  -23,  -28,  -34,  -34,  -33,  -31,  -40,
     -36,  -27,  -25,  -22,  -30,  -20,  -11,    2,   12,   22,   22,   26,   28,   35,   47,   44,
      27,   29,   29,   29,   19,    2,    1,   -9,  -15,  -21,  -34,  -35,  -34,  -40,  -44,  -42,
     -34,  -31,  -26,  -21,   -9,  -12,   -3,   10,   17,   29,   26,   27,   34,   48,   50,   34,
      33,   25,   21,   16,    8,    3,   -8,  -11,  -25,  -30,  -37,  -37,  -42,  -51,  -34,  -28,
     -21,  -26,  -25,  -19,  -13,    4,    9,   17,   29,   41,   33,   33,   44,   45,   32,   31,
      28,   22,   16,    5,  -10,  -13,  -16,  -23,  -38,  -39,  -39,  -45,  -54,  -40,  -32,  -24,
     -22,  -17,  -14,    0,    6,    9,   18,   41,   43,   34,   32,   40,   40,   31,   30,   27,
      22,   19,   14,   -2,  -16,  -21,  -34,  -48,  -45,  -41,  -41,  -41,  -45,  -38,  -25,  -21,
     -17,  -20,   -7,   11,   17,   19,   36,   40,   42,   44,   47,   46,   39,   33,   26,   15,
      11,    8,   -5,  -19,  -24,  -29,  -40,  -44,  -48,  -44,  -37,  -37,  -43,  -43,  -26,  -19,
     -14,   -2,   13,   23,   31,   36,   36,   43,   41,   47,   46,   44,   40,   24,   15,   14,
       3,  -12,  -21,  -23,  -30,  -36,  -47,  -51,  -50,  -47,  -44,  -46,  -31,  -19,  -16,  -11,
       2,   16,   20,   25,   29,   40,   53,   51,   49,   45,   41,   35,   25,   18,    7,    5,
     -12,  -18,  -23,  -34,  -39,  -56,  -58,  -54,  -49,  -50,  -45,  -35,  -26,  -12,   -5,    6,
      17,   29,   41,   42,   47,   50,   46,   49,   50,   50,   39,   30,   16,    2,   -8,  -15,
     -21,  -30,  -41,  -49,  -50,  -46,  -57,  -63,  -57,  -41,  -29,  -24,  -12,   -3,    5,   12,
      22,   33,   41,   50,   51,   53,   57,   55,   46,   36,   29,   16,    2,   -4,  -11,  -21,
     -33,  -40,  -49,  -47,  -53,  -60,  -58,  -51,  -42,  -34,  -23,  -13,   -2,    5,   17,   27,
      39,   49,   48,   51,   56,   54,   58,   44,   37,   28,   18,    4,   -3,  -15,  -29,  -39,
     -49,  -49,  -51,  -62,  -65,  -64,  -47,  -42,  -36,  -26,  -14,   -5,   10,   24,   32,   45,
      50,   49,   62,   65,   63,   47,   42,   41,   36,   23,    7,   -7,  -22,  -31,  -41,  -53,
     -58,  -62,  -59,  -62,  -56,  -54,  -50,  -44,  -32,  -16,    0,   11,   25,   35,   50,   54,
      55,   56,   66,   65,   62,   54,   45,   36,   23,   14,   -4,  -22,  -44,  -55,  -52,  -62,
     -61,  -66,  -70,  -68,  -60,  -54,  -45,  -29,  -15,    4,   21,   34,   36,   44,   54,   62,
      70,   73,   68,   67,   59,   50,   37,   21,   -5,  -12,  -25,  -39,  -48,  -53,  -63,  -76,
     -73,  -71,  -71,  -67,  -57,  -45,  -29,  -12,    2,   13,   30,   42,   51,   61,   76,   71,
      63,   66,   71,   60,   50,   40,   23,   -2,   -9,  -20,  -41,  -54,  -59,  -72,  -79,  -71,
     -64,  -73,  -68,  -60,  -51,  -36,  -13,    2,   13,   27,   47,   54,   71,   78,   71,   60,
      72,   74,   65,   54,   39,   28,    7,   -6,  -23,  -50,  -59,  -64,  -69,  -75,  -70,  -78,
     -74,  -73,  -64,  -52,  -37,  -13,    6,   18,   40,   51,   58,   64,   78,   79,   75,   68,
      64,   68,   57,   45,   21,    4,  -16,  -34,  -50,  -65,  -75,  -83,  -80,  -71,  -69,  -68,
     -73,  -63,  -57,  -36,  -16,    6,   26,   45,   60,   70,   71,   79,   79,   81,   78,   80,
      64,   55,   36,   16,   -4,  -23,  -38,  -54,  -63,  -69,  -81,  -85,  -87,  -76,  -72,  -66,
     -61,  -52,  -30,  -12,   12,   24,   44,   55,   69,   78,   85,   84,   74,   70,   71,   71,
      62,   41,   17,  -11,  -25,  -42,  -55,  -66,  -75,  -87,  -87,  -81,  -74,  -76,  -76,  -63,
     -48,  -32,  -13,    7,   30,   51,   64,   76,   80,   82,   83,   81,   80,   82,   70,   61,
      42,   19,    0,  -28,  -49,  -61,  -72,  -78,  -87,  -90,  -89,  -88,  -87,  -82,  -69,  -54,
     -33,  -13,   15,   36,   58,   68,   79,   90,   96,   90,   84,   86,   89,   79,   62,   38,
      22,   -3,  -29,  -55,  -69,  -81,  -89,  -94,  -94,  -94,  -94,  -89,  -74,  -62,  -52,  -35,
     -18,   14,   39,   54,   65,   76,   87,   98,   95,   94,   90,   82,   75,   69,   47,   26,
      -6,  -33,  -57,  -72,  -82,  -88,  -97,  -90,  -91,  -88,  -83,  -80,  -75,  -59,  -33,   -9,
      20,   42,   58,   68,   82,   90,   94,   93,   94,   88,   85,   77,   65,   43,   16,  -10,
     -37,  -60,  -71,  -84,  -89,  -95,  -97, -102,  -95,  -84,  -80,  -72,  -57,  -26,   -4,   19,
      42,   62,   80,   89,   94,   97,  100,   99,   90,   83,   71,   65,   39,   14,   -9,  -43,
     -65,  -83,  -90,  -95,  -98,  -96, -100,  -96,  -88,  -76,  -66,  -51,  -24,  -12,   21,   45,
      70,   85,   93,   95,   97,  101,  105,   92,   84,   69,   58,   35,   16,  -14,  -44,  -68,
     -86,  -88,  -96, -101, -101, -102,  -97,  -90,  -74,  -69,  -50,  -19,    9,   35,   56,   76,
      84,   92,   98,   96,   99,   97,   93,   84,   77,   59,   24,    2,  -30,  -52,  -76,  -87,
     -93,  -98, -100, -102, -100,  -96,  -89,  -81,  -73,  -46,  -18,   12,   36,   62,   82,   88,
      96,  104,  107,  105,  102,   92,   84,   77,   53,   26,   -6,  -35,  -57,  -75,  -81,  -92,
    -103, -114, -111, -108,  -98,  -88,  -83,  -67,  -35,   -7,   20,   39,   60,   70,   89,  106,
     116,  107,  103,   99,   86,   90,   82,   53,   18,  -13,  -31,  -52,  -73,  -92, -102, -106,
    -104,  -97, -106,  -99, -101,  -92,  -72,  -42,   -5,   16,   38,   66,   86,  101,   99,  101,
      95,  112,  107,   99,   95,   81,   53,   16,   -3,  -29,  -60,  -81, -102,  -98, -102, -102,
    -112, -114, -101, -104,  -88,  -69,  -34,   -8,   14,   41,   67,   92,   94,   99,  103,  104,
     115,  109,  103,   90,   78,   52,   22,    0,  -39,  -65,  -92,  -95,  -91, -103, -104, -118,
    -110, -102,  -93,  -84,  -71,  -36,  -15,   19,   52,   81,   94,   89,   98,  103,  115,  117,
     102,   92,   83,   80,   49,   23,  -11,  -43,  -67,  -90,  -93, -102, -105, -110, -118, -104,
    -100,  -89,  -83,  -64,  -36,   -7,   28,   50,   74,   88,   95,  104,  103,  115,  107,  106,
      97,   87,   74,   50,   20,  -17,  -47,  -75,  -89,  -93, -101, -102, -115, -117, -106,  -97,
     -88,  -90,  -73,  -38,    2,   36,   60,   75,   84,   96,  104,  115,  115,  102,   98,   96,
      96,   84,   52,   10,  -12,  -32,  -53,  -71,  -87, -101, -109, -112, -109, -106, -105, -102,
     -92,  -74,  -48,  -19,    7,   33,   56,   76,   91,  101,  108,  111,  111,  108,  103,   96,
      85,   63,   33,    1,  -27,  -51,  -73,  -90, -102, -109, -112, -110, -107, -103, -100,  -93,
     -76,  -50,  -19,   10,   36,   58,   76,   91,  101,  108,  111,  111,  108,  103,   96,   85,
      63,   33,    1,  -27,  -51,  -73,  -90, -102, -109, -112, -110, -107, -103, -100,  -93,  -76,
     -50,  -19,   10,   36,   58,   76,   -1,   -2,  -15,   21,  -17,   23,  -30,    1,   34,  -34,
       6,    5,  -15,   19,    1,  -25,    6,   20,   -2,  -28,   15,   10,  -15,    0,   -7,   10,
       7,   -5,   -9,   -6,   19,   -3,  -21,    3,   20,   -4,  -20,    1,   16,   -3,   -8,   -2,
       5,    1,   -8,   -6,    3,    9,    2,  -13,   -4,   15,   -7,   -9,    0,    3,    6,   -7,
      -7,    5,    8,   -8,   -4,    0,    1,    1,   -6,   -4,    7,    2,   -2,   -7,    0,    4,
      -3,   -4,    0,    2,    0,   -2,   -4,    1,    4,   -2,   -4,   -3,    1,    3,   -5,   -4,
       4,    3,   -6,   -5,    4,   -1,   -2,   -3,    0,    3,   -3,   -1,   -4,    3,    3,   -5,
      -3,    1,    1,   -2,   -3,    1,    2,   -2,   -4,    0,    0,    0,   -1,   -3,    1,    1,
      -3,   -2,    1,    0,   -2,   -2,    0,    0,   -2,   -1,    0,   -1,    1,   -2,   -2,    1,
       0,   -2,    0,   -1,    0,   -1,   -1,   -1,    0,    0,   -1,   -3,    1,    1,   -2,   -2,
       0,    1,   -1,   -2,   -1,    0,    0,    0,   -2,   -1,    1,    0,   -3,    0,    2,   -1,
      -2,    0,    0,    0,   -2,    0,   -1,    0,   -1,   -1,    1,    0,   -1,    0,   -1,    1,
       0,  -13,    5,    7,  -11,   24,  -50,   41,    4,  -29,   14,  -11,    8,   11,  -15,  -12,
      15,   18,  -21,  -14,   22,   -2,  -11,   -3,   -3,   18,   -3,   -5,  -14,    9,   22,  -24,
     -16,   23,   12,  -23,   -8,    9,   10,   -4,   -8,   -3,   11,   -4,  -14,    0,    8,    8,
      -5,  -14,    8,   10,  -12,   -4,   -2,   10,    0,  -11,   -3,   11,    0,   -7,   -2,   -1,
       7,   -6,   -8,    3,    6,    0,   -3,   -8,    7,    2,   -7,   -2,    2,    1,   -2,   -4,
      -1,    3,    3,   -4,   -5,    1,    3,   -3,   -6,    2,    5,   -1,   -7,   -1,    3,   -1,
      -4,   -3,    5,    0,   -3,   -2,   -1,    4,   -1,   -5,   -1,    3,   -1,   -4,   -1,    3,
       1,   -4,   -2,    1,    0,   -2,   -3,    0,    2,   -1,   -4,    1,    1,   -1,   -2,   -2,
       1,   -1,   -3,    0,    0,    0,   -1,   -2,    0,    0,   -2,   -1,    0,   -1,    0,   -2,
      -1,    0,   -1,    0,   -1,   -2,    2,   -1,   -2,   -1,    0,    1,   -2,    0,   -1,   -1,
       0,   -1,   -2,    0,    1,   -1,   -3,    0,    1,   -1,   -3,    0,    1,   -2,   -1,    0,
       0,   -1,   -1,    0,   -1,   -1,   -1,   -1,    0,    0,   -1,   -1,    0,    0,   -2,    0,
       0,    0,    0,   -2,    1,   -1,    0,   -1,    0,    0,    0,   -1,    0,    0,    0,    0,
      -1,    0,    0,   -1,    0,   -1,    1,    0,    0,    0,    1,   -1,   -1,    0,    0,    0,
       1,   -2,    4,   -3,    3,  -40,   71,  -73,   67,  -27,  -68,  127,  -80,    3,    5,    1,
      17,  -14,    1,  -30,   53,   -3,  -42,   15,   19,   -9,  -17,   -1,   13,   16,  -17,    4,
     -32,   43,   15,  -68,   18,   54,  -38,   -7,   -1,   11,    7,   -3,  -18,    5,   25,  -27,
      -9,    9,   19,   -6,  -12,   -8,   20,   -1,  -15,   -1,    1,   17,  -10,  -16,   12,   12,
     -13,    0,   -6,   10,    2,  -16,   -1,   14,   -4,    4,  -11,   -2,   12,   -6,   -8,    4,
       4,   -2,   -4,    1,   -2,    4,    3,   -7,   -5,    8,    0,  -10,    1,    4,    2,   -4,
      -6,    4,    1,   -1,   -7,    1,    8,   -9,    2,   -5,    3,    3,   -4,   -3,    0,    3,
      -3,   -5,    4,    3,   -3,   -4,    0,    2,    0,   -3,   -4,    5,    0,   -5,   -1,    2,
       0,   -3,    0,   -1,    2,   -2,   -4,    3,    0,   -1,   -2,   -1,    2,   -2,   -2,    1,
      -1,    0,   -1,   -3,    1,    1,   -2,    1,   -3,    1,    1,   -3,   -1,    1,    0,   -1,
      -2,    1,   -1,   -1,    1,   -2,    1,   -1,   -1,   -1,   -1,    0,    1,   -3,    0,    0,
       1,   -4,    0,    1,   -2,    0,   -2,    0,    0,    0,   -2,    1,   -1,    0,   -2,    0,
       2,   -2,   -1,    0,   -1,    2,   -2,   -1,    1,   -2,    0,   -1,    1,   -1,   -1,   -1,
       1,   -2,    1,   -1,   -1,    2,   -3,    0,    0,   -1,    1,   -1,    0,    1,    0,   -2,
       0,   -1,    1,   -2,    0,    0,   -1,    1,    0,   -2,    0,    1,   -2,    1,    0,    0,
      -1,    0,    1,   -1,   -1,   -1,    1,    1,   -1,    0,    0,    0,   -1,    1,    0,   -1,
       1,    0,    0,    1,    0,   -1,    1,    0,    3,  -40,   58,  -39,   12,   42, -117,  108,
       1,  -66,   22,   17,    0,   -9,   10,  -39,   42,    4,  -23,  -12,   28,    3,  -34,    9,
      17,    3,   -9,   10,  -29,   13,   53,  -79,    3,   64,  -26,  -24,   16,   -9,   14,    2,
      -8,  -15,   31,   -9,  -30,   11,   29,  -15,   -7,    0,    3,    6,   -4,   -9,   -6,   22,
       1,  -24,    9,   11,   -8,    0,   -2,    2,    8,  -12,   -6,   10,    2,    2,   -9,   -4,
      11,   -2,  -10,    3,    2,    3,   -5,   -1,    1,   -1,    6,   -4,   -8,    9,    2,   -8,
      -3,    6,    3,   -4,   -3,   -1,    6,   -2,   -8,    0,    9,   -4,   -3,   -2,    2,    4,
      -4,   -1,   -1,    4,   -2,   -6,    4,    2,   -1,   -4,    0,    1,    2,   -3,   -5,    3,
       3,   -3,   -4,    3,    0,   -1,    0,   -2,    2,    0,   -3,    0,    3,    0,   -3,   -1,
       2,    0,   -3,    1,    0,   -1,    2,   -2,   -2,    2,   -1,    0,   -1,   -1,    1,   -1,
      -2,    0,    0,    1,   -3,    1,    0,   -1,    1,   -2,   -1,    2,   -2,   -1,    0,   -1,
       2,   -3,   -1,    1,    1,   -2,   -2,    2,    1,   -2,   -1,    0,    0,    1,   -3,    1,
       0,    0,    0,   -2,    3,    0,   -2,    0,    0,    1,    0,   -1,    1,   -2,    0,    0,
       0,   -1,    1,    0,    0,    0,   -1,    1,   -1,    1,    0,   -1,    1,   -2,    0,    1,
       1,    0,    1,   -2,    1,    0,    1,    0,    0,    3,   -1,    0,    1,    0,    0,    3,
     -29,   35,  -12,  -16,   56,  -88,   39,   62,  -79,    5,   29,    1,  -13,   12,  -29,   26,
      17,  -28,   -3,   12,    5,  -11,  -19,   28,    1,   -5,    9,  -21,   -7,   60,  -56,  -20,
      57,  -10,  -27,   21,  -21,   16,   12,  -12,  -21,   24,    6,  -29,    4,   19,    2,   -7,
      -5,   -3,    7,    6,  -11,   -9,   11,   13,  -18,   -4,   13,    1,   -3,   -6,   -1,   10,
      -8,   -6,    5,    3,    5,   -3,  -11,    4,    9,  -11,    0,    4,    3,   -4,   -1,    0,
       0,    7,    0,  -14,    7,    5,   -7,   -4,    4,    5,   -1,   -4,   -4,    4,    1,   -4,
      -4,    7,   -1,   -1,   -3,    0,    5,   -1,   -4,   -1,    2,    0,   -3,    1,    1,    2,
      -2,   -4,    1,    2,    0,   -5,    2,    3,   -2,   -2,    1,    1,   -2,    2,   -3,    0,
       0,   -1,   -1,    0,    1,    0,   -3,    0,    0,   -1,    1,   -1,   -2,    1,   -1,    0,
      -2,    2,    1,   -2,   -1,    1,    0,   -1,   -1,    0,    1,   -1,    0,   -2,    1,    1,
      -1,    0,   -1,   -1,    0,    0,   -1,   -1,    0,   -1,   -1,    2,   -2,   -1,    1,    0,
       0,   -1,   -1,    1,    0,   -1,    1,   -1,    0,    1,   -3,    1,    1,   -1,   -1,    0,
       1,    0,    0,    0,   -1,    0,    0,   -1,    0,    1,    0,    0,    2,   -2,    0,    1,
       0,    0,    0,    0,    1,    0,    0,    1,    0,    1,   -1,   -1,   -7,   -9,   35,  -52,
      59,  -33,  -32,   64,  -15,  -41,   19,   22,  -20,    9,  -11,   -3,   33,  -27,    2,    7,
      -9,   19,  -37,   24,    7,  -11,   11,   -1,  -30,   37,    8,  -57,   36,   19,  -33,   14,
       0,  -17,   26,    1,  -20,   -5,   26,  -18,  -13,   14,    7,   -6,    4,   -9,   -4,   11,
       3,  -14,   -7,   20,    0,  -18,   10,    1,    4,   -5,   -7,    6,    0,   -3,   -2,   -2,
       8,    5,  -11,   -6,   10,   -1,  -10,    6,   -2,   -1,    1,   -3,    0,    3,    5,   -9,
      -5,    9,   -3,   -4,    1,    1,    3,   -1,   -4,   -1,    2,   -2,   -5,    5,   -3,    0,
       1,   -5,    4,    2,   -3,   -3,    0,    0,   -2,    1,    0,   -2,    3,   -2,   -5,    2,
       2,   -2,   -4,    3,    0,   -2,    1,   -2,   -2,    5,   -2,   -6,    1,    2,   -1,   -1,
       0,    1,   -1,   -2,   -1,   -1,    2,    0,   -4,    0,    1,    0,   -3,    0,    2,    0,
      -3,    0,    0,    1,   -1,   -1,    1,    0,   -1,   -2,    1,    0,    0,   -1,    0,   -2,
       1,    0,   -1,    1,   -1,    0,   -2,    1,    1,   -2,   -1,    2,   -2,    1,   -3,    1,
       1,   -1,    0,    0,   -1,    1,    0,   -2,    2,   -1,   -1,    0,    0,    1,    0,    1,
       0,   -2,    1,    0,    0,   -1,    1,    0,    0,    0,    0,   -3,  -20,   45,  -56,   40,
      -5,  -34,   27,   24,  -42,   -1,   29,  -14,   -4,    2,   -7,   24,  -20,   -1,   18,  -25,
      25,  -29,    9,   21,  -26,   14,    4,  -20,    7,   27,  -42,    5,   31,  -24,   -2,   19,
     -30,   21,    8,  -11,  -17,   20,    1,  -22,   11,    7,   -7,    6,   -5,   -7,    3,   11,
      -6,  -18,   11,   16,  -20,    1,    5,    2,   -3,   -3,    0,   -3,    4,   -1,   -7,    2,
      10,   -9,   -8,    7,    2,   -9,    5,   -1,   -5,    2,    1,   -3,   -2,    9,   -5,   -8,
       4,    1,   -5,    0,    1,    2,   -1,    0,   -5,    4,   -1,   -5,    4,   -3,    1,    1,
      -5,    3,    0,    0,   -3,    0,   -1,   -2,    1,    2,   -5,    2,    1,   -5,   -2,    3,
      -1,   -5,    2,    1,   -4,    2,   -1,   -4,    2,    3,   -7,   -1,    2,    0,   -2,    1,
       0,   -2,   -1,    0,   -3,    1,    2,   -3,   -2,    3,    0,   -3,   -1,    1,    0,   -1,
      -2,   -1,    1,    0,    0,   -1,    0,    0,   -2,    0,    0,    1,   -2,    2,   -3,    1,
       0,    0,   -2,    1,    0,   -1,    0,    0,   -1,   -1,    2,   -3,    0,    0,   -1,    0,
       0,   -1,    1,    0,   -4,  -13,   32,  -41,   31,  -10,  -10,    4,   22,  -25,   -8,   21,
      -3,  -14,    5,    1,   12,  -23,    8,   18,  -31,   25,  -26,   10,   17,  -23,    8,    5,
      -9,    0,   16,  -25,    2,   23,  -22,   -2,   22,  -30,   15,    7,   -6,  -13,   12,    1,
     -17,    9,    5,   -6,    4,   -3,   -7,    5,    7,   -6,  -13,    7,   10,  -11,    0,    0,
       4,   -3,   -3,    2,   -7,    4,    2,   -5,    0,    6,   -3,   -8,    4,    2,   -8,    7,
       0,   -8,   -1,    6,    0,   -8,    6,    0,   -5,    1,    0,   -5,    3,    2,   -3,   -2,
       4,   -5,   -1,   -1,   -2,    3,   -4,    1,   -1,   -3,    3,   -1,   -2,   -2,    1,   -2,
      -2,    1,    1,   -4,    1,    2,   -5,   -3,    5,   -3,   -4,    4,   -1,   -4,    2,   -1,
      -4,    3,    1,   -5,   -2,    2,    0,   -2,    2,   -1,   -4,    3,   -1,   -3,    0,    1,
      -2,   -2,    1,   -1,   -1,   -1,    0,    0,   -1,   -1,   -1,    0,   -1,    1,   -1,   -1,
       0,   -2,    1,    0,   -1,   -1,    0,   -1,   -1,   -1,    2,   -2,   -1,    1,   -1,   -2,
       1,   -1,   -1,    1,   -2,    1,   -7,   -3,   15,  -23,   20,  -16,    9,  -12,   16,  -12,
      -8,   11,    5,  -18,    6,    8,    0,  -18,   16,    4,  -19,   16,  -17,   10,    5,   -8,
      -2,    9,   -5,   -4,   10,  -17,    5,   13,  -18,    2,   12,  -17,   10,    0,   -2,   -8,
       7,   -4,   -7,    6,    1,   -3,    1,    3,   -9,   -2,   10,   -7,   -8,    4,    6,   -6,
       1,    0,    0,   -2,    1,   -1,   -8,    6,    1,   -5,    2,    4,   -2,   -4,    1,    1,
      -7,    5,   -1,   -4,   -2,    4,    0,   -4,    4,   -3,   -4,    1,    0,   -3,    0,    2,
      -1,   -2,    2,   -2,   -1,   -3,    0,    3,   -4,    3,   -3,    0,    2,    0,   -3,   -1,
       1,   -3,   -1,    2,    0,   -1,    0,    0,   -3,    0,    1,   -4,   -1,    2,    0,   -2,
       0,    1,   -3,    1,    1,   -3,   -2,    2,   -1,   -1,    2,   -1,   -2,    1,    0,   -1,
      -1,   -1,   -3,   -8,  -16,  -20,   -7,   14,   20,   19,   18,   16,   11,    3,   -9,  -21,
     -36,  -43,  -39,  -24,    6,   38,   57,   55,   26,    0,   -7,  -10,  -13,  -12,  -11,  -29,
     -56,  -59,  -37,    0,   43,   74,   87,   75,   37,   -2,  -31,  -51,  -59,  -45,  -15,  -16,
     -34,  -20,  -10,   -5,   29,   61,   72,   51,   18,   -2,  -21,  -39,  -35,  -24,    1,    0,
     -31,  -29,  -23,  -44,  -13,   48,   82,   79,   46,   16,   -4,  -44,  -58,  -26,    3,    6,
     -38,  -52,  -24,  -42,  -35,   47,   95,   88,   55,   19,   12,  -22,  -72,  -38,    4,    3,
     -31,  -67,  -29,  -24,  -60,   23,  112,  111,   72,   22,    7,  -20,  -90,  -73,   -1,   19,
      -4,  -57,  -36,    3,  -54,  -32,   98,  125,   71,   14,   14,    0,  -82, -106,    0,   42,
      10,  -48,  -32,   -2,  -54,  -63,   72,  125,   82,   24,   14,   -8,  -57, -104,  -22,   52,
      34,  -34,  -46,  -16,  -35,  -83,   32,  127,   99,   26,   19,    4,  -55, -110,  -48,   45,
      36,  -12,  -26,  -22,  -41,  -64,   -7,  107,  113,   56,    6,    4,  -41,  -92,  -74,   35,
      57,   12,  -41,  -21,  -39,  -67,  -40,   86,  114,   71,   10,   22,  -31,  -83,  -83,   16,
      46,   34,  -28,  -18,  -42,  -58,  -60,   55,  108,   97,    3,   21,   -8,  -77, -102,   10,
      45,   42,  -26,   -2,  -27,  -68,  -73,   45,   83,   92,   29,   25,   -8,  -56, -104,  -13,
      35,   52,   -6,   -7,  -22,  -46,  -91,   10,   80,   95,   35,   26,    8,  -38, -106,  -34,
      34,   42,    5,    1,  -23,  -39,  -73,  -28,   61,   89,   60,   20,    2,   -7,  -73,  -86,
      24,   52,   26,  -12,  -11,  -19,  -58,  -86,   46,   91,   62,   17,   22,  -15,  -39, -106,
       8,   55,   45,  -13,   -6,  -30,  -21, -102,    4,   82,   87,    7,   28,   -3,   -9, -115,
     -32,   50,   63,  -23,    8,  -19,  -18,  -94,  -28,   61,   96,   14,   39,   -4,    1,  -85,
     -60,   23,   79,   -3,    2,  -20,  -10,  -82,  -65,   25,  108,   28,   31,   19,    9,  -65,
     -74,   -5,   78,   16,   -3,   -9,  -14,  -65,  -76,   -3,   93,   60,   29,   22,   13,  -43,
     -90,  -30,   61,   49,   -9,   -1,    4,  -52,  -98,  -16,   68,   72,   21,   38,   15,  -31,
     -94,  -34,   32,   67,    5,    9,    0,  -28, -111,  -33,   40,   85,   24,   37,   23,   -6,
    -104,  -44,   13,   69,    9,   14,    8,  -11, -110,  -53,   20,   80,   32,   48,   30,    5,
     -87,  -66,   -7,   63,   33,   12,    2,    5,  -86,  -94,   -2,   79,   46,   26,   44,   22,
     -59,  -88,  -19,   54,   48,   13,   14,    4,  -51, -112,  -37,   67,   71,   21,   38,   29,
     -29, -104,  -50,   44,   63,   11,   10,   14,  -24, -103,  -67,   49,   88,   20,   27,   43,
     -10,  -90,  -79,   24,   69,   21,    7,   18,   -8,  -82, -103,   17,   94,   38,   10,   54,
      12,  -70,  -97,    1,   68,   37,   -4,   27,   -6,  -56, -104,  -21,   82,   67,   -3,   46,
      23,  -37, -108,  -31,   57,   58,  -13,   29,   11,  -32, -106,  -50,   53,   92,   -6,   38,
      38,  -15, -105,  -54,   34,   79,  -12,   20,   22,  -11,  -98,  -70,   22,   99,    4,   16,
      48,   14,  -99,  -75,   15,   82,    2,    0,   44,    8,  -93,  -80,    0,   84,   29,   -3,
      57,   32,  -79,  -94,    1,   66,   27,  -19,   49,   29,  -73, -109,   -7,   54,   52,  -17,
      62,   53,  -46, -113,   -4,   43,   51,  -30,   46,   37,  -42, -128,  -23,   26,   69,  -18,
      51,   59,   -2, -122,  -30,   24,   66,  -27,   31,   51,    1, -128,  -48,   13,   71,  -11,
      33,   66,   22, -110,  -57,    8,   68,   -9,   12,   53,   28, -104,  -87,   -4,   67,    8,
       8,   72,   53,  -80,  -91,   -4,   59,   10,  -13,   63,   44,  -81, -109,  -19,   46,   33,
      -6,   76,   57,  -43, -104,  -24,   36,   42,  -26,   55,   51,  -34, -126,  -39,   19,   58,
     -21,   68,   71,   -8, -114,  -32,    2,   62,  -24,   52,   54,   -4, -120,  -53,  -22,   71,
      -8,   49,   62,   31, -102,  -52,  -25,   70,   -5,   24,   55,   35, -109,  -69,  -40,   59,
      16,   25,   65,   55,  -80,  -70,  -37,   47,   23,    7,   48,   51,  -73,  -97,  -48,   30,
      46,    6,   57,   74,  -37,  -98,  -34,   21,   48,  -10,   44,   58,  -34, -123,  -46,   -2,
      61,    2,   50,   69,   10, -110,  -40,   -5,   59,   -9,   31,   53,   19, -126,  -59,  -20,
      62,    8,   32,   64,   49, -105,  -59,  -16,   58,    2,   17,   50,   45, -102,  -83,  -31,
      46,   24,   15,   53,   69,  -65,  -86,  -24,   42,   25,   -4,   45,   64,  -58, -112,  -37,
      30,   41,   -6,   51,   75,  -24, -105,  -32,   26,   41,  -19,   39,   62,  -14, -117,  -51,
       7,   54,  -13,   35,   78,   19, -105,  -47,    9,   58,  -19,   21,   69,   18, -113,  -66,
     -10,   52,  -10,   14,   75,   42,  -83,  -60,   -5,   52,    0,   -3,   69,   43,  -83,  -83,
     -21,   35,   17,  -13,   72,   57,  -54,  -82,  -10,   29,   28,  -29,   65,   52,  -45,  -98,
     -21,    1,   40,  -30,   64,   63,   -7,  -94,   -9,    1,   51,  -36,   51,   54,   -8, -115,
     -23,  -22,   47,  -30,   48,   65,   24,  -90,  -13,  -15,   46,  -26,   30,   55,   21, -100,
     -37,  -26,   31,  -10,   24,   65,   41,  -71,  -35,  -10,   25,   -2,    4,   58,   32,  -69,
     -61,  -16,    2,    8,    1,   67,   42,  -33,  -56,   -1,   -1,   20,  -13,   59,   33,  -28,
     -82,  -10,  -20,   22,  -15,   64,   40,   -1,  -70,    0,  -17,   29,  -22,   53,   33,    1,
     -84,  -15,  -29,   22,  -19,   53,   43,   22,  -64,   -7,  -19,   25,  -18,   37,   38,   16,
     -73,  -30,  -33,   11,  -14,   32,   50,   31,  -45,  -17,  -15,   16,   -4,   16,   43,   23,
     -49,  -43,  -30,   -2,   -1,    8,   52,   36,  -25,  -32,  -13,   -1,   11,   -1,   42,   30,
     -25,  -49,  -25,  -18,   10,   -7,   44,   40,   -2,  -34,  -11,  -15,   21,   -6,   29,   33,
      -5,  -54,  -29,  -30,   13,   -6,   29,   46,   15,  -32,  -10,  -18,   16,   -1,   13,   36,
       9,  -45,  -30,  -32,    0,    1,   12,   43,   28,  -23,  -16,  -16,    6,    9,    2,   33,
      22,  -33,  -34,  -27,  -11,    2,    1,   35,   36,  -14,  -16,  -11,   -5,    8,    3,   24,
      32,  -19,  -30,  -29,  -17,   -4,    1,   20,   43,   -5,  -14,  -13,   -4,    0,    7,   11,
      39,   -9,  -23,  -28,  -17,  -16,    1,    9,   44,    3,   -7,  -15,   -4,   -4,    7,    5,
      38,    3,  -20,  -30,  -19,  -19,   -8,    0,   40,   17,   -6,   -7,   -3,   -2,   -1,    4,
      32,   16,  -20,  -21,  -26,  -17,  -18,   -3,   28,   32,   -7,   -1,   -9,    4,   -9,    3,
      22,   34,  -19,  -14,  -27,  -13,  -27,  -10,   16,   44,   -8,    5,   -6,    3,  -12,    1,
      13,   40,  -12,  -11,  -25,  -17,  -27,  -15,    5,   45,    4,    2,    0,    0,   -9,   -5,
       6,   38,    2,  -17,  -14,  -20,  -24,  -23,    0,   38,   19,   -4,   11,   -4,   -7,  -10,
       4,   27,   20,  -20,   -9,  -23,  -22,  -30,   -6,   26,   35,   -8,   12,    2,   -4,  -15,
       2,   20,   32,  -16,   -7,  -15,  -22,  -37,  -14,   18,   39,   -3,    5,    8,   -5,  -18,
      -2,   18,   34,   -4,  -14,   -4,  -21,  -35,  -25,   15,   36,    8,   -4,   21,   -5,  -17,
     -14,   23,   26,    9,  -22,    4,  -25,  -32,  -40,   14,   27,   24,  -12,   30,    1,   -8,
     -26,   24,   21,   19,  -28,    9,  -20,  -28,  -51,    7,   23,   30,  -15,   27,    9,   -7,
     -32,   16,   25,   23,  -21,    4,   -8,  -27,  -50,  -10,   25,   29,   -9,   13,   24,   -7,
     -28,   -3,   34,   20,  -12,   -9,   10,  -31,  -43,  -29,   30,   23,    2,   -3,   38,   -9,
     -19,  -19,   39,   18,   -1,  -20,   25,  -29,  -36,  -42,   26,   17,   12,  -14,   43,   -3,
     -15,  -29,   35,   19,    6,  -28,   27,  -18,  -36,  -48,   16,   17,   15,  -15,   39,   12,
     -13,  -29,   24,   24,    9,  -25,   19,   -1,  -39,  -50,    1,   18,   11,  -11,   25,   26,
     -14,  -26,   12,   32,   10,  -17,    6,   17,  -33,  -48,  -14,   20,    6,   -7,   11,   36,
      -9,  -26,   -1,   34,   11,   -9,   -4,   25,  -25,  -49,  -26,   19,    4,   -4,    5,   41,
       3,  -21,   -8,   31,   12,   -7,  -11,   23,  -13,  -47,  -37,   13,    6,   -3,    1,   40,
      14,  -17,  -14,   26,   16,   -2,  -12,   20,   -3,  -40,  -44,    2,    6,   -2,   -4,   35,
      24,   -9,  -19,   19,   17,    2,  -13,   16,    5,  -29,  -48,   -7,    4,    3,   -7,   28,
      28,    2,  -21,   13,   14,    9,  -14,   11,    9,  -15,  -49,  -17,   -3,    6,  -11,   20,
      30,   14,  -23,    7,   12,   14,  -11,    6,   10,   -4,  -46,  -24,  -10,    6,   -8,   11,
      29,   24,  -15,    0,   11,   14,   -4,   -2,   11,    3,  -37,  -36,  -13,   -3,   -2,    2,
      28,   27,   -2,  -10,   14,    9,    7,   -8,   13,    3,  -21,  -42,  -14,  -14,    4,   -6,
      24,   24,   13,  -16,   12,    3,   14,   -8,   12,    4,   -7,  -44,  -18,  -20,    5,   -6,
      18,   22,   23,  -13,    6,    2,   13,   -4,    5,    5,    1,  -36,  -26,  -20,   -1,   -1,
      10,   23,   25,   -3,   -4,    5,    9,    5,   -2,    8,    1,  -24,  -36,  -18,  -10,    4,
       1,   24,   23,   11,   -9,    8,    4,   12,   -7,    9,    1,  -12,  -40,  -19,  -16,    4,
      -4,   21,   21,   16,   -9,    6,    2,   13,   -4,    6,    6,   -4,  -33,  -24,  -18,   -2,
      -2,   10,   21,   18,    0,   -3,    3,    8,    6,   -1,    8,    0,  -18,  -31,  -19,  -10,
       1,    0,   19,   20,   13,   -5,    4,    5,   12,   -4,    5,    2,   -7,  -34,  -24,  -17,
       1,   -4,   13,   20,   21,   -3,    2,    5,   14,    0,    2,    4,    0,  -26,  -28,  -20,
      -6,   -4,    4,   18,   23,    6,   -3,    5,    9,    7,   -1,    6,    3,  -14,  -33,  -22,
     -14,   -1,   -1,   16,   22,   17,   -4,    4,    4,   10,   -2,    4,    3,   -4,  -30,  -25,
     -19,   -2,   -2,   11,   20,   23,    0,    0,    2,   10,    3,    1,    4,    1,  -23,  -30,
     -22,   -8,   -1,    4,   19,   23,   10,   -3,    4,    6,    8,   -2,    5,    2,  -13,  -33,
     -23,  -15,    0,   -1,   16,   21,   16,   -3,    3,    4,   11,    0,    5,    6,   -3,  -27,
     -25,  -19,   -4,   -2,    9,   19,   19,    2,   -3,    2,    8,    6,   -1,    8,    0,    0,
       2,   33,   42,   58,   71,   79,   85,   88,   91,   94,   79,   95,   82,  106,   86,  105,
      47,   16,   -6,   13,   44,   31,  -15,  -38,  -36,   20,   70,   41,   48,   58,   24,  -57,
    -127, -119, -102, -126, -128, -111,  -78,  -82,  -88,  -87,  -60,  -66,  -98, -104,  -99,  -97,
     -99, -104, -101,  -88,  -87,  -91,  -61,  -27,  -34,  -54,  -55,  -45,  -24,  -10,   -5,   -4,
       5,   34,   63,  101,   94,   78,   52,   51,   52,   74,   81,   77,   59,   46,   17,    7,
      39,   53,   47,   42,   66,   83,   73,   52,   28,   22,   11,    8,   11,    0,  -15,  -23,
     -15,  -14,   -6,   16,   46,   62,   71,   76,   90,  102,  103,  103,  101,  100,   90,   75,
      63,   67,   49,   37,   28,   12,    5,    6,   15,   15,    8,   -7,  -12,   -4,  -10,  -28,
     -24,  -17,  -25,  -50,  -64,  -81, -103, -116, -116, -113,  -95,  -72,  -54,  -41,  -47,  -65,
     -65,  -50,  -33,  -24,   -7,   11,    8,   -4,  -13,  -28,  -51,  -75,  -90,  -91,  -90,  -90,
     -87,  -88,  -83,  -84,  -82,  -81,  -81,  -76,  -65,  -71,  -85,  -84,  -79,  -83,  -81,  -77,
     -72,  -70,  -65,  -66,  -66,  -65,  -66,  -68,  -61,  -56,  -51,  -36,  -13,   -3,   -5,   -8,
     -12,  -12,    3,   16,   21,   31,   50,   69,   77,   82,   90,  102,  110,  114,  116,  117,
     118,  119,  116,  112,  109,  105,   98,   99,  103,  102,   91,   73,   64,   63,   61,   57,
      51,   40,   24,   35,   57,   75,   84,   79,   65,   37,    4,  -26,  -45,  -57,  -54,  -46,
     -45,  -54,  -67,  -67,  -48,  -16,   15,   35,   44,   45,   44,   45,   46,   38,   23,    2,
     -15,  -34,  -52,  -60,  -70,  -77,  -80,  -79,  -74,  -77,  -84,  -86,  -80,  -72,  -68,  -72,
     -80,  -87,  -92,  -96, -101, -104, -104, -101,  -93,  -90,  -89,  -86,  -85,  -84,  -83,  -82,
     -81,  -79,  -77,  -76,  -73,  -71,  -66,  -62,  -55,  -39,  -31,  -27,  -25,  -31,  -37,  -46,
     -51,  -53,  -54,  -48,  -45,  -38,  -20,    3,   24,   35,   39,   32,   16,    5,    3,    0,
      -6,  -13,  -13,  -11,   -2,   14,   28,   40,   50,   53,   50,   55,   64,   74,   90,  105,
     108,  112,  106,  104,  109,  112,  123,  127,  127,  127,  127,  127,  127,  118,  113,  107,
     110,  114,  111,  104,  101,  101,  102,  103,   99,   99,   89,   73,   53,   35,   20,    0,
     -22,  -43,  -63,  -77,  -82,  -76,  -65,  -48,  -36,  -29,  -24,  -25,  -29,  -37,  -40,  -49,
     -59,  -67,  -73,  -76,  -78,  -79,  -75,  -73,  -74,  -75,  -68,  -52,  -44,  -30,  -19,   -9,
      -6,   -9,  -13,  -24,  -33,  -35,  -31,  -30,  -35,  -40,  -44,  -45,  -51,  -53,  -54,  -50,
     -50,  -47,  -42,  -50,  -55,  -54,  -56,  -56,  -54,  -54,  -49,  -48,  -41,  -32,  -28,  -18,
     -13,   -5,    6,   18,   33,   49,   60,   71,   78,   88,   95,   97,   93,   88,   91,   93,
      97,   98,   97,   94,   91,   85,   81,   72,   70,   66,   61,   60,   64,   66,   74,   83,
      92,  102,  108,  109,  107,  102,   97,   95,   91,   87,   80,   74,   67,   62,   61,   58,
      61,   61,   57,   53,   43,   35,   27,   25,   24,   20,   20,   22,   27,   34,   36,   32,
      21,    8,   -3,  -10,  -16,  -18,  -16,  -16,  -19,  -15,  -11,  -11,  -12,  -20,  -34,  -45,
     -59,  -72,  -80,  -89,  -94,  -95, -102, -111, -114, -111, -111, -108, -106, -104, -101,  -98,
     -93,  -90,  -86,  -86,  -83,  -82,  -81,  -79,  -76,  -73,  -70,  -72,  -78,  -81,  -79,  -79,
     -72,  -60,  -43,  -31,  -25,  -27,  -34,  -37,  -40,  -42,  -41,  -39,  -36,  -34,  -25,  -12,
      -4,    5,   12,   16,   17,   15,   13,    6,   -4,   -7,   -8,   -6,   -1,    4,    7,    9,
      12,   16,   19,   19,   22,   28,   29,   28,   29,   30,   34,   40,   49,   57,   71,   78,
      85,   92,   96,   95,   89,   85,   86,   93,   99,  104,  102,  100,   94,   85,   77,   73,
      69,   66,   63,   60,   60,   59,   57,   52,   47,   41,   31,   18,    6,   -3,   -7,  -11,
     -12,  -14,  -18,  -22,  -23,  -22,  -24,  -30,  -37,  -41,  -44,  -50,  -56,  -64,  -67,  -65,
     -62,  -58,  -58,  -58,  -59,  -61,  -62,  -66,  -72,  -78,  -79,  -77,  -73,  -68,  -64,  -61,
     -56,  -53,  -54,  -52,  -52,  -57,  -63,  -69,  -70,  -68,  -65,  -62,  -59,  -57,  -56,  -58,
     -60,  -61,  -63,  -64,  -62,  -61,  -60,  -58,  -54,  -49,  -45,  -42,  -39,  -36,  -32,  -28,
     -22,  -13,   -7,   -3,    2,   13,   28,   41,   52,   64,   71,   73,   73,   70,   64,   61,
      60,   64,   66,   65,   66,   64,   61,   60,   62,   65,   64,   66,   67,   67,   68,   66,
      64,   66,   68,   73,   76,   74,   72,   66,   58,   52,   46,   42,   38,   38,   41,   47,
      52,   52,   48,   45,   42,   40,   38,   34,   29,   27,   26,   28,   29,   28,   29,   30,
      31,   28,   24,   21,   19,   17,   14,   10,    6,    3,   -4,   -9,  -15,  -19,  -26,  -33,
     -40,  -49,  -55,  -60,  -65,  -70,  -73,  -72,  -72,  -71,  -70,  -71,  -75,  -78,  -81,  -83,
     -86,  -86,  -85,  -84,  -82,  -80,  -77,  -72,  -69,  -66,  -63,  -61,  -61,  -61,  -61,  -61,
     -60,  -58,  -53,  -48,  -42,  -36,  -30,  -28,  -30,  -32,  -33,  -32,  -31,  -28,  -22,  -18,
     -10,   -5,    0,    3,    6,   11,   16,   19,   22,   24,   26,   27,   29,   34,   40,   46,
      48,   48,   48,   45,   40,   36,   33,   31,   33,   35,   40,   48,   55,   62,   68,   73,
      76,   78,   78,   77,   79,   82,   85,   87,   87,   87,   86,   86,   86,   83,   78,   71,
      63,   55,   48,   44,   39,   36,   36,   36,   35,   32,   28,   24,   18,   13,    9,    6,
       4,    1,   -2,   -5,  -11,  -17,  -20,  -21,  -20,  -21,  -24,  -28,  -32,  -34,  -33,  -33,
     -35,  -37,  -40,  -43,  -47,  -52,  -58,  -63,  -69,  -74,  -77,  -80,  -81,  -82,  -81,  -80,
     -77,  -74,  -69,  -62,  -54,  -48,  -48,  -51,  -54,  -57,  -57,  -57,  -56,  -55,  -55,  -56,
     -57,  -56,  -55,  -54,  -54,  -54,  -54,  -52,  -49,  -45,  -41,  -38,  -34,  -31,  -29,  -27,
     -24,  -20,  -17,  -11,   -7,   -3,    0,    5,   10,   16,   22,   27,   31,   34,   38,   42,
      44,   45,   48,   50,   52,   57,   61,   64,   64,   65,   65,   63,   60,   57,   55,   55,
      58,   61,   63,   65,   67,   69,   71,   74,   77,   79,   79,   77,   74,   71,   68,   66,
      63,   60,   57,   55,   51,   46,   40,   36,   30,   25,   20,   17,   16,   17,   16,   14,
      12,   10,    7,    3,   -1,   -5,  -11,  -15,  -17,  -18,  -18,  -19,  -21,  -25,  -29,  -32,
     -33,  -33,  -36,  -39,  -43,  -46,  -50,  -53,  -56,  -58,  -59,  -60,  -61,  -62,  -63,  -65,
     -66,  -67,  -68,  -70,  -72,  -72,  -70,  -67,  -63,  -61,  -60,  -60,  -58,  -56,  -54,  -53,
     -52,  -52,  -52,  -51,  -50,  -49,  -47,  -45,  -43,  -40,  -37,  -35,  -34,  -32,  -29,  -25,
     -21,  -18,  -14,   -9,   -4,    0,    4,    7,   11,   15,   18,   21,   25,   28,   33,   37,
      41,   44,   46,   47,   47,   46,   46,   45,   43,   42,   42,   43,   46,   48,   49,   50,
      52,   55,   59,   62,   65,   66,   67,   68,   69,   69,   70,   72,   74,   74,   73,   72,
      71,   69,   65,   61,   57,   53,   50,   46,   43,   38,   35,   32,   28,   23,   19,   17,
      17,   15,   13,   11,    9,    5,    1,   -3,   -6,   -9,  -12,  -14,  -17,  -19,  -23,  -27,
     -31,  -35,  -38,  -40,  -43,  -46,  -48,  -52,  -55,  -57,  -61,  -64,  -66,  -67,  -68,  -69,
     -70,  -70,  -70,  -69,  -69,  -70,  -71,  -70,  -66,  -62,  -59,  -55,  -52,  -50,  -46,  -43,
     -41,  -38,  -36,  -35,  -35,  -34,  -33,  -33,  -33,  -33,  -31,  -30,  -28,  -26,  -25,  -24,
     -21,  -20,  -20,  -19,  -