" This file is autogenerated from the script 'generate_L2U_keymap.jl'
" The symbols are based on Julia version 1.12.0-DEV.387
" The full generating script can be found in the comments at the bottom of this file,
" and it can be extracted with:
"
"     $ grep '^">' latex2unicode_utf-8.vim | cut -c4- > 'generate_L2U_keymap.jl'
"
" To produce this keymap file you need to have Julia compilied from source, and
" to run `make deps` inside Julia's `doc` directory.
" Then you can run:
"
"     $ julia generate_L2U_keymap.jl
"

scriptencoding utf-8

let b:keymap_name = "L2U"
loadkeymap

" Tab completion sequence   Code point                   " Character  : Unicode name
" ------------------------- ---------------------------- " ---------- : --------------------------------------------------------------------------------------------------------
\\0/3                       <char-0x02189>               " ↉          : VULGAR FRACTION ZERO THIRDS
\\1/                        <char-0x0215F>               " ⅟          : FRACTION NUMERATOR ONE
\\1/1                       \\1/1                        "            : (Incomplete sequence)
\\1/10                      <char-0x02152>               " ⅒          : VULGAR FRACTION ONE TENTH
\\1/2                       <char-0x000BD>               " ½          : VULGAR FRACTION ONE HALF / FRACTION ONE HALF
\\1/3                       <char-0x02153>               " ⅓          : VULGAR FRACTION ONE THIRD / FRACTION ONE THIRD
\\1/4                       <char-0x000BC>               " ¼          : VULGAR FRACTION ONE QUARTER / FRACTION ONE QUARTER
\\1/5                       <char-0x02155>               " ⅕          : VULGAR FRACTION ONE FIFTH / FRACTION ONE FIFTH
\\1/6                       <char-0x02159>               " ⅙          : VULGAR FRACTION ONE SIXTH / FRACTION ONE SIXTH
\\1/7                       <char-0x02150>               " ⅐          : VULGAR FRACTION ONE SEVENTH
\\1/8                       <char-0x0215B>               " ⅛          : VULGAR FRACTION ONE EIGHTH / FRACTION ONE EIGHTH
\\1/9                       <char-0x02151>               " ⅑          : VULGAR FRACTION ONE NINTH
\\1/<Tab>                   <char-0x0215F>               " ⅟          : FRACTION NUMERATOR ONE
\\2/3                       <char-0x02154>               " ⅔          : VULGAR FRACTION TWO THIRDS / FRACTION TWO THIRDS
\\2/5                       <char-0x02156>               " ⅖          : VULGAR FRACTION TWO FIFTHS / FRACTION TWO FIFTHS
\\3/4                       <char-0x000BE>               " ¾          : VULGAR FRACTION THREE QUARTERS / FRACTION THREE QUARTERS
\\3/5                       <char-0x02157>               " ⅗          : VULGAR FRACTION THREE FIFTHS / FRACTION THREE FIFTHS
\\3/8                       <char-0x0215C>               " ⅜          : VULGAR FRACTION THREE EIGHTHS / FRACTION THREE EIGHTHS
\\4/5                       <char-0x02158>               " ⅘          : VULGAR FRACTION FOUR FIFTHS / FRACTION FOUR FIFTHS
\\5/6                       <char-0x0215A>               " ⅚          : VULGAR FRACTION FIVE SIXTHS / FRACTION FIVE SIXTHS
\\5/8                       <char-0x0215D>               " ⅝          : VULGAR FRACTION FIVE EIGHTHS / FRACTION FIVE EIGHTHS
\\7/8                       <char-0x0215E>               " ⅞          : VULGAR FRACTION SEVEN EIGHTHS / FRACTION SEVEN EIGHTHS
\\AA                        <char-0x000C5>               " Å          : LATIN CAPITAL LETTER A WITH RING ABOVE / LATIN CAPITAL LETTER A RING
\\AE                        <char-0x000C6>               " Æ          : LATIN CAPITAL LETTER AE / LATIN CAPITAL LETTER A E
\\Alpha                     <char-0x00391>               " Α          : GREEK CAPITAL LETTER ALPHA
\\And                       <char-0x02A53>               " ⩓          : DOUBLE LOGICAL AND
\\Angle                     <char-0x0299C>               " ⦜          : RIGHT ANGLE VARIANT WITH SQUARE
\\Angstrom                  <char-0x0212B>               " Å          : ANGSTROM SIGN / ANGSTROM UNIT
\\Beta                      <char-0x00392>               " Β          : GREEK CAPITAL LETTER BETA
\\Bot                       <char-0x02AEB>               " ⫫          : DOUBLE UP TACK
\\Bumpeq                    <char-0x0224E>               " ≎          : GEOMETRICALLY EQUIVALENT TO
\\Cap                       <char-0x022D2>               " ⋒          : DOUBLE INTERSECTION
\\Chi                       <char-0x003A7>               " Χ          : GREEK CAPITAL LETTER CHI
\\Colon                     <char-0x02237>               " ∷          : PROPORTION
\\Colon<Tab>                <char-0x02237>               " ∷          : PROPORTION
\\Colone                    \\Colone                     "            : (Incomplete sequence)
\\Coloneq                   <char-0x02A74>               " ⩴          : DOUBLE COLON EQUAL
\\Cup                       <char-0x022D3>               " ⋓          : DOUBLE UNION
\\DDownarrow                <char-0x027F1>               " ⟱          : DOWNWARDS QUADRUPLE ARROW
\\DH                        <char-0x000D0>               " Ð          : LATIN CAPITAL LETTER ETH
\\DJ                        <char-0x00110>               " Đ          : LATIN CAPITAL LETTER D WITH STROKE / LATIN CAPITAL LETTER D BAR
\\Dashv                     <char-0x02AE4>               " ⫤          : VERTICAL BAR DOUBLE LEFT TURNSTILE
\\Ddownarrow                <char-0x0290B>               " ⤋          : DOWNWARDS TRIPLE ARROW
\\Delta                     <char-0x00394>               " Δ          : GREEK CAPITAL LETTER DELTA
\\Digamma                   <char-0x003DC>               " Ϝ          : GREEK LETTER DIGAMMA / GREEK CAPITAL LETTER DIGAMMA
\\Doteq                     <char-0x02251>               " ≑          : GEOMETRICALLY EQUAL TO
\\DownArrowBar              <char-0x02913>               " ⤓          : DOWNWARDS ARROW TO BAR
\\DownArrowUpArrow          <char-0x021F5>               " ⇵          : DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW
\\DownLeftRightVector       <char-0x02950>               " ⥐          : LEFT BARB DOWN RIGHT BARB DOWN HARPOON
\\DownLeftTeeVector         <char-0x0295E>               " ⥞          : LEFTWARDS HARPOON WITH BARB DOWN FROM BAR
\\DownLeftVectorBar         <char-0x02956>               " ⥖          : LEFTWARDS HARPOON WITH BARB DOWN TO BAR
\\DownRightTeeVector        <char-0x0295F>               " ⥟          : RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR
\\DownRightVectorBar        <char-0x02957>               " ⥗          : RIGHTWARDS HARPOON WITH BARB DOWN TO BAR
\\Downarrow                 <char-0x021D3>               " ⇓          : DOWNWARDS DOUBLE ARROW / DOWN DOUBLE ARROW
\\ElOr                      <char-0x02A56>               " ⩖          : TWO INTERSECTING LOGICAL OR
\\Elroang                   <char-0x02986>               " ⦆          : RIGHT WHITE PARENTHESIS
\\Epsilon                   <char-0x00395>               " Ε          : GREEK CAPITAL LETTER EPSILON
\\Equal                     <char-0x02A75>               " ⩵          : TWO CONSECUTIVE EQUALS SIGNS
\\Equiv                     <char-0x02263>               " ≣          : STRICTLY EQUIVALENT TO
\\Eta                       <char-0x00397>               " Η          : GREEK CAPITAL LETTER ETA
\\Finv                      <char-0x02132>               " Ⅎ          : TURNED CAPITAL F / TURNED F
\\Game                      <char-0x02141>               " ⅁          : TURNED SANS-SERIF CAPITAL G
\\Gamma                     <char-0x00393>               " Γ          : GREEK CAPITAL LETTER GAMMA
\\H                         <char-0x0030B>               " ◌̋          : COMBINING DOUBLE ACUTE ACCENT / NON-SPACING DOUBLE ACUTE
\\Im                        <char-0x02111>               " ℑ          : BLACK-LETTER CAPITAL I / BLACK-LETTER I
\\Iota                      <char-0x00399>               " Ι          : GREEK CAPITAL LETTER IOTA
\\Kappa                     <char-0x0039A>               " Κ          : GREEK CAPITAL LETTER KAPPA
\\Koppa                     <char-0x003DE>               " Ϟ          : GREEK LETTER KOPPA / GREEK CAPITAL LETTER KOPPA
\\L                         <char-0x00141>               " Ł          : LATIN CAPITAL LETTER L WITH STROKE / LATIN CAPITAL LETTER L SLASH
\\L<Tab>                    <char-0x00141>               " Ł          : LATIN CAPITAL LETTER L WITH STROKE / LATIN CAPITAL LETTER L SLASH
\\LL                        \\LL                         "            : (Incomplete sequence)
\\LLeftarrow                <char-0x02B45>               " ⭅          : LEFTWARDS QUADRUPLE ARROW
\\La                        \\La                         "            : (Incomplete sequence)
\\Lambda                    <char-0x0039B>               " Λ          : GREEK CAPITAL LETTER LAMDA / GREEK CAPITAL LETTER LAMBDA
\\Lap                       <char-0x029CA>               " ⧊          : TRIANGLE WITH DOT ABOVE
\\Ld                        \\Ld                         "            : (Incomplete sequence)
\\Ldsh                      <char-0x021B2>               " ↲          : DOWNWARDS ARROW WITH TIP LEFTWARDS / DOWN ARROW WITH TIP LEFT
\\Le                        \\Le                         "            : (Incomplete sequence)
\\LeftDownTeeVector         <char-0x02961>               " ⥡          : DOWNWARDS HARPOON WITH BARB LEFT FROM BAR
\\LeftDownVectorBar         <char-0x02959>               " ⥙          : DOWNWARDS HARPOON WITH BARB LEFT TO BAR
\\LeftRightVector           <char-0x0294E>               " ⥎          : LEFT BARB UP RIGHT BARB UP HARPOON
\\LeftTeeVector             <char-0x0295A>               " ⥚          : LEFTWARDS HARPOON WITH BARB UP FROM BAR
\\LeftTriangleBar           <char-0x029CF>               " ⧏          : LEFT TRIANGLE BESIDE VERTICAL BAR
\\LeftUpDownVector          <char-0x02951>               " ⥑          : UP BARB LEFT DOWN BARB LEFT HARPOON
\\LeftUpTeeVector           <char-0x02960>               " ⥠          : UPWARDS HARPOON WITH BARB LEFT FROM BAR
\\LeftUpVectorBar           <char-0x02958>               " ⥘          : UPWARDS HARPOON WITH BARB LEFT TO BAR
\\LeftVectorBar             <char-0x02952>               " ⥒          : LEFTWARDS HARPOON WITH BARB UP TO BAR
\\Leftarrow                 <char-0x021D0>               " ⇐          : LEFTWARDS DOUBLE ARROW / LEFT DOUBLE ARROW
\\Leftrightarrow            <char-0x021D4>               " ⇔          : LEFT RIGHT DOUBLE ARROW
\\Ll                        \\Ll                         "            : (Incomplete sequence)
\\Lleftarrow                <char-0x021DA>               " ⇚          : LEFTWARDS TRIPLE ARROW / LEFT TRIPLE ARROW
\\Lo                        \\Lo                         "            : (Incomplete sequence)
\\Longleftarrow             <char-0x027F8>               " ⟸          : LONG LEFTWARDS DOUBLE ARROW
\\Longleftrightarrow        <char-0x027FA>               " ⟺          : LONG LEFT RIGHT DOUBLE ARROW
\\Longmapsfrom              <char-0x027FD>               " ⟽          : LONG LEFTWARDS DOUBLE ARROW FROM BAR
\\Longmapsto                <char-0x027FE>               " ⟾          : LONG RIGHTWARDS DOUBLE ARROW FROM BAR
\\Longrightarrow            <char-0x027F9>               " ⟹          : LONG RIGHTWARDS DOUBLE ARROW
\\Ls                        \\Ls                         "            : (Incomplete sequence)
\\Lsh                       <char-0x021B0>               " ↰          : UPWARDS ARROW WITH TIP LEFTWARDS / UP ARROW WITH TIP LEFT
\\Mapsfrom                  <char-0x02906>               " ⤆          : LEFTWARDS DOUBLE ARROW FROM BAR
\\Mapsto                    <char-0x02907>               " ⤇          : RIGHTWARDS DOUBLE ARROW FROM BAR
\\Mu                        <char-0x0039C>               " Μ          : GREEK CAPITAL LETTER MU
\\NG                        <char-0x0014A>               " Ŋ          : LATIN CAPITAL LETTER ENG
\\Nearrow                   <char-0x021D7>               " ⇗          : NORTH EAST DOUBLE ARROW / UPPER RIGHT DOUBLE ARROW
\\NestedGreaterGreater      <char-0x02AA2>               " ⪢          : DOUBLE NESTED GREATER-THAN
\\NestedLessLess            <char-0x02AA1>               " ⪡          : DOUBLE NESTED LESS-THAN
\\NotGreaterGreater         <char-0x0226B><char-0x00338> " ≫̸          : MUCH GREATER-THAN / MUCH GREATER THAN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotLeftTriangleBar        <char-0x029CF><char-0x00338> " ⧏̸          : LEFT TRIANGLE BESIDE VERTICAL BAR + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotLessLess               <char-0x0226A><char-0x00338> " ≪̸          : MUCH LESS-THAN / MUCH LESS THAN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotNestedGreaterGreater   <char-0x02AA2><char-0x00338> " ⪢̸          : DOUBLE NESTED GREATER-THAN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotNestedLessLess         <char-0x02AA1><char-0x00338> " ⪡̸          : DOUBLE NESTED LESS-THAN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotRightTriangleBar       <char-0x029D0><char-0x00338> " ⧐̸          : VERTICAL BAR BESIDE RIGHT TRIANGLE + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotSquareSubset           <char-0x0228F><char-0x00338> " ⊏̸          : SQUARE IMAGE OF + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\NotSquareSuperset         <char-0x02290><char-0x00338> " ⊐̸          : SQUARE ORIGINAL OF + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\Nu                        <char-0x0039D>               " Ν          : GREEK CAPITAL LETTER NU
\\Nwarrow                   <char-0x021D6>               " ⇖          : NORTH WEST DOUBLE ARROW / UPPER LEFT DOUBLE ARROW
\\O                         <char-0x000D8>               " Ø          : LATIN CAPITAL LETTER O WITH STROKE / LATIN CAPITAL LETTER O SLASH
\\O<Tab>                    <char-0x000D8>               " Ø          : LATIN CAPITAL LETTER O WITH STROKE / LATIN CAPITAL LETTER O SLASH
\\OE                        <char-0x00152>               " Œ          : LATIN CAPITAL LIGATURE OE / LATIN CAPITAL LETTER O E
\\Om                        \\Om                         "            : (Incomplete sequence)
\\Omega                     <char-0x003A9>               " Ω          : GREEK CAPITAL LETTER OMEGA
\\Omicron                   <char-0x0039F>               " Ο          : GREEK CAPITAL LETTER OMICRON
\\Or                        <char-0x02A54>               " ⩔          : DOUBLE LOGICAL OR
\\Ot                        \\Ot                         "            : (Incomplete sequence)
\\Otimes                    <char-0x02A37>               " ⨷          : MULTIPLICATION SIGN IN DOUBLE CIRCLE
\\P                         <char-0x000B6>               " ¶          : PILCROW SIGN / PARAGRAPH SIGN
\\P<Tab>                    <char-0x000B6>               " ¶          : PILCROW SIGN / PARAGRAPH SIGN
\\Ph                        \\Ph                         "            : (Incomplete sequence)
\\Phi                       <char-0x003A6>               " Φ          : GREEK CAPITAL LETTER PHI
\\Pi                        <char-0x003A0>               " Π          : GREEK CAPITAL LETTER PI
\\Pr                        \\Pr                         "            : (Incomplete sequence)
\\Prec                      <char-0x02ABB>               " ⪻          : DOUBLE PRECEDES
\\PropertyLine              <char-0x0214A>               " ⅊          : PROPERTY LINE
\\Ps                        \\Ps                         "            : (Incomplete sequence)
\\Psi                       <char-0x003A8>               " Ψ          : GREEK CAPITAL LETTER PSI
\\QED                       <char-0x0220E>               " ∎          : END OF PROOF
\\RRightarrow               <char-0x02B46>               " ⭆          : RIGHTWARDS QUADRUPLE ARROW
\\Rdsh                      <char-0x021B3>               " ↳          : DOWNWARDS ARROW WITH TIP RIGHTWARDS / DOWN ARROW WITH TIP RIGHT
\\Re                        <char-0x0211C>               " ℜ          : BLACK-LETTER CAPITAL R / BLACK-LETTER R
\\Re<Tab>                   <char-0x0211C>               " ℜ          : BLACK-LETTER CAPITAL R / BLACK-LETTER R
\\Rev                       \\Rev                        "            : (Incomplete sequence)
\\ReverseUpEquilibrium      <char-0x0296F>               " ⥯          : DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
\\Rho                       <char-0x003A1>               " Ρ          : GREEK CAPITAL LETTER RHO
\\RightDownTeeVector        <char-0x0295D>               " ⥝          : DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR
\\RightDownVectorBar        <char-0x02955>               " ⥕          : DOWNWARDS HARPOON WITH BARB RIGHT TO BAR
\\RightTeeVector            <char-0x0295B>               " ⥛          : RIGHTWARDS HARPOON WITH BARB UP FROM BAR
\\RightTriangleBar          <char-0x029D0>               " ⧐          : VERTICAL BAR BESIDE RIGHT TRIANGLE
\\RightUpDownVector         <char-0x0294F>               " ⥏          : UP BARB RIGHT DOWN BARB RIGHT HARPOON
\\RightUpTeeVector          <char-0x0295C>               " ⥜          : UPWARDS HARPOON WITH BARB RIGHT FROM BAR
\\RightUpVectorBar          <char-0x02954>               " ⥔          : UPWARDS HARPOON WITH BARB RIGHT TO BAR
\\RightVectorBar            <char-0x02953>               " ⥓          : RIGHTWARDS HARPOON WITH BARB UP TO BAR
\\Rightarrow                <char-0x021D2>               " ⇒          : RIGHTWARDS DOUBLE ARROW / RIGHT DOUBLE ARROW
\\Rlarr                     <char-0x02942>               " ⥂          : RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW
\\RoundImplies              <char-0x02970>               " ⥰          : RIGHT DOUBLE ARROW WITH ROUNDED HEAD
\\Rrightarrow               <char-0x021DB>               " ⇛          : RIGHTWARDS TRIPLE ARROW / RIGHT TRIPLE ARROW
\\Rsh                       <char-0x021B1>               " ↱          : UPWARDS ARROW WITH TIP RIGHTWARDS / UP ARROW WITH TIP RIGHT
\\RuleDelayed               <char-0x029F4>               " ⧴          : RULE-DELAYED
\\S                         <char-0x000A7>               " §          : SECTION SIGN
\\S<Tab>                    <char-0x000A7>               " §          : SECTION SIGN
\\Sa                        \\Sa                         "            : (Incomplete sequence)
\\Sampi                     <char-0x003E0>               " Ϡ          : GREEK LETTER SAMPI / GREEK CAPITAL LETTER SAMPI
\\Se                        \\Se                         "            : (Incomplete sequence)
\\Searrow                   <char-0x021D8>               " ⇘          : SOUTH EAST DOUBLE ARROW / LOWER RIGHT DOUBLE ARROW
\\Si                        \\Si                         "            : (Incomplete sequence)
\\Sigma                     <char-0x003A3>               " Σ          : GREEK CAPITAL LETTER SIGMA
\\Sq                        \\Sq                         "            : (Incomplete sequence)
\\Sqcap                     <char-0x02A4E>               " ⩎          : DOUBLE SQUARE INTERSECTION
\\Sqcup                     <char-0x02A4F>               " ⩏          : DOUBLE SQUARE UNION
\\St                        \\St                         "            : (Incomplete sequence)
\\Stigma                    <char-0x003DA>               " Ϛ          : GREEK LETTER STIGMA / GREEK CAPITAL LETTER STIGMA
\\Su                        \\Su                         "            : (Incomplete sequence)
\\Subset                    <char-0x022D0>               " ⋐          : DOUBLE SUBSET
\\Succ                      <char-0x02ABC>               " ⪼          : DOUBLE SUCCEEDS
\\Supset                    <char-0x022D1>               " ⋑          : DOUBLE SUPERSET
\\Sw                        \\Sw                         "            : (Incomplete sequence)
\\Swarrow                   <char-0x021D9>               " ⇙          : SOUTH WEST DOUBLE ARROW / LOWER LEFT DOUBLE ARROW
\\TH                        <char-0x000DE>               " Þ          : LATIN CAPITAL LETTER THORN
\\Tau                       <char-0x003A4>               " Τ          : GREEK CAPITAL LETTER TAU
\\Theta                     <char-0x00398>               " Θ          : GREEK CAPITAL LETTER THETA
\\Times                     <char-0x02A2F>               " ⨯          : VECTOR OR CROSS PRODUCT
\\Top                       <char-0x02AEA>               " ⫪          : DOUBLE DOWN TACK
\\UUparrow                  <char-0x027F0>               " ⟰          : UPWARDS QUADRUPLE ARROW
\\UpArrowBar                <char-0x02912>               " ⤒          : UPWARDS ARROW TO BAR
\\UpEquilibrium             <char-0x0296E>               " ⥮          : UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
\\Uparrow                   <char-0x021D1>               " ⇑          : UPWARDS DOUBLE ARROW / UP DOUBLE ARROW
\\Updownarrow               <char-0x021D5>               " ⇕          : UP DOWN DOUBLE ARROW
\\Upsilon                   <char-0x003A5>               " Υ          : GREEK CAPITAL LETTER UPSILON
\\Uuparrow                  <char-0x0290A>               " ⤊          : UPWARDS TRIPLE ARROW
\\VDash                     <char-0x022AB>               " ⊫          : DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
\\Vdash                     <char-0x022A9>               " ⊩          : FORCES
\\Vert                      <char-0x02016>               " ‖          : DOUBLE VERTICAL LINE / DOUBLE VERTICAL BAR
\\Vvdash                    <char-0x022AA>               " ⊪          : TRIPLE VERTICAL BAR RIGHT TURNSTILE
\\Vvert                     <char-0x02980>               " ⦀          : TRIPLE VERTICAL BAR DELIMITER
\\Xi                        <char-0x0039E>               " Ξ          : GREEK CAPITAL LETTER XI
\\Yup                       <char-0x02144>               " ⅄          : TURNED SANS-SERIF CAPITAL Y
\\Zbar                      <char-0x001B5>               " Ƶ          : LATIN CAPITAL LETTER Z WITH STROKE / LATIN CAPITAL LETTER Z BAR
\\Zeta                      <char-0x00396>               " Ζ          : GREEK CAPITAL LETTER ZETA
\\^!                        <char-0x0A71D>               " ꜝ          : MODIFIER LETTER RAISED EXCLAMATION MARK
\\^(                        <char-0x0207D>               " ⁽          : SUPERSCRIPT LEFT PARENTHESIS / SUPERSCRIPT OPENING PARENTHESIS
\\^)                        <char-0x0207E>               " ⁾          : SUPERSCRIPT RIGHT PARENTHESIS / SUPERSCRIPT CLOSING PARENTHESIS
\\^+                        <char-0x0207A>               " ⁺          : SUPERSCRIPT PLUS SIGN
\\^-                        <char-0x0207B>               " ⁻          : SUPERSCRIPT MINUS / SUPERSCRIPT HYPHEN-MINUS
\\^0                        <char-0x02070>               " ⁰          : SUPERSCRIPT ZERO / SUPERSCRIPT DIGIT ZERO
\\^1                        <char-0x000B9>               " ¹          : SUPERSCRIPT ONE / SUPERSCRIPT DIGIT ONE
\\^2                        <char-0x000B2>               " ²          : SUPERSCRIPT TWO / SUPERSCRIPT DIGIT TWO
\\^3                        <char-0x000B3>               " ³          : SUPERSCRIPT THREE / SUPERSCRIPT DIGIT THREE
\\^4                        <char-0x02074>               " ⁴          : SUPERSCRIPT FOUR / SUPERSCRIPT DIGIT FOUR
\\^5                        <char-0x02075>               " ⁵          : SUPERSCRIPT FIVE / SUPERSCRIPT DIGIT FIVE
\\^6                        <char-0x02076>               " ⁶          : SUPERSCRIPT SIX / SUPERSCRIPT DIGIT SIX
\\^7                        <char-0x02077>               " ⁷          : SUPERSCRIPT SEVEN / SUPERSCRIPT DIGIT SEVEN
\\^8                        <char-0x02078>               " ⁸          : SUPERSCRIPT EIGHT / SUPERSCRIPT DIGIT EIGHT
\\^9                        <char-0x02079>               " ⁹          : SUPERSCRIPT NINE / SUPERSCRIPT DIGIT NINE
\\^=                        <char-0x0207C>               " ⁼          : SUPERSCRIPT EQUALS SIGN
\\^A                        <char-0x01D2C>               " ᴬ          : MODIFIER LETTER CAPITAL A
\\^B                        <char-0x01D2E>               " ᴮ          : MODIFIER LETTER CAPITAL B
\\^D                        <char-0x01D30>               " ᴰ          : MODIFIER LETTER CAPITAL D
\\^E                        <char-0x01D31>               " ᴱ          : MODIFIER LETTER CAPITAL E
\\^G                        <char-0x01D33>               " ᴳ          : MODIFIER LETTER CAPITAL G
\\^H                        <char-0x01D34>               " ᴴ          : MODIFIER LETTER CAPITAL H
\\^I                        <char-0x01D35>               " ᴵ          : MODIFIER LETTER CAPITAL I
\\^J                        <char-0x01D36>               " ᴶ          : MODIFIER LETTER CAPITAL J
\\^K                        <char-0x01D37>               " ᴷ          : MODIFIER LETTER CAPITAL K
\\^L                        <char-0x01D38>               " ᴸ          : MODIFIER LETTER CAPITAL L
\\^M                        <char-0x01D39>               " ᴹ          : MODIFIER LETTER CAPITAL M
\\^N                        <char-0x01D3A>               " ᴺ          : MODIFIER LETTER CAPITAL N
\\^O                        <char-0x01D3C>               " ᴼ          : MODIFIER LETTER CAPITAL O
\\^P                        <char-0x01D3E>               " ᴾ          : MODIFIER LETTER CAPITAL P
\\^R                        <char-0x01D3F>               " ᴿ          : MODIFIER LETTER CAPITAL R
\\^T                        <char-0x01D40>               " ᵀ          : MODIFIER LETTER CAPITAL T
\\^U                        <char-0x01D41>               " ᵁ          : MODIFIER LETTER CAPITAL U
\\^V                        <char-0x02C7D>               " ⱽ          : MODIFIER LETTER CAPITAL V
\\^W                        <char-0x01D42>               " ᵂ          : MODIFIER LETTER CAPITAL W
\\^a                        <char-0x01D43>               " ᵃ          : MODIFIER LETTER SMALL A
\\^a<Tab>                   <char-0x01D43>               " ᵃ          : MODIFIER LETTER SMALL A
\\^al                       \\^al                        "            : (Incomplete sequence)
\\^alpha                    <char-0x01D45>               " ᵅ          : MODIFIER LETTER SMALL ALPHA
\\^b                        <char-0x01D47>               " ᵇ          : MODIFIER LETTER SMALL B
\\^b<Tab>                   <char-0x01D47>               " ᵇ          : MODIFIER LETTER SMALL B
\\^be                       \\^be                        "            : (Incomplete sequence)
\\^beta                     <char-0x01D5D>               " ᵝ          : MODIFIER LETTER SMALL BETA
\\^c                        <char-0x01D9C>               " ᶜ          : MODIFIER LETTER SMALL C
\\^c<Tab>                   <char-0x01D9C>               " ᶜ          : MODIFIER LETTER SMALL C
\\^ch                       \\^ch                        "            : (Incomplete sequence)
\\^chi                      <char-0x01D61>               " ᵡ          : MODIFIER LETTER SMALL CHI
\\^d                        <char-0x01D48>               " ᵈ          : MODIFIER LETTER SMALL D
\\^d<Tab>                   <char-0x01D48>               " ᵈ          : MODIFIER LETTER SMALL D
\\^de                       \\^de                        "            : (Incomplete sequence)
\\^delta                    <char-0x01D5F>               " ᵟ          : MODIFIER LETTER SMALL DELTA
\\^do                       \\^do                        "            : (Incomplete sequence)
\\^downarrow                <char-0x0A71C>               " ꜜ          : MODIFIER LETTER RAISED DOWN ARROW
\\^e                        <char-0x01D49>               " ᵉ          : MODIFIER LETTER SMALL E
\\^e<Tab>                   <char-0x01D49>               " ᵉ          : MODIFIER LETTER SMALL E
\\^ep                       \\^ep                        "            : (Incomplete sequence)
\\^epsilon                  <char-0x01D4B>               " ᵋ          : MODIFIER LETTER SMALL OPEN E
\\^f                        <char-0x01DA0>               " ᶠ          : MODIFIER LETTER SMALL F
\\^g                        <char-0x01D4D>               " ᵍ          : MODIFIER LETTER SMALL G
\\^g<Tab>                   <char-0x01D4D>               " ᵍ          : MODIFIER LETTER SMALL G
\\^ga                       \\^ga                        "            : (Incomplete sequence)
\\^gamma                    <char-0x01D5E>               " ᵞ          : MODIFIER LETTER SMALL GREEK GAMMA
\\^h                        <char-0x002B0>               " ʰ          : MODIFIER LETTER SMALL H
\\^i                        <char-0x02071>               " ⁱ          : SUPERSCRIPT LATIN SMALL LETTER I
\\^i<Tab>                   <char-0x02071>               " ⁱ          : SUPERSCRIPT LATIN SMALL LETTER I
\\^io                       \\^io                        "            : (Incomplete sequence)
\\^iota                     <char-0x01DA5>               " ᶥ          : MODIFIER LETTER SMALL IOTA
\\^j                        <char-0x002B2>               " ʲ          : MODIFIER LETTER SMALL J
\\^k                        <char-0x01D4F>               " ᵏ          : MODIFIER LETTER SMALL K
\\^l                        <char-0x002E1>               " ˡ          : MODIFIER LETTER SMALL L
\\^l<Tab>                   <char-0x002E1>               " ˡ          : MODIFIER LETTER SMALL L
\\^lt                       \\^lt                        "            : (Incomplete sequence)
\\^ltphi                    <char-0x01DB2>               " ᶲ          : MODIFIER LETTER SMALL PHI
\\^m                        <char-0x01D50>               " ᵐ          : MODIFIER LETTER SMALL M
\\^n                        <char-0x0207F>               " ⁿ          : SUPERSCRIPT LATIN SMALL LETTER N
\\^o                        <char-0x01D52>               " ᵒ          : MODIFIER LETTER SMALL O
\\^p                        <char-0x01D56>               " ᵖ          : MODIFIER LETTER SMALL P
\\^p<Tab>                   <char-0x01D56>               " ᵖ          : MODIFIER LETTER SMALL P
\\^ph                       \\^ph                        "            : (Incomplete sequence)
\\^phi                      <char-0x01D60>               " ᵠ          : MODIFIER LETTER SMALL GREEK PHI
\\^r                        <char-0x002B3>               " ʳ          : MODIFIER LETTER SMALL R
\\^s                        <char-0x002E2>               " ˢ          : MODIFIER LETTER SMALL S
\\^t                        <char-0x01D57>               " ᵗ          : MODIFIER LETTER SMALL T
\\^t<Tab>                   <char-0x01D57>               " ᵗ          : MODIFIER LETTER SMALL T
\\^th                       \\^th                        "            : (Incomplete sequence)
\\^theta                    <char-0x01DBF>               " ᶿ          : MODIFIER LETTER SMALL THETA
\\^u                        <char-0x01D58>               " ᵘ          : MODIFIER LETTER SMALL U
\\^u<Tab>                   <char-0x01D58>               " ᵘ          : MODIFIER LETTER SMALL U
\\^up                       \\^up                        "            : (Incomplete sequence)
\\^uparrow                  <char-0x0A71B>               " ꜛ          : MODIFIER LETTER RAISED UP ARROW
\\^v                        <char-0x01D5B>               " ᵛ          : MODIFIER LETTER SMALL V
\\^w                        <char-0x002B7>               " ʷ          : MODIFIER LETTER SMALL W
\\^x                        <char-0x002E3>               " ˣ          : MODIFIER LETTER SMALL X
\\^y                        <char-0x002B8>               " ʸ          : MODIFIER LETTER SMALL Y
\\^z                        <char-0x01DBB>               " ᶻ          : MODIFIER LETTER SMALL Z
\\_(                        <char-0x0208D>               " ₍          : SUBSCRIPT LEFT PARENTHESIS / SUBSCRIPT OPENING PARENTHESIS
\\_)                        <char-0x0208E>               " ₎          : SUBSCRIPT RIGHT PARENTHESIS / SUBSCRIPT CLOSING PARENTHESIS
\\_+                        <char-0x0208A>               " ₊          : SUBSCRIPT PLUS SIGN
\\_-                        <char-0x0208B>               " ₋          : SUBSCRIPT MINUS / SUBSCRIPT HYPHEN-MINUS
\\_0                        <char-0x02080>               " ₀          : SUBSCRIPT ZERO / SUBSCRIPT DIGIT ZERO
\\_1                        <char-0x02081>               " ₁          : SUBSCRIPT ONE / SUBSCRIPT DIGIT ONE
\\_2                        <char-0x02082>               " ₂          : SUBSCRIPT TWO / SUBSCRIPT DIGIT TWO
\\_3                        <char-0x02083>               " ₃          : SUBSCRIPT THREE / SUBSCRIPT DIGIT THREE
\\_4                        <char-0x02084>               " ₄          : SUBSCRIPT FOUR / SUBSCRIPT DIGIT FOUR
\\_5                        <char-0x02085>               " ₅          : SUBSCRIPT FIVE / SUBSCRIPT DIGIT FIVE
\\_6                        <char-0x02086>               " ₆          : SUBSCRIPT SIX / SUBSCRIPT DIGIT SIX
\\_7                        <char-0x02087>               " ₇          : SUBSCRIPT SEVEN / SUBSCRIPT DIGIT SEVEN
\\_8                        <char-0x02088>               " ₈          : SUBSCRIPT EIGHT / SUBSCRIPT DIGIT EIGHT
\\_9                        <char-0x02089>               " ₉          : SUBSCRIPT NINE / SUBSCRIPT DIGIT NINE
\\_=                        <char-0x0208C>               " ₌          : SUBSCRIPT EQUALS SIGN
\\_a                        <char-0x02090>               " ₐ          : LATIN SUBSCRIPT SMALL LETTER A
\\_beta                     <char-0x01D66>               " ᵦ          : GREEK SUBSCRIPT SMALL LETTER BETA
\\_chi                      <char-0x01D6A>               " ᵪ          : GREEK SUBSCRIPT SMALL LETTER CHI
\\_e                        <char-0x02091>               " ₑ          : LATIN SUBSCRIPT SMALL LETTER E
\\_gamma                    <char-0x01D67>               " ᵧ          : GREEK SUBSCRIPT SMALL LETTER GAMMA
\\_h                        <char-0x02095>               " ₕ          : LATIN SUBSCRIPT SMALL LETTER H
\\_i                        <char-0x01D62>               " ᵢ          : LATIN SUBSCRIPT SMALL LETTER I
\\_j                        <char-0x02C7C>               " ⱼ          : LATIN SUBSCRIPT SMALL LETTER J
\\_k                        <char-0x02096>               " ₖ          : LATIN SUBSCRIPT SMALL LETTER K
\\_l                        <char-0x02097>               " ₗ          : LATIN SUBSCRIPT SMALL LETTER L
\\_m                        <char-0x02098>               " ₘ          : LATIN SUBSCRIPT SMALL LETTER M
\\_n                        <char-0x02099>               " ₙ          : LATIN SUBSCRIPT SMALL LETTER N
\\_o                        <char-0x02092>               " ₒ          : LATIN SUBSCRIPT SMALL LETTER O
\\_p                        <char-0x0209A>               " ₚ          : LATIN SUBSCRIPT SMALL LETTER P
\\_p<Tab>                   <char-0x0209A>               " ₚ          : LATIN SUBSCRIPT SMALL LETTER P
\\_ph                       \\_ph                        "            : (Incomplete sequence)
\\_phi                      <char-0x01D69>               " ᵩ          : GREEK SUBSCRIPT SMALL LETTER PHI
\\_r                        <char-0x01D63>               " ᵣ          : LATIN SUBSCRIPT SMALL LETTER R
\\_r<Tab>                   <char-0x01D63>               " ᵣ          : LATIN SUBSCRIPT SMALL LETTER R
\\_rh                       \\_rh                        "            : (Incomplete sequence)
\\_rho                      <char-0x01D68>               " ᵨ          : GREEK SUBSCRIPT SMALL LETTER RHO
\\_s                        <char-0x0209B>               " ₛ          : LATIN SUBSCRIPT SMALL LETTER S
\\_s<Tab>                   <char-0x0209B>               " ₛ          : LATIN SUBSCRIPT SMALL LETTER S
\\_sc                       \\_sc                        "            : (Incomplete sequence)
\\_schwa                    <char-0x02094>               " ₔ          : LATIN SUBSCRIPT SMALL LETTER SCHWA
\\_t                        <char-0x0209C>               " ₜ          : LATIN SUBSCRIPT SMALL LETTER T
\\_u                        <char-0x01D64>               " ᵤ          : LATIN SUBSCRIPT SMALL LETTER U
\\_v                        <char-0x01D65>               " ᵥ          : LATIN SUBSCRIPT SMALL LETTER V
\\_x                        <char-0x02093>               " ₓ          : LATIN SUBSCRIPT SMALL LETTER X
\\aa                        <char-0x000E5>               " å          : LATIN SMALL LETTER A WITH RING ABOVE / LATIN SMALL LETTER A RING
\\accurrent                 <char-0x023E6>               " ⏦          : AC CURRENT
\\acidfree                  <char-0x0267E>               " ♾          : PERMANENT PAPER SIGN
\\acute                     <char-0x00301>               " ◌́          : COMBINING ACUTE ACCENT / NON-SPACING ACUTE
\\adots                     <char-0x022F0>               " ⋰          : UP RIGHT DIAGONAL ELLIPSIS
\\ae                        <char-0x000E6>               " æ          : LATIN SMALL LETTER AE / LATIN SMALL LETTER A E
\\aleph                     <char-0x02135>               " ℵ          : ALEF SYMBOL / FIRST TRANSFINITE CARDINAL
\\allequal                  <char-0x0224C>               " ≌          : ALL EQUAL TO
\\alpha                     <char-0x003B1>               " α          : GREEK SMALL LETTER ALPHA
\\amalg                     <char-0x02A3F>               " ⨿          : AMALGAMATION OR COPRODUCT
\\angdnr                    <char-0x0299F>               " ⦟          : ACUTE ANGLE
\\angle                     <char-0x02220>               " ∠          : ANGLE
\\angle<Tab>                <char-0x02220>               " ∠          : ANGLE
\\angles                    <char-0x0299E>               " ⦞          : ANGLE WITH S INSIDE
\\angleu                    \\angleu                     "            : (Incomplete sequence)
\\angleubar                 <char-0x029A4>               " ⦤          : ANGLE WITH UNDERBAR
\\annuity                   <char-0x020E7>               " ◌⃧          : COMBINING ANNUITY SYMBOL
\\approx                    <char-0x02248>               " ≈          : ALMOST EQUAL TO
\\approx<Tab>               <char-0x02248>               " ≈          : ALMOST EQUAL TO
\\approxe                   \\approxe                    "            : (Incomplete sequence)
\\approxeq                  <char-0x0224A>               " ≊          : ALMOST EQUAL OR EQUAL TO
\\approxeq<Tab>             <char-0x0224A>               " ≊          : ALMOST EQUAL OR EQUAL TO
\\approxeqq                 <char-0x02A70>               " ⩰          : APPROXIMATELY EQUAL OR EQUAL TO
\\approxn                   \\approxn                    "            : (Incomplete sequence)
\\approxnotequal            <char-0x02246>               " ≆          : APPROXIMATELY BUT NOT ACTUALLY EQUAL TO
\\aquarius                  <char-0x02652>               " ♒         : AQUARIUS
\\arceq                     <char-0x02258>               " ≘          : CORRESPONDS TO
\\aries                     <char-0x02648>               " ♈         : ARIES
\\ast                       <char-0x02217>               " ∗          : ASTERISK OPERATOR
\\ast<Tab>                  <char-0x02217>               " ∗          : ASTERISK OPERATOR
\\aste                      \\aste                       "            : (Incomplete sequence)
\\asteq                     <char-0x02A6E>               " ⩮          : EQUALS WITH ASTERISK
\\asteraccent               <char-0x020F0>               " ◌⃰          : COMBINING ASTERISK ABOVE
\\astr                      \\astr                       "            : (Incomplete sequence)
\\astrosun                  <char-0x02609>               " ☉          : SUN
\\asymp                     <char-0x0224D>               " ≍          : EQUIVALENT TO
\\awint                     <char-0x02A11>               " ⨑          : ANTICLOCKWISE INTEGRATION
\\backepsilon               <char-0x003F6>               " ϶          : GREEK REVERSED LUNATE EPSILON SYMBOL
\\backppprime               <char-0x02037>               " ‷          : REVERSED TRIPLE PRIME
\\backpprime                <char-0x02036>               " ‶          : REVERSED DOUBLE PRIME
\\backprime                 <char-0x02035>               " ‵          : REVERSED PRIME
\\backsim                   <char-0x0223D>               " ∽          : REVERSED TILDE
\\backsim<Tab>              <char-0x0223D>               " ∽          : REVERSED TILDE
\\backsime                  \\backsime                   "            : (Incomplete sequence)
\\backsimeq                 <char-0x022CD>               " ⋍          : REVERSED TILDE EQUALS
\\bagmember                 <char-0x022FF>               " ⋿          : Z NOTATION BAG MEMBERSHIP
\\bar                       <char-0x00304>               " ◌̄          : COMBINING MACRON / NON-SPACING MACRON
\\bar<Tab>                  <char-0x00304>               " ◌̄          : COMBINING MACRON / NON-SPACING MACRON
\\barc                      \\barc                       "            : (Incomplete sequence)
\\barcap                    <char-0x02A43>               " ⩃          : INTERSECTION WITH OVERBAR
\\barcup                    <char-0x02A42>               " ⩂          : UNION WITH OVERBAR
\\barl                      \\barl                       "            : (Incomplete sequence)
\\barleftarrow              <char-0x021E4>               " ⇤          : LEFTWARDS ARROW TO BAR / LEFT ARROW TO BAR
\\barleftarrow<Tab>         <char-0x021E4>               " ⇤          : LEFTWARDS ARROW TO BAR / LEFT ARROW TO BAR
\\barleftarrowr             \\barleftarrowr              "            : (Incomplete sequence)
\\barleftarrowrightarrowbar <char-0x021B9>               " ↹          : LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR / LEFT ARROW TO BAR OVER RIGHT ARROW TO BAR
\\baro                      \\baro                       "            : (Incomplete sequence)
\\barovernorthwestarrow     <char-0x021B8>               " ↸          : NORTH WEST ARROW TO LONG BAR / UPPER LEFT ARROW TO LONG BAR
\\barr                      \\barr                       "            : (Incomplete sequence)
\\barrightarrowdiamond      <char-0x02920>               " ⤠          : RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND
\\barv                      \\barv                       "            : (Incomplete sequence)
\\barvee                    <char-0x022BD>               " ⊽          : NOR
\\barw                      \\barw                       "            : (Incomplete sequence)
\\barwedge                  <char-0x022BC>               " ⊼          : NAND
\\bbA                       <char-0x1D538>               " 𝔸          : MATHEMATICAL DOUBLE-STRUCK CAPITAL A
\\bbB                       <char-0x1D539>               " 𝔹          : MATHEMATICAL DOUBLE-STRUCK CAPITAL B
\\bbC                       <char-0x02102>               " ℂ          : DOUBLE-STRUCK CAPITAL C / DOUBLE-STRUCK C
\\bbD                       <char-0x1D53B>               " 𝔻          : MATHEMATICAL DOUBLE-STRUCK CAPITAL D
\\bbE                       <char-0x1D53C>               " 𝔼          : MATHEMATICAL DOUBLE-STRUCK CAPITAL E
\\bbF                       <char-0x1D53D>               " 𝔽          : MATHEMATICAL DOUBLE-STRUCK CAPITAL F
\\bbG                       <char-0x1D53E>               " 𝔾          : MATHEMATICAL DOUBLE-STRUCK CAPITAL G
\\bbG<Tab>                  <char-0x1D53E>               " 𝔾          : MATHEMATICAL DOUBLE-STRUCK CAPITAL G
\\bbGa                      \\bbGa                       "            : (Incomplete sequence)
\\bbGamma                   <char-0x0213E>               " ℾ          : DOUBLE-STRUCK CAPITAL GAMMA
\\bbH                       <char-0x0210D>               " ℍ          : DOUBLE-STRUCK CAPITAL H / DOUBLE-STRUCK H
\\bbI                       <char-0x1D540>               " 𝕀          : MATHEMATICAL DOUBLE-STRUCK CAPITAL I
\\bbJ                       <char-0x1D541>               " 𝕁          : MATHEMATICAL DOUBLE-STRUCK CAPITAL J
\\bbK                       <char-0x1D542>               " 𝕂          : MATHEMATICAL DOUBLE-STRUCK CAPITAL K
\\bbL                       <char-0x1D543>               " 𝕃          : MATHEMATICAL DOUBLE-STRUCK CAPITAL L
\\bbM                       <char-0x1D544>               " 𝕄          : MATHEMATICAL DOUBLE-STRUCK CAPITAL M
\\bbN                       <char-0x02115>               " ℕ          : DOUBLE-STRUCK CAPITAL N / DOUBLE-STRUCK N
\\bbO                       <char-0x1D546>               " 𝕆          : MATHEMATICAL DOUBLE-STRUCK CAPITAL O
\\bbP                       <char-0x02119>               " ℙ          : DOUBLE-STRUCK CAPITAL P / DOUBLE-STRUCK P
\\bbP<Tab>                  <char-0x02119>               " ℙ          : DOUBLE-STRUCK CAPITAL P / DOUBLE-STRUCK P
\\bbPi                      <char-0x0213F>               " ℿ          : DOUBLE-STRUCK CAPITAL PI
\\bbQ                       <char-0x0211A>               " ℚ          : DOUBLE-STRUCK CAPITAL Q / DOUBLE-STRUCK Q
\\bbR                       <char-0x0211D>               " ℝ          : DOUBLE-STRUCK CAPITAL R / DOUBLE-STRUCK R
\\bbS                       <char-0x1D54A>               " 𝕊          : MATHEMATICAL DOUBLE-STRUCK CAPITAL S
\\bbT                       <char-0x1D54B>               " 𝕋          : MATHEMATICAL DOUBLE-STRUCK CAPITAL T
\\bbU                       <char-0x1D54C>               " 𝕌          : MATHEMATICAL DOUBLE-STRUCK CAPITAL U
\\bbV                       <char-0x1D54D>               " 𝕍          : MATHEMATICAL DOUBLE-STRUCK CAPITAL V
\\bbW                       <char-0x1D54E>               " 𝕎          : MATHEMATICAL DOUBLE-STRUCK CAPITAL W
\\bbX                       <char-0x1D54F>               " 𝕏          : MATHEMATICAL DOUBLE-STRUCK CAPITAL X
\\bbY                       <char-0x1D550>               " 𝕐          : MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
\\bbZ                       <char-0x02124>               " ℤ          : DOUBLE-STRUCK CAPITAL Z / DOUBLE-STRUCK Z
\\bba                       <char-0x1D552>               " 𝕒          : MATHEMATICAL DOUBLE-STRUCK SMALL A
\\bbb                       <char-0x1D553>               " 𝕓          : MATHEMATICAL DOUBLE-STRUCK SMALL B
\\bbc                       <char-0x1D554>               " 𝕔          : MATHEMATICAL DOUBLE-STRUCK SMALL C
\\bbd                       <char-0x1D555>               " 𝕕          : MATHEMATICAL DOUBLE-STRUCK SMALL D
\\bbe                       <char-0x1D556>               " 𝕖          : MATHEMATICAL DOUBLE-STRUCK SMALL E
\\bbe<Tab>                  <char-0x1D556>               " 𝕖          : MATHEMATICAL DOUBLE-STRUCK SMALL E
\\bbei                      \\bbei                       "            : (Incomplete sequence)
\\bbeight                   <char-0x1D7E0>               " 𝟠          : MATHEMATICAL DOUBLE-STRUCK DIGIT EIGHT
\\bbf                       <char-0x1D557>               " 𝕗          : MATHEMATICAL DOUBLE-STRUCK SMALL F
\\bbf<Tab>                  <char-0x1D557>               " 𝕗          : MATHEMATICAL DOUBLE-STRUCK SMALL F
\\bbfi                      \\bbfi                       "            : (Incomplete sequence)
\\bbfive                    <char-0x1D7DD>               " 𝟝          : MATHEMATICAL DOUBLE-STRUCK DIGIT FIVE
\\bbfo                      \\bbfo                       "            : (Incomplete sequence)
\\bbfour                    <char-0x1D7DC>               " 𝟜          : MATHEMATICAL DOUBLE-STRUCK DIGIT FOUR
\\bbg                       <char-0x1D558>               " 𝕘          : MATHEMATICAL DOUBLE-STRUCK SMALL G
\\bbg<Tab>                  <char-0x1D558>               " 𝕘          : MATHEMATICAL DOUBLE-STRUCK SMALL G
\\bbga                      \\bbga                       "            : (Incomplete sequence)
\\bbgamma                   <char-0x0213D>               " ℽ          : DOUBLE-STRUCK SMALL GAMMA
\\bbh                       <char-0x1D559>               " 𝕙          : MATHEMATICAL DOUBLE-STRUCK SMALL H
\\bbi                       <char-0x1D55A>               " 𝕚          : MATHEMATICAL DOUBLE-STRUCK SMALL I
\\bbi<Tab>                  <char-0x1D55A>               " 𝕚          : MATHEMATICAL DOUBLE-STRUCK SMALL I
\\bbiD                      <char-0x02145>               " ⅅ          : DOUBLE-STRUCK ITALIC CAPITAL D
\\bbid                      <char-0x02146>               " ⅆ          : DOUBLE-STRUCK ITALIC SMALL D
\\bbie                      <char-0x02147>               " ⅇ          : DOUBLE-STRUCK ITALIC SMALL E
\\bbii                      <char-0x02148>               " ⅈ          : DOUBLE-STRUCK ITALIC SMALL I
\\bbij                      <char-0x02149>               " ⅉ          : DOUBLE-STRUCK ITALIC SMALL J
\\bbj                       <char-0x1D55B>               " 𝕛          : MATHEMATICAL DOUBLE-STRUCK SMALL J
\\bbk                       <char-0x1D55C>               " 𝕜          : MATHEMATICAL DOUBLE-STRUCK SMALL K
\\bbl                       <char-0x1D55D>               " 𝕝          : MATHEMATICAL DOUBLE-STRUCK SMALL L
\\bbm                       <char-0x1D55E>               " 𝕞          : MATHEMATICAL DOUBLE-STRUCK SMALL M
\\bbn                       <char-0x1D55F>               " 𝕟          : MATHEMATICAL DOUBLE-STRUCK SMALL N
\\bbn<Tab>                  <char-0x1D55F>               " 𝕟          : MATHEMATICAL DOUBLE-STRUCK SMALL N
\\bbni                      \\bbni                       "            : (Incomplete sequence)
\\bbnine                    <char-0x1D7E1>               " 𝟡          : MATHEMATICAL DOUBLE-STRUCK DIGIT NINE
\\bbo                       <char-0x1D560>               " 𝕠          : MATHEMATICAL DOUBLE-STRUCK SMALL O
\\bbo<Tab>                  <char-0x1D560>               " 𝕠          : MATHEMATICAL DOUBLE-STRUCK SMALL O
\\bbon                      \\bbon                       "            : (Incomplete sequence)
\\bbone                     <char-0x1D7D9>               " 𝟙          : MATHEMATICAL DOUBLE-STRUCK DIGIT ONE
\\bbp                       <char-0x1D561>               " 𝕡          : MATHEMATICAL DOUBLE-STRUCK SMALL P
\\bbp<Tab>                  <char-0x1D561>               " 𝕡          : MATHEMATICAL DOUBLE-STRUCK SMALL P
\\bbpi                      <char-0x0213C>               " ℼ          : DOUBLE-STRUCK SMALL PI
\\bbq                       <char-0x1D562>               " 𝕢          : MATHEMATICAL DOUBLE-STRUCK SMALL Q
\\bbr                       <char-0x1D563>               " 𝕣          : MATHEMATICAL DOUBLE-STRUCK SMALL R
\\bbr<Tab>                  <char-0x1D563>               " 𝕣          : MATHEMATICAL DOUBLE-STRUCK SMALL R
\\bbrk                      \\bbrk                       "            : (Incomplete sequence)
\\bbrktbrk                  <char-0x023B6>               " ⎶          : BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET
\\bbs                       <char-0x1D564>               " 𝕤          : MATHEMATICAL DOUBLE-STRUCK SMALL S
\\bbs<Tab>                  <char-0x1D564>               " 𝕤          : MATHEMATICAL DOUBLE-STRUCK SMALL S
\\bbse                      \\bbse                       "            : (Incomplete sequence)
\\bbsemi                    <char-0x02A1F>               " ⨟          : Z NOTATION SCHEMA COMPOSITION
\\bbseven                   <char-0x1D7DF>               " 𝟟          : MATHEMATICAL DOUBLE-STRUCK DIGIT SEVEN
\\bbsi                      \\bbsi                       "            : (Incomplete sequence)
\\bbsix                     <char-0x1D7DE>               " 𝟞          : MATHEMATICAL DOUBLE-STRUCK DIGIT SIX
\\bbsu                      \\bbsu                       "            : (Incomplete sequence)
\\bbsum                     <char-0x02140>               " ⅀          : DOUBLE-STRUCK N-ARY SUMMATION
\\bbt                       <char-0x1D565>               " 𝕥          : MATHEMATICAL DOUBLE-STRUCK SMALL T
\\bbt<Tab>                  <char-0x1D565>               " 𝕥          : MATHEMATICAL DOUBLE-STRUCK SMALL T
\\bbth                      \\bbth                       "            : (Incomplete sequence)
\\bbthree                   <char-0x1D7DB>               " 𝟛          : MATHEMATICAL DOUBLE-STRUCK DIGIT THREE
\\bbtw                      \\bbtw                       "            : (Incomplete sequence)
\\bbtwo                     <char-0x1D7DA>               " 𝟚          : MATHEMATICAL DOUBLE-STRUCK DIGIT TWO
\\bbu                       <char-0x1D566>               " 𝕦          : MATHEMATICAL DOUBLE-STRUCK SMALL U
\\bbv                       <char-0x1D567>               " 𝕧          : MATHEMATICAL DOUBLE-STRUCK SMALL V
\\bbw                       <char-0x1D568>               " 𝕨          : MATHEMATICAL DOUBLE-STRUCK SMALL W
\\bbx                       <char-0x1D569>               " 𝕩          : MATHEMATICAL DOUBLE-STRUCK SMALL X
\\bby                       <char-0x1D56A>               " 𝕪          : MATHEMATICAL DOUBLE-STRUCK SMALL Y
\\bbz                       <char-0x1D56B>               " 𝕫          : MATHEMATICAL DOUBLE-STRUCK SMALL Z
\\bbz<Tab>                  <char-0x1D56B>               " 𝕫          : MATHEMATICAL DOUBLE-STRUCK SMALL Z
\\bbze                      \\bbze                       "            : (Incomplete sequence)
\\bbzero                    <char-0x1D7D8>               " 𝟘          : MATHEMATICAL DOUBLE-STRUCK DIGIT ZERO
\\because                   <char-0x02235>               " ∵          : BECAUSE
\\benzenr                   <char-0x023E3>               " ⏣          : BENZENE RING WITH CIRCLE
\\beta                      <char-0x003B2>               " β          : GREEK SMALL LETTER BETA
\\beth                      <char-0x02136>               " ℶ          : BET SYMBOL / SECOND TRANSFINITE CARDINAL
\\between                   <char-0x0226C>               " ≬          : BETWEEN
\\bfA                       <char-0x1D400>               " 𝐀          : MATHEMATICAL BOLD CAPITAL A
\\bfA<Tab>                  <char-0x1D400>               " 𝐀          : MATHEMATICAL BOLD CAPITAL A
\\bfAl                      \\bfAl                       "            : (Incomplete sequence)
\\bfAlpha                   <char-0x1D6A8>               " 𝚨          : MATHEMATICAL BOLD CAPITAL ALPHA
\\bfB                       <char-0x1D401>               " 𝐁          : MATHEMATICAL BOLD CAPITAL B
\\bfB<Tab>                  <char-0x1D401>               " 𝐁          : MATHEMATICAL BOLD CAPITAL B
\\bfBe                      \\bfBe                       "            : (Incomplete sequence)
\\bfBeta                    <char-0x1D6A9>               " 𝚩          : MATHEMATICAL BOLD CAPITAL BETA
\\bfC                       <char-0x1D402>               " 𝐂          : MATHEMATICAL BOLD CAPITAL C
\\bfC<Tab>                  <char-0x1D402>               " 𝐂          : MATHEMATICAL BOLD CAPITAL C
\\bfCh                      \\bfCh                       "            : (Incomplete sequence)
\\bfChi                     <char-0x1D6BE>               " 𝚾          : MATHEMATICAL BOLD CAPITAL CHI
\\bfD                       <char-0x1D403>               " 𝐃          : MATHEMATICAL BOLD CAPITAL D
\\bfD<Tab>                  <char-0x1D403>               " 𝐃          : MATHEMATICAL BOLD CAPITAL D
\\bfDe                      \\bfDe                       "            : (Incomplete sequence)
\\bfDelta                   <char-0x1D6AB>               " 𝚫          : MATHEMATICAL BOLD CAPITAL DELTA
\\bfDi                      \\bfDi                       "            : (Incomplete sequence)
\\bfDigamma                 <char-0x1D7CA>               " 𝟊          : MATHEMATICAL BOLD CAPITAL DIGAMMA
\\bfE                       <char-0x1D404>               " 𝐄          : MATHEMATICAL BOLD CAPITAL E
\\bfE<Tab>                  <char-0x1D404>               " 𝐄          : MATHEMATICAL BOLD CAPITAL E
\\bfEp                      \\bfEp                       "            : (Incomplete sequence)
\\bfEpsilon                 <char-0x1D6AC>               " 𝚬          : MATHEMATICAL BOLD CAPITAL EPSILON
\\bfEt                      \\bfEt                       "            : (Incomplete sequence)
\\bfEta                     <char-0x1D6AE>               " 𝚮          : MATHEMATICAL BOLD CAPITAL ETA
\\bfF                       <char-0x1D405>               " 𝐅          : MATHEMATICAL BOLD CAPITAL F
\\bfG                       <char-0x1D406>               " 𝐆          : MATHEMATICAL BOLD CAPITAL G
\\bfG<Tab>                  <char-0x1D406>               " 𝐆          : MATHEMATICAL BOLD CAPITAL G
\\bfGa                      \\bfGa                       "            : (Incomplete sequence)
\\bfGamma                   <char-0x1D6AA>               " 𝚪          : MATHEMATICAL BOLD CAPITAL GAMMA
\\bfH                       <char-0x1D407>               " 𝐇          : MATHEMATICAL BOLD CAPITAL H
\\bfI                       <char-0x1D408>               " 𝐈          : MATHEMATICAL BOLD CAPITAL I
\\bfI<Tab>                  <char-0x1D408>               " 𝐈          : MATHEMATICAL BOLD CAPITAL I
\\bfIo                      \\bfIo                       "            : (Incomplete sequence)
\\bfIota                    <char-0x1D6B0>               " 𝚰          : MATHEMATICAL BOLD CAPITAL IOTA
\\bfJ                       <char-0x1D409>               " 𝐉          : MATHEMATICAL BOLD CAPITAL J
\\bfK                       <char-0x1D40A>               " 𝐊          : MATHEMATICAL BOLD CAPITAL K
\\bfK<Tab>                  <char-0x1D40A>               " 𝐊          : MATHEMATICAL BOLD CAPITAL K
\\bfKa                      \\bfKa                       "            : (Incomplete sequence)
\\bfKappa                   <char-0x1D6B1>               " 𝚱          : MATHEMATICAL BOLD CAPITAL KAPPA
\\bfL                       <char-0x1D40B>               " 𝐋          : MATHEMATICAL BOLD CAPITAL L
\\bfL<Tab>                  <char-0x1D40B>               " 𝐋          : MATHEMATICAL BOLD CAPITAL L
\\bfLa                      \\bfLa                       "            : (Incomplete sequence)
\\bfLambda                  <char-0x1D6B2>               " 𝚲          : MATHEMATICAL BOLD CAPITAL LAMDA
\\bfM                       <char-0x1D40C>               " 𝐌          : MATHEMATICAL BOLD CAPITAL M
\\bfM<Tab>                  <char-0x1D40C>               " 𝐌          : MATHEMATICAL BOLD CAPITAL M
\\bfMu                      <char-0x1D6B3>               " 𝚳          : MATHEMATICAL BOLD CAPITAL MU
\\bfN                       <char-0x1D40D>               " 𝐍          : MATHEMATICAL BOLD CAPITAL N
\\bfN<Tab>                  <char-0x1D40D>               " 𝐍          : MATHEMATICAL BOLD CAPITAL N
\\bfNu                      <char-0x1D6B4>               " 𝚴          : MATHEMATICAL BOLD CAPITAL NU
\\bfO                       <char-0x1D40E>               " 𝐎          : MATHEMATICAL BOLD CAPITAL O
\\bfO<Tab>                  <char-0x1D40E>               " 𝐎          : MATHEMATICAL BOLD CAPITAL O
\\bfOm                      \\bfOm                       "            : (Incomplete sequence)
\\bfOmega                   <char-0x1D6C0>               " 𝛀          : MATHEMATICAL BOLD CAPITAL OMEGA
\\bfOmicron                 <char-0x1D6B6>               " 𝚶          : MATHEMATICAL BOLD CAPITAL OMICRON
\\bfP                       <char-0x1D40F>               " 𝐏          : MATHEMATICAL BOLD CAPITAL P
\\bfP<Tab>                  <char-0x1D40F>               " 𝐏          : MATHEMATICAL BOLD CAPITAL P
\\bfPh                      \\bfPh                       "            : (Incomplete sequence)
\\bfPhi                     <char-0x1D6BD>               " 𝚽          : MATHEMATICAL BOLD CAPITAL PHI
\\bfPi                      <char-0x1D6B7>               " 𝚷          : MATHEMATICAL BOLD CAPITAL PI
\\bfPs                      \\bfPs                       "            : (Incomplete sequence)
\\bfPsi                     <char-0x1D6BF>               " 𝚿          : MATHEMATICAL BOLD CAPITAL PSI
\\bfQ                       <char-0x1D410>               " 𝐐          : MATHEMATICAL BOLD CAPITAL Q
\\bfR                       <char-0x1D411>               " 𝐑          : MATHEMATICAL BOLD CAPITAL R
\\bfR<Tab>                  <char-0x1D411>               " 𝐑          : MATHEMATICAL BOLD CAPITAL R
\\bfRh                      \\bfRh                       "            : (Incomplete sequence)
\\bfRho                     <char-0x1D6B8>               " 𝚸          : MATHEMATICAL BOLD CAPITAL RHO
\\bfS                       <char-0x1D412>               " 𝐒          : MATHEMATICAL BOLD CAPITAL S
\\bfS<Tab>                  <char-0x1D412>               " 𝐒          : MATHEMATICAL BOLD CAPITAL S
\\bfSi                      \\bfSi                       "            : (Incomplete sequence)
\\bfSigma                   <char-0x1D6BA>               " 𝚺          : MATHEMATICAL BOLD CAPITAL SIGMA
\\bfT                       <char-0x1D413>               " 𝐓          : MATHEMATICAL BOLD CAPITAL T
\\bfT<Tab>                  <char-0x1D413>               " 𝐓          : MATHEMATICAL BOLD CAPITAL T
\\bfTa                      \\bfTa                       "            : (Incomplete sequence)
\\bfTau                     <char-0x1D6BB>               " 𝚻          : MATHEMATICAL BOLD CAPITAL TAU
\\bfTh                      \\bfTh                       "            : (Incomplete sequence)
\\bfTheta                   <char-0x1D6AF>               " 𝚯          : MATHEMATICAL BOLD CAPITAL THETA
\\bfU                       <char-0x1D414>               " 𝐔          : MATHEMATICAL BOLD CAPITAL U
\\bfU<Tab>                  <char-0x1D414>               " 𝐔          : MATHEMATICAL BOLD CAPITAL U
\\bfUp                      \\bfUp                       "            : (Incomplete sequence)
\\bfUpsilon                 <char-0x1D6BC>               " 𝚼          : MATHEMATICAL BOLD CAPITAL UPSILON
\\bfV                       <char-0x1D415>               " 𝐕          : MATHEMATICAL BOLD CAPITAL V
\\bfW                       <char-0x1D416>               " 𝐖          : MATHEMATICAL BOLD CAPITAL W
\\bfX                       <char-0x1D417>               " 𝐗          : MATHEMATICAL BOLD CAPITAL X
\\bfX<Tab>                  <char-0x1D417>               " 𝐗          : MATHEMATICAL BOLD CAPITAL X
\\bfXi                      <char-0x1D6B5>               " 𝚵          : MATHEMATICAL BOLD CAPITAL XI
\\bfY                       <char-0x1D418>               " 𝐘          : MATHEMATICAL BOLD CAPITAL Y
\\bfZ                       <char-0x1D419>               " 𝐙          : MATHEMATICAL BOLD CAPITAL Z
\\bfZ<Tab>                  <char-0x1D419>               " 𝐙          : MATHEMATICAL BOLD CAPITAL Z
\\bfZe                      \\bfZe                       "            : (Incomplete sequence)
\\bfZeta                    <char-0x1D6AD>               " 𝚭          : MATHEMATICAL BOLD CAPITAL ZETA
\\bfa                       <char-0x1D41A>               " 𝐚          : MATHEMATICAL BOLD SMALL A
\\bfa<Tab>                  <char-0x1D41A>               " 𝐚          : MATHEMATICAL BOLD SMALL A
\\bfal                      \\bfal                       "            : (Incomplete sequence)
\\bfalpha                   <char-0x1D6C2>               " 𝛂          : MATHEMATICAL BOLD SMALL ALPHA
\\bfb                       <char-0x1D41B>               " 𝐛          : MATHEMATICAL BOLD SMALL B
\\bfb<Tab>                  <char-0x1D41B>               " 𝐛          : MATHEMATICAL BOLD SMALL B
\\bfbe                      \\bfbe                       "            : (Incomplete sequence)
\\bfbeta                    <char-0x1D6C3>               " 𝛃          : MATHEMATICAL BOLD SMALL BETA
\\bfc                       <char-0x1D41C>               " 𝐜          : MATHEMATICAL BOLD SMALL C
\\bfc<Tab>                  <char-0x1D41C>               " 𝐜          : MATHEMATICAL BOLD SMALL C
\\bfch                      \\bfch                       "            : (Incomplete sequence)
\\bfchi                     <char-0x1D6D8>               " 𝛘          : MATHEMATICAL BOLD SMALL CHI
\\bfd                       <char-0x1D41D>               " 𝐝          : MATHEMATICAL BOLD SMALL D
\\bfd<Tab>                  <char-0x1D41D>               " 𝐝          : MATHEMATICAL BOLD SMALL D
\\bfde                      \\bfde                       "            : (Incomplete sequence)
\\bfdelta                   <char-0x1D6C5>               " 𝛅          : MATHEMATICAL BOLD SMALL DELTA
\\bfdi                      \\bfdi                       "            : (Incomplete sequence)
\\bfdigamma                 <char-0x1D7CB>               " 𝟋          : MATHEMATICAL BOLD SMALL DIGAMMA
\\bfe                       <char-0x1D41E>               " 𝐞          : MATHEMATICAL BOLD SMALL E
\\bfe<Tab>                  <char-0x1D41E>               " 𝐞          : MATHEMATICAL BOLD SMALL E
\\bfei                      \\bfei                       "            : (Incomplete sequence)
\\bfeight                   <char-0x1D7D6>               " 𝟖          : MATHEMATICAL BOLD DIGIT EIGHT
\\bfep                      \\bfep                       "            : (Incomplete sequence)
\\bfepsilon                 <char-0x1D6DC>               " 𝛜          : MATHEMATICAL BOLD EPSILON SYMBOL
\\bfet                      \\bfet                       "            : (Incomplete sequence)
\\bfeta                     <char-0x1D6C8>               " 𝛈          : MATHEMATICAL BOLD SMALL ETA
\\bff                       <char-0x1D41F>               " 𝐟          : MATHEMATICAL BOLD SMALL F
\\bff<Tab>                  <char-0x1D41F>               " 𝐟          : MATHEMATICAL BOLD SMALL F
\\bffi                      \\bffi                       "            : (Incomplete sequence)
\\bffive                    <char-0x1D7D3>               " 𝟓          : MATHEMATICAL BOLD DIGIT FIVE
\\bffo                      \\bffo                       "            : (Incomplete sequence)
\\bffour                    <char-0x1D7D2>               " 𝟒          : MATHEMATICAL BOLD DIGIT FOUR
\\bfg                       <char-0x1D420>               " 𝐠          : MATHEMATICAL BOLD SMALL G
\\bfg<Tab>                  <char-0x1D420>               " 𝐠          : MATHEMATICAL BOLD SMALL G
\\bfga                      \\bfga                       "            : (Incomplete sequence)
\\bfgamma                   <char-0x1D6C4>               " 𝛄          : MATHEMATICAL BOLD SMALL GAMMA
\\bfh                       <char-0x1D421>               " 𝐡          : MATHEMATICAL BOLD SMALL H
\\bfi                       <char-0x1D422>               " 𝐢          : MATHEMATICAL BOLD SMALL I
\\bfi<Tab>                  <char-0x1D422>               " 𝐢          : MATHEMATICAL BOLD SMALL I
\\bfio                      \\bfio                       "            : (Incomplete sequence)
\\bfiota                    <char-0x1D6CA>               " 𝛊          : MATHEMATICAL BOLD SMALL IOTA
\\bfj                       <char-0x1D423>               " 𝐣          : MATHEMATICAL BOLD SMALL J
\\bfk                       <char-0x1D424>               " 𝐤          : MATHEMATICAL BOLD SMALL K
\\bfk<Tab>                  <char-0x1D424>               " 𝐤          : MATHEMATICAL BOLD SMALL K
\\bfka                      \\bfka                       "            : (Incomplete sequence)
\\bfkappa                   <char-0x1D6CB>               " 𝛋          : MATHEMATICAL BOLD SMALL KAPPA
\\bfl                       <char-0x1D425>               " 𝐥          : MATHEMATICAL BOLD SMALL L
\\bfl<Tab>                  <char-0x1D425>               " 𝐥          : MATHEMATICAL BOLD SMALL L
\\bfla                      \\bfla                       "            : (Incomplete sequence)
\\bflambda                  <char-0x1D6CC>               " 𝛌          : MATHEMATICAL BOLD SMALL LAMDA
\\bfm                       <char-0x1D426>               " 𝐦          : MATHEMATICAL BOLD SMALL M
\\bfm<Tab>                  <char-0x1D426>               " 𝐦          : MATHEMATICAL BOLD SMALL M
\\bfmu                      <char-0x1D6CD>               " 𝛍          : MATHEMATICAL BOLD SMALL MU
\\bfn                       <char-0x1D427>               " 𝐧          : MATHEMATICAL BOLD SMALL N
\\bfn<Tab>                  <char-0x1D427>               " 𝐧          : MATHEMATICAL BOLD SMALL N
\\bfna                      \\bfna                       "            : (Incomplete sequence)
\\bfnabla                   <char-0x1D6C1>               " 𝛁          : MATHEMATICAL BOLD NABLA
\\bfni                      \\bfni                       "            : (Incomplete sequence)
\\bfnine                    <char-0x1D7D7>               " 𝟗          : MATHEMATICAL BOLD DIGIT NINE
\\bfnu                      <char-0x1D6CE>               " 𝛎          : MATHEMATICAL BOLD SMALL NU
\\bfo                       <char-0x1D428>               " 𝐨          : MATHEMATICAL BOLD SMALL O
\\bfo<Tab>                  <char-0x1D428>               " 𝐨          : MATHEMATICAL BOLD SMALL O
\\bfom                      \\bfom                       "            : (Incomplete sequence)
\\bfomega                   <char-0x1D6DA>               " 𝛚          : MATHEMATICAL BOLD SMALL OMEGA
\\bfomicron                 <char-0x1D6D0>               " 𝛐          : MATHEMATICAL BOLD SMALL OMICRON
\\bfon                      \\bfon                       "            : (Incomplete sequence)
\\bfone                     <char-0x1D7CF>               " 𝟏          : MATHEMATICAL BOLD DIGIT ONE
\\bfp                       <char-0x1D429>               " 𝐩          : MATHEMATICAL BOLD SMALL P
\\bfp<Tab>                  <char-0x1D429>               " 𝐩          : MATHEMATICAL BOLD SMALL P
\\bfpa                      \\bfpa                       "            : (Incomplete sequence)
\\bfpartial                 <char-0x1D6DB>               " 𝛛          : MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
\\bfph                      \\bfph                       "            : (Incomplete sequence)
\\bfphi                     <char-0x1D6DF>               " 𝛟          : MATHEMATICAL BOLD PHI SYMBOL
\\bfpi                      <char-0x1D6D1>               " 𝛑          : MATHEMATICAL BOLD SMALL PI
\\bfps                      \\bfps                       "            : (Incomplete sequence)
\\bfpsi                     <char-0x1D6D9>               " 𝛙          : MATHEMATICAL BOLD SMALL PSI
\\bfq                       <char-0x1D42A>               " 𝐪          : MATHEMATICAL BOLD SMALL Q
\\bfr                       <char-0x1D42B>               " 𝐫          : MATHEMATICAL BOLD SMALL R
\\bfr<Tab>                  <char-0x1D42B>               " 𝐫          : MATHEMATICAL BOLD SMALL R
\\bfra                      \\bfra                       "            : (Incomplete sequence)
\\bfrakA                    <char-0x1D56C>               " 𝕬          : MATHEMATICAL BOLD FRAKTUR CAPITAL A
\\bfrakB                    <char-0x1D56D>               " 𝕭          : MATHEMATICAL BOLD FRAKTUR CAPITAL B
\\bfrakC                    <char-0x1D56E>               " 𝕮          : MATHEMATICAL BOLD FRAKTUR CAPITAL C
\\bfrakD                    <char-0x1D56F>               " 𝕯          : MATHEMATICAL BOLD FRAKTUR CAPITAL D
\\bfrakE                    <char-0x1D570>               " 𝕰          : MATHEMATICAL BOLD FRAKTUR CAPITAL E
\\bfrakF                    <char-0x1D571>               " 𝕱          : MATHEMATICAL BOLD FRAKTUR CAPITAL F
\\bfrakG                    <char-0x1D572>               " 𝕲          : MATHEMATICAL BOLD FRAKTUR CAPITAL G
\\bfrakH                    <char-0x1D573>               " 𝕳          : MATHEMATICAL BOLD FRAKTUR CAPITAL H
\\bfrakI                    <char-0x1D574>               " 𝕴          : MATHEMATICAL BOLD FRAKTUR CAPITAL I
\\bfrakJ                    <char-0x1D575>               " 𝕵          : MATHEMATICAL BOLD FRAKTUR CAPITAL J
\\bfrakK                    <char-0x1D576>               " 𝕶          : MATHEMATICAL BOLD FRAKTUR CAPITAL K
\\bfrakL                    <char-0x1D577>               " 𝕷          : MATHEMATICAL BOLD FRAKTUR CAPITAL L
\\bfrakM                    <char-0x1D578>               " 𝕸          : MATHEMATICAL BOLD FRAKTUR CAPITAL M
\\bfrakN                    <char-0x1D579>               " 𝕹          : MATHEMATICAL BOLD FRAKTUR CAPITAL N
\\bfrakO                    <char-0x1D57A>               " 𝕺          : MATHEMATICAL BOLD FRAKTUR CAPITAL O
\\bfrakP                    <char-0x1D57B>               " 𝕻          : MATHEMATICAL BOLD FRAKTUR CAPITAL P
\\bfrakQ                    <char-0x1D57C>               " 𝕼          : MATHEMATICAL BOLD FRAKTUR CAPITAL Q
\\bfrakR                    <char-0x1D57D>               " 𝕽          : MATHEMATICAL BOLD FRAKTUR CAPITAL R
\\bfrakS                    <char-0x1D57E>               " 𝕾          : MATHEMATICAL BOLD FRAKTUR CAPITAL S
\\bfrakT                    <char-0x1D57F>               " 𝕿          : MATHEMATICAL BOLD FRAKTUR CAPITAL T
\\bfrakU                    <char-0x1D580>               " 𝖀          : MATHEMATICAL BOLD FRAKTUR CAPITAL U
\\bfrakV                    <char-0x1D581>               " 𝖁          : MATHEMATICAL BOLD FRAKTUR CAPITAL V
\\bfrakW                    <char-0x1D582>               " 𝖂          : MATHEMATICAL BOLD FRAKTUR CAPITAL W
\\bfrakX                    <char-0x1D583>               " 𝖃          : MATHEMATICAL BOLD FRAKTUR CAPITAL X
\\bfrakY                    <char-0x1D584>               " 𝖄          : MATHEMATICAL BOLD FRAKTUR CAPITAL Y
\\bfrakZ                    <char-0x1D585>               " 𝖅          : MATHEMATICAL BOLD FRAKTUR CAPITAL Z
\\bfraka                    <char-0x1D586>               " 𝖆          : MATHEMATICAL BOLD FRAKTUR SMALL A
\\bfrakb                    <char-0x1D587>               " 𝖇          : MATHEMATICAL BOLD FRAKTUR SMALL B
\\bfrakc                    <char-0x1D588>               " 𝖈          : MATHEMATICAL BOLD FRAKTUR SMALL C
\\bfrakd                    <char-0x1D589>               " 𝖉          : MATHEMATICAL BOLD FRAKTUR SMALL D
\\bfrake                    <char-0x1D58A>               " 𝖊          : MATHEMATICAL BOLD FRAKTUR SMALL E
\\bfrakf                    <char-0x1D58B>               " 𝖋          : MATHEMATICAL BOLD FRAKTUR SMALL F
\\bfrakg                    <char-0x1D58C>               " 𝖌          : MATHEMATICAL BOLD FRAKTUR SMALL G
\\bfrakh                    <char-0x1D58D>               " 𝖍          : MATHEMATICAL BOLD FRAKTUR SMALL H
\\bfraki                    <char-0x1D58E>               " 𝖎          : MATHEMATICAL BOLD FRAKTUR SMALL I
\\bfrakj                    <char-0x1D58F>               " 𝖏          : MATHEMATICAL BOLD FRAKTUR SMALL J
\\bfrakk                    <char-0x1D590>               " 𝖐          : MATHEMATICAL BOLD FRAKTUR SMALL K
\\bfrakl                    <char-0x1D591>               " 𝖑          : MATHEMATICAL BOLD FRAKTUR SMALL L
\\bfrakm                    <char-0x1D592>               " 𝖒          : MATHEMATICAL BOLD FRAKTUR SMALL M
\\bfrakn                    <char-0x1D593>               " 𝖓          : MATHEMATICAL BOLD FRAKTUR SMALL N
\\bfrako                    <char-0x1D594>               " 𝖔          : MATHEMATICAL BOLD FRAKTUR SMALL O
\\bfrakp                    <char-0x1D595>               " 𝖕          : MATHEMATICAL BOLD FRAKTUR SMALL P
\\bfrakq                    <char-0x1D596>               " 𝖖          : MATHEMATICAL BOLD FRAKTUR SMALL Q
\\bfrakr                    <char-0x1D597>               " 𝖗          : MATHEMATICAL BOLD FRAKTUR SMALL R
\\bfraks                    <char-0x1D598>               " 𝖘          : MATHEMATICAL BOLD FRAKTUR SMALL S
\\bfrakt                    <char-0x1D599>               " 𝖙          : MATHEMATICAL BOLD FRAKTUR SMALL T
\\bfraku                    <char-0x1D59A>               " 𝖚          : MATHEMATICAL BOLD FRAKTUR SMALL U
\\bfrakv                    <char-0x1D59B>               " 𝖛          : MATHEMATICAL BOLD FRAKTUR SMALL V
\\bfrakw                    <char-0x1D59C>               " 𝖜          : MATHEMATICAL BOLD FRAKTUR SMALL W
\\bfrakx                    <char-0x1D59D>               " 𝖝          : MATHEMATICAL BOLD FRAKTUR SMALL X
\\bfraky                    <char-0x1D59E>               " 𝖞          : MATHEMATICAL BOLD FRAKTUR SMALL Y
\\bfrakz                    <char-0x1D59F>               " 𝖟          : MATHEMATICAL BOLD FRAKTUR SMALL Z
\\bfrh                      \\bfrh                       "            : (Incomplete sequence)
\\bfrho                     <char-0x1D6D2>               " 𝛒          : MATHEMATICAL BOLD SMALL RHO
\\bfs                       <char-0x1D42C>               " 𝐬          : MATHEMATICAL BOLD SMALL S
\\bfs<Tab>                  <char-0x1D42C>               " 𝐬          : MATHEMATICAL BOLD SMALL S
\\bfse                      \\bfse                       "            : (Incomplete sequence)
\\bfseven                   <char-0x1D7D5>               " 𝟕          : MATHEMATICAL BOLD DIGIT SEVEN
\\bfsi                      \\bfsi                       "            : (Incomplete sequence)
\\bfsigma                   <char-0x1D6D4>               " 𝛔          : MATHEMATICAL BOLD SMALL SIGMA
\\bfsix                     <char-0x1D7D4>               " 𝟔          : MATHEMATICAL BOLD DIGIT SIX
\\bft                       <char-0x1D42D>               " 𝐭          : MATHEMATICAL BOLD SMALL T
\\bft<Tab>                  <char-0x1D42D>               " 𝐭          : MATHEMATICAL BOLD SMALL T
\\bfta                      \\bfta                       "            : (Incomplete sequence)
\\bftau                     <char-0x1D6D5>               " 𝛕          : MATHEMATICAL BOLD SMALL TAU
\\bfth                      \\bfth                       "            : (Incomplete sequence)
\\bftheta                   <char-0x1D6C9>               " 𝛉          : MATHEMATICAL BOLD SMALL THETA
\\bfthree                   <char-0x1D7D1>               " 𝟑          : MATHEMATICAL BOLD DIGIT THREE
\\bftw                      \\bftw                       "            : (Incomplete sequence)
\\bftwo                     <char-0x1D7D0>               " 𝟐          : MATHEMATICAL BOLD DIGIT TWO
\\bfu                       <char-0x1D42E>               " 𝐮          : MATHEMATICAL BOLD SMALL U
\\bfu<Tab>                  <char-0x1D42E>               " 𝐮          : MATHEMATICAL BOLD SMALL U
\\bfup                      \\bfup                       "            : (Incomplete sequence)
\\bfupsilon                 <char-0x1D6D6>               " 𝛖          : MATHEMATICAL BOLD SMALL UPSILON
\\bfv                       <char-0x1D42F>               " 𝐯          : MATHEMATICAL BOLD SMALL V
\\bfv<Tab>                  <char-0x1D42F>               " 𝐯          : MATHEMATICAL BOLD SMALL V
\\bfva                      \\bfva                       "            : (Incomplete sequence)
\\bfvarTheta                <char-0x1D6B9>               " 𝚹          : MATHEMATICAL BOLD CAPITAL THETA SYMBOL
\\bfvarepsilon              <char-0x1D6C6>               " 𝛆          : MATHEMATICAL BOLD SMALL EPSILON
\\bfvarkappa                <char-0x1D6DE>               " 𝛞          : MATHEMATICAL BOLD KAPPA SYMBOL
\\bfvarphi                  <char-0x1D6D7>               " 𝛗          : MATHEMATICAL BOLD SMALL PHI
\\bfvarpi                   <char-0x1D6E1>               " 𝛡          : MATHEMATICAL BOLD PI SYMBOL
\\bfvarrho                  <char-0x1D6E0>               " 𝛠          : MATHEMATICAL BOLD RHO SYMBOL
\\bfvarsigma                <char-0x1D6D3>               " 𝛓          : MATHEMATICAL BOLD SMALL FINAL SIGMA
\\bfvartheta                <char-0x1D6DD>               " 𝛝          : MATHEMATICAL BOLD THETA SYMBOL
\\bfw                       <char-0x1D430>               " 𝐰          : MATHEMATICAL BOLD SMALL W
\\bfx                       <char-0x1D431>               " 𝐱          : MATHEMATICAL BOLD SMALL X
\\bfx<Tab>                  <char-0x1D431>               " 𝐱          : MATHEMATICAL BOLD SMALL X
\\bfxi                      <char-0x1D6CF>               " 𝛏          : MATHEMATICAL BOLD SMALL XI
\\bfy                       <char-0x1D432>               " 𝐲          : MATHEMATICAL BOLD SMALL Y
\\bfz                       <char-0x1D433>               " 𝐳          : MATHEMATICAL BOLD SMALL Z
\\bfz<Tab>                  <char-0x1D433>               " 𝐳          : MATHEMATICAL BOLD SMALL Z
\\bfze                      \\bfze                       "            : (Incomplete sequence)
\\bfzero                    <char-0x1D7CE>               " 𝟎          : MATHEMATICAL BOLD DIGIT ZERO
\\bfzeta                    <char-0x1D6C7>               " 𝛇          : MATHEMATICAL BOLD SMALL ZETA
\\biA                       <char-0x1D468>               " 𝑨          : MATHEMATICAL BOLD ITALIC CAPITAL A
\\biA<Tab>                  <char-0x1D468>               " 𝑨          : MATHEMATICAL BOLD ITALIC CAPITAL A
\\biAl                      \\biAl                       "            : (Incomplete sequence)
\\biAlpha                   <char-0x1D71C>               " 𝜜          : MATHEMATICAL BOLD ITALIC CAPITAL ALPHA
\\biB                       <char-0x1D469>               " 𝑩          : MATHEMATICAL BOLD ITALIC CAPITAL B
\\biB<Tab>                  <char-0x1D469>               " 𝑩          : MATHEMATICAL BOLD ITALIC CAPITAL B
\\biBe                      \\biBe                       "            : (Incomplete sequence)
\\biBeta                    <char-0x1D71D>               " 𝜝          : MATHEMATICAL BOLD ITALIC CAPITAL BETA
\\biC                       <char-0x1D46A>               " 𝑪          : MATHEMATICAL BOLD ITALIC CAPITAL C
\\biC<Tab>                  <char-0x1D46A>               " 𝑪          : MATHEMATICAL BOLD ITALIC CAPITAL C
\\biCh                      \\biCh                       "            : (Incomplete sequence)
\\biChi                     <char-0x1D732>               " 𝜲          : MATHEMATICAL BOLD ITALIC CAPITAL CHI
\\biD                       <char-0x1D46B>               " 𝑫          : MATHEMATICAL BOLD ITALIC CAPITAL D
\\biD<Tab>                  <char-0x1D46B>               " 𝑫          : MATHEMATICAL BOLD ITALIC CAPITAL D
\\biDe                      \\biDe                       "            : (Incomplete sequence)
\\biDelta                   <char-0x1D71F>               " 𝜟          : MATHEMATICAL BOLD ITALIC CAPITAL DELTA
\\biE                       <char-0x1D46C>               " 𝑬          : MATHEMATICAL BOLD ITALIC CAPITAL E
\\biE<Tab>                  <char-0x1D46C>               " 𝑬          : MATHEMATICAL BOLD ITALIC CAPITAL E
\\biEp                      \\biEp                       "            : (Incomplete sequence)
\\biEpsilon                 <char-0x1D720>               " 𝜠          : MATHEMATICAL BOLD ITALIC CAPITAL EPSILON
\\biEt                      \\biEt                       "            : (Incomplete sequence)
\\biEta                     <char-0x1D722>               " 𝜢          : MATHEMATICAL BOLD ITALIC CAPITAL ETA
\\biF                       <char-0x1D46D>               " 𝑭          : MATHEMATICAL BOLD ITALIC CAPITAL F
\\biG                       <char-0x1D46E>               " 𝑮          : MATHEMATICAL BOLD ITALIC CAPITAL G
\\biG<Tab>                  <char-0x1D46E>               " 𝑮          : MATHEMATICAL BOLD ITALIC CAPITAL G
\\biGa                      \\biGa                       "            : (Incomplete sequence)
\\biGamma                   <char-0x1D71E>               " 𝜞          : MATHEMATICAL BOLD ITALIC CAPITAL GAMMA
\\biH                       <char-0x1D46F>               " 𝑯          : MATHEMATICAL BOLD ITALIC CAPITAL H
\\biI                       <char-0x1D470>               " 𝑰          : MATHEMATICAL BOLD ITALIC CAPITAL I
\\biI<Tab>                  <char-0x1D470>               " 𝑰          : MATHEMATICAL BOLD ITALIC CAPITAL I
\\biIo                      \\biIo                       "            : (Incomplete sequence)
\\biIota                    <char-0x1D724>               " 𝜤          : MATHEMATICAL BOLD ITALIC CAPITAL IOTA
\\biJ                       <char-0x1D471>               " 𝑱          : MATHEMATICAL BOLD ITALIC CAPITAL J
\\biK                       <char-0x1D472>               " 𝑲          : MATHEMATICAL BOLD ITALIC CAPITAL K
\\biK<Tab>                  <char-0x1D472>               " 𝑲          : MATHEMATICAL BOLD ITALIC CAPITAL K
\\biKa                      \\biKa                       "            : (Incomplete sequence)
\\biKappa                   <char-0x1D725>               " 𝜥          : MATHEMATICAL BOLD ITALIC CAPITAL KAPPA
\\biL                       <char-0x1D473>               " 𝑳          : MATHEMATICAL BOLD ITALIC CAPITAL L
\\biL<Tab>                  <char-0x1D473>               " 𝑳          : MATHEMATICAL BOLD ITALIC CAPITAL L
\\biLa                      \\biLa                       "            : (Incomplete sequence)
\\biLambda                  <char-0x1D726>               " 𝜦          : MATHEMATICAL BOLD ITALIC CAPITAL LAMDA
\\biM                       <char-0x1D474>               " 𝑴          : MATHEMATICAL BOLD ITALIC CAPITAL M
\\biM<Tab>                  <char-0x1D474>               " 𝑴          : MATHEMATICAL BOLD ITALIC CAPITAL M
\\biMu                      <char-0x1D727>               " 𝜧          : MATHEMATICAL BOLD ITALIC CAPITAL MU
\\biN                       <char-0x1D475>               " 𝑵          : MATHEMATICAL BOLD ITALIC CAPITAL N
\\biN<Tab>                  <char-0x1D475>               " 𝑵          : MATHEMATICAL BOLD ITALIC CAPITAL N
\\biNu                      <char-0x1D728>               " 𝜨          : MATHEMATICAL BOLD ITALIC CAPITAL NU
\\biO                       <char-0x1D476>               " 𝑶          : MATHEMATICAL BOLD ITALIC CAPITAL O
\\biO<Tab>                  <char-0x1D476>               " 𝑶          : MATHEMATICAL BOLD ITALIC CAPITAL O
\\biOm                      \\biOm                       "            : (Incomplete sequence)
\\biOmega                   <char-0x1D734>               " 𝜴          : MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
\\biOmicron                 <char-0x1D72A>               " 𝜪          : MATHEMATICAL BOLD ITALIC CAPITAL OMICRON
\\biP                       <char-0x1D477>               " 𝑷          : MATHEMATICAL BOLD ITALIC CAPITAL P
\\biP<Tab>                  <char-0x1D477>               " 𝑷          : MATHEMATICAL BOLD ITALIC CAPITAL P
\\biPh                      \\biPh                       "            : (Incomplete sequence)
\\biPhi                     <char-0x1D731>               " 𝜱          : MATHEMATICAL BOLD ITALIC CAPITAL PHI
\\biPi                      <char-0x1D72B>               " 𝜫          : MATHEMATICAL BOLD ITALIC CAPITAL PI
\\biPs                      \\biPs                       "            : (Incomplete sequence)
\\biPsi                     <char-0x1D733>               " 𝜳          : MATHEMATICAL BOLD ITALIC CAPITAL PSI
\\biQ                       <char-0x1D478>               " 𝑸          : MATHEMATICAL BOLD ITALIC CAPITAL Q
\\biR                       <char-0x1D479>               " 𝑹          : MATHEMATICAL BOLD ITALIC CAPITAL R
\\biR<Tab>                  <char-0x1D479>               " 𝑹          : MATHEMATICAL BOLD ITALIC CAPITAL R
\\biRh                      \\biRh                       "            : (Incomplete sequence)
\\biRho                     <char-0x1D72C>               " 𝜬          : MATHEMATICAL BOLD ITALIC CAPITAL RHO
\\biS                       <char-0x1D47A>               " 𝑺          : MATHEMATICAL BOLD ITALIC CAPITAL S
\\biS<Tab>                  <char-0x1D47A>               " 𝑺          : MATHEMATICAL BOLD ITALIC CAPITAL S
\\biSi                      \\biSi                       "            : (Incomplete sequence)
\\biSigma                   <char-0x1D72E>               " 𝜮          : MATHEMATICAL BOLD ITALIC CAPITAL SIGMA
\\biT                       <char-0x1D47B>               " 𝑻          : MATHEMATICAL BOLD ITALIC CAPITAL T
\\biT<Tab>                  <char-0x1D47B>               " 𝑻          : MATHEMATICAL BOLD ITALIC CAPITAL T
\\biTa                      \\biTa                       "            : (Incomplete sequence)
\\biTau                     <char-0x1D72F>               " 𝜯          : MATHEMATICAL BOLD ITALIC CAPITAL TAU
\\biTh                      \\biTh                       "            : (Incomplete sequence)
\\biTheta                   <char-0x1D723>               " 𝜣          : MATHEMATICAL BOLD ITALIC CAPITAL THETA
\\biU                       <char-0x1D47C>               " 𝑼          : MATHEMATICAL BOLD ITALIC CAPITAL U
\\biU<Tab>                  <char-0x1D47C>               " 𝑼          : MATHEMATICAL BOLD ITALIC CAPITAL U
\\biUp                      \\biUp                       "            : (Incomplete sequence)
\\biUpsilon                 <char-0x1D730>               " 𝜰          : MATHEMATICAL BOLD ITALIC CAPITAL UPSILON
\\biV                       <char-0x1D47D>               " 𝑽          : MATHEMATICAL BOLD ITALIC CAPITAL V
\\biW                       <char-0x1D47E>               " 𝑾          : MATHEMATICAL BOLD ITALIC CAPITAL W
\\biX                       <char-0x1D47F>               " 𝑿          : MATHEMATICAL BOLD ITALIC CAPITAL X
\\biX<Tab>                  <char-0x1D47F>               " 𝑿          : MATHEMATICAL BOLD ITALIC CAPITAL X
\\biXi                      <char-0x1D729>               " 𝜩          : MATHEMATICAL BOLD ITALIC CAPITAL XI
\\biY                       <char-0x1D480>               " 𝒀          : MATHEMATICAL BOLD ITALIC CAPITAL Y
\\biZ                       <char-0x1D481>               " 𝒁          : MATHEMATICAL BOLD ITALIC CAPITAL Z
\\biZ<Tab>                  <char-0x1D481>               " 𝒁          : MATHEMATICAL BOLD ITALIC CAPITAL Z
\\biZe                      \\biZe                       "            : (Incomplete sequence)
\\biZeta                    <char-0x1D721>               " 𝜡          : MATHEMATICAL BOLD ITALIC CAPITAL ZETA
\\bia                       <char-0x1D482>               " 𝒂          : MATHEMATICAL BOLD ITALIC SMALL A
\\bia<Tab>                  <char-0x1D482>               " 𝒂          : MATHEMATICAL BOLD ITALIC SMALL A
\\bial                      \\bial                       "            : (Incomplete sequence)
\\bialpha                   <char-0x1D736>               " 𝜶          : MATHEMATICAL BOLD ITALIC SMALL ALPHA
\\bib                       <char-0x1D483>               " 𝒃          : MATHEMATICAL BOLD ITALIC SMALL B
\\bib<Tab>                  <char-0x1D483>               " 𝒃          : MATHEMATICAL BOLD ITALIC SMALL B
\\bibe                      \\bibe                       "            : (Incomplete sequence)
\\bibeta                    <char-0x1D737>               " 𝜷          : MATHEMATICAL BOLD ITALIC SMALL BETA
\\bic                       <char-0x1D484>               " 𝒄          : MATHEMATICAL BOLD ITALIC SMALL C
\\bic<Tab>                  <char-0x1D484>               " 𝒄          : MATHEMATICAL BOLD ITALIC SMALL C
\\bich                      \\bich                       "            : (Incomplete sequence)
\\bichi                     <char-0x1D74C>               " 𝝌          : MATHEMATICAL BOLD ITALIC SMALL CHI
\\bid                       <char-0x1D485>               " 𝒅          : MATHEMATICAL BOLD ITALIC SMALL D
\\bid<Tab>                  <char-0x1D485>               " 𝒅          : MATHEMATICAL BOLD ITALIC SMALL D
\\bide                      \\bide                       "            : (Incomplete sequence)
\\bidelta                   <char-0x1D739>               " 𝜹          : MATHEMATICAL BOLD ITALIC SMALL DELTA
\\bie                       <char-0x1D486>               " 𝒆          : MATHEMATICAL BOLD ITALIC SMALL E
\\bie<Tab>                  <char-0x1D486>               " 𝒆          : MATHEMATICAL BOLD ITALIC SMALL E
\\biep                      \\biep                       "            : (Incomplete sequence)
\\biepsilon                 <char-0x1D750>               " 𝝐          : MATHEMATICAL BOLD ITALIC EPSILON SYMBOL
\\biet                      \\biet                       "            : (Incomplete sequence)
\\bieta                     <char-0x1D73C>               " 𝜼          : MATHEMATICAL BOLD ITALIC SMALL ETA
\\bif                       <char-0x1D487>               " 𝒇          : MATHEMATICAL BOLD ITALIC SMALL F
\\big                       <char-0x1D488>               " 𝒈          : MATHEMATICAL BOLD ITALIC SMALL G
\\big<Tab>                  <char-0x1D488>               " 𝒈          : MATHEMATICAL BOLD ITALIC SMALL G
\\biga                      \\biga                       "            : (Incomplete sequence)
\\bigamma                   <char-0x1D738>               " 𝜸          : MATHEMATICAL BOLD ITALIC SMALL GAMMA
\\bigb                      \\bigb                       "            : (Incomplete sequence)
\\bigblacktriangledown      <char-0x025BC>               " ▼          : BLACK DOWN-POINTING TRIANGLE / BLACK DOWN POINTING TRIANGLE
\\bigblacktriangleup        <char-0x025B2>               " ▲          : BLACK UP-POINTING TRIANGLE / BLACK UP POINTING TRIANGLE
\\bigbot                    <char-0x027D8>               " ⟘          : LARGE UP TACK
\\bigc                      \\bigc                       "            : (Incomplete sequence)
\\bigcap                    <char-0x022C2>               " ⋂          : N-ARY INTERSECTION
\\bigcirc                   <char-0x025CB>               " ○          : WHITE CIRCLE
\\bigcup                    <char-0x022C3>               " ⋃          : N-ARY UNION
\\bigcup<Tab>               <char-0x022C3>               " ⋃          : N-ARY UNION
\\bigcupd                   \\bigcupd                    "            : (Incomplete sequence)
\\bigcupdot                 <char-0x02A03>               " ⨃          : N-ARY UNION OPERATOR WITH DOT
\\bigo                      \\bigo                       "            : (Incomplete sequence)
\\bigodot                   <char-0x02A00>               " ⨀          : N-ARY CIRCLED DOT OPERATOR
\\bigoplus                  <char-0x02A01>               " ⨁          : N-ARY CIRCLED PLUS OPERATOR
\\bigotimes                 <char-0x02A02>               " ⨂          : N-ARY CIRCLED TIMES OPERATOR
\\bigs                      \\bigs                       "            : (Incomplete sequence)
\\bigslopedvee              <char-0x02A57>               " ⩗          : SLOPING LARGE OR
\\bigslopedwedge            <char-0x02A58>               " ⩘          : SLOPING LARGE AND
\\bigsqcap                  <char-0x02A05>               " ⨅          : N-ARY SQUARE INTERSECTION OPERATOR
\\bigsqcup                  <char-0x02A06>               " ⨆          : N-ARY SQUARE UNION OPERATOR
\\bigstar                   <char-0x02605>               " ★          : BLACK STAR
\\bigt                      \\bigt                       "            : (Incomplete sequence)
\\bigtimes                  <char-0x02A09>               " ⨉          : N-ARY TIMES OPERATOR
\\bigtop                    <char-0x027D9>               " ⟙          : LARGE DOWN TACK
\\bigtriangledown           <char-0x025BD>               " ▽          : WHITE DOWN-POINTING TRIANGLE / WHITE DOWN POINTING TRIANGLE
\\bigtriangleup             <char-0x025B3>               " △          : WHITE UP-POINTING TRIANGLE / WHITE UP POINTING TRIANGLE
\\bigu                      \\bigu                       "            : (Incomplete sequence)
\\biguplus                  <char-0x02A04>               " ⨄          : N-ARY UNION OPERATOR WITH PLUS
\\bigv                      \\bigv                       "            : (Incomplete sequence)
\\bigvee                    <char-0x022C1>               " ⋁          : N-ARY LOGICAL OR
\\bigw                      \\bigw                       "            : (Incomplete sequence)
\\bigwedge                  <char-0x022C0>               " ⋀          : N-ARY LOGICAL AND
\\bigwhitestar              <char-0x02606>               " ☆          : WHITE STAR
\\bih                       <char-0x1D489>               " 𝒉          : MATHEMATICAL BOLD ITALIC SMALL H
\\bii                       <char-0x1D48A>               " 𝒊          : MATHEMATICAL BOLD ITALIC SMALL I
\\bii<Tab>                  <char-0x1D48A>               " 𝒊          : MATHEMATICAL BOLD ITALIC SMALL I
\\biio                      \\biio                       "            : (Incomplete sequence)
\\biiota                    <char-0x1D73E>               " 𝜾          : MATHEMATICAL BOLD ITALIC SMALL IOTA
\\bij                       <char-0x1D48B>               " 𝒋          : MATHEMATICAL BOLD ITALIC SMALL J
\\bik                       <char-0x1D48C>               " 𝒌          : MATHEMATICAL BOLD ITALIC SMALL K
\\bik<Tab>                  <char-0x1D48C>               " 𝒌          : MATHEMATICAL BOLD ITALIC SMALL K
\\bika                      \\bika                       "            : (Incomplete sequence)
\\bikappa                   <char-0x1D73F>               " 𝜿          : MATHEMATICAL BOLD ITALIC SMALL KAPPA
\\bil                       <char-0x1D48D>               " 𝒍          : MATHEMATICAL BOLD ITALIC SMALL L
\\bil<Tab>                  <char-0x1D48D>               " 𝒍          : MATHEMATICAL BOLD ITALIC SMALL L
\\bila                      \\bila                       "            : (Incomplete sequence)
\\bilambda                  <char-0x1D740>               " 𝝀          : MATHEMATICAL BOLD ITALIC SMALL LAMDA
\\bim                       <char-0x1D48E>               " 𝒎          : MATHEMATICAL BOLD ITALIC SMALL M
\\bim<Tab>                  <char-0x1D48E>               " 𝒎          : MATHEMATICAL BOLD ITALIC SMALL M
\\bimu                      <char-0x1D741>               " 𝝁          : MATHEMATICAL BOLD ITALIC SMALL MU
\\bin                       <char-0x1D48F>               " 𝒏          : MATHEMATICAL BOLD ITALIC SMALL N
\\bin<Tab>                  <char-0x1D48F>               " 𝒏          : MATHEMATICAL BOLD ITALIC SMALL N
\\bina                      \\bina                       "            : (Incomplete sequence)
\\binabla                   <char-0x1D735>               " 𝜵          : MATHEMATICAL BOLD ITALIC NABLA
\\binu                      <char-0x1D742>               " 𝝂          : MATHEMATICAL BOLD ITALIC SMALL NU
\\bio                       <char-0x1D490>               " 𝒐          : MATHEMATICAL BOLD ITALIC SMALL O
\\bio<Tab>                  <char-0x1D490>               " 𝒐          : MATHEMATICAL BOLD ITALIC SMALL O
\\biom                      \\biom                       "            : (Incomplete sequence)
\\biomega                   <char-0x1D74E>               " 𝝎          : MATHEMATICAL BOLD ITALIC SMALL OMEGA
\\biomicron                 <char-0x1D744>               " 𝝄          : MATHEMATICAL BOLD ITALIC SMALL OMICRON
\\bip                       <char-0x1D491>               " 𝒑          : MATHEMATICAL BOLD ITALIC SMALL P
\\bip<Tab>                  <char-0x1D491>               " 𝒑          : MATHEMATICAL BOLD ITALIC SMALL P
\\bipa                      \\bipa                       "            : (Incomplete sequence)
\\bipartial                 <char-0x1D74F>               " 𝝏          : MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
\\biph                      \\biph                       "            : (Incomplete sequence)
\\biphi                     <char-0x1D753>               " 𝝓          : MATHEMATICAL BOLD ITALIC PHI SYMBOL
\\bipi                      <char-0x1D745>               " 𝝅          : MATHEMATICAL BOLD ITALIC SMALL PI
\\bips                      \\bips                       "            : (Incomplete sequence)
\\bipsi                     <char-0x1D74D>               " 𝝍          : MATHEMATICAL BOLD ITALIC SMALL PSI
\\biq                       <char-0x1D492>               " 𝒒          : MATHEMATICAL BOLD ITALIC SMALL Q
\\bir                       <char-0x1D493>               " 𝒓          : MATHEMATICAL BOLD ITALIC SMALL R
\\bir<Tab>                  <char-0x1D493>               " 𝒓          : MATHEMATICAL BOLD ITALIC SMALL R
\\birh                      \\birh                       "            : (Incomplete sequence)
\\birho                     <char-0x1D746>               " 𝝆          : MATHEMATICAL BOLD ITALIC SMALL RHO
\\bis                       <char-0x1D494>               " 𝒔          : MATHEMATICAL BOLD ITALIC SMALL S
\\bis<Tab>                  <char-0x1D494>               " 𝒔          : MATHEMATICAL BOLD ITALIC SMALL S
\\bisa                      \\bisa                       "            : (Incomplete sequence)
\\bisansA                   <char-0x1D63C>               " 𝘼          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A
\\bisansA<Tab>              <char-0x1D63C>               " 𝘼          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A
\\bisansAl                  \\bisansAl                   "            : (Incomplete sequence)
\\bisansAlpha               <char-0x1D790>               " 𝞐          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA
\\bisansB                   <char-0x1D63D>               " 𝘽          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B
\\bisansB<Tab>              <char-0x1D63D>               " 𝘽          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B
\\bisansBe                  \\bisansBe                   "            : (Incomplete sequence)
\\bisansBeta                <char-0x1D791>               " 𝞑          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA
\\bisansC                   <char-0x1D63E>               " 𝘾          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C
\\bisansC<Tab>              <char-0x1D63E>               " 𝘾          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C
\\bisansCh                  \\bisansCh                   "            : (Incomplete sequence)
\\bisansChi                 <char-0x1D7A6>               " 𝞦          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI
\\bisansD                   <char-0x1D63F>               " 𝘿          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D
\\bisansD<Tab>              <char-0x1D63F>               " 𝘿          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D
\\bisansDe                  \\bisansDe                   "            : (Incomplete sequence)
\\bisansDelta               <char-0x1D793>               " 𝞓          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA
\\bisansE                   <char-0x1D640>               " 𝙀          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E
\\bisansE<Tab>              <char-0x1D640>               " 𝙀          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E
\\bisansEp                  \\bisansEp                   "            : (Incomplete sequence)
\\bisansEpsilon             <char-0x1D794>               " 𝞔          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON
\\bisansEt                  \\bisansEt                   "            : (Incomplete sequence)
\\bisansEta                 <char-0x1D796>               " 𝞖          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA
\\bisansF                   <char-0x1D641>               " 𝙁          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F
\\bisansG                   <char-0x1D642>               " 𝙂          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G
\\bisansG<Tab>              <char-0x1D642>               " 𝙂          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G
\\bisansGa                  \\bisansGa                   "            : (Incomplete sequence)
\\bisansGamma               <char-0x1D792>               " 𝞒          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA
\\bisansH                   <char-0x1D643>               " 𝙃          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H
\\bisansI                   <char-0x1D644>               " 𝙄          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I
\\bisansI<Tab>              <char-0x1D644>               " 𝙄          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I
\\bisansIo                  \\bisansIo                   "            : (Incomplete sequence)
\\bisansIota                <char-0x1D798>               " 𝞘          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA
\\bisansJ                   <char-0x1D645>               " 𝙅          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J
\\bisansK                   <char-0x1D646>               " 𝙆          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K
\\bisansK<Tab>              <char-0x1D646>               " 𝙆          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K
\\bisansKa                  \\bisansKa                   "            : (Incomplete sequence)
\\bisansKappa               <char-0x1D799>               " 𝞙          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA
\\bisansL                   <char-0x1D647>               " 𝙇          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L
\\bisansL<Tab>              <char-0x1D647>               " 𝙇          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L
\\bisansLa                  \\bisansLa                   "            : (Incomplete sequence)
\\bisansLambda              <char-0x1D79A>               " 𝞚          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA
\\bisansM                   <char-0x1D648>               " 𝙈          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M
\\bisansM<Tab>              <char-0x1D648>               " 𝙈          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M
\\bisansMu                  <char-0x1D79B>               " 𝞛          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU
\\bisansN                   <char-0x1D649>               " 𝙉          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N
\\bisansN<Tab>              <char-0x1D649>               " 𝙉          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N
\\bisansNu                  <char-0x1D79C>               " 𝞜          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU
\\bisansO                   <char-0x1D64A>               " 𝙊          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O
\\bisansO<Tab>              <char-0x1D64A>               " 𝙊          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O
\\bisansOm                  \\bisansOm                   "            : (Incomplete sequence)
\\bisansOmega               <char-0x1D7A8>               " 𝞨          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
\\bisansOmicron             <char-0x1D79E>               " 𝞞          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON
\\bisansP                   <char-0x1D64B>               " 𝙋          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P
\\bisansP<Tab>              <char-0x1D64B>               " 𝙋          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P
\\bisansPh                  \\bisansPh                   "            : (Incomplete sequence)
\\bisansPhi                 <char-0x1D7A5>               " 𝞥          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI
\\bisansPi                  <char-0x1D79F>               " 𝞟          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI
\\bisansPs                  \\bisansPs                   "            : (Incomplete sequence)
\\bisansPsi                 <char-0x1D7A7>               " 𝞧          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI
\\bisansQ                   <char-0x1D64C>               " 𝙌          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q
\\bisansR                   <char-0x1D64D>               " 𝙍          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R
\\bisansR<Tab>              <char-0x1D64D>               " 𝙍          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R
\\bisansRh                  \\bisansRh                   "            : (Incomplete sequence)
\\bisansRho                 <char-0x1D7A0>               " 𝞠          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO
\\bisansS                   <char-0x1D64E>               " 𝙎          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S
\\bisansS<Tab>              <char-0x1D64E>               " 𝙎          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S
\\bisansSi                  \\bisansSi                   "            : (Incomplete sequence)
\\bisansSigma               <char-0x1D7A2>               " 𝞢          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA
\\bisansT                   <char-0x1D64F>               " 𝙏          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T
\\bisansT<Tab>              <char-0x1D64F>               " 𝙏          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T
\\bisansTa                  \\bisansTa                   "            : (Incomplete sequence)
\\bisansTau                 <char-0x1D7A3>               " 𝞣          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU
\\bisansTh                  \\bisansTh                   "            : (Incomplete sequence)
\\bisansTheta               <char-0x1D797>               " 𝞗          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA
\\bisansU                   <char-0x1D650>               " 𝙐          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U
\\bisansU<Tab>              <char-0x1D650>               " 𝙐          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U
\\bisansUp                  \\bisansUp                   "            : (Incomplete sequence)
\\bisansUpsilon             <char-0x1D7A4>               " 𝞤          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON
\\bisansV                   <char-0x1D651>               " 𝙑          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V
\\bisansW                   <char-0x1D652>               " 𝙒          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W
\\bisansX                   <char-0x1D653>               " 𝙓          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X
\\bisansX<Tab>              <char-0x1D653>               " 𝙓          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X
\\bisansXi                  <char-0x1D79D>               " 𝞝          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI
\\bisansY                   <char-0x1D654>               " 𝙔          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y
\\bisansZ                   <char-0x1D655>               " 𝙕          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
\\bisansZ<Tab>              <char-0x1D655>               " 𝙕          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
\\bisansZe                  \\bisansZe                   "            : (Incomplete sequence)
\\bisansZeta                <char-0x1D795>               " 𝞕          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA
\\bisansa                   <char-0x1D656>               " 𝙖          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A
\\bisansa<Tab>              <char-0x1D656>               " 𝙖          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A
\\bisansal                  \\bisansal                   "            : (Incomplete sequence)
\\bisansalpha               <char-0x1D7AA>               " 𝞪          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA
\\bisansb                   <char-0x1D657>               " 𝙗          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B
\\bisansb<Tab>              <char-0x1D657>               " 𝙗          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B
\\bisansbe                  \\bisansbe                   "            : (Incomplete sequence)
\\bisansbeta                <char-0x1D7AB>               " 𝞫          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA
\\bisansc                   <char-0x1D658>               " 𝙘          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C
\\bisansc<Tab>              <char-0x1D658>               " 𝙘          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C
\\bisansch                  \\bisansch                   "            : (Incomplete sequence)
\\bisanschi                 <char-0x1D7C0>               " 𝟀          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI
\\bisansd                   <char-0x1D659>               " 𝙙          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D
\\bisansd<Tab>              <char-0x1D659>               " 𝙙          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D
\\bisansde                  \\bisansde                   "            : (Incomplete sequence)
\\bisansdelta               <char-0x1D7AD>               " 𝞭          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA
\\bisanse                   <char-0x1D65A>               " 𝙚          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E
\\bisanse<Tab>              <char-0x1D65A>               " 𝙚          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E
\\bisansep                  \\bisansep                   "            : (Incomplete sequence)
\\bisansepsilon             <char-0x1D7C4>               " 𝟄          : MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL
\\bisanset                  \\bisanset                   "            : (Incomplete sequence)
\\bisanseta                 <char-0x1D7B0>               " 𝞰          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA
\\bisansf                   <char-0x1D65B>               " 𝙛          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F
\\bisansg                   <char-0x1D65C>               " 𝙜          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G
\\bisansg<Tab>              <char-0x1D65C>               " 𝙜          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G
\\bisansga                  \\bisansga                   "            : (Incomplete sequence)
\\bisansgamma               <char-0x1D7AC>               " 𝞬          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA
\\bisansh                   <char-0x1D65D>               " 𝙝          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H
\\bisansi                   <char-0x1D65E>               " 𝙞          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I
\\bisansi<Tab>              <char-0x1D65E>               " 𝙞          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I
\\bisansio                  \\bisansio                   "            : (Incomplete sequence)
\\bisansiota                <char-0x1D7B2>               " 𝞲          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA
\\bisansj                   <char-0x1D65F>               " 𝙟          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J
\\bisansk                   <char-0x1D660>               " 𝙠          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K
\\bisansk<Tab>              <char-0x1D660>               " 𝙠          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K
\\bisanska                  \\bisanska                   "            : (Incomplete sequence)
\\bisanskappa               <char-0x1D7B3>               " 𝞳          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA
\\bisansl                   <char-0x1D661>               " 𝙡          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L
\\bisansl<Tab>              <char-0x1D661>               " 𝙡          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L
\\bisansla                  \\bisansla                   "            : (Incomplete sequence)
\\bisanslambda              <char-0x1D7B4>               " 𝞴          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA
\\bisansm                   <char-0x1D662>               " 𝙢          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M
\\bisansm<Tab>              <char-0x1D662>               " 𝙢          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M
\\bisansmu                  <char-0x1D7B5>               " 𝞵          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU
\\bisansn                   <char-0x1D663>               " 𝙣          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N
\\bisansn<Tab>              <char-0x1D663>               " 𝙣          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N
\\bisansna                  \\bisansna                   "            : (Incomplete sequence)
\\bisansnabla               <char-0x1D7A9>               " 𝞩          : MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
\\bisansnu                  <char-0x1D7B6>               " 𝞶          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU
\\bisanso                   <char-0x1D664>               " 𝙤          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O
\\bisanso<Tab>              <char-0x1D664>               " 𝙤          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O
\\bisansom                  \\bisansom                   "            : (Incomplete sequence)
\\bisansomega               <char-0x1D7C2>               " 𝟂          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
\\bisansomicron             <char-0x1D7B8>               " 𝞸          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON
\\bisansp                   <char-0x1D665>               " 𝙥          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P
\\bisansp<Tab>              <char-0x1D665>               " 𝙥          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P
\\bisanspa                  \\bisanspa                   "            : (Incomplete sequence)
\\bisanspartial             <char-0x1D7C3>               " 𝟃          : MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
\\bisansph                  \\bisansph                   "            : (Incomplete sequence)
\\bisansphi                 <char-0x1D7C7>               " 𝟇          : MATHEMATICAL SANS-SERIF BOLD ITALIC PHI SYMBOL
\\bisanspi                  <char-0x1D7B9>               " 𝞹          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI
\\bisansps                  \\bisansps                   "            : (Incomplete sequence)
\\bisanspsi                 <char-0x1D7C1>               " 𝟁          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI
\\bisansq                   <char-0x1D666>               " 𝙦          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q
\\bisansr                   <char-0x1D667>               " 𝙧          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R
\\bisansr<Tab>              <char-0x1D667>               " 𝙧          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R
\\bisansrh                  \\bisansrh                   "            : (Incomplete sequence)
\\bisansrho                 <char-0x1D7BA>               " 𝞺          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO
\\bisanss                   <char-0x1D668>               " 𝙨          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S
\\bisanss<Tab>              <char-0x1D668>               " 𝙨          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S
\\bisanssi                  \\bisanssi                   "            : (Incomplete sequence)
\\bisanssigma               <char-0x1D7BC>               " 𝞼          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA
\\bisanst                   <char-0x1D669>               " 𝙩          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T
\\bisanst<Tab>              <char-0x1D669>               " 𝙩          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T
\\bisansta                  \\bisansta                   "            : (Incomplete sequence)
\\bisanstau                 <char-0x1D7BD>               " 𝞽          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU
\\bisansth                  \\bisansth                   "            : (Incomplete sequence)
\\bisanstheta               <char-0x1D7B1>               " 𝞱          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA
\\bisansu                   <char-0x1D66A>               " 𝙪          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U
\\bisansu<Tab>              <char-0x1D66A>               " 𝙪          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U
\\bisansup                  \\bisansup                   "            : (Incomplete sequence)
\\bisansupsilon             <char-0x1D7BE>               " 𝞾          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON
\\bisansv                   <char-0x1D66B>               " 𝙫          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V
\\bisansv<Tab>              <char-0x1D66B>               " 𝙫          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V
\\bisansva                  \\bisansva                   "            : (Incomplete sequence)
\\bisansvarTheta            <char-0x1D7A1>               " 𝞡          : MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL
\\bisansvarepsilon          <char-0x1D7AE>               " 𝞮          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON
\\bisansvarkappa            <char-0x1D7C6>               " 𝟆          : MATHEMATICAL SANS-SERIF BOLD ITALIC KAPPA SYMBOL
\\bisansvarphi              <char-0x1D7BF>               " 𝞿          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI
\\bisansvarpi               <char-0x1D7C9>               " 𝟉          : MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
\\bisansvarrho              <char-0x1D7C8>               " 𝟈          : MATHEMATICAL SANS-SERIF BOLD ITALIC RHO SYMBOL
\\bisansvarsigma            <char-0x1D7BB>               " 𝞻          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA
\\bisansvartheta            <char-0x1D7C5>               " 𝟅          : MATHEMATICAL SANS-SERIF BOLD ITALIC THETA SYMBOL
\\bisansw                   <char-0x1D66C>               " 𝙬          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W
\\bisansx                   <char-0x1D66D>               " 𝙭          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X
\\bisansx<Tab>              <char-0x1D66D>               " 𝙭          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X
\\bisansxi                  <char-0x1D7B7>               " 𝞷          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI
\\bisansy                   <char-0x1D66E>               " 𝙮          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y
\\bisansz                   <char-0x1D66F>               " 𝙯          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
\\bisansz<Tab>              <char-0x1D66F>               " 𝙯          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
\\bisansze                  \\bisansze                   "            : (Incomplete sequence)
\\bisanszeta                <char-0x1D7AF>               " 𝞯          : MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA
\\bisi                      \\bisi                       "            : (Incomplete sequence)
\\bisigma                   <char-0x1D748>               " 𝝈          : MATHEMATICAL BOLD ITALIC SMALL SIGMA
\\bit                       <char-0x1D495>               " 𝒕          : MATHEMATICAL BOLD ITALIC SMALL T
\\bit<Tab>                  <char-0x1D495>               " 𝒕          : MATHEMATICAL BOLD ITALIC SMALL T
\\bita                      \\bita                       "            : (Incomplete sequence)
\\bitau                     <char-0x1D749>               " 𝝉          : MATHEMATICAL BOLD ITALIC SMALL TAU
\\bith                      \\bith                       "            : (Incomplete sequence)
\\bitheta                   <char-0x1D73D>               " 𝜽          : MATHEMATICAL BOLD ITALIC SMALL THETA
\\biu                       <char-0x1D496>               " 𝒖          : MATHEMATICAL BOLD ITALIC SMALL U
\\biu<Tab>                  <char-0x1D496>               " 𝒖          : MATHEMATICAL BOLD ITALIC SMALL U
\\biup                      \\biup                       "            : (Incomplete sequence)
\\biupsilon                 <char-0x1D74A>               " 𝝊          : MATHEMATICAL BOLD ITALIC SMALL UPSILON
\\biv                       <char-0x1D497>               " 𝒗          : MATHEMATICAL BOLD ITALIC SMALL V
\\biv<Tab>                  <char-0x1D497>               " 𝒗          : MATHEMATICAL BOLD ITALIC SMALL V
\\biva                      \\biva                       "            : (Incomplete sequence)
\\bivarTheta                <char-0x1D72D>               " 𝜭          : MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL
\\bivarepsilon              <char-0x1D73A>               " 𝜺          : MATHEMATICAL BOLD ITALIC SMALL EPSILON
\\bivarkappa                <char-0x1D752>               " 𝝒          : MATHEMATICAL BOLD ITALIC KAPPA SYMBOL
\\bivarphi                  <char-0x1D74B>               " 𝝋          : MATHEMATICAL BOLD ITALIC SMALL PHI
\\bivarpi                   <char-0x1D755>               " 𝝕          : MATHEMATICAL BOLD ITALIC PI SYMBOL
\\bivarrho                  <char-0x1D754>               " 𝝔          : MATHEMATICAL BOLD ITALIC RHO SYMBOL
\\bivarsigma                <char-0x1D747>               " 𝝇          : MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA
\\bivartheta                <char-0x1D751>               " 𝝑          : MATHEMATICAL BOLD ITALIC THETA SYMBOL
\\biw                       <char-0x1D498>               " 𝒘          : MATHEMATICAL BOLD ITALIC SMALL W
\\bix                       <char-0x1D499>               " 𝒙          : MATHEMATICAL BOLD ITALIC SMALL X
\\bix<Tab>                  <char-0x1D499>               " 𝒙          : MATHEMATICAL BOLD ITALIC SMALL X
\\bixi                      <char-0x1D743>               " 𝝃          : MATHEMATICAL BOLD ITALIC SMALL XI
\\biy                       <char-0x1D49A>               " 𝒚          : MATHEMATICAL BOLD ITALIC SMALL Y
\\biz                       <char-0x1D49B>               " 𝒛          : MATHEMATICAL BOLD ITALIC SMALL Z
\\biz<Tab>                  <char-0x1D49B>               " 𝒛          : MATHEMATICAL BOLD ITALIC SMALL Z
\\bize                      \\bize                       "            : (Incomplete sequence)
\\bizeta                    <char-0x1D73B>               " 𝜻          : MATHEMATICAL BOLD ITALIC SMALL ZETA
\\bkarow                    <char-0x0290D>               " ⤍          : RIGHTWARDS DOUBLE DASH ARROW
\\blackcircledrightdot      <char-0x02688>               " ⚈          : BLACK CIRCLE WITH WHITE DOT RIGHT
\\blackcircledtwodots       <char-0x02689>               " ⚉          : BLACK CIRCLE WITH TWO WHITE DOTS
\\blackcircleulquadwhite    <char-0x025D5>               " ◕          : CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK
\\blackinwhitediamond       <char-0x025C8>               " ◈          : WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
\\blackinwhitesquare        <char-0x025A3>               " ▣          : WHITE SQUARE CONTAINING BLACK SMALL SQUARE
\\blacklefthalfcircle       <char-0x025D6>               " ◖          : LEFT HALF BLACK CIRCLE
\\blacklozenge              <char-0x029EB>               " ⧫          : BLACK LOZENGE
\\blackpointerleft          <char-0x025C4>               " ◄          : BLACK LEFT-POINTING POINTER / BLACK LEFT POINTING POINTER
\\blackpointerright         <char-0x025BA>               " ►          : BLACK RIGHT-POINTING POINTER / BLACK RIGHT POINTING POINTER
\\blackrighthalfcircle      <char-0x025D7>               " ◗          : RIGHT HALF BLACK CIRCLE
\\blacksmiley               <char-0x0263B>               " ☻          : BLACK SMILING FACE
\\blacksquare               <char-0x025A0>               " ■          : BLACK SQUARE
\\blacktriangle             <char-0x025B4>               " ▴          : BLACK UP-POINTING SMALL TRIANGLE / BLACK UP POINTING SMALL TRIANGLE
\\blacktriangle<Tab>        <char-0x025B4>               " ▴          : BLACK UP-POINTING SMALL TRIANGLE / BLACK UP POINTING SMALL TRIANGLE
\\blacktriangled            \\blacktriangled             "            : (Incomplete sequence)
\\blacktriangledown         <char-0x025BE>               " ▾          : BLACK DOWN-POINTING SMALL TRIANGLE / BLACK DOWN POINTING SMALL TRIANGLE
\\blacktrianglel            \\blacktrianglel             "            : (Incomplete sequence)
\\blacktriangleleft         <char-0x025C0>               " ◀          : BLACK LEFT-POINTING TRIANGLE / BLACK LEFT POINTING TRIANGLE
\\blacktriangler            \\blacktriangler             "            : (Incomplete sequence)
\\blacktriangleright        <char-0x025B6>               " ▶          : BLACK RIGHT-POINTING TRIANGLE / BLACK RIGHT POINTING TRIANGLE
\\blanksymbol               <char-0x02422>               " ␢          : BLANK SYMBOL / BLANK
\\blkhorzoval               <char-0x02B2C>               " ⬬          : BLACK HORIZONTAL ELLIPSE
\\blkvertoval               <char-0x02B2E>               " ⬮          : BLACK VERTICAL ELLIPSE
\\blockfull                 <char-0x02588>               " █          : FULL BLOCK
\\blockhalfshaded           <char-0x02592>               " ▒          : MEDIUM SHADE
\\blocklefthalf             <char-0x0258C>               " ▌          : LEFT HALF BLOCK
\\blocklowhalf              <char-0x02584>               " ▄          : LOWER HALF BLOCK
\\blockqtrshaded            <char-0x02591>               " ░          : LIGHT SHADE
\\blockrighthalf            <char-0x02590>               " ▐          : RIGHT HALF BLOCK
\\blockthreeqtrshaded       <char-0x02593>               " ▓          : DARK SHADE
\\blockuphalf               <char-0x02580>               " ▀          : UPPER HALF BLOCK
\\bot                       <char-0x022A5>               " ⊥          : UP TACK
\\bot<Tab>                  <char-0x022A5>               " ⊥          : UP TACK
\\bots                      \\bots                       "            : (Incomplete sequence)
\\botsemicircle             <char-0x025E1>               " ◡          : LOWER HALF CIRCLE
\\bowtie                    <char-0x022C8>               " ⋈          : BOWTIE
\\boxast                    <char-0x029C6>               " ⧆          : SQUARED ASTERISK
\\boxbar                    <char-0x025EB>               " ◫          : WHITE SQUARE WITH VERTICAL BISECTING LINE
\\boxbslash                 <char-0x029C5>               " ⧅          : SQUARED FALLING DIAGONAL SLASH
\\boxcircle                 <char-0x029C7>               " ⧇          : SQUARED SMALL CIRCLE
\\boxdiag                   <char-0x029C4>               " ⧄          : SQUARED RISING DIAGONAL SLASH
\\boxdot                    <char-0x022A1>               " ⊡          : SQUARED DOT OPERATOR
\\boxminus                  <char-0x0229F>               " ⊟          : SQUARED MINUS
\\boxplus                   <char-0x0229E>               " ⊞          : SQUARED PLUS
\\boxquestion               <char-0x02370>               " ⍰          : APL FUNCTIONAL SYMBOL QUAD QUESTION
\\boxtimes                  <char-0x022A0>               " ⊠          : SQUARED TIMES
\\boxupcaret                <char-0x02353>               " ⍓          : APL FUNCTIONAL SYMBOL QUAD UP CARET
\\breve                     <char-0x00306>               " ◌̆          : COMBINING BREVE / NON-SPACING BREVE
\\brokenbar                 <char-0x000A6>               " ¦          : BROKEN BAR / BROKEN VERTICAL BAR
\\bsansA                    <char-0x1D5D4>               " 𝗔          : MATHEMATICAL SANS-SERIF BOLD CAPITAL A
\\bsansA<Tab>               <char-0x1D5D4>               " 𝗔          : MATHEMATICAL SANS-SERIF BOLD CAPITAL A
\\bsansAl                   \\bsansAl                    "            : (Incomplete sequence)
\\bsansAlpha                <char-0x1D756>               " 𝝖          : MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA
\\bsansB                    <char-0x1D5D5>               " 𝗕          : MATHEMATICAL SANS-SERIF BOLD CAPITAL B
\\bsansB<Tab>               <char-0x1D5D5>               " 𝗕          : MATHEMATICAL SANS-SERIF BOLD CAPITAL B
\\bsansBe                   \\bsansBe                    "            : (Incomplete sequence)
\\bsansBeta                 <char-0x1D757>               " 𝝗          : MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA
\\bsansC                    <char-0x1D5D6>               " 𝗖          : MATHEMATICAL SANS-SERIF BOLD CAPITAL C
\\bsansC<Tab>               <char-0x1D5D6>               " 𝗖          : MATHEMATICAL SANS-SERIF BOLD CAPITAL C
\\bsansCh                   \\bsansCh                    "            : (Incomplete sequence)
\\bsansChi                  <char-0x1D76C>               " 𝝬          : MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI
\\bsansD                    <char-0x1D5D7>               " 𝗗          : MATHEMATICAL SANS-SERIF BOLD CAPITAL D
\\bsansD<Tab>               <char-0x1D5D7>               " 𝗗          : MATHEMATICAL SANS-SERIF BOLD CAPITAL D
\\bsansDe                   \\bsansDe                    "            : (Incomplete sequence)
\\bsansDelta                <char-0x1D759>               " 𝝙          : MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA
\\bsansE                    <char-0x1D5D8>               " 𝗘          : MATHEMATICAL SANS-SERIF BOLD CAPITAL E
\\bsansE<Tab>               <char-0x1D5D8>               " 𝗘          : MATHEMATICAL SANS-SERIF BOLD CAPITAL E
\\bsansEp                   \\bsansEp                    "            : (Incomplete sequence)
\\bsansEpsilon              <char-0x1D75A>               " 𝝚          : MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON
\\bsansEt                   \\bsansEt                    "            : (Incomplete sequence)
\\bsansEta                  <char-0x1D75C>               " 𝝜          : MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA
\\bsansF                    <char-0x1D5D9>               " 𝗙          : MATHEMATICAL SANS-SERIF BOLD CAPITAL F
\\bsansG                    <char-0x1D5DA>               " 𝗚          : MATHEMATICAL SANS-SERIF BOLD CAPITAL G
\\bsansG<Tab>               <char-0x1D5DA>               " 𝗚          : MATHEMATICAL SANS-SERIF BOLD CAPITAL G
\\bsansGa                   \\bsansGa                    "            : (Incomplete sequence)
\\bsansGamma                <char-0x1D758>               " 𝝘          : MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA
\\bsansH                    <char-0x1D5DB>               " 𝗛          : MATHEMATICAL SANS-SERIF BOLD CAPITAL H
\\bsansI                    <char-0x1D5DC>               " 𝗜          : MATHEMATICAL SANS-SERIF BOLD CAPITAL I
\\bsansI<Tab>               <char-0x1D5DC>               " 𝗜          : MATHEMATICAL SANS-SERIF BOLD CAPITAL I
\\bsansIo                   \\bsansIo                    "            : (Incomplete sequence)
\\bsansIota                 <char-0x1D75E>               " 𝝞          : MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA
\\bsansJ                    <char-0x1D5DD>               " 𝗝          : MATHEMATICAL SANS-SERIF BOLD CAPITAL J
\\bsansK                    <char-0x1D5DE>               " 𝗞          : MATHEMATICAL SANS-SERIF BOLD CAPITAL K
\\bsansK<Tab>               <char-0x1D5DE>               " 𝗞          : MATHEMATICAL SANS-SERIF BOLD CAPITAL K
\\bsansKa                   \\bsansKa                    "            : (Incomplete sequence)
\\bsansKappa                <char-0x1D75F>               " 𝝟          : MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA
\\bsansL                    <char-0x1D5DF>               " 𝗟          : MATHEMATICAL SANS-SERIF BOLD CAPITAL L
\\bsansL<Tab>               <char-0x1D5DF>               " 𝗟          : MATHEMATICAL SANS-SERIF BOLD CAPITAL L
\\bsansLa                   \\bsansLa                    "            : (Incomplete sequence)
\\bsansLambda               <char-0x1D760>               " 𝝠          : MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA
\\bsansM                    <char-0x1D5E0>               " 𝗠          : MATHEMATICAL SANS-SERIF BOLD CAPITAL M
\\bsansM<Tab>               <char-0x1D5E0>               " 𝗠          : MATHEMATICAL SANS-SERIF BOLD CAPITAL M
\\bsansMu                   <char-0x1D761>               " 𝝡          : MATHEMATICAL SANS-SERIF BOLD CAPITAL MU
\\bsansN                    <char-0x1D5E1>               " 𝗡          : MATHEMATICAL SANS-SERIF BOLD CAPITAL N
\\bsansN<Tab>               <char-0x1D5E1>               " 𝗡          : MATHEMATICAL SANS-SERIF BOLD CAPITAL N
\\bsansNu                   <char-0x1D762>               " 𝝢          : MATHEMATICAL SANS-SERIF BOLD CAPITAL NU
\\bsansO                    <char-0x1D5E2>               " 𝗢          : MATHEMATICAL SANS-SERIF BOLD CAPITAL O
\\bsansO<Tab>               <char-0x1D5E2>               " 𝗢          : MATHEMATICAL SANS-SERIF BOLD CAPITAL O
\\bsansOm                   \\bsansOm                    "            : (Incomplete sequence)
\\bsansOmega                <char-0x1D76E>               " 𝝮          : MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
\\bsansOmicron              <char-0x1D764>               " 𝝤          : MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON
\\bsansP                    <char-0x1D5E3>               " 𝗣          : MATHEMATICAL SANS-SERIF BOLD CAPITAL P
\\bsansP<Tab>               <char-0x1D5E3>               " 𝗣          : MATHEMATICAL SANS-SERIF BOLD CAPITAL P
\\bsansPh                   \\bsansPh                    "            : (Incomplete sequence)
\\bsansPhi                  <char-0x1D76B>               " 𝝫          : MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI
\\bsansPi                   <char-0x1D765>               " 𝝥          : MATHEMATICAL SANS-SERIF BOLD CAPITAL PI
\\bsansPs                   \\bsansPs                    "            : (Incomplete sequence)
\\bsansPsi                  <char-0x1D76D>               " 𝝭          : MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI
\\bsansQ                    <char-0x1D5E4>               " 𝗤          : MATHEMATICAL SANS-SERIF BOLD CAPITAL Q
\\bsansR                    <char-0x1D5E5>               " 𝗥          : MATHEMATICAL SANS-SERIF BOLD CAPITAL R
\\bsansR<Tab>               <char-0x1D5E5>               " 𝗥          : MATHEMATICAL SANS-SERIF BOLD CAPITAL R
\\bsansRh                   \\bsansRh                    "            : (Incomplete sequence)
\\bsansRho                  <char-0x1D766>               " 𝝦          : MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO
\\bsansS                    <char-0x1D5E6>               " 𝗦          : MATHEMATICAL SANS-SERIF BOLD CAPITAL S
\\bsansS<Tab>               <char-0x1D5E6>               " 𝗦          : MATHEMATICAL SANS-SERIF BOLD CAPITAL S
\\bsansSi                   \\bsansSi                    "            : (Incomplete sequence)
\\bsansSigma                <char-0x1D768>               " 𝝨          : MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA
\\bsansT                    <char-0x1D5E7>               " 𝗧          : MATHEMATICAL SANS-SERIF BOLD CAPITAL T
\\bsansT<Tab>               <char-0x1D5E7>               " 𝗧          : MATHEMATICAL SANS-SERIF BOLD CAPITAL T
\\bsansTa                   \\bsansTa                    "            : (Incomplete sequence)
\\bsansTau                  <char-0x1D769>               " 𝝩          : MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU
\\bsansTh                   \\bsansTh                    "            : (Incomplete sequence)
\\bsansTheta                <char-0x1D75D>               " 𝝝          : MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA
\\bsansU                    <char-0x1D5E8>               " 𝗨          : MATHEMATICAL SANS-SERIF BOLD CAPITAL U
\\bsansU<Tab>               <char-0x1D5E8>               " 𝗨          : MATHEMATICAL SANS-SERIF BOLD CAPITAL U
\\bsansUp                   \\bsansUp                    "            : (Incomplete sequence)
\\bsansUpsilon              <char-0x1D76A>               " 𝝪          : MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON
\\bsansV                    <char-0x1D5E9>               " 𝗩          : MATHEMATICAL SANS-SERIF BOLD CAPITAL V
\\bsansW                    <char-0x1D5EA>               " 𝗪          : MATHEMATICAL SANS-SERIF BOLD CAPITAL W
\\bsansX                    <char-0x1D5EB>               " 𝗫          : MATHEMATICAL SANS-SERIF BOLD CAPITAL X
\\bsansX<Tab>               <char-0x1D5EB>               " 𝗫          : MATHEMATICAL SANS-SERIF BOLD CAPITAL X
\\bsansXi                   <char-0x1D763>               " 𝝣          : MATHEMATICAL SANS-SERIF BOLD CAPITAL XI
\\bsansY                    <char-0x1D5EC>               " 𝗬          : MATHEMATICAL SANS-SERIF BOLD CAPITAL Y
\\bsansZ                    <char-0x1D5ED>               " 𝗭          : MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
\\bsansZ<Tab>               <char-0x1D5ED>               " 𝗭          : MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
\\bsansZe                   \\bsansZe                    "            : (Incomplete sequence)
\\bsansZeta                 <char-0x1D75B>               " 𝝛          : MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA
\\bsansa                    <char-0x1D5EE>               " 𝗮          : MATHEMATICAL SANS-SERIF BOLD SMALL A
\\bsansa<Tab>               <char-0x1D5EE>               " 𝗮          : MATHEMATICAL SANS-SERIF BOLD SMALL A
\\bsansal                   \\bsansal                    "            : (Incomplete sequence)
\\bsansalpha                <char-0x1D770>               " 𝝰          : MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA
\\bsansb                    <char-0x1D5EF>               " 𝗯          : MATHEMATICAL SANS-SERIF BOLD SMALL B
\\bsansb<Tab>               <char-0x1D5EF>               " 𝗯          : MATHEMATICAL SANS-SERIF BOLD SMALL B
\\bsansbe                   \\bsansbe                    "            : (Incomplete sequence)
\\bsansbeta                 <char-0x1D771>               " 𝝱          : MATHEMATICAL SANS-SERIF BOLD SMALL BETA
\\bsansc                    <char-0x1D5F0>               " 𝗰          : MATHEMATICAL SANS-SERIF BOLD SMALL C
\\bsansc<Tab>               <char-0x1D5F0>               " 𝗰          : MATHEMATICAL SANS-SERIF BOLD SMALL C
\\bsansch                   \\bsansch                    "            : (Incomplete sequence)
\\bsanschi                  <char-0x1D786>               " 𝞆          : MATHEMATICAL SANS-SERIF BOLD SMALL CHI
\\bsansd                    <char-0x1D5F1>               " 𝗱          : MATHEMATICAL SANS-SERIF BOLD SMALL D
\\bsansd<Tab>               <char-0x1D5F1>               " 𝗱          : MATHEMATICAL SANS-SERIF BOLD SMALL D
\\bsansde                   \\bsansde                    "            : (Incomplete sequence)
\\bsansdelta                <char-0x1D773>               " 𝝳          : MATHEMATICAL SANS-SERIF BOLD SMALL DELTA
\\bsanse                    <char-0x1D5F2>               " 𝗲          : MATHEMATICAL SANS-SERIF BOLD SMALL E
\\bsanse<Tab>               <char-0x1D5F2>               " 𝗲          : MATHEMATICAL SANS-SERIF BOLD SMALL E
\\bsansei                   \\bsansei                    "            : (Incomplete sequence)
\\bsanseight                <char-0x1D7F4>               " 𝟴          : MATHEMATICAL SANS-SERIF BOLD DIGIT EIGHT
\\bsansep                   \\bsansep                    "            : (Incomplete sequence)
\\bsansepsilon              <char-0x1D78A>               " 𝞊          : MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL
\\bsanset                   \\bsanset                    "            : (Incomplete sequence)
\\bsanseta                  <char-0x1D776>               " 𝝶          : MATHEMATICAL SANS-SERIF BOLD SMALL ETA
\\bsansf                    <char-0x1D5F3>               " 𝗳          : MATHEMATICAL SANS-SERIF BOLD SMALL F
\\bsansf<Tab>               <char-0x1D5F3>               " 𝗳          : MATHEMATICAL SANS-SERIF BOLD SMALL F
\\bsansfi                   \\bsansfi                    "            : (Incomplete sequence)
\\bsansfive                 <char-0x1D7F1>               " 𝟱          : MATHEMATICAL SANS-SERIF BOLD DIGIT FIVE
\\bsansfo                   \\bsansfo                    "            : (Incomplete sequence)
\\bsansfour                 <char-0x1D7F0>               " 𝟰          : MATHEMATICAL SANS-SERIF BOLD DIGIT FOUR
\\bsansg                    <char-0x1D5F4>               " 𝗴          : MATHEMATICAL SANS-SERIF BOLD SMALL G
\\bsansg<Tab>               <char-0x1D5F4>               " 𝗴          : MATHEMATICAL SANS-SERIF BOLD SMALL G
\\bsansga                   \\bsansga                    "            : (Incomplete sequence)
\\bsansgamma                <char-0x1D772>               " 𝝲          : MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA
\\bsansh                    <char-0x1D5F5>               " 𝗵          : MATHEMATICAL SANS-SERIF BOLD SMALL H
\\bsansi                    <char-0x1D5F6>               " 𝗶          : MATHEMATICAL SANS-SERIF BOLD SMALL I
\\bsansi<Tab>               <char-0x1D5F6>               " 𝗶          : MATHEMATICAL SANS-SERIF BOLD SMALL I
\\bsansio                   \\bsansio                    "            : (Incomplete sequence)
\\bsansiota                 <char-0x1D778>               " 𝝸          : MATHEMATICAL SANS-SERIF BOLD SMALL IOTA
\\bsansj                    <char-0x1D5F7>               " 𝗷          : MATHEMATICAL SANS-SERIF BOLD SMALL J
\\bsansk                    <char-0x1D5F8>               " 𝗸          : MATHEMATICAL SANS-SERIF BOLD SMALL K
\\bsansk<Tab>               <char-0x1D5F8>               " 𝗸          : MATHEMATICAL SANS-SERIF BOLD SMALL K
\\bsanska                   \\bsanska                    "            : (Incomplete sequence)
\\bsanskappa                <char-0x1D779>               " 𝝹          : MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA
\\bsansl                    <char-0x1D5F9>               " 𝗹          : MATHEMATICAL SANS-SERIF BOLD SMALL L
\\bsansl<Tab>               <char-0x1D5F9>               " 𝗹          : MATHEMATICAL SANS-SERIF BOLD SMALL L
\\bsansla                   \\bsansla                    "            : (Incomplete sequence)
\\bsanslambda               <char-0x1D77A>               " 𝝺          : MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA
\\bsansm                    <char-0x1D5FA>               " 𝗺          : MATHEMATICAL SANS-SERIF BOLD SMALL M
\\bsansm<Tab>               <char-0x1D5FA>               " 𝗺          : MATHEMATICAL SANS-SERIF BOLD SMALL M
\\bsansmu                   <char-0x1D77B>               " 𝝻          : MATHEMATICAL SANS-SERIF BOLD SMALL MU
\\bsansn                    <char-0x1D5FB>               " 𝗻          : MATHEMATICAL SANS-SERIF BOLD SMALL N
\\bsansn<Tab>               <char-0x1D5FB>               " 𝗻          : MATHEMATICAL SANS-SERIF BOLD SMALL N
\\bsansna                   \\bsansna                    "            : (Incomplete sequence)
\\bsansnabla                <char-0x1D76F>               " 𝝯          : MATHEMATICAL SANS-SERIF BOLD NABLA
\\bsansni                   \\bsansni                    "            : (Incomplete sequence)
\\bsansnine                 <char-0x1D7F5>               " 𝟵          : MATHEMATICAL SANS-SERIF BOLD DIGIT NINE
\\bsansnu                   <char-0x1D77C>               " 𝝼          : MATHEMATICAL SANS-SERIF BOLD SMALL NU
\\bsanso                    <char-0x1D5FC>               " 𝗼          : MATHEMATICAL SANS-SERIF BOLD SMALL O
\\bsanso<Tab>               <char-0x1D5FC>               " 𝗼          : MATHEMATICAL SANS-SERIF BOLD SMALL O
\\bsansom                   \\bsansom                    "            : (Incomplete sequence)
\\bsansomega                <char-0x1D788>               " 𝞈          : MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
\\bsansomicron              <char-0x1D77E>               " 𝝾          : MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON
\\bsanson                   \\bsanson                    "            : (Incomplete sequence)
\\bsansone                  <char-0x1D7ED>               " 𝟭          : MATHEMATICAL SANS-SERIF BOLD DIGIT ONE
\\bsansp                    <char-0x1D5FD>               " 𝗽          : MATHEMATICAL SANS-SERIF BOLD SMALL P
\\bsansp<Tab>               <char-0x1D5FD>               " 𝗽          : MATHEMATICAL SANS-SERIF BOLD SMALL P
\\bsanspa                   \\bsanspa                    "            : (Incomplete sequence)
\\bsanspartial              <char-0x1D789>               " 𝞉          : MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
\\bsansph                   \\bsansph                    "            : (Incomplete sequence)
\\bsansphi                  <char-0x1D78D>               " 𝞍          : MATHEMATICAL SANS-SERIF BOLD PHI SYMBOL
\\bsanspi                   <char-0x1D77F>               " 𝝿          : MATHEMATICAL SANS-SERIF BOLD SMALL PI
\\bsansps                   \\bsansps                    "            : (Incomplete sequence)
\\bsanspsi                  <char-0x1D787>               " 𝞇          : MATHEMATICAL SANS-SERIF BOLD SMALL PSI
\\bsansq                    <char-0x1D5FE>               " 𝗾          : MATHEMATICAL SANS-SERIF BOLD SMALL Q
\\bsansr                    <char-0x1D5FF>               " 𝗿          : MATHEMATICAL SANS-SERIF BOLD SMALL R
\\bsansr<Tab>               <char-0x1D5FF>               " 𝗿          : MATHEMATICAL SANS-SERIF BOLD SMALL R
\\bsansrh                   \\bsansrh                    "            : (Incomplete sequence)
\\bsansrho                  <char-0x1D780>               " 𝞀          : MATHEMATICAL SANS-SERIF BOLD SMALL RHO
\\bsanss                    <char-0x1D600>               " 𝘀          : MATHEMATICAL SANS-SERIF BOLD SMALL S
\\bsanss<Tab>               <char-0x1D600>               " 𝘀          : MATHEMATICAL SANS-SERIF BOLD SMALL S
\\bsansse                   \\bsansse                    "            : (Incomplete sequence)
\\bsansseven                <char-0x1D7F3>               " 𝟳          : MATHEMATICAL SANS-SERIF BOLD DIGIT SEVEN
\\bsanssi                   \\bsanssi                    "            : (Incomplete sequence)
\\bsanssigma                <char-0x1D782>               " 𝞂          : MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA
\\bsanssix                  <char-0x1D7F2>               " 𝟲          : MATHEMATICAL SANS-SERIF BOLD DIGIT SIX
\\bsanst                    <char-0x1D601>               " 𝘁          : MATHEMATICAL SANS-SERIF BOLD SMALL T
\\bsanst<Tab>               <char-0x1D601>               " 𝘁          : MATHEMATICAL SANS-SERIF BOLD SMALL T
\\bsansta                   \\bsansta                    "            : (Incomplete sequence)
\\bsanstau                  <char-0x1D783>               " 𝞃          : MATHEMATICAL SANS-SERIF BOLD SMALL TAU
\\bsansth                   \\bsansth                    "            : (Incomplete sequence)
\\bsanstheta                <char-0x1D777>               " 𝝷          : MATHEMATICAL SANS-SERIF BOLD SMALL THETA
\\bsansthree                <char-0x1D7EF>               " 𝟯          : MATHEMATICAL SANS-SERIF BOLD DIGIT THREE
\\bsanstw                   \\bsanstw                    "            : (Incomplete sequence)
\\bsanstwo                  <char-0x1D7EE>               " 𝟮          : MATHEMATICAL SANS-SERIF BOLD DIGIT TWO
\\bsansu                    <char-0x1D602>               " 𝘂          : MATHEMATICAL SANS-SERIF BOLD SMALL U
\\bsansu<Tab>               <char-0x1D602>               " 𝘂          : MATHEMATICAL SANS-SERIF BOLD SMALL U
\\bsansup                   \\bsansup                    "            : (Incomplete sequence)
\\bsansupsilon              <char-0x1D784>               " 𝞄          : MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON
\\bsansv                    <char-0x1D603>               " 𝘃          : MATHEMATICAL SANS-SERIF BOLD SMALL V
\\bsansv<Tab>               <char-0x1D603>               " 𝘃          : MATHEMATICAL SANS-SERIF BOLD SMALL V
\\bsansva                   \\bsansva                    "            : (Incomplete sequence)
\\bsansvarTheta             <char-0x1D767>               " 𝝧          : MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL
\\bsansvarepsilon           <char-0x1D774>               " 𝝴          : MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON
\\bsansvarkappa             <char-0x1D78C>               " 𝞌          : MATHEMATICAL SANS-SERIF BOLD KAPPA SYMBOL
\\bsansvarphi               <char-0x1D785>               " 𝞅          : MATHEMATICAL SANS-SERIF BOLD SMALL PHI
\\bsansvarpi                <char-0x1D78F>               " 𝞏          : MATHEMATICAL SANS-SERIF BOLD PI SYMBOL
\\bsansvarrho               <char-0x1D78E>               " 𝞎          : MATHEMATICAL SANS-SERIF BOLD RHO SYMBOL
\\bsansvarsigma             <char-0x1D781>               " 𝞁          : MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA
\\bsansvartheta             <char-0x1D78B>               " 𝞋          : MATHEMATICAL SANS-SERIF BOLD THETA SYMBOL
\\bsansw                    <char-0x1D604>               " 𝘄          : MATHEMATICAL SANS-SERIF BOLD SMALL W
\\bsansx                    <char-0x1D605>               " 𝘅          : MATHEMATICAL SANS-SERIF BOLD SMALL X
\\bsansx<Tab>               <char-0x1D605>               " 𝘅          : MATHEMATICAL SANS-SERIF BOLD SMALL X
\\bsansxi                   <char-0x1D77D>               " 𝝽          : MATHEMATICAL SANS-SERIF BOLD SMALL XI
\\bsansy                    <char-0x1D606>               " 𝘆          : MATHEMATICAL SANS-SERIF BOLD SMALL Y
\\bsansz                    <char-0x1D607>               " 𝘇          : MATHEMATICAL SANS-SERIF BOLD SMALL Z
\\bsansz<Tab>               <char-0x1D607>               " 𝘇          : MATHEMATICAL SANS-SERIF BOLD SMALL Z
\\bsansze                   \\bsansze                    "            : (Incomplete sequence)
\\bsanszero                 <char-0x1D7EC>               " 𝟬          : MATHEMATICAL SANS-SERIF BOLD DIGIT ZERO
\\bsanszeta                 <char-0x1D775>               " 𝝵          : MATHEMATICAL SANS-SERIF BOLD SMALL ZETA
\\bscrA                     <char-0x1D4D0>               " 𝓐          : MATHEMATICAL BOLD SCRIPT CAPITAL A
\\bscrB                     <char-0x1D4D1>               " 𝓑          : MATHEMATICAL BOLD SCRIPT CAPITAL B
\\bscrC                     <char-0x1D4D2>               " 𝓒          : MATHEMATICAL BOLD SCRIPT CAPITAL C
\\bscrD                     <char-0x1D4D3>               " 𝓓          : MATHEMATICAL BOLD SCRIPT CAPITAL D
\\bscrE                     <char-0x1D4D4>               " 𝓔          : MATHEMATICAL BOLD SCRIPT CAPITAL E
\\bscrF                     <char-0x1D4D5>               " 𝓕          : MATHEMATICAL BOLD SCRIPT CAPITAL F
\\bscrG                     <char-0x1D4D6>               " 𝓖          : MATHEMATICAL BOLD SCRIPT CAPITAL G
\\bscrH                     <char-0x1D4D7>               " 𝓗          : MATHEMATICAL BOLD SCRIPT CAPITAL H
\\bscrI                     <char-0x1D4D8>               " 𝓘          : MATHEMATICAL BOLD SCRIPT CAPITAL I
\\bscrJ                     <char-0x1D4D9>               " 𝓙          : MATHEMATICAL BOLD SCRIPT CAPITAL J
\\bscrK                     <char-0x1D4DA>               " 𝓚          : MATHEMATICAL BOLD SCRIPT CAPITAL K
\\bscrL                     <char-0x1D4DB>               " 𝓛          : MATHEMATICAL BOLD SCRIPT CAPITAL L
\\bscrM                     <char-0x1D4DC>               " 𝓜          : MATHEMATICAL BOLD SCRIPT CAPITAL M
\\bscrN                     <char-0x1D4DD>               " 𝓝          : MATHEMATICAL BOLD SCRIPT CAPITAL N
\\bscrO                     <char-0x1D4DE>               " 𝓞          : MATHEMATICAL BOLD SCRIPT CAPITAL O
\\bscrP                     <char-0x1D4DF>               " 𝓟          : MATHEMATICAL BOLD SCRIPT CAPITAL P
\\bscrQ                     <char-0x1D4E0>               " 𝓠          : MATHEMATICAL BOLD SCRIPT CAPITAL Q
\\bscrR                     <char-0x1D4E1>               " 𝓡          : MATHEMATICAL BOLD SCRIPT CAPITAL R
\\bscrS                     <char-0x1D4E2>               " 𝓢          : MATHEMATICAL BOLD SCRIPT CAPITAL S
\\bscrT                     <char-0x1D4E3>               " 𝓣          : MATHEMATICAL BOLD SCRIPT CAPITAL T
\\bscrU                     <char-0x1D4E4>               " 𝓤          : MATHEMATICAL BOLD SCRIPT CAPITAL U
\\bscrV                     <char-0x1D4E5>               " 𝓥          : MATHEMATICAL BOLD SCRIPT CAPITAL V
\\bscrW                     <char-0x1D4E6>               " 𝓦          : MATHEMATICAL BOLD SCRIPT CAPITAL W
\\bscrX                     <char-0x1D4E7>               " 𝓧          : MATHEMATICAL BOLD SCRIPT CAPITAL X
\\bscrY                     <char-0x1D4E8>               " 𝓨          : MATHEMATICAL BOLD SCRIPT CAPITAL Y
\\bscrZ                     <char-0x1D4E9>               " 𝓩          : MATHEMATICAL BOLD SCRIPT CAPITAL Z
\\bscra                     <char-0x1D4EA>               " 𝓪          : MATHEMATICAL BOLD SCRIPT SMALL A
\\bscrb                     <char-0x1D4EB>               " 𝓫          : MATHEMATICAL BOLD SCRIPT SMALL B
\\bscrc                     <char-0x1D4EC>               " 𝓬          : MATHEMATICAL BOLD SCRIPT SMALL C
\\bscrd                     <char-0x1D4ED>               " 𝓭          : MATHEMATICAL BOLD SCRIPT SMALL D
\\bscre                     <char-0x1D4EE>               " 𝓮          : MATHEMATICAL BOLD SCRIPT SMALL E
\\bscrf                     <char-0x1D4EF>               " 𝓯          : MATHEMATICAL BOLD SCRIPT SMALL F
\\bscrg                     <char-0x1D4F0>               " 𝓰          : MATHEMATICAL BOLD SCRIPT SMALL G
\\bscrh                     <char-0x1D4F1>               " 𝓱          : MATHEMATICAL BOLD SCRIPT SMALL H
\\bscri                     <char-0x1D4F2>               " 𝓲          : MATHEMATICAL BOLD SCRIPT SMALL I
\\bscrj                     <char-0x1D4F3>               " 𝓳          : MATHEMATICAL BOLD SCRIPT SMALL J
\\bscrk                     <char-0x1D4F4>               " 𝓴          : MATHEMATICAL BOLD SCRIPT SMALL K
\\bscrl                     <char-0x1D4F5>               " 𝓵          : MATHEMATICAL BOLD SCRIPT SMALL L
\\bscrm                     <char-0x1D4F6>               " 𝓶          : MATHEMATICAL BOLD SCRIPT SMALL M
\\bscrn                     <char-0x1D4F7>               " 𝓷          : MATHEMATICAL BOLD SCRIPT SMALL N
\\bscro                     <char-0x1D4F8>               " 𝓸          : MATHEMATICAL BOLD SCRIPT SMALL O
\\bscrp                     <char-0x1D4F9>               " 𝓹          : MATHEMATICAL BOLD SCRIPT SMALL P
\\bscrq                     <char-0x1D4FA>               " 𝓺          : MATHEMATICAL BOLD SCRIPT SMALL Q
\\bscrr                     <char-0x1D4FB>               " 𝓻          : MATHEMATICAL BOLD SCRIPT SMALL R
\\bscrs                     <char-0x1D4FC>               " 𝓼          : MATHEMATICAL BOLD SCRIPT SMALL S
\\bscrt                     <char-0x1D4FD>               " 𝓽          : MATHEMATICAL BOLD SCRIPT SMALL T
\\bscru                     <char-0x1D4FE>               " 𝓾          : MATHEMATICAL BOLD SCRIPT SMALL U
\\bscrv                     <char-0x1D4FF>               " 𝓿          : MATHEMATICAL BOLD SCRIPT SMALL V
\\bscrw                     <char-0x1D500>               " 𝔀          : MATHEMATICAL BOLD SCRIPT SMALL W
\\bscrx                     <char-0x1D501>               " 𝔁          : MATHEMATICAL BOLD SCRIPT SMALL X
\\bscry                     <char-0x1D502>               " 𝔂          : MATHEMATICAL BOLD SCRIPT SMALL Y
\\bscrz                     <char-0x1D503>               " 𝔃          : MATHEMATICAL BOLD SCRIPT SMALL Z
\\bsimilarleftarrow         <char-0x02B41>               " ⭁          : REVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROW
\\bsimilarrightarrow        <char-0x02B47>               " ⭇          : REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW
\\bsolhsub                  <char-0x027C8>               " ⟈          : REVERSE SOLIDUS PRECEDING SUBSET
\\btdl                      <char-0x0026C>               " ɬ          : LATIN SMALL LETTER L WITH BELT / LATIN SMALL LETTER L BELT
\\btimes                    <char-0x02A32>               " ⨲          : SEMIDIRECT PRODUCT WITH BOTTOM CLOSED
\\bullet                    <char-0x02022>               " •          : BULLET
\\bullseye                  <char-0x025CE>               " ◎          : BULLSEYE
\\bumpeq                    <char-0x0224F>               " ≏          : DIFFERENCE BETWEEN
\\bumpeq<Tab>               <char-0x0224F>               " ≏          : DIFFERENCE BETWEEN
\\bumpeqq                   <char-0x02AAE>               " ⪮          : EQUALS SIGN WITH BUMPY ABOVE
\\c                         <char-0x00327>               " ◌̧          : COMBINING CEDILLA / NON-SPACING CEDILLA
\\c<Tab>                    <char-0x00327>               " ◌̧          : COMBINING CEDILLA / NON-SPACING CEDILLA
\\ca                        \\ca                         "            : (Incomplete sequence)
\\cancer                    <char-0x0264B>               " ♋         : CANCER
\\candra                    <char-0x00310>               " ◌̐          : COMBINING CANDRABINDU / NON-SPACING CANDRABINDU
\\cap                       <char-0x02229>               " ∩          : INTERSECTION
\\cap<Tab>                  <char-0x02229>               " ∩          : INTERSECTION
\\capd                      \\capd                       "            : (Incomplete sequence)
\\capdot                    <char-0x02A40>               " ⩀          : INTERSECTION WITH DOT
\\capr                      \\capr                       "            : (Incomplete sequence)
\\capricornus               <char-0x02651>               " ♑         : CAPRICORN
\\capw                      \\capw                       "            : (Incomplete sequence)
\\capwedge                  <char-0x02A44>               " ⩄          : INTERSECTION WITH LOGICAL AND
\\carriagereturn            <char-0x021B5>               " ↵          : DOWNWARDS ARROW WITH CORNER LEFTWARDS / DOWN ARROW WITH CORNER LEFT
\\cb                        \\cb                         "            : (Incomplete sequence)
\\cbrt                      <char-0x0221B>               " ∛          : CUBE ROOT
\\cd                        \\cd                         "            : (Incomplete sequence)
\\cdot                      <char-0x022C5>               " ⋅          : DOT OPERATOR
\\cdot<Tab>                 <char-0x022C5>               " ⋅          : DOT OPERATOR
\\cdotp                     <char-0x000B7>               " ·          : MIDDLE DOT
\\cdots                     <char-0x022EF>               " ⋯          : MIDLINE HORIZONTAL ELLIPSIS
\\ch                        \\ch                         "            : (Incomplete sequence)
\\check                     <char-0x0030C>               " ◌̌          : COMBINING CARON / NON-SPACING HACEK
\\check<Tab>                <char-0x0030C>               " ◌̌          : COMBINING CARON / NON-SPACING HACEK
\\checkm                    \\checkm                     "            : (Incomplete sequence)
\\checkmark                 <char-0x02713>               " ✓          : CHECK MARK
\\chi                       <char-0x003C7>               " χ          : GREEK SMALL LETTER CHI
\\ci                        \\ci                         "            : (Incomplete sequence)
\\circ                      <char-0x02218>               " ∘          : RING OPERATOR
\\circ<Tab>                 <char-0x02218>               " ∘          : RING OPERATOR
\\circe                     \\circe                      "            : (Incomplete sequence)
\\circeq                    <char-0x02257>               " ≗          : RING EQUAL TO
\\circl                     \\circl                      "            : (Incomplete sequence)
\\circlearrowleft           <char-0x021BA>               " ↺          : ANTICLOCKWISE OPEN CIRCLE ARROW
\\circlearrowright          <char-0x021BB>               " ↻          : CLOCKWISE OPEN CIRCLE ARROW
\\circledR                  <char-0x000AE>               " ®          : REGISTERED SIGN / REGISTERED TRADE MARK SIGN
\\circledS                  <char-0x024C8>               " Ⓢ          : CIRCLED LATIN CAPITAL LETTER S
\\circledast                <char-0x0229B>               " ⊛          : CIRCLED ASTERISK OPERATOR
\\circledbullet             <char-0x029BF>               " ⦿          : CIRCLED BULLET
\\circledcirc               <char-0x0229A>               " ⊚          : CIRCLED RING OPERATOR
\\circleddash               <char-0x0229D>               " ⊝          : CIRCLED DASH
\\circledequal              <char-0x0229C>               " ⊜          : CIRCLED EQUALS
\\circledparallel           <char-0x029B7>               " ⦷          : CIRCLED PARALLEL
\\circledrightdot           <char-0x02686>               " ⚆          : WHITE CIRCLE WITH DOT RIGHT
\\circledstar               <char-0x0272A>               " ✪          : CIRCLED WHITE STAR
\\circledtwodots            <char-0x02687>               " ⚇          : WHITE CIRCLE WITH TWO DOTS
\\circledwhitebullet        <char-0x029BE>               " ⦾          : CIRCLED WHITE BULLET
\\circlellquad              <char-0x025F5>               " ◵          : WHITE CIRCLE WITH LOWER LEFT QUADRANT
\\circlelrquad              <char-0x025F6>               " ◶          : WHITE CIRCLE WITH LOWER RIGHT QUADRANT
\\circleonleftarrow         <char-0x02B30>               " ⬰          : LEFT ARROW WITH SMALL CIRCLE
\\circleonrightarrow        <char-0x021F4>               " ⇴          : RIGHT ARROW WITH SMALL CIRCLE
\\circletophalfblack        <char-0x025D3>               " ◓          : CIRCLE WITH UPPER HALF BLACK
\\circleulquad              <char-0x025F4>               " ◴          : WHITE CIRCLE WITH UPPER LEFT QUADRANT
\\circleurquad              <char-0x025F7>               " ◷          : WHITE CIRCLE WITH UPPER RIGHT QUADRANT
\\circleurquad<Tab>         <char-0x025F7>               " ◷          : WHITE CIRCLE WITH UPPER RIGHT QUADRANT
\\circleurquadb             \\circleurquadb              "            : (Incomplete sequence)
\\circleurquadblack         <char-0x025D4>               " ◔          : CIRCLE WITH UPPER RIGHT QUADRANT BLACK
\\circlevertfill            <char-0x025CD>               " ◍          : CIRCLE WITH VERTICAL FILL
\\cirfb                     <char-0x025D2>               " ◒          : CIRCLE WITH LOWER HALF BLACK
\\cirfl                     <char-0x025D0>               " ◐          : CIRCLE WITH LEFT HALF BLACK
\\cirfnint                  <char-0x02A10>               " ⨐          : CIRCULATION FUNCTION
\\cirfr                     <char-0x025D1>               " ◑          : CIRCLE WITH RIGHT HALF BLACK
\\cl                        \\cl                         "            : (Incomplete sequence)
\\clockoint                 <char-0x02A0F>               " ⨏          : INTEGRAL AVERAGE WITH SLASH
\\clomeg                    <char-0x00277>               " ɷ          : LATIN SMALL LETTER CLOSED OMEGA
\\closedvarcap              <char-0x02A4D>               " ⩍          : CLOSED INTERSECTION WITH SERIFS
\\closedvarcup              <char-0x02A4C>               " ⩌          : CLOSED UNION WITH SERIFS
\\closedvarcup<Tab>         <char-0x02A4C>               " ⩌          : CLOSED UNION WITH SERIFS
\\closedvarcups             \\closedvarcups              "            : (Incomplete sequence)
\\closedvarcupsmashprod     <char-0x02A50>               " ⩐          : CLOSED UNION WITH SERIFS AND SMASH PRODUCT
\\clubsuit                  <char-0x02663>               " ♣          : BLACK CLUB SUIT
\\clwintegral               <char-0x02231>               " ∱          : CLOCKWISE INTEGRAL
\\co                        \\co                         "            : (Incomplete sequence)
\\coloneq                   <char-0x02254>               " ≔          : COLON EQUALS / COLON EQUAL
\\commaminus                <char-0x02A29>               " ⨩          : MINUS SIGN WITH COMMA ABOVE
\\complement                <char-0x02201>               " ∁          : COMPLEMENT
\\cong                      <char-0x02245>               " ≅          : APPROXIMATELY EQUAL TO
\\cong<Tab>                 <char-0x02245>               " ≅          : APPROXIMATELY EQUAL TO
\\congd                     \\congd                      "            : (Incomplete sequence)
\\congdot                   <char-0x02A6D>               " ⩭          : CONGRUENT WITH DOT ABOVE
\\conictaper                <char-0x02332>               " ⌲          : CONICAL TAPER
\\conjquant                 <char-0x02A07>               " ⨇          : TWO LOGICAL AND OPERATOR
\\coprod                    <char-0x02210>               " ∐          : N-ARY COPRODUCT
\\copyright                 <char-0x000A9>               " ©          : COPYRIGHT SIGN
\\cs                        \\cs                         "            : (Incomplete sequence)
\\csub                      <char-0x02ACF>               " ⫏          : CLOSED SUBSET
\\csub<Tab>                 <char-0x02ACF>               " ⫏          : CLOSED SUBSET
\\csube                     <char-0x02AD1>               " ⫑          : CLOSED SUBSET OR EQUAL TO
\\csup                      <char-0x02AD0>               " ⫐          : CLOSED SUPERSET
\\csup<Tab>                 <char-0x02AD0>               " ⫐          : CLOSED SUPERSET
\\csupe                     <char-0x02AD2>               " ⫒          : CLOSED SUPERSET OR EQUAL TO
\\cu                        \\cu                         "            : (Incomplete sequence)
\\cup                       <char-0x0222A>               " ∪          : UNION
\\cup<Tab>                  <char-0x0222A>               " ∪          : UNION
\\cupd                      \\cupd                       "            : (Incomplete sequence)
\\cupdot                    <char-0x0228D>               " ⊍          : MULTISET MULTIPLICATION
\\cupv                      \\cupv                       "            : (Incomplete sequence)
\\cupvee                    <char-0x02A45>               " ⩅          : UNION WITH LOGICAL OR
\\curlyeqprec               <char-0x022DE>               " ⋞          : EQUAL TO OR PRECEDES
\\curlyeqsucc               <char-0x022DF>               " ⋟          : EQUAL TO OR SUCCEEDS
\\curlyvee                  <char-0x022CE>               " ⋎          : CURLY LOGICAL OR
\\curlywedge                <char-0x022CF>               " ⋏          : CURLY LOGICAL AND
\\curvearrowleft            <char-0x021B6>               " ↶          : ANTICLOCKWISE TOP SEMICIRCLE ARROW
\\curvearrowright           <char-0x021B7>               " ↷          : CLOCKWISE TOP SEMICIRCLE ARROW
\\dagger                    <char-0x02020>               " †          : DAGGER
\\daleth                    <char-0x02138>               " ℸ          : DALET SYMBOL / FOURTH TRANSFINITE CARDINAL
\\danger                    <char-0x02621>               " ☡          : CAUTION SIGN
\\dashV                     <char-0x02AE3>               " ⫣          : DOUBLE VERTICAL BAR LEFT TURNSTILE
\\dashleftharpoondown       <char-0x0296B>               " ⥫          : LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
\\dashrightharpoondown      <char-0x0296D>               " ⥭          : RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
\\dashv                     <char-0x022A3>               " ⊣          : LEFT TACK
\\dbkarow                   <char-0x0290F>               " ⤏          : RIGHTWARDS TRIPLE DASH ARROW
\\dblarrowupdown            <char-0x021C5>               " ⇅          : UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW / UP ARROW LEFT OF DOWN ARROW
\\ddagger                   <char-0x02021>               " ‡          : DOUBLE DAGGER
\\ddddot                    <char-0x020DC>               " ◌⃜          : COMBINING FOUR DOTS ABOVE / NON-SPACING FOUR DOTS ABOVE
\\dddot                     <char-0x020DB>               " ◌⃛          : COMBINING THREE DOTS ABOVE / NON-SPACING THREE DOTS ABOVE
\\ddfnc                     <char-0x02999>               " ⦙          : DOTTED FENCE
\\ddot                      <char-0x00308>               " ◌̈          : COMBINING DIAERESIS / NON-SPACING DIAERESIS
\\ddot<Tab>                 <char-0x00308>               " ◌̈          : COMBINING DIAERESIS / NON-SPACING DIAERESIS
\\ddots                     <char-0x022F1>               " ⋱          : DOWN RIGHT DIAGONAL ELLIPSIS
\\ddots<Tab>                <char-0x022F1>               " ⋱          : DOWN RIGHT DIAGONAL ELLIPSIS
\\ddotse                    \\ddotse                     "            : (Incomplete sequence)
\\ddotseq                   <char-0x02A77>               " ⩷          : EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW
\\defas                     <char-0x029CB>               " ⧋          : TRIANGLE WITH UNDERBAR
\\degree                    <char-0x000B0>               " °          : DEGREE SIGN
\\del                       <char-0x02207>               " ∇          : NABLA
\\del<Tab>                  <char-0x02207>               " ∇          : NABLA
\\delt                      \\delt                       "            : (Incomplete sequence)
\\delta                     <char-0x003B4>               " δ          : GREEK SMALL LETTER DELTA
\\dh                        <char-0x000F0>               " ð          : LATIN SMALL LETTER ETH
\\diagdown                  <char-0x02572>               " ╲          : BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT / FORMS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
\\diagup                    <char-0x02571>               " ╱          : BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT / FORMS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
\\diameter                  <char-0x02300>               " ⌀          : DIAMETER SIGN
\\diamond                   <char-0x022C4>               " ⋄          : DIAMOND OPERATOR
\\diamond<Tab>              <char-0x022C4>               " ⋄          : DIAMOND OPERATOR
\\diamondb                  \\diamondb                   "            : (Incomplete sequence)
\\diamondbotblack           <char-0x02B19>               " ⬙          : DIAMOND WITH BOTTOM HALF BLACK
\\diamondl                  \\diamondl                   "            : (Incomplete sequence)
\\diamondleftarrow          <char-0x0291D>               " ⤝          : LEFTWARDS ARROW TO BLACK DIAMOND
\\diamondleftarrow<Tab>     <char-0x0291D>               " ⤝          : LEFTWARDS ARROW TO BLACK DIAMOND
\\diamondleftarrowb         \\diamondleftarrowb          "            : (Incomplete sequence)
\\diamondleftarrowbar       <char-0x0291F>               " ⤟          : LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND
\\diamondleftblack          <char-0x02B16>               " ⬖          : DIAMOND WITH LEFT HALF BLACK
\\diamondr                  \\diamondr                   "            : (Incomplete sequence)
\\diamondrightblack         <char-0x02B17>               " ⬗          : DIAMOND WITH RIGHT HALF BLACK
\\diamonds                  \\diamonds                   "            : (Incomplete sequence)
\\diamondsuit               <char-0x02662>               " ♢          : WHITE DIAMOND SUIT
\\diamondt                  \\diamondt                   "            : (Incomplete sequence)
\\diamondtopblack           <char-0x02B18>               " ⬘          : DIAMOND WITH TOP HALF BLACK
\\dicei                     <char-0x02680>               " ⚀          : DIE FACE-1
\\dicei<Tab>                <char-0x02680>               " ⚀          : DIE FACE-1
\\diceii                    <char-0x02681>               " ⚁          : DIE FACE-2
\\diceii<Tab>               <char-0x02681>               " ⚁          : DIE FACE-2
\\diceiii                   <char-0x02682>               " ⚂          : DIE FACE-3
\\diceiv                    <char-0x02683>               " ⚃          : DIE FACE-4
\\dicev                     <char-0x02684>               " ⚄          : DIE FACE-5
\\dicev<Tab>                <char-0x02684>               " ⚄          : DIE FACE-5
\\dicevi                    <char-0x02685>               " ⚅          : DIE FACE-6
\\digamma                   <char-0x003DD>               " ϝ          : GREEK SMALL LETTER DIGAMMA
\\dingasterisk              <char-0x0273D>               " ✽          : HEAVY TEARDROP-SPOKED ASTERISK
\\disin                     <char-0x022F2>               " ⋲          : ELEMENT OF WITH LONG HORIZONTAL STROKE
\\disjquant                 <char-0x02A08>               " ⨈          : TWO LOGICAL OR OPERATOR
\\div                       <char-0x000F7>               " ÷          : DIVISION SIGN
\\div<Tab>                  <char-0x000F7>               " ÷          : DIVISION SIGN
\\divi                      \\divi                       "            : (Incomplete sequence)
\\divideontimes             <char-0x022C7>               " ⋇          : DIVISION TIMES
\\dj                        <char-0x00111>               " đ          : LATIN SMALL LETTER D WITH STROKE / LATIN SMALL LETTER D BAR
\\dlcorn                    <char-0x023A3>               " ⎣          : LEFT SQUARE BRACKET LOWER CORNER
\\dot                       <char-0x00307>               " ◌̇          : COMBINING DOT ABOVE / NON-SPACING DOT ABOVE
\\dot<Tab>                  <char-0x00307>               " ◌̇          : COMBINING DOT ABOVE / NON-SPACING DOT ABOVE
\\dote                      \\dote                       "            : (Incomplete sequence)
\\doteq                     <char-0x02250>               " ≐          : APPROACHES THE LIMIT
\\doteq<Tab>                <char-0x02250>               " ≐          : APPROACHES THE LIMIT
\\dotequ                    \\dotequ                     "            : (Incomplete sequence)
\\dotequiv                  <char-0x02A67>               " ⩧          : IDENTICAL WITH DOT ABOVE
\\dotm                      \\dotm                       "            : (Incomplete sequence)
\\dotminus                  <char-0x02238>               " ∸          : DOT MINUS
\\dotp                      \\dotp                       "            : (Incomplete sequence)
\\dotplus                   <char-0x02214>               " ∔          : DOT PLUS
\\dots                      <char-0x02026>               " …          : HORIZONTAL ELLIPSIS
\\dots<Tab>                 <char-0x02026>               " …          : HORIZONTAL ELLIPSIS
\\dotsi                     \\dotsi                      "            : (Incomplete sequence)
\\dotsim                    <char-0x02A6A>               " ⩪          : TILDE OPERATOR WITH DOT ABOVE
\\dotsm                     \\dotsm                      "            : (Incomplete sequence)
\\dotsminusdots             <char-0x0223A>               " ∺          : GEOMETRIC PROPORTION
\\dott                      \\dott                       "            : (Incomplete sequence)
\\dottedcircle              <char-0x025CC>               " ◌          : DOTTED CIRCLE
\\dottedsquare              <char-0x02B1A>               " ⬚          : DOTTED SQUARE
\\dottimes                  <char-0x02A30>               " ⨰          : MULTIPLICATION SIGN WITH DOT ABOVE
\\doublebarvee              <char-0x02A62>               " ⩢          : LOGICAL OR WITH DOUBLE OVERBAR
\\doublepipe                <char-0x001C2>               " ǂ          : LATIN LETTER ALVEOLAR CLICK / LATIN LETTER PIPE DOUBLE BAR
\\doubleplus                <char-0x029FA>               " ⧺          : DOUBLE PLUS
\\downarrow                 <char-0x02193>               " ↓          : DOWNWARDS ARROW / DOWN ARROW
\\downarrow<Tab>            <char-0x02193>               " ↓          : DOWNWARDS ARROW / DOWN ARROW
\\downarrowb                \\downarrowb                 "            : (Incomplete sequence)
\\downarrowbarred           <char-0x02908>               " ⤈          : DOWNWARDS ARROW WITH HORIZONTAL STROKE
\\downdasharrow             <char-0x021E3>               " ⇣          : DOWNWARDS DASHED ARROW / DOWN DASHED ARROW
\\downdownarrows            <char-0x021CA>               " ⇊          : DOWNWARDS PAIRED ARROWS / DOWN PAIRED ARROWS
\\downharpoonleft           <char-0x021C3>               " ⇃          : DOWNWARDS HARPOON WITH BARB LEFTWARDS / DOWN HARPOON WITH BARB LEFT
\\downharpoonright          <char-0x021C2>               " ⇂          : DOWNWARDS HARPOON WITH BARB RIGHTWARDS / DOWN HARPOON WITH BARB RIGHT
\\downharpoonsleftright     <char-0x02965>               " ⥥          : DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
\\downvDash                 <char-0x02AEA>               " ⫪          : DOUBLE DOWN TACK
\\downwhitearrow            <char-0x021E9>               " ⇩          : DOWNWARDS WHITE ARROW / WHITE DOWN ARROW
\\downzigzagarrow           <char-0x021AF>               " ↯          : DOWNWARDS ZIGZAG ARROW / DOWN ZIGZAG ARROW
\\draftingarrow             <char-0x0279B>               " ➛          : DRAFTING POINT RIGHTWARDS ARROW / DRAFTING POINT RIGHT ARROW
\\drbkarrow                 <char-0x02910>               " ⤐          : RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW
\\droang                    <char-0x0031A>               " ◌̚          : COMBINING LEFT ANGLE ABOVE / NON-SPACING LEFT ANGLE ABOVE
\\dshfnc                    <char-0x02506>               " ┆          : BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL / FORMS LIGHT TRIPLE DASH VERTICAL
\\dsol                      <char-0x029F6>               " ⧶          : SOLIDUS WITH OVERBAR
\\dualmap                   <char-0x029DF>               " ⧟          : DOUBLE-ENDED MULTIMAP
\\dyogh                     <char-0x002A4>               " ʤ          : LATIN SMALL LETTER DEZH DIGRAPH / LATIN SMALL LETTER D YOGH
\\egsdot                    <char-0x02A98>               " ⪘          : SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE
\\eighthnote                <char-0x0266A>               " ♪          : EIGHTH NOTE
\\elinters                  <char-0x023E7>               " ⏧          : ELECTRICAL INTERSECTION
\\ell                       <char-0x02113>               " ℓ          : SCRIPT SMALL L
\\elsdot                    <char-0x02A97>               " ⪗          : SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE
\\emdash                    <char-0x02014>               " —          : EM DASH
\\emptyset                  <char-0x02205>               " ∅          : EMPTY SET
\\emptyset<Tab>             <char-0x02205>               " ∅          : EMPTY SET
\\emptyseto                 \\emptyseto                  "            : (Incomplete sequence)
\\emptysetoarr              <char-0x029B3>               " ⦳          : EMPTY SET WITH RIGHT ARROW ABOVE
\\emptysetoarr<Tab>         <char-0x029B3>               " ⦳          : EMPTY SET WITH RIGHT ARROW ABOVE
\\emptysetoarrl             <char-0x029B4>               " ⦴          : EMPTY SET WITH LEFT ARROW ABOVE
\\emptysetobar              <char-0x029B1>               " ⦱          : EMPTY SET WITH OVERBAR
\\emptysetocirc             <char-0x029B2>               " ⦲          : EMPTY SET WITH SMALL CIRCLE ABOVE
\\enclosecircle             <char-0x020DD>               " ◌⃝          : COMBINING ENCLOSING CIRCLE / ENCLOSING CIRCLE
\\enclosediamond            <char-0x020DF>               " ◌⃟          : COMBINING ENCLOSING DIAMOND / ENCLOSING DIAMOND
\\enclosesquare             <char-0x020DE>               " ◌⃞          : COMBINING ENCLOSING SQUARE / ENCLOSING SQUARE
\\enclosetriangle           <char-0x020E4>               " ◌⃤          : COMBINING ENCLOSING UPWARD POINTING TRIANGLE
\\endash                    <char-0x02013>               " –          : EN DASH
\\enspace                   <char-0x02002>               "            : EN SPACE
\\eparsl                    <char-0x029E3>               " ⧣          : EQUALS SIGN AND SLANTED PARALLEL
\\epsilon                   <char-0x003F5>               " ϵ          : GREEK LUNATE EPSILON SYMBOL
\\eqcirc                    <char-0x02256>               " ≖          : RING IN EQUAL TO
\\eqcolon                   <char-0x02255>               " ≕          : EQUALS COLON / EQUAL COLON
\\eqdef                     <char-0x0225D>               " ≝          : EQUAL TO BY DEFINITION
\\eqdot                     <char-0x02A66>               " ⩦          : EQUALS SIGN WITH DOT BELOW
\\eqeqeq                    <char-0x02A76>               " ⩶          : THREE CONSECUTIVE EQUALS SIGNS
\\eqgtr                     <char-0x022DD>               " ⋝          : EQUAL TO OR GREATER-THAN / EQUAL TO OR GREATER THAN
\\eqless                    <char-0x022DC>               " ⋜          : EQUAL TO OR LESS-THAN / EQUAL TO OR LESS THAN
\\eqqgtr                    <char-0x02A9A>               " ⪚          : DOUBLE-LINE EQUAL TO OR GREATER-THAN
\\eqqless                   <char-0x02A99>               " ⪙          : DOUBLE-LINE EQUAL TO OR LESS-THAN
\\eqqplus                   <char-0x02A71>               " ⩱          : EQUALS SIGN ABOVE PLUS SIGN
\\eqqsim                    <char-0x02A73>               " ⩳          : EQUALS SIGN ABOVE TILDE OPERATOR
\\eqqslantgtr               <char-0x02A9C>               " ⪜          : DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN
\\eqqslantless              <char-0x02A9B>               " ⪛          : DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN
\\eqsim                     <char-0x02242>               " ≂          : MINUS TILDE
\\eqslantgtr                <char-0x02A96>               " ⪖          : SLANTED EQUAL TO OR GREATER-THAN
\\eqslantless               <char-0x02A95>               " ⪕          : SLANTED EQUAL TO OR LESS-THAN
\\equalleftarrow            <char-0x02B40>               " ⭀          : EQUALS SIGN ABOVE LEFTWARDS ARROW
\\equalparallel             <char-0x022D5>               " ⋕          : EQUAL AND PARALLEL TO
\\equiv                     <char-0x02261>               " ≡          : IDENTICAL TO
\\equiv<Tab>                <char-0x02261>               " ≡          : IDENTICAL TO
\\equivD                    \\equivD                     "            : (Incomplete sequence)
\\equivDD                   <char-0x02A78>               " ⩸          : EQUIVALENT WITH FOUR DOTS ABOVE
\\eqvparsl                  <char-0x029E5>               " ⧥          : IDENTICAL TO AND SLANTED PARALLEL
\\esh                       <char-0x00283>               " ʃ          : LATIN SMALL LETTER ESH
\\eta                       <char-0x003B7>               " η          : GREEK SMALL LETTER ETA
\\eth                       <char-0x000F0>               " ð          : LATIN SMALL LETTER ETH
\\euler                     <char-0x0212F>               " ℯ          : SCRIPT SMALL E
\\euler<Tab>                <char-0x0212F>               " ℯ          : SCRIPT SMALL E
\\eulerm                    \\eulerm                     "            : (Incomplete sequence)
\\eulermascheroni           <char-0x02107>               " ℇ          : EULER CONSTANT / EULERS
\\euro                      <char-0x020AC>               " €          : EURO SIGN
\\exclamdown                <char-0x000A1>               " ¡          : INVERTED EXCLAMATION MARK
\\exists                    <char-0x02203>               " ∃          : THERE EXISTS
\\fallingdotseq             <char-0x02252>               " ≒          : APPROXIMATELY EQUAL TO OR THE IMAGE OF
\\fdiagovnearrow            <char-0x0292F>               " ⤯          : FALLING DIAGONAL CROSSING NORTH EAST ARROW
\\fdiagovrdiag              <char-0x0292C>               " ⤬          : FALLING DIAGONAL CROSSING RISING DIAGONAL
\\female                    <char-0x02640>               " ♀          : FEMALE SIGN
\\fhr                       <char-0x0027E>               " ɾ          : LATIN SMALL LETTER R WITH FISHHOOK / LATIN SMALL LETTER FISHHOOK R
\\fisheye                   <char-0x025C9>               " ◉          : FISHEYE
\\flat                      <char-0x0266D>               " ♭          : MUSIC FLAT SIGN / FLAT
\\fltns                     <char-0x023E5>               " ⏥          : FLATNESS
\\forall                    <char-0x02200>               " ∀          : FOR ALL
\\forks                     <char-0x02ADC>               " ⫝̸          : FORKING
\\forks<Tab>                <char-0x02ADC>               " ⫝̸          : FORKING
\\forksn                    \\forksn                     "            : (Incomplete sequence)
\\forksnot                  <char-0x02ADD>               " ⫝          : NONFORKING
\\forkv                     <char-0x02AD9>               " ⫙          : ELEMENT OF OPENING DOWNWARDS
\\fourthroot                <char-0x0221C>               " ∜          : FOURTH ROOT
\\frakA                     <char-0x1D504>               " 𝔄          : MATHEMATICAL FRAKTUR CAPITAL A
\\frakB                     <char-0x1D505>               " 𝔅          : MATHEMATICAL FRAKTUR CAPITAL B
\\frakC                     <char-0x0212D>               " ℭ          : BLACK-LETTER CAPITAL C / BLACK-LETTER C
\\frakD                     <char-0x1D507>               " 𝔇          : MATHEMATICAL FRAKTUR CAPITAL D
\\frakE                     <char-0x1D508>               " 𝔈          : MATHEMATICAL FRAKTUR CAPITAL E
\\frakF                     <char-0x1D509>               " 𝔉          : MATHEMATICAL FRAKTUR CAPITAL F
\\frakG                     <char-0x1D50A>               " 𝔊          : MATHEMATICAL FRAKTUR CAPITAL G
\\frakH                     <char-0x0210C>               " ℌ          : BLACK-LETTER CAPITAL H / BLACK-LETTER H
\\frakI                     <char-0x02111>               " ℑ          : BLACK-LETTER CAPITAL I / BLACK-LETTER I
\\frakJ                     <char-0x1D50D>               " 𝔍          : MATHEMATICAL FRAKTUR CAPITAL J
\\frakK                     <char-0x1D50E>               " 𝔎          : MATHEMATICAL FRAKTUR CAPITAL K
\\frakL                     <char-0x1D50F>               " 𝔏          : MATHEMATICAL FRAKTUR CAPITAL L
\\frakM                     <char-0x1D510>               " 𝔐          : MATHEMATICAL FRAKTUR CAPITAL M
\\frakN                     <char-0x1D511>               " 𝔑          : MATHEMATICAL FRAKTUR CAPITAL N
\\frakO                     <char-0x1D512>               " 𝔒          : MATHEMATICAL FRAKTUR CAPITAL O
\\frakP                     <char-0x1D513>               " 𝔓          : MATHEMATICAL FRAKTUR CAPITAL P
\\frakQ                     <char-0x1D514>               " 𝔔          : MATHEMATICAL FRAKTUR CAPITAL Q
\\frakR                     <char-0x0211C>               " ℜ          : BLACK-LETTER CAPITAL R / BLACK-LETTER R
\\frakS                     <char-0x1D516>               " 𝔖          : MATHEMATICAL FRAKTUR CAPITAL S
\\frakT                     <char-0x1D517>               " 𝔗          : MATHEMATICAL FRAKTUR CAPITAL T
\\frakU                     <char-0x1D518>               " 𝔘          : MATHEMATICAL FRAKTUR CAPITAL U
\\frakV                     <char-0x1D519>               " 𝔙          : MATHEMATICAL FRAKTUR CAPITAL V
\\frakW                     <char-0x1D51A>               " 𝔚          : MATHEMATICAL FRAKTUR CAPITAL W
\\frakX                     <char-0x1D51B>               " 𝔛          : MATHEMATICAL FRAKTUR CAPITAL X
\\frakY                     <char-0x1D51C>               " 𝔜          : MATHEMATICAL FRAKTUR CAPITAL Y
\\frakZ                     <char-0x02128>               " ℨ          : BLACK-LETTER CAPITAL Z / BLACK-LETTER Z
\\fraka                     <char-0x1D51E>               " 𝔞          : MATHEMATICAL FRAKTUR SMALL A
\\frakb                     <char-0x1D51F>               " 𝔟          : MATHEMATICAL FRAKTUR SMALL B
\\frakc                     <char-0x1D520>               " 𝔠          : MATHEMATICAL FRAKTUR SMALL C
\\frakd                     <char-0x1D521>               " 𝔡          : MATHEMATICAL FRAKTUR SMALL D
\\frake                     <char-0x1D522>               " 𝔢          : MATHEMATICAL FRAKTUR SMALL E
\\frakf                     <char-0x1D523>               " 𝔣          : MATHEMATICAL FRAKTUR SMALL F
\\frakg                     <char-0x1D524>               " 𝔤          : MATHEMATICAL FRAKTUR SMALL G
\\frakh                     <char-0x1D525>               " 𝔥          : MATHEMATICAL FRAKTUR SMALL H
\\fraki                     <char-0x1D526>               " 𝔦          : MATHEMATICAL FRAKTUR SMALL I
\\frakj                     <char-0x1D527>               " 𝔧          : MATHEMATICAL FRAKTUR SMALL J
\\frakk                     <char-0x1D528>               " 𝔨          : MATHEMATICAL FRAKTUR SMALL K
\\frakl                     <char-0x1D529>               " 𝔩          : MATHEMATICAL FRAKTUR SMALL L
\\frakm                     <char-0x1D52A>               " 𝔪          : MATHEMATICAL FRAKTUR SMALL M
\\frakn                     <char-0x1D52B>               " 𝔫          : MATHEMATICAL FRAKTUR SMALL N
\\frako                     <char-0x1D52C>               " 𝔬          : MATHEMATICAL FRAKTUR SMALL O
\\frakp                     <char-0x1D52D>               " 𝔭          : MATHEMATICAL FRAKTUR SMALL P
\\frakq                     <char-0x1D52E>               " 𝔮          : MATHEMATICAL FRAKTUR SMALL Q
\\frakr                     <char-0x1D52F>               " 𝔯          : MATHEMATICAL FRAKTUR SMALL R
\\fraks                     <char-0x1D530>               " 𝔰          : MATHEMATICAL FRAKTUR SMALL S
\\frakt                     <char-0x1D531>               " 𝔱          : MATHEMATICAL FRAKTUR SMALL T
\\fraku                     <char-0x1D532>               " 𝔲          : MATHEMATICAL FRAKTUR SMALL U
\\frakv                     <char-0x1D533>               " 𝔳          : MATHEMATICAL FRAKTUR SMALL V
\\frakw                     <char-0x1D534>               " 𝔴          : MATHEMATICAL FRAKTUR SMALL W
\\frakx                     <char-0x1D535>               " 𝔵          : MATHEMATICAL FRAKTUR SMALL X
\\fraky                     <char-0x1D536>               " 𝔶          : MATHEMATICAL FRAKTUR SMALL Y
\\frakz                     <char-0x1D537>               " 𝔷          : MATHEMATICAL FRAKTUR SMALL Z
\\frown                     <char-0x02322>               " ⌢          : FROWN
\\fullouterjoin             <char-0x027D7>               " ⟗          : FULL OUTER JOIN
\\gamma                     <char-0x003B3>               " γ          : GREEK SMALL LETTER GAMMA
\\ge                        <char-0x02265>               " ≥          : GREATER-THAN OR EQUAL TO / GREATER THAN OR EQUAL TO
\\ge<Tab>                   <char-0x02265>               " ≥          : GREATER-THAN OR EQUAL TO / GREATER THAN OR EQUAL TO
\\gem                       \\gem                        "            : (Incomplete sequence)
\\gemini                    <char-0x0264A>               " ♊         : GEMINI
\\geq                       <char-0x02265>               " ≥          : GREATER-THAN OR EQUAL TO / GREATER THAN OR EQUAL TO
\\geq<Tab>                  <char-0x02265>               " ≥          : GREATER-THAN OR EQUAL TO / GREATER THAN OR EQUAL TO
\\geqq                      <char-0x02267>               " ≧          : GREATER-THAN OVER EQUAL TO / GREATER THAN OVER EQUAL TO
\\geqq<Tab>                 <char-0x02267>               " ≧          : GREATER-THAN OVER EQUAL TO / GREATER THAN OVER EQUAL TO
\\geqqs                     \\geqqs                      "            : (Incomplete sequence)
\\geqqslant                 <char-0x02AFA>               " ⫺          : DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO
\\geqs                      \\geqs                       "            : (Incomplete sequence)
\\geqslant                  <char-0x02A7E>               " ⩾          : GREATER-THAN OR SLANTED EQUAL TO
\\ges                       \\ges                        "            : (Incomplete sequence)
\\gescc                     <char-0x02AA9>               " ⪩          : GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
\\gesdot                    <char-0x02A80>               " ⪀          : GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
\\gesdot<Tab>               <char-0x02A80>               " ⪀          : GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
\\gesdoto                   <char-0x02A82>               " ⪂          : GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
\\gesdoto<Tab>              <char-0x02A82>               " ⪂          : GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
\\gesdotol                  <char-0x02A84>               " ⪄          : GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT
\\gesles                    <char-0x02A94>               " ⪔          : GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL
\\gg                        <char-0x0226B>               " ≫          : MUCH GREATER-THAN / MUCH GREATER THAN
\\gg<Tab>                   <char-0x0226B>               " ≫          : MUCH GREATER-THAN / MUCH GREATER THAN
\\ggg                       <char-0x022D9>               " ⋙          : VERY MUCH GREATER-THAN / VERY MUCH GREATER THAN
\\ggg<Tab>                  <char-0x022D9>               " ⋙          : VERY MUCH GREATER-THAN / VERY MUCH GREATER THAN
\\gggn                      \\gggn                       "            : (Incomplete sequence)
\\gggnest                   <char-0x02AF8>               " ⫸          : TRIPLE NESTED GREATER-THAN
\\gimel                     <char-0x02137>               " ℷ          : GIMEL SYMBOL / THIRD TRANSFINITE CARDINAL
\\glE                       <char-0x02A92>               " ⪒          : GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL
\\gla                       <char-0x02AA5>               " ⪥          : GREATER-THAN BESIDE LESS-THAN
\\glj                       <char-0x02AA4>               " ⪤          : GREATER-THAN OVERLAPPING LESS-THAN
\\glst                      <char-0x00294>               " ʔ          : LATIN LETTER GLOTTAL STOP
\\gnapprox                  <char-0x02A8A>               " ⪊          : GREATER-THAN AND NOT APPROXIMATE
\\gneq                      <char-0x02A88>               " ⪈          : GREATER-THAN AND SINGLE-LINE NOT EQUAL TO
\\gneq<Tab>                 <char-0x02A88>               " ⪈          : GREATER-THAN AND SINGLE-LINE NOT EQUAL TO
\\gneqq                     <char-0x02269>               " ≩          : GREATER-THAN BUT NOT EQUAL TO / GREATER THAN BUT NOT EQUAL TO
\\gnsim                     <char-0x022E7>               " ⋧          : GREATER-THAN BUT NOT EQUIVALENT TO / GREATER THAN BUT NOT EQUIVALENT TO
\\grave                     <char-0x00300>               " ◌̀          : COMBINING GRAVE ACCENT / NON-SPACING GRAVE
\\gsime                     <char-0x02A8E>               " ⪎          : GREATER-THAN ABOVE SIMILAR OR EQUAL
\\gsiml                     <char-0x02A90>               " ⪐          : GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN
\\gtcc                      <char-0x02AA7>               " ⪧          : GREATER-THAN CLOSED BY CURVE
\\gtcir                     <char-0x02A7A>               " ⩺          : GREATER-THAN WITH CIRCLE INSIDE
\\gtquest                   <char-0x02A7C>               " ⩼          : GREATER-THAN WITH QUESTION MARK ABOVE
\\gtrapprox                 <char-0x02A86>               " ⪆          : GREATER-THAN OR APPROXIMATE
\\gtrdot                    <char-0x022D7>               " ⋗          : GREATER-THAN WITH DOT / GREATER THAN WITH DOT
\\gtreqless                 <char-0x022DB>               " ⋛          : GREATER-THAN EQUAL TO OR LESS-THAN / GREATER THAN EQUAL TO OR LESS THAN
\\gtreqqless                <char-0x02A8C>               " ⪌          : GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN
\\gtrless                   <char-0x02277>               " ≷          : GREATER-THAN OR LESS-THAN / GREATER THAN OR LESS THAN
\\gtrsim                    <char-0x02273>               " ≳          : GREATER-THAN OR EQUIVALENT TO / GREATER THAN OR EQUIVALENT TO
\\guillemotleft             <char-0x000AB>               " «          : LEFT-POINTING DOUBLE ANGLE QUOTATION MARK / LEFT POINTING GUILLEMET
\\guillemotright            <char-0x000BB>               " »          : RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK / RIGHT POINTING GUILLEMET
\\guilsinglleft             <char-0x02039>               " ‹          : SINGLE LEFT-POINTING ANGLE QUOTATION MARK / LEFT POINTING SINGLE GUILLEMET
\\guilsinglright            <char-0x0203A>               " ›          : SINGLE RIGHT-POINTING ANGLE QUOTATION MARK / RIGHT POINTING SINGLE GUILLEMET
\\gvertneqq                 <char-0x02269><char-0x0FE00> " ≩︀          : GREATER-THAN BUT NOT EQUAL TO / GREATER THAN BUT NOT EQUAL TO + VARIATION SELECTOR-1
\\hat                       <char-0x00302>               " ◌̂          : COMBINING CIRCUMFLEX ACCENT / NON-SPACING CIRCUMFLEX
\\hat<Tab>                  <char-0x00302>               " ◌̂          : COMBINING CIRCUMFLEX ACCENT / NON-SPACING CIRCUMFLEX
\\hata                      \\hata                       "            : (Incomplete sequence)
\\hatapprox                 <char-0x02A6F>               " ⩯          : ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT
\\hbar                      <char-0x00127>               " ħ          : LATIN SMALL LETTER H WITH STROKE / LATIN SMALL LETTER H BAR
\\heartsuit                 <char-0x02661>               " ♡          : WHITE HEART SUIT
\\hermaphrodite             <char-0x026A5>               " ⚥          : MALE AND FEMALE SIGN
\\hermitconjmatrix          <char-0x022B9>               " ⊹          : HERMITIAN CONJUGATE MATRIX
\\hexagon                   <char-0x02394>               " ⎔          : SOFTWARE-FUNCTION SYMBOL
\\hexagon<Tab>              <char-0x02394>               " ⎔          : SOFTWARE-FUNCTION SYMBOL
\\hexagonb                  \\hexagonb                   "            : (Incomplete sequence)
\\hexagonblack              <char-0x02B23>               " ⬣          : HORIZONTAL BLACK HEXAGON
\\highminus                 <char-0x000AF>               " ¯          : MACRON / SPACING MACRON
\\hksearow                  <char-0x02925>               " ⤥          : SOUTH EAST ARROW WITH HOOK
\\hkswarow                  <char-0x02926>               " ⤦          : SOUTH WEST ARROW WITH HOOK
\\hlmrk                     <char-0x002D1>               " ˑ          : MODIFIER LETTER HALF TRIANGULAR COLON
\\hookleftarrow             <char-0x021A9>               " ↩          : LEFTWARDS ARROW WITH HOOK / LEFT ARROW WITH HOOK
\\hookrightarrow            <char-0x021AA>               " ↪          : RIGHTWARDS ARROW WITH HOOK / RIGHT ARROW WITH HOOK
\\house                     <char-0x02302>               " ⌂          : HOUSE
\\hrectangle                <char-0x025AD>               " ▭          : WHITE RECTANGLE
\\hrectangle<Tab>           <char-0x025AD>               " ▭          : WHITE RECTANGLE
\\hrectangleb               \\hrectangleb                "            : (Incomplete sequence)
\\hrectangleblack           <char-0x025AC>               " ▬          : BLACK RECTANGLE
\\hslash                    <char-0x0210F>               " ℏ          : PLANCK CONSTANT OVER TWO PI / PLANCK CONSTANT OVER 2 PI
\\hspace                    <char-0x0200A>               "            : HAIR SPACE
\\hvlig                     <char-0x00195>               " ƕ          : LATIN SMALL LETTER HV / LATIN SMALL LETTER H V
\\iff                       <char-0x027FA>               " ⟺          : LONG LEFT RIGHT DOUBLE ARROW
\\iiiint                    <char-0x02A0C>               " ⨌          : QUADRUPLE INTEGRAL OPERATOR
\\iiint                     <char-0x0222D>               " ∭          : TRIPLE INTEGRAL
\\iint                      <char-0x0222C>               " ∬          : DOUBLE INTEGRAL
\\image                     <char-0x022B7>               " ⊷          : IMAGE OF
\\imath                     <char-0x00131>               " ı          : LATIN SMALL LETTER DOTLESS I
\\impliedby                 <char-0x027F8>               " ⟸          : LONG LEFTWARDS DOUBLE ARROW
\\implies                   <char-0x027F9>               " ⟹          : LONG RIGHTWARDS DOUBLE ARROW
\\in                        <char-0x02208>               " ∈          : ELEMENT OF
\\in<Tab>                   <char-0x02208>               " ∈          : ELEMENT OF
\\inc                       \\inc                        "            : (Incomplete sequence)
\\increment                 <char-0x02206>               " ∆          : INCREMENT
\\ind                       \\ind                        "            : (Incomplete sequence)
\\indep                     <char-0x02AEB>               " ⫫          : DOUBLE UP TACK
\\inf                       \\inf                        "            : (Incomplete sequence)
\\infty                     <char-0x0221E>               " ∞          : INFINITY
\\ing                       \\ing                        "            : (Incomplete sequence)
\\inglst                    <char-0x00296>               " ʖ          : LATIN LETTER INVERTED GLOTTAL STOP
\\int                       <char-0x0222B>               " ∫          : INTEGRAL
\\int<Tab>                  <char-0x0222B>               " ∫          : INTEGRAL
\\intB                      \\intB                       "            : (Incomplete sequence)
\\intBar                    <char-0x02A0E>               " ⨎          : INTEGRAL WITH DOUBLE STROKE
\\intb                      \\intb                       "            : (Incomplete sequence)
\\intbar                    <char-0x02A0D>               " ⨍          : FINITE PART INTEGRAL
\\intc                      \\intc                       "            : (Incomplete sequence)
\\intcap                    <char-0x02A19>               " ⨙          : INTEGRAL WITH INTERSECTION
\\intcup                    <char-0x02A1A>               " ⨚          : INTEGRAL WITH UNION
\\inte                      \\inte                       "            : (Incomplete sequence)
\\intercal                  <char-0x022BA>               " ⊺          : INTERCALATE
\\interleave                <char-0x02AF4>               " ⫴          : TRIPLE VERTICAL BAR BINARY RELATION
\\intp                      \\intp                       "            : (Incomplete sequence)
\\intprod                   <char-0x02A3C>               " ⨼          : INTERIOR PRODUCT
\\intprod<Tab>              <char-0x02A3C>               " ⨼          : INTERIOR PRODUCT
\\intprodr                  <char-0x02A3D>               " ⨽          : RIGHTHAND INTERIOR PRODUCT
\\intx                      <char-0x02A18>               " ⨘          : INTEGRAL WITH TIMES SIGN
\\inv                       \\inv                        "            : (Incomplete sequence)
\\inversewhitecircle        <char-0x025D9>               " ◙          : INVERSE WHITE CIRCLE
\\invnot                    <char-0x02310>               " ⌐          : REVERSED NOT SIGN
\\invv                      <char-0x0028C>               " ʌ          : LATIN SMALL LETTER TURNED V
\\invw                      <char-0x0028D>               " ʍ          : LATIN SMALL LETTER TURNED W
\\invw<Tab>                 <char-0x0028D>               " ʍ          : LATIN SMALL LETTER TURNED W
\\invwh                     \\invwh                      "            : (Incomplete sequence)
\\invwhitelowerhalfcircle   <char-0x025DB>               " ◛          : LOWER HALF INVERSE WHITE CIRCLE
\\invwhiteupperhalfcircle   <char-0x025DA>               " ◚          : UPPER HALF INVERSE WHITE CIRCLE
\\iota                      <char-0x003B9>               " ι          : GREEK SMALL LETTER IOTA
\\isansA                    <char-0x1D608>               " 𝘈          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL A
\\isansB                    <char-0x1D609>               " 𝘉          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL B
\\isansC                    <char-0x1D60A>               " 𝘊          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL C
\\isansD                    <char-0x1D60B>               " 𝘋          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL D
\\isansE                    <char-0x1D60C>               " 𝘌          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL E
\\isansF                    <char-0x1D60D>               " 𝘍          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL F
\\isansG                    <char-0x1D60E>               " 𝘎          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL G
\\isansH                    <char-0x1D60F>               " 𝘏          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL H
\\isansI                    <char-0x1D610>               " 𝘐          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL I
\\isansJ                    <char-0x1D611>               " 𝘑          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL J
\\isansK                    <char-0x1D612>               " 𝘒          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL K
\\isansL                    <char-0x1D613>               " 𝘓          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL L
\\isansM                    <char-0x1D614>               " 𝘔          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL M
\\isansN                    <char-0x1D615>               " 𝘕          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL N
\\isansO                    <char-0x1D616>               " 𝘖          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL O
\\isansP                    <char-0x1D617>               " 𝘗          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL P
\\isansQ                    <char-0x1D618>               " 𝘘          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q
\\isansR                    <char-0x1D619>               " 𝘙          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL R
\\isansS                    <char-0x1D61A>               " 𝘚          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL S
\\isansT                    <char-0x1D61B>               " 𝘛          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL T
\\isansU                    <char-0x1D61C>               " 𝘜          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL U
\\isansV                    <char-0x1D61D>               " 𝘝          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL V
\\isansW                    <char-0x1D61E>               " 𝘞          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL W
\\isansX                    <char-0x1D61F>               " 𝘟          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL X
\\isansY                    <char-0x1D620>               " 𝘠          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y
\\isansZ                    <char-0x1D621>               " 𝘡          : MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z
\\isansa                    <char-0x1D622>               " 𝘢          : MATHEMATICAL SANS-SERIF ITALIC SMALL A
\\isansb                    <char-0x1D623>               " 𝘣          : MATHEMATICAL SANS-SERIF ITALIC SMALL B
\\isansc                    <char-0x1D624>               " 𝘤          : MATHEMATICAL SANS-SERIF ITALIC SMALL C
\\isansd                    <char-0x1D625>               " 𝘥          : MATHEMATICAL SANS-SERIF ITALIC SMALL D
\\isanse                    <char-0x1D626>               " 𝘦          : MATHEMATICAL SANS-SERIF ITALIC SMALL E
\\isansf                    <char-0x1D627>               " 𝘧          : MATHEMATICAL SANS-SERIF ITALIC SMALL F
\\isansg                    <char-0x1D628>               " 𝘨          : MATHEMATICAL SANS-SERIF ITALIC SMALL G
\\isansh                    <char-0x1D629>               " 𝘩          : MATHEMATICAL SANS-SERIF ITALIC SMALL H
\\isansi                    <char-0x1D62A>               " 𝘪          : MATHEMATICAL SANS-SERIF ITALIC SMALL I
\\isansj                    <char-0x1D62B>               " 𝘫          : MATHEMATICAL SANS-SERIF ITALIC SMALL J
\\isansk                    <char-0x1D62C>               " 𝘬          : MATHEMATICAL SANS-SERIF ITALIC SMALL K
\\isansl                    <char-0x1D62D>               " 𝘭          : MATHEMATICAL SANS-SERIF ITALIC SMALL L
\\isansm                    <char-0x1D62E>               " 𝘮          : MATHEMATICAL SANS-SERIF ITALIC SMALL M
\\isansn                    <char-0x1D62F>               " 𝘯          : MATHEMATICAL SANS-SERIF ITALIC SMALL N
\\isanso                    <char-0x1D630>               " 𝘰          : MATHEMATICAL SANS-SERIF ITALIC SMALL O
\\isansp                    <char-0x1D631>               " 𝘱          : MATHEMATICAL SANS-SERIF ITALIC SMALL P
\\isansq                    <char-0x1D632>               " 𝘲          : MATHEMATICAL SANS-SERIF ITALIC SMALL Q
\\isansr                    <char-0x1D633>               " 𝘳          : MATHEMATICAL SANS-SERIF ITALIC SMALL R
\\isanss                    <char-0x1D634>               " 𝘴          : MATHEMATICAL SANS-SERIF ITALIC SMALL S
\\isanst                    <char-0x1D635>               " 𝘵          : MATHEMATICAL SANS-SERIF ITALIC SMALL T
\\isansu                    <char-0x1D636>               " 𝘶          : MATHEMATICAL SANS-SERIF ITALIC SMALL U
\\isansv                    <char-0x1D637>               " 𝘷          : MATHEMATICAL SANS-SERIF ITALIC SMALL V
\\isansw                    <char-0x1D638>               " 𝘸          : MATHEMATICAL SANS-SERIF ITALIC SMALL W
\\isansx                    <char-0x1D639>               " 𝘹          : MATHEMATICAL SANS-SERIF ITALIC SMALL X
\\isansy                    <char-0x1D63A>               " 𝘺          : MATHEMATICAL SANS-SERIF ITALIC SMALL Y
\\isansz                    <char-0x1D63B>               " 𝘻          : MATHEMATICAL SANS-SERIF ITALIC SMALL Z
\\isinE                     <char-0x022F9>               " ⋹          : ELEMENT OF WITH TWO HORIZONTAL STROKES
\\isindot                   <char-0x022F5>               " ⋵          : ELEMENT OF WITH DOT ABOVE
\\isinobar                  <char-0x022F7>               " ⋷          : SMALL ELEMENT OF WITH OVERBAR
\\isins                     <char-0x022F4>               " ⋴          : SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
\\isinvb                    <char-0x022F8>               " ⋸          : ELEMENT OF WITH UNDERBAR
\\itA                       <char-0x1D434>               " 𝐴          : MATHEMATICAL ITALIC CAPITAL A
\\itA<Tab>                  <char-0x1D434>               " 𝐴          : MATHEMATICAL ITALIC CAPITAL A
\\itAl                      \\itAl                       "            : (Incomplete sequence)
\\itAlpha                   <char-0x1D6E2>               " 𝛢          : MATHEMATICAL ITALIC CAPITAL ALPHA
\\itB                       <char-0x1D435>               " 𝐵          : MATHEMATICAL ITALIC CAPITAL B
\\itB<Tab>                  <char-0x1D435>               " 𝐵          : MATHEMATICAL ITALIC CAPITAL B
\\itBe                      \\itBe                       "            : (Incomplete sequence)
\\itBeta                    <char-0x1D6E3>               " 𝛣          : MATHEMATICAL ITALIC CAPITAL BETA
\\itC                       <char-0x1D436>               " 𝐶          : MATHEMATICAL ITALIC CAPITAL C
\\itC<Tab>                  <char-0x1D436>               " 𝐶          : MATHEMATICAL ITALIC CAPITAL C
\\itCh                      \\itCh                       "            : (Incomplete sequence)
\\itChi                     <char-0x1D6F8>               " 𝛸          : MATHEMATICAL ITALIC CAPITAL CHI
\\itD                       <char-0x1D437>               " 𝐷          : MATHEMATICAL ITALIC CAPITAL D
\\itD<Tab>                  <char-0x1D437>               " 𝐷          : MATHEMATICAL ITALIC CAPITAL D
\\itDe                      \\itDe                       "            : (Incomplete sequence)
\\itDelta                   <char-0x1D6E5>               " 𝛥          : MATHEMATICAL ITALIC CAPITAL DELTA
\\itE                       <char-0x1D438>               " 𝐸          : MATHEMATICAL ITALIC CAPITAL E
\\itE<Tab>                  <char-0x1D438>               " 𝐸          : MATHEMATICAL ITALIC CAPITAL E
\\itEp                      \\itEp                       "            : (Incomplete sequence)
\\itEpsilon                 <char-0x1D6E6>               " 𝛦          : MATHEMATICAL ITALIC CAPITAL EPSILON
\\itEt                      \\itEt                       "            : (Incomplete sequence)
\\itEta                     <char-0x1D6E8>               " 𝛨          : MATHEMATICAL ITALIC CAPITAL ETA
\\itF                       <char-0x1D439>               " 𝐹          : MATHEMATICAL ITALIC CAPITAL F
\\itG                       <char-0x1D43A>               " 𝐺          : MATHEMATICAL ITALIC CAPITAL G
\\itG<Tab>                  <char-0x1D43A>               " 𝐺          : MATHEMATICAL ITALIC CAPITAL G
\\itGa                      \\itGa                       "            : (Incomplete sequence)
\\itGamma                   <char-0x1D6E4>               " 𝛤          : MATHEMATICAL ITALIC CAPITAL GAMMA
\\itH                       <char-0x1D43B>               " 𝐻          : MATHEMATICAL ITALIC CAPITAL H
\\itI                       <char-0x1D43C>               " 𝐼          : MATHEMATICAL ITALIC CAPITAL I
\\itI<Tab>                  <char-0x1D43C>               " 𝐼          : MATHEMATICAL ITALIC CAPITAL I
\\itIo                      \\itIo                       "            : (Incomplete sequence)
\\itIota                    <char-0x1D6EA>               " 𝛪          : MATHEMATICAL ITALIC CAPITAL IOTA
\\itJ                       <char-0x1D43D>               " 𝐽          : MATHEMATICAL ITALIC CAPITAL J
\\itK                       <char-0x1D43E>               " 𝐾          : MATHEMATICAL ITALIC CAPITAL K
\\itK<Tab>                  <char-0x1D43E>               " 𝐾          : MATHEMATICAL ITALIC CAPITAL K
\\itKa                      \\itKa                       "            : (Incomplete sequence)
\\itKappa                   <char-0x1D6EB>               " 𝛫          : MATHEMATICAL ITALIC CAPITAL KAPPA
\\itL                       <char-0x1D43F>               " 𝐿          : MATHEMATICAL ITALIC CAPITAL L
\\itL<Tab>                  <char-0x1D43F>               " 𝐿          : MATHEMATICAL ITALIC CAPITAL L
\\itLa                      \\itLa                       "            : (Incomplete sequence)
\\itLambda                  <char-0x1D6EC>               " 𝛬          : MATHEMATICAL ITALIC CAPITAL LAMDA
\\itM                       <char-0x1D440>               " 𝑀          : MATHEMATICAL ITALIC CAPITAL M
\\itM<Tab>                  <char-0x1D440>               " 𝑀          : MATHEMATICAL ITALIC CAPITAL M
\\itMu                      <char-0x1D6ED>               " 𝛭          : MATHEMATICAL ITALIC CAPITAL MU
\\itN                       <char-0x1D441>               " 𝑁          : MATHEMATICAL ITALIC CAPITAL N
\\itN<Tab>                  <char-0x1D441>               " 𝑁          : MATHEMATICAL ITALIC CAPITAL N
\\itNu                      <char-0x1D6EE>               " 𝛮          : MATHEMATICAL ITALIC CAPITAL NU
\\itO                       <char-0x1D442>               " 𝑂          : MATHEMATICAL ITALIC CAPITAL O
\\itO<Tab>                  <char-0x1D442>               " 𝑂          : MATHEMATICAL ITALIC CAPITAL O
\\itOm                      \\itOm                       "            : (Incomplete sequence)
\\itOmega                   <char-0x1D6FA>               " 𝛺          : MATHEMATICAL ITALIC CAPITAL OMEGA
\\itOmicron                 <char-0x1D6F0>               " 𝛰          : MATHEMATICAL ITALIC CAPITAL OMICRON
\\itP                       <char-0x1D443>               " 𝑃          : MATHEMATICAL ITALIC CAPITAL P
\\itP<Tab>                  <char-0x1D443>               " 𝑃          : MATHEMATICAL ITALIC CAPITAL P
\\itPh                      \\itPh                       "            : (Incomplete sequence)
\\itPhi                     <char-0x1D6F7>               " 𝛷          : MATHEMATICAL ITALIC CAPITAL PHI
\\itPi                      <char-0x1D6F1>               " 𝛱          : MATHEMATICAL ITALIC CAPITAL PI
\\itPs                      \\itPs                       "            : (Incomplete sequence)
\\itPsi                     <char-0x1D6F9>               " 𝛹          : MATHEMATICAL ITALIC CAPITAL PSI
\\itQ                       <char-0x1D444>               " 𝑄          : MATHEMATICAL ITALIC CAPITAL Q
\\itR                       <char-0x1D445>               " 𝑅          : MATHEMATICAL ITALIC CAPITAL R
\\itR<Tab>                  <char-0x1D445>               " 𝑅          : MATHEMATICAL ITALIC CAPITAL R
\\itRh                      \\itRh                       "            : (Incomplete sequence)
\\itRho                     <char-0x1D6F2>               " 𝛲          : MATHEMATICAL ITALIC CAPITAL RHO
\\itS                       <char-0x1D446>               " 𝑆          : MATHEMATICAL ITALIC CAPITAL S
\\itS<Tab>                  <char-0x1D446>               " 𝑆          : MATHEMATICAL ITALIC CAPITAL S
\\itSi                      \\itSi                       "            : (Incomplete sequence)
\\itSigma                   <char-0x1D6F4>               " 𝛴          : MATHEMATICAL ITALIC CAPITAL SIGMA
\\itT                       <char-0x1D447>               " 𝑇          : MATHEMATICAL ITALIC CAPITAL T
\\itT<Tab>                  <char-0x1D447>               " 𝑇          : MATHEMATICAL ITALIC CAPITAL T
\\itTa                      \\itTa                       "            : (Incomplete sequence)
\\itTau                     <char-0x1D6F5>               " 𝛵          : MATHEMATICAL ITALIC CAPITAL TAU
\\itTh                      \\itTh                       "            : (Incomplete sequence)
\\itTheta                   <char-0x1D6E9>               " 𝛩          : MATHEMATICAL ITALIC CAPITAL THETA
\\itU                       <char-0x1D448>               " 𝑈          : MATHEMATICAL ITALIC CAPITAL U
\\itU<Tab>                  <char-0x1D448>               " 𝑈          : MATHEMATICAL ITALIC CAPITAL U
\\itUp                      \\itUp                       "            : (Incomplete sequence)
\\itUpsilon                 <char-0x1D6F6>               " 𝛶          : MATHEMATICAL ITALIC CAPITAL UPSILON
\\itV                       <char-0x1D449>               " 𝑉          : MATHEMATICAL ITALIC CAPITAL V
\\itW                       <char-0x1D44A>               " 𝑊          : MATHEMATICAL ITALIC CAPITAL W
\\itX                       <char-0x1D44B>               " 𝑋          : MATHEMATICAL ITALIC CAPITAL X
\\itX<Tab>                  <char-0x1D44B>               " 𝑋          : MATHEMATICAL ITALIC CAPITAL X
\\itXi                      <char-0x1D6EF>               " 𝛯          : MATHEMATICAL ITALIC CAPITAL XI
\\itY                       <char-0x1D44C>               " 𝑌          : MATHEMATICAL ITALIC CAPITAL Y
\\itZ                       <char-0x1D44D>               " 𝑍          : MATHEMATICAL ITALIC CAPITAL Z
\\itZ<Tab>                  <char-0x1D44D>               " 𝑍          : MATHEMATICAL ITALIC CAPITAL Z
\\itZe                      \\itZe                       "            : (Incomplete sequence)
\\itZeta                    <char-0x1D6E7>               " 𝛧          : MATHEMATICAL ITALIC CAPITAL ZETA
\\ita                       <char-0x1D44E>               " 𝑎          : MATHEMATICAL ITALIC SMALL A
\\ita<Tab>                  <char-0x1D44E>               " 𝑎          : MATHEMATICAL ITALIC SMALL A
\\ital                      \\ital                       "            : (Incomplete sequence)
\\italpha                   <char-0x1D6FC>               " 𝛼          : MATHEMATICAL ITALIC SMALL ALPHA
\\itb                       <char-0x1D44F>               " 𝑏          : MATHEMATICAL ITALIC SMALL B
\\itb<Tab>                  <char-0x1D44F>               " 𝑏          : MATHEMATICAL ITALIC SMALL B
\\itbe                      \\itbe                       "            : (Incomplete sequence)
\\itbeta                    <char-0x1D6FD>               " 𝛽          : MATHEMATICAL ITALIC SMALL BETA
\\itc                       <char-0x1D450>               " 𝑐          : MATHEMATICAL ITALIC SMALL C
\\itc<Tab>                  <char-0x1D450>               " 𝑐          : MATHEMATICAL ITALIC SMALL C
\\itch                      \\itch                       "            : (Incomplete sequence)
\\itchi                     <char-0x1D712>               " 𝜒          : MATHEMATICAL ITALIC SMALL CHI
\\itd                       <char-0x1D451>               " 𝑑          : MATHEMATICAL ITALIC SMALL D
\\itd<Tab>                  <char-0x1D451>               " 𝑑          : MATHEMATICAL ITALIC SMALL D
\\itde                      \\itde                       "            : (Incomplete sequence)
\\itdelta                   <char-0x1D6FF>               " 𝛿          : MATHEMATICAL ITALIC SMALL DELTA
\\ite                       <char-0x1D452>               " 𝑒          : MATHEMATICAL ITALIC SMALL E
\\ite<Tab>                  <char-0x1D452>               " 𝑒          : MATHEMATICAL ITALIC SMALL E
\\itep                      \\itep                       "            : (Incomplete sequence)
\\itepsilon                 <char-0x1D716>               " 𝜖          : MATHEMATICAL ITALIC EPSILON SYMBOL
\\itet                      \\itet                       "            : (Incomplete sequence)
\\iteta                     <char-0x1D702>               " 𝜂          : MATHEMATICAL ITALIC SMALL ETA
\\itf                       <char-0x1D453>               " 𝑓          : MATHEMATICAL ITALIC SMALL F
\\itg                       <char-0x1D454>               " 𝑔          : MATHEMATICAL ITALIC SMALL G
\\itg<Tab>                  <char-0x1D454>               " 𝑔          : MATHEMATICAL ITALIC SMALL G
\\itga                      \\itga                       "            : (Incomplete sequence)
\\itgamma                   <char-0x1D6FE>               " 𝛾          : MATHEMATICAL ITALIC SMALL GAMMA
\\ith                       <char-0x0210E>               " ℎ          : PLANCK CONSTANT
\\iti                       <char-0x1D456>               " 𝑖          : MATHEMATICAL ITALIC SMALL I
\\iti<Tab>                  <char-0x1D456>               " 𝑖          : MATHEMATICAL ITALIC SMALL I
\\itim                      \\itim                       "            : (Incomplete sequence)
\\itimath                   <char-0x1D6A4>               " 𝚤          : MATHEMATICAL ITALIC SMALL DOTLESS I
\\itio                      \\itio                       "            : (Incomplete sequence)
\\itiota                    <char-0x1D704>               " 𝜄          : MATHEMATICAL ITALIC SMALL IOTA
\\itj                       <char-0x1D457>               " 𝑗          : MATHEMATICAL ITALIC SMALL J
\\itj<Tab>                  <char-0x1D457>               " 𝑗          : MATHEMATICAL ITALIC SMALL J
\\itjm                      \\itjm                       "            : (Incomplete sequence)
\\itjmath                   <char-0x1D6A5>               " 𝚥          : MATHEMATICAL ITALIC SMALL DOTLESS J
\\itk                       <char-0x1D458>               " 𝑘          : MATHEMATICAL ITALIC SMALL K
\\itk<Tab>                  <char-0x1D458>               " 𝑘          : MATHEMATICAL ITALIC SMALL K
\\itka                      \\itka                       "            : (Incomplete sequence)
\\itkappa                   <char-0x1D705>               " 𝜅          : MATHEMATICAL ITALIC SMALL KAPPA
\\itl                       <char-0x1D459>               " 𝑙          : MATHEMATICAL ITALIC SMALL L
\\itl<Tab>                  <char-0x1D459>               " 𝑙          : MATHEMATICAL ITALIC SMALL L
\\itla                      \\itla                       "            : (Incomplete sequence)
\\itlambda                  <char-0x1D706>               " 𝜆          : MATHEMATICAL ITALIC SMALL LAMDA
\\itm                       <char-0x1D45A>               " 𝑚          : MATHEMATICAL ITALIC SMALL M
\\itm<Tab>                  <char-0x1D45A>               " 𝑚          : MATHEMATICAL ITALIC SMALL M
\\itmu                      <char-0x1D707>               " 𝜇          : MATHEMATICAL ITALIC SMALL MU
\\itn                       <char-0x1D45B>               " 𝑛          : MATHEMATICAL ITALIC SMALL N
\\itn<Tab>                  <char-0x1D45B>               " 𝑛          : MATHEMATICAL ITALIC SMALL N
\\itna                      \\itna                       "            : (Incomplete sequence)
\\itnabla                   <char-0x1D6FB>               " 𝛻          : MATHEMATICAL ITALIC NABLA
\\itnu                      <char-0x1D708>               " 𝜈          : MATHEMATICAL ITALIC SMALL NU
\\ito                       <char-0x1D45C>               " 𝑜          : MATHEMATICAL ITALIC SMALL O
\\ito<Tab>                  <char-0x1D45C>               " 𝑜          : MATHEMATICAL ITALIC SMALL O
\\itom                      \\itom                       "            : (Incomplete sequence)
\\itomega                   <char-0x1D714>               " 𝜔          : MATHEMATICAL ITALIC SMALL OMEGA
\\itomicron                 <char-0x1D70A>               " 𝜊          : MATHEMATICAL ITALIC SMALL OMICRON
\\itp                       <char-0x1D45D>               " 𝑝          : MATHEMATICAL ITALIC SMALL P
\\itp<Tab>                  <char-0x1D45D>               " 𝑝          : MATHEMATICAL ITALIC SMALL P
\\itpa                      \\itpa                       "            : (Incomplete sequence)
\\itpartial                 <char-0x1D715>               " 𝜕          : MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
\\itph                      \\itph                       "            : (Incomplete sequence)
\\itphi                     <char-0x1D719>               " 𝜙          : MATHEMATICAL ITALIC PHI SYMBOL
\\itpi                      <char-0x1D70B>               " 𝜋          : MATHEMATICAL ITALIC SMALL PI
\\itps                      \\itps                       "            : (Incomplete sequence)
\\itpsi                     <char-0x1D713>               " 𝜓          : MATHEMATICAL ITALIC SMALL PSI
\\itq                       <char-0x1D45E>               " 𝑞          : MATHEMATICAL ITALIC SMALL Q
\\itr                       <char-0x1D45F>               " 𝑟          : MATHEMATICAL ITALIC SMALL R
\\itr<Tab>                  <char-0x1D45F>               " 𝑟          : MATHEMATICAL ITALIC SMALL R
\\itrh                      \\itrh                       "            : (Incomplete sequence)
\\itrho                     <char-0x1D70C>               " 𝜌          : MATHEMATICAL ITALIC SMALL RHO
\\its                       <char-0x1D460>               " 𝑠          : MATHEMATICAL ITALIC SMALL S
\\its<Tab>                  <char-0x1D460>               " 𝑠          : MATHEMATICAL ITALIC SMALL S
\\itsi                      \\itsi                       "            : (Incomplete sequence)
\\itsigma                   <char-0x1D70E>               " 𝜎          : MATHEMATICAL ITALIC SMALL SIGMA
\\itt                       <char-0x1D461>               " 𝑡          : MATHEMATICAL ITALIC SMALL T
\\itt<Tab>                  <char-0x1D461>               " 𝑡          : MATHEMATICAL ITALIC SMALL T
\\itta                      \\itta                       "            : (Incomplete sequence)
\\ittau                     <char-0x1D70F>               " 𝜏          : MATHEMATICAL ITALIC SMALL TAU
\\itth                      \\itth                       "            : (Incomplete sequence)
\\ittheta                   <char-0x1D703>               " 𝜃          : MATHEMATICAL ITALIC SMALL THETA
\\itu                       <char-0x1D462>               " 𝑢          : MATHEMATICAL ITALIC SMALL U
\\itu<Tab>                  <char-0x1D462>               " 𝑢          : MATHEMATICAL ITALIC SMALL U
\\itup                      \\itup                       "            : (Incomplete sequence)
\\itupsilon                 <char-0x1D710>               " 𝜐          : MATHEMATICAL ITALIC SMALL UPSILON
\\itv                       <char-0x1D463>               " 𝑣          : MATHEMATICAL ITALIC SMALL V
\\itv<Tab>                  <char-0x1D463>               " 𝑣          : MATHEMATICAL ITALIC SMALL V
\\itva                      \\itva                       "            : (Incomplete sequence)
\\itvarTheta                <char-0x1D6F3>               " 𝛳          : MATHEMATICAL ITALIC CAPITAL THETA SYMBOL
\\itvarepsilon              <char-0x1D700>               " 𝜀          : MATHEMATICAL ITALIC SMALL EPSILON
\\itvarkappa                <char-0x1D718>               " 𝜘          : MATHEMATICAL ITALIC KAPPA SYMBOL
\\itvarphi                  <char-0x1D711>               " 𝜑          : MATHEMATICAL ITALIC SMALL PHI
\\itvarpi                   <char-0x1D71B>               " 𝜛          : MATHEMATICAL ITALIC PI SYMBOL
\\itvarrho                  <char-0x1D71A>               " 𝜚          : MATHEMATICAL ITALIC RHO SYMBOL
\\itvarsigma                <char-0x1D70D>               " 𝜍          : MATHEMATICAL ITALIC SMALL FINAL SIGMA
\\itvartheta                <char-0x1D717>               " 𝜗          : MATHEMATICAL ITALIC THETA SYMBOL
\\itw                       <char-0x1D464>               " 𝑤          : MATHEMATICAL ITALIC SMALL W
\\itx                       <char-0x1D465>               " 𝑥          : MATHEMATICAL ITALIC SMALL X
\\itx<Tab>                  <char-0x1D465>               " 𝑥          : MATHEMATICAL ITALIC SMALL X
\\itxi                      <char-0x1D709>               " 𝜉          : MATHEMATICAL ITALIC SMALL XI
\\ity                       <char-0x1D466>               " 𝑦          : MATHEMATICAL ITALIC SMALL Y
\\itz                       <char-0x1D467>               " 𝑧          : MATHEMATICAL ITALIC SMALL Z
\\itz<Tab>                  <char-0x1D467>               " 𝑧          : MATHEMATICAL ITALIC SMALL Z
\\itze                      \\itze                       "            : (Incomplete sequence)
\\itzeta                    <char-0x1D701>               " 𝜁          : MATHEMATICAL ITALIC SMALL ZETA
\\jmath                     <char-0x00237>               " ȷ          : LATIN SMALL LETTER DOTLESS J
\\join                      <char-0x02A1D>               " ⨝          : JOIN
\\jupiter                   <char-0x02643>               " ♃          : JUPITER
\\k                         <char-0x00328>               " ◌̨          : COMBINING OGONEK / NON-SPACING OGONEK
\\k<Tab>                    <char-0x00328>               " ◌̨          : COMBINING OGONEK / NON-SPACING OGONEK
\\ka                        \\ka                         "            : (Incomplete sequence)
\\kappa                     <char-0x003BA>               " κ          : GREEK SMALL LETTER KAPPA
\\ke                        \\ke                         "            : (Incomplete sequence)
\\kernelcontraction         <char-0x0223B>               " ∻          : HOMOTHETIC
\\ko                        \\ko                         "            : (Incomplete sequence)
\\koppa                     <char-0x003DF>               " ϟ          : GREEK SMALL LETTER KOPPA
\\l                         <char-0x00142>               " ł          : LATIN SMALL LETTER L WITH STROKE / LATIN SMALL LETTER L SLASH
\\l<Tab>                    <char-0x00142>               " ł          : LATIN SMALL LETTER L WITH STROKE / LATIN SMALL LETTER L SLASH
\\la                        \\la                         "            : (Incomplete sequence)
\\lambda                    <char-0x003BB>               " λ          : GREEK SMALL LETTER LAMDA / GREEK SMALL LETTER LAMBDA
\\langle                    <char-0x027E8>               " ⟨          : MATHEMATICAL LEFT ANGLE BRACKET
\\lat                       <char-0x02AAB>               " ⪫          : LARGER THAN
\\lat<Tab>                  <char-0x02AAB>               " ⪫          : LARGER THAN
\\late                      <char-0x02AAD>               " ⪭          : LARGER THAN OR EQUAL TO
\\lazysinv                  <char-0x0223E>               " ∾          : INVERTED LAZY S
\\lc                        \\lc                         "            : (Incomplete sequence)
\\lceil                     <char-0x02308>               " ⌈          : LEFT CEILING
\\ld                        \\ld                         "            : (Incomplete sequence)
\\ldots                     <char-0x02026>               " …          : HORIZONTAL ELLIPSIS
\\ldq                       <char-0x0201C>               " “          : LEFT DOUBLE QUOTATION MARK / DOUBLE TURNED COMMA QUOTATION MARK
\\le                        <char-0x02264>               " ≤          : LESS-THAN OR EQUAL TO / LESS THAN OR EQUAL TO
\\le<Tab>                   <char-0x02264>               " ≤          : LESS-THAN OR EQUAL TO / LESS THAN OR EQUAL TO
\\lef                       \\lef                        "            : (Incomplete sequence)
\\leftarrow                 <char-0x02190>               " ←          : LEFTWARDS ARROW / LEFT ARROW
\\leftarrow<Tab>            <char-0x02190>               " ←          : LEFTWARDS ARROW / LEFT ARROW
\\leftarrowa                \\leftarrowa                 "            : (Incomplete sequence)
\\leftarrowapprox           <char-0x02B4A>               " ⭊          : LEFTWARDS ARROW ABOVE ALMOST EQUAL TO
\\leftarrowb                \\leftarrowb                 "            : (Incomplete sequence)
\\leftarrowbackapprox       <char-0x02B42>               " ⭂          : LEFTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO
\\leftarrowbsimilar         <char-0x02B4B>               " ⭋          : LEFTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
\\leftarrowl                \\leftarrowl                 "            : (Incomplete sequence)
\\leftarrowless             <char-0x02977>               " ⥷          : LEFTWARDS ARROW THROUGH LESS-THAN
\\leftarrowo                \\leftarrowo                 "            : (Incomplete sequence)
\\leftarrowonoplus          <char-0x02B32>               " ⬲          : LEFT ARROW WITH CIRCLED PLUS
\\leftarrowp                \\leftarrowp                 "            : (Incomplete sequence)
\\leftarrowplus             <char-0x02946>               " ⥆          : LEFTWARDS ARROW WITH PLUS BELOW
\\leftarrows                \\leftarrows                 "            : (Incomplete sequence)
\\leftarrowsubset           <char-0x0297A>               " ⥺          : LEFTWARDS ARROW THROUGH SUBSET
\\leftarrowt                \\leftarrowt                 "            : (Incomplete sequence)
\\leftarrowtail             <char-0x021A2>               " ↢          : LEFTWARDS ARROW WITH TAIL / LEFT ARROW WITH TAIL
\\leftarrowtriangle         <char-0x021FD>               " ⇽          : LEFTWARDS OPEN-HEADED ARROW
\\leftarrowx                <char-0x02B3E>               " ⬾          : LEFTWARDS ARROW THROUGH X
\\leftbkarrow               <char-0x0290C>               " ⤌          : LEFTWARDS DOUBLE DASH ARROW
\\leftcurvedarrow           <char-0x02B3F>               " ⬿          : WAVE ARROW POINTING DIRECTLY LEFT
\\leftdasharrow             <char-0x021E0>               " ⇠          : LEFTWARDS DASHED ARROW / LEFT DASHED ARROW
\\leftdbkarrow              <char-0x0290E>               " ⤎          : LEFTWARDS TRIPLE DASH ARROW
\\leftdotarrow              <char-0x02B38>               " ⬸          : LEFTWARDS ARROW WITH DOTTED STEM
\\leftharpoonaccent         <char-0x020D0>               " ◌⃐          : COMBINING LEFT HARPOON ABOVE / NON-SPACING LEFT HARPOON ABOVE
\\leftharpoondown           <char-0x021BD>               " ↽          : LEFTWARDS HARPOON WITH BARB DOWNWARDS / LEFT HARPOON WITH BARB DOWN
\\leftharpoonsupdown        <char-0x02962>               " ⥢          : LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN
\\leftharpoonup             <char-0x021BC>               " ↼          : LEFTWARDS HARPOON WITH BARB UPWARDS / LEFT HARPOON WITH BARB UP
\\leftharpoonup<Tab>        <char-0x021BC>               " ↼          : LEFTWARDS HARPOON WITH BARB UPWARDS / LEFT HARPOON WITH BARB UP
\\leftharpoonupd            \\leftharpoonupd             "            : (Incomplete sequence)
\\leftharpoonupdash         <char-0x0296A>               " ⥪          : LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
\\leftleftarrows            <char-0x021C7>               " ⇇          : LEFTWARDS PAIRED ARROWS / LEFT PAIRED ARROWS
\\leftmoon                  <char-0x0263E>               " ☾          : LAST QUARTER MOON
\\leftouterjoin             <char-0x027D5>               " ⟕          : LEFT OUTER JOIN
\\leftrightarrow            <char-0x02194>               " ↔          : LEFT RIGHT ARROW
\\leftrightarrow<Tab>       <char-0x02194>               " ↔          : LEFT RIGHT ARROW
\\leftrightarrowc           \\leftrightarrowc            "            : (Incomplete sequence)
\\leftrightarrowcircle      <char-0x02948>               " ⥈          : LEFT RIGHT ARROW THROUGH SMALL CIRCLE
\\leftrightarrows           <char-0x021C6>               " ⇆          : LEFTWARDS ARROW OVER RIGHTWARDS ARROW / LEFT ARROW OVER RIGHT ARROW
\\leftrightarrowt           \\leftrightarrowt            "            : (Incomplete sequence)
\\leftrightarrowtriangle    <char-0x021FF>               " ⇿          : LEFT RIGHT OPEN-HEADED ARROW
\\leftrightharpoondownup    <char-0x0294B>               " ⥋          : LEFT BARB DOWN RIGHT BARB UP HARPOON
\\leftrightharpoons         <char-0x021CB>               " ⇋          : LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON / LEFT HARPOON OVER RIGHT HARPOON
\\leftrightharpoons<Tab>    <char-0x021CB>               " ⇋          : LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON / LEFT HARPOON OVER RIGHT HARPOON
\\leftrightharpoonsd        \\leftrightharpoonsd         "            : (Incomplete sequence)
\\leftrightharpoonsdown     <char-0x02967>               " ⥧          : LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
\\leftrightharpoonsu        \\leftrightharpoonsu         "            : (Incomplete sequence)
\\leftrightharpoonsup       <char-0x02966>               " ⥦          : LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP
\\leftrightharpoonupdown    <char-0x0294A>               " ⥊          : LEFT BARB UP RIGHT BARB DOWN HARPOON
\\leftrightsquigarrow       <char-0x021AD>               " ↭          : LEFT RIGHT WAVE ARROW
\\leftsquigarrow            <char-0x021DC>               " ⇜          : LEFTWARDS SQUIGGLE ARROW / LEFT SQUIGGLE ARROW
\\leftthreearrows           <char-0x02B31>               " ⬱          : THREE LEFTWARDS ARROWS
\\leftthreetimes            <char-0x022CB>               " ⋋          : LEFT SEMIDIRECT PRODUCT
\\leftwavearrow             <char-0x0219C>               " ↜          : LEFTWARDS WAVE ARROW / LEFT WAVE ARROW
\\leftwhitearrow            <char-0x021E6>               " ⇦          : LEFTWARDS WHITE ARROW / WHITE LEFT ARROW
\\leo                       <char-0x0264C>               " ♌         : LEO
\\leq                       <char-0x02264>               " ≤          : LESS-THAN OR EQUAL TO / LESS THAN OR EQUAL TO
\\leq<Tab>                  <char-0x02264>               " ≤          : LESS-THAN OR EQUAL TO / LESS THAN OR EQUAL TO
\\leqq                      <char-0x02266>               " ≦          : LESS-THAN OVER EQUAL TO / LESS THAN OVER EQUAL TO
\\leqq<Tab>                 <char-0x02266>               " ≦          : LESS-THAN OVER EQUAL TO / LESS THAN OVER EQUAL TO
\\leqqs                     \\leqqs                      "            : (Incomplete sequence)
\\leqqslant                 <char-0x02AF9>               " ⫹          : DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO
\\leqs                      \\leqs                       "            : (Incomplete sequence)
\\leqslant                  <char-0x02A7D>               " ⩽          : LESS-THAN OR SLANTED EQUAL TO
\\les                       \\les                        "            : (Incomplete sequence)
\\lescc                     <char-0x02AA8>               " ⪨          : LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
\\lesdot                    <char-0x02A7F>               " ⩿          : LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
\\lesdot<Tab>               <char-0x02A7F>               " ⩿          : LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
\\lesdoto                   <char-0x02A81>               " ⪁          : LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
\\lesdoto<Tab>              <char-0x02A81>               " ⪁          : LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
\\lesdotor                  <char-0x02A83>               " ⪃          : LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT
\\lesges                    <char-0x02A93>               " ⪓          : LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL
\\lessapprox                <char-0x02A85>               " ⪅          : LESS-THAN OR APPROXIMATE
\\lessdot                   <char-0x022D6>               " ⋖          : LESS-THAN WITH DOT / LESS THAN WITH DOT
\\lesseqgtr                 <char-0x022DA>               " ⋚          : LESS-THAN EQUAL TO OR GREATER-THAN / LESS THAN EQUAL TO OR GREATER THAN
\\lesseqqgtr                <char-0x02A8B>               " ⪋          : LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN
\\lessgtr                   <char-0x02276>               " ≶          : LESS-THAN OR GREATER-THAN / LESS THAN OR GREATER THAN
\\lesssim                   <char-0x02272>               " ≲          : LESS-THAN OR EQUIVALENT TO / LESS THAN OR EQUIVALENT TO
\\lf                        \\lf                         "            : (Incomplete sequence)
\\lfloor                    <char-0x0230A>               " ⌊          : LEFT FLOOR
\\lg                        \\lg                         "            : (Incomplete sequence)
\\lgE                       <char-0x02A91>               " ⪑          : LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL
\\lgblkcircle               <char-0x02B24>               " ⬤          : BLACK LARGE CIRCLE
\\lgblksquare               <char-0x02B1B>               " ⬛         : BLACK LARGE SQUARE
\\lgwhtcircle               <char-0x025EF>               " ◯          : LARGE CIRCLE
\\lgwhtsquare               <char-0x02B1C>               " ⬜         : WHITE LARGE SQUARE
\\li                        \\li                         "            : (Incomplete sequence)
\\libra                     <char-0x0264E>               " ♎         : LIBRA
\\linefeed                  <char-0x021B4>               " ↴          : RIGHTWARDS ARROW WITH CORNER DOWNWARDS / RIGHT ARROW WITH CORNER DOWN
\\ll                        <char-0x0226A>               " ≪          : MUCH LESS-THAN / MUCH LESS THAN
\\ll<Tab>                   <char-0x0226A>               " ≪          : MUCH LESS-THAN / MUCH LESS THAN
\\lla                       \\lla                        "            : (Incomplete sequence)
\\llarc                     <char-0x025DF>               " ◟          : LOWER LEFT QUADRANT CIRCULAR ARC
\\llb                       \\llb                        "            : (Incomplete sequence)
\\llblacktriangle           <char-0x025E3>               " ◣          : BLACK LOWER LEFT TRIANGLE
\\llbracket                 <char-0x027E6>               " ⟦          : MATHEMATICAL LEFT WHITE SQUARE BRACKET
\\llc                       \\llc                        "            : (Incomplete sequence)
\\llcorner                  <char-0x0231E>               " ⌞          : BOTTOM LEFT CORNER
\\lll                       \\lll                        "            : (Incomplete sequence)
\\lllnest                   <char-0x02AF7>               " ⫷          : TRIPLE NESTED LESS-THAN
\\llt                       \\llt                        "            : (Incomplete sequence)
\\lltriangle                <char-0x025FA>               " ◺          : LOWER LEFT TRIANGLE
\\lm                        \\lm                         "            : (Incomplete sequence)
\\lmoustache                <char-0x023B0>               " ⎰          : UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION
\\lmrk                      <char-0x002D0>               " ː          : MODIFIER LETTER TRIANGULAR COLON
\\ln                        \\ln                         "            : (Incomplete sequence)
\\lnapprox                  <char-0x02A89>               " ⪉          : LESS-THAN AND NOT APPROXIMATE
\\lneq                      <char-0x02A87>               " ⪇          : LESS-THAN AND SINGLE-LINE NOT EQUAL TO
\\lneq<Tab>                 <char-0x02A87>               " ⪇          : LESS-THAN AND SINGLE-LINE NOT EQUAL TO
\\lneqq                     <char-0x02268>               " ≨          : LESS-THAN BUT NOT EQUAL TO / LESS THAN BUT NOT EQUAL TO
\\lnsim                     <char-0x022E6>               " ⋦          : LESS-THAN BUT NOT EQUIVALENT TO / LESS THAN BUT NOT EQUIVALENT TO
\\lo                        \\lo                         "            : (Incomplete sequence)
\\longleftarrow             <char-0x027F5>               " ⟵          : LONG LEFTWARDS ARROW
\\longleftrightarrow        <char-0x027F7>               " ⟷          : LONG LEFT RIGHT ARROW
\\longleftsquigarrow        <char-0x02B33>               " ⬳          : LONG LEFTWARDS SQUIGGLE ARROW
\\longmapsfrom              <char-0x027FB>               " ⟻          : LONG LEFTWARDS ARROW FROM BAR
\\longmapsto                <char-0x027FC>               " ⟼          : LONG RIGHTWARDS ARROW FROM BAR
\\longrightarrow            <char-0x027F6>               " ⟶          : LONG RIGHTWARDS ARROW
\\longrightsquigarrow       <char-0x027FF>               " ⟿          : LONG RIGHTWARDS SQUIGGLE ARROW
\\looparrowleft             <char-0x021AB>               " ↫          : LEFTWARDS ARROW WITH LOOP / LEFT ARROW WITH LOOP
\\looparrowright            <char-0x021AC>               " ↬          : RIGHTWARDS ARROW WITH LOOP / RIGHT ARROW WITH LOOP
\\low                       <char-0x002D5>               " ˕          : MODIFIER LETTER DOWN TACK
\\low<Tab>                  <char-0x002D5>               " ˕          : MODIFIER LETTER DOWN TACK
\\lowi                      \\lowi                       "            : (Incomplete sequence)
\\lowint                    <char-0x02A1C>               " ⨜          : INTEGRAL WITH UNDERBAR
\\lozenge                   <char-0x025CA>               " ◊          : LOZENGE
\\lp                        \\lp                         "            : (Incomplete sequence)
\\lpargt                    <char-0x029A0>               " ⦠          : SPHERICAL ANGLE OPENING LEFT
\\lq                        <char-0x02018>               " ‘          : LEFT SINGLE QUOTATION MARK / SINGLE TURNED COMMA QUOTATION MARK
\\lr                        \\lr                         "            : (Incomplete sequence)
\\lrarc                     <char-0x025DE>               " ◞          : LOWER RIGHT QUADRANT CIRCULAR ARC
\\lrblacktriangle           <char-0x025E2>               " ◢          : BLACK LOWER RIGHT TRIANGLE
\\lrcorner                  <char-0x0231F>               " ⌟          : BOTTOM RIGHT CORNER
\\lrtriangle                <char-0x025FF>               " ◿          : LOWER RIGHT TRIANGLE
\\lrtriangle<Tab>           <char-0x025FF>               " ◿          : LOWER RIGHT TRIANGLE
\\lrtrianglee               \\lrtrianglee                "            : (Incomplete sequence)
\\lrtriangleeq              <char-0x029E1>               " ⧡          : INCREASES AS
\\ls                        \\ls                         "            : (Incomplete sequence)
\\lsime                     <char-0x02A8D>               " ⪍          : LESS-THAN ABOVE SIMILAR OR EQUAL
\\lsimg                     <char-0x02A8F>               " ⪏          : LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN
\\lsqhook                   <char-0x02ACD>               " ⫍          : SQUARE LEFT OPEN BOX OPERATOR
\\lt                        \\lt                         "            : (Incomplete sequence)
\\ltcc                      <char-0x02AA6>               " ⪦          : LESS-THAN CLOSED BY CURVE
\\ltcir                     <char-0x02A79>               " ⩹          : LESS-THAN WITH CIRCLE INSIDE
\\ltimes                    <char-0x022C9>               " ⋉          : LEFT NORMAL FACTOR SEMIDIRECT PRODUCT
\\ltlmr                     <char-0x00271>               " ɱ          : LATIN SMALL LETTER M WITH HOOK / LATIN SMALL LETTER M HOOK
\\ltln                      <char-0x00272>               " ɲ          : LATIN SMALL LETTER N WITH LEFT HOOK / LATIN SMALL LETTER N HOOK
\\ltphi                     <char-0x00278>               " ɸ          : LATIN SMALL LETTER PHI
\\ltquest                   <char-0x02A7B>               " ⩻          : LESS-THAN WITH QUESTION MARK ABOVE
\\lv                        \\lv                         "            : (Incomplete sequence)
\\lvboxline                 <char-0x023B8>               " ⎸          : LEFT VERTICAL BOX LINE
\\lvertneqq                 <char-0x02268><char-0x0FE00> " ≨︀          : LESS-THAN BUT NOT EQUAL TO / LESS THAN BUT NOT EQUAL TO + VARIATION SELECTOR-1
\\male                      <char-0x02642>               " ♂          : MALE SIGN
\\maltese                   <char-0x02720>               " ✠          : MALTESE CROSS
\\mapsdown                  <char-0x021A7>               " ↧          : DOWNWARDS ARROW FROM BAR / DOWN ARROW FROM BAR
\\mapsfrom                  <char-0x021A4>               " ↤          : LEFTWARDS ARROW FROM BAR / LEFT ARROW FROM BAR
\\mapsto                    <char-0x021A6>               " ↦          : RIGHTWARDS ARROW FROM BAR / RIGHT ARROW FROM BAR
\\mapsup                    <char-0x021A5>               " ↥          : UPWARDS ARROW FROM BAR / UP ARROW FROM BAR
\\mars                      <char-0x02642>               " ♂          : MALE SIGN
\\mdblkcircle               <char-0x026AB>               " ⚫         : MEDIUM BLACK CIRCLE
\\mdblkdiamond              <char-0x02B25>               " ⬥          : BLACK MEDIUM DIAMOND
\\mdblklozenge              <char-0x02B27>               " ⬧          : BLACK MEDIUM LOZENGE
\\mdblksquare               <char-0x025FC>               " ◼          : BLACK MEDIUM SQUARE
\\mdlgblkcircle             <char-0x025CF>               " ●          : BLACK CIRCLE
\\mdlgblkdiamond            <char-0x025C6>               " ◆          : BLACK DIAMOND
\\mdlgwhtdiamond            <char-0x025C7>               " ◇          : WHITE DIAMOND
\\mdsmblksquare             <char-0x025FE>               " ◾         : BLACK MEDIUM SMALL SQUARE
\\mdsmwhtcircle             <char-0x026AC>               " ⚬          : MEDIUM SMALL WHITE CIRCLE
\\mdsmwhtsquare             <char-0x025FD>               " ◽         : WHITE MEDIUM SMALL SQUARE
\\mdwhtcircle               <char-0x026AA>               " ⚪         : MEDIUM WHITE CIRCLE
\\mdwhtdiamond              <char-0x02B26>               " ⬦          : WHITE MEDIUM DIAMOND
\\mdwhtlozenge              <char-0x02B28>               " ⬨          : WHITE MEDIUM LOZENGE
\\mdwhtsquare               <char-0x025FB>               " ◻          : WHITE MEDIUM SQUARE
\\measangledltosw           <char-0x029AF>               " ⦯          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN
\\measangledrtose           <char-0x029AE>               " ⦮          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN
\\measangleldtosw           <char-0x029AB>               " ⦫          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT
\\measanglelutonw           <char-0x029A9>               " ⦩          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT
\\measanglerdtose           <char-0x029AA>               " ⦪          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT
\\measanglerutone           <char-0x029A8>               " ⦨          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT
\\measangleultonw           <char-0x029AD>               " ⦭          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP
\\measangleurtone           <char-0x029AC>               " ⦬          : MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP
\\measeq                    <char-0x0225E>               " ≞          : MEASURED BY
\\measuredangle             <char-0x02221>               " ∡          : MEASURED ANGLE
\\measuredangle<Tab>        <char-0x02221>               " ∡          : MEASURED ANGLE
\\measuredanglel            \\measuredanglel             "            : (Incomplete sequence)
\\measuredangleleft         <char-0x0299B>               " ⦛          : MEASURED ANGLE OPENING LEFT
\\medblackstar              <char-0x02B51>               " ⭑          : BLACK SMALL STAR
\\medwhitestar              <char-0x02B50>               " ⭐         : WHITE MEDIUM STAR
\\mercury                   <char-0x0263F>               " ☿          : MERCURY
\\mho                       <char-0x02127>               " ℧          : INVERTED OHM SIGN / MHO
\\mid                       <char-0x02223>               " ∣          : DIVIDES
\\mid<Tab>                  <char-0x02223>               " ∣          : DIVIDES
\\midb                      \\midb                       "            : (Incomplete sequence)
\\midbarvee                 <char-0x02A5D>               " ⩝          : LOGICAL OR WITH HORIZONTAL DASH
\\midbarwedge               <char-0x02A5C>               " ⩜          : LOGICAL AND WITH HORIZONTAL DASH
\\minhat                    <char-0x02A5F>               " ⩟          : LOGICAL AND WITH UNDERBAR
\\minus                     <char-0x02212>               " −          : MINUS SIGN
\\minus<Tab>                <char-0x02212>               " −          : MINUS SIGN
\\minusd                    \\minusd                     "            : (Incomplete sequence)
\\minusdot                  <char-0x02A2A>               " ⨪          : MINUS SIGN WITH DOT BELOW
\\minusf                    \\minusf                     "            : (Incomplete sequence)
\\minusfdots                <char-0x02A2B>               " ⨫          : MINUS SIGN WITH FALLING DOTS
\\minusr                    \\minusr                     "            : (Incomplete sequence)
\\minusrdots                <char-0x02A2C>               " ⨬          : MINUS SIGN WITH RISING DOTS
\\mlcp                      <char-0x02ADB>               " ⫛          : TRANSVERSAL INTERSECTION
\\models                    <char-0x022A7>               " ⊧          : MODELS
\\modtwosum                 <char-0x02A0A>               " ⨊          : MODULO TWO SUM
\\mp                        <char-0x02213>               " ∓          : MINUS-OR-PLUS SIGN
\\mu                        <char-0x003BC>               " μ          : GREEK SMALL LETTER MU
\\mu<Tab>                   <char-0x003BC>               " μ          : GREEK SMALL LETTER MU
\\mul                       \\mul                        "            : (Incomplete sequence)
\\multimap                  <char-0x022B8>               " ⊸          : MULTIMAP
\\nBumpeq                   <char-0x0224E><char-0x00338> " ≎̸          : GEOMETRICALLY EQUIVALENT TO + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nHdownarrow               <char-0x021DF>               " ⇟          : DOWNWARDS ARROW WITH DOUBLE STROKE / DOWN ARROW WITH DOUBLE STROKE
\\nHuparrow                 <char-0x021DE>               " ⇞          : UPWARDS ARROW WITH DOUBLE STROKE / UP ARROW WITH DOUBLE STROKE
\\nLeftarrow                <char-0x021CD>               " ⇍          : LEFTWARDS DOUBLE ARROW WITH STROKE / LEFT DOUBLE ARROW WITH STROKE
\\nLeftrightarrow           <char-0x021CE>               " ⇎          : LEFT RIGHT DOUBLE ARROW WITH STROKE
\\nRightarrow               <char-0x021CF>               " ⇏          : RIGHTWARDS DOUBLE ARROW WITH STROKE / RIGHT DOUBLE ARROW WITH STROKE
\\nVDash                    <char-0x022AF>               " ⊯          : NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
\\nVdash                    <char-0x022AE>               " ⊮          : DOES NOT FORCE
\\nVleftarrow               <char-0x021FA>               " ⇺          : LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE
\\nVleftarrow<Tab>          <char-0x021FA>               " ⇺          : LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE
\\nVleftarrowt              \\nVleftarrowt               "            : (Incomplete sequence)
\\nVleftarrowtail           <char-0x02B3A>               " ⬺          : LEFTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
\\nVleftrightarrow          <char-0x021FC>               " ⇼          : LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE
\\nVrightarrow              <char-0x021FB>               " ⇻          : RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE
\\nVrightarrow<Tab>         <char-0x021FB>               " ⇻          : RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE
\\nVrightarrowt             \\nVrightarrowt              "            : (Incomplete sequence)
\\nVrightarrowtail          <char-0x02915>               " ⤕          : RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
\\nVtwoheadleftarrow        <char-0x02B35>               " ⬵          : LEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
\\nVtwoheadleftarrow<Tab>   <char-0x02B35>               " ⬵          : LEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
\\nVtwoheadleftarrowt       \\nVtwoheadleftarrowt        "            : (Incomplete sequence)
\\nVtwoheadleftarrowtail    <char-0x02B3D>               " ⬽          : LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
\\nVtwoheadrightarrow       <char-0x02901>               " ⤁          : RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
\\nVtwoheadrightarrow<Tab>  <char-0x02901>               " ⤁          : RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
\\nVtwoheadrightarrowt      \\nVtwoheadrightarrowt       "            : (Incomplete sequence)
\\nVtwoheadrightarrowtail   <char-0x02918>               " ⤘          : RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
\\nabla                     <char-0x02207>               " ∇          : NABLA
\\nand                      <char-0x022BC>               " ⊼          : NAND
\\napprox                   <char-0x02249>               " ≉          : NOT ALMOST EQUAL TO
\\nasymp                    <char-0x0226D>               " ≭          : NOT EQUIVALENT TO
\\natural                   <char-0x0266E>               " ♮          : MUSIC NATURAL SIGN / NATURAL
\\nbumpeq                   <char-0x0224F><char-0x00338> " ≏̸          : DIFFERENCE BETWEEN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\ncong                     <char-0x02247>               " ≇          : NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
\\ne                        <char-0x02260>               " ≠          : NOT EQUAL TO
\\ne<Tab>                   <char-0x02260>               " ≠          : NOT EQUAL TO
\\nea                       \\nea                        "            : (Incomplete sequence)
\\nearrow                   <char-0x02197>               " ↗          : NORTH EAST ARROW / UPPER RIGHT ARROW
\\neg                       <char-0x000AC>               " ¬          : NOT SIGN
\\neo                       \\neo                        "            : (Incomplete sequence)
\\neovnwarrow               <char-0x02931>               " ⤱          : NORTH EAST ARROW CROSSING NORTH WEST ARROW
\\neovsearrow               <char-0x0292E>               " ⤮          : NORTH EAST ARROW CROSSING SOUTH EAST ARROW
\\nep                       \\nep                        "            : (Incomplete sequence)
\\neptune                   <char-0x02646>               " ♆          : NEPTUNE
\\neq                       <char-0x02260>               " ≠          : NOT EQUAL TO
\\neq<Tab>                  <char-0x02260>               " ≠          : NOT EQUAL TO
\\neqs                      \\neqs                       "            : (Incomplete sequence)
\\neqsim                    <char-0x02242><char-0x00338> " ≂̸          : MINUS TILDE + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nequ                      \\nequ                       "            : (Incomplete sequence)
\\nequiv                    <char-0x02262>               " ≢          : NOT IDENTICAL TO
\\neu                       \\neu                        "            : (Incomplete sequence)
\\neuter                    <char-0x026B2>               " ⚲          : NEUTER
\\nex                       \\nex                        "            : (Incomplete sequence)
\\nexists                   <char-0x02204>               " ∄          : THERE DOES NOT EXIST
\\ng                        <char-0x0014B>               " ŋ          : LATIN SMALL LETTER ENG
\\ng<Tab>                   <char-0x0014B>               " ŋ          : LATIN SMALL LETTER ENG
\\nge                       \\nge                        "            : (Incomplete sequence)
\\ngeq                      <char-0x02271>               " ≱          : NEITHER GREATER-THAN NOR EQUAL TO / NEITHER GREATER THAN NOR EQUAL TO
\\ngeq<Tab>                 <char-0x02271>               " ≱          : NEITHER GREATER-THAN NOR EQUAL TO / NEITHER GREATER THAN NOR EQUAL TO
\\ngeqs                     \\ngeqs                      "            : (Incomplete sequence)
\\ngeqslant                 <char-0x02A7E><char-0x00338> " ⩾̸          : GREATER-THAN OR SLANTED EQUAL TO + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\ngt                       \\ngt                        "            : (Incomplete sequence)
\\ngtr                      <char-0x0226F>               " ≯          : NOT GREATER-THAN / NOT GREATER THAN
\\ngtr<Tab>                 <char-0x0226F>               " ≯          : NOT GREATER-THAN / NOT GREATER THAN
\\ngtrs                     \\ngtrs                      "            : (Incomplete sequence)
\\ngtrsim                   <char-0x02275>               " ≵          : NEITHER GREATER-THAN NOR EQUIVALENT TO / NEITHER GREATER THAN NOR EQUIVALENT TO
\\ni                        <char-0x0220B>               " ∋          : CONTAINS AS MEMBER
\\ni<Tab>                   <char-0x0220B>               " ∋          : CONTAINS AS MEMBER
\\nio                       \\nio                        "            : (Incomplete sequence)
\\niobar                    <char-0x022FE>               " ⋾          : SMALL CONTAINS WITH OVERBAR
\\nis                       <char-0x022FC>               " ⋼          : SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
\\nis<Tab>                  <char-0x022FC>               " ⋼          : SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
\\nisd                      <char-0x022FA>               " ⋺          : CONTAINS WITH LONG HORIZONTAL STROKE
\\nleftarrow                <char-0x0219A>               " ↚          : LEFTWARDS ARROW WITH STROKE / LEFT ARROW WITH STROKE
\\nleftrightarrow           <char-0x021AE>               " ↮          : LEFT RIGHT ARROW WITH STROKE
\\nleq                      <char-0x02270>               " ≰          : NEITHER LESS-THAN NOR EQUAL TO / NEITHER LESS THAN NOR EQUAL TO
\\nleq<Tab>                 <char-0x02270>               " ≰          : NEITHER LESS-THAN NOR EQUAL TO / NEITHER LESS THAN NOR EQUAL TO
\\nleqs                     \\nleqs                      "            : (Incomplete sequence)
\\nleqslant                 <char-0x02A7D><char-0x00338> " ⩽̸          : LESS-THAN OR SLANTED EQUAL TO + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nless                     <char-0x0226E>               " ≮          : NOT LESS-THAN / NOT LESS THAN
\\nless<Tab>                <char-0x0226E>               " ≮          : NOT LESS-THAN / NOT LESS THAN
\\nlesss                    \\nlesss                     "            : (Incomplete sequence)
\\nlesssim                  <char-0x02274>               " ≴          : NEITHER LESS-THAN NOR EQUIVALENT TO / NEITHER LESS THAN NOR EQUIVALENT TO
\\nmid                      <char-0x02224>               " ∤          : DOES NOT DIVIDE
\\nni                       <char-0x0220C>               " ∌          : DOES NOT CONTAIN AS MEMBER
\\nolinebreak               <char-0x02060>               " ⁠           : WORD JOINER
\\nor                       <char-0x022BD>               " ⊽          : NOR
\\not                       <char-0x00338>               " ◌̸          : COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\not<Tab>                  <char-0x00338>               " ◌̸          : COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\notb                      \\notb                       "            : (Incomplete sequence)
\\notbackslash              <char-0x02340>               " ⍀          : APL FUNCTIONAL SYMBOL BACKSLASH BAR
\\notg                      \\notg                       "            : (Incomplete sequence)
\\notgreaterless            <char-0x02279>               " ≹          : NEITHER GREATER-THAN NOR LESS-THAN / NEITHER GREATER THAN NOR LESS THAN
\\noti                      \\noti                       "            : (Incomplete sequence)
\\notin                     <char-0x02209>               " ∉          : NOT AN ELEMENT OF
\\notl                      \\notl                       "            : (Incomplete sequence)
\\notlessgreater            <char-0x02278>               " ≸          : NEITHER LESS-THAN NOR GREATER-THAN / NEITHER LESS THAN NOR GREATER THAN
\\nots                      \\nots                       "            : (Incomplete sequence)
\\notslash                  <char-0x0233F>               " ⌿          : APL FUNCTIONAL SYMBOL SLASH BAR
\\nparallel                 <char-0x02226>               " ∦          : NOT PARALLEL TO
\\npolint                   <char-0x02A14>               " ⨔          : LINE INTEGRATION NOT INCLUDING THE POLE
\\nprec                     <char-0x02280>               " ⊀          : DOES NOT PRECEDE
\\nprec<Tab>                <char-0x02280>               " ⊀          : DOES NOT PRECEDE
\\nprecc                    \\nprecc                     "            : (Incomplete sequence)
\\npreccurlyeq              <char-0x022E0>               " ⋠          : DOES NOT PRECEDE OR EQUAL
\\nprece                    \\nprece                     "            : (Incomplete sequence)
\\npreceq                   <char-0x02AAF><char-0x00338> " ⪯̸          : PRECEDES ABOVE SINGLE-LINE EQUALS SIGN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nprecs                    \\nprecs                     "            : (Incomplete sequence)
\\nprecsim                  <char-0x0227E><char-0x00338> " ≾̸          : PRECEDES OR EQUIVALENT TO + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nrightarrow               <char-0x0219B>               " ↛          : RIGHTWARDS ARROW WITH STROKE / RIGHT ARROW WITH STROKE
\\nrleg                     <char-0x0019E>               " ƞ          : LATIN SMALL LETTER N WITH LONG RIGHT LEG
\\nsim                      <char-0x02241>               " ≁          : NOT TILDE
\\nsim<Tab>                 <char-0x02241>               " ≁          : NOT TILDE
\\nsime                     <char-0x02244>               " ≄          : NOT ASYMPTOTICALLY EQUAL TO
\\nsqsubseteq               <char-0x022E2>               " ⋢          : NOT SQUARE IMAGE OF OR EQUAL TO
\\nsqsupseteq               <char-0x022E3>               " ⋣          : NOT SQUARE ORIGINAL OF OR EQUAL TO
\\nsubset                   <char-0x02284>               " ⊄          : NOT A SUBSET OF
\\nsubset<Tab>              <char-0x02284>               " ⊄          : NOT A SUBSET OF
\\nsubsete                  \\nsubsete                   "            : (Incomplete sequence)
\\nsubseteq                 <char-0x02288>               " ⊈          : NEITHER A SUBSET OF NOR EQUAL TO
\\nsubseteq<Tab>            <char-0x02288>               " ⊈          : NEITHER A SUBSET OF NOR EQUAL TO
\\nsubseteqq                <char-0x02AC5><char-0x00338> " ⫅̸          : SUBSET OF ABOVE EQUALS SIGN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nsucc                     <char-0x02281>               " ⊁          : DOES NOT SUCCEED
\\nsucc<Tab>                <char-0x02281>               " ⊁          : DOES NOT SUCCEED
\\nsuccc                    \\nsuccc                     "            : (Incomplete sequence)
\\nsucccurlyeq              <char-0x022E1>               " ⋡          : DOES NOT SUCCEED OR EQUAL
\\nsucce                    \\nsucce                     "            : (Incomplete sequence)
\\nsucceq                   <char-0x02AB0><char-0x00338> " ⪰̸          : SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nsuccs                    \\nsuccs                     "            : (Incomplete sequence)
\\nsuccsim                  <char-0x0227F><char-0x00338> " ≿̸          : SUCCEEDS OR EQUIVALENT TO + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\nsupset                   <char-0x02285>               " ⊅          : NOT A SUPERSET OF
\\nsupset<Tab>              <char-0x02285>               " ⊅          : NOT A SUPERSET OF
\\nsupsete                  \\nsupsete                   "            : (Incomplete sequence)
\\nsupseteq                 <char-0x02289>               " ⊉          : NEITHER A SUPERSET OF NOR EQUAL TO
\\nsupseteq<Tab>            <char-0x02289>               " ⊉          : NEITHER A SUPERSET OF NOR EQUAL TO
\\nsupseteqq                <char-0x02AC6><char-0x00338> " ⫆̸          : SUPERSET OF ABOVE EQUALS SIGN + COMBINING LONG SOLIDUS OVERLAY / NON-SPACING LONG SLASH OVERLAY
\\ntriangleleft             <char-0x022EA>               " ⋪          : NOT NORMAL SUBGROUP OF
\\ntriangleleft<Tab>        <char-0x022EA>               " ⋪          : NOT NORMAL SUBGROUP OF
\\ntrianglelefte            \\ntrianglelefte             "            : (Incomplete sequence)
\\ntrianglelefteq           <char-0x022EC>               " ⋬          : NOT NORMAL SUBGROUP OF OR EQUAL TO
\\ntriangleright            <char-0x022EB>               " ⋫          : DOES NOT CONTAIN AS NORMAL SUBGROUP
\\ntriangleright<Tab>       <char-0x022EB>               " ⋫          : DOES NOT CONTAIN AS NORMAL SUBGROUP
\\ntrianglerighte           \\ntrianglerighte            "            : (Incomplete sequence)
\\ntrianglerighteq          <char-0x022ED>               " ⋭          : DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
\\nu                        <char-0x003BD>               " ν          : GREEK SMALL LETTER NU
\\nu<Tab>                   <char-0x003BD>               " ν          : GREEK SMALL LETTER NU
\\num                       \\num                        "            : (Incomplete sequence)
\\numero                    <char-0x02116>               " №          : NUMERO SIGN / NUMERO
\\nvDash                    <char-0x022AD>               " ⊭          : NOT TRUE
\\nvLeftarrow               <char-0x02902>               " ⤂          : LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE
\\nvLeftrightarrow          <char-0x02904>               " ⤄          : LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE
\\nvRightarrow              <char-0x02903>               " ⤃          : RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE
\\nvdash                    <char-0x022AC>               " ⊬          : DOES NOT PROVE
\\nvleftarrow               <char-0x021F7>               " ⇷          : LEFTWARDS ARROW WITH VERTICAL STROKE
\\nvleftarrow<Tab>          <char-0x021F7>               " ⇷          : LEFTWARDS ARROW WITH VERTICAL STROKE
\\nvleftarrowt              \\nvleftarrowt               "            : (Incomplete sequence)
\\nvleftarrowtail           <char-0x02B39>               " ⬹          : LEFTWARDS ARROW WITH TAIL WITH VERTICAL STROKE
\\nvleftrightarrow          <char-0x021F9>               " ⇹          : LEFT RIGHT ARROW WITH VERTICAL STROKE
\\nvrightarrow              <char-0x021F8>               " ⇸          : RIGHTWARDS ARROW WITH VERTICAL STROKE
\\nvrightarrow<Tab>         <char-0x021F8>               " ⇸          : RIGHTWARDS ARROW WITH VERTICAL STROKE
\\nvrightarrowt             \\nvrightarrowt              "            : (Incomplete sequence)
\\nvrightarrowtail          <char-0x02914>               " ⤔          : RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE
\\nvtwoheadleftarrow        <char-0x02B34>               " ⬴          : LEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
\\nvtwoheadleftarrow<Tab>   <char-0x02B34>               " ⬴          : LEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
\\nvtwoheadleftarrowt       \\nvtwoheadleftarrowt        "            : (Incomplete sequence)
\\nvtwoheadleftarrowtail    <char-0x02B3C>               " ⬼          : LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE
\\nvtwoheadrightarrow       <char-0x02900>               " ⤀          : RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
\\nvtwoheadrightarrow<Tab>  <char-0x02900>               " ⤀          : RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
\\nvtwoheadrightarrowt      \\nvtwoheadrightarrowt       "            : (Incomplete sequence)
\\nvtwoheadrightarrowtail   <char-0x02917>               " ⤗          : RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE
\\nwarrow                   <char-0x02196>               " ↖          : NORTH WEST ARROW / UPPER LEFT ARROW
\\nwovnearrow               <char-0x02932>               " ⤲          : NORTH WEST ARROW CROSSING NORTH EAST ARROW
\\o                         <char-0x000F8>               " ø          : LATIN SMALL LETTER O WITH STROKE / LATIN SMALL LETTER O SLASH
\\o<Tab>                    <char-0x000F8>               " ø          : LATIN SMALL LETTER O WITH STROKE / LATIN SMALL LETTER O SLASH
\\ob                        \\ob                         "            : (Incomplete sequence)
\\obar                      <char-0x0233D>               " ⌽          : APL FUNCTIONAL SYMBOL CIRCLE STILE
\\obslash                   <char-0x029B8>               " ⦸          : CIRCLED REVERSE SOLIDUS
\\oc                        \\oc                         "            : (Incomplete sequence)
\\ocirc                     <char-0x0030A>               " ◌̊          : COMBINING RING ABOVE / NON-SPACING RING ABOVE
\\ocommatopright            <char-0x00315>               " ◌̕          : COMBINING COMMA ABOVE RIGHT / NON-SPACING COMMA ABOVE RIGHT
\\od                        \\od                         "            : (Incomplete sequence)
\\odiv                      <char-0x02A38>               " ⨸          : CIRCLED DIVISION SIGN
\\odot                      <char-0x02299>               " ⊙          : CIRCLED DOT OPERATOR
\\odot<Tab>                 <char-0x02299>               " ⊙          : CIRCLED DOT OPERATOR
\\odots                     \\odots                      "            : (Incomplete sequence)
\\odotslashdot              <char-0x029BC>               " ⦼          : CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN
\\oe                        <char-0x00153>               " œ          : LATIN SMALL LIGATURE OE / LATIN SMALL LETTER O E
\\og                        \\og                         "            : (Incomplete sequence)
\\ogreaterthan              <char-0x029C1>               " ⧁          : CIRCLED GREATER-THAN
\\oh                        \\oh                         "            : (Incomplete sequence)
\\ohm                       <char-0x02126>               " Ω          : OHM SIGN / OHM
\\oi                        \\oi                         "            : (Incomplete sequence)
\\oiiint                    <char-0x02230>               " ∰          : VOLUME INTEGRAL
\\oiint                     <char-0x0222F>               " ∯          : SURFACE INTEGRAL
\\oint                      <char-0x0222E>               " ∮          : CONTOUR INTEGRAL
\\oint<Tab>                 <char-0x0222E>               " ∮          : CONTOUR INTEGRAL
\\ointc                     \\ointc                      "            : (Incomplete sequence)
\\ointctrclockwise          <char-0x02233>               " ∳          : ANTICLOCKWISE CONTOUR INTEGRAL
\\ol                        \\ol                         "            : (Incomplete sequence)
\\oldKoppa                  <char-0x003D8>               " Ϙ          : GREEK LETTER ARCHAIC KOPPA
\\oldkoppa                  <char-0x003D9>               " ϙ          : GREEK SMALL LETTER ARCHAIC KOPPA
\\olessthan                 <char-0x029C0>               " ⧀          : CIRCLED LESS-THAN
\\om                        \\om                         "            : (Incomplete sequence)
\\omega                     <char-0x003C9>               " ω          : GREEK SMALL LETTER OMEGA
\\omicron                   <char-0x003BF>               " ο          : GREEK SMALL LETTER OMICRON
\\ominus                    <char-0x02296>               " ⊖          : CIRCLED MINUS
\\op                        \\op                         "            : (Incomplete sequence)
\\openbracketleft           <char-0x027E6>               " ⟦          : MATHEMATICAL LEFT WHITE SQUARE BRACKET
\\openbracketright          <char-0x027E7>               " ⟧          : MATHEMATICAL RIGHT WHITE SQUARE BRACKET
\\openo                     <char-0x00254>               " ɔ          : LATIN SMALL LETTER OPEN O
\\oplus                     <char-0x02295>               " ⊕          : CIRCLED PLUS
\\oplus<Tab>                <char-0x02295>               " ⊕          : CIRCLED PLUS
\\oplusl                    \\oplusl                     "            : (Incomplete sequence)
\\opluslhrim                <char-0x02A2D>               " ⨭          : PLUS SIGN IN LEFT HALF CIRCLE
\\oplusr                    \\oplusr                     "            : (Incomplete sequence)
\\oplusrhrim                <char-0x02A2E>               " ⨮          : PLUS SIGN IN RIGHT HALF CIRCLE
\\or                        \\or                         "            : (Incomplete sequence)
\\ordfeminine               <char-0x000AA>               " ª          : FEMININE ORDINAL INDICATOR
\\ordmasculine              <char-0x000BA>               " º          : MASCULINE ORDINAL INDICATOR
\\original                  <char-0x022B6>               " ⊶          : ORIGINAL OF
\\os                        \\os                         "            : (Incomplete sequence)
\\oslash                    <char-0x02298>               " ⊘          : CIRCLED DIVISION SLASH
\\ot                        \\ot                         "            : (Incomplete sequence)
\\otimes                    <char-0x02297>               " ⊗          : CIRCLED TIMES
\\otimes<Tab>               <char-0x02297>               " ⊗          : CIRCLED TIMES
\\otimesh                   \\otimesh                    "            : (Incomplete sequence)
\\otimeshat                 <char-0x02A36>               " ⨶          : CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT
\\otimesl                   \\otimesl                    "            : (Incomplete sequence)
\\otimeslhrim               <char-0x02A34>               " ⨴          : MULTIPLICATION SIGN IN LEFT HALF CIRCLE
\\otimesr                   \\otimesr                    "            : (Incomplete sequence)
\\otimesrhrim               <char-0x02A35>               " ⨵          : MULTIPLICATION SIGN IN RIGHT HALF CIRCLE
\\oturnedcomma              <char-0x00312>               " ◌̒          : COMBINING TURNED COMMA ABOVE / NON-SPACING TURNED COMMA ABOVE
\\ov                        \\ov                         "            : (Incomplete sequence)
\\overbar                   <char-0x00305>               " ◌̅          : COMBINING OVERLINE / NON-SPACING OVERSCORE
\\overbrace                 <char-0x023DE>               " ⏞          : TOP CURLY BRACKET
\\overbracket               <char-0x023B4>               " ⎴          : TOP SQUARE BRACKET
\\overleftarrow             <char-0x020D6>               " ◌⃖          : COMBINING LEFT ARROW ABOVE / NON-SPACING LEFT ARROW ABOVE
\\overleftrightarrow        <char-0x020E1>               " ◌⃡          : COMBINING LEFT RIGHT ARROW ABOVE / NON-SPACING LEFT RIGHT ARROW ABOVE
\\ovhook                    <char-0x00309>               " ◌̉          : COMBINING HOOK ABOVE / NON-SPACING HOOK ABOVE
\\palh                      <char-0x00321>               " ◌̡          : COMBINING PALATALIZED HOOK BELOW / NON-SPACING PALATALIZED HOOK BELOW
\\parallel                  <char-0x02225>               " ∥          : PARALLEL TO
\\parallel<Tab>             <char-0x02225>               " ∥          : PARALLEL TO
\\parallelo                 \\parallelo                  "            : (Incomplete sequence)
\\parallelogram             <char-0x025B1>               " ▱          : WHITE PARALLELOGRAM
\\parallelogram<Tab>        <char-0x025B1>               " ▱          : WHITE PARALLELOGRAM
\\parallelogramb            \\parallelogramb             "            : (Incomplete sequence)
\\parallelogramblack        <char-0x025B0>               " ▰          : BLACK PARALLELOGRAM
\\partial                   <char-0x02202>               " ∂          : PARTIAL DIFFERENTIAL
\\partial<Tab>              <char-0x02202>               " ∂          : PARTIAL DIFFERENTIAL
\\partialm                  \\partialm                   "            : (Incomplete sequence)
\\partialmeetcontraction    <char-0x02AA3>               " ⪣          : DOUBLE NESTED LESS-THAN WITH UNDERBAR
\\pbgam                     <char-0x00264>               " ɤ          : LATIN SMALL LETTER RAMS HORN / LATIN SMALL LETTER BABY GAMMA
\\pentagon                  <char-0x02B20>               " ⬠          : WHITE PENTAGON
\\pentagon<Tab>             <char-0x02B20>               " ⬠          : WHITE PENTAGON
\\pentagonb                 \\pentagonb                  "            : (Incomplete sequence)
\\pentagonblack             <char-0x02B1F>               " ⬟          : BLACK PENTAGON
\\perp                      <char-0x027C2>               " ⟂          : PERPENDICULAR
\\perspcorrespond           <char-0x02A5E>               " ⩞          : LOGICAL AND WITH DOUBLE OVERBAR
\\pertenthousand            <char-0x02031>               " ‱          : PER TEN THOUSAND SIGN
\\perthousand               <char-0x02030>               " ‰          : PER MILLE SIGN
\\pes                       <char-0x020A7>               " ₧          : PESETA SIGN
\\pgamma                    <char-0x00263>               " ɣ          : LATIN SMALL LETTER GAMMA
\\phi                       <char-0x003D5>               " ϕ          : GREEK PHI SYMBOL / GREEK SMALL LETTER SCRIPT PHI
\\pi                        <char-0x003C0>               " π          : GREEK SMALL LETTER PI
\\pi<Tab>                   <char-0x003C0>               " π          : GREEK SMALL LETTER PI
\\pis                       \\pis                        "            : (Incomplete sequence)
\\pisces                    <char-0x02653>               " ♓         : PISCES
\\pit                       \\pit                        "            : (Incomplete sequence)
\\pitchfork                 <char-0x022D4>               " ⋔          : PITCHFORK
\\planck                    <char-0x0210E>               " ℎ          : PLANCK CONSTANT
\\plusdot                   <char-0x02A25>               " ⨥          : PLUS SIGN WITH DOT BELOW
\\pluseqq                   <char-0x02A72>               " ⩲          : PLUS SIGN ABOVE EQUALS SIGN
\\plushat                   <char-0x02A23>               " ⨣          : PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE
\\plussim                   <char-0x02A26>               " ⨦          : PLUS SIGN WITH TILDE BELOW
\\plussubtwo                <char-0x02A27>               " ⨧          : PLUS SIGN WITH SUBSCRIPT TWO
\\plustrif                  <char-0x02A28>               " ⨨          : PLUS SIGN WITH BLACK TRIANGLE
\\pluto                     <char-0x02647>               " ♇          : PLUTO
\\pm                        <char-0x000B1>               " ±          : PLUS-MINUS SIGN / PLUS-OR-MINUS SIGN
\\pointint                  <char-0x02A15>               " ⨕          : INTEGRAL AROUND A POINT OPERATOR
\\postalmark                <char-0x03012>               " 〒         : POSTAL MARK
\\pppprime                  <char-0x02057>               " ⁗          : QUADRUPLE PRIME
\\ppprime                   <char-0x02034>               " ‴          : TRIPLE PRIME
\\pprime                    <char-0x02033>               " ″          : DOUBLE PRIME
\\prec                      <char-0x0227A>               " ≺          : PRECEDES
\\prec<Tab>                 <char-0x0227A>               " ≺          : PRECEDES
\\preca                     \\preca                      "            : (Incomplete sequence)
\\precapprox                <char-0x02AB7>               " ⪷          : PRECEDES ABOVE ALMOST EQUAL TO
\\precc                     \\precc                      "            : (Incomplete sequence)
\\preccurlyeq               <char-0x0227C>               " ≼          : PRECEDES OR EQUAL TO
\\prece                     \\prece                      "            : (Incomplete sequence)
\\preceq                    <char-0x02AAF>               " ⪯          : PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
\\preceq<Tab>               <char-0x02AAF>               " ⪯          : PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
\\preceqq                   <char-0x02AB3>               " ⪳          : PRECEDES ABOVE EQUALS SIGN
\\precn                     \\precn                      "            : (Incomplete sequence)
\\precnapprox               <char-0x02AB9>               " ⪹          : PRECEDES ABOVE NOT ALMOST EQUAL TO
\\precneq                   <char-0x02AB1>               " ⪱          : PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO
\\precneq<Tab>              <char-0x02AB1>               " ⪱          : PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO
\\precneqq                  <char-0x02AB5>               " ⪵          : PRECEDES ABOVE NOT EQUAL TO
\\precnsim                  <char-0x022E8>               " ⋨          : PRECEDES BUT NOT EQUIVALENT TO
\\precs                     \\precs                      "            : (Incomplete sequence)
\\precsim                   <char-0x0227E>               " ≾          : PRECEDES OR EQUIVALENT TO
\\prime                     <char-0x02032>               " ′          : PRIME
\\prod                      <char-0x0220F>               " ∏          : N-ARY PRODUCT
\\profline                  <char-0x02312>               " ⌒          : ARC
\\profsurf                  <char-0x02313>               " ⌓          : SEGMENT
\\propto                    <char-0x0221D>               " ∝          : PROPORTIONAL TO
\\prurel                    <char-0x022B0>               " ⊰          : PRECEDES UNDER RELATION
\\pscrv                     <char-0x0028B>               " ʋ          : LATIN SMALL LETTER V WITH HOOK / LATIN SMALL LETTER SCRIPT V
\\psi                       <char-0x003C8>               " ψ          : GREEK SMALL LETTER PSI
\\pupsil                    <char-0x0028A>               " ʊ          : LATIN SMALL LETTER UPSILON
\\quad                      <char-0x02003>               "            : EM SPACE
\\quarternote               <char-0x02669>               " ♩          : QUARTER NOTE
\\questeq                   <char-0x0225F>               " ≟          : QUESTIONED EQUAL TO
\\questiondown              <char-0x000BF>               " ¿          : INVERTED QUESTION MARK
\\rLarr                     <char-0x02944>               " ⥄          : SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW
\\rais                      <char-0x002D4>               " ˔          : MODIFIER LETTER UP TACK
\\rangle                    <char-0x027E9>               " ⟩          : MATHEMATICAL RIGHT ANGLE BRACKET
\\rarrx                     <char-0x02947>               " ⥇          : RIGHTWARDS ARROW THROUGH X
\\rasp                      <char-0x002BC>               " ʼ          : MODIFIER LETTER APOSTROPHE
\\rceil                     <char-0x02309>               " ⌉          : RIGHT CEILING
\\rdiagovfdiag              <char-0x0292B>               " ⤫          : RISING DIAGONAL CROSSING FALLING DIAGONAL
\\rdiagovsearrow            <char-0x02930>               " ⤰          : RISING DIAGONAL CROSSING SOUTH EAST ARROW
\\rdq                       <char-0x0201D>               " ”          : RIGHT DOUBLE QUOTATION MARK / DOUBLE COMMA QUOTATION MARK
\\reapos                    <char-0x0201B>               " ‛          : SINGLE HIGH-REVERSED-9 QUOTATION MARK / SINGLE REVERSED COMMA QUOTATION MARK
\\recorder                  <char-0x02315>               " ⌕          : TELEPHONE RECORDER
\\reglst                    <char-0x00295>               " ʕ          : LATIN LETTER PHARYNGEAL VOICED FRICATIVE / LATIN LETTER REVERSED GLOTTAL STOP
\\revangle                  <char-0x029A3>               " ⦣          : REVERSED ANGLE
\\revangle<Tab>             <char-0x029A3>               " ⦣          : REVERSED ANGLE
\\revangleu                 \\revangleu                  "            : (Incomplete sequence)
\\revangleubar              <char-0x029A5>               " ⦥          : REVERSED ANGLE WITH UNDERBAR
\\revemptyset               <char-0x029B0>               " ⦰          : REVERSED EMPTY SET
\\rfloor                    <char-0x0230B>               " ⌋          : RIGHT FLOOR
\\rh                        <char-0x00322>               " ◌̢          : COMBINING RETROFLEX HOOK BELOW / NON-SPACING RETROFLEX HOOK BELOW
\\rh<Tab>                   <char-0x00322>               " ◌̢          : COMBINING RETROFLEX HOOK BELOW / NON-SPACING RETROFLEX HOOK BELOW
\\rho                       <char-0x003C1>               " ρ          : GREEK SMALL LETTER RHO
\\rightangle                <char-0x0221F>               " ∟          : RIGHT ANGLE
\\rightangle<Tab>           <char-0x0221F>               " ∟          : RIGHT ANGLE
\\rightanglea               \\rightanglea                "            : (Incomplete sequence)
\\rightanglearc             <char-0x022BE>               " ⊾          : RIGHT ANGLE WITH ARC
\\rightanglem               \\rightanglem                "            : (Incomplete sequence)
\\rightanglemdot            <char-0x0299D>               " ⦝          : MEASURED RIGHT ANGLE WITH DOT
\\rightarrow                <char-0x02192>               " →          : RIGHTWARDS ARROW / RIGHT ARROW
\\rightarrow<Tab>           <char-0x02192>               " →          : RIGHTWARDS ARROW / RIGHT ARROW
\\rightarrowb               \\rightarrowb                "            : (Incomplete sequence)
\\rightarrowbackapprox      <char-0x02B48>               " ⭈          : RIGHTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO
\\rightarrowbar             <char-0x021E5>               " ⇥          : RIGHTWARDS ARROW TO BAR / RIGHT ARROW TO BAR
\\rightarrowbsimilar        <char-0x02B4C>               " ⭌          : RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
\\rightarrowd               \\rightarrowd                "            : (Incomplete sequence)
\\rightarrowdiamond         <char-0x0291E>               " ⤞          : RIGHTWARDS ARROW TO BLACK DIAMOND
\\rightarrowg               \\rightarrowg                "            : (Incomplete sequence)
\\rightarrowgtr             <char-0x02B43>               " ⭃          : RIGHTWARDS ARROW THROUGH GREATER-THAN
\\rightarrowp               \\rightarrowp                "            : (Incomplete sequence)
\\rightarrowplus            <char-0x02945>               " ⥅          : RIGHTWARDS ARROW WITH PLUS BELOW
\\rightarrows               \\rightarrows                "            : (Incomplete sequence)
\\rightarrowsupset          <char-0x02B44>               " ⭄          : RIGHTWARDS ARROW THROUGH SUPERSET
\\rightarrowt               \\rightarrowt                "            : (Incomplete sequence)
\\rightarrowtail            <char-0x021A3>               " ↣          : RIGHTWARDS ARROW WITH TAIL / RIGHT ARROW WITH TAIL
\\rightarrowtriangle        <char-0x021FE>               " ⇾          : RIGHTWARDS OPEN-HEADED ARROW
\\rightdasharrow            <char-0x021E2>               " ⇢          : RIGHTWARDS DASHED ARROW / RIGHT DASHED ARROW
\\rightdotarrow             <char-0x02911>               " ⤑          : RIGHTWARDS ARROW WITH DOTTED STEM
\\rightharpoonaccent        <char-0x020D1>               " ◌⃑          : COMBINING RIGHT HARPOON ABOVE / NON-SPACING RIGHT HARPOON ABOVE
\\rightharpoondown          <char-0x021C1>               " ⇁          : RIGHTWARDS HARPOON WITH BARB DOWNWARDS / RIGHT HARPOON WITH BARB DOWN
\\rightharpoonsupdown       <char-0x02964>               " ⥤          : RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
\\rightharpoonup            <char-0x021C0>               " ⇀          : RIGHTWARDS HARPOON WITH BARB UPWARDS / RIGHT HARPOON WITH BARB UP
\\rightharpoonup<Tab>       <char-0x021C0>               " ⇀          : RIGHTWARDS HARPOON WITH BARB UPWARDS / RIGHT HARPOON WITH BARB UP
\\rightharpoonupd           \\rightharpoonupd            "            : (Incomplete sequence)
\\rightharpoonupdash        <char-0x0296C>               " ⥬          : RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
\\rightleftarrows           <char-0x021C4>               " ⇄          : RIGHTWARDS ARROW OVER LEFTWARDS ARROW / RIGHT ARROW OVER LEFT ARROW
\\rightleftharpoons         <char-0x021CC>               " ⇌          : RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON / RIGHT HARPOON OVER LEFT HARPOON
\\rightleftharpoons<Tab>    <char-0x021CC>               " ⇌          : RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON / RIGHT HARPOON OVER LEFT HARPOON
\\rightleftharpoonsd        \\rightleftharpoonsd         "            : (Incomplete sequence)
\\rightleftharpoonsdown     <char-0x02969>               " ⥩          : RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN
\\rightleftharpoonsu        \\rightleftharpoonsu         "            : (Incomplete sequence)
\\rightleftharpoonsup       <char-0x02968>               " ⥨          : RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP
\\rightmoon                 <char-0x0263D>               " ☽          : FIRST QUARTER MOON
\\rightouterjoin            <char-0x027D6>               " ⟖          : RIGHT OUTER JOIN
\\rightpentagon             <char-0x02B54>               " ⭔          : WHITE RIGHT-POINTING PENTAGON
\\rightpentagon<Tab>        <char-0x02B54>               " ⭔          : WHITE RIGHT-POINTING PENTAGON
\\rightpentagonb            \\rightpentagonb             "            : (Incomplete sequence)
\\rightpentagonblack        <char-0x02B53>               " ⭓          : BLACK RIGHT-POINTING PENTAGON
\\rightrightarrows          <char-0x021C9>               " ⇉          : RIGHTWARDS PAIRED ARROWS / RIGHT PAIRED ARROWS
\\rightsquigarrow           <char-0x021DD>               " ⇝          : RIGHTWARDS SQUIGGLE ARROW / RIGHT SQUIGGLE ARROW
\\rightthreearrows          <char-0x021F6>               " ⇶          : THREE RIGHTWARDS ARROWS
\\rightthreetimes           <char-0x022CC>               " ⋌          : RIGHT SEMIDIRECT PRODUCT
\\rightwavearrow            <char-0x0219D>               " ↝          : RIGHTWARDS WAVE ARROW / RIGHT WAVE ARROW
\\rightwhitearrow           <char-0x021E8>               " ⇨          : RIGHTWARDS WHITE ARROW / WHITE RIGHT ARROW
\\ringplus                  <char-0x02A22>               " ⨢          : PLUS SIGN WITH SMALL CIRCLE ABOVE
\\risingdotseq              <char-0x02253>               " ≓          : IMAGE OF OR APPROXIMATELY EQUAL TO
\\rl                        <char-0x0027C>               " ɼ          : LATIN SMALL LETTER R WITH LONG LEG
\\rmoustache                <char-0x023B1>               " ⎱          : UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION
\\rppolint                  <char-0x02A12>               " ⨒          : LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE
\\rq                        <char-0x02019>               " ’          : RIGHT SINGLE QUOTATION MARK / SINGLE COMMA QUOTATION MARK
\\rrbracket                 <char-0x027E7>               " ⟧          : MATHEMATICAL RIGHT WHITE SQUARE BRACKET
\\rsolbar                   <char-0x029F7>               " ⧷          : REVERSE SOLIDUS WITH HORIZONTAL STROKE
\\rsqhook                   <char-0x02ACE>               " ⫎          : SQUARE RIGHT OPEN BOX OPERATOR
\\rtimes                    <char-0x022CA>               " ⋊          : RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT
\\rtld                      <char-0x00256>               " ɖ          : LATIN SMALL LETTER D WITH TAIL / LATIN SMALL LETTER D RETROFLEX HOOK
\\rtll                      <char-0x0026D>               " ɭ          : LATIN SMALL LETTER L WITH RETROFLEX HOOK / LATIN SMALL LETTER L RETROFLEX HOOK
\\rtln                      <char-0x00273>               " ɳ          : LATIN SMALL LETTER N WITH RETROFLEX HOOK / LATIN SMALL LETTER N RETROFLEX HOOK
\\rtlr                      <char-0x0027D>               " ɽ          : LATIN SMALL LETTER R WITH TAIL / LATIN SMALL LETTER R HOOK
\\rtls                      <char-0x00282>               " ʂ          : LATIN SMALL LETTER S WITH HOOK / LATIN SMALL LETTER S HOOK
\\rtlt                      <char-0x00288>               " ʈ          : LATIN SMALL LETTER T WITH RETROFLEX HOOK / LATIN SMALL LETTER T RETROFLEX HOOK
\\rtlz                      <char-0x00290>               " ʐ          : LATIN SMALL LETTER Z WITH RETROFLEX HOOK / LATIN SMALL LETTER Z RETROFLEX HOOK
\\rttrnr                    <char-0x0027B>               " ɻ          : LATIN SMALL LETTER TURNED R WITH HOOK / LATIN SMALL LETTER TURNED R HOOK
\\rvboxline                 <char-0x023B9>               " ⎹          : RIGHT VERTICAL BOX LINE
\\rvbull                    <char-0x025D8>               " ◘          : INVERSE BULLET
\\sagittarius               <char-0x02650>               " ♐         : SAGITTARIUS
\\sampi                     <char-0x003E1>               " ϡ          : GREEK SMALL LETTER SAMPI
\\sansA                     <char-0x1D5A0>               " 𝖠          : MATHEMATICAL SANS-SERIF CAPITAL A
\\sansB                     <char-0x1D5A1>               " 𝖡          : MATHEMATICAL SANS-SERIF CAPITAL B
\\sansC                     <char-0x1D5A2>               " 𝖢          : MATHEMATICAL SANS-SERIF CAPITAL C
\\sansD                     <char-0x1D5A3>               " 𝖣          : MATHEMATICAL SANS-SERIF CAPITAL D
\\sansE                     <char-0x1D5A4>               " 𝖤          : MATHEMATICAL SANS-SERIF CAPITAL E
\\sansF                     <char-0x1D5A5>               " 𝖥          : MATHEMATICAL SANS-SERIF CAPITAL F
\\sansG                     <char-0x1D5A6>               " 𝖦          : MATHEMATICAL SANS-SERIF CAPITAL G
\\sansH                     <char-0x1D5A7>               " 𝖧          : MATHEMATICAL SANS-SERIF CAPITAL H
\\sansI                     <char-0x1D5A8>               " 𝖨          : MATHEMATICAL SANS-SERIF CAPITAL I
\\sansJ                     <char-0x1D5A9>               " 𝖩          : MATHEMATICAL SANS-SERIF CAPITAL J
\\sansK                     <char-0x1D5AA>               " 𝖪          : MATHEMATICAL SANS-SERIF CAPITAL K
\\sansL                     <char-0x1D5AB>               " 𝖫          : MATHEMATICAL SANS-SERIF CAPITAL L
\\sansL<Tab>                <char-0x1D5AB>               " 𝖫          : MATHEMATICAL SANS-SERIF CAPITAL L
\\sansLm                    \\sansLm                     "            : (Incomplete sequence)
\\sansLmirrored             <char-0x02143>               " ⅃          : REVERSED SANS-SERIF CAPITAL L
\\sansLt                    \\sansLt                     "            : (Incomplete sequence)
\\sansLturned               <char-0x02142>               " ⅂          : TURNED SANS-SERIF CAPITAL L
\\sansM                     <char-0x1D5AC>               " 𝖬          : MATHEMATICAL SANS-SERIF CAPITAL M
\\sansN                     <char-0x1D5AD>               " 𝖭          : MATHEMATICAL SANS-SERIF CAPITAL N
\\sansO                     <char-0x1D5AE>               " 𝖮          : MATHEMATICAL SANS-SERIF CAPITAL O
\\sansP                     <char-0x1D5AF>               " 𝖯          : MATHEMATICAL SANS-SERIF CAPITAL P
\\sansQ                     <char-0x1D5B0>               " 𝖰          : MATHEMATICAL SANS-SERIF CAPITAL Q
\\sansR                     <char-0x1D5B1>               " 𝖱          : MATHEMATICAL SANS-SERIF CAPITAL R
\\sansS                     <char-0x1D5B2>               " 𝖲          : MATHEMATICAL SANS-SERIF CAPITAL S
\\sansT                     <char-0x1D5B3>               " 𝖳          : MATHEMATICAL SANS-SERIF CAPITAL T
\\sansU                     <char-0x1D5B4>               " 𝖴          : MATHEMATICAL SANS-SERIF CAPITAL U
\\sansV                     <char-0x1D5B5>               " 𝖵          : MATHEMATICAL SANS-SERIF CAPITAL V
\\sansW                     <char-0x1D5B6>               " 𝖶          : MATHEMATICAL SANS-SERIF CAPITAL W
\\sansX                     <char-0x1D5B7>               " 𝖷          : MATHEMATICAL SANS-SERIF CAPITAL X
\\sansY                     <char-0x1D5B8>               " 𝖸          : MATHEMATICAL SANS-SERIF CAPITAL Y
\\sansZ                     <char-0x1D5B9>               " 𝖹          : MATHEMATICAL SANS-SERIF CAPITAL Z
\\sansa                     <char-0x1D5BA>               " 𝖺          : MATHEMATICAL SANS-SERIF SMALL A
\\sansb                     <char-0x1D5BB>               " 𝖻          : MATHEMATICAL SANS-SERIF SMALL B
\\sansc                     <char-0x1D5BC>               " 𝖼          : MATHEMATICAL SANS-SERIF SMALL C
\\sansd                     <char-0x1D5BD>               " 𝖽          : MATHEMATICAL SANS-SERIF SMALL D
\\sanse                     <char-0x1D5BE>               " 𝖾          : MATHEMATICAL SANS-SERIF SMALL E
\\sanse<Tab>                <char-0x1D5BE>               " 𝖾          : MATHEMATICAL SANS-SERIF SMALL E
\\sansei                    \\sansei                     "            : (Incomplete sequence)
\\sanseight                 <char-0x1D7EA>               " 𝟪          : MATHEMATICAL SANS-SERIF DIGIT EIGHT
\\sansf                     <char-0x1D5BF>               " 𝖿          : MATHEMATICAL SANS-SERIF SMALL F
\\sansf<Tab>                <char-0x1D5BF>               " 𝖿          : MATHEMATICAL SANS-SERIF SMALL F
\\sansfi                    \\sansfi                     "            : (Incomplete sequence)
\\sansfive                  <char-0x1D7E7>               " 𝟧          : MATHEMATICAL SANS-SERIF DIGIT FIVE
\\sansfo                    \\sansfo                     "            : (Incomplete sequence)
\\sansfour                  <char-0x1D7E6>               " 𝟦          : MATHEMATICAL SANS-SERIF DIGIT FOUR
\\sansg                     <char-0x1D5C0>               " 𝗀          : MATHEMATICAL SANS-SERIF SMALL G
\\sansh                     <char-0x1D5C1>               " 𝗁          : MATHEMATICAL SANS-SERIF SMALL H
\\sansi                     <char-0x1D5C2>               " 𝗂          : MATHEMATICAL SANS-SERIF SMALL I
\\sansj                     <char-0x1D5C3>               " 𝗃          : MATHEMATICAL SANS-SERIF SMALL J
\\sansk                     <char-0x1D5C4>               " 𝗄          : MATHEMATICAL SANS-SERIF SMALL K
\\sansl                     <char-0x1D5C5>               " 𝗅          : MATHEMATICAL SANS-SERIF SMALL L
\\sansm                     <char-0x1D5C6>               " 𝗆          : MATHEMATICAL SANS-SERIF SMALL M
\\sansn                     <char-0x1D5C7>               " 𝗇          : MATHEMATICAL SANS-SERIF SMALL N
\\sansn<Tab>                <char-0x1D5C7>               " 𝗇          : MATHEMATICAL SANS-SERIF SMALL N
\\sansni                    \\sansni                     "            : (Incomplete sequence)
\\sansnine                  <char-0x1D7EB>               " 𝟫          : MATHEMATICAL SANS-SERIF DIGIT NINE
\\sanso                     <char-0x1D5C8>               " 𝗈          : MATHEMATICAL SANS-SERIF SMALL O
\\sanso<Tab>                <char-0x1D5C8>               " 𝗈          : MATHEMATICAL SANS-SERIF SMALL O
\\sanson                    \\sanson                     "            : (Incomplete sequence)
\\sansone                   <char-0x1D7E3>               " 𝟣          : MATHEMATICAL SANS-SERIF DIGIT ONE
\\sansp                     <char-0x1D5C9>               " 𝗉          : MATHEMATICAL SANS-SERIF SMALL P
\\sansq                     <char-0x1D5CA>               " 𝗊          : MATHEMATICAL SANS-SERIF SMALL Q
\\sansr                     <char-0x1D5CB>               " 𝗋          : MATHEMATICAL SANS-SERIF SMALL R
\\sanss                     <char-0x1D5CC>               " 𝗌          : MATHEMATICAL SANS-SERIF SMALL S
\\sanss<Tab>                <char-0x1D5CC>               " 𝗌          : MATHEMATICAL SANS-SERIF SMALL S
\\sansse                    \\sansse                     "            : (Incomplete sequence)
\\sansseven                 <char-0x1D7E9>               " 𝟩          : MATHEMATICAL SANS-SERIF DIGIT SEVEN
\\sanssi                    \\sanssi                     "            : (Incomplete sequence)
\\sanssix                   <char-0x1D7E8>               " 𝟨          : MATHEMATICAL SANS-SERIF DIGIT SIX
\\sanst                     <char-0x1D5CD>               " 𝗍          : MATHEMATICAL SANS-SERIF SMALL T
\\sanst<Tab>                <char-0x1D5CD>               " 𝗍          : MATHEMATICAL SANS-SERIF SMALL T
\\sansth                    \\sansth                     "            : (Incomplete sequence)
\\sansthree                 <char-0x1D7E5>               " 𝟥          : MATHEMATICAL SANS-SERIF DIGIT THREE
\\sanstw                    \\sanstw                     "            : (Incomplete sequence)
\\sanstwo                   <char-0x1D7E4>               " 𝟤          : MATHEMATICAL SANS-SERIF DIGIT TWO
\\sansu                     <char-0x1D5CE>               " 𝗎          : MATHEMATICAL SANS-SERIF SMALL U
\\sansv                     <char-0x1D5CF>               " 𝗏          : MATHEMATICAL SANS-SERIF SMALL V
\\sansw                     <char-0x1D5D0>               " 𝗐          : MATHEMATICAL SANS-SERIF SMALL W
\\sansx                     <char-0x1D5D1>               " 𝗑          : MATHEMATICAL SANS-SERIF SMALL X
\\sansy                     <char-0x1D5D2>               " 𝗒          : MATHEMATICAL SANS-SERIF SMALL Y
\\sansz                     <char-0x1D5D3>               " 𝗓          : MATHEMATICAL SANS-SERIF SMALL Z
\\sansz<Tab>                <char-0x1D5D3>               " 𝗓          : MATHEMATICAL SANS-SERIF SMALL Z
\\sansze                    \\sansze                     "            : (Incomplete sequence)
\\sanszero                  <char-0x1D7E2>               " 𝟢          : MATHEMATICAL SANS-SERIF DIGIT ZERO
\\saturn                    <char-0x02644>               " ♄          : SATURN
\\sbbrg                     <char-0x0032A>               " ◌̪          : COMBINING BRIDGE BELOW / NON-SPACING BRIDGE BELOW
\\sblhr                     <char-0x002D3>               " ˓          : MODIFIER LETTER CENTRED LEFT HALF RING / MODIFIER LETTER CENTERED LEFT HALF RING
\\sbrhr                     <char-0x002D2>               " ˒          : MODIFIER LETTER CENTRED RIGHT HALF RING / MODIFIER LETTER CENTERED RIGHT HALF RING
\\schwa                     <char-0x00259>               " ə          : LATIN SMALL LETTER SCHWA
\\scorpio                   <char-0x0264F>               " ♏         : SCORPIUS
\\scpolint                  <char-0x02A13>               " ⨓          : LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE
\\scrA                      <char-0x1D49C>               " 𝒜          : MATHEMATICAL SCRIPT CAPITAL A
\\scrB                      <char-0x0212C>               " ℬ          : SCRIPT CAPITAL B / SCRIPT B
\\scrC                      <char-0x1D49E>               " 𝒞          : MATHEMATICAL SCRIPT CAPITAL C
\\scrD                      <char-0x1D49F>               " 𝒟          : MATHEMATICAL SCRIPT CAPITAL D
\\scrE                      <char-0x02130>               " ℰ          : SCRIPT CAPITAL E / SCRIPT E
\\scrF                      <char-0x02131>               " ℱ          : SCRIPT CAPITAL F / SCRIPT F
\\scrG                      <char-0x1D4A2>               " 𝒢          : MATHEMATICAL SCRIPT CAPITAL G
\\scrH                      <char-0x0210B>               " ℋ          : SCRIPT CAPITAL H / SCRIPT H
\\scrI                      <char-0x02110>               " ℐ          : SCRIPT CAPITAL I / SCRIPT I
\\scrJ                      <char-0x1D4A5>               " 𝒥          : MATHEMATICAL SCRIPT CAPITAL J
\\scrK                      <char-0x1D4A6>               " 𝒦          : MATHEMATICAL SCRIPT CAPITAL K
\\scrL                      <char-0x02112>               " ℒ          : SCRIPT CAPITAL L / SCRIPT L
\\scrM                      <char-0x02133>               " ℳ          : SCRIPT CAPITAL M / SCRIPT M
\\scrN                      <char-0x1D4A9>               " 𝒩          : MATHEMATICAL SCRIPT CAPITAL N
\\scrO                      <char-0x1D4AA>               " 𝒪          : MATHEMATICAL SCRIPT CAPITAL O
\\scrP                      <char-0x1D4AB>               " 𝒫          : MATHEMATICAL SCRIPT CAPITAL P
\\scrQ                      <char-0x1D4AC>               " 𝒬          : MATHEMATICAL SCRIPT CAPITAL Q
\\scrR                      <char-0x0211B>               " ℛ          : SCRIPT CAPITAL R / SCRIPT R
\\scrS                      <char-0x1D4AE>               " 𝒮          : MATHEMATICAL SCRIPT CAPITAL S
\\scrT                      <char-0x1D4AF>               " 𝒯          : MATHEMATICAL SCRIPT CAPITAL T
\\scrU                      <char-0x1D4B0>               " 𝒰          : MATHEMATICAL SCRIPT CAPITAL U
\\scrV                      <char-0x1D4B1>               " 𝒱          : MATHEMATICAL SCRIPT CAPITAL V
\\scrW                      <char-0x1D4B2>               " 𝒲          : MATHEMATICAL SCRIPT CAPITAL W
\\scrX                      <char-0x1D4B3>               " 𝒳          : MATHEMATICAL SCRIPT CAPITAL X
\\scrY                      <char-0x1D4B4>               " 𝒴          : MATHEMATICAL SCRIPT CAPITAL Y
\\scrZ                      <char-0x1D4B5>               " 𝒵          : MATHEMATICAL SCRIPT CAPITAL Z
\\scra                      <char-0x1D4B6>               " 𝒶          : MATHEMATICAL SCRIPT SMALL A
\\scrb                      <char-0x1D4B7>               " 𝒷          : MATHEMATICAL SCRIPT SMALL B
\\scrc                      <char-0x1D4B8>               " 𝒸          : MATHEMATICAL SCRIPT SMALL C
\\scrd                      <char-0x1D4B9>               " 𝒹          : MATHEMATICAL SCRIPT SMALL D
\\scre                      <char-0x0212F>               " ℯ          : SCRIPT SMALL E
\\scrf                      <char-0x1D4BB>               " 𝒻          : MATHEMATICAL SCRIPT SMALL F
\\scrg                      <char-0x0210A>               " ℊ          : SCRIPT SMALL G
\\scrh                      <char-0x1D4BD>               " 𝒽          : MATHEMATICAL SCRIPT SMALL H
\\scri                      <char-0x1D4BE>               " 𝒾          : MATHEMATICAL SCRIPT SMALL I
\\scrj                      <char-0x1D4BF>               " 𝒿          : MATHEMATICAL SCRIPT SMALL J
\\scrk                      <char-0x1D4C0>               " 𝓀          : MATHEMATICAL SCRIPT SMALL K
\\scrl                      <char-0x1D4C1>               " 𝓁          : MATHEMATICAL SCRIPT SMALL L
\\scrm                      <char-0x1D4C2>               " 𝓂          : MATHEMATICAL SCRIPT SMALL M
\\scrn                      <char-0x1D4C3>               " 𝓃          : MATHEMATICAL SCRIPT SMALL N
\\scro                      <char-0x02134>               " ℴ          : SCRIPT SMALL O
\\scrp                      <char-0x1D4C5>               " 𝓅          : MATHEMATICAL SCRIPT SMALL P
\\scrq                      <char-0x1D4C6>               " 𝓆          : MATHEMATICAL SCRIPT SMALL Q
\\scrr                      <char-0x1D4C7>               " 𝓇          : MATHEMATICAL SCRIPT SMALL R
\\scrs                      <char-0x1D4C8>               " 𝓈          : MATHEMATICAL SCRIPT SMALL S
\\scrt                      <char-0x1D4C9>               " 𝓉          : MATHEMATICAL SCRIPT SMALL T
\\scru                      <char-0x1D4CA>               " 𝓊          : MATHEMATICAL SCRIPT SMALL U
\\scrv                      <char-0x1D4CB>               " 𝓋          : MATHEMATICAL SCRIPT SMALL V
\\scrw                      <char-0x1D4CC>               " 𝓌          : MATHEMATICAL SCRIPT SMALL W
\\scrx                      <char-0x1D4CD>               " 𝓍          : MATHEMATICAL SCRIPT SMALL X
\\scry                      <char-0x1D4CE>               " 𝓎          : MATHEMATICAL SCRIPT SMALL Y
\\scrz                      <char-0x1D4CF>               " 𝓏          : MATHEMATICAL SCRIPT SMALL Z
\\scurel                    <char-0x022B1>               " ⊱          : SUCCEEDS UNDER RELATION
\\searrow                   <char-0x02198>               " ↘          : SOUTH EAST ARROW / LOWER RIGHT ARROW
\\seovnearrow               <char-0x0292D>               " ⤭          : SOUTH EAST ARROW CROSSING NORTH EAST ARROW
\\setminus                  <char-0x02216>               " ∖          : SET MINUS
\\sharp                     <char-0x0266F>               " ♯          : MUSIC SHARP SIGN / SHARP
\\shuffle                   <char-0x029E2>               " ⧢          : SHUFFLE PRODUCT
\\sigma                     <char-0x003C3>               " σ          : GREEK SMALL LETTER SIGMA
\\sim                       <char-0x0223C>               " ∼          : TILDE OPERATOR
\\sim<Tab>                  <char-0x0223C>               " ∼          : TILDE OPERATOR
\\sime                      \\sime                       "            : (Incomplete sequence)
\\simeq                     <char-0x02243>               " ≃          : ASYMPTOTICALLY EQUAL TO
\\simg                      \\simg                       "            : (Incomplete sequence)
\\simgE                     <char-0x02AA0>               " ⪠          : SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN
\\simgtr                    <char-0x02A9E>               " ⪞          : SIMILAR OR GREATER-THAN
\\simi                      \\simi                       "            : (Incomplete sequence)
\\similarleftarrow          <char-0x02B49>               " ⭉          : TILDE OPERATOR ABOVE LEFTWARDS ARROW
\\siml                      \\siml                       "            : (Incomplete sequence)
\\simlE                     <char-0x02A9F>               " ⪟          : SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN
\\simless                   <char-0x02A9D>               " ⪝          : SIMILAR OR LESS-THAN
\\simm                      \\simm                       "            : (Incomplete sequence)
\\simminussim               <char-0x02A6C>               " ⩬          : SIMILAR MINUS SIMILAR
\\simp                      \\simp                       "            : (Incomplete sequence)
\\simplus                   <char-0x02A24>               " ⨤          : PLUS SIGN WITH TILDE ABOVE
\\simr                      \\simr                       "            : (Incomplete sequence)
\\simrdots                  <char-0x02A6B>               " ⩫          : TILDE OPERATOR WITH RISING DOTS
\\sinewave                  <char-0x0223F>               " ∿          : SINE WAVE
\\smallblacktriangleleft    <char-0x025C2>               " ◂          : BLACK LEFT-POINTING SMALL TRIANGLE / BLACK LEFT POINTING SMALL TRIANGLE
\\smallblacktriangleright   <char-0x025B8>               " ▸          : BLACK RIGHT-POINTING SMALL TRIANGLE / BLACK RIGHT POINTING SMALL TRIANGLE
\\smallin                   <char-0x0220A>               " ∊          : SMALL ELEMENT OF
\\smallni                   <char-0x0220D>               " ∍          : SMALL CONTAINS AS MEMBER
\\smalltriangleleft         <char-0x025C3>               " ◃          : WHITE LEFT-POINTING SMALL TRIANGLE / WHITE LEFT POINTING SMALL TRIANGLE
\\smalltriangleright        <char-0x025B9>               " ▹          : WHITE RIGHT-POINTING SMALL TRIANGLE / WHITE RIGHT POINTING SMALL TRIANGLE
\\smashtimes                <char-0x02A33>               " ⨳          : SMASH PRODUCT
\\smblkdiamond              <char-0x02B29>               " ⬩          : BLACK SMALL DIAMOND
\\smblklozenge              <char-0x02B2A>               " ⬪          : BLACK SMALL LOZENGE
\\smblksquare               <char-0x025AA>               " ▪          : BLACK SMALL SQUARE
\\smeparsl                  <char-0x029E4>               " ⧤          : EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE
\\smile                     <char-0x02323>               " ⌣          : SMILE
\\smt                       <char-0x02AAA>               " ⪪          : SMALLER THAN
\\smt<Tab>                  <char-0x02AAA>               " ⪪          : SMALLER THAN
\\smte                      <char-0x02AAC>               " ⪬          : SMALLER THAN OR EQUAL TO
\\smwhitestar               <char-0x02B52>               " ⭒          : WHITE SMALL STAR
\\smwhtcircle               <char-0x025E6>               " ◦          : WHITE BULLET
\\smwhtlozenge              <char-0x02B2B>               " ⬫          : WHITE SMALL LOZENGE
\\smwhtsquare               <char-0x025AB>               " ▫          : WHITE SMALL SQUARE
\\sout                      <char-0x00336>               " ◌̶          : COMBINING LONG STROKE OVERLAY / NON-SPACING LONG BAR OVERLAY
\\spadesuit                 <char-0x02660>               " ♠          : BLACK SPADE SUIT
\\sphericalangle            <char-0x02222>               " ∢          : SPHERICAL ANGLE
\\sphericalangle<Tab>       <char-0x02222>               " ∢          : SPHERICAL ANGLE
\\sphericalangleu           \\sphericalangleu            "            : (Incomplete sequence)
\\sphericalangleup          <char-0x029A1>               " ⦡          : SPHERICAL ANGLE OPENING UP
\\sqcap                     <char-0x02293>               " ⊓          : SQUARE CAP
\\sqcup                     <char-0x02294>               " ⊔          : SQUARE CUP
\\sqfl                      <char-0x025E7>               " ◧          : SQUARE WITH LEFT HALF BLACK
\\sqfnw                     <char-0x02519>               " ┙          : BOX DRAWINGS UP LIGHT AND LEFT HEAVY / FORMS UP LIGHT AND LEFT HEAVY
\\sqfr                      <char-0x025E8>               " ◨          : SQUARE WITH RIGHT HALF BLACK
\\sqfse                     <char-0x025EA>               " ◪          : SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK
\\sqlozenge                 <char-0x02311>               " ⌑          : SQUARE LOZENGE
\\sqrint                    <char-0x02A16>               " ⨖          : QUATERNION INTEGRAL OPERATOR
\\sqrt                      <char-0x0221A>               " √          : SQUARE ROOT
\\sqrt<Tab>                 <char-0x0221A>               " √          : SQUARE ROOT
\\sqrtb                     \\sqrtb                      "            : (Incomplete sequence)
\\sqrtbottom                <char-0x023B7>               " ⎷          : RADICAL SYMBOL BOTTOM
\\sqsubset                  <char-0x0228F>               " ⊏          : SQUARE IMAGE OF
\\sqsubset<Tab>             <char-0x0228F>               " ⊏          : SQUARE IMAGE OF
\\sqsubsete                 \\sqsubsete                  "            : (Incomplete sequence)
\\sqsubseteq                <char-0x02291>               " ⊑          : SQUARE IMAGE OF OR EQUAL TO
\\sqsubsetn                 \\sqsubsetn                  "            : (Incomplete sequence)
\\sqsubsetneq               <char-0x022E4>               " ⋤          : SQUARE IMAGE OF OR NOT EQUAL TO
\\sqsupset                  <char-0x02290>               " ⊐          : SQUARE ORIGINAL OF
\\sqsupset<Tab>             <char-0x02290>               " ⊐          : SQUARE ORIGINAL OF
\\sqsupsete                 \\sqsupsete                  "            : (Incomplete sequence)
\\sqsupseteq                <char-0x02292>               " ⊒          : SQUARE ORIGINAL OF OR EQUAL TO
\\sqsupsetn                 \\sqsupsetn                  "            : (Incomplete sequence)
\\sqsupsetneq               <char-0x022E5>               " ⋥          : SQUARE ORIGINAL OF OR NOT EQUAL TO
\\square                    <char-0x025A1>               " □          : WHITE SQUARE
\\square<Tab>               <char-0x025A1>               " □          : WHITE SQUARE
\\squareb                   \\squareb                    "            : (Incomplete sequence)
\\squarebotblack            <char-0x02B13>               " ⬓          : SQUARE WITH BOTTOM HALF BLACK
\\squarec                   \\squarec                    "            : (Incomplete sequence)
\\squarecrossfill           <char-0x025A9>               " ▩          : SQUARE WITH DIAGONAL CROSSHATCH FILL
\\squareh                   \\squareh                    "            : (Incomplete sequence)
\\squarehfill               <char-0x025A4>               " ▤          : SQUARE WITH HORIZONTAL FILL
\\squarehvfill              <char-0x025A6>               " ▦          : SQUARE WITH ORTHOGONAL CROSSHATCH FILL
\\squarel                   \\squarel                    "            : (Incomplete sequence)
\\squarellblack             <char-0x02B15>               " ⬕          : SQUARE WITH LOWER LEFT DIAGONAL HALF BLACK
\\squarellquad              <char-0x025F1>               " ◱          : WHITE SQUARE WITH LOWER LEFT QUADRANT
\\squarelrquad              <char-0x025F2>               " ◲          : WHITE SQUARE WITH LOWER RIGHT QUADRANT
\\squaren                   \\squaren                    "            : (Incomplete sequence)
\\squareneswfill            <char-0x025A8>               " ▨          : SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
\\squarenwsefill            <char-0x025A7>               " ▧          : SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
\\squaret                   \\squaret                    "            : (Incomplete sequence)
\\squaretopblack            <char-0x02B12>               " ⬒          : SQUARE WITH TOP HALF BLACK
\\squareu                   \\squareu                    "            : (Incomplete sequence)
\\squareulblack             <char-0x025E9>               " ◩          : SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK
\\squareulquad              <char-0x025F0>               " ◰          : WHITE SQUARE WITH UPPER LEFT QUADRANT
\\squareurblack             <char-0x02B14>               " ⬔          : SQUARE WITH UPPER RIGHT DIAGONAL HALF BLACK
\\squareurquad              <char-0x025F3>               " ◳          : WHITE SQUARE WITH UPPER RIGHT QUADRANT
\\squarev                   \\squarev                    "            : (Incomplete sequence)
\\squarevfill               <char-0x025A5>               " ▥          : SQUARE WITH VERTICAL FILL
\\squoval                   <char-0x025A2>               " ▢          : WHITE SQUARE WITH ROUNDED CORNERS
\\ss                        <char-0x000DF>               " ß          : LATIN SMALL LETTER SHARP S
\\star                      <char-0x022C6>               " ⋆          : STAR OPERATOR
\\star<Tab>                 <char-0x022C6>               " ⋆          : STAR OPERATOR
\\stare                     \\stare                      "            : (Incomplete sequence)
\\starequal                 <char-0x0225B>               " ≛          : STAR EQUALS
\\sterling                  <char-0x000A3>               " £          : POUND SIGN
\\stigma                    <char-0x003DB>               " ϛ          : GREEK SMALL LETTER STIGMA
\\strike                    <char-0x00336>               " ◌̶          : COMBINING LONG STROKE OVERLAY / NON-SPACING LONG BAR OVERLAY
\\strns                     <char-0x023E4>               " ⏤          : STRAIGHTNESS
\\subedot                   <char-0x02AC3>               " ⫃          : SUBSET OF OR EQUAL TO WITH DOT ABOVE
\\submult                   <char-0x02AC1>               " ⫁          : SUBSET WITH MULTIPLICATION SIGN BELOW
\\subset                    <char-0x02282>               " ⊂          : SUBSET OF
\\subset<Tab>               <char-0x02282>               " ⊂          : SUBSET OF
\\subseta                   \\subseta                    "            : (Incomplete sequence)
\\subsetapprox              <char-0x02AC9>               " ⫉          : SUBSET OF ABOVE ALMOST EQUAL TO
\\subsetd                   \\subsetd                    "            : (Incomplete sequence)
\\subsetdot                 <char-0x02ABD>               " ⪽          : SUBSET WITH DOT
\\subsete                   \\subsete                    "            : (Incomplete sequence)
\\subseteq                  <char-0x02286>               " ⊆          : SUBSET OF OR EQUAL TO
\\subseteq<Tab>             <char-0x02286>               " ⊆          : SUBSET OF OR EQUAL TO
\\subseteqq                 <char-0x02AC5>               " ⫅          : SUBSET OF ABOVE EQUALS SIGN
\\subsetn                   \\subsetn                    "            : (Incomplete sequence)
\\subsetneq                 <char-0x0228A>               " ⊊          : SUBSET OF WITH NOT EQUAL TO / SUBSET OF OR NOT EQUAL TO
\\subsetneq<Tab>            <char-0x0228A>               " ⊊          : SUBSET OF WITH NOT EQUAL TO / SUBSET OF OR NOT EQUAL TO
\\subsetneqq                <char-0x02ACB>               " ⫋          : SUBSET OF ABOVE NOT EQUAL TO
\\subsetp                   \\subsetp                    "            : (Incomplete sequence)
\\subsetplus                <char-0x02ABF>               " ⪿          : SUBSET WITH PLUS SIGN BELOW
\\subsim                    <char-0x02AC7>               " ⫇          : SUBSET OF ABOVE TILDE OPERATOR
\\subsub                    <char-0x02AD5>               " ⫕          : SUBSET ABOVE SUBSET
\\subsup                    <char-0x02AD3>               " ⫓          : SUBSET ABOVE SUPERSET
\\succ                      <char-0x0227B>               " ≻          : SUCCEEDS
\\succ<Tab>                 <char-0x0227B>               " ≻          : SUCCEEDS
\\succa                     \\succa                      "            : (Incomplete sequence)
\\succapprox                <char-0x02AB8>               " ⪸          : SUCCEEDS ABOVE ALMOST EQUAL TO
\\succc                     \\succc                      "            : (Incomplete sequence)
\\succcurlyeq               <char-0x0227D>               " ≽          : SUCCEEDS OR EQUAL TO
\\succe                     \\succe                      "            : (Incomplete sequence)
\\succeq                    <char-0x02AB0>               " ⪰          : SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
\\succeq<Tab>               <char-0x02AB0>               " ⪰          : SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
\\succeqq                   <char-0x02AB4>               " ⪴          : SUCCEEDS ABOVE EQUALS SIGN
\\succn                     \\succn                      "            : (Incomplete sequence)
\\succnapprox               <char-0x02ABA>               " ⪺          : SUCCEEDS ABOVE NOT ALMOST EQUAL TO
\\succneq                   <char-0x02AB2>               " ⪲          : SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO
\\succneq<Tab>              <char-0x02AB2>               " ⪲          : SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO
\\succneqq                  <char-0x02AB6>               " ⪶          : SUCCEEDS ABOVE NOT EQUAL TO
\\succnsim                  <char-0x022E9>               " ⋩          : SUCCEEDS BUT NOT EQUIVALENT TO
\\succs                     \\succs                      "            : (Incomplete sequence)
\\succsim                   <char-0x0227F>               " ≿          : SUCCEEDS OR EQUIVALENT TO
\\sum                       <char-0x02211>               " ∑          : N-ARY SUMMATION
\\sum<Tab>                  <char-0x02211>               " ∑          : N-ARY SUMMATION
\\sumi                      \\sumi                       "            : (Incomplete sequence)
\\sumint                    <char-0x02A0B>               " ⨋          : SUMMATION WITH INTEGRAL
\\sun                       <char-0x0263C>               " ☼          : WHITE SUN WITH RAYS
\\supdsub                   <char-0x02AD8>               " ⫘          : SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET
\\supedot                   <char-0x02AC4>               " ⫄          : SUPERSET OF OR EQUAL TO WITH DOT ABOVE
\\suphsol                   <char-0x027C9>               " ⟉          : SUPERSET PRECEDING SOLIDUS
\\suphsub                   <char-0x02AD7>               " ⫗          : SUPERSET BESIDE SUBSET
\\supmult                   <char-0x02AC2>               " ⫂          : SUPERSET WITH MULTIPLICATION SIGN BELOW
\\supset                    <char-0x02283>               " ⊃          : SUPERSET OF
\\supset<Tab>               <char-0x02283>               " ⊃          : SUPERSET OF
\\supseta                   \\supseta                    "            : (Incomplete sequence)
\\supsetapprox              <char-0x02ACA>               " ⫊          : SUPERSET OF ABOVE ALMOST EQUAL TO
\\supsetd                   \\supsetd                    "            : (Incomplete sequence)
\\supsetdot                 <char-0x02ABE>               " ⪾          : SUPERSET WITH DOT
\\supsete                   \\supsete                    "            : (Incomplete sequence)
\\supseteq                  <char-0x02287>               " ⊇          : SUPERSET OF OR EQUAL TO
\\supseteq<Tab>             <char-0x02287>               " ⊇          : SUPERSET OF OR EQUAL TO
\\supseteqq                 <char-0x02AC6>               " ⫆          : SUPERSET OF ABOVE EQUALS SIGN
\\supsetn                   \\supsetn                    "            : (Incomplete sequence)
\\supsetneq                 <char-0x0228B>               " ⊋          : SUPERSET OF WITH NOT EQUAL TO / SUPERSET OF OR NOT EQUAL TO
\\supsetneq<Tab>            <char-0x0228B>               " ⊋          : SUPERSET OF WITH NOT EQUAL TO / SUPERSET OF OR NOT EQUAL TO
\\supsetneqq                <char-0x02ACC>               " ⫌          : SUPERSET OF ABOVE NOT EQUAL TO
\\supsetp                   \\supsetp                    "            : (Incomplete sequence)
\\supsetplus                <char-0x02AC0>               " ⫀          : SUPERSET WITH PLUS SIGN BELOW
\\supsim                    <char-0x02AC8>               " ⫈          : SUPERSET OF ABOVE TILDE OPERATOR
\\supsub                    <char-0x02AD4>               " ⫔          : SUPERSET ABOVE SUBSET
\\supsup                    <char-0x02AD6>               " ⫖          : SUPERSET ABOVE SUPERSET
\\surd                      <char-0x0221A>               " √          : SQUARE ROOT
\\swarrow                   <char-0x02199>               " ↙          : SOUTH WEST ARROW / LOWER LEFT ARROW
\\tau                       <char-0x003C4>               " τ          : GREEK SMALL LETTER TAU
\\tau<Tab>                  <char-0x003C4>               " τ          : GREEK SMALL LETTER TAU
\\taur                      \\taur                       "            : (Incomplete sequence)
\\taurus                    <char-0x02649>               " ♉         : TAURUS
\\tdcol                     <char-0x02AF6>               " ⫶          : TRIPLE COLON OPERATOR
\\tesh                      <char-0x002A7>               " ʧ          : LATIN SMALL LETTER TESH DIGRAPH / LATIN SMALL LETTER T ESH
\\th                        <char-0x000FE>               " þ          : LATIN SMALL LETTER THORN
\\th<Tab>                   <char-0x000FE>               " þ          : LATIN SMALL LETTER THORN
\\the                       \\the                        "            : (Incomplete sequence)
\\therefore                 <char-0x02234>               " ∴          : THEREFORE
\\theta                     <char-0x003B8>               " θ          : GREEK SMALL LETTER THETA
\\thi                       \\thi                        "            : (Incomplete sequence)
\\thickspace                <char-0x02005>               "            : FOUR-PER-EM SPACE
\\thinspace                 <char-0x02009>               "            : THIN SPACE
\\thr                       \\thr                        "            : (Incomplete sequence)
\\threedangle               <char-0x027C0>               " ⟀          : THREE DIMENSIONAL ANGLE
\\threeunderdot             <char-0x020E8>               " ◌⃨          : COMBINING TRIPLE UNDERDOT
\\tieconcat                 <char-0x02040>               " ⁀          : CHARACTER TIE
\\tilde                     <char-0x00303>               " ◌̃          : COMBINING TILDE / NON-SPACING TILDE
\\tilde<Tab>                <char-0x00303>               " ◌̃          : COMBINING TILDE / NON-SPACING TILDE
\\tildel                    \\tildel                     "            : (Incomplete sequence)
\\tildelow                  <char-0x002DC>               " ˜          : SMALL TILDE / SPACING TILDE
\\tildet                    \\tildet                     "            : (Incomplete sequence)
\\tildetrpl                 <char-0x0224B>               " ≋          : TRIPLE TILDE
\\times                     <char-0x000D7>               " ×          : MULTIPLICATION SIGN
\\times<Tab>                <char-0x000D7>               " ×          : MULTIPLICATION SIGN
\\timesb                    \\timesb                     "            : (Incomplete sequence)
\\timesbar                  <char-0x02A31>               " ⨱          : MULTIPLICATION SIGN WITH UNDERBAR
\\to                        <char-0x02192>               " →          : RIGHTWARDS ARROW / RIGHT ARROW
\\to<Tab>                   <char-0x02192>               " →          : RIGHTWARDS ARROW / RIGHT ARROW
\\toe                       \\toe                        "            : (Incomplete sequence)
\\toea                      <char-0x02928>               " ⤨          : NORTH EAST ARROW AND SOUTH EAST ARROW
\\ton                       \\ton                        "            : (Incomplete sequence)
\\tona                      <char-0x02927>               " ⤧          : NORTH WEST ARROW AND NORTH EAST ARROW
\\top                       <char-0x022A4>               " ⊤          : DOWN TACK
\\top<Tab>                  <char-0x022A4>               " ⊤          : DOWN TACK
\\topb                      \\topb                       "            : (Incomplete sequence)
\\topbot                    <char-0x02336>               " ⌶          : APL FUNCTIONAL SYMBOL I-BEAM
\\tops                      \\tops                       "            : (Incomplete sequence)
\\topsemicircle             <char-0x025E0>               " ◠          : UPPER HALF CIRCLE
\\tos                       \\tos                        "            : (Incomplete sequence)
\\tosa                      <char-0x02929>               " ⤩          : SOUTH EAST ARROW AND SOUTH WEST ARROW
\\tow                       \\tow                        "            : (Incomplete sequence)
\\towa                      <char-0x0292A>               " ⤪          : SOUTH WEST ARROW AND NORTH WEST ARROW
\\trademark                 <char-0x02122>               " ™          : TRADE MARK SIGN / TRADEMARK
\\trapezium                 <char-0x023E2>               " ⏢          : WHITE TRAPEZIUM
\\trianglecdot              <char-0x025EC>               " ◬          : WHITE UP-POINTING TRIANGLE WITH DOT / WHITE UP POINTING TRIANGLE WITH DOT
\\triangledown              <char-0x025BF>               " ▿          : WHITE DOWN-POINTING SMALL TRIANGLE / WHITE DOWN POINTING SMALL TRIANGLE
\\triangleleft              <char-0x025C1>               " ◁          : WHITE LEFT-POINTING TRIANGLE / WHITE LEFT POINTING TRIANGLE
\\triangleleft<Tab>         <char-0x025C1>               " ◁          : WHITE LEFT-POINTING TRIANGLE / WHITE LEFT POINTING TRIANGLE
\\triangleleftb             \\triangleleftb              "            : (Incomplete sequence)
\\triangleleftblack         <char-0x025ED>               " ◭          : UP-POINTING TRIANGLE WITH LEFT HALF BLACK / UP POINTING TRIANGLE WITH LEFT HALF BLACK
\\trianglelefte             \\trianglelefte              "            : (Incomplete sequence)
\\trianglelefteq            <char-0x022B4>               " ⊴          : NORMAL SUBGROUP OF OR EQUAL TO
\\triangleminus             <char-0x02A3A>               " ⨺          : MINUS SIGN IN TRIANGLE
\\triangleplus              <char-0x02A39>               " ⨹          : PLUS SIGN IN TRIANGLE
\\triangleq                 <char-0x0225C>               " ≜          : DELTA EQUAL TO
\\triangleright             <char-0x025B7>               " ▷          : WHITE RIGHT-POINTING TRIANGLE / WHITE RIGHT POINTING TRIANGLE
\\triangleright<Tab>        <char-0x025B7>               " ▷          : WHITE RIGHT-POINTING TRIANGLE / WHITE RIGHT POINTING TRIANGLE
\\trianglerightb            \\trianglerightb             "            : (Incomplete sequence)
\\trianglerightblack        <char-0x025EE>               " ◮          : UP-POINTING TRIANGLE WITH RIGHT HALF BLACK / UP POINTING TRIANGLE WITH RIGHT HALF BLACK
\\trianglerighte            \\trianglerighte             "            : (Incomplete sequence)
\\trianglerighteq           <char-0x022B5>               " ⊵          : CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
\\triangletimes             <char-0x02A3B>               " ⨻          : MULTIPLICATION SIGN IN TRIANGLE
\\tricolon                  <char-0x0205D>               " ⁝          : TRICOLON
\\tripleplus                <char-0x029FB>               " ⧻          : TRIPLE PLUS
\\trna                      <char-0x00250>               " ɐ          : LATIN SMALL LETTER TURNED A
\\trnh                      <char-0x00265>               " ɥ          : LATIN SMALL LETTER TURNED H
\\trnm                      <char-0x0026F>               " ɯ          : LATIN SMALL LETTER TURNED M
\\trnm<Tab>                 <char-0x0026F>               " ɯ          : LATIN SMALL LETTER TURNED M
\\trnml                     \\trnml                      "            : (Incomplete sequence)
\\trnmlr                    <char-0x00270>               " ɰ          : LATIN SMALL LETTER TURNED M WITH LONG LEG
\\trnr                      <char-0x00279>               " ɹ          : LATIN SMALL LETTER TURNED R
\\trnr<Tab>                 <char-0x00279>               " ɹ          : LATIN SMALL LETTER TURNED R
\\trnrl                     <char-0x0027A>               " ɺ          : LATIN SMALL LETTER TURNED R WITH LONG LEG
\\trnsa                     <char-0x00252>               " ɒ          : LATIN SMALL LETTER TURNED ALPHA / LATIN SMALL LETTER TURNED SCRIPT A
\\trnt                      <char-0x00287>               " ʇ          : LATIN SMALL LETTER TURNED T
\\trny                      <char-0x0028E>               " ʎ          : LATIN SMALL LETTER TURNED Y
\\ttA                       <char-0x1D670>               " 𝙰          : MATHEMATICAL MONOSPACE CAPITAL A
\\ttB                       <char-0x1D671>               " 𝙱          : MATHEMATICAL MONOSPACE CAPITAL B
\\ttC                       <char-0x1D672>               " 𝙲          : MATHEMATICAL MONOSPACE CAPITAL C
\\ttD                       <char-0x1D673>               " 𝙳          : MATHEMATICAL MONOSPACE CAPITAL D
\\ttE                       <char-0x1D674>               " 𝙴          : MATHEMATICAL MONOSPACE CAPITAL E
\\ttF                       <char-0x1D675>               " 𝙵          : MATHEMATICAL MONOSPACE CAPITAL F
\\ttG                       <char-0x1D676>               " 𝙶          : MATHEMATICAL MONOSPACE CAPITAL G
\\ttH                       <char-0x1D677>               " 𝙷          : MATHEMATICAL MONOSPACE CAPITAL H
\\ttI                       <char-0x1D678>               " 𝙸          : MATHEMATICAL MONOSPACE CAPITAL I
\\ttJ                       <char-0x1D679>               " 𝙹          : MATHEMATICAL MONOSPACE CAPITAL J
\\ttK                       <char-0x1D67A>               " 𝙺          : MATHEMATICAL MONOSPACE CAPITAL K
\\ttL                       <char-0x1D67B>               " 𝙻          : MATHEMATICAL MONOSPACE CAPITAL L
\\ttM                       <char-0x1D67C>               " 𝙼          : MATHEMATICAL MONOSPACE CAPITAL M
\\ttN                       <char-0x1D67D>               " 𝙽          : MATHEMATICAL MONOSPACE CAPITAL N
\\ttO                       <char-0x1D67E>               " 𝙾          : MATHEMATICAL MONOSPACE CAPITAL O
\\ttP                       <char-0x1D67F>               " 𝙿          : MATHEMATICAL MONOSPACE CAPITAL P
\\ttQ                       <char-0x1D680>               " 𝚀          : MATHEMATICAL MONOSPACE CAPITAL Q
\\ttR                       <char-0x1D681>               " 𝚁          : MATHEMATICAL MONOSPACE CAPITAL R
\\ttS                       <char-0x1D682>               " 𝚂          : MATHEMATICAL MONOSPACE CAPITAL S
\\ttT                       <char-0x1D683>               " 𝚃          : MATHEMATICAL MONOSPACE CAPITAL T
\\ttU                       <char-0x1D684>               " 𝚄          : MATHEMATICAL MONOSPACE CAPITAL U
\\ttV                       <char-0x1D685>               " 𝚅          : MATHEMATICAL MONOSPACE CAPITAL V
\\ttW                       <char-0x1D686>               " 𝚆          : MATHEMATICAL MONOSPACE CAPITAL W
\\ttX                       <char-0x1D687>               " 𝚇          : MATHEMATICAL MONOSPACE CAPITAL X
\\ttY                       <char-0x1D688>               " 𝚈          : MATHEMATICAL MONOSPACE CAPITAL Y
\\ttZ                       <char-0x1D689>               " 𝚉          : MATHEMATICAL MONOSPACE CAPITAL Z
\\tta                       <char-0x1D68A>               " 𝚊          : MATHEMATICAL MONOSPACE SMALL A
\\ttb                       <char-0x1D68B>               " 𝚋          : MATHEMATICAL MONOSPACE SMALL B
\\ttc                       <char-0x1D68C>               " 𝚌          : MATHEMATICAL MONOSPACE SMALL C
\\ttd                       <char-0x1D68D>               " 𝚍          : MATHEMATICAL MONOSPACE SMALL D
\\tte                       <char-0x1D68E>               " 𝚎          : MATHEMATICAL MONOSPACE SMALL E
\\tte<Tab>                  <char-0x1D68E>               " 𝚎          : MATHEMATICAL MONOSPACE SMALL E
\\ttei                      \\ttei                       "            : (Incomplete sequence)
\\tteight                   <char-0x1D7FE>               " 𝟾          : MATHEMATICAL MONOSPACE DIGIT EIGHT
\\ttf                       <char-0x1D68F>               " 𝚏          : MATHEMATICAL MONOSPACE SMALL F
\\ttf<Tab>                  <char-0x1D68F>               " 𝚏          : MATHEMATICAL MONOSPACE SMALL F
\\ttfi                      \\ttfi                       "            : (Incomplete sequence)
\\ttfive                    <char-0x1D7FB>               " 𝟻          : MATHEMATICAL MONOSPACE DIGIT FIVE
\\ttfo                      \\ttfo                       "            : (Incomplete sequence)
\\ttfour                    <char-0x1D7FA>               " 𝟺          : MATHEMATICAL MONOSPACE DIGIT FOUR
\\ttg                       <char-0x1D690>               " 𝚐          : MATHEMATICAL MONOSPACE SMALL G
\\tth                       <char-0x1D691>               " 𝚑          : MATHEMATICAL MONOSPACE SMALL H
\\tti                       <char-0x1D692>               " 𝚒          : MATHEMATICAL MONOSPACE SMALL I
\\ttj                       <char-0x1D693>               " 𝚓          : MATHEMATICAL MONOSPACE SMALL J
\\ttk                       <char-0x1D694>               " 𝚔          : MATHEMATICAL MONOSPACE SMALL K
\\ttl                       <char-0x1D695>               " 𝚕          : MATHEMATICAL MONOSPACE SMALL L
\\ttm                       <char-0x1D696>               " 𝚖          : MATHEMATICAL MONOSPACE SMALL M
\\ttn                       <char-0x1D697>               " 𝚗          : MATHEMATICAL MONOSPACE SMALL N
\\ttn<Tab>                  <char-0x1D697>               " 𝚗          : MATHEMATICAL MONOSPACE SMALL N
\\ttni                      \\ttni                       "            : (Incomplete sequence)
\\ttnine                    <char-0x1D7FF>               " 𝟿          : MATHEMATICAL MONOSPACE DIGIT NINE
\\tto                       <char-0x1D698>               " 𝚘          : MATHEMATICAL MONOSPACE SMALL O
\\tto<Tab>                  <char-0x1D698>               " 𝚘          : MATHEMATICAL MONOSPACE SMALL O
\\tton                      \\tton                       "            : (Incomplete sequence)
\\ttone                     <char-0x1D7F7>               " 𝟷          : MATHEMATICAL MONOSPACE DIGIT ONE
\\ttp                       <char-0x1D699>               " 𝚙          : MATHEMATICAL MONOSPACE SMALL P
\\ttq                       <char-0x1D69A>               " 𝚚          : MATHEMATICAL MONOSPACE SMALL Q
\\ttr                       <char-0x1D69B>               " 𝚛          : MATHEMATICAL MONOSPACE SMALL R
\\tts                       <char-0x1D69C>               " 𝚜          : MATHEMATICAL MONOSPACE SMALL S
\\tts<Tab>                  <char-0x1D69C>               " 𝚜          : MATHEMATICAL MONOSPACE SMALL S
\\ttse                      \\ttse                       "            : (Incomplete sequence)
\\ttseven                   <char-0x1D7FD>               " 𝟽          : MATHEMATICAL MONOSPACE DIGIT SEVEN
\\ttsi                      \\ttsi                       "            : (Incomplete sequence)
\\ttsix                     <char-0x1D7FC>               " 𝟼          : MATHEMATICAL MONOSPACE DIGIT SIX
\\ttt                       <char-0x1D69D>               " 𝚝          : MATHEMATICAL MONOSPACE SMALL T
\\ttt<Tab>                  <char-0x1D69D>               " 𝚝          : MATHEMATICAL MONOSPACE SMALL T
\\ttth                      \\ttth                       "            : (Incomplete sequence)
\\ttthree                   <char-0x1D7F9>               " 𝟹          : MATHEMATICAL MONOSPACE DIGIT THREE
\\tttw                      \\tttw                       "            : (Incomplete sequence)
\\tttwo                     <char-0x1D7F8>               " 𝟸          : MATHEMATICAL MONOSPACE DIGIT TWO
\\ttu                       <char-0x1D69E>               " 𝚞          : MATHEMATICAL MONOSPACE SMALL U
\\ttv                       <char-0x1D69F>               " 𝚟          : MATHEMATICAL MONOSPACE SMALL V
\\ttw                       <char-0x1D6A0>               " 𝚠          : MATHEMATICAL MONOSPACE SMALL W
\\ttx                       <char-0x1D6A1>               " 𝚡          : MATHEMATICAL MONOSPACE SMALL X
\\tty                       <char-0x1D6A2>               " 𝚢          : MATHEMATICAL MONOSPACE SMALL Y
\\ttz                       <char-0x1D6A3>               " 𝚣          : MATHEMATICAL MONOSPACE SMALL Z
\\ttz<Tab>                  <char-0x1D6A3>               " 𝚣          : MATHEMATICAL MONOSPACE SMALL Z
\\ttze                      \\ttze                       "            : (Incomplete sequence)
\\ttzero                    <char-0x1D7F6>               " 𝟶          : MATHEMATICAL MONOSPACE DIGIT ZERO
\\turnangle                 <char-0x029A2>               " ⦢          : TURNED ANGLE
\\turnediota                <char-0x02129>               " ℩          : TURNED GREEK SMALL LETTER IOTA
\\turnednot                 <char-0x02319>               " ⌙          : TURNED NOT SIGN
\\turnk                     <char-0x0029E>               " ʞ          : LATIN SMALL LETTER TURNED K
\\twocaps                   <char-0x02A4B>               " ⩋          : INTERSECTION BESIDE AND JOINED WITH INTERSECTION
\\twocups                   <char-0x02A4A>               " ⩊          : UNION BESIDE AND JOINED WITH UNION
\\twoheaddownarrow          <char-0x021A1>               " ↡          : DOWNWARDS TWO HEADED ARROW / DOWN TWO HEADED ARROW
\\twoheadleftarrow          <char-0x0219E>               " ↞          : LEFTWARDS TWO HEADED ARROW / LEFT TWO HEADED ARROW
\\twoheadleftarrow<Tab>     <char-0x0219E>               " ↞          : LEFTWARDS TWO HEADED ARROW / LEFT TWO HEADED ARROW
\\twoheadleftarrowt         \\twoheadleftarrowt          "            : (Incomplete sequence)
\\twoheadleftarrowtail      <char-0x02B3B>               " ⬻          : LEFTWARDS TWO-HEADED ARROW WITH TAIL
\\twoheadleftdbkarrow       <char-0x02B37>               " ⬷          : LEFTWARDS TWO-HEADED TRIPLE DASH ARROW
\\twoheadmapsfrom           <char-0x02B36>               " ⬶          : LEFTWARDS TWO-HEADED ARROW FROM BAR
\\twoheadmapsto             <char-0x02905>               " ⤅          : RIGHTWARDS TWO-HEADED ARROW FROM BAR
\\twoheadrightarrow         <char-0x021A0>               " ↠          : RIGHTWARDS TWO HEADED ARROW / RIGHT TWO HEADED ARROW
\\twoheadrightarrow<Tab>    <char-0x021A0>               " ↠          : RIGHTWARDS TWO HEADED ARROW / RIGHT TWO HEADED ARROW
\\twoheadrightarrowt        \\twoheadrightarrowt         "            : (Incomplete sequence)
\\twoheadrightarrowtail     <char-0x02916>               " ⤖          : RIGHTWARDS TWO-HEADED ARROW WITH TAIL
\\twoheaduparrow            <char-0x0219F>               " ↟          : UPWARDS TWO HEADED ARROW / UP TWO HEADED ARROW
\\twoheaduparrow<Tab>       <char-0x0219F>               " ↟          : UPWARDS TWO HEADED ARROW / UP TWO HEADED ARROW
\\twoheaduparrowc           \\twoheaduparrowc            "            : (Incomplete sequence)
\\twoheaduparrowcircle      <char-0x02949>               " ⥉          : UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE
\\twonotes                  <char-0x0266B>               " ♫          : BEAMED EIGHTH NOTES / BARRED EIGHTH NOTES
\\u                         <char-0x002D8>               " ˘          : BREVE / SPACING BREVE
\\u<Tab>                    <char-0x002D8>               " ˘          : BREVE / SPACING BREVE
\\ul                        \\ul                         "            : (Incomplete sequence)
\\ularc                     <char-0x025DC>               " ◜          : UPPER LEFT QUADRANT CIRCULAR ARC
\\ulblacktriangle           <char-0x025E4>               " ◤          : BLACK UPPER LEFT TRIANGLE
\\ulcorner                  <char-0x0231C>               " ⌜          : TOP LEFT CORNER
\\ultriangle                <char-0x025F8>               " ◸          : UPPER LEFT TRIANGLE
\\um                        \\um                         "            : (Incomplete sequence)
\\uminus                    <char-0x02A41>               " ⩁          : UNION WITH MINUS SIGN
\\un                        \\un                         "            : (Incomplete sequence)
\\underbar                  <char-0x00332>               " ◌̲          : COMBINING LOW LINE / NON-SPACING UNDERSCORE
\\underbrace                <char-0x023DF>               " ⏟          : BOTTOM CURLY BRACKET
\\underbracket              <char-0x023B5>               " ⎵          : BOTTOM SQUARE BRACKET
\\underleftarrow            <char-0x020EE>               " ◌⃮          : COMBINING LEFT ARROW BELOW
\\underleftharpoondown      <char-0x020ED>               " ◌⃭          : COMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDS
\\underleftrightarrow       <char-0x0034D>               " ◌͍          : COMBINING LEFT RIGHT ARROW BELOW
\\underrightarrow           <char-0x020EF>               " ◌⃯          : COMBINING RIGHT ARROW BELOW
\\underrightharpoondown     <char-0x020EC>               " ◌⃬          : COMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDS
\\up                        \\up                         "            : (Incomplete sequence)
\\upand                     <char-0x0214B>               " ⅋          : TURNED AMPERSAND
\\uparrow                   <char-0x02191>               " ↑          : UPWARDS ARROW / UP ARROW
\\uparrow<Tab>              <char-0x02191>               " ↑          : UPWARDS ARROW / UP ARROW
\\uparrowb                  \\uparrowb                   "            : (Incomplete sequence)
\\uparrowbarred             <char-0x02909>               " ⤉          : UPWARDS ARROW WITH HORIZONTAL STROKE
\\updasharrow               <char-0x021E1>               " ⇡          : UPWARDS DASHED ARROW / UP DASHED ARROW
\\updownarrow               <char-0x02195>               " ↕          : UP DOWN ARROW
\\updownarrow<Tab>          <char-0x02195>               " ↕          : UP DOWN ARROW
\\updownarrowb              \\updownarrowb               "            : (Incomplete sequence)
\\updownarrowbar            <char-0x021A8>               " ↨          : UP DOWN ARROW WITH BASE
\\updownharpoonleftright    <char-0x0294D>               " ⥍          : UP BARB LEFT DOWN BARB RIGHT HARPOON
\\updownharpoonrightleft    <char-0x0294C>               " ⥌          : UP BARB RIGHT DOWN BARB LEFT HARPOON
\\upharpoonleft             <char-0x021BF>               " ↿          : UPWARDS HARPOON WITH BARB LEFTWARDS / UP HARPOON WITH BARB LEFT
\\upharpoonright            <char-0x021BE>               " ↾          : UPWARDS HARPOON WITH BARB RIGHTWARDS / UP HARPOON WITH BARB RIGHT
\\upharpoonsleftright       <char-0x02963>               " ⥣          : UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
\\upin                      <char-0x027D2>               " ⟒          : ELEMENT OF OPENING UPWARDS
\\upin<Tab>                 <char-0x027D2>               " ⟒          : ELEMENT OF OPENING UPWARDS
\\upint                     <char-0x02A1B>               " ⨛          : INTEGRAL WITH OVERBAR
\\uplus                     <char-0x0228E>               " ⊎          : MULTISET UNION
\\upsilon                   <char-0x003C5>               " υ          : GREEK SMALL LETTER UPSILON
\\upuparrows                <char-0x021C8>               " ⇈          : UPWARDS PAIRED ARROWS / UP PAIRED ARROWS
\\upvDash                   <char-0x02AEB>               " ⫫          : DOUBLE UP TACK
\\upwhitearrow              <char-0x021E7>               " ⇧          : UPWARDS WHITE ARROW / WHITE UP ARROW
\\ur                        \\ur                         "            : (Incomplete sequence)
\\uranus                    <char-0x02645>               " ♅          : URANUS
\\urarc                     <char-0x025DD>               " ◝          : UPPER RIGHT QUADRANT CIRCULAR ARC
\\urblacktriangle           <char-0x025E5>               " ◥          : BLACK UPPER RIGHT TRIANGLE
\\urcorner                  <char-0x0231D>               " ⌝          : TOP RIGHT CORNER
\\urtriangle                <char-0x025F9>               " ◹          : UPPER RIGHT TRIANGLE
\\vDash                     <char-0x022A8>               " ⊨          : TRUE
\\varTheta                  <char-0x003F4>               " ϴ          : GREEK CAPITAL THETA SYMBOL
\\varbarwedge               <char-0x02305>               " ⌅          : PROJECTIVE
\\varbeta                   <char-0x003D0>               " ϐ          : GREEK BETA SYMBOL / GREEK SMALL LETTER CURLED BETA
\\varcarriagereturn         <char-0x023CE>               " ⏎          : RETURN SYMBOL
\\varclubsuit               <char-0x02667>               " ♧          : WHITE CLUB SUIT
\\vardiamondsuit            <char-0x02666>               " ♦          : BLACK DIAMOND SUIT
\\vardoublebarwedge         <char-0x02306>               " ⌆          : PERSPECTIVE
\\varepsilon                <char-0x003B5>               " ε          : GREEK SMALL LETTER EPSILON
\\varheartsuit              <char-0x02665>               " ♥          : BLACK HEART SUIT
\\varhexagon                <char-0x02B21>               " ⬡          : WHITE HEXAGON
\\varhexagon<Tab>           <char-0x02B21>               " ⬡          : WHITE HEXAGON
\\varhexagonb               \\varhexagonb                "            : (Incomplete sequence)
\\varhexagonblack           <char-0x02B22>               " ⬢          : BLACK HEXAGON
\\varhexagonl               \\varhexagonl                "            : (Incomplete sequence)
\\varhexagonlrbonds         <char-0x0232C>               " ⌬          : BENZENE RING
\\varisinobar               <char-0x022F6>               " ⋶          : ELEMENT OF WITH OVERBAR
\\varisins                  <char-0x022F3>               " ⋳          : ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
\\varkappa                  <char-0x003F0>               " ϰ          : GREEK KAPPA SYMBOL / GREEK SMALL LETTER SCRIPT KAPPA
\\varlrtriangle             <char-0x022BF>               " ⊿          : RIGHT TRIANGLE
\\varniobar                 <char-0x022FD>               " ⋽          : CONTAINS WITH OVERBAR
\\varnis                    <char-0x022FB>               " ⋻          : CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
\\varnothing                <char-0x02205>               " ∅          : EMPTY SET
\\varointclockwise          <char-0x02232>               " ∲          : CLOCKWISE CONTOUR INTEGRAL
\\varphi                    <char-0x003C6>               " φ          : GREEK SMALL LETTER PHI
\\varpi                     <char-0x003D6>               " ϖ          : GREEK PI SYMBOL / GREEK SMALL LETTER OMEGA PI
\\varrho                    <char-0x003F1>               " ϱ          : GREEK RHO SYMBOL / GREEK SMALL LETTER TAILED RHO
\\varsigma                  <char-0x003C2>               " ς          : GREEK SMALL LETTER FINAL SIGMA
\\varspadesuit              <char-0x02664>               " ♤          : WHITE SPADE SUIT
\\varstar                   <char-0x02736>               " ✶          : SIX POINTED BLACK STAR
\\varsubsetneqq             <char-0x0228A><char-0x0FE00> " ⊊︀          : SUBSET OF WITH NOT EQUAL TO / SUBSET OF OR NOT EQUAL TO + VARIATION SELECTOR-1
\\varsupsetneq              <char-0x0228B><char-0x0FE00> " ⊋︀          : SUPERSET OF WITH NOT EQUAL TO / SUPERSET OF OR NOT EQUAL TO + VARIATION SELECTOR-1
\\vartheta                  <char-0x003D1>               " ϑ          : GREEK THETA SYMBOL / GREEK SMALL LETTER SCRIPT THETA
\\vartriangle               <char-0x025B5>               " ▵          : WHITE UP-POINTING SMALL TRIANGLE / WHITE UP POINTING SMALL TRIANGLE
\\vartriangle<Tab>          <char-0x025B5>               " ▵          : WHITE UP-POINTING SMALL TRIANGLE / WHITE UP POINTING SMALL TRIANGLE
\\vartrianglel              \\vartrianglel               "            : (Incomplete sequence)
\\vartriangleleft           <char-0x022B2>               " ⊲          : NORMAL SUBGROUP OF
\\vartriangler              \\vartriangler               "            : (Incomplete sequence)
\\vartriangleright          <char-0x022B3>               " ⊳          : CONTAINS AS NORMAL SUBGROUP
\\varveebar                 <char-0x02A61>               " ⩡          : SMALL VEE WITH UNDERBAR
\\vdash                     <char-0x022A2>               " ⊢          : RIGHT TACK
\\vdots                     <char-0x022EE>               " ⋮          : VERTICAL ELLIPSIS
\\vec                       <char-0x020D7>               " ◌⃗          : COMBINING RIGHT ARROW ABOVE / NON-SPACING RIGHT ARROW ABOVE
\\vee                       <char-0x02228>               " ∨          : LOGICAL OR
\\vee<Tab>                  <char-0x02228>               " ∨          : LOGICAL OR
\\veeb                      \\veeb                       "            : (Incomplete sequence)
\\veebar                    <char-0x022BB>               " ⊻          : XOR
\\veed                      \\veed                       "            : (Incomplete sequence)
\\veedot                    <char-0x027C7>               " ⟇          : OR WITH DOT INSIDE
\\veedoublebar              <char-0x02A63>               " ⩣          : LOGICAL OR WITH DOUBLE UNDERBAR
\\veee                      \\veee                       "            : (Incomplete sequence)
\\veeeq                     <char-0x0225A>               " ≚          : EQUIANGULAR TO
\\veem                      \\veem                       "            : (Incomplete sequence)
\\veemidvert                <char-0x02A5B>               " ⩛          : LOGICAL OR WITH MIDDLE STEM
\\veeo                      \\veeo                       "            : (Incomplete sequence)
\\veeodot                   <char-0x02A52>               " ⩒          : LOGICAL OR WITH DOT ABOVE
\\venus                     <char-0x02640>               " ♀          : FEMALE SIGN
\\verti                     <char-0x002CC>               " ˌ          : MODIFIER LETTER LOW VERTICAL LINE
\\vertoverlay               <char-0x020D2>               " ◌⃒          : COMBINING LONG VERTICAL LINE OVERLAY / NON-SPACING LONG VERTICAL BAR OVERLAY
\\verts                     <char-0x002C8>               " ˈ          : MODIFIER LETTER VERTICAL LINE
\\verymuchless              <char-0x022D8>               " ⋘          : VERY MUCH LESS-THAN / VERY MUCH LESS THAN
\\viewdata                  <char-0x02317>               " ⌗          : VIEWDATA SQUARE
\\virgo                     <char-0x0264D>               " ♍         : VIRGO
\\visiblespace              <char-0x02423>               " ␣          : OPEN BOX
\\vrectangleblack           <char-0x025AE>               " ▮          : BLACK VERTICAL RECTANGLE
\\vrecto                    <char-0x025AF>               " ▯          : WHITE VERTICAL RECTANGLE
\\vysmblkcircle             <char-0x02219>               " ∙          : BULLET OPERATOR
\\vysmblksquare             <char-0x02B1D>               " ⬝          : BLACK VERY SMALL SQUARE
\\vysmwhtsquare             <char-0x02B1E>               " ⬞          : WHITE VERY SMALL SQUARE
\\wedge                     <char-0x02227>               " ∧          : LOGICAL AND
\\wedge<Tab>                <char-0x02227>               " ∧          : LOGICAL AND
\\wedged                    \\wedged                     "            : (Incomplete sequence)
\\wedgedot                  <char-0x027D1>               " ⟑          : AND WITH DOT
\\wedgedoublebar            <char-0x02A60>               " ⩠          : LOGICAL AND WITH DOUBLE UNDERBAR
\\wedgem                    \\wedgem                     "            : (Incomplete sequence)
\\wedgemidvert              <char-0x02A5A>               " ⩚          : LOGICAL AND WITH MIDDLE STEM
\\wedgeo                    \\wedgeo                     "            : (Incomplete sequence)
\\wedgeodot                 <char-0x02A51>               " ⩑          : LOGICAL AND WITH DOT ABOVE
\\wedgeonwedge              <char-0x02A55>               " ⩕          : TWO INTERSECTING LOGICAL AND
\\wedgeq                    <char-0x02259>               " ≙          : ESTIMATES
\\whitearrowupfrombar       <char-0x021EA>               " ⇪          : UPWARDS WHITE ARROW FROM BAR / WHITE UP ARROW FROM BAR
\\whiteinwhitetriangle      <char-0x027C1>               " ⟁          : WHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLE
\\whitepointerleft          <char-0x025C5>               " ◅          : WHITE LEFT-POINTING POINTER / WHITE LEFT POINTING POINTER
\\whitepointerright         <char-0x025BB>               " ▻          : WHITE RIGHT-POINTING POINTER / WHITE RIGHT POINTING POINTER
\\whthorzoval               <char-0x02B2D>               " ⬭          : WHITE HORIZONTAL ELLIPSE
\\whtvertoval               <char-0x02B2F>               " ⬯          : WHITE VERTICAL ELLIPSE
\\wideangledown             <char-0x029A6>               " ⦦          : OBLIQUE ANGLE OPENING UP
\\wideangleup               <char-0x029A7>               " ⦧          : OBLIQUE ANGLE OPENING DOWN
\\widebridgeabove           <char-0x020E9>               " ◌⃩          : COMBINING WIDE BRIDGE ABOVE
\\wideutilde                <char-0x00330>               " ◌̰          : COMBINING TILDE BELOW / NON-SPACING TILDE BELOW
\\wp                        <char-0x02118>               " ℘          : SCRIPT CAPITAL P / SCRIPT P
\\wr                        <char-0x02240>               " ≀          : WREATH PRODUCT
\\xi                        <char-0x003BE>               " ξ          : GREEK SMALL LETTER XI
\\xor                       <char-0x022BB>               " ⊻          : XOR
\\xrat                      <char-0x0211E>               " ℞          : PRESCRIPTION TAKE
\\yen                       <char-0x000A5>               " ¥          : YEN SIGN
\\yogh                      <char-0x00292>               " ʒ          : LATIN SMALL LETTER EZH / LATIN SMALL LETTER YOGH
\\zeta                      <char-0x003B6>               " ζ          : GREEK SMALL LETTER ZETA
" ------------------------- ---------------------------- " ---------- : --------------------------------------------------------------------------------------------------------

" Below here is the script that was used to produce this file.

"> #!/bin/env julia
"> 
"> import REPL
"> 
"> const filename = "latex2unicode_utf-8"
"> const include_emoji = false # set this to true if you want to keymap empjis as well
"> 
"> # We want to avoid situations in which the user types e.g. \delt and pauses,
"> # and the result is "∇t" because "\del" gets recognized and then there is some leftover "t".
"> # This allows us to get completions with <Tab> for example.
"> function fix_completions(completions::Dict{String,String})
">     allinputs = sort!(collect(keys(completions)))
">     new_completions = copy(completions)
"> 
">     for input in allinputs
">         chars = completions[input]
">         l = length(input)
">         longer = filter(x->startswith(x, input)&&length(x)>l, allinputs)
">         n = length(longer)
">         n == 0 && continue
">         new_completions[input * "<Tab>"] = chars
">         for other in longer
">             add = other[1:(l+1)]
">             get!(new_completions, add, add)
">         end
">     end
">     return new_completions
"> end
"> 
"> function unicode_data()
">     file = normpath(Sys.BINDIR, "..", "..", "doc", "UnicodeData.txt")
">     names = Dict{UInt32, String}()
">     open(file) do unidata
">         for line in readlines(unidata)
">             id, name, desc = split(line, ";")[[1, 2, 11]]
">             codepoint = parse(UInt32, "0x$id")
">             names[codepoint] = (name == "" ? desc : desc == "" ? name : "$name / $desc")
">         end
">     end
">     return names
"> end
"> 
"> # Prepend a dotted circle ('◌' i.e. '\u25CC') to combining characters
"> function fix_combining_chars(char)
">     cat = Base.Unicode.category_code(char)
">     return string(cat == 6 || cat == 8 ? "◌" : "", char)
"> end
"> 
"> function table_entries(completions::Dict{String,String}, unicode_dict)
">     latex = String[]
">     code = String[]
">     unicode = String[]
">     desc = String[]
"> 
">     for (input, chars) in sort!(collect(completions))
">         code_points, unicode_names, characters = String[], String[], String[]
">         if startswith(chars, "\\")
">             push!(code_points, replace(chars, "\\" => "\\\\"))
">             push!(unicode_names, "(Incomplete sequence)")
">             push!(characters, "")
">         else
">             for char in chars
">                 push!(code_points, "<char-0x$(uppercase(string(UInt32(char), base = 16, pad = 5)))>")
">                 push!(unicode_names, get(unicode_dict, UInt32(char), "(No Unicode name)"))
">                 push!(characters, isempty(characters) ? fix_combining_chars(char) : "$char")
">             end
">         end
">         push!(latex, replace(input, "\\"=>"\\\\"))
">         push!(code, join(code_points))
">         push!(unicode, join(characters))
">         push!(desc, join(unicode_names, " + "))
">     end
">     return latex, code, unicode, desc
"> end
"> 
"> open("$filename.vim","w") do f
">     print(f, """
">         " This file is autogenerated from the script '$(basename(Base.source_path()))'
">         " The symbols are based on Julia version $VERSION
">         " The full generating script can be found in the comments at the bottom of this file,
">         " and it can be extracted with:
">         "
">         "     \$ grep '^\">' $filename.vim | cut -c4- > '$(basename(Base.source_path()))'
">         "
">         " To produce this keymap file you need to have Julia compilied from source, and
">         " to run `make deps` inside Julia's `doc` directory.
">         " Then you can run:
">         "
">         "     \$ julia $(basename(Base.source_path()))
">         "
"> 
">         scriptencoding utf-8
"> 
">         let b:keymap_name = "L2U"
">         loadkeymap
"> 
">         """)
"> 
">     col_headers = ["\" Tab completion sequence", "Code point", "Character", "Unicode name"]
"> 
">     orig_completions = include_emoji ? merge(
">                 REPL.REPLCompletions.latex_symbols,
">                 REPL.REPLCompletions.emoji_symbols
">                 ) :
">                 REPL.REPLCompletions.latex_symbols
"> 
">     latex, code, unicode, desc =
">         table_entries(
">             fix_completions(orig_completions),
">             unicode_data()
">             )
"> 
">     lw = max(length(col_headers[3]), maximum(map(length, latex)))
">     cw = max(length(col_headers[1]), maximum(map(length, code)))
">     uw = max(length(col_headers[2]), maximum(map(length, unicode)))
">     dw = max(length(col_headers[4]), maximum(map(length, desc)))
"> 
">     print_padded(l, c, u, d) = println(f, rpad(l, lw), " ", rpad(c, cw), " \" ", rpad(u, uw), " : ", d)
"> 
">     print_padded(col_headers...)
">     print_padded("\" " * "-"^(lw-2), "-"^cw, "-"^uw, "-"^dw)
"> 
">     for (l, c, u, d) in zip(latex, code, unicode, desc)
">         print_padded(l, c, u, d)
">     end
">     print_padded("\" " * "-"^(lw-2), "-"^cw, "-"^uw, "-"^dw)
"> 
">     print(f, """
"> 
">         " Below here is the script that was used to produce this file.
"> 
">         """)
">     for l in readlines(Base.source_path())
">         println(f, "\"> ", l)
">     end
">     println(f)
"> end

