package ONVIF::PTZ::Types::RelayOutputSettings;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Mode_of :ATTR(:get<Mode>);
my %DelayTime_of :ATTR(:get<DelayTime>);
my %IdleState_of :ATTR(:get<IdleState>);

__PACKAGE__->_factory(
    [ qw(        Mode
        DelayTime
        IdleState

    ) ],
    {
        'Mode' => \%Mode_of,
        'DelayTime' => \%DelayTime_of,
        'IdleState' => \%IdleState_of,
    },
    {
        'Mode' => 'ONVIF::PTZ::Types::RelayMode',
        'DelayTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::duration',
        'IdleState' => 'ONVIF::PTZ::Types::RelayIdleState',
    },
    {

        'Mode' => 'Mode',
        'DelayTime' => 'DelayTime',
        'IdleState' => 'IdleState',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::RelayOutputSettings

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RelayOutputSettings from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Mode


=item * DelayTime


=item * IdleState




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::RelayOutputSettings
   Mode => $some_value, # RelayMode
   DelayTime =>  $some_value, # duration
   IdleState => $some_value, # RelayIdleState
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

